/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;

public class IDACall
extends BaseServlet {
    protected static final String STACKTRACE_ON_FAILURE = "stacktraceOnFailure";

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._processRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (!encoding.toLowerCase().equals("none")) {
            request.setCharacterEncoding(encoding);
        }
        if (this.log.isDebugEnabled()) {
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                this.log.debug("Header Name:Value pair: " + headerName + ":" + headerValue);
                if (!"authorization".equals(headerName)) continue;
                String encodedValue = headerValue.split(" ")[1];
                String decodedValue = new String(Base64.decodeBase64((byte[])encodedValue.getBytes()));
                this.log.debug("Base64-decoded Authorization Value: " + decodedValue);
            }
            HttpSession ses = request.getSession(false);
            this.log.debug("session exists: " + (ses == null ? "null" : ses.getId()));
            this.log.debug("remote user: " + request.getRemoteUser());
        }
        try {
            this.processRequest(request, response);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RequestContext context = RequestContext.instance((Servlet)this, request, response);
            try {
                RPCManager rpc = new RPCManager((Servlet)this, request, response);
                this.processRPCTransaction(rpc, context);
            }
            catch (ClientMustResubmitException cmre) {
                return;
            }
        }
        catch (Throwable e) {
            this.handleError(response, e);
        }
    }

    public void processRPCTransaction(RPCManager rpc, RequestContext context) throws Exception {
        this.log.info("Performing " + rpc.requestCount() + " operation(s) [UA: " + context.request.getHeader("User-Agent") + "]");
        for (BaseRequest baseRequest : rpc.getRequests()) {
            if (baseRequest instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)baseRequest;
                rpc.send(rpcRequest, this.handleRPCRequest(rpcRequest, rpc, context));
                continue;
            }
            DSRequest dsRequest = (DSRequest)baseRequest;
            rpc.send(dsRequest, this.handleDSRequest(dsRequest, rpc, context));
        }
    }

    public DSResponse handleDSRequest(DSRequest dsRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            DataSource dataSource = dsRequest.getDataSource();
            if (dataSource != null && dataSource.isServerOnly()) {
                this.log.warn("Rejecting attempt to run client DSRequest on DataSource " + dataSource.getName() + " because it is declared serverOnly");
                return new DSResponse(dataSource, -1);
            }
            return dsRequest.execute();
        }
        catch (Throwable t) {
            return this.handleDSRequestError(dsRequest, rpc, context, t);
        }
    }

    public DSResponse handleDSRequestError(DSRequest dsRequest, RPCManager rpc, RequestContext context, Throwable t) {
        return IDACall._handleDSRequestError(dsRequest, rpc, context, t);
    }

    public static DSResponse _handleDSRequestError(DSRequest dsRequest, RPCManager rpc, RequestContext context, Throwable t) {
        boolean trace;
        Throwable t1 = t;
        String errorToString = t1.toString();
        StackTraceElement[] stack = t1.getStackTrace();
        Throwable t2 = t1.fillInStackTrace();
        t1.setStackTrace(stack);
        String exceptionError = null;
        if (errorToString != null && !errorToString.equals("") && t2 != null) {
            RequestContext.staticLog.warn((Object)"dsRequest.execute() failed: ", t1);
        } else {
            t1.setStackTrace(stack);
            RequestContext.staticLog.warn((Object)("dsRequest.execute() failed: " + t1.getClass().getName() + ": " + t1.getMessage() + " (The original exception may be missing information)"), t1);
        }
        DSResponse dsResponse = null;
        try {
            dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        }
        catch (Exception e) {
            RequestContext.staticLog.warn((Object)"Got Exception trying to instantiate error DSResponse - going to try without the DataSource reference", e);
            dsResponse = new DSResponse();
        }
        if (t1 instanceof UpdateWithoutPKException) {
            dsResponse.setStatus(-9);
        } else if (t1 instanceof SecurityException) {
            dsResponse.setStatus(-3);
        } else if (dsRequest != null && "downloadFile".equals(dsRequest.getOperationType())) {
            exceptionError = t1.getMessage();
            HashMap<String, Object> data = new HashMap<String, Object>();
            Map criteria = dsRequest.getCriteria();
            String binaryField = (String)criteria.get("download_fieldname");
            data.put(binaryField, exceptionError.getBytes());
            data.put(binaryField + "_filename", "errors.txt");
            data.put(binaryField + "_filesize", exceptionError.length());
            data.put(binaryField + "_date_created", new Date());
            dsResponse.setData(data);
            dsResponse.setStatus(0);
            dsRequest.copyExportSettingsToResponse(dsResponse);
        } else {
            dsResponse.setStatus(-1);
        }
        if (exceptionError == null) {
            dsResponse.setData(t1.getLocalizedMessage());
        }
        if (t instanceof NoClassDefFoundError && t.getMessage().indexOf("org/hibernate") != -1) {
            dsResponse.setData("Hibernate .jars do not appear to be installed. Please see the Setup Guide and Deployment Instructions");
        }
        if (trace = IDACall.shouldReturnStacktrace(context)) {
            dsResponse.setParameter("stacktrace", DataTools.getStackTrace(t1));
        }
        return dsResponse;
    }

    public RPCResponse handleRPCRequest(RPCRequest rpcRequest, RPCManager rpc, RequestContext context) throws Exception {
        try {
            return rpcRequest.execute();
        }
        catch (Throwable t) {
            return this.handleRPCRequestError(rpcRequest, rpc, context, t);
        }
    }

    public RPCResponse handleRPCRequestError(RPCRequest rpcRequest, RPCManager rpc, RequestContext context, Throwable t) {
        return IDACall._handleRPCRequestError(rpcRequest, rpc, context, t);
    }

    public static RPCResponse _handleRPCRequestError(RPCRequest rpcRequest, RPCManager rpc, RequestContext context, Throwable t) {
        RequestContext.staticLog.warn((Object)"rpcRequest.execute() failed: ", t);
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setStatus(-1);
        rpcResponse.setData(t.getLocalizedMessage());
        if (IDACall.shouldReturnStacktrace(context)) {
            rpcResponse.setStacktrace(DataTools.getStackTrace(t));
        }
        return rpcResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean shouldReturnStacktrace(RequestContext context) {
        boolean trace = false;
        try {
            Map<String, String> queryParamsMap = ServletTools.parseQueryString(context.request.getQueryString());
            Boolean urlTrace = DataTools.asBooleanObject(queryParamsMap.get(STACKTRACE_ON_FAILURE));
            if (urlTrace == null) {
                urlTrace = DataTools.asBooleanObject(context.request.getParameter(STACKTRACE_ON_FAILURE));
            }
            if (config.getBoolean((Object)"allow.return.stacktrace", false)) {
                trace = urlTrace != null ? urlTrace.booleanValue() : config.getBoolean((Object)"exception.returns.stacktrace", false);
            }
            boolean bl = trace;
            return bl;
        }
        catch (Exception e) {
            RequestContext.staticLog.warn((Object)"Exception when trying to determine whether to return a stacktrace", e);
        }
        finally {
            return trace;
        }
    }
}

