/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.spring;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.ISpringBeanFactory;
import com.isomorphic.io.ISCFile;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringBeanFactory
implements ISpringBeanFactory {
    protected static ApplicationContext ac;

    public Object getBeanFactory(ServletContext servletContext) throws Exception {
        if (servletContext != null) {
            return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        }
        if (ac == null) {
            Config config = Config.getGlobal();
            List locationList = config.getCommaSeparatedList((Object)"standalone.spring.applicationContext");
            String[] locations = new String[locationList.size()];
            for (int i = 0; i < locationList.size(); ++i) {
                String path;
                String string = path = locationList.get(i) == null ? null : locationList.get(i).toString();
                if (path != null) {
                    path = ISCFile.canonicalizePath((String)path);
                }
                locations[i] = "file://" + path;
            }
            ac = new FileSystemXmlApplicationContext(locations);
        }
        return ac;
    }

    public Object getBean(ServletContext servletContext, String bean) throws Exception {
        return ((BeanFactory)this.getBeanFactory(servletContext)).getBean(bean);
    }
}

