openapi: "${oasVersion}"
${infoFragment}
${serversFragment}
${tagsFragment}

components: 
  schemas:
    RequestBodyModel:
      type: object
      properties:
        dataSource:
          type: string
          description: DataSource this DSRequest will act on.
        operationType:
          type: string
          description: |
            Type of operation being performed: 'fetch', 'add', 'remove', 'update' or 'custom'.
          enum: [fetch, add, update, remove, custom]
        operationId:
          type: string
          description: |
            Optional operationId if the given DataSource supports two or more variants of one of the basic DataSource operations, for instance, a "fetch" that uses full text search and a "fetch" that accepts per-field search criteria.
        startRow:
          type: integer
          description: |
            Starting row of requested results, used only with fetch operations. If unset, 0 is assumed.  Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.  
        endRow:
          type: integer
          description: |  
            End row of requested results, used only with fetch operations. Note that startRow and endRow are zero-based, inclusive at the beginning and exclusive at the end (like substring), so startRow=0&endRow=1 is a request for the first record.
        data:
          type: object
          description: |  
            Data, such as search criteria or an updated record, to be used by the given operation. Contents differ by operationType:
              - **fetch**: Filter criteria, as an Object
              - **add**: New record, as an Object
              - **update**: Primary keys of record to update, and new values (or just complete updated record), as an Object
              - **remove**: Primary keys of record to delete, as an Object
              - **custom**: Whatever the custom operation requires
          
    ResponseBodyModel:
      type: object
      properties: 
        response:
          type: object
          properties:
            affectedRows:
              type: integer
            status:
              type: integer
            queueStatus:
              type: integer
            startRow:
              type: integer
            endRow: 
              type: integer
            totalRows:
              type: integer
            data:
              nullable: true
              type: array
              items:
                type: object
paths: 
  /:
    post:
      tags:
        - POSTCommand
      summary: CRUD Operations
      description: Post any operation to any datasource by specifiying each in the payload.  Useful, for example, when AdvancedCriteria are required in search parameters.  
        
      <#-- TODO add a bunch of doc here about the differences between this & raw rest (e.g., defaultFormat).  Also doc the differences in request, response formats, and so on-->
      <#-- TODO Some problem with xml metadata?  shouldn't the xml version also be returning affectedRows?  I'm not seeing it here.  Also, what's with the startRow, endRow -1 etc.? 
        From RestDataSource javadoc:  "JSON format responses are expected to contain the same data / meta-data as XMLresponses, encapsulated in a simple object with a "response" attribute."
      -->
      parameters:
        - ${dynamicDataFormatParamName}: 
          name: ${dynamicDataFormatParamName}
          <#-- TODO verify this is documented behavior, and not just observed.  Also note default values are different per operation -->
          description: This governs whether the server expects request bodies to be encoded as XML or JSON, and further influences which format is returned.
          in: query
          schema:
            type: string
            default: ${defaultDataFormat}
            enum:
              - json
              - xml
      requestBody:
        content:
          'application/json':
            schema:
              $ref: "#/components/schemas/RequestBodyModel"  
            examples:
              fetch: 
                summary: Fetch Employees w/ Advanced Criteria
                value: {
                  "dataSource": "Employees",
                  "operationType": "fetch",
                  "startRow": 0,
                  "endRow": 75,
                  "data": {
                    "_constructor": "AdvancedCriteria",
                    "operator": "or",
                    "criteria": {
                      "criterion": [
                        {
                          "fieldName": "REPORTS_TO_TITLE",
                          "operator": "isNull"
                        },
                        {                        
                          "fieldName": "REPORTS_TO_TITLE",
                          "operator": "equals",
                          "value": "President"
                        },
                        {
                          "operator": "and",
                          "criteria": {
                            "criterion": [
                              {                        
                                "fieldName": "REPORTS_TO_TITLE",
                                "operator": "equals",
                                "value": "VP Sales"
                              },
                              {
                                "fieldName": "JOB_TITLE",
                                "operator": "notEqual",
                                "value": "Sales Rep"
                              }
                            ]
                          }
                        }
                      ]
                    }
                  }
                }
              queued:
                summary: Queued Transactions
                value: {
                  "transaction": {
                    "operations": [
                      {
                        "dataSource": "Customers",
                        "operationType": "add",
                        "data": { 
                          "CUSTOMER_NAME": "Isomorphic Software",
                          "CONTACT_FIRST_NAME": "SmartClient",
                          "CONTACT_LAST_NAME": "Developer",
                          "ADDRESS_LINE1": "1 Sansome Street",
                          "ADDRESS_LINE2": "Suite 3500",
                          "CITY": "San Francisco",
                          "STATE": "CA",
                          "POSTAL_CODE": "94104",
                          "COUNTRY": "USA",
                          "PHONE": "866-223-4569"
                        }
                      },
                      {
                        "dataSource": "Customers",
                        "operationType": "add",
                        "data": { 
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "STATE": "AZ",
                          "POSTAL_CODE": "85718",
                          "COUNTRY": "USA",
                          "PHONE": "555-765-4321"
                        }
                      }
                    ]
                  }
                }
              add: 
                summary: Add Customer
                value: {
                  "dataSource": "Customers",
                  "operationType": "add",
                  "data": { 
                    "CUSTOMER_NAME": "ACME Corporation",
                    "CONTACT_FIRST_NAME": "SmartGWT",
                    "CONTACT_LAST_NAME": "Developer",
                    "ADDRESS_LINE1": "7575 East Border St.",
                    "CITY": "Tucson",
                    "STATE": "AZ",
                    "POSTAL_CODE": "85718",
                    "COUNTRY": "USA",
                    "PHONE": "555-765-4321"
                  }
                }
              update:
                summary: Update Customer
                value: {
                  "dataSource": "Customers",
                  "operationType": "update",
                  "data": {
                    "CUSTOMER_NUMBER": 1003, 
                    "CREDIT_LIMIT": 5000.01 
                  }
                }
              remove:
                summary: Remove Customer
                value: {
                  "dataSource": "Customers",
                  "operationType": "remove",
                  "data": {
                    "CUSTOMER_NUMBER": 1003 
                  }
                }
          'application/xml':
            schema:
              $ref: "#/components/schemas/RequestBodyModel"  
            examples:
              fetch:
                summary: Fetch Employees w/ Advanced Criteria
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Employees</dataSource>
                    <operationType>fetch</operationType>
                    <startRow>0</startRow>
                    <endRow>75</endRow>
                    <data>
                      <_constructor>AdvancedCriteria</_constructor>
                      <operator>or</operator>
                      <criteria>
                        <criterion>
                          <fieldName>REPORTS_TO_TITLE</fieldName>
                          <operator>isNull</operator>
                        </criterion>
                        <criterion>
                          <fieldName>REPORTS_TO_TITLE</fieldName>
                          <operator>equals</operator>
                          <value>President</value>
                        </criterion>
                        <criterion>
                          <operator>and</operator>
                          <criteria>
                            <criterion>
                              <fieldName>REPORTS_TO_TITLE</fieldName>
                              <operator>equals</operator>
                              <value>VP Sales</value>
                            </criterion>
                            <criterion>
                              <fieldName>JOB_TITLE</fieldName>
                              <operator>notEqual</operator>
                              <value>Sales Rep</value>
                            </criterion>
                          </criteria>
                        </criterion>
                      </criteria>
                    </data>
                  </request>
              queued:
                summary: Queued Transactions
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <transaction>
                    <operations>
                      <request>
                        <dataSource>Customers</dataSource>
                        <operationType>add</operationType>
                        <data>
                          <CUSTOMER_NAME>Isomorphic Software</CUSTOMER_NAME>
                          <CONTACT_FIRST_NAME>SmartClient</CONTACT_FIRST_NAME>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <ADDRESS_LINE1>1 Sansome Street</ADDRESS_LINE1>
                          <ADDRESS_LINE2>Suite 3500</ADDRESS_LINE2>
                          <CITY>San Francisco</CITY>
                          <STATE>CA</STATE>
                          <POSTAL_CODE>94104</POSTAL_CODE>
                          <COUNTRY>USA</COUNTRY>
                          <PHONE>866-223-4569</PHONE>
                        </data>
                      </request>
                      <request>
                        <dataSource>Customers</dataSource>
                        <operationType>add</operationType>
                        <data>
                          <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                          <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                          <CITY>Tucson</CITY>
                          <STATE>AZ</STATE>
                          <POSTAL_CODE>85718</POSTAL_CODE>
                          <COUNTRY>USA</COUNTRY>
                          <PHONE>555-765-4321</PHONE>
                        </data>
                      </request>
                    </operations>
                  </transaction>
              add: 
                summary: Add Customer
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>add</operationType>
                    <data>
                      <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                      <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                      <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                      <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                      <CITY>Tucson</CITY>
                      <STATE>AZ</STATE>
                      <POSTAL_CODE>85718</POSTAL_CODE>
                      <COUNTRY>USA</COUNTRY>
                      <PHONE>555-765-4321</PHONE>
                    </data>
                  </request>
              update:
                summary: Update Customer
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>update</operationType>
                    <data>
                      <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                      <CREDIT_LIMIT>5000.01</CREDIT_LIMIT>
                    </data>
                  </request>
              remove:
                summary: Remove Customer
                value: |
                  <?xml version="1.0" encoding="UTF-8" ?>
                  <request>
                    <dataSource>Customers</dataSource>
                    <operationType>remove</operationType>
                    <data>
                      <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                    </data>
                  </request>
      responses:
        '200':
          description: |
          <#if wrapJSONResponses>
            Note that JSON responses are by default wrapped with a prefix/suffix pair as shown below, but these strings may be overridden at the DataSource level.  Refer to each operation's response documentation individually to deterine whether that is the case (as noted by the spec extension x-jsonWrapper element).  
            ```
              ${jsonPrefix}
              {
                "response": {
                  "affectedRows": 1,
                  "data": [
                    {
                      "CUSTOMER_NUMBER": 1003
                    }
                  ],
                  "operationType": "remove",
                  "queueStatus": 0,
                  "status": 0
                }
              }
              ${jsonSuffix} 
            ```
          </#if>
          content:
            'application/json':
            <#if wrapJSONResponses>
              x-jsonWrapper:
                prefix: ${jsonPrefix}
                suffix: ${jsonSuffix}
            </#if> 
              schema:
                $ref: "#/components/schemas/ResponseBodyModel"
              examples:
                fetch: 
                  summary: Fetch Employees w/ Advanced Criteria
                  value: {
                    "response": {
                      "affectedRows": 0,
                      "data": [
                        {
                          "EMAIL": "dmurphy@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1002,
                          "EXTENSION": "x5800",
                          "FIRST_NAME": "Diane",
                          "FORMATTED_NAME": "Murphy, Diane",
                          "JOB_TITLE": "President",
                          "LAST_NAME": "Murphy",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO_NAME": "Murphy, Diane",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "mpatterso@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1056,
                          "EXTENSION": "x4611",
                          "FIRST_NAME": "Mary",
                          "FORMATTED_NAME": "Patterson, Mary",
                          "JOB_TITLE": "VP Sales",
                          "LAST_NAME": "Patterson",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1002,
                          "REPORTS_TO_NAME": "Patterson, Mary",
                          "REPORTS_TO_TITLE": "President",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "jfirrelli@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1076,
                          "EXTENSION": "x9273",
                          "FIRST_NAME": "Jeff",
                          "FORMATTED_NAME": "Firrelli, Jeff",
                          "JOB_TITLE": "VP Marketing",
                          "LAST_NAME": "Firrelli",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1002,
                          "REPORTS_TO_NAME": "Firrelli, Jeff",
                          "REPORTS_TO_TITLE": "President",
                          "TERRITORY": "NA"
                        },
                        {
                          "EMAIL": "wpatterson@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1088,
                          "EXTENSION": "x4871",
                          "FIRST_NAME": "William",
                          "FORMATTED_NAME": "Patterson, William",
                          "JOB_TITLE": "Sales Manager (APAC)",
                          "LAST_NAME": "Patterson",
                          "OFFICE_CODE": "6",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Patterson, William",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "APAC"
                        },
                        {
                          "EMAIL": "gbondur@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1102,
                          "EXTENSION": "x5408",
                          "FIRST_NAME": "Gerard",
                          "FORMATTED_NAME": "Bondur, Gerard",
                          "JOB_TITLE": "Sale Manager (EMEA)",
                          "LAST_NAME": "Bondur",
                          "OFFICE_CODE": "4",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Bondur, Gerard",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "EMEA"
                        },
                        {
                          "EMAIL": "abow@classicmodelcars.com",
                          "EMPLOYEE_NUMBER": 1143,
                          "EXTENSION": "x5428",
                          "FIRST_NAME": "Anthony",
                          "FORMATTED_NAME": "Bow, Anthony",
                          "JOB_TITLE": "Sales Manager (NA)",
                          "LAST_NAME": "Bow",
                          "OFFICE_CODE": "1",
                          "REPORTS_TO": 1056,
                          "REPORTS_TO_NAME": "Bow, Anthony",
                          "REPORTS_TO_TITLE": "VP Sales",
                          "TERRITORY": "NA"
                        }
                      ],
                      "endRow": 6,
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "fetch",
                      "queueStatus": 0,
                      "startRow": 0,
                      "status": 0,
                      "totalRows": 6
                    }
                  }
                queued:
                  summary: Queued Transactions
                  value: [
                    {
                      "response": {
                        "affectedRows": 1,
                        "data": [
                          {
                              "ADDRESS_LINE1": "1 Sansome Street",
                              "ADDRESS_LINE2": "Suite 3500",
                              "CITY": "San Francisco",
                              "CONTACT_FIRST_NAME": "SmartClient",
                              "CONTACT_LAST_NAME": "Developer",
                              "COUNTRY": "USA",
                              "CUSTOMER_NAME": "Isomorphic Software",
                              "CUSTOMER_NUMBER": 1001,
                              "PHONE": "866-223-4569",
                              "POSTAL_CODE": "94104",
                              "STATE": "CA"
                          }
                        ],
                        "invalidateCache": false,
                        "isDSResponse": true,
                        "operationType": "add",
                        "queueStatus": 0,
                        "status": 0
                      }
                    },
                    {
                      "response": {
                        "affectedRows": 1,
                        "data": [
                          {
                            "ADDRESS_LINE1": "7575 East Border St.",
                            "CITY": "Tucson",
                            "CONTACT_FIRST_NAME": "SmartGWT",
                            "CONTACT_LAST_NAME": "Developer",
                            "COUNTRY": "USA",
                            "CUSTOMER_NAME": "ACME Corporation",
                            "CUSTOMER_NUMBER": 1002,
                            "PHONE": "555-765-4321",
                            "POSTAL_CODE": "85718",
                            "STATE": "AZ"
                          }
                        ],
                        "invalidateCache": false,
                        "isDSResponse": true,
                        "operationType": "add",
                        "queueStatus": 0,
                        "status": 0
                      }
                    }
                  ]  
                add:
                  summary: Add Customer
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "COUNTRY": "USA",
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CUSTOMER_NUMBER": 1003,
                          "PHONE": "555-765-4321",
                          "POSTAL_CODE": "85718",
                          "STATE": "AZ"
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "add",
                      "queueStatus": 0,
                      "status": 0
                    }
                  }
                update:
                  summary: Update Customer
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "ADDRESS_LINE1": "7575 East Border St.",
                          "CITY": "Tucson",
                          "CONTACT_FIRST_NAME": "SmartGWT",
                          "CONTACT_LAST_NAME": "Developer",
                          "COUNTRY": "USA",
                          "CREDIT_LIMIT": 5000.01,
                          "CUSTOMER_NAME": "ACME Corporation",
                          "CUSTOMER_NUMBER": 1015,
                          "PHONE": "555-765-4321",
                          "POSTAL_CODE": "85718",
                          "STATE": "AZ"
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "update",
                      "queueStatus": 0,
                      "status": 0
                    }
                  }
                remove:
                  summary: Remove Customer
                  value: {
                    "response": {
                      "affectedRows": 1,
                      "data": [
                        {
                          "CUSTOMER_NUMBER": 1003
                        }
                      ],
                      "invalidateCache": false,
                      "isDSResponse": true,
                      "operationType": "remove",
                      "queueStatus": 0,
                      "status": 0
                    }
                  } 
            'application/xml': 
              schema:
                $ref: "#/components/schemas/ResponseBodyModel"
              examples:
                fetch:
                  summary: Fetch Employees w/ Advanced Criteria
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>0</startRow>
                      <endRow>6</endRow>
                      <totalRows>6</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <FORMATTED_NAME>Murphy, Diane</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1002</EMPLOYEE_NUMBER>
                          <JOB_TITLE>President</JOB_TITLE>
                          <REPORTS_TO_NAME>Murphy, Diane</REPORTS_TO_NAME>
                          <EXTENSION>x5800</EXTENSION>
                          <LAST_NAME>Murphy</LAST_NAME>
                          <EMAIL>dmurphy@classicmodelcars.com</EMAIL>
                          <FIRST_NAME>Diane</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Patterson, Mary</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1056</EMPLOYEE_NUMBER>
                          <JOB_TITLE>VP Sales</JOB_TITLE>
                          <REPORTS_TO_NAME>Patterson, Mary</REPORTS_TO_NAME>
                          <EXTENSION>x4611</EXTENSION>
                          <REPORTS_TO_TITLE>President</REPORTS_TO_TITLE>
                          <LAST_NAME>Patterson</LAST_NAME>
                          <EMAIL>mpatterso@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1002</REPORTS_TO>
                          <FIRST_NAME>Mary</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Firrelli, Jeff</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1076</EMPLOYEE_NUMBER>
                          <JOB_TITLE>VP Marketing</JOB_TITLE>
                          <REPORTS_TO_NAME>Firrelli, Jeff</REPORTS_TO_NAME>
                          <EXTENSION>x9273</EXTENSION>
                          <REPORTS_TO_TITLE>President</REPORTS_TO_TITLE>
                          <LAST_NAME>Firrelli</LAST_NAME>
                          <EMAIL>jfirrelli@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1002</REPORTS_TO>
                          <FIRST_NAME>Jeff</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Patterson, William</FORMATTED_NAME>
                          <TERRITORY>APAC</TERRITORY>
                          <EMPLOYEE_NUMBER>1088</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sales Manager (APAC)</JOB_TITLE>
                          <REPORTS_TO_NAME>Patterson, William</REPORTS_TO_NAME>
                          <EXTENSION>x4871</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Patterson</LAST_NAME>
                          <EMAIL>wpatterson@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>William</FIRST_NAME>
                          <OFFICE_CODE>6</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Bondur, Gerard</FORMATTED_NAME>
                          <TERRITORY>EMEA</TERRITORY>
                          <EMPLOYEE_NUMBER>1102</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sale Manager (EMEA)</JOB_TITLE>
                          <REPORTS_TO_NAME>Bondur, Gerard</REPORTS_TO_NAME>
                          <EXTENSION>x5408</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Bondur</LAST_NAME>
                          <EMAIL>gbondur@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>Gerard</FIRST_NAME>
                          <OFFICE_CODE>4</OFFICE_CODE>
                        </record>
                        <record>
                          <FORMATTED_NAME>Bow, Anthony</FORMATTED_NAME>
                          <TERRITORY>NA</TERRITORY>
                          <EMPLOYEE_NUMBER>1143</EMPLOYEE_NUMBER>
                          <JOB_TITLE>Sales Manager (NA)</JOB_TITLE>
                          <REPORTS_TO_NAME>Bow, Anthony</REPORTS_TO_NAME>
                          <EXTENSION>x5428</EXTENSION>
                          <REPORTS_TO_TITLE>VP Sales</REPORTS_TO_TITLE>
                          <LAST_NAME>Bow</LAST_NAME>
                          <EMAIL>abow@classicmodelcars.com</EMAIL>
                          <REPORTS_TO>1056</REPORTS_TO>
                          <FIRST_NAME>Anthony</FIRST_NAME>
                          <OFFICE_CODE>1</OFFICE_CODE>
                        </record>
                      </data>
                    </response>
                queued:
                  summary: Queued Transactions
                  value: |
                    <?xml version="1.0"?>
                    <responses>
                      <response>
                        <status>0</status>
                        <queueStatus>0</queueStatus>
                        <startRow>-1</startRow>
                        <endRow>-1</endRow>
                        <totalRows>-1</totalRows>
                        <queueStatus>0</queueStatus>
                        <data>
                          <record>
                            <ADDRESS_LINE1>1 Sansome Street</ADDRESS_LINE1>
                            <ADDRESS_LINE2>Suite 3500</ADDRESS_LINE2>
                            <CUSTOMER_NUMBER>1001</CUSTOMER_NUMBER>
                            <CUSTOMER_NAME>Isomorphic Software</CUSTOMER_NAME>
                            <CITY>San Francisco</CITY>
                            <COUNTRY>USA</COUNTRY>
                            <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                            <POSTAL_CODE>94104</POSTAL_CODE>
                            <PHONE>866-223-4569</PHONE>
                            <STATE>CA</STATE>
                            <CONTACT_FIRST_NAME>SmartClient</CONTACT_FIRST_NAME>
                          </record>
                        </data>
                      </response>
                      <response>
                        <status>0</status>
                        <queueStatus>0</queueStatus>
                        <startRow>-1</startRow>
                        <endRow>-1</endRow>
                        <totalRows>-1</totalRows>
                        <queueStatus>0</queueStatus>
                        <data>
                          <record>
                            <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                            <CUSTOMER_NUMBER>1002</CUSTOMER_NUMBER>
                            <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                            <CITY>Tucson</CITY>
                            <COUNTRY>USA</COUNTRY>
                            <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                            <POSTAL_CODE>85718</POSTAL_CODE>
                            <PHONE>555-765-4321</PHONE>
                            <STATE>AZ</STATE>
                            <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                          </record>
                        </data>
                      </response>
                    </responses>
                add: 
                  summary: Add Customer
                  value: |
                      <?xml version="1.0"?>
                      <response>
                        <status>0</status>
                        <queueStatus>0</queueStatus>
                        <startRow>-1</startRow>
                        <endRow>-1</endRow>
                        <totalRows>-1</totalRows>
                        <queueStatus>0</queueStatus>
                        <data>
                          <record>
                            <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                            <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                            <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                            <CITY>Tucson</CITY>
                            <COUNTRY>USA</COUNTRY>
                            <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                            <POSTAL_CODE>85718</POSTAL_CODE>
                            <PHONE>555-765-4321</PHONE>
                            <STATE>AZ</STATE>
                            <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                          </record>
                        </data>
                      </response>
                update:
                  summary: Update Customer
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>-1</startRow>
                      <endRow>-1</endRow>
                      <totalRows>-1</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <ADDRESS_LINE1>7575 East Border St.</ADDRESS_LINE1>
                          <CREDIT_LIMIT>5000.01</CREDIT_LIMIT>
                          <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                          <CUSTOMER_NAME>ACME Corporation</CUSTOMER_NAME>
                          <CITY>Tucson</CITY>
                          <COUNTRY>USA</COUNTRY>
                          <CONTACT_LAST_NAME>Developer</CONTACT_LAST_NAME>
                          <POSTAL_CODE>85718</POSTAL_CODE>
                          <PHONE>555-765-4321</PHONE>
                          <STATE>AZ</STATE>
                          <CONTACT_FIRST_NAME>SmartGWT</CONTACT_FIRST_NAME>
                        </record>
                      </data>
                    </response>
                remove:
                  summary: Remove Customer
                  value: |
                    <?xml version="1.0"?>
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                      <startRow>-1</startRow>
                      <endRow>-1</endRow>
                      <totalRows>-1</totalRows>
                      <queueStatus>0</queueStatus>
                      <data>
                        <record>
                          <CUSTOMER_NUMBER>1003</CUSTOMER_NUMBER>
                        </record>
                      </data>
                    </response>
                
        default:
          $ref: "isomorphic.yaml#/components/responses/ErrorResponse"
      
<#list dataSources as ds>
  <#if ds.defaultOperations?size != 0>
  /${ds.id}:
    $ref: ${ds.id}.yaml#/paths/~1${ds.id}
  </#if>  
  <#if ds.pathSupportsPrimaryKeySegment>  
  /${ds.id}/{${ds.primaryKey}}:
    $ref: ${ds.id}.yaml#/paths/~1${ds.id}~1%7B${ds.primaryKey}%7D
  </#if>  
  <#if ds.namedOperations?has_content>
    <#list ds.namedOperations as op>
  /${ds.id}/${op.operationType}/${op.operationId}:
    $ref: ${ds.id}.yaml#/paths/~1${ds.id}~1${op.operationType}~1${op.operationId}
    </#list>
  </#if>
  
</#list>