/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.log.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jDataSourceAppender
extends AppenderSkeleton {
    public static LinkedBlockingQueue dispatchQueue = new LinkedBlockingQueue();
    public static boolean requiresDataSourceDispatcher = false;
    boolean reentrant = false;

    public void setName(String name) {
        this.name = name;
        requiresDataSourceDispatcher = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(LoggingEvent event) {
        if (this.reentrant) {
            return;
        }
        if (Logger.threadIgnored() || Logger.threadDisabled()) {
            return;
        }
        this.reentrant = true;
        try {
            Map mdc = Logger.getMDC();
            if (mdc != null) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("event", event);
                m.put("mdc", mdc);
                dispatchQueue.add(m);
            } else {
                dispatchQueue.add(event);
            }
        }
        finally {
            this.reentrant = false;
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void close() {
    }
}

