openapi: "${oasVersion}"
${infoFragment}
${serversFragment}

paths:
<#if defaultOperations?size != 0>  
  /${id}:
  <#if defaultOperations.fetch??>
  <#assign op = defaultOperations.fetch>
    get:
      summary: Fetch ${id} (simple)
      description: Performs a fetch against the '${id}' datasource, with any query params interpreted as simple search criteria.
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      <#list op.parameters as field>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=op />
          in: query
          schema:
            <@fielddef indentation=12 field=field />
      </#list>
      responses:
        200:
          <@responsedef operation=op />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
  </#if>
  <#if defaultOperations.add??>
    <#assign op = defaultOperations.add>
    post:
      summary: Add ${id}
      description: Adds the given '${id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however. 
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
      <#list op.parameters as field>
      <#if field.format?? && field.format == 'sequence'>
        <#continue />
      </#if>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=op />
          in: query
          schema: 
            <@fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@requestbodydef operation=op />
      responses:
        201: 
          <@responsedef operation=op format="record" />
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default" 
  </#if>
  <#if defaultOperations.update??>
  <#assign op = defaultOperations.update>
    <#if op.allowMultiUpdate??>  
    patch:
      summary: Update ${id}
      description: Updates the given '${id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.  Note that in the absence of any primary key values (${primaryKeyFieldNames}) this operation will update multiple records, if allowed.    
    <#else>
    put:
      summary: Update ${id}
      description: Updates the given '${id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.  Note that in the absence of any primary key values (${primaryKeyFieldNames}) this operation will behave just like the POST method, resulting in an added record.
    </#if>
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
      <#list op.parameters as field>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=op />
          in: query
          schema: 
            <@fielddef indentation=12 field=field />
      </#list>
      requestBody:
        <@requestbodydef operation=op />  
      responses:
        200:
          <@responsedef operation=op format="any" />
      <#if !op.allowMultiUpdate??>  
        201:
          <@responsedef operation=op format="any" />  
      </#if>
        204:
          $ref: "#/components/responses/204"
        default:
          $ref: "#/components/responses/default"
  </#if>
  <#if defaultOperations.remove??>
  <#assign op = defaultOperations.remove>
    delete:
      summary: Remove ${id}
      description: Removes the given '${id}' record, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
      <#list op.parameters as field>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=op />
          in: query
          schema: 
            <@fielddef indentation=12 field=field />
      </#list>            
      responses:
        200:
          <@responsedef operation=op />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
  </#if>
</#if>    
<#if pathSupportsPrimaryKeySegment>  
  /${id}/{${primaryKeys?first.name}}: 
  <#if defaultOperations.fetch??>
  <#assign op = defaultOperations.fetch>
    get:
      summary: Fetch ${id} by key
      description: Performs a fetch against the '${id}' datasource, using the path parameter value as simple search criteria.
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
        - $ref: "#/components/parameters/textMatchStyle"
        - $ref: "#/components/parameters/pathToKey"
      responses:
        200:
          <@responsedef operation=op format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
  </#if>
  
  <#if defaultOperations.update??>
  <#assign op = defaultOperations.update>
    put:
      summary: Update ${id} by key
      description: Update ${id} by key, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
        - $ref: "#/components/parameters/pathToKey"
      <#list op.parameters as field>
        <#if field.primaryKey??>
          <#continue />
        </#if>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=op />
          in: query
          schema: 
            <@fielddef indentation=12 field=field />
      </#list>  
      requestBody:
        <@requestbodydef operation=op pathIncludesKey=true/>
      responses:
        200:
          <@responsedef operation=op format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
  </#if>

  <#if defaultOperations.remove??>
  <#assign op = defaultOperations.remove>
    delete:
      summary: Remove ${id} by key
      description: Remove ${id} by key, with request body values overriding / augmenting their corresponding query parameter values (where applicable).  Typical usage provides the value in either one place or the other, however.
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/pathToKey"
      responses:
        200:
          <@responsedef operation=op format="record" />
        404:
          $ref: "#/components/responses/404"
        default:
          $ref: "#/components/responses/default"
  </#if>
</#if>

<#if namedOperations?has_content>
<#list namedOperations as named>
  <#assign method = named.httpMethod>
  /${id}/${named.operationType}/${named.operationId}:
    ${method}:
      summary: ${id}.${named.operationId}
      <#if named.operationType == 'custom'>
      description: |
        _Custom operations may use zero, one, or many of the optional parameters, and do not necessarily even adhere to documented request and response rules.  If appropriate, contact support for more accurate documentation._
      </#if>
      tags:
        - ${id}
      parameters:
        - $ref: "#/components/parameters/hybridMode"
        - $ref: "#/components/parameters/${dynamicDataFormatParamName}"
      <#if named.operationType == 'fetch' || named.operationType == 'custom'>
        - $ref: "#/components/parameters/sortBy"
        - $ref: "#/components/parameters/startRow"
        - $ref: "#/components/parameters/endRow"
        - $ref: "#/components/parameters/textMatchStyle"
      </#if>
    <#list named.parameters as field>
        - name: ${field.name}
          <@describe indentation=10 field=field operation=named />
          in: query
          schema: 
            <@fielddef indentation=12 field=field />
      </#list>
      <#if named.operationType != 'fetch' && named.operationType != 'remove'>
      requestBody:
        <@requestbodydef operation=named />
      </#if>                  
      responses:
        '200':
          <@responsedef operation=named />
        default:
           $ref: "#/components/responses/default"
      
</#list>
</#if>      

components:
  parameters:
    hybridMode:
      name: hybridMode
      description: Hybrid mode allows you to send HTTP requests as usual, but receive the responses in SmartClient DSResponse format.  See any example having the DSResponse label.
      in: query
      schema:
        type: boolean
        default: ${hybridMode?c}
    ${dynamicDataFormatParamName}: 
      name: ${dynamicDataFormatParamName}
      description: This governs whether the server expects request bodies to be encoded as XML or JSON, and further influences which format is returned.
      in: query
      schema:
        type: string
        default: ${defaultDataFormat}
        enum:
          - json
          - xml
    sortBy:
      $ref: "isomorphic.yaml#/components/parameters/sortBy"
    startRow:
      $ref: "isomorphic.yaml#/components/parameters/startRow"
    endRow:
      $ref: "isomorphic.yaml#/components/parameters/endRow"
    textMatchStyle:
      name: textMatchStyle
      description: | 
        For "fetch" operations, how search criteria should be interpreted for text fields:
        
           - **exact**: for exact match
           - **exactCase**: for case-sensitive exact match
           - **startsWith**: for matching at the beginning only
           - **substring**: for substring match. 
           
        All textMatchStyle settings except "exactCase" are case-insensitive; use AdvancedCriteria for greater control over matching.
      in: query
      schema:
        type: string
        enum:
          - exact
          - exactCase
          - substring
          - startsWith
        default: ${defaultTextMatchStyle}
  <#if pathSupportsPrimaryKeySegment>
    pathToKey:
      name: ${primaryKeys?first.name}
      in: path
      required: true
      schema:
        type: string      
  </#if>
  responses:
    204:
      $ref: "isomorphic.yaml#/components/responses/204"
    404:
      description: "Not Found."
    default:
      $ref:  "isomorphic.yaml#/components/responses/ErrorResponse" 
  
  schemas:
    ${id}:
      title: ${id} Record
      type: object
      xml:
        name: record
      properties:
      <#list fields as field>      
        ${field.name}:
          <@fielddef indentation=10 field=field />
      </#list>

<#macro requestbodydef operation pathIncludesKey=false>
        content: 
          application/json:
            schema:
              type: object
              properties:
            <#list operation.parameters as field>
              <#if pathIncludesKey && field.primaryKey??>
                <#-- <#continue /> -->
              </#if>
                ${field.name}:
                  <@describe indentation=18 field=field operation=operation/>
                  <@fielddef indentation=18 field=field />
              </#list>
            example:
              {
              <#list operation.parameters as field>
                <#if pathIncludesKey && field.primaryKey??>
                  <#-- <#continue /> -->
                </#if>
                ${field.name}: ${field.sample}<#sep>,</#sep>
              </#list>
              }    
          application/xml:
            schema:
              type: object
              xml:
                name: request
              required: 
                - data
              properties:
                data:
                  type: object
                  properties:
            <#list operation.parameters as field>
              <#if pathIncludesKey && field.primaryKey??>
                <#-- <#continue /> -->
              </#if>      
                    ${field.name}:
                      <@describe indentation=22 field=field operation=operation/>
                      <@fielddef indentation=22 field=field />
                </#list>
            example: |
              <request>
                <data>
                <#list operation.parameters as field>
                  <#if pathIncludesKey && field.primaryKey??>
                    <#-- <#continue /> -->
                  </#if>
                  <${field.name}>${field.sample}</${field.name}>
                </#list>
                </data>
              </request>
</#macro>

<#macro responsedef operation format=operation.payloadFormat>
          description: | 
            Expected Response.
            - '${id} Record' responses are sent for adds, fetches that supply the primary key value as a path segment (not as a query param or POSTED data), and updates or removes that specify the primary key either as param(s) or as a path segment.  
            - 'Array responses' are always generated for any fetch which doesn't specify the primary key as a path segment, or any update or remove request that doesn't specify a primary key.
            - 'DSResponses' are returned if the hybridMode parameter value is true, whether by default or overridden via request parameter.

        <#if wrapJSONResponses>            
            Note that JSON responses are wrapped with a prefix/suffix pair as noted in the x-jsonWrapper element and illustrated in the example below.
            ```
              ${jsonPrefix}
              {
                "response": {
                  "status": 0,
                  "queueStatus": 0,
                  "startRow": 0,
                  "endRow": 0,
                  "totalRows": 0,
                  "data": []
                }
              }
              ${jsonSuffix} 
            ```
          x-jsonWrapper:
            prefix: ${jsonPrefix}
            suffix: ${jsonSuffix}
        </#if>  
          content:
            application/json:
              <@responseschema operation=operation format=format />
              examples:
              <#if format == "record" || format == "any">
                Record:
                  value:
                  <#list operation.outputs as field>
                    ${field.name}: ${field.sample!""}
                  </#list>
              </#if>
              <#if format == "array" || format == "any">
                Array:
                  value: [{
                  <#list operation.outputs as field>
                    ${field.name}: ${field.sample!""}<#sep>, 
                  </#list>
                  }]
              </#if>
                DSResponse:
                  value:
                    response: 
                      status: 0,
                      queueStatus: 0,
                    <#if operation.operationType == 'fetch'>
                      startRow: 0,
                      endRow: 1,
                      totalRows: 1,
                    <#else>
                      affectedRows: 1,
                    </#if>
                      data: [{
                      <#list operation.outputs as field>
                        ${field.name}: ${field.sample!""}<#sep>, 
                      </#list>
                      }]
            application/xml:
              <@responseschema operation=operation format=format />
              examples:
              <#if format == "record" || format == "any">
                Record:
                  value: |
                    <record>
                    <#list operation.outputs as field>
                      <${field.name}>${field.sample!""}</${field.name}>
                    </#list>
                    </record>
              </#if>
              <#if format == "array" || format == "any">
                Array:
                  value: |
                    <data>
                      <record>
                      <#list operation.outputs as field>
                        <${field.name}>${field.sample!""}</${field.name}> 
                      </#list>
                      </record>
                    </data>
              </#if>
                DSResponse:
                  value: |
                    <response>
                      <status>0</status>
                      <queueStatus>0</queueStatus>
                    <#if operation.operationType == 'fetch'>
                      <startRow>0</startRow>
                      <endRow>1</endRow>
                      <totalRows>1</totalRows>
                    <#else>
                      <affectedRows>1</affectedRows>
                  </#if>
                      <data>
                        <record>
                        <#list operation.outputs as field>
                          <${field.name}>${field.sample!""}</${field.name}> 
                        </#list>
                        </record>
                      </data>
                    </response>
</#macro>

<#macro responseschema operation, format>
              schema:
                oneOf:
                <#if format == "record" || format == "any">
                  - title: ${id} Record
                    type: object
                    xml:
                      name: record
                    <#list operation.requiredOutputs>
                    required:
                      <#items as field>
                      - ${field.name}
                      </#items>
                    </#list>
                    properties:
                    <#list operation.outputs as field>
                      ${field.name}:
                        <@describe indentation=24 field=field operation=operation context="response"/>
                        <@fielddef indentation=24 field=field />
                    </#list>
                </#if>
                <#if format == "array" ||format == "any">
                  - title: Record Array 
                    type: array
                    xml:
                      wrapped: true
                      name: data
                    items: 
                      type: object
                      xml:
                        name: record
                      <#list operation.requiredOutputs>
                      required:
                        <#items as field>
                        - ${field.name}
                        </#items>
                      </#list>
                      properties:
                      <#list operation.outputs as field>
                        ${field.name}:
                          <@describe indentation=26 field=field operation=operation context="response"/>
                          <@fielddef indentation=26 field=field />
                      </#list>
                </#if>
                  - title: DSResponse  
                    type: object
                    required: 
                      - response
                    properties: 
                      response:
                        type: object
                        required: 
                          - queueStatus
                          - status
                          - data
                        properties:
                          affectedRows:
                            type: integer
                          status:
                            type: integer
                          queueStatus:
                            type: integer
                          startRow:
                            type: integer
                          endRow: 
                            type: integer
                          totalRows:
                            type: integer
                          data:
                            type: array
                            xml:
                              wrapped: true
                            items:
                              type: object
                              xml:
                                name: record
                              <#list operation.requiredOutputs>
                              required:
                                <#items as field>
                                - ${field.name}
                                </#items>
                              </#list>
                              properties:
                              <#list operation.outputs as field>
                                ${field.name}:
                                  <@describe indentation=34 field=field operation=operation context="response"/>
                                  <@fielddef indentation=34 field=field />
                              </#list>
</#macro>

<#macro fielddef indentation, field>
  <#if field.type??>
    <@indent indentation, "type: ${field.type}" />
  </#if>
  <#if field.format??>
    <@indent indentation, "format: ${field.format}" />
  </#if>
  <#if field.nullable??>
    <@indent indentation, "nullable: ${field.nullable?c}" />
  </#if>
  <#if field.maximum??>
    <@indent indentation, "maximum: ${field.maximum}" />
  </#if>
  <#if field.exclusiveMaximum??>
    <@indent indentation, "exclusiveMaximum: ${field.exclusiveMaximum}" />
  </#if>
  <#if field.minimum??>
    <@indent indentation, "minimum: ${field.minimum}" />
  </#if>
  <#if field.exclusiveMinimum??>
    <@indent indentation, "exclusiveMinimum: ${field.exclusiveMinimum}" />
  </#if>
  <#if field.maxLength??>
    <@indent indentation, "maxLength: ${field.maxLength}" />
  </#if>
  <#if field.minLength??>
    <@indent indentation, "minLength: ${field.minLength}" />
  </#if>
  <#if field.pattern??>
    <@indent indentation, "pattern: ${field.pattern}" />
  </#if>
  <#if field.enum??>
    <@indent indentation, "enum:" />
    <#list field.enum as id>
      <@indent indentation+2, "- '${id}'" />
    </#list>
  </#if>
  <#if field.validators??>
    <@indent indentation, "x-validators:" />
    <#list field.validators as v>
      <@indent indentation+2, "validator-${v?counter}: " />
      <@printValidator indentation+4, v />
    </#list>
  </#if>
</#macro>

<#macro printValidator spaces, map>
  <#list map as key, val>
    <#if val?is_hash>
      <@indent spaces, "${key}:" />
      <@printValidator spaces+2, val />
      <#continue />
    </#if>
    <#-- skip it here, we'll add to the field's description -->
    <#if key == "description">
      <#continue />
    </#if>
    <#-- sigh -->
    <#if val?is_boolean>
      <@indent spaces, "${key}: ${val?c}" />
    <#else>
      <@indent spaces, "${key}: ${val}" />
    </#if>
  </#list>
</#macro>

<#macro indent spaces, content>
  <#local len = content?length >
${content?left_pad(spaces+len)}
</#macro>

<#function isRequired field, operation>
  <#if operation.required??>
    <#return operation.required?seq_contains(field.name)>
  </#if>
  <#return false>
</#function>

<#macro describe indentation, field, operation, context="request">
  <@indent indentation, "description: |  " />
  <#if ((context == "response" && field.restrictions?seq_contains("view")) 
     || (context == "request" && field.restrictions?seq_contains(operation.operationType)))>
    <@indent indentation+2, "**Note that access may be restricted, based on conditions evaluated at runtime.  If appropriate, contact support for details on these constraints.**  " />
  </#if>
  <#if context == "request" && isRequired(field, operation)>
    <@indent indentation+2, "**Required.**  " />
  </#if>
  <#if field.fk??>
    <#local fk = field.fk />
    <@indent indentation+2, "*Foreign Key referencing '${fk.ds}.${fk.field}'*" />
  </#if>
  <#if field.description??>
    <@indent indentation+2, "${field.description}" />
  </#if>
  <#if context == "request" && field.validators?? && (operation.operationType == "add" || operation.operationType == "update")>
    <@indent indentation+2, "Validation Requirements:" />
    <#list field.validators as v>
      <#if v.description??><@indent indentation+4, "- ${v.description}" /></#if>
    </#list>
  </#if>
  <#if field.valueMap??>
    <@indent indentation+2, "Note that legal values can be mapped to the following descriptions:" />
    <#list field.valueMap as id, val>
        <@indent indentation+2, "- **${id}**: ${val}" />
    </#list>
  </#if>
</#macro>