/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.DefaultURLConnection;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class DefaultURLStreamHandler
extends URLStreamHandler {
    private final VfsComponentContext context;
    private final FileSystemOptions fileSystemOptions;

    public DefaultURLStreamHandler(VfsComponentContext context) {
        this(context, null);
    }

    public DefaultURLStreamHandler(VfsComponentContext context, FileSystemOptions fileSystemOptions) {
        this.context = context;
        this.fileSystemOptions = fileSystemOptions;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        FileObject entry = this.context.resolveFile(url.toExternalForm(), this.fileSystemOptions);
        return new DefaultURLConnection(url, entry.getContent());
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        try {
            FileObject old = this.context.resolveFile(u.toExternalForm(), this.fileSystemOptions);
            FileObject newURL = start > 0 && spec.charAt(start - 1) == ':' ? this.context.resolveFile(old, spec, this.fileSystemOptions) : (old.isFile() && old.getParent() != null ? old.getParent().resolveFile(spec) : old.resolveFile(spec));
            String url = newURL.getName().getURI();
            StringBuilder filePart = new StringBuilder();
            String protocolPart = UriParser.extractScheme(this.context.getFileSystemManager().getSchemes(), url, filePart);
            this.setURL(u, protocolPart, "", -1, null, null, filePart.toString(), null, null);
        }
        catch (FileSystemException fse) {
            throw new RuntimeException(fse.getMessage());
        }
    }

    @Override
    protected String toExternalForm(URL u) {
        return u.getProtocol() + ":" + u.getFile();
    }
}

