/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.mail;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Message;
import com.google.api.services.gmail.model.MessagePart;
import com.google.api.services.gmail.model.MessagePartBody;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.mail.GmailService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GmailAttachmentDataSource
extends BasicDataSource {
    private static Logger log = new Logger(GmailAttachmentDataSource.class.getName());

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        Map criteria = req.getCriteria();
        ArrayList records = new ArrayList();
        DSResponse dsResponse = new DSResponse();
        String user = "me";
        String messageId = (String)criteria.get("messageId");
        String userId = (String)criteria.get("userId");
        Gmail service = GmailService.getGmailService(userId);
        Message message = (Message)service.users().messages().get(user, messageId).setFormat("full").execute();
        if (message == null) {
            dsResponse.setData(records);
            return dsResponse;
        }
        MessagePart payload = message.getPayload();
        String mimeType = payload.getMimeType();
        if (mimeType == null || !mimeType.startsWith("multipart")) {
            dsResponse.setData(records);
            return dsResponse;
        }
        messageId = message.getId();
        List parts = payload.getParts();
        for (MessagePart part : payload.getParts()) {
            String filename = part.getFilename();
            if (filename == null || filename.length() == 0) continue;
            MessagePartBody body = part.getBody();
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put("userId", userId);
            record.put("messageId", messageId);
            record.put("attachmentId", body.getAttachmentId());
            record.put("file_filename", filename);
            record.put("file_filesize", body.getSize());
            records.add(record);
        }
        dsResponse.setData(records);
        return dsResponse;
    }

    @Override
    public DSResponse executeDownload(DSRequest req) throws Exception {
        Map criteria = req.getCriteria();
        HashMap<String, Object> record = new HashMap<String, Object>();
        Gmail service = GmailService.getGmailService((String)criteria.get("userId"));
        String user = "me";
        String messageId = (String)criteria.get("messageId");
        String attachmentId = (String)criteria.get("attachmentId");
        MessagePartBody part = (MessagePartBody)service.users().messages().attachments().get(user, messageId, attachmentId).execute();
        byte[] fileByteArray = Base64.decodeBase64((String)part.getData());
        record.put("messageId", messageId);
        record.put("attachmentId", attachmentId);
        record.put("file", fileByteArray);
        DSResponse dsResponse = new DSResponse();
        dsResponse.setData(record);
        return dsResponse;
    }
}

