/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLMetaData;
import com.isomorphic.sql.SQLTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OpenEdgeDriver
extends SQLDriver {
    private static Logger log = new Logger(OpenEdgeDriver.class.getName());
    private static Map<String, Boolean> _supportsOffsetFetch = new HashMap<String, Boolean>();
    private static Map<String, Float> _version = new HashMap<String, Float>();

    public OpenEdgeDriver(String dbName, SQLTable table) throws Exception {
        super(dbName, table);
    }

    @Override
    public boolean supportsNativeReplace() {
        return false;
    }

    @Override
    public boolean supportsSQLLimit() {
        return true;
    }

    @Override
    public String limitQuery(String query, long startRow, long batchSize, List outputColumns, String orderClauseString, String computedOrderClause, DSRequest req, List dataSources, Map context) throws Exception {
        if (this.supportsOffsetFetch()) {
            return this.limitQueryUsingOffsetFetch(query, startRow, batchSize, orderClauseString, computedOrderClause, context);
        }
        return super.limitQuery(query, startRow, batchSize, outputColumns, orderClauseString, computedOrderClause, req, dataSources, context);
    }

    @Override
    public boolean supportsOffsetFetch() {
        if (!_supportsOffsetFetch.containsKey(this.dbName)) {
            try {
                _supportsOffsetFetch.put(this.dbName, this._getVersion(this.dbName) > 11.199f);
            }
            catch (Exception e) {
                log.info((Object)("supportsOffsetFetch on db: " + this.dbName + " threw exception: " + e.toString()));
                _supportsOffsetFetch.put(this.dbName, false);
            }
        }
        return _supportsOffsetFetch.get(this.dbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float _getVersion(String dbName) throws Exception {
        Map<String, Float> map = _version;
        synchronized (map) {
            if (!_version.containsKey(dbName)) {
                SQLMetaData md = new SQLMetaData(dbName, this.getOrCreateConnection());
                String version = md.getMetaData().getDatabaseProductVersion();
                log.debug((Object)("OpenEdge version is '" + version + "'"));
                version = version.substring(0, version.lastIndexOf(46));
                _version.put(dbName, Float.valueOf(Float.parseFloat(version)));
            }
            return _version.get(dbName).floatValue();
        }
    }

    public String limitQueryUsingOffsetFetch(String query, long startRow, long batchSize, String baseOrderClause, String computedOrderClause, Map context) {
        String q = query;
        if (computedOrderClause != null && computedOrderClause.trim().length() > 0) {
            q = baseOrderClause == null || baseOrderClause.trim().length() == 0 || "$defaultOrderClause".equals(baseOrderClause) && (context.get("defaultOrderClause") == null || ((String)context.get("defaultOrderClause")).trim().length() == 0) ? q + " ORDER BY " : q + ", ";
            q = q + computedOrderClause;
        }
        return q + " OFFSET " + startRow + " ROWS FETCH NEXT " + batchSize + " ROWS ONLY";
    }

    @Override
    public Map fetchLastPrimaryKeys(Map primaryKeysPresent, List sequencesNotPresent, SQLDataSource ds, DSRequest req) throws Exception {
        if (this.dbConnection == null && req == null) {
            throw new Exception("no existing db connection exists for last row fetch");
        }
        Object sqlStatement = null;
        Map primaryKeys = primaryKeysPresent;
        for (String sequenceName : sequencesNotPresent) {
            String sequence = this.getCurrentSequenceValue((String)ds.getCorrectDs2NativeFieldMap().get(sequenceName), ds);
            if (sequence == null) continue;
            Object obj = OpenEdgeDriver.getScalarResult("SELECT " + sequence + " FROM SYSPROGRESS.SYSCALCTABLE", this.dbConnection, this.dbName, this, req);
            Object transformed = this.getTransformedSequenceValue(obj, sequenceName, ds, req);
            if (transformed != null) {
                primaryKeys.put(sequenceName, transformed);
                continue;
            }
            primaryKeys.put(sequenceName, obj);
        }
        return primaryKeys;
    }

    @Override
    public String formatValue(Object value) {
        return value.toString();
    }

    @Override
    public String sqlOutTransform(String columnName, String remapName, String tableName) throws Exception {
        String output = this.escapeColumnName(columnName);
        if (remapName != null && !columnName.equals(remapName)) {
            output = output + " AS " + this.escapeColumnName(remapName);
        }
        if (tableName != null) {
            output = tableName + "." + output;
        }
        return output;
    }

    @Override
    public String escapeValue(Object value) {
        if (value == null) {
            return null;
        }
        return "'" + this.escapeValueUnquoted(value.toString(), false) + "'";
    }

    @Override
    public String escapeValueUnquoted(Object value, boolean escapeForFilter) {
        if (value == null) {
            return null;
        }
        String escaped = this.matcher.reset(value.toString()).usePattern(SINGLE_QUOTE_PATTERN).replaceAll(SINGLE_QUOTE_ESCAPE);
        if (escapeForFilter) {
            escaped = this.matcher.reset(escaped).usePattern(BACKSLASH_PATTERN).replaceAll(BACKSLASH_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(PERCENT_PATTERN).replaceAll(PERCENT_ESCAPE);
            escaped = this.matcher.reset(escaped).usePattern(UNDERSCORE_PATTERN).replaceAll(UNDERSCORE_ESCAPE);
        }
        return escaped;
    }

    @Override
    public int caseInsensitiveStrategy() {
        return 0;
    }

    @Override
    public int caseInsensitiveStrategyForRelativeComparisons() {
        return 0;
    }

    @Override
    public String caseSensitiveEqualsPredicate() {
        log.debug((Object)"OpenEdgeDriver does not support case-sensitive comparisons");
        return super.caseSensitiveEqualsPredicate();
    }

    @Override
    public String caseSensitiveLikePredicate() {
        log.debug((Object)"OpenEdgeDriver does not support case-sensitive comparisons");
        return super.caseSensitiveLikePredicate();
    }

    @Override
    protected boolean defaultLikeIsCaseSensitive() {
        return false;
    }

    @Override
    public boolean useActualSequenceObjects(SQLDataSource ds) {
        return true;
    }

    @Override
    public String getNextSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName, dataSource);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = dataSource.getSchemaName();
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".NextVal";
    }

    public String getCurrentSequenceValue(String columnName, SQLDataSource dataSource) throws Exception {
        String sequenceName = this.getSequenceName(columnName);
        if (sequenceName == null) {
            return null;
        }
        String schema = "";
        if (dataSource != null) {
            schema = dataSource.getSchemaName();
            schema = schema == null ? "" : schema + ".";
        }
        return schema + sequenceName + ".CurrVal";
    }

    @Override
    protected String getExpressionForSortBy(String column, Map valueMap, DSRequest request) {
        if (valueMap == null || valueMap.size() == 0) {
            return column;
        }
        if (this._sqlConfig.getBoolean((Object)"useCaseForSortBy", false)) {
            return column;
        }
        String expr = "CASE " + column;
        for (String rawValue : valueMap.keySet()) {
            String actualValue = this.transformActualValueForSort(rawValue, column, request);
            String displayValue = this.getLocalizedDisplayValue(valueMap.get(rawValue), request);
            displayValue = this.escapeValue(displayValue);
            expr = expr + " WHEN " + actualValue + " THEN " + displayValue;
        }
        expr = expr + " ELSE " + column + " END";
        return expr;
    }

    @Override
    public String getNaturalDatabaseObjectName(String objectName) {
        return objectName == null ? null : objectName.toUpperCase();
    }

    @Override
    public String getDummyQuery() {
        return "SELECT 1 FROM SYSPROGRESS.SYSTABLES WHERE TABLENAME = 'SYSTABLES'";
    }

    @Override
    public String getLargeIntegerSQLType() {
        return "bigint";
    }

    @Override
    public boolean castNumbersBeforeLikeCompare() {
        return true;
    }

    @Override
    public String getTextColumnDefinitionForLength(long length) throws Exception {
        String result;
        if (length <= (long)config.getInt((Object)"max.varchar.length", 255)) {
            result = "varchar(" + length + ") COLLATE I";
        } else if (length <= 0x3FFFFFFFL) {
            result = "clob";
        } else {
            throw new Exception("Column length > 1GB is not supported by OpenEdge");
        }
        return result;
    }

    @Override
    public String getFloatType() {
        return "float";
    }

    @Override
    protected boolean supportsBinaryStreams() {
        return false;
    }
}

