/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestRunnerHelper;
import com.isomorphic.autotest.TestRunnerWebDriver;
import com.isomorphic.autotest.TestSpecifier;
import com.isomorphic.autotest.Utils;
import com.isomorphic.autotest.model.TestCaseResults;
import com.isomorphic.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;

public class TestShowcaseHelper
extends ConfiguredBase {
    private static final String OPEN_FOR_TESTING = "?autotest=showcase";
    private static final String MAX_REPORT_LENGTH = "&autotest_report_limit=";
    private static final String DISABLE_FULL_SCREEN = "&disableFullscreenMode=true";
    private static final String TARGET_REACT_SAMPLES = "&react=true";
    private static Logger log = new Logger(TestShowcaseHelper.class.getName());
    private static String tmpDir = System.getenv("TMP_DIR") != null ? System.getenv("TMP_DIR") : "/tmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testAll(String browser, boolean runSelenium, boolean runUsualTests, String[] seleniumScripts, ShowcaseSpecifier showcase, TestRunnerHelper.TestCallback callback) {
        String testRootPath = config.getTestRoot(showcase);
        Map<String, List<String>> scripts = showcase.getSeleniumHTMLScripts(testRootPath, seleniumScripts);
        TestRunnerWebDriver driver = new TestRunnerWebDriver(browser, config.getHttpBaseURL(showcase));
        RuntimeException fatalException = null;
        try {
            driver.start();
            if (runUsualTests) {
                TestShowcaseHelper.testShowcaseExampleTree(browser, callback, driver, scripts, showcase, runSelenium);
            } else if (runSelenium) {
                TestShowcaseHelper.loadExampleTree(driver, showcase);
                ArrayList<String> tests = new ArrayList<String>(scripts.keySet());
                for (String id : tests) {
                    if (!showcase.shouldTestExampleTreeNode(driver, id)) continue;
                    List<String> fileList = scripts.get(id);
                    TestShowcaseHelper.testSeleniumHTMLScripts(fileList, browser, callback, testRootPath, showcase, id);
                }
            }
        }
        catch (RuntimeException e) {
            fatalException = e;
        }
        finally {
            driver.stop();
        }
        if (fatalException != null) {
            log.error((Object)"Test framework aborted due to exception!");
            Utils.dumpStringToFile(tmpDir + "/awstest.exception.txt", ExceptionUtils.getStackTrace((Throwable)fatalException));
            throw fatalException;
        }
    }

    private static void checkedScrollToRow(TestRunnerWebDriver driver, String exampleTree, int targetRow) {
        driver.waitForJSToSucceed(exampleTree + ".getTotalRows() > " + targetRow, 10);
        driver.getEval(exampleTree + ".scrollToRow(" + targetRow + ");");
    }

    private static String loadExampleTree(TestRunnerWebDriver driver, ShowcaseSpecifier showcase) {
        String url = config.getHttpBaseURL(showcase) + config.getShowcaseFile(showcase) + OPEN_FOR_TESTING + DISABLE_FULL_SCREEN;
        int length = Utils.getMaximumReportLength();
        if (length > 0) {
            url = url + MAX_REPORT_LENGTH + length;
        }
        if (showcase.isSmartReact()) {
            url = url + TARGET_REACT_SAMPLES;
        }
        if (config.hasGoogleMapsAPIKey()) {
            url = url + "&google_maps_api_key=" + config.getGoogleMapsAPIKey();
        }
        driver.open(url);
        driver.waitForElementPresent(showcase.getExampleTreeScLocator(), config.getSeleniumTimeout());
        return showcase.getExampleTreeObject();
    }

    private static void testShowcaseExampleTree(String browser, TestRunnerHelper.TestCallback callback, TestRunnerWebDriver driver, Map<String, List<String>> scripts, ShowcaseSpecifier showcase, boolean runSelenium) {
        boolean saveMessages = config.shouldSaveMessages();
        String testRootPath = config.getTestRoot(showcase);
        int nRows = Integer.parseInt(driver.getEval(TestShowcaseHelper.loadExampleTree(driver, showcase) + ".getTotalRows()"));
        for (int row = 0; row < nRows; ++row) {
            List<String> fileList;
            TestSpecifier ts;
            String exampleTree = showcase.getExampleTreeObject();
            if (saveMessages) {
                driver.clearDeveloperConsoleMessages();
            }
            TestShowcaseHelper.checkedScrollToRow(driver, exampleTree, row);
            showcase.clearExampleResultsViewer(driver);
            showcase.clearRPCManagerState(driver);
            if (!showcase.shouldTestExampleTreeNode(driver, row) || null == (ts = showcase.generateTestSpecifier(driver, row))) continue;
            boolean runRcTests = runSelenium;
            if (showcase.isExampleTreeNodeANormalExample(driver, row)) {
                TestCaseResults tcr = TestRunnerHelper.test(ts, browser, driver, showcase, false);
                runRcTests &= tcr.allTestsSuccessful();
                callback.onTestResults(tcr);
                if (showcase.mustReloadExampleTree(tcr)) {
                    TestShowcaseHelper.loadExampleTree(driver, showcase);
                }
            }
            String sampleId = ts.getTestId();
            if (!runRcTests || null == (fileList = scripts.get(sampleId))) continue;
            TestShowcaseHelper.testSeleniumHTMLScripts(fileList, browser, callback, testRootPath, showcase, sampleId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void testSeleniumHTMLScripts(List testFiles, String browser, TestRunnerHelper.TestCallback callback, String testRootPath, ShowcaseSpecifier showcase, String smartClientId) {
        TestRunnerWebDriver driver = new TestRunnerWebDriver(browser);
        for (Object object : testFiles) {
            try {
                driver.start();
                TestCaseResults tcr = TestRunnerHelper.testRctest(config.getHttpBaseURL(showcase), testRootPath, (String)object, driver, showcase, null, smartClientId, null);
                callback.onTestResults(tcr);
            }
            catch (IOException e) {
                log.error((Object)("Problems with selenium test: " + object), (Throwable)e);
            }
            finally {
                driver.stop();
            }
        }
    }
}

