/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-12-06/LGPL Deployment (2025-12-06)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
isc.defineClass("PubSub");

isc.PubSub.addClassMethods({
    _subscriberRegistry : {},
    _nextSubscriptionId : 0,

    getSubscribers : function (channelName) {
        return (this._subscriberRegistry[channelName] = 
                this._subscriberRegistry[channelName] || []);
    },

    subscribe : function (channelName, target, callback) {
        if (!channelName) {
            isc.logWarn("subscribe: missing channelName " + this.getStackTrace());
            return;
        }
        var subscribers = this.getSubscribers(channelName), 
            subscriptionId = this._nextSubscriptionId++;

        if (this.logIsDebugEnabled("PubSub")) {
            isc.Log.logDebug("SUBSCRIBE " + channelName + " ON " + target + " -> " + subscriptionId, "PubSub");
        }
        subscribers.add({ subscriptionId: subscriptionId, target: target, callback: callback });
        return subscriptionId;
    },

    unsubscribe : function (channelName, subscriptionId) {
        if (this.logIsDebugEnabled("PubSub")) {
            isc.Log.logDebug("UNSUBSCRIBE " + channelName + " -> " + subscriptionId, "PubSub");
        }
        var subscribers = this.getSubscribers(channelName);
        subscribers.remove(subscribers.find("subscriptionId", subscriptionId));
    },

    publish : function (channelName, data) {
        // dup to avoid concurrent modification during publish()
        var subscribers = this.getSubscribers(channelName).duplicate(); 
        if (this.logIsDebugEnabled("PubSub")) {
            isc.Log.logWarn("PUBLISH " + channelName + " [" + subscribers.length + "]: " + isc.echo(data), "PubSub");
        }
        this.delayCall("_deliver", [subscribers, channelName, data]);
    },

    _deliver : function (subscribers, channelName, data) {
        for (var i = 0; i < subscribers.length; i++) {
            if (this.logIsDebugEnabled("PubSub")) {
                isc.Log.logWarn("HANDLE " + channelName + " ON " + subscribers[i].target, "PubSub");
            }
            isc.Class.fireCallback(subscribers[i].callback, "data", [data], subscribers[i].target);
        }
    }
});

