/*

  SmartClient Ajax RIA system
  Version v14.0p_2025-12-06/LGPL Deployment (2025-12-06)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class Media
// Constants and APIs for managing icons and fonts in your application.
// @treeLocation Client Reference/Media
// @visibility external
//<

isc.defineClass("Media", "Class");
isc.Media.addClassMethods({
    getCompactSkinNames : function (_callback) {
        isc.DMI.call({
            appID: "isc_builtin",
            className: "com.isomorphic.util.SkinUtil", 
            methodName: "getCompactSkinNames", 
            arguments: [], 
            callback : function (resp, data) {
                if (resp.status < 0) {
                    isc.logWarn("Missing Builtin DMI 'getCompactSkinNames'");
                    // fire the callback with no param, so the Showcase doesn't hang in LGPL
                    if (_callback) _callback(null);
                    return;
                }
                if (_callback) _callback(data);
            },
            requestParams: { willHandleError: true}
        });
    },
    getSkinConfig : function (name, _callback) {
        isc.DMI.call({
            appID: "isc_builtin",
            className: "com.isomorphic.util.SkinUtil", 
            methodName: "getSkinConfigMap", 
            arguments: [name], 
            callback : function (resp, data) {
                if (resp.status < 0) {
                    isc.logWarn("Missing Builtin DMI 'getSkinConfigMap'");
                    // fire the callback with no param, so the Showcase doesn't hang in LGPL
                    if (_callback) _callback(null);
                    return;
                }
                if (_callback) _callback(data);
            },
            requestParams: { willHandleError: true }
        });
    },

    
    
    // this array lists the supported stockIconGroups
    stockIconGroups: [],

    addStockIconGroup : function (name, title, metadata, scImgURLPrefix, criteria) {
        if (metadata) {
            // passed array of stockIcon entries - add them now, if not already present
            if (!isc.Media.stockIcons.getProperty("group").getUniqueItems().contains(name)) {
                isc.Media.addStockIcons(metadata);
            }
        }
        isc.Media.stockIconGroups.add({ 
            name: name, title: title, 
            metadata: isc.Media.getStockIcons(name), 
            scImgURLPrefix: scImgURLPrefix,
            // this is criteria to filter the stockIcons array
            criteria: criteria || { group: name }
        });
        isc.Media.stockIconGroupsMap = isc.Media.stockIconGroups.makeIndex("name");
        return isc.Media.getStockIconGroup(name);
    },

    // remove a stockIconGroup entry, and its icons
    removeStockIconGroup : function (groupName) {
        var groupIcons = isc.Media.getStockIcons(groupName);
        for (var i=0; i<groupIcons.length; i++) {
            isc.Media.stockIcons.remove(groupIcons[i]);
        }
        var group = isc.Media.stockIconGroupsMap[groupName];
        if (group) isc.Media.stockIconGroups.remove(group);
        group = null;
        isc.Media.stockIconGroupsMap = isc.Media.stockIconGroups.makeIndex("name");
        isc.Media.stockIconsMap = isc.Media.stockIcons.makeIndex("name");
    },
    clearStockIconGroups : function (name) {
        isc.Media.stockIconGroupsMap = {};
        for (var i=isc.Media.stockIconGroups.length-1; i>0; i--) {
            isc.Media.stockIconGroups[i] = null;
            isc.Media.stockIconGroups.remove(i);
        }
        isc.Media.stockIconGroups = [];
    },

    getStockIconGroup : function (name) {
        return isc.Media.stockIconGroupsMap[name];
    },

    getStockIcons : function (group, name) {
        var result;
        if (name) {
            // return the single stockIcon with the passed "name", wrapped in an array, or an 
            // empty array
            result = isc.Media.stockIconsMap[name];
            if (result) result = [result]
            else result = [];
        } else if (group) {
            // return the stockIcons with the passed "group"
            result = isc.Media.stockIcons.findAll("group", group);
        } else {
            // return all the stockIcons
            result = isc.Media.stockIcons;
        }
        return result || [];
    },

    

    //> @classMethod Media.getStockIcon()
    // Returns the +link{object:StockIcon, stockIcon} with the passed name, or null if the name 
    // is unused.
    // @param iconName (String) the name of the +link{object:StockIcon, StockIcon} to return
    // @group stockIcons, media
    // @visibility external
    //<
    getStockIcon : function (iconName, fieldName) {
        // the iconName is really a value for any field on the StockIcon, by default the "name"
        // field - the fieldName param allows you to get an icon by some other property, like
        // a known src, but it isn't doc'd
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();
        // default fieldName is "name" - so the default call is just getStockIcon("Add"), eg
        fieldName = fieldName || "name";
        if (fieldName == "name") {
            // find the stockIcon by name
            if (isc.Media.stockIconsMap[fieldName]) {
                return isc.addProperties({}, isc.Media.stockIconsMap[iconName]);
            }
        } 
        // find the stockIcon by some other field - where icon[fieldName]==iconName
        var map = isc.Media.stockIcons.makeIndex(fieldName);
        if (map[iconName]) {
            return isc.addProperties({}, map[iconName]);
        }
        return null;
    },

    removeStockIcon : function (stockKey) {
        isc.Media.removeStockIcons([stockKey]);
    },
    removeStockIcons : function (stockKeys) {
        if (!isc.isAn.Array(stockKeys)) stockKeys = [stockKeys];
        for (var i=0; i<stockKeys.length; i++) {
            if (isc.Media.stockIconsMap[stockKeys[i]]) {
                isc.Media.stockIcons.remove(isc.Media.stockIconsMap[stockKeys[i]]);
                delete isc.Media.stockIconsMap[stockKeys[i]];
                isc.Media.rebuildMaps();
            }
        }
    },
    
    setStockIconStates : function (stockKeys, statesArray) {
        if (!isc.isAn.Array(stockKeys)) stockKeys = [stockKeys];
        for (var i=0; i<stockKeys.length; i++) {
            if (isc.Media.stockIconsMap[stockKeys[i]]) {
                var icon = isc.Media.stockIconsMap[stockKeys[i]];
                if (icon) icon.states = statesArray;
            }
        }
    },

    // update the states array on all the icons in the passed group
    setStockIconGroupStates : function (groupKey, statesArray) {
        var icons = isc.Media.getStockIcons(groupKey);
        for (var i=0; i<icons.length; i++) {
            var icon = icons[i];
            if (icon) icon.states = statesArray;
        }
    },

    // internal methods for getting a DS of image-properties for the builtin framework images
    getStockIconDS : function (iconGroup) {
        var group = isc.Media.getStockIconGroup(iconGroup);
        if (!group || !isc.DataSource) return null;
        if (!group.dataSource) {
            group.dataSource = isc.DataSource.create({
                clientOnly: true,
                fields: [
                    { name: "src", type: "text", primaryKey: true },
                    { name: "fromSrc", type: "text" },
                    { name: "name", type: "text" },
                    { name: "state", type: "text" },
                    { name: "width", type: "integer" },
                    { name: "height", type: "integer" }
                ],
                cacheData: group.metadata
            });
        }
        return group.dataSource;
    },
    // helper to get the image URLs for a known standard group - param can currently be one of 
    // "action", "header" or "class"
    getStockIconURLS : function (iconGroup) {
        var icons = isc.Media.getStockIcons(iconGroup);

        // sort the icons by index and name
        icons.setSort([
            { property: "index", direction: "ascending" },
            { property: "name", direction: "ascending" }
        ]);

        var URLs = [];
        // build an array of objects with src and Name attributes
        for (var i=0; i<icons.length; i++) {
            var icon = icons[i];
            URLs.add({ name: icon.name, fromSrc: icon.parsedURL, src: icon.imgURL });
            if (icon.states && icon.states.length > 0) {
                // if the icon has states, add those URLs as well
                var dotIndex = icon.parsedURL.indexOf("."),
                    start = icon.parsedURL.substring(0, dotIndex) + "_",
                    end = icon.parsedURL.substring(dotIndex)
                ;
                
                for (var j=0; j<icon.states.length; j++) {
                    var iSrc = start + icon.states[j] + end;
                    URLs.add({
                        name: icon.name + "_" + icon.states[j], 
                        fromSrc: iSrc,
                        src: isc.Canvas.getImgURL(iSrc),
                        state: icon.states[j]
                    });
                }
            }
        }
        return URLs;
    },

    //> @classMethod Media.getStockIconNames()
    // Returns an array of the +link{stockIcon.name, names} of all registered 
    // +link{object:StockIcon, stockIcons}.  These are the names which can be used as 
    // src-string values for +link{type:SCImgURL, image attributes}.
    // @group stockIcons, media
    // @visibility external
    //<
    getStockIconNames : function () {
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();
        return isc.Media.stockIcons.getProperty("name").getUniqueItems().sort();
    },
    
    // modify the current src associated with some stockIcon - accepts either name and src, or 
    // a map of icon-name to new src

    //> @classMethod Media.addStockIcons()
    // Registers a list of new +link{object:StockIcon, stockIcons} for use in an application.
    // @param icons (Array of StockIcon) the +link{object:StockIcon, StockIcons} to add
    // @group stockIcons, media
    // @visibility external
    //<
    addStockIcons : function (icons) {
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();
        for (var i=0; i<icons.length; i++) {
            // passing true here prevents the internal maps from being rebuilt for each icon
            isc.Media.addStockIcon(icons[i], true);
        }
        // rebuild the various optimization maps to include all the new stockIcons
        isc.Media.rebuildMaps()
    },

    //> @classMethod Media.addStockIcon()
    // Registers a new +link{object:StockIcon} for use in an application.
    // @param icon (StockIcon) the new +link{object:StockIcon, StockIcon}
    // @group stockIcons, media
    //<
    addStockIcon : function (icon, skipMapUpdates) {
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();

        // don't add an icon with no name, or a name that's already in use
        if (!icon.name) {
            isc.logWarn("Media.addStockIcon() passed icon with no name.");
            return; 
        }
        if (isc.Media.stockIconsMap[icon.name]) {
            isc.logWarn("Media.addStockIcon() passed icon with a name that already exists.");
            return; 
        }

        var pSrc = icon.fromSrc || "";

        // regex for a non-blank string that doesn't start with a / or a [
        var regex = /^[^[/].+$/;

        // all builtin stockIcons specify either [SKINIMG] or [TOOLSIMG] (for classIcons used 
        // in Reify and Skin Editor) in the fromSrc - so this is a custom stockIcon added by 
        // a developer.  If it's relative and has no prefix, assume its intended to be relative 
        // to the appImgDir, [APPIMG]
        if (regex.test(pSrc)) pSrc = (icon.imgDir || "[APPIMG]") + pSrc;
        icon.parsedURL = pSrc;
        icon.expandedFromSrc = pSrc.length > 0 ? isc.Canvas.getImgURL(pSrc) : icon.src;

        // setting "empty" here makes this a known stockIcon with no current mapping - when
        // used in a if (StatefulCanvas, for) ample, the = will avoid rendering any DOM
        // content and showing blank space if the value is "empty" - however, if some skin 
        // or app updates the src with updateIconMapping() or similar, then that skin or 
        // app will render an icon
        if (!icon.src) icon.src = icon.expandedFromSrc || "empty";
        icon.expandedSrc = isc.Canvas.getImgURL(icon.src);

        isc.Media.stockIcons.add(icon);
        
        if (!skipMapUpdates) isc.Media.rebuildMaps();
    },
    
    expandSrc : function (src, imgDir, instance) {
        var newSrc = isc.Canvas.getImgURL(src, imgDir, instance);
        if (newSrc == src && src.contains("[")) {
            // src still contains a token
            var config = isc.Canvas._getSpriteConfig(src);
            if (config) {
                if (config.src && !config.svg) config.src = isc.Canvas.getImgURL(config.src, imgDir, instance);
                else if (config.svg) config.svg = isc.Canvas.getImgURL(config.svg, imgDir, instance);
                newSrc = isc.Canvas._encodeSpriteConfig(config);
            }
        }
        return newSrc;
    },

    // rebuild internal maps, used for quickly accessing stockIcons and identifying them from 
    // various potential inputs, namely any of those supported by SCImgURL/sprite-strings
    // or StockIcon-names
    rebuildMaps : function () {
        isc.Media.stockIconsMap = isc.Media.stockIcons.makeIndex("name");
        // cache maps of name to (current, expanded) src and vice-versa
        isc.Media.iconNameToSrcMap = isc.Media.stockIcons.getValueMap("name", "src");
        isc.Media.srcToIconNameMap = isc.Media.stockIcons.getValueMap("src", "name");
        isc.Media.expandedSrcToIconNameMap = isc.Media.stockIcons.getValueMap("expandedSrc", "name");

        // cache a map of the expanded stockIcon.fromSrc (expandedFromSrc) to name
        isc.Media.expandedFromSrcToIconNameMap = isc.Media.stockIcons.getValueMap("expandedFromSrc", "name");

        // cache a map of the expanded fromSrc to expanded current src
        isc.Media.expandedFromSrcToSrcMap = isc.Media.stockIcons.getValueMap("expandedFromSrc", "src"); 
        // cache a map of SCImgURL (like "[SKINIMG]...") to stockIcon names
        isc.Media.parsedURLToIconNameMap = isc.Media.stockIcons.getValueMap("parsedURL", "name");

        // create a map of iconSets for quicker access later
        isc.Media.iconSetsMap = isc.Media.iconSets.makeIndex("name");

        // notify maps updated
        isc.Media.mapsUpdated();
    },
    
    // notification method that might come in handy later
    mapsUpdated : function () {
        isc.Element.cssVariablesUpdated(true);
    },


    //> @classMethod Media.updateIconMapping()
    // Updates the +link{stockIcon.src, src-string} currently assigned to the passed 
    // +link{stockIcon.name, icon-name}.
    // <p>
    // Changes the src that will be rendered when the passed icon-name or it's 
    // +link{stockIcon.fromSrc} are used as the value of an 
    // +link{type:SCImgURL, image-src} property, such as +link{button.icon} or +link{img.src}.
    // @param name (String) the name of the stockIcon to modify
    // @param newSrc (String) the new +link{type:SCImgURL, src-string} for the passed icon-name
    // @group stockIcons, media
    // @visibility external
    //<
    updateIconMapping : function (name, newSrc) {
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();

        var obj = name;
        if (isc.isA.String(obj)) {
            // shouldn't be passed an object any more, but we need one to pass on
            obj = {};
            obj[name] = newSrc;
        }
        return isc.Media.updateIconMappings(obj);
    },
    
    //> @classMethod Media.updateIconMappings()
    // Updates the +link{stockIcon.src, src-strings} currently assigned to one or more 
    // +link{object:stockIcon, StockIcons}.  The <i>mappings</i> parameter should be a map of 
    // StockIcon-name to +link{type:SCImgURL, any valid src-string}.
    // <p>
    // Once updated, the icons named in the map will render their respective new images 
    // when their +link{stockIcon.name, names} or +link{stockIcon.fromSrc, fromSrc-values} are 
    // used as the value of an image-src property, such as +link{button.icon} or 
    // +link{img.src}.
    // @param mappings (Object) a map of StockIcon-names to new src-strings
    // @group stockIcons, media
    // @visibility external
    //<
    updateIconMappings : function (mappings) {
        for (var key in mappings){
            var icon = isc.Media.stockIconsMap[key];
            if (!icon) {
                isc.logInfo("Can't map invalid stockIcon key '" + key + "'", "stockIcons");
                continue;
            }
            icon.src = mappings[key];

            // update the name->currentSrc map
            isc.Media.iconNameToSrcMap[key] = mappings[key];
            // update the parsed fromSrc->currentSrc map
            isc.Media.expandedFromSrcToSrcMap[icon.expandedFromSrc] = mappings[key];

            // update the expanded src
            icon.expandedSrc = isc.Media.expandSrc(icon.src);
            isc.Media.expandedSrcToIconNameMap[icon.expandedSrc] = key;

            //this.logWarn("modified " + key);
        }
        isc.Media.mapsUpdated();
    },

    // temp internal mechanism to switch from one version of a stockIcons file to another 
    // at runtime
    defaultSVGStockIconPath: "[SKINIMG]stockIcons.svg",
    currentSVGStockIconPath: "[SKINIMG]stockIcons.svg",
    materialSymbolsPath: "[HELPERS]media/svg/stockIconSets/MaterialSymbols/",
    changeSVGStockIconSource : function (toPath) {
        var fromPath = isc.Media.currentSVGStockIconPath;
        toPath = toPath || isc.Media.defaultSVGStockIconPath;

        // cheesy hack - for the moment, hard-code support for the Material-Symbols stockIcon 
        // variants - if passed a toPath like "ms_100_rounded" or "ms_100_rounded_filled", 
        // assume it refers to one of the files in 
        // "[HELPERS]media/svg/stockIconSets/MaterialSymbols/" 
        // and prepend that string to the toPath
        var msFileNameRegex = new RegExp("^ms_([1-7]00)(_)(rounded)(_)?(filled)?$");
        if (msFileNameRegex.test(toPath)) {
            toPath = isc.Media.materialSymbolsPath + toPath;
            if (!toPath.endsWith(".svg")) toPath += ".svg";
        }

        for (var key in isc.Media.iconNameToSrcMap) {
            var src = isc.Media.iconNameToSrcMap[key];
            if (!src) continue;
            var newSrc = src.replace(fromPath, toPath);
            if (newSrc != src) isc.Media.updateIconMapping(key, newSrc);
        }
        isc.Media.currentSVGStockIconPath = toPath;
        isc.Element.cssVariablesUpdated(true);
    }

});

isc.Media.addClassProperties({
    
    //> @object IconSet
    // An object with a unique name that groups together  
    // +link{iconSet.stockIcons, known images} as an array of 
    // +link{class:StockIcon, stockIcons} and/or +link{iconSet.mappings, mappings} 
    // from existing +link{stockIcon.name, stockIcon-names} to 
    // new +link{type:SCImgURL, src-strings of any type}.  Provides a means of applying an 
    // overlay that will replace many or all registered stockIcons, and/or install a set of 
    // custom stockIcons, in a single call.
    // <p>
    // The framework ships with many builtin +link{isc.Media.getStockIconNames(), StockIcons}
    // and has two builtin IconSets that use them:
    // <ul>
    //  <li>"skin" - this is the default IconSet for skins - it doesn't apply any mappings, 
    //      so it uses the StockIcon +link{stockIcon.fromSrc, fromSrc's} and shows the icons 
    //      from the skin's "images/" directory</li>
    //  <li>"svg[:weight:style]" - this <i>IconSet</i> installs <i>mappings</i> that replace 
    //      all framework usage of on-disk image files with stylable
    //      +link{group:svgSymbols, SVG symbols}, largely from a single .svg file.  
    //      These SVG graphics are available at weights ranging 
    //      from 100 to 700 and in <i>outlined</i> and <i>filled</i> styles.  You 
    //      choose among these by appending a weight and/or a style-name, "filled" or 
    //      "outlined", each prefixed with a colon (":").
    //  </li>
    // </ul>
    // These builtin IconSets may be used at runtime by passing their names directly to 
    // +link{Media.useMedia, Media.useMedia()}.
    // <pre>
    // // use the default media from the skin's images/ directory
    // isc.Media.useMedia("skin")
    //
    // // use "svg", which requires either a weight or style 
    //
    // // no style - uses the default style "outlined"
    // isc.Media.useMedia("svg:400")
    // 
    // // no weight - uses the default weight, "400"
    // isc.Media.useMedia("svg:outlined")
    // 
    // // weight 500, style "filled"
    // isc.Media.useMedia("svg:500:filled")
    // </pre>
    // Note that the "svg" IconSet requires skin-configuration changes to achieve sizing and 
    // scaling behavior that matches our Shiva skin.
    // <p>
    // Developers may also create custom <code>IconSets</code> to define new StockIcons or map 
    // existing ones to new image-sources.  A custom IconSet may be applied at runtime by 
    // passing it directly to +link{Media.useMedia, Media.useMedia()}.  This will 
    // +link{Media.addIconSet, add the IconSet} to the +link{Media.iconSets, registered list},
    // if it isn't already there, and then
    // +link{Media.addStockIcons, add} any +link{iconSet.stockIcons, new stockIcons} it 
    // defines and apply its +link{Media.updateIconMappings, mappings} to
    // modify the src-strings for existing icons, replacing all uses of each named stockIcon 
    // in your application.
    // <p>
    // Typically, this will take effect immediately with no further action by the developer.
    // <p>
    // If you define multiple +link{Media.iconSets, iconSets} with mappings, you can switch 
    // between them to change all your app-icons at runtime without any need 
    // for code-changes.
    // <p>
    // Similarly, you can define multiple iconSets that only add new StockIcons for a certain 
    // part of your product, so they're only installed when that product-module is loaded, or 
    // affect only some of the registered <i>StockIcons</i>.  Then, you can call 
    // <i>useMedia()</i> multiple times, so you can compartmentalize 
    // your graphics into separate overlays, if that's beneficial.
    // <p>
    // <h2>Examples</h2>
    // <h3>Example 1</h3>
    // In this example, the "chevronIconSet" IconSet maps a bunch of builtin StockIcon-names to 
    // new target src-strings, replacing all uses of the original.  This code maps the original
    // PNG files to sprite-strings that use SVG Symbols from a custom file at
    // <i>[APP]newMedia/svgSprite.svg</i>.  The code only 
    // shows 4 icons being mapped, but you could equally map all of the builtin StockIcons in 
    // a single "overlay" IconSet, and that would replace all framework icons with 
    // customized ones. 
    // <pre>
    //  // IconSet that maps the builtin Chevron StockIcons to new src-strings, which point to
    //  // individual +link{group:svgSymbols, SVG Symbols} in a sprite file
    //  var chevronIconSet = {
    //      name: "chevronIconSet",
    //      mappings: {
    //          "Chevron_Up": "sprite:svg:[APP]newMedia/svgSprite.svg#chevron_up",
    //          "Chevron_Down": "sprite:svg:[APP]newMedia/svgSprite.svg#chevron_down",
    //          "Chevron_Left": "sprite:svg:[APP]newMedia/svgSprite.svg#chevron_left",
    //          "Chevron_Right": "sprite:svg:[APP]newMedia/svgSprite.svg#chevron_right"
    //      }
    //  };
    //
    //  isc.Media.useMedia(chevronIconSet);
    // </pre>
    // <h3>Example 2</h3>
    // In this example, the "logoIconSet" defines a few new StockIcons for existing 
    // image-paths.
    // <pre>
    //  // IconSet that defines StockIcons for logo images in the application root
    //  var logoIconSet = {
    //      name: "logoIconSet",
    //      stockIcons: [
    //          {
    //              name: "ProductLogo",
    //              fromSrc: "[APP]productLogo.png",
    //          },
    //          {
    //              name: "AccountsModuleLogo",
    //              fromSrc: "[APP]accountsLogo.png",
    //          },
    //          {
    //              name: "CalendarModuleLogo",
    //              fromSrc: "[APP]calendarLogo.png",
    //          }
    //      ]
    //  };
    //
    //  isc.Media.useMedia(logoIconSet);
    // </pre>
    // <p>
    // If your project bootstrap runs this code, you may then use the names of these new 
    // StockIcons in image-sources, such as +link{button.icon}: "ProductLogo", and extend 
    // them as described +link{object:StockIcon, here}, anywhere in your project.  Any 
    // request for the StockIcon-names will render the associated <b>fromSrc</b>, since no 
    // +link{stockIcon.src, target src} has been set.
    // <p>
    // <h3>Example 3</h3>
    // If you support multiple skins in your project, you may have icons that look great on 
    // light-colored backgrounds, but need to be lighter in order to look good on dark 
    // backgrounds.  To do that, you can create another IconSet that 
    // defines new src-string mappings for your StockIcons, and install it in the dark-skin's 
    // <i>load_skin.js</i> file, or other load-time code, after the first IconSet has been 
    // installed so the StockIcons are present.
    // <pre>
    //  // IconSet that maps custom logo-StockIcons to lighter images in darker skins
    //  var logoIconSetLight = {
    //      name: "logoIconSetLight",
    //      mappings: {
    //          "ProductLogo": "[APP]productLogoLight.png"
    //          "AccountsModuleLogo": "[APP]accountsLogoLight.png",
    //          "CalendarModuleLogo": "[APP]calendarLogoLight.png",
    //      }
    //  };
    //
    //  isc.Media.useMedia(logoIconSetLight);
    // </pre>
    // When this code is run in a Dark skin, any requests from code for the original 
    // "[APP]productLogo.png" or it's StockIcon name "ProductLogo" will be automatically 
    // mapped to the new file, "[APP]productLogoLight.png".
    // @group media, stockIcons
    // @treeLocation Client Reference/Media
    // @visibility external
    //<

    //> @attr iconSet.name (String : null : IR)
    // The unique name for this IconSet - must be a valid JavaScript Identifier.  If the 
    // IconSet has been registered with 
    // +link{media.addIconSet, addIconSet()}, its name may be passed by developers in calls to 
    // +link{Media.useMedia, useMedia()}, in order to add its list of 
    // +link{iconSet.stockIcons, stockIcons} and/or apply its set of 
    // +link{iconSet.mappings, mappings} to modify the images used by existing 
    // +link{object:StockIcon, stockIcons}.
    // @group media, stockIcons
    // @visibility external
    //<

    //> @attr iconSet.mappings (Object : null : IR)
    // An optional JavaScript object that maps known +link{stockIcon.name, stockIcon-names} to 
    // new src-strings, which may be of +link{type:SCImgURL, any type}.  This set of mappings 
    // may be applied at runtime by passing the IconSet itself, or it's 
    // +link{iconSet.name, name} if it's already been +link{Media.addIconSet, registered}, to 
    // +link{Media.useMedia, useMedia}.
    // @group media, stockIcons
    // @visibility external
    //<
    
    //> @attr iconSet.stockIcons (Object : null : IR)
    // An optional list of +link{class:StockIcon, custom icons} which are made available for 
    // use directly in src-strings by +link{stockIcon.name, name}, like any other 
    // <code>stockIcon</code>.
    // @group media, stockIcons
    // @visibility external
    //<

    //> @classMethod Media.getIconSet()
    // Retrieves an +link{object:IconSet} that was previously registered with 
    // +link{Media.addIconSet, addIconSet()} or passed to +link{Media.useMedia, useMedia()}.
    // @param iconSet (String | IconSet) an +link{object:IconSet} or its +link{iconSet.name, name}
    // @group stockIcons, media
    // @visibility external
    //<
    getIconSet : function (iconSet) {
        var name = iconSet;
        if (isc.isAn.Object(name)) name = name.name;
        if (!isc.Media.iconSetsMap[name]) return null;
        return isc.addProperties({}, isc.Media.iconSetsMap[name]);
    },
    //> @classMethod Media.applyIconSet()
    // Apply the stockIcons and/or mappings from an +link{object:IconSet} that was previously 
    // registered with +link{Media.addIconSet, addIconSet()}
    // @param iconSet (String | IconSet) an +link{object:IconSet} or its +link{iconSet.name, name}
    // @group stockIcons, media
    // @visibility internal
    //<
    applyIconSet : function (iconSet) {
        var set = isc.Media.getIconSet(iconSet);
        if (set) {
            if (set.stockIcons) isc.Media.addStockIcons(set.stockIcons);
            if (set.mappings) isc.Media.updateIconMappings(set.mappings);
            return true;
        }
        return false;
    },
    //> @classMethod Media.addIconSet()
    // Adds an +link{object:IconSet} to the +link{media.iconSets, global list} for future use 
    // by passing its name to +link{Media.useMedia, useMedia()}.
    // <p>
    // If an IconSet has not been registered with this method, you may pass the object itself
    // to <i>Media.useMedia()</i> to have it registered and applied right away.
    // @param iconSet (IconSet) the +link{object:IconSet} to add
    // @group stockIcons, media
    // @visibility external
    //<
    addIconSet : function (iconSet) {
        if (!isc.Media.iconSets) isc.Media.iconSets = [];
        var registered = isc.Media.getIconSet(iconSet);
        if (registered) {
            this.logWarn("Iconset with name '" + registered.name + "' is already registered");
            return;
        }
        isc.Media.iconSets.add(iconSet);
        // re-create the map of iconSets to include the new one
        isc.Media.iconSetsMap = isc.Media.iconSets.makeIndex("name");
        return isc.Media.getIconSet(iconSet);
    },

    //> @classAttr Media.iconSets (Array of IconSet : [] : IR)
    // A list of +link{object:IconSet, IconSets} that are available for use by passing their 
    // names to +link{Media.useMedia}.
    // <p>
    // The framework has two builtin IconSets
    // <ul>
    //  <li>"skin", which does not apply any mappings and uses the icons from the skin's 
    //      "images/" directory
    //  <li>"svg", which installs an <i>IconSet</i>, based on Google's Material-Symbols, with
    //      +link{iconSet.mappings, mappings} that replace all framework usage of on-disk image 
    //      files from the "images/" directory with +link{group:svgSymbols, SVG symbols} from a 
    //      single .svg file.  These SVG graphics are available at various weights and in 
    //      outlined and filled styles which you can access by including them separated by 
    //      colons in your call to +link{Media.useMedia, useMedia()} - for example, 
    //      "svg:100", "svg:filled" or "svg:500:outlined"
    // </li></ul>
    // @group media, stockIcons
    // @visibility external
    //<
    iconSets: [
        {
            // this is the default IconSet - it applies no mappings, meaning it just uses the 
            // regular image-files from the skin's /images dir
            name: "skin"
        },
        {
            name: "svg",
            //variantPath: 
            variants: [
                "ms_100_rounded", "ms_200_rounded", "ms_300_rounded", "ms_400_rounded", 
                    "ms_500_rounded", "ms_600_rounded", "ms_700_rounded",
                "ms_100_rounded_filled", "ms_200_rounded_filled", "ms_300_rounded_filled",
                    "ms_400_rounded_filled", "ms_500_rounded_filled", "ms_600_rounded_filled",
                    "ms_700_rounded_filled"
            ],
            srcPrefix: "sprite:svg:[SKINIMG]stockIcons.svg",
            mappings: { 
                //AIAssist: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#robot",
                AbsoluteForm: "sprite:svg:[SKINIMG]stockIcons.svg#table",
                Accept: "sprite:svg:[SKINIMG]stockIcons.svg#check;",
                Add: "sprite:svg:[SKINIMG]stockIcons.svg#add_circle",
                Add_Files: "sprite:svg:[SKINIMG]stockIcons.svg#playlist_add",
                Approve: "sprite:svg:[SKINIMG]stockIcons.svg#check",
                Auto_fit: "sprite:svg:[SKINIMG]stockIcons.svg#left_panel_close",
                Auto_fit_all: "sprite:svg:[SKINIMG]stockIcons.svg#format_letter_spacing",
                Back: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_back;size:14,14;",
                Background: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_fill",
                Blank: "sprite:svg:[SKINIMG]stockIcons.svg#empty",
                BlurbItem: "sprite:svg:[SKINIMG]stockIcons.svg#format_align_left",
                Border: "sprite:svg:[SKINIMG]stockIcons.svg#crop_square",
                Button: "sprite:svg:[SKINIMG]stockIcons.svg#branding_watermark",
                Calendar: "sprite:svg:[SKINIMG]stockIcons.svg#calendar_month",
                CalendarView: "sprite:svg:[SKINIMG]stockIcons.svg#calendar_view_month",
                Cancel: "sprite:svg:[SKINIMG]stockIcons.svg#cancel",
                Canvas: "sprite:svg:[SKINIMG]stockIcons.svg#view_comfy",
                Checkbox_Checked: "sprite:svg:[SKINIMG]stockIcons.svg#checkbox-checked",
                Checkbox_Partial: "sprite:svg:[SKINIMG]stockIcons.svg#checkbox-partial",
                Checkbox_Unchecked: "sprite:svg:[SKINIMG]stockIcons.svg#checkbox-unchecked",
                CheckboxItem: "sprite:svg:[SKINIMG]stockIcons.svg#check_box",
                //Chevron_Down: "sprite:svg:[SKINIMG]stockIcons.svg#expand_more;size:10,10;",
                //Chevron_Left: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_left;size:10,10;",
                //Chevron_Right: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_right;size:10,10;",
                //Chevron_Up: "sprite:svg:[SKINIMG]stockIcons.svg#expand_less;size:10,10;",
                ClearFilter: "sprite:svg:[SKINIMG]stockIcons.svg#filter_none",
                Clear_sort: "sprite:svg:[SKINIMG]stockIcons.svg#verified",
                Close: "sprite:svg:[SKINIMG]stockIcons.svg#close",
                Collapse_Left: "sprite:svg:[SKINIMG]stockIcons.svg#fullscreen_exit",
                Color: "sprite:svg:[SKINIMG]stockIcons.svg#colors",
                Color_Light: "sprite:svg:[SKINIMG]stockIcons.svg#colors",
                Color_Dark: "sprite:svg:[SKINIMG]stockIcons.svg#colors;color:white;",
                ColorItem: "sprite:svg:[SKINIMG]stockIcons.svg#colors",
                ColorPicker: "sprite:svg:[SKINIMG]stockIcons.svg#apps",
                ColorPicker_Close: "sprite:svg:[SKINIMG]stockIcons.svg#close",
                Color_swatch: "sprite:svg:[SKINIMG]stockIcons.svg#palette",
                Column_preferences: "sprite:svg:[SKINIMG]stockIcons.svg#view_column",
                ComboBoxItem: "sprite:svg:[SKINIMG]stockIcons.svg#inventory_2",
                Configure: "sprite:svg:[SKINIMG]stockIcons.svg#settings",
                Configure_sort: "sprite:svg:[SKINIMG]stockIcons.svg#sort_by_alpha",
                Crosshair: "sprite:svg:[SKINIMG]stockIcons.svg#",
                CubeGrid: "sprite:svg:[SKINIMG]stockIcons.svg#deployed_code",
                DataSource: "sprite:svg:[SKINIMG]stockIcons.svg#data_table",
                DataView: "sprite:svg:[SKINIMG]stockIcons.svg#background_grid_small",
                DateChooser: "sprite:svg:[SKINIMG]stockIcons.svg#calendar_month",
                DateChooser_Previous: "sprite:svg:[SKINIMG]stockIcons.svg#navigate_before",
                DateChooser_Next: "sprite:svg:[SKINIMG]stockIcons.svg#navigate_next",
                DateChooser_First: "sprite:svg:[SKINIMG]stockIcons.svg#first_page",
                DateChooser_Last: "sprite:svg:[SKINIMG]stockIcons.svg#last_page",
                DateGrid: "sprite:svg:[SKINIMG]stockIcons.svg#date_range",
                DateItem: "sprite:svg:[SKINIMG]stockIcons.svg#today",
                Deck: "sprite:svg:[SKINIMG]stockIcons.svg#pip_exit",
                DetailViewer: "sprite:svg:[SKINIMG]stockIcons.svg#view_list",
                Dialog_Ask: "sprite:svg:[SKINIMG]stockIcons.svg#help",
                Dialog_Confirm: "sprite:svg:[SKINIMG]stockIcons.svg#info",
                Dialog_Error: "sprite:svg:[SKINIMG]stockIcons.svg#do_not_disturb_on",
                Dialog_Notify: "sprite:svg:[SKINIMG]stockIcons.svg#info",
                Dialog_Say: "sprite:svg:[SKINIMG]stockIcons.svg#chat_info",
                Dialog_Stop: "sprite:svg:[SKINIMG]stockIcons.svg#stop_circle",
                Dialog_Warn: "sprite:svg:[SKINIMG]stockIcons.svg#warning",
                Download: "sprite:svg:[SKINIMG]stockIcons.svg#download",
                Drag: "sprite:svg:[SKINIMG]stockIcons.svg#drag_indicator",
                Dynamic: "sprite:svg:[SKINIMG]stockIcons.svg#dynamic_feed",
                DynamicForm: "sprite:svg:[SKINIMG]stockIcons.svg#dynamic_form",
                Edit: "sprite:svg:[SKINIMG]stockIcons.svg#edit",
                Exclamation: "sprite:svg:[SKINIMG]stockIcons.svg#warning",
                Expand_Right: "sprite:svg:[SKINIMG]stockIcons.svg#fullscreen",
                Export: "sprite:svg:[SKINIMG]stockIcons.svg#share_windows",
                FacetChart: "sprite:svg:[SKINIMG]stockIcons.svg#bar_chart",
                FileItem: "sprite:svg:[SKINIMG]stockIcons.svg#file_open",
                Filter: "sprite:svg:[SKINIMG]stockIcons.svg#filter_list",
                FilterActive: "sprite:svg:[SKINIMG]stockIcons.svg#filter_alt",
                FilterBuilder: "sprite:svg:[SKINIMG]stockIcons.svg#filter_alt",
                Find: "sprite:svg:[SKINIMG]stockIcons.svg#find_in_page",
                First: "sprite:svg:[SKINIMG]stockIcons.svg#first_page",
                FloatItem: "sprite:svg:[SKINIMG]stockIcons.svg#decimal_increase",
                Font: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_text",
                FontLoader: "sprite:svg:[SKINIMG]stockIcons.svg#font_download",
                FormItem: "sprite:svg:[SKINIMG]stockIcons.svg#match_word",
                Format_align_center: "sprite:svg:[SKINIMG]stockIcons.svg#format_align_center",
                Format_align_justify: "sprite:svg:[SKINIMG]stockIcons.svg#format_align_justify",
                Format_align_left: "sprite:svg:[SKINIMG]stockIcons.svg#format_align_left",
                Format_align_right: "sprite:svg:[SKINIMG]stockIcons.svg#format_align_right",
                Format_bold: "sprite:svg:[SKINIMG]stockIcons.svg#format_bold",
                Format_copy: "sprite:svg:[SKINIMG]stockIcons.svg#content_copy",
                Format_fill_color: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_fill",
                Format_indent_decrease: "sprite:svg:[SKINIMG]stockIcons.svg#format_indent_decrease",
                Format_indent_increase: "sprite:svg:[SKINIMG]stockIcons.svg#format_indent_increase",
                Format_italic: "sprite:svg:[SKINIMG]stockIcons.svg#format_italic",
                Format_list_bulleted: "sprite:svg:[SKINIMG]stockIcons.svg#format_list_bulleted",
                Format_list_numbered: "sprite:svg:[SKINIMG]stockIcons.svg#format_list_numbered",
                Format_text_color: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_text",
                Format_underline: "sprite:svg:[SKINIMG]stockIcons.svg#format_underlined",
                FormulaBuilder: "sprite:svg:[SKINIMG]stockIcons.svg#function",
                Forward: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_forward;size:14,14;",
                FreezeLeft: "sprite:svg:[SKINIMG]stockIcons.svg#border_left",
                FreezeRight: "sprite:svg:[SKINIMG]stockIcons.svg#border_right",
                //GridFormula: "sprite:svg:[SKINIMG]stockIcons.svg#function",
                Grid_Formula: "sprite:svg:[SKINIMG]stockIcons.svg#function",
                Grid_Group_closed: "sprite:svg:[SKINIMG]stockIcons.svg#add_box;size:10,10;",
                Grid_Group_opened: "sprite:svg:[SKINIMG]stockIcons.svg#chips;size:10,10;",
                Grid_Row_collapsed: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_right_collapsed",
                Grid_Row_expanded: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_right_expanded",
                Grid_Sort_ascending: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_upward;size:9,9;",
                Grid_Sort_descending: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_downward;size:9,9;",
                Gripper: "sprite:svg:[SKINIMG]stockIcons.svg#wifi_1_bar", // double check
                GroupLabel: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_text",
                Groupby: "sprite:svg:[SKINIMG]stockIcons.svg#ad_group",
                HLayout: "sprite:svg:[SKINIMG]stockIcons.svg#border_horizontal",
                HandPlacedForm: "sprite:svg:[SKINIMG]stockIcons.svg#table",
                Header: "sprite:svg:[SKINIMG]stockIcons.svg#subheader",
                HeaderItem: "sprite:svg:[SKINIMG]stockIcons.svg#subheader",
                Header_Arrow_down: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_downward",
                Header_Arrow_left: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_back",
                Header_Arrow_right: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_forward",
                Header_Arrow_up: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_upward",                
                Header_Cascade: "sprite:svg:[SKINIMG]stockIcons.svg#auto_awesome_motion",
                Header_Clipboard: "sprite:svg:[SKINIMG]stockIcons.svg#assignment",                
                Header_Clock: "sprite:svg:[SKINIMG]stockIcons.svg#nest_clock_farsight_analog",
                Header_Close: "sprite:svg:[SKINIMG]stockIcons.svg#close",
                Header_Comment: "sprite:svg:[SKINIMG]stockIcons.svg#comment",                
                Header_Document: "sprite:svg:[SKINIMG]stockIcons.svg#document",                
                Header_Double_arrow_down: "sprite:svg:[SKINIMG]stockIcons.svg#keyboard_double_arrow_down",
                Header_Double_arrow_left: "sprite:svg:[SKINIMG]stockIcons.svg#keyboard_double_arrow_left",
                Header_Double_arrow_right: "sprite:svg:[SKINIMG]stockIcons.svg#keyboard_double_arrow_right",
                Header_Double_arrow_up: "sprite:svg:[SKINIMG]stockIcons.svg#keyboard_double_arrow_up",
                Header_Favourite: "sprite:svg:[SKINIMG]stockIcons.svg#favorite",
                Header_Find: "sprite:svg:[SKINIMG]stockIcons.svg#find_in_page",
                Header_Help: "sprite:svg:[SKINIMG]stockIcons.svg#help",
                Header_Home: "sprite:svg:[SKINIMG]stockIcons.svg#home",
                Header_Mail: "sprite:svg:[SKINIMG]stockIcons.svg#mail",                
                Header_Maximize: "sprite:svg:[SKINIMG]stockIcons.svg#crop_square",
                Header_Minimize: "sprite:svg:[SKINIMG]stockIcons.svg#minimize",               
                Header_Minus: "sprite:svg:[SKINIMG]stockIcons.svg#minimize",                
                Header_Person: "sprite:svg:[SKINIMG]stockIcons.svg#person",
                Header_Pin_down: "sprite:svg:[SKINIMG]stockIcons.svg#push_pin",                
                Header_Pin_left: "sprite:svg:[SKINIMG]stockIcons.svg#push_pin_left",// custom icon
                Header_Plus: "sprite:svg:[SKINIMG]stockIcons.svg#add",
                Header_Print: "sprite:svg:[SKINIMG]stockIcons.svg#print",
                Header_Refresh: "sprite:svg:[SKINIMG]stockIcons.svg#refresh",
                Header_Refresh_thin: "sprite:svg:[SKINIMG]stockIcons.svg#refresh",
                Header_Save: "sprite:svg:[SKINIMG]stockIcons.svg#save",
                Header_Settings: "sprite:svg:[SKINIMG]stockIcons.svg#settings",
                Header_Transfer: "sprite:svg:[SKINIMG]stockIcons.svg#transition_push",
                Header_Trash: "sprite:svg:[SKINIMG]stockIcons.svg#delete",                
                Header_Calculator: "sprite:svg:[SKINIMG]stockIcons.svg#calculate",
                Header_Cart: "sprite:svg:[SKINIMG]stockIcons.svg#shopping_cart",
                Header_Zoom: "sprite:svg:[SKINIMG]stockIcons.svg#zoom_in",
                Help: "sprite:svg:[SKINIMG]stockIcons.svg#help",
                HiddenItem: "sprite:svg:[SKINIMG]stockIcons.svg#preview_off",
                Hover: "sprite:svg:[SKINIMG]stockIcons.svg#gesture_select",
                IconButton: "sprite:svg:[SKINIMG]stockIcons.svg#check_circle",
                //iOS_More: "sprite:svg:[SKINIMG]stockIcons.svg#",
                Label: "sprite:svg:[SKINIMG]stockIcons.svg#format_color_text",
                Last: "sprite:svg:[SKINIMG]stockIcons.svg#last_page",
                Layout: "sprite:svg:[SKINIMG]stockIcons.svg#view_quilt",
                LayoutSpacer: "sprite:svg:[SKINIMG]stockIcons.svg#splitscreen",
                LeadingDate_Gripper: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_right",
                LinkItem: "sprite:svg:[SKINIMG]stockIcons.svg#link",
                ListGrid: "sprite:svg:[SKINIMG]stockIcons.svg#grid_on",
                Menu: "sprite:svg:[SKINIMG]stockIcons.svg#article",
                MenuButton: "sprite:svg:[SKINIMG]stockIcons.svg#capture",
                MenuItem: "sprite:svg:[SKINIMG]stockIcons.svg#article",
                Menu_Check: "sprite:svg:[SKINIMG]stockIcons.svg#check;size:14,14;",
                Menu_Down: "sprite:svg:[SKINIMG]stockIcons.svg#expand_more;size:10,10;",
                Menu_Hamburger: "sprite:svg:[SKINIMG]stockIcons.svg#view_headline",
                Menu_Submenu: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_right",
                Menu_Up: "sprite:svg:[SKINIMG]stockIcons.svg#expand_less;size:10,10;",
                MiniNav_Down: "sprite:svg:[SKINIMG]stockIcons.svg#expand_more;size:14,14;",
                MiniNav_Up: "sprite:svg:[SKINIMG]stockIcons.svg#expand_less;size:14,14;",
                Minus: "sprite:svg:[SKINIMG]stockIcons.svg#remove",
                MonthSchedule: "sprite:svg:[SKINIMG]stockIcons.svg#edit_calendar",
                Navigate_Back: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_left;",
                NavigationBar: "sprite:svg:[SKINIMG]stockIcons.svg#chips",
                NavigationButton: "sprite:svg:[SKINIMG]stockIcons.svg#power_settings_new",
                Next: "sprite:svg:[SKINIMG]stockIcons.svg#navigate_next",
                Notify: "sprite:svg:[SKINIMG]stockIcons.svg#notifications",
                Notify_checkmark: "sprite:svg:[SKINIMG]stockIcons.svg#verified",
                Notify_close: "sprite:svg:[SKINIMG]stockIcons.svg#cancel",
                Notify_error: "sprite:svg:[SKINIMG]stockIcons.svg#error",
                Notify_warning: "sprite:svg:[SKINIMG]stockIcons.svg#warning",
                Ok: "sprite:svg:[SKINIMG]stockIcons.svg#check",
                PasswordItem: "sprite:svg:[SKINIMG]stockIcons.svg#password",
                Pickers_Date: "sprite:svg:[SKINIMG]stockIcons.svg#date_range",
                PickList: "sprite:svg:[SKINIMG]stockIcons.svg#fact_check",
                Plus: "sprite:svg:[SKINIMG]stockIcons.svg#add",
                PortalLayout: "sprite:svg:[SKINIMG]stockIcons.svg#browse",
                Prev: "sprite:svg:[SKINIMG]stockIcons.svg#navigate_before",
                Print: "sprite:svg:[SKINIMG]stockIcons.svg#print",
                Process: "sprite:svg:[SKINIMG]stockIcons.svg#family_history",
                ProgressBar: "sprite:svg:[SKINIMG]stockIcons.svg#page_control",
                PropertySheet: "sprite:svg:[SKINIMG]stockIcons.svg#list_alt",
                RadioGroupItem: "sprite:svg:[SKINIMG]stockIcons.svg#format_list_bulleted",
                RecordEditor_filter: "sprite:svg:[SKINIMG]stockIcons.svg#filter_list",
                Redo: "sprite:svg:[SKINIMG]stockIcons.svg#redo",
                Refresh: "sprite:svg:[SKINIMG]stockIcons.svg#autorenew",
                //Related_Fields: "sprite:svg:[SKINIMG]stockIcons.svg#related_fields",
                Remove: "sprite:svg:[SKINIMG]stockIcons.svg#cancel",
                Remove_Files: "sprite:svg:[SKINIMG]stockIcons.svg#playlist_remove",
                ResetItem: "sprite:svg:[SKINIMG]stockIcons.svg#reset_wrench",
                ResizeBar: "sprite:svg:[SKINIMG]stockIcons.svg#align_self_stretch",
                RibbonBar: "sprite:svg:[SKINIMG]stockIcons.svg#subheader",
                RibbonGroup: "sprite:svg:[SKINIMG]stockIcons.svg#magnification_large",
                RichTextEditor: "sprite:svg:[SKINIMG]stockIcons.svg#format_shapes",
                Save: "sprite:svg:[SKINIMG]stockIcons.svg#save",
                Saved_search: "sprite:svg:[SKINIMG]stockIcons.svg#saved_search",
                Saved_search_remove: "sprite:svg:[SKINIMG]stockIcons.svg#search_off",
                ScreenLoader: "sprite:svg:[SKINIMG]stockIcons.svg#open_in_browser",
                Scrollbar: "sprite:svg:[SKINIMG]stockIcons.svg#expand",
                Search: "sprite:svg:[SKINIMG]stockIcons.svg#search",
                SearchForm: "sprite:svg:[SKINIMG]stockIcons.svg#pageview",
                SectionHeader: "sprite:svg:[SKINIMG]stockIcons.svg#scrollable_header",
                SectionHeader_closed: "sprite:svg:[SKINIMG]stockIcons.svg#expand_more;size:14,14;",
                SectionHeader_opened: "sprite:svg:[SKINIMG]stockIcons.svg#expand_less;size:14,14;",
                SectionItem: "sprite:svg:[SKINIMG]stockIcons.svg#add_ad",
                SectionStack: "sprite:svg:[SKINIMG]stockIcons.svg#post",
                SectionStackSection: "sprite:svg:[SKINIMG]stockIcons.svg#splitscreen_bottom",
                SelectItem: "sprite:svg:[SKINIMG]stockIcons.svg#inventory_2",
                SelectOtherItem: "sprite:svg:[SKINIMG]stockIcons.svg#format_list_bulleted_add",
                Slider: "sprite:svg:[SKINIMG]stockIcons.svg#sliders",
                Sort_ascending: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_upward;size:10,10;",
                Sort_descending: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_downward;size:10,10;",
                SpacerItem: "sprite:svg:[SKINIMG]stockIcons.svg#width",
                SplitPane: "sprite:svg:[SKINIMG]stockIcons.svg#thumbnail_bar",
                Splitbar: "sprite:svg:[SKINIMG]stockIcons.svg#swap_horiz",
                StopButton_Up: "sprite:svg:[SKINIMG]stockIcons.svg#stop_square",
                StopButton_Down: "sprite:svg:[SKINIMG]stockIcons.svg#stop_square",
                SubmitItem: "sprite:svg:[SKINIMG]stockIcons.svg#play_circle",
                TabSet: "sprite:svg:[SKINIMG]stockIcons.svg#tab",
                TabSet_close: "sprite:svg:[SKINIMG]stockIcons.svg#close",
                Text: "sprite:svg:[SKINIMG]stockIcons.svg#text_fields",
                TextItem: "sprite:svg:[SKINIMG]stockIcons.svg#text_fields",
                TextAreaItem: "sprite:svg:[SKINIMG]stockIcons.svg#format_shapes",
                Text_linespacing: "sprite:svg:[SKINIMG]stockIcons.svg#format_line_spacing",
                TileGrid: "sprite:svg:[SKINIMG]stockIcons.svg#view_comfy_alt",
                TimeItem: "sprite:svg:[SKINIMG]stockIcons.svg#text_fields",
                ToolStrip: "sprite:svg:[SKINIMG]stockIcons.svg#buttons_alt",
                ToolStripButton: "sprite:svg:[SKINIMG]stockIcons.svg#capture",
                ToolStripGroup: "sprite:svg:[SKINIMG]stockIcons.svg#buttons_alt",
                ToolStripSeparator: "sprite:svg:[SKINIMG]stockIcons.svg#align_self_stretch",
                ToolStrip_hresizer: "sprite:svg:[SKINIMG]stockIcons.svg#more_horiz;",
                ToolStrip_hseparator: "sprite:svg:[SKINIMG]stockIcons.svg#remove",
                ToolStrip_vresizer: "sprite:svg:[SKINIMG]stockIcons.svg#more_vert;",
                ToolStrip_vseparator: "sprite:svg:[SKINIMG]stockIcons.svg#remove;rotate:90;",
                Tour: "sprite:svg:[SKINIMG]stockIcons.svg#follow_the_signs",
                TransferIcons_down: "sprite:svg:[SKINIMG]stockIcons.svg#expand_more",
                TransferIcons_downLast: "sprite:svg:[SKINIMG]stockIcons.svg#vertical_align_bottom",
                TransferIcons_left: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_left",
                TransferIcons_leftFirst: "sprite:svg:[SKINIMG]stockIcons.svg#first_page",
                TransferIcons_right: "sprite:svg:[SKINIMG]stockIcons.svg#chevron_right",
                TransferIcons_rightLast: "sprite:svg:[SKINIMG]stockIcons.svg#last_page",
                TransferIcons_up: "sprite:svg:[SKINIMG]stockIcons.svg#expand_less",
                TransferIcons_upFirst: "sprite:svg:[SKINIMG]stockIcons.svg#vertical_align_top",
                Transparency: "sprite:svg:[SKINIMG]stockIcons.svg#transparency",
                TrailingDate_Gripper: "sprite:svg:[SKINIMG]stockIcons.svg#arrow_left",
                TreeGrid: "sprite:svg:[SKINIMG]stockIcons.svg#lan",
                Tree_folder: "sprite:svg:[SKINIMG]stockIcons.svg#folder;statefulClass:false",
                Tree_folderclosed: "sprite:svg:[SKINIMG]stockIcons.svg#folder;statefulClass:false",
                Tree_folderdrop: "sprite:svg:[SKINIMG]stockIcons.svg#folder_special;statefulClass:false",
                Tree_folderfile: "sprite:svg:[SKINIMG]stockIcons.svg#snippet_folder;statefulClass:false",
                Tree_folderloading: "sprite:svg:[SKINIMG]stockIcons.svg#drive_folder_upload;statefulClass:false",
                Tree_folderopened: "sprite:svg:[SKINIMG]stockIcons.svg#folder_open;statefulClass:false",
                Tree_leaf: "sprite:svg:[SKINIMG]stockIcons.svg#file_present",
                Tree_opener_closed: "sprite:svg:[SKINIMG]stockIcons.svg#add;size:10,10;",
                Tree_opener_opened: "sprite:svg:[SKINIMG]stockIcons.svg#remove;size:10,10;",
                TriplePane: "sprite:svg:[SKINIMG]stockIcons.svg#space_dashboard",
                Undo: "sprite:svg:[SKINIMG]stockIcons.svg#undo",
                Unfreeze: "sprite:svg:[SKINIMG]stockIcons.svg#border_clear",
                Ungroup: "sprite:svg:[SKINIMG]stockIcons.svg#ad_group_off",
                UploadItem: "sprite:svg:[SKINIMG]stockIcons.svg#upload",
                VLayout: "sprite:svg:[SKINIMG]stockIcons.svg#border_vertical",
                ValuesManager: "sprite:svg:[SKINIMG]stockIcons.svg#database",
                View: "sprite:svg:[SKINIMG]stockIcons.svg#search",
                View_rtl: "sprite:svg:[SKINIMG]stockIcons.svg#preview",
                Window: "sprite:svg:[SKINIMG]stockIcons.svg#select_window"
            }
        },
        {
            // this is the regular font - there are four other variants
            name: "materialIcons",
            cssClass: "material-icons",
            keyList: "10k:e951;10mp:e952;11mp:e953;12mp:e954;13mp:e955;14mp:e956;15mp:e957;16mp:e958;17mp:e959;18mp:e95a;19mp:e95b;1k:e95c;1k_plus:e95d;20mp:e95e;21mp:e95f;22mp:e960;23mp:e961;24mp:e962;2k:e963;2k_plus:e964;2mp:e965;360:e577;3d_rotation:e84d;3k:e966;3k_plus:e967;3mp:e968;4k:e072;4k_plus:e969;4mp:e96a;5g:ef38;5k:e96b;5k_plus:e96c;5mp:e96d;6_ft_apart:f21e;6k:e96e;6k_plus:e96f;6mp:e970;7k:e971;7k_plus:e972;7mp:e973;8k:e974;8k_plus:e975;8mp:e976;9k:e977;9k_plus:e978;9mp:e979;ac_unit:eb3b;access_alarm:e190;access_alarms:e191;access_time:e192;accessibility:e84e;accessibility_new:e92c;accessible:e914;accessible_forward:e934;account_balance:e84f;account_balance_wallet:e850;account_box:e851;account_circle:e853;account_tree:e97a;ad_units:ef39;adb:e60e;add:e145;add_a_photo:e439;add_alarm:e193;add_alert:e003;add_box:e146;add_business:e729;add_call:e0e8;add_chart:e97b;add_circle:e147;add_circle_outline:e148;add_comment:e266;add_ic_call:e97c;add_link:e178;add_location:e567;add_location_alt:ef3a;add_moderator:e97d;add_photo_alternate:e43e;add_road:ef3b;add_shopping_cart:e854;add_task:f23a;add_to_drive:e65c;add_to_home_screen:e1fe;add_to_photos:e39d;add_to_queue:e05c;addchart:ef3c;adjust:e39e;admin_panel_settings:ef3d;agriculture:ea79;airline_seat_flat:e630;airline_seat_flat_angled:e631;airline_seat_individual_suite:e632;airline_seat_legroom_extra:e633;airline_seat_legroom_normal:e634;airline_seat_legroom_reduced:e635;airline_seat_recline_extra:e636;airline_seat_recline_normal:e637;airplanemode_active:e195;airplanemode_inactive:e194;airplanemode_off:e194;airplanemode_on:e195;airplay:e055;airport_shuttle:eb3c;alarm:e855;alarm_add:e856;alarm_off:e857;alarm_on:e858;album:e019;align_horizontal_center:e00f;align_horizontal_left:e00d;align_horizontal_right:e010;align_vertical_bottom:e015;align_vertical_center:e011;align_vertical_top:e00c;all_inbox:e97f;all_inclusive:eb3d;all_out:e90b;alt_route:f184;alternate_email:e0e6;amp_stories:ea13;analytics:ef3e;anchor:f1cd;android:e859;animation:e71c;announcement:e85a;apartment:ea40;api:f1b7;app_blocking:ef3f;app_registration:ef40;app_settings_alt:ef41;approval:e982;apps:e5c3;architecture:ea3b;archive:e149;arrow_back:e5c4;arrow_back_ios:e5e0;arrow_circle_down:f181;arrow_circle_up:f182;arrow_downward:e5db;arrow_drop_down:e5c5;arrow_drop_down_circle:e5c6;arrow_drop_up:e5c7;arrow_forward:e5c8;arrow_forward_ios:e5e1;arrow_left:e5de;arrow_right:e5df;arrow_right_alt:e941;arrow_upward:e5d8;art_track:e060;article:ef42;aspect_ratio:e85b;assessment:e85c;assignment:e85d;assignment_ind:e85e;assignment_late:e85f;assignment_return:e860;assignment_returned:e861;assignment_turned_in:e862;assistant:e39f;assistant_direction:e988;assistant_navigation:e989;assistant_photo:e3a0;atm:e573;attach_email:ea5e;attach_file:e226;attach_money:e227;attachment:e2bc;attractions:ea52;audiotrack:e3a1;auto_awesome:e65f;auto_awesome_mosaic:e660;auto_awesome_motion:e661;auto_delete:ea4c;auto_fix_high:e663;auto_fix_normal:e664;auto_fix_off:e665;auto_stories:e666;autorenew:e863;av_timer:e01b;baby_changing_station:f19b;backpack:f19c;backspace:e14a;backup:e864;backup_table:ef43;badge:ea67;bakery_dining:ea53;ballot:e172;bar_chart:e26b;batch_prediction:f0f5;bathtub:ea41;battery_alert:e19c;battery_charging_full:e1a3;battery_full:e1a4;battery_std:e1a5;battery_unknown:e1a6;beach_access:eb3e;bedtime:ef44;beenhere:e52d;bento:f1f4;bike_scooter:ef45;biotech:ea3a;block:e14b;block_flipped:ef46;bluetooth:e1a7;bluetooth_audio:e60f;bluetooth_connected:e1a8;bluetooth_disabled:e1a9;bluetooth_searching:e1aa;blur_circular:e3a2;blur_linear:e3a3;blur_off:e3a4;blur_on:e3a5;bolt:ea0b;book:e865;book_online:f217;bookmark:e866;bookmark_border:e867;bookmark_outline:e867;bookmarks:e98b;border_all:e228;border_bottom:e229;border_clear:e22a;border_color:e22b;border_horizontal:e22c;border_inner:e22d;border_left:e22e;border_outer:e22f;border_right:e230;border_style:e231;border_top:e232;border_vertical:e233;branding_watermark:e06b;breakfast_dining:ea54;brightness_1:e3a6;brightness_2:e3a7;brightness_3:e3a8;brightness_4:e3a9;brightness_5:e3aa;brightness_6:e3ab;brightness_7:e3ac;brightness_auto:e1ab;brightness_high:e1ac;brightness_low:e1ad;brightness_medium:e1ae;broken_image:e3ad;browser_not_supported:ef47;brunch_dining:ea73;brush:e3ae;bubble_chart:e6dd;bug_report:e868;build:e869;build_circle:ef48;burst_mode:e43c;bus_alert:e98f;business:e0af;business_center:eb3f;cached:e86a;cake:e7e9;calculate:ea5f;calendar_today:e935;calendar_view_day:e936;call:e0b0;call_end:e0b1;call_made:e0b2;call_merge:e0b3;call_missed:e0b4;call_missed_outgoing:e0e4;call_received:e0b5;call_split:e0b6;call_to_action:e06c;camera:e3af;camera_alt:e3b0;camera_enhance:e8fc;camera_front:e3b1;camera_rear:e3b2;camera_roll:e3b3;campaign:ef49;cancel:e5c9;cancel_presentation:e0e9;cancel_schedule_send:ea39;car_rental:ea55;car_repair:ea56;card_giftcard:e8f6;card_membership:e8f7;card_travel:e8f8;carpenter:f1f8;cases:e992;casino:eb40;cast:e307;cast_connected:e308;cast_for_education:efec;category:e574;celebration:ea65;cell_wifi:e0ec;center_focus_strong:e3b4;center_focus_weak:e3b5;change_history:e86b;charging_station:f19d;chat:e0b7;chat_bubble:e0ca;chat_bubble_outline:e0cb;check:e5ca;check_box:e834;check_box_outline_blank:e835;check_circle:e86c;check_circle_outline:e92d;checkroom:f19e;chevron_left:e5cb;chevron_right:e5cc;child_care:eb41;child_friendly:eb42;chrome_reader_mode:e86d;circle:ef4a;circle_notifications:e994;class:e86e;clean_hands:f21f;cleaning_services:f0ff;clear:e14c;clear_all:e0b8;close:e5cd;close_fullscreen:f1cf;closed_caption:e01c;closed_caption_disabled:f1dc;closed_caption_off:e996;cloud:e2bd;cloud_circle:e2be;cloud_done:e2bf;cloud_download:e2c0;cloud_off:e2c1;cloud_queue:e2c2;cloud_upload:e2c3;code:e86f;collections:e3b6;collections_bookmark:e431;color_lens:e3b7;colorize:e3b8;comment:e0b9;comment_bank:ea4e;commute:e940;compare:e3b9;compare_arrows:e915;compass_calibration:e57c;compress:e94d;computer:e30a;confirmation_num:e638;confirmation_number:e638;connect_without_contact:f223;connected_tv:e998;construction:ea3c;contact_mail:e0d0;contact_page:f22e;contact_phone:e0cf;contact_support:e94c;contactless:ea71;contacts:e0ba;content_copy:e14d;content_cut:e14e;content_paste:e14f;control_camera:e074;control_point:e3ba;control_point_duplicate:e3bb;copyright:e90c;coronavirus:f221;corporate_fare:f1d0;countertops:f1f7;create:e150;create_new_folder:e2cc;credit_card:e870;crop:e3be;crop_16_9:e3bc;crop_3_2:e3bd;crop_5_4:e3bf;crop_7_5:e3c0;crop_din:e3c1;crop_free:e3c2;crop_landscape:e3c3;crop_original:e3c4;crop_portrait:e3c5;crop_rotate:e437;crop_square:e3c6;dangerous:e99a;dashboard:e871;dashboard_customize:e99b;data_usage:e1af;date_range:e916;deck:ea42;dehaze:e3c7;delete:e872;delete_forever:e92b;delete_outline:e92e;delete_sweep:e16c;delivery_dining:ea72;departure_board:e576;description:e873;design_services:f10a;desktop_access_disabled:e99d;desktop_mac:e30b;desktop_windows:e30c;details:e3c8;developer_board:e30d;developer_mode:e1b0;device_hub:e335;device_thermostat:e1ff;device_unknown:e339;devices:e1b1;devices_other:e337;dialer_sip:e0bb;dialpad:e0bc;dinner_dining:ea57;directions:e52e;directions_bike:e52f;directions_boat:e532;directions_bus:e530;directions_car:e531;directions_ferry:e532;directions_off:f10f;directions_railway:e534;directions_run:e566;directions_subway:e533;directions_train:e534;directions_transit:e535;directions_walk:e536;dirty_lens:ef4b;disabled_by_default:f230;disc_full:e610;dnd_forwardslash:e611;dns:e875;do_not_disturb:e612;do_not_disturb_alt:e611;do_not_disturb_off:e643;do_not_disturb_on:e644;do_not_step:f19f;do_not_touch:f1b0;dock:e30e;domain:e7ee;domain_disabled:e0ef;domain_verification:ef4c;done:e876;done_all:e877;done_outline:e92f;donut_large:e917;donut_small:e918;double_arrow:ea50;drafts:e151;drag_handle:e25d;drag_indicator:e945;drive_eta:e613;drive_file_move:e675;drive_file_move_outline:e9a1;drive_file_rename_outline:e9a2;drive_folder_upload:e9a3;dry:f1b3;dry_cleaning:ea58;duo:e9a5;dvr:e1b2;dynamic_feed:ea14;dynamic_form:f1bf;east:f1df;eco:ea35;edit:e3c9;edit_attributes:e578;edit_location:e568;edit_off:e950;edit_road:ef4d;eject:e8fb;elderly:f21a;electric_bike:eb1b;electric_car:eb1c;electric_moped:eb1d;electric_rickshaw:eb1e;electric_scooter:eb1f;electrical_services:f102;elevator:f1a0;email:e0be;emoji_emotions:ea22;emoji_events:ea23;emoji_flags:ea1a;emoji_food_beverage:ea1b;emoji_nature:ea1c;emoji_objects:ea24;emoji_people:ea1d;emoji_symbols:ea1e;emoji_transportation:ea1f;engineering:ea3d;enhance_photo_translate:e8fc;enhanced_encryption:e63f;equalizer:e01d;error:e000;error_outline:e001;escalator:f1a1;escalator_warning:f1ac;euro:ea15;euro_symbol:e926;ev_station:e56d;event:e878;event_available:e614;event_busy:e615;event_note:e616;event_seat:e903;exit_to_app:e879;expand:e94f;expand_less:e5ce;expand_more:e5cf;explicit:e01e;explore:e87a;explore_off:e9a8;exposure:e3ca;exposure_minus_1:e3cb;exposure_minus_2:e3cc;exposure_neg_1:e3cb;exposure_neg_2:e3cc;exposure_plus_1:e3cd;exposure_plus_2:e3ce;exposure_zero:e3cf;extension:e87b;face:e87c;face_retouching_natural:ef4e;facebook:f234;fact_check:f0c5;family_restroom:f1a2;fast_forward:e01f;fast_rewind:e020;fastfood:e57a;favorite:e87d;favorite_border:e87e;favorite_outline:e87e;featured_play_list:e06d;featured_video:e06e;feedback:e87f;fence:f1f6;festival:ea68;fiber_dvr:e05d;fiber_manual_record:e061;fiber_new:e05e;fiber_pin:e06a;fiber_smart_record:e062;file_copy:e173;file_download:e2c4;file_download_done:e9aa;file_present:ea0e;file_upload:e2c6;filter:e3d3;filter_1:e3d0;filter_2:e3d1;filter_3:e3d2;filter_4:e3d4;filter_5:e3d5;filter_6:e3d6;filter_7:e3d7;filter_8:e3d8;filter_9:e3d9;filter_9_plus:e3da;filter_alt:ef4f;filter_b_and_w:e3db;filter_center_focus:e3dc;filter_drama:e3dd;filter_frames:e3de;filter_hdr:e3df;filter_list:e152;filter_list_alt:e94e;filter_none:e3e0;filter_tilt_shift:e3e2;filter_vintage:e3e3;find_in_page:e880;find_replace:e881;fingerprint:e90d;fire_extinguisher:f1d8;fire_hydrant:f1a3;fireplace:ea43;first_page:e5dc;fit_screen:ea10;fitness_center:eb43;flag:e153;flaky:ef50;flare:e3e4;flash_auto:e3e5;flash_off:e3e6;flash_on:e3e7;flight:e539;flight_land:e904;flight_takeoff:e905;flip:e3e8;flip_camera_android:ea37;flip_camera_ios:ea38;flip_to_back:e882;flip_to_front:e883;folder:e2c7;folder_open:e2c8;folder_shared:e2c9;folder_special:e617;follow_the_signs:f222;font_download:e167;food_bank:f1f2;format_align_center:e234;format_align_justify:e235;format_align_left:e236;format_align_right:e237;format_bold:e238;format_clear:e239;format_color_fill:e23a;format_color_reset:e23b;format_color_text:e23c;format_indent_decrease:e23d;format_indent_increase:e23e;format_italic:e23f;format_line_spacing:e240;format_list_bulleted:e241;format_list_numbered:e242;format_list_numbered_rtl:e267;format_paint:e243;format_quote:e244;format_shapes:e25e;format_size:e245;format_strikethrough:e246;format_textdirection_l_to_r:e247;format_textdirection_r_to_l:e248;format_underline:e249;format_underlined:e249;forum:e0bf;forward:e154;forward_10:e056;forward_30:e057;forward_5:e058;forward_to_inbox:f187;foundation:f200;free_breakfast:eb44;fullscreen:e5d0;fullscreen_exit:e5d1;functions:e24a;g_translate:e927;gamepad:e30f;games:e021;gavel:e90e;gesture:e155;get_app:e884;gif:e908;goat:10fffd;golf_course:eb45;gps_fixed:e1b3;gps_not_fixed:e1b4;gps_off:e1b5;grade:e885;gradient:e3e9;grading:ea4f;grain:e3ea;graphic_eq:e1b8;grass:f205;grid_off:e3eb;grid_on:e3ec;grid_view:e9b0;group:e7ef;group_add:e7f0;group_work:e886;groups:f233;hail:e9b1;handyman:f10b;hardware:ea59;hd:e052;hdr_enhanced_select:ef51;hdr_off:e3ed;hdr_on:e3ee;hdr_strong:e3f1;hdr_weak:e3f2;headset:e310;headset_mic:e311;headset_off:e33a;healing:e3f3;hearing:e023;hearing_disabled:f104;height:ea16;help:e887;help_center:f1c0;help_outline:e8fd;high_quality:e024;highlight:e25f;highlight_alt:ef52;highlight_off:e888;highlight_remove:e888;history:e889;history_edu:ea3e;history_toggle_off:f17d;home:e88a;home_filled:e9b2;home_repair_service:f100;home_work:ea09;horizontal_distribute:e014;horizontal_rule:f108;horizontal_split:e947;hot_tub:eb46;hotel:e53a;hourglass_bottom:ea5c;hourglass_disabled:ef53;hourglass_empty:e88b;hourglass_full:e88c;hourglass_top:ea5b;house:ea44;house_siding:f202;how_to_reg:e174;how_to_vote:e175;http:e902;https:e88d;hvac:f10e;icecream:ea69;image:e3f4;image_aspect_ratio:e3f5;image_not_supported:f116;image_search:e43f;imagesearch_roller:e9b4;import_contacts:e0e0;import_export:e0c3;important_devices:e912;inbox:e156;indeterminate_check_box:e909;info:e88e;info_outline:e88f;input:e890;insert_chart:e24b;insert_chart_outlined:e26a;insert_comment:e24c;insert_drive_file:e24d;insert_emoticon:e24e;insert_invitation:e24f;insert_link:e250;insert_photo:e251;insights:f092;integration_instructions:ef54;inventory:e179;invert_colors:e891;invert_colors_off:e0c4;invert_colors_on:e891;ios_share:e6b8;iso:e3f6;keyboard:e312;keyboard_arrow_down:e313;keyboard_arrow_left:e314;keyboard_arrow_right:e315;keyboard_arrow_up:e316;keyboard_backspace:e317;keyboard_capslock:e318;keyboard_control:e5d3;keyboard_hide:e31a;keyboard_return:e31b;keyboard_tab:e31c;keyboard_voice:e31d;king_bed:ea45;kitchen:eb47;label:e892;label_important:e937;label_important_outline:e948;label_off:e9b6;label_outline:e893;landscape:e3f7;language:e894;laptop:e31e;laptop_chromebook:e31f;laptop_mac:e320;laptop_windows:e321;last_page:e5dd;launch:e895;layers:e53b;layers_clear:e53c;leaderboard:f20c;leak_add:e3f8;leak_remove:e3f9;leave_bags_at_home:f21b;legend_toggle:f11b;lens:e3fa;library_add:e02e;library_add_check:e9b7;library_books:e02f;library_music:e030;lightbulb:e0f0;lightbulb_outline:e90f;line_style:e919;line_weight:e91a;linear_scale:e260;link:e157;link_off:e16f;linked_camera:e438;liquor:ea60;list:e896;list_alt:e0ee;live_help:e0c6;live_tv:e639;local_activity:e53f;local_airport:e53d;local_atm:e53e;local_attraction:e53f;local_bar:e540;local_cafe:e541;local_car_wash:e542;local_convenience_store:e543;local_dining:e556;local_drink:e544;local_fire_department:ef55;local_florist:e545;local_gas_station:e546;local_grocery_store:e547;local_hospital:e548;local_hotel:e549;local_laundry_service:e54a;local_library:e54b;local_mall:e54c;local_movies:e54d;local_offer:e54e;local_parking:e54f;local_pharmacy:e550;local_phone:e551;local_pizza:e552;local_play:e553;local_police:ef56;local_post_office:e554;local_print_shop:e555;local_printshop:e555;local_restaurant:e556;local_see:e557;local_shipping:e558;local_taxi:e559;location_city:e7f1;location_disabled:e1b6;location_history:e55a;location_off:e0c7;location_on:e0c8;location_pin:f1db;location_searching:e1b7;lock:e897;lock_clock:ef57;lock_open:e898;lock_outline:e899;login:ea77;logout:e9ba;looks:e3fc;looks_3:e3fb;looks_4:e3fd;looks_5:e3fe;looks_6:e3ff;looks_one:e400;looks_two:e401;loop:e028;loupe:e402;low_priority:e16d;loyalty:e89a;luggage:f235;lunch_dining:ea61;mail:e158;mail_outline:e0e1;map:e55b;maps_ugc:ef58;margin:e9bb;mark_as_unread:e9bc;mark_chat_read:f18b;mark_chat_unread:f189;mark_email_read:f18c;mark_email_unread:f18a;markunread:e159;markunread_mailbox:e89b;masks:f218;maximize:e930;mediation:efa7;medical_services:f109;meeting_room:eb4f;memory:e322;menu:e5d2;menu_book:ea19;menu_open:e9bd;merge_type:e252;message:e0c9;messenger:e0ca;messenger_outline:e0cb;mic:e029;mic_external_off:ef59;mic_external_on:ef5a;mic_none:e02a;mic_off:e02b;microwave:f204;military_tech:ea3f;minimize:e931;miscellaneous_services:f10c;missed_video_call:e073;mms:e618;mobile_friendly:e200;mobile_off:e201;mobile_screen_share:e0e7;mode_comment:e253;mode_edit:e254;model_training:f0cf;monetization_on:e263;money:e57d;money_off:e25c;monitor:ef5b;monochrome_photos:e403;mood:e7f2;mood_bad:e7f3;moped:eb28;more:e619;more_horiz:e5d3;more_time:ea5d;more_vert:e5d4;motion_photos_off:e9c0;motion_photos_on:e9c1;motion_photos_pause:f227;motion_photos_paused:e9c2;motorcycle:e91b;mouse:e323;move_to_inbox:e168;movie:e02c;movie_creation:e404;movie_filter:e43a;mp:e9c3;multiline_chart:e6df;multiple_stop:f1b9;multitrack_audio:e1b8;museum:ea36;music_note:e405;music_off:e440;music_video:e063;my_library_add:e02e;my_library_books:e02f;my_library_music:e030;my_location:e55c;nat:ef5c;nature:e406;nature_people:e407;navigate_before:e408;navigate_next:e409;navigation:e55d;near_me:e569;near_me_disabled:f1ef;network_cell:e1b9;network_check:e640;network_locked:e61a;network_wifi:e1ba;new_releases:e031;next_plan:ef5d;next_week:e16a;nfc:e1bb;night_shelter:f1f1;nightlife:ea62;nightlight_round:ef5e;nights_stay:ea46;no_backpack:f237;no_cell:f1a4;no_drinks:f1a5;no_encryption:e641;no_flash:f1a6;no_food:f1a7;no_luggage:f23b;no_meals:f1d6;no_meals_ouline:f229;no_meeting_room:eb4e;no_photography:f1a8;no_sim:e0cc;no_stroller:f1af;no_transfer:f1d5;north:f1e0;north_east:f1e1;north_west:f1e2;not_accessible:f0fe;not_interested:e033;not_listed_location:e575;not_started:f0d1;note:e06f;note_add:e89c;notes:e26c;notification_important:e004;notifications:e7f4;notifications_active:e7f7;notifications_none:e7f5;notifications_off:e7f6;notifications_on:e7f7;notifications_paused:e7f8;now_wallpaper:e1bc;now_widgets:e1bd;offline_bolt:e932;offline_pin:e90a;offline_share:e9c5;ondemand_video:e63a;online_prediction:f0eb;opacity:e91c;open_in_browser:e89d;open_in_full:f1ce;open_in_new:e89e;open_with:e89f;outbond:f228;outbox:ef5f;outdoor_grill:ea47;outgoing_mail:f0d2;outlet:f1d4;outlined_flag:e16e;padding:e9c8;pages:e7f9;pageview:e8a0;palette:e40a;pan_tool:e925;panorama:e40b;panorama_fish_eye:e40c;panorama_fisheye:e40c;panorama_horizontal:e40d;panorama_horizontal_select:ef60;panorama_photosphere:e9c9;panorama_photosphere_select:e9ca;panorama_vertical:e40e;panorama_vertical_select:ef61;panorama_wide_angle:e40f;panorama_wide_angle_select:ef62;park:ea63;party_mode:e7fa;pause:e034;pause_circle_filled:e035;pause_circle_outline:e036;pause_presentation:e0ea;payment:e8a1;payments:ef63;pedal_bike:eb29;pending:ef64;pending_actions:f1bb;people:e7fb;people_alt:ea21;people_outline:e7fc;perm_camera_mic:e8a2;perm_contact_cal:e8a3;perm_contact_calendar:e8a3;perm_data_setting:e8a4;perm_device_info:e8a5;perm_device_information:e8a5;perm_identity:e8a6;perm_media:e8a7;perm_phone_msg:e8a8;perm_scan_wifi:e8a9;person:e7fd;person_add:e7fe;person_add_alt:ea4d;person_add_alt_1:ef65;person_add_disabled:e9cb;person_outline:e7ff;person_pin:e55a;person_pin_circle:e56a;person_remove:ef66;person_remove_alt_1:ef67;person_search:f106;personal_video:e63b;pest_control:f0fa;pest_control_rodent:f0fd;pets:e91d;phone:e0cd;phone_android:e324;phone_bluetooth_speaker:e61b;phone_callback:e649;phone_disabled:e9cc;phone_enabled:e9cd;phone_forwarded:e61c;phone_in_talk:e61d;phone_iphone:e325;phone_locked:e61e;phone_missed:e61f;phone_paused:e620;phonelink:e326;phonelink_erase:e0db;phonelink_lock:e0dc;phonelink_off:e327;phonelink_ring:e0dd;phonelink_setup:e0de;photo:e410;photo_album:e411;photo_camera:e412;photo_camera_back:ef68;photo_camera_front:ef69;photo_filter:e43b;photo_library:e413;photo_size_select_actual:e432;photo_size_select_large:e433;photo_size_select_small:e434;picture_as_pdf:e415;picture_in_picture:e8aa;picture_in_picture_alt:e911;pie_chart:e6c4;pie_chart_outlined:e6c5;pin_drop:e55e;pivot_table_chart:e9ce;place:e55f;plagiarism:ea5a;play_arrow:e037;play_circle_fill:e038;play_circle_filled:e038;play_circle_outline:e039;play_disabled:ef6a;play_for_work:e906;playlist_add:e03b;playlist_add_check:e065;playlist_play:e05f;plumbing:f107;plus_one:e800;point_of_sale:f17e;policy:ea17;poll:e801;polymer:e8ab;pool:eb48;portable_wifi_off:e0ce;portrait:e416;post_add:ea20;power:e63c;power_input:e336;power_off:e646;power_settings_new:e8ac;pregnant_woman:e91e;present_to_all:e0df;preview:f1c5;print:e8ad;print_disabled:e9cf;priority_high:e645;privacy_tip:f0dc;psychology:ea4a;public:e80b;public_off:f1ca;publish:e255;published_with_changes:f232;push_pin:f10d;qr_code:ef6b;qr_code_2:e00a;qr_code_scanner:f206;query_builder:e8ae;question_answer:e8af;queue:e03c;queue_music:e03d;queue_play_next:e066;quick_contacts_dialer:e0cf;quick_contacts_mail:e0d0;quickreply:ef6c;radio:e03e;radio_button_checked:e837;radio_button_off:e836;radio_button_on:e837;radio_button_unchecked:e836;railway_alert:e9d1;ramen_dining:ea64;rate_review:e560;read_more:ef6d;receipt:e8b0;receipt_long:ef6e;recent_actors:e03f;recommend:e9d2;record_voice_over:e91f;redeem:e8b1;redo:e15a;reduce_capacity:f21c;refresh:e5d5;remove:e15b;remove_circle:e15c;remove_circle_outline:e15d;remove_done:e9d3;remove_from_queue:e067;remove_moderator:e9d4;remove_red_eye:e417;remove_shopping_cart:e928;reorder:e8fe;repeat:e040;repeat_on:e9d6;repeat_one:e041;repeat_one_on:e9d7;replay:e042;replay_10:e059;replay_30:e05a;replay_5:e05b;replay_circle_filled:e9d8;reply:e15e;reply_all:e15f;report:e160;report_off:e170;report_problem:e8b2;request_page:f22c;request_quote:f1b6;reset_tv:e9d9;restaurant:e56c;restaurant_menu:e561;restore:e8b3;restore_from_trash:e938;restore_page:e929;rice_bowl:f1f5;ring_volume:e0d1;roofing:f201;room:e8b4;room_preferences:f1b8;room_service:eb49;rotate_90_degrees_ccw:e418;rotate_left:e419;rotate_right:e41a;rounded_corner:e920;router:e328;rowing:e921;rss_feed:e0e5;rtt:e9ad;rule:f1c2;rule_folder:f1c9;run_circle:ef6f;rv_hookup:e642;sanitizer:f21d;satellite:e562;save:e161;save_alt:e171;saved_search:ea11;scanner:e329;scatter_plot:e268;schedule:e8b5;schedule_send:ea0a;school:e80c;science:ea4b;score:e269;screen_lock_landscape:e1be;screen_lock_portrait:e1bf;screen_lock_rotation:e1c0;screen_rotation:e1c1;screen_search_desktop:ef70;screen_share:e0e2;sd:e9dd;sd_card:e623;sd_storage:e1c2;search:e8b6;search_off:ea76;security:e32a;segment:e94b;select_all:e162;self_improvement:ea78;send:e163;send_and_archive:ea0c;send_to_mobile:f05c;sensor_door:f1b5;sensor_window:f1b4;sentiment_dissatisfied:e811;sentiment_neutral:e812;sentiment_satisfied:e813;sentiment_satisfied_alt:e0ed;sentiment_very_dissatisfied:e814;sentiment_very_satisfied:e815;set_meal:f1ea;settings:e8b8;settings_applications:e8b9;settings_backup_restore:e8ba;settings_bluetooth:e8bb;settings_brightness:e8bd;settings_cell:e8bc;settings_display:e8bd;settings_ethernet:e8be;settings_input_antenna:e8bf;settings_input_component:e8c0;settings_input_composite:e8c1;settings_input_hdmi:e8c2;settings_input_svideo:e8c3;settings_overscan:e8c4;settings_phone:e8c5;settings_power:e8c6;settings_remote:e8c7;settings_system_daydream:e1c3;settings_voice:e8c8;share:e80d;shield:e9e0;shop:e8c9;shop_two:e8ca;shopping_bag:f1cc;shopping_basket:e8cb;shopping_cart:e8cc;short_text:e261;show_chart:e6e1;shuffle:e043;shuffle_on:e9e1;shutter_speed:e43d;sick:f220;signal_cellular_0_bar:f0a8;signal_cellular_4_bar:e1c8;signal_cellular_alt:e202;signal_cellular_connected_no_internet_4_bar:e1cd;signal_cellular_no_sim:e1ce;signal_cellular_null:e1cf;signal_cellular_off:e1d0;signal_wifi_0_bar:f0b0;signal_wifi_4_bar:e1d8;signal_wifi_4_bar_lock:e1d9;signal_wifi_off:e1da;sim_card:e32b;sim_card_alert:e624;single_bed:ea48;skip_next:e044;skip_previous:e045;slideshow:e41b;slow_motion_video:e068;smart_button:f1c1;smartphone:e32c;smoke_free:eb4a;smoking_rooms:eb4b;sms:e625;sms_failed:e626;snippet_folder:f1c7;snooze:e046;soap:f1b2;sort:e164;sort_by_alpha:e053;source:f1c4;south:f1e3;south_east:f1e4;south_west:f1e5;spa:eb4c;space_bar:e256;speaker:e32d;speaker_group:e32e;speaker_notes:e8cd;speaker_notes_off:e92a;speaker_phone:e0d2;speed:e9e4;spellcheck:e8ce;sports:ea30;sports_bar:f1f3;sports_baseball:ea51;sports_basketball:ea26;sports_cricket:ea27;sports_esports:ea28;sports_football:ea29;sports_golf:ea2a;sports_handball:ea33;sports_hockey:ea2b;sports_kabaddi:ea34;sports_mma:ea2c;sports_motorsports:ea2d;sports_rugby:ea2e;sports_soccer:ea2f;sports_tennis:ea32;sports_volleyball:ea31;square_foot:ea49;stacked_bar_chart:e9e6;stacked_line_chart:f22b;stairs:f1a9;star:e838;star_border:e83a;star_half:e839;star_outline:e83a;star_outline:f06f;star_rate:f0ec;stars:e8d0;stay_current_landscape:e0d3;stay_current_portrait:e0d4;stay_primary_landscape:e0d5;stay_primary_portrait:e0d6;sticky_note_2:f1fc;stop:e047;stop_circle:ef71;stop_screen_share:e0e3;storage:e1db;store:e8d1;store_mall_directory:e563;storefront:ea12;straighten:e41c;stream:e9e9;streetview:e56e;strikethrough_s:e257;stroller:f1ae;style:e41d;subdirectory_arrow_left:e5d9;subdirectory_arrow_right:e5da;subject:e8d2;subscript:f111;subscriptions:e064;subtitles:e048;subtitles_off:ef72;subway:e56f;superscript:f112;supervised_user_circle:e939;supervisor_account:e8d3;support:ef73;support_agent:f0e2;surround_sound:e049;swap_calls:e0d7;swap_horiz:e8d4;swap_horizontal_circle:e933;swap_vert:e8d5;swap_vert_circle:e8d6;swap_vertical_circle:e8d6;swipe:e9ec;switch_account:e9ed;switch_camera:e41e;switch_left:f1d1;switch_right:f1d2;switch_video:e41f;sync:e627;sync_alt:ea18;sync_disabled:e628;sync_problem:e629;system_update:e62a;system_update_alt:e8d7;system_update_tv:e8d7;tab:e8d8;tab_unselected:e8d9;table_chart:e265;table_rows:f101;table_view:f1be;tablet:e32f;tablet_android:e330;tablet_mac:e331;tag:e9ef;tag_faces:e420;takeout_dining:ea74;tap_and_play:e62b;tapas:f1e9;taxi_alert:ef74;terrain:e564;text_fields:e262;text_format:e165;text_rotate_up:e93a;text_rotate_vertical:e93b;text_rotation_angledown:e93c;text_rotation_angleup:e93d;text_rotation_down:e93e;text_rotation_none:e93f;text_snippet:f1c6;textsms:e0d8;texture:e421;theater_comedy:ea66;theaters:e8da;thumb_down:e8db;thumb_down_alt:e816;thumb_down_off_alt:e9f2;thumb_up:e8dc;thumb_up_alt:e817;thumb_up_off_alt:e9f3;thumbs_up_down:e8dd;time_to_leave:e62c;timelapse:e422;timeline:e922;timer:e425;timer_10:e423;timer_3:e424;timer_off:e426;title:e264;toc:e8de;today:e8df;toggle_off:e9f5;toggle_on:e9f6;toll:e8e0;tonality:e427;topic:f1c8;touch_app:e913;tour:ef75;toys:e332;track_changes:e8e1;traffic:e565;train:e570;tram:e571;transfer_within_a_station:e572;transform:e428;transit_enterexit:e579;translate:e8e2;trending_down:e8e3;trending_flat:e8e4;trending_neutral:e8e4;trending_up:e8e5;trip_origin:e57b;tty:f1aa;tune:e429;turned_in:e8e6;turned_in_not:e8e7;tv:e333;tv_off:e647;two_wheeler:e9f9;umbrella:f1ad;unarchive:e169;undo:e166;unfold_less:e5d6;unfold_more:e5d7;unpublished:f236;unsubscribe:e0eb;update:e923;update_disabled:e075;upgrade:f0fb;upload_file:e9fc;usb:e1e0;verified:ef76;verified_user:e8e8;vertical_align_bottom:e258;vertical_align_center:e259;vertical_align_top:e25a;vertical_distribute:e076;vertical_split:e949;vibration:e62d;video_call:e070;video_collection:e04a;video_label:e071;video_library:e04a;video_settings:ea75;videocam:e04b;videocam_off:e04c;videogame_asset:e338;view_agenda:e8e9;view_array:e8ea;view_carousel:e8eb;view_column:e8ec;view_comfortable:e42a;view_comfy:e42a;view_compact:e42b;view_day:e8ed;view_headline:e8ee;view_in_ar:e9fe;view_list:e8ef;view_module:e8f0;view_quilt:e8f1;view_sidebar:f114;view_stream:e8f2;view_week:e8f3;vignette:e435;visibility:e8f4;visibility_off:e8f5;voice_chat:e62e;voice_over_off:e94a;voicemail:e0d9;volume_down:e04d;volume_mute:e04e;volume_off:e04f;volume_up:e050;volunteer_activism:ea70;vpn_key:e0da;vpn_lock:e62f;wallet_giftcard:e8f6;wallet_membership:e8f7;wallet_travel:e8f8;wallpaper:e1bc;warning:e002;wash:f1b1;watch:e334;watch_later:e924;water_damage:f203;waterfall_chart:ea00;waves:e176;wb_auto:e42c;wb_cloudy:e42d;wb_incandescent:e42e;wb_iridescent:e436;wb_shade:ea01;wb_sunny:e430;wb_twighlight:ea02;wc:e63d;web:e051;web_asset:e069;weekend:e16b;west:f1e6;whatshot:e80e;wheelchair_pickup:f1ab;where_to_vote:e177;widgets:e1bd;wifi:e63e;wifi_calling:ef77;wifi_lock:e1e1;wifi_off:e648;wifi_protected_setup:f0fc;wifi_tethering:e1e2;wine_bar:f1e8;work:e8f9;work_off:e942;work_outline:e943;workspaces_filled:ea0d;workspaces_outline:ea0f;wrap_text:e25b;wrong_location:ef78;wysiwyg:f1c3;youtube_searched_for:e8fa;zoom_in:e8ff;zoom_out:e900;zoom_out_map:e56b",
            mappings : {
                // actions
                Accept: 'check', // new
                Add: 'add_circle',
                Approve: 'check',
                Auto_fit: 'auto_fix_normal',
                Auto_fit_all: 'auto_fix_high',
                Back: 'arrow_back',
                Cancel: 'cancel',
                Clear_sort: 'verified',
                ClearFilter: 'filter_none', // new
                Close: 'close',
                Collapse_Left: "fullscreen_exit",
                Color_swatch: 'palette',
                Column_preferences: 'view_column',
                Configure: 'settings',
                Configure_sort: 'sort_by_alpha',
                Download: 'file_download',
                Drag: 'drag_indicator',
                Dynamic: 'dynamic_feed',
                Edit: 'edit',
                Exclamation: 'warning',
                Expand_Right: "fullscreen",
                Export: 'import_export', // new
                Filter: 'filter_list',
                FilterActive: 'filter_alt',  // new
                First: 'first_page',
                Forward: 'arrow_forward',
                FreezeLeft: 'border_left',
                FreezeRight: 'border_right',
                Groupby: 'workspaces_filled',
                Help: 'help',
                Last: 'last_page',
                Next: 'navigate_next',
                Ok: 'check',
                Plus: 'add',  // new
                Prev: 'navigate_before',
                Print: 'print',  // new
                Redo: 'redo',
                Refresh: 'autorenew',
                Remove: 'cancel',
                Save: 'save',
                Search: 'search',
                Sort_ascending: 'arrow_upward',
                Sort_descending: 'arrow_downward',
                Text_linespacing: 'format_line_spacing',  // new
                Undo: 'undo',
                Unfreeze: 'border_clear',
                Ungroup: 'workspaces_outline',
                View: 'pageview',
                View_rtl: 'preview',
                // grid
                Grid_Sort_ascending: "value:arrow_upward;font-size:12;dimensions:14,12;",
                Grid_Sort_descending: "value:arrow_downward;font-size:12;dimensions:14,12;",
                // menu
                Menu_Check: "check",
                Menu_Down: "value:expand_more;color:inherit;dimensions:16,16;",
                Menu_Submenu: "chevron_right",
                Menu_Up: "value:expand_less;color:inherit;dimensions:16,16;",
                Menu_Hamburger: "view_headline",
                // RecordEditor
                RecordEditor_filter: "value:filter_list;font-size:14;dimensions:16,16;",
                
                // SectionHeader
                SectionHeader_closed: "value:expand_more;font-size:22px;",
                SectionHeader_opened: "value:expand_less;font-size:22px;",

                // tree
                Tree_leaf: 'file_present',
                Tree_folder: 'folder',
                Tree_folderclosed: 'folder',
                Tree_folderdrop: 'folder_special',
                Tree_folderfile: 'snippet_folder',
                Tree_folderloading: 'drive_folder_upload',
                Tree_folderopened: 'folder_open',
                Tree_opener_closed: 'add',
                Tree_opener_opened: 'remove',

                // TransferIcons dir
                TransferIcons_left: "chevron_left",
                TransferIcons_right: "chevron_right",
                TransferIcons_leftFirst: "first_page",
                TransferIcons_rightLast: "last_page",
                TransferIcons_up: "expand_less",
                TransferIcons_down: "expand_more",
                TransferIcons_upFirst: "vertical_align_top",
                TransferIcons_downLast: "vertical_align_bottom",

                // generic chevrons
                //Chevron_Up: "expand_less",
                //Chevron_Down: "expand_more",
                //Chevron_Left: "chevron_left",
                //Chevron_Right: "chevron_right",

                // RichText formatting options
                Format_align_center: "format_align_center",
                Format_align_justify: "format_align_justify",
                Format_align_left: "format_align_left",
                Format_align_right: "format_align_right",
                Format_text_color: "format_color_text",
                Format_fill_color: "format_color_fill",
                Format_bold: "format_bold",
                Format_italic: "format_italic",
                Format_underline: "format_underline",
                Format_indent_increase:"format_indent_increase",
                Format_indent_decrease:"format_indent_decrease",
                Format_list_bulleted:"format_list_bulleted",
                Format_list_numbered:"format_list_numbered",

                // Some others that need reorganising
                Saved_search: "saved_search",
                Saved_search_remove: "search_off",

                // pickers
                Pickers_Date: "date_range"

            }
        },
        {
            name: "materialIconsOutline",
            cssClass: "material-icons-outlined",
            keyList: "360:e577;3d_rotation:e84d;4k:e072;5g:ef38;6_ft_apart:f21e;ac_unit:eb3b;access_alarm:e190;access_alarms:e191;access_time:e192;accessibility:e84e;accessibility_new:e92c;accessible:e914;accessible_forward:e934;account_balance:e84f;account_balance_wallet:e850;account_box:e851;account_circle:e853;account_tree:e97a;ad_units:ef39;adb:e60e;add:e145;add_a_photo:e439;add_alarm:e193;add_alert:e003;add_box:e146;add_business:e729;add_circle:e147;add_circle_outline:e148;add_comment:e266;add_ic_call:e97c;add_location:e567;add_location_alt:ef3a;add_photo_alternate:e43e;add_road:ef3b;add_shopping_cart:e854;add_task:f23a;add_to_home_screen:e1fe;add_to_photos:e39d;add_to_queue:e05c;addchart:ef3c;adjust:e39e;admin_panel_settings:ef3d;agriculture:ea79;airline_seat_flat:e630;airline_seat_flat_angled:e631;airline_seat_individual_suite:e632;airline_seat_legroom_extra:e633;airline_seat_legroom_normal:e634;airline_seat_legroom_reduced:e635;airline_seat_recline_extra:e636;airline_seat_recline_normal:e637;airplanemode_active:e195;airplanemode_inactive:e194;airplanemode_off:e194;airplanemode_on:e195;airplay:e055;airport_shuttle:eb3c;alarm:e855;alarm_add:e856;alarm_off:e857;alarm_on:e858;album:e019;align_horizontal_center:e00f;align_horizontal_left:e00d;align_horizontal_right:e010;align_vertical_bottom:e015;align_vertical_center:e011;align_vertical_top:e00c;all_inbox:e97f;all_inclusive:eb3d;all_out:e90b;alt_route:f184;alternate_email:e0e6;amp_stories:ea13;analytics:ef3e;anchor:f1cd;android:e859;announcement:e85a;apartment:ea40;api:f1b7;app_blocking:ef3f;app_settings_alt:ef41;apps:e5c3;architecture:ea3b;archive:e149;arrow_back:e5c4;arrow_back_ios:e5e0;arrow_circle_down:f181;arrow_circle_up:f182;arrow_downward:e5db;arrow_drop_down:e5c5;arrow_drop_down_circle:e5c6;arrow_drop_up:e5c7;arrow_forward:e5c8;arrow_forward_ios:e5e1;arrow_left:e5de;arrow_right:e5df;arrow_right_alt:e941;arrow_upward:e5d8;art_track:e060;article:ef42;aspect_ratio:e85b;assessment:e85c;assignment:e85d;assignment_ind:e85e;assignment_late:e85f;assignment_return:e860;assignment_returned:e861;assignment_turned_in:e862;assistant:e39f;assistant_photo:e3a0;atm:e573;attach_email:ea5e;attach_file:e226;attach_money:e227;attachment:e2bc;attribution:efdb;audiotrack:e3a1;auto_delete:ea4c;autorenew:e863;av_timer:e01b;baby_changing_station:f19b;backpack:f19c;backspace:e14a;backup:e864;backup_table:ef43;ballot:e172;bar_chart:e26b;batch_prediction:f0f5;bathtub:ea41;battery_alert:e19c;battery_charging_full:e1a3;battery_full:e1a4;battery_std:e1a5;battery_unknown:e1a6;beach_access:eb3e;bedtime:ef44;beenhere:e52d;bento:f1f4;bike_scooter:ef45;biotech:ea3a;block:e14b;bluetooth:e1a7;bluetooth_audio:e60f;bluetooth_connected:e1a8;bluetooth_disabled:e1a9;bluetooth_searching:e1aa;blur_circular:e3a2;blur_linear:e3a3;blur_off:e3a4;blur_on:e3a5;book:e865;book_online:f217;bookmark:e866;bookmark_border:e867;bookmark_outline:e867;bookmarks:e98b;border_all:e228;border_bottom:e229;border_clear:e22a;border_horizontal:e22c;border_inner:e22d;border_left:e22e;border_outer:e22f;border_right:e230;border_style:e231;border_top:e232;border_vertical:e233;branding_watermark:e06b;brightness_1:e3a6;brightness_2:e3a7;brightness_3:e3a8;brightness_4:e3a9;brightness_5:e3aa;brightness_6:e3ab;brightness_7:e3ac;brightness_auto:e1ab;brightness_high:e1ac;brightness_low:e1ad;brightness_medium:e1ae;broken_image:e3ad;browser_not_supported:ef47;brush:e3ae;bubble_chart:e6dd;bug_report:e868;build:e869;build_circle:ef48;burst_mode:e43c;business:e0af;business_center:eb3f;cached:e86a;cake:e7e9;calculate:ea5f;calendar_today:e935;calendar_view_day:e936;call:e0b0;call_end:e0b1;call_made:e0b2;call_merge:e0b3;call_missed:e0b4;call_missed_outgoing:e0e4;call_received:e0b5;call_split:e0b6;call_to_action:e06c;camera:e3af;camera_alt:e3b0;camera_enhance:e8fc;camera_front:e3b1;camera_rear:e3b2;camera_roll:e3b3;campaign:ef49;cancel:e5c9;cancel_presentation:e0e9;cancel_schedule_send:ea39;card_giftcard:e8f6;card_membership:e8f7;card_travel:e8f8;carpenter:f1f8;casino:eb40;cast:e307;cast_connected:e308;cast_for_education:efec;category:e574;center_focus_strong:e3b4;center_focus_weak:e3b5;change_history:e86b;charging_station:f19d;chat:e0b7;chat_bubble:e0ca;chat_bubble_outline:e0cb;check:e5ca;check_box:e834;check_box_outline_blank:e835;check_circle:e86c;check_circle_outline:e92d;checkroom:f19e;chevron_left:e5cb;chevron_right:e5cc;child_care:eb41;child_friendly:eb42;chrome_reader_mode:e86d;class:e86e;clean_hands:f21f;cleaning_services:f0ff;clear:e14c;clear_all:e0b8;close:e5cd;close_fullscreen:f1cf;closed_caption:e01c;closed_caption_disabled:f1dc;cloud:e2bd;cloud_circle:e2be;cloud_done:e2bf;cloud_download:e2c0;cloud_off:e2c1;cloud_queue:e2c2;cloud_upload:e2c3;code:e86f;collections:e3b6;collections_bookmark:e431;color_lens:e3b7;colorize:e3b8;comment:e0b9;comment_bank:ea4e;commute:e940;compare:e3b9;compare_arrows:e915;compass_calibration:e57c;computer:e30a;confirmation_num:e638;confirmation_number:e638;connect_without_contact:f223;construction:ea3c;contact_mail:e0d0;contact_page:f22e;contact_phone:e0cf;contact_support:e94c;contactless:ea71;contacts:e0ba;content_copy:f08a;content_cut:f08b;content_paste:f098;control_camera:e074;control_point:e3ba;control_point_duplicate:e3bb;copy:f08a;copyright:e90c;coronavirus:f221;corporate_fare:f1d0;countertops:f1f7;create:e150;create_new_folder:e2cc;credit_card:e870;crop:e3be;crop_16_9:e3bc;crop_3_2:e3bd;crop_5_4:e3bf;crop_7_5:e3c0;crop_din:e3c1;crop_free:e3c2;crop_landscape:e3c3;crop_original:e3c4;crop_portrait:e3c5;crop_rotate:e437;crop_square:e3c6;cut:f08b;dashboard:e871;data_usage:e1af;date_range:e916;deck:ea42;dehaze:e3c7;delete:e872;delete_forever:e92b;delete_outline:e92e;delete_sweep:e16c;departure_board:e576;description:e873;design_services:f10a;desktop_access_disabled:e99d;desktop_mac:e30b;desktop_windows:e30c;details:e3c8;developer_board:e30d;developer_mode:e1b0;device_hub:e335;device_unknown:e339;devices:e1b1;devices_other:e337;dialer_sip:e0bb;dialpad:e0bc;directions:e52e;directions_bike:e52f;directions_boat:e532;directions_bus:e530;directions_car:e531;directions_ferry:e532;directions_off:f10f;directions_railway:e534;directions_run:e566;directions_subway:e533;directions_train:e534;directions_transit:e535;directions_walk:e536;disabled_by_default:f230;disc_full:e610;dns:e875;do_disturb:f08c;do_disturb_alt:f08d;do_disturb_off:f08e;do_disturb_on:f08f;do_not_step:f19f;do_not_touch:f1b0;dock:e30e;domain:e7ee;domain_disabled:e0ef;domain_verification:ef4c;done:e876;done_all:e877;done_outline:e92f;donut_large:e917;donut_small:e918;double_arrow:ea50;download:f090;download_done:f091;drafts:e151;drag_handle:e25d;drag_indicator:e945;drive_eta:e613;dry:f1b3;duo:e9a5;dvr:e1b2;dynamic_feed:ea14;dynamic_form:f1bf;east:f1df;eco:ea35;edit:e3c9;edit_attributes:e578;edit_location:e568;edit_road:ef4d;eject:e8fb;elderly:f21a;electric_bike:eb1b;electric_car:eb1c;electric_moped:eb1d;electric_scooter:eb1f;electrical_services:f102;elevator:f1a0;email:e0be;emoji_emotions:ea22;emoji_events:ea23;emoji_flags:ea1a;emoji_food_beverage:ea1b;emoji_nature:ea1c;emoji_objects:ea24;emoji_people:ea1d;emoji_symbols:ea1e;emoji_transportation:ea1f;engineering:ea3d;enhance_photo_translate:e8fc;enhanced_encryption:e63f;equalizer:e01d;error:e000;error_outline:e001;escalator:f1a1;escalator_warning:f1ac;euro:ea15;euro_symbol:e926;ev_station:e56d;event:e878;event_available:e614;event_busy:e615;event_note:e616;event_seat:e903;exit_to_app:e879;expand_less:e5ce;expand_more:e5cf;explicit:e01e;explore:e87a;explore_off:e9a8;exposure:e3ca;exposure_minus_1:e3cb;exposure_minus_2:e3cc;exposure_neg_1:e3cb;exposure_neg_2:e3cc;exposure_plus_1:e3cd;exposure_plus_2:e3ce;exposure_zero:e3cf;extension:e87b;face:e87c;face_unlock:f008;facebook:f234;fact_check:f0c5;family_restroom:f1a2;fast_forward:e01f;fast_rewind:e020;fastfood:e57a;favorite:e87d;favorite_border:e87e;favorite_outline:e87e;featured_play_list:e06d;featured_video:e06e;feedback:e87f;fence:f1f6;fiber_dvr:e05d;fiber_manual_record:e061;fiber_new:e05e;fiber_pin:e06a;fiber_smart_record:e062;file_copy:e173;filter:e3d3;filter_1:e3d0;filter_2:e3d1;filter_3:e3d2;filter_4:e3d4;filter_5:e3d5;filter_6:e3d6;filter_7:e3d7;filter_8:e3d8;filter_9:e3d9;filter_9_plus:e3da;filter_alt:ef4f;filter_b_and_w:e3db;filter_center_focus:e3dc;filter_drama:e3dd;filter_frames:e3de;filter_hdr:e3df;filter_list:e152;filter_none:e3e0;filter_tilt_shift:e3e2;filter_vintage:e3e3;find_in_page:e880;find_replace:e881;fingerprint:e90d;fire_extinguisher:f1d8;fireplace:ea43;first_page:e5dc;fitness_center:eb43;flag:e153;flaky:ef50;flare:e3e4;flash_auto:e3e5;flash_off:e3e6;flash_on:e3e7;flight:e539;flight_land:e904;flight_takeoff:e905;flip:e3e8;flip_camera_android:ea37;flip_camera_ios:ea38;flip_to_back:e882;flip_to_front:e883;folder:e2c7;folder_open:e2c8;folder_shared:e2c9;folder_special:e617;follow_the_signs:f222;font_download:e167;food_bank:f1f2;format_align_center:e234;format_align_justify:e235;format_align_left:e236;format_align_right:e237;format_bold:e238;format_clear:e239;format_color_reset:e23b;format_indent_decrease:e23d;format_indent_increase:e23e;format_italic:e23f;format_line_spacing:e240;format_list_bulleted:e241;format_list_numbered:e242;format_list_numbered_rtl:e267;format_paint:e243;format_quote:e244;format_shapes:e25e;format_size:e245;format_strikethrough:e246;format_textdirection_l_to_r:e247;format_textdirection_r_to_l:e248;format_underline:e249;format_underlined:e249;forum:e0bf;forward:e154;forward_10:e056;forward_30:e057;forward_5:e058;forward_to_inbox:f187;foundation:f200;free_breakfast:eb44;fullscreen:e5d0;fullscreen_exit:e5d1;functions:e24a;g_translate:e927;gamepad:e30f;games:e021;gavel:e90e;gesture:e155;get_app:e884;gif:e908;golf_course:eb45;gps_fixed:e1b3;gps_not_fixed:e1b4;gps_off:e1b5;grade:e885;gradient:e3e9;grading:ea4f;grain:e3ea;graphic_eq:e1b8;grass:f205;grid_off:e3eb;grid_on:e3ec;group:e7ef;group_add:e7f0;group_work:e886;groups:f233;handyman:f10b;hd:e052;hdr_off:e3ed;hdr_on:e3ee;hdr_strong:e3f1;hdr_weak:e3f2;headset:e310;headset_mic:e311;healing:e3f3;hearing:e023;hearing_disabled:f104;height:ea16;help:e887;help_center:f1c0;help_outline:e8fd;high_quality:e024;highlight:e25f;highlight_alt:ef52;highlight_off:e888;highlight_remove:e888;history:e889;history_edu:ea3e;history_toggle_off:f17d;home:e88a;home_repair_service:f100;home_work:ea09;horizontal_distribute:e014;horizontal_rule:f108;horizontal_split:e947;hot_tub:eb46;hotel:e53a;hourglass_bottom:ea5c;hourglass_disabled:ef53;hourglass_empty:e88b;hourglass_full:e88c;hourglass_top:ea5b;house:ea44;house_siding:f202;how_to_reg:e174;how_to_vote:e175;http:e902;https:e88d;hvac:f10e;image:e3f4;image_aspect_ratio:e3f5;image_not_supported:f116;image_search:e43f;import_contacts:e0e0;import_export:e0c3;important_devices:e912;inbox:e156;indeterminate_check_box:e909;info:e88e;input:e890;insert_chart:e24b;insert_chart_outlined:e26a;insert_comment:e24c;insert_drive_file:e24d;insert_emoticon:e24e;insert_invitation:e24f;insert_link:e250;insert_photo:e251;insights:f092;integration_instructions:ef54;invert_colors:e891;invert_colors_off:e0c4;invert_colors_on:e891;iso:e3f6;keyboard:e312;keyboard_arrow_down:e313;keyboard_arrow_left:e314;keyboard_arrow_right:e315;keyboard_arrow_up:e316;keyboard_backspace:e317;keyboard_capslock:e318;keyboard_control:e5d3;keyboard_hide:e31a;keyboard_return:e31b;keyboard_tab:e31c;keyboard_voice:e31d;king_bed:ea45;kitchen:eb47;label:e892;label_important:e937;label_off:e9b6;landscape:e3f7;language:e894;laptop:e31e;laptop_chromebook:e31f;laptop_mac:e320;laptop_windows:e321;last_page:e5dd;launch:e895;layers:e53b;layers_clear:e53c;leaderboard:f20c;leak_add:e3f8;leak_remove:e3f9;leave_bags_at_home:f23b;legend_toggle:f11b;lens:e3fa;library_add:e02e;library_add_check:e9b7;library_books:e02f;library_music:e030;lightbulb:e0f0;line_style:e919;line_weight:e91a;linear_scale:e260;link:e157;link_off:e16f;linked_camera:e438;list:e896;list_alt:e0ee;live_help:e0c6;live_tv:e639;local_activity:e53f;local_airport:e53d;local_atm:e53e;local_attraction:e53f;local_bar:e540;local_cafe:e541;local_car_wash:e542;local_convenience_store:e543;local_dining:e556;local_drink:e544;local_fire_department:ef55;local_florist:e545;local_gas_station:e546;local_grocery_store:e547;local_hospital:e548;local_hotel:e549;local_laundry_service:e54a;local_library:e54b;local_mall:e54c;local_movies:e54d;local_offer:e54e;local_parking:e54f;local_pharmacy:e550;local_phone:e551;local_pizza:e552;local_play:e553;local_police:ef56;local_post_office:e554;local_print_shop:e555;local_printshop:e555;local_restaurant:e556;local_see:e557;local_shipping:e558;local_taxi:e559;location_city:e7f1;location_disabled:e1b6;location_history:e55a;location_off:e0c7;location_on:e0c8;location_searching:e1b7;lock:e897;lock_open:e898;login:ea77;looks:e3fc;looks_3:e3fb;looks_4:e3fd;looks_5:e3fe;looks_6:e3ff;looks_one:e400;looks_two:e401;loop:e028;loupe:e402;low_priority:e16d;loyalty:e89a;luggage:f235;mail:e158;mail_outline:e0e1;map:e55b;maps_ugc:ef58;mark_chat_read:f18b;mark_chat_unread:f189;mark_email_read:f18c;mark_email_unread:f18a;markunread:e159;markunread_mailbox:e89b;masks:f218;maximize:e930;mediation:efa7;medical_services:f109;meeting_room:eb4f;memory:e322;menu:e5d2;menu_book:ea19;menu_open:e9bd;merge_type:e252;message:e0c9;messenger:e0ca;messenger_outline:e0cb;mic:e029;mic_none:e02a;mic_off:e02b;microwave:f204;military_tech:ea3f;minimize:e931;miscellaneous_services:f10c;missed_video_call:e073;mms:e618;mobile_friendly:e200;mobile_off:e201;mobile_screen_share:e0e7;mode:f097;mode_comment:e253;model_training:f0cf;monetization_on:e263;money:e57d;money_off:e25c;money_off_csred:f038;monochrome_photos:e403;mood:e7f2;mood_bad:e7f3;moped:eb28;more:e619;more_horiz:e5d3;more_time:ea5d;more_vert:e5d4;motion_photos_on:e9c1;motion_photos_pause:f227;motion_photos_paused:e9c2;motorcycle:e91b;mouse:e323;move_to_inbox:e168;movie:e02c;movie_creation:e404;movie_filter:e43a;multiline_chart:e6df;multiple_stop:f1b9;multitrack_audio:e1b8;museum:ea36;music_note:e405;music_off:e440;music_video:e063;my_library_add:e02e;my_library_books:e02f;my_library_music:e030;my_location:e55c;nat:ef5c;nature:e406;nature_people:e407;navigate_before:e408;navigate_next:e409;navigation:e55d;near_me:e569;near_me_disabled:f1ef;network_check:e640;network_locked:e61a;new_releases:e031;next_plan:ef5d;next_week:e16a;nfc:e1bb;night_shelter:f1f1;nights_stay:ea46;no_backpack:f237;no_cell:f1a4;no_drinks:f1a5;no_encryption:e641;no_encryption_gmailerrorred:f03f;no_flash:f1a6;no_food:f1a7;no_luggage:f23b;no_meals:f1d6;no_meeting_room:eb4e;no_photography:f1a8;no_sim:e0cc;no_stroller:f1af;no_transfer:f1d5;north:f1e0;north_east:f1e1;north_west:f1e2;not_accessible:f0fe;not_interested:e033;not_listed_location:e575;not_started:f0d1;note:e06f;note_add:e89c;notes:e26c;notification_important:e004;notifications:e7f4;notifications_active:e7f7;notifications_none:e7f5;notifications_off:e7f6;notifications_on:e7f7;notifications_paused:e7f8;now_wallpaper:e1bc;now_widgets:e1bd;offline_bolt:e932;offline_pin:e90a;ondemand_video:e63a;online_prediction:f0eb;opacity:e91c;open_in_browser:e89d;open_in_full:f1ce;open_in_new:e89e;open_with:e89f;outbond:f228;outdoor_grill:ea47;outlet:f1d4;outlined_flag:e16e;pages:e7f9;pageview:e8a0;palette:e40a;pan_tool:e925;panorama:e40b;panorama_fish_eye:e40c;panorama_fisheye:e40c;panorama_horizontal:e40d;panorama_vertical:e40e;panorama_wide_angle:e40f;party_mode:e7fa;paste:f098;pause:e034;pause_circle_filled:e035;pause_circle_outline:e036;pause_presentation:e0ea;payment:e8a1;payments:ef63;pedal_bike:eb29;pending:ef64;pending_actions:f1bb;people:e7fb;people_alt:ea21;people_outline:e7fc;perm_camera_mic:e8a2;perm_contact_cal:e8a3;perm_contact_calendar:e8a3;perm_data_setting:e8a4;perm_device_info:e8a5;perm_device_information:e8a5;perm_identity:e8a6;perm_media:e8a7;perm_phone_msg:e8a8;perm_scan_wifi:e8a9;person:e7fd;person_add:e7fe;person_add_alt_1:ef65;person_add_disabled:e9cb;person_outline:e7ff;person_pin:e55a;person_pin_circle:e56a;person_remove:ef66;person_remove_alt_1:ef67;person_search:f106;personal_video:e63b;pest_control:f0fa;pest_control_rodent:f0fd;pets:e91d;phone:e0cd;phone_android:e324;phone_bluetooth_speaker:e61b;phone_callback:e649;phone_disabled:e9cc;phone_enabled:e9cd;phone_forwarded:e61c;phone_in_talk:e61d;phone_iphone:e325;phone_locked:e61e;phone_missed:e61f;phone_paused:e620;phonelink:e326;phonelink_erase:e0db;phonelink_lock:e0dc;phonelink_off:e327;phonelink_ring:e0dd;phonelink_setup:e0de;photo:e410;photo_album:e411;photo_camera:e412;photo_filter:e43b;photo_library:e413;photo_size_select_actual:e432;photo_size_select_large:e433;photo_size_select_small:e434;picture_as_pdf:e415;picture_in_picture:e8aa;picture_in_picture_alt:e911;pie_chart:e6c4;pie_chart_outline:f044;pin_drop:e55e;place:e55f;plagiarism:ea5a;play_arrow:e037;play_circle_fill:e038;play_circle_filled:e038;play_circle_outline:e039;play_for_work:e906;playlist_add:e03b;playlist_add_check:e065;playlist_play:e05f;plumbing:f107;plus_one:e800;point_of_sale:f17e;policy:ea17;poll:e801;polymer:e8ab;pool:eb48;portable_wifi_off:e0ce;portrait:e416;post_add:ea20;power:e63c;power_input:e336;power_off:e646;power_settings_new:e8ac;precision_manufacturing:f049;pregnant_woman:e91e;present_to_all:e0df;preview:f1c5;print:e8ad;print_disabled:e9cf;priority_high:e645;privacy_tip:f0dc;psychology:ea4a;public:e80b;public_off:f1ca;publish:e255;published_with_changes:f232;push_pin:f10d;qr_code:ef6b;qr_code_2:e00a;qr_code_scanner:f206;query_builder:e8ae;question_answer:e8af;queue:e03c;queue_music:e03d;queue_play_next:e066;quick_contacts_dialer:e0cf;quick_contacts_mail:e0d0;quickreply:ef6c;radio:e03e;radio_button_checked:e837;radio_button_off:e836;radio_button_on:e837;radio_button_unchecked:e836;rate_review:e560;read_more:ef6d;receipt:e8b0;receipt_long:ef6e;recent_actors:e03f;record_voice_over:e91f;redeem:e8b1;redo:e15a;reduce_capacity:f21c;refresh:e5d5;remove:e15b;remove_circle:e15c;remove_circle_outline:e15d;remove_from_queue:e067;remove_red_eye:e417;remove_shopping_cart:e928;reorder:e8fe;repeat:e040;repeat_one:e041;replay:e042;replay_10:e059;replay_30:e05a;replay_5:e05b;reply:e15e;reply_all:e15f;report:e160;report_gmailerrorred:f052;report_off:e170;report_problem:e8b2;request_page:f22c;request_quote:f1b6;restaurant:e56c;restaurant_menu:e561;restore:e8b3;restore_from_trash:e938;restore_page:e929;rice_bowl:f1f5;ring_volume:e0d1;roofing:f201;room:e8b4;room_preferences:f1b8;room_service:eb49;rotate_90_degrees_ccw:e418;rotate_left:e419;rotate_right:e41a;rounded_corner:e920;router:e328;rowing:e921;rss_feed:e0e5;rule:f1c2;rule_folder:f1c9;run_circle:ef6f;rv_hookup:e642;sanitizer:f21d;satellite:e562;save:e161;save_alt:e171;scanner:e329;scatter_plot:e268;schedule:e8b5;school:e80c;science:ea4b;score:e269;screen_lock_landscape:e1be;screen_lock_portrait:e1bf;screen_lock_rotation:e1c0;screen_rotation:e1c1;screen_share:e0e2;sd_card:e623;sd_card_alert:f057;sd_storage:e1c2;search:e8b6;search_off:ea76;security:e32a;select_all:e162;self_improvement:ea78;send:e163;sensor_door:f1b5;sensor_window:f1b4;sentiment_dissatisfied:e811;sentiment_neutral:e812;sentiment_satisfied:e813;sentiment_satisfied_alt:e0ed;sentiment_very_dissatisfied:e814;sentiment_very_satisfied:e815;set_meal:f1ea;settings:e8b8;settings_applications:e8b9;settings_backup_restore:e8ba;settings_bluetooth:e8bb;settings_brightness:e8bd;settings_cell:e8bc;settings_display:e8bd;settings_ethernet:e8be;settings_input_antenna:e8bf;settings_input_component:e8c0;settings_input_composite:e8c1;settings_input_hdmi:e8c2;settings_input_svideo:e8c3;settings_overscan:e8c4;settings_phone:e8c5;settings_power:e8c6;settings_remote:e8c7;settings_system_daydream:e1c3;settings_voice:e8c8;share:e80d;shop:e8c9;shop_two:e8ca;shopping_bag:f1cc;shopping_basket:e8cb;shopping_cart:e8cc;short_text:e261;show_chart:e6e1;shuffle:e043;shutter_speed:e43d;sick:f220;signal_cellular_4_bar:e1c8;signal_cellular_alt:e202;signal_cellular_connected_no_internet_4_bar:e1cd;signal_cellular_no_sim:e1ce;signal_cellular_null:e1cf;signal_cellular_off:e1d0;signal_wifi_4_bar:e1d8;signal_wifi_4_bar_lock:e1d9;signal_wifi_off:e1da;sim_card:e32b;single_bed:ea48;skip_next:e044;skip_previous:e045;slideshow:e41b;slow_motion_video:e068;smart_button:f1c1;smartphone:e32c;smoke_free:eb4a;smoking_rooms:eb4b;sms:e625;sms_failed:e626;snippet_folder:f1c7;snooze:e046;soap:f1b2;sort:e164;sort_by_alpha:e053;source:f1c4;south:f1e3;south_east:f1e4;south_west:f1e5;spa:eb4c;space_bar:e256;speaker:e32d;speaker_group:e32e;speaker_notes:e8cd;speaker_notes_off:e92a;speaker_phone:e0d2;speed:e9e4;spellcheck:e8ce;sports:ea30;sports_bar:f1f3;sports_baseball:ea51;sports_basketball:ea26;sports_cricket:ea27;sports_esports:ea28;sports_football:ea29;sports_golf:ea2a;sports_handball:ea33;sports_hockey:ea2b;sports_kabaddi:ea34;sports_mma:ea2c;sports_motorsports:ea2d;sports_rugby:ea2e;sports_soccer:ea2f;sports_tennis:ea32;sports_volleyball:ea31;square_foot:ea49;stacked_line_chart:f22b;stairs:f1a9;star:e838;star_border:e83a;star_border_purple500:f099;star_half:e839;star_outline:f06f;star_purple500:f09a;star_rate:f0ec;stars:e8d0;stay_current_landscape:e0d3;stay_current_portrait:e0d4;stay_primary_landscape:e0d5;stay_primary_portrait:e0d6;sticky_note_2:f1fc;stop:e047;stop_circle:ef71;stop_screen_share:e0e3;storage:e1db;store:e8d1;store_mall_directory:e563;storefront:ea12;straighten:e41c;streetview:e56e;strikethrough_s:e257;stroller:f1ae;style:e41d;subdirectory_arrow_left:e5d9;subdirectory_arrow_right:e5da;subject:e8d2;subscript:f111;subscriptions:e064;subtitles:e048;subtitles_off:ef72;subway:e56f;superscript:f112;supervised_user_circle:e939;supervisor_account:e8d3;support:ef73;support_agent:f0e2;surround_sound:e049;swap_calls:e0d7;swap_horiz:e8d4;swap_horizontal_circle:e933;swap_vert:e8d5;swap_vert_circle:e8d6;swap_vertical_circle:e8d6;switch_camera:e41e;switch_left:f1d1;switch_right:f1d2;switch_video:e41f;sync:e627;sync_alt:ea18;sync_disabled:e628;sync_problem:e629;system_update:e62a;system_update_alt:e8d7;system_update_tv:e8d7;tab:e8d8;tab_unselected:e8d9;table_chart:e265;table_rows:f101;table_view:f1be;tablet:e32f;tablet_android:e330;tablet_mac:e331;tag_faces:e420;tap_and_play:e62b;tapas:f1e9;terrain:e564;text_fields:e262;text_format:e165;text_rotate_up:e93a;text_rotate_vertical:e93b;text_rotation_angledown:e93c;text_rotation_angleup:e93d;text_rotation_down:e93e;text_rotation_none:e93f;text_snippet:f1c6;textsms:e0d8;texture:e421;theaters:e8da;thermostat:f076;thumb_down:e8db;thumb_down_alt:e816;thumb_up:e8dc;thumb_up_alt:e817;thumbs_up_down:e8dd;time_to_leave:e62c;timelapse:e422;timeline:e922;timer:e425;timer_10:e423;timer_3:e424;timer_off:e426;title:e264;toc:e8de;today:e8df;toggle_off:e9f5;toggle_on:e9f6;toll:e8e0;tonality:e427;topic:f1c8;touch_app:e913;tour:ef75;toys:e332;track_changes:e8e1;traffic:e565;train:e570;tram:e571;transfer_within_a_station:e572;transform:e428;transit_enterexit:e579;translate:e8e2;trending_down:e8e3;trending_flat:e8e4;trending_neutral:e8e4;trending_up:e8e5;trip_origin:e57b;tty:f1aa;tune:e429;turned_in:e8e6;turned_in_not:e8e7;tv:e333;tv_off:e647;two_wheeler:e9f9;umbrella:f1ad;unarchive:e169;undo:e166;unfold_less:e5d6;unfold_more:e5d7;unpublished:f236;unsubscribe:e0eb;update:e923;update_disabled:e075;upgrade:f0fb;upload:f09b;usb:e1e0;verified:ef76;verified_user:e8e8;vertical_align_bottom:e258;vertical_align_center:e259;vertical_align_top:e25a;vertical_distribute:e076;vertical_split:e949;vibration:e62d;video_call:e070;video_collection:e04a;video_label:e071;video_library:e04a;video_settings:ea75;videocam:e04b;videocam_off:e04c;videogame_asset:e338;view_agenda:e8e9;view_array:e8ea;view_carousel:e8eb;view_column:e8ec;view_comfortable:e42a;view_comfy:e42a;view_compact:e42b;view_day:e8ed;view_headline:e8ee;view_list:e8ef;view_module:e8f0;view_quilt:e8f1;view_sidebar:f114;view_stream:e8f2;view_week:e8f3;vignette:e435;visibility:e8f4;visibility_off:e8f5;voice_chat:e62e;voice_over_off:e94a;voicemail:e0d9;volume_down:e04d;volume_mute:e04e;volume_off:e04f;volume_up:e050;vpn_key:e0da;vpn_lock:e62f;wallet_giftcard:e8f6;wallet_membership:e8f7;wallet_travel:e8f8;wallpaper:e1bc;warning:e002;warning_amber:f083;wash:f1b1;watch:e334;watch_later:e924;water_damage:f203;waves:e176;wb_auto:e42c;wb_cloudy:e42d;wb_incandescent:e42e;wb_iridescent:e436;wb_sunny:e430;wc:e63d;web:e051;web_asset:e069;weekend:e16b;west:f1e6;whatshot:e80e;wheelchair_pickup:f1ab;where_to_vote:e177;widgets:e1bd;wifi:e63e;wifi_calling:ef77;wifi_lock:e1e1;wifi_off:e648;wifi_protected_setup:f0fc;wifi_tethering:e1e2;wine_bar:f1e8;work:e8f9;work_off:e942;work_outline:e943;wrap_text:e25b;wrong_location:ef78;wysiwyg:f1c3;youtube_searched_for:e8fa;zoom_in:e8ff;zoom_out:e900;zoom_out_map:e56b"
        },
        {
            name: "materialIconsSharp",
            cssClass: "material-icons-sharp",
            keyList: "360:e577;3d_rotation:e84d;4k:e072;5g:ef38;6_ft_apart:f21e;ac_unit:eb3b;access_alarm:e190;access_alarms:e191;access_time:e192;accessibility:e84e;accessibility_new:e92c;accessible:e914;accessible_forward:e934;account_balance:e84f;account_balance_wallet:e850;account_box:e851;account_circle:e853;account_tree:e97a;ad_units:ef39;adb:e60e;add:e145;add_a_photo:e439;add_alarm:e193;add_alert:e003;add_box:e146;add_business:e729;add_circle:e147;add_circle_outline:e148;add_comment:e266;add_ic_call:e97c;add_location:e567;add_location_alt:ef3a;add_photo_alternate:e43e;add_road:ef3b;add_shopping_cart:e854;add_task:f23a;add_to_home_screen:e1fe;add_to_photos:e39d;add_to_queue:e05c;addchart:ef3c;adjust:e39e;admin_panel_settings:ef3d;agriculture:ea79;airline_seat_flat:e630;airline_seat_flat_angled:e631;airline_seat_individual_suite:e632;airline_seat_legroom_extra:e633;airline_seat_legroom_normal:e634;airline_seat_legroom_reduced:e635;airline_seat_recline_extra:e636;airline_seat_recline_normal:e637;airplanemode_active:e195;airplanemode_inactive:e194;airplanemode_off:e194;airplanemode_on:e195;airplay:e055;airport_shuttle:eb3c;alarm:e855;alarm_add:e856;alarm_off:e857;alarm_on:e858;album:e019;align_horizontal_center:e00f;align_horizontal_left:e00d;align_horizontal_right:e010;align_vertical_bottom:e015;align_vertical_center:e011;align_vertical_top:e00c;all_inbox:e97f;all_inclusive:eb3d;all_out:e90b;alt_route:f184;alternate_email:e0e6;amp_stories:ea13;analytics:ef3e;anchor:f1cd;android:e859;announcement:e85a;apartment:ea40;api:f1b7;app_blocking:ef3f;app_settings_alt:ef41;apps:e5c3;architecture:ea3b;archive:e149;arrow_back:e5c4;arrow_back_ios:e5e0;arrow_circle_down:f181;arrow_circle_up:f182;arrow_downward:e5db;arrow_drop_down:e5c5;arrow_drop_down_circle:e5c6;arrow_drop_up:e5c7;arrow_forward:e5c8;arrow_forward_ios:e5e1;arrow_left:e5de;arrow_right:e5df;arrow_right_alt:e941;arrow_upward:e5d8;art_track:e060;article:ef42;aspect_ratio:e85b;assessment:e85c;assignment:e85d;assignment_ind:e85e;assignment_late:e85f;assignment_return:e860;assignment_returned:e861;assignment_turned_in:e862;assistant:e39f;assistant_photo:e3a0;atm:e573;attach_email:ea5e;attach_file:e226;attach_money:e227;attachment:e2bc;attribution:efdb;audiotrack:e3a1;auto_delete:ea4c;autorenew:e863;av_timer:e01b;baby_changing_station:f19b;backpack:f19c;backspace:e14a;backup:e864;backup_table:ef43;ballot:e172;bar_chart:e26b;batch_prediction:f0f5;bathtub:ea41;battery_alert:e19c;battery_charging_full:e1a3;battery_full:e1a4;battery_std:e1a5;battery_unknown:e1a6;beach_access:eb3e;bedtime:ef44;beenhere:e52d;bento:f1f4;bike_scooter:ef45;biotech:ea3a;block:e14b;bluetooth:e1a7;bluetooth_audio:e60f;bluetooth_connected:e1a8;bluetooth_disabled:e1a9;bluetooth_searching:e1aa;blur_circular:e3a2;blur_linear:e3a3;blur_off:e3a4;blur_on:e3a5;book:e865;book_online:f217;bookmark:e866;bookmark_border:e867;bookmark_outline:e867;bookmarks:e98b;border_all:e228;border_bottom:e229;border_clear:e22a;border_horizontal:e22c;border_inner:e22d;border_left:e22e;border_outer:e22f;border_right:e230;border_style:e231;border_top:e232;border_vertical:e233;branding_watermark:e06b;brightness_1:e3a6;brightness_2:e3a7;brightness_3:e3a8;brightness_4:e3a9;brightness_5:e3aa;brightness_6:e3ab;brightness_7:e3ac;brightness_auto:e1ab;brightness_high:e1ac;brightness_low:e1ad;brightness_medium:e1ae;broken_image:e3ad;browser_not_supported:ef47;brush:e3ae;bubble_chart:e6dd;bug_report:e868;build:e869;build_circle:ef48;burst_mode:e43c;business:e0af;business_center:eb3f;cached:e86a;cake:e7e9;calculate:ea5f;calendar_today:e935;calendar_view_day:e936;call:e0b0;call_end:e0b1;call_made:e0b2;call_merge:e0b3;call_missed:e0b4;call_missed_outgoing:e0e4;call_received:e0b5;call_split:e0b6;call_to_action:e06c;camera:e3af;camera_alt:e3b0;camera_enhance:e8fc;camera_front:e3b1;camera_rear:e3b2;camera_roll:e3b3;campaign:ef49;cancel:e5c9;cancel_presentation:e0e9;cancel_schedule_send:ea39;card_giftcard:e8f6;card_membership:e8f7;card_travel:e8f8;carpenter:f1f8;casino:eb40;cast:e307;cast_connected:e308;cast_for_education:efec;category:e574;center_focus_strong:e3b4;center_focus_weak:e3b5;change_history:e86b;charging_station:f19d;chat:e0b7;chat_bubble:e0ca;chat_bubble_outline:e0cb;check:e5ca;check_box:e834;check_box_outline_blank:e835;check_circle:e86c;check_circle_outline:e92d;checkroom:f19e;chevron_left:e5cb;chevron_right:e5cc;child_care:eb41;child_friendly:eb42;chrome_reader_mode:e86d;class:e86e;clean_hands:f21f;cleaning_services:f0ff;clear:e14c;clear_all:e0b8;close:e5cd;close_fullscreen:f1cf;closed_caption:e01c;closed_caption_disabled:f1dc;cloud:e2bd;cloud_circle:e2be;cloud_done:e2bf;cloud_download:e2c0;cloud_off:e2c1;cloud_queue:e2c2;cloud_upload:e2c3;code:e86f;collections:e3b6;collections_bookmark:e431;color_lens:e3b7;colorize:e3b8;comment:e0b9;comment_bank:ea4e;commute:e940;compare:e3b9;compare_arrows:e915;compass_calibration:e57c;computer:e30a;confirmation_num:e638;confirmation_number:e638;connect_without_contact:f223;construction:ea3c;contact_mail:e0d0;contact_page:f22e;contact_phone:e0cf;contact_support:e94c;contactless:ea71;contacts:e0ba;content_copy:f08a;content_cut:f08b;content_paste:f098;control_camera:e074;control_point:e3ba;control_point_duplicate:e3bb;copy:f08a;copyright:e90c;coronavirus:f221;corporate_fare:f1d0;countertops:f1f7;create:e150;create_new_folder:e2cc;credit_card:e870;crop:e3be;crop_16_9:e3bc;crop_3_2:e3bd;crop_5_4:e3bf;crop_7_5:e3c0;crop_din:e3c1;crop_free:e3c2;crop_landscape:e3c3;crop_original:e3c4;crop_portrait:e3c5;crop_rotate:e437;crop_square:e3c6;cut:f08b;dashboard:e871;data_usage:e1af;date_range:e916;deck:ea42;dehaze:e3c7;delete:e872;delete_forever:e92b;delete_outline:e92e;delete_sweep:e16c;departure_board:e576;description:e873;design_services:f10a;desktop_access_disabled:e99d;desktop_mac:e30b;desktop_windows:e30c;details:e3c8;developer_board:e30d;developer_mode:e1b0;device_hub:e335;device_unknown:e339;devices:e1b1;devices_other:e337;dialer_sip:e0bb;dialpad:e0bc;directions:e52e;directions_bike:e52f;directions_boat:e532;directions_bus:e530;directions_car:e531;directions_ferry:e532;directions_off:f10f;directions_railway:e534;directions_run:e566;directions_subway:e533;directions_train:e534;directions_transit:e535;directions_walk:e536;disabled_by_default:f230;disc_full:e610;dns:e875;do_disturb:f08c;do_disturb_alt:f08d;do_disturb_off:f08e;do_disturb_on:f08f;do_not_step:f19f;do_not_touch:f1b0;dock:e30e;domain:e7ee;domain_disabled:e0ef;domain_verification:ef4c;done:e876;done_all:e877;done_outline:e92f;donut_large:e917;donut_small:e918;double_arrow:ea50;download:f090;download_done:f091;drafts:e151;drag_handle:e25d;drag_indicator:e945;drive_eta:e613;dry:f1b3;duo:e9a5;dvr:e1b2;dynamic_feed:ea14;dynamic_form:f1bf;east:f1df;eco:ea35;edit:e3c9;edit_attributes:e578;edit_location:e568;edit_road:ef4d;eject:e8fb;elderly:f21a;electric_bike:eb1b;electric_car:eb1c;electric_moped:eb1d;electric_rickshaw:eb1e;electric_scooter:eb1f;electrical_services:f102;elevator:f1a0;email:e0be;emoji_emotions:ea22;emoji_events:ea23;emoji_flags:ea1a;emoji_food_beverage:ea1b;emoji_nature:ea1c;emoji_objects:ea24;emoji_people:ea1d;emoji_symbols:ea1e;emoji_transportation:ea1f;engineering:ea3d;enhance_photo_translate:e8fc;enhanced_encryption:e63f;equalizer:e01d;error:e000;error_outline:e001;escalator:f1a1;escalator_warning:f1ac;euro:ea15;euro_symbol:e926;ev_station:e56d;event:e878;event_available:e614;event_busy:e615;event_note:e616;event_seat:e903;exit_to_app:e879;expand_less:e5ce;expand_more:e5cf;explicit:e01e;explore:e87a;explore_off:e9a8;exposure:e3ca;exposure_minus_1:e3cb;exposure_minus_2:e3cc;exposure_neg_1:e3cb;exposure_neg_2:e3cc;exposure_plus_1:e3cd;exposure_plus_2:e3ce;exposure_zero:e3cf;extension:e87b;face:e87c;face_unlock:f008;facebook:f234;fact_check:f0c5;family_restroom:f1a2;fast_forward:e01f;fast_rewind:e020;fastfood:e57a;favorite:e87d;favorite_border:e87e;favorite_outline:e87e;featured_play_list:e06d;featured_video:e06e;feedback:e87f;fence:f1f6;fiber_dvr:e05d;fiber_manual_record:e061;fiber_new:e05e;fiber_pin:e06a;fiber_smart_record:e062;file_copy:e173;filter:e3d3;filter_1:e3d0;filter_2:e3d1;filter_3:e3d2;filter_4:e3d4;filter_5:e3d5;filter_6:e3d6;filter_7:e3d7;filter_8:e3d8;filter_9:e3d9;filter_9_plus:e3da;filter_alt:ef4f;filter_b_and_w:e3db;filter_center_focus:e3dc;filter_drama:e3dd;filter_frames:e3de;filter_hdr:e3df;filter_list:e152;filter_none:e3e0;filter_tilt_shift:e3e2;filter_vintage:e3e3;find_in_page:e880;find_replace:e881;fingerprint:e90d;fire_extinguisher:f1d8;fireplace:ea43;first_page:e5dc;fitness_center:eb43;flag:e153;flaky:ef50;flare:e3e4;flash_auto:e3e5;flash_off:e3e6;flash_on:e3e7;flight:e539;flight_land:e904;flight_takeoff:e905;flip:e3e8;flip_camera_android:ea37;flip_camera_ios:ea38;flip_to_back:e882;flip_to_front:e883;folder:e2c7;folder_open:e2c8;folder_shared:e2c9;folder_special:e617;follow_the_signs:f222;font_download:e167;food_bank:f1f2;format_align_center:e234;format_align_justify:e235;format_align_left:e236;format_align_right:e237;format_bold:e238;format_clear:e239;format_color_reset:e23b;format_indent_decrease:e23d;format_indent_increase:e23e;format_italic:e23f;format_line_spacing:e240;format_list_bulleted:e241;format_list_numbered:e242;format_list_numbered_rtl:e267;format_paint:e243;format_quote:e244;format_shapes:e25e;format_size:e245;format_strikethrough:e246;format_textdirection_l_to_r:e247;format_textdirection_r_to_l:e248;format_underline:e249;format_underlined:e249;forum:e0bf;forward:e154;forward_10:e056;forward_30:e057;forward_5:e058;forward_to_inbox:f187;foundation:f200;free_breakfast:eb44;fullscreen:e5d0;fullscreen_exit:e5d1;functions:e24a;g_translate:e927;gamepad:e30f;games:e021;gavel:e90e;gesture:e155;get_app:e884;gif:e908;golf_course:eb45;gps_fixed:e1b3;gps_not_fixed:e1b4;gps_off:e1b5;grade:e885;gradient:e3e9;grading:ea4f;grain:e3ea;graphic_eq:e1b8;grass:f205;grid_off:e3eb;grid_on:e3ec;group:e7ef;group_add:e7f0;group_work:e886;groups:f233;handyman:f10b;hd:e052;hdr_off:e3ed;hdr_on:e3ee;hdr_strong:e3f1;hdr_weak:e3f2;headset:e310;headset_mic:e311;healing:e3f3;hearing:e023;hearing_disabled:f104;height:ea16;help:e887;help_center:f1c0;help_outline:e8fd;high_quality:e024;highlight:e25f;highlight_alt:ef52;highlight_off:e888;highlight_remove:e888;history:e889;history_edu:ea3e;history_toggle_off:f17d;home:e88a;home_repair_service:f100;home_work:ea09;horizontal_distribute:e014;horizontal_rule:f108;horizontal_split:e947;hot_tub:eb46;hotel:e53a;hourglass_bottom:ea5c;hourglass_disabled:ef53;hourglass_empty:e88b;hourglass_full:e88c;hourglass_top:ea5b;house:ea44;house_siding:f202;how_to_reg:e174;how_to_vote:e175;http:e902;https:e88d;hvac:f10e;image:e3f4;image_aspect_ratio:e3f5;image_not_supported:f116;image_search:e43f;import_contacts:e0e0;import_export:e0c3;important_devices:e912;inbox:e156;indeterminate_check_box:e909;info:e88e;info_outline:e88f;input:e890;insert_chart:e24b;insert_chart_outlined:e26a;insert_comment:e24c;insert_drive_file:e24d;insert_emoticon:e24e;insert_invitation:e24f;insert_link:e250;insert_photo:e251;insights:f092;integration_instructions:ef54;invert_colors:e891;invert_colors_off:e0c4;invert_colors_on:e891;iso:e3f6;keyboard:e312;keyboard_arrow_down:e313;keyboard_arrow_left:e314;keyboard_arrow_right:e315;keyboard_arrow_up:e316;keyboard_backspace:e317;keyboard_capslock:e318;keyboard_control:e5d3;keyboard_hide:e31a;keyboard_return:e31b;keyboard_tab:e31c;keyboard_voice:e31d;king_bed:ea45;kitchen:eb47;label:e892;label_important:e937;label_important_outline:e948;label_off:e9b6;label_outline:e893;landscape:e3f7;language:e894;laptop:e31e;laptop_chromebook:e31f;laptop_mac:e320;laptop_windows:e321;last_page:e5dd;launch:e895;layers:e53b;layers_clear:e53c;leaderboard:f20c;leak_add:e3f8;leak_remove:e3f9;leave_bags_at_home:f23b;legend_toggle:f11b;lens:e3fa;library_add:e02e;library_add_check:e9b7;library_books:e02f;library_music:e030;lightbulb_outline:e90f;line_style:e919;line_weight:e91a;linear_scale:e260;link:e157;link_off:e16f;linked_camera:e438;list:e896;list_alt:e0ee;live_help:e0c6;live_tv:e639;local_activity:e53f;local_airport:e53d;local_atm:e53e;local_attraction:e53f;local_bar:e540;local_cafe:e541;local_car_wash:e542;local_convenience_store:e543;local_dining:e556;local_drink:e544;local_fire_department:ef55;local_florist:e545;local_gas_station:e546;local_grocery_store:e547;local_hospital:e548;local_hotel:e549;local_laundry_service:e54a;local_library:e54b;local_mall:e54c;local_movies:e54d;local_offer:e54e;local_parking:e54f;local_pharmacy:e550;local_phone:e551;local_pizza:e552;local_play:e553;local_police:ef56;local_post_office:e554;local_print_shop:e555;local_printshop:e555;local_restaurant:e556;local_see:e557;local_shipping:e558;local_taxi:e559;location_city:e7f1;location_disabled:e1b6;location_history:e55a;location_off:e0c7;location_on:e0c8;location_searching:e1b7;lock:e897;lock_open:e898;lock_outline:e899;login:ea77;looks:e3fc;looks_3:e3fb;looks_4:e3fd;looks_5:e3fe;looks_6:e3ff;looks_one:e400;looks_two:e401;loop:e028;loupe:e402;low_priority:e16d;loyalty:e89a;luggage:f235;mail:e158;mail_outline:e0e1;map:e55b;maps_ugc:ef58;mark_chat_read:f18b;mark_chat_unread:f189;mark_email_read:f18c;mark_email_unread:f18a;markunread:e159;markunread_mailbox:e89b;masks:f218;maximize:e930;mediation:efa7;medical_services:f109;meeting_room:eb4f;memory:e322;menu:e5d2;menu_book:ea19;menu_open:e9bd;merge_type:e252;message:e0c9;messenger:e0ca;messenger_outline:e0cb;mic:e029;mic_none:e02a;mic_off:e02b;microwave:f204;military_tech:ea3f;minimize:e931;miscellaneous_services:f10c;missed_video_call:e073;mms:e618;mobile_friendly:e200;mobile_off:e201;mobile_screen_share:e0e7;mode:f097;mode_comment:e253;model_training:f0cf;monetization_on:e263;money:e57d;money_off:e25c;money_off_csred:f038;monochrome_photos:e403;mood:e7f2;mood_bad:e7f3;moped:eb28;more:e619;more_horiz:e5d3;more_time:ea5d;more_vert:e5d4;motion_photos_on:e9c1;motion_photos_pause:f227;motion_photos_paused:e9c2;motorcycle:e91b;mouse:e323;move_to_inbox:e168;movie:e02c;movie_creation:e404;movie_filter:e43a;multiline_chart:e6df;multiple_stop:f1b9;multitrack_audio:e1b8;museum:ea36;music_note:e405;music_off:e440;music_video:e063;my_library_add:e02e;my_library_books:e02f;my_library_music:e030;my_location:e55c;nat:ef5c;nature:e406;nature_people:e407;navigate_before:e408;navigate_next:e409;navigation:e55d;near_me:e569;near_me_disabled:f1ef;network_check:e640;network_locked:e61a;new_releases:e031;next_plan:ef5d;next_week:e16a;nfc:e1bb;night_shelter:f1f1;nights_stay:ea46;no_backpack:f237;no_cell:f1a4;no_drinks:f1a5;no_encryption:e641;no_encryption_gmailerrorred:f03f;no_flash:f1a6;no_food:f1a7;no_luggage:f23b;no_meals:f1d6;no_meeting_room:eb4e;no_photography:f1a8;no_sim:e0cc;no_stroller:f1af;no_transfer:f1d5;north:f1e0;north_east:f1e1;north_west:f1e2;not_accessible:f0fe;not_interested:e033;not_listed_location:e575;not_started:f0d1;note:e06f;note_add:e89c;notes:e26c;notification_important:e004;notifications:e7f4;notifications_active:e7f7;notifications_none:e7f5;notifications_off:e7f6;notifications_on:e7f7;notifications_paused:e7f8;now_wallpaper:e1bc;now_widgets:e1bd;offline_bolt:e932;offline_pin:e90a;ondemand_video:e63a;online_prediction:f0eb;opacity:e91c;open_in_browser:e89d;open_in_full:f1ce;open_in_new:e89e;open_with:e89f;outbond:f228;outdoor_grill:ea47;outlet:f1d4;outlined_flag:e16e;pages:e7f9;pageview:e8a0;palette:e40a;pan_tool:e925;panorama:e40b;panorama_fish_eye:e40c;panorama_fisheye:e40c;panorama_horizontal:e40d;panorama_vertical:e40e;panorama_wide_angle:e40f;party_mode:e7fa;paste:f098;pause:e034;pause_circle_filled:e035;pause_circle_outline:e036;pause_presentation:e0ea;payment:e8a1;payments:ef63;pedal_bike:eb29;pending:ef64;pending_actions:f1bb;people:e7fb;people_alt:ea21;people_outline:e7fc;perm_camera_mic:e8a2;perm_contact_cal:e8a3;perm_contact_calendar:e8a3;perm_data_setting:e8a4;perm_device_info:e8a5;perm_device_information:e8a5;perm_identity:e8a6;perm_media:e8a7;perm_phone_msg:e8a8;perm_scan_wifi:e8a9;person:e7fd;person_add:e7fe;person_add_alt_1:ef65;person_add_disabled:e9cb;person_outline:e7ff;person_pin:e55a;person_pin_circle:e56a;person_remove:ef66;person_remove_alt_1:ef67;person_search:f106;personal_video:e63b;pest_control:f0fa;pest_control_rodent:f0fd;pets:e91d;phone:e0cd;phone_android:e324;phone_bluetooth_speaker:e61b;phone_callback:e649;phone_disabled:e9cc;phone_enabled:e9cd;phone_forwarded:e61c;phone_in_talk:e61d;phone_iphone:e325;phone_locked:e61e;phone_missed:e61f;phone_paused:e620;phonelink:e326;phonelink_erase:e0db;phonelink_lock:e0dc;phonelink_off:e327;phonelink_ring:e0dd;phonelink_setup:e0de;photo:e410;photo_album:e411;photo_camera:e412;photo_filter:e43b;photo_library:e413;photo_size_select_actual:e432;photo_size_select_large:e433;photo_size_select_small:e434;picture_as_pdf:e415;picture_in_picture:e8aa;picture_in_picture_alt:e911;pie_chart:e6c4;pie_chart_outline:f044;pin_drop:e55e;place:e55f;plagiarism:ea5a;play_arrow:e037;play_circle_fill:e038;play_circle_filled:e038;play_circle_outline:e039;play_for_work:e906;playlist_add:e03b;playlist_add_check:e065;playlist_play:e05f;plumbing:f107;plus_one:e800;point_of_sale:f17e;policy:ea17;poll:e801;polymer:e8ab;pool:eb48;portable_wifi_off:e0ce;portrait:e416;post_add:ea20;power:e63c;power_input:e336;power_off:e646;power_settings_new:e8ac;precision_manufacturing:f049;pregnant_woman:e91e;present_to_all:e0df;preview:f1c5;print:e8ad;print_disabled:e9cf;priority_high:e645;privacy_tip:f0dc;psychology:ea4a;public:e80b;public_off:f1ca;publish:e255;published_with_changes:f232;push_pin:f10d;qr_code:ef6b;qr_code_2:e00a;qr_code_scanner:f206;query_builder:e8ae;question_answer:e8af;queue:e03c;queue_music:e03d;queue_play_next:e066;quick_contacts_dialer:e0cf;quick_contacts_mail:e0d0;quickreply:ef6c;radio:e03e;radio_button_checked:e837;radio_button_off:e836;radio_button_on:e837;radio_button_unchecked:e836;rate_review:e560;read_more:ef6d;receipt:e8b0;receipt_long:ef6e;recent_actors:e03f;record_voice_over:e91f;redeem:e8b1;redo:e15a;reduce_capacity:f21c;refresh:e5d5;remove:e15b;remove_circle:e15c;remove_circle_outline:e15d;remove_from_queue:e067;remove_red_eye:e417;remove_shopping_cart:e928;reorder:e8fe;repeat:e040;repeat_one:e041;replay:e042;replay_10:e059;replay_30:e05a;replay_5:e05b;reply:e15e;reply_all:e15f;report:e160;report_gmailerrorred:f052;report_off:e170;report_problem:e8b2;request_page:f22c;request_quote:f1b6;restaurant:e56c;restaurant_menu:e561;restore:e8b3;restore_from_trash:e938;restore_page:e929;rice_bowl:f1f5;ring_volume:e0d1;roofing:f201;room:e8b4;room_preferences:f1b8;room_service:eb49;rotate_90_degrees_ccw:e418;rotate_left:e419;rotate_right:e41a;rounded_corner:e920;router:e328;rowing:e921;rss_feed:e0e5;rule:f1c2;rule_folder:f1c9;run_circle:ef6f;rv_hookup:e642;sanitizer:f21d;satellite:e562;save:e161;save_alt:e171;scanner:e329;scatter_plot:e268;schedule:e8b5;school:e80c;science:ea4b;score:e269;screen_lock_landscape:e1be;screen_lock_portrait:e1bf;screen_lock_rotation:e1c0;screen_rotation:e1c1;screen_share:e0e2;sd_card:e623;sd_card_alert:f057;sd_storage:e1c2;search:e8b6;search_off:ea76;security:e32a;select_all:e162;self_improvement:ea78;send:e163;sensor_door:f1b5;sensor_window:f1b4;sentiment_dissatisfied:e811;sentiment_satisfied:e813;sentiment_satisfied_alt:e0ed;sentiment_very_dissatisfied:e814;sentiment_very_satisfied:e815;set_meal:f1ea;settings:e8b8;settings_applications:e8b9;settings_backup_restore:e8ba;settings_bluetooth:e8bb;settings_brightness:e8bd;settings_cell:e8bc;settings_display:e8bd;settings_ethernet:e8be;settings_input_antenna:e8bf;settings_input_component:e8c0;settings_input_composite:e8c1;settings_input_hdmi:e8c2;settings_input_svideo:e8c3;settings_overscan:e8c4;settings_phone:e8c5;settings_power:e8c6;settings_remote:e8c7;settings_system_daydream:e1c3;settings_voice:e8c8;share:e80d;shop:e8c9;shop_two:e8ca;shopping_bag:f1cc;shopping_basket:e8cb;shopping_cart:e8cc;short_text:e261;show_chart:e6e1;shuffle:e043;shutter_speed:e43d;sick:f220;signal_cellular_4_bar:e1c8;signal_cellular_alt:e202;signal_cellular_connected_no_internet_4_bar:e1cd;signal_cellular_no_sim:e1ce;signal_cellular_null:e1cf;signal_cellular_off:e1d0;signal_wifi_4_bar:e1d8;signal_wifi_4_bar_lock:e1d9;signal_wifi_off:e1da;sim_card:e32b;single_bed:ea48;skip_next:e044;skip_previous:e045;slideshow:e41b;slow_motion_video:e068;smart_button:f1c1;smartphone:e32c;smoke_free:eb4a;smoking_rooms:eb4b;sms:e625;sms_failed:e626;snippet_folder:f1c7;snooze:e046;soap:f1b2;sort:e164;sort_by_alpha:e053;source:f1c4;south:f1e3;south_east:f1e4;south_west:f1e5;spa:eb4c;space_bar:e256;speaker:e32d;speaker_group:e32e;speaker_notes:e8cd;speaker_notes_off:e92a;speaker_phone:e0d2;speed:e9e4;spellcheck:e8ce;sports:ea30;sports_bar:f1f3;sports_baseball:ea51;sports_basketball:ea26;sports_cricket:ea27;sports_esports:ea28;sports_football:ea29;sports_golf:ea2a;sports_handball:ea33;sports_hockey:ea2b;sports_kabaddi:ea34;sports_mma:ea2c;sports_motorsports:ea2d;sports_rugby:ea2e;sports_soccer:ea2f;sports_tennis:ea32;sports_volleyball:ea31;square_foot:ea49;stacked_line_chart:f22b;stairs:f1a9;star:e838;star_border:e83a;star_border_purple500:f099;star_half:e839;star_outline:f06f;star_purple500:f09a;star_rate:f0ec;stars:e8d0;stay_current_landscape:e0d3;stay_current_portrait:e0d4;stay_primary_landscape:e0d5;stay_primary_portrait:e0d6;sticky_note_2:f1fc;stop:e047;stop_circle:ef71;stop_screen_share:e0e3;storage:e1db;store:e8d1;store_mall_directory:e563;storefront:ea12;straighten:e41c;streetview:e56e;strikethrough_s:e257;stroller:f1ae;style:e41d;subdirectory_arrow_left:e5d9;subdirectory_arrow_right:e5da;subject:e8d2;subscript:f111;subscriptions:e064;subtitles:e048;subtitles_off:ef72;subway:e56f;superscript:f112;supervised_user_circle:e939;supervisor_account:e8d3;support:ef73;support_agent:f0e2;surround_sound:e049;swap_calls:e0d7;swap_horiz:e8d4;swap_horizontal_circle:e933;swap_vert:e8d5;swap_vert_circle:e8d6;swap_vertical_circle:e8d6;switch_camera:e41e;switch_left:f1d1;switch_right:f1d2;switch_video:e41f;sync:e627;sync_alt:ea18;sync_disabled:e628;sync_problem:e629;system_update:e62a;system_update_alt:e8d7;system_update_tv:e8d7;tab:e8d8;tab_unselected:e8d9;table_chart:e265;table_rows:f101;table_view:f1be;tablet:e32f;tablet_android:e330;tablet_mac:e331;tag_faces:e420;tap_and_play:e62b;tapas:f1e9;terrain:e564;text_fields:e262;text_format:e165;text_rotate_up:e93a;text_rotate_vertical:e93b;text_rotation_angledown:e93c;text_rotation_angleup:e93d;text_rotation_down:e93e;text_rotation_none:e93f;text_snippet:f1c6;textsms:e0d8;texture:e421;theaters:e8da;thermostat:f076;thumb_down:e8db;thumb_down_alt:e816;thumb_up:e8dc;thumb_up_alt:e817;thumbs_up_down:e8dd;time_to_leave:e62c;timelapse:e422;timeline:e922;timer:e425;timer_10:e423;timer_3:e424;timer_off:e426;title:e264;toc:e8de;today:e8df;toggle_off:e9f5;toggle_on:e9f6;toll:e8e0;tonality:e427;topic:f1c8;touch_app:e913;tour:ef75;toys:e332;track_changes:e8e1;traffic:e565;train:e570;tram:e571;transfer_within_a_station:e572;transform:e428;transit_enterexit:e579;translate:e8e2;trending_down:e8e3;trending_flat:e8e4;trending_neutral:e8e4;trending_up:e8e5;trip_origin:e57b;tty:f1aa;tune:e429;turned_in:e8e6;turned_in_not:e8e7;tv:e333;tv_off:e647;two_wheeler:e9f9;umbrella:f1ad;unarchive:e169;undo:e166;unfold_less:e5d6;unfold_more:e5d7;unpublished:f236;unsubscribe:e0eb;update:e923;update_disabled:e075;upgrade:f0fb;upload:f09b;usb:e1e0;verified:ef76;verified_user:e8e8;vertical_align_bottom:e258;vertical_align_center:e259;vertical_align_top:e25a;vertical_distribute:e076;vertical_split:e949;vibration:e62d;video_call:e070;video_collection:e04a;video_label:e071;video_library:e04a;video_settings:ea75;videocam:e04b;videocam_off:e04c;videogame_asset:e338;view_agenda:e8e9;view_array:e8ea;view_carousel:e8eb;view_column:e8ec;view_comfortable:e42a;view_comfy:e42a;view_compact:e42b;view_day:e8ed;view_headline:e8ee;view_list:e8ef;view_module:e8f0;view_quilt:e8f1;view_sidebar:f114;view_stream:e8f2;view_week:e8f3;vignette:e435;visibility:e8f4;visibility_off:e8f5;voice_chat:e62e;voice_over_off:e94a;voicemail:e0d9;volume_down:e04d;volume_mute:e04e;volume_off:e04f;volume_up:e050;vpn_key:e0da;vpn_lock:e62f;wallet_giftcard:e8f6;wallet_membership:e8f7;wallet_travel:e8f8;wallpaper:e1bc;warning:e002;warning_amber:f083;wash:f1b1;watch:e334;watch_later:e924;water_damage:f203;waves:e176;wb_auto:e42c;wb_cloudy:e42d;wb_incandescent:e42e;wb_iridescent:e436;wb_sunny:e430;wc:e63d;web:e051;web_asset:e069;weekend:e16b;west:f1e6;whatshot:e80e;wheelchair_pickup:f1ab;where_to_vote:e177;widgets:e1bd;wifi:e63e;wifi_calling:ef77;wifi_lock:e1e1;wifi_off:e648;wifi_protected_setup:f0fc;wifi_tethering:e1e2;wine_bar:f1e8;work:e8f9;work_off:e942;work_outline:e943;wrap_text:e25b;wrong_location:ef78;wysiwyg:f1c3;youtube_searched_for:e8fa;zoom_in:e8ff;zoom_out:e900;zoom_out_map:e56b"
        }
    ],
    
    iconSet: "skin",

    // this is called lazily, from isc.Media methods that try to access stockIcons 
    initMedia : function (iconSet) {
        if (isc.Media.mediaInitialized) {
            // initMedia() can be called before the skin loads, so loadSkin() will call it again,
            // so the media from the skin is picked up
            // clear the current groups and standard blocks from several places
            isc.Media.clearStockIconGroups();
            if (isc.Canvas) isc.Canvas.standardActionIcons = null;
            if (isc.Window) isc.Window.standardHeaderIcons = null;
        }

        // legacy - apply filtered stockIcon lists to several framework classes
        isc.Media.addStockIconGroup("action", "Action Icons");
        if (isc.Canvas) {
            // make a copy of the "action" stockIcon group and alter the name-format from 
            // "Group_Icon" to just "Icon" - 13.0 uses the first of those formats for 
            // uniqueness; the latter format is for backcompat to pre-13.0 skins, which 
            // referred to these icons with their old names
            var icons = isc.Media.getStockIcons("action");
            var canvasIcons = [];
            icons.map(function (i) {
                var newIcon = { name: i.name.replace("Action_", ""), group: i.group, states: i.states };
                canvasIcons.add(newIcon);
            });
            isc.Canvas.addClassProperties({ standardActionIcons: canvasIcons });
        }

        isc.Media.addStockIconGroup("header", "Header Icons");
        if (isc.Window) {
            // make a copy of the "header" stockIcon group and alter the name-format from 
            // "Group_Icon" to just "Icon" - 13.0 uses the first of those formats for 
            // uniqueness; the latter format is for backcompat to pre-13.0 skins, which 
            // referred to these icons with their old names
            var icons = isc.Media.getStockIcons("header");
            var windowIcons = [];
            icons.map(function (i) {
                var newIcon = { name: i.name.replace("Header_", ""), group: i.group, states: i.states };
                windowIcons.add(newIcon);
            });
            isc.Window.addClassProperties({ standardHeaderIcons: windowIcons });
        }

        if (isc.Class && isc.Class.standardClassIcons) {
            if (!isc.Media.stardarClassIconsInitialized) {
                // Class is initialized before Media, so need to add its standardClassIcons 
                // entries to the stockIcon list, if they're present (Tools is loaded)
                isc.Media.stockIcons.addList(isc.Class.standardClassIcons);
                isc.Media.stardarClassIconsInitialized = true;
            }
            isc.Media.addStockIconGroup("classIcons", "Class Icons", null, "[TOOLSIMG]");
        }

        isc.Media.stockIconsMap = isc.Media.stockIcons.makeIndex("name");

        // regex for a non-blank string that doesn't start with a / or a [
        var regex = /^[^[/].+$/;
        
        // apply parsed "src" attributes to all the stockIcons
        for (var key in isc.Media.stockIconsMap) {
            var icon = isc.Media.stockIconsMap[key],
                group = isc.Media.stockIconGroupsMap[icon.group] || {},
                defaultExt = icon.group == "header" ? isc.Canvas.standardHeaderIconExtension : null
            ;

            var pSrc = icon.fromSrc || "";
            // all builtin stockIcons have a fromSrc that specifies either [SKINIMG], for skin
            // icons, or [TOOLSIMG] for the classIcons used in Reify and Skin Editor - so, if 
            // the fromSrc doesn't start with a / (not relative) or a [ (already has a prefix), 
            // it's a custom stockIcon with a relative path but no prefix.  It was presumably 
            // added by a developer, so assume it's relative to the appImgDir, [APPIMG]
            if (regex.test(pSrc)) {
                pSrc = icon.imgDir || (group.scImgURLPrefix || "[APPIMG]") + pSrc;

                if (defaultExt) {
                    pSrc = pSrc.substring(0, pSrc.indexOf(".")+1) + defaultExt;
                }
            }
            icon.parsedURL = pSrc;
            //icon.pageURL = isc.Page.getURL(pSrc);
            icon.expandedFromSrc = pSrc.length > 0 ? isc.Canvas.getImgURL(pSrc) : icon.src;
            
            // the icon may already have a default mapping set as icon.src - this means we can 
            // have stockIcons with a file-path that doesn't need to exist because the icon is 
            // already mapped to something else - for example, there are stickIcons called 
            // "Chevron_Up/Down/Left/Right", and they set src to a shared SVG sprite by 
            // default
            if (!icon.src) icon.src = icon.expandedFromSrc;
        }

        // rebuild various maps used for quick access
        isc.Media.rebuildMaps();

        isc.Media.mediaInitialized = true;

        // if passed an iconSet name, use it now
        if (iconSet && iconSet != "skin") isc.Media.useMedia(iconSet);

    },

    //> @classMethod Media.useMedia()
    // Installs an +link{object:IconSet, IconSet} by adding its list of 
    // +link{iconSet.stockIcons, custom stockIcons} and/or applying its set of 
    // +link{iconSet.mappings, stockIcon-mappings} that modify the images used by existing 
    // +link{object:StockIcon, stockIcons}.
    // <p>
    // Typically, this will take effect immediately with no further action by the developer.
    // @param iconSet (String | IconSet) a new +link{object:IconSet}, or the 
    //         +link{iconSet.name, name} of one previously +link{Media.addIconSet, registered}
    // @group stockIcons, media
    // @visibility external
    //<
    useMedia : function (iconSet, skipUpdate) {
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();

        var iconSetName = isc.isAn.Object(iconSet) ? iconSet.name : iconSet;

        if (isc.isA.String(iconSet)) {

            if (iconSetName != "skin") {
                // support for changing the weight of the existing stockIcons in Shiva
                // pass a value like "svg[:weight:style]" - "svg:500" or "svg:600:filled"
            
                var parts = iconSetName.split(":");
                
                if (parts[0] == "svg") {
                    if (parts.length > 1) {
                        var weightRegex = new RegExp("([1-7]00)$");
                        var weight = "_400";
                        var style = "_rounded";
                        for (var i=0; i<parts.length; i++) {
                            if (weightRegex.test(parts[i])) weight = "_" + parts[i];
                            else if (parts[i] == "filled") style = "_rounded_filled";
                            else style = "_rounded";
                        }
                        iconSetName = "ms" + weight + style;
                        
                        // passed string equates to the format "ms_100_rounded" or 
                        // "ms_100_rounded_filled" - this is a request to switch SVG source-file
                        if (isc.Media.iconSet != "svg") {
                            // install the SVG mappings before modifying them below
                            isc.Media.useMedia("svg", true);
                        }
                        isc.Media.changeSVGStockIconSource(iconSetName);
                        return;
                    }
                }
            }
        } 

        var set = isc.Media.getIconSet(iconSet)
        if (!set) {
            if (isc.isAn.Object(iconSet)) {
                // if the object is registered (addIconSet()), use it's name - otherwise, add it 
                // first
                var set = isc.Media.getIconSet(iconSet);
                if (!set) set = isc.Media.addIconSet(iconSet);
                iconSetName = set && set.name;
            } else {
                this.logWarn("Unknown iconSetName: " + iconSetName);
                return;
            }
        }
        isc.Media.iconSet = iconSetName;

        if (iconSetName == "skin") isc.Media.enableTreeIconCaching = true;
        else if (iconSetName.contains("svg")) isc.Media.enableTreeIconCaching = false;

        isc.Media.fontIconMap = {};
        if (iconSetName == "materialIcons") {
            isc.Media.fontIconMap = isc.Media.iconSets["materialIcons"].mappings;
            var iconSize = isc.FormItem.getPrototype().iconHeight || 16;
            iconSize -= 2;
            //var partsString = "font:cssClass:material-icons;size:" + iconSize + "px;dimensions:" + iconSize + "," + iconSize + ";";
            //var parts = ["font:cssClass:material-icons;value:", null, ";size:" + iconSize + "px;dimensions:" + iconSize + "," + iconSize + ";"];
            var partsString = "font:cssClass:material-icons;dimensions:" + iconSize + "," + iconSize + ";";
            var parts = ["font:cssClass:material-icons;value:", null, ";dimensions:" + iconSize + "," + iconSize + ";"];
            for (var key in this.iconNameToSrcMap) {
                if (isc.Media.fontIconMap[key]) {
                    var value = isc.Media.fontIconMap[key];
                    if (!value.contains(":")) {
                        // this is just a font-glyph key
                        parts[1] = value;
                        // update the src string on the stockIcon object and in the currentSrc map
                        isc.Media.stockIconsMap[key].src = parts.join("");
                        isc.Media.expandedFromSrcToSrcMap[this.iconNameToSrcMap[key]] = parts.join("");
                    } else {
                        // this isn't just a font-glyph key - it has other attributes in the 
                        // string - just tag the whole thing onto the end
                        value = partsString + value;
                        // update the src string on the stockIcon object and in the currentSrc map
                        isc.Media.stockIconsMap[key].src = value;
                        isc.Media.expandedFromSrcToSrcMap[this.iconNameToSrcMap[key]] = value;
                    }
                }
            }

            // isc.Media.expandedFromSrcToSrcMap is a map of full image-URL to possible font-config
        } else {
            if (iconSetName == "skin") {
                // we want to revert all the "src" attributes on StockIcons that have a fromSrc
                // to their expandedFromSrc, which is the expanded version of the fromSrc
                var map = {};
                isc.Media.stockIcons.map(function (icon) {
                    map[icon.name] = icon.expandedFromSrc; 
                });
                isc.Media.updateIconMappings(map);
            } else {
                if (iconSetName == "svg") {
                    isc.Media.currentSVGStockIconPath = isc.Media.defaultSVGStockIconPath;
                }
                isc.Media.applyIconSet(iconSetName);
            }
        }

        isc.Media.rebuildMaps();

        // clear CSS caches to that styles and potentially icons get refreshed
        if (!skipUpdate) isc.Canvas.clearCSSCaches();
    },

    // this flag is referenced by code in TreeCells.getIcon(), to determine whether to cache
    // the various tree-icons - when the skin is using SVG symbols, avoid that caching for the 
    // moment because the current code results in unexpected cache-matches and multiple re-uses
    // of the same global element-ids
    enableTreeIconCaching: true,

    // stockIcon config
    _stockIconConfig: {},
    _notStockIconConfig: {},
    // don't check for "icon:" or "stock:" prefixes on a src - we don't use any as yet 
    allowStockPrefix: false,
    _$stockPrefix: "stock:",
    allowIconPrefix: false,
    _$iconPrefix: "icon:",
    isStockIconConfig : function (src) {
        if (!src || !isc.Media.mediaInitialized) return false;
        // if the src has been seen before, it will be in one of these two objects
        if (isc.Media._stockIconConfig[src]) {
            //c.logWarn("skipped " + src);
            return true;
        }
        if (isc.Media._notStockIconConfig[src]) {
            //c.logWarn("skipped " + src);
            return false
        }

        // otherwise, find out if it's a stockIcon, and cache the result
        var map = isc.Media.iconNameToSrcMap,
            result
        ;
        if (map && map[src]) {
            // just a stockKey, like "Edit", that exists in the stockIcons list (and iconNameToSrcMap)
            result = true;
        } else {
            // a stockIcon config, like "stock:Edit" or "icon:MyCustomIcon" - they're the same,
            // right now, and both are switched off by default
            result = (isc.Media.allowStockPrefix && src.startsWith(isc.Media._$stockPrefix)) || 
                (isc.Media.allowIconPrefix && src.startsWith(isc.Media._$iconPrefix));
        }

        if (result) isc.Media._stockIconConfig[src] = true;
        else isc.Media._notStockIconConfig[src] = true;
        return result;
    },

    // get the stockIcon key associated with the passed src - can be passed 
    // - any full file-path that maps to a stockIcon (icon.src)
    // - an SCImgURL that maps to a stockIcon (icon.parsedURL)
    // - an SCImgURL that, when parsed, maps to a stockIcon (icon.expandedFromSrc)
    // - a src prefixed "icon:" or "stock:"
    // - a stockIcon name, which is just returned
    getStockIconKeyForSrc : function (src, imgDir, instance) {
        if (!isc.Media.mediaInitialized) return src;

        // passed null or empty string - return null
        if (src == null || src == "") return null;

        // passed a valid stockIcon name, just return it
        if (this.iconNameToSrcMap[src]) return src;
        
        // return the key mapped from the expanded original fromSrc (icon.expandedFromSrc)
        var key = this.expandedFromSrcToIconNameMap[src];
        if (key) return key;

        // return the key mapped from the full path or one with [SKINIMG] for example
        var key = this.srcToIconNameMap[src] || this.parsedURLToIconNameMap[src];
        if (key) return key;

        // if the passed src starts with a directory shortcut, like [SKIN], expand it now
        if (src && src.contains && src.contains("[")) {
            // expand the src, replacing [SKIN], [SKINIMG] etc
            src = isc.Media.expandSrc(src, imgDir, instance);

            // get the parsed fromSrc from the map of fromSrc to current src 
            var fromSrc = this.expandedFromSrcToSrcMap[src];
            // key is the entry for the fromSrc relating to the passed src, if it's in the map, 
            // otherwise the entry for the passed src
            key = this.srcToIconNameMap[fromSrc] || this.srcToIconNameMap[src] || this.expandedSrcToIconNameMap[src];
            if (key) return key;
        }

        if (isc.isA.String(src)) {
            // split by colon to detect other mapping-types
            var parts = src.split(":");

            // passed a valid stockIcon name along with other properties - just return it - callers
            // will pass this value to getStockIconSrc(key), which will deal with getting the 
            // associated src-string for the stockIcon-name and then appending the extra properties
            if (this.iconNameToSrcMap[parts[0]]) {
                return src;
            }
            
            // passed a valid stockIcon prefixed with "icon:"
            if (isc.Media.allowIconPrefix && parts[0] == "icon" && this.iconNameToSrcMap[parts[1]]) 
                return src.substrng(5);

            // passed a valid stockIcon prefixed with "stock:"
            if (isc.Media.allowStockPrefix && parts[0] == "stock" && this.iconNameToSrcMap[parts[1]]) 
                return src.substrng(6);
        }

        return null;
    },
    getStockIconSrc : function (src) {
        // return whatever icon-definition is currently assigned to the passed stockKey - that
        // is, the current value of isc.Media.iconNameToSrcMap[stockKey]
        if (!isc.Media.mediaInitialized) return src;

        // split by colon - will result in one entry for a regular stockIcon name, or multiple 
        // entries if the key includes additional settings for the src-string
        var parts = src.split(":");

        var stockKey = parts.shift();

        //this.logWarn("in getStockIconSrc, checking src: " + src); 
        if (isc.Media.isStockIconConfig(stockKey)) {
            //this.logWarn("src is " + src + "  -- stockKey is " + stockKey);
            if (isc.Media.allowStockPrefix && stockKey.startsWith(isc.Media._$stockPrefix)) {
                stockKey = stockKey.substring(6);
            } else if (isc.Media.allowIconPrefix && stockKey.startsWith(isc.Media._$iconPrefix)) {
                stockKey = stockKey.substring(5);
            }
            // otherwise, it's just a stockKey (stockIcon name), with no prefix - also valid
            //this.logWarn("stockKey is now -- " + stockKey);
        }

        // get the src currently assigned to the detected key
        var result = isc.Media.iconNameToSrcMap[stockKey];

        if (result && result.startsWith("sprite:")) {
            // if the current mapping is a sprite-string, and the key passed into this method
            // had extra props like "Edit:color:red;", append the extra settings to the result
            if (!result.endsWith(";")) result += ";";
            if (parts.length > 0) {
                result += parts.join(":");
            }
        }

        return result || src;
    },

    isEmptyStockIcon : function (src) {
        var key = isc.Media.getStockIconKeyForSrc(src);

        // if there's a key, it's a stockIcon - get it's current mapped src
        var iconSrc = key ? isc.Media.getStockIconSrc(key)  : null;

        // return true if the src is "empty", false otherwise
        return iconSrc == "empty";
    },

    mapImgURL : function (src) {
        if (!isc.Media.mediaInitialized) return src;
        return isc.Media.expandedFromSrcToSrcMap[src] || src;
    },

    // flag that prevents checking for fontIcons in Canvas.imgHTML() and saves some time - not 
    // a lot, since isFontIconConfig() caches its results
    allowFontPrefix: true,
    _$fontPrefix: "font:",
    // cache of src strings that were / were not fontIconConfigs
    _fontIconConfig: {},
    _notFontIconConfig: {},
    // is the passed string a formatted fontIcon-config?
    isFontIconConfig : function (src) {
        if (!isc.Media.allowFontPrefix || !src) return false;
        // if the src has been seen before, it will be in one of these two objects
        if (isc.Media._fontIconConfig[src]) {
            //isc.logWarn("skipped " + src);
            return true;
        }
        if (isc.Media._notFontIconConfig[src]) {
            //isc.logWarn("skipped " + src);
            return false;
        }
        // otherwise, it's a fontConfig if it starts with "font:"
        var result = isc.isA.String(src) && src.startsWith(this._$fontPrefix);
        // cache the result for next time
        if (result) isc.Media._fontIconConfig[src] = true;
        else isc.Media._notFontIconConfig[src] = true;
        return result;
    },
    // parse a fontIcon string into a config object
    _$fontIconCssClass: "cssClass",
    _$fontIconValue: "value",
    _$fontIconColor: "color",
    _$fontIconOpacity: "opacity",
    _$fontIconDimensions: "dimensions",
    _$fontIconSize: "size",
    _$fontIconFontSize: "font-size",
    // use these if not using a cssClass
    _$fontIconName: "name",
    _$fontIconFamily: "family",
    _$fontIconFontFamily: "font-family",
    getFontIconConfig : function (src) {
        if (!isc.Media.isFontIconConfig(src)) return null;
        // lazily init the stock media on first access
        if (!isc.Media.mediaInitialized) isc.Media.initMedia();
        var result = {};
        var parts = src.substring(5).split(";");
        for (var i=0; i<parts.length; i++) {
            var item = parts[i].split(":");
            if (item[0]==this._$fontIconCssClass) {
                result.cssClass = item[1];
            } else if (item[0]==this._$fontIconValue) {
                result.value = item[1];
            } else if (item[0]==this._$fontIconColor) {
                result.color = item[1];
            } else if (item[0]==this._$fontIconOpacity) {
                result.opacity = item[1];
            } else if (item[0]==this._$fontIconDimensions) {
                if (item[1] == null) {
                    isc.logWarn("Null fontIcon dimensions...");
                }
                result[this._$fontIconDimensions] = item[1];
            } else if (item[0]==this._$fontIconSize || item[0]==this._$fontIconFontSize) {
                if (item[1] == null) {
                    isc.logWarn("Null fontIcon size...");
                }
                result[this._$fontIconSize] = parseInt(item[1]);
            } else if (item[0]==this._$fontIconFontFamily || item[0]==this._$fontIconFamily || 
                    item[0]==this._$fontIconName) {
                result[this._$fontIconFontFamily] = item[1];
            }
        }
        return result;
    },
    
    // _encodeFontIconConfig will take a font config object, and encode it in a string
    _encodeFontIconConfig : function (fontIconConfig) {
        if (!isc.isAn.Object(fontIconConfig)) return fontIconConfig;
        var encodedFontIcon = "font:",
            hasAttributes = false;

        if (fontIconConfig.cssClass) {
            encodedFontIcon += "cssClass:" + fontIconConfig.cssClass + ";";
            hasAttributes = true;
        }
        if (fontIconConfig.value) {
            encodedFontIcon += "value:" + fontIconConfig.value + ";";
            hasAttributes = true;
        }
        if (fontIconConfig.color) {
            encodedFontIcon += "color:" + fontIconConfig.color + ";";
            hasAttributes = true;
        }
        if (fontIconConfig.opacity) {
            encodedFontIcon += "opacity:" + fontIconConfig.opacity + ";";
            hasAttributes = true;
        }
        if (fontIconConfig["font-size"]) {
            encodedFontIcon += "font-size:" + parseInt(fontIconConfig["font-size"]) + "px;";
            hasAttributes = true;
        }
        if (fontIconConfig.size) {
            encodedFontIcon += "size:" + fontIconConfig.size + ";";
            hasAttributes = true;
        }
        
        if (fontIconConfig.name) {
            encodedFontIcon += "name:" + fontIconConfig.name + ";";
            hasAttributes = true;
        }
        if (fontIconConfig.family) {
            encodedFontIcon += "family:" + fontIconConfig.family + ";";
            hasAttributes = true;
        }

        
        if (!hasAttributes) {
            this.logInfo("Unable to derive meaningful attributes from font-icon configuration:" 
                + this.echo(fontIconConfig));
            return "";
        }
        return encodedFontIcon;
    },

    // helper to return the HTML for a span containing an icon from a font
    getFontIconHTML : function (config) {
        
        if (!isc.Media.isFontIconConfig(config)) return config;
        var parts = config.substring(5).split(";");
        var style = [];
        var style = ["color:", null, ";", "opacity:", null, ";", "font-size:", null, ";",
                "width:", null, "px;", "height:", null, "px;", "font-family:", null, ";"];
        var cssClass = null;
        var value = "";
        for (var i=0; i<parts.length; i++) {
            var item = parts[i].split(":");
            if (item[0]==this._$fontIconCssClass) {
                cssClass = item[1];
            } else if (item[0]==this._$fontIconValue) {
                value = item[1];
            } else if (item[0]==this._$fontIconColor) {
                style[1] = item[1];
            } else if (item[0]==this._$fontIconOpacity) {
                style[4] = item[1];
            } else if (item[0]==this._$fontIconSize || item[0]==this._$fontIconFontSize) {
                style[7] = item[1];
            } else if (item[0]==this._$fontIconDimensions) {
                var parts = item[1].split(",");
                style[10] = parseInt(parts[0]);
                style[13] = parseInt(parts[1]);
            } else if (item[0]==this._$fontIconName || item[0]==this._$fontIconFamily
                    || item[0]==this._$fontIconFontFamily) {
                style[16] = item[1];
            }
        }
        if (!style[1]) style[0] = style[2] = null;
        if (!style[4]) style[3] = style[5] = null;
        if (!style[7]) style[6] = style[8] = null;
        if (!style[10]) style[9] = style[11] = style[12] = style[14] = null;
        if (!style[16]) style[15] = style[17] = null;
        style = style.join("");

        var result = ["<span "];
        if (cssClass) result.addList(["class='", cssClass, "'"]);
        if (style.length > 0) result.addList(["style='", style, "'"]);
        result.addList([">", value, "</span>"]);
        return result.join("");
    },


    // flag that prevents checking for svgSprite icons in Canvas.imgHTML() and saves some time 
    // when they aren't needed
    allowSvgSpritePrefix: true,

    // is the passed src an svgSprite config?
    isSvgSpriteConfig : function (src) {
        if (!isc.Media.allowSvgSpritePrefix) return false;
        var config = isc.Canvas._getSpriteConfig(src);
        return config && (config.svg != null);
    },

    isSVGDataURL : function (src) {
        return src && src.startsWith("data:image/svg+xml;");
    },
    _$svgSpriteLegacyPrefix: "sprite:usesvg:",
    _$svgSpritePrefix: "sprite:svg:",
    // cache of src strings that were / were not svgSpriteConfigs
    _svgSpriteConfig: {},
    _notSvgSpriteConfig: {},
    // is the passed string a formatted svg-sprite config?
    isSvgSpriteConfigString : function (src) {
        if (!isc.Media.allowSvgSpritePrefix || !src || !isc.isA.String(src)) return false;
        // if the src has been seen before, it will be in one of these two objects
        if (isc.Media._svgSpriteConfig[src]) {
            //isc.logWarn("skipped " + src);
            return true;
        }
        if (isc.Media._notSvgSpriteConfig[src]) {
            //isc.logWarn("skipped " + src);
            return false;
        }
        // otherwise, it's an svg sprite if it starts with "sprite:svg" or "sprite:usesvg:"
        var result = src.startsWith(this._$svgSpritePrefix) || src.startsWith(this._$svgSpriteLegacyPrefix);
        // cache the result for next time
        if (result) isc.Media._svgSpriteConfig[src] = true;
        else isc.Media._notSvgSpriteConfig[src] = true;
        return result;
    },

    // return an svgSprite config or null if the passed src is something else
    getSvgSpriteConfig : function (src) {
        var config = isc.Canvas._getSpriteConfig(src);
        if (config && config.use) return config;
        return null;
    },

    // when true, the default, applies the current Canvas.fontIncrease to "size" attributes in 
    // SVG src-strings
    //> @classAttr Media.svgAutoScale (Boolean : true : IR)
    // When true automatically scales "size" attributes specified in SVG src-strings.
    // @group svgSymbols
    // @visibility external
    //<
    svgAutoScale: true,

    //> @classAttr Media.svgUseDefaultSize (Boolean : true : IR)
    // When true, causes SVGs with no divinable size to render at a useable 
    // +link{Media.svgDefaultSize, default size}, rather than at browser-default size, which is 
    // 300x150 and never desirable.
    // @group svgSymbols
    // @visibility external
    //<
    svgUseDefaultSize: true,

    //> @classAttr Media.svgDefaultSize (Integer : 16 : IR)
    // The default-size in pixels for any request for an SVG symbol that 
    // doesn't provide any sizes (none of width/height/imageWidth/imageHeight on the widget or 
    // "size" in the src-string).  In this way, unsized SVGs will render at a useable default 
    // size, rather than at browser-default size, which is 300x150 and never desirable.
    // @group svgSymbols
    // @visibility external
    //<
    svgDefaultSize: 16,

    
    getSvgSpriteHTML : function (src, width, height, name, extraStuff, imgDir, activeAreaHTML,
                        instance, returnTemplate, generateSpan, cssClass, eventStuff, 
                        extraCSSText, cssPointerEvents, stockIconName) 
    {
        var spriteConfig = null;
        var isSprite = false;
        if (src.svg !== undefined) {
            // passed an svgSprite config
            spriteConfig = src;
            isSprite = true;
        } else if (isc.Media.isSvgSpriteConfigString(src)) {
            // For the case where src gets passed as a text parameter we assume that a src
            // object would be the map of parameters to this function
            src = {
                 src: src
                ,width: width
                ,height: height
                ,name: name
                ,extraStuff: extraStuff
                ,eventStuff: eventStuff
                ,extraCSSText: extraCSSText
                ,imgDir: imgDir
                ,activeAreaHTML: activeAreaHTML
                //,instance: instance
                ,returnTemplate: returnTemplate
                ,generateSpan: generateSpan
                ,cssClass: cssClass
            };
            spriteConfig = isc.Canvas._getSpriteConfig(src.src);
            isSprite = spriteConfig !== null;
            if (isSprite) isc.addProperties(src, spriteConfig);
        } else if (isc.isAn.Object(src) ) {
            spriteConfig = isc.Canvas._getSpriteConfig(src.src);
            isSprite = spriteConfig !== null;
        } 

        var config = isc.addProperties({}, {
                width: width
                ,height: height
                ,name: name
                ,extraStuff: extraStuff
                ,eventStuff: eventStuff
                ,extraCSSText: extraCSSText
                ,imgDir: imgDir
                ,activeAreaHTML: activeAreaHTML
                //,instance: instance
                ,returnTemplate: returnTemplate
                ,generateSpan: generateSpan
                ,cssClass: cssClass
                
            },
            spriteConfig
        )

        if (config.extraStuff) {
            // remove a class declaration if there is one
            var regex = new RegExp("class=\"['\"][^'\"]*['\"]\"", "g");
            config.extraStuff = config.extraStuff.replace(regex, '');
        }


        // <svg> tags need a specified width and height or they'll size at 300x150, the browser
        // default - if the src string included "size:w,h;", those values will be in 
        // config.originalWidth/Height - if they're not set, use the sizes for the span itself.
        if (!config.originalWidth && config.width) config.originalWidth = config.width;
        if (!config.originalHeight && config.height) config.originalHeight = config.height;

        // if there are still no sizes and so configured, use the svgDefaultSize - otherwise, 
        // the svg tag will render at browser-default size, 300x150
        if (isc.Media.svgUseDefaultSize) {
            if (!config.originalWidth) config.originalWidth = isc.Media.svgDefaultSize;
            if (!config.originalHeight) config.originalHeight = isc.Media.svgDefaultSize;
        }

        // hacky - switch the width/height values if changing orientation
        if (config.rotate && config.rotate == 90 || config.rotate == 270) {
            var w = config.originalWidth;
            config.originalWidth = config.originalHeight;
            config.originalHeight = w;
        }

        // make sure the outer image has sizes as well
        if (config.width == null) config.width = config.originalWidth;
        if (config.height == null) config.height = config.originaleight;

        // default id to name
        if (!config.id && config.name){
            config.id = config.name;
        }

        // ensure id is prefixed with instance.getCanvasName()        
        if (config.id && instance && !config.id.startsWith(instance.getCanvasName())){
            config.id = instance.getCanvasName() + config.id;
        }

        // default display to "inline-block"
        if (!config.display){
            config.display = "inline-block";
        }
        
        if (!config.stockIcon && stockIconName) config.stockIcon = stockIconName;


        if (isSprite && config.svg !== undefined) {
            //this.logWarn(src.svg) ;
            var srcKeys = Object.keys(config);

            // the outer <span> tag
            var spanTag = ["<span "];

            // on the outer <span>, set display: inline-block, so that icons can 
            // be shown horizontally adjacent - there's an inner <span> as well, which 
            // sets display: grid, in order to center the inner <svg>
            var spanStyle = ["display: " + config.display + ";vertical-align:middle;"];

            // the <svg> tag that sets the graphics-size and contains the <use> tag
            var svgTag = ["<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" "];

            
            var svgStyle = [];
            if (isc.Browser.isTouch && isc.Browser._hasElementPointerEvents) {
                if (!cssPointerEvents) cssPointerEvents = "none";
                svgStyle.add("pointer-events:" + cssPointerEvents + ";");
            }

            // skip these attrs - first 2 or 3 added after the loop, others are framework details
            var skipThese = ["src", "usesvg", "svg", "imgDir", "returnTemplate", "generateSpan"]
            
            for ( var x = 0; x < srcKeys.length; x++ ) {
                var key = srcKeys[x];

                // skip these - see above
                if (skipThese.contains(key)) continue;

                var val = config[key];
                if (val == null) continue;
                
                // these apply to the style attribute of the <svg> tag, not the outer <span>
                if (key === "fill") {
                    // svg fill (background color) also goes in the svg's style attribute
                    svgStyle.add("fill: " + val + ";");
                    continue;
                }
                if (key === "stroke") {
                    // svg stroke (outline color) also goes in the svg's style attribute
                    svgStyle.add("stroke: " + val + ";");
                    continue;
                }
                if (key === "color") {
                    // svg stroke and fill can be set to the special CSS value "currentColor" 
                    // in the source SVG - then, an external CSS class can affect that value 
                    // by setting CSS color
                    svgStyle.add("color: " + val + ";");
                    continue;
                }
                if (key === "stroke-width") {
                    // svg stroke-width (outline width) also goes in the svg's style attribute
                    svgStyle.add("stroke-width: " + val + ";");
                    continue;
                }
                if (key === "originalWidth") {
                    // image width - this comes from the "size:w,h;" attribute in src-strings 
                    // - must be on the <svg>; it limits the child <use> viewbox -
                    // without this, you get the browser default size of 300x150...

                    // canScale is set by Canvas._getSpriteConfig() if there was a size:w,h in 
                    // the original src string - if it's true, and isc.Media.svgAutoScale is 
                    // also true, scale the icon by the current 
                    // global fontIncrease - scale:false will prevent scaling
                    if (config.canScale && config.scale != false && isc.Media.svgAutoScale) {
                        val += isc.Canvas.getCurrentFontIncrease();
                    }
                    svgStyle.add("width: " + val + "px;");
                    continue;
                }
                if (key === "originalHeight") {
                    // image height - this comes from the "size:w,h;" attribute in src-strings 
                    // - must be on the <svg>; it limits the child <use> viewbox -
                    // without this, you get the browser default size of 300x150...

                    // canScale is set by Canvas._getSpriteConfig() if there was a size:w,h in 
                    // the original src string - if it's true, and isc.Media.svgAutoScale is 
                    // also true, scale the icon by the current 
                    // global fontIncrease - scale:false will prevent scaling
                    if (config.canScale && config.scale != false && isc.Media.svgAutoScale) {
                        val += isc.Canvas.getCurrentFontIncrease();
                    }
                    svgStyle.add("height: " + val + "px;");
                    continue;
                }

                if (key === "transform") {
                    // CSS transform - goes in the svg's style attribute
                    svgStyle.add("transform: " + val + ";");
                    continue;
                }
                if (key === "rotate") {
                    // CSS rotate() transform - shortcut for the above general "transform"
                    svgStyle.add("transform: rotate(" + parseInt(val) + "deg);");
                    continue;
                }


                // these apply to the style attribute of the outer <span>, and not the <svg>
                if (key === "extraCSSText") {
                    // extraCSSText is content for the outer-span's style attribute
                    if (!val.endsWith(";")) val += ";";
                    spanStyle.add(val);
                    continue;
                }
                if (key === "width") {
                    // element-width - must be on the <span>
                    spanStyle.add("width: " + val + "px;");
                    continue;
                }
                if (key === "height") {
                    // element-height - must be on the <span>
                    spanStyle.add("height: " + val + "px;");
                    //spanStyle.add("line-height: " + val + "px;");
                    continue;
                }
                if (key === "opacity") {
                    // apply opacity to the outer span
                    spanStyle.add("opacity: " + val + ";");
                    continue;
                }

                
                // everything else applies to the <span> tag, not to any style attribute
                if (key === "extraStuff") {
                    // this is other settings, such as "id", to apply to the outer <span> tag
                    spanTag.add(val);
                    continue;
                }

                if (key === "eventStuff") {
                    // this is event handlers and things like _itemPart, to apply to the outer <span> tag
                    spanTag.add(val);
                    continue;
                }

                // anything else - things like "issprite" and "issvgsprite", in this case
                spanTag.addList([key, "=\"", val, "\" "]);
            }

            // add the "style" attribute for the <svg> tag
            if (svgStyle.length != 0) svgTag.addList([" style=\"", svgStyle.join(""), "\""]);

            // set "viewbox" as required
            if (config.viewbox) svgTag.addList([" viewbox=\"", config.viewbox, "\" "]);
            
            // cssClass should be on the outer <span>, rather than the inner <svg>
            if (config.cssClass) spanTag.addList([" class=\"", config.cssClass, "\" "]);

            if (config.stockIcon) spanTag.addList([" stockicon=\"", config.stockIcon, "\" "]);

            // script the <use> tag
            var endFragmentArr = ["><use "];
            var url = isc.Page.getURL(config.svg);
            
            endFragmentArr.addList(["xlink:href=\"", url, "\" href=\"", url, "\""]);
            //endFragmentArr.addList(useTag);
            endFragmentArr.add("></use></svg>");
            var endFragment = endFragmentArr.join("");

            // add the <use> tag and close the <svg>
            svgTag.add(endFragment);

            // add an "id" to the outer <span> as necessary
            if (returnTemplate) {
                // add a blank id and set the _idSlot for it - calling code uses it
                spanTag.addList([" id=\"", null, null, "\""]);
                spanTag._idSlot = spanTag.length - 2;
            } else if (config.name)  {
                // add an id if there's a name and instance
                spanTag.addList([" id=\"", instance ? instance.getCanvasName() : "", config.name, "\""]);
                //spanTag.addList([" id=\"", instance ? instance.getCanvasName() : "", config.name, "\""]);
            }

            // insert the "style" attribute for the outer <span>
            if (spanStyle.length != 0) spanTag.add(" style=\"" + spanStyle.join("") + "\"");
            spanTag.add(">");

            // insert an extra <span> - the outer one has sizes and display:inline-block, so that
            // icons can appear next to each other - this inner one uses display:grid to center 
            // the inner svgTag
            // inner one has full w/h and display:grid 
            spanTag.add("<span style=\"width:100%; height:100%; display:grid; place-items:center;\">");
            // insert the entire <svg> tag, with its child <use> tag, and close the </span>
            spanTag.addList(svgTag);
            spanTag.add("</span>");
            spanTag.add("</span>");

            if (returnTemplate) {
                // return the template array
                return spanTag.duplicate();
            }

            var res = spanTag.join("");

            return res;
        }
    }

,
    
// SVG Auto-Crop 
    // 
    // use like:
    // const cropped = isc.Media.autoCropSVG(svgText, {});
    // const croppedWithPadding = isc.Media.autoCropSVG(svgText, { padding: 10 });
    // const croppedSquare = isc.Media.autoCropSVG(svgText, { padding: 5, makeSquare: true });

    //> @classMethod autoCropSVG
    // Auto-crops an SVG element or string to its content bounds, with optional padding or 
    // squared-crop, and returns the cropped SVG element as a string.
    // @param svgString (String) the SVG element as a string
    // @param [options] (Object) optional object with padding (number) and makeSquare (boolean) properties
    // @return (String) the cropped SVG as a string
    //<
    autoCropSVG: function(svgInput, options) {
        options = options || {};
        const padding = options.padding || 0;
        const makeSquare = options.makeSquare || false;
        
        // Handle both string and element input
        let svgElement;
        if (typeof svgInput === 'string') {
            const parser = new DOMParser();
            const svgDoc = parser.parseFromString(svgInput, 'image/svg+xml');
            svgElement = svgDoc.documentElement;
        } else {
            svgElement = svgInput;
        }
        
        // Get content bounds
        const contentBounds = this.getContentBounds(svgElement);
        
        // Apply padding
        let cropX = contentBounds.x - padding;
        let cropY = contentBounds.y - padding;
        let cropWidth = contentBounds.width + (padding * 2);
        let cropHeight = contentBounds.height + (padding * 2);
        
        // Make square if requested
        if (makeSquare) {
            const maxDim = Math.max(cropWidth, cropHeight);
            const centerX = cropX + cropWidth / 2;
            const centerY = cropY + cropHeight / 2;
            
            cropX = centerX - maxDim / 2;
            cropY = centerY - maxDim / 2;
            cropWidth = maxDim;
            cropHeight = maxDim;
        }
        
        // Clone and crop the SVG
        const croppedSvg = svgElement.cloneNode(true);
        
        // Update viewBox and dimensions
        croppedSvg.setAttribute('viewBox', [cropX, cropY, cropWidth, cropHeight].join(" "));
        croppedSvg.setAttribute('width', cropWidth);
        croppedSvg.setAttribute('height', cropHeight);
        
        // Return as string
        return new XMLSerializer().serializeToString(croppedSvg);
    },

    // Alternative version using clipPath (more precise but adds elements)
    autoCropSVGWithClipPath: function(svgInput, options) {
        options = options || {};
        const padding = options.padding || 0;
        const makeSquare = options.makeSquare || false;
        
        // Handle both string and element input
        let svgElement;
        if (typeof svgInput === 'string') {
            const parser = new DOMParser();
            const svgDoc = parser.parseFromString(svgInput, 'image/svg+xml');
            svgElement = svgDoc.documentElement;
        } else {
            svgElement = svgInput;
        }
        
        const contentBounds = this.getContentBounds(svgElement);
        
        let cropX = contentBounds.x - padding;
        let cropY = contentBounds.y - padding;
        let cropWidth = contentBounds.width + (padding * 2);
        let cropHeight = contentBounds.height + (padding * 2);
        
        if (makeSquare) {
            const maxDim = Math.max(cropWidth, cropHeight);
            const centerX = cropX + cropWidth / 2;
            const centerY = cropY + cropHeight / 2;
            cropX = centerX - maxDim / 2;
            cropY = centerY - maxDim / 2;
            cropWidth = maxDim;
            cropHeight = maxDim;
        }
        
        const croppedSvg = svgElement.cloneNode(true);
        
        // Use clipPath method
        const clipPath = document.createElementNS('http://www.w3.org/2000/svg', 'clipPath');
        clipPath.setAttribute('id', 'autoCrop');
        
        const clipRect = document.createElementNS('http://www.w3.org/2000/svg', 'rect');
        clipRect.setAttribute('x', cropX);
        clipRect.setAttribute('y', cropY);
        clipRect.setAttribute('width', cropWidth);
        clipRect.setAttribute('height', cropHeight);
        clipPath.appendChild(clipRect);
        
        let defs = croppedSvg.querySelector('defs');
        if (!defs) {
            defs = document.createElementNS('http://www.w3.org/2000/svg', 'defs');
            croppedSvg.insertBefore(defs, croppedSvg.firstChild);
        }
        defs.appendChild(clipPath);
        
        const children = Array.prototype.slice.call(croppedSvg.children);
        for (let i = 0; i < children.length; i++) {
            const child = children[i];
            if (child.tagName !== 'defs') {
                child.setAttribute('clip-path', 'url(#autoCrop)');
            }
        }
        
        croppedSvg.setAttribute('viewBox', cropX + ' ' + cropY + ' ' + cropWidth + ' ' + cropHeight);
        croppedSvg.setAttribute('width', cropWidth);
        croppedSvg.setAttribute('height', cropHeight);
        
        return new XMLSerializer().serializeToString(croppedSvg);
    },

    // Content bounds detection
    getContentBounds: function(svgElement) {
        // Create temporary SVG to measure bounds
        const tempSvg = svgElement.cloneNode(true);
        tempSvg.style.position = 'absolute';
        tempSvg.style.left = '-9999px';
        tempSvg.style.visibility = 'hidden';
        document.body.appendChild(tempSvg);
        
        try {
            // Try getBBox first - note: getBBox may not include stroke in all browsers
            const bbox = tempSvg.getBBox();
            
            // Also try getStrokeBBox if available (includes stroke)
            let strokeBBox = null;
            if (typeof tempSvg.getStrokeBBox === 'function') {
                try {
                    strokeBBox = tempSvg.getStrokeBBox();
                } catch (e) {
                    // getStrokeBBox not available or failed
                }
            }
            
            // Use strokeBBox if available, otherwise fall back to manual calculation
            if (strokeBBox) {
                return { x: strokeBBox.x, y: strokeBBox.y, width: strokeBBox.width, height: strokeBBox.height };
            } else {
                // getBBox doesn't always include stroke, so use fallback
                console.warn('getStrokeBBox not available, using manual calculation');
                return this.getContentBoundsFallback(tempSvg);
            }
        } catch (e) {
            console.warn('getBBox failed, using fallback');
            return this.getContentBoundsFallback(svgElement);
        } finally {
            document.body.removeChild(tempSvg);
        }
    },

    getContentBoundsFallback: function(svgElement) {
        let minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity;
        const elements = svgElement.querySelectorAll('*');
        
        for (let i = 0; i < elements.length; i++) {
            const el = elements[i];
            if (el.tagName === 'defs' || el.tagName === 'clipPath' || el.tagName === 'marker') continue;
            
            const bounds = this.getElementBounds(el);
            if (bounds && bounds.width > 0 && bounds.height > 0) {
                minX = Math.min(minX, bounds.x);
                minY = Math.min(minY, bounds.y);
                maxX = Math.max(maxX, bounds.x + bounds.width);
                maxY = Math.max(maxY, bounds.y + bounds.height);
            }
        }
        
        if (minX === Infinity) {
            return { x: 0, y: 0, width: 100, height: 100 };
        }
        
        return { x: minX, y: minY, width: maxX - minX, height: maxY - minY };
    },

    getElementBounds: function(el) {
        const tagName = el.tagName.toLowerCase();
        let bounds = null;
        
        switch (tagName) {
            case 'rect':
                bounds = {
                    x: parseFloat(el.getAttribute('x')) || 0,
                    y: parseFloat(el.getAttribute('y')) || 0,
                    width: parseFloat(el.getAttribute('width')) || 0,
                    height: parseFloat(el.getAttribute('height')) || 0
                };
                break;
            case 'circle':
                const cx = parseFloat(el.getAttribute('cx')) || 0;
                const cy = parseFloat(el.getAttribute('cy')) || 0;
                const r = parseFloat(el.getAttribute('r')) || 0;
                bounds = { x: cx - r, y: cy - r, width: r * 2, height: r * 2 };
                break;
            case 'ellipse':
                const ecx = parseFloat(el.getAttribute('cx')) || 0;
                const ecy = parseFloat(el.getAttribute('cy')) || 0;
                const rx = parseFloat(el.getAttribute('rx')) || 0;
                const ry = parseFloat(el.getAttribute('ry')) || 0;
                bounds = { x: ecx - rx, y: ecy - ry, width: rx * 2, height: ry * 2 };
                break;
            case 'line':
                const x1 = parseFloat(el.getAttribute('x1')) || 0;
                const y1 = parseFloat(el.getAttribute('y1')) || 0;
                const x2 = parseFloat(el.getAttribute('x2')) || 0;
                const y2 = parseFloat(el.getAttribute('y2')) || 0;
                bounds = {
                    x: Math.min(x1, x2), y: Math.min(y1, y2),
                    width: Math.abs(x2 - x1), height: Math.abs(y2 - y1)
                };
                break;
            case 'polyline':
            case 'polygon':
                bounds = this.getPolyBounds(el);
                break;
            case 'path':
                bounds = this.getPathBounds(el);
                break;
            case 'text':
                bounds = this.getTextBounds(el);
                break;
            default:
                return null;
        }
        
        if (!bounds) return null;
        
        // Account for stroke width - stroke extends half its width on each side
        const strokeWidth = this.getStrokeWidth(el);
        if (strokeWidth > 0) {
            bounds.x -= strokeWidth / 2;
            bounds.y -= strokeWidth / 2;
            bounds.width += strokeWidth;
            bounds.height += strokeWidth;
        }
        
        return bounds;
    },
    
    getStrokeWidth: function(el) {
        // Check for stroke-width attribute
        let strokeWidth = parseFloat(el.getAttribute('stroke-width'));
        if (!isNaN(strokeWidth) && strokeWidth > 0) {
            return strokeWidth;
        }
        
        // Check for stroke attribute (if there's a stroke but no explicit width, default is 1)
        const stroke = el.getAttribute('stroke');
        if (stroke && stroke !== 'none') {
            return 1; // SVG default stroke-width
        }
        
        // Check computed style if element is in DOM
        if (el.ownerDocument && el.ownerDocument.defaultView) {
            try {
                const computedStyle = el.ownerDocument.defaultView.getComputedStyle(el);
                const computedStroke = computedStyle.stroke;
                const computedStrokeWidth = parseFloat(computedStyle.strokeWidth);
                
                if (computedStroke && computedStroke !== 'none' && !isNaN(computedStrokeWidth)) {
                    return computedStrokeWidth;
                }
            } catch (e) {
                // Ignore errors from getComputedStyle
            }
        }
        
        return 0;
    },

    getPolyBounds: function(poly) {
        const points = poly.getAttribute('points');
        if (!points) return null;
        
        const coords = points.split(/[\s,]+/).filter(Boolean).map(Number);
        let minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity;
        
        for (let i = 0; i < coords.length; i += 2) {
            const x = coords[i], y = coords[i + 1];
            if (!isNaN(x) && !isNaN(y)) {
                minX = Math.min(minX, x); maxX = Math.max(maxX, x);
                minY = Math.min(minY, y); maxY = Math.max(maxY, y);
            }
        }
        
        return { x: minX, y: minY, width: maxX - minX, height: maxY - minY };
    },

    getPathBounds: function(path) {
        const d = path.getAttribute('d');
        if (!d) return null;
        
        // Parse path commands properly to track actual coordinates
        let minX = Infinity, minY = Infinity, maxX = -Infinity, maxY = -Infinity;
        let currentX = 0, currentY = 0;
        let startX = 0, startY = 0;
        
        // Simple path parser - handles M, L, H, V, C, S, Q, T, A, Z commands
        const commands = d.match(/[MmLlHhVvCcSsQqTtAaZz][^MmLlHhVvCcSsQqTtAaZz]*/g);
        if (!commands) return null;
        
        const updateBounds = function(x, y) {
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        };
        
        for (let i = 0; i < commands.length; i++) {
            const cmd = commands[i];
            const type = cmd[0];
            const coords = cmd.slice(1).trim().split(/[\s,]+/).filter(Boolean).map(Number);
            
            const isRelative = type === type.toLowerCase();
            
            switch (type.toUpperCase()) {
                case 'M': // Move
                    currentX = isRelative ? currentX + coords[0] : coords[0];
                    currentY = isRelative ? currentY + coords[1] : coords[1];
                    startX = currentX;
                    startY = currentY;
                    updateBounds(currentX, currentY);
                    break;
                    
                case 'L': // Line
                    for (let j = 0; j < coords.length; j += 2) {
                        currentX = isRelative ? currentX + coords[j] : coords[j];
                        currentY = isRelative ? currentY + coords[j + 1] : coords[j + 1];
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'H': // Horizontal line
                    for (let j = 0; j < coords.length; j++) {
                        currentX = isRelative ? currentX + coords[j] : coords[j];
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'V': // Vertical line
                    for (let j = 0; j < coords.length; j++) {
                        currentY = isRelative ? currentY + coords[j] : coords[j];
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'C': // Cubic bezier
                    for (let j = 0; j < coords.length; j += 6) {
                        const cp1x = isRelative ? currentX + coords[j] : coords[j];
                        const cp1y = isRelative ? currentY + coords[j + 1] : coords[j + 1];
                        const cp2x = isRelative ? currentX + coords[j + 2] : coords[j + 2];
                        const cp2y = isRelative ? currentY + coords[j + 3] : coords[j + 3];
                        currentX = isRelative ? currentX + coords[j + 4] : coords[j + 4];
                        currentY = isRelative ? currentY + coords[j + 5] : coords[j + 5];
                        updateBounds(cp1x, cp1y);
                        updateBounds(cp2x, cp2y);
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'S': // Smooth cubic bezier
                    for (let j = 0; j < coords.length; j += 4) {
                        const cp2x = isRelative ? currentX + coords[j] : coords[j];
                        const cp2y = isRelative ? currentY + coords[j + 1] : coords[j + 1];
                        currentX = isRelative ? currentX + coords[j + 2] : coords[j + 2];
                        currentY = isRelative ? currentY + coords[j + 3] : coords[j + 3];
                        updateBounds(cp2x, cp2y);
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'Q': // Quadratic bezier
                    for (let j = 0; j < coords.length; j += 4) {
                        const cpx = isRelative ? currentX + coords[j] : coords[j];
                        const cpy = isRelative ? currentY + coords[j + 1] : coords[j + 1];
                        currentX = isRelative ? currentX + coords[j + 2] : coords[j + 2];
                        currentY = isRelative ? currentY + coords[j + 3] : coords[j + 3];
                        updateBounds(cpx, cpy);
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'T': // Smooth quadratic bezier
                    for (let j = 0; j < coords.length; j += 2) {
                        currentX = isRelative ? currentX + coords[j] : coords[j];
                        currentY = isRelative ? currentY + coords[j + 1] : coords[j + 1];
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'A': // Arc
                    for (let j = 0; j < coords.length; j += 7) {
                        currentX = isRelative ? currentX + coords[j + 5] : coords[j + 5];
                        currentY = isRelative ? currentY + coords[j + 6] : coords[j + 6];
                        updateBounds(currentX, currentY);
                    }
                    break;
                    
                case 'Z': // Close path
                    currentX = startX;
                    currentY = startY;
                    break;
            }
        }
        
        if (minX === Infinity) return null;
        
        return { x: minX, y: minY, width: maxX - minX, height: maxY - minY };
    },

    getTextBounds: function(text) {
        const x = parseFloat(text.getAttribute('x')) || 0;
        const y = parseFloat(text.getAttribute('y')) || 0;
        const fontSize = parseFloat(text.getAttribute('font-size')) || 16;
        const textContent = text.textContent || '';
        
        const approxWidth = textContent.length * fontSize * 0.6;
        const approxHeight = fontSize;
        
        return {
            x: x, y: y - approxHeight * 0.8,
            width: approxWidth, height: approxHeight
        };
    },
    
    // SVG color-detection and re-mapping

    // Extract all colors used in SVG fill and stroke attributes
    // @param {string|Element} svgInput - SVG string or SVG DOM element
    // @return {Array} Array of unique colors found
    //
    svgGetColors: function(svgInput) {
        let svgElement;

        // Handle both string and element inputs
        if (typeof svgInput === 'string') {
            // Create a temporary container to parse the SVG string
            const parser = new DOMParser();
            const doc = parser.parseFromString(svgInput, 'image/svg+xml');
            svgElement = doc.documentElement;
        } else if (svgInput instanceof Element) {
            svgElement = svgInput;
        } else {
            throw new Error('Input must be an SVG string or SVG element');
        }

        const colors = [];

        // Helper function to check if color already exists in array
        const colorExists = function (colorArray, color) {
            for (let i = 0; i < colorArray.length; i++) {
                if (colorArray[i] === color) {
                    return true;
                }
            }
            return false;
        };

        // Helper function to check if color already exists in array
        const ignoreColor = function (color) {
            // ignore "none" and transparent - definitely don't want to change that at runtime
            if (color == "none" || color == "transparent") return true;
            // ignore "white" - it'll never be a color we want to change - applications are 
            // typically white with dark icons or dark with light icons - unless this icon
            // was specifically designed for a dark skin, white should not be colorizable
            if (color == "white") return true;
            return false;
        }

        // Helper function to extract color from a value
        const extractColor = function (value) {
            if (!value || value === 'none' || value === 'transparent') {
                return null;
            }

            // Handle various color formats
            value = value.trim().toLowerCase();

            // Skip gradients and patterns
            if (value.indexOf('url(') === 0) {
                return null;
            }

            // Check for hex colors
            if (value.match(/^#[0-9a-f]{3,8}$/i)) {
                return value;
            }

            // Check for rgb/rgba colors
            if (value.match(/^rgba?\([^)]+\)$/i)) {
                return value;
            }

            // Check for hsl/hsla colors
            if (value.match(/^hsla?\([^)]+\)$/i)) {
                return value;
            }

            // Check for named colors (basic check)
            const namedColors = [
                'aliceblue', 'antiquewhite', 'aqua', 'aquamarine', 'azure', 'beige', 'bisque', 'black',
                'blanchedalmond', 'blue', 'blueviolet', 'brown', 'burlywood', 'cadetblue', 'chartreuse',
                'chocolate', 'coral', 'cornflowerblue', 'cornsilk', 'crimson', 'cyan', 'darkblue',
                'darkcyan', 'darkgoldenrod', 'darkgray', 'darkgreen', 'darkgrey', 'darkkhaki',
                'darkmagenta', 'darkolivegreen', 'darkorange', 'darkorchid', 'darkred', 'darksalmon',
                'darkseagreen', 'darkslateblue', 'darkslategray', 'darkslategrey', 'darkturquoise',
                'darkviolet', 'deeppink', 'deepskyblue', 'dimgray', 'dimgrey', 'dodgerblue',
                'firebrick', 'floralwhite', 'forestgreen', 'fuchsia', 'gainsboro', 'ghostwhite',
                'gold', 'goldenrod', 'gray', 'green', 'greenyellow', 'grey', 'honeydew', 'hotpink',
                'indianred', 'indigo', 'ivory', 'khaki', 'lavender', 'lavenderblush', 'lawngreen',
                'lemonchiffon', 'lightblue', 'lightcoral', 'lightcyan', 'lightgoldenrodyellow',
                'lightgray', 'lightgreen', 'lightgrey', 'lightpink', 'lightsalmon', 'lightseagreen',
                'lightskyblue', 'lightslategray', 'lightslategrey', 'lightsteelblue', 'lightyellow',
                'lime', 'limegreen', 'linen', 'magenta', 'maroon', 'mediumaquamarine', 'mediumblue',
                'mediumorchid', 'mediumpurple', 'mediumseagreen', 'mediumslateblue', 'mediumspringgreen',
                'mediumturquoise', 'mediumvioletred', 'midnightblue', 'mintcream', 'mistyrose',
                'moccasin', 'navajowhite', 'navy', 'oldlace', 'olive', 'olivedrab', 'orange',
                'orangered', 'orchid', 'palegoldenrod', 'palegreen', 'paleturquoise', 'palevioletred',
                'papayawhip', 'peachpuff', 'peru', 'pink', 'plum', 'powderblue', 'purple', 'red',
                'rosybrown', 'royalblue', 'saddlebrown', 'salmon', 'sandybrown', 'seagreen',
                'seashell', 'sienna', 'silver', 'skyblue', 'slateblue', 'slategray', 'slategrey',
                'snow', 'springgreen', 'steelblue', 'tan', 'teal', 'thistle', 'tomato', 'turquoise',
                'violet', 'wheat', 'white', 'whitesmoke', 'yellow', 'yellowgreen'
            ];

            for (let i = 0; i < namedColors.length; i++) {
                if (namedColors[i] === value) {
                    return value;
                }
            }

            return null;
        };

        // Get all elements that might have fill or stroke
        const allElements = svgElement.querySelectorAll('*');
        const elementsToCheck = [svgElement];

        // Add all elements to the check list
        for (let i = 0; i < allElements.length; i++) {
            elementsToCheck.push(allElements[i]);
        }

        for (let i = 0; i < elementsToCheck.length; i++) {
            const element = elementsToCheck[i];

            // Check fill attribute
            const fill = element.getAttribute('fill');
            if (fill) {
                const color = extractColor(fill);
                if (color && !ignoreColor(color) && !colorExists(colors, color)) {
                    colors.push(color);
                }
            }

            // Check stroke attribute
            const stroke = element.getAttribute('stroke');
            if (stroke) {
                const color = extractColor(stroke);
                if (color && !colorExists(colors, color)) {
                    colors.push(color);
                }
            }

            // Check style attribute for fill and stroke
            const style = element.getAttribute('style');
            if (style) {
                const styleRules = style.split(';');
                for (let j = 0; j < styleRules.length; j++) {
                    const rule = styleRules[j].trim();
                    const colonIndex = rule.indexOf(':');
                    if (colonIndex > -1) {
                        const property = rule.substring(0, colonIndex).trim();
                        const value = rule.substring(colonIndex + 1).trim();

                        if (property === 'fill' || property === 'stroke') {
                            const color = extractColor(value);
                            if (color && !ignoreColor(color) && !colorExists(colors, color)) {
                                colors.push(color);
                            }
                        }
                    }
                }
            }
        }

        return colors;
    },

    // Replace a color in SVG content
    // @param {string|Element} svgInput - SVG string or SVG DOM element
    // @param {string} oldColor - Color to replace
    // @param {string} newColor - Replacement color
    // @return {string} SVG content as string with colors replaced
    svgReplaceColor : function(svgInput, oldColor, newColor) {
        let svgString;
    
        // Convert input to string
        if (typeof svgInput === 'string') {
            svgString = svgInput;
        } else if (svgInput instanceof Element) {
            svgString = svgInput.outerHTML;
        } else {
            throw new Error('Input must be an SVG string or SVG element');
        }

        // Normalize colors for comparison
        const normalizeColor = function (color) {
            return color.trim().toLowerCase();
        };

        const normalizedOldColor = normalizeColor(oldColor);
        const normalizedNewColor = normalizeColor(newColor);

        if (normalizedOldColor == normalizedNewColor) {
            return svgString;
        }

        // Replace in attributes (fill="color" and stroke="color")
        svgString = svgString.replace(/fill\s*=\s*["']([^"']+)["']/gi, function(match, colorValue) {
            if (normalizeColor(colorValue) === normalizedOldColor) {
                return match.replace(colorValue, newColor);
            }
            return match;
        });
    
        svgString = svgString.replace(/stroke\s*=\s*["']([^"']+)["']/gi, function(match, colorValue) {
            if (normalizeColor(colorValue) === normalizedOldColor) {
                return match.replace(colorValue, newColor);
            }
            return match;
        });
    
        // Replace in style attributes
        svgString = svgString.replace(/style\s*=\s*["']([^"']+)["']/gi, function(match, styleValue) {
            let newStyleValue = styleValue;
      
            // Replace fill in style
            newStyleValue = newStyleValue.replace(/fill\s*:\s*([^;]+)/gi, function(styleMatch, colorValue) {
                if (normalizeColor(colorValue) === normalizedOldColor) {
                    return styleMatch.replace(colorValue, newColor);
                }
                return styleMatch;
            });
      
            // Replace stroke in style
            newStyleValue = newStyleValue.replace(/stroke\s*:\s*([^;]+)/gi, function(styleMatch, colorValue) {
                if (normalizeColor(colorValue) === normalizedOldColor) {
                    return styleMatch.replace(colorValue, newColor);
                }
                return styleMatch;
            });
      
            return match.replace(styleValue, newStyleValue);
        });
    
        return svgString;
    }

    //> @groupDef stockIcons
    // The <i>StockIcons</i> system allows known graphics to be re-used throughout your 
    // projects by using their names in src-strings, instead of their URLs or sprite-strings - 
    // this avoids the need for hard-coded paths in source-code, and allows the actual image 
    // applied by the StockIcon name to be easily modified <b><i>at runtime</i></b> without 
    // trawling through code doing find-and-replace operations.
    // <p>
    // StockIcons can also map +link{StockIcon.fromSrc, from} a known file-path, meaning that 
    // legacy paths in existing code don't need to be modified - if your code requests a 
    // file-path which is assigned to the <i>fromSrc</i> of a known StockIcon, it will first 
    // be mapped to that StockIcon, and then it will render whatever image is 
    // +link{StockIcon.src, currently assigned} to it.
    // <p>
    // The framework ships with +link{Media.getStockIconNames, many such StockIcon-definitions} 
    // that represent the numerous images available in the "images/" directory of a skin.  
    // You can use these builtin definitions in your code directly, by setting a widget's 
    // icon or src property to the name of a StockIcon. For example, to re-use the current 
    // skin's default "Edit" icon, you could set the image-source for a button's 
    // +link{button.icon, icon} to "[SKINIMG]actions/edit.png" in your code.  With StockIcons, 
    // you can use just the associated icon's name, "Edit" - for example:
    // <pre>
    // isc.Button.create({ icon: "Edit" });
    // isc.Img.create({ src: "Edit" });
    // </pre>
    // <p>
    // You can also provide additional customization along with the StockIcon-name.  For 
    // example, if your StockIcons are mapped to +link{group:svgSymbols, stylable SVG Symbols} 
    // via +link{type:SCSpriteConfig, sprite-strings} (our Shiva skin does this), you can 
    // add a colon (":") right after the StockIcon-name and then include any additional 
    // properties that are supported by SVG sprite-strings, to modify this instance of the 
    // base StockIcon definition.
    // <pre>
    // // make it red and semi-transparent
    // isc.Button.create({ icon: "Edit:color:red;opacity:0.5;" });
    // // set a size and show it upside-down
    // isc.Img.create({ src: "Edit:size:24,24;rotate:180;" });
    // </pre>
    // <p>
    // @title StockIcons Overview
    // @treeLocation Client Reference/Media
    // @visibility external
    //<
    
    //> @object StockIconGroup
    // An object that groups +link{object:StockIcon, StockIcons} together
    // 
    // @group media, stockIcons
    // @treeLocation Client Reference/Media
    // @visibility internal
    //<

    //> @object StockIcon
    // An object that represents a known image by mapping a unique 
    // +link{stockIcon.name, name} to an +link{stockIcon.src, image-src}.  The current 
    // image-src may be modified at runtime and developers 
    // may use these known images by name in any +link{type:SCImgURL, image-property} - for 
    // example, +link{statefulCanvas.icon, icon}: "Edit" or +link{Img.src, src}: "Accept"
    // would show whatever image-src is +link{stockIcon.src, currently mapped} to those 
    // builtin stockIcons.
    // <pre>
    // isc.Button.create({ icon: "Edit" });
    // isc.Img.create({ src: "Edit" });
    // </pre>
    // <p>
    // It's also possible to extend a known <code>StockIcon</code> each time 
    // you use it, by stating it's name followed by a colon and any additional settings 
    // supported by the +link{type:SCSpriteConfig} type.  For example, you might be mapping 
    // the builtin "Edit" icon to a +link{group:svgSymbols, stylable SVG Symbol} (the default 
    // behavior of the Shiva skin) and have some edge-case that requires you to show it in red, 
    // or even upside down: 
    // <pre>
    // isc.Img.create({ src: "Edit:color:red;" });
    // isc.Img.create({ src: "Edit:rotate:180;" });
    // </pre>
    // <p>
    // While a <code>StockIcon</code> maps a unique name to an image-src, it can also map
    // <b><i>from</i></b> a known file-path via the +link{stockIcon.fromSrc, fromSrc property}.  
    // If that attribute is set on a stockIcon, any request for the URL it represents 
    // will be mapped to that stockIcon and render its current <code>src</code> instead.
    // <p>
    // Developers may also add custom StockIcons either by calling 
    // +link{Media.addStockIcons, addStockIcons()} or by passing an existing 
    // +link{object:IconSet} to +link{Media.useMedia, useMedia()}, and these can be used in 
    // the same way as builtin ones - once installed, code can refer to them by name.  Later, 
    // the icons can be modified individually or in bulk by calling 
    // +link{Media.updateIconMappings, updateIconMappings()} which will update the current 
    // src property on the named stockIcons and refresh the UI.
    // <p>
    // As an example, assume you have multiple projects - each of these has an image in the 
    // base dir called "appLogo.png", which is displayed in many places.  You could define 
    // a StockIcon to map that known file-path to a global name, like this:
    // <pre>
    // isc.Media.addStockIcons([
    //     {
    //         name: "AppLogo",
    //         fromSrc: "[APP]appLogo.png",
    //         src: null
    //     }
    // ]);
    // </pre>
    // Now, you can refer to this icon in code by just the name "AppLogo".  Because you 
    // applied a <i>fromSrc</i>, any requests from existing code for that file-path will 
    // also be mapped to this StockIcon-name.
    // <p>
    // So at this point, any code that sets an image-source to either "[APP]appLogo.png" 
    // or "AppLogo" with render whatever is +link{StockIcon.src, currently assigned} to 
    // your new StockIcon.  Since there is no <b><i>src</i></b> in the definition, it defaults 
    // to the <b><i>fromSrc</i></b> and both will render "[APP]appLogo.png".
    // <pre>
    // isc.Button.create({ icon: "[APP]appLogo.png" })
    // isc.Button.create({ icon: "AppLogo" })
    // </pre>
    // <p>
    // In the future, you might refresh the UI in your project and want to update your 
    // app-logo image.  You can easily +link{Media.updateIconMappings, assign new mappings} to 
    // any StockIcon at runtime, and all uses of them will be updated to reflect the new 
    // +link{StockIcon.src, src}.
    // <pre>
    // // define a mapping for the AppLogo image, to a new SVG symbol from a sprite file
    // var newMappings = { "AppLogo": "sprite:svg:[APP]svgIcons.svg#appLogo" };
    // 
    // // apply the mapping - this call will update the <i>src</i> property on the StockIcon 
    // // and notify the framework that the icon's been updated, so the UI can update
    // isc.Media.updateIconMappings(newMappings);
    // </pre>
    // Anywhere you use the "AppLogo" icon in your code, by name or path (fromSrc), it will 
    // now render the updated mapping and show your SVG symbol instead of the original PNG.  
    // In this case, because it's an SVG, you can re-style the base StockIcon each time you 
    // use it, perhaps changing it's color for use in different contexts.
    // <pre>
    // // perhaps your logo goes red when a critical app-update is pending
    // isc.Img.create({ src: "AppLogo:color:red;" });
    // 
    // // or perhaps you show it as a watermark in the background of the page
    // isc.Img.create({ src: "AppLogo:size:500,500;opacity:0.2;" });
    // </pre>
    // <p>
    // For more information about installing multiple new StockIcons at once, or applying 
    // overlays of mappings to existing ones, read about +link{object:IconSet} and 
    // +link{Media.useMedia}. 
    //
    // @group media, stockIcons
    // @treeLocation Client Reference/Media
    // @visibility external
    //<
    
    //> @attr stockIcon.name (String : null : IR)
    // The unique name for this icon, which must be a valid JavaScript Identifier and may be 
    // used by developers as the src-string for any 
    // +link{type:SCImgURL, image-property}, to show whatever image is 
    // +link{stockIcon.src, currently assigned} to that stockIcon-name.  For 
    // example, +link{statefulCanvas.icon, button.icon}: "Edit" or +link{Img.src, img.src}: "Accept"
    // @group media, stockIcons
    // @visibility external
    //<
    
    //> @attr stockIcon.src (SCImgURL : null : IR)
    // The current source assigned to this stockIcon.  When developers use the 
    // +link{stockIcon.name, name} of a stockIcon as the src-string for any 
    // +link{type:SCImgURL, image-property}, this is the image-src that will be used.
    // <p>
    // When +link{stockIcon.fromSrc} is set, as it is for most built-in stockIcons, any 
    // request for the file-path it represents is mapped to this stockIcon and will render 
    // <code>stockIcon.src</code> instead.
    // <p>
    // If this attribute is set, it serves as an initial default.
    // <p>
    // If this attribute is not set, the default for most built-in icons, it will default to 
    // the full-path represented by the <code>stockIcon.fromSrc</code>.
    // <p>
    // You may set this attribute to the special value "empty" to provide a StockIcon which 
    // has no mapping and will not render any HTML by default, unless you assign a different 
    // src via a call to +link{Media.updateIconMappings} or in an +link{object:IconSet} passed 
    // to +link{Media.useMedia}.  In this way, if one skin applies a src for this stockIcon, it 
    // will be shown - if another skin doesn't apply a src, it won't render HTML at all.  For 
    // example, a Button would not show empty space where the icon should be.
    // @group media, stockIcons
    // @visibility external
    //<

    //> @attr stockIcon.fromSrc (SCImgURL : null : IR)
    // An +link{type:SCImgURL} that resolves to a known image file-path.  When that file-path 
    // is requested at runtime, it will be mapped to this stockIcon and replaced with the 
    // icon represented by +link{stockIcon.src}.
    // <p>
    // This attribute is optional, but most built-in stockIcons set this value to one of the 
    // image-paths in a skin's <i>images</i> directory ([SKINIMG] prefix).
    // <p>
    // Values applied to this property should be either a fixed path or a relative path
    // prefixed with a shortcut like [APPIMG] or [SKINIMG].  If your files are relative to
    // your application bootstrap, use [APP] as a prefix, because image-paths like 
    // "icons/logo.png" are not relative to your page, as you might expect - instead, they're 
    // relative to your +link{page.getAppImgDir(), appImgDir} which is typically [APP]/images/.
    // @group media, stockIcons
    // @visibility external
    //<
    
    //> @attr stockIcon.group (String : null : IR)
    // Optional name of a +link{object:StockIconGroup, group} to which this stockIcon belongs.
    // Can be used for filtering or grouped-display in widgets like the 
    // +link{class:ImagePicker}.
    // @group media, stockIcons
    // @visibility external
    //<

    //> @attr stockIcon.index (Integer : null : IR)
    // Optional index used for sorting in some widgets like the +link{class:ImagePicker}.
    // @group media, stockIcons
    // @visibility external
    //<

});


isc.Media.addClassProperties({
    // define metadata for the framework-wide standard actionIcons
    stockIcons: [
        {
            index: 2, 
            fromSrc:"[SKINIMG]blank.pnng", 
            name:"Blank", 
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/system.svg#empty;size:10,10;"
        },
        // group: "action" - all icons from images/actions
        {
            index: 5,
            fromSrc: "[SKINIMG]actions/pause.png",
            name: "Pause",
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#pause"
        },
        {
            index: 6,
            fromSrc: "[SKINIMG]actions/resume.png",
            name: "Resume",
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#resume"
        },
        {
            index: 10, 
            fromSrc:"[SKINIMG]actions/edit.png", 
            name:"Edit", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 20, 
            fromSrc:"[SKINIMG]actions/approve.png", 
            name:"Approve",
            group: "action"
        }, 
        {
            index: 30, 
            fromSrc:"[SKINIMG]actions/accept.png", 
            name:"Accept",
            group: "action"
        }, 
        {
            index: 40, 
            fromSrc:"[SKINIMG]actions/ok.png", 
            name:"Ok",
            group: "action"
        }, 
        {
            index: 50, 
            fromSrc:"[SKINIMG]actions/plus.png", 
            name:"Plus", 
            group: "action",
            "states":[
                "Disabled"
            ]
        },
        {
            index: 55, 
            fromSrc:"[SKINIMG]actions/minus.png", 
            name:"Minus", 
            group: "action"
        },
        {
            index: 60, 
            fromSrc:"[SKINIMG]actions/add.png", 
            name:"Add", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 70, 
            fromSrc:"[SKINIMG]actions/remove.png", 
            name:"Remove", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 80, 
            fromSrc:"[SKINIMG]actions/cancel.png", 
            name:"Cancel",
            group: "action"
        }, 
        {
            index: 90, 
            fromSrc:"[SKINIMG]actions/close.png", 
            name:"Close", 
            group: "action",
            "states":[
                "Disabled", 
                "Down", 
                "Over"
            ]
        }, 
        {
            index: 100, 
            fromSrc:"[SKINIMG]actions/exclamation.png", 
            name:"Exclamation",
            group: "action"
        }, 
        {
            index: 110, 
            fromSrc:"[SKINIMG]actions/help.png", 
            name:"Help",
            group: "action"
        },
        {
            index: 120, 
            fromSrc:"[SKINIMG]actions/undo.png", 
            name:"Undo",
            group: "action"
        }, 
        {
            index: 130, 
            fromSrc:"[SKINIMG]actions/redo.png", 
            name:"Redo",
            group: "action"
        }, 
        {
            index: 140, 
            fromSrc:"[SKINIMG]actions/refresh.png", 
            name:"Refresh", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 150, 
            fromSrc:"[SKINIMG]actions/first.png", 
            name:"First",
            group: "action"
        }, 
        {
            index: 160, 
            fromSrc:"[SKINIMG]actions/prev.png", 
            name:"Prev",
            group: "action"
        }, 
        {
            index: 170, 
            fromSrc:"[SKINIMG]actions/next.png", 
            name:"Next",
            group: "action"
        }, 
        {
            index: 180, 
            fromSrc:"[SKINIMG]actions/last.png", 
            name:"Last",
            group: "action"
        }, 
        {
            index: 190, 
            fromSrc:"[SKINIMG]actions/back.png", 
            name:"Back", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 200, 
            fromSrc:"[SKINIMG]actions/forward.png", 
            name:"Forward", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 210, 
            fromSrc:"[SKINIMG]actions/auto_fit.png", 
            name:"Auto_fit",
            group: "action"
        }, 
        {
            index: 220, 
            fromSrc:"[SKINIMG]actions/auto_fit_all.png", 
            name:"Auto_fit_all",
            group: "action"
        }, 
        {
            index: 230, 
            fromSrc:"[SKINIMG]actions/freezeLeft.png", 
            name:"FreezeLeft",
            group: "action"
        }, 
        {
            index: 240, 
            fromSrc:"[SKINIMG]actions/freezeRight.png", 
            name:"FreezeRight",
            group: "action"
        }, 
        {
            index: 250, 
            fromSrc:"[SKINIMG]actions/unfreeze.png", 
            name:"Unfreeze",
            group: "action"
        }, 
        {
            index: 260, 
            fromSrc:"[SKINIMG]actions/groupby.png", 
            name:"Groupby",
            group: "action"
        }, 
        {
            index: 270, 
            fromSrc:"[SKINIMG]actions/column_preferences.png", 
            name:"Column_preferences",
            group: "action"
        }, 
        {
            index: 280, 
            fromSrc:"[SKINIMG]actions/configure.png", 
            name:"Configure",
            group: "action"
        }, 
        {
            index: 290, 
            fromSrc:"[SKINIMG]actions/configure_sort.png", 
            name:"Configure_sort",
            group: "action"
        }, 
        {
            index: 300, 
            fromSrc:"[SKINIMG]actions/sort_ascending.png", 
            name:"Sort_ascending",
            group: "action"
        }, 
        {
            index: 310, 
            fromSrc:"[SKINIMG]actions/sort_descending.png", 
            name:"Sort_descending",
            group: "action"
        }, 
        {
            index: 320, 
            fromSrc:"[SKINIMG]actions/clear_sort.png", 
            name:"Clear_sort",
            group: "action"
        }, 
        {
            index: 330, 
            fromSrc:"[SKINIMG]actions/text_linespacing.png", 
            name:"Text_linespacing",
            group: "action"
        },
        {
            index: 340, 
            fromSrc:"[SKINIMG]actions/ungroup.png", 
            name:"Ungroup",
            group: "action"
        }, 
        {
            index: 350, 
            fromSrc:"[SKINIMG]actions/drag.png", 
            name:"Drag", 
            group: "action",
            "states":[
                "Disabled"
            ]
        }, 
        {
            index: 360, 
            fromSrc:"[SKINIMG]actions/print.png", 
            name:"Print",
            group: "action"
        }, 
        {
            index: 370, 
            fromSrc:"[SKINIMG]actions/save.png", 
            name:"Save",
            group: "action"
        }, 
        {
            index: 380, 
            fromSrc:"[SKINIMG]actions/dynamic.png", 
            name:"Dynamic",
            group: "action"
        }, 
        {
            index: 390, 
            fromSrc:"[SKINIMG]actions/filter.png", 
            name:"Filter",
            group: "action"
        }, 
        {
            index: 394, 
            fromSrc:"[SKINIMG]actions/filterActive.png", 
            name:"FilterActive",
            group: "action"
        }, 
        {
            index: 400, 
            fromSrc:"[SKINIMG]actions/search.png", 
            name:"Search",
            group: "action"
        }, 
        {
            index: 404, 
            fromSrc:"[SKINIMG]actions/find.png", 
            name:"Find",
            group: "action"
        }, 
        {
            index: 410, 
            fromSrc:"[SKINIMG]actions/view.png", 
            name:"View",
            group: "action"
        }, 
        {
            index: 420, 
            fromSrc:"[SKINIMG]actions/view_rtl.png", 
            name:"View_rtl",
            group: "action"
        },
        {
            index: 430, 
            fromSrc:"[SKINIMG]actions/download.png", 
            name:"Download",
            group: "action"
        }, 
        {
            index: 440, 
            fromSrc:"[SKINIMG]actions/color_swatch.png", 
            name:"Color_swatch",
            group: "action"
        },
        {
            index: 450, 
            fromSrc:"[SKINIMG]actions/clearFilter.png", 
            name:"ClearFilter",
            group: "action"
        },
        {
            index: 460, 
            fromSrc:"[SKINIMG]actions/export.png", 
            name:"Export",
            group: "action"
        }

,
        {
            index: 470, 
            fromSrc:"[SKINIMG]actions/add_files.png", 
            name:"Add_Files",
            states: ["disabled"],
            group: "action"
        },
        {
            index: 480, 
            fromSrc:"[SKINIMG]actions/remove_files.png", 
            name:"Remove_Files",
            states: ["disabled"],
            group: "action"
        },
        {
            index: 490, 
            fromSrc:"[SKINIMG]actions/expand_right.png", 
            name:"Expand_Right",
            states: ["disabled"],
            group: "action"
        },
        {
            index: 500, 
            fromSrc:"[SKINIMG]actions/collapse_left.png", 
            name:"Collapse_Left",
            states: ["disabled"],
            group: "action"
        },

        // AI icons
        {
            index: 550, 
            fromSrc:"[SKINIMG]AI/robot_blue.png", 
            name:"AIAssist",
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#robot"
        },
        {
            index: 551,
            fromSrc:"[SKINIMG]AI/robot_blue.png",
            name:"AIAnswerEngine",
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#robot2"
        },

        {
            index: 560,
            fromSrc:"[SKINIMG]actions/relatedFields.png", 
            name:"Related_Fields", 
            group: "action",
            src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#related_fields"
        },

        {
            index: 565,
            fromSrc:"[SKINIMG]actions/sigma.png", 
            name:"Functions", 
            group: "action"
            //,
            //src: "sprite:svg:[HELPERS]media/svg/stockIcons.svg#functions"
        },

        // images/buttons - empty
        
        // images/Calendar
        {
            index: 600, 
            fromSrc:"[SKINIMG]Calendar/gripper.png", 
            name:"Gripper",
            group: "calendar"
        },
        {
            index: 610, 
            fromSrc:"[SKINIMG]Calendar/leadingDateGripper.png", 
            name:"LeadingDate_Gripper",
            group: "calendar"
        },
        {
            index: 620, 
            fromSrc:"[SKINIMG]Calendar/trailingDateGripper.png", 
            name:"TrailingDate_Gripper",
            group: "calendar"
        },

        // images/Class - empty

        // images/ColorPicker
        {
            index: 700, 
            fromSrc:"[SKINIMG]ColorPicker/close.png", 
            name:"ColorPicker_Close",
            group: "colorPicker"
        },
        {
            index: 710, 
            fromSrc:"[SKINIMG]ColorPicker/crosshair.png", 
            name:"Crosshair",
            group: "colorPicker"
        },

        {
            index: 750, 
            fromSrc:"[SKINIMG]DynamicForm/ColorPicker_icon.png", 
            name:"Color",
            group: "colorPicker"
        },
        {
            index: 752, 
            fromSrc:"[SKINIMG]DynamicForm/ColorPicker_icon_overlayLight.png", 
            name:"Color_Light",
            group: "colorPicker"
        },
        {
            index: 754, 
            fromSrc:"[SKINIMG]DynamicForm/ColorPicker_icon_overlayDark.png", 
            name:"Color_Dark",
            group: "colorPicker"
        },

        // images/controls - I think these icons all come from images/DynamicForm now

        // images/cssButton - stretch images - presumably old

        // images/CubeGrid
        // add with indexes from 800 

        // images/DateChooser
        {
            index: 900, 
            fromSrc:"[SKINIMG]DateChooser/arrow_left.png", 
            name:"DateChooser_Previous",
            group: "dateChooser"
        },
        {
            index: 910, 
            fromSrc:"[SKINIMG]DateChooser/arrow_right.png", 
            name:"DateChooser_Next",
            group: "dateChooser"
        },
        {
            index: 920, 
            fromSrc:"[SKINIMG]DateChooser/doubleArrow_left.png", 
            name:"DateChooser_First",
            group: "dateChooser"
        },
        {
            index: 930, 
            fromSrc:"[SKINIMG]DateChooser/doubleArrow_right.png", 
            name:"DateChooser_Last",
            group: "dateChooser"
        },

        // images/Dialog
        {
            index: 1000, 
            fromSrc:"[SKINIMG]Dialog/ask.png", 
            name:"Dialog_Ask",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1010, 
            fromSrc:"[SKINIMG]Dialog/confirm.png", 
            name:"Dialog_Confirm",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1020, 
            fromSrc:"[SKINIMG]Dialog/error.png", 
            name:"Dialog_Error",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1030, 
            fromSrc:"[SKINIMG]Dialog/notify.png", 
            name:"Dialog_Notify",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1040, 
            fromSrc:"[SKINIMG]Dialog/say.png", 
            name:"Dialog_Say",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1050, 
            fromSrc:"[SKINIMG]Dialog/stop.png", 
            name:"Dialog_Stop",
            states: ["disabled"],
            group: "dialog"
        },
        {
            index: 1060, 
            fromSrc:"[SKINIMG]Dialog/warn.png", 
            name:"Dialog_Warn",
            states: ["disabled"],
            group: "dialog"
        },
        
        // images/FileBrowser - index 1100+ - not sure if these are "stock", per-se

        // images/GradientEditor
        {
            index: 1200, 
            fromSrc:"[SKINIMG]GradientEditor/stopBar_stopBottom.png", 
            name:"StopButton_Up",
            group: "gradientEditor"
        },
        {
            index: 1210, 
            fromSrc:"[SKINIMG]GradientEditor/stopBar_stopTop.png", 
            name:"StopButton_Down",
            group: "gradientEditor"
        },
        {
            index: 1220, 
            fromSrc:"[SKINIMG]GradientEditor/transparency.png", 
            name:"Transparency",
            group: "gradientEditor"
        },
        
        // images/headerIcons - 1300+ - applies elsewhere in this file
        
        // images/Imgbutton - don't think these are needed, future-wise
        
        // images/iOS - single image "more", not sure what it's used for
        {
            index: 1500, 
            fromSrc:"[SKINIMG]iOS/more.png", 
            name:"iOS_More",
            group: "iOS"
        },
        
        // images/ListGrid - 1600+ - add some of these 
        {
            index: 1600, 
            fromSrc:"[SKINIMG]ListGrid/formula_menuItem.png", 
            name:"Grid_Formula",
            group: "ListGrid"
        }, 
        {
            index: 1610, 
            fromSrc:"[SKINIMG]ListGrid/group_closed.png", 
            name:"Grid_Group_closed",
            group: "ListGrid"
        }, 
        {
            index: 1620, 
            fromSrc:"[SKINIMG]ListGrid/group_opened.png", 
            name:"Grid_Group_opened",
            group: "ListGrid"
        }, 
        {
            index: 1630, 
            fromSrc:"[SKINIMG]ListGrid/row_collapsed.png", 
            name:"Grid_Row_collapsed",
            group: "ListGrid"
        }, 
        {
            index: 1640, 
            fromSrc:"[SKINIMG]ListGrid/row_expanded.png", 
            name:"Grid_Row_expanded",
            group: "ListGrid"
        }, 
        {
            index: 1650, 
            fromSrc:"[SKINIMG]ListGrid/sort_ascending.png", 
            name:"Grid_Sort_ascending",
            group: "ListGrid"
        }, 
        {
            index: 1660, 
            fromSrc:"[SKINIMG]ListGrid/sort_descending.png", 
            name:"Grid_Sort_descending",
            group: "ListGrid"
        }, 

        // images/Menu - 1700+ = add some of these 
        {
            index: 1700, 
            fromSrc:"[SKINIMG]Menu/check.png", 
            name:"Menu_Check",
            group: "Menu"
        }, 
        {
            index: 1710, 
            fromSrc:"[SKINIMG]Menu/down.png", 
            name:"Menu_Down",
            group: "Menu"
        }, 
        {
            index: 1720, 
            fromSrc:"[SKINIMG]Menu/submenu.png", 
            name:"Menu_Submenu",
            group: "Menu"
        }, 
        {
            index: 1730, 
            fromSrc:"[SKINIMG]Menu/up.png", 
            name:"Menu_Up",
            group: "Menu"
        }, 


        // images/MultiUploadItem - add files and remove files icons moved to "actions"

        // images/NavigationBar - not sure about these ones just yet
        {
            index: 1800, 
            fromSrc:"[SKINIMG]NavigationBar/back_arrow.png", 
            name:"Navigate_Back",
            group: "navigationBar"
        },
        {
            index: 1810, 
            fromSrc:"[SKINIMG]NavigationBar/miniNav_up.png", 
            name:"MiniNav_Up",
            group: "navigationBar"
        },
        {
            index: 1820, 
            fromSrc:"[SKINIMG]NavigationBar/miniNav_down.png", 
            name:"MiniNav_Down",
            group: "navigationBar"
        },

        // Notify icons
        {
            index: 2000, 
            fromSrc:"[SKINIMG]Notify/checkmark.png", 
            name:"Notify_checkmark",
            group: "notify"
        },
        {
            index: 2010, 
            fromSrc:"[SKINIMG]Notify/close.png", 
            name:"Notify_close",
            group: "notify"
        },
        {
            index: 2020, 
            fromSrc:"[SKINIMG]Notify/error.png", 
            name:"Notify_error",
            group: "notify"
        },
        {
            index: 2030, 
            fromSrc:"[SKINIMG]Notify/warning.png", 
            name:"Notify_warning",
            group: "notify"
        },
        
        // images/Panel - nothing
        
        // images/pickers - these are all old, using sprites now
        {
            index: 2100, 
            fromSrc:"[SKINIMG]pickers/date_picker.png", 
            name:"Pickers_Date",
            group: "pickers"
        },
        
        
        // images/ProgressBar - nothing
        
        // images/RecordEditor - add/remove icons, probably should be using the usual ones
        {
            index: 2300, 
            fromSrc:"[SKINIMG]RecordEditor/filter.png", 
            name:"RecordEditor_filter",
            group: "recordEditor",
            states: [ "Over", "Disabled" ]
        },
        
        // images/RichTextEditor - these should be added, eventually
        {
            index: 2350, 
            fromSrc:"[SKINIMG]RichTextEditor/text_align_center.png", 
            name:"Format_align_center",
            group: "Format"
        },
        {
            index: 2360, 
            fromSrc:"[SKINIMG]RichTextEditor/text_align_justified.png", 
            name:"Format_align_justify",
            group: "Format"
        },
        {
            index: 2370, 
            fromSrc:"[SKINIMG]RichTextEditor/text_align_left.png", 
            name:"Format_align_left",
            group: "Format"
        },
        {
            index: 2380, 
            fromSrc:"[SKINIMG]RichTextEditor/text_align_right.png", 
            name:"Format_align_right",
            group: "Format"
        },
        {
            index: 2390, 
            fromSrc:"[SKINIMG]RichTextEditor/text_color.png", 
            name:"Format_text_color",
            group: "Format"
        },
        {
            index: 2400, 
            fromSrc:"[SKINIMG]RichTextEditor/background_color.png", 
            name:"Format_fill_color",
            group: "Format"
        },
        {
            index: 2410, 
            fromSrc:"[SKINIMG]RichTextEditor/text_bold.png", 
            name:"Format_bold",
            group: "Format"
        },
        {
            index: 2420, 
            fromSrc:"[SKINIMG]RichTextEditor/text_italic.png", 
            name:"Format_italic",
            group: "Format"
        },
        {
            index: 2430, 
            fromSrc:"[SKINIMG]RichTextEditor/text_underline.png", 
            name:"Format_underline",
            group: "Format"
        },
        {
            index: 2440, 
            fromSrc:"[SKINIMG]RichTextEditor/indent.png", 
            name:"Format_indent_increase",
            group: "Format"
        },
        {
            index: 2450, 
            fromSrc:"[SKINIMG]RichTextEditor/outdent.png", 
            name:"Format_indent_decrease",
            group: "Format"
        },
        {
            index: 2460, 
            fromSrc:"[SKINIMG]RichTextEditor/text_list_bullets.png", 
            name:"Format_list_bulleted",
            group: "Format"
        },
        {
            index: 2470, 
            fromSrc:"[SKINIMG]RichTextEditor/text_list_numbers.png", 
            name:"Format_list_numbered",
            group: "Format"
        },
        {
            index: 2480, 
            fromSrc:"[SKINIMG]RichTextEditor/copy.png", 
            name:"Format_copy",
            group: "Format"
        },
        
        // images/SchemaViewer - nothing stock
        
        // images/Scrollbar - sprites
        
        // images/SectionHeader - 
        {
            index: 2500, 
            fromSrc:"[SKINIMG]SectionHeader/opener_closed.png", 
            name:"SectionHeader_closed",
            group: "sectionHeader"
        },
        {
            index: 2510, 
            fromSrc:"[SKINIMG]SectionHeader/opener_opened.png", 
            name:"SectionHeader_opened",
            group: "sectionHeader"
        },
        
        // images/shared - nothing
        // images/Slider - nothing relevant
        // images/Splitbar - maybe later
        // images/Tab - nothing
        // images/TabSet
        {
            index: 2700, 
            fromSrc:"[SKINIMG]TabSet/close.png", 
            name:"TabSet_close",
            group: "tabSet"
        },

        // images/ToolStrip
        {
            index: 2800, 
            fromSrc:"[SKINIMG]ToolStrip/hresizer.png", 
            name:"ToolStrip_hresizer",
            group: "toolStrip"
        },
        {
            index: 2810, 
            fromSrc:"[SKINIMG]ToolStrip/hseparator.png", 
            name:"ToolStrip_hseparator",
            group: "toolStrip"
        },
        {
            index: 2820, 
            fromSrc:"[SKINIMG]ToolStrip/resizer.png", 
            name:"ToolStrip_vresizer",
            group: "toolStrip"
        },
        {
            index: 2830, 
            fromSrc:"[SKINIMG]ToolStrip/separator.png", 
            name:"ToolStrip_vseparator",
            group: "toolStrip"
        },

        // images/TransferIcons - probably need to be done
        {
            index: 2900, 
            fromSrc:"[SKINIMG]TransferIcons/left.png", 
            name:"TransferIcons_left",
            group: "TransferIcons"
        },
        {
            index: 2910, 
            fromSrc:"[SKINIMG]TransferIcons/right.png", 
            name:"TransferIcons_right",
            group: "TransferIcons"
        },
        {
            index: 2920, 
            fromSrc:"[SKINIMG]TransferIcons/left_all.png", 
            name:"TransferIcons_leftFirst",
            group: "TransferIcons"
        },
        {
            index: 2930, 
            fromSrc:"[SKINIMG]TransferIcons/right_all.png", 
            name:"TransferIcons_rightLast",
            group: "TransferIcons"
        },
        {
            index: 2940, 
            fromSrc:"[SKINIMG]TransferIcons/up.png", 
            name:"TransferIcons_up",
            group: "TransferIcons"
        },
        {
            index: 2950, 
            fromSrc:"[SKINIMG]TransferIcons/down.png", 
            name:"TransferIcons_down",
            group: "TransferIcons"
        },
        {
            index: 2960, 
            fromSrc:"[SKINIMG]TransferIcons/up_first.png", 
            name:"TransferIcons_upFirst",
            group: "TransferIcons"
        },
        {
            index: 2970, 
            fromSrc:"[SKINIMG]TransferIcons/down_last.png", 
            name:"TransferIcons_downLast",
            group: "TransferIcons"
        },
        
        // images/TreeGrid
        {
            index: 3000, 
            fromSrc:"[SKINIMG]TreeGrid/file.png", 
            name:"Tree_leaf",
            group: "treeGrid"
        },
        {
            index: 3010, 
            fromSrc:"[SKINIMG]TreeGrid/folder.png", 
            name:"Tree_folder",
            group: "treeGrid"
        },
        {
            index: 3020, 
            fromSrc:"[SKINIMG]TreeGrid/folder_closed.png", 
            name:"Tree_folderclosed",
            group: "treeGrid"
        },
        {
            index: 3030, 
            fromSrc:"[SKINIMG]TreeGrid/folder_drop.png", 
            name:"Tree_folderdrop",
            group: "treeGrid"
        },
        {
            index: 3040, 
            fromSrc:"[SKINIMG]TreeGrid/folder_file.png", 
            name:"Tree_folderfile",
            group: "treeGrid"
        },
        {
            index: 3050, 
            fromSrc:"[SKINIMG]TreeGrid/folder_loading.gif", 
            name:"Tree_folderloading",
            group: "treeGrid"
        },
        {
            index: 3060, 
            fromSrc:"[SKINIMG]TreeGrid/folder_open.png", 
            name:"Tree_folderopened",
            group: "treeGrid"
        },
        {
            index: 3070, 
            fromSrc:"[SKINIMG]TreeGrid/opener_closed.png", 
            name:"Tree_opener_closed",
            group: "treeGrid"
        },
        {
            index: 3080, 
            fromSrc:"[SKINIMG]TreeGrid/opener_opened.png", 
            name:"Tree_opener_opened",
            group: "treeGrid"
        },

        
        // images/Window - these are all in the "headerIcons" dir in Flat skins

        // checkbox icons
        {
            index: 3500, 
            fromSrc:"sprite:cssClass:checkboxTrue;size:38,38", 
            name:"Checkbox_Checked",
            group: "checkbox"
        },
        {
            index: 3500, 
            fromSrc:"sprite:cssClass:checkboxFalse;size:38,38", 
            name:"Checkbox_Unchecked",
            group: "checkbox"
        },
        {
            index: 3500, 
            fromSrc:"sprite:cssClass:checkboxPartial;size:38,38;", 
            name:"Checkbox_Partial",
            group: "checkbox"
        },        

        // generic chevrons
        {
            index: 4000, 
            fromSrc:"[SKINIMG]pickers/Chevron_up.png", 
            name:"Chevron_Up",
            group: "pickers",
            src: "sprite:svg:[HELPERS]media/svg/chevrons.svg#arrow_up;size:10,10;"
        },
        {
            index: 4010, 
            fromSrc:"[SKINIMG]pickers/Chevron_down.png", 
            name:"Chevron_Down",
            group: "pickers",
            src: "sprite:svg:[HELPERS]media/svg/chevrons.svg#arrow_down;size:10,10;"
        },
        {
            index: 4020, 
            fromSrc:"[SKINIMG]pickers/Chevron_left.png", 
            name:"Chevron_Left",
            group: "pickers",
            src: "sprite:svg:[HELPERS]media/svg/chevrons.svg#arrow_left;size:10,10;"
        },
        {
            index: 4030, 
            fromSrc:"[SKINIMG]pickers/Chevron_right.png", 
            name:"Chevron_Right",
            group: "pickers",
            src: "sprite:svg:[HELPERS]media/svg/chevrons.svg#arrow_right;size:10,10;"
        },
        
        // hamburger menu
        {
            index: 4100, 
            fromSrc:"[SKINIMG]pickers/menu_hamburger.png", 
            name:"Menu_Hamburger",
            group: "pickers"
        },
        
        // Saved Search icons
        {
            index: 4200, 
            fromSrc:"[SKINIMG]", 
            name:"Saved_search",
            group: "pickers",
            src: "empty"
        },
        {
            index: 4210, 
            fromSrc:"[SKINIMG]", 
            name:"Saved_search_remove",
            group: "pickers",
            src: "empty"
        },
        
        {
            index: 5000,
            fromSrc:"[SKINIMG]loading_horizontal.gif",
            name:"Loading",
            group: "action"
        },
        
        /* Speech Recognition icons */
        
        {
            index: 6000,
            fromSrc: null,
            src:"sprite:svg:[HELPERS]media/svg/system.svg#VoiceAssist",
            name:"VoiceAssist"
        },

        /* Cog icon for settings */
        
        {
            index: 20000,
            fromSrc: null,
            src:"sprite:svg:[HELPERS]media/svg/system.svg#Settings",
            name:"Settings"
        }

    ]
});

// define metadata for the framework-wide standard headerIcons
isc.Media.stockIcons.addList([
    {
        index: 1300,
        fromSrc:"[SKINIMG]headerIcons/arrow_down.png", 
        name:"Header_Arrow_down", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1310,
        fromSrc:"[SKINIMG]headerIcons/arrow_left.png", 
        name:"Header_Arrow_left", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1320,
        fromSrc:"[SKINIMG]headerIcons/arrow_right.png", 
        name:"Header_Arrow_right", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1330,
        fromSrc:"[SKINIMG]headerIcons/arrow_up.png", 
        name:"Header_Arrow_up", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1340,
        fromSrc:"[SKINIMG]headerIcons/calculator.png", 
        name:"Header_Calculator", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1350,
        fromSrc:"[SKINIMG]headerIcons/cart.png", 
        name:"Header_Cart", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1360,
        fromSrc:"[SKINIMG]headerIcons/cascade.png", 
        name:"Header_Cascade", 
        group: "header",
        states:[
            "Disabled", 
            "Over"
        ]
    }, 
    {
        index: 1370,
        fromSrc:"[SKINIMG]headerIcons/clipboard.png", 
        name:"Header_Clipboard", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1380,
        fromSrc:"[SKINIMG]headerIcons/clock.png", 
        name:"Header_Clock", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1390,
        fromSrc:"[SKINIMG]headerIcons/close.png", 
        name:"Header_Close", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1400,
        fromSrc:"[SKINIMG]headerIcons/comment.png", 
        name:"Header_Comment", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1410,
        fromSrc:"[SKINIMG]headerIcons/document.png", 
        name:"Header_Document", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1420,
        fromSrc:"[SKINIMG]headerIcons/double_arrow_down.png", 
        name:"Header_Double_arrow_down", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1430,
        fromSrc:"[SKINIMG]headerIcons/double_arrow_left.png", 
        name:"Header_Double_arrow_left", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1440,
        fromSrc:"[SKINIMG]headerIcons/double_arrow_right.png", 
        name:"Header_Double_arrow_right", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1450,
        fromSrc:"[SKINIMG]headerIcons/double_arrow_up.png", 
        name:"Header_Double_arrow_up", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1460,
        fromSrc:"[SKINIMG]headerIcons/favourite.png", 
        name:"Header_Favourite", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1470,
        fromSrc:"[SKINIMG]headerIcons/find.png", 
        name:"Header_Find", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1480,
        fromSrc:"[SKINIMG]headerIcons/help.png", 
        name:"Header_Help", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1490,
        fromSrc:"[SKINIMG]headerIcons/home.png", 
        name:"Header_Home", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1500,
        fromSrc:"[SKINIMG]headerIcons/mail.png", 
        name:"Header_Mail", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1510,
        fromSrc:"[SKINIMG]headerIcons/maximize.png", 
        name:"Header_Maximize", 
        group: "header",
        states:[
            "Down", 
            "Over"
        ]
    }, 
    {
        index: 1540,
        fromSrc:"[SKINIMG]headerIcons/minimize.png", 
        name:"Header_Minimize", 
        group: "header",
        states:[
            "Disabled", 
            "Over"
        ]
    }, 
    {
        index: 1550,
        fromSrc:"[SKINIMG]headerIcons/minus.png", 
        name:"Header_Minus", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1560,
        fromSrc:"[SKINIMG]headerIcons/person.png", 
        name:"Header_Person", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1570,
        fromSrc:"[SKINIMG]headerIcons/pin_down.png", 
        name:"Header_Pin_down", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1580,
        fromSrc:"[SKINIMG]headerIcons/pin_left.png", 
        name:"Header_Pin_left", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1590,
        fromSrc:"[SKINIMG]headerIcons/plus.png", 
        name:"Header_Plus", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1600,
        fromSrc:"[SKINIMG]headerIcons/print.png", 
        name:"Header_Print", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1610,
        fromSrc:"[SKINIMG]headerIcons/refresh.png", 
        name:"Header_Refresh", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1620,
        fromSrc:"[SKINIMG]headerIcons/refresh_thin.png", 
        name:"Header_Refresh_thin", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1630,
        fromSrc:"[SKINIMG]headerIcons/save.png", 
        name:"Header_Save", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1640,
        fromSrc:"[SKINIMG]headerIcons/settings.png", 
        name:"Header_Settings", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1650,
        fromSrc:"[SKINIMG]headerIcons/transfer.png", 
        name:"Header_Transfer", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1660,
        fromSrc:"[SKINIMG]headerIcons/trash.png", 
        name:"Header_Trash", 
        group: "header",
        states:[
            "Over"
        ]
    }, 
    {
        index: 1670,
        fromSrc:"[SKINIMG]headerIcons/zoom.png", 
        name:"Header_Zoom", 
        group: "header",
        states:[
            "Over"
        ]
    }
]);

//> @groupDef svgSymbols
// SVG or Structured Vector Graphics are not bitmapped-images in the tradition sense, but 
// rather an XML-based vector image format that defines a list of vectors that describe how one 
// or more lines or shapes should be rendered.  This means that SVG graphics are typically 
// small and compressible as text, and can be drawn at 
// any size without losing quality, a powerful capability when dealing with images.
// <p>
// SVG can be loaded directly in a page and, when loaded in this way, can be accessed/modified 
// in JavaScript and affected by CSS at runtime.  However, such modifications can be costly 
// and are known to cause flickering in some browsers, due to files being reloaded and  
// necessary DOM changes when images are reloaded/updated.
// <p>
// <h3>Spriting with SVG &lt;symbol&gt;s</h3>
// Unlike bitmaps, SVG are individual entities and can't be sewn together into a 
// "compound image", in the traditional sense, for use with spriting.  However, it is 
// possible to combine individual &lt;svg&gt;s into a single &lt;svg&gt; 
// container as &lt;symbol&gt; elements.  These are template definitions which aren't rendered 
// in the browser - but instances of them can be created by id at runtime using the framework
// sprite mechanism, via the special src-string prefix <code>sprite:svg:</code>.
// <p>
// This approach is great for working with SVG graphics in your app because it works for any 
// SVG and doesn't cause server trips or make sizable DOM modifications.  However, it does 
// require some preparation and has limits in terms of runtime styling.
// <p>
// <h3>Making the sprite container</h3>
// The &lt;svg&gt; container can be defined externally in a .svg file or inline in your HTML, 
// but it must conform to the following rules:
// <ul>
// <li> it should contain the root &lt;svg&gt; element
// <li> the &lt;svg&gt; tag should contain &lt;symbol&gt; tags, which are equivalent to the 
//      &lt;svg&gt; tag itself and support all of the same child elements.  See below for notes 
//      on preparing symbols.
// <li> the root element may also define a &lt;style&gt; element, and a top-level &lt;defs&gt; 
//      tag may be included to define shared reusable elements such as 
//      gradients - however, these elements may prevent runtime styling, or may not be 
//      available in the main document when the &lt;symbol&gt; fragments 
//      are reused in different contexts.  If your &lt;symbol&gt;s are styled by CSS classes, 
//      these must be defined in a separate .css file, which should be loaded in your page.  
//      See <b><i>Styling Symbols</i></b> below.
//
// </ul>
// A valid &lt;svg&gt; container for reusable &lt;symbol&gt; fragments might look like this:
// <pre>
// &lt;svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
//     aria-hidden="true" style="position: absolute; width: 0; height: 0; overflow: hidden;" 
// &gt;
//    &lt;symbol id="icon-play" viewBox="0 0 32 32"&gt;
//        &lt;path d="M6 4l20 12-20 12z"&gt;&lt;/path&gt;
//    &lt;/symbol&gt;
//    &lt;symbol id="icon-pause" viewBox="0 0 32 32"&gt;
//        &lt;path d="M4 4h10v24h-10zM18 4h10v24h-10z"&gt;&lt;/path&gt;
//    &lt;/symbol&gt;
// &lt;/svg&gt;
// </pre>
// <P>
// An &lt;svg&gt; container structured in this way will not be rendered in the browser, but the 
// &lt;symbol&gt;s it defines are made available as a set of templates which 
// can be re-used later in <code>src</code> strings, via the special prefix 
// <i>"sprite:svg:"</i>.  The format of <code>src</code> strings differs slightly according 
// to where your &lt;svg&gt; container is defined.  If it's defined inline in the HTML, only 
// the fragment-id is required - for example
// <pre>src: "sprite:svg:#icon-play"</pre>
// If it's defined in a separate file, you must also specify which file:
// <pre>src: "sprite:svg:path/to/fileName.svg#icon-play"</pre>
// When the external file-name is specified in this way, there is no need for the developer to
// explicitly load the file.
// <P>
// Note that this mechanism is not explicitly supported in any version of Internet Explorer, 
// since that browser has never had full SVG support.
// 
// <h3>Preparing symbols</h3>
// To convert a .svg file to a symbol tag, copy the &lt;svg&gt; and its content, remove 
// everything from the opening svg tag except for the viewbox setting, which represents the 
// designed size, add a unique id attribute to reference this image later in src-strings, and 
// rename it from an svg tag to a symbol tag.  If you want one of the colors in your symbol to 
// be mutable at runtime, find and replace it with the special value "currentColor" (see 
// <b><i>Styling Symbols</i></b> below).
// <p>
// Since SVG is XML-based, individual SVG editors and other tools often write additional 
// metadata into .svg files.  This extra context is not relevant to using these graphics 
// as symbols in the framework and can usually be entirely removed without ill effects.  For 
// example, here is a .svg file exported from a popular image-editing software and its 
// equivalent symbol element-content.
// <pre>
// &lt;?xml version="1.0" encoding="UTF-8" standalone="no"?&gt;
// &lt;!-- Generator: Adobe Illustrator 28.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  --&gt;
// 
// &lt;svg
//   version="1.1"
//   id="someID"
//   x="0px"
//   y="0px"
//   viewBox="0 0 2500 2500"
//   enable-background="new 0 0 2500 2500"
//   xml:space="preserve"
//   xmlns="http://www.w3.org/2000/svg"
//   xmlns:svg="http://www.w3.org/2000/svg"&gt;&lt;defs
//   id="defs1" /&gt;
//&lt;path
//   fill-rule="evenodd"
//   clip-rule="evenodd"
//   d="M1237.77,0.57c-33.09,4.54-61.94,30.54-70.21,63.29 ..."
//   id="path1"
//   style="fill:#3d618a;fill-opacity:1" /&gt;
//&lt;/svg&gt;
// </pre>
// <p>
// Following the instructions above, this .svg will end up as a runtime-stylable symbol like this:
// <pre>
//&lt;symbol id="add" viewBox="0 0 2500 2500" &gt;
//    &lt;path
//   fill-rule="evenodd"
//   clip-rule="evenodd"
//   d="M1237.77,0.57c-33.09,4.54-61.94,30.54-70.21,63.29 ..."
//   id="path1"
//   style="fill:currentColor;fill-opacity:1" /&gt;
//&lt;/symbol&gt;
// </pre>
// 
// <h3>Using symbols</h3>
// Symbols are used by referencing them in src-strings prefixed "sprite:svg:".  This format 
// supports a number of inline attributes separated by ";" characters.  The basic format is:
// <pre> "sprite:svg:[path-to-file.svg]#[symbolId];" </pre>
// Additional supported properties include:
// <ul> 
// <li>size:[w,h] - the pixel-size of the SVG when rendered - if not provided, size is derived 
//      from image-related sizes on the container, such as +link{Img.imageWidth} or 
//      +link{FormItem.pickerIconWidth} - if no such sizes exist, SVGs will be rendered at the 
//      browser's default size for symbols, which is typically 300x150.
// <li>color:[color] - applies a fixed color to this symbol-usage - this color will not change 
//      with state
// <li>opacity:[0-1] - applies CSS opacity in the range 0.0 to 1.0, where 1.0 is fully opaque
// <li>cssClass:[className] - applies a CSS class-name to the span that wraps the SVG - the 
//      CSS class may be simple or stateful - if "color" is also in the src-string, color wins
// <li>statefulId:[true/false] - uses a different symbol for states, by appending "_[State]" to 
//      the end of the provided symbolId - for example, an "Over" state requires that there be 
//      a symbol in the same sprite container with the id <i>[symbolId]</i>_Over
// <li>statefulClass:[true/false] - when set to false, prevents the cssClass from having states 
//      appended to it - defaults to true, or to false if <i>statefulId</i> is true
// <li>rotate:[angle] - rotates the image via a CSS <i>transform</i> like 
//      "transform: rotate({angle}deg);" - this is a shortcut for directly using "transform",
//      which is also supported in src-strings
// <li>transform:[CSS-transform] - applies one or more space-separated CSS transforms to the 
//      image - if you use this, don't use "rotate" separately in your src-string, because 
//      elements can only have one <i>transform</i> setting</li>
// </ul>
// The following attributes are also supported but are unlikely to be as useful - see the 
// following section on <b><i>Styling symbols</i></b> for more details.
// <ul>
// <li>fill:[color] - a color to apply as a fill to closed shapes that don't specify a color 
// <li>stroke:[color} - a color to apply to stroked lines that don't specify a stroke - may 
//      also form the outlines of closed shapes
// <li>stroke-width:[1px, eg} - the width of stroked lines that don't specify a width
// </ul>
// <p>
// See below for example usages.
//
// <h3>Styling symbols</h3>
// As with regular SVG, it's possible to modify the colors and other styles of &lt;symbol&gt;s 
// at runtime.  However, browsers render &lt;symbol&gt;s inside &lt;use&gt; tags, and these
// elements keep their content separate from the main document, in DocumentFragments in the 
// browser's shadow DOM.  These fragments are not subject to the main document's 
// scope/CSS cascade so, while it's possible to modify the styles of complex/multi-color 
// &lt;symbol&gt;s, it does rely on your graphics having been carefully constructed to include 
// no direct styling, or to ensure that styling is applied via CSS classes which are declared 
// externally and loaded directly.  
// <P>
// At its most basic, individual graphics elements in a &lt;symbol&gt; which do not
// specify colors inline can be easily modified.  If all child elements are unstyled (ie, the
// symbol is single-color, even if it has multiple child graphics), the image-color can be changed 
// as a whole by applying external CSS that sets the SVG <i>fill</i> and <i>stroke</i> settings 
// to different colors.  If some child elements have inlined styles, they will 
// not be modified by such external CSS - this means that certain parts of a &lt;symbol&gt; 
// can be of a fixed-color, via inlined styles, while other parts can be left unstyled and can 
// be customized via external CSS later, to highlight only those unstyled parts.  
// <p>
// <b>Note, however, that this is not the recommended approach:</b>  Applying custom styles via 
// <i>fill</i> and <i>stroke</i> can be difficult to achieve consistently across different 
// images, which may use fills or strokes in any combination, or use "compound paths" to 
// render what looks like a stroked line-drawing but is actually various filled shapes.  We 
// provide a sample of this mechanism in our 
// +externalLink{https:\\www.smartclient.com\smartclient-latest\showcase\?id=svgSymbols, online showcase} - 
// the graphics in this sample are all stroked lines which also form closed-shapes, meaning 
// that both stroke and fill have an effect; but this is unlikely to be true in many cases. 
// <p>
// <h3>The recommended approach</h3>
// The recommended approach to applying custom colors is to ensure that all parts of your 
// &lt;symbol&gt; that should change color are given the special fill or stroke value 
// "currentColor", like <code>fill="currentColor"</code> or 
// <code>style="fill:currentColor;"</code>.  This value is always equal to the 
// current/inherited CSS <code>color</code> and can be 
// referenced by graphics elements.  If your CSS class sets <code>fill</code> and 
// <code>color</code> to different values, graphics elements that use <code>currentColor</code>
// will assume the <code>color</code> value, while filled paths that do not specify a 
// <code>fill</code> will respond to CSS "fill".
// <p>
// To achieve this, your SVGs will need to be saved with fill/stroke colors inline 
// where they apply, and the parts that should change color later should all use the same 
// known color.  As part of preparing your symbol, find and replace that known color with 
// "currentColor".  Now, when this graphic is used later, any parts with fill or stroke set to
// "currentColor" will inherit the CSS "color" value from its container, or from a "cssClass" 
// or "color" setting in the src string.
// <p>
// As noted above, it's also possible to fully re-style more complex, multi-color SVG - but 
// this involves ensuring that all styling is externalized and backed by CSS; these details are 
// highly dependent on the graphics and as such are the responsibility of the graphics designer 
// or generator tool.
// <P>
// For demonstration code, see the <i>SVG Symbols</i> sample in our  
// +externalLink{https:\\www.smartclient.com\smartclient-latest\showcase\?id=svgSymbols, online showcase}
//
// <h3>Simple Icons Example</h3>
// Consider a set of single-color SVG &lt;symbol&gt;s that you want to leverage as re-usable 
// icons in your projects.  You may want to show them in different colors in different 
// contexts such as buttons, menus or formItems, and you may
// want them to be stateful, changing color as you roll over or disable them.  This is easily 
// achieved in two ways:
// <ul>
// <li> if your graphics do not apply any fill or stroke colors at all,
// browsers will use their default fill and stroke colors when rendering your symbols 
// (typically, both black), but you can modify these defaults by applying a simple CSS class
// that sets them.
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt> skins provide a builtin 
// <code>svgIcon</code> style that you can use or modify for this purpose, or you can create 
// your own custom styles.  However, note that this technique can be inconsistent depending on 
// design-choices across images, as described above 
// <li> if your graphics set one or more fill or stroke settings to "currentColor", your images  
// will inherit their color from their container, or from a cssClass or color setting applied
// in the src string.
// </ul> 
// For example, an external CSS class could be created:
// <pre>
// // grey color changing to red on rollover
// .icon { color: grey; }
// .iconOver { color: red; }
// </pre>
// 
// This class can then be applied to a stateful widget housing a symbol, via its 
// +link{Img.baseStyle, baseStyle} or similar, or by including it directly in <code>src</code> 
// strings via "cssClass", or as separate per-state 
// URLs in an +link{object:SCStatefulImgConfig} object. 
// 
// <pre>
// isc.Img.create({
//     // show stateful styles
//     showRollOver: true,
//
//     // use baseStyle for statefulness
//     src: "sprite:svg:fileName.svg#icon-id;",
//     <b>baseStyle: "icon"</b>
//
//     // or, use cssClass in config-strings for statefulness
//     src: "sprite:svg:fileName.svg#icon-id;<b>cssClass:icon;</b>"
//
//     // or, use a specific cssClass for each state, in an SCStatefulImgConfig block
//     // - note, all states are supported, but this sample code only shows 2
//     src: {
//         _base: "sprite:svg:fileName.svg#icon-id;<b>cssClass:icon;</b>",
//         Over: "sprite:svg:fileName.svg#icon-id;<b>cssClass:iconOver;</b>",
//     }
//
// })
// </pre>
// <P>
// Developers can also override <code>color</code> on a per usage basis, by specifying it 
// directly in sprite-config <code>src</code> strings
// <pre>
// isc.Img.create({
//     src: {
//         _base: "sprite:svg:fileName.svg#icon-id;<b>color:grey;</b>",
//         Over: "sprite:svg:fileName.svg#icon-id;<b>color:red;</b>",
//     }
// })
// </pre>
// <P>
// Most UI elements provide colors that will be picked up by child symbols that don't specify a 
// cssClass or color - for example, a symbol used as the icon in a MenuItem will show 
// skin-appropriate stateful colors automatically.
// +link{MenuItem.icon} is not itself a stateful attribute, but its colors will be inherited 
// from the menu's stateful +link{Menu.iconFieldProperties, icon-field} if not specified.
// <pre>
// isc.Menu.create({
//     items: [
//         { title: "Option 1", icon: "sprite:svg:fileName.svg#icon-id" }
//     ]
// })
// </pre>
// @treeLocation Concepts
// @visibility external
// @title SVG Symbols Overview
//<
//<




//>ISC_140
//> @class VoiceAssist
// The VoiceAssist class provides voice-interaction features by leveraging the browser’s speech 
// recognition capabilities, typically through the SpeechRecognition or webkitSpeechRecognition 
// interfaces. At the time of writing, full support is available in Chromium-based browsers 
// like Chrome and Edge (on desktop). Safari provides partial support through the 
// webkitSpeechRecognition API.  Firefox does not support speech recognition due to privacy 
// and security concerns, and some Chromium-based browsers like Brave also omit support due to 
// their exclusion of Google’s proprietary services.
// <p>
// To enable VoiceAssist, call +link{VoiceAssist.enable()}, optionally passing the 
// +link{VoiceAssist.voiceKey, keyName} you want to use for activation and recording - 
// the default is <code>Control</code>. Once initialized, VoiceAssist can be activated or 
// deactivated with three quick taps of the +link{VoiceAssist.voiceKey}.
// <p>
// When recognition is active, a user may double-tap the <code>voiceKey</code> to begin 
// dictating a value for a focused input control.  Text appears in the input control as the 
// user speaks and the transcription is completed by a subsequent double-tap of the 
// <code>voiceKey</code>, or by remaining silent for a number of seconds.
// <p>
// In addition to value-dictation, a user may dictate a command to be issued to the focused
// component, which may deal with the text itself or forward to an AI for action.  If the 
// focused component doesn't +link{Canvas.supportsVoiceCommands, support voice-commands} but 
// one of its parents does, that parent will be the focus of your dictated command. To begin 
// dictating a command, press and hold the <code>voiceKey</code> - while the key remains 
// pressed, the +link{VoiceAssist.recordingProgress} method is fired with interim text-results 
// as the user speaks.
// <p>
// If the user speaks one of the +link{VoiceAssist.cancelPhrases}, the interim text is 
// discarded and recording is canceled.
// <p>
// When the user releases the speech-key, recording is stopped and the final text of the 
// recording is passed to the +link{Canvas.doVoiceCommand, target component} for action.
// @treeLocation Client Reference/VoiceAssist
// @visibility external
//<
isc.defineClass("VoiceAssist", "Class");
isc.VoiceAssist.addClassProperties({

    showVoiceAssistIcon : function (item) {
        if (!this.voiceAssistImg) {
            this.voiceAssistImg = isc.Img.create({
                ID: "voiceAssistImage",
                width: 32, height: 32,
                imageSize: 24,
                backgroundColor: "lightgreen",
                src: "VoiceAssist", baseStyle: "icon"
            });
        }
        var rect = item.getPageRect();
        this.voiceAssistImg.placeNear(rect[0]+rect[2]+10, rect[1]);
        this.voiceAssistImg.bringToFront();
        this.voiceAssistImg.show();
    },
    hideVoiceAssistIcon : function () {
        this.voiceAssistImg && this.voiceAssistImg.hide();
    },

    //> @attr voiceAssist.voiceKey (String : "Control" : IRW)
    // The key that activates and performs VoiceAssist features like value and command 
    // dictation.
    // @visibility external
    //<
    voiceKey: 'Control',

    //> @attr voiceAssist.language (String : null : IRW)
    // The BCP 47 language-tag for the language that VoiceAssist expects to interpret.  These 
    // are in the format <i>"language-REGION"</i>, like "en-US" or "fr-FR".  If 
    // unset, VoiceAssist uses the language provided by your browser or OS.
    // @visibility external
    //<
    //language: null,

    // Configuration
    doubleTapTimeout: 500, // ms
    tripleTapTimeout: 500, // extra ms after a double-tap to add a third tap
    longPressDelay: 200, // ms before longPress activates
    longPressTimer: null,

    
 
    //> @attr voiceAssist.autoStopDelay (Integer : 2000 : IRW)
    // VoiceAssist will stop recording automatically if the user stops speaking for this length
    // of time.  The default is 2 seconds.
    // @visibility external
    //<
    autoStopDelay: 2000, // ms
    
    //> @attr voiceAssist.noSpeechDelay (Integer : 3000 : IRW)
    // VoiceAssist will stop recording automatically if the user doesn't speak at all for this
    // length of time.  The default is 3 seconds.
    // @visibility external
    //<
    noSpeechDelay: 3000,
    
    // various state
    lastKeyupTime: 0,
    tapCount: 0,
    enabled: false, // main feature toggle
    dictatingCommand: false, // long-press command dictation (supportsVoiceCommands())
    dictatingValue: false, // double-tap value dictation (supportsValueDictation())
    recognition: null, // SpeechRecognition object
    
    // results cached during recording
    interimResult: "",
    finalResult: "",
    
    //> @attr voiceAssist.cancelPhrases (Array of String : ["never mind", "nevermind"] : IRW)
    // A list of phrases that, when spoken, will cancel an ongoing recording without completing
    // normally.  When dictating a command, the transcription is simply discarded.  When 
    // dictating a value, the transcription is discarded and the value in the focused component 
    // is restored to its pre-recording value.
    // <p>
    // The default cancel-phrase is "never mind" (or "nevermind").
    // @visibility external
    //<
    // means of canceling
    cancelPhrases: ["never mind", "nevermind"],

    // helper to check if voice-recording is allowed - do this the first time a user tries to
    // enable voiceAssist by triple-tapping the speechKey (Control)
    requestMicPermission : function () {
        return new Promise(function (resolve, reject) {
            var getUserMedia = (navigator.mediaDevices && navigator.mediaDevices.getUserMedia) ? 
                    function (constraints, success, error) {
                        navigator.mediaDevices.getUserMedia(constraints).then(success, error);
                    } 
                    : (navigator.getUserMedia ||navigator.webkitGetUserMedia ||navigator.mozGetUserMedia ||navigator.msGetUserMedia)
            ;

            if (!getUserMedia) {
                // browser doesn't support getUserMedia at all
                reject(new Error('getUserMedia not supported'));
                return;
            }

            getUserMedia(
                { audio: true },
                function (stream) {
                    // immediately stop the stream - we just needed the permission
                    if (stream && stream.getTracks) {
                        stream.getTracks().forEach(function (t) { t.stop(); });
                    }
                    resolve(true);
                },
                function (err) {
                    reject(err || new Error('Microphone permission denied'));
                }
            );
        });
    },

    //> @classMethod voiceAssist.enable() (A)
    // Enables the VoiceAssist module - once enabled, a user may triple-tap the 
    // +link{voiceAssist.voiceKey, speech-key} to activate VoiceAssist, allowing them to 
    // dictate values and commands for components in the UI.
    // @param key (String) optional different key to use for VoiceAssist - use with care
    // @visibility external
    //<
    enable : function (key) {
        if (key) this.voiceKey = key;
        
        // init speech recognition
        this.initSpeechRecognition();
        
        // preserve the context
        var self = this;
        
        // local handlers that can be removed later
        this._voiceKeyDownHandler = function (event) {
            if (event.key === self.voiceKey) {
                self.voiceKeyDown(event);
            } else if (self.dictatingCommand) {
                self.cancelDictatingCommand();
            } else if (self.dictatingValue) {
                self.cancelDictatingValue();
            }
        };
        
        this._voiceKeyUpHandler = function (event) {
            if (event.key === self.voiceKey) {
                self.voiceKeyUp(event);
            }
        };
        
        // listen for keyUp and keyDown
        document.addEventListener('keydown', this._voiceKeyDownHandler);
        document.addEventListener('keyup', this._voiceKeyUpHandler);
        
        this.logWarn("Speech key handler installed for '" + this.voiceKey + "' key");
        return this;
    },
    
    //> @classMethod voiceAssist.disable() (A)
    // Disables the VoiceAssist module, canceling any current dictation and deactivating the  
    // ability to dictate values and commands for components in the UI.
    // @visibility external
    //<
    disable : function () {
        // bail if no handlers
        if (!this._voiceKeyDownHandler || !this._voiceKeyUpHandler) {
            this.logDebug("Event handlers not found - may already be disabled");
            return this;
        }
        
        // remove listeners
        document.removeEventListener('keydown', this._voiceKeyDownHandler);
        document.removeEventListener('keyup', this._voiceKeyUpHandler);
        
        // clean up any ongoing dictation
        if (this.dictatingCommand) {
            this.cancelDictatingCommand();
        }
        if (this.dictatingValue) {
            this.cancelDictatingValue();
        }
        
        // clean up any pending timers
        if (this.longPressTimer) {
            clearTimeout(this.longPressTimer);
            this.longPressTimer = null;
        }
        
        // stop recognition if it's running
        if (this.recognition) {
            try {
                this.recognition.stop();
            } catch (e) {
                console.error("Error stopping speech recognition:", e);
            }
        }
        
        // reset state
        this.enabled = false;
        this._voiceKeyDownHandler = null;
        this._voiceKeyUpHandler = null;
        
        this.logInfo("Speech key handler disabled");
        return this;
    },
    
    // setup speech recognition
    initSpeechRecognition : function () {
        if (!("webkitSpeechRecognition" in window) && !("SpeechRecognition" in window)) {
            console.error("Speech recognition not supported in this browser");
            return;
        }
        
        var SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
        this.recognition = new SpeechRecognition();
        
        this.recognition.continuous = true;
        this.recognition.interimResults = true;

        // override the default recognition.lang only if language if set - if it's not set, the 
        // default behavior is to assume the language from the browser or OS 
        if (this.language) this.recognition.lang = this.language;

        var self = this;
        

        // --- SpeechRecognition event handlers -------------------------------------

        // onstart - reset userHasSpoken and show the commandWindow as required
        this.recognition.onstart = function () {
            this.logDebug("onstart (session begun)");
            this.userHasSpoken = false;
            if (this.dictatingCommand) {
                // show the command-window if dictating a command
                this.showCommandWindow();
            } else if (this.dictatingValue) {
                // show the voiceAssistImg next to the target textBox etc
                this.showVoiceAssistIcon(this.targetComponent);
            }
        }.bind(this);

        // onaudiostart - start the timer to detect if the user never speaks
        this.recognition.onaudiostart = function () {
            this.logDebug("onaudiostart (mic capturing)");

            // start fallback timeout for "user never spoke"
            this.startNoSpeechTimer();
        }.bind(this);

        // onspeechstart - when speech is detected, clear the two timers that detect no speech
        this.recognition.onspeechstart = function () {
            this.logDebug("onspeechstart (user speaking)");
            this.userHasSpoken = true;

            // cancel no-speech timeout and any silence timeout
            this.clearNoSpeechTimer();
            this.clearSilenceTimer();
        }.bind(this);

        // onresult - handle result from the speech-to-text engine
        // There's only ever one piece of "interim" result text, stored as this.interimResult 
        // - it gets improved over time, as more speech is recognized, and then finalized and 
        // cleared when confidence is high or, in the case of Chrome, every time you pause for 
        // a second or so.  So, there's only one interim text but potentially many finalized 
        // results, which are appended together into this.finalResult.
        this.recognition.onresult = function (event) {

            // bail if dictation was already canceled
            if (!this.dictatingCommand && !this.dictatingValue) {
                return;
            }

            this.clearSilenceTimer();
            this.clearNoSpeechTimer();

            var interimTranscript = "";
            var finalTranscript = "";

            for (var i = event.resultIndex; i < event.results.length; ++i) {
                var transcript = event.results[i][0].transcript;
                if (event.results[i].isFinal) {
                    finalTranscript += transcript;
                } else {
                    interimTranscript += transcript;
                }
            }
            
            // check for cancel phrase in interim or final transcripts
            var lowerInterim = (this.interimResult + interimTranscript).toLowerCase().trim();
            var lowerFinal = (this.finalResult + finalTranscript).toLowerCase().trim();
            
            // bail if the transcript ends with any cancel phrase
            var hasCancelPhrase = false;
            for (var j = 0; j < this.cancelPhrases.length; j++) {
                var phrase = this.cancelPhrases[j].toLowerCase().trim();
                if (lowerInterim.endsWith(phrase) || lowerFinal.endsWith(phrase)) {
                    hasCancelPhrase = true;
                    break;
                }
            }
            
            if (hasCancelPhrase) {
                this.logInfo("Cancel phrase detected, stopping dictation");
                if (this.dictatingCommand) {
                    this.cancelDictatingCommand();
                } else if (this.dictatingValue) {
                    this.cancelDictatingValue();
                }
                return;
            }
                        
            if (interimTranscript !== "" && (this.dictatingCommand || this.dictatingValue)) {
                // cache the interim result
                this.interimResult = interimTranscript;   // overwrite, not append
                this.onInterimResult(this.finalResult + this.interimResult);
            }
            
            if (finalTranscript !== "" && (this.dictatingCommand || this.dictatingValue)) {
                // cache this final result - in Chrome, an isFinal result happens every time 
                // you pause speaking for a second or so, and the interim text is cleared, but 
                // the recording is not stopped - cache each finalTranscript to prevent loss of 
                // previous input if the user starts speaking again after a pause
                this.finalResult += finalTranscript;
                this.interimResult = "";
            }

            // we want to reset this timer after processing each interim result
            this.startSilenceTimer();
        }.bind(this);

        // onerror - clear the timers 
        this.recognition.onerror = function (event) {
            this.logDebug("onerror: " + event.error);
            this.clearSilenceTimer();
            this.clearNoSpeechTimer();

            if (event.error == "no-speech") {
                // if there's a no-speech error, the user paused for a long time - we want to 
                // stop the recording at that time, but not cancel it
                if (this.dictatingCommand) {
                    this.stopDictatingCommand();
                }
                if (this.dictatingValue) {
                    this.stopDictatingValue();
                }
                return;
            } else if (event.error == "network") {
                // Brave, for example, lets you init the mic but doesn't contact a server
                isc.say("Network error - the browser likely blocks contact with voice-to-text services.");
            }
        }.bind(this);

        // onspeechend - when speech ends, start timer to detect silence for n seconds
        this.recognition.onspeechend = function () {
            this.logDebug("onspeechend (user stopped speaking)");

            if (this.userHasSpoken) {
                this.startSilenceTimer();
            }
        }.bind(this);

        // onaudioend - mic switched off - clear the timers 
        this.recognition.onaudioend = function () {
            this.logDebug("onaudioend (mic stopped)");
            this.clearSilenceTimer();
            this.clearNoSpeechTimer();
        }.bind(this);

        // onend - clear timers and hide the commandWindow
        this.recognition.onend = function () {
            this.logDebug("onend (session finished)");
            this.clearSilenceTimer();
            this.clearNoSpeechTimer();
            
            const finalResult = this.getFullTranscript();
            if (this.dictatingCommand) {
                // hide the command-window if dictating a command
                this.hideCommandWindow();

                if (this.recordingCanceled) {
                    this.logDebug("Command-dictation canceled");
                } else {
                    // fire the method with the final text
                    this.dictateCommandComplete(finalResult);
                    this.logDebug("Command-dictation complete");
                }
            } else if (this.dictatingValue) {
                // hide the voiceAssistIcon if dictating a value
                this.hideVoiceAssistIcon();

                if (this.recordingCanceled) {
                    var targetComponent = this.getTargetComponent();

                    // restore previous value if targetComponent exists
                    if (targetComponent) {
                        if (targetComponent.setValue) {
                            targetComponent.setValue(targetComponent._preDictationValue);
                        }
                    }
                    this.logDebug("Value-dictation canceled");
                } else {
                    // call the final step to complete value-dictation
                    this.dictateValueComplete(finalResult);
                    this.logDebug("Value-dictation complete");
                }
            }

            // reset cached results
            this.lastResult = this.finalResult;
            this.interimResult = "";
            this.finalResult = "";

            // clear some flags that can no longer be true
            delete this.dictatingCommand;
            delete this.dictatingValue;
            delete this.recordingCanceled;
        }.bind(this);
    },
    
    // timer to detect when speech was detected and has now stopped - if more speech is 
    // detected, this timer is cleared - otherwise, it will end recording normally
    startSilenceTimer : function () {
        this.clearSilenceTimer();
        this.silenceTimer = isc.Timer.setTimeout(function () {
            this.logDebug("silence timeout, " + (this.userHasSpoken ? "stopping normally" : "canceling"));
            if (this.userHasSpoken) {
                // stop dictating normally if speech had been detected
                if (this.dictatingCommand) this.stopDictatingCommand();
                else if (this.dictatingValue) this.stopDictatingValue();
            } else {
                // otherwise, cancel dictation - the user stopped recording manually without
                // ever speaking
                if (this.dictatingCommand) this.cancelDictatingCommand();
                else if (this.dictatingValue) this.cancelDictatingValue();
            }
        }.bind(this), this.autoStopDelay);
    },
    // clear the timer that detects when speech was being recorded and has now stopped 
    clearSilenceTimer : function() {
        if (this.silenceTimer !== null) {
            isc.Timer.clearTimeout(this.silenceTimer);
            this.silenceTimer = null;
        }
    },

    // timer to detect when no speech is detected at all - started when audio is first enabled 
    // but before there is recognizable speech - if speech is detected, this timer is cleared
    startNoSpeechTimer : function () {
        this.clearNoSpeechTimer();
        this.noSpeechTimer = isc.Timer.setTimeout(function () {
            this.logDebug("no speech detected, canceling");
            this.recordingCanceled = true;
            this.recognition.stop();
        }.bind(this), this.noSpeechDelay);
    },
    // clear the timer that detects when no speech is detected at all 
    clearNoSpeechTimer : function () {
        if (this.noSpeechTimer !== null) {
            isc.Timer.clearTimeout(this.noSpeechTimer);
            this.noSpeechTimer = null;
        }
    },


    // interim speech results
    onInterimResult : function (text) {
        var content = (this.finalResult || "") + " " + text;
        // trim this here - means that if the user dictates a value and presses enter without
        // stopping the recording, the value won't have a leading space
        content = content.trim();
        if (this.dictatingCommand) {
            this.logDebug("Command (interim)\n  text: " + text + "\n  trimmed: " + content);
            this.dictateCommandProgress(content);
        } else if (this.dictatingValue) {
            this.logDebug("Value (interim)\n  text: " + text + "\n  trimmed: " + content);
            this.dictateValueProgress(content);
        }
        this.recordingProgress(content);
    },
    
    //> @classMethod voiceAssist.recordingProgress() (A)
    // Event fired with interim text-results as the user speaks. 
    // @param text (String) the latest text-results for an on-going recording
    // @visibility external
    //<
    recordingProgress : function (text) {
    },

    dictateValueProgress : function (content) {
        var comp = this.getTargetComponent();
        if (comp) {
            if (comp.dictationProgress) comp.dictationProgress(content);
            else if (comp.setValue) comp.setValue(content);
        }
    },

    // update the floating label with the current text for AI requests
    dictateCommandProgress : function (content) {
        var widget = this.commandWindow;
        if (!widget) return;
        if (widget.setValue) widget.setValue(content);
        if (widget.setCommand) widget.setCommand(content);
    },
    
    // combine the cached final and interim results
    getFullTranscript : function () {
        var finalResult = (this.finalResult || "").trim(),
            interimResult = (this.interimResult || "").trim()
        ;

        var result = finalResult + interimResult;

        // Edge runs your text through Azure Speech, which applies capitalization and punctuation
        // - for example "monaco" becomes "Monaco." - get rid of punctuation because it'll break 
        // dictating filter-values 
        result = result.replace(/^\s+|\s+$/g, '').replace(/[.!?…]+$/g, '');

        return result;
    },
    
    // helpers to see whether a target supports command or value dictation
    targetSupportsVoiceCommands : function (target) {
        return target && target.supportsVoiceCommands && target.supportsVoiceCommands();
    },
    targetSupportsValueDictation : function (target) {
        return target && target.supportsValueDictation && target.supportsValueDictation();
    },

    getTargetComponent : function () {
        // if currently dictating a value, we want to prefer the targetComponent, which will
        // be a focused FormItem or similar
        if (this.dictatingValue) return this.targetComponent || this.masterComponent;
        return this.masterComponent || this.targetComponent;
    },

    getFocusComponent : function () {
        return this.targetComponent;
    },

    // starting from the last focus component, walk up the parent-tree looking for a component
    // that supports the current recording type (dictatingValue/Command)
    findComponent : function () {
        var component = isc.EH.getFocusCanvas() || isc.EH._lastFocusTarget || isc.EH.lastClickTarget;
        
        if (isc.isA.DynamicForm(component)) {
            var item = component.getFocusItem();
            if (item) {
                if (this.dictatingCommand && this.targetSupportsVoiceCommands(item)) {
                    // formItem that supports voice commands (directly or via AI)
                    component = item;
                } else if (this.dictatingValue && this.targetSupportsValueDictation(item)) {
                    // formItem that supports voice value-dictation
                    component = item;
                }
            }
        }
        if (component && this.dictatingCommand) {
            if (!this.targetSupportsVoiceCommands(component)) {
                while (component.parentElement != null) {
                    if (this.targetSupportsVoiceCommands(component)) break;
                    component = component.parentElement;
                }
            }
            if (component && this.targetSupportsVoiceCommands(component) && component.doVoiceCommand) {
                // found a parent that supports voice commands
                this.logInfo("VoiceAssist Component: " + (component ? component && component.ID : "None"));
                return component;
            }
        } else if (component && this.dictatingValue) {
            // focused in an item that directly supports value-dictation - we don't walk up the 
            // parent tree for this functionality
            if (this.targetSupportsValueDictation(component)) {
                this.logInfo("VoiceAssist Component: " + (component ? component && component.ID : "None"));
                return component;
            }
        }

        return null;
    },

    // handle keydown events
    voiceKeyDown : function (event) {
        // only process if the feature is enabled, unless it's a triple-tap sequence
        if (!this.enabled && this.tapCount < 2) return;
        
        // clear any existing timer
        if (this.longPressTimer) {
            clearTimeout(this.longPressTimer);
            this.longPressTimer = null;
        }
        
        // start long press timer if feature is enabled and not already dictating
        if (this.enabled && !this.dictatingCommand && !this.dictatingValue) {
            var self = this;
            this.longPressTimer = isc.Timer.setTimeout(function () {
                self.startDictatingCommand();
            }, this.longPressDelay);
        }
    },
    
    // handle keyup events
    voiceKeyUp : function (event) {
        var currentTime = Date.now();
        
        // clear any pending longPress timer
        if (this.longPressTimer) {
            clearTimeout(this.longPressTimer);
            this.longPressTimer = null;
        }
        
        // handle long press ending
        if (this.dictatingCommand) {
            this.stopDictatingCommand();
            return;
        }
        
        // calculate time since last keyup
        var timeSinceLastKeyup = currentTime - this.lastKeyupTime;
        this.lastKeyupTime = currentTime;
        
        // if it was a long time since the last keyup, reset the tap count
        if (timeSinceLastKeyup > this.doubleTapTimeout && this.tapCount > 0) {
            this.tapCount = 0;
        }
        
        // increment tap count
        this.tapCount++;
        
        // handle triple tap (always check for triple tap to enable/disable the feature)
        if (this.tapCount === 3 && timeSinceLastKeyup <= this.tripleTapTimeout) {
            this.tripleTap();
            this.tapCount = 0;
            return;
        }
        
        if (this.tapCount === 2 && timeSinceLastKeyup <= this.doubleTapTimeout) {
            // if already dictating a value, a double tap always stops dictation - the taps do 
            // NOT count toward a triple-tap
            if (this.dictatingValue) {
                this.tapCount = 0;
                this.doubleTap();
                return;
            }
            if (this.enabled) {
                this.doubleTap();
            
                // set a timeout to reset tap count
                isc.Timer.setTimeout(function () {
                    if (this.tapCount === 2) {
                        this.tapCount = 0;
                    }
                }, this.tripleTapTimeout);
            }
        }
    },
    
    // double tap handler - toggles value dictation
    doubleTap : function () {
        if (!this.enabled) return;
        
        if (this.dictatingValue) {
            if (this.userHasSpoken) {
                // stop dictating normally if speech had been detected
                this.stopDictatingValue();
            } else {
                // otherwise, cancel dictation - the user stopped recording manually without
                // ever speaking
                this.cancelDictatingValue();
            }
        } else {
            // start dictating value
            this.startDictatingValue();
        }
    },
    
    // triple tap handler - toggles VoiceAssist availability
    tripleTap : function () {
        
        if (this.recordingAllowed == false) {
            this.logWarn("Your browser does not allow voice-recording for this site.");
            return;
        } else if (this.recordingAllowed == true) {
            this._tripleTap();
        } else {
            var self = this;
            this.requestMicPermission()
            .then(function () {
                // now it's safe to start recognition: no dropped first attempt
                self.recordingAllowed = true;
                self._tripleTap();
            })
            .catch (function (err) {
                self.recordingAllowed = false;
                self.logWarn("Recording-permissions error:", err.message);
                isc.say("Error obtaining recording-permissions: " + err.message);
            });
            return;
        }
    },
    
    _tripleTap : function () {
        this.enabled = !this.enabled;
        
        // if disabling, stop any ongoing dictation
        if (!this.enabled) {
            if (this.dictatingCommand) this.stopDictatingCommand();
            if (this.dictatingValue) this.stopDictatingValue();
        }

        // show a Notify at the top
        isc.notify("<b>AI Voice-Assist  " + (!this.enabled ? "Disabled" : "Enabled" + 
            "</b><p><nobr>Hold down <i>" + this.voiceKey + 
            "</i> to record a command or double-tap to dictate a value</nobr>"), null, null, 
            { 
                position: "T", 
                // enabled has a close-icon and a long auto-hide delay
                // disabled has a short auto-hide delay and no close-icon
                duration: this.enabled ? 3000 : 2000, 
                canDismiss: this.enabled ? true : false,
                overflow: "visible",
                closeButtonSize: 17,
                closeButtonWidth: 17,
                autoFitWidth: true, 
                autoFitMaxWidth: "70%",
                maxWidth: 900, 
                messageIcon: "AIAnswerEngine",
                messageIconWidth: 24,
                messageIconHeight: 24
            }
        );

        this.logInfo(this.enabled ? " Enabled" : " Disabled");
    },
    
    // start value dictation (double-tap mode)
    startDictatingValue : function () {
        if (this.dictatingValue) return;
        if (this.dictatingCommand) this.stopDictatingCommand();
        
        this.dictatingValue = true;

        this.targetComponent = this.findComponent();    

        // for value-dictation, we want to use the actual focus/target component, not
        // the masterComponent, which is for handling commands, rather than item-values
        var targetComponent = this.targetComponent;

        if (!targetComponent) {
            // if the focus widget doesn't have supportsValueDictation(), there's nothing to 
            // do - just don't start recording
            this.dictatingValue = false;
            return;
        }

        // reset cached results
        this.interimResult = "";
        this.finalResult = "";
        
        this.logDebug("Starting value dictation - " + (targetComponent ? targetComponent.ID : "none"));
        
        if (targetComponent) {
            targetComponent._preDictationValue = targetComponent.getValue();
        }
        
        try {
            if (this.recognition) {
                this.recognition.start();
            }
        } catch (e) {
            // if recognition is already running, stop it first and try again
            if (e.name === 'InvalidStateError') {
                this.recognition.stop();
                isc.Timer.setTimeout(function () {
                    try {
                        this.recognition.start();
                    } catch (e2) {
                        console.error("Failed to restart recognition:", e2);
                        this.dictatingValue = false;
                    }
                }, 100);
            } else {
                this.dictatingValue = false;
            }
        }

        // if the call to start() succeeded, the onstart event will call startSilenceTime()
    },
    
    // stop value dictation
    stopDictatingValue : function () {
        if (!this.dictatingValue) return;

        // cancel the timer that deals with stopping recording when the user falls silent
        this.clearSilenceTimer();

        try {
            if (this.recognition) {
                this.recognition.stop();
            }
        } catch (e) {
            console.error("Error stopping speech recognition:", e);
        }
    },
    
    // cancel value dictation (without processing results)
    cancelDictatingValue : function () {
        if (!this.dictatingValue) return;

        // cancel the timer that deals with stopping recording when the user falls silent
        this.clearSilenceTimer();

        // this flag is checked in recognition.onend() to determine whether to complete or cancel
        this.recordingCanceled = true;

        try {
            if (this.recognition) {
                this.recognition.stop();
            }
        } catch (e) {
            console.error("Error stopping speech recognition:", e);
        }

    },
    
    // process dictated value
    dictateValueComplete : function (text) {
        this.logDebug("Dictated value: " + text);
        
        text = text.trim();

        // for value-dictation, we want to use the actual focus/target component, not
        // the masterComponent, which is for handling commands, rather than item-values
        var targetComponent = this.targetComponent;

        if (targetComponent) {
            if (targetComponent.doValueDictation) targetComponent.doValueDictation(text);
            else if (targetComponent.setValue) targetComponent.setValue(text);
        }
    },
    
    // start long press - for command dictation
    startDictatingCommand : function () {
        if (!this.enabled || this.dictatingValue) return;

        this.dictatingCommand = true;

        // reset cached results
        this.interimResult = "";
        this.finalResult = "";

        this.targetComponent = this.findComponent();

        // this may return the focus/click-component, or it may return the masterComponent, 
        // which is an arbitrary widget that will receive the voice-commands in preference
        // to the focus-component
        var targetComponent = this.getTargetComponent();

        this.logDebug("Starting command dictation - target is: " + 
            (targetComponent ? targetComponent.ID : "none"));

        try {
            if (this.recognition) {
                this.recognition.start();
            }
        } catch (e) {
            //console.error("Error starting speech recognition:", e);
            // if recognition is already running, stop it first and try again
            if (e.name === 'InvalidStateError') {
                this.recognition.stop();
                isc.Timer.setTimeout(function () {
                    try {
                        this.recognition.start();
                    } catch (e2) {
                        console.error("Failed to restart recognition:", e2);
                        this.dictatingCommand = false;
                    }
                }, 100);
            } else {
                this.dictatingCommand = false;
            }
        }

        // if the call to start() succeeded, the onstart event will call startAutoStopTimer()
    },
    
    // cancel long press
    cancelDictatingCommand : function () {
        if (!this.dictatingCommand) return;

        // cancel the timer that deals with stopping recording when the user falls silent
        this.clearSilenceTimer();

        // this flag is checked in recognition.onend() to determine whether to complete or cancel
        this.recordingCanceled = true;

        try {
            if (this.recognition) {
                this.recognition.stop();
            }
        } catch (e) {
            console.error("Error stopping speech recognition:", e);
        }
        
    },
    
    // end long press
    stopDictatingCommand : function () {
        if (!this.dictatingCommand) return;

        // cancel the timer that deals with stopping recording when the user falls silent
        this.clearSilenceTimer();

        this.logDebug("Ending command dictation");

        try {
            if (this.recognition) {
                this.recognition.stop();
            }
        } catch (e) {
            console.error("Error stopping speech recognition:", e);
        }

        // clearing the commandWindow and other state happens in onend()        
    },

    // process dictated command
    dictateCommandComplete : function (text) {
        this.logDebug("Dictated command: " + text);

        // trim the final text - spaces are annoying if you dictate a search value for a grid 
        // field
        text = text.trim();

        this.commandWindow.showExecutingCommand(text);

        // this may return the focus/click-component, or it may return the masterComponent, 
        // which is an arbitrary widget that will receive the voice-commands in preference
        // to the focus-component
        var targetComponent = this.getTargetComponent();

        if (targetComponent && targetComponent.doVoiceCommand) {
            targetComponent.doVoiceCommand(text);
        } else {
            isc.doVoiceCommand(text);
        }
        this.hideCommandWindow();
    },
    
    // window for displaying recording progress when recording a command
    commandWindowConstructor: "Canvas",
    commandWindowDefaults: {
        width: 400,
        height: 60,
        maxWidth: 800,
        overflow: "visible",
        styleName: "notifyMessage",
        headerLabelDefaults: {
            _constructor: "Label",
            width: "100%",
            height: 30,
            overflow: "visible",
            styleName: "notifyMessage"
        },
        contentLabelDefaults: {
            _constructor: "Label",
            width: "100%",
            top: 30,
            height: "*",
            overflow: "visible",
            styleName: "notifyMessage",
            contents: ""
        },
        initWidget : function () {
            this.addAutoChild("headerLabel", { contents: "AI Command: " });
            this.addAutoChild("contentLabel");
        },
        setComponent : function (component) {
            this.component = component;
            this.headerLabel.setContents("Listening... [say 'never mind' to cancel] - " + 
                (component && component.getID ? component.getID() : "No target") + "");
        },
        setCommand : function (newText) {
            this.contentLabel.setContents("Command: " + newText);
        },
        showExecutingCommand : function (newText) {
            var component = this.component || {};
            this.headerLabel.setContents("Executing AI Command: " + 
                (component.getID ? component.getID() : "No target"));
            this.setCommand(newText);
        }
    },
    showCommandWindow : function () {
        if (!this.commandWindow) {
            this.commandWindow = isc.Canvas.create(this.commandWindowDefaults);
        }
        this.commandWindow.setComponent(this.getTargetComponent());
        this.commandWindow.setCommand("Command:");
        this.commandWindow.placeNear(((isc.Page.getWidth()-this.commandWindow.getWidth())/2), 0);
        this.commandWindow.show();
        this.commandWindow.bringToFront();
    },
    hideCommandWindow : function () {
        if (this.commandWindow) this.commandWindow.hide();
    }
});

isc.doVoiceCommand = function (text) {
    if (isc.AI && !isc.AI.disabled) isc.AI.useAssistant(text);
}

//<ISC_140
