/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.application;

import com.isomorphic.base.Base;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.UpdateWithoutPKException;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.SessionDataSource;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.util.DataTools;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AppBase
extends Base {
    protected static Logger log = new Logger(AppBase.class.getName());
    protected static final boolean authorizationEnabled = config.getBoolean((Object)"authorization.enabled", false);
    protected String appID;
    protected Map appConfig;
    protected Map definedUserTypes;
    protected RequestContext context = null;
    protected String operation = null;
    protected String operationType = null;
    protected DSRequest request = null;
    protected DSResponse result = null;
    protected Map userTypes = new HashMap();
    protected DataSource dataSource = null;
    protected Map operationsMap = null;
    protected static String DEFAULT_IMPLEMENTER = "com.isomorphic.application.AppBase";
    protected static String DEFAULT_PACKAGE = config.getString("application.defaultPackage");
    Map leasedDataSources = new HashMap();

    public static AppBase findByAppID(String appID) throws Exception {
        LinkedHashMap userTypes;
        AppBase theApp = null;
        if (appID.equals("builtinApplication") || appID.equals("defaultApplication")) {
            if (authorizationEnabled) {
                throw new Exception("The special application 'builtinApplication' cannot be used unless authorization is globally disabled (property authorization.enabled: false)");
            }
            theApp = new AppBase();
            theApp.appID = "builtinApplication";
            theApp.appConfig = new HashMap();
            return theApp;
        }
        Map appConfig = (Map)DataStructCache.getInstance(appID, "apps", "App");
        if (appConfig == null) {
            throw new Exception("Unable to find app file for application ID " + DataTools.escapeHTML(appID));
        }
        Object appClassname = (String)appConfig.get("appImplementer");
        if (appClassname == null) {
            appClassname = DEFAULT_IMPLEMENTER;
        } else if (((String)appClassname).indexOf(".") == -1 && DEFAULT_PACKAGE != null && !"".equals(DEFAULT_PACKAGE)) {
            appClassname = DEFAULT_PACKAGE + "." + (String)appClassname;
        }
        log.info("Using class '" + (String)appClassname + "' as the implementer for application '" + appID + "'");
        theApp = null;
        try {
            theApp = (AppBase)Reflection.instantiateClass((String)appClassname);
        }
        catch (Exception e) {
            throw new Exception("Unable to instantiate " + DataTools.escapeHTML((String)appClassname) + " - check the appImplementer setting in the app file for appID: " + DataTools.escapeHTML(appID) + " and ensure that your class has a public zero-argument constructor - actual error was: " + e.toString());
        }
        theApp.appID = appID;
        theApp.appConfig = appConfig;
        LinkedHashMap userTypeRequirements = userTypes = (LinkedHashMap)appConfig.get("userTypes");
        if (userTypes != null && !userTypes.isEmpty() && userTypes.values().iterator().next() instanceof Map) {
            userTypeRequirements = new LinkedHashMap();
            for (Map userType : userTypes.values()) {
                String userTypeID = (String)userType.get("ID");
                userTypeRequirements.put(userTypeID, userType.get("requirements"));
            }
        }
        log.info("UserType requirements: " + DataTools.prettyPrint(userTypeRequirements));
        theApp.definedUserTypes = userTypeRequirements;
        return theApp;
    }

    protected void canPerformAutoOperation() throws Exception {
        if (this.appID.equals("builtinApplication") || this.appID.equals("defaultApplication")) {
            if (authorizationEnabled) {
                throw new Exception("DENIED attempt to execute auto operation '" + this.operation + "' bound to the auto-generated default application because authorization is currently enabled");
            }
        } else {
            Boolean definedOperationsOnly = (Boolean)this.appConfig.get("definedOperationsOnly");
            Map opConfig = this.getOperationConfig(this.operation);
            if (definedOperationsOnly != null && definedOperationsOnly.booleanValue() && (opConfig == null || opConfig.isEmpty())) {
                throw new Exception("DENIED attempt to execute auto operation '" + this.operation + "' bound to the application '" + this.appID + "' because this application is configued for defined operations only and there is no definition for this operation in the app file");
            }
        }
    }

    protected Map createAutoOperation(String operationType, Map passedOperationConfig, String dataSourceId) {
        if (passedOperationConfig == null) {
            passedOperationConfig = new HashMap();
        }
        passedOperationConfig.remove("dataSource");
        passedOperationConfig.remove("type");
        passedOperationConfig.remove("ID");
        DataTypeMap defaultOperationConfig = DataTools.buildMap("ID", this.operation, "type", operationType, "dataSource", dataSourceId);
        DataTools.mapMerge((Map)((Object)defaultOperationConfig), passedOperationConfig);
        return passedOperationConfig;
    }

    private boolean userQualifiesForOperation(String operation) throws Exception {
        if (this.definedUserTypes == null || this.definedUserTypes.size() == 0) {
            log.debug("No userTypes defined, allowing anyone access to all operations for this application");
            return true;
        }
        Map opConstraints = this.getOperationConstraints(operation);
        List allowedUserTypes = opConstraints == null || opConstraints.containsKey("*") ? DataTools.enumToList(this.definedUserTypes.keySet().iterator()) : DataTools.enumToList(opConstraints.keySet().iterator());
        List qualifiedUserTypes = this.userIsOfTypes(allowedUserTypes);
        if (qualifiedUserTypes != null) {
            log.debug((Object)"Qualified for user types for this operation", qualifiedUserTypes);
            return true;
        }
        return false;
    }

    public boolean userQualifiesForType(String userType) throws Exception {
        Logger.auth.info("AppBase::boolean userQualifiesForType(String userType): override this method to provide custom userType qualification logic (base implementation returns true)");
        return true;
    }

    public boolean userIsOfType(String userType) throws Exception {
        if (this.definedUserTypes == null) {
            return false;
        }
        Boolean qualified = (Boolean)this.userTypes.get(userType);
        if (qualified != null) {
            return qualified;
        }
        qualified = !authorizationEnabled || this.userQualifiesForType(userType);
        this.userTypes.put(userType, qualified);
        return qualified;
    }

    public List userIsOfTypes() throws Exception {
        if (this.definedUserTypes == null) {
            return null;
        }
        return this.userIsOfTypes(DataTools.enumToList(this.definedUserTypes.keySet().iterator()));
    }

    public List userIsOfTypes(List userTypes) throws Exception {
        ArrayList<String> qualified = new ArrayList<String>();
        for (String userType : userTypes) {
            if (!this.userIsOfType(userType)) continue;
            qualified.add(userType);
        }
        if (qualified.size() > 0) {
            return qualified;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DSResponse execute(DSRequest request, RequestContext context) throws Exception {
        this.request = request;
        this.context = context;
        DataSource ds = request != null ? request.getDataSource() : null;
        this.result = ds != null ? new DSResponse(ds) : new DSResponse();
        boolean pushedLogContext = false;
        if (!this.appID.equals("builtinApplication") && !this.appID.equals("defaultApplication") && request.getOperation() != null) {
            Logger.pushContext(request.getAppID() + "." + request.getOperation());
            pushedLogContext = true;
        }
        try {
            String exportAs;
            Object dataSourceId;
            this.operation = request.getOperation();
            Map operationConfig = this.getOperationConfig(this.operation);
            if (operationConfig == null || operationConfig.isEmpty()) {
                this.canPerformAutoOperation();
                dataSourceId = request.getDataSourceName();
                String operationType = request.getOperationType();
                if ((dataSourceId == null || operationType == null) && this.getCustomMethod(this.operation) == null) {
                    String message = "Auto-operation name (" + this.operation + ") must either be of the format dataSourceId_operationType or a public zero-argument method";
                    throw new Exception(message);
                }
                Map operations = this.getOperationsMap();
                operationConfig = this.createAutoOperation(operationType, request.getOperationConfig(), (String)dataSourceId);
                operations.put(this.operation, operationConfig);
            } else {
                this.operationType = this.getDSOperationType(this.operation);
            }
            if (!this.userQualifiesForOperation(this.operation)) {
                log.warn("User does not qualify for any userTypes that are allowed to perform this operation ('" + this.operation + "')");
                this.result.setStatus(-3);
                dataSourceId = this.result;
                return dataSourceId;
            }
            try {
                this.executeAppOperation();
            }
            finally {
                this.freeDataSources();
            }
            if (this.result.getStatus() == 1) {
                this.result.setSuccess();
            }
            if (this.result.statusIsError()) {
                dataSourceId = this.result;
                return dataSourceId;
            }
            String string = exportAs = this.operation == null ? null : (String)this.getOperationProperty(this.operation, "exportAs");
            if (exportAs != null) {
                throw new Exception("CSV export is not supported in this version.");
            }
            DSResponse dSResponse = this.result;
            return dSResponse;
        }
        finally {
            if (pushedLogContext) {
                Logger.popContext();
            }
        }
    }

    protected void executeAppOperation() throws Exception {
        Method customMethod = this.getCustomMethod(this.operation);
        if (customMethod != null) {
            log.info("Invoking custom app operation method '_" + this.operation + "'");
            customMethod.invoke((Object)this, (Object[])new Class[0]);
        } else {
            log.debug("No public zero-argument method named '_" + this.operation + "' found, performing generic datasource operation");
            String dsName = this.request.getDataSourceName();
            if (dsName == null) {
                throw new Exception("No public zero-argument method named '_" + this.operation + " and request does not specify a DataSource to use for a default operation - unable to proceed.");
            }
            this.dataSource = this.request.getDataSource();
            this.executeDefaultDSOperation();
            this.dataSource = null;
        }
    }

    protected void executeDefaultDSOperation() throws Exception {
        String dsName = this.request.getDataSourceName();
        DataSource ds = this.request.getDataSource();
        if (ds == null) {
            log.warn("Can't find dataSource: " + dsName + " - please make sure that you have a " + dsName + ".ds.xml file for it in one of these locations: " + config.getString("project.datasources"));
            throw new Exception("Can't find dataSource: " + dsName + " - please make sure that you have a " + dsName + ".ds.xml file for it in one of locations listed in 'project.datasources' server.properties setting.");
        }
        String operationType = this.request.getOperationType();
        if (!this.request.getAllowMultiUpdate() && (DataSource.isRemove(operationType) || DataSource.isUpdate(operationType))) {
            List criteria = this.request.getCriteriaSets();
            if (criteria == null || criteria.isEmpty()) {
                throw new Exception("Received null criteria for " + operationType + " operation - would " + operationType + " all records - ignoring.");
            }
            for (Map data : criteria) {
                if (data == null) {
                    throw new Exception("Received null criteria for " + operationType + " operation - would " + operationType + " all records - ignoring.");
                }
                boolean specificCriteria = false;
                ArrayList<String> passedKeys = new ArrayList<String>();
                List keysMissing = null;
                specificCriteria = this.request.criteriaHasPKs(data, ds.getPrimaryKeys(), true, passedKeys);
                if (!AdvancedCriteria.isAdvancedCriteria(data)) {
                    keysMissing = DataTools.setDisjunction(ds.getPrimaryKeys(), passedKeys);
                }
                if (ds instanceof SessionDataSource) continue;
                DataTypeMap opBinding = ds.getOperationBinding(operationType, this.request.getOperationId());
                Boolean allowMultiUpdate = Boolean.FALSE;
                Boolean providesMissingKeys = Boolean.FALSE;
                if (opBinding != null) {
                    allowMultiUpdate = (Boolean)opBinding.get("allowMultiUpdate");
                    providesMissingKeys = (Boolean)opBinding.get("providesMissingKeys");
                }
                if (!(specificCriteria || Boolean.TRUE.equals(allowMultiUpdate) || Boolean.TRUE.equals(providesMissingKeys))) {
                    if (keysMissing != null) {
                        throw new UpdateWithoutPKException("Criteria received from the client for " + operationType + " operation is missing the following required unique and/or primary fields: " + keysMissing.toString() + ". Either provide all primary key fields or set allowMultiUpdate or providesMissingKeys on the OperationBinding (see the client-side docs for details of those flags)");
                    }
                    throw new UpdateWithoutPKException("Criteria received from the client for " + operationType + " operation is potentially addressing multiple records. Either provide more specific criteria addressing single record and containing all primary key fields or set allowMultiUpdate or providesMissingKeys on the OperationBinding (see the client-side docs for details of those flags)");
                }
                if (ds.getPrimaryKeys().size() != 0 || Boolean.TRUE.equals(allowMultiUpdate)) continue;
                throw new UpdateWithoutPKException(operationType + " operation received from client for DataSource '" + ds.getName() + "', operationId '" + this.request.getOperationId() + "'. This is not allowed because the DataSource has no primaryKey.  Either declare primaryKey field(s) or set allowMultiUpdate to true on the OperationBinding");
            }
        }
        this.result = ds.execute(this.request);
    }

    public DataSource getDataSource(String dsName) throws Exception {
        DataSource ds = (DataSource)this.leasedDataSources.get(dsName);
        if (ds == null) {
            ds = DataSourceManager.getDataSource(dsName, this.request);
            this.leasedDataSources.put(dsName, ds);
        }
        return ds;
    }

    public void freeDataSources() {
        Iterator i = this.leasedDataSources.values().iterator();
        while (i.hasNext()) {
            DataSourceManager.freeDataSource((DataSource)i.next());
        }
    }

    private Method getCustomMethod(String operationName) {
        try {
            Method method = Reflection.findMethod(this, "_" + operationName);
            if (method != null) {
                return method;
            }
            if (this.dataSource == null) {
                return null;
            }
            if ("auto".equals(this.request.getOperationSource())) {
                String dataSourceId = this.dataSource.getName();
                if ("fetch".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_select");
                }
                if ("add".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_insert");
                }
                if ("remove".equals(this.operationType)) {
                    return Reflection.findMethod(this, "_" + dataSourceId + "_delete");
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getOperationsMap() {
        if ((Map)this.appConfig.get("operations") == null) {
            this.appConfig.put("operations", new HashMap());
        }
        if (this.operationsMap == null) {
            this.operationsMap = new DataTypeMap((Map)this.appConfig.get("operations"));
        }
        return this.operationsMap;
    }

    public Map getOperationConfig(String appOperation) {
        Map opConfig = (Map)this.getOperationsMap().get(appOperation);
        if (opConfig == null) {
            return new HashMap();
        }
        return opConfig;
    }

    public Object getOperationProperty(String appOperation, String property) {
        try {
            return DataTools.nestedGet(this.getOperationsMap(), appOperation + "." + property);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getOperationConstraints(String appOperation) {
        return (Map)this.getOperationProperty(appOperation, "constraints");
    }

    public Map getOperationOutputs(String appOperation) {
        return (Map)this.getOperationProperty(appOperation, "outputs");
    }

    public String getDSOperationType(String appOperation) {
        return (String)this.getOperationProperty(appOperation, "type");
    }

    public List getConstraintsForUserType(String userType, String operation) {
        Map opConstraints = this.getOperationConstraints(operation);
        if (opConstraints == null || opConstraints.get(userType) == null) {
            return null;
        }
        return DataTools.makeListIfSingle(opConstraints.get(userType));
    }

    public List getOutputsForUserType(String userType, String operation) {
        Map opOutputs = this.getOperationOutputs(operation);
        if (opOutputs == null || opOutputs.get(userType) == null) {
            return null;
        }
        return DataTools.makeListIfSingle(opOutputs.get(userType));
    }
}

