/*

  SmartClient Ajax RIA system
  Version v14.1p_2025-12-06/LGPL Deployment (2025-12-06)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>ISC_140
//> @class ShuttleItem
// +link{Shuttle}-based form item for choosing values from a list of options.
// <P>
// Options for the Shuttle should be derived from an +link{formItem.optionDataSource, optionDataSource}.
//
// @treeLocation Client Reference/Forms/Form Items
// @inheritsFrom CanvasItem
// @visibility external
//<
//<ISC_140

isc.defineClass("ShuttleItem", "CanvasItem");
isc.ShuttleItem.addProperties({


    //>ISC_140
    //> @attr shuttleItem.width (int | String : 400 : IRW)
    // @include FormItem.width
    // @visibility external
    //<
    //<ISC_140
    width:400,

    //>ISC_140
    //> @attr shuttleItem.height (int | String : 400 : IRW)
    // @include FormItem.height
    // @visibility external
    //<
    //<ISC_140
    height:200,


    //>ISC_140
    //> @attr shuttleItem.shuttle (Shuttle AutoChild : null : R)
    // The ShuttleItem generates a +link{Shuttle} +link{AutoChild} as its 
    // +link{CanvasItem.canvas,canvas}.
    //
    // @visibility external
    //<
    //<ISC_140


    //>ISC_140
    //> @attr shuttleItem.valueField (String : null : IR)
    // The value field for a shuttle item will be applied to the
    // +link{shuttle} as +link{shuttle.valueField}.
    // <P>
    // If no explicit valueField was specified it may be automatically
    // derived - see +link{FormItem.getValueFieldName()} for details.
    //
    // @visibility external
    //<
    //<ISC_140



    //>ISC_140
    //> @attr shuttleItem.displayField (String : null : IR)
    // @include FormItem.displayField
    // @visibility external
    //<
    //<ISC_140
    

    //>ISC_140
    //> @attr shuttleItem.optionDataSource (DataSource : null : IR)
    // The optionDataSource for a shuttle item will be applied to the
    // +link{shuttle} as +link{shuttle.dataSource}.
    // <P>
    // If no explicit optionDataSource was specified it may be automatically
    // derived - see +link{FormItem.getOptionDataSource()} for details.
    //
    // @visibility external
    //<
    //<ISC_140


    //>ISC_140
    //> @attr shuttleItem.shuttleFields (Array of ListGridField : null : IR)
    // Which +link{Shuttle.fields} should be displayed in the +link{shuttle}.
    // <P>
    // If not specified, the grids within the shuttle will show a single field
    // containing the +link{formItem.getDisplayFieldName(),displayField}, if
    // specified otherwise the +link{formItem.getValueFieldName(),valueField} for the
    // item
    // 
    // @visibility external
    //<
    //<ISC_140 

    shuttleConstructor:"Shuttle",
    shuttleDefaults:{
        selectionUpdated : function () {
            this.canvasItem.saveValue(this.getSelectedValues());
        }
    },

    _createCanvas : function () {

        var fields = this.shuttleFields;
        var valueField = this.getValueFieldName();
        var displayField = this.getDisplayFieldName() || valueField;
        if (fields == null) {
            fields = [{ name: displayField}];
        }

        var shuttleProperties = {
            dataSource:this.getOptionDataSource(),
            valueField:valueField,
            fields:fields,
            selectedValues:this.getValue()
        };



        this.shuttle = this.canvas = this.createAutoChild("shuttle", shuttleProperties);
        // Call super to set up reference back to CanvasItem, observation etc.
        return this.Super("_createCanvas", arguments);
    },

    showValue : function (displayValue, dataValue) {
        if (!this.canvas) return;
        this.canvas.clearSelection(false);
        this.canvas.setSelectedByValue(dataValue, true);
    }
  
});
