/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.examples.SupplyItem;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SupplyItemStore {
    static Logger log = new Logger(SupplyItemStore.class.getName());
    static Map itemsByID = new HashMap();

    public static SupplyItem storeItem(SupplyItem item) {
        Long itemID = item.getItemID();
        if (itemID == null) {
            itemID = SupplyItemStore.getNextItemID();
        }
        item.setItemID(itemID);
        itemsByID.put(itemID, item);
        return item;
    }

    public static SupplyItem removeItem(Long itemID) {
        return (SupplyItem)itemsByID.remove(itemID);
    }

    public static Long getNextItemID() {
        int highest = 0;
        for (Long id : itemsByID.keySet()) {
            highest = Math.max(highest, id.intValue());
        }
        return highest + 1;
    }

    public static SupplyItem getItemByID(Long itemID) {
        return (SupplyItem)itemsByID.get(itemID);
    }

    public static List findMatchingItems(Long itemID, String itemName) {
        return SupplyItemStore.findMatchingItems(itemID, itemName, 0, Integer.MAX_VALUE);
    }

    public static List findMatchingItems(Long itemID, String itemName, int startRow, int endRow) {
        Collection items = itemsByID.values();
        ArrayList<SupplyItem> matchingItems = new ArrayList<SupplyItem>();
        int count = 0;
        for (SupplyItem item : items) {
            if (itemID != null && !itemID.equals(item.getItemID()) || itemName != null && item.getItemName().toLowerCase().indexOf(itemName.toLowerCase()) == -1 || count++ < startRow) continue;
            if (count >= endRow) break;
            matchingItems.add(item);
        }
        return matchingItems;
    }

    public static int getMatchingRowcount(Long itemID, String itemName) {
        Collection items = itemsByID.values();
        int count = 0;
        for (SupplyItem item : items) {
            if (itemID != null && !itemID.equals(item.getItemID()) || itemName != null && item.getItemName().toLowerCase().indexOf(itemName.toLowerCase()) == -1) continue;
            ++count;
        }
        return count;
    }

    static {
        try {
            DataSource ds = DataSourceManager.get((String)"supplyItem", null);
            List supplyItems = ds.fetch(new HashMap());
            int maxRows = supplyItems.size();
            if (maxRows > 300) {
                maxRows = 300;
            }
            for (int i = 0; i < maxRows; ++i) {
                Map properties = (Map)supplyItems.get(i);
                SupplyItem item = new SupplyItem();
                DataTools.setProperties((Map)properties, (Object)item);
                SupplyItemStore.storeItem(item);
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to initialize SupplyItemStore", (Throwable)e);
        }
    }
}

