import React from 'react';
import { Field, FieldProps } from './Field';
import { AsComponentXML } from './core/ReactComponent';


declare interface DataSourceFieldProps extends FieldProps {

/**
 * See {@link isc.DataSourceField.autoGenerated DataSourceField.autoGenerated}.
 */
autoGenerated?: boolean;

/**
 * See {@link isc.DataSourceField.canSortClientOnly DataSourceField.canSortClientOnly}.
 */
canSortClientOnly?: boolean;

/**
 * See {@link isc.DataSourceField.columnCode DataSourceField.columnCode}.
 */
columnCode?: string;

/**
 * See {@link isc.DataSourceField.valueMap DataSourceField.valueMap}.
 */
valueMap?: ValueMap;

/**
 * See {@link isc.DataSourceField.initRequiresAuthentication DataSourceField.initRequiresAuthentication}.
 */
initRequiresAuthentication?: boolean;

/**
 * See {@link isc.DataSourceField.includeFrom DataSourceField.includeFrom}.
 */
includeFrom?: string;

/**
 * See {@link isc.DataSourceField.relatedTableAlias DataSourceField.relatedTableAlias}.
 */
relatedTableAlias?: string;

/**
 * See {@link isc.DataSourceField.required DataSourceField.required}.
 */
required?: boolean;

/**
 * See {@link isc.DataSourceField.sequenceName DataSourceField.sequenceName}.
 */
sequenceName?: string;

/**
 * See {@link isc.DataSourceField.escapeHTML DataSourceField.escapeHTML}.
 */
escapeHTML?: boolean;

/**
 * See {@link isc.DataSourceField.updateRequiresAuthentication DataSourceField.updateRequiresAuthentication}.
 */
updateRequiresAuthentication?: boolean;

/**
 * See {@link isc.DataSourceField.exportFormat DataSourceField.exportFormat}.
 */
exportFormat?: string;

/**
 * See {@link isc.DataSourceField.description DataSourceField.description}.
 */
description?: string;

/**
 * See {@link isc.DataSourceField.title DataSourceField.title}.
 */
title?: string;

/**
 * See {@link isc.DataSourceField.multipleStorageSeparator DataSourceField.multipleStorageSeparator}.
 */
multipleStorageSeparator?: string;

/**
 * See {@link isc.DataSourceField.javaCollectionClass DataSourceField.javaCollectionClass}.
 */
javaCollectionClass?: string;

/**
 * See {@link isc.DataSourceField.creatorOverrides DataSourceField.creatorOverrides}.
 */
creatorOverrides?: boolean;

/**
 * See {@link isc.DataSourceField.filterEditorType DataSourceField.filterEditorType}.
 */
filterEditorType?: string;

/**
 * See {@link isc.DataSourceField.editRequiresRole DataSourceField.editRequiresRole}.
 */
editRequiresRole?: string;

/**
 * See {@link isc.DataSourceField.canExport DataSourceField.canExport}.
 */
canExport?: boolean;

/**
 * See {@link isc.DataSourceField.imageWidth DataSourceField.imageWidth}.
 */
imageWidth?: number | string;

/**
 * See {@link isc.DataSourceField.viewRequiresRole DataSourceField.viewRequiresRole}.
 */
viewRequiresRole?: string;

/**
 * See {@link isc.DataSourceField.exportForceText DataSourceField.exportForceText}.
 */
exportForceText?: boolean;

/**
 * See {@link isc.DataSourceField.sqlForceInsensitive DataSourceField.sqlForceInsensitive}.
 */
sqlForceInsensitive?: boolean;

/**
 * See {@link isc.DataSourceField.mimeType DataSourceField.mimeType}.
 */
mimeType?: string;

/**
 * See {@link isc.DataSourceField.valueXPath DataSourceField.valueXPath}.
 */
valueXPath?: string;

/**
 * See {@link isc.DataSourceField.initRequires DataSourceField.initRequires}.
 */
initRequires?: string;

/**
 * See {@link isc.DataSourceField.sortByField DataSourceField.sortByField}.
 */
sortByField?: string;

/**
 * See {@link isc.DataSourceField.translatorClassName DataSourceField.translatorClassName}.
 */
translatorClassName?: string;

/**
 * See {@link isc.DataSourceField.storeMilliseconds DataSourceField.storeMilliseconds}.
 */
storeMilliseconds?: boolean;

/**
 * See {@link isc.DataSourceField.canEdit DataSourceField.canEdit}.
 */
canEdit?: boolean;

/**
 * See {@link isc.DataSourceField.showFileInline DataSourceField.showFileInline}.
 */
showFileInline?: boolean;

/**
 * See {@link isc.DataSourceField.javaKeyClass DataSourceField.javaKeyClass}.
 */
javaKeyClass?: string;

/**
 * See {@link isc.DataSourceField.fkColumnCode DataSourceField.fkColumnCode}.
 */
fkColumnCode?: string;

/**
 * See {@link isc.DataSourceField.recreateOnChange DataSourceField.recreateOnChange}.
 */
recreateOnChange?: boolean;

/**
 * See {@link isc.DataSourceField.childTagName DataSourceField.childTagName}.
 */
childTagName?: string;

/**
 * See {@link isc.DataSourceField.deepCloneOnEdit DataSourceField.deepCloneOnEdit}.
 */
deepCloneOnEdit?: boolean;

/**
 * See {@link isc.DataSourceField.timeFormatter DataSourceField.timeFormatter}.
 */
timeFormatter?: string;

/**
 * See {@link isc.DataSourceField.excludeFromState DataSourceField.excludeFromState}.
 */
excludeFromState?: boolean;

/**
 * See {@link isc.DataSourceField.canView DataSourceField.canView}.
 */
canView?: boolean;

/**
 * See {@link isc.DataSourceField.viewRequiresAuthentication DataSourceField.viewRequiresAuthentication}.
 */
viewRequiresAuthentication?: boolean;

/**
 * See {@link isc.DataSourceField.foreignKey DataSourceField.foreignKey}.
 */
foreignKey?: string;

/**
 * See {@link isc.DataSourceField.validOperators DataSourceField.validOperators}.
 */
validOperators?: string[];

/**
 * See {@link isc.DataSourceField.hidden DataSourceField.hidden}.
 */
hidden?: boolean;

/**
 * See {@link isc.DataSourceField.inapplicable DataSourceField.inapplicable}.
 */
inapplicable?: boolean;

/**
 * See {@link isc.DataSourceField.decimalPrecision DataSourceField.decimalPrecision}.
 */
decimalPrecision?: number;

/**
 * See {@link isc.DataSourceField.template DataSourceField.template}.
 */
template?: string;

/**
 * See {@link isc.DataSourceField.primaryKey DataSourceField.primaryKey}.
 */
primaryKey?: boolean;

/**
 * See {@link isc.DataSourceField.allowClientRequestedSummaries DataSourceField.allowClientRequestedSummaries}.
 */
allowClientRequestedSummaries?: boolean;

/**
 * See {@link isc.DataSourceField.updateRequires DataSourceField.updateRequires}.
 */
updateRequires?: string;

/**
 * See {@link isc.DataSourceField.validators DataSourceField.validators}.
 */
validators?: Validator[];

/**
 * See {@link isc.DataSourceField.editorType DataSourceField.editorType}.
 */
editorType?: string;

/**
 * See {@link isc.DataSourceField.xmlAttribute DataSourceField.xmlAttribute}.
 */
xmlAttribute?: boolean;

/**
 * See {@link isc.DataSourceField.fieldValueScript DataSourceField.fieldValueScript}.
 */
fieldValueScript?: string;

/**
 * See {@link isc.DataSourceField.initRequiresRole DataSourceField.initRequiresRole}.
 */
initRequiresRole?: string;

/**
 * See {@link isc.DataSourceField.summaryFunction DataSourceField.summaryFunction}.
 */
summaryFunction?: string;

/**
 * See {@link isc.DataSourceField.importStrategyFailedErrorMessage DataSourceField.importStrategyFailedErrorMessage}.
 */
importStrategyFailedErrorMessage?: string;

/**
 * See {@link isc.DataSourceField.length DataSourceField.length}.
 */
length?: number;

/**
 * See {@link isc.DataSourceField.dateFormatter DataSourceField.dateFormatter}.
 */
dateFormatter?: string;

/**
 * See {@link isc.DataSourceField.valueOperation DataSourceField.valueOperation}.
 */
valueOperation?: string;

/**
 * See {@link isc.DataSourceField.valueMapEnum DataSourceField.valueMapEnum}.
 */
valueMapEnum?: string;

/**
 * See {@link isc.DataSourceField.readOnlyEditorType DataSourceField.readOnlyEditorType}.
 */
readOnlyEditorType?: string;

/**
 * See {@link isc.DataSourceField.ignore DataSourceField.ignore}.
 */
ignore?: boolean;

/**
 * See {@link isc.DataSourceField.canSave DataSourceField.canSave}.
 */
canSave?: boolean;

/**
 * See {@link isc.DataSourceField.editRequiresAuthentication DataSourceField.editRequiresAuthentication}.
 */
editRequiresAuthentication?: boolean;

/**
 * See {@link isc.DataSourceField.emptyDisplayValue DataSourceField.emptyDisplayValue}.
 */
emptyDisplayValue?: string;

/**
 * See {@link isc.DataSourceField.maxFileSize DataSourceField.maxFileSize}.
 */
maxFileSize?: number;

/**
 * See {@link isc.DataSourceField.useLocalDisplayFieldValue DataSourceField.useLocalDisplayFieldValue}.
 */
useLocalDisplayFieldValue?: boolean;

/**
 * See {@link isc.DataSourceField.skipTypeCoercion DataSourceField.skipTypeCoercion}.
 */
skipTypeCoercion?: boolean;

/**
 * See {@link isc.DataSourceField.name DataSourceField.name}.
 */
name?: string;

/**
 * See {@link isc.DataSourceField.rootValue DataSourceField.rootValue}.
 */
rootValue?: any;

/**
 * See {@link isc.DataSourceField.storeWithHash DataSourceField.storeWithHash}.
 */
storeWithHash?: string;

/**
 * See {@link isc.DataSourceField.audit DataSourceField.audit}.
 */
audit?: string;

/**
 * See {@link isc.DataSourceField.valueWriteXPath DataSourceField.valueWriteXPath}.
 */
valueWriteXPath?: string;

/**
 * See {@link isc.DataSourceField.includeVia DataSourceField.includeVia}.
 */
includeVia?: string;

/**
 * See {@link isc.DataSourceField.stringInBrowser DataSourceField.stringInBrowser}.
 */
stringInBrowser?: boolean;

/**
 * See {@link isc.DataSourceField.joinType DataSourceField.joinType}.
 */
joinType?: string;

/**
 * See {@link isc.DataSourceField.group DataSourceField.group}.
 */
group?: string;

/**
 * See {@link isc.DataSourceField.canFilter DataSourceField.canFilter}.
 */
canFilter?: boolean;

/**
 * See {@link isc.DataSourceField.ignoreTextMatchStyle DataSourceField.ignoreTextMatchStyle}.
 */
ignoreTextMatchStyle?: boolean;

/**
 * See {@link isc.DataSourceField.includeSummaryFunction DataSourceField.includeSummaryFunction}.
 */
includeSummaryFunction?: string;

/**
 * See {@link isc.DataSourceField.nullReplacementValue DataSourceField.nullReplacementValue}.
 */
nullReplacementValue?: any;

/**
 * See {@link isc.DataSourceField.filterOn DataSourceField.filterOn}.
 */
filterOn?: string;

/**
 * See {@link isc.DataSourceField.imageHeight DataSourceField.imageHeight}.
 */
imageHeight?: number | string;

/**
 * See {@link isc.DataSourceField.joinPrefix DataSourceField.joinPrefix}.
 */
joinPrefix?: string;

/**
 * See {@link isc.DataSourceField.javaClass DataSourceField.javaClass}.
 */
javaClass?: string;

/**
 * See {@link isc.DataSourceField.calculated DataSourceField.calculated}.
 */
calculated?: boolean;

/**
 * See {@link isc.DataSourceField.joinSuffix DataSourceField.joinSuffix}.
 */
joinSuffix?: string;

/**
 * See {@link isc.DataSourceField.multipleStorage DataSourceField.multipleStorage}.
 */
multipleStorage?: string;

/**
 * See {@link isc.DataSourceField.otherFKs DataSourceField.otherFKs}.
 */
otherFKs?: string;

/**
 * See {@link isc.DataSourceField.joinString DataSourceField.joinString}.
 */
joinString?: string;

/**
 * See {@link isc.DataSourceField.implicitSequence DataSourceField.implicitSequence}.
 */
implicitSequence?: boolean;

/**
 * See {@link isc.DataSourceField.decimalPad DataSourceField.decimalPad}.
 */
decimalPad?: number;

/**
 * See {@link isc.DataSourceField.summaryValueTitle DataSourceField.summaryValueTitle}.
 */
summaryValueTitle?: string;

/**
 * See {@link isc.DataSourceField.requiredMessage DataSourceField.requiredMessage}.
 */
requiredMessage?: string;

/**
 * See {@link isc.DataSourceField.multipleValueSeparator DataSourceField.multipleValueSeparator}.
 */
multipleValueSeparator?: string;

/**
 * See {@link isc.DataSourceField.updateRequiresRole DataSourceField.updateRequiresRole}.
 */
updateRequiresRole?: string;

/**
 * See {@link isc.DataSourceField.formula DataSourceField.formula}.
 */
formula?: string;

/**
 * See {@link isc.DataSourceField.editRequires DataSourceField.editRequires}.
 */
editRequires?: string;

/**
 * See {@link isc.DataSourceField.foreignDisplayField DataSourceField.foreignDisplayField}.
 */
foreignDisplayField?: string;

/**
 * See {@link isc.DataSourceField.exportTitle DataSourceField.exportTitle}.
 */
exportTitle?: string;

/**
 * See {@link isc.DataSourceField.displayField DataSourceField.displayField}.
 */
displayField?: string;

/**
 * See {@link isc.DataSourceField.nillable DataSourceField.nillable}.
 */
nillable?: boolean;

/**
 * See {@link isc.DataSourceField.encodeInResponse DataSourceField.encodeInResponse}.
 */
encodeInResponse?: boolean;

/**
 * See {@link isc.DataSourceField.imageSize DataSourceField.imageSize}.
 */
imageSize?: number | string;

/**
 * See {@link isc.DataSourceField.defaultOperator DataSourceField.defaultOperator}.
 */
defaultOperator?: string;

/**
 * See {@link isc.DataSourceField.precision DataSourceField.precision}.
 */
precision?: number;

/**
 * See {@link isc.DataSourceField.importStrategy DataSourceField.importStrategy}.
 */
importStrategy?: string;

/**
 * See {@link isc.DataSourceField.childrenProperty DataSourceField.childrenProperty}.
 */
childrenProperty?: boolean;

/**
 * See {@link isc.DataSourceField.multiple DataSourceField.multiple}.
 */
multiple?: boolean;

/**
 * See {@link isc.DataSourceField.outputWhen DataSourceField.outputWhen}.
 */
outputWhen?: string;

/**
 * See {@link isc.DataSourceField.lenientXPath DataSourceField.lenientXPath}.
 */
lenientXPath?: boolean;

/**
 * See {@link isc.DataSourceField.type DataSourceField.type}.
 */
type?: string;

/**
 * See {@link isc.DataSourceField.viewRequires DataSourceField.viewRequires}.
 */
viewRequires?: string;

/**
 * See {@link isc.DataSourceField.detail DataSourceField.detail}.
 */
detail?: boolean;

/**
 * See {@link isc.DataSourceField.fkTableCode DataSourceField.fkTableCode}.
 */
fkTableCode?: string;

/**
 * See {@link isc.DataSourceField.propertiesOnly DataSourceField.propertiesOnly}.
 */
propertiesOnly?: boolean;

/**
 * See {@link isc.DataSourceField.format DataSourceField.format}.
 */
format?: string;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * DataSourceField wraps the SmartClient object
 * {@link isc.DataSourceField DataSourceField} for React, allowing you to import
 * DataSourceField for use in React JS and JSX.
 * @class
 */
declare class DataSourceField extends Field {
    props: AsComponentXML<DataSourceFieldProps>;
}
