# Installing the SmartClient runtime

[← Back to API Index](../reference.md)

---

## KB Topic: Installing the SmartClient runtime

### Description
The SmartClient framework is distributed with both client and server components. JavaScript components run on the client, in the browser, and integrate with optional server components that run in a standards-compliant [web container](https://docs.oracle.com/javaee/5/tutorial/doc/bnabo.html), like [Tomcat](https://tomcat.apache.org/index.html). Client components don't necessarily require the server, but server components are designed to make many complicated tasks trivial. See the SmartClient [feature matrix](https://www.smartclient.com/product/) for details.

In all cases, Isomorphic strongly recommends using some form of [dependency management](https://devopedia.org/dependency-manager) in your project, as it dramatically simplifies framework installation and upgrades. Those not using the SmartClient server might consider using the built-in [support for Node Package Manager](npmjs.md#kb-topic-npmjs-support), but most teams with Java experience are at least familiar with [Maven](https://maven.apache.org/guides/index.html) so SmartClient also [includes support](mavenSupport.md#kb-topic-maven-support) for publishing both client and server components to a Maven repository. Note that your project doesn't necessarily need to be built with Maven, it just needs to be able to retrieve its dependencies from that repository. [Gradle](https://gradle.org) and [Ivy](http://ant.apache.org/ivy/index.html) are two popular alternatives, for example.

Those who might prefer to evaluate SmartClient using a self-contained SDK, or still wish to manage the installation manually should refer to the separate documentation topic covering the [SDK Installation](sdkInstall.md#kb-topic-deploying-the-smartclient-sdk). The rest of this overview touches briefly on context, tips, and tricks for those who want to follow best practices but may not necessarily have experience with Java web application development or with Maven.

["Maven is a software project management and comprehension tool"](https://maven.apache.org/what-is-maven.html), whose key features include [a mechanism for dependency resolution](https://maven.apache.org/guides/introduction/introduction-to-dependency-mechanism.html) as recommended above. In short, Maven attempts to retrieve these resources first from a local [repository](https://maven.apache.org/guides/introduction/introduction-to-repositories.html). If the resource isn't found, it attempts to retrieve it from one or more remote repositories, and caches it for subsequent attempts.

Most open source Java libraries can be found on the (remote) [Maven Central](https://search.maven.org) repository, which requires no configuration to use. Occasionally, however, the library you need isn't published to any public repository, and you'll need to [install it locally](https://maven.apache.org/guides/mini/guide-3rd-party-jars-local.html) or [deploy it to a remote repository](https://maven.apache.org/guides/mini/guide-3rd-party-jars-remote.html). Most environments should be using a remote repository [provided by a repository manager](https://maven.apache.org/repository-management.html) set up and maintained by your organization.

SmartClient is not published to any public repository, and so will need to be installed or deployed before you're able to use it in any project. This can be quite tedious when it has to be done for as many [artifacts](https://www.smartclient.com/smartclient-release/isomorphic/system/reference/mavendoc/maven-usage.html) as are provided in current distributions, so [an open source Maven "Plugin"](http://github.smartclient.com/isc-maven-plugin/) is made available with [install](http://github.smartclient.com/isc-maven-plugin/install-mojo.html) and [deploy](http://github.smartclient.com/isc-maven-plugin/deploy-mojo.html) goals that each are capable of downloading, unpacking, and installing or deploying [Patch & Development Builds](https://www.smartclient.com/builds/index.jsp) in a single step. After Maven has been [downloaded](https://maven.apache.org/download.cgi), [installed](https://maven.apache.org/install.html), and [configured](http://github.smartclient.com/isc-maven-plugin/examples/configuration.html) (some configuration required for other than LGPL or EVAL SmartClient builds), this whole process takes no more than a few minutes on a reasonably fast network. Refer to [mavenSupport](mavenSupport.md#kb-topic-maven-support) documentation for a command that you can copy and paste to install the most recent evaluation version of SmartClient, and another to get you started by [generating a skeleton project](https://maven.apache.org/archetype/maven-archetype-plugin/usage.html) from a [Maven archetype](https://maven.apache.org/archetype/index.html), or template.

Having run both of those commands, your newly created project will contain a [pom.xml file](https://maven.apache.org/guides/introduction/introduction-to-the-pom.html), which details among other things the libraries, or dependencies, needed to compile, package, and run the app. In this case, you'll find a reference to the version of SmartClient you used to create the project. To upgrade, you'll just change the value of the ${smartclient.version} property to reflect another build number that you've installed or deployed using the process outlined above and rebuild. To add another JAR to your project, you just add the dependency to your POM. To add one of the SmartClient [optional modules](loadingOptionalModules.md#kb-topic-loading-optional-modules), for example, you'd first use the plugin to install / deploy it to your own repository and then add the appropriate block to your POM's dependencies section.

Your project will also contain a README file containing a copy/paste command line for installing, deploying to and starting a local 'embedded' [Jetty](https://www.eclipse.org/jetty/) server, as well as detailed instructions for [Eclipse](https://help.eclipse.org/latest/index.jsp) integration, and even automated conversion to an [Ant](https://ant.apache.org) based build (complete with Ivy configuration). Isomorphic generally recommends starting with the Jetty command to see things working quickly before experimentation with other approaches. The plugin provides an [FAQ](http://github.smartclient.com/isc-maven-plugin/faq.html) for reference, and posting questions / issues to the public [forum](https://forums.smartclient.com) for help is always appropriate.

---
