/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.io.ISCFile;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.AtomicFileWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;

public class IOUtil {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private static String uniqueProcessIdentifier = null;

    public static void copyStreams(InputStream in, OutputStream out) throws IOException {
        IOUtil.copyStreams(in, out, 4096, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize) throws IOException {
        IOUtil.copyStreams(in, out, bufSize, true);
    }

    public static void copyStreams(InputStream in, OutputStream out, boolean buffered) throws IOException {
        IOUtil.copyStreams(in, out, 4096, buffered);
    }

    public static void copyStreams(InputStream in, OutputStream out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufSize];
        if (buffered) {
            in = new BufferedInputStream(in);
            out = new BufferedOutputStream(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    public static void copyCharacterStreams(Reader in, Writer out) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize) throws IOException {
        IOUtil.copyCharacterStreams(in, out, bufSize, true);
    }

    public static void copyCharacterStreams(Reader in, Writer out, boolean buffered) throws IOException {
        IOUtil.copyCharacterStreams(in, out, 4096, buffered);
    }

    public static void copyCharacterStreams(Reader in, Writer out, int bufSize, boolean buffered) throws IOException {
        int bytesRead;
        char[] buffer = new char[bufSize];
        if (buffered) {
            in = new BufferedReader(in);
            out = new BufferedWriter(out);
        }
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        if (buffered) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutput(Writer writer, Object input) throws Exception {
        if (input instanceof List) {
            List inputs = (List)input;
            Iterator e = inputs.iterator();
            while (e.hasNext()) {
                IOUtil.addOutput(writer, e.next());
            }
        } else if (input instanceof String) {
            writer.write((String)input);
        } else {
            if (input instanceof InputStream) {
                InputStream inputStream = (InputStream)input;
                InputStreamReader reader = new InputStreamReader(inputStream);
                try {
                    IOUtil.copyCharacterStreams(reader, writer);
                }
                finally {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (input instanceof Reader) {
                Reader inputReader = (Reader)input;
                try {
                    IOUtil.copyCharacterStreams(inputReader, writer);
                }
                finally {
                    try {
                        inputReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new Exception("Unsupported input format: " + input.getClass().getName());
        }
    }

    public static void addOutput(OutputStream out, Object input) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(new NonFlushingOutputStream(out));
        IOUtil.addOutput(writer, input);
        ((Writer)writer).flush();
    }

    public static Reader makeReader(Object source) {
        if (source == null) {
            throw new NullPointerException("Passed null source");
        }
        if (source instanceof Reader) {
            return (Reader)source;
        }
        if (source instanceof InputStream) {
            return new InputStreamReader((InputStream)source);
        }
        if (source instanceof String || source instanceof StringBuffer) {
            return new StringReader(source.toString());
        }
        if (source instanceof char[]) {
            return new CharArrayReader((char[])source);
        }
        if (source instanceof byte[]) {
            return new InputStreamReader(new ByteArrayInputStream((byte[])source));
        }
        throw new IllegalArgumentException("Don't know to make a Reader from a " + source.getClass().getName());
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        return IOUtil.readerToString(new InputStreamReader(stream));
    }

    public static String readerToString(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtil.copyCharacterStreams(reader, writer);
        return ((Object)writer).toString();
    }

    public static void closeQuitely(InputStream is) {
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeQuitely(OutputStream os) {
        try {
            os.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            os.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] toByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = 0;
        while (read != -1) {
            read = stream.read(buffer);
            if (read <= 0) continue;
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static File threadSafeTmpFile(File file) throws IOException {
        return new File(IOUtil.threadSafeTmpFileName(file.getCanonicalPath()));
    }

    public static String threadSafeTmpFileName(String fileName) {
        String tmpFileName = IOUtil._threadSafeTmpFileName(fileName);
        File tmpFile = new File(tmpFileName);
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        return tmpFileName;
    }

    public static String _threadSafeTmpFileName(String fileName) {
        if (uniqueProcessIdentifier == null) {
            try {
                uniqueProcessIdentifier = ManagementFactory.getRuntimeMXBean().getName();
            }
            catch (Throwable t) {
                uniqueProcessIdentifier = UUID.randomUUID().toString();
            }
        }
        return fileName + ".tmp." + uniqueProcessIdentifier + "." + Thread.currentThread().getId();
    }

    public static void atomicWrite(String data, ISCFile iscFile) throws IOException {
        IOUtil.atomicWrite((Reader)new StringReader(data), iscFile);
    }

    public static void atomicWrite(String data, File file) throws IOException {
        IOUtil.atomicWrite((Reader)new StringReader(data), file);
    }

    public static void atomicWrite(String data, String fileName) throws IOException {
        IOUtil.atomicWrite((Reader)new StringReader(data), fileName);
    }

    public static void atomicWrite(Reader reader, ISCFile iscFile) throws IOException {
        Writer writer = iscFile.getWriter();
        IOUtil.copyCharacterStreams(reader, writer);
        writer.close();
    }

    public static void atomicWrite(Reader reader, File file) throws IOException {
        AtomicFileWriter writer = new AtomicFileWriter(file);
        IOUtil.copyCharacterStreams(reader, (Writer)((Object)writer));
        writer.close();
    }

    public static void atomicWrite(Reader reader, String fileName) throws IOException {
        AtomicFileWriter writer = new AtomicFileWriter(fileName);
        IOUtil.copyCharacterStreams(reader, (Writer)((Object)writer));
        writer.close();
    }

    public static void atomicWrite(InputStream in, ISCFile iscFile) throws IOException {
        OutputStream out = iscFile.getOutputStream();
        IOUtil.copyStreams(in, out);
        out.close();
    }

    public static void atomicWrite(InputStream in, File file) throws IOException {
        AtomicFileOutputStream out = new AtomicFileOutputStream(file);
        IOUtil.copyStreams(in, (OutputStream)((Object)out));
        out.close();
    }

    public static void atomicWrite(InputStream in, String fileName) throws IOException {
        AtomicFileOutputStream out = new AtomicFileOutputStream(fileName);
        IOUtil.copyStreams(in, (OutputStream)((Object)out));
        out.close();
    }

    public static boolean atomicMove(ISCFile origFile, ISCFile newFile) throws IOException {
        return origFile.renameTo(newFile);
    }

    public static boolean atomicMove(File origFile, File newFile) throws IOException {
        return IOUtil.atomicMove(origFile.getCanonicalPath(), newFile.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean atomicMove(String origFileName, String newFileName) throws IOException {
        boolean renamed = IOUtil._atomicRename(origFileName, newFileName);
        if (renamed) {
            return true;
        }
        File origFile = new File(origFileName);
        String tmpAdjacentFileName = IOUtil._threadSafeTmpFileName(newFileName);
        File tmpAdjacentFile = new File(tmpAdjacentFileName);
        if (!tmpAdjacentFileName.equals(origFileName) && !tmpAdjacentFile.equals(origFile)) {
            FileUtils.copyFile((File)origFile, (File)tmpAdjacentFile, (boolean)true);
            try {
                renamed = IOUtil._atomicRename(tmpAdjacentFileName, newFileName);
                if (renamed) {
                    origFile.delete();
                }
            }
            finally {
                tmpAdjacentFile.delete();
            }
        }
        if (!renamed) {
            File newFile = new File(newFileName);
            newFile.delete();
            renamed = origFile.renameTo(newFile);
        }
        if (!renamed) {
            FileUtils.moveFile((File)origFile, (File)new File(newFileName));
            renamed = true;
        }
        return renamed;
    }

    public static boolean _atomicRename(File origFile, File newFile) throws IOException {
        return IOUtil._atomicRename(origFile.getCanonicalPath(), newFile.getCanonicalPath());
    }

    public static boolean _atomicRename(String origFileName, String newFileName) {
        boolean renamed = false;
        if (SystemUtils.JAVA_VERSION_INT >= 170) {
            try {
                Files.move(Paths.get(origFileName, new String[0]), Paths.get(newFileName, new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                renamed = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!renamed) {
            File origFile = new File(origFileName);
            File newFile = new File(newFileName);
            renamed = origFile.renameTo(newFile);
        }
        return renamed;
    }

    static class NonFlushingOutputStream
    extends FilterOutputStream {
        public NonFlushingOutputStream(OutputStream stream) {
            super(stream);
        }

        @Override
        public void flush() {
        }
    }
}

