/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;

public class EasyMock2FactoryWriter
implements FactoryWriter {
    private final PrintWriter output;
    private final String javaPackageName;
    private final String javaClassName;
    private String indentationString = "  ";
    private String newLine = "\n";
    private int indentation = 1;

    public EasyMock2FactoryWriter(Writer output, String javaPackageName, String javaClassName) {
        this.javaPackageName = javaPackageName;
        this.javaClassName = javaClassName;
        this.output = new PrintWriter(output);
    }

    public void writeHeader() throws IOException {
        this.output.append("package ").append(this.javaPackageName).append(';').append(this.newLine).append(this.newLine);
        this.output.append("public class ").append(this.javaClassName).append(" {").append(this.newLine).append(this.newLine);
    }

    public void writeFooter() throws IOException {
        this.output.append('}').append(this.newLine);
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void writeMethod(String generatedMethodName, FactoryMethod factoryMethodToDelegateTo) throws IOException {
        this.writeJavaDoc(factoryMethodToDelegateTo);
        this.indent();
        this.output.append("public static ");
        String returnType = factoryMethodToDelegateTo.getGenerifiedType();
        if (returnType == null) {
            returnType = "java.lang.Object";
        }
        this.output.append(returnType);
        this.output.append(' ').append(generatedMethodName);
        this.writeParameters(factoryMethodToDelegateTo);
        this.writeExceptions(factoryMethodToDelegateTo);
        this.output.append(" {").append(this.newLine);
        ++this.indentation;
        this.writeMethodBody(factoryMethodToDelegateTo);
        --this.indentation;
        this.indent();
        this.output.append('}').append(this.newLine).append(this.newLine);
    }

    private void writeMethodBody(FactoryMethod factoryMethod) {
        this.indent();
        this.output.append("org.hamcrest.integration.EasyMockAdapter.adapt(").append(this.newLine);
        ++this.indentation;
        this.indent();
        this.output.append(factoryMethod.getMatcherClass());
        this.output.append('.').append(factoryMethod.getName());
        this.output.append('(');
        boolean seenFirst = false;
        for (FactoryMethod.Parameter parameter : factoryMethod.getParameters()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                seenFirst = true;
            }
            this.output.append(parameter.getName());
        }
        this.output.append("));").append(this.newLine);
        --this.indentation;
        this.indent();
        this.output.append("return null;").append(this.newLine);
    }

    private void writeExceptions(FactoryMethod factoryMethod) {
        boolean seenFirst = false;
        for (String exception : factoryMethod.getExceptions()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                this.output.append(" throws ");
                seenFirst = true;
            }
            this.output.append(exception);
        }
    }

    private void writeParameters(FactoryMethod factoryMethod) {
        this.output.append('(');
        boolean seenFirst = false;
        for (FactoryMethod.Parameter parameter : factoryMethod.getParameters()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                seenFirst = true;
            }
            this.output.append(parameter.getType()).append(' ').append(parameter.getName());
        }
        this.output.append(')');
    }

    private void writeJavaDoc(FactoryMethod factoryMethod) {
        String[] lines;
        if (factoryMethod.getJavaDoc() != null && (lines = factoryMethod.getJavaDoc().split("\n")).length > 0) {
            this.indent();
            this.output.append("/**").append(this.newLine);
            for (String line : lines) {
                this.indent();
                this.output.append(" * ").append(line).append(this.newLine);
            }
            this.indent();
            this.output.append(" */").append(this.newLine);
        }
    }

    private void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.append(this.indentationString);
        }
    }
}

