/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.messaging;

import com.isomorphic.messaging.MessagingConnectionHandler;
import com.isomorphic.servlet.BaseServlet;
import com.isomorphic.servlet.RequestContext;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MessagingServlet
extends BaseServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contentType;
        boolean eventStream = "true".equals(request.getParameter("eventStream"));
        boolean disconnectUponConnect = "true".equals(request.getParameter("disconnectUponConnect"));
        request.setAttribute("isc_dontCompress", (Object)"RealtimeMessaging responses cannot be compressed");
        String encoding = this.getServletConfig().getInitParameter("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        String string = contentType = eventStream ? "text/event-stream" : "text/html";
        if (eventStream) {
            contentType = contentType + ";charset=UTF-8";
            response.setContentType(contentType);
        } else if (!"none".equalsIgnoreCase(encoding)) {
            request.setCharacterEncoding(encoding);
            contentType = contentType + ";charset=" + encoding;
            response.setContentType(contentType);
        } else {
            response.setContentType(contentType);
        }
        MessagingConnectionHandler handler = null;
        try {
            RequestContext context = RequestContext.instance((Servlet)this, (HttpServletRequest)request, (HttpServletResponse)response);
            context.setContentType(contentType);
            handler = new MessagingConnectionHandler(context);
            handler.eventStream = eventStream;
            handler.disconnectUponConnect = disconnectUponConnect;
            handler.process();
        }
        catch (Throwable t) {
            this.handleError(response, t);
        }
        finally {
            if (handler != null) {
                handler.cleanup();
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

