/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.jpa;

import com.isomorphic.base.Config;
import com.isomorphic.jpa.EMFProviderInterface;
import com.isomorphic.log.Logger;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;

public class EMFProviderCMT
implements EMFProviderInterface {
    private static final String CLASS_NAME = EMFProviderCMT.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public String entityManagerRef;
    public String entityManagerFactoryRef;

    public EMFProviderCMT() {
        this(Config.getGlobal().getString((Object)"jpa.entityManager", null), Config.getGlobal().getString((Object)"jpa.entityManagerFactory", null));
    }

    public EMFProviderCMT(Properties config) {
        this(config.getProperty("entityManager"), config.getProperty("entityManagerFactory"));
    }

    public EMFProviderCMT(String entityManagerRef, String entityManagerFactoryRef) {
        this.entityManagerRef = entityManagerRef;
        this.entityManagerFactoryRef = entityManagerFactoryRef;
    }

    @Override
    public EntityManagerFactory get() {
        EntityManagerFactory emf = null;
        try {
            Context envCtx = new InitialContext();
            envCtx = (Context)envCtx.lookup("java:comp/env");
            emf = (EntityManagerFactory)envCtx.lookup(this.entityManagerFactoryRef);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire entity manager factory.", (Throwable)ex);
        }
        if (emf == null) {
            throw new PersistenceException("Unable to acquire entity manager factory.");
        }
        return emf;
    }

    @Override
    public EntityManager getEntityManager() throws PersistenceException {
        EntityManager em = null;
        try {
            Context envCtx = new InitialContext();
            envCtx = (Context)envCtx.lookup("java:comp/env");
            em = (EntityManager)envCtx.lookup(this.entityManagerRef);
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire entity manager.", (Throwable)ex);
        }
        if (em == null) {
            throw new PersistenceException("Unable to acquire entity manager.");
        }
        return em;
    }

    @Override
    public void returnEntityManager(EntityManager em) {
    }

    @Override
    public Object getTransaction(EntityManager em) throws Exception {
        EJBContext tx = null;
        try {
            InitialContext envCtx = new InitialContext();
            tx = (EJBContext)envCtx.lookup("java:comp/EJBContext");
            em.joinTransaction();
        }
        catch (Exception ex) {
            throw new PersistenceException("Unable to acquire transaction.", (Throwable)ex);
        }
        if (tx == null) {
            throw new PersistenceException("Unable to acquire transaction.");
        }
        return tx;
    }

    @Override
    public void commitTransaction(Object tx) throws Exception {
    }

    @Override
    public void rollbackTransaction(Object tx) {
        if (tx != null) {
            try {
                ((EJBContext)tx).setRollbackOnly();
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected exception while rolling back transaction", (Throwable)ex);
            }
        }
    }
}

