/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.auth.DevModeAuthFilter;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.taglib.BaseTag;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class LoadTag
extends BaseTag {
    public String suffix = null;
    public String defer = null;
    public String cacheOnly = null;
    public String onload = null;
    public String version = null;
    public String isomorphicDir = null;
    public String modulesDir = "system/modules/";
    public String debugModulesDir = "system/modules-debug/";
    public Boolean useDebugModules = null;
    public String isomorphicDevURI = null;
    public String isomorphicURI = null;
    private static final Pattern UNESCAPED_SINGLE_QUOTE_PATTERN = Pattern.compile("(?<!\\\\)'");
    public String relativePathToWebRoot = null;
    public String absolutePathToWebRoot = null;

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setDefer(String defer) {
        this.defer = defer;
    }

    public String getDefer() {
        return this.defer;
    }

    public void setCacheOnly(String cacheOnly) {
        this.cacheOnly = cacheOnly;
    }

    public String getCacheOnly() {
        return this.cacheOnly;
    }

    public void setOnload(String onload) {
        this.onload = onload;
    }

    public String getOnload() {
        return this.onload;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setIsomorphicDir(String isomorphicDir) {
        this.isomorphicDir = isomorphicDir;
    }

    public String getIsomorphicDir() {
        return this.isomorphicDir;
    }

    public void setModulesDir(String modulesDir) {
        if (!modulesDir.endsWith("/")) {
            modulesDir = modulesDir + "/";
        }
        this.modulesDir = modulesDir;
    }

    public final String getModulesDir() {
        return this.modulesDir;
    }

    public void setDebugModulesDir(String debugModulesDir) {
        if (!debugModulesDir.endsWith("/")) {
            debugModulesDir = debugModulesDir + "/";
        }
        this.debugModulesDir = debugModulesDir;
    }

    public final String getDebugModulesDir() {
        return this.debugModulesDir;
    }

    public void setUseDebugModules(String useDebugModules) {
        this.useDebugModules = Boolean.valueOf(useDebugModules);
    }

    public String getUseDebugModules() {
        return "" + this.useDebugModules;
    }

    public void setIsomorphicDevURI(String isomorphicDevURI) {
        if (!isomorphicDevURI.endsWith("/")) {
            isomorphicDevURI = isomorphicDevURI + "/";
        }
        this.isomorphicDevURI = isomorphicDevURI;
    }

    public String getIsomorphicDevURI() {
        String uri = this.pageContext.getRequest().getParameter("isomorphicDevURI");
        if (uri != null && DevModeAuthFilter.devModeAuthorized((HttpServletRequest)this.pageContext.getRequest())) {
            return uri;
        }
        return this.isomorphicDevURI;
    }

    public void setIsomorphicURI(String isomorphicURI) {
        if (!isomorphicURI.endsWith("/")) {
            isomorphicURI = isomorphicURI + "/";
        }
        this.isomorphicURI = isomorphicURI;
    }

    protected String safeURI(String URI2) {
        Matcher matcher = UNESCAPED_SINGLE_QUOTE_PATTERN.matcher(URI2);
        return matcher.replaceAll("\\'");
    }

    public String getIsomorphicURI() {
        if (this.isomorphicURI == null) {
            this.isomorphicURI = (String)this.pageContext.getRequest().getAttribute("isomorphicURI");
        }
        if (this.isomorphicURI != null) {
            this.isomorphicURI = this.safeURI(this.isomorphicURI);
            return this.isomorphicURI;
        }
        this.isomorphicURI = config.getPath("isomorphicURI");
        if ("__AUTODETECT__".equals(this.isomorphicURI) || "__auto__".equals(this.isomorphicURI)) {
            String relativePathToWebRoot = this.getRelativePathToWebRoot();
            this.isomorphicURI = relativePathToWebRoot + config.getPath("isomorphicURIRootRelative");
            this.isomorphicURI = ISCFile.canonicalizePath(this.isomorphicURI);
            if (!this.isomorphicURI.endsWith("/")) {
                this.isomorphicURI = this.isomorphicURI + "/";
            }
        }
        this.log.debug("isomorphicURI not specified in tag, defaulting to: " + this.isomorphicURI);
        if (!this.isomorphicURI.endsWith("/")) {
            this.isomorphicURI = this.isomorphicURI + "/";
        }
        this.isomorphicURI = this.safeURI(this.isomorphicURI);
        this.pageContext.getRequest().setAttribute("isomorphicURI", (Object)this.isomorphicURI);
        return this.isomorphicURI;
    }

    public String getRelativePathToWebRoot() {
        if (this.relativePathToWebRoot != null) {
            return this.relativePathToWebRoot;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String uri = ServletTools.getInitialRequestURI(request);
        List<String> pathComponents = DataTools.simpleSplit(uri, "/");
        int count = pathComponents.size() - 1;
        if (uri.endsWith("/")) {
            ++count;
        }
        String relativeComponent = "";
        for (int i = count; i > 0; --i) {
            relativeComponent = relativeComponent + "../";
        }
        return relativeComponent;
    }

    public void setRelativePathToWebRoot(String relativePathToWebRoot) {
        this.relativePathToWebRoot = relativePathToWebRoot;
    }

    public String getAbsolutePathToWebRoot() {
        return this.absolutePathToWebRoot;
    }

    public void setAbsolutePathToWebRoot(String absolutePathToWebRoot) {
        this.absolutePathToWebRoot = absolutePathToWebRoot;
    }

    public String browserPathToFile(String fileName) {
        String absoluePathToWebRoot = this.getAbsolutePathToWebRoot();
        if (this.absolutePathToWebRoot != null) {
            String filePath = ISCFile.canonicalizePath(this.absolutePathToWebRoot + "/" + fileName);
            return filePath;
        }
        String relativePathToWebRoot = this.getRelativePathToWebRoot();
        String filePath = ISCFile.canonicalizePath(relativePathToWebRoot + fileName);
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public String versionedBrowserPathToFile(String fileName, String fileExtension) {
        return this.addVersion(this.browserPathToFile(fileName), fileExtension);
    }

    public String versionedBrowserPathToFile(String fileName) {
        return this.addVersion(this.browserPathToFile(fileName));
    }

    @Override
    public void init() {
        super.init();
        boolean defer = "true".equals(this.getDefer());
        boolean cacheOnly = "true".equals(this.getCacheOnly());
        this.getIsomorphicURI();
        try {
            if (this.pageContext.getRequest().getAttribute("_isc_isomorphicDir") == null) {
                String iscDir = this.isomorphicDir;
                if (iscDir == null) {
                    iscDir = this.isomorphicURI;
                }
                this.pageContext.getOut().write("<SCRIPT>window.isomorphicDir='" + iscDir + "';</SCRIPT>\n");
                this.pageContext.getRequest().setAttribute("_isc_isomorphicDir", (Object)Boolean.TRUE);
            }
            if ((defer || cacheOnly) && this.pageContext.getRequest().getAttribute("_isc_fileLoader") == null) {
                String version = this.getVersion();
                this.pageContext.getOut().write("<SCRIPT SRC=" + this.addVersion(this.isomorphicURI + this.getModulesDir() + "ISC_FileLoader.js") + "></SCRIPT>");
                if (config.getBoolean((Object)"FileLoader.disableCaching", false) && this.pageContext.getRequest().getAttribute("enableFileLoaderCaching") == null) {
                    this.pageContext.getOut().write("<SCRIPT>isc.FileLoader.disableCaching=true;</SCRIPT>");
                }
                this.pageContext.getRequest().setAttribute("_isc_fileLoader", (Object)Boolean.TRUE);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"caught exception sending fileLoader", e);
        }
    }

    protected String getIsomorphicVersion() {
        String version = this.getVersion();
        if (version == null) {
            version = config.getString("iscVersionNumber");
        }
        return version;
    }

    protected String addVersion(String url) {
        return this.addVersion(url, "js");
    }

    protected String addVersion(String url, String fileExtension) {
        String devMode;
        if (!config.getBoolean((Object)"isc.addVersionToLoadTags", false)) {
            return url;
        }
        String version = this.getIsomorphicVersion();
        String versionParamName = config.getString("isc.versionParamName");
        if (url.indexOf(versionParamName + "=") == -1) {
            url = ServletTools.addQueryParameter(url, versionParamName, version + "." + fileExtension);
        }
        if (!(devMode = config.getString("devMode", "dev")).equals("dev")) {
            url = ServletTools.addQueryParameter(url, "devMode", devMode + "." + fileExtension);
        }
        return url;
    }
}

