/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Config;
import com.isomorphic.base.ICall;
import com.isomorphic.base.Reflection;
import com.isomorphic.base.ReflectionArgument;
import com.isomorphic.base.VersionSafeChecker;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.crypto.BCrypt;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.IOUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.ArrayUtils;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

public class DataTools {
    private static Logger log = new Logger(DataTools.class.getName());
    private static boolean supportsNativeUTC = Arrays.asList(TimeZone.getAvailableIDs()).indexOf("UTC") != -1;
    private static final Class<?>[] ARRAY_PRIMITIVE_TYPES = new Class[]{int[].class, float[].class, double[].class, boolean[].class, byte[].class, short[].class, long[].class, char[].class};
    public static final Object[] EMPTY_ARRAY = new Object[0];
    private static Map<String, Class> cachedClasses = new HashMap<String, Class>();
    public static long getPropsLapse = 0L;
    public static long readMethodLapse = 0L;
    public static long reflectionInvokeLapse = 0L;
    private static Map<Class, Map<String, PropertyDescriptor>> cachedPropertyDescriptors = new HashMap<Class, Map<String, PropertyDescriptor>>();
    private static Boolean cachePropertyDescriptors = null;
    public static long lapse = 0L;
    public static HashMap defaultTransformers = new HashMap();
    public static DataTypeMap mimeTypesJS;
    public static boolean useMimeTypesJS;

    public static List keysNotPresent(Map map, List keys) {
        ArrayList missingList = null;
        for (Object key : keys) {
            if (map.containsKey(key)) continue;
            if (missingList == null) {
                missingList = new ArrayList();
            }
            missingList.add(key);
        }
        return missingList;
    }

    public static Map subsetMap(Map origMap, List keys) {
        if (origMap == null || keys == null) {
            return null;
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (Object key : keys) {
            if (!origMap.containsKey(key)) continue;
            newMap.put(key, origMap.get(key));
        }
        return newMap;
    }

    public static <T> boolean containsAllKeys(Map<T, ?> map, T ... keys) {
        if (map == null || keys == null || keys.length == 0) {
            return false;
        }
        for (T key : keys) {
            if (map.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static Map subsetMap(Map origMap, List keys, boolean trimOrigMap) {
        if (!trimOrigMap) {
            return DataTools.subsetMap(origMap, keys);
        }
        if (origMap == null || keys == null) {
            return null;
        }
        Iterator i = origMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (keys.contains(key)) continue;
            i.remove();
        }
        return origMap;
    }

    public static List subsetByPrefix(List list, String prefix) {
        if (list == null) {
            return null;
        }
        ArrayList newList = new ArrayList();
        for (Object elem : list) {
            if (!(elem instanceof String) || !((String)elem).startsWith(prefix)) continue;
            newList.add(elem);
        }
        return newList;
    }

    public static List removeEmptyStrings(List list) {
        if (list == null) {
            return null;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object elem = i.next();
            if (!(elem instanceof String) || !((String)elem).equals("")) continue;
            i.remove();
        }
        return list;
    }

    public static List removeDuplicates(List list) {
        if (list == null) {
            return null;
        }
        ArrayList seen = new ArrayList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object elem = i.next();
            if (elem == null) continue;
            if (seen.contains(elem)) {
                i.remove();
                continue;
            }
            seen.add(elem);
        }
        return list;
    }

    public static Map removeNullValuedKeys(Map map) {
        if (map == null) {
            return null;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            if (map.get(i.next()) != null) continue;
            i.remove();
        }
        return map;
    }

    public static Map removeEmptyStringValuedKeys(Map map) {
        if (map == null) {
            return null;
        }
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object value = map.get(i.next());
            if (!(value instanceof String) || ((String)value).length() != 0) continue;
            i.remove();
        }
        return map;
    }

    public static Map divideMap(Map origMap, List retainKeys) {
        if (origMap == null || retainKeys == null) {
            return null;
        }
        HashMap removedKeys = null;
        Iterator origKeys = origMap.keySet().iterator();
        while (origKeys.hasNext()) {
            Object key = origKeys.next();
            if (retainKeys.contains(key)) continue;
            if (removedKeys == null) {
                removedKeys = new HashMap();
            }
            removedKeys.put(key, origMap.get(key));
            origKeys.remove();
        }
        return removedKeys;
    }

    public static Map mapUnion(Map primary, Map secondary) {
        if (primary == null && secondary == null) {
            return new HashMap();
        }
        if (primary == null) {
            return new HashMap(secondary);
        }
        if (secondary == null) {
            return new HashMap(primary);
        }
        HashMap newMap = new HashMap();
        for (Object key : secondary.keySet()) {
            newMap.put(key, secondary.get(key));
        }
        for (Object key : primary.keySet()) {
            newMap.put(key, primary.get(key));
        }
        return newMap;
    }

    public static LinkedHashMap orderedMapUnion(Map primary, Map secondary) {
        if (primary == null && secondary == null) {
            return new LinkedHashMap();
        }
        if (primary == null) {
            return new LinkedHashMap(secondary);
        }
        if (secondary == null) {
            return new LinkedHashMap(primary);
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (Object key : primary.keySet()) {
            newMap.put(key, primary.get(key));
        }
        for (Object key : secondary.keySet()) {
            if (newMap.containsKey(key)) continue;
            newMap.put(key, secondary.get(key));
        }
        return newMap;
    }

    public static Object deepMerge(Object source, Object target, boolean overwrite) throws Exception {
        if (source == null || target == null) {
            return null;
        }
        if (target instanceof Map && source instanceof Map) {
            Map targetMap = (Map)target;
            Map sourceMap = (Map)source;
            for (Object key : sourceMap.keySet()) {
                Object value = sourceMap.get(key);
                if (!targetMap.containsKey(key)) {
                    targetMap.put(key, value);
                    continue;
                }
                Object targetValue = targetMap.get(key);
                if (targetValue instanceof Map && value instanceof Map || targetValue instanceof Collection && value instanceof Collection) {
                    DataTools.deepMerge(value, targetValue, overwrite);
                    continue;
                }
                if (!overwrite) continue;
                targetMap.put(key, value);
            }
        } else if (target instanceof Collection && source instanceof Collection) {
            Collection targetCollection = (Collection)target;
            Collection sourceCollection = (Collection)source;
            for (Object sourceValue : sourceCollection) {
                if (targetCollection.contains(sourceValue)) continue;
                targetCollection.add(sourceValue);
            }
        } else {
            throw new Exception("deepMerge type mismatch. source is of type '" + source.getClass().getName() + " while target is of type " + target.getClass().getName() + " source: " + source.toString() + " target: " + target.toString());
        }
        return target;
    }

    public static Object deepClone(Object source) throws Exception {
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            Map target = (Map)Reflection.newInstance(source.getClass());
            for (Object key : ((Map)source).keySet()) {
                Object value = ((Map)source).get(key);
                target.put(key, DataTools.deepClone(value));
            }
            return target;
        }
        if (source instanceof Collection) {
            Collection target = (Collection)Reflection.newInstance(source.getClass());
            for (Object value : (Collection)source) {
                target.add(DataTools.deepClone(value));
            }
            return target;
        }
        Method cloneMethod = null;
        try {
            cloneMethod = Reflection.findMethod(source, "clone");
        }
        catch (NoSuchMethodException i) {
            // empty catch block
        }
        if (cloneMethod != null) {
            return cloneMethod.invoke(source, null);
        }
        Class[] paramTypes = new Class[]{source.getClass()};
        Constructor<?> copyConstructor = null;
        try {
            copyConstructor = source.getClass().getConstructor(paramTypes);
        }
        catch (NoSuchMethodException value) {
            // empty catch block
        }
        if (copyConstructor != null) {
            Object[] params = new Object[]{source};
            return copyConstructor.newInstance(params);
        }
        return source;
    }

    public static void deepRemoveKey(Object keyToRemove, Object data) throws Exception {
        block4: {
            block3: {
                if (!(data instanceof Map)) break block3;
                Map dataMap = (Map)data;
                Iterator i = dataMap.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    if (key == keyToRemove) {
                        i.remove();
                        continue;
                    }
                    DataTools.deepRemoveKey(keyToRemove, dataMap.get(key));
                }
                break block4;
            }
            if (!(data instanceof Collection)) break block4;
            Collection dataCollection = (Collection)data;
            Iterator i = dataCollection.iterator();
            while (i.hasNext()) {
                DataTools.deepRemoveKey(keyToRemove, i.next());
            }
        }
    }

    public static void deepRemoveNullValues(Object data) throws Exception {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map dataMap = (Map)data;
                Iterator i = dataMap.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    Object value = dataMap.get(key);
                    if (value == null) {
                        i.remove();
                        continue;
                    }
                    DataTools.deepRemoveNullValues(value);
                }
                break block5;
            }
            if (!(data instanceof Collection)) break block5;
            Collection dataCollection = (Collection)data;
            Iterator i = dataCollection.iterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (value == null) {
                    i.remove();
                    continue;
                }
                DataTools.deepRemoveNullValues(value);
            }
        }
    }

    public static void deepRemoveEmptyCollections(Object data) throws Exception {
        block5: {
            block4: {
                if (!(data instanceof Map)) break block4;
                Map dataMap = (Map)data;
                Iterator i = dataMap.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    Object value = dataMap.get(key);
                    if (value instanceof Collection && ((Collection)value).size() == 0) {
                        i.remove();
                        continue;
                    }
                    DataTools.deepRemoveEmptyCollections(value);
                }
                break block5;
            }
            if (!(data instanceof Collection)) break block5;
            Collection dataCollection = (Collection)data;
            Iterator i = dataCollection.iterator();
            while (i.hasNext()) {
                Object value = i.next();
                if (value instanceof Collection && ((Collection)value).size() == 0) {
                    i.remove();
                    continue;
                }
                DataTools.deepRemoveEmptyCollections(value);
            }
        }
    }

    public static Map cascadeMaps(Map ... maps) {
        HashMap accumulator = maps[maps.length - 1];
        if (accumulator == null) {
            accumulator = new HashMap();
        }
        if (maps.length == 1) {
            return accumulator;
        }
        for (int i = 0; i < maps.length - 1; ++i) {
            Map m = maps[i];
            if (m == null) continue;
            DataTools.mapMerge(m, accumulator);
        }
        return accumulator;
    }

    public static Map mapMerge(Map source, Map target) {
        if (target == null) {
            return null;
        }
        if (source == null) {
            return target;
        }
        for (Object key : source.keySet()) {
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map mapMergeNonNull(Map source, Map target) {
        if (target == null) {
            return null;
        }
        if (source == null) {
            return target;
        }
        for (Object key : source.keySet()) {
            Object value = source.get(key);
            if (value == null) continue;
            target.put(key, value);
        }
        return target;
    }

    public static Map putAllNotPresent(Map target, Map source) {
        if (target == null) {
            return null;
        }
        if (source == null) {
            return target;
        }
        for (Object key : source.keySet()) {
            if (target.containsKey(key)) continue;
            target.put(key, source.get(key));
        }
        return target;
    }

    public static Map mapIntersection(Map primary, Map secondary) {
        if (primary == null && secondary == null) {
            return null;
        }
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        HashMap result = new HashMap();
        for (Object key : primary.keySet()) {
            Object value;
            if (secondary.get(key) == null || (value = primary.get(key)) == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public static List mapIntersectionKeys(Map one, Map two) {
        ArrayList result = new ArrayList();
        if (one == null || two == null) {
            return result;
        }
        Map iterMap = one;
        Map compMap = two;
        if (two.size() < one.size()) {
            iterMap = two;
            compMap = one;
        }
        for (Object key : iterMap.keySet()) {
            if (compMap.get(key) == null) continue;
            result.add(compMap.get(key));
        }
        return result;
    }

    public static Map substringKeyMap(String prefix, Map source) {
        if (prefix == null) {
            return source;
        }
        if (source == null) {
            return null;
        }
        HashMap newMap = new HashMap();
        for (String key : source.keySet()) {
            if (!key.startsWith(prefix)) continue;
            String newKey = key.substring(prefix.length(), key.length());
            newMap.put(newKey, source.get(key));
        }
        return newMap;
    }

    public static Map identityMap(List list) {
        if (list == null) {
            return null;
        }
        HashMap map = new HashMap();
        for (Object element : list) {
            map.put(element, element);
        }
        return map;
    }

    public static Map reverseMap(Map origMap) {
        HashMap reverseMap = new HashMap();
        for (Object origKey : origMap.keySet()) {
            Object origValue = origMap.get(origKey);
            DataTools.putMultiple(reverseMap, origValue, origKey);
        }
        return reverseMap;
    }

    public static Map putMultiple(Map map, Object key, Object value) {
        Object existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, value);
        } else if (existingValue instanceof List) {
            ((List)existingValue).add(value);
        } else {
            map.put(key, DataTools.buildList(existingValue, value));
        }
        return map;
    }

    public static Map putMultipleAsList(Map map, Object key, Object value) {
        Object existingValue = map.get(key);
        if (existingValue == null) {
            map.put(key, DataTools.buildList(value));
        } else if (existingValue instanceof List) {
            ((List)existingValue).add(value);
        } else {
            map.put(key, DataTools.buildList(existingValue, value));
        }
        return map;
    }

    public static LinkedHashMap getSortedMap(Map map) {
        if (map == null) {
            return null;
        }
        Object[] keys = map.keySet().toArray();
        Arrays.sort(keys);
        LinkedHashMap rtn = new LinkedHashMap();
        for (int i = 0; i < keys.length; ++i) {
            rtn.put(keys[i], map.get(keys[i]));
        }
        return rtn;
    }

    public static List getSortedList(List list) {
        if (list == null) {
            return null;
        }
        Object[] arr = DataTools.listToArray(list);
        Arrays.sort(arr);
        return DataTools.arrayToList(arr);
    }

    public static boolean containsByReference(Collection c, Object obj) {
        if (c == null || obj == null) {
            return false;
        }
        for (Object o : c) {
            if (o != obj) continue;
            return true;
        }
        return false;
    }

    public static List addAll(List target, List source) {
        if (source == null) {
            return target;
        }
        if (target == null) {
            return null;
        }
        Iterator elems = source.iterator();
        return DataTools.addAll(target, elems);
    }

    public static List addAll(List target, Iterator source) {
        if (source == null) {
            return target;
        }
        while (source.hasNext()) {
            target.add(source.next());
        }
        return target;
    }

    public static List addAsList(List targetList, Object sourceList) {
        if (sourceList == null) {
            return targetList;
        }
        if (!(sourceList instanceof List)) {
            targetList.add(sourceList);
            return targetList;
        }
        return DataTools.addAll(targetList, (List)sourceList);
    }

    public static Object combineAsLists(Object one, Object two) {
        if (one == null) {
            return two;
        }
        if (two == null) {
            return one;
        }
        ArrayList combinedList = new ArrayList();
        DataTools.addAsList(combinedList, one);
        DataTools.addAsList(combinedList, two);
        return combinedList;
    }

    public static Map putCombinedList(Map map, Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("putCombinedList passed null key");
        }
        Object existingValue = map.get(key);
        Object combinedList = DataTools.combineAsLists(existingValue, value);
        if (combinedList != null) {
            map.put(key, combinedList);
        }
        return map;
    }

    public static <T> List<T> setUnion(List<T> one, List<T> two) {
        if (one == null) {
            return new ArrayList<T>(two);
        }
        ArrayList<T> result = new ArrayList<T>(one);
        if (two == null) {
            return result;
        }
        Iterator<T> elems = two.iterator();
        while (elems.hasNext()) {
            result.add(elems.next());
        }
        return result;
    }

    public static void addDisjunctionToSet(List one, List two) {
        if (one == null || two == null) {
            return;
        }
        for (Object value : two) {
            if (one.contains(value)) continue;
            one.add(value);
        }
    }

    public static <T> T[] arrayUnion(T[] one, T[] two) {
        if (one == null) {
            return (Object[])two.clone();
        }
        if (two == null) {
            return (Object[])one.clone();
        }
        Object[] result = new Object[one.length + two.length];
        int resultIndex = 0;
        int i = 0;
        while (i < one.length) {
            result[resultIndex] = one[i];
            ++i;
            ++resultIndex;
        }
        i = 0;
        while (i < two.length) {
            result[resultIndex] = two[i];
            ++i;
            ++resultIndex;
        }
        return result;
    }

    public static <T> List<T> setIntersection(Collection<T> one, Collection<T> two) {
        ArrayList<T> result = new ArrayList<T>();
        if (one == null || two == null) {
            return result;
        }
        for (T oneElem : one) {
            if (!two.contains(oneElem)) continue;
            result.add(oneElem);
        }
        return result;
    }

    public static Map mapDisjunction(Map one, Map two) {
        HashMap result = new HashMap();
        for (Object key : one.keySet()) {
            if (two.get(key) != null) continue;
            result.put(key, one.get(key));
        }
        for (Object key : two.keySet()) {
            if (one.get(key) != null) continue;
            result.put(key, two.get(key));
        }
        return result;
    }

    public static List setDisjunction(Collection one, Collection two) {
        if (two == null) {
            return new ArrayList(one);
        }
        ArrayList result = new ArrayList();
        if (one == null) {
            return result;
        }
        for (Object oneElem : one) {
            if (two.contains(oneElem)) continue;
            result.add(oneElem);
        }
        return result;
    }

    public static void setIntersectionAndDisjunction(Collection one, Collection two, ICall intersect, ICall disjoint) {
        if (one == null || two == null) {
            return;
        }
        for (Object oneElem : one) {
            if (two.contains(oneElem)) {
                if (intersect == null) continue;
                intersect.call(oneElem);
                continue;
            }
            if (disjoint == null) continue;
            disjoint.call(oneElem);
        }
    }

    public static void setIntersection(Collection one, Collection two, ICall intersect) {
        DataTools.setIntersectionAndDisjunction(one, two, intersect, null);
    }

    public static void setDisjunction(Collection one, Collection two, ICall disjoint) {
        DataTools.setIntersectionAndDisjunction(one, two, null, disjoint);
    }

    public static List enumToList(Iterator i) {
        if (i == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public static List arrayToList(Object[] arr, int from, int length) {
        if (arr == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = from; i < length; ++i) {
            list.add(arr[i]);
        }
        return list;
    }

    public static List arrayToList(Object[] arr) {
        if (arr == null) {
            return null;
        }
        return DataTools.arrayToList(arr, 0, arr.length);
    }

    public static List arrayToList(Object[] arr, int from) {
        if (arr == null) {
            return null;
        }
        return DataTools.arrayToList(arr, from, arr.length - from);
    }

    public static Object[] listToArray(List list) {
        if (list == null) {
            return null;
        }
        Object[] valueArr = new Object[list.size()];
        list.toArray(valueArr);
        return valueArr;
    }

    public static String[] listToStringArray(Collection list) {
        if (list == null) {
            return null;
        }
        String[] valueArr = new String[list.size()];
        list.toArray(valueArr);
        return valueArr;
    }

    public static Properties mapToProperties(Map map) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)map);
        return props;
    }

    public static List keysAsList(Map map) {
        if (map == null) {
            return null;
        }
        return DataTools.enumToList(map.keySet().iterator());
    }

    public static List makeList(Object element) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (element == null) {
            return result;
        }
        result.add(element);
        return result;
    }

    public static List makeListIfSingle(Object obj) {
        if (obj instanceof List) {
            return (List)obj;
        }
        return DataTools.makeList(obj);
    }

    public static Map mapFromLists(List keys, List values) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (keys.size() != values.size()) {
            String message = "Mismatched keys (" + keys.size() + ") and values (" + values.size() + ") lists\nKeys: " + keys.toString() + "\nValues: " + values.toString();
            throw new IllegalArgumentException(message);
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            Object value = values.get(i);
            if (value == null) continue;
            map.put(keys.get(i), value);
        }
        return map;
    }

    public static String join(Object strings, String delimiter) {
        if (strings instanceof String) {
            return (String)strings;
        }
        return DataTools.join((Collection)strings, delimiter);
    }

    public static String join(String[] strings, String delimiter) {
        return DataTools.join(DataTools.arrayToList(strings), delimiter);
    }

    public static String join(Collection strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        String output = "";
        Iterator e = strings.iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (next == null) continue;
            output = output + next;
            if (!e.hasNext()) continue;
            output = output + delimiter;
        }
        return output;
    }

    public static List<String> splitByLength(String toSplit, int length) {
        if (toSplit == null) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        int strLength = toSplit.length();
        for (int start = 0; start < strLength; start += length) {
            output.add(toSplit.substring(start, start + length > strLength ? strLength : start + length));
        }
        return output;
    }

    public static List<String> simpleSplit(String toSplit, String delimiter) {
        if (toSplit == null) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(toSplit, delimiter, true);
        boolean lastTokenWasDelimiter = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (!token.equals(delimiter)) {
                output.add(token);
                lastTokenWasDelimiter = false;
                continue;
            }
            if (lastTokenWasDelimiter) {
                output.add("");
            }
            lastTokenWasDelimiter = true;
        }
        return output;
    }

    public static String[] split(String str, String separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        while (str.length() != 0) {
            int index = str.indexOf(separator);
            if (index == -1) {
                tmp.add(str);
                break;
            }
            if (index == 0) {
                tmp.add("");
            } else {
                tmp.add(str.substring(0, index));
                str = str.substring(index);
            }
            if ((str = str.substring(separator.length())).length() != 0) continue;
            tmp.add("");
            break;
        }
        String[] x = new String[tmp.size()];
        tmp.toArray(x);
        return x;
    }

    public static List<String> perl5Split(String input, String regex) {
        ArrayList<String> results = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        int end = 0;
        while (m.find()) {
            int start = m.start();
            if (end < start) {
                results.add(input.substring(end, start));
            }
            end = m.end();
            results.add(input.substring(start, end));
        }
        if (end < input.length()) {
            results.add(input.substring(end));
        }
        return results;
    }

    public static boolean contains(String str, String substr) {
        return str.indexOf(substr) != -1;
    }

    public static JXPathContext jxPathContext(Object obj) {
        JXPathContext context = JXPathContext.newContext((Object)obj);
        context.setLenient(true);
        return context;
    }

    public static Object xpathGet(Object obj, String xpath) {
        if (obj == null) {
            return null;
        }
        return DataTools.jxPathContext(obj).getValue(xpath);
    }

    public static List xpathGetList(Object obj, String xpath) {
        if (obj == null) {
            return null;
        }
        Iterator iterator = DataTools.jxPathContext(obj).iterate(xpath);
        if (iterator == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static void xpathSet(Object obj, String xpath, Object value) {
        if (obj == null) {
            return;
        }
        DataTools.jxPathContext(obj).setValue(xpath, value);
    }

    public static Object nestedGet(Object struct, String fetch) {
        Object currentStruct = struct;
        List<String> components = DataTools.simpleSplit(fetch, ".");
        String pathSoFar = "[start]";
        for (String nextKey : components) {
            if (currentStruct instanceof Map) {
                currentStruct = ((Map)currentStruct).get(nextKey);
            } else if (currentStruct instanceof List) {
                int index = 0;
                try {
                    index = Integer.parseInt(nextKey);
                    currentStruct = ((List)currentStruct).get(index);
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("NestedGet: Bad index " + nextKey + " for List at path '" + pathSoFar + "'");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ArrayIndexOutOfBoundsException("NestedGet: Bad index " + index + " for List at path '" + pathSoFar + "'");
                }
            } else {
                throw new ClassCastException("NestedGet: at '" + pathSoFar + "' structure is neither List nor Map: " + (currentStruct != null ? currentStruct.getClass().getName() : "null"));
            }
            pathSoFar = pathSoFar + "." + nextKey;
        }
        return currentStruct;
    }

    public static Map getSubtreePrefixed(String prefix, Map data) {
        if (data == null) {
            return null;
        }
        if (prefix == null || prefix.length() == 0) {
            return data;
        }
        HashMap result = new HashMap();
        for (String key : data.keySet()) {
            if (!key.startsWith(prefix + ".")) continue;
            result.put(key.substring(prefix.length() + 1), data.get(key));
        }
        return result;
    }

    public static void clearSubtreePrefixed(String prefix, DataTypeMap data) {
        if (prefix == null || data == null) {
            return;
        }
        if (prefix.length() == 0) {
            return;
        }
        Iterator ii = data.keySet().iterator();
        while (ii.hasNext()) {
            String key = (String)ii.next();
            if (!key.startsWith(prefix + ".")) continue;
            ii.remove();
        }
    }

    public static Map getPrefixed(String prefix, Map data) {
        if (prefix == null || data == null) {
            return null;
        }
        if (prefix.length() == 0) {
            return data;
        }
        HashMap result = new HashMap();
        for (String key : data.keySet()) {
            if (!key.startsWith(prefix + ".")) continue;
            result.put(key, data.get(key));
        }
        return result;
    }

    public static <T> List<T> buildList(T ... args) {
        return new ArrayList<T>(Arrays.asList(args));
    }

    public static DataTypeMap buildMap(Object ... args) {
        DataTypeMap<Object, Object> result = new DataTypeMap<Object, Object>();
        int oddEvenCounter = 1;
        Object key = null;
        for (Object o : args) {
            if (oddEvenCounter == 2) {
                result.put(key, o);
                oddEvenCounter = 1;
                key = null;
                continue;
            }
            key = o;
            ++oddEvenCounter;
        }
        return result;
    }

    public static Object getSingle(Object toFetchFrom) {
        if (toFetchFrom instanceof List) {
            if (((List)toFetchFrom).size() == 1) {
                return ((List)toFetchFrom).get(0);
            }
        } else if (toFetchFrom instanceof Map && ((Map)toFetchFrom).size() == 1) {
            Iterator e = ((Map)toFetchFrom).keySet().iterator();
            return e.next();
        }
        return null;
    }

    public static int checkSize(Object obj) {
        if (obj instanceof List) {
            return ((List)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        return 0;
    }

    public static String fastDateFormat(Date date) {
        return DataTools.fastDateFormat(date, false);
    }

    public static String fastDateFormat(Date date, Calendar cacheCalendar) {
        return DataTools.fastDateFormat(date, false, cacheCalendar);
    }

    public static String fastDateFormat(Date date, boolean omitTime) {
        return DataTools.fastDateFormat(date, false, omitTime);
    }

    public static String fastDateFormat(Date date, boolean omitTime, Calendar cacheCalendar) {
        return DataTools.fastDateFormat(date, false, omitTime, cacheCalendar);
    }

    public static String fastDateFormat(Date date, boolean formatInUTC, boolean omitTime) {
        return DataTools.fastDateFormat(date, formatInUTC, omitTime, Calendar.getInstance());
    }

    public static String fastDateFormat(Date date, boolean formatInUTC, boolean omitTime, Calendar cacheCalendar) {
        return DataTools.fastDateFormat(date, formatInUTC, omitTime, Calendar.getInstance(), false);
    }

    public static String fastDateFormat(Date date, boolean formatInUTC, boolean omitTime, Calendar cacheCalendar, boolean omitMillis) {
        cacheCalendar.setTimeZone(TimeZone.getDefault());
        long timeToSet = date.getTime();
        if (formatInUTC) {
            if (supportsNativeUTC) {
                cacheCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                TimeZone GMT = TimeZone.getTimeZone("GMT");
                cacheCalendar.setTimeZone(GMT);
                timeToSet -= (long)GMT.getOffset(timeToSet);
            }
        }
        cacheCalendar.setTimeInMillis(timeToSet);
        StringBuilder out = new StringBuilder(20);
        out.append(cacheCalendar.get(1));
        out.append("-");
        out.append(cacheCalendar.get(2) + 1);
        out.append("-");
        out.append(cacheCalendar.get(5));
        if (!omitTime) {
            out.append(" ");
            out.append(cacheCalendar.get(11));
            out.append(":");
            out.append(cacheCalendar.get(12));
            out.append(":");
            out.append(cacheCalendar.get(13));
            if (!omitMillis) {
                out.append(".");
                out.append(cacheCalendar.get(14));
            }
        }
        return out.toString();
    }

    public static int parseTimeZoneOffset(String timeZone) {
        String tz = timeZone;
        if (tz == null || "".equals(tz.trim())) {
            return 0;
        }
        boolean forward = true;
        if (tz.startsWith("-")) {
            forward = false;
            tz = tz.substring(1);
        } else if (tz.startsWith("+")) {
            tz = tz.substring(1);
        }
        String[] parts = tz.split(":");
        try {
            int hours = Integer.parseInt(parts[0]);
            int minutes = Integer.parseInt(parts[1]) + hours * 60;
            int offsetMillis = minutes * 60 * 1000;
            return offsetMillis * (forward ? 1 : -1);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static Boolean parseBoolean(String s) {
        if (s == null || s.isEmpty() || "null".equalsIgnoreCase(s)) {
            return null;
        }
        if ("false".equalsIgnoreCase(s) || "no".equalsIgnoreCase(s)) {
            return false;
        }
        if (s.length() != 1) {
            return true;
        }
        char letter = s.charAt(0);
        return letter != 'F' && letter != 'N' && letter != '0';
    }

    public static String getStackTrace(Throwable t, int lineCount) {
        String stackTrace = DataTools.getStackTrace(t);
        int index = 0;
        while (lineCount >= 0) {
            index = stackTrace.indexOf("\n", index) + 1;
            --lineCount;
        }
        return stackTrace.substring(0, index - 1);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        try {
            sw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sw.toString();
    }

    public static Map remapRow(Map row, Map remap, boolean keepNonRemapped) {
        if (remap == null) {
            return row;
        }
        HashMap newRow = new HashMap();
        for (Object oldKey : row.keySet()) {
            Object newKey = remap.get(oldKey);
            Object data = row.get(oldKey);
            if (newKey == null) {
                if (!keepNonRemapped) continue;
                newRow.put(oldKey, data);
                continue;
            }
            newRow.put(newKey, data);
        }
        return newRow;
    }

    public static Map remapRow(Map row, Map remap) {
        return DataTools.remapRow(row, remap, true);
    }

    public static List remapRows(List rows, Map remap, boolean keepNonRemapped) {
        if (remap == null) {
            return rows;
        }
        return DataTools.remapRows(rows.iterator(), remap, keepNonRemapped);
    }

    public static List remapRows(Iterator rows, Map remap, boolean keepNonRemapped) {
        ArrayList<Map> newRows = new ArrayList<Map>();
        while (rows.hasNext()) {
            Map oldRow = (Map)rows.next();
            Map newRow = DataTools.remapRow(oldRow, remap, keepNonRemapped);
            if (newRow.size() <= 0) continue;
            newRows.add(newRow);
        }
        return newRows;
    }

    public static List remapRows(List rows, Map remap) {
        return DataTools.remapRows(rows, remap, true);
    }

    public static Object remapObject(Object rows, Map remap) throws Exception {
        return DataTools.remapObject(rows, remap, true);
    }

    public static Object remapObject(Object rows, Map remap, boolean keepNonRemapped) throws Exception {
        if (rows instanceof Map) {
            return DataTools.remapRow((Map)rows, remap, keepNonRemapped);
        }
        if (rows instanceof List) {
            return DataTools.remapRows((List)rows, remap, keepNonRemapped);
        }
        if (rows == null) {
            return null;
        }
        throw new Exception("Cannot remap column names for type: " + rows.getClass().getName());
    }

    public static List remapKeys(List keys, Map remap, boolean keepNonRemapped) {
        ArrayList<Object> newKeys = new ArrayList<Object>();
        if (keys != null) {
            for (Object oldKey : keys) {
                Object newKey = remap.get(oldKey);
                if (newKey != null) {
                    newKeys.add(newKey);
                    continue;
                }
                if (!keepNonRemapped) continue;
                newKeys.add(oldKey);
            }
        }
        return newKeys;
    }

    public static List getProperty(List rows, Object column) {
        ArrayList values = new ArrayList();
        if (rows != null) {
            for (Map row : rows) {
                if (!row.containsKey(column)) continue;
                values.add(row.get(column));
            }
        }
        return values;
    }

    public static List getColumnValues(List rows, Object column) {
        return DataTools.getProperty(rows, column);
    }

    public static List findAll(List rows, Object propertyName, Object value) {
        ArrayList<Map> values = new ArrayList<Map>();
        if (value != null) {
            for (Map row : rows) {
                if (!value.equals(row.get(propertyName))) continue;
                values.add(row);
            }
        } else {
            for (Map row : rows) {
                if (row.get(propertyName) != null) continue;
                values.add(row);
            }
        }
        return values;
    }

    public static List findAll(List rows, Map properties) {
        ArrayList<Map> values = new ArrayList<Map>();
        for (Map row : rows) {
            boolean found = true;
            for (Object propertyName : properties.keySet()) {
                if (properties.get(propertyName).equals(row.get(propertyName))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            values.add(row);
        }
        return values;
    }

    public static Map makeIndex(Collection objects, String propertyName) {
        LinkedHashMap index = new LinkedHashMap();
        for (Object object : objects) {
            Map propertyMap;
            Object propertyValue;
            if (!(object instanceof Map) || (propertyValue = (propertyMap = (Map)object).get(propertyName)) == null) continue;
            index.put(propertyValue, propertyMap);
        }
        return index;
    }

    public static Map indexOnProperty(Collection objects, String propertyName) {
        return DataTools.makeIndex(objects, propertyName);
    }

    public static void dumpConfig(Writer out) throws Exception {
        JSTranslater jsTrans = new JSTranslater();
        jsTrans.enablePrettyPrinting();
        jsTrans.collapseSmallContainers(false);
        out.write("Loaded Configuration files (in load order, non-interpolated):\n");
        out.write("-------------------------------------------------------------\n");
        for (Map configInfo : Config.loadedConfigFiles) {
            DataTools.prettyPrint((Object)configInfo, out);
            out.write("\n");
        }
        out.write("Merged Configuration (interpolated):\n");
        out.write("------------------------------------\n");
        TreeMap m = new TreeMap();
        Config config = Config.getGlobal();
        for (Object key : config.keySet()) {
            Object value = config.get(key);
            m.put(key, value);
        }
        DataTools.prettyPrint(m, out);
    }

    public static String fileContentsAsString(String fileName) throws IOException {
        File f = new File(fileName);
        FileReader r = new FileReader(fileName);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(r, sw);
        r.close();
        return sw.toString();
    }

    public static String fileContentsAsString(ISCFile file) throws IOException {
        return DataTools.fileContentsAsString(file, null);
    }

    public static String fileContentsAsString(ISCFile file, Charset charset) throws IOException {
        Reader r = file.getReader(charset);
        StringWriter sw = new StringWriter();
        IOUtil.copyCharacterStreams(r, sw);
        r.close();
        return sw.toString();
    }

    public static String makePathAppendable(String path) {
        if (path.charAt(1) == ':') {
            path = "/" + path.charAt(0) + path.substring(2);
        }
        return path;
    }

    public static boolean pathIsRelative(String path) {
        return path != null && !path.startsWith("/") && !path.startsWith("\\") && !new File(path).isAbsolute() && !DataTools.isContainerIOPath(path) && path.length() > 1 && (path.charAt(1) != ':' || path.charAt(2) != '/' && path.charAt(2) != '\\');
    }

    public static String makePathAbsolute(String path) {
        if (path.contains("://")) {
            return path;
        }
        if (!DataTools.pathIsRelative(path)) {
            return path;
        }
        Config config = Config.getGlobal();
        return config.getPath("webRoot") + '/' + path;
    }

    public static boolean isURI(String uri) {
        return uri.startsWith("file:") || uri.startsWith("jar:") || uri.startsWith("http:") || uri.startsWith("https:");
    }

    public static boolean isContainerIOPath(String path) {
        return ISCFile.isContainerIOPath(path);
    }

    public static InputStream inputStreamForFilename(String filename) throws IOException {
        return ISCFile.newInstance(filename).getInputStream();
    }

    public static List filesWithExtension(File dir, String extension) {
        if (!dir.exists() && dir.isDirectory()) {
            return null;
        }
        String[] files = dir.list();
        ArrayList<String> matchingFiles = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            if (!filename.endsWith(extension)) continue;
            matchingFiles.add(filename);
        }
        return matchingFiles;
    }

    public static boolean isIdentifier(String str) {
        if (str == null || str.length() < 2) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            if (Character.isJavaIdentifierPart(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Object[] toObjectArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        Class<?> valueClass = value.getClass();
        Object[] result = null;
        for (Class<?> primitiveArrayClass : ARRAY_PRIMITIVE_TYPES) {
            if (!valueClass.isAssignableFrom(primitiveArrayClass)) continue;
            int arrlength = Array.getLength(value);
            result = new Object[arrlength];
            for (int i = 0; i < arrlength; ++i) {
                result[i] = Array.get(value, i);
            }
            break;
        }
        if (result == null) {
            result = new Object[]{value};
        }
        return result;
    }

    public static List toLowerCaseList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String string : list) {
            results.add(string.toLowerCase());
        }
        return results;
    }

    public static String prettyPrint(Object obj) {
        return DataTools.prettyPrint(obj, (DataTypeMap)null);
    }

    public static String prettyPrint(Object obj, DataTypeMap beanIntrospectorOptions) {
        try {
            JSTranslater jsTrans = JSTranslater.get();
            if (beanIntrospectorOptions != null) {
                jsTrans.withBeanIntrospectorOptions(beanIntrospectorOptions);
            }
            jsTrans.enablePrettyPrinting();
            return jsTrans.toJS(obj);
        }
        catch (Exception e) {
            return "Exception during DataTools.prettyPrint:\n" + DataTools.getStackTrace(e);
        }
    }

    public static void prettyPrint(Object obj, Writer out) throws Exception {
        JSTranslater jsTrans = JSTranslater.instance();
        jsTrans.enablePrettyPrinting();
        jsTrans.toJS(obj, out);
    }

    public static boolean getBoolean(Map map, Object key) {
        Object value = map.get(key);
        return DataTools.asBoolean(value);
    }

    public static boolean getBoolean(Map map, Object key, boolean dft) {
        Object value = map.get(key);
        if (value == null) {
            return dft;
        }
        return DataTools.asBoolean(value);
    }

    public static Boolean getBooleanObject(Map map, Object key) {
        return DataTools.getBooleanObject(map, key, Boolean.FALSE);
    }

    public static Boolean getBooleanObject(Map map, Object key, Boolean nullValue) {
        Object value = map.get(key);
        if (value == null) {
            return nullValue;
        }
        return DataTools.asBoolean(value);
    }

    public static boolean asBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        String boolString = (String)value;
        return boolString != null && !boolString.equals("") && !boolString.equalsIgnoreCase("false");
    }

    public static boolean asBoolean(Object value, boolean dft) {
        if (value == null) {
            return dft;
        }
        return DataTools.asBoolean(value);
    }

    public static Boolean asBooleanObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() > 0;
        }
        String boolString = (String)value;
        if ("".equals(boolString)) {
            return null;
        }
        return !boolString.equalsIgnoreCase("false");
    }

    public static Boolean asBooleanObject(Object value, Boolean dft) {
        if (value == null) {
            return dft;
        }
        return DataTools.asBooleanObject(value);
    }

    public static int getInt(Map map, Object key) {
        Object value = map.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static long getLong(Map map, Object key) {
        Object value = map.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.valueOf(value.toString());
    }

    public static double asDouble(Object obj) {
        if (obj == null) {
            return Double.NaN;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            return Double.parseDouble(obj.toString());
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    public static void addToIntInMap(Map map, Object key, int addition) {
        map.put(key, DataTools.getIntInMap(map, key) + addition);
    }

    public static void incrementIntInMap(Map map, Object key) {
        DataTools.addToIntInMap(map, key, 1);
    }

    public static int getIntInMap(Map map, Object key) {
        if (map == null) {
            throw new IllegalArgumentException("Map cannot be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        Object value = map.get(key);
        if (value == null) {
            return 0;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Value in map is not a java.lang.Number");
        }
        return ((Number)value).intValue();
    }

    public static String getPlaintextMD5Hash(String source) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(source.getBytes());
        byte[] bytes = md.digest();
        String key = "";
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                key = key + "0";
            }
            key = key + hex;
        }
        return key;
    }

    public static String getterName(Method method) {
        if (method.getParameterTypes().length > 0) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        } else {
            return null;
        }
        if (methodName.length() > 0) {
            methodName = methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
            return methodName;
        }
        return null;
    }

    public static Field[] getClassFields(Class c) {
        if (c == null) {
            return new Field[0];
        }
        Field[] declaredFields = c.getDeclaredFields();
        Field[] superclassFields = DataTools.getClassFields(c.getSuperclass());
        Field[] fields = new Field[declaredFields.length + superclassFields.length];
        System.arraycopy(declaredFields, 0, fields, 0, declaredFields.length);
        System.arraycopy(superclassFields, 0, fields, declaredFields.length, superclassFields.length);
        return fields;
    }

    public static Method[] getClassMethods(Class c) {
        if (c == null) {
            return new Method[0];
        }
        Method[] declaredMethods = c.getDeclaredMethods();
        Method[] superclassMethods = DataTools.getClassMethods(c.getSuperclass());
        Method[] methods = new Method[declaredMethods.length + superclassMethods.length];
        System.arraycopy(declaredMethods, 0, methods, 0, declaredMethods.length);
        System.arraycopy(superclassMethods, 0, methods, declaredMethods.length, superclassMethods.length);
        return methods;
    }

    /*
     * WARNING - void declaration
     */
    public static Class getPropertyType(Class c, String propertyName) throws IntrospectionException {
        AccessibleObject method;
        int n;
        AccessibleObject[] methods;
        Field[] fields;
        if (c == null) {
            throw new NullPointerException("Class parameter can not be null");
        }
        if (propertyName == null) {
            throw new NullPointerException("Property name parameter can not be null");
        }
        if ("".equals(propertyName.trim())) {
            throw new IntrospectionException("Property name parameter can not be empty");
        }
        String[] path = propertyName.split("\\.");
        Class<?> propertyType = null;
        for (Field field : fields = c.getDeclaredFields()) {
            if (!path[0].equals(field.getName())) continue;
            propertyType = field.getType();
            break;
        }
        if (propertyType == null) {
            void var8_13;
            methods = c.getMethods();
            Method[] methodArray = methods;
            n = methodArray.length;
            boolean bl = false;
            while (var8_13 < n) {
                method = methodArray[var8_13];
                if (path[0].equals(DataTools.getterName((Method)method))) {
                    propertyType = ((Method)method).getReturnType();
                    break;
                }
                ++var8_13;
            }
        }
        if (propertyType == null) {
            fields = DataTools.getClassFields(c);
            methods = fields;
            int n2 = methods.length;
            for (n = 0; n < n2; ++n) {
                AccessibleObject accessibleObject = methods[n];
                if (!path[0].equals(((Field)accessibleObject).getName())) continue;
                propertyType = ((Field)accessibleObject).getType();
                break;
            }
        }
        if (propertyType == null) {
            void var8_17;
            AccessibleObject[] accessibleObjectArray = methods = DataTools.getClassMethods(c);
            n = accessibleObjectArray.length;
            boolean bl = false;
            while (var8_17 < n) {
                method = accessibleObjectArray[var8_17];
                if (path[0].equals(DataTools.getterName((Method)method))) {
                    propertyType = ((Method)method).getReturnType();
                    break;
                }
                ++var8_17;
            }
        }
        if (propertyType == null) {
            throw new IntrospectionException("Property \"" + path[0] + "\" is not found in class \"" + c.getName() + "\"");
        }
        if (path.length > 1) {
            String subName = "";
            for (int i = 1; i < path.length; ++i) {
                if (!"".equals(subName)) {
                    subName = subName + ".";
                }
                subName = subName + path[i];
            }
            if (!propertyType.isPrimitive()) {
                return DataTools.getPropertyType(propertyType, subName);
            }
            throw new IntrospectionException("Found primitive property \"" + path[0] + "\" in class \"" + c.getName() + "\". It can not have subproperty \"" + subName + "\"");
        }
        return propertyType;
    }

    public static Class getCachedClass(String className) {
        Class clazz = null;
        if (!cachedClasses.containsKey(className)) {
            try {
                clazz = Reflection.classForName(className);
            }
            catch (ClassNotFoundException ex) {
                clazz = null;
            }
            cachedClasses.put(className, clazz);
        }
        clazz = cachedClasses.get(className);
        return clazz;
    }

    public static Class getRealClass(Object bean) {
        if (bean == null) {
            return null;
        }
        Class hibernateProxyClass = DataTools.getCachedClass("org.hibernate.proxy.HibernateProxy");
        if (hibernateProxyClass != null && hibernateProxyClass.isAssignableFrom(bean.getClass())) {
            try {
                Method lazyInitializerMethod = hibernateProxyClass.getMethod("getHibernateLazyInitializer", new Class[0]);
                Object lazyInitializer = lazyInitializerMethod.invoke(bean, new Object[0]);
                Method persistentClassMethod = lazyInitializer.getClass().getMethod("getPersistentClass", new Class[0]);
                Class realClass = (Class)persistentClassMethod.invoke(lazyInitializer, new Object[0]);
                return realClass;
            }
            catch (Exception ex) {
                log.warn((Object)"Failed to extract implementation object from proxy. Returning proxy class.", ex);
            }
        }
        return bean.getClass();
    }

    public static Map getProperties(Object bean) throws Exception {
        return DataTools.getProperties(bean, null, null);
    }

    public static Map getProperties(Object bean, DataTypeMap opts) throws Exception {
        return DataTools.getProperties(bean, null, opts);
    }

    public static Map getProperties(Object bean, Collection propsToKeep) throws Exception {
        return DataTools.getProperties(bean, propsToKeep, null);
    }

    public static Map getProperties(Object bean, Collection propsToKeep, DataTypeMap opts) throws Exception {
        if (bean == null) {
            return null;
        }
        if (opts == null) {
            opts = new DataTypeMap();
        }
        LinkedHashMap<String, Object> propertyMap = new LinkedHashMap<String, Object>();
        long nanos = System.nanoTime();
        Map<String, PropertyDescriptor> propertyDescriptors = DataTools.getPropertyDescriptors(bean);
        if (propertyDescriptors == null) {
            getPropsLapse += System.nanoTime() - nanos;
            return propertyMap;
        }
        for (String propertyName : propertyDescriptors.keySet()) {
            Object value;
            PropertyDescriptor propertyDescriptor = propertyDescriptors.get(propertyName);
            String propertyNameInMap = propertyName;
            if (propsToKeep != null && !propsToKeep.contains(propertyName)) {
                boolean keepProp = false;
                for (String prop : propsToKeep) {
                    if (!prop.toLowerCase().equals(propertyName.toLowerCase())) continue;
                    keepProp = true;
                    propertyNameInMap = prop;
                    break;
                }
                if (!keepProp) continue;
            }
            if (propsToKeep == null && "class".equals(propertyName)) continue;
            long readNanos = System.nanoTime();
            Method getter = propertyDescriptor.getReadMethod();
            readMethodLapse += System.nanoTime() - readNanos;
            if (getter == null || !Modifier.isPublic(getter.getModifiers())) continue;
            try {
                long invokeNanos = System.nanoTime();
                value = getter.invoke(bean, EMPTY_ARRAY);
                reflectionInvokeLapse += System.nanoTime() - invokeNanos;
            }
            catch (Throwable t) {
                t = Reflection.getRealTargetException(t);
                String error = DataTools.getStackTrace(t);
                log.debug("Bean inspection: invocation of " + bean.getClass().getName() + "." + getter.getName() + "() while trying to obtain property '" + propertyName + "' threw an exception: " + error + "\nSetting value to the error string and continuing");
                value = t.toString();
            }
            propertyMap.put(propertyNameInMap, value);
        }
        getPropsLapse += System.nanoTime() - nanos;
        return propertyMap;
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Object bean) throws Exception {
        if (bean == null) {
            return null;
        }
        return DataTools.getPropertyDescriptors(DataTools.getRealClass(bean));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class beanClass) throws Exception {
        return DataTools.getPropertyDescriptors(beanClass, null);
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class beanClass, DataTypeMap opts) throws Exception {
        if (beanClass == null) {
            return null;
        }
        if (opts == null) {
            opts = new DataTypeMap();
        }
        if (cachePropertyDescriptors == null) {
            cachePropertyDescriptors = Config.getGlobal().getBoolean((Object)"cache.bean.property.descriptors", false);
        }
        if (cachePropertyDescriptors.booleanValue() && cachedPropertyDescriptors.containsKey(beanClass)) {
            Map<String, PropertyDescriptor> work = cachedPropertyDescriptors.get(beanClass);
            return work;
        }
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        if (propertyDescriptors == null) {
            return properties;
        }
        Class interceptFieldEnabledClass = DataTools.getCachedClass("net.sf.cglib.transform.impl.InterceptFieldEnabled");
        Class fieldHandledClass = DataTools.getCachedClass("org.hibernate.bytecode.javassist.FieldHandled");
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            String propertyName;
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            if (propertyDescriptor == null || "interceptFieldCallback".equals(propertyName = propertyDescriptor.getName()) && interceptFieldEnabledClass != null && interceptFieldEnabledClass.isAssignableFrom(beanClass) || "fieldHandler".equals(propertyName) && fieldHandledClass != null && fieldHandledClass.isAssignableFrom(beanClass)) continue;
            properties.put(propertyName, propertyDescriptor);
        }
        if (cachedPropertyDescriptors != null) {
            cachedPropertyDescriptors.put(beanClass, properties);
        }
        return properties;
    }

    public static Object setProperties(Map propertyMap, Object bean) throws Exception {
        return DataTools.setProperties(propertyMap, bean, null, null, true);
    }

    public static Object setProperties(Map propertyMap, Object bean, DataTypeMap opts) throws Exception {
        return DataTools.setProperties(propertyMap, bean, null, null, opts);
    }

    public static Object setProperties(Map propertyMap, Object bean, DataSource dataSource) throws Exception {
        return DataTools.setProperties(propertyMap, bean, dataSource, null, true);
    }

    public static Object setProperties(Map propertyMap, Object bean, DataSource dataSource, DataTypeMap opts) throws Exception {
        return DataTools.setProperties(propertyMap, bean, dataSource, null, opts);
    }

    public static Object setProperties(Map propertyMap, Object bean, DataSource dataSource, DSRequest dsRequest) throws Exception {
        return DataTools.setProperties(propertyMap, bean, dataSource, dsRequest, true);
    }

    public static Object setProperties(Map propertyMap, Object bean, DataSource ds, DSRequest dsRequest, boolean clearContext) throws Exception {
        return DataTools.setProperties(propertyMap, bean, ds, dsRequest, DataTools.buildMap("clearContext", clearContext));
    }

    public static Object setProperties(Map propertyMap, Object bean, DataSource ds, DSRequest dsRequest, DataTypeMap opts) throws Exception {
        HashMap<String, String> badProperties;
        Class<?> beanClass;
        block29: {
            if (opts == null) {
                opts = new DataTypeMap();
            }
            if (bean == null) {
                log.error((Object)"Null bean passed to setProperties, returning null", new Exception());
                return null;
            }
            beanClass = bean.getClass();
            if (propertyMap == null) {
                log.error((Object)("Null propertyMap passed to setProperties for bean of type: " + beanClass.getName() + " returning bean unmodified."), new Exception());
                return bean;
            }
            if (ds != null && opts.getBoolean((Object)"clearContext", false)) {
                ds._clearConvertedProperties();
            }
            Map<String, PropertyDescriptor> propertyDescriptors = DataTools.getPropertyDescriptors(bean);
            badProperties = new HashMap<String, String>();
            for (String propertyName : propertyMap.keySet()) {
                Method writeMethod;
                Object value = propertyMap.get(propertyName);
                PropertyDescriptor property = propertyDescriptors.get(propertyName);
                if (property == null) {
                    for (String propName : propertyDescriptors.keySet()) {
                        if (!propName.toLowerCase().equals(propertyName.toLowerCase())) continue;
                        boolean collision = false;
                        for (String mapPropName : propertyMap.keySet()) {
                            if (mapPropName.equals(propertyName) || !mapPropName.toLowerCase().equals(propertyName.toLowerCase())) continue;
                            collision = true;
                            break;
                        }
                        if (collision) continue;
                        property = propertyDescriptors.get(propName);
                    }
                }
                Method method = writeMethod = property == null ? null : property.getWriteMethod();
                if (property == null && Map.class.isAssignableFrom(beanClass)) {
                    ((Map)bean).put(propertyName, value);
                    continue;
                }
                Field directAssignField = null;
                Class<?> paramType = null;
                if (property == null || writeMethod == null) {
                    if (opts.getBoolean((Object)"invokeNonConformingSetters", false)) {
                        Class argClass = value != null ? value.getClass() : String.class;
                        Method method2 = null;
                        try {
                            method2 = Reflection.findMethod(beanClass, "set" + DataTools.ucFirstLetter(propertyName), argClass);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        Reflection._invokeMethod(method2, bean, value);
                        continue;
                    }
                    if (!opts.getBoolean((Object)"directAssignToFields", false)) {
                        badProperties.put(propertyName, "No such property");
                        continue;
                    }
                    try {
                        directAssignField = beanClass.getField(propertyName);
                    }
                    catch (Exception e) {
                        badProperties.put(propertyName, "No accessible field");
                        continue;
                    }
                    paramType = directAssignField.getType();
                } else {
                    if (writeMethod == null || !Modifier.isPublic(writeMethod.getModifiers())) {
                        badProperties.put(propertyName, "No accessible setter method");
                        continue;
                    }
                    paramType = writeMethod.getParameterTypes()[0];
                }
                try {
                    value = DataTools.coerceProperty(propertyName, value, beanClass, propertyDescriptors, ds, dsRequest, propertyMap, opts);
                }
                catch (Exception e) {
                    badProperties.put(propertyName, "Exception coercing value for property: " + propertyName + ":" + e);
                }
                if (writeMethod != null) {
                    writeMethod.invoke(bean, value);
                    continue;
                }
                try {
                    directAssignField.set(bean, value);
                }
                catch (Exception e) {
                    badProperties.put(propertyName, "Exception in direct field assign for field: " + directAssignField.getName() + ":" + e);
                }
            }
            if (badProperties != null && (Config.getGlobal().getBoolean((Object)"supportDynamicBeans", false) || opts.getBoolean((Object)"supportDynamicBeans", false))) {
                try {
                    Method setter = Reflection.findMethod(bean, "set");
                    if (setter != null) {
                        Iterator i = badProperties.keySet().iterator();
                        while (i.hasNext()) {
                            String propertyName = (String)i.next();
                            Object propertyValue = propertyMap.get(propertyName);
                            propertyValue = DataTools.coerceProperty(propertyName, propertyValue, beanClass, propertyDescriptors, ds, dsRequest, opts);
                            Object[] params = new Object[]{propertyName, propertyValue};
                            setter.invoke(bean, params);
                            i.remove();
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof NoSuchMethodException) break block29;
                    log.warn((Object)("Error trying to set dynamic bean properties.  Actual error: " + e.toString()), e);
                }
            }
        }
        if (badProperties.size() != 0) {
            log.info("While applying to " + beanClass.getName() + ", couldn't setProperties:\n" + DataTools.prettyPrint(badProperties));
        }
        return bean;
    }

    public static Object coerceProperty(String propertyName, Object value, Class beanClass) throws Exception {
        return DataTools.coerceProperty(propertyName, value, beanClass, DataTools.getPropertyDescriptors(beanClass), null, null);
    }

    public static Object coerceProperty(String propertyName, Object value, Class beanClass, DataSource ds, DSRequest dsRequest) throws Exception {
        return DataTools.coerceProperty(propertyName, value, beanClass, DataTools.getPropertyDescriptors(beanClass), ds, dsRequest);
    }

    public static Object coerceProperty(String propertyName, Object value, Class beanClass, Map propertyDescriptors, DataSource ds, DSRequest dsRequest) throws Exception {
        return DataTools.coerceProperty(propertyName, value, beanClass, DataTools.getPropertyDescriptors(beanClass), ds, dsRequest, null);
    }

    public static Object coerceProperty(String propertyName, Object value, Class beanClass, Map propertyDescriptors, DataSource ds, DSRequest dsRequest, DataTypeMap opts) throws Exception {
        return DataTools.coerceProperty(propertyName, value, beanClass, DataTools.getPropertyDescriptors(beanClass), ds, dsRequest, null, null);
    }

    public static Object coerceProperty(String propertyName, Object value, Class beanClass, Map propertyDescriptors, DataSource ds, DSRequest dsRequest, Map propertyMap, DataTypeMap opts) throws Exception {
        DSField field;
        DSField field2;
        if (opts == null) {
            opts = new DataTypeMap();
        }
        PropertyDescriptor pd = (PropertyDescriptor)propertyDescriptors.get(propertyName);
        Field directAssignField = null;
        Method setter = null;
        Class paramType = null;
        if (pd != null) {
            setter = pd.getWriteMethod();
        }
        if (setter != null) {
            paramType = setter.getParameterTypes()[0];
        }
        if (paramType == null && opts.getBoolean((Object)"directAssignToFields", false)) {
            directAssignField = beanClass.getField(propertyName);
            paramType = directAssignField.getType();
        }
        if (paramType == null && ds != null && (field2 = ds.getField(propertyName)) != null) {
            if (field2.getBoolean("multiple")) {
                paramType = Reflection.classForName("java.util.List");
            } else {
                paramType = ds._getPropertyJavaClass(propertyName, field2, value);
                if (paramType == null) {
                    paramType = Reflection.classForName("java.lang.Object");
                }
            }
        }
        if (paramType == null) {
            paramType = Object.class;
        }
        if (Collection.class.isAssignableFrom(paramType) || Map.class.isAssignableFrom(paramType)) {
            VersionSafeChecker.GenericParameterNode genericParamInfo = null;
            if (setter != null) {
                List genericParamTypes = VersionSafeChecker.getGenericParameterTypes(setter);
                genericParamInfo = (VersionSafeChecker.GenericParameterNode)genericParamTypes.get(0);
            } else {
                genericParamInfo = VersionSafeChecker.getGenericFieldType(directAssignField);
            }
            if (genericParamInfo != null && genericParamInfo.getClassByIndex(0) == paramType) {
                genericParamInfo = genericParamInfo.getChildNode();
            }
            if (value instanceof String && opts.getBoolean((Object)"convertJSONStrings", false)) {
                String s = (String)value;
                if (Collection.class.isAssignableFrom(paramType)) {
                    if (s.startsWith("[")) {
                        try {
                            value = JSTranslater.instance().fromJS(s);
                        }
                        catch (Exception exception) {}
                    } else if (propertyMap != null && propertyMap instanceof Config) {
                        value = ((Config)((Object)propertyMap)).getList(propertyName);
                    }
                } else if (Map.class.isAssignableFrom(paramType) && s.startsWith("{")) {
                    try {
                        value = JSTranslater.instance().fromJS(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ReflectionArgument arg = new ReflectionArgument(value != null ? value.getClass() : null, value);
            Class javaClass = null;
            Class javaCollectionClass = null;
            Class javaKeyClass = null;
            DataSource subDS = null;
            if (ds != null && propertyName != null) {
                String fieldType = null;
                DSField field3 = ds.getField(propertyName);
                if (field3 != null) {
                    try {
                        javaClass = ds._getPropertyJavaClass(propertyName, field3, value);
                        String typeName = field3.getProperty("javaCollectionClass");
                        if (typeName != null) {
                            javaCollectionClass = Reflection.classForName(typeName);
                        }
                        if ((typeName = field3.getProperty("javaKeyClass")) != null) {
                            javaKeyClass = Reflection.classForName(typeName);
                        }
                    }
                    catch (Exception e) {
                        log.warn(e.getClass().getName() + " " + e.getMessage() + " encountered whilst trying to derive Java classes from override class names for DataSource '" + ds.getName() + "', field name '" + propertyName + "'");
                        e.printStackTrace();
                    }
                    fieldType = field3.getType();
                }
                subDS = fieldType == null ? null : DataSourceManager.get(fieldType, dsRequest);
            }
            return Reflection.adaptValue(paramType, genericParamInfo, arg, null, subDS == null ? ds : subDS, javaClass, javaCollectionClass, javaKeyClass, dsRequest);
        }
        DataSource subDS = null;
        if (ds != null && propertyName != null && (field = ds.getField(propertyName)) != null) {
            String type;
            Class work;
            if (!JSONFilter.class.isAssignableFrom(paramType) && (work = ds._getPropertyJavaClass(propertyName, field, value)) != null) {
                paramType = work;
            }
            if ((type = field.getType()) != null) {
                subDS = DataSourceManager.get(type);
            }
        }
        if (value == null) {
            if (paramType.isPrimitive()) {
                value = DataTools.convertType(paramType, "", ds);
            }
        } else if (!paramType.isAssignableFrom(value.getClass())) {
            value = DataTools.convertType(paramType, value, subDS == null ? ds : subDS, false);
        }
        return value;
    }

    public static Object convertType(Class targetType, Object value) throws Exception {
        return DataTools.convertType(targetType, value, null, true);
    }

    public static Object convertType(Class targetType, Object value, DataSource ds) throws Exception {
        return DataTools.convertType(targetType, value, ds, true);
    }

    public static Object convertType(Class targetType, Object value, DataSource ds, boolean clearContext) throws Exception {
        return DataTools.convertType(targetType, value, ds, DataTools.buildMap("clearContext", clearContext));
    }

    public static Object convertType(Class targetType, Object value, DataSource ds, DataTypeMap opts) throws Exception {
        Object instance;
        Transformer transformer;
        if (targetType == null) {
            return null;
        }
        if (value == null) {
            return null;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (value instanceof String && "".equals(value) && Number.class.isAssignableFrom(targetType)) {
            return null;
        }
        if (!targetType.isPrimitive() && !VersionSafeChecker.isEnum(targetType)) {
            Class[] types = new Class[]{value.getClass()};
            try {
                Constructor constructor = targetType.getConstructor(types);
                Object[] arguments = new Object[]{value};
                return constructor.newInstance(arguments);
            }
            catch (NoSuchMethodException constructor) {
            }
            catch (InvocationTargetException constructor) {
                // empty catch block
            }
        }
        if ((transformer = (Transformer)defaultTransformers.get(targetType)) != null) {
            return transformer.transform(value);
        }
        if (VersionSafeChecker.isEnum(targetType)) {
            return DataTools.transformEnum(value, targetType, ds);
        }
        if (value instanceof Map && !targetType.isPrimitive() && !targetType.isInterface() && !targetType.isArray()) {
            instance = null;
            try {
                instance = targetType.newInstance();
                try {
                    DataTools.setProperties((Map)value, instance, ds, null, opts);
                    return instance;
                }
                catch (Exception ee) {
                    log.debug("Tried to convert inbound nested Map to: " + targetType.getName() + " but DataTools.setProperties() on instantiated class failed with the following error: " + ee.getMessage());
                }
            }
            catch (Exception e) {
                log.debug("Tried to convert inbound nested Map to: " + targetType.getName() + " but instantiation failed with the following error:" + e.getMessage());
            }
        }
        if (value instanceof InputStream) {
            if (String.class == targetType) {
                return IOUtil.inputStreamToString((InputStream)value);
            }
            if (byte[].class.isAssignableFrom(targetType)) {
                return IOUtil.toByteArray((InputStream)value);
            }
            if (Byte[].class.isAssignableFrom(targetType)) {
                return ArrayUtils.toObject((byte[])IOUtil.toByteArray((InputStream)value));
            }
            if (OutputStream.class.isAssignableFrom(targetType)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtil.copyStreams((InputStream)value, out);
                return out;
            }
        }
        if (value instanceof String) {
            if (byte[].class.isAssignableFrom(targetType)) {
                return ((String)value).getBytes();
            }
            if (Byte[].class.isAssignableFrom(targetType)) {
                return ArrayUtils.toObject((byte[])((String)value).getBytes());
            }
        }
        if (value instanceof Byte[] && String.class == targetType) {
            return new String(ArrayUtils.toPrimitive((Byte[])((Byte[])value)));
        }
        if (targetType.isArray()) {
            try {
                Object valueArray = null;
                if (value instanceof Collection) {
                    valueArray = ((Collection)value).toArray();
                } else if (value.getClass().isArray()) {
                    valueArray = value;
                } else if (value instanceof Map) {
                    valueArray = ((Map)value).values().toArray();
                } else {
                    valueArray = Array.newInstance(value.getClass(), 1);
                    Array.set(valueArray, 0, value);
                }
                if (valueArray != null) {
                    Object instance2 = Array.newInstance(targetType.getComponentType(), Array.getLength(valueArray));
                    for (int i = 0; i < Array.getLength(valueArray); ++i) {
                        Array.set(instance2, i, DataTools.convertType(targetType.getComponentType(), Array.get(valueArray, i), ds, opts));
                    }
                    return instance2;
                }
                throw new Exception("Failed to convert value into array of value type.");
            }
            catch (Exception e) {
                log.debug("Failed to convert value into array of targetType: " + e.getMessage());
            }
        }
        if (String.class == targetType) {
            return value.toString();
        }
        if (!targetType.isPrimitive() && (targetType.isInterface() || Modifier.isAbstract(targetType.getModifiers()))) {
            log.warn("Impossible to convert to target type " + targetType.getName() + " - it is not a concrete class");
        }
        if (targetType.getName().startsWith("org.joda.time") && value instanceof String) {
            try {
                Method parse = Reflection.findMethod(targetType.getName(), "parse", String.class);
                return parse.invoke(null, value);
            }
            catch (Throwable t) {
                t = Reflection.getRealTargetException(t);
                String error = DataTools.getStackTrace(t);
                log.warn("Failed conversion to joda time type. We tried to call " + targetType.getName() + ".parse(String) method and it failed.");
            }
        }
        if (value instanceof String && opts.getBoolean((Object)"convertJSONStrings", false) && ((String)value).startsWith("{") && !targetType.isPrimitive() && !targetType.isInterface() && !targetType.isArray()) {
            try {
                value = JSTranslater.instance().fromJS((String)value);
                instance = null;
                try {
                    instance = targetType.newInstance();
                    try {
                        DataTools.setProperties((Map)value, instance, ds, null, opts);
                        return instance;
                    }
                    catch (Exception ee) {
                        log.debug("Tried to convert inbound nested Map (from JSON) to: " + targetType.getName() + " but DataTools.setProperties() on instantiated class failed with the following error: " + ee.getMessage());
                    }
                }
                catch (Exception e) {
                    log.debug("Tried to convert inbound nested Map (from JSON) to: " + targetType.getName() + " but instantiation failed with the following error:" + e.getMessage());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Can't convert value of type " + value.getClass().getName() + " to target type " + targetType.getName());
    }

    public static Object transformEnum(Object value, Class targetType, DataSource ds) throws Exception {
        if (!targetType.isEnum()) {
            return null;
        }
        String translateStrategy = ds == null ? "string" : ds.getEnumTranslateStrategy();
        String ordinalProperty = ds == null ? "_ordinal" : ds.getEnumOrdinalProperty();
        String constantProperty = ds == null ? "_constant" : ds.getEnumConstantProperty();
        String valueStr = value == null ? "" : value.toString();
        Enum theEnum = null;
        Enum[] enumConsts = (Enum[])targetType.getEnumConstants();
        Map<Object, String> stringValueMap = Reflection.getEnumValues(targetType, false);
        if (value instanceof Map) {
            translateStrategy = "bean";
        }
        if ("ordinal".equalsIgnoreCase(translateStrategy)) {
            int ordinal = -1;
            try {
                ordinal = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ordinal >= 0 && ordinal < enumConsts.length) {
                theEnum = enumConsts[ordinal];
            } else {
                log.warn("Value " + value + " was non-numeric, negative or too large using \"ordinal\" strategy for targetType " + targetType.getName() + " - trying constant name");
            }
        } else if ("bean".equalsIgnoreCase(translateStrategy)) {
            if (value instanceof Map) {
                String property = (String)((Map)value).get(constantProperty);
                if (property != null) {
                    if (stringValueMap.containsKey(property)) {
                        theEnum = Enum.valueOf(targetType, property);
                    } else {
                        for (Object key : stringValueMap.keySet()) {
                            if (!key.toString().equalsIgnoreCase(property)) continue;
                            theEnum = Enum.valueOf(targetType, key.toString());
                            break;
                        }
                    }
                }
                if (theEnum == null) {
                    Object ordinalObj = ((Map)value).get(ordinalProperty);
                    if (ordinalObj != null) {
                        property = ordinalObj.toString();
                        int ordinal = -1;
                        try {
                            ordinal = Integer.parseInt(property);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (ordinal >= 0 && ordinal < enumConsts.length) {
                            theEnum = enumConsts[ordinal];
                        }
                    } else {
                        log.warn("Could not map value " + value + " to a valid enum member using \"bean\" strategy for targetType " + targetType.getName() + " - trying constant name, then ordinal number");
                    }
                }
            } else {
                log.warn("Value " + value + " is not an instance of Map using \"bean\" strategy for targetType " + targetType.getName() + " - trying constant name, then ordinal number");
            }
        }
        if ("string".equalsIgnoreCase(translateStrategy)) {
            for (Object e : targetType.getEnumConstants()) {
                if (!valueStr.equals(e.toString())) continue;
                theEnum = (Enum)e;
                break;
            }
            if (theEnum == null) {
                log.warn("Value " + value + " was not found in the enum using \"string\" strategy for targetType " + targetType.getName() + " - trying constant name, then ordinal number");
            }
        }
        if (theEnum == null) {
            if (stringValueMap.containsKey(valueStr)) {
                theEnum = Enum.valueOf(targetType, valueStr);
            } else {
                for (Object key : stringValueMap.keySet()) {
                    if (!key.toString().equalsIgnoreCase(valueStr)) continue;
                    theEnum = Enum.valueOf(targetType, key.toString());
                    break;
                }
                if (theEnum == null && translateStrategy.toLowerCase().equals("name")) {
                    log.warn("Value " + value + " was not found in the enum using \"name\" strategy for targetType " + targetType.getName() + " - trying ordinal number");
                }
            }
        }
        if (theEnum == null && !"ordinal".equalsIgnoreCase(translateStrategy)) {
            int ordinal = -1;
            try {
                ordinal = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ordinal >= 0 && ordinal < enumConsts.length) {
                theEnum = enumConsts[ordinal];
            }
        }
        if (theEnum == null) {
            log.error("Value: " + value.toString() + " cannot be converted to a valid  member of enumerated type " + targetType.getName());
        }
        return targetType.cast(theEnum);
    }

    public static void registerTransformer(Class targetType, Transformer transformer) {
        defaultTransformers.put(targetType, transformer);
    }

    public static Object castValue(Object value, Class targetType) {
        return DataTools.castValue(value, targetType, null);
    }

    public static Object castValue(Object value, Class targetType, DataSource ds) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (Boolean.TYPE.equals(targetType)) {
            targetType = Boolean.class;
        }
        if (Byte.TYPE.equals(targetType)) {
            targetType = Byte.class;
        }
        if (Short.TYPE.equals(targetType)) {
            targetType = Short.class;
        }
        if (Integer.TYPE.equals(targetType)) {
            targetType = Integer.class;
        }
        if (Long.TYPE.equals(targetType)) {
            targetType = Long.class;
        }
        if (Float.TYPE.equals(targetType)) {
            targetType = Float.class;
        }
        if (Double.TYPE.equals(targetType)) {
            targetType = Double.class;
        }
        if (Character.TYPE.equals(targetType)) {
            targetType = Character.class;
        }
        if (targetType.isInstance(value)) {
            return value;
        }
        if (Boolean.class.equals(targetType)) {
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.signum() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                if (c == 'T' || c == 't' || c == 'Y' || c == 'y') {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                String s = value.toString();
                if ("t".equalsIgnoreCase(s) || "y".equalsIgnoreCase(s) || "true".equalsIgnoreCase(s) || "yes".equalsIgnoreCase(s)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        } else if (Byte.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return (byte)(Boolean.TRUE.equals(value) ? 1 : 0);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.byteValue();
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return (byte)c;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Byte.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
        } else if (Short.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return (short)(Boolean.TRUE.equals(value) ? 1 : 0);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.shortValue();
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return (short)c;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Short.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
        } else if (Integer.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return Boolean.TRUE.equals(value) ? 1 : 0;
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.intValue();
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return (int)c;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
        } else if (Long.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return (long)(Boolean.TRUE.equals(value) ? 1 : 0);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.longValue();
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return (long)c;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Long.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                return ((Date)value).getTime();
            }
        } else if (Float.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return Float.valueOf(Boolean.TRUE.equals(value) ? 1 : 0);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return Float.valueOf(n.floatValue());
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return Float.valueOf(c);
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Float.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                return Float.valueOf(((Date)value).getTime());
            }
        } else if (Double.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return (double)(Boolean.TRUE.equals(value) ? 1 : 0);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return n.doubleValue();
            }
            if (Character.class.isAssignableFrom(valueClass)) {
                char c = ((Character)value).charValue();
                return (double)c;
            }
            if (String.class.isAssignableFrom(valueClass)) {
                try {
                    return Double.valueOf(value.toString());
                }
                catch (NumberFormatException ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                return (double)((Date)value).getTime();
            }
        } else if (Character.class.equals(targetType)) {
            if (Boolean.class.isAssignableFrom(valueClass)) {
                return Character.valueOf(Boolean.TRUE.equals(value) ? (char)'t' : 'f');
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                BigDecimal n = new BigDecimal(((Number)value).toString());
                return Character.valueOf((char)n.intValue());
            }
            if (String.class.isAssignableFrom(valueClass)) {
                if ("".equals(value.toString())) {
                    return Character.valueOf('\u0000');
                }
                value.toString().charAt(0);
            }
        } else {
            if (String.class.isAssignableFrom(targetType)) {
                return value.toString();
            }
            if (BigInteger.class.isAssignableFrom(targetType)) {
                if (Boolean.class.isAssignableFrom(valueClass)) {
                    return Boolean.TRUE.equals(value) ? BigInteger.ONE : BigInteger.ZERO;
                }
                if (Number.class.isAssignableFrom(valueClass)) {
                    BigDecimal n = new BigDecimal(((Number)value).toString());
                    return n.toBigInteger();
                }
                if (Character.class.isAssignableFrom(valueClass)) {
                    return BigInteger.valueOf(((Character)value).charValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    try {
                        return new BigInteger(value.toString());
                    }
                    catch (NumberFormatException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    return BigInteger.valueOf(((Date)value).getTime());
                }
            } else if (BigDecimal.class.isAssignableFrom(targetType)) {
                if (Boolean.class.isAssignableFrom(valueClass)) {
                    return Boolean.TRUE.equals(value) ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                if (Number.class.isAssignableFrom(valueClass)) {
                    return new BigDecimal(((Number)value).toString());
                }
                if (Character.class.isAssignableFrom(valueClass)) {
                    return BigDecimal.valueOf(((Character)value).charValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    try {
                        return new BigDecimal(value.toString());
                    }
                    catch (NumberFormatException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    return BigDecimal.valueOf(((Date)value).getTime());
                }
            } else if (java.sql.Date.class.isAssignableFrom(targetType)) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    BigDecimal n = new BigDecimal(((Number)value).toString());
                    return new java.sql.Date(n.longValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    DateFormat df = DateFormat.getDateInstance();
                    try {
                        Date d = df.parse(value.toString());
                        return new java.sql.Date(d.getTime());
                    }
                    catch (ParseException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    return new java.sql.Date(((Date)value).getTime());
                }
                if (Time.class.isAssignableFrom(valueClass)) {
                    return new java.sql.Date(((Time)value).getTime());
                }
                if (Timestamp.class.isAssignableFrom(valueClass)) {
                    return new java.sql.Date(((Timestamp)value).getTime());
                }
            } else if (Time.class.isAssignableFrom(targetType)) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    BigDecimal n = new BigDecimal(((Number)value).toString());
                    return new Time(n.longValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    DateFormat df = DateFormat.getTimeInstance();
                    try {
                        Date d = df.parse(value.toString());
                        return new Time(d.getTime());
                    }
                    catch (ParseException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    return new Time(((Date)value).getTime());
                }
                if (java.sql.Date.class.isAssignableFrom(valueClass)) {
                    return new Time(((java.sql.Date)value).getTime());
                }
                if (Timestamp.class.isAssignableFrom(valueClass)) {
                    return new Time(((Timestamp)value).getTime());
                }
            } else if (Timestamp.class.isAssignableFrom(targetType)) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    BigDecimal n = new BigDecimal(((Number)value).toString());
                    return new Timestamp(n.longValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    try {
                        Date d = df.parse(value.toString());
                        return new Timestamp(d.getTime());
                    }
                    catch (ParseException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
                if (Date.class.isAssignableFrom(valueClass)) {
                    return new Timestamp(((Date)value).getTime());
                }
                if (java.sql.Date.class.isAssignableFrom(valueClass)) {
                    return new Timestamp(((java.sql.Date)value).getTime());
                }
                if (Time.class.isAssignableFrom(valueClass)) {
                    return new Timestamp(((Time)value).getTime());
                }
            } else if (Date.class.isAssignableFrom(targetType)) {
                if (Number.class.isAssignableFrom(valueClass)) {
                    BigDecimal n = new BigDecimal(((Number)value).toString());
                    return new Date(n.longValue());
                }
                if (String.class.isAssignableFrom(valueClass)) {
                    DateFormat df = DateFormat.getDateTimeInstance();
                    try {
                        return df.parse(value.toString());
                    }
                    catch (ParseException ex) {
                        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                    }
                }
            } else if (VersionSafeChecker.isEnum(targetType)) {
                try {
                    return DataTools.transformEnum(value, targetType, ds);
                }
                catch (Exception ex) {
                    throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
                }
            }
        }
        throw new ClassCastException("Value '" + value.toString() + "' of type '" + valueClass.toString() + "' can not be cast to type '" + targetType.toString() + "'.");
    }

    public static boolean isTextType(Class clazz) {
        return String.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Character.TYPE.equals(clazz);
    }

    public static boolean isNumberType(Class clazz) {
        return Number.class.isAssignableFrom(clazz) || Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Long.TYPE.equals(clazz) || Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz);
    }

    public static InputStream isEmptyStream(InputStream in) throws IOException {
        return DataTools.isEmptyStream(in, 1);
    }

    public static InputStream isEmptyStream(InputStream in, int minLength) throws IOException {
        if (in == null) {
            throw new IOException("InputStream is null");
        }
        if (minLength < 1) {
            return in;
        }
        PushbackInputStream input = new PushbackInputStream(in, minLength);
        byte[] dataToPushBack = new byte[minLength];
        if (input.read(dataToPushBack, 0, minLength) < minLength) {
            throw new IOException("InputStream is empty");
        }
        input.unread(dataToPushBack);
        return input;
    }

    public static void main(String[] args) throws Exception {
        TestBean bean = new TestBean();
        HashMap<String, String> testValues = new HashMap<String, String>();
        testValues.put("intObj", "");
        testValues.put("justInt", "");
        testValues.put("floatObj", "");
        testValues.put("justFloat", "");
        testValues.put("boolObj", "");
        testValues.put("justBool", "");
        DataTools.setProperties(testValues, bean);
        System.out.println("Bean is: " + DataTools.prettyPrint(bean));
        testValues.put("intObj", null);
        testValues.put("justInt", null);
        testValues.put("floatObj", null);
        testValues.put("justFloat", null);
        testValues.put("boolObj", null);
        testValues.put("justBool", null);
        DataTools.setProperties(testValues, bean);
        System.out.println("Bean is: " + DataTools.prettyPrint(bean));
    }

    public static boolean stringToBooleanValue(String s) {
        if (s == null) {
            return false;
        }
        return s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("true");
    }

    public static Date endOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date startOfDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean recursiveFileDelete(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DataTools.recursiveFileDelete(new File(file, children[i]));
                if (success) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String mimeTypeForFileName(String fileName) throws Exception {
        return DataTools.mimeTypeForExtension(DataTools.extensionForFileName(fileName));
    }

    public static boolean caseSensitiveFileExists(String filename, File file) throws IOException {
        if (file.exists()) {
            if (filename == null) {
                return true;
            }
            int slashIndex = (filename = ISCFile.canonicalizePath(filename)).lastIndexOf("/");
            if (slashIndex != -1) {
                filename = filename.substring(slashIndex + 1);
            }
            return filename.equals(file.getCanonicalFile().getName());
        }
        return false;
    }

    public static String mimeTypeForExtension(String extension) throws Exception {
        if (extension == null) {
            return null;
        }
        extension = extension.toLowerCase();
        String mimeType = null;
        if (mimeType == null) {
            if (useMimeTypesJS) {
                mimeType = mimeTypesJS.getString(extension);
            } else if (ISCFile.servletContext != null) {
                mimeType = ISCFile.servletContext.getMimeType("foo." + extension);
            }
        }
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        return mimeType;
    }

    public static String extensionForFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int lastDotIndex = fileName.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return null;
        }
        String extension = fileName.substring(lastDotIndex + 1);
        return extension;
    }

    public static URL resourceFromClassLoader(String name) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL resource = null;
        if (cl != null) {
            resource = cl.getResource(name);
        }
        if (resource == null) {
            cl = Config.class.getClassLoader();
            resource = cl.getResource(name);
        }
        return resource;
    }

    public static List<String> commaSeparatedStringToList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            result.add(st.nextToken().trim());
        }
        return result;
    }

    public static String getLineContainingCharPosition(String buffer, int charPos) {
        int length;
        int pos;
        int lineStart = 0;
        for (pos = charPos; pos > 0; --pos) {
            char c = buffer.charAt(pos);
            if (c != '\n' && c != '\r') continue;
            lineStart = pos + 1;
            break;
        }
        int lineEnd = length = buffer.length();
        for (pos = charPos; pos < length; ++pos) {
            char c = buffer.charAt(pos);
            if (c != '\n' && c != '\r') continue;
            lineEnd = pos;
            break;
        }
        return buffer.substring(lineStart, lineEnd);
    }

    public static int countChars(String s, char c) {
        StringReader sr = new StringReader(s);
        int count = 0;
        try {
            int x;
            while ((x = sr.read()) != -1) {
                if (x != c) continue;
                ++count;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return count;
    }

    public static int countCompleteLines(String buffer) {
        return DataTools.countChars(buffer, '\n');
    }

    public static int countLines(String buffer, int toCharPos) {
        int pos = 0;
        int lines = 1;
        while (pos < toCharPos) {
            char c = buffer.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 < toCharPos && buffer.charAt(pos + 1) == '\n') {
                    pos += 2;
                    continue;
                }
            }
            if (c == '\n') {
                ++lines;
            }
            ++pos;
        }
        return lines;
    }

    public static int cardinality(BitSet set) {
        int cardinality = 0;
        int length = set.length();
        for (int i = 0; i < length; ++i) {
            if (!set.get(i)) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public static String formatFileSize(long fileSize) {
        String suffix = null;
        if (fileSize < 1024L) {
            suffix = "B";
        } else if (fileSize < 0x100000L) {
            fileSize = Math.round(fileSize / 1024L);
            suffix = "KB";
        } else {
            fileSize = Math.round(fileSize / 0x100000L * 100L) / 100;
            suffix = "MB";
        }
        return fileSize + " " + suffix;
    }

    public static List resolveDependencyTree(List initialItems, Map dependencies) throws Exception {
        if (dependencies == null) {
            return initialItems;
        }
        ArrayList<Object> items = new ArrayList();
        items.addAll(initialItems);
        boolean done = false;
        while (!done) {
            done = true;
            ArrayList dependencyItems = new ArrayList();
            for (Object item : items) {
                List itemDependencies = dependencies instanceof DataTypeMap ? ((DataTypeMap)((Object)dependencies)).getList(item, null) : (List)dependencies.get(item);
                if (itemDependencies == null) continue;
                dependencyItems.addAll(itemDependencies);
            }
            if (!items.containsAll(dependencyItems)) {
                done = false;
                items.addAll(dependencyItems);
            }
            items = new ArrayList(DataTools.identityMap(items).keySet());
        }
        return items;
    }

    public static List sortByExplicitOrder(List toSort, List ordered) {
        if (ordered == null || ordered.size() == 0) {
            return toSort;
        }
        ArrayList result = new ArrayList();
        for (Object item : ordered) {
            if (!toSort.contains(item)) continue;
            result.add(item);
        }
        for (Object item : toSort) {
            if (ordered.contains(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static String randomString(int length) {
        byte[] bytes = new byte[length];
        Base64 encoder = new Base64();
        new Random().nextBytes(bytes);
        bytes = encoder.encode(bytes);
        return new String(bytes, 0, length);
    }

    public static String base64Encode(InputStream stream) throws Exception {
        byte[] bytes;
        int l;
        ArrayList<byte[]> temp = new ArrayList<byte[]>();
        int size = 0;
        int lastSize = 0;
        while ((l = stream.read(bytes = new byte[1000])) != -1) {
            size += l;
            temp.add(bytes);
            lastSize = l;
        }
        byte[] realBytes = new byte[size];
        for (int i = 0; i < temp.size(); ++i) {
            int copySize = i == temp.size() - 1 ? lastSize : 1000;
            System.arraycopy(temp.get(i), 0, realBytes, i * 1000, copySize);
        }
        return DataTools.base64Encode(realBytes);
    }

    public static String base64Encode(byte[] bytes) {
        Base64 encoder = new Base64();
        return new String(Base64.encodeBase64((byte[])bytes));
    }

    public static InputStream base64Decode(String encoded) {
        Base64 decoder = new Base64();
        byte[] bytes = encoded.getBytes();
        byte[] decoded = Base64.decodeBase64((byte[])bytes);
        return new ByteArrayInputStream(decoded);
    }

    public static byte[] base64DecodeToBytes(String encoded) {
        Base64 decoder = new Base64();
        byte[] bytes = encoded.getBytes();
        return Base64.decodeBase64((byte[])bytes);
    }

    public static String base64DecodeToString(String encoded) {
        return new String(DataTools.base64DecodeToBytes(encoded), StandardCharsets.UTF_8);
    }

    public static String deriveTitleFromName(String name) {
        String work = name.replaceAll("_", " ");
        work = work.trim();
        String title = "";
        if (work == work.toUpperCase() || work == work.toLowerCase()) {
            work = work.toLowerCase();
            boolean capNext = true;
            for (int i = 0; i < work.length(); ++i) {
                String letter = work.substring(i, i + 1);
                if (capNext) {
                    letter = letter.toUpperCase();
                    capNext = false;
                }
                if (" ".equals(letter)) {
                    capNext = true;
                }
                title = title + letter;
            }
        } else {
            title = work.substring(0, 1).toUpperCase();
            boolean capLast = work.substring(0, 1).equals(work.substring(0, 1).toUpperCase());
            boolean capSeq = false;
            for (int i = 1; i < work.length(); ++i) {
                String letter = work.substring(i, i + 1);
                if (capSeq && letter.equals(letter.toLowerCase())) {
                    capSeq = false;
                    title = title.substring(0, title.length() - 1) + " " + title.substring(title.length() - 1);
                }
                if (capLast && letter.equals(letter.toUpperCase())) {
                    capSeq = true;
                }
                if (!capLast && letter.equals(letter.toUpperCase())) {
                    title = title + " ";
                }
                capLast = letter.equals(letter.toUpperCase());
                title = title + letter;
            }
        }
        return title;
    }

    public static String randomText(int length) throws Exception {
        String[] pool = new String[]{"0123456789", "abcdefghijklmnopqrstuvwxyz", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int usePool = (int)Math.floor(Math.random() * 3.0);
            int useChar = (int)Math.floor(Math.random() * (double)pool[usePool].length());
            sb.append(pool[usePool].charAt(useChar));
        }
        return sb.toString();
    }

    public static String md5(String plaintext) throws Exception {
        return DataTools.hashValue(plaintext, "MD5");
    }

    public static String sha(String plaintext) throws Exception {
        return DataTools.hashValue(plaintext, "SHA");
    }

    public static String bcrypt(String plaintext) throws Exception {
        return DataTools.hashValue(plaintext, "bcrypt");
    }

    public static String hashValue(String plaintext) throws Exception {
        return DataTools.hashValue(plaintext, "MD5");
    }

    public static String hashValue(String plaintext, String algorithm) throws Exception {
        if (algorithm.equals("bcrypt")) {
            return BCrypt.hashpw(plaintext, BCrypt.gensalt());
        }
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.reset();
        md.update(plaintext.getBytes());
        byte[] cipherbytes = md.digest();
        BigInteger work = new BigInteger(1, cipherbytes);
        String ciphertext = work.toString(16);
        if (algorithm.equals("MD5")) {
            ciphertext = "00000000000000000000000000000000".substring(ciphertext.length()) + ciphertext;
        } else if (algorithm.equals("SHA")) {
            ciphertext = "0000000000000000000000000000000000000000".substring(ciphertext.length()) + ciphertext;
        } else {
            throw new Exception("Unable to hash - unsupported algorithm: " + algorithm);
        }
        return ciphertext;
    }

    public static String escapeHTML(String src) {
        if (src == null) {
            return null;
        }
        return src.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("(\r\n|\r|\n) ", "<BR>&nbsp;").replaceAll("(\r\n|\r|\n)", "<BR>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public static String stripHTML(String src) {
        if (src == null) {
            return null;
        }
        return src.replaceAll("<br>", "\n").replaceAll("<BR>", "\n").replaceAll("\\<[^>]*?>", "").replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&nbsp;", "");
    }

    public static Locale deriveLocaleFromName(String localeName) {
        if (localeName == null) {
            return null;
        }
        String[] localeElements = localeName.split("_");
        if (localeElements.length == 1) {
            return new Locale(localeElements[0]);
        }
        if (localeElements.length == 2) {
            return new Locale(localeElements[0], localeElements[1]);
        }
        if (localeElements.length == 3) {
            return new Locale(localeElements[0], localeElements[1], localeElements[2]);
        }
        return null;
    }

    public static boolean keyExists(Map map, String key, boolean ignoreCase) {
        if (map == null || map.keySet().size() == 0) {
            return false;
        }
        if (key == null) {
            return map.keySet().contains(null);
        }
        if (ignoreCase) {
            key = key.toLowerCase();
        }
        Object[] mapKeys = map.keySet().toArray();
        for (int i = 0; i < mapKeys.length; ++i) {
            String mapKey = mapKeys[i].toString();
            if (ignoreCase) {
                mapKey = mapKey.toLowerCase();
            }
            if (!mapKey.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String getListEntry(List<String> list, String entry) {
        if (list == null || list.size() == 0 || entry == null) {
            return null;
        }
        entry = entry.toLowerCase();
        for (int i = 0; i < list.size(); ++i) {
            String entryInList = list.get(i);
            if (entryInList == null || !entryInList.toLowerCase().equals(entry)) continue;
            return entryInList;
        }
        return null;
    }

    public static String formatDate(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Object getLoggerRepository() {
        return Logger.getLoggerRepository();
    }

    public static String ucFirstLetter(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char firstChar = s.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            s = Character.toUpperCase(firstChar) + s.substring(1);
        }
        return s;
    }

    static {
        Transformer boolTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                return Boolean.valueOf(input.toString());
            }
        };
        defaultTransformers.put(Boolean.TYPE, boolTransform);
        Transformer charTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return new Character('\u0000');
                }
                return new Character(value.charAt(0));
            }
        };
        defaultTransformers.put(Character.TYPE, charTransform);
        defaultTransformers.put(Character.class, charTransform);
        Transformer byteTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return new Byte(0);
                }
                try {
                    return Byte.valueOf(value);
                }
                catch (Exception exception) {
                    BigDecimal d = new BigDecimal(value);
                    return new Byte(d.byteValueExact());
                }
            }
        };
        defaultTransformers.put(Byte.TYPE, byteTransform);
        defaultTransformers.put(Byte.class, byteTransform);
        Transformer shortTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return new Short(0);
                }
                try {
                    return Short.valueOf(value);
                }
                catch (Exception exception) {
                    BigDecimal d = new BigDecimal(value);
                    return new Short(d.shortValueExact());
                }
            }
        };
        defaultTransformers.put(Short.TYPE, shortTransform);
        defaultTransformers.put(Short.class, shortTransform);
        Transformer intTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return 0;
                }
                try {
                    return Integer.valueOf(value);
                }
                catch (Exception exception) {
                    BigDecimal d = new BigDecimal(value);
                    return d.intValueExact();
                }
            }
        };
        defaultTransformers.put(Integer.TYPE, intTransform);
        defaultTransformers.put(Integer.class, intTransform);
        Transformer longTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return 0L;
                }
                try {
                    return Long.valueOf(value);
                }
                catch (Exception exception) {
                    BigDecimal d = new BigDecimal(value);
                    return d.longValueExact();
                }
            }
        };
        defaultTransformers.put(Long.TYPE, longTransform);
        defaultTransformers.put(Long.class, longTransform);
        Transformer floatTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(value);
            }
        };
        defaultTransformers.put(Float.TYPE, floatTransform);
        defaultTransformers.put(Float.class, floatTransform);
        Transformer doubleTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return 0.0;
                }
                return Double.valueOf(value);
            }
        };
        defaultTransformers.put(Double.TYPE, doubleTransform);
        defaultTransformers.put(Double.class, doubleTransform);
        Transformer bigDecimalTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return new BigDecimal(0);
                }
                return new BigDecimal(value);
            }
        };
        defaultTransformers.put(BigDecimal.class, bigDecimalTransform);
        Transformer bigIntegerTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                String value = input.toString();
                if ("".equals(value)) {
                    return BigInteger.ZERO;
                }
                try {
                    return new BigInteger(value);
                }
                catch (Exception exception) {
                    BigDecimal d = new BigDecimal(value);
                    return d.toBigIntegerExact();
                }
            }
        };
        defaultTransformers.put(BigInteger.class, bigIntegerTransform);
        Transformer javaSqlDateTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                if (input instanceof Date) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)input);
                    c.set(11, 0);
                    c.set(12, 0);
                    c.set(13, 0);
                    c.set(14, 0);
                    return new java.sql.Date(c.getTime().getTime());
                }
                throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.sql.Date");
            }
        };
        defaultTransformers.put(java.sql.Date.class, javaSqlDateTransform);
        Transformer javaSqlTimeTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                if (input instanceof Date) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)input);
                    c.set(1970, 0, 1);
                    return new Time(c.getTime().getTime());
                }
                throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.sql.Time");
            }
        };
        defaultTransformers.put(Time.class, javaSqlTimeTransform);
        Transformer javaSqlTimestampTransform = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                if (input instanceof Date) {
                    return new Timestamp(((Date)input).getTime());
                }
                throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.sql.Timestamp");
            }
        };
        defaultTransformers.put(Timestamp.class, javaSqlTimestampTransform);
        Transformer calendarTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                if (input instanceof Date) {
                    Calendar c = Calendar.getInstance();
                    c.setTime((Date)input);
                    return c;
                }
                throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.util.Calendar");
            }
        };
        defaultTransformers.put(Calendar.class, calendarTransformer);
        Transformer dateTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                if (input instanceof Calendar) {
                    return ((Calendar)input).getTime();
                }
                if (input instanceof String) {
                    SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    return sdf.parse((String)input);
                }
                throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.util.Date");
            }
        };
        defaultTransformers.put(Date.class, dateTransformer);
        Transformer jodaDateTimeTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    return new DateTime(input);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to org.joda.time.DateTime", ex);
                }
            }
        };
        defaultTransformers.put(DateTime.class, jodaDateTimeTransformer);
        Transformer jodaDateMidnightTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    return new DateMidnight(input);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to org.joda.time.DateMidnight", ex);
                }
            }
        };
        defaultTransformers.put(DateMidnight.class, jodaDateMidnightTransformer);
        Transformer jodaLocalDateTimeTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    return new LocalDateTime(input);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to org.joda.time.LocalDateTime", ex);
                }
            }
        };
        defaultTransformers.put(LocalDateTime.class, jodaLocalDateTimeTransformer);
        Transformer jodaLocalDateTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    return new LocalDate(input);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to org.joda.time.LocalDate", ex);
                }
            }
        };
        defaultTransformers.put(LocalDate.class, jodaLocalDateTransformer);
        Transformer jodaLocalTimeTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    return new LocalTime(input);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to org.joda.time.LocalTime", ex);
                }
            }
        };
        defaultTransformers.put(LocalTime.class, jodaLocalTimeTransformer);
        Transformer xmlGregorianCalendarTransformer = new Transformer(){

            @Override
            public Object transform(Object input) throws Exception {
                try {
                    if (input instanceof Calendar) {
                        input = ((Calendar)input).getTime();
                    } else if (input instanceof String) {
                        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                        input = sdf.parse((String)input);
                    }
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTimeInMillis(((Date)input).getTime());
                    return DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
                }
                catch (Exception ex) {
                    throw new Exception("Can't convert type: " + input.getClass().getName() + " to javax.xml.datatype.XMLGregorianCalendar", ex);
                }
            }
        };
        defaultTransformers.put(XMLGregorianCalendar.class, xmlGregorianCalendarTransformer);
        try {
            Class javaLocalDateClass = Reflection.classForName("java.time.LocalDate");
            Transformer javaLocalDateTransformer = new Transformer(){

                @Override
                public Object transform(Object input) throws Exception {
                    try {
                        if (input instanceof Date) {
                            Object instant = Reflection.invokeMethod(input, "toInstant");
                            Object zoneId = Reflection.invokeStaticMethod("java.time.ZoneId", "systemDefault");
                            Object zdt = Reflection.invokeMethod(instant, "atZone", zoneId);
                            return Reflection.invokeMethod(zdt, "toLocalDate");
                        }
                        return Reflection.invokeStaticMethod("java.time.LocalDate", "parse", input.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.time.LocalDate", ex);
                    }
                }
            };
            defaultTransformers.put(javaLocalDateClass, javaLocalDateTransformer);
            Class javaLocalDateTimeClass = Reflection.classForName("java.time.LocalDateTime");
            Transformer javaLocalDateTimeTransformer = new Transformer(){

                @Override
                public Object transform(Object input) throws Exception {
                    try {
                        if (input instanceof Date) {
                            Object instant = Reflection.invokeMethod(input, "toInstant");
                            Object zoneId = Reflection.invokeStaticMethod("java.time.ZoneId", "systemDefault");
                            Object zdt = Reflection.invokeMethod(instant, "atZone", zoneId);
                            return Reflection.invokeMethod(zdt, "toLocalDateTime");
                        }
                        return Reflection.invokeStaticMethod("java.time.LocalDateTime", "parse", input.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.time.LocalDateTime", ex);
                    }
                }
            };
            defaultTransformers.put(javaLocalDateTimeClass, javaLocalDateTimeTransformer);
            Class javaLocalTimeClass = Reflection.classForName("java.time.LocalTime");
            Transformer javaLocalTimeTransformer = new Transformer(){

                @Override
                public Object transform(Object input) throws Exception {
                    try {
                        if (input instanceof Date) {
                            Object instant = Reflection.invokeMethod(input, "toInstant");
                            Object zoneId = Reflection.invokeStaticMethod("java.time.ZoneId", "systemDefault");
                            Object zdt = Reflection.invokeMethod(instant, "atZone", zoneId);
                            return Reflection.invokeMethod(zdt, "toLocalTime");
                        }
                        return Reflection.invokeStaticMethod("java.time.LocalTime", "parse", input.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.time.LocalTime", ex);
                    }
                }
            };
            defaultTransformers.put(javaLocalTimeClass, javaLocalTimeTransformer);
            Class javaInstantClass = Reflection.classForName("java.time.Instant");
            Transformer javaInstantTransformer = new Transformer(){

                @Override
                public Object transform(Object input) throws Exception {
                    try {
                        if (input instanceof Date) {
                            return Reflection.invokeMethod(input, "toInstant");
                        }
                        return Reflection.invokeStaticMethod("java.time.Instant", "parse", input.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.time.Instant", ex);
                    }
                }
            };
            defaultTransformers.put(javaInstantClass, javaInstantTransformer);
            Class javaZonedDateTimeClass = Reflection.classForName("java.time.ZonedDateTime");
            Transformer javaZonedDateTimeTransformer = new Transformer(){

                @Override
                public Object transform(Object input) throws Exception {
                    try {
                        if (input instanceof Date) {
                            Object instant = Reflection.invokeMethod(input, "toInstant");
                            Object zoneId = Reflection.invokeStaticMethod("java.time.ZoneId", "systemDefault");
                            return Reflection.invokeMethod(instant, "atZone", zoneId);
                        }
                        return Reflection.invokeStaticMethod("java.time.ZonedDateTime", "parse", input.toString());
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("Can't convert type: " + input.getClass().getName() + " to java.time.ZonedDateTime", ex);
                    }
                }
            };
            defaultTransformers.put(javaZonedDateTimeClass, javaZonedDateTimeTransformer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        mimeTypesJS = null;
        useMimeTypesJS = false;
    }

    static class TestBean {
        protected Integer intObj;
        protected int justInt;
        protected Float floatObj;
        protected float justFloat;
        protected Boolean boolObj;
        protected boolean justBool;
        protected Character charObj;
        protected char justChar;
        protected Byte byteObj;
        protected byte justByte;

        TestBean() {
        }

        public Integer getIntObj() {
            return this.intObj;
        }

        public void setIntObj(Integer intObj) {
            this.intObj = intObj;
        }

        public int getJustInt() {
            return this.justInt;
        }

        public void setJustInt(int justInt) {
            this.justInt = justInt;
        }

        public Float getFloatObj() {
            return this.floatObj;
        }

        public void setFloatObj(Float floatObj) {
            this.floatObj = floatObj;
        }

        public float getJustFloat() {
            return this.justFloat;
        }

        public void setJustFloat(float justFloat) {
            this.justFloat = justFloat;
        }

        public Boolean getBoolObj() {
            return this.boolObj;
        }

        public void setBoolObj(Boolean boolObj) {
            this.boolObj = boolObj;
        }

        public boolean getJustBool() {
            return this.justBool;
        }

        public void setJustBool(boolean justBool) {
            this.justBool = justBool;
        }

        public Character getCharObj() {
            return this.charObj;
        }

        public void setCharObj(Character charObj) {
            this.charObj = charObj;
        }

        public char getJustChar() {
            return this.justChar;
        }

        public void setJustChar(char justChar) {
            this.justChar = justChar;
        }

        public Byte getByteObj() {
            return this.byteObj;
        }

        public void setByteObj(Byte byteObj) {
            this.byteObj = byteObj;
        }

        public byte getJustByte() {
            return this.justByte;
        }

        public void setJustByte(byte justByte) {
            this.justByte = justByte;
        }
    }

    public static interface Transformer {
        public Object transform(Object var1) throws Exception;
    }
}

