@echo off
setlocal
setlocal enableextensions
setlocal enabledelayedexpansion

set HAVE_JDK=0
set HAVE_JRE=0
set JAVA_IN_PATH=0
set USER_DEFINED_JAVA_HOME=0

rem ===========================================================================
rem JAVA_HOME detection
rem ===========================================================================
rem if JAVA_HOME is set in the env, use that
if defined JAVA_HOME  (
   set USER_DEFINED_JAVA_HOME=1
   goto checkJavaHome
)

rem if JAVA_HOME is not set in the current environment, try to look it up in the registry
rem ===========================================================================
rem JDK >= 9 detection: JavaHome stored under a different registry key than older releases
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\JDK
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if defined JAVA_HOME (
   set HAVE_JDK=1
   goto checkJavaHome
)

rem if JAVA_HOME is not set in the current environment, try to look it up in the registry
rem ===========================================================================
rem JDK < 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Development Kit
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if defined JAVA_HOME (
   set HAVE_JDK=1
   goto checkJavaHome
)

rem ===========================================================================
rem JRE >= 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\JDK
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if defined JAVA_HOME (
   set HAVE_JRE=1
   goto checkJavaHome
)

rem ===========================================================================
rem JRE < 9 detection
rem ===========================================================================
set KeyName=HKEY_LOCAL_MACHINE\SOFTWARE\JavaSoft\Java Runtime Environment
set Cmd=reg query "%KeyName%" /s
for /f "tokens=2*" %%i in ('%Cmd% ^| find "JavaHome"') do (
	set JAVA_HOME=%%j
	set JAVA=%%j\bin\java
)
if defined JAVA_HOME (
   set HAVE_JRE=1
   goto checkJavaHome
)

rem ===========================================================================
rem Java path detection
rem ===========================================================================
rem as a last effort, try java in the path
for /f %%A in ("java.exe") do (
    set JAVA_BIN_DIR=%%~dp$PATH:A
    set JAVA=%%~dp$PATH:A\java
)
if defined JAVA_BIN_DIR (
   set JAVA_IN_PATH=1
   goto checkJavaHome
)

:checkJavaHome
if %USER_DEFINED_JAVA_HOME% == 1 (
    rem remove quotes around JAVA_HOME for consistency
    set JAVA_HOME=%JAVA_HOME:"=%
    echo.
    echo:Using user-defined JAVA_HOME: "!JAVA_HOME!"
    echo. 
    goto setJava
)

if %HAVE_JDK% == 1 (
    echo.
    echo:Using auto-detected JDK JAVA_HOME: "%JAVA_HOME%"
    echo.
    goto setJava
)

if %HAVE_JRE% == 1 (
    echo.
    echo:Using auto-detected JRE JAVA_HOME: "%JAVA_HOME%"
    echo.
    goto setJava
)

if %JAVA_IN_PATH% == 1 (
    echo.
    echo:Using Java installation detected in PATH variable at "%JAVA_BIN_DIR%"
    echo.
    goto setJava
)

rem if JAVA_HOME is unset, complain
if not defined JAVA_HOME (
    echo.
    echo:Error: could not find a Java JDK or JRE in your environment.
    echo.
    echo:If you do not have Java installed, please download and install the JDK.
    echo:If you do have Java installed, please set the JAVA_HOME environment
    echo:variable to the base directory of the JDK.
    echo.
    pause
    exit
)

:setJava
rem if JAVA_HOME environment var is set, look in there for the java binary - otherwise rely on the
rem PATH environment var
if not defined JAVA set JAVA=java
if defined JAVA_HOME set JAVA=%JAVA_HOME%\bin\java

%~D0 & CHDIR %~DP0

rem read in command line args
set ARGS=
:argLoop
if ""%1""=="""" goto endArgLoop
    set ARGS=%ARGS% %1
    shift
    goto argLoop
:endArgLoop

rem determine java version
for /f "tokens=3*" %%g in ('"%JAVA%" -version 2^>^&1 ^| findstr /i version') do (
    set JAVA_VERSION=%%g
)
set JAVA_VERSION=%JAVA_VERSION:"=%
set "JAVA_MAJOR_VERSION=%JAVA_VERSION:.=" &rem #%

rem JDK 9,10 don't ship with EE APIs such as javax.xml.bind: must pass a special flag, but 11 onwards, removed entirely
set JAVA_RUNTIME_ARGS=
if "%JAVA_MAJOR_VERSION%" == "9" (
    set JAVA_RUNTIME_ARGS=--add-modules=java.se.ee
)
if "%JAVA_MAJOR_VERSION%" == "10" (
    set JAVA_RUNTIME_ARGS=--add-modules=java.se.ee
)
if %JAVA_MAJOR_VERSION% GTR 15 (
    echo.
    echo:###############################################################################
    echo:## Java 16+ ^(you are using Java %JAVA_VERSION%^) requires special --add-opens
    echo:## arguments to use SmartClient Spring integration.  Automatically Adding.
    echo:###############################################################################
    echo.
    set JAVA_RUNTIME_ARGS=!JAVA_RUNTIME_ARGS! --add-opens java.base/java.io=ALL-UNNAMED
    set JAVA_RUNTIME_ARGS=!JAVA_RUNTIME_ARGS! --add-opens java.base/java.lang=ALL-UNNAMED
    set JAVA_RUNTIME_ARGS=!JAVA_RUNTIME_ARGS! --add-opens java.base/java.lang.reflect=ALL-UNNAMED
)

rem Remember (so we can restore) and set UTF8 codepage on console.  Note that you also need to set a font
rem contains UTF8 chars (most if not all TrueType fonts will work. E.g. "Lucida Console")
for /f "tokens=2 delims=:." %%x in ('chcp') do set DEFAULT_CODEPAGE=%%x
chcp 65001

rem install schema
call .\selenium\installSchema.bat smartgwtee.jar
rem run the tool
:execCommand
"%JAVA%" %JAVA_RUNTIME_ARGS% -Xmx192m   -cp selenium;lib\*;samples\showcase\war\WEB-INF\classes com.isomorphic.autotest.TestRunner  %ARGS%
if "%ERRORLEVEL%" == "5" goto execCommand

rem Restore original codepage. Technically this can fail to be called if the user
rem interrupts batch execution with Ctrl+C.  But given that these are not intended to be
rem production tools and the fact that in most cases failure to reset is innocuous, this should
rem be fine.
chcp %DEFAULT_CODEPAGE%

rem if there was an error or relevant output - allow the user to see it before the window
rem auto-closes
pause
