/*

  SmartClient Ajax RIA system
  Version v12.1p_2025-10-14/LGPL Deployment (2025-10-14)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//> @class DataSource
// A DataSource is data-provider-independent description of a set of objects
// that will be loaded, edited and saved within the user interface of your application.
// <P>
// Each DataSource consists of a list of +link{dataSource.fields,fields} that make up a
// DataSource <code>record</code>, along with +link{dataSourceField.type,field types}, 
// +link{dataSourceField.validators,validation rules}, 
// +link{dataSourceField.foreignKey,relationships} to other DataSources, and other
// metadata.
// <P>
// The abstract object description provided by a DataSource is easily mapped to a variety of
// backend object models and storage schemes.  The following table shows analogous terminology
// across systems.
// <table border=1 class="normal">
// <tr>
//   <td>Isomorphic SmartClient</td>
//   <td>Relational Database</td>
//   <td>Enterprise Java Beans (EJB)</td>
//   <td>Entity/Relationship Modeling</td>
//   <td>OO/UML</td>
//   <td>XML Schema/WSDL</td>
//   <td>LDAP</td>
// </tr><tr>
//   <td>DataSource</td>
//   <td>Table</td>
//   <td>EJB class</td>
//   <td>Entity</td>
//   <td>Class</td>
//   <td>Element Schema (ComplexType)</td>
//   <td>Objectclass</td>
// </tr><tr>
//   <td>Record</td>
//   <td>Row</td>
//   <td>EJB instance</td>
//   <td>Entity instance</td>
//   <td>Class instance/Object</td>
//   <td>Element instance (ComplexType)</td>
//   <td>Entry</td>
// </tr><tr>
//   <td>Field</td>
//   <td>Column</td>
//   <td>Property</td>
//   <td>Attribute</td>
//   <td>Property/Attribute</td>
//   <td>Attribute or Element (SimpleType)</td>
//   <td>Attribute</td>
// </tr></table>
// <P>
// DataSources can be +link{group:dataSourceDeclaration,declared} in either JavaScript or XML
// format, and can also be +link{group:metadataImport,imported} from existing metadata formats,
// including XML Schema.
// <P>
// <i>Data Binding</i> is the process by which
// +link{dataBoundComponent,Data Binding-capable UI components} can automatically configure
// themselves for viewing, editing and saving data described by DataSources.  DataBinding is
// covered in the +docTreeLink{QuickStartGuide,QuickStart Guide}, Chapter 6, <i>Data
// Binding</i>.
// <P>
// +link{group:clientServerIntegration,Data Integration} is the process by which a DataSource
// can be connected to server systems such as SQL DataBases, Java Object models, WSDL web
// services and other data providers.  Data Integration comes in two variants: client-side and
// server-side.  +link{group:serverDataIntegration,Server-side integration} uses the
// SmartClient Java-based server to connect to data represented by Java Objects or
// JDBC-accessible databases.  +link{group:clientDataIntegration,Client-side integration}
// connects SmartClient DataSources to XML, JSON or other formats accessible via HTTP.
// <P>
// DataSources have a concept of +link{group:dataSourceOperations,4 core operations} ("fetch",
// "add", "update" and "remove") that can be performed on the set of objects represented by a
// DataSource.  Once a DataSource has been integrated with your data store, databinding-capable 
// UI components can leverage the 4 core DataSource operations to provide many complete user
// interactions without the need to configure how each individual component loads and saves
// data.
// <P>
// These interactions include +link{listGrid,grid views}, +link{TreeGrid,tree views}, 
// +link{detailViewer,detail views}, +link{DynamicForm,form}-based 
// +link{dynamicForm.editRecord,editing} and +link{dynamicForm.saveData,saving},
// grid-based +link{listGrid.canEdit,editing} and +link{listGrid.saveByCell,saving},
// and custom interactions provided by +explorerExample{patternReuse} custom
// databinding-capable components.
// 
// @see interface:DataBoundComponent for information on DataBound Components
// @see group:dataSourceDeclaration for how to create DataSources
// @treeLocation Client Reference/Data Binding
// @serverDS allowed
// @visibility external
//<
isc.defineClass("DataSource");

//> @type DSOperationType
// One of the four basic operations that can be performed on DataSource data: "fetch",
// "add", "update", "remove".  Elsewhere called CRUD operations, where CRUD stands for
// "create", "retrieve", "update", "delete", which correspond to "add", "fetch", "update" and
// "remove" in SmartClient terminology.  See +link{group:dataSourceOperations} for a full
// description.
// <p>
// There are also additional, non-CRUD operations explained below.
//
//
// @value "fetch"        Fetch one or more records that match a set of search criteria.
// @value "add"          Store new records
// @value "update"       Update an existing record
// @value "remove"       Remove (delete) an existing record
// @value "custom"       perform some arbitrary custom logic that is not a CRUD operation.
//                       Format of the inputs and outputs is unconstrained, and the operation
//                       will be ignored for cache sync purposes by +link{ResultSet}s.  See 
//                       +link{DataSource.performCustomOperation()}.
// @value "validate"     Run server-side validation for "add" or "update" without actually
//                       adding or updating anything.  See +link{DataSource.validateData()}.
// @value "viewFile"     Retrieve a file stored in a binary field in a DataSource record, and
//                       allow the browser to choose whether to view it directly or prompt the
//                       user to save.  See +link{group:binaryFields}. 
// @value "downloadFile" Like "viewFile", but the HTTP header Content-Disposition is used to
//                       suggest that the browser show a save dialog.  See +link{group:binaryFields}. 
// @value "storeTestData" Takes a List of Maps and stores the data in Admin Console XML test
//                       data format
// @value "clientExport" Upload formatted client data and export it to Excel, XML and other 
//                       formats.  Used automatically by 
//                       +link{method:dataSource.exportClientData(),exportClientData()} 
//                       and cannot be used directly.  Usable only with the SmartClient server
//                       framework.
// @value "getFile"      Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.getFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "hasFile"      Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.hasFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "listFiles"    Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.listFiles()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "removeFile"   Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.removeFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "saveFile"     Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.saveFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "renameFile"   Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.renameFile()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "getFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.getFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "hasFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.hasFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "listFileVersions" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.listFileVersions()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
// @value "removeFileVersion" Use the DataSource as a +link{group:fileSource,source for files}.
//                       Used automatically by +link{DataSource.removeFileVersion()}, and
//                       would not normally be used directly. Usable only with
//                       the SmartClient server framework.
//
// @visibility external
//<

//> @object Record
// A Record is an ordinary JavaScript Object with properties that are treated as data to
// be displayed and edited by a +link{DataBoundComponent}. 
// <P>
// +link{DataBoundComponent}s have a concept of +link{dataBoundComponent.fields,named fields},
// where values for each field are found under the same-named property in a Record.
// <P>
// A Record is always an ordinary JavaScript Object regardless of how the record is 
// loaded (static data, java server, XML web service, etc), and so supports the
// normal behaviors of JavaScript Objects, including accessing and assigning to properties
// via dot notation:
// <pre>
//     var fieldValue = record.<i>fieldName</i>;
//     record.<i>fieldName</i> = newValue;
// </pre>
// <P>
// The concept of working with Records is common to all +link{DataBoundComponent}s, although
// individual DataBoundComponents may work with singular records (+link{DynamicForm}) or
// may work with lists (+link{ListGrid}), trees (+link{TreeGrid}), or cubes
// (+link{CubeGrid}) of records.
// <P>
// Individual DataComponents may also look for special properties on Records which
// control styling or behavior for those records, such as
// +link{listGrid.recordEditProperty,<code>record.canEdit</code>}.
// 
// @treeLocation Client Reference/Data Binding/DataSource
// @visibility external
//<

//> @groupDef dataSourceDeclaration
// DataSources can be specified in XML format, in which case the SmartClient server is used to
// load the DataSource, or DataSources can be programmatically created on the client.
// <P>
// Whether a DataSource is loaded via the SmartClient server or programmatically created
// client-side, identical requests will ultimately be submitted to the server.  However,
// DataSources defined in XML are loaded and used by the SmartClient Server, enabling many
// features including synchronized client-server validation, request bundling, file upload, and
// optional automatic SQL/JPA/Hibernate connectivity (see the 
// +link{group:iscServer,Server Summary} for details).
// <P>
// <smartclient>
// DataSources created on the client use the same style of creation as DataBound components:
// <pre>
//    isc.DataSource.create({
//        ID:"supplyItem",
//        fields:[
//            {name:"itemName", ... }
//            ...
//        ]
//    });
// </pre>
// </smartclient>
// <smartgwt>
// DataSources can be programmatically created on the client like so:
// <pre>
//    DataSource ds = new DataSource();
//    ds.setID("supplyItem");
//    DataSourceTextField nameField = new DataSourceTextField("itemName", "Name");
//    // create other fields
//    ds.setFields(nameField, ...);
// </pre>
// </smartgwt>
// Reference for all properties that can be set for DataSources, their fields and validators is
// given in the +link{class:DataSource} class reference.
// <P>
// DataSources defined in XML declare fields, validators and other settings using XML tags:
// <pre>
//     &lt;DataSource ID="supplyItem"&gt;
//         &lt;fields&gt;
//             &lt;field name="itemName" type="text" title="Item"/&gt;
//             &lt;field name="SKU"      type="text" title="SKU"&gt;
//                 &lt;validators&gt;
//                     &lt;validator type="integerRange" ... /&gt;
//                 &lt;/validators&gt;
//             &lt;/field&gt;
//         &lt;/fields&gt;
//     &lt;/DataSource&gt;
// </pre>
// DataSources defined in XML are loaded by using the <code>DataSourceLoader</code>
// servlet provided by the SmartClient Server.  This can be done as an ordinary HTML
// &lt;script&gt; tag as you application first loads:
// <pre>
//     &lt;SCRIPT SRC=isomorphic/DataSourceLoader?dataSource=supplyItem,employees,worldDS&gt;&lt;/SCRIPT&gt;
// </pre>
// .. or can be done on the fly via +link{DataSource.load()}.
// <P>
// Alternatively, in JSP environments, XML DataSources can be loaded via a special JSP tag
// supported by the SmartClient Server:
// <pre>
//     &lt;%&#64; taglib uri="/WEB-INF/iscTaglib.xml" prefix="isomorphic" %&gt;
//     ...
//     &lt;SCRIPT&gt;
//     &lt;isomorphic:loadDS ID="supplyItem"/&gt;
//     &lt;/SCRIPT&gt;
// </pre>
// <P>
// When loading an XML DataSource, by default, the ISC Server will look for a file named
// <code>&lt;dataSourceId&gt;.ds.xml</code> in the <code>/shared/ds</code> subdirectory under
// webroot.  The location of this directory can be changed, or individual DataSources can be
// placed in arbitrary locations.  For more information, see
// +link{group:server_properties,[webroot]/WEB-INF/classes/server.properties}.
// <P>
// XML DataSources can also be generated on the fly in case the entire DataSource or portions
// of it are based on dynamic data.  See the server API
// com.isomorphic.DataSource.addDynamicDSGenerator().
//
// @see class:DataSource
// @see group:loadDSTag
// @treeLocation Client Reference/Data Binding/DataSource
// @title Creating DataSources
// @visibility external
//<



//> @groupDef i18n
//
// <b><u>Internationalizing SmartClient Applications</u></b>
// <p>
// Internationalizing a SmartClient application involves creating locale-specific
// versions of all strings, images, and possibly colors.  In some cases, component layout may
// be affected as well (for example date field order differs between some locales).
// <p>
// <u><b>Character Encodings</b></u>
// <p>
// In order to deliver content in different languages to the browser and have it be displayed
// correctly, it is important that the browser and server agree on the character encoding being
// used to send the page.  
// <p>
// Generally speaking, you can use whatever character encoding you prefer, so long as
// you're consistent about serving your files to the browser with exactly the same encoding
// as was used to save the file to disk.  Keep in mind though that the character encoding you
// choose must be supported by all browsers you intend to support.  Isomorphic recommends that,
// where possible, you use the UTF-8 encoding.  Regardless of which character encoding you
// choose, keep in mind that for the browser to correctly display non-ASCII characters, you
// <b>must</b> explicitly set the character encoding of your page to match the encoding you
// used to save the file.  Browsers have built-in heuristics to guess the character encoding,
// but they can't be relied upon to work 100% of the time.
// <p>
// There are two ways to explicitly tell the browser what character
// encoding is being used for a given page.  One is to set the "Content-Type" HTTP header, for
// example:
// <pre>
// Content-Type: text/html; charset=UTF-8
// </pre>
// If you're using JSP on the back-end, you can set this header as follows:
// <pre>
// &lt;%@ page contentType="text/html; charset=UTF-8"%&gt;
// </pre>
// Or using Java Servlet APIs in a Servlet as follows:
// <pre>
// response.setContentType("text/html; charset=UTF-8");
// </pre>
// Note that the latter needs to be done before any content is written to the response output
// stream.
// <p>
// The other approach to setting the content encoding is to use an HTML META tag to embed it
// in the page itself (note that this applies to HTML documents only).  The META tag must go
// inside the &lt;HEAD&gt; HTML element - e.g. as follows:
// <pre>
// &lt;HEAD&gt;
// &lt;META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8"&gt;
// &lt;/HEAD&gt;
// </pre>
// In addition, for a .html or other static (non-.jsp) file, you must also ensure that the file
// itself is saved in UTF-8 encoding.  Advanced text editors (including the Eclipse IDE) can
// show you the encoding of a text file and allow you to change it.  In Eclipse this is in the
// Preferences area (search for "Encoding") and UTF-8 is <b>not the default</b> for .html
// files, and should be changed.
// <P>
// Isomorphic recommends that you follow <b>all</b> of the above approaches for maximum
// compatibility.  For example, if you omit the META tag approach, pages saved by the user
// using the browser save function may not render correctly when subsequently read from disk
// because HTTP headers are not available in that context.  Conversely, not providing the
// HTTP header or not saving the file in UTF-8 can result in application servers delivering the
// file in the encoding in which it is saved, or in their own default and incorrect content
// encoding.
// <p>
// If you're using a given character encoding pervasively in your pages, you can also configure
// your web server or application server to use that character encoding as the default for all
// pages of a given mime type or some other criteria (depending on the capability of your
// server) - for example on a per-directory basis.
// <p>
// For more information on character encodings, character sets, and working with HTML, please
// see W3C's tutorial here:
// +externalLink{http://www.w3.org/International/tutorials/tutorial-char-enc/}
// <p>
// <b>NOTE: Default Encoding</b>
// <p>
// As mentioned above, Isomorphic recommends the use of UTF-8 encoding.  However, it is 
// not possible to configure some servlet engines to do this by default.  Both Tomcat and Jetty 
// default to the ISO-8859-1 character set (commonly known as Latin-1), even if the Java VM 
// specifies a different encoding (the Tomcat documentation claims that this behavior is a 
// requirement of the Servlet specification).
// <p>
// To work around this, we change charset encoding to UTF-8 on every request/response that 
// goes through two core Isomorphic servlets: <code>IDACall</code> and <code>DataSourceLoader</code>.
// If you need to change this, you can do so by adding <code>init-param</code> settings to your
// <code>web.xml</code> file.  Please see the Javadocs for those two servlets for examples of 
// how to do this.
// <p>
// <u><b>Framework Message Localization</b></u>
// <p>
// SmartClient components include standard prompts and error messages in various cases, and all
// such messages support localization.
// <P>
// <smartclient>
// Language packs are included in the directory smartclientSDK/isomorphic/locales.  To load a
// language pack, simply include the desired locale via a
// standard HTML &lt;script src=&gt; tag, for example: 
// <pre>
//    &lt;SCRIPT SRC="isomorphic/locales/frameworkMessages_pt.properties"&gt;&lt;/SCRIPT&gt;
// </pre>
// .. to load the Portuguese locale. 
// <p>
// Alternatively can use the <code>locale</code> attribute on the <code>loadISC</code> or
// <code>loadModules</code> jsp tags:
// <pre>
//   &lt;isomorphic:loadISC skin="Enterprise" locale="pt"/&gt; 
// </pre>
// Or, if you have the +link{group:networkPerformance,Network Performance}, you can use the
// +link{FileLoader.loadLocale}/+link{FileLoader.cacheLocale} APIs:
// <pre>
//   isc.FileLoader.loadLocale("pt");
// </pre>
// <p>
// To see various locales, have a look at the 
// +explorerExample{changeLocales,Localization example}.
// </smartclient>
// <smartgwt>
// SmartGWT ships with pre-built language packs for many languages.  These are automatically 
// used by the framework: all you have to do is ensure that the appropriate locale has been
// set using one of the 
// <a href=https://developers.google.com/web-toolkit/doc/latest/DevGuideI18nLocale#LocaleSpecifying>standard GWT mechanisms</a>.
// In brief, either:<ul>
// <li>Add a meta tag to your bootstrap page: <code>&lt;meta name="gwt:property" content="locale=ja_JP"&gt;</code></li>
// <li>Specify the locale in a query parameter: <code>http://www.example.org/myapp.html?locale=fr_CA</code></li>
// </ul>
// </smartgwt>
// <P>
// If you find that the language pack you are using has any incorrect or missing translations,
// or you want to add a new language pack, please visit
// +externalLink{http://forums.smartclient.com/showthread.php?t=9987,this forums thread} for
// instructions on how to contribute translations so that they will be added to future
// SmartClient builds.
// <P>
// You can alternatively maintain your own private additions or overrides to the default
// language packs.
// <smartclient>
// A complete list of standard messages is presented +link{group:i18nMessages, here}.<br>
// To customize these messages, use +link{Class.addProperties()} or
// +link{Class.addClassProperties()} to override default values at the instance or class level
// respectively.  For example, the class property
// +link{classAttr:RPCManager.timeoutErrorMessage} is displayed to the user in a warning dialog
// when a SmartClient operation fails to complete.  This can be modified using the
// +link{Class.addClassProperties()} method, as follows:
// <pre>
// isc.RPCManager.addClassProperties({timeoutErrorMessage:"Custom Timeout Message"});
// </pre>
// </smartclient>
// <smartgwt>
// Use the standard GWT technique for selectively overriding Messages: create a
// subclass of <code>SmartGwtMessages</code> that overrides specific methods, and a 
// .properties file with your overridden messages.  Then create your overridden Messages
// instance and call <code>I18nUtil.initMessages()</code> with it.  For example:
// <pre>
//    public class CustomizedSgwtMessages extends com.smartgwt.client.i18n.SmartGwtMessages {
//       // override button_title
//       String button_title();
//    }
//   
//    // then in a new file CustomizedSgwtMessages.properties
//    button_title=My Title
//
//    // and in a new file CustomizedSgwtMessages_fr.properties
//    button_title=French translation
//
//    // then in your onModuleLoad() call
//    CustomizedSgwtMessages myMessages = GWT.create(CustomizedSgwtMessages);
//    I18nUtil.initMessages(myMessages);
// </pre>
// </smartgwt>
// <p>
// <u><b>Application Message Localization</b></u>
// <p>
// <smartclient>
// Text such as button titles typically appears in the middle of JavaScript code:
// <pre>
//     isc.Button.create({ title: "Click me!"});
// </pre>
// If you are on the Java platform and your JavaScript code appears in a .jsp, you can use the
// JSTL Core package (Java Server Pages Standard Tag Library) to replace that static "Click
// me!" text with a localized reference.  This can be done as follows:
// <pre>
//     &lt;%@ taglib prefix="fmt" uri="/WEB-INF/fmt.tld" %&gt;
//     &lt;SCRIPT&gt;
//     isc.Button.create({ title: &lt;fmt:message key="buttonTitle"&gt; });
//     &lt;/SCRIPT&gt;
// </pre>
// Assuming you've set the current Locale and provided a resource bundle with the relevant
// translated text, the above would create a button with a title that comes from the locale-specific
// bundle you provided.  For more information, see Sun's i18n tutorial:
// +externalLink{http://java.sun.com/docs/books/tutorial/i18n/} and the JSTL home page:
// +externalLink{http://java.sun.com/products/jsp/jstl/}.
// <P>
// Note that this approach does not imply that your JavaScript must appear in the midst of an
// HTML page.  A .jsp file can be used to return a pure JavaScript response via just removing
// the &lt;SCRIPT&gt; tags in the example above, and targetting the .jsp with a &lt;SCRIPT
// SRC=&gt; tag from another .jsp or .html file.
// <P>
// A second common technique is to load internationalized messages as a JavaScript Object
// mapping from a message name to the internationalized message.  For example, if your messages
// are stored in Java .properties format, you could load your .properties file as a standard Java
// +externalLink{http://docs.oracle.com/javase/6/docs/api/java/util/Properties.html,Properties object}, 
// and use the server-side com.isomorphic.js.JSTranslater.toJSVariable() API to output the
// properties as a JavaScript variable.
// <P>
// If the variable name chosen was 'i18nMessages', code to make use of the .properties data
// would look like:
// <pre>
//     isc.Button.create({ title: i18nMessages["buttonTitle"] });
// </pre>
// <P>
// Approaches for non-Java platforms are similar, and generally any approach that works for
// HTML or JavaScript files works with SmartClient.  See the end of this section for pointers
// to additional resources.
// </smartclient>
// <smartgwt>
// String localization in SmartGWT is best done using <a href=http://code.google.com/webtoolkit/doc/latest/DevGuideI18n.html>
// standard GWT approaches</a>.  Although GWT supports various ways of localizing strings, 
// Isomorphic recommends the use of an approach based on Resource Bundles.  Other parts of 
// SmartGWT - for example, <code>.ds.xml</code> files - are best localized using resource 
// bundles, so using resource bundles makes it easier to share messages that are used both
// client and server side.
// </smartgwt>
// <p>
// <u><b>Localizing Server-side Error Messages</b></u>
// <p>
// If you are providing error messages from server-side code, use standard Java techniques to
// determine the locale (<code>servletRequest.getLocale()</code>) and load ResourceBundles.
// Note that if you are using +link{validator.serverObject,DMI validation}, the
// HttpServletRequest is available via the standard +link{dmiOverview,DMI} approach: just
// declare it as an additional parameter, and it is provided.
// <p>
// <u><b>Support for Right-to-Left (RTL) languages</b></u>
// <p>
// SmartClient includes support for RTL languages.  To enable, simply set
// <code>dir="rtl"</code> on the HTML element:
// <pre>
//    &lt;HTML dir="rtl"&gt;
// </pre>
// ListGrid columns, horizontal layouts, scrolling directions, etc will reverse order
// automatically.
// <p>
// Because RTL in some cases requires additional media files, RTL is only supported for the
// Enterprise, EnterpriseBlue and Graphite skins.
// <p>
// <u><b>DataSource and Component XML localization</b></u>
// <p>
// Please see the separate article on 
// +link{group:dataSourceLocalization,DataSource and Component XML Localization}
// <p>
// <u><b>Localized Number and Currency Formatting</b></u>
// <p>
// Please see the separate article on 
// +link{group:localizedNumberFormatting,Localized Number Formatting}
// <p>
// <smartclient>
// <u><b>Image, CSS localization</b></u>
// <p>
// Most SmartClient components use a mixture of text, CSS and images to render.  If you wish to
// provide locale-specific images or use locale-specific CSS, you can create localized copies
// of a SmartClient skin named after the locale and modify images as you see fit.  A skin is
// specified at load time using either the <code>skin</code> attribute of the
// <code>&lt;isomorphic:loadISC&gt;</code> tag or by loading the skin
// directly using a script tag like so: &lt;SCRIPT SRC=/isomorphic/skins/[skin]/load_skin.js&gt;.
// If you're using the <code>loadISC</code> tag, you can specify a locale-specific skin like so:
// <pre>
// &lt;isomorphic:loadISC skin="[localeName]"/&gt;
// </pre>
// Or you can use a script tag like so:
// <pre>
// &lt;SCRIPT SRC=/isomorphic/skins/[localeName]/load_skin.js&gt;&lt;/SCRIPT&gt;
// </pre>
// Where the <code>[localeName]</code> is the name of the current locale - you'll have this in the
// current page context as you'll need it to use the JSTL &lt;fmt:setLocale&gt; tag.
// <p>
// </smartclient>
// Resources:
// <p>
// <b><u>Java</u></b>
// <ul>
// <li>Sun's i18n tutorial: +externalLink{http://java.sun.com/docs/books/tutorial/i18n/}
// <li>JSTL home page: +externalLink{http://java.sun.com/products/jsp/jstl/}
// <li>Apache JSTL "Getting Started": 
//     +externalLink{http://jakarta.apache.org/taglibs/doc/standard-doc/standard/GettingStarted.html}
// <li>Apache taglibs: +externalLink{http://jakarta.apache.org/taglibs/}
// </ul>
// <p>
//
// <b><u>.NET</u></b>
// <ul>
// <li>MSDN Developer Resource: "Developing World-Ready Applications":
// +externalLink{http://msdn.microsoft.com/library/default.asp?url=/library/en-us/cpguide/html/cpcondesigningglobalapplications.asp}
// </ul>
//
// <b><u>PHP</u></b>
// <ul>
// <li>PHP Gettext manual: +externalLink{http://us2.php.net/gettext}
// <li>O'Reilly Gettext tutorial: +externalLink{http://www.onlamp.com/pub/a/php/2002/06/13/php.html}
// </ul>
// <p>
//
// <b><u>Perl</u></b>
// <ul>
// <li>Perl, Unicode and i18n FAQ: +externalLink{http://rf.net/~james/perli18n.html}
// </ul>
// @treeLocation Concepts
// @title Internationalization and Localization
// @visibility external
//<





//> @groupDef dataSourceLocalization
// <smartclient>
// DataSources can be created in +link{group:dataSourceDeclaration,several ways}.
// DataSources created directly in JavaScript can be 
// internationalized via the techniques described in the main +link{group:i18n,i18n article}.
// </smartclient>
// DataSources which are declared in XML (.ds.xml files) and are read by the SmartClient 
// server, which are normally loaded <smartclient>into a .jsp page via the 
// <code>&lt;isomorphic:loadDS&gt;</code> JSP tag,</smartclient>
// <smartgwt>by the <code>DataSourceLoader</code> servlet,</smartgwt> can instead be 
// internationalized using an approach similar to the internationalization of JSP files with
// JSTL tags.  This approach is also supported for screens defined using 
// +link{group:componentXML,Component XML}.
// <p>
// <b>Note: </b>The tags we use for internationalizing SmartClient XML files look like 
// standard JSTL tags; this is intentional, simply because developers are familiar with JSTL.  
// However, the tags are being processed by SmartClient code, <b>not</b> JSTL, so only the 
// specific tags documented here are supported.
// <P>
// Given the following DataSource located in /shared/ds/supplyItem.ds.xml:
// <pre>
// &lt;DataSource ID="supplyItem"&gt;
//     &lt;fields&gt;
//         &lt;field name="itemName"&gt;
//             &lt;title&gt;Item Name&lt;/title&gt;
//             &lt;validators&gt;
//                 &lt;Validator type="lengthRange" max="40"&gt;
//                     &lt;errorMessage&gt;Must be 40 characters or less.&lt;/errorMessage&gt;
//                 &lt;/Validator&gt;
//             &lt;/validators&gt;
//         &lt;/field&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// To localize the title and validator error string of the <code>itemName</code> field, 
// change the DataSource definition as follows:
// <pre>
// &lt;DataSource ID="supplyItem" xmlns:fmt="WEB-INF/"&gt;
//     &lt;fields&gt;
//         &lt;field name="itemName"&gt;
//             &lt;title&gt;&lt;fmt:message key="itemTitle"/&gt;&lt;/title&gt;
//             &lt;validators&gt;
//                 &lt;Validator type="lengthRange" max="40"&gt;
//                     &lt;errorMessage&gt;&lt;fmt:message key="itemLengthRangeValidator"/&gt;&lt;/errorMessage&gt;
//                 &lt;/Validator&gt;
//             &lt;/validators&gt;
//         &lt;/field&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// This will cause SmartClient Server to look for a 
// <a href=http://docs.oracle.com/javase/8/docs/api/java/util/ResourceBundle.html#getBundle-java.lang.String-java.util.Locale->ResourceBundle</a> 
// called "supplyItem", containing keys "itemTitle" and "itemLengthRangeValidator", and 
// replace the <code>&lt;fmt:message&gt;</code> tags with the values from the resource bundle
// in the expected way.  It obtains the user's <code>Locale</code> from the servlet request, 
// but you can override this if you want to force an application-specific locale, regardless of 
// the user's operating system settings.  To do this, <smartclient> either specify
// a "locale" attribute in the &lt;loadDS&gt; tag, like this:<br>
// <code>&lt;loadDS ID="myDataSource" locale="es" /&gt;</code><p>
// or </smartclient> specify a "locale" parameter on HTTP requests to the <code>DataSourceLoader</code>
// and <code>IDACall</code> servlets (the latter is typically done via
// +link{RPCManager.actionURL}).
// <p>
// <smartclient> In both of these cases, the </smartclient>
// <smartgwt>The </smartgwt> locale parameter should be an underscore-separated string
// conforming to the rules described in 
// <a href=https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html>this article</a>
// on Java internationalization.  For example, "fr" (French language) or "en_US" (English 
// language, US location).
// <p>
// As mentioned, SmartClient Server will look for a <code>ResourceBundle</code> called 
// "supplyItem" in this case because it defaults to the name of the DataSource.  It is 
// possible to override this default at both the DataSource and field levels:
// <ul>
// <li>Specify <code>&lt;fmt:bundle&gt;</code> as a top-level DataSource tag, like this:<br>
// <pre>   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="supplyItem"&gt;
//      &lt;fmt:bundle basename="com.isomorphic.test.i18n" /&gt;
//      ...
// &lt;/DataSource&gt;</pre></li>
// <li>Specify the bundle name in the individual <code>&lt;fmt:message&gt;</code> tags, like this:<br>
// <pre>   &lt;title&gt;&lt;fmt:message key='title1' bundle="com.mycompany.MyProperties" /&gt;&lt;/title&gt;</pre></li>
// </ul>
// When you name a resource bundle manually like this, if you qualify the name it influences
// where we expect to find that resource bundle.  In the above example, we would look in the 
// <code>com.mycompany</code> package.  For unqualified names (including the default of the 
// DataSource name that we use in the absence of an override), we look in the so-called 
// "default package", which corresponds to the root of your classes directory or the root of 
// a .JAR file.
// <p>
// Note that the <code>xmlns:fmt</code> attribute in the DataSource definition is required by 
// the XML parser if you intend to use our <code>fmt:message</code> features.  However, the 
// actual value you use is unimportant as long as it is present.
// <p>
// Although these examples don't show it, note that it is also possible to internationalize
// DataSource-level values in the same way as field-level values - for example:<pre>
//   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt; 
//     &lt;title&gt;&lt;fmt:message key="dsTitle" /&gt;&lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
// <p>
// Any property on a DataSource or on a UI component that is documented to be of "String" type 
// or any derived type (such as "URL") supports the <code>fmt:message</code> tags.
// <p>
// Note that any amount of whitespace around &lt;fmt&gt; tag is ignored, unless there is also 
// some text, then whitespace becomes significant as well. A declaration like this one:
// <pre>
//   &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt; 
//     &lt;title&gt;
//         <b>Some text</b> &lt;fmt:message key="dsTitle" /&gt;
//     &lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
// .. will cause linefeed / carriage return characters to be embedded in your title as well as the 
// text. This can be useful in situations where you want to embed small amounts of static text in 
// a localized attribute, but most of the time, you will want the &lt;fmt&gt; tag on one line with the
// surrounding tag (eg "title").
// <p>
// If any HTML tags are needed around a &lt;fmt&gt; value, you can place them into the resource bundle 
// or use the <i>CDATA section</i> to escape them in the XML file:
// <pre>
//  &lt;DataSource  xmlns:fmt="WEB-INF/" ID="i18nTest"&gt; 
//     &lt;title&gt;<b>&lt;![CDATA[&lt;b&gt;]]&gt;</b>&lt;fmt:message key="dsTitle" /&gt;<b>&lt;![CDATA[&lt;/b&gt;]]&gt;</b>&lt;/title&gt;
//      ...
// &lt;/DataSource&gt;
// </pre>
// <h4>Unicode support</h4>
// The Java language insists that <code>.properties</code> files be encoded with ISO-8859-1 -
// in other words, that they be plain ASCII files.  This means that any non-ASCII characters 
// have to be escaped, like so: <b>\u1234</b>.  For languages like Russian or Japanese, that 
// are based on completely non-ASCII character sets, this obviously leads to 
// <code>.properties</code> files that are entirely escaped references, and are not 
// human-readable.  Although the <code>nativetoascii</code> tool is provided with Java to make 
// the creation of these escaped files less tedious, it is still inconvenient that this 
// "compilation step" is required.
// <p>
// SmartClient avoids the need for this when localizing DataSources and Component XML by 
// directly supporting <code>.properties</code> files encoded with UTF-8.  To make use of this:
// <ul>
// <li>Encode your <code>.properties</code> file with UTF-8, preferably without a BOM (Byte 
// Order Marker).  SmartClient Server will simply ignore the BOM in a <code>.properties</code> 
// file if it is present, but you may see odd behavior from other software if the BOM is 
// present in other types of file - for example, JSP snippets that are included in other pages.
// The BOM has no meaning in a UTF-8 file anyway, so we recommend just omitting it from all 
// your UTF-8 files (though note that doing this may confuse some editing software, 
// particularly on Windows)</li>
// <li>Encode your bootstrap file(s) in UTF-8 and set headers or meta tags to inform the
// browser that the file is UTF-8 encoded, as described in +link{group:i18n,this article}</li>
// <li>In your <code>&lt;fmt:bundle&gt;</code> tag, specify an <code>encoding</code> attribute.
// There are only two supported values for this attribute: "utf-8" and "iso-8859"</li>
// <li>You can also override the encoding in individual <code>&lt;fmt:message&gt;</code> tags,
// just like to can override the bundle to use.  Again, just specify an <code>encoding</code>
// attribute</li>
// <li>You can make UTF-8 encoding the global default by setting attribute
// <code>i18n.resourceBundle.parse.utf-8</code> to true in your <code>server.properties</code>
// file.  This prevents you from having to explicitly specify <code>encoding="utf-8"</code>
// in all your <code>.ds.xml</code> and <code>.ui.xml</code> files</li>
// <li>Note that <code>.properties</code> files are located and parsed by SmartClient framework
// code when <code>encoding="utf-8"</code> is in force.  Our parsing code only supports 
// the naming conventions explained in the article linked to above; specifically, it does not 
// support the additional "script" and "extension" elements introduced in Java 7.  File names
// must be of the form "basename_language_COUNTRY_VARIANT", where "COUNTRY" and "VARIANT" are
// optional.  Examples: "fr", "en_US", "en_GB_POSIX"</li>
// </ul>
// <h4>Component XML</h4>
// All of the above applies similarly for localizing screens defined using 
// +link{group:componentXML,Component XML}.  For example:<pre>
// &lt;isomorphicXML xmlns:fmt="WEB-INF/"&gt;
//   &lt;fmt:bundle basename="com.isomorphic.test.i18n.test" /&gt;
//   &lt;Window ID="testWin1"&gt;
//     &lt;title&gt;&lt;fmt:message key='title1' /&gt;&lt;/title&gt;
//   &lt;/Window&gt;
// &lt;/isomorphicXML&gt;
// </pre>
// Note the following differences between localizing <code>.ds.xml</code> (DataSource) files and
// localizing <code>.ui.xml</code> (component XML) files: <ul>
// <li>The <code>&lt;isomorphicXML&gt;</code> tag, which is ordinarily only used to wrap 
// multiple widget definitions to give a valid XML file, is required if you are using this 
// internationalization technique.</li>
// <li>Because there is no concept of an "ID" associated with a <code>.ui.xml</code> file, 
// there is no default bundle like there is with DataSource definitions.  Instead, you have to
// specify the bundle by hand, either by adding a <code>&lt;fmt:bundle&gt;</code> tag as an 
// immediate child of the <code>&lt;isomorphicXML&gt;</code> tag, or by specifying 
// <code>bundle</code> attributes in your individual <code>&lt;fmt:message&gt;</code> tags.</li>
// <li>Locale can be overridden, as described for DataSources above, by 
// specifying a "locale" parameter on HTTP requests to the <code>ScreenLoaderServlet</code> 
// (this is done for you when you pass a locale to the +link{RPCManager.loadScreen} method).</li>
// </ul>
// <h4>Custom localization provider support</h4>
// Custom localization providers can be configured for the entire framework or for specific 
// DataSource and Component XML instances based on their names. For more details see 
// javadoc for <code>com.isomorphic.util.LocaleMessageProviderRegistry</code> server-side API.
// <h4>Troubleshooting</h4>
// If something went wrong, we use fmt string as a value:
// <code>&lt;fmt:message key="message_key"&gt;</code>.
// Getting similar value instead of localized message means that either <code>bundle</code>
// could not be found or the <code>key</code> is incorrect, look for warnings in server logs
// for specific details.<br>
// 
// @treeLocation Concepts/Internationalization and Localization
// @title DataSource and Component XML Localization
// @visibility external
//<

//> @groupDef localizedNumberFormatting
//
// Use the special +link{dataSourceField.type,field types} "localeInt", "localeFloat" and
// "localeCurrency" to have locale-specific formatting applied to numeric values, as well as
// automatic parsing of user inputs that use locale-specific decimal and grouping separators.
// <p>
// <smartclient>
// These special types rely on the settings +link{numberUtil.decimalSymbol},
// +link{numberUtil.groupingSymbol} and +link{numberUtil.currencySymbol}.  These are normally
// set automatically when you load a language pack for the current locale.
// <p>
// See +link{group:i18n} for more background on internationalization and loading language packs
// for the current locale.
// </smartclient>
// <smartgwt>
// These special types automatically use GWT's NumberFormat logic, using the default locale.
// Additional +link{SimpleType,SimpleTypes} can be created that call GWT's NumberFormat if more
// variations are needed.
// <p>
// Note that language packs shipped with SmartGWT contain properties such as "decimalSymbol"
// that seemingly would control localized number formatting.  These are inactive for SmartGWT
// and should be ignored.
// <p>
// See +link{group:i18n} for more background on internationalization.
// </smartgwt>
//
// @title Localized Number Formatting
// @visibility external
//<

//> @groupDef featureExplorerOverview
//
// The +docTreeLink{FeatureExplorer, Feature Explorer} is an example shell designed to help you
// explore the capabilities of SmartClient.  Read on for a brief overview, including specific
// instructions for using the example code in your own standalone application.
// <p>
// The tree on the left of the Feature Explorer contains examples grouped by logical
// categories.  Selecting an example brings it up on the right side of the screen, inside a
// tabbed view.  The default "View" tab shows the interactive example itself, while other
// tabs show the underlying source.  The "JS" tab shows the source for the example.  There is
// sometimes also an "XML" tab that shows the corresponding version in 
// +link{componentXML, Component XML} format.  For databound examples, there are also
// frequently additional tabs that show the +link{dataSource, DataSources} associated with the
// example.
// <p>
// <b><u>How to create a standalone application using code from the Feature Explorer</u></b>
// <p>
// The Feature Explorer shell is designed to show many examples in one place and to enable
// experimentation by providing a way for you to modify example code and try out your changes.
// As a result, the Feature Explorer requires some basic server support and its examples omit
// the usual SmartClient module includes that have to be in place for using SmartClient
// components standalone.
// <p>
// If you'd like to use example code in your application to get started quickly, create a page
// with SmartClient includes and then take the code from the "JS" tab and place it between
// &lt;SCRIPT&gt; blocks as described +link{group:nonJavaBackend, here}.  If the example also
// includes a datasource, place the datasource definitions in the same file before the
// component code.  Note that DataSources (and components) written in XML require the optional
// SmartClient server.  If you're using the server, you can include them on your page using the 
// +link{group:loadDSTag} tag.
// <p>
// <b><u>Feature Explorer difference in the LGPL package</u></b>
// <p>
// The LGPL edition of SmartClient does not include the SmartClient Java Server as part of the
// licensed software, but a trimmed down server is included in the package to support the
// Feature Explorer shell.  There are some examples that use DataSources that would normally
// use the SmartClient server for persistence.  In the LGPL package, these DataSources are
// automatically turned into +link{group:clientOnlyDataSources, Client Only DataSources} and
// the Feature Explorer loads the data for these one-time from the dataURL or testFileName
// attributes specified on the DataSource.  Subsequent DataSource operations work against this
// client-side dataset, which is why changes to the data aren't permanent in these examples.
// <p>
// Check out the +link{clientServerIntegration, Client-Server Integration} overview topic for
// an overview of your DataBinding options.
//
// @title Feature Explorer Overview
// @visibility external
//<

//> @groupDef iscInstall
// Isomorphic currently recommends leveraging the +link{mavenSupport, support for Maven}, for
// those who are comfortable with it, as it dramatically simplifies initial installs,
// acquiring patched builds, and upgrading to new versions.
// <p>
// For those unable or unwilling to do so, however, this overview serves as a how-to for
// installing SmartClient into your web application.
// Evaluators are urged to use the SmartClient SDK with the embedded tomcat servlet engine
// during evaluation rather than pursue installation into an existing web application up front,
// however, reading this document and the related +link{group:clientServerIntegration,server
// integration} materials is recommended to get an overview.
// <P>
// SmartClient has two pieces - the client components that run in the browser and the server
// components that run in a J2SE-compatible container.  You don't need to use a Java back-end
// to use SmartClient, but the SDK comes with some examples that assume the presence of the
// Java back-end and, for some examples, a SQL Database.  If you will be using SmartClient with
// a Java back-end, see below for the list of J2SE application servers supported by the Java
// implementation of the SmartClient server.
// <p>
// The SDK contains two top-level directories: <code>smartclientSDK</code> and
// <code>smartclientRuntime</code>.  The <code>smartclientSDK</code> directory contains the
// embedded servlet engine, embedded database, examples, and documentation.  The
// <code>smartclientRuntime</code> directory contains just the client and server components of
// the SmartClient product - use the contents of this directory when deploying SmartClient into
// your application environment.
// <p>
// <u><b>Client integration</b></u>
// <p>
// To install the client-side portion of SmartClient, simply copy the <code>isomorphic</code>
// directory from the smartclientRuntime webroot to the webroot of your application.  Having
// done this you can use SmartClient components on your pages regardless of the technologies
// used on your back-end and you can bind to server-side componentry backed by arbitrary
// technology - see the <i>Data Integration</i> section of the
// +link{group:clientServerIntegration} section for more information.
// <p>
// <u><b>Server integration</b></u>
// <p>
// <span style='color:red'>Note:</span> Some of the instructions below ask you to copy files
// into the WEB-INF/classes folder.  If you're using an IDE such as Eclipse that attempts to
// manage the WEB-INF/classes folder, we recommend that you copy these files to the src/
// directory of your project (next to the top-level folder for your java namespace) such that
// your IDE auto-deploys them to the WEB-INF/classes folder.  We have seen cases of tools like
// Eclipse periodically deleting files that are checked into to WEB-INF/classes directly.
// <p>
// <ul>
// <li> Copy all files from the WEB-INF/lib directory of the smartclientRuntime to your
// WEB-INF/lib.  The set of libs in the smartclientRuntime/WEB-INF/lib folder is a minimal set;
// smartclient<b>SDK</b>/WEB-INF/lib contains all other .jars you might need, including third-party
// libraries bundled for convenience.  See
// +link{group:javaModuleDependencies,Java Module Dependencies} for details of the .JAR files that
// comprise the SmartClient Server, and their dependencies on various third-party libraries.
// Generally, if there are conflicts with the versions of third-party libraries you want to
// use, you can use the versions you want - SmartClient has minimal dependencies on these
// libraries. 
// <li> Copy the WEB-INF/classes/log4j.isc.config.xml from the smartclientRuntime to your
// WEB-INF/classes
// directory.  This file contains the SmartClient server log configuration.
// See +link{group:serverLogging} for information on server-side logging and how to configure it.
// <li> Copy the +link{group:server_properties,WEB-INF/classes/server.properties}
// from the smartclientRuntime to your WEB-INF/classes
// directory.  This file contains settings for basic file locations such the location of
// webroot, the SmartClient SQL engine and DMI.  The version under smartclientRuntime has a
// basic, secure configuration.  See the version of +link{group:server_properties,server.properties}
// under the smartclientSDK directory for sample SQL and other settings.
// <li> Copy the WEB-INF/iscTaglib.xml from the smartclientRuntime to your WEB-INF directory.
// This file enables the use of custom SmartClient tags in your JSPs.  
// <li> Merge portions of the WEB-INF/web.xml into your application's web.xml.  To use
// SmartClient JSP tags like &lt;loadISC&gt;, you'll need to merge the &lt;jsp-config&gt;
// section from web.xml.  Also there are some mandatory and optional servlets and filters to
// merge - see below.
// <li> <b>Power and Enterprise Editions only</b>.  Copy the shared/ds/batchUpload.ds.xml file
// to the same location in your target webapp directory.  This file is a utility DataSource
// that is used to provide the initial upload functionality of the +link{BatchUploader} 
// component - strictly speaking, you only need to perform this step if you intend to use that 
// component.
// </ul>
// <p>
// See +link{servletDetails,Core and Optional SmartClient servlets} for details of additional 
// changes you may need to make to your applications <code>web.xml</code> file.  See 
// +link{group:javaModuleDependencies,Java Module Dependencies} for details of the .JAR files that
// comprise the SmartClient Server, and their dependencies on various third-party libraries.
// <p>
// <u><b>Multiple Applications / WARs</b></u>
// <p>
// To integrate the server portion of SmartClient, you need to follow the steps below for each
// application (WAR) that uses SmartClient.  Note that, if installing into an environment that
// uses multiple WARs, installation of SmartClient JARs into a directory shared by multiple
// applications is not supported.  Installation of a separate WAR with client-side SmartClient
// modules for maintaining cache coherence across applications using the same version of ISC is
// supported - contact Isomorphic support for more details on how to set that up.
// <p>
// <u><b>Troubleshooting</b></u>
// <p>
// This section covers some common problems with possible solutions.  You may also need to refer to the
// documentation for your specific application server, web server, or database. If you experience any problems
// installing and configuring SmartClient in your environment, please post on the 
// <a href="http://forums.smartclient.com/" target='_blank'>SmartClient forums</a> for
// assistance.
// <p>
// <table width="90%" class="normal" align="center" border="1" cellpadding="5">
// <tr bgcolor="#808080">
// 	<td width="30%"><b>Problem</b></td>
// 	<td width="30%"><b>Possible Causes</b></td>
// 	<td width="40%"><b>Solution</b></td>
// </tr><tr>
// 	<td rowspan='3'>Browser displays a generic "page cannot be displayed" or "unable to locate the server" message.</td>
// 	<td>Servlet engine not started.</td>
// 	<td>Start your application server.</td>
// </tr><tr>
// 	<td>Missing/incorrect port for servlet engine in URL.</td>
// 	<td>Check the startup messages, logs, or documentation for the servlet engine to determine what port it is using.</td>
// </tr><tr>
// 	<td>Host name is incorrect.</td>
// 	<td>Check whether other pages on the host can be accessed.
// 		Try the base URL http://[host name]:[port number] to see whether the servlet engine or webserver is functioning.</td>
// </tr><tr>
// 	<td>Browser displays a 404 or other page/file not found error.</td>
// 	<td>Incorrect URL.</td>
// 	<td>Check for errors in the URL, including capitalization.</td>
// </tr><tr>
// 	<td>Server error: taglib not defined</td>
// 	<td>Missing iscTaglib.xml or iscTaglib.xml not referenced in web.xml</td>
// 	<td>Copy WEB-INF/iscTaglib.xml from smartclientRuntime to your deployment WEB-INF directory
// 	and make sure that you have merged the &lt;jsp-config&gt; section from the
// 	smartclientRuntime web.xml</td>
// </tr><tr>
//  <td>ClassNotFound or other Java Exceptions in the server log.</td>
//  <td>Missing JAR files</td>
//  <td>Verify every required .jar has been copied into the WEB-INF/lib directory of your
//  deployment.  Use +link{group:javaModuleDependencies,these docs} to double-check.  If in
//  doubt, copy every available .jar, verify this is working, then trim off .jars you are
//  definitely not using.</td>
// </tr><tr>
//  <td>"isc" is not defined JS error</td>
//  <td>Incorrect URLs to SmartClient modules</td>
//  <td>Use View Source to look at SCRIPT includes (e.g. for ISC_Core.js), try those URLs
//  directly in the browser to verify the files are correctly deployed</td>
// </tr>
// </table>
// <P>
// <u><b>Caching Considerations</b></u>
// <p>
// When upgrading from one SmartClient release to the next, you want to make sure that the user
// picks up the new version on next access, but you also want to keep the ISC modules cacheable
// so they're not refetched on every access.
// <p>
// SmartClient deals with this problem by appending a version string as a query parameter to
// each module load directive.  This is done by the &lt;isomorphic:loadISC&gt; and
// &lt;isomorphic:loadModules&gt; tags automatically.  As long as you make sure that the file
// that contains these tags is non-cacheable, you will get the desired behavior.
// <p>
// <u><b>Supported J2SE/J2EE Containers</b></u>
// <p>
// Below is the list of J2SE/J2EE containers that have been tested to be compatible with this
// version of SmartClient.  Installation in these containers is supported for deployment by
// Isomorphic.  If your application server is not on this list, please contact us at the
// <a href="http://forums.smartclient.com" target='_blank'>SmartClient forums</a> to see if we can support
// your deployment.  In general, the Java portion of ISC should work on servlet containers that
// comply with servlet specification version 2.3 and up and utilize a JVM no older than version
// 1.7.  Older, currently supported versions require Java 1.6, but support for even older JVMs
// may be possible via special
// <a href="https://www.smartclient.com/services/index.jsp#consulting">contract with Isomorphic</a>.
// <p>
// Supported J2SE/J2EE Containers:
// <p>
// <table class='normal'>
// <tr><td width=40></td><td width=400><i>Apache Tomcat 7.x, 8.x, 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>Apache Geronimo 2.x, 3.x</i></td><td></td></tr>
// <tr><td></td><td><i>Apache TomEE 7.x, 8.x</i></td><td></td></tr>
// <tr><td></td><td><i>Oracle WebLogic 11gR1 PSx, 12c Release x</i></td><td></td></tr>
// <tr><td></td><td><i>Caucho Resin 3.1.x, 4.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM WebSphere 8.x, 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM WebSphere Community Edition ${IBM_WebSphere_Community_Edition_versions}</i></td><td></td></tr>
// <tr><td></td><td><i>JBoss ${JBoss_versions}</i></td><td></td></tr>
// <tr><td></td><td><i>WildFly 8.x, 9.x, 10.x, 11.x, 12.x, 13.x, 14.x, 15.x, 16.x, 17.x, 18.x</i></td><td></td></tr>
// <tr><td></td><td><i>Mortbay Jetty 9.x</i></td><td></td></tr>
// <tr><td></td><td><i>Glassfish 4.x, 5.x</i></td><td></td></tr>
// </table>
//
// @treeLocation Concepts
// @title Deploying SmartClient
// @visibility external
//<



//> @groupDef sgwtEESetup
//
// <h3>Creating a new project from scratch</h3>
// <P>
// If you are starting a new project from scratch, we recommend starting with one of the sample
// projects included with SmartGWT EE under the "samples" directory.  Use the project that most
// closely matches your integration strategy and follow the instructions in the "readme" file
// within the sample directory.
// <P>
// <h3>Adding SmartGWT EE to an existing project</h3>
// <P>
// <B>Important:</b> If you have created a project using the GWT Plugin for Eclipse, a Maven archetype, or
// similar tool, first get rid of unused resources typically included in such "starter projects":
// <ul>
//   <li> from your [i]moduleName[/i].gwt.xml file, remove imports of any GWT themes, leaving
//        only the import of com.google.gwt.user.User.  Proper imports to add for SmartGWT
//        Pro/EE are shown below.
//   <li> get rid of any sample servlets or GWT-RPC services (delete both web.xml entries and
//        server-side source)
// </ul>
// <P>
// Now add SmartGWT EE: all of these steps are required.  <b>Do not skip steps or omit
// resources you think you may not need</b>.  Get a working project first, then think about
// trimming resources, as needed, once you understand the system.
// <P>
// In the steps below, copying from eg "war/WEB-INF/..." means copying from the "war"
// subdirectory of whichever sample project is closest to your desired integration strategy.
// <P>
// <ol>
// <li>Unless you're <a href="http://github.smartclient.com/isc-maven-plugin/">using Maven</a> 
//     to manage dependencies, you'll need to add all jars from the SmartGWT Pro/EE 
//     distribution (under smartgwtee-<i>version</i>/lib)
//     to your CLASSPATH.  You can copy the '.classpath' file from the appropriate sample
//     project for a working set of includes (it's in the same directory as the <i>war/</i>
//     folder). There are both client- and server-side jars, both kinds go in the classpath.
//     For server-side .jars, dependencies are documented +link{group:javaModuleDependencies,here}.
// <li>update your <i>modulename</i>.gwt.xml file with these imports:
//    <pre>
//    &lt;inherits name="com.smartgwtee.SmartGwtEE"/&gt;
//    &lt;inherits name="com.smartgwtee.tools.Tools"/&gt;
//    </pre>
//    <b>NOTE:</b> if you were previously using SmartGWT LGPL, <b>remove</b> the
//    &lt;inherit&gt; of 'com.smartgwt.SmartGWT' and ensure the &lt;inherit&gt; of
//    'com.smartgwt.tools.SmartGwtTools' appears <b>before</b> the imports above.  Also ensure
//    that all SmartGWT-related inherits appear *before* your &lt;entry-point&gt; declaration.
// <li> if you are using Optional Modules such as Analytics or RealtimeMessaging, see
//      +link{group:loadingOptionalModules} for additional inherits
// <li> Copy log4j.isc.config.xml across to the "src" dir of your project (it's
//      placed in the "src" dir as a means of getting it into the CLASSPATH).  This file is
//      either in the "src/" dir of a given sample project or in war/WEB-INF/classes.  This
//      enables default log4 categories for server-side logs appropriate for development.
//      See +link{group:serverLogging} for information on server-side logging and how to configure it.
// <li> Copy +link{group:server_properties,server.properties} across to the "src" dir of your project.
//      This file is either in the "src/" dir of a given sample project or in war/WEB-INF/classes.
//      This contains miscellaneous server settings - see the file itself for documentation.
//    <ul>
//       <li><b>server.properties contains server-side paths that contain the GWT module name</b>.
//           Replace the module name from the sample project (eg "builtinds") with the module
//           name of your actual GWT project 
//       <li> if you're using SQLDataSource, enter your JDBC settings (start with a
//            server.properties from a project that uses a database to see the required format for
//            settings)
//    </ul>
// <li> If you plan to use JPA, copy src/META-INF/persistence.xml into your src/META-INF directory.
//      This file will be copied into war/WEB-INF/classes/META-INF directory during build process.
//      Make sure you specify your entity classes in persistence.xml. If you change persistence unit
//      name you have to update "jpa.persistenceUnitName" property in 
//      +link{group:server_properties,server.properties} file. More
//      information on JPA configuration can be found in +link{group:jpaIntegration}.
// <li> merge web.xml, starting with the web.xml from the sample project that is closest to
//      your target application (under war/WEB-INF in the sample project).  The list of
//      servlets and what they do is documented +link{group:servletDetails,here}.  See the
//      server-side JavaDoc for further details on servlet APIs and override points.
// <li> Copy war/WEB-INF/iscTaglib.xml to your war/WEB-INF/iscTaglib.xml.  This is required for
//      JSP tags to work and used by tools such as Visual Builder.  Be sure you have also
//      copied the web.xml section that enables the taglib (&lt;jsp-config&gt; element) 
// <li> (SmartGWT Power or Enterprise only) If using the BatchUpload functionality, copy
//      war/ds/batchUpload.ds.xml from the Showcase sample project to the shared.datasources
//      directory you configured in +link{group:server_properties,server.properties}.
// </ol>
// <h4>Extra Step Required for GWT 2.8+</h4>
// If you're using GWT 2.8 or later, attempting to run SuperDevMode in Eclipse may lead to an
// exception being reported such as:<p><pre>
//     org.apache.xerces.parsers.XIncludeAwareParserConfiguration cannot be cast to 
//         org.apache.xerces.xni.parser.XMLParserConfiguration</code></pre><p>
// This is due to xerces classes being included in GWT 2.8+, in addition to being in the JRE.
// To solve, add the following extra VM arguments to either your launch configuration or JRE in
// Eclipse:
// <p><pre>
//     -Djavax.xml.parsers.SAXParserFactory=com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl
//     -Djavax.xml.parsers.DocumentBuilderFactory=com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl
// </pre><p>
// <u><b>Troubleshooting</b></u>
// <table width="90%" class="normal" align="center" border="1" cellpadding="5">
// <tr bgcolor="#808080">
// 	<td width="30%"><b>Problem</b></td>
// 	<td width="30%"><b>Possible Causes</b></td>
// 	<td width="40%"><b>Solution</b></td>
// </tr><tr>
//  <td>ClassNotFound or other Java Exceptions in the server log.</td>
//  <td>Missing JAR files</td>
//  <td>Verify every .jar from the smartgwtee-<i>version</i>/lib directory has been added to your CLASSPATH.
//  Although you might later be able to remove some .jars, for initial installation testing,
//  copy every .jar</td>
// </tr><tr>
// 	<td>Client-side error about attempting to use "iscServer" request without server installed</td>
// 	<td>Wrong imports in <i>moduleName</i>.gwt.xml</td>
// 	<td>See correct imports above, note <b>remove</b> com.smartgwt.SmartGWT import and be sure
//      imports are in the correct order</td>
// </tr><tr>
// 	<td>Client-side error about "$debox is not defined"</td>
// 	<td>Wrong order of imports in <i>moduleName</i>.gwt.xml</td>
// 	<td>Make sure all SmartGWT-related imports appear before &lt;entry-point&gt; in your
//      .gwt.xml file</td>
// </tr><tr>
// 	<td>Missing images or failure to load page</td>
// 	<td>Didn't set isomorphicDir in .html bootstrap file</td>
// 	<td>See step above for setting isomorphicDir</td>
// </tr><tr>
// 	<td>Server error: "adminConsole" app not found when launching tools such as Visual Builder</td>
// 	<td>Bad filesystem paths configured in +link{group:server_properties,server.properties}</td>
// 	<td>Correct paths in +link{group:server_properties,server.properties}.  
//      <b>NOTE</b> the samples include the GWT module
//      name in some settings, search and replace this value with your GWT module name</td>
// </tr><tr>
// 	<td>Server error: Can't find DataSource with ID <i>yourDataSourceID</i></td>
// 	<td>Bad filesystem paths in +link{group:server_properties,server.properties} or 
//      bad DataSource .ds.xml file</td>
// 	<td>Correct paths in +link{group:server_properties,server.properties} - search for 
//      "project.datasources".  Also check that
//      the DataSource ID you are using matches the "ID" attribute in the .ds.xml file (NOTE:
//      ID attribute is uppercase "ID" not "id") and that the file is named
//      <i>dataSourceId</i>.ds.xml.  DataSource IDs are <b>case sensitive</b>, including the
//      file name.  For more in-depth troubleshooting steps, see 
//      +link{http://forums.smartclient.com/showthread.php?t=8159#aDSLoad,this FAQ answer}.</td>
// </tr><tr>
// 	<td>Server error: taglib not defined</td>
// 	<td>Missing iscTaglib.xml or iscTaglib.xml not referenced in web.xml</td>
// 	<td>See step above about iscTaglib.xml and web.xml entry</td>
// </tr><tr>
// 	<td>Server unable to load builtinTypes.xml as it starts up, possibly hitting a 
//      NullPointerException</td>
// 	<td>Modules have been added to your GWT project (.gwt.xml) but you haven't run
//      another GWT compile</td>
// 	<td>GWT compile your project again</td>
// </tr>
// </table>
// <P>
// For further troubleshooting steps, see
// +externalLink{http://forums.smartclient.com/showthread.php?t=8159,the SmartGWT FAQ} and, if
// still stuck, try posting in the Forums. <B>NOTE:</B> gather all the information indicated in
// the FAQ before posting.
// <p>
// <b>NOTE:</b>  It is possible to create a server-only SmartGWT EE project that will run 
// standalone (ie, not inside a servlet container or application server).  Please see
// +link{groupDef:standaloneDataSourceUsage,Standalone DataSource Usage} for details.
// 
// @title Smart GWT Pro/EE Project Setup & Deployment
// @visibility sgwt
//<

//> @groupDef server_properties
//
// The <code>server.properties</code> file is a configuration file read by the SmartClient
// server. It contains miscellaneous server settings - see the file itself for documentation 
// and default or sample settings.
// <P>
// Note that this is a standard Java Properties file, except it allows variable substitution
// from other properties defined earlier in the file.
// <P>
// It's loaded from the <code>CLASSPATH</code>, so it can be anywhere in the 
// <code>CLASSPATH</code>, but is typically either in the projects java "src" directory or
// in <code>WEB-INF/classes</code>.
// <P>
// Server side code can access and modify the properties specified in this file via the
// <code>com.isomorphic.base.Config</code> class
//
// @visibility external
// @title <code>server.properties</code> file
// @treeLocation Concepts/Deploying SmartClient
//<

//> @groupDef servletDetails
// 
// The following is a description of the servlets and filters you'll find in the web.xml file
// contained in the smartclientRuntime and what they do:
// <p>
// <i>Core Functionality</i>
// <ul>
// <li>Init servlet - see the article on +link{group:serverInit,SmartClient Server Initialization}</li>
// <li>IDACall servlet - <b>required</b> for +link{group:dmiOverview,DMI}, built-in RPC operations and built-in DataSource
// operations to work.  All databound examples in the SDK use this servlet.  If you're planning on
// using a custom actionURL for all your RPC requests, then you don't need this servlet.
// <li>FileDownload servlet - required for serving the Isomorphic framework code compressed and with
// caching headers as well as for serving skin images with caching headers.  It is highly
// recommended that you use this for production but is not required. 
// <li>PreCache servlet - loads resources into memory on container startup.  Not required, but if you
// exclude this servlet there may be a slow response to the very first request.
// <li>jsp-config section - the iscTaglib registration block is required to use
// &lt;isomorphic&gt; tags, and the *.isc and *.rpc mappings.  These are optional, if you want
// to use these as handy development tools.
// </ul>
// <p>
// <i>Optional Functionality</i>
// <ul>
// <li>RESTHandler servlet - handles SmartClient Server DataSource operations issued by 
// REST clients: it's like IDACall, but for the REST protocol.  Typically,  the clients
// of this servlet would not be ordinary SmartClient/SmartGWT applications (though they 
// could be), but other client technologies that need to access SmartClient DataSource 
// operations as reusable services.  If you do not plan to connect to the server using the
// REST protocol, then you don't need this servlet.
// <li>AxisServlet - exposes all DataSource operations via a WSDL service described by 
// SmartClientOperations.wsdl.  This is effectively the same as the RESTHandler servlet, but 
// for SOAP clients.  If you do not plan to connect to the server using webservice protocols,
// then you don't need this servlet.
// <li>HttpProxy - used by the RPCManager when sending AJAX RPCs to a server other than the
// server that serves the main application page.  You need to install this servlet if, for
// example, your application will be querying web services exposed by servers other than the
// server that is serving the rest of the application.  See the javadoc for this servlet for
// various configuration options, such as how to restrict the URLs that are allowed to be
// proxied. 
// <li>MessagingServlet - used by the realtime messaging system.  If you're planning
// on using this subsystem, you'll need this servlet.
// <li>CompressionFilter - required if you want to use dynamic compression of html and js
// files.
// <li>JSSyntaxScannerFilter - development tool that looks for trailing commas in JS
// source (scans html files for &lt;script&gt; tags and scans .js files in their entirety).
// This is a useful development tool, but should not be included in production.
// <li>NoCacheFilter - development tool that makes any content it intercepts non-cacheable in
// order to ensure developers are looking at the latest version of a file when modifying
// examples.  Not for production use.
// <li>DataSourceLoader - a servlet that returns the definition of one or more DataSources in
// JavaScript notation.  This servlet is provided as an alternative to using the 
// <code>&lt;isomorphic:loadDS&gt;</code> JSP tag, and is particularly suitable in environments
// where JSP tags can't be used for some reason (such as with SmartGWT).  See 
// +link{group:dataSourceDeclaration,Creating DataSources} for more details.
// <li>ScreenLoaderServlet - a servlet that returns the definition of one or more screens in
// JavaScript notation. 
// Can be invoked using a traditional HTTP GET, the +link{group:loadUITag,loadUI JSP tag},
// or the +link{rpcManager.loadScreen} function.</li>
// <li>ProjectLoaderServlet - returns a JavaScript fragment that when executed loads a named project
// and +link{rpcManager.cacheScreens,caches} all (or a specified subset) of its screens up-front.
// Can be invoked using a traditional HTTP GET, or the +link{rpcManager.loadProject} function.
// Refer to +serverDocLink{com.isomorphic.servlet.ProjectLoaderServlet,javadoc}  for parameter names 
// and their meanings.
// </li>
// </ul>
// Note that not all of the servlets and filters listed under <i>Optional Functionality</i>
// above are present in the web.xml that ships with the smartclientRuntime - if you need to use
// any of these, copy their configuration from the web.xml available under the WEB-INF
// directory of smartclientSDK.  Other servlets, filters and configuration files from the
// smartclientSDK should not be copied to your deployment, simply because the SDK includes many
// developer tools that are not extensively audited from a security standpoint.
//
// @treeLocation Concepts/Deploying SmartClient
// @title The Core and Optional SmartClient servlets
// @visibility external
//<


//> @groupDef serverInit
// 
// The SmartClient Server framework must be initialized from its config files at startup
// time, before user code invokes <em>any</em> framework functionality.  If you are running
// standalone (ie, outside of a servlet container), you should call the static utility method 
// <code>ISCInit.go()</code> early in your bootstrap code (eg, from the top of your 
// <code>main()</code> method).
// <p>
// If you are running inside a servlet engine, install the following listener in your web.xml.
// Ideally this should be the first listener registered in web.xml because part of the init
// logic exports database connections configured via server.properties via JNDI for consumption
// by other frameworks (Spring, Hibernate, etc).  See also below for other rationale related to
// Spring.
// <ul>
// <li>Install <code>InitListener</code>, which is a <code>ServletContextListener</code>:<br>
// <pre>   &lt;listener&gt;
//        &lt;listener-class&gt;com.isomorphic.base.InitListener&lt;/listener-class&gt;
//    &lt;/listener&gt;</pre></li>
// </ul>
// <p>
// <h4>Interaction with Spring initialization</h4>
// The Spring framework attempts to initialize itself in similar ways to the SmartClient
// framework, and similarly it wants its own initialization to be the very first thing that 
// happens.  This can cause problems in certain cases.  For example, one known problem occurs
// when you define DataSource instances as Spring beans, and Spring gets to initialize itself 
// first: it attempts to instantiate a instance of the bean, which ultimately calls into 
// our framework code before the framework has been initialized.
// <p>
// The solution to this is to use the <code>InitListener</code>, and to ensure that it is 
// declared in your <code>web.xml</code> file before the Spring
// <code>ContextLoaderListener</code>.  The Servlet 2.3 spec states (SRV.10.3.3):<p>
// <em>&nbsp;&nbsp;"During Web application execution, listeners are invoked in the order of their 
// registration."</em>
// <p>
// Therefore, declaring the SmartClient listener before the Spring one ensures that
// things run in the correct order in Servlet 2.4-compatible containers, and in those Servlet
// 2.3 containers that enforce the rule of running listeners before initializing filters or
// servlets.
//
// @treeLocation Concepts/Deploying SmartClient
// @title Server Framework Initialization
// @visibility external
//<





//> @groupDef reifyMaven
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt> 
// +link{group:mavenSupport, support for Maven} includes the ability to 
// +externalLink{http://github.smartclient.com/isc-maven-plugin/reify-import-mojo.html, import}
// (and optionally, 
// +externalLink{http://github.smartclient.com/isc-maven-plugin/reify-validate-mojo.html, verify}
// ) assets from +externalLink{http://reify.com, reify.com} into your project either on-demand 
// or during your build process.  Using the 
// +externalLink{http://github.smartclient.com/isc-maven-plugin/examples/configuration.html, example configuration}, 
// the import command might look something like the following:
// <p>
// <pre>
//   mvn com.isomorphic:isc-maven-plugin:1.4.5:reify-import -Pisc
// </pre>
// <strong>Important:</strong> This flow is unidirectional.  That is, whatever changes are to 
// be made to these resources should be made using the collaborative Reify environment and then
// re-imported.  There is, by design, no reason to modify them locally, and the plugin takes
// steps to notify you when that happens.
// Refer to the +link{group:reifyForDevelopers, Reify for Developers} documentation topic for 
// further discussion.
// 
// @treeLocation Concepts
// @title Importing from Reify
// @visibility external
//<

//> @groupDef mavenSupport
// <smartclient>SmartClient</smartclient><smartgwt>SmartGWT</smartgwt> artifacts are not 
// published to any public repository, but a POM for each is included in the SDK, and can be 
// used to install them to your own private Maven repository.  The official
// +externalLink{http://github.smartclient.com/isc-maven-plugin/,Isomorphic plugin for Maven} 
// contains a handful of targets intended to simplify that process through automation.  Please
// refer to the plugin's documentation for usage and examples.
// <p />
// For a complete listing of artifacts installed in your environment, consult your repository
// manager.  Where no repository manager is in use, a directory listing can often provide all 
// the detail you need.  Once you've made an artifact available to your build, you can use it 
// just like you'd use any other dependency.
// <smartclient> 
// <p />
// That said, typical installations of the current build will include the artifacts documented 
// <a target="_blank" href="./mavendoc/maven-usage.html">here</a>, where coordinates in most 
// cases will vary slightly by date and license.  A sample configuration using a few artifacts
// from an eval build released on November 14, 2016 follows:
// <p/>
// 
// <pre>
// &lt;?xml version="1.0" encoding="UTF-8"?&gt;
// &lt;project  xmlns="http://maven.apache.org/POM/4.0.0" 
//              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//              xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd"&gt;
// 
//      &lt;modelVersion&gt;4.0.0&lt;/modelVersion&gt;
// 
//      &lt;groupId&gt;com.isomorphic.smartclient.samples&lt;/groupId&gt;
//      &lt;artifactId&gt;component-databinding&lt;/artifactId&gt;
//      &lt;version&gt;1.0.0&lt;/version&gt;
//      &lt;packaging&gt;war&lt;/packaging&gt;
// 
//      &lt;dependencies&gt;
// 
//          &lt;!-- The SmartClient Evaluation edition --&gt;
//          &lt;dependency&gt;
//              &lt;groupId&gt;com.isomorphic.smartclient.eval&lt;/groupId&gt;
//              &lt;artifactId&gt;smartclient-eval&lt;/artifactId&gt;
//              &lt;version&gt;11.0-p20161114&lt;/version&gt;
//              &lt;type&gt;pom&lt;/type&gt;
//          &lt;/dependency&gt;
// 
//          &lt;!-- Use SQLDataSources --&gt;
//          &lt;dependency&gt;
//              &lt;groupId&gt;com.isomorphic.smartclient.eval&lt;/groupId&gt;
//              &lt;artifactId&gt;isomorphic-sql&lt;/artifactId&gt;
//              &lt;version&gt;11.0-p20161114&lt;/version&gt;
//          &lt;/dependency&gt;
//
//      &lt;/dependencies&gt;
// &lt;/project&gt;
// </pre></smartclient>
//
// <smartgwt>
// <p/>
// Following execution of the plugin's install or deploy goal, your Maven repository will 
// include a handful of archetypes meant to jump start development with the SmartGWT framework.
// Most users will want to start new projects with either the 
// <b>archetype-smartgwt-quickstart</b> or <b>archetype-smartgwt-quickstart-relogin</b> 
// archetypes.  To generate a new project based on the former:
// 
// <ol>
// <li><a href="https://maven.apache.org/install.html">Install Maven</a>, if necessary.</li>
// 
// <li>Install SmartGWT, if necessary.
// <pre>
// mvn com.isomorphic:isc-maven-plugin:1.4.5:install \
//    -Dproduct=SMARTGWT -Dlicense=EVAL -DbuildNumber=12.1p
// </pre>
// </li>
// 
// <li>
// Generate a project (using LATEST as below, or the version installed for you in step 2)
// <pre>
//  mvn archetype:generate \
//    -DartifactId=my-application \
//    -Dmodule=MyApplication -Dmodule-short-name=myapp \
//    -DgroupId=com.example -Dpackage=com.example.myapplication \
//    -DarchetypeGroupId=com.isomorphic.archetype \
//    -DarchetypeArtifactId=archetype-smartgwt-quickstart \
//    -DarchetypeVersion=LATEST -DinteractiveMode=false
// </pre>
// </li>
// </ol>
// 
// and refer to the README in the new 'my-application' directory for further instructions 
// around usage in Maven, Ant, and Eclipse environments.
// <p/>
// To generate a project from any of the following archetypes, provide its artifactId to the 
// above command's archetypeArtifactId parameter:
// <p/>
// <ul>  
//   <li><b>archetype-smartgwt-quickstart</b>: 
//       The recommended approach for most applications, using data access / databinding with 
//       "sql" datasources
//   </li> 
//   <li><b>archetype-smartgwt-quickstart-relogin</b>: 
//       Like archetype-smartgwt-quickstart, but includes integration with Spring 
//       Security to illustrate the +link{group:relogin,relogin} pattern.
//   </li>
//   <p/>
//   <li><b>archetype-smartgwt-example-builtinds</b>:
//       Illustrates how a single databound component can be used (and re-used) with many 
//       datasources
//   </li>
//   <li><b>archetype-smartgwt-example-customds</b>:
//       Illustrates setting up a DataSource accessing a servlet front controller (for example 
//       Struts or Spring MVC controller) for the various DataSource operations
//   </li>
//   <li><b>archetype-smartgwt-example-dsdmi</b>: 
//       llustrates setting up a DataSource that calls methods on your configured server bean 
//       in response to DataSource operations (fetch, add, update, remove)
//   </li>
//   <li><b>archetype-smartgwt-example-dshibernate</b>: 
//       llustrates the use of "hibernate" datasources in 'beanless mode'
//   </li>
//   <li><b>archetype-smartgwt-example-dshibernatederived</b>: 
//       This example illustrates the use of "hibernate" datasources with 'autoDeriveSchema' 
//       to inherit fields from a Hibernate mapping or bean
//   </li>
//   <li><b>archetype-smartgwt-example-dsjpa</b>: 
//       llustrates the use of JPA DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-gae</b>: 
//       llustrates an approach to running a SmartGWT application on the Google App Engine 
//       standard environment using SQL DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-gaedatastore</b>: 
//       llustrates an approach to running a SmartGWT application on the Google App Engine 
//       standard environment using Google Cloud Datastore as a _limited_ JPA DataSource
//   </li>
//   <li><b>archetype-smartgwt-example-gaejpa</b>: 
//       llustrates an approach to running a SmartGWT application on the Google App Engine 
//       standard environment using JPA DataSources
//   </li>
//   <li><b>archetype-smartgwt-example-manualhibernate</b>: 
//       llustrates setting up a DataSource that accesses your servlet controller, using 
//       Hibernate to process the requests manually via a Spring MVC Controller class 
//       (not recommended)
//   </li>
//   <li><b>archetype-smartgwt-example-restserver</b>: 
//       llustrates use of the SmartClient +link{group:servletDetails,RESTHandler servlet} to 
//       easily provide data access to clients other than SmartClient / SmartGWT (mobile, 
//       Swing, native, etc).
//   </li>
//   <li><b>archetype-smartgwt-example-spring-hibernate3-dmi</b>: 
//       llustrates a DataSource accessing a Spring bean using Direct Method Invocation (DMI), 
//       which then services the request manually via Hibernate.
//   </li>
// </ul>
//
// </smartgwt>
// <smartclient>
// <p/>
// Following execution of the plugin's install or deploy goal, its
// +externalLink{http://github.smartclient.com/isc-maven-plugin/install-mojo.html#workdir, working directory}
// will contain a copy of the SDK that you can use to view doc and samples locally.
// Your Maven repository will also
// include a handful of archetypes meant to jump start development with the SmartClient 
// framework.  Most users will want to start new projects with either the 
// <b>archetype-smartclient-quickstart</b> or 
// <b>archetype-smartclient-quickstart-relogin</b> archetypes.  To generate a new project
// based on the former:
// 
// <ol>
// <li><a href="https://maven.apache.org/install.html">Install Maven</a>, if necessary.</li>
// 
// <li>Install SmartClient, if necessary.
// <pre>
// mvn com.isomorphic:isc-maven-plugin:1.4.5:install \
//    -Dproduct=SMARTCLIENT -Dlicense=EVAL -DbuildNumber=12.1p
// </pre>
// </li>
// 
// <li>
// Generate a project (using LATEST as below, or the version installed for you in step 2)
// <pre>
//  mvn archetype:generate \
//    -DartifactId=my-application \
//    -Dmodule=MyApplication -Dmodule-short-name=myapp \
//    -DgroupId=com.example -Dpackage=com.example.myapplication \
//    -DarchetypeGroupId=com.isomorphic.archetype \
//    -DarchetypeArtifactId=archetype-smartclient-quickstart \
//    -DarchetypeVersion=LATEST -DinteractiveMode=false
// </pre>
// </li>
// </ol>
// 
// and refer to the README in the new 'my-application' directory for further instructions 
// around usage in Maven, Ant, and Eclipse environments.
// <p/>
// To generate a project from any of the following archetypes, provide its artifactId to the 
// above command's archetypeArtifactId parameter:
// <p/>
// <ul>  
//   <li><b>archetype-smartclient-quickstart</b>: 
//       The recommended approach for most applications, using data access / databinding with 
//       "sql" datasources
//   </li> 
//   <li><b>archetype-smartclient-quickstart-relogin</b>: 
//       Like archetype-smartclient-quickstart, but includes integration with 
//       Spring Security to illustrate the +link{group:relogin,relogin} pattern.
//   </li>
// </ul>
//
// </smartclient>
//
// @treeLocation Concepts/Deploying SmartClient
// @title Maven Support
// @visibility external
//<

//> @groupDef javaModuleDependencies
// +link{group:mavenSupport,Maven} users should generally refer to the POMs bundled with the 
// SDK, and installed for them by the official 
// +externalLink{http://github.smartclient.com/isc-maven-plugin/,Isomorphic plugin for Maven}. 
// For others,  the following is a short description of the functionality contained in each 
// SmartClient server JAR, and a link to the documentation listing its dependencies.  Please 
// refer to that documentation for more detail on the dependency graph, including version 
// numbers, transitive dependencies, and licensing.
// <P>
// Note that if you are using GWT, GWT itself also has an Apache 2.0 license, however tools and
// test environments that you may use during development have different license (such as
// Eclipse - Eclipse Public License).  Also, specific GWT widgets, not required by Smart GWT, 
// have licenses different from core GWT (such as JFreeChart's LGPL license).  See 
// +externalLink{http://code.google.com/webtoolkit/terms.html,Google's summary of terms} for
// details.
// 
// <style>
//   .jmd-module  {
//     width: 140px;
//     text-align: right;
//     vertical-align: top;
//     padding-right: 10px;
//   }
//   .jmd-optional  {
//     text-decoration: underline;
//     margin-top: 10px; margin-bottom: 8px;
//   }
// </style>
// 
// <table width="100%" >
//   <tr>
//     <td class="jmd-module">
//       <a target="_blank" href="./mavendoc/isomorphic-core-rpc.html">isomorphic_core_rpc</a>
//     </td>
//     <td>      
//       This is the core SmartClient module.  It provides the RPC, DMI, and DataSource
//       support. Please note that both commons-collections-3.x and commons-collections4-4.x 
//       are required and safe to include side by side in the CLASSPATH (different third party 
//       libs rely on one or the other).  The same is true of commons-lang and commons-lang3.
//       <div class="jmd-optional">
//         Optional Dependencies
//       </div>
//       <ul>
//         <li><i>freemarker</i>
//              - if you're using the built-in support for REST via the
//                +link{group:servletDetails,RESTHandler servlet} servlet
//         <li><i>isomorphic_js_parser</i> 
//              - if you're using the built-in support for REST via the 
//                +link{group:servletDetails,RESTHandler servlet} servlet with JSON payloads
//         <li><i>xercesImpl</i> 
//              - if you're using JDK &lt; 1.5
//         <li><i>javax.mail</i> 
//              - if you plan to use the Mail messaging feature
//         <li><i>javax.persistence</i> 
//              - if you plan to use the metadata-from-annotations feature.  Note that if you 
//                are using JPA, or a recent version of Hibernate, then you are probably 
//                already using this library.
//         <li><i>poi </i> 
//              - if you plan to export datasets in Microsoft Excel 97 (xls) or 2007 (xlsx) 
//                formats.  
//         <li><i>poi-ooxml</i> 
//              - also needed if you plan to export data in Excel 2007 (xlsx) format
//         <li><i>isomorphic_contentexport</i> 
//              - if you plan to export to PDF format
//         <li><i>isomorphic_jpa</i> 
//              - if you plan to use BatchDS Generator (even if you are not using JPA, 
//                although the generated DataSources will not require JPA at runtime if you 
//                are not using JPA).
//         <li><i>log4j</i> 
//              - if you plan to use log4j logging (used by default)
//         <li><i>slf4j-log4j12</i> 
//              - if you plan to use slf4j with log4j (for example), or any other slf4j bridge 
//                library depending on which logging framework will be used.  See 
//                +link{group:serverLogging} for information on server-side logging and how to 
//                configure it.
//         <li><i>groovy</i> 
//              - if you plan to use Groovy with the +link{group:serverScript} feature.  
//                Note, we also recommend that you use Groovy as the evaluation engine if you 
//                intend to use Java as an inline scripting language.  
//                See the "Server Scripting" documentation.
//         <li><i>commons-digester and commons-beanutils</i> 
//              - if you plan to use Velocity Tools.
//        </ul>
//      </td>
//   </tr>  
//   <tr>
//     <td class="jmd-module"><a target="_blank" 
//         href="./mavendoc/isomorphic-contentexport.html">isomorphic_contentexport</a>
//     </td>
//     <td>
//       Provides support for PDF Export.
//       <div class="jmd-optional">
//       Optional Dependencies
//       </div>
//       <ul>
//       <li><i>batik-anim, batik-awt-util, batik-bridge, batik-css, batik-dom, batik-ext, 
//              batik-gvt, batik-parser, batik-script, batik-svg-dom, batik-util, batik-xml
//           </i> -
//           <p/>
//           These are all required to use +link{RPCManager.exportImage()}, or when using 
//           +link{RPCManager.exportContent()} to export a DrawPane or FacetChart only 
//           in IE8 or earlier, or if a DrawPane has a DrawImage which loads a cross-domain 
//           image.
//           <p/>
//           <b>NOTE:</b> 
//           Between iText 2.0.x and iText 2.1.x there is a binary (but not source) 
//           incompatibility that causes a server-side <code>NoSuchMethodError</code> 
//           when exporting, e.g., charts in Internet Explorer. This is a 
//       +externalLink{http://code.google.com/p/flying-saucer/issues/detail?id=126,known issue} 
//           with the Flying Saucer product that is fixed by using 
//           core-renderer-R8-isomorphic.jar and iText-2.1.7.jar in the lib-iTextAlternate/ 
//           directory instead of core-renderer.jar and iText-2.0.8.jar in the lib/ directory.  
//           To use iText 2.1.7 with the Server Framework, exclude lib/core-renderer.jar and 
//           lib/iText-2.0.x.jar from the application's classpath and instead add 
//           lib-iTextAlternate/core-renderer-R8-isomorphic.jar and 
//           lib-iTextAlternate/iText-2.1.7.jar.
//       </ul>
//     </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//      <a target="_blank" href="./mavendoc/isomorphic-tools.html">isomorphic_tools</a>
//   </td>
//   <td>
//     Contains back-end logic for the "Admin Console" tool visible in the Developer Console, 
//     and also standalone from the SDK home page.  Also contains the various data importers 
//     and exporters, and the server-side components of the BatchUploader.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-cdi.html">isomorphic_cdi</a>
//   </td>
//   <td>
//     Support for +link{group:dmiOverview,DMI} dispatches to Spring beans 
//     (via +link{serverObject.lookupStyle} : "cdi").
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-spring.html">isomorphic_spring</a>
//   </td>
//   <td>
//     Support for +link{group:dmiOverview,DMI} dispatches to Spring beans 
//     (via +link{serverObject.lookupStyle} : "spring").
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-messaging.html">
//     isomorphic_realtime_messaging</a>
//   </td>
//   <td>
//     Server support required for the SmartClient Realtime Messaging Module.  Install this 
//     if you're using this 'push' technology.  For more information, see 
//     +link{group:messaging,Messaging}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-hibernate.html">isomorphic_hibernate</a>
//   </td>
//   <td>
//     Contains support for Hibernate DataSources as described here: 
//     +link{group:hibernateIntegration}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-jpa.html">isomorphic_jpa</a>
//   </td>
//   <td>
//     Contains support for JPA DataSources as described +link{group:jpaIntegration,here}
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-sql.html">isomorphic_sql</a></td>
//   <td>
//     The SmartClient SQLDataSource.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-autotest.html">isomorphic_autotest</a>
//   </td>
//   <td>
//     Support for +link{group:automatedTesting,automated testing and Continuous Integration}
//     <div class="jmd-optional">
//     Optional Dependencies
//     </div>
//     <ul>
//       <li><i>jna</i> - if testing with IE on Windows environments
//       <li><i>servlet-api</i> - needed only if you intend to run TestRunner from a standalone
//            process (ie, from a normal Java program, not a webapp).  
//            <p/>
//            However, it should <u>not</u> be deployed to a servlet container such as Tomcat 
//            or Jetty.  The best case is that the file will be unused and a source of 
//            confusion for anybody looking at the webapp's library usage; the worst case is 
//            that it will conflict with the container's own implementation of the Servlet API.
//     </ul>
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module">
//     <a target="_blank" href="./mavendoc/isomorphic-js-parser.html">isomorphic_js_parser</a>
//   </td>
//   <td>
//     A parser capable of reading a JSON byte stream and creating an in-memory Java object 
//     structure to match.  Used by any mechanism that relies on JSON-style configuration.  
//     Examples include FileAssembly definitions in JSON format, any use of the rulesFile with 
//     a URIRegexFilter (Java Servlet) or subclass.  
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-compression.html">
//     isomorphic_compression</a>
//   </td>
//   <td>
//     This is a part of the Network Performance Module.  The isomorphic_compression module is 
//     required for dynamic and static compression of various assets delivered to the browser.  
//     For more information, see: +link{group:compression}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-assembly.html">
//     isomorphic_assembly</a>
//   </td>
//   <td>
//     This is part of the Network Performance Module.  The isomorphic_assembly module is 
//     required for file assembly and stripping.  For more information, see: 
//     +link{group:fileAssembly}.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-m2pluginextras.html">
//     isomorphic_m2pluginextras</a>
//   </td>
//   <td>
//     A small collection of tools / utilities for use by Maven builds, Ant Scripts, and 
//     command line invocation.
//   </td>
// </tr>
// <tr>
//   <td class="jmd-module"><a target="_blank" href="./mavendoc/isomorphic-struts.html">
//     isomorphic_struts</a>
//   </td>
//   <td>
//     Contains the ValidationAction and ValidationFailureAction classes that implement 
//     RPC-based validation of DynamicForms using the Struts ValidatorPlugIn.  
//     If you're not using Struts or if you don't need this particular feature of SmartClient, 
//     you do not need this module or its dependencies (also see the important note  below).  
//     An example of this style of validation is available here:  
//     +externalLink{/examples/struts/forms/welcome.do} - read the info on this page, and 
//     follow  the "Dynamic Form (With RPC-based Validation)" Link for the actual example.
//     <br><br>
//     <b>NOTE:</b> This support is for Struts 1.0 only, and is only intended to be used in 
//      certain edge cases of incremental migration to SmartClient.  You should only use it if 
//      directed to do so by Isomorphic Support.
//   </td>
// </tr>
// </table>
//
// @treeLocation Concepts/Deploying SmartClient
// @title Java Module Dependencies
// @visibility external
//<

//> @groupDef npmjs
// SmartClient client-side resources - the JavaScript runtime, skins, and schema - can be
// installed and updated via +externalLink{https://www.npmjs.com,npmjs}.  Select the 
// appropriate package based on your licensing:<ul>
// <li> +externalLink{https://www.npmjs.com/package/smartclient-lgpl,      smartclient-lgpl}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-eval,      smartclient-eval}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-pro,       smartclient-pro}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-power,     smartclient-power}
// <li> +externalLink{https://www.npmjs.com/package/smartclient-enterprise,smartclient-enterprise}
// </ul>
// <b>Note:</b> the SmartClient npm module requires an environment, such as
// +externalLink{https://en.wikipedia.org/wiki/React_(JavaScript_library),React} or
// +externalLink{https://en.wikipedia.org/wiki/Angular_(web_framework),Angular}, that defines
// "window" as a global with real browser document and navigator objects.
// <h2>Installation</h2>
// To install one of these packages, use:
// <pre>
//   npm install &lt;package name&gt; [flags]</pre>
// where the flags are as follows:<p>
// <table border=1 class="normal">
// <tr bgcolor="#D0D0D0"><td>Option Name</td><td>Argument Value</td><td>Description</td></td>
// <tr>
// <td><code>location</code></td><td>path</td>
// <td>A path (absolute or relative to the dependent module) specifying where to install
// the SmartClient runtime(s).  Default is to place the runtime root directory
// (<code>isomorphic</code>) in the dependent module directory.</td>
// </tr><tr>
// <td><code>branch</code></td><td>number</td>
// <td>Desired branch (e.g. 11.1).  Default is the latest release.</td>
// </tr><tr>
// <td><code>date</code></td><td>date in format YYYY-MM-DD | <code>latest</code>
// </td><td>Desired date.  Default is to use the latest build available.</td>
// </tr><tr>
// <td><code>runtime</code></td><td><code>release</code> | <code>debug</code> |
// <code>both</code></td><td>Desired runtime(s) to install.  Default is to install them both.
// </td></tr><tr>
// <td><code>reference</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to keep the framework reference directory.  Default is to not install it to save
// disk space.</td>
// </tr><tr>
// <td><code>skins</code></td><td><code>Tahoe</code> | <code>all</code> | <code>none</code></td>
// <td>Which skins (if any) to install.  Default is to only install Tahoe.</td>
// </tr><tr>
// <td><code>username</code></td><td>string</td>
// <td>The username for your +externalLink{https://www.smartclient.com,SmartClient account}.
// Required for the +externalLink{https://www.npmjs.com/package/smartclient-pro,Pro},
// +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// and available subject to your licensing.</td>
// </tr><tr>
// <td><code>password</code></td><td>string</td>
// <td>The password for your +externalLink{https://www.smartclient.com,SmartClient account}.
// Required for the +externalLink{https://www.npmjs.com/package/smartclient-pro,Pro},
// +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// and available subject to your licensing.</td>
// </tr><tr>
// <td><code>analytics</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to install the optional +link{group:loadingOptionalModules,Analytics Module}.
// Only available for the +externalLink{https://www.npmjs.com/package/smartclient-power,Power},
// and +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// subject to your licensing.</td>
// </tr><tr>
// <td><code>rtm</code></td><td><code>true</code> | <code>false</code></td>
// <td>Whether to install the optional 
// +link{group:loadingOptionalModules,RealtimeMessaging Module}.  Only available for the
// for the +externalLink{https://www.npmjs.com/package/smartclient-power,Power}, and
// +externalLink{https://www.npmjs.com/package/smartclient-enterprise,Enterprise} packages,
// subject to your licensing.</td>
// </tr><tr>
// <td><code>yes</code></td><td><code>true</code> | <code>false</code></td>
// <td>Assume answer 'yes' to prompts with default.  This allows the install or update process
// to complete without interaction, to enable complete automation.</td>
// </tr></table><p>
// After installation, command-line configuration is persisted, so command-line arguments only
// need to be supplied when updating if the desired configuration has changed. If a username and
// password aren't supplied via the above options, you will be prompted to enter them by the
// update script. A password typed in response to the script won't be persisted to your
// configuration, so you may choose to always enter it interactively for security.
// <h2>Updating</h2>
// Since 'npm update' no longer runs a package's update script if the version hasn't changed,
// and smartclient npm packages are versioned separately from nightly SDK builds, you must go
// to the smartclient npm module directory, and run using the syntax
// <pre>
//   npm run update [flags]</pre>
// to update your installation to the latest runtimes.  The supported flags are the same as
// during installation.
// <P>
// <h2>Examples</h2>
// New install of SmartClient Evaluation, selecting a specific branch and date:
// <pre>
//   npm install smartclient-eval --branch=11.1 --date=2018-12-30</pre>
// Update to latest nighlty build (run from package directory):
// <pre>
//   npm run update --date=latest</pre>
// Update to SmartClient 12.1 branch, installing all skins:
// <pre>
//   npm run update --branch=12.1 --skins=all</pre>
// <h2>Importing</h2>
// If you are building a new Angular, React or similar application, and plan to use SmartClient
// pervasively throughout, you can just add an import declaration to your <code>main.ts</code>
// or <code>App.tsx</code> to make the framework available.  However, if you are adding
// SmartClient to an existing application, and you only plan to use SmartClient for specific
// components like grids, or for +link{group:reifyForDevelopers,Reify screens}, consider using
// +link{group:backgroundDownload,background download} instead of importing SmartClient
// directly (importing causes SmartClient to load immediately on all pages).
// <p>
// To directly import the release or debug framework, respectively, in your application, you can
// write:
// <pre>
//   import 'smartclient-eval/debug';</pre>
// or
// <pre>
//   import 'smartclient-eval/release';</pre>
// To import a skin as well, such as "Tahoe", you can add:
// <pre>
//   import 'smartclient-eval/skins/Tahoe';</pre>
// To import one of the optional modules, you'd write something like:
// <pre>
//   import 'smartclient-eval/debug/rtm';</pre>
// or
// <pre>
//   import 'smartclient-eval/release/analytics';</pre>
// respectively, to import the debug version of the Realtime Messaging module or the release
// version of the Analytics module.
// <p>
// <b>Caution:</b> you can't mix debug and release imports in a single app.
// <h3>Importing skins in Angular</h3>
// In Angular,  if you directly import the skin, you may need to manually add the path to the
// <code>skin_styles.css</code> file for your skin to the <code>src/styles.css</code> file (or
// equivalent) for your app, in addition to importing the
// skin as described above.
// <p>
// For example, if you've installed the SmartClient runtime in the default location, and are
// importing Tahoe, you'd add the following to <code>src/style.css</code> in your app:
// <pre>
//   &commat;import '../isomorphic/skins/Tahoe/skin_styles.css';</pre>
// <b>Note:</b> if you are using the +link{FileLoader} to load a skin, it must be installed
// under <code>src/assets</code> (for example copied from <code>isomorphic/skins</code>) to
// work properly.
// <h3>Using SmartClient APIs</h3>
// If you want to refer to SmartClient APIs through your own constant, you can always issue a
// declaration such as:
// <pre>
//   const ISC: typeof isc = window['isc'];</pre>
// after importing this package.
// <h2>TypeScript</h2>
// To provide typescript support, the installation process should automatically augment your
// <code>tsconfig.json</code> file with an include directive targeting SmartClient's typescript
// file.
// <P>
// Alternatively, you can copy the typescript declaration file, <code>smartclient.d.ts</code>,
// from the installed resources under the <code>isomorphic</code> directory to your app's
// source directory, and then import it from your app like:
//
// <pre>
//   import 'smartclient.d.ts';</pre>
// SmartClient's TypeScript support is intended for IDE auto-completion and inline
// documentation, not for transpilation.  So, if you run into compile errors, you can always
// remove any reference to our TypeScript file from your own TS file and application, remove
// <code>smartclient.d.ts</code> from under <code>src/assets</code> (if present), and instead
// make TypeScript active for your IDE only.  For further details, see the TypeScript support
// documentation for +link{group:typeScriptSupport,our framework} or your IDE.
//
// @treeLocation Concepts/Deploying SmartClient
// @see group:iscInstall
// @title NPMJS Support
// @visibility external
//<



//> @groupDef iscServer
//
// The SmartClient Server is a set of Java libraries, servlets and tools that provide the key
// server-side components needed to build a complete application in the modern web
// architecture.
// <P>
// The SmartClient Server can be +link{group:iscInstall,integrated} into any pre-existing Java
// application, and is designed to rapidly connect SmartClient visual components to
// pre-existing Java business logic or persistence engines.  SmartClient's Ajax request
// processing facilities can be easily integrated into Struts Actions,
// +link{group:springIntegration,Spring controllers}, or custom servlets and JSPs.
// <P>
// Alternatively, the SmartClient Server provides a complete SQL and Hibernate-based
// persistence engine for new applications, with out-of-the-box servlets for processing Ajax
// data requests.
// <P>
// The SmartClient Server is optional, and SmartClient's client-side Ajax engine can be
// integrated with any server that provides HTTP access, using XML, JSON, SOAP or proprietary
// data protocols.  However any server in a modern web application will be required to provide
// most or all of the features of the SmartClient Server (described below), and the SmartClient
// Server represents a best-of-breed implementation of these facilities with a long history of
// high-volume production deployments.
// <P>
// <h4>Server enforcement of +link{class:Validator,Validators}</h4>
// <P>
// Data passed from the browser can be automatically validated by the SmartClient Server.
// In contrast, when using +link{group:clientDataIntegration,client-side integration},
// data arrives as HTTP params or XML messages, and you must parse values into the correct
// types (eg java.util.Date) and validate them, or use a server framework that does so.
// <P>
// <h4>High Speed Data Delivery / Data Compression</h4>
// <P>
// The SmartClient Server delivers data to and from the browser using a proprietary, maximally
// efficient protocol, providing simple Java APIs for sending and receiving data.
// <P>
// SmartClient's data protocol is:
// <ul>
// <li> automatically compressed: provides 6-8x improvement in bandwidth utilization
// <li> efficient on the server: high speed data serialization for any Java Object
// <li> efficient in the browser: faster than ordinary XML or JSON data delivery
// <li> minimal: facilities for +link{dataSource.dropExtraFields,trimming} and
// +link{dataSourceField.valueXPath,extracting} only the data you want the browser to see
// </ul>
// <P>
// <h4>Transparent upload support</h4>
// <P>
// SmartClient provides special client and server-side support for +link{group:upload,file
// upload}, which allows single and multiple-file HTTP uploads to be performed as a background
// Ajax request without reloading the page or launching sub-windows.
// <P>
// Uploaded files arrive at the SmartClient server as Java InputStreams accessible from the
// DSRequest object, and can optionally be automatically stored via SmartClient's SQL
// subsystem.
// <P>
// <h4>Transparent Queuing / "Batch" Operations</h4>
// <P>
// Any request transmitted to the SmartClient Server can be combined into a "queue" transmitted
// as a single HTTP request, with in-order execution for all queued operations. 
// +link{RPCManager.startQueue,startQueue()} starts a queue and
// +link{RPCManager.sendQueue,sendQueue()} transmits it; queuing is transparent to the code
// that initiates the individual requests.  This enables:
// <ul>
// <li> re-use of data access operations across different screens
// <li> easy implementation of transaction boundaries
// <li> simplified saving and loading of screens with complex, master-detail views
// <li> guaranteed in-order processing of operations
// <li> more efficient network usage
// </ul>
// <P>
// <h4>Visual Builder</h4>
// <P>
// +link{group:visualBuilder,Visual Builder} is included with the SmartClient Server, and uses
// server features such as automatic SQL binding to provide a rapid prototyping environment.
// <P>
// <h4>Automatic Bi-directional Java &lt; - &gt; JavaScript serialization and translation</h4>
// <P>
// Provides a powerful, type-safe +link{rpcRequest.data,data transmission mechanism} for moving
// data between a Java server and the browser. 
// <P>
// Any Java objects, including Java Beans, POJOs, Java Collections, XML DOMs and all Java
// primitives, with any level of nesting, can be automatically serialized and delivered as
// JavaScript Objects to the SmartClient client-side components.
// <P>
// JavaScript Objects existing in the browser can likewise be automatically transmitted to a
// Java Server and translated to Java Objects, with any level of nesting and automatic
// preservation of primitive types.
// <P>
// <h4>SQL and Hibernate connectors</h4>
// <P>
// DataSources of serverType:"sql" or serverType:"hibernate" can generate and execute queries
// against popular SQL engines or against the Hibernate ORM system, providing SmartClient's
// +link{DataBoundComponent}s with the four standard CRUD operations (create, retrieve, update,
// delete) without writing any server-side code.  For rapid prototyping, these DataSources can
// even generate SQL tables based on the DataSource declaration, using the
// +link{group:adminConsole,Admin Console} visual tool.
// <P>
// Server-side APIs allow server-side modification of the request before it is executed (for
// example, to enforce security) and post-processing of the request after execution (for
// example, to provide calculated values).
// <P>
// Both serverType:"sql" and serverType:"hibernate" support the field-operator-value queries
// that can be generated by using the +link{FilterBuilder} component (see
// +explorerExample{filterBuilderBracket,example}).
// <P>
// <h4>Rich, Standardized Request / Response protocol</h4>
// <P>
// The SmartClient Server provides a standardized request and response protocol designed for
// data-oriented "CRUD" operations (create, retrieve, update, delete).
// <P>
// This standardized protocol automatically handles +link{DSRequest,request metadata} (paging
// parameters, requested sort order, original values of data being modified) and
// +link{DSResponse,response metadata} (error handling, cache management, session expiration etc).
// <P>
// Similar to the impact of Struts on early web applications, this standardized protocol avoids
// developers in different groups inventing their own incompatible and redundant
// request/response protocols, and allows developers to more easily learn code they didn't
// author.
// <P>
// <h4>Bi-directional XPath binding to Java Objects</h4>
// <P>
// Most UI designs do not directly reflect the underlying Object model and so some degree of
// translation is necessary in order to populate UI components with data and apply user changes
// to the Java Object model.  This is often accomplished with brittle, difficult to understand
// data translation code sprinkled throughout the system, done in a different way for every
// screen or component.
// <P>
// SmartClient provides a standard, +link{dataSourceField.valueXPath,XPath-based approach} to
// adapting any Java-based Object model to the requirements of the UI design.  Data relevant to
// the application UI is centrally extracted in the server-side +link{DataSource} layer, so
// that all UI components have a consistent, unified view of the data model for both loading
// <b>and</b> saving data.
// <P>
// <h4>Broadest possible browser support</h4>
// <P>
// The SmartClient Server can compensate for facilities 
// +link{group:platformDependencies,missing or disabled in certain browsers},
// including ActiveX being disabled in IE6 and missing XML support in some versions
// of Apple's Safari browser.
// <P>
// <h4>Transparent Proxying</h4>
// <P>
// +link{RPCManager.sendProxied,Proxying} allows SmartClient applications to access web
// services, RSS feeds, HTML content and other data services in a secure manner regardless of
// where they are located: across the enterprise or publicly available.
// <P>
// <h4>Optional +link{group:networkPerformance,Network Performance} Module</h4>
// <P>
// Provides:
// <ul>
// <li> compressed delivery of SmartClient runtime, application logic and other assets such as CSS
// <li> +link{FileLoader,background download} of SmartClient and other assets for zero
// user-perceived load time
// <li> on-the-fly stripping and combining of JavaScript (application code and data)
// <li> browser cache control
// </ul>
// <P>
// <h4>Optional Messaging Module (aka server push)</h4>
// <P>
// The +link{group:messaging,Messaging} module allows the server to "push" messages to the client, without
// client polling, for real-time monitoring/dashboarding applications.
//
// @title SmartClient Server Summary
// @treeLocation Java Server Reference
// @visibility external
//<


//> @groupDef jsfIntegration
//
// SmartClient can be used within JSF applications to add AJAX richness and interactivity.
// <P>
// Because JSF is a pre-AJAX architecture, the recommended approach in adding
// SmartClient to JSF applications is to create pages that use SmartClient components exclusively,
// so that older, server-based JSF components do not introduce full-page refreshes.
// <P>
// JSF pages that render components on the server access data via JSF Expression Language.
// SmartClient-based JSF pages can similarly load initial data by using JSTL, as shown in 
// +externalLink{/examples/server_integration/#jstlList,this example}, where a ListGrid is
// populated by JSTL access to Java Beans stored in the JSP <code>pageContext</code>.  
// <P>
// Once a SmartClient JSF page has loaded, SmartClient components will request data via background
// HTTP requests that load only data, not a complete page.  The 
// +link{group:dmiOverview,Direct Method Invocation} system can be used to declaratively map SmartClient's
// background data requests directly to Java Methods. The SmartClient server automatically
// translates inbound request data into Java Objects that are passed to the method you specify,
// and the Java method return value is automatically translated into data for SmartClient
// components.
// <P>
// <h4>Incorporating server-side JSF components into a SmartClient JSF page</h4>
// <P>
// An +link{HTMLFlow} or +link{HTMLPane} component can be used to incorporate server-generated
// content within a SmartClient-based page.  With +link{htmlFlow.contentsType,contentsType} set to
// "page", the HTMLPane/Flow will act like a standalone page-within-a-page (via a
// SmartClient-managed HTML IFRAME element), allowing interactive server-side JSF components to
// participate normally, with limitations as discussed under the documentation for 
// +link{htmlFlow.contentsType,contentsType}.
//
// @treeLocation Concepts
// @title Integration with JSF
// @visibility external
//<

//> @groupDef strutsIntegration
//
// <h3>Please note that Apache Struts is deprecated and will be removed from Smartclient 13.0
// </h3><p>
// <b>Overview of SmartClient integration with Struts and other popular server-side
// frameworks.</b>
// <p>
// Current and upcoming server-side frameworks solve a lot of problems endemic to the past
// generation of web applications.  Piles of JSPs and Servlets have been replaced by MVC and
// other paradigms that enhance developer productivity.  Unfortunately the end-user
// presentation remains vanilla HTML.  SmartClient solves this problem by providing rich
// databindable components. SmartClient was designed to integrate cleanly with existing
// server-side frameworks.  Because SmartClient components only require an HTML context to
// render, they can be used with any server-side frameworks that use HTML for presentation.
// <p>
// SmartClient provides a rich UI by doing more work on the client (browser) rather than
// sending every user action to the server for re-rendering.  Instead of doing page transitions
// to redraw the whole page, SmartClient sends RPC (Remote Procedure Call) requests (or AJAX
// requests) to the server while the UI allows the user to continue interacting with the
// system.  Current server-side frameworks, on the other hand are typically designed around
// page transitions - for example in Struts user actions are typically mapped to URLs that
// dispatch through a central servlet and ultimately return new HTML to be rendered by the
// browser.  The problem with page transitions is that they destroy client-side state and
// introduce client-server latency (and generally use more bandwidth since HTML is sent over
// the wire rather than just data) - essentially destroying a large part of the Rich
// Internet Application (RIA) experience.
// <p>
// Fortunately, there's a way to get the best of both worlds - to leverage the power of your
// favorite server-side framework and combine it with the SmartClient UI.  There are several
// approaches to integrating SmartClient into an existing framework:
// <p>
// <u><b>Plug-replacing HTML components with SmartClient components</b></u>
// <p>
// SmartClient components can be instructed to draw at page load time using by specifying
// <code>position: "relative"</code> at construction time.  This enables you to replace any
// chunk of HTML with a SmartClient component - the new component simply inserts its HTML in
// the page flow during page load.  This is the easiest integration option - you get a better
// UI with minimal work.  The downside is that you don't get the full power of a rich client
// because most user actions will still trigger a page transition.
// <p>
// <u><b>Eliminating page transitions</b></u>
// <p>
// Most SmartClient components can accept new data (or even dynamically pre-fetch and expire
// data) without needing to be recreated.  For example - let's say you want to draw a grid on a
// page.  In a traditional server-side-rendered application the server would generate all of
// the html with "next 20 records" and "previous 20 records" buttons. When the user wants to
// see the next set of data, he clicks one of the buttons and the server replaces the entire
// page with a new grid that contains the next/previous 20 records.  In a SmartClient
// application, you would create a databound ListGrid.  Based on its configuration this grid
// will fetch the first N (say 20) records and display a scrollbar for the user to scroll
// through the data.  When the user scrolls off the last cached record the ListGrid
// automatically sends an RPC to the server asking for the next 20 records.  This RPC (fetch)
// is performed without destroying the page the user is currently looking at - it just happens
// seamlessly in the background.  If the user now scrolls back to the first 20 records -
// they're already cached in the grid, so no fetch is performed.  Of course, in a real world
// application, it's typical that a page has hundreds of components and in a server-side-only
// rendering all of them need to be rebuilt by the server and resent to the client when a piece
// of data in just one needs to be updated.  SmartClient components can intelligently update
// just their data without the need to redraw the whole page.
// <p>
// The plug-replacement strategy listed above gives us a SmartClient component in place of a
// raw HTML rendering.  Now we need to databind that component so that actions like scrolling a
// grid or validating a form don't cause a page transition.  To do this, you need to set up a 
// Struts Action that will handle <b>all</b> SmartClient <code>RPCRequest</code>s and 
// <code>DSRequest</code>s.  This is important, as requests need to be sent to the same URL 
// to enable queuing to work.  In your Action class, you simply need to invoke 
// <code>RPCManager.processRequest()</code> to hook straight into the normal 
// <code>DSRequest</code> processing flow.
// <p>
// The SDK contains a simple example of doing form validation without incurring a page
// transition. These examples also show how to populate e.g. field names using the struts-bean
// taglib and how to set validation errors using the standard Struts Validation plugin.
// Point your browser to +externalLink{/examples/struts/forms} in the SmartClient SDK to take a
// look.
//
// @treeLocation Concepts
// @title Integration with Struts
// @visibility external
//<

//> @groupDef springIntegration
// <b>Overview</b>
// <P>
// The Spring framework has many different parts, from integration with Object Relational
// Mapping (ORM) and transaction management systems, to a Model View Controller (MVC)
// architecture.
// <P>
// If you are building a new application from scratch and/or you are trying to 
// modernize the presentation layer of an existing application, most of Spring MVC is
// inapplicable in the +link{group:smartArchitecture,SmartClient architecture}.  Specifically,
// SmartClient renders <b>all</b> HTML on the client, and the server is responsible only for
// retrieving data and enforcing business rules.  This means that Spring's ModelAndView and all
// functionality related to retrieving and rendering Views is unnecessary in SmartClient.
// SmartClient only needs the Model, and provides methods to deliver that Model to SmartClient
// components (the server side method DSResponse.setData()).
// <P>
// However, Spring's DispatchServlet, Handler chain, and Controller architecture is applicable
// to SmartClient.  See "Using Spring Controllers" below.
// <P>
// <b>Existing Spring Application</b>
// <P>
// As discussed under the general +link{group:clientServerIntegration,server integration}
// topic, integrating SmartClient into your application involves finding a way to provide data
// that fulfills the +link{DSRequest,DataSource requests} sent by SmartClient components.
// <P>
// There are 2 approaches for integrating SmartClient into an existing Spring application:
// <ul>
// <li> <b>call Spring beans via SmartClient DMI or custom DataSources</b>
// <span style="color:red">[Recommended]</span>: use SmartClient Direct Method Invocation
// (DMI) to map +link{dsRequest,DataSource requests} to beans managed by Spring, via
// +link{serverObject.lookupStyle}:"spring".   Return data to the browser by either simply
// returning it from your method, or via creating a DSResponse and calling DSResponse.setData()
// (server-side method).  Or, use a similar approach based on custom DataSource implementations
// where the +link{dataSource.serverConstructor,serverConstructor} is of the pattern 
// <b>"spring:{bean_name}"</b>
// <P>
// This is the easiest method and produces the best result.  A Collection of Java Beans, such
// as EJB or Hibernate-managed beans, can be directly returned to SmartClient as the result of
// a DMI method, without the need to create an intervening
// +externalLink{http://en.wikipedia.org/wiki/Data_transfer_object,Data Transfer Object} to express
// which fields should be delivered to the browser - instead, only the fields declared on the
// DataSource are returned to the browser (see
// +link{DataSource.dropExtraFields,dropExtraFields}.  In this integration scenario, the
// majority of the features of the SmartClient Server framework still apply - see this
// +link{group:featuresCustomPersistence,overview}.
// <p>
// Note, there are special scoping considerations to bear in mind when using Spring-injected 
// DataSources or DMIs - see +link{group:serverDataSourceImplementation,this discussion} of 
// caching and thread-safety issues.
// <P>
// <li> <b>configure Spring to return XML or JSON responses</b>: create variants
// on existing Spring workflows that use a different type of View in order to output XML or
// JSON data instead of complete HTML pages.  The SmartClient +link{RestDataSource} provides a
// standard "REST" XML or JSON-based protocol you can implement, or you can adapt generic
// +link{DataSource,DataSources} to existing formats.
// <P>
// In some Spring applications, all existing Spring workflows can be made callable by
// SmartClient with a generic View class capable of serializing the Model to XML or JSON,
// combined with a Controller that always uses this View.  Consider the following Java
// anonymous class, which uses the SmartClient JSTranslater class to dump the entire 
// Spring Model as a JSON response.
// <pre>
//  new View() {
//        public void render(Map model, HttpServletRequest request,
//                           HttpServletResponse response) throws IOException {
//                final ServletOutputStream outputStream = response.getOutputStream();
//                response.setContentType("application/x-javascript");
//                outputStream.println(JSTranslater.get().toJS(model));
//                outputStream.close();
//        }
//        public String getContentType() {
//                return "application/x-javascript";
//        }
//  }
// </pre>
// <P>
// If you use this approach, you do not need to install the SmartClient server, and can
// +link{iscInstall,deploy} SmartClient as simple web content (JS/media/HTML files).  If you
// are already familiar with how to generate XML from objects that typically appear in your
// Spring Models, this may be the easiest path.
// </ul>
// <P>
// <h3><b>Using Spring Controllers with SmartClient DMI</b></h3>
// <P>
// You can create a Controller that invokes standard SmartClient server request processing,
// including DMI, like so:
// <pre>
// public class <smartclient>SmartClientRPCController</smartclient><smartgwt>SmartGWTRPCController</smartgwt> extends AbstractController
// {
//     public ModelAndView handleRequest(HttpServletRequest request, 
//                                       HttpServletResponse response)
//         throws Exception
//     {
//         // invoke SmartClient server standard request processing
//         com.isomorphic.rpc.RPCManager.processRequest(request, response);
//         return null; // avoid default rendering
//     }
// }
// </pre>
// This lets you use Spring's DispatchServlet, Handler chain and Controller architecture as a
// pre- and post-processing model wrapped around SmartClient DMI.
// <p>
// <h3><b>Using Spring Transactions with SmartClient DMI</b></h3>
// <p>
// You can make DMI's participate in Spring's transaction management scheme by setting the 
// +link{dataSource.useSpringTransaction,useSpringTransaction} flag on your DataSources or 
// +link{class:OperationBinding}s.  This makes your DMI method(s) 
// transactional, and ensures that any DSRequests and Spring DAO operations executed within 
// that DMI use the same Spring-managed transaction.  See the documentation for 
// <code>useSpringTransaction</code> for more details.
// <p>
// In Power Edition and above, SmartClient Server has its own transaction management system.
// This allows you to send +link{RPCManager.startQueue(),queues} of 
// +link{class:DSRequest,DSRequest}s to the server, and the entire queue will be treated as a 
// single database transaction.  This is <b>not</b> the same thing as Spring transaction 
// integration: SmartClient's built-in transaction management works across an entire queue of
// DSRequests, whereas Spring transactions are specific to a Java method that has been marked 
// <code>&#x0040;Transactional</code> - the transaction starts and ends when the method starts and 
// ends.
// <p>
// It is possible to have an entire SmartClient queue - including any <code>&#x0040;Transactional</code>
// DMIs that contain both Spring DAO operations and DSRequests - use the same Spring-managed 
// transaction.  To do this:<ul>
// <li>Create a new Spring service bean with a <code>&#x0040;Transactional</code> method like this
// (note, the isolation level can vary as you please, but the propagation type must be REQUIRED
// to enable proper sharing of the transaction):<pre>
//    &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
//    public class MyServiceBean {
// 
//        // invoke SmartClient server standard request processing
//        public void processQueue(RPCManager rpc) throws Exception {
//            rpc.processRPCTransaction();
//        }
//    }</pre></li>
// <li><b>Either:</b> Subclass the <code>com.isomorphic.servlet.IDACall</code> servlet and 
// override its <code>processRPCTransaction</code> method to inject the service bean you just
// created and invoke its transactional method.  You will also have to change your 
// <code>web.xml</code> file to point at this new servlet rather than <code>IDACall</code></li>
// <li><b>Or:</b> Use a Spring Controller, as described in the section <b>Using Spring 
// Controllers with SmartClient DMI</b>, above.  Just follow the instructions for using a 
// Spring Controller, but have your <code>handleRequest()</code> implementation inject your
// service bean and invoke its transactional method, as described for the <code>IDACall</code>
// subclass approach</li>
// </ul>
// Whether you choose the IDACall or Spring Controller approach, the important thing is that 
// the call to <code>RPCManager.processRPCTransaction()</code> takes place from within a 
// <code>&#x0040;Transactional</code> method of a Spring service bean.  This will place the 
// processing of the entire SmartClient queue inside the transaction that is created by Spring
// to service that transactional method.
//
// @treeLocation Concepts
// @title Integration with Spring
// @visibility external
//<



//> @groupDef hibernateIntegration
//
// SmartClient can integrate with Hibernate in two main ways, both of which are enabled by
// creating a DataSource descriptor (.ds.xml file) with
// +link{DataSource.serverType,serverType="hibernate"}:
// <ul>
// <li> Pre-existing beans: a SmartClient DataSource can be automatically derived from either a
// Hibernate-managed bean or the Hibernate mapping.  Use
// +link{dataSource.schemaBean,schemaBean} to derive from the bean or
// +link{DataSource.autoDeriveSchema} to derive from the mapping.  In this case you will
// initially have a very short .ds.xml per bean - no &lt;fields&gt; are required unless
// and until you want to override the automatically derived fields.
// <li> "Beanless" mode: SmartClient can drive Hibernate as a storage layer only, automatically
// generating Hibernate configuration from a SmartClient DataSource file
// (<i>dataSourceID</i>.ds.xml).  In this case, you do not write a Java bean or create
// Hibernate mappings; Hibernate's beanless
// +externalLink{http://docs.jboss.org/hibernate/orm/3.3/reference/en-US/html/persistent-classes.html#persistent-classes-dynamicmodels,"dynamic model"}
// mode is used.  
// </ul>
// <P>
// Which mode to use is primarily a matter of preference and pre-existing code.  However, if
// you do not have pre-existing code or other special circumstances, the following approach is
// the most productive:
// <ol> 
// <li> use "beanless" mode, specifying fields in SmartClient's .ds.xml format (far more
// compact than a Java bean with a getter and setter for each field)
// <li> add business logic as needed via DMI, Server Scripting, custom server validators, and
// other approaches covered in the QuickStart Guide
// <li> call any reusable DMI methods both via your SmartClient UI and via other, non-UI
// related Java logic (the DMI methods are now a reusable "data services tier")
// <li> only create an actual Java bean if you discover re-usable, bean-specific business
// logic that cannot be encapsulated as a data service (rare)
// </ol>
// <P>
// Note that the +link{group:adminConsole,Admin Console}'s
// "Import DataSources" section can be used to import test data into serverType:"hibernate"
// DataSources in the same manner as SQLDataSources.
// <p>
// HibernateDataSource supports operations with composite primary keys. Setting data source level property
// +link{attr:dataSource.idClassName,idClassName} to fully qualified class name indicates,
// that entity uses composite primary key.
// <p>
// <h3>Beans and the DSRequest / DSResponse</h3>
// <p>
// In case of "pre-existing beans" approach, see +link{hbBeans} for the information how incoming 
// DSRequest data is used and what to expect in DSResponse.
// <p>
// <h3>Hibernate relations</h3>
// <p>
// For Hibernate integration where Java beans have been explicitly declared,
// HibernateDataSource supports automatic handling of Hibernate relations that don't declare a
// concrete field to hold ID values - see +link{group:jpaHibernateRelations}.
// <p>
// <h3>Hibernate Configuration</h3>
// <p>
// You can provide Hibernate configuration to the SmartClient server in three ways:
// <ul>
// <li>You can place a traditional <code>hibernate.cfg.xml</code> file somewhere on the 
//     classpath</li>
// <li>You can have SmartClient look up a Hibernate <code>Configuration</code> to use.  This 
//     works in the same way as a +link{ServerObject}, and in fact makes use of the 
//     ServerObject code, though note that lookupStyle "attribute" is not supported.  To look 
//     up a configuration, add ServerObject-compliant properties to your 
//     +link{group:server_properties,server.properties} file, prefixed with <code>hibernate.config</code>.  For
//     example: <pre>
//        hibernate.config.lookupStyle: spring
//        hibernate.config.bean: mySessionFactory
// </pre></li>
// <li>You can provide a Hibernate configuration at the level of individual DataSources, by 
//     specifying a +link{DataSource.configBean,configBean} on the dataSource (this is only 
//     applicable if you are using Spring; see below)</li>
// </ul>
// If you choose to have SmartClient lookup the Hibernate configuration, and you specify a 
// +link{serverObject.lookupStyle,lookupStyle} of "spring", SmartClient will make use of a
// Hibernate <code>SessionFactory</code> configured by Spring.  It is possible to set up multiple
// Hibernate configurations in Spring, and to map individual DataSources to different 
// configurations by making use of the <code>dataSource.configBean</code> property mentioned
// above.  Please note the following caveats:
// <ul>
// <li>DataSource-level Hibernate configuration is intended for unusual cases, such as when the
//     physical data store for one DataSource is actually a different database.  Hibernate 
//     relations between entities with different configurations do not work</li>
// <li>If you choose to configure Hibernate via Spring, "beanless" on-the-fly 
//     mappings are not supported; all entities must be hand-mapped to a bean, either in the 
//     properties of the Spring bean providing the configuration, in a <code>.cfg.xml</code>
//     file named in the Spring bean's <code>configLocation</code> property, or by use of 
//     persistence annotations in the actual mapped beans themselves</li>
// </ul>
// <p>
// <h3>Inbound DSRequest data will use numeric field types from your bean</h3>
// <p>
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will 
// automatically be converted to the type of the target field, before the request is received 
// in a +link{DMI}.  For details, see +link{group:dsRequestBeanTypes}.
// <p>
// <h3>Manual Hibernate Integration</h3>
// <p>
// In some cases you may not be able to immediately use the built-in HibernateDataSource - in
// this case take a look at +link{group:manualJpaHibernate,manual Hibernate integration}.
//
// @see attr:dataSource.beanClassName
// @see group:sqlConnectionPooling
// @treeLocation Concepts/Persistence Technologies
// @title Integration with Hibernate
// @visibility external
//<

//> @groupDef jpaIntegration
// To use JPA, set serverType="jpa" in your .ds.xml file, then set
// +link{attr:dataSource.beanClassName,beanClassName} to the fully qualified class name of the
// JPA entity.  For example:
// <pre>
// &lt;DataSource
//     ID="countryDS"
//     serverType="jpa"
//     beanClassName="com.smartgwt.sample.showcase.server.jpa.Country"
// &gt;
//     &lt;fields&gt;
// &lt;!-- ... Fields definition ... --&gt;
//     &lt;/fields&gt;
// &lt;/DataSource&gt;
// </pre>
// +link{DataSource.autoDeriveSchema} is supported for deriving DataSource fields from JPA
// entities automatically (except with JPA 1.0; see below).
// <p>
// Full support is provided for executing simple +link{Criteria}, with +link{AdvancedCriteria}
// supported if you have Power Edition or above.  However, note that there are limitations with case
// sensitive search in MySQL since MySQL automatically uses the 'like' operator in a
// case-insensitive manner and JPA does not correct this.  See <a
// href="http://dev.mysql.com/doc/refman/5.5/en/case-sensitivity.html">MySQL Reference Manual
// :: C.5.5.1 Case Sensitivity in String Searches</a> for more information.<p/>
// <p>
// If create a custom DataSource based on the built-in JPA functionality, subclass
// <code>com.isomorphic.jpa.JPA2DataSource</code>.
// <p>
// <h3>Beans and the DSRequest / DSResponse</h3>
// <p>
// In case of "pre-existing beans" approach, see +link{hbBeans} for the information how incoming 
// DSRequest data is used and what to expect in DSResponse.
// <p>
// <h3>JPA relations</h3>
// <p>
// For JPA integration where Java beans have been explicitly declared,
// JPADataSource supports automatic handling of JPA relations that don't declare a
// concrete field to hold ID values - see +link{group:jpaHibernateRelations}.
// <p>
// <h3>JPA configuration</h3>
// <p>
// JPA configuration should be specified in the <code>persistence.xml</code> file as usual, and placed
// in the <code>/WEB-INF/classes/META-INF</code> directory.  For JPA 2.0 make sure you correctly
// declare its usage in <code>persistence.xml</code>:<pre>
// &lt;persistence
//     version="2.0"
//     xmlns="http://java.sun.com/xml/ns/persistence"
//     xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
//     xsi:schemaLocation="http://java.sun.com/xml/ns/persistence 
//                         http://java.sun.com/xml/ns/persistence/persistence_2_0.xsd"
// &gt;
// ...
// &lt;/persistence&gt;</pre><br/>
// <P>
// JPADataSource supports operations with composite primary keys. Setting data source level property
// +link{attr:dataSource.idClassName,idClassName} to fully qualified class name indicates,
// that entity uses composite primary key.
// <P>
// JPADataSource supports automatic handling of JPA relations that don't declare a concrete
// field to hold ID values - see +link{group:jpaHibernateRelations}.
// <P>
// <h3>JPA 1.0 compatibility</h3>
// <P>
// To use JPA 1.0, set serverType="jpa1" instead.  JPA 1.0 does not support
// +link{dataSource.autoDeriveSchema}.  For JPA 1.0, the concrete implementation class (for subclassing to
// create a custom DataSource) is <code>com.isomorphic.jpa.JPADataSource</code>.
// <p>
// <h3>JPA transactions</h3>
// <p>
// JPA provides three mechanisms for transactions: for JEE applications JPA provides integration
// with JTA (Bean Managed Transactions and Container Managed Transactions); for JSE applications JPA has a native
// <code>EntityTransaction</code> implementation (Locally Managed Transactions). Spring framework is another popular
// way for declaring transactions in application.
// The transaction mechanism should be configured in the +link{group:server_properties,server.properties}
// file by setting
// property <b><code>jpa.emfProvider</code></b> to the fully qualified class name of the provider
// (implementation of <code>com.isomorphic.jpa.EMFProviderInterface</code>). SmartClient comes
// with five implementations:<ul>
// <li><b><code>com.isomorphic.jpa.EMFProviderLMT</code></b> - for Locally Managed Transactions.
//      Every fetch or DML operation starts a new transaction and commits after successful
//      execution.<br/>
//      This implementation reads the <b><code>jpa.persistenceUnitName</code></b> property from
//      the +link{group:server_properties,server.properties} file.  The value of this property needs
//      to be set to
//      the name of the persistence unit configured in <code>persistence.xml</code> file. For example:<pre>
// jpa.persistenceUnitName: PERSISTENCE_UNIT_NAME
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderBMT</code></b> - for Bean Managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the container and starts it.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManager</code></b> and <b><code>jpa.entityManagerFactory</code></b>
//      containing appropriate resource name references configured in
//      <code>/WEB-INF/web.xml</code>. Configuration example:<pre>
// &lt;!-- EntityManager resource reference name declaration --&gt;
// &lt;persistence-context-ref&gt;
//    &lt;persistence-context-ref-name&gt;persistence/em&lt;/persistence-context-ref-name&gt;
//    &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
// &lt;/persistence-context-ref&gt;
//
// &lt;!-- EntityManagerFactory resource reference name declaration --&gt;
//  &lt;persistence-unit-ref&gt;
//      &lt;persistence-unit-ref-name&gt;persistence/emf&lt;/persistence-unit-ref-name&gt;
//      &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//  &lt;/persistence-unit-ref&gt;
//
// #Property values for sample references:
// jpa.entityManager: persistence/em
// jpa.entityManagerFactory: persistence/emf
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderCMT</code></b> - for Container Managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the JEE container.
//      After successful method execution the container commits the transaction. In case of execution
//      failure <code>tx.setRollbackOnly()</code> is used to notify container to rollback the
//      transaction.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManager</code></b> and <b><code>jpa.entityManagerFactory</code></b>
//      containing appropriate resource name references configured in
//      <code>/META-INF/ejb-jar.xml</code>. Configuration example:<pre>
// &lt;?xml version="1.0" encoding="UTF-8"?&gt;
// &lt;ejb-jar
//      version = "3.0"
//      xmlns = "http://java.sun.com/xml/ns/javaee"
//      xmlns:xsi = "http://www.w3.org/2001/XMLSchema-instance"
//      xsi:schemaLocation = "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/ejb-jar_3_0.xsd"&gt;
//      &lt;enterprise-beans&gt;
//          &lt;session&gt;
//              &lt;ejb-name&gt;TestEJB&lt;/ejb-name&gt;
//              &lt;persistence-context-ref&gt;
//                  &lt;persistence-context-ref-name&gt;persistence/em&lt;/persistence-context-ref-name&gt;
//                  &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//              &lt;/persistence-context-ref&gt;
//              &lt;persistence-unit-ref&gt;
//                  &lt;persistence-unit-ref-name&gt;persistence/emf&lt;/persistence-unit-ref-name&gt;
//                  &lt;persistence-unit-name&gt;PERSISTENCE_UNIT_NAME&lt;/persistence-unit-name&gt;
//              &lt;/persistence-unit-ref&gt;
//         &lt;/session&gt;
//     &lt;/enterprise-beans&gt;
// &lt;/ejb-jar&gt;
//
// #Property values for sample references:
// jpa.entityManager: persistence/em
// jpa.entityManagerFactory: persistence/emf
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderNoTransactions</code></b> - transactions are
//      not used.<br/>
//      From the +link{group:server_properties,server.properties} file this implementation reads the
//      <b><code>jpa.persistenceUnitName</code></b> property which must containt the name of persistence unit
//      configured in <code>persistence.xml</code> file. For example:<pre>
// jpa.persistenceUnitName: PERSISTENCE_UNIT_NAME
//      </pre></li>
// <li><b><code>com.isomorphic.jpa.EMFProviderSpring</code></b> - for Spring Framework managed Transactions.
//      Every fetch or DML operation acquires the transaction object from the Spring Application Context.<br/>
//      This implementation reads two properties from the +link{group:server_properties,server.properties}
//      file:
//      <b><code>jpa.entityManagerFactory</code></b> and <b><code>jpa.transaction</code></b>
//      containing appropriate bean names configured in Spring Application Context.
//      You have to declare additional bean in your Spring Application Context to allow SmartClient
//      to acquire reference to context.
//      Configuration example:<pre>
// &lt;!-- SpringApplicationContextProvider bean definition required to get access to application context. --&gt;
// &lt;bean id="springApplicationContextProvider" class="com.isomorphic.spring.SpringApplicationContextProvider" /&gt;
//
// &lt;!-- Connection to data base --&gt;
// &lt;bean id="dataSource"
//      class="org.springframework.jdbc.datasource.DriverManagerDataSource"
//      p:driverClassName="DRIVER_CLASS"
//      p:url="CONNECTION_URL"
//      p:username="DB_USER_NAME"
//      p:password="DB_USER_PASSWORD" /&gt;
//
// &lt;!-- Reference to JPA EntityManagerFactory --&gt;
// &lt;bean id="entityManagerFactory" class="org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean"&gt;
//     &lt;property name="dataSource" ref="dataSource" /&gt;
//     &lt;property name="jpaVendorAdapter"&gt;
//        &lt;bean class="org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter"&gt;
//            &lt;property name="database" value="DB_TYPE" /&gt;
//        &lt;/bean&gt;
//     &lt;/property&gt;
//     &lt;property name="persistenceUnitName" value="PERSISTENCE_UNIT_NAME" /&gt;
// &lt;/bean&gt;
//
// &lt;!-- Reference to JpaTransactionManager --&gt;
// &lt;bean id="transactionManager" class="org.springframework.orm.jpa.JpaTransactionManager"&gt;
//     &lt;property name="entityManagerFactory" ref="entityManagerFactory" /&gt;
// &lt;/bean&gt;
//
// #Property values for sample bean names:
// jpa.entityManagerFactory: entityManagerFactory
// jpa.transaction: transactionManager
//      </pre></li>
// </ul>
// You can set <b><code>jpa.emfProvider</code></b> to your own implementation of
// <code>com.isomorphic.jpa.EMFProviderInterface</code> if you have specific requirements for
// transaction handling. <code>EMF</code> will instantiate provided implementation on initialization (static) and
// will use same instance every time. By using own implementation you can have complete control over creating/using
// <code>EntityManagerFactory</code> and <code>EntityManager</code> instances.<p/>
// <b>Additional configurations:</b><p/>
// In case you have several persistence units defined in your <code>persistence.xml</code> you can have additional
// configurations in +link{group:server_properties,server.properties} file. Additional configurations
// (prefixed with <b><code>jpa.</code></b>) should have name, <b><code>emfProvider</code></b> property and other
// properties required by specified EMF provider implementation.
// For example:<pre>
// jpa.configName.emfProvider: com.isomorphic.jpa.EMFProviderLMT
// jpa.configName.persistenceUnitName: ANOTHER_PERSISTENCE_UNIT_NAME</pre>
// To use additional JPA configuration you have to set <b><code>jpaConfig</code></b> property in data source
// definition:<pre>
// &lt;DataSource
//     ID="countryDS"
//     serverType="jpa"
//     beanClassName="com.smartgwt.sample.showcase.server.jpa.Country"
//     jpaConfig="configName"
// &gt;</pre>
// <b>Transaction management:</b>
// <p/><ul>
// <li>Operating under +link{RPCManager} (<code>+link{DSRequest}</code> has reference to
//   <code>+link{RPCManager}</code>):<ul>
//      <li>If participating in automatic transactions:<ul>
//          <li>retrieves existing transaction from <code>+link{RPCManager}</code> (if available);</li>
//          <li>starts new transaction (if not found in <code>+link{RPCManager}</code>);</li></ul></li>
//      <li>If one transaction per operation is used - starts new transaction;</li>
//      <li>Registers itself to <code>DSRequest.registerCallback()</code> for <code>onSuccess()</code>/
//      <code>onFailure()</code> execution to commit/roll back transaction;</li>
//      <li>Sets <code>DSRequest.setFreeOnExecute()</code> to <code>false</code> to postpone releasing
//          of <code>EntityManager</code> avoiding lazy loading exceptions when creating JS response and
//          traversing through persistent object tree;</li>
//      <li>Registers itself to <code>RPCManager.registerFreeResourcesHandler()</code> for <code>freeResources()</code>
//      execution to release <code>EntityManager</code>.</li></ul><br/>
// If you want to use same <code>EntityManager</code> and transaction in your custom data source implementation you can
// acquire it by <pre>JPAConnectionHolder holder = DataSource.getTransactionObject(req, EMF.TRANSACTION_ATTR);</pre>
// <code>JPAConnectionHolder</code> instance contains references to entity manager and transaction object
// used by <code>JPADataSource</code>. You should never commit/rollback automatic transaction.
// Overall commit/rollback will be issued by <code>RPCManager</code> and will be handled by <code>JPADataSource</code>
// object which started transaction.
// </li>
// <li>Operating without +link{RPCManager}:<ul>
//      <li>starts new transaction;</li>
//      <li>commits/rolls back transaction and releases <code>EntityManager</code> if
//          <code>DSRequest.setFreeOnExecute()</code> is set to <code>true</code> (defalut);</li>
//      <li>relies on calling code to call <code>onSuccess()</code>/<code>onFailure()</code> to commit/roll back
//          transaction and to call <code>freeResources()</code> to release <code>EntityManager</code>.<br/>
//          Example code for data source operation execution with manual transaction handling:
//          <pre>
//              DSRequest req = new DSRequest("myDS", "fetch");
//              req.setFreeOnExecute(false);
//              DSResponse resp = req.execute();
//              List dataList = resp.getDataList();
//              //... traverse through persistent object tree
//              // Commit current transaction.
//              ((JPADataSource) r.getDataSource()).onSuccess();
//              // Release entity manager.
//              ((JPADataSource) r.getDataSource()).freeResources(req);
//          </pre></li></ul>
// </li></ul>
// <p>
// <h3>Inbound DSRequest data will use numeric field types from your bean</h3>
// <p>
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will automatically 
// be converted to the type of the target field, before the request is received in a +link{DMI}.  For 
// details, see +link{group:dsRequestBeanTypes}.
// <p>
// <h3>Manual JPA Integration</h3>
// <p>
// In some cases you may not be able to immediately use the built-in JPADataSource - in
// this case take a look at +link{group:manualJpaHibernate,manual Hibernate integration}.
//
// @see group:sqlConnectionPooling
// @treeLocation Concepts/Persistence Technologies
// @title Integration with JPA
// @visibility external
//<

//> @groupDef jpaHibernateRelations
// JPA and Hibernate allow relations to be declared between entities where there is no actual
// Java field for storing the ID of a related entity, even though such a column exists in the
// database.  For example:
// <pre>
//    &#64;ManyToOne
//    &#64;JoinColumn(name="countryId", referencedColumnName="countryId")
//    private Country country;
// </pre>
// JPADataSource and HibernateDataSource support this style of declaration and will
// automatically handle mapping between IDs and entities.
// <p>
// The example above and the following examples assume a DataSource "country" for a
// JPA/Hibernate entity "Country" with an Id field of "countryId", and a DataSource "city" for a
// JPA/Hibernate entity "City" with an Id field of "cityId".
// <p>
// <h3>Many-To-One Relations</h3>
// <p>
// An example of Many-To-One is that Many "City"s belong to One "Country".  In Java, each City
// bean has a field of type Country.  In the database, rows for cities and countries are linked
// by ID.
// <p>
// To specify a many-to-one relation, declare a DataSourceField named after the Java field that
// declares the relation ("country" above) with the property
// +link{attr:DataSourceField.foreignKey,foreignKey} pointing to related DataSource's primary key:
// <pre>
//    &lt;field name="country" foreignKey="country.countryId"/&gt;
// </pre>
// When delivered to the browser, the value of the <code>country</code> field will be the ID of
// the related Country entity.  The <code>country</code> field can be treated as a normal text
// or integer field value, for example, you can use a +link{SelectItem} that uses
// +link{SelectItem.optionDataSource} to allow selecting the ID of a different related
// entity.  Then, when the new ID is saved to the server, JPADataSource automatically looks up
// the related object and persists the new relation to JPA.
// <p>
// <b>NOTE:</b>: do not declare a "type" attribute for such a field - these fields provide
// specialized mapping between IDs and JPA/Hibernate entities, so don't really have a single
// concrete type.
// <p>
// If you want fields from a related entity to be included whenever your entity is fetched, for
// example, whenever a city is fetched you want the <code>countryName</code> fetched from the
// related <code>country</code> entity, use +link{DataSourceField.includeFrom}.
// <p>
// <b>Automatic Criteria translation</b>
// <p>
// If criteria are submitted for a ManyToOne relation field containing an ID value, this will
// correctly return Records that are associated with the related object that has that ID.
// <p>
// For example, given a countryId of "1", you can fetch all city Records that are related to
// that countryId as follows:
// <smartclient>
// <pre>
//   isc.DataSource.get("city").fetchData({ countryId: 1 }, &lt;callback/&gt;);
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
//    DataSource.get("city").fetchData(new Criteria("countryId", "1"), &lt;callback/&gt;);
// </pre>
// </smartgwt>
// <p>
// <h3>One-to-Many Relations</h3>
// <p>
// An example of One-To-Many relation is that One "Country" has Many "City"'s.  Each "Country"
// has a list of cities within it, which may be declared as a Java bean property of Collection
// type (or List, Set, etc).
// <p>
// To specify a one-to-many relation, declare a DataSourceField that:
// <ul>
// <li> is named after the Java field that declares the OneToMany relation (whose type is a
//      Collection of the related entities)
// <li> declares its "type" to be the ID of the related DataSource
// <li> declares a +link{attr:DataSourceField.foreignKey,foreignKey} pointing to the related
//      DataSource's primaryKey field
// <li> sets multiple="true"
// </ul>
// For example, for a Country bean that has a Collection of City beans:
// <pre>
//     &lt;field name="cities" type="city" multiple="true" foreignKey="city.cityId"/&gt;
// </pre>
// With this declaration, whenever Records are loaded from the Country DataSource, they will
// contain a list of City Records as subobjects, accessible via 
// <smartgwt><code>countryRecord.getAttributeAsRecordList("cities")</code></smartgwt>
// <span class="client">countryRecord.cities</span>
// <p>
// If loading all related "city" records is desirable in some circumstances and not others, you
// can use +link{operationBinding.outputs} to avoid loading "city" records for certain
// operations.
// <p>
// <h3>Many-To-Many Relations</h3>
// An example of Many-To-Many relation is that Students have multiple Courses and each Course has 
// multiple Students. In Java each Student bean has a list of Courses and each Course bean has a 
// list of Students. In database tables are linked using additional table holding references to 
// both students and courses.
// <P>
// To set up Many-To-Many relation between data sources you need to set up One-To-Many relation on 
// both sides.
// <P>
// For example students DataSourceField for CourseDS data source:
// <pre>
//     &lt;field name="students" type="integer" foreignKey="StudentDS.id" multiple="true" /&gt;
// </pre>
// and courses DataSourceField for StudentDS data source:
// <pre>
//     &lt;field name="courses" type="integer" foreignKey="CourseDS.id" multiple="true" /&gt;
// </pre>
// Note that type attribute can be safely omitted here.
// <P>
// <b>Note</b> that alternative type declaration to be ID of related data source (as in regular 
// One-To-Many relation case) would work as expected, but is <b>not recommended</b> to use, cause 
// it would result in getting lots of copies of same data. Smartclient server will prevent infinite 
// loops, but still lots of unnecessary data will be sent to client.
// <P>
// <h3>Alternative: Many-To-One loading complete related object</h3>
// <p>
// For a Many-To-One relation, instead of loading just the ID of the related object, you can
// load the entire related object as a nested Record.  To do so, just declare the type of the
// field to be the ID of the related DataSource, rather than leaving type unset:
// <pre>
//     &lt;field name="country" type="country" foreignKey="country.countryId"/&gt;
// </pre>
// The nested "country" Record will be available on a "city" record via 
// <smartgwt><code>cityRecord.getAttributeAsRecord("country")</code></smartgwt>
// <smartclient>cityRecord.country</smartclient>.
// Saving a City record that contains a nested Country record in the "country"
// attribute will result in the Country being updated in JPA/Hibernate.
// <P>
// This mode is not typically used, since loading just the ID of the related Country object is
// more efficient if many cities are being loaded, and the related Country object can always be
// loaded with a second fetchData() data, which can still be done in a single HTTP request via
// +link{isc.RPCManager.startQueue(),queuing}.
// <P>
// <h3>Alternative: One-To-Many loading related IDs</h3>
// <p>
// For a One-To-Many relation, instead of loading the complete list of related objects, you can
// load just a list of their IDs.  To do so, just omit the type declaration when declaring the
// relation:
// <pre>
//    &lt;field name="cities" multiple="true" foreignKey="city.cityId"/&gt;
// </pre>
// When saving, if a replacement list of IDs is included in the Record, the appropriate
// JPA/Hibernate relationships will be updated.
// <P>
// This is very rarely used, and would typically only be used by client-side code that plans to
// programmatically work with the list of related IDs rather than display them in a UI
// component.
// <p>
// <h3><b>NOTE:</b> Bidirectional relations</h3>
// <p>
// When relations are declared, JPA and Hibernate consider only one of the two entities to be
// the "owner" of the relation, meaning essentially that the references that make up the
// relationship are stored with that entity.  When performing updates, make sure you update the
// entity that "owns" the relation.  All changes to relations on "non-owning" entities are
// silently discarded.
// <p>
// <h3>Search criteria on One-to-Many and Many-to-Many relations</h3>
// <p>
// The following +link{Operator,search operators} are supported with the behaviors listed
// below.  For simple Criteria, criteria values are treated identically to the "equals"
// operator and the +link{dsRequest.textMatchStyle,textMatchStyle} is ignored.
// <P>
// Examples are given in terms of a "country" DataSource that has a one-to-many relation with a "city"
// DataSource through a relation field called "cities"
// <p>
// <table border=1 class="normal">
// <tr>
// <td>Operator</td><td>Behavior</td>
// </tr>
// <tr>
// <td><code>isNull</code></td><td>matches country records which have no related cities</td>
// </tr>
// <tr>
// <td><code>notNull</code></td><td>matches country records which have at least one related city</td>
// </tr>
// <tr>
// <td><code>equals, notEqual</code></td><td>
// <code>criterion.value</code> should be a primaryKey value for the related
// city DataSource.  This criterion matches any country which
// contains the passed city (or for "notEqual", matches any country which
// <b>does not</b> contain the passed city.  
// </td>
// </tr>
// <tr>
// <td><code>inSet, notInSet</code></td><td>
// <code>criterion.value</code> should an array of primaryKey values for the
// related city DataSource.  This criterion matches any country which
// contains <b>any</b> of the passed cities (or for "notInSet", which
// contains <b>none</b> of the passed cities).</td>
// </tr>
// </table>
// The following is an example of a criterion for matching a "country" records which have related
// cities with primaryKey values 1, 2 or 3 (shown serialized as JSON):
// <pre>
//   {fieldName:"cities", operator:"inSet", value:[1,2,3]}
// </pre>
// As an alternative syntax, "equals", "notEqual", "inSet" and "notInSet" will also allow
// <code>criterion.value</code> to be specified as a list of Objects, each containing the
// primaryKey field and its value:
// <pre>
//      {fieldName:"cities",operator:"inSet",value:[{cityId:1},{cityId:2},{cityId:3}]}
// </pre>
// The operators explained above work the same way for Many-To-Many relation fields.
// <p>
// Any other operator applied to a relation field will cause a warning to be logged, and will be
// treated as though the criterion were not present (matches all records).
//
// @treeLocation Concepts/Persistence Technologies
// @title JPA &amp; Hibernate Relations
// @visibility external
//<

//> @groupDef manualJpaHibernate
// In some cases you may not be able to immediately use the built-in JPADataSource or
// HibernateDataSource.  For example, you have pre-existing business logic that already
// directly calls JPA or Hibernate APIs, and it may seem to be a large task to refactor this
// logic so that the built-in DataSources can be used.
// <p>
// In this case you can use the overall approach described in
// +link{group:serverDataIntegration} to connect to your pre-existing business logic.  You will
// not be leveraging any of the built-in JPA or Hibernate functionality, so the approach and level of
// effort will be the same as if you were using a non-Hibernate ORM or integrating with
// entirely custom Java classes.
// <P>
// +explorerExample{reusableORMDataSource,This example} shows a Hibernate-based implementation of
// a custom DataSource that implements support for simple Criteria, sorting and data paging,
// but not +link{AdvancedCriteria}, +link{dataSourceField.includeFrom,automatic joins},
// automatic transactions or many other features built into HibernateDataSource.  
// <P>
// Because these features are very valuable and more features are added to the built-in
// DataSources all the time, it's recommended that you refactor your code to use the built-in
// DataSources as soon as you can; refactoring existing business logic as validators, DMIs, or
// custom DataSources is often easier than it looks.  
// <P>
// You can also take the approach of using the built-in DataSources for new entities or
// entities where there is currently no significant business logic, while continuing to use
// your existing code where it's non-trivial to refactor.
//
// @title Manual JPA &amp; Hibernate Integration
// @treeLocation Concepts/Persistence Technologies
// @visibility external
//<

//> @groupDef hbBeans 
//
// This section relates to JPA and Hibernate datasources and describes how submitted data 
// is used and what to expect in <code>DSResponse</code> if Smartclient is integrated with 
// Hibernate using "Pre-existing beans" approach (see +link{hibernateIntegration} for details).
// <p>
// Note that "beanless" integration mode is completely omitted here, since in that case data is 
// represented by <code>Maps</code> instead of <code>Beans</code>.
// <p>
// <h3>Data sent in DSRequest</h3>
// In case of add or update operations +link{dsRequest.data,DSRequest data} is used to populate 
// associated <code>Bean</code>:
// <ul>
//   <li>add - new <code>Bean</code> is created and filled with submitted data</li>
//   <li>update - existing <code>Bean</code> is retrieved and then submitted data is set overwriting 
// existing values</li>
// </ul>
// New values are applied using <code>DataSource.setProperties(...)</code> server-side API, which performs 
// automatic conversions of any types that can reasonably be auto-converted, supports inner beans and 
// recursive data structures, see server-side javadocs for details.
// <p>
// <h3>Data returned in DSResponse</h3>
// In case of getting access to DSResponse (for example, by manually executing DSRequest in a +link{dmi}), 
// DSResponse data can be accessed by calling <code>DSResponse.getData()</code> server-side API. See what 
// data will be returned depending on +link{dsRequest.operationType,operation type} and other circumstances:
// <p>
// <table border="1" class="normal" width="90%" cellpadding="5">
// <tr>
//   <td>Operation type</td>
//   <td>DSResponse data</td>
// </tr><tr>
//   <td width="20%">Fetch</td>
//   <td>Generally fetch operation will return <code>List</code> of <code>Beans</code> or empty 
// <code>List</code> if no records were found. However some features, if used, do break this rule:
//     <ul>
//       <li>If +link{dsRequest.outputs} (or +link{operationBinding.outputs}) is set, then only 
// fields listed in outputs are fetched from Database and, accordingly, DSResponse data will return  
// <code>List</code> of <code>Maps</code> each <code>Map</code> holding only requested set of 
// field/value pairs.</li>
//       <li>If Server Summaries feature is used, then DSResponse data will also return 
// <code>List</code> of <code>Maps</code> each <code>Map</code> holding only field/value pairs
// involved in summary query, i.e. only fields listed in +link{dsRequest.groupBy} and 
// +link{dsRequest.summaryFunctions}, see +link{serverSummaries,Server Summaries overview} for details.<p>
//     </ul>
//   </td>
// </tr><tr>
//   <td width="20%">Add</td>
//   <td>
//     Add operation will return created <code>Bean</code>.
//   </td>
// </tr><tr>
//   <td width="20%">Update</td>
//   <td>
//     If multiple records update is allowed (see +link{operationBinding.allowMultiUpdate} and 
// +link{MultiUpdatePolicy}}), then update operation will return <code>List</code> of <code>Beans</code>,
// or empty <code>List</code> if no records were actually updated. If multiple records update is not 
// allowed, then update operation will return updated <code>Bean</code>, or <code>null</code> if 
// record was not updated (for example, in case if it does not exist).
//   </td>
// </tr><tr>
//   <td width="20%">Remove</td>
//   <td>
//     If multiple records update is allowed, then remove operation will always return <code>null</code>. If 
// multi records update is not allowed, then remove operation will return a <code>Map</code> holding field/value 
// pairs for +link{dataSourceField.primaryKey, Primary Key fields} of the record requested to be removed, no matter 
// if the record was actually removed. Consult <code>DSResponse.getAffectedRows()</code> server-side API to see if 
// the record was removed, or how many records were removed in case of multiple records removal.
//   </td>
// </tr>
// </table>
//
// @treeLocation Concepts/Persistence Technologies
// @title Beans and the DSRequest / DSResponse
// @visibility external
//<

//> @groupDef dsRequestBeanTypes
// 
// For fields with numeric types, the +link{dsRequest.data,record data} in DSRequests will 
// automatically be converted to the type of the target field, before the request is received 
// in a +link{DMI}.
// <p>
// For example, if +link{dataSource.beanClassName,your bean} has a field "price" of type Float, 
// an "update" DSRequest with a new value for this field will use the Java Float type for the 
// new value, whereas in the absence of a bean, the Double type would ordinarily be used 
// (see +link{rpcRequest.data}).
// <p>
// This happens only for fields of type <i>integer</i>, <i>sequence</i>, <i>intEnum</i> and
// <i>float</i>. Because the conversion is performed as part of server-side validation, it 
// applies only to "update" or "add" requests, and does not apply to +link{dsRequest.oldValues},
// which will continue to use the generic types listed in +link{rpcRequest.data}.
// <P>
// Note that, while values for non-numeric fields will still use basic Java types (for example,
// values for Java Enum fields will arrive +link{dataSource.enumTranslateStrategy,as Strings by 
// default}), manual conversion of the remaining data is not necessary; the server-side API 
// <code>DataSource.setProperties()</code> does all remaining conversion necessary to populate 
// a bean from the request data (see that API's docs for details), and this conversion
// will be performed automatically if your DMI logic calls <code>execute()</code> on the DSRequest.
// <P>
// You may need to explicitly define what Java type must be used during conversion for a given
// field. This can be achieved by setting +link{dataSourceField.javaClass} property.
// <p>
// If conversion fails, because of target field using an abstract Java type or invalid 
// class defined in DSField.javaClass property etc, conversion will fall back to its 
// default behavior, i.e. Java type will be guessed from the actual field value. 
// It would be Long for integer based types and Double for float type or, if the value would 
// appear to exceed the ranges of these types, BigInteger and BigDecimal accordingly.
// 
// @title DSRequest data auto-converted to bean types
// @visibility external
//<

//> @groupDef gaeIntegration
// Google App Engine (GAE) is a platform-as-a-service (PaaS) offering from Google, which
// supports cloud deployment of applications written in Java and other languages, as well as
// SQL or JPA access to highly scalable storage (both Google CloudSQL and BigTable-based
// solutions).
// <p>
// SmartClient applications, including those based on the SmartClient Server Framework, can be
// deployed to GAE and can integrate with Google CloudSQL either via SQLDataSource or via JPA,
// and can also use Google's BigTable-based storage via JPA.
// <P>
// For further information, setup instructions and example configuration, see our
// +externalLink{http://wiki.smartclient.com/display/Main/Google+App+Engine,public wiki}
//
// @see group:jpaIntegration
// @treeLocation Concepts/Persistence Technologies
// @title Google Application Engine (GAE)
// @visibility external
//<

//> @groupDef sqlConnectionPooling
// <b>This discussion applies primarily to the built-in SQL DataSource provided in Pro and 
// better editions of SmartClient, though elements of it also apply to the built-in Hibernate
// and JPA DataSources</b>
// <p>
// SQLDataSource communicates with database products using 
// <a href=http://docs.oracle.com/javase/7/docs/api/java/sql/Connection.html>JDBC Connection
// objects</a>.  These Connections are provided by the individual database products' JDBC 
// drivers; they either wrap the database's native mechanism for a client-server connection,
// or they implement a pure Java equivalent of the same thing.  All read and update operations
// performed by SQL DataSource take place via one of these connections.  Also, 
// +link{DataSource.autoJoinTransactions,SQL transactions} are implemented by having the queue
// of related updates take place through the same connection, with a single commit (or 
// rollback) at the end of the queue.
// <p>
// Database connections are a limited resource, and they can also be expensive to acquire.  For
// both of these reasons, SmartClient by default uses the Apache DBCP pooling library to 
// maintain a pool of resuable connections.  Connections are borrowed from the pool as required,
// and returned to the pool when they are no longer needed, and the pooling library ensures that
// connections are only lent out to one borrowing process at any given time.  This arrangement
// is efficient in terms of both connection acquisition speed and the number of connections 
// required<ul>
// <li>Reusing an existing connection is typically faster than asking the database for a new 
// one; depending on the database, it can be much faster</li>
// <li>Reusing the same connections over and over means that applications require fewer 
// connections to handle the same workload.  Even busy applications handling hundreds of 
// concurrent users typically require a much smaller number of pooled connections than might 
// be thought at first glance</li>
// </ul>
// For these reasons, we ship SmartClient with connection pooling switched on, and we recommend
// you leave it that way.
// <h3>Connection pool settings</h3>
// You configure the behavior of SQL connection pooling with the following 
// <code>server.properties</code> settings (note, many of these settings map directly to 
// settings in the underlying DBCP library; you can find out more about their effects in the
// <a href=http://commons.apache.org/proper/commons-dbcp/configuration.html>DBCP docs</a>):
// <p>
// <table border="1">
// <tr><td><code>sql.pool.enabled</code></td><td>Set true/false to enable or disable the entire  
// SQL connection pooling feature.  Defaults to true</td></tr>
// <tr><td><code>sql.pool.maxActive</code></td><td>Maximum number of "active" (ie, currently
// lent out) connections.  Defaults to -1, which means "no limit"</td></tr>
// <tr><td><code>sql.pool.maxIdle</code></td><td>Maximum number of "idle" (ie, currently 
// sitting in the pool, not lent out) connections.  Defaults to -1, which means "no limit"</td></tr>
// <tr><td><code>sql.pool.minIdle</code></td><td>Minimum number of "idle" (ie, currently
// sitting in the pool, not lent out) connections.  If the pool drops below this number of 
// idle connections, new ones will be created.  Defaults to -1, which means "no minimum"</td></tr>
// <tr><td><code>sql.pool.whenExhaustedAction</code></td><td>Specifies what the pool should do
// if the system attempts to borrow a connection and there are no idle connections to lend.<ul>
// <li>"fail" will throw an Exception and the SQL operation will fail</li>
// <li>"block" will cause the borrowing thread to block until a connection becomes available</li>
// <li>"grow" will create a new connection, add it to the pool, and then return it to the 
// borrowing thread.  Note, if you use this strategy, the "maxActive" setting has no effect</li>
// </ul>The default value is "grow"</td></tr>
// <tr><td><code>sql.pool.testOnBorrow</code></td><td>If true, we attempt to validate the 
// connection before lending it out.  This validation involves checking if the connection is 
// marked as closed, and also running a "pingTest" query if one is defined (see the section on
// per-database configuration, below).  If validation fails, the connection is discarded and 
// another one selected from the pool.  Defaults to true</td></tr>
// <tr><td><code>sql.pool.testOnReturn</code></td><td>The same as <code>testOnBorrow</code>, 
// but the checking occurs when the connection is returned to the pool rather than when we are 
// about to lend it out.  Defaults to false</td></tr>
// <tr><td><code>sql.pool.testWhileIdle</code></td><td>The same as <code>testOnBorrow</code>, 
// but the checking is done by the idle connection evictor (see below) during its periodic 
// inspection of the idle objects in the pool.  Defaults to false</td></tr>
// <tr><td><code>sql.pool.timeBetweenEvictionRunsMillis</code></td><td>DBCP can optionally run
// an "idle connection evictor" thread, which periodically checks the pool for connections 
// that have been idle for more than a threshold time, and "evicts" them from the pool (ie,
// closes and then discards them).  The purpose of this is to keep the connection pool at the 
// intended size, instead of allowing it to remain at whatever size it reached during the 
// system's busiest time.  Without an evictor, it would not be unusual to see the number of 
// connections in the pool grow towards <code>maxActive</code> over time, or even beyond it 
// if the pool is configured to grow when exhausted.  If this is not what you want, configure
// an eviction thread.  However, note that the eviction thread contends with the main pooling
// code for access to the idle connections; if you set the evictor to run very frequently, it
// can introduce performance issues.
// <p>
// This property specifies the number of milliseconds to sleep between runs of the idle 
// connection evictor.  If set to a negative value, no evictor will be run.  Defaults to -1 
// (ie, no eviction thread)</td></tr>
// <tr><td><code>sql.pool.minEvictableIdleTimeMillis</code></td><td>The minimum time a
// connection may sit idle in the pool before it is eligible for eviction.  If set to a 
// negative value, connections will never be evicted due to the length of time they have sat 
// idle (a connection will only be evicted if <code>testWhileIdle</code> is true and it 
// fails validation).  Defaults to -1</td></tr>
// <tr><td><code>sql.pool.numTestsPerEvictionRun</code></td><td>The number of connections to
// check during each eviction run.  Defaults to -1, which means check all objects in the pool
// (this is not documented by Apache, but negative values are treated as the denominator in 
// determining a fraction of the pool size, so -2 means check half the connections, -3 means 
// check a third, etc)</td></tr>
// </table>
// <p>
// In addition to the <code>sql.pool</code> configuration subtree, you can specify per-database
// configuration by adding the +link{dataSource.dbName,dbName} to the property, like so:<pre>
//     sql.mydatabase.pool.enabled: true
//     sql.mydatabase.pool.numTestsPerEvictionRun: 10
//     # etc...
// </pre>
// There is also a configuration property outside the <code>sql.pool</code> and 
// <code>sql.{DBNAME}.pool</code> trees that is nevertheless part of SQL connection pooling 
// configuration.  This property, <code>sql.{DBNAME}.pingTest</code>, should be a small SQL 
// fetch query, ideally a dummy fetch that runs very quickly and returns a single row.  As 
// discussed above, this "pingTest", if configured, is used to determine if a connection is 
// valid before lending it out.  Most databases have a traditional, proprietary query that fits 
// the bill, but it varies by database. Some example pingTest queries:<pre>
//     # Oracle
//     sql.OracleDatabase.pingTest: select 1 from dual
//     # SQL Server
//     sql.mssqlserverdb.pingTest: select 'x'
//     # DB2
//     sql.db2database.pingTest: select 'x' from SYSIBM.SYSDUMMY1
// </pre>
// <h3>Troubleshooting issues related to connection pooling</h3>
// Many databases will automatically close inactive connections, which can interfere with
// connection pooling: if an application is not constantly using all of the connections in its
// pool, it may retrieve a closed connection from the pool.
// <P>
// In some cases you can disable the behavior of closing inactive connections.  For MySQL it's
// controlled by the
// +externalLink{http://dev.mysql.com/doc/refman/5.0/en/server-system-variables.html#sysvar_wait_timeout,wait_timeout}
// setting in your my.cnf file).  However, this could potentially cause leaked connections if
// applications terminate without cleaning up their database connections.
// <P>
// Intelligent connection pools compensate for unexpectedly closed connections automatically:
// <ul>
// <li>J2EE containers generally implement internal keepalives or staleness checks - this is
// the preferred solution if available.  If using SQLDataSource, use JNDI-based
// configuration as described +link{group:dbConfigTool,here}.
// <li>SQLDataSource uses DBCP (Apache Commons) pooling, which also compensates for connection
// closure automatically.  This is enabled by default with appropriate settings, but can be
// disabled system wide via setting <b>sql.pool.enabled</b> to false in
// +link{group:server_properties,server.properties}, or
// disabled for a specific database configuration via <b>sql.<i>dbName</i>.pool.enabled</b>.
// The following properties can also be set on sql.pool / sql.<i>dbName</i>.pool and control
// same-named DBCP properties, however, it is not recommended to set these properties unless
// you have experience with DBCP and are troubleshooting a specific pool-related performance
// problem: testOnBorrow, testOnReturn, testWhileIdle, timeBetweenEvictionRunsMillis,
// minEvictableIdleTimeMillis, numTestsPerEvictionRun.
// <p>
// When the pool is configured for connection validation, as it is by default, a SQL statement 
// is run to verify the condition of its connection.  To control the timeout value on this statement, 
// set the sql.validationQueryTimeout / sql.dbName.validationQueryTimeout property (in seconds, default value is 10).
// <p>
// If you are trying to diagnose an issue related to SQL connection pooling, you can enable
// DEBUG logging for the following classes in <code>log4j.isc.config.xml</code> (see
// installation instructions for details about this file).  All of these classes are in package
// <code>com.isomorphic.sql</code>:
// <ul>
// <li> PoolableSQLConnectionFactory: logs connection creation, and whether or not the
//      connections are pooled
// <li> SQLConnectionManager: logs when connections are borrowed
// <li> SQLDriver: logs the hashCode of the connection when SQL statements are executed
// <li> SQLTransaction: logs transactional open, commit, rollback and close.
// </ul>
// <li>JPA/Hibernate: Hibernate's built-in connection pool is <b>not</b> intended for
// production use according to Hibernate's own documentation.  This includes using JPA with
// Hibernate as the provider. If you get dead connections during development you can disable
// Hibernate's built-in connection pool by setting "hibernate.connection.pool_size" to 0. For
// production use you must use production-ready connection pool libraries for example
// C3P0. Here are recommended settings for C3P0 properties:
// <ul>
// <li>c3p0.acquireRetryDelay=1000</li>
// <li>c3p0.acquireRetryAttempts=60</li>
// <li>c3p0.breakAfterAcquireFailure=false</li>
// </ul>
// </li>
// </ul>
// @treeLocation Concepts/Persistence Technologies
// @title SQL Connection Pooling
// @visibility external
//<

//> @groupDef standaloneDataSourceUsage
// The DataSource layer can be used in a standalone application separate from a servlet engine,
// for use cases like offline batch data processing, sending emails based on database
// state, or integration of SmartClient Server logic into a standalone Java Swing application.
// <p>
// In addition, the section below on "Transactions in standalone applications" also applies to
// any transaction that is initiated separately from an RPCManager and/or the HttpServletRequest
// lifecycle.  This includes use cases like non-servlet web apps (using NIO servers like
// Grizzly), web apps that set timers to perform delayed actions (using frameworks such as
// Quartz), as well JMS or other Java frameworks that may introduce non-HttpServletRequest threads
// within a servlet container.
// <p>
// Note that we do still require <code>servlet-api.jar</code> to be on the classpath of 
// standalone applications.  This is only to satisfy class-loading requirements; there are 
// cases where running inside a servlet engine allows us to provide extra functionality, such
// as declarative authentication and authorization features, so some classes do have member 
// variables or method parameters of types in the Servlet API.  They all operate correctly 
// when these variables or parameters are null, but the JVM will still try to load the classes 
// and will crash if they are missing.
// <p> 
// Using the DataSource layer to run DataSource operations in your standalone applications is
// extremely straightforward.  This example fetches and prints every record from the 
// "customers" DataSource:
// <pre>
//   public static void main(String[] args) {
//     DataSource ds = DataSourceManager.get("customers");
//     List records = ds.fetch();
//     for (Iterator i = records.iterator; i.hasNext(); ) {
//       System.out.println(i.next());
//     }
//   }
// </pre>
// To make this example fetch just customers in the United States:
// <pre>
//     Map criteria = new HashMap();
//     criteria.put("countryCode", "US");
//     List records = ds.fetch(criteria);
// </pre>
// This example shows how to run a specific fetch operation, specifying both selection 
// criteria and a sort order, using a <code>DSRequest</code> rather than a <code>DataSource</code> 
// convenience method:
// <pre>
//   public static void main(String[] args) {
//     DSRequest dsReq = new DSRequest("customers", "fetch");
//     dsReq.setOperationId("specialFetch");
//     Map criteria = new HashMap();
//     criteria.put("countryCode", "US");
//     criteria.put("region", "CA");
//     dsReq.setCriteria(criteria);
//     dsReq.setSortBy("customerName");
//     List records = dsReq.execute().getDataList();
//   }
// </pre>
// This example shows how to do a simple update:
// <pre>
//   public static void main(String[] args) {
//     DataSource ds = DataSourceManager.get("customers");
//     Map criteria = new HashMap();
//     criteria.put("customerNo", 12345);
//     Map values = new HashMap();
//     values.put("creditLimit", 10000);
//     values.put("currencyCode", "USD");
//     ds.update(criteria, values);
//   }
// </pre>
// Finally, this example shows how to perform a specific update operation via a 
// <code>DSRequest</code>:
// <pre>
//   public static void main(String[] args) {
//     DSRequest dsReq = new DSRequest("customers", "update");
//     dsReq.setOperationId("specialUpdate");
//     Map criteria = new HashMap();
//     criteria.put("customerNo", 12345);
//     Map values = new HashMap();
//     values.put("creditLimit", 10000);
//     values.put("currencyCode", "USD");
//     dsReq.setCriteria(criteria);
//     dsReq.setValues(values);
//     dsReq.execute();
//   }
// </pre>
// <b>NOTES</b>
// <p>
// Because we are not running inside a servlet container, SmartClient's built-in logic to 
// work out where its application root is does not work.  Therefore, you need to manually 
// set a "webRoot" in your +link{group:server_properties,server.properties} file. 
// The webRoot should point
// to the root folder of your application (note for SmartGWT applications, this is typically
// the "war" subfolder of your project).  Example entries:<p>
// <code>    webRoot: /home/testUser/myProject</code><p>
// or:<p>
// <code>    webRoot: C:\Projects\MyProject\war</code><p>
// Again in +link{group:server_properties,server.properties}, 
// you may need to set <code>isomorphicPathRootRelative</code>
// to match the standalone project's layout if you make the standalone mode separate:<p>
// <code>    isomorphicPathRootRelative: myProject/sc</code>
// <p>
// <smartgwt>
// Note that the directory structure that normally appears in "war/<i>myProject</i>/sc" in your
// GWT project is required to be present under the configured
// <i>webRoot</i>+<i>isomorphicPathRootRelative</i> directory when running standalone.  This structure is
// normally created by the GWT compiler, by processing &lt;inherits&gt; tags in your .gwt.xml
// that cause resources to be copied from smartgwtee.jar.  If your build/deployment scripts do
// not invoke the GWT compiler these files will not be present, so you will need to either add
// a step to invoke the GWT compiler or manually copy the files.
// </smartgwt>
// You should place the +link{group:server_properties,server.properties} file somewhere on your classpath.  
// Typically, the root of your <code>bin</code> or <code>classes</code> folder structure is 
// the most suitable place for it.
// <p>
// Both the built-in DataSources and custom DataSources can be used in standalone
// applications, <b>but only if you do not introduce dependencies on the servlet container in
// your DataSource code</b>. For example, if you have a security check in a DMI or custom
// DataSource that depends on checking the current logged-in user, code in a means of bypassing
// this, or create a parallel operationBinding that is accessible only to the superuser.
// <br>
// <h3>Declarative Security</h3>
// <p>
// When you use the DataSource layer in a standalone application,
// +link{dataSource.requiresAuthentication,Declarative Security} has to be explicitly controlled.
// <p>
// To enable a request for security checks you simply need to call <code>dsRequest.setUserId()</code>
// or <code>dsRequest.setUserRoles()</code>. If the request is apart of a transaction then security
// can also be defaulted using <code>dsTransaction.setClientRequest(true/false)</code>, however
// any value set on an individual request will still take priority. For instance if you call
// <code>dsTransaction.setClientRequest(false)</code> but then also call <code>dsRequest.setUserId(id)</code>,
// then security checks will still take place for that request as it has had security enabled which
// takes priority over the value on <code>DSTransaction</code>.
// <p>
// Note: If you have Declarative Security checks in your DataSources and/or enabled via your Java
// code, and you want to completely disable such checks system-wide, you can  set
// <code>security.disabled: true</code> in +link{group:server_properties}.  This causes API calls
// like <code>dsRequest.setClientRequest()</code> to be completely ignored.
//
// <h3>Transactions</h3>
// <p>
// In standalone mode, transactions cannot be automatically initiated with the HTTP request lifecyle,
// however you can still manually initiate and commit transactions (note, only available with a Power
// or better license).  To do so, create a <code>DSTransaction</code> object and associated each
// <code>DSRequest</code> with it via <code>dsRequest.setDSTransaction()</code>.  At the end of
// processing, call <code>DSTransaction.complete()</code> to ensure commits and rollbacks are
// executed and that resources are freed up.
// <p>
// Usage Example:
// <pre>
//     DSTransaction dst = new DSTransaction();
//     DSRequest req1 = new DSRequest("myDataSource", "update");
//     req1.setDsTransaction(dst);
//
//     DSRequest req2 = new DSRequest("myDataSource", "add");
//     req2.setDsTransaction(dst);
//
//     DSRequest req3 = new DSRequest("myDataSource", "update");
//     req3.setDsTransaction(dst);
//
//     try {
//         // This will process the queue of requests which have been registered with the transaction.
//         dst.processQueue();
//     } finally {
//         // We put this in a "finally" block to ensure it always runs even on exceptions.
//         dst.complete();
//     }
// </pre>
// <p>
// You can also handle the requests manually instead of using <code>dsTransaction.processQueue()</code>.
// This can be handy if you wish to perform another operation in between each request or if one
// request depends on data from the other.  At the end of processing, call
// <code>DSTransaction.complete()</code> to ensure commits and rollbacks are executed and that
// resources are freed up.
// <p>
// Usage Example:
// <pre>
//     DSTransaction dst = new DSTransaction();
//
//     try {
//         DSRequest req1 = new DSRequest("myDataSource", "fetch");
//         req1.setDsTransaction(dst);
//
//         DSRequest req2 = new DSRequest("myDataSource", "update");
//         req2.setDsTransaction(dst);
//
//         req1.execute();
//         // Use the response from req1 to modify req2 here
//         req2.execute();
//     } catch (Exception e) {
//         throw new RuntimeException(e);
//     } finally {
//         // We put this in a "finally" block to ensure it always runs even on exceptions.
//         dst.complete();
//     }
// </pre>
// <p>
// Please note that +link{group:transactionChaining,Transaction chaining} is supported while
// using transactions in a standalone use case - expressions such as <code>$responseData</code>
// will refer to results from previous <code>DSRequests</code> that are part of the same
// <code>DSTransaction</code>.
// <p>
// <b>Note the following about standalone transactions:</b>
// <ul>
// <li>DSRequests that have not had <code>setDSTransaction()</code> called will be outside of
// any transactional processing - they will be auto-committed at the end of request
// processing.</li>
// <li>You may partition your updates into multiple transactions, simply by creating multiple
// <code>DSTransaction</code> objects and assigning them to DSRequests as required.  Note, this
// will tie up a database connection per <code>DSTransaction</code> until the transactions are
// committed or rolled back.</li>
// <li>When using the DSTransaction's built in <code>processQueue()</code> method, error handling
// will be taken care of automatically for each <code>DSRequest.execute()</code> call and a
// proper <code>DSResponse</code> will always be returned.</li>
// <li>Your code is responsible for calling the <code>complete()</code> method, which will
// commit the transaction if every DSRequest was successful, or roll it back if there were any
// failures, and then release the database connection. If you do not call
// <code>complete()</code>, you will leak database connections, so consider placing the call
// inside a <code>finally</code> block</li>
// <li>If you do not want SmartClient Server's default behavior of automatically rolling back
// if any DSRequest failed, you can manually take over the transaction management by calling
// <code>commit()</code> or <code>rollback()</code> instead of <code>complete()</code>.  Note,
// if you do this you also take on responsibility for releasing the database connection by
// calling <code>freeQueueResources()</code> or <code>freeAllResources()</code>.  If you fail
// to do this, you will leak database connections</li>
// <li>A DSTransaction object can be re-used after <code>complete()</code> has been called.
// When you do this, a new database connection is borrowed or established, and a new
// transaction is started</li>
// </ul>
//
// <h3>Spring Framework</h3>
// <p>
// In a typical web application, Spring configuration is picked up from an "applicationContext"
// file by a servlet or listener, and then made available to the rest of the app via the
// servletContext.  When running standalone, this is not possible, so instead we read the
// applicationContext file manually when we need to, eg, create a DataSource object that is
// configured as a Spring bean.
// <p>
// By default, the framework will look in the "normal" place for for this configuration:
// <code>WEB-INF/applicationContext.xml</code>.  If you have changed the location or name
// of this file, and you want to run the application outside of a servlet engine, you can tell
// the framework where to find the configuration file by specifying property
// <code>standalone.spring.applicationContext</code> in your +link{group:server_properties,server.properties}.
// The default setting for this property looks like this:<pre>
//    standalone.spring.applicationContext: $webRoot/WEB-INF/applicationContext.xml
// </pre>
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Standalone DataSource Usage
// @see transactionChaining
// @visibility external
//<



//> @groupDef sqlDataSource
// The SmartClient Server supports comprehensive, codeless SQL connectivity for DataSources
// defined in XML.  Our SQL connectivity is mature, feature-rich, protected against injection
// attacks and easily customizable to support user-written SQL and additional business logic
// of any complexity.  +link{group:sqlVsJPA,This article} compares the built-in SQL DataSource
// to other persistence approaches based on Javabeans.
// <P>
// To use the built-in SQL engine, declare a +link{DataSource} in XML format with
// +link{dataSource.serverType} set to "sql", and place it in the shared dataSources directory
// ([webroot]/shared/ds by default) in a file called "[dataSourceId].ds.xml".
// <p>
// You can then use the +link{group:adminConsole,Admin Console} to configure database access,
// as well as to automatically create and populate a database table based on your DataSource.
// By default, DataSources will use the "default database" from the admin console, however you
// can set +link{dataSource.dbName} to the name of a specific database configuration you have
// configured via the Admin Console.
// <P>
// The list of databases known to work with the the built-in SQL logic is as follows:
// <p>
// <table class='normal'>
// <tr><td width=40></td><td width=400><i>HSQLDB 1.7.x, 1.8.x, 2.0.x, 2.2.x, 2.3.x, 2.4.x, 2.5.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM DB2 8.x, 9.x, 10.x, 11.x</i></td><td></td></tr>
// <tr><td></td><td><i>IBM DB2 for i (formerly known as DB2 for i5/OS) V5R4M0 onwards</i></td><td></td></tr>
// <tr><td></td><td><i>Firebird 2.5.x, 3.x</i></td><td></td></tr>
// <tr><td></td><td><i>Informix 11.5+, 12.1</i></td><td></td></tr>
// <tr><td></td><td><i>MS SQL Server 2000, 2005, 2008, 2008 R2, 2012, 2014, 2016, 2017</i></td><td></td></tr>
// <tr><td></td><td><i>MySQL 5.0.x, 5.1.x, 5.5.x, 5.6.x, 5.7.x, 8.x</i></td><td></td></tr>
// <tr><td></td><td><i>MariaDB 5.x, 10.x</i></td><td></td></tr>
// <tr><td></td><td><i>Oracle 8.0.5, 8i, 9i, 10g, 11g, 12c, 18c, 19c</i></td><td></td></tr>
// <tr><td></td><td><i>PostgreSQL 7.x, 8.x, 9.x, 10.x, 11.x, 12.x</i></td><td></td></tr>
// </table>
// <p>We also support a generic SQL92 database connection which works for basic CRUD operations
// with any database product that supports standard SQL92 syntax and data types, plus a couple 
// of widely-implemented features that are not actually part of the standard.  Specifically,
// this means we do not support:<ul>
// <li>Sequences</li>
// <li>Paging via SQL limit queries</li>
// <li>+link{DataSource.autoJoinTransactions,Automatic transaction management}
// <li>Long text values (there is no real definition of "long" here - we try to use a standard
// VARCHAR, but different databases will support different maximum values for this)</li>
// <li>Databases that do not implement the widely-supported LOWER() function</li>
// <li>Databases that do not support the ability to perform string-type operations on numeric
// columns - for example, <code>myNumericColumn LIKE '%5%'</code></li>
// </ul>
// <p>You will also need a JDBC driver for your specific database. Licensing restrictions
// prevent us including any JDBC driver other than the one for HSQLDB.  However, you
// can download these drivers for free from the vendors' websites.  If your specific database
// server or version is not listed above, please go to the
// <a href="http://forums.smartclient.com">SmartClient forums</a> for assistance.
// <P>
// You can also connect to an existing database table - the Visual Builder DataSource Wizard
// ("New" button in DataSources pane) allows you to pick an existing database table and have a
// DataSource generated from it.  The Batch DataSource Generator tool will allow you to
// generate DataSources for any number of SQL DataSources, and customize the process so that
// organization-specific rules are applied (eg ignoring certain columns, or using naming
// conventions to generate more complete DataSources).
// <P>
// Once you have your SQL DataSource connected to a table, in a default SDK installation,
// DSRequests for your DataSource will be sent to the default
// +link{RPCManager.actionURL,actionURL}, and hence handled automatically, without you having
// to write any Java code, by the +link{servletDetails,IDACall servlet registered in web.xml}.
// IDACall is a very simple servlet that just calls the server-side method
// dsRequest.execute() for all inbound requests.  For more details on how DataSource requests
// are processed by SmartClient Server, and how you can alter and add to this processing, see
// this description of +link{group:serverDataIntegration,server data integration}.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title SQL DataSources
// @requiresModules SCServer
// @visibility external
//<

//> @groupDef testData
// You can create a test file that contains a sample dataset which can be imported into your
// database table with the Admin Console.
// <p>
// Test data can come in a variety of flavours based on your personal preference.
// <p>
// <ul>
// <li>CSV - Comma Separated Values</li>
// <li>JSON - An array of JSON objects</li>
// <li>XML - Extensible Markup Language</li>
// </ul>
// <p>
// <h3>CSV</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.csv</code> extension.
// <p>
// The CSV file can contain an optional header line as the example below will show you. The headline
// names can be either DataSource title or field name and are not case sensitive. If the
// header line is missing it will be assumed that the data/columns are the same order as the field
// declaration in the DataSource file. This sample represents some moon landing data and you can
// also use double quotes around more complex values.
// <p>
// <pre>
// mission, duration, launchDate, commander, rover
// "Apollo 11", "195.31", 1969-07-16, "Neil Armstrong", false
// "Apollo 12", "244.61", 1969-11-14, "Charles Conard", false
// "Apollo 13", 142.91, "1970-04-11", "Jim Lovell", false
// "Apollo 14", 216.03, "1971-01-31", "Alan Shepard", false
// "Apollo 15", 295.20, "1971-07-26", "David Scott", true
// "Apollo 16", 265.85, "1972-04-16", "John W. Young", true
// "Apollo 17", "301.87", 1972-12-07, "Eugene Cernan", true
// </pre>
// <p>
// <h3>JSON</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.js</code> extension.
// <p>
// The JSON file needs to contain an array of objects. Each object represents a new record and
// will contain the properties in a JSON fashion. The names can be either DataSource title or
// field name and are not case senstive.
// <p>
// <pre>
// [
//   {
//     category: "Adding Machine/calculator Roll",
//     itemName: "Adding Machine Roll 57x57mm Lint Free",
//     sku: "226500",
//     unitCost: 0.52,
//     units: "Roll"
//   },
//   {
//     category: "Pastes and Gum",
//     itemName: "Glue UHU Clear Gum 250ml",
//     sku: "724800",
//     unitCost: 2.26,
//     description: "Ideal for paper and card. Dries clear. Easy to use. Washable &amp; Non-Toxic."
//   },
//   ...
// ]
// </pre>
// <p>
// <h3>XML</h3>
// <p>
// The test file to use with your DataSource is specified in the <code>testFileName</code>
// DataSource configuration property and will have the <code>.data.xml</code> extension.
// <p>
// The test data file should consist of a top-level element containing a series of XML
// elements, each of which creates one DataSource record. Values for each field are given
// within tags named after the field name or in the parent tag as an attribute.
// <p>
// For example, the following XML represents a list of supply items.
// <p>
// <pre>
// &lt;records&gt;
//  &lt;record&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-502-153&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Blue Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;1&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/record&gt;
//  &lt;record&gt;
//      &lt;description&gt;A revolutionary cushion-grip ballpoint pen that reduces
//          required gripping power, relieving stress and alleviating writing
//          fatigue. Excellent for people who suffer from arthritis or carpal
//          tunnel syndrome. Medium point, black ink. Refillable.&lt;/description&gt;
//      &lt;category&gt;1&lt;/category&gt;
//      &lt;itemRef&gt;ODC 204-708-834&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;5&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;0&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Dr. Grip Pens -- Black Barrel&lt;/itemName&gt;
//      &lt;itemID&gt;2&lt;/itemID&gt;
//      &lt;unitCost&gt;4.99&lt;/unitCost&gt;
//  &lt;/record&gt;
//  &lt;record&gt;
//      &lt;description&gt;Personalized business cards for all your networking
//          needs.&lt;/description&gt;
//      &lt;category&gt;2&lt;/category&gt;
//      &lt;itemRef&gt;&lt;/itemRef&gt;
//      &lt;maxQuantity&gt;500&lt;/maxQuantity&gt;
//      &lt;requiresJustification&gt;1&lt;/requiresJustification&gt;
//      &lt;itemName&gt;Personalized business cards -- 500 count&lt;/itemName&gt;
//      &lt;itemID&gt;3&lt;/itemID&gt;
//      &lt;unitCost&gt;25.00&lt;/unitCost&gt;
//  &lt;/record&gt;
//  ...
// &lt;records/&gt;
// </pre>
//
// Data for a tree-like DataSource can be specified with the same format.
// The following code example is for supply categories. This will make use of attribute values
// instead of separate tags for each property on the supply category. The attribues are not
// case sensitive and can be named after either the DataSource title or field name.
//
// <pre>
// &lt;categories&gt;
//     &lt;category itemName="Office Paper Products" parentID="root" /&gt;
//     &lt;category itemName="Calculator Rolls" parentID="Office Paper Products" /&gt;
//     &lt;category itemName="Adding Machine/calculator Roll" parentID="Calculator Rolls" /&gt;
//     ...
// &lt;/categories&gt;
// </pre>
//
// Note that all records must define values for the itemName primary key field and for the
// parentID field that establishes the tree relationship.
// <p>
// <h3>Date, Time and DateTime considerations</h3>
// <p>
// When you have date, time or datetime fields these need to be formatted the same way they are expected
// to be formatted in REST responses. If data for a field does not match the expected format it
// will be parsed using JDK built-in DataFormat parsers, in lenient mode, in the server's default
// locale.
//
// Examples of date, time and datetime formats.
// <pre>
//    // date - YYYY-MM-DD
//    2014-12-06
//
//    // time - hh:mm:ss
//    22:01:45
//
//    // datetime - YYYY-MM-DDThh:mm:ssZ
//    2014-12-06T22:01:45-04:00
// </pre>
//
// @see dateFormatAndStorage
// @treeLocation Client Reference/Data Binding/DataSource
// @title Test Data
// @visibility external
//<

//> @groupDef sqlSettings
// Although the Admin Console provides a UI to let you to configure database access for 
// DataSources that use SmartClient's built-in +link{group:sqlDataSource,SQL engine}, it is 
// also possible to configure these DataSources with manual entries in your 
// +link{group:server_properties,server.properties} file.
// <p>
// When you manually configure a DataSource like this, you do so by maintaining a set of 
// properties with names structured like this:
// <pre>   sql.{dbName}.x.y
// </pre>
// where <code>{dbName}</code> is the name of the database configuration you are providing.
// Note that this database name is just an arbitrary name for a particular database 
// configuration; many of the default ones provided with SmartClient are named after a database
// <em>type</em>, in order to make their intended use more immediately obvious, but this is 
// not by any means a requirement.
// <p>
// For the remainder of this discussion, we will assume we are configuring a database with a 
// name of "MyDatabase".
// <p>
// <h4>SQL configuration properties</h4><p>
// <b><code>sql.MyDatabase.database.type</code></b><br>
// This should be set to one of the supported database types.  These are:<p>
// <table style="font-size:10px">
// <tr><td><b>hsqldb</b></td><td>HSQLDB 1.7.x and greater</td></tr>
// <tr><td><b>db2</b></td><td>IBM DB2 8.x and greater</td></tr>
// <tr><td><b>db2iSeries</b></td><td>IBM DB2 for iSeries/i5, V5R4 and greater</td></tr>
// <tr><td><b>firebirdsql</b></td><td>Firebird 2.5 and greater</td></tr>
// <tr><td><b>informix</b></td><td>Informix 11.5 and greater</td></tr>
// <tr><td><b>sqlserver</b></td><td>Microsoft SQL Server 2000 and greater</td></tr>
// <tr><td><b>mysql</b></td><td>MySQL 3.2.x and greater</td></tr>
// <tr><td><b>mariadb</b></td><td>MariaDB 5.1 and greater</td></tr>
// <tr><td><b>oracle</b></td><td>Oracle 8.0.5, 8i and greater</td></tr>
// <tr><td><b>postgresql</b></td><td>PostgreSQL 7.x and greater</td></tr>
// <tr><td><b>generic</b></td><td>A generic SQL92 database, with limitations described in
// +link{group:sqlDataSource,this article}</td></tr>
// </table><p>
// <code><b>sql.MyDatabase.driver</b></code><br>
// The name of the JDBC driver implementation.  This depends upon your database product and 
// version, and the specific JDBC driver you are using (JDBC drivers can usually be downloaded
// from your database vendor's website).  Bearing in mind the caveat that this information can
// vary by release and JDBC implementation, here are some suggested values for our supported 
// databases:<p>
// <table style="font-size:10px">
// <tr><td><b>hsqldb</b></td><td><code>org.hsqldb.jdbcDriver</code></td></tr>
// <tr><td><b>db2</b></td><td><code>com.ibm.db2.jcc.DB2DataSource</code></td></tr>
// <tr><td><b>db2iSeries</b></td><td><code>com.ibm.as400.access.AS400JDBCDriver</code></td></tr>
// <tr><td><b>firebirdsql</b></td><td><code>org.firebirdsql.jdbc.FBDriver</code></td></tr>
// <tr><td><b>informix</b></td><td><code>com.informix.jdbc.IfxDriver</code></td></tr>
// <tr><td><b>sqlserver</b></td><td><code>com.microsoft.jdbc.sqlserver.SQLServerDriver</code> or 
// <code>com.microsoft.sqlserver.jdbc.SQLServerDriver</code> (Microsoft changed the order of 
// "jdbc" and "sqlserver" between the 2000 and 2005 editions of the product)</td></tr>
// <tr><td><b>mysql</b></td><td><code>com.mysql.jdbc.jdbc2.optional.MysqlDataSource</code></td></tr>
// <tr><td><b>mariadb</b></td><td><code>org.mariadb.jdbc.MariaDbDataSource</code></td></tr>
// <tr><td><b>oracle</b></td><td><code>oracle.jdbc.driver.OracleDriver</code></td></tr>
// <tr><td><b>postgresql</b></td><td><code>org.postgresql.Driver</code></td></tr>
// </table><p>
// <code><b>sql.MyDatabase.driver.serverName</b></code><br>
// The name or IP address of the database server
// <p>
// <code><b>sql.MyDatabase.driver.portNumber</b></code><br>
// The port on which the database server is listening
// <p>
// <code><b>sql.MyDatabase.driver.user</b></code><br>
// The user to connect as
// <p>
// <code><b>sql.MyDatabase.driver.password</b></code><br>
// The user's password
// <p>
// <code><b>sql.MyDatabase.driver.databaseName</b></code><br>
// The database to connect to.  A "database" in this context is a named collection of tables
// and other database resources that are somehow grouped together by the database product.
// The specifics of how this is implemented vary by database.  Note that some database 
// products use the terms "catalog" or "schema" to refer to the same concept, and Oracle - 
// although it does also have a concept of catalog - uses the term "SID" for this concept.<p>
// <code><b>sql.MyDatabase.interface.type</b></code><br>
// Indicates how the JDBC connection will be created or looked up; the value of this setting 
// depends on the capabilities of the particular JDBC driver you are using, and is inherently
// connected to the value of <code>sql.MyDatabase.driver</code>.  The following settings are 
// supported:<p>
// <b>dataSource</b> - the driver is an instance of <code>javax.sql.DataSource</code> and 
// should be instantiated by SmartClient Server<br>
// <b>driverManager</b> - the driver is an instance of <code>java.sql.DriverManager</code><br>
// <b>jndi</b> - the driver is an instance of <code>javax.sql.DataSource</code> and should be 
// looked up using JNDI<p>
// <code><b>sql.MyDatabase.driver.url</b></code><br>
// For configurations where <code>sql.MyDatabase.interface.type</code> is "driverManager", 
// this property allows you to manually enter the URL we use to connect to the database.  If 
// this property is not provided, we build the URL from other settings such as 
// <code>sql.MyDatabase.driver.serverName</code> and 
// <code>sql.MyDatabase.driver.databaseName</code>.<p>
//
// <b>Other properties</b><br>
// Different JDBC drivers support different properties to support product-specific quirks and
// features.  You can often specify these properties by embedding them as parameters in the 
// URL used to connect to the database.<p>
//
// Alternatively, any subproperty you set on the "driver" in server.properties is applied to 
// the JDBC driver object via Reflection. For example, the MySQL JDBC driver supports a property
// "useUnicode", which forces the database to use Unicode character encoding.  If 
// <code>sql.MyDatabase.driver</code> is <code>com.mysql.jdbc.jdbc2.optional.MysqlDataSource</code>,
// setting <code>sql.MyDatabase.driver.useUnicode</code> to true means we'll attempt to call 
// <code>setUseUnicode(true)</code> on this class.  This would have exactly the same effect as
// defining the connection URL manually and specifying the parameter <code>useUnicode=true</code>
//
// Mysql vs MariaDB: there is broad compatibility between these two databases as described in
// +externalLink{https://mariadb.com/kb/en/library/mariadb-vs-mysql-compatibility/}.  Within
// the bounds of that compatibility matrix, you can use database.type 'mysql' and 'mariadb' 
// interchangeably, and likewise with the drivers that you use.  However for future compatibility
// it is recommended that you use <code>database.type: mariadb</code> for MariaDB.  This will ensure
// that as MariaDB implements new features and backompat breaking changes, your application won't
// run into any gotchas because the SmartClient server logic will automatically use the right feature
// set to accomplish documented behavior.
//
// <h4>Smartclient properties</h4><p>
// <b><code>sql.mysql.optimizeCaseSensitiveCriteria</code></b><br>
// <i>This setting affects all <b>MySQL</b> connectors and it is set to <b>true</b> by default.</i> 
// Depending on +link{type:TextMatchStyle,textMatchStyle} case
// sensitivity in text criteria is achieved by using LIKE BINARY sql comparison operator, which does not
// use indexed search. Indexes are used with regular "=" comparison operator, which does not ensure case
// sensitivity. With big amounts of data indexes are critical, so in order to use them and still have
// case sensitivity supported this setting must be set to <code>true</code> (default).
// This way we would generate comparison expression like:<br>
// <code>&lt;field&gt; = &lt;value&gt; AND &lt;field&gt; LIKE BINARY &lt;value&gt;</code><br>
// where first part ensures efficient indexed search and second part adds case sensitivity to significantly
// reduced amounts of data. This would be more efficient without indexes as well, cause LIKE BINARY
// conversion would be performed on less rows anyway.<br>
// Setting this property to <code>false</code> would bring back the old behavior, when only 
// LIKE BINARY comparison would be used, which would return same results, but much slower.
// <p>
// <b><code>sql.aliasLengthLimit</code> and <code>sql.MyDatabase.aliasLengthLimit</code></b><br>
// These properties override the default table alias length limit when using features like
// +link{dataSourceField.includeVia}.
// Default alias length limit is set accordingly to the documentation for supported databases
// and defaults to 128 characters, except these databases:<p>
// <table style="font-size:10px">
// <tr><td><b>firebirdsql</b></td>  <td>63</td></tr>
// <tr><td><b>mysql</b></td>        <td>256</td></tr>
// <tr><td><b>mariadb</b></td>      <td>256</td></tr>
// <tr><td><b>oracle</b></td>       <td>automatically set to 128 since DB version 12.2 and to 30 for older versions</td></tr>
// <tr><td><b>postgresql</b></td>   <td>63</td></tr>
// </table><p>
// In order to support portability across databases it is advised to keep alias length limit at
// the lowest supported value. Use global setting <code>sql.aliasLengthLimit</code> to apply limit
// across all DB drivers, or use DB specific setting <code>sql.MyDatabase.aliasLengthLimit</code>
// (overrides the global one).
// <p>
// <b><code>sql.postgresql.useILike</code></b><br>
// Starting with version 12.0, SmartClient Server supports the use of a Postgres-specific
// comparison keyword, ILIKE.  This keyword natively does a case-insensitive LIKE, so the
// SmartClient driver does not have to do what it normally does to enable this kind of 
// comparison, which is to convert the filter value to lower case and then generate SQL like:
// <pre>WHERE LOWER(someField) LIKE 'united%'</pre>
// When ILIKE is in use, Postgres is able to make use of indexes, which it does not do when
// we use the "lowercase both sides" strategy, so this is a potentially significant performance
// enhancer, depending on your application:
// <pre> WHERE someField ILIKE 'United%'</pre>
// 
// @treeLocation Client Reference/Data Binding/DataSource
// @title SQL Database Settings in <code>server.properties</code>
// @requiresModules SCServer
// @visibility external
//<

//> @groupDef troubleshootingServerDeadlocks
// Java thread deadlocking can occur in a multi-threaded application when two or more threads 
// need the same lock and block while waiting for it. These threads can be permanently blocked
// (deadlocked), waiting for each other.
// <P>
// For developers using the SmartClient server, if deadlocks are encountered we recommend the
// following troubleshooting steps:
// <ul>
// <li>Search server code for calls to DataSourceManager and audit whether you are
//     following the documented pooling rules for obtaining and releasing dataSources</li>
// <li>Look at the deadlocked thread ID and looked at the server logs for the logs for 
//     the last request that thread serviced.<br>
//     Our default logging messages include the thread ID so you can easily correlate 
//     the logs with the hung thread. You can also adjust server logging sensitivity via
//     settings in the log4j configuration file (<i>log4j.isc.config.xml</i>).<br>
//     Note that the logged thread IDs are shortened by default. If there isn't enough 
//     information shown to correlate with the deadlocked thread you can also change the 
//     logging format (pattern) in the log4j configuration file.<br>
//     If you are using some other log package, it should be easy to turn on logging of 
//     thread IDs, and you should do so - this is a basic logging best practice.<br>
//     See documentation +link{group:serverLogging,here} for more information on server side
//     logging.</li>
//  <li>Attach a tool such as Dynatrace so that you can inspect the hung thread.</li>
//  <li>Examine any threaded code you may have, and made sure it likewise follows the 
//      rules of pooling (see also +link{group:standaloneDataSourceUsage,Standalone DataSource Usage})</li>
// </ul>
//
// @treeLocation Java Server Reference/Debugging
// @title Troubleshooting thread deadlocks on the server
// @visibility external
//<

//> @groupDef clientOnlyDataSources
// For prototyping purposes, a "client-only" DataSource can be created that has no permanent
// storage and never contacts the server, instead using a set of test data to respond to
// requests in the same manner as a server-based DataSource might.
// <P>
// The client-side interface to a client-only DataSource is identical to a server-based
// DataSource, including asynchronous responses, so that a client-only DataSource can be
// replaced by a server-based DataSource without code changes.  The only difference is that
// changes to records belonging to the DataSource persist only until the page is reloaded.
// <p>
// Client-only DataSources allow you to create a complete prototype application in an .html
// file that does not require a server.
// <p>
// <smartclient>
// The <code>clientOnly</code> property is specified to create a client-only DataSource, and
// the <code>cacheData</code> property should contain the test dataset, as an Array of Objects,
// one per DataSource record.  For example:
// <pre>
//   isc.DataSource.create({
//       ID:"supplyItem",
//       fields: ...,
//       clientOnly:true,
//       cacheData:[
//          {itemName:"Pencil", cost:5.50},
//          ...
//       ]
//   });
// </pre>
// If you have existing test data in XML (see +link{group:dbConfigTool,Database Configuration} for
// expected format) and your client-only DataSource is defined in a .jsp file,
// you can use the XML->JS translation engine to populate the DataSource with data from XML, like so:
// <pre>
//   isc.DataSource.create({
//     ID:"solutions",
//     fields: ...,
//     clientOnly : true,
//     cacheData : 
//         &lt;isomorphic:XML filename="shared/ds/test_data/solutions.data.xml"/&gt;
//   });
// </pre>
// Another useful practice is to specify both the clientOnly DataSource and its test data in
// XML, so that the +link{group:adminConsole,Admin Console} can later be used to import the
// DataSource and its test data into a SQL Database.  An idiom for accomplishing this is:
// <pre>
//   &lt;isomorphic:loadDS name="solutions"/&gt;
//   isc.DataSource.getDataSource("solutions").addProperties({
//     clientOnly : true,
//     cacheData : 
//        &lt;isomorphic:XML filename="shared/ds/test_data/solutions.data.xml"/&gt;
//   });
// </pre>
// Finally test data can be included directly in the clientOnly DataSource 
// XML.  An idiom for accomplishing this is:
// <pre>
// &lt;DataSource ID="supplyItem"&gt;
//   &lt;fields&gt;
//       &lt;field name="itemName" type="text" title="Item"/&gt;
//       &lt;field name="SKU"      type="text" title="SKU"/&gt;
//   &lt;/fields&gt;
//   &lt;cacheData&gt;
//       &lt;Object&gt;
//           &lt;itemName&gt;name&lt;/itemName&gt;
//           &lt;SKU&gt;112233&lt;/SKU&gt;
//       &lt;/Object&gt;
//       ...
//   &lt;/cacheData&gt;
// &lt;/DataSource&gt;
// </pre>
// If you specify your DataSource as <code>clientOnly: true</code>, omit cacheData
// entirely, and provide either a +link{attr:dataSource.dataURL} or a <code>testFileName</code>, the
// </smartclient>
// <smartgwt>
// The setClientOnly method is specified to create a client-only DataSource. For example:
// <pre>
//  DataSource dataSource = new DataSource();
//  dataSource.setID("stockQuotesDS");
//  DataSourceField idField = new DataSourceField("id", FieldType.INTEGER, "Id");
//  ........
//  dataSource.setFields(idField,.....);
//  dataSource.setClientOnly(true);
// </pre>
// If you have existing test data in XML (see the Admin Console for expected format), 
// you can load it into a client-only DataSource using setDataURL method, like so:
// <pre>
//  DataSource dataSource = new DataSource();
//  dataSource.setID("stockQuotesDS");
//  dataSource.setRecordXPath("/List/stockQuotes");
//  DataSourceField idField = new DataSourceField("id", FieldType.INTEGER, "Id");
//  ........
//  dataSource.setFields(idField,.....);
//  dataSource.setDataURL("ds/test_data/stockQuotes.data.xml");
//  dataSource.setClientOnly(true);
// </pre>
// The
// </smartgwt>
// DataSource will lazily make a one-time fetch against the specified data file the first time
// an operation is called on it.  From then on, the DataSource will work against the local
// cache created from this initial request.  This is a quick way to prototype against some test
// data that may eventually be returned from an arbitrary back-end.
// <P>
// Finally, it is possible to have a DataSource which initially fetches the entire dataset and
// performs all subsequent fetching locally, while still visiting the server to perform all 
// other operations.  See +link{dataSource.cacheAllData}.
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Client Only DataSources
// @visibility external
//<




// synonym, isc namespace only (never a global)
isc.DS = isc.DataSource;

// static properties and methods
isc.DataSource.addClassProperties({
    

	// locating dataSources
	dataSourceObjectSuffix : "DS",			// suffix for the global to hold info about a dataSource,
											//	eg:  var myDataSourceDS = {...}
	
	_dataSources : {},						// internal array to hold the list of dataSources we've loaded
	_elements : {},						    // internal array of XSElements
	_types : {},						    // internal array of XSComplexTypes
    _$element : "element", _$type:"type",
    _tableCodesToDatasourceIds: {},         // a map to find loaded sql datasource by it's tableCode
    _fkTableCodesToDatasourceIds: {},
    _constructorToDatasourceIds: {},        // a map from Constructor values in schemas to the Datasource ID,
                                            // so that we can determine the schema for a class if the schema ID
                                            // is different from the class name, but has a Constructor attribute
                                            // equal to the class name
	
	TABLE : "table",						// table type of datasource
	VIEW : "view",							// view type of datasource (virtual datasource)

    //> @classAttr DataSource.loaderURL (URL : DataSource.loaderURL : RW)
    //
    // The URL where the DataSourceLoader servlet has been installed.  Defaults to the
    // +link{Page.setIsomorphicDir,isomorphicDir} plus "/DataSourceLoader".  Change by calling
    // calling +link{DataSource.setLoaderURL()}
    //
    // @visibility external
    //<
	loaderURL:"[ISOMORPHIC]/DataSourceLoader",

    //> @classAttr DataSource.defaultStringInBrowser (Boolean : null : RW)
    // Default value if +link{dataSourceField.stringInBrowser} is not defined. See
    // <code>stringInBrowser</code> docs for details.<br>
    // Note this setting should be used only if you are *not* using the SmartClient Server.
    //
    // @see dataSourceField.stringInBrowser
    // @visibility external
    //<
	
	// deepCloneOnEdit: If we have nested dataSources, and have edit-components bound to these
	// DS's, using dataPath to extract values from inner objects, should the field values be
	// recursively duplicated on edit.
	// Default value is true - this is required to support standard functionality such as being
	// able to pass a ListGrid record to a DynamicForm for editing and avoiding having both 
	// components referencing the same inner-objects in memory [thus leading to edits directly
	// effecting the ListGrid record with no save-step or other notification].
	
	deepCloneOnEdit:true,

	// See class method registerSgwtDS()
    DS_FN: {},

    // chunks of SOAP messages
	_soapEnvelopeStart : "<soap:Envelope xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/' ",
	_soapEnvelopeEnd : "</soap:Envelope>",
	_soapHeaderStart : "<soap:Header>",
	_soapHeaderEnd : "</soap:Header>",
	_soapBodyStart : "<soap:Body", // intentionally unterminated
	_soapBodyEnd : "</soap:Body>",

    // Shallow clones the given DSRequest. The request data is also shallow cloned.
    _cloneDSRequest : function (dsRequest, dontIncludePromptProperties) {
        if (dsRequest == null) return null;

        if (dsRequest.unconvertedDSRequest != null) {
            dsRequest = dsRequest.unconvertedDSRequest;
        }

        var clonedDSRequest = {
            // Core DSRequest configuration
            operationId: dsRequest.operationId,
            operationType: dsRequest.operationType,
            data: isc.shallowClone(dsRequest.data),
            textMatchStyle: dsRequest.textMatchStyle,
            sortBy: dsRequest.sortBy,
            startRow: dsRequest.startRow,
            endRow: dsRequest.endRow,
            oldValues: dsRequest.oldValues,
            outputs: dsRequest.outputs,
            httpMethod: dsRequest.httpMethod,
            httpHeaders: dsRequest.httpHeaders,
            params: dsRequest.params,
            useHttpProxy: dsRequest.useHttpProxy,
            willHandleError: dsRequest.willHandleError,

            // Advanced or uncommonly-used DSRequest configuration properties
            actionURL: dsRequest.actionURL,
            dataProtocol: dsRequest.dataProtocol,
            additionalOutputs: dsRequest.additionalOutputs,
            allowIE9Leak: dsRequest.allowIE9Leak,
            bypassCache: ("_origBypassCache" in dsRequest ? dsRequest._origBypassCache : dsRequest.bypassCache),
            callbackParam: dsRequest.callbackParam,
            clientContext: dsRequest.clientContext,
            componentId: dsRequest.componentId,
            containsCredentials: dsRequest.containsCredentials,
            contentType: dsRequest.contentType,
            downloadResult: dsRequest.downloadResult,
            downloadToNewWindow: dsRequest.downloadToNewWindow,
            evalResult: dsRequest.evalResult,
            evalVars: dsRequest.evalVars,
            fallbackToEval: ("_origFallbackToEval" in dsRequest ? dsRequest._origFallbackToEval : dsRequest.fallbackToEval),
            generateRelatedUpdates: dsRequest.generateRelatedUpdates,
            groupBy: dsRequest.groupBy,
            headerData: dsRequest.headerData,
            ignoreTimeout: dsRequest.ignoreTimeout,
            keepParentsOnFilter: dsRequest.keepParentsOnFilter,
            lineBreakStyle: dsRequest.lineBreakStyle,
            omitNullMapValuesInResponse: dsRequest.omitNullMapValuesInResponse,
            paramsOnly: dsRequest.paramsOnly, // deprecated
            parentNode: ("_origParentNode" in dsRequest ? dsRequest._origParentNode : dsRequest.parentNode),
            pendingAdd: dsRequest.pendingAdd,
            progressiveLoading: dsRequest.progressiveLoading,
            resultSet: dsRequest.resultSet,
            resultTree: dsRequest.resultTree,
            sendNoQueue: dsRequest.sendNoQueue,
            serverOutputAsString: dsRequest.serverOutputAsString,
            shouldUseCache: dsRequest.shouldUseCache,
            streamResults: dsRequest.streamResults,
            summaryFunctions: dsRequest.summaryFunctions,
            suppressAutoDraw: dsRequest.suppressAutoDraw,
            timeout: dsRequest.timeout,
            transport: dsRequest.transport,
            useFlatFields: dsRequest.useFlatFields,
            useFlatHeaderFields: dsRequest.useFlatHeaderFields,
            useSimpleHttp: dsRequest.useSimpleHttp,
            useStrictJSON: ("_origUseStrictJSON" in dsRequest ? dsRequest._origUseStrictJSON : dsRequest.useStrictJSON),
            useXmlHttpRequest: dsRequest.useXmlHttpRequest, // deprecated
            validationMode: dsRequest.validationMode
        };

        if (!dontIncludePromptProperties) {
            clonedDSRequest.showPrompt = dsRequest.showPrompt;
        }

        // Copy the export* and prompt* properties
        for (var propName in dsRequest) {
            if (propName.startsWith("export") ||
                (!dontIncludePromptProperties && propName.startsWith("prompt")))
            {
                clonedDSRequest[propName] = dsRequest[propName];
            }
        }

        return clonedDSRequest;
    },

    _cloneDSResponse : function (dsResponse) {
        if (dsResponse == null) return null;

        return {
            clientContext: dsResponse.clientContext,
            data: isc.shallowClone(dsResponse.data),
            dataSource: dsResponse.dataSource,
            endRow: dsResponse.endRow,
            errors: dsResponse.errors,
            fromOfflineCache: dsResponse.fromOfflineCache,
            httpHeaders: dsResponse.httpHeaders,
            httpResponseCode: dsResponse.httpResponseCode,
            httpResponseText: dsResponse.httpResponseText,
            invalidateCache: dsResponse.invalidateCache,
            offlineTimestamp: dsResponse.offlineTimestamp,
            operationType: dsResponse.operationType,
            queueStatus: dsResponse.queueStatus,
            startRow: dsResponse.startRow,
            status: dsResponse.status,
            totalRows: dsResponse.totalRows,
            transactionNum: dsResponse.transactionNum
        };
    }
});

isc.DataSource.addClassMethods({

    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        var id = A ? A.ID : null;
        if (isc.DataSource._doNotClobber) {
            var instance;
            if (id) instance = isc.DataSource.get(id);
            if (instance) return instance;
        }
        
        if (this.DS_FN) delete this.DS_FN[id];

        return this.invokeSuper(this, "create", A,B,C,D,E,F,G,H,I,J,K,L,M);
    }, 

    // Looking up and loading DataSources
	// --------------------------------------------------------------------------------------------

    isLoaded : function (name) {
		// if no name was passed to us, return false
		if (!name) return false;
        if (isc.isA.DataSource(name) || this._dataSources[name]) return true;
        return false;
    },
    
    //> @classMethod DataSource.getDataSource()
    // Lookup a DataSource by ID.
    //
    // @param ID (GlobalId) DataSource ID
    // @return (DataSource) the DataSource with this ID, if loaded, otherwise null.
    // @visibility external
    //<
    // If the dataSource does not exist locally and a callback is provided to this method, we
    // attempt to fetch the named datasource from the server and callback.  
    _$refColon:"ref:",
	getDataSource : function (name, callback, context, schemaType) {
		// if no name was passed to us, return null
		if (!name) return null;

//        if (isc.isA.DataSource(name)) {
//            alert("getting datasource: " + name);
//        } else {
//            alert("getting name: " + name);
//        }

        // handle being passed a DataSource instance
        if (isc.isA.DataSource(name)) return name;

        // strip off the "ref:" prefix used in the XML format.  Happens when a field of
        // DataSource type has been declared as an XML attribute (if it's not an attribute you
        // get <DataSource ref="dsId"/> and this is handled during XML->JS translation)
        if (isc.startsWith(name, this._$refColon)) {
            name = name.substring(4);
        }

        if (schemaType && isc.WebService) {
            if (schemaType == isc.DS._$element) return this._elements[name];
            if (schemaType == isc.DS._$type) return this._types[name];
            return null;
        }

		// load the ds (clientside)
        var ds = this._dataSources[name];
		if (!ds) {
            // If this is a DataSource that has been registered as having been created in 
            // SmartGWT, create it JS-side now
            if (isc.DataSource.DS_FN && isc.DataSource.DS_FN[name]) {
                // Remove it from the SGWT pending list before calling into the create 
                // method, otherwise we get a recursion loop
                var work = isc.DataSource.DS_FN[name];
                delete isc.DataSource.DS_FN[name];
                work.call(null);
            }
            ds = this._dataSources[name];
            if (!ds) {
                ds = this._loadDataSource(name, callback);
                if (ds) ds.ID = name; // tell the dataSource its name for later
            }
		}

		if (ds) {
            // if they've specified a callback, call the callback in addition to returning the ds
            // Note, the ability to provide a callback is not publicly documented, so changing
            // this from passing the DS instance to the DS ID is not a backompat issue
            if (callback) {
                this.fireCallback(callback, "dsID", [ds.ID], ds);
            }
            
            return ds;
		}

		// load from server if a callback was passed
		if (callback) {
            this.load(name, callback, context);
        }
			
		// let the caller know that we don't have the datasource.  if a callback was passed,
		// the caller will be notified via the callback.
		return null;
	},
    
    // loadSchema - attempt to load a remote dataSource schema from the server.
    // This is supported as part of the SmartClient server functionality
    loadSchema : function (name, callback, context) {
        this.logWarn("Attempt to load schema for DataSource '" + name + 
            "'. This dataSource cannot be found. To load DataSources from the server without " +
            "explicit inclusion in your application requires optional SmartClient server " +
            "support - not present in this build.");
        return null;
    },
    
    
    //> @classMethod DataSource.get()
    // Synonym of +link{getDataSource()}: Lookup a DataSource by ID.
    //
    // @param ID (GlobalId) DataSource ID
    // @return (DataSource) the DataSource with this ID, if loaded, otherwise null.
    // @visibility external
    //<
    get : function (name, callback, context, schemaType) { 
        return this.getDataSource(name, callback, context, schemaType); 
    },

    _loadDataSource : function (name, callback) {
		if (callback) return null; // no error if we're going to try to load from server.

		//>DEBUG
        if (name != isc.auto && this.logIsDebugEnabled()) {
            this.logDebug("isc.DataSource '" + name + "' not present");
        }
		//<DEBUG

		// couldn't load the dataSource -- return null
		return null;
	},

    // returns a list of all registered datasources
    getRegisteredDataSources : function () {
        return isc.getKeys(this._dataSources);
    }, 

    getRegisteredDataSourceObjects : function() {
        var keys = this.getRegisteredDataSources(),
            result = [];

        for (var i=0; i<keys.length; i++ ) {
            result.add(this.getDataSource(keys[i]));
        }
        return result;
    },

	// returns true if the named DS is registered, false otherwise
	isRegistered : function (name) {
		if (this._dataSources[name]) return true;
		return false;
	},


    // Foreign Key relationships
	// --------------------------------------------------------------------------------------------
    // field.foreignKey can be [dataSourceID].[fieldName] or just [dataSourceID], where the latter
    // form means it's a foreignKey on the other dataSource's primary key fields.
    
    // methods to break up field.foreignKey into the target DataSource and field name.  Factored in
    // case we ever want to change our somewhat hokey foreign key scheme
    getForeignFieldName : function (field) {
        var foreignKey = field.foreignKey,
            dotIndex = foreignKey.indexOf(".");
    
        // If there is no dot the foreignkey is a field within this dataSource.
        
        if (dotIndex == -1) return foreignKey;
        return foreignKey.substring(dotIndex + 1);
    },

    getForeignDSName : function (field, defaultDS) {
        var foreignKey = field.foreignKey,
            dotIndex = foreignKey.indexOf(".");
        
        // If there is no dot the foreignkey is a field within this dataSource.
                
        if (dotIndex == -1) {
            if (defaultDS == null) return null;
            return isc.isA.String(defaultDS) ? defaultDS : defaultDS.ID;
        }
        return foreignKey.substring(0, dotIndex);
    },
    
    registerDataSource : function (dataSource) {
        //>DEBUG
        if (this.logIsInfoEnabled()) {
            this.logInfo("Registered new isc.DataSource '" + dataSource.ID + "'");
        }
        //<DEBUG
        if (dataSource.ID) {
            var existingDS = this._dataSources[dataSource.ID];
            // overwrite any existing registered DataSource, unless we have a schemaNamespace.
            // This avoids XMLSchema-derived Schema cloberring ordinary DataSources, since
            // XMLSchema-derived DataSources can be looked up via other means
            // (SchemaSet.getSchema())
            if (!existingDS || !dataSource.schemaNamespace) {
                this._dataSources[dataSource.ID] = dataSource;
            }

            // Keep track of any Constructor or equivalent, if it isn't equal
            // to the ID.  That way, we can find a schema which can create
            // the class, even if the schema ID is not equal to the className.
            // The _constructor || Constructor || type is also what
            // getNearestSchemaClass() does.
            var cons = dataSource._constructor || dataSource.Constructor || dataSource.type;
            if (cons && (cons != dataSource.ID)) {
                this._constructorToDatasourceIds[cons] = dataSource.ID;
            }

            if (dataSource.tableCode) {
                this._tableCodesToDatasourceIds[dataSource.tableCode] = dataSource.ID;
                var linkedDatasources = this._fkTableCodesToDatasourceIds[dataSource.tableCode];
                if (linkedDatasources) {
                    for (var i = 0; i < linkedDatasources.length; i++) {
                        var linkedDSName = linkedDatasources[i];
                        var linkedDS = isc.DS.get(linkedDSName);
                        var linkedDSFields = linkedDS.getFields();
                        var dsFields = dataSource.getFields();
                        for (var linkedDSFieldName in linkedDSFields) {
                            for (var dsFieldName in dsFields) {
                                if (linkedDSFields[linkedDSFieldName].fkColumnCode == dsFields[dsFieldName].columnCode) {
                                    linkedDSFields[linkedDSFieldName].foreignKey = dataSource.ID + "." + dsFields[dsFieldName].name;
                                    break;
                                }
                            }
                        }
                        linkedDS.addChildDataSource(dataSource);
                        linkedDatasources.removeAt(i);
                        i--;
                    }
                    if (linkedDatasources.length == 0) {
                        delete this._fkTableCodesToDatasourceIds[dataSource.tableCode];
                    }
                }
            }
        }

        
        if (isc.Schema && isc.isA.Schema(dataSource)) {
            if (isc.isAn.XSElement(dataSource)) this._elements[dataSource.ID] = dataSource;
            else if (isc.isAn.XSComplexType(dataSource)) this._types[dataSource.ID] = dataSource;
            return;
        }

        
   
        // link DataSources with foreignKeys to each other as they are loaded
        // -----------------------------------------------------------------------------------
        
        var fields = dataSource.getLocalFields(true);

        var unlinkedChildren = this._unlinkedChildren = (this._unlinkedChildren || {});
 
        // try to satisfy this DS's foreignKey relationships
		for (var fieldName in fields) { 
			var field = fields[fieldName];
			var targetDSName = null;
			if (field.fkTableCode) {
			    targetDSName = this._tableCodesToDatasourceIds[field.fkTableCode];
			    // check whether sql datasource with encoded tableName was already loaded
			    if (targetDSName == null) {
			        if (this._fkTableCodesToDatasourceIds[field.fkTableCode] == null) {
			            this._fkTableCodesToDatasourceIds[field.fkTableCode] = [];
			        }
			        this._fkTableCodesToDatasourceIds[field.fkTableCode].add(dataSource.ID);
			        continue;
			    }
			    var ds = isc.DS.get(targetDSName);
                var dsFields = ds.getFields();
                for (var dsFieldName in dsFields) {
                    if (dsFields[dsFieldName].columnCode == field.fkColumnCode) {
                        field.foreignKey = ds.ID + "." + dsFields[dsFieldName].name;
                    }
                }
			} else if (field.foreignKey) {
	            var targetDSName = this.getForeignDSName(field, dataSource);
			} else {
			    continue;
			}
            if (isc.DS.isRegistered(targetDSName)) {
                //this.logWarn("dataSource: " + dataSource.ID + " found parent: " + targetDS.ID);
                // tell the other DataSource that this DS links to it in a 1 to many
                // relationship
                isc.DS.get(targetDSName).addChildDataSource(dataSource);
            } else {
                //this.logWarn("dataSource: " + dataSource.ID + " could not find parent: " +
                //             targetDSName);  
                // add ourselves to the list of future children of targetDS, to be linked up
                // whenever it gets loaded
                if (unlinkedChildren[targetDSName] == null) {
                    unlinkedChildren[targetDSName] = [];
                }
                unlinkedChildren[targetDSName].add(dataSource);
            }
        }

        // see if this new DS satisfies any foreignKey relationships
        var children = unlinkedChildren[dataSource.ID];
        if (children != null) {
            //this.logWarn("dataSource: " + dataSource.ID + " found children: " + children);  
            dataSource.map("addChildDataSource", children);
            unlinkedChildren[dataSource.ID] = null;
        }

        // Link DataSources that declare childRelations to their children
        // ---------------------------------------------------------------------------------
        var unfoundChildren = this._unfoundChildren = this._unfoundChildren || {};
        if (dataSource.childRelations) {
            for (var i = 0; i < dataSource.childRelations.length; i++) {
                var relation = dataSource.childRelations[i],
                    childDSName = relation.dsName,
                    childDS = isc.DS.get(childDSName);
                if (childDS) {
                    //this.logWarn("dataSource: " + dataSource.ID + 
                    //             " found child: " + childDS.ID);
                    this._addChildRelation(dataSource, childDS, relation);
                } else {
                    //this.logWarn("dataSource: " + dataSource.ID + 
                    //             " could not find child: " + childDSName);  
                    if (unfoundChildren[childDSName] == null) {
                        unfoundChildren[childDSName] = [];
                    }
                    relation.parentDS = dataSource.ID;
                    unfoundChildren[childDSName].add(relation);
                }
            }
        }
        // eg User loaded, now Account is loaded
        var relations = unfoundChildren[dataSource.ID];
        if (relations) {
            for (var i = 0; i < relations.length; i++) {
                var relation = relations[i];
                this._addChildRelation(isc.DS.get(relation.parentDS), dataSource, relation);
            }
        }
        
    },

    _addChildRelation : function (parentDS, childDS, relation) {
        parentDS.addChildDataSource(childDS);

        // create foreignKey marker on field
        if (!relation.fieldName) return;

        var field = childDS.getField(relation.fieldName);
        if (!field.foreignKey) {
            // HACK allows getTreeRelationship to work
            field.foreignKey = parentDS.ID + "." + 
                                    parentDS.getPrimaryKeyFieldNames()[0];
        }
    },

    _equals : function (ds1, ds2) {
        if (isc.isA.DataSource(ds1)) {
            if (!isc.isA.DataSource(ds2)) ds1 = ds1.getID();
        } else {
            if (isc.isA.DataSource(ds2))  ds2 = ds2.getID();
        }
        return ds1 == ds2;
    },

    // SmartGWT DataSource registration
    // ---------------------------------------------------------------------------------------
    
    registerSgwtDS : function (id, commandObject) {
        isc.DataSource.DS_FN[id] = commandObject;
    },
    unregisterSgwtDS : function (id) {
        delete isc.DataSource.DS_FN[id];
    },
    reregisterSgwtDS : function (oldId, newId) {
        isc.DataSource.DS_FN[newId] = isc.DataSource.DS_FN[oldId];
        delete isc.DataSource.DS_FN[oldId];
    },

    // Schema and types
    // ---------------------------------------------------------------------------------------

    //> @classMethod dataSource.getFieldValue()
    // Helper method to return the value of the supplied field from within the supplied record,
    // looking up the value from the supplied dataPath.  This method is only of real
    // use when you are dealing with complex nested data via +link{Canvas.dataPath,dataPath}; 
    // it is obviously a trivial matter to obtain a field value from a flat record directly.
	// <P>
	// If the dataPath is null, this method will follow any +link{listGridField.dataPath,dataPath} 
    // specified on the component field instead.  In either case, it will also extract 
	// +link{simpleType.getAtomicValue(),atomic values} from custom +link{SimpleType} fields
	// where this is required.
    //
	// @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
	//  Field definition from a dataSource or dataBoundComponent.
    // @param record (Record) The valueset in which to look up the field value
    // @param dataPath (String) Optionally, a string expressing the dataPath to use for value lookup.
    //                            If null, the dataPath from the field will be used
    // @param component (Canvas) Optionally, a component to prvide extra context for the dataPath
    //                             search.  This is typically required if the dataPath traverses a list
    // @param reason (String) An optional reason for the get request, to be passed into
    //                                   any +link{simpleType.getAtomicValue()} method - see that
    //                                   API for details
    // @return (Any)
    // @visibility external
    //<
    getFieldValue : function(field, record, dataPath, component, reason) {
        return isc.Canvas._getFieldValue(dataPath, field, record, component, true, reason);
    },

    //> @classMethod dataSource.saveValueViaDataPath()
    // Helper method to save the argument value inside the argument values record, storing the 
    // value at the supplied dataPath, or at the field's declared dataPath if the argument 
    // dataPath is null.  This method is only of real use when you are dealing with complex 
    // nested data via +link{Canvas.dataPath,dataPath}; it is obviously a trivial matter 
    // to store a field value in a flat record directly.
	// <P>
	// This method will call the +link{simpleType.updateAtomicValue(),updateAtomicValue()}
    // method of custom +link{SimpleType} fields where this is required.
    //
	// @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
	//  Field definition from a dataSource or dataBoundComponent.
    // @param dataPath (String) The dataPath to store the value at.  If null, the dataPath will
    //                          be picked up from the field
    // @param value (Any) The value to save
    // @param values (Record)The valueset in which to save the field value
    // @param reason (String) An optional reason for the save request, to be passed into
    //                                   any +link{SimpleType.updateAtomicValue()} method - see that
    //                                   API for details
    // @visibility external
    //<
    saveValueViaDataPath : function(field, dataPath, value, values, reason) {
        return isc.Canvas._saveFieldValue(dataPath, field, value, values, null, true, reason);
    },

    //> @classMethod dataSource.clearValueAtDataPath()
    // Helper method to save the argument value inside the argument values record, storing the 
    // value at the supplied dataPath, or at the field's declared dataPath if the argument 
    // dataPath is null.  This method is only of real use when you are dealing with complex 
    // nested data via +link{Canvas.dataPath,dataPath}; it is obviously a trivial matter 
    // to store a field value in a flat record directly.
	// <P>
	// This method will call the +link{simpleType.updateAtomicValue(),updateAtomicValue()}
    // method of custom +link{SimpleType} fields where this is required.
    //
	// @param field (DataSourceField | ListGridField | DetailViewerField | FormItem)
	//  Field definition from a dataSource or dataBoundComponent.
    // @param dataPath (String) The dataPath at which to clear the value.  If null, the dataPath will
    //                          be picked up from the field
    // @param values (Record)The valueset from which to clear the field value
    // @visibility external
    //<
    clearValueAtDataPath : function(field, dataPath, values) {
        if (dataPath == null) {
            dataPath = field;
        }
        isc.Canvas._clearFieldValue(dataPath, values, null, true);
    },

    // helper method that returns a shallow copy of requestProperties
    // we want to avoid side-effecting the requestProperties that application developers 
    // pass into our APIs, since otherwise re-used requestProperties objects might carry over 
    // settings like requestProperties.prompt or requestProperties.operationId between different 
    // types of operations.
    dupRequest : function (requestProperties) {
        if (!requestProperties || requestProperties._alreadyDuped) return requestProperties;

        return isc.addProperties({_alreadyDuped:true}, requestProperties);
    },
    
    // helper method for getObjectField; returns inheritance distance or -1 on error
    getInheritanceDistance : function (superclass, subclass) {
        // check that the arguments are in fact classes, and confirm their relationship
        var superclassObj = isc.ClassFactory.getClass(superclass),
            subclassObj = isc.ClassFactory.getClass(subclass)
        ;
        if (superclassObj == null || subclassObj == null) {
            this.logWarn("Invalid superclass and/or subclass argument provided");
            return -1;
        }
        if (!subclassObj.isA(superclass)) {
            this.logWarn(subclass + " is not a subclass of " + superclass);
            return -1;
        }

        // The normal procedure works if both are Class or both are
        // SGWTFactory.  In the mixed case, we need to get the scClass for the
        // SGWTFactory and compute using that.
        if (isc.isA.SGWTFactoryObject(superclassObj)) {
            if (!isc.isA.SGWTFactoryObject(subclassObj)) {
                superclassObj = superclassObj.getDefaultScClass();
                if (!superclassObj) {
                    this.logWarn("Could not get defaultScClass for SGWTFactory " + superclass);
                    return -1;
                }
            }
        } else if (isc.isA.SGWTFactoryObject(subclassObj)) {
            // We only get here if the superclass is not an SGWTFactory
            subclassObj = subclassObj.getDefaultScClass();
            if (!subclassObj) {
                this.logWarn("Could not get defaultScClass for SGWTFactory " + subclass);
                return -1;
            }
        }
        
        for (var distance = 0; subclassObj != superclassObj; distance++) {
            subclassObj = subclassObj.getSuperClass();
        }
        
        return distance;
    },

    // simple: String, Number, Boolean, Date, Time, Function
    // non-simple: null, Object, Array
    
    isSimpleTypeValue : function (value) {
        if (value != null && (!isc.isAn.Object(value) || isc.isA.Date(value))) return true;
        return false;
    },

    // Given an object, find the nearest schema to be used to serialize it.
    // If there is a SmartClient Class, but no schema exists (eg custom class), we find the
    // nearest SmartClient super class that has a schema.
    getNearestSchema : function (object) {
        if (object == null) return null;
    
        var className;
        if (isc.isA.String(object)) className = object;
        else {
            className = isc.isAn.Instance(object) ? object.getClassName() : 
                                                    object._constructor || object.type || object.$schemaId;
        }

		var schema = isc.DS.get(className);

        // If there is no schema whose ID is the class name, then check
        // for a schema which can be used to construct the class name
        if (!schema) {
            schema = isc.DS.get(this._constructorToDatasourceIds[className]);
        }
		
        // if no schema is loaded for this class, look for a superclass schema
        if (schema) return schema;

		var theClass = isc.ClassFactory.getClass(className);
        var originalClass = theClass;

        if (theClass != null) {
    		var lastSuperClass = null;
	    	while (schema == null && (theClass = theClass.getSuperClass()) != null && 
                                      theClass != lastSuperClass) 
            {

	    		schema = isc.DS.get(theClass.getClassName());
                if (schema == null) {
                    schema = isc.DS.get(this._constructorToDatasourceIds[className]);
                }

		    	lastSuperClass = theClass;
    		}
            
            // If we have no schema, and we're looking at an SGWTFactoryObject,
            // then try again with the SC equivalent
            if (!schema) {
                if (isc.isA.SGWTFactoryObject(originalClass)) {
                    var scClassName = originalClass.getDefaultScClassName();
                    if (scClassName) return this.getNearestSchema(scClassName);
                }
            }
        }

        return schema || isc.DS.get("Object");
    },
    
    // Given a SmartClient component schema name, determine the associated SmartClient class
    
    getNearestSchemaClass : function (type) {
        if (type == null) return null;
        var theClass;
        
        while (theClass == null) {
            // Pick up the dataSource for the className passed in.
            // This will allow us to determine the correct SmartClient class for the object
            // by iterating up the datasource parent chain if necessary
            var schema = isc.DS.get(type);
            // Catch the case where we're passed a schema string that we don't recognize
            if (schema == null) {
                // Check if it represents an SGWT class ... in that case, use the SGWTFactory
                var sgwtClass = isc.ClassFactory.getClass(type);
                if (sgwtClass && isc.isA.SGWTFactoryObject(sgwtClass)) {
                    return sgwtClass;
                } else {
                    return null;
                }
            }
            theClass = isc.ClassFactory.getClass(schema._constructor || schema.Constructor 
                                                                     || schema.type);
            //this.logWarn("schema is: " + schema + ", theClass: " + theClass + 
            //             ", schema.inheritsFrom: " + schema.inheritsFrom);
            
            if (theClass != null) return theClass;
            type = schema.inheritsFrom;
            
            if (!type) return null;
        }
        return null;
    },

    // Standard Operations
	// ----------------------------------------------------------------------------------------

    // Centrally handle backcompat synonyms for operation types
    _getStandardOperationType : function (operationType) {
        switch (operationType) {
            case "fetch":
            case "select":
            case "filter":
                return "fetch";
            case "add":
            case "insert":
                return "add";
            case "update": 
                return "update";
            case "remove":
            case "delete":
                return "remove";

            default:
                // cases not covered:
                // "replace": no longer supported, but not equivalent to any supported type
                // "validate": never had a synonym

            return operationType;
        }
    },

	isClientOnly : function (dataSource) {
		if (isc.isA.String(dataSource)) dataSource = this.getDataSource(dataSource);
		if (!dataSource) return false;
		return dataSource.clientOnly;
	},

    //> @classMethod DataSource.makeFileSpec()
    //
    // Converts a file path to a +link{FileSpec}.
    //
    // @param path (String) The path to convert, e.g. "employees.ds.xml"
    // @return (FileSpec) The equivalent FileSpec, e.g. {fileName: "employees", fileType: "ds",
    //                    fileFormat: xml"}
    // @group fileSource
    // @visibility external
    //<
    makeFileSpec : function (path) {
        var fileSpec = {};

        // Remove initial or trailing "/"
        path = path.trim();
        if (path.startsWith("/")) path = path.slice(1);
        if (path.endsWith("/")) path = path.slice(0, -1);

        // Split on "/"
        var parts = path.split("/");

        // Get just the filename portion ... i.e. after last "/"
        var onlyFileName = parts[parts.length - 1];

        // If the URL included query parameters, warn and ignore them - they aren't
        // supported for FileSource requests
        var queryIndex = onlyFileName.indexOf("?"),
            queryString;
        if (queryIndex != -1) {
            queryString = onlyFileName.substring(queryIndex);
            onlyFileName = onlyFileName.substring(0,queryIndex);

            this.logWarn("File path passed to getFile() or makeFileSpec() includes a query parameter:" 
                + queryString + ". This will be ignored.");
        }

        // From something like employees.ds.xml, get "ds" as the fileType and "xml" as the fileFormat
        // Rules:
        // -- the fileType and fileFormat cannot have spaces in them (that is,
        //    a dot followed at some point by a space will be interpreted as belonging
        //    to the fileName, not as separating the fileName from the fileType or fileFormat)
        // -- fileType and fileFormat are separated from the fileName and each other by a dot "."
        // -- if there is only one specified, then it is the fileType
        var tokens = onlyFileName.split(".");
        var length = tokens.length;

        switch (length) {
            case 0:
            case 1:
                // No dots found, so no fileType or fileFormat specified
                // Just break
                break;

            case 2:
                // If there is one extension, it is the fileType, as long as it has no spaces
                if (!tokens[1].contains(" ")) {
                    fileSpec.fileType = tokens[1];
                }
                break;

            default:
                // If there are two or more extensions, then check the last two
                fileSpec.fileType = tokens[length - 2];
                fileSpec.fileFormat = tokens[length - 1];

                if (fileSpec.fileFormat.contains(" ")) {
                    // If the last token had a space, then assume the whole thing is fileName
                    delete fileSpec.fileType;
                    delete fileSpec.fileFormat;
                } else if (fileSpec.fileType.contains(" ")) {
                    // If the second-last token had a space, then assume the last token is the dsFileType
                    fileSpec.fileType = fileSpec.fileFormat;
                    delete fileSpec.fileFormat;
                }
                break;
        }

        // Strip the extensions from the path, +1 for the dot
        var extensionLength = (
            fileSpec.fileType ? fileSpec.fileType.length + 1 : 0
        ) + (
            fileSpec.fileFormat ? fileSpec.fileFormat.length + 1 : 0
        );
        // If there was a query string on the original URL, strip that too
        if (queryString != null) extensionLength += queryString.length;

        if (extensionLength == 0) {
            fileSpec.fileName = path;
        } else {
            fileSpec.fileName = path.slice(0, -extensionLength);
        }
        return fileSpec;
    },

	// ResultSets creation
	// --------------------------------------------------------------------------------------------

    // make a default operation for the specified dataSource, using the specified application.
	// if no application is specified, use the default application.
    makeDefaultOperation : function (dataSourceId, operationType, operationId) 
    {
		// XXX this is really only intended for the standard set of operations (fetch, update,
        // add, remove): check that operationType is valid?
		
		var theApp = isc.rpc.app();

        if (isc.isA.DataSource(dataSourceId)) dataSourceId = dataSourceId.ID;
        if (!dataSourceId) {
            dataSourceId = "auto";
        } else if (operationId) {
            
            // If we have a valid dataSource and operationId, store/lookup against the 
            // dataSource, not the app - so, eg, we can have an operationId "customFetch" 
            // on more than one dataSource
            var dataSource = isc.DataSource.get(dataSourceId);
            if (isc.isA.DataSource(dataSource)) {
                if (!dataSource.createdOperations) dataSource.createdOperations = {};
                var operation = dataSource.createdOperations[operationType + " " + operationId];
                if (operation == null) {
                    operation = {ID:operationId,
                                 dataSource:dataSourceId,
                                 type:operationType, 
                                 filterType:"paged",
                                 loadDataOnDemand:true};
                    dataSource.createdOperations[operationType + " " + operationId] = operation;
                }
                return operation;
            } 
        }
    
        // NOTE: removed code that added the datasource to the application if it wasn't
        // already there so that it could be looked up when performing the operation;
        // now behavior is that if no datasources are defined on the app, it will just
        // look for a currently loaded datasource with that name

        // make sure the app has an operations array
        if (theApp.operations == null) theApp.operations = {};

        // create the default operation on this DataSource

        // allow an operationId, otherwise create one based on DS and operation type
        operationId = operationId || dataSourceId + "_" + operationType;
        var operation = theApp.operations[operationId];
        if (operation == null) {
            operation = {ID:operationId,
                         dataSource:dataSourceId,
                         type:operationType, 
                         filterType:"paged",
                         loadDataOnDemand:true,
                         source:"auto"};
            theApp.operations[operationId] = operation;

            
        }

        // return the operation
        return operation;
    },

	// ResultSet cache sync
	// --------------------------------------------------------------------------------------------
    // NOTE: if an operation modifies more than one DataSource, obviously its not going to make
    // sense to pass the same updateData to ResultSets on different DataSources.  We assume you
    // know that you don't have a ResultSet on the second DataSource, or are dropping cache on
    // updates!

    handleUpdate : function (dsResponse, dsRequest) { 
        if (!this.isUpdateOperation(dsRequest.operationType)) return;
        
        // notify the datasource that the operation affects
        var ds = this.get(dsRequest.dataSource);
        ds.updateCaches(dsResponse, dsRequest);
    },

	// is this an operation which alters data?
	isUpdateOperation : function (operation) {
		if (operation == "add" || operation == "update" || operation == "remove" || 
            operation == "replace" 
            //>!BackCompat 2004.7.23 synonyms
            || operation == "delete" || operation == "insert" 
            //<!BackCompat
           ) return true;
	},
    
    getUpdatedData : function (dsRequest, dsResponse, useDataFromRequest) {
        var ds = this.get(dsRequest.dataSource);
        return ds.getUpdatedData(dsRequest, dsResponse, useDataFromRequest);
    },

    // ---------------------------------------------------------------------------------------
    
	// given a set of values from a DynamicForm, return appropriate filter criteria
	filterCriteriaForFormValues : function (formValues) {
        if (isc.DS.isAdvancedCriteria(formValues)) return formValues;
    
		var filterValues = {};
		for (var fieldName in formValues) {
			var formValue = formValues[fieldName];
			// Form fields may have the value "" if they held a value and were cleared out.  A
            // blank field in a form used as a filter means "field can have any value", not
            // "field must be blank", so we eliminate blank field->value pairs.
			// This also goes for a selectList where a blank value is selected, which is
            // supposed to mean "Any".
			if (formValue == null || isc.is.emptyString(formValue)) continue;

			// multi-selects are returned as an array.  
			if (isc.isAn.Array(formValue)) {
                
                // If nothing is selected we get [], meaning no criteria
                if (formValue.length == 0) continue;
			    // If blank is selected, we get ["", "otherValue", ...], meaning "field can
                // have any value".
                
                for (var i = 0; i < formValue.length; i++) {
                    var orValue = formValue[i];
                    if (isc.isAn.emptyString(orValue)) continue;
                }
            }
			
			// use the formValue as is
			filterValues[fieldName] = formValue;

			// NOTE: we do this on the client rather than the server because otherwise the client
			// would be unable to express "field must be blank" - the server would discard the
			// criterion assuming it was an artifact of the filterValues having come from a
			// DynamicForm.
		}
		return filterValues;
	},

    checkEmptyCriteria : function (criteria, subCriterion) {
    	
        if ((subCriterion || this.isAdvancedCriteria(criteria)) && criteria.criteria) {
            if (criteria.criteria.length == 0 ) return null;

            for (var i=criteria.criteria.length-1; i>=0; i--) {
                var subCrit = criteria.criteria[i],
                    shouldRemove = false;

                if (!subCrit) shouldRemove = true;
                else {
                    if (!subCrit.criteria) {
                        // is this an empty object?
                        if (isc.isA.emptyObject(subCrit)) shouldRemove = true;
                    } else {
                        var crit = this.checkEmptyCriteria(subCrit, true);
                        if (crit) criteria.criteria[i] = crit;
                        else shouldRemove = true;
                    }
                }

                if (shouldRemove) criteria.criteria.removeAt(i);
            }
        }

        return criteria;
    },

    //> @classAttr DataSource.serializeTimeAsDatetime (boolean : false : IRA)
    // Specifies how time field values should be serialized when being sent to the server for
    // dataSources with dataFormat <code>"xml"</code> or <code>"json"</code>.
    // If <code>false</code> the time field will be serialized as a logical time object in
    // UTC, using the standard truncated XML Schema format: <code>"HH:MM:SS"</code>.
    // If <code>true</code> the time field will be serialized as a complete dateTime object
    // matching the value of the underlying JavaScript date object representing this time on the
    // client.
    // @visibility external
    //<
    
    serializeTimeAsDatetime:false,
    
    //> @object DSLoadSettings
    // Settings to control optional +link{DataSource.load,DataSource loading} features.
    //
    // @treeLocation Client Reference/Data Binding/DataSource
    // @see dataSource.load() 
    // @visibility external
    //<

    //> @attr dSLoadSettings.forceReload (Boolean : null : IRW)
    // Forcibly reload a dataSource if it's already loaded.
    // @visibility external
    //<
    //> @attr dSLoadSettings.loadParents (Boolean : null : IRW)
    // Load parent DataSources
    // @visibility external
    //<
    //> @attr dSLoadSettings.mockMode (Boolean : null : IRW)
    // Place loaded DataSource into +link{dataSource.mockMode,mockMode}
    // @visibility external
    //<

    //> @classMethod DataSource.load()
    // Load a DataSource or an array of DataSources using the DataSourceLoader servlet.  When
    // a callback is specified, this is fired after the DataSources are loaded.  The callback
    // is passed a single parameter, the <code>dsID</code> list passed into the method.  If
    // no loading occurs because the requested DataSource(s) are already loaded, a warning is 
    // logged and the callback is fired immediately.
    // <P>
    // To force reloading of DataSources that have already been loaded,
    // pass <code>true</code> for the forceReload parameter. Note that if a DataSource has been
    // created locally with the specified ID, even if this is a +link{MockDataSource}, the
    // <code>forceReload</code> parameter will be required to force the "real" dataSource
    // to be loaded.
    //
    // @param dsID (String | Array of String) DataSource ID or Array of DataSource IDs
    // @param callback (Function) Callback to fire after DataSource loading completes
    // @param [forceReload] (boolean | DSLoadSettings) Forcibly reload a dataSource if it's already loaded
    // @visibility external
    //<
    load : function (dsID, callback, forceReload, loadParents) {
        
        var mockMode;
        var requestProps;
        var sandboxContext;

        // DataSource.get() used to implicitly call loadSchema() if the requested DS is not
        // present.  This is now deprecated, and we use the standard load() method instead for
        // these internal dataSource loads.  However, DS.get() has an existing pattern of 
        // accepting a context object, so we'll pull the parameter values out of that
        if (isc.isAn.Object(forceReload)) {
            mockMode = forceReload.mockMode;
            loadParents = forceReload.loadParents;
            requestProps = forceReload.requestProps;
            sandboxContext = forceReload.sandboxContext;

            // finally reassign the obj
            forceReload = forceReload.forceReload;
        }

        // when sandboxContext is in effect, force load because only the server knows where
        // the definition will come from, so there's no way for us to know a priori whether or
        // not we have the right cached value (ultimately because the server sandboxing code
        // is what determins the ID of the resulting DS since sandboxing is encoded in the ID)
        if (sandboxContext) forceReload = true;
        
        var singleName, 
            callbacks;
        
        if (!isc.isAn.Array(dsID)) {
            // If there is a single DataSource to load, we may have been called from DS.get(),
            // and it is possible that multiple framework calls to DS.get() for the same 
            // DataSource will arrive while we are waiting for the server to respond.  In 
            // this case, we will have a callbacks registry for the named datasource and all 
            // we need to do is register our callback and wait for the server to reply.  This 
            // way we suppress multiple server requests for the same dataSource.
            callbacks = isc.DataSource._getDataSourceCallbacks;
            if (callbacks[dsID]) {
                callbacks[dsID].add(callback);
                return null;
            } else {
                // this is the first request for this dataSource
                callbacks[dsID] = [];
                callbacks[dsID].add(callback);
            }                
            singleName = dsID;
            dsID = [dsID];
        }

        if (dsID.length <= 0) {
            this.logWarn("No DataSource IDs passed in.");
            return;
        }

        var loadThese = [];
        
        for (var i=0; i<dsID.length; i++) {
            if (!this.isLoaded(dsID[i]) || forceReload) loadThese.add(dsID[i]);
        }

        var dsList = loadThese.join(","),
            url = isc.DataSource.loaderURL + 
                    (isc.DataSource.loaderURL.contains("?") ? "&" : "?") +
                    (loadParents ? "loadParents=true&" : "") +
                    (mockMode ? "mockMode=true&" : "") + "dataSource="+dsList;

        if (loadThese.length > 0) {

            var combinedRequestProps = {
                actionURL: url,
                httpMethod: "GET",
                willHandleError: true,
                clientContext : {
                    dsID : dsID
                }
            };
            if (requestProps) {
                combinedRequestProps = isc.combineObjects(isc.addProperties({}, combinedRequestProps), requestProps);
            }

            if (sandboxContext) {
                // serialize sandboxContext to URL
                var requestParams = combinedRequestProps.params || {};
                combinedRequestProps.params = requestParams;
                for (var key in sandboxContext) {
                    // prefix each context value with special sbx_ to avoid conflicts
                    requestParams['sbx_'+key] = sandboxContext[key];
                }
                combinedRequestProps.clientContext.sandboxContext = sandboxContext;
            }

            // post out to the DataSourceLoader servlet
            isc.RPCManager.send(null, 
                function (rpcResponse, data, rpcRequest) {
                    var dsID = rpcRequest.clientContext.dsID;
                    var sandboxContext = rpcRequest.clientContext.sandboxContext;

                    //!OBFUSCATEOK
                    if (rpcResponse.httpResponseCode == 404) {
                        isc.warn("The DataSourceLoader servlet is not available at the configured DataSource.loaderURL ('" + isc.DataSource.loaderURL + "').");
                        return null;
                    }
                    if (loadParents && !forceReload) isc.DataSource._doNotClobber = true;
                    try {
                        // eval the returned create() statement(s) and fire the callback if passed
                        if (sandboxContext) {
                            isc.DataSource._dsGlobalsRename = {};
                            for (var i = 0; i < dsID.length; i++) {
                                var ID = dsID[i],
                                    newID = isc.DS._getSandboxedID(ID, sandboxContext);
                                isc.DataSource._dsGlobalsRename[ID] = newID;

                                // replace for callback
                                dsID[i] = newID;
                            }
                        }
                        isc.Class.evaluate(data);
                    } catch(e) {
                        isc.logWarn("Response from DataSourceLoader caused exception " +
                                isc.echoAll(e) +
                                ", response was:\n" +
                                data);
                    }
                    delete isc.DataSource._dsGlobalsRename;
                    delete isc.DataSource._doNotClobber;
                    if (singleName) {
                        for (var i = 0; i < callbacks[singleName].length; i++) {
                            var cb = callbacks[singleName][i];
                            if (cb) this.fireCallback(cb, ["dsID"], [dsID]);
                        }
						delete callbacks[singleName];
                    } else {
                        if (callback) this.fireCallback(callback, ["dsID"], [dsID]);
                    }
                },
                combinedRequestProps
            );
        } else {
            this.logWarn("DataSource(s) already loaded: " + dsID.join(",") + 
                "\nUse forceReload to reload such DataSources");
            if (callback) this.fireCallback(callback, ["dsID"], [dsID]);
            
            
            if (singleName) delete callbacks[singleName];
        }
    },

    
    _getSandboxedID : function (id, sandboxContext) {
        var newID = id;
        for (var key in sandboxContext) {
            newID += "_sbx_" + key + "_" + sandboxContext[key];
        }
        return newID;
    },
    
    //> @classMethod dataSource.loadWithParents()
    // Variation of +link{DataSource.load()} that will also automatically load any DataSources that
    // the requested DataSources inherit from (via +link{DataSource.inheritsFrom}).
    // <P>
    // If the parent DataSource is already loaded, calling <code>loadWithParents</code> will not
    // automatically reload them unless the forceReload parameter is passed.
    // 
    // @param dsID (String | Array of String) DataSource ID or Array of DataSource IDs
    // @param callback (Function) Callback to fire after DataSource loading completes
    // @param [forceReload] (boolean | DSLoadSettings) Forcibly reload a dataSource if it's already loaded
    //
    // @visibility external
    //<
    loadWithParents : function (dsID, callback, forceReload) {
        if (isc.isAn.Object(forceReload)) {
            forceReload.loadParents = true;
        }
        this.load(dsID, callback, forceReload, true);
    },
    
    //> @classMethod DataSource.getSortBy()
    // Given an array of +link{SortSpecifier}s, return a simple list of Strings in the format
    // expected by +link{dsRequest.sortBy}.
    //
    // @param sortSpecifiers (Array of SortSpecifier) The list of specifiers to return in  
    // sortBy format
    // @return (Array of String) An array of sort-definitions in the format expected by 
    // +link{dsRequest.sortBy}
    // @visibility external
    //<
    getSortBy : function (sortSpecifiers) {
        if (!isc.isA.Array(sortSpecifiers)) sortSpecifiers = [sortSpecifiers];
        
        var sortArray = [];
        for (var i=0; i<sortSpecifiers.length; i++) {
            var item=sortSpecifiers.get(i),
                property = item.sortByProperty || item.property;
            if (property == null) continue;
            sortArray.add((!Array.shouldSortAscending(item.direction) ? "-" : "") + property);
        }
        return sortArray;
    },

    //> @classMethod DataSource.getSortSpecifiers()
    // Return an array of +link{SortSpecifier}s, given an array of Strings in the format
    // expected by +link{dsRequest.sortBy}.
    //
    // @param sortBy (Array of String) A list of sortBy strings in the format expected by +link{dsRequest.sortBy}
    // @return (Array of SortSpecifier) An array of +link{SortSpecifier}s equivalent to the passed in string array
    // @visibility external
    //<
    getSortSpecifiers : function (sortBy) {
        if (!isc.isA.Array(sortBy)) sortBy = [sortBy];
        
        var specifierArray = [];
        for (var i=0; i<sortBy.length; i++) {
            var item = sortBy.get(i),
                direction = "ascending",
                property = item
            ;
            if (item.substring(0,1) == "-") {
                direction = "descending";
                property = item.substring(1);
            }
            specifierArray.add({ property: property, direction: direction})
        }
        return specifierArray;
    },

    // class-level version of isAdvancedCriteria - accepts a DS as a param, passed in by calls
    // from the instance-level method
    isAdvancedCriteria : function (criteria, dataSource) {
        if (!criteria || isc.isAn.emptyObject(criteria)) return false;

        if (!dataSource) {
            // Is it explicitly marked as AdvancedCiteria?
            return (criteria && criteria._constructor == "AdvancedCriteria");
        }

        if (!isc.isA.DataSource(dataSource)) dataSource = this.get(dataSource);

        // we have a dataSource
        if (criteria._constructor == "AdvancedCriteria") return true;

        // Not explicitly marked, so we'll make a guess.
        var returnVal = false,
            searchOp = dataSource.getSearchOperator(criteria.operator)
        ;

        
        if (dataSource.getField(criteria.fieldName) && searchOp) {
            returnVal = true;
        }

        // Before applying further heuristics, make sure that this DataSource
        // doesn't have any fields that are actually called "fieldName" or "operator"
        else if (dataSource.getField("fieldName") || dataSource.getField("operator")) returnVal = false;

        // if the criteria has fieldName and operator attribues *AND* the operator is
        // valid, assume we have advancedCriteria - this caters for criteria agains calculated
        // fields, which do not appear as DS-fields
        
        else if (criteria.fieldName && (criteria.operator && searchOp)) {
            returnVal = true;
        }

        // if the criteria has fieldName and value attributes but no operator assume
        // we have advancedCriteria where operator is implied as "equals".
        else if (criteria.fieldName && criteria.value != null && criteria.operator == null) {
            returnVal = true;
        } else {
            // We'll also assume it's an AdvancedCriteria if there is no fieldName property and
            // the operator is either "and" or "or".
            var undef;
            if (criteria.operator != undef) {
                var op = searchOp;
                if (op != null && (op.isAnd || op.isOr)) {
                    returnVal = true;
                }
            }
        }
        this.logInfo("Criteria object:" + this.echo(criteria) + " not explicitly marked as AdvancedCriteria" +
            (returnVal ? " but treating as Advanced based on format." : " - treating as SimpleCriteria."), "AdvancedCriteria");
        return returnVal;
    },

    //> @classMethod DataSource.copyCriteria
    // Create a copy of a criteria.
    //
    // @param criteria (Criteria) criteria to copy
    // @return (Criteria) copy of criteria
    // @visibility external
    //<
    copyCriteria : function (criteria) {
        if (criteria == null) return null;
        return isc.clone(criteria);
    },
    
    getCriteriaFields : function (criteria, dataSource, isSubcriterion) {
        if (dataSource && !isc.isA.DataSource(dataSource)) dataSource = this.get(dataSource);
        if (isSubcriterion || 
            (dataSource ? dataSource.isAdvancedCriteria(criteria) : 
                this.isAdvancedCriteria(criteria))
           ) 
        {
            var fieldNames = [];
            this._getAdvancedCriteriaFields(criteria, fieldNames);
            return fieldNames;
        }
        return isc.getKeys(criteria);
    },

    // Drill into advancedCriteria object extracting fields
    _getAdvancedCriteriaFields : function (criterion, fieldNames) {
        if (criterion.criteria) {
            for (var i = 0; i < criterion.criteria.length; i++) {
                isc.DS._getAdvancedCriteriaFields(criterion.criteria[i], fieldNames);
            }
        } else {
            fieldNames.add(criterion.fieldName);
        }
    },

    // Drill into advancedCriteria object extracting operators
    _getAdvancedCriteriaOperators : function (criterion, operators) {
        if (criterion.criteria) {
            for (var i = 0; i < criterion.criteria.length; i++) {
                isc.DS._getAdvancedCriteriaOperators(criterion.criteria[i], operators);
            }
        } else {
            operators.add(criterion.operator);
        }
    },

    // ---------- LOCAL RESPONSE CACHING ----------
    _responseCache: [],
    maxResponsesToCache: 100,
    cacheResponse : function (dsRequest, dsResponse) {
        if (isc.Offline) {
            var requestKey = isc.Offline.serialize(isc.Offline.trimRequest(dsRequest));
            var index = this._responseCache.findIndex("requestKey", requestKey);
            if (index != -1) {
                this._responseCache.set(index, dsResponse);
            } else {
                if (this._responseCache.length >= this.maxResponsesToCache) {
                    this._responseCache.removeAt(0);
                }
                this._responseCache.add({
                    requestKey: requestKey,
                    dsResponse: dsResponse
                });
            }
        }
    },
    
    getCachedResponse : function (dsRequest) {
        if (isc.Offline) {
            var requestKey = isc.Offline.serialize(isc.Offline.trimRequest(dsRequest));
            return this._responseCache.find("requestKey", requestKey);
        }
        return null;
    },
    
    
    //> @classAttr DataSource.offlineMessage  (String : "This data not available while offline" : IRW)
    // A message returned by a DataSource when it is returning an empty dataset for a fetch
    // because the browser is currently offline and there is no suitable cached offline response.
    // @group i18nMessages, offlineGroup
    // @visibility external
    //<
    offlineMessage: "This data not available while offline",

    //> @classAttr DataSource.maxFileSizeExceededMessage  (HTMLString : "Size of '${uploadedFileName}' (${uploadedFileSize}) exceeded maximum allowed file size of ${maxFileSize}" : IRW)
    // A message returned by a <code>DataSource</code> when an uploaded file's size exceeded
    // +link{DataSourceField.maxFileSize}.
    // <p>
    // If this is not set, then +link{Validator.maxFileSizeExceeded} value will be used.
    // @group i18nMessages
    // @visibility external
    //<
    maxFileSizeExceededMessage: "Size of '${uploadedFileName}' (${uploadedFileSize}) exceeded maximum allowed file size of ${maxFileSize}",

    //> @classAttr DataSource.requiredFileMessage (HTMLString : "'${uploadedFileName}' was empty, but empty files are not allowed." : IRW)
    // A message returned by a <code>DataSource</code> when an uploaded file was empty, but the
    // field is +link{DataSourceField.required,required}.
    // @group i18nMessages
    // @visibility external
    //<
    requiredFileMessage: "'${uploadedFileName}' was empty, but empty files are not allowed.",

    //> @classAttr DataSource.requiredCriterionMessage (HTMLString : "Operation requires criteria for the following field(s): [${requiredCriterion}]" : IRW)
    // A message returned by a <code>DataSource</code> when an operation requires criteria, but none was provided.
    // @group i18nMessages
    // @visibility external
    //<    
    requiredCriterionMessage: "Operation requires criteria for the following field(s): [${requiredCriterion}]",

    
    getPathValue : function (record, fieldPath, field, reason) {
    	//var field;
    	//if (isc.isAn.Object(fieldPath)) {
        //	field = fieldPath;
    	//	fieldPath = null;
    	//}
        return isc.Canvas._getFieldValue(fieldPath, field, record, null, true, reason);
    },
    
    // setPathValue - corollary for getPathValue()
    setPathValue : function (record, fieldPath, field, value) {
    	//var field;
    	//if (isc.isAn.Object(field)) {
    	//	field = fieldPath;
    	//	fieldPath = null;
		//}
        isc.Canvas._saveFieldValue(fieldPath, field, value, record, null, true);
    },
    
    // Given an array of dataSources, return field identifiers for all fields in the dataSources
    // These will be of the form "dataSourceID.fieldName"
    getCombinedDataSourceFields : function (dataSources) {
        var fields = [];
        for (var i = 0; i < dataSources.length; i++) {
            var dataSource = dataSources[i];
            if (isc.isA.String(dataSource)) dataSource = isc.DataSource.get(dataSource);
            if (dataSource == null) {
                this.logWarn("getCombinedDataSourceFields() - unable to locate dataSource:"
                    + dataSources[i]);
                continue;
            }
            var dsID = dataSource.getID(),
                dsFields = isc.getKeys(dataSource.getFields());
            for (var j = 0; j < dsFields.length; j++) {
                fields[fields.length] = dsID + "." + dsFields[j];
            }
        }
        return fields;
    },
    
    // Given a ds field identifier like "dataSourceId.fieldName", extract the field definition
    // from the appropriate dataSource.
    // The dataSources array is optional - if present, pull from that set of dataSources
    // rather than doing a standard isc.DS.get()
    
    
    getFieldFromDataSources : function (combinedFieldId, dataSources, suppressWarning) {
        var dataSource = this.getDataSourceForField(combinedFieldId, dataSources, suppressWarning);
        if (dataSource == null) {
            if (!suppressWarning) {
            	this.logWarn("getFieldFromDataSources() - unable to find dataSource " +
                	" from combined field ID " + combinedFieldId);
			}
            return null;
        }
        
        var splitFieldId = combinedFieldId.split("."),
            dsId = splitFieldId[0],
            dsFieldName = splitFieldId[splitFieldId.length-1];
        var field = dataSource.getField(dsFieldName);
        // If field was not found, check for a meta field of that name
        if (!field) field = dataSource.getField(isc.Canvas._makeRuleScopeMetaFieldName(dsFieldName));
        return field;
    },
    
    getDataSourceForField : function (combinedFieldId, dataSources, suppressWarning) {

        var splitFieldId = combinedFieldId.split("."),
            dsId = splitFieldId[0],
            dsFieldName = splitFieldId[splitFieldId.length-1];
        if (dsId == null || dsFieldName == null) {
            if (!suppressWarning) {
            	this.logWarn("getDataSourceForField() passed invalid field ID:" + combinedFieldId +
					". Expected format is to use dot-notation to indicate the dataSource plus " +
					"fieldName - for example 'countryDS.countryCode'");
			}
            return null;
        }
        var dataSource;
        if (dataSources == null) dataSource = isc.DataSource.get(dsId);
        else {
            // sanity check only
            if (!isc.isAn.Array(dataSources)) dataSources = [dataSources];
            for (var i = 0; i < dataSources.length; i++) {
                var ds = dataSources[i];
                if (ds && ds.getID() == dsId || 
                        (ds && ds.criteriaBasePath && combinedFieldId.startsWith(ds.criteriaBasePath)))
                {
                    dataSource = ds;
                    break;
                }
                var fieldSplit = combinedFieldId.split(".");
                if (ds && ds.criteriaBasePath) {
                    var fieldName = isc.Canvas._makeRuleScopeMetaFieldName(fieldSplit[fieldSplit.length-1]);
                    var field = ds.getField(fieldName);
                    if (field) {
                        if (field.criteriaPath && field.criteriaPath == combinedFieldId) {
                            dataSource = ds;
                            break;
                        }
                    }
                }
            }
        }
        return dataSource;
    },

    _getDefaultValueForFieldType : function (fieldType) {
        var value;
        switch (fieldType) {
            case "date":
            case "datetime":
            case "time":
                value = new Date(0);
                break;
            case "float":
                value = 0.0;
                break;
            case "integer":
                value = 0;
                break;
            case "boolean":
                value = false;
                break;
            case "text":
            default:
                value = "";
                break;
        }
        return value;
    },
                                 
    _getTypedValueAsString : function (value, fieldType, settings) {
        if (settings == null) settings = {};

        if (value == null) {
            var defaultText = settings.nullValueText;
            if (defaultText != null) return defaultText;
            // if textExportSettings.nullValueText is null, then
            // set value to the default value for the field's type
            value = this._getDefaultValueForFieldType(fieldType);
        }
        switch (fieldType) {
            case "date":
                var format = settings.dateFormat;
                return value.toShortDate(format);
            case "datetime":
                var format = settings.dateTimeFormat;
                return value.toShortDateTime(format);
            case "time":
                var format = settings.timeFormat;
                return isc.Time.toShortTime(value, format);
            case "float":
            case "integer":
            case "boolean":
            default:
                return value.toString();
            case "text":
                return value;
        }
    },
    
    //> @classMethod DataSource.isFlatCriteria(AdvancedCriteria) 
    // Returns true if a given AdvancedCriteria is "flat." That is, the criteria consists of either:
    // <ul> 
    // <li> a top-level "and" or "or" +link{Criterion}, where none of the 
    //      +link{Criterion.criteria,subcriteria} use +link{LogicalOperator,logical operators},
    //      hence have no subcriteria of their own
    // <li> a single Criterion that is not a logical operator, hence has no subcriteria
    // </ul>
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to check for flatness
    // @return (boolean) true if criteria is flat
    // @visibility external
    //<
    isFlatCriteria : function (criteria) {
        if (!criteria) return false;

        var op = isc.DS._operators[criteria.operator];
        
        // Is criteria a single Criterion?
        if (isc.isA.emptyObject(criteria) || (criteria.fieldName && op && op.valueType != "criteria")) 
        {
            return true;
        }

        // Does criteria have a top-level logical operator but no other
        // logical operators in sub-criteria?
        if (op && op.valueType == "criteria" && criteria.criteria) {
            var subCriteria = criteria.criteria;
            for (var i = 0; i < subCriteria.length; i++) {
                var criterion = subCriteria[i],
                    subOp = criterion.operator ? isc.DS._operators[criterion.operator] : null,
                    logical = subOp && subOp.valueType == "criteria"
                ;
                if (logical) {
                    return false;
                }
            }
            return true;
        }
        return false;
    },

    //> @classMethod DataSource.flattenCriteria(AdvancedCriteria)
    // Returns new criteria that has at most one top-level LogicalOperator ("and" or "or").
    // This new criteria will be considered "flat" by +link{isFlatCriteria}.
    // <p>
    // Not all AdvancedCriteria can be flattened and remain logically equivalent.  When
    // criteria will be logically modified by flattening, all criteria that appear anywhere in
    // the AdvancedCriteria structure will appear under a single top-level operator, which
    // will be the same top-level operator as the passed AdvancedCriteria.
    // <p>
    // For example, given criteria like this (in the JSON representation of AdvancedCriteria):
    // <pre>
    //      { operator: "and", criteria: [
    //         { fieldName: "continent", operator: "equals", value: "Europe"},
    //         { operator: "or", criteria: [
    //            { fieldName: "countryName", operator: "iEndsWith", value: "land"},
    //            { fieldName: "population", operator: "lessThan", value: 3000000}
    //         ]}
    //        ]
    //      }
    // </pre>
    // The returned criteria would be:
    // <pre>
    //      { operator: "and", criteria: [
    //         { fieldName: "continent", operator: "equals", value: "Europe"},
    //         { fieldName: "countryName", operator: "iEndsWith", value: "land"},
    //         { fieldName: "population", operator: "lessThan", value: 3000000}
    //       ]}
    // </pre>
    // This returned criteria is not logically equivalent to the passed criteria - the
    // "iEndsWith" and "lessThan" criteria that were formerly nested under a logical "or"
    // operator must now <i>both</i> be satisfied instead of <i>either</i> being satisfied.
    // You can use +link{canFlattenCriteria()} to detect whether an AdvancedCriteria is going
    // to be changed by <code>flattenCriteria()</code>.
    // <p>
    // Because the returned criteria may not be logically equivalent,
    // <code>flattenCriteria</code> should not be used as a means of simplifying criteria to
    // make server implementation easier or anything of the kind.  The primary purpose of
    // returning logically different criteria is to enable an end user to switch from an
    // interface for editing nested criteria to an interface that can't handle nested
    // criteria and convert the criteria while preserving as much as possible.
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to flatten
    // @return (AdvancedCriteria) flattened criteria
    // @visibility external
    //<
    flattenCriteria : function (criteria) {
        if (!criteria) return null;

        // Start with top-level criteria
        var flatCriteria = isc.addProperties({}, criteria);

        // Add all sub-criteria as a single criteria list
        if (flatCriteria.criteria) {
            flatCriteria.criteria = [];
            this._addSubCriteriaToList(flatCriteria.criteria, criteria);
        }

        return flatCriteria;
    },
    _addSubCriteriaToList : function (list, criteria) {
        if (!criteria.criteria) {
            list.add(isc.addProperties({}, criteria));
            return;
        }
        var subCriteria = criteria.criteria;
        for (var i = 0; i < subCriteria.length; i++) {
            var criterion = subCriteria[i];
            this._addSubCriteriaToList(list, criterion);
        }
    },

    //> @classMethod DataSource.canFlattenCriteria(AdvancedCriteria)
    // Returns true if calling +link{flattenCriteria()} on the passed criteria would produce
    // logically equivalent criteria.
    //
    // @param criteria (AdvancedCriteria) the AdvancedCriteria to check for flatness
    // @return (boolean) true if criteria can be flattened without logical change
    // @visibility external
    //<
    canFlattenCriteria : function (criteria) {
        if (!criteria) return false;

        // If criteria is already flat, it can be flattened.
        if (isc.DataSource.isFlatCriteria(criteria)) return true;

        // If top-level operator and all sub-criteria operators
        // are the same, the criteria can be flattened.
        var topLevelOperator = criteria.operator;
        if (this._criteriaHasSameLogicalOperators(criteria, topLevelOperator)) return true;
        
        return false;
    },
    _criteriaHasSameLogicalOperators : function (criteria, operator) {
        if (!criteria.criteria || criteria.criteria.isEmpty()) return true;
        
        if (criteria.operator != operator) {
            // if there's only one subCriteria, and it's not advanced (has no criteria 
            // array of its own), it can still be flattened, whatever the operator (unless 
            // the operator is "not") - otherwise, return false here
            if (criteria.criteria.length != 1 || criteria.criteria[0].criteria || criteria.operator == "not") return false;
        }

        var subCriteria = criteria.criteria;
        for (var i = 0; i < subCriteria.length; i++) {
            var criterion = subCriteria[i];
            if (!this._criteriaHasSameLogicalOperators(criterion, operator)) return false;
        }
        
        return true;
    },

    //> @classMethod DataSource.getAdvancedCriteriaDescription()
    // Returns a human-readable string describing the clauses in this advanced criteria or criterion.
    // 
    // @param criteria (AdvancedCriteria | Criterion) Criteria to convert to a readable string
    // @param dataSource (DataSource) DataSource to provide definitions of operators
    // @return (String) Human-readable string describing the clauses in the passed criteria
    // @visibility external
    //<
    getAdvancedCriteriaDescription : function (criteria, dataSource, localComponent, criteriaOutputSettings) {

        if (!criteriaOutputSettings) {
            criteriaOutputSettings = {};
        }

        var prefix = criteriaOutputSettings.prefix || '' ,
            suffix = criteriaOutputSettings.suffix || '';

        // support being passed an array of dataSources, and using dot-notation on the fieldNames
        // to extract field info
        if (!isc.isAn.Array(dataSource)) {    
            if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);
            if (!dataSource) return "No dataSource";
        }

        var result = "";

        if (criteria.criteria && isc.isAn.Array(criteria.criteria)) {
            // complex criteria, call this method again with that criteria
            var opId = criteria.operator,
                FB = isc.FilterBuilder.getPrototype(),
                
                opTitle = FB["inline" + 
                    opId.substring(0,1).toUpperCase() + 
                    opId.substring(1,opId.length) + "Title"],
                subCriteria = criteria.criteria
            ;

            for (var i = 0; i<subCriteria.length; i++) {
                var subItem = subCriteria[i];

                result += prefix;

                if (i > 0) result += " " + opTitle + " ";
                if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                    result += "("
                        result += isc.DataSource.getAdvancedCriteriaDescription(subItem, dataSource, localComponent);
                    result += ")"
                } else {
                    result += isc.DataSource.getCriterionDescription(subItem, dataSource, localComponent);
                }

                result += suffix;
            }
        } else {
            // simple criterion or regular criteria
            if (criteria.fieldName == null) {
                criteria = isc.DataSource.convertCriteria(criteria);
            }
            result += prefix + isc.DataSource.getCriterionDescription(criteria, dataSource, localComponent) + suffix;
        }

        return result;
    },

    
    _getFieldOperatorTitle : function (field, op) {
        if (isc.isA.String(op)) op = isc.DS._operators[op];
        if (!op) return null;

        if (isc.isA.String(field)) field = this.getField(field);
        
        var ops = isc.Operators;
        
        if (!field || !field.type) {
            // no field or data type, return the title or titleProperty
            if (op) return op.titleProperty ? ops[op.titleProperty] : op.title;
            return "";
        }

        if (isc.SimpleType.inheritsFrom(field.type, "text")) {
            // text data type, return the textTitleProperty, textTitle, titleProperty or title
            var result = ops[op.textTitleProperty] || op.textTitle;
            if (result) return result;
        }
        // not a text data type - return the titleProperty or title
        return op.titleProperty ? ops[op.titleProperty] : op.title;
    },

    // helper method to return the description of a single criterion
    getCriterionDescription : function (criterion, dataSource, localComponent) {

        if (criterion == null) return "";
        var localValuePrefix = (localComponent != null) ? localComponent.ID + ".values." : null,
            fieldName = criterion.fieldName,
            operatorName = criterion.operator,
            start = criterion.start,
            end = criterion.end,
            field
        ;

        if (isc.isAn.Array(dataSource)) {
            var dataSources = dataSource;
            dataSource = isc.DataSource.getDataSourceForField(fieldName, dataSources);
            if (!dataSource && localComponent && !fieldName.contains(".") && !fieldName.contains("/")) {
                var fieldName = localValuePrefix + fieldName;
                dataSource = isc.DataSource.getDataSourceForField(fieldName, dataSources);
            }
            if (!dataSource) return "No DataSource";
            // At this point we've identified the dataSource, but the fieldName is dot-prefixed, so
            // use getFieldFromDataSources to get the field object.
            field = isc.DataSource.getFieldFromDataSources(fieldName, [dataSource]);
        } else {
            if (!isc.isA.DataSource(dataSource)) dataSource = isc.DS.getDataSource(dataSource);
            if (!dataSource) return "No DataSource";
            if (fieldName) {
                var segments = fieldName.split("."),
                    dsID = segments[0];
                if (dsID == dataSource.ID) fieldName = segments[1];
            }
            field = dataSource.getField(fieldName);
            if (field == null) {
                field = dataSource.getFieldForDataPath(fieldName);
            }
        }

        var operator = dataSource.getSearchOperator(operatorName, field),
            operatorMap = dataSource.getFieldOperatorMap(field, true, operator.valueType, false),
            result=""
        ;

        if (!field) {
            if (criterion.criteria && isc.isAn.Array(criterion.criteria)) {
                // we've been passed an AdvancedCriteria as a simple criterion - log a warning and
                // return the result of getAdvancedCriteriaDescription(), rather than just bailing
                isc.logWarn("DataSource.getCriterionDescription: Passed an AdvancedCriteria - "+
                "returning through getAdvancedCriteriaDescription.");
                return isc.DataSource.getAdvancedCriteriaDescription(criterion, dataSource, localComponent);
            }

            // just an unknown field - log a warning and bail

            result = fieldName + " " + isc.FilterBuilder.missingFieldPrompt + " ";

            isc.logWarn("DataSource.getCriterionDescription: No such field '"+fieldName+"' "+
                    "in DataSource '"+dataSource.ID+"'.");
        } else {
            result = (field.title ? field.title : fieldName) + " ";
        }

        result += (isc.Operators[operator.titleProperty] || operatorMap[operatorName] || operatorName);

        if (operator.valueType != "none") {
            var valuePath = criterion.valuePath;
            if (valuePath != null) {
                if (valuePath.startsWith(localValuePrefix)) valuePath = valuePath.replace(localValuePrefix, "");
                result += " value of " + valuePath;
            } else {
                var value = criterion.value;
                if (isc.DateUtil.isRelativeDate(value)) {
                    // if passed a RelativeDate, convert it to an absolute one for display
                    var type = field ? field.type : null,
                            isLogicalDate = false,
                            sType = isc.SimpleType
                            ;
                    if (sType.inheritsFrom(type, "date") && !sType.inheritsFrom(type, "datetime")) {
                        isLogicalDate = true;
                    }
    
                    value = isc.DateUtil.getAbsoluteDate(value, null, null, isLogicalDate);
                }

                if (operator.valueType == "valueRange") {
                    // use the FilterBuilder shorthand translation of "and" - the general "and" 
                    // operator has the title "Match All" which doesn't make sense in this context
                    var andTitle = isc.FilterBuilder.getPrototype().inlineAndTitle;
                    result += " " + start + " " + andTitle + " " + end;
                } else if (operator.valueType == "fieldName") {
                    // this is an operator like iEqualsField - we want to output the localized
                    // title of the field, not it's name
                    var targetField = dataSource.getField(value);
                    result += " " + (targetField ? targetField.title : null) || fieldName;
                } else if (operatorName != "notNull") {
                    result += " ";
                    if (isc.isA.Date(value)) {
                        // handle dates separately
                        if (value.isLogicalDate) result += value.toShortDate();
                        else result += value.toShortDatetime();
                    } else result += value && value.toString ? value.toString() : value;
                }
            }
        }

        return result;
    },

    //> @classMethod DataSource.getLoaderURL()
    // Returns the +link{DataSource.setLoaderURL(),loaderURL}
    //
    // @return (String) The loaderURL
    // @visibility external
    //<
    getLoaderURL : function() {
        return isc.DataSource.loaderURL;
    },

    //> @classMethod DataSource.setLoaderURL()
    // Sets the URL where the DataSourceLoader servlet has been installed; this is used by the 
    // +link{DataSource.load()} method.  Note, one reason you may wish to modify the loader URL
    // is to include a Cross-Site Request Forgery (CSRF) token, as described 
    // +link{RPCManager.actionURL,here}
    //
    // @param url (String) The new loaderURL
    // @visibility external
    //<
    setLoaderURL : function(url) {
        isc.DataSource.addClassProperties({ loaderURL: url });
    },

    // if any criterions have operator:"equals", remove the operator setting - used to reduce
    // clutter in the output from getViewState() - restored by expandEqualsCriteria()  
    collapseEqualsCriteria : function (criteria) {
        if (!criteria) return;
        if (criteria.criteria) {
            for (var i=0; i<criteria.criteria.length; i++) {
                var crit = criteria.criteria[i];
                if (crit.criteria) isc.DataSource.collapseEqualsCriteria(crit);
                else if (crit.operator == "equals") delete crit.operator;
            }
        } else if (criteria.operator == "equals") delete criteria.operator;
    },

    // if any criterions have a value but no operator, make them operator:"equals" - restores
    // operator settings removed by collapseEqualsCriteria() to reduce clutter in the output 
    // from getViewState()  
    expandEqualsCriteria : function (criteria) {
        if (!criteria) return;
        if (criteria.criteria) {
            for (var i=0; i<criteria.criteria.length; i++) {
                var crit = criteria.criteria[i];
                if (crit.criteria) isc.DataSource.expandEqualsCriteria(crit);
                else if (crit.value != null && !crit.operator) {
                    crit.operator = "equals";
                }
            }
        } else if (criteria.value != null && !criteria.operator) {
            criteria.operator = "equals";
        }
    }

    

    
});


isc.DataSource.addProperties({
    //> @attr dataSource.ID              (String : null : [IR])
	// Unique identifier for this DataSource.  Required for all DataSources.
    //
    // <smartclient>DataSources will make themselves available as JavaScript globals under
    // the same name as their ID only if +link{addGlobalId} is set.</smartclient>
    //
    // @group identity
    // @serverDS allowed
    // @see group:memoryLeaks
    // @visibility external
    //<

    //> @attr dataSource.addGlobalId    (boolean : true : IRA)
    // Whether to make this DataSource available as a global variable for convenience.
    // @group identity
    // @visibility external
    //<
    addGlobalId:true,

    //> @attr dataSource.dataFormat (DSDataFormat : "iscServer" : [IR])
    // Indicates the format to be used for HTTP requests and responses when
    // fulfilling DSRequests (eg, when +link{DataSource.fetchData()} is called).
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    // @example jsonDataSource
    // @example simpleJSON
    //<
    dataFormat:"iscServer",
    
    //> @attr dataSource.useStrictJSON (boolean : null : IR)
    // Should HTTP responses to requests by this dataSource be formatted using the
    // strict JSON subset of the javascript language?
    // If set to true, responses returned by the server should match the format described
    // +externalLink{http://www.json.org/js.html,here}.
    // <P>
    // Only applies to dataSources which send requests to a server and have
    // +link{dataSource.dataFormat} set to "json" or "iscServer".
    // <P>
    // <b>Note:</b> using strict JSON avoids a known issue in Internet Explorer 9 where
    // datasource transactions can leak memory due to a browser behavior where the native
    // <code>eval()</code> method fails to clean up references when the objects
    // go out of scope. See +link{isc.RPCManager.allowIE9Leak} for more on this.
    // @visibility external
    //<
    
    //> @attr dsRequest.useStrictJSON (boolean : null : IR)
    // Should the HTTP response to this request be formatted using the
    // strict JSON subset of the javascript language?
    // If set to true, responses returned by the server should match the format described
    // +externalLink{http://www.json.org/js.html,here}.
    // <P>
    // Only applies to requests sent a server with
    // +link{dataSource.dataFormat} set to "json" or "iscServer".
    // @visibility external
    //<
    
    

    //> @attr dataSource.dataProtocol (DSProtocol : null : [IR])
    // Controls the format in which inputs are sent to the dataURL when fulfilling DSRequests.
    // May be overridden for individual request types using
    // +link{OperationBinding.dataProtocol,operation bindings}.
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.useHttpProxy (boolean : null : IR)
    // Like +link{operationBinding.useHttpProxy}, but serves as a default for this DataSource
    // that may be overridden by individual operationBindings.
    //
    // @group clientDataIntegration
    // @visibility external
    //<
    
    //> @attr dataSource.callbackParam (String : "callback" : [IR])
    // Applies only to dataFormat: "json" and +link{dataTransport}:"scriptInclude".  Specifies
    // the name of the query parameter that tells your JSON service what function to call as
    // part of the response.
    //
    // @see dataSource.dataFormat
    // @see dataSource.operationBindings
    // @see operationBinding.callbackParam
    // @group clientDataIntegration
    // @visibility external
    // @serverDS allowed
    // @example xmlEditSave
    //<
    callbackParam : "callback",

    //> @attr dataSource.requestProperties (DSRequest Properties : null : [IRW])
    // Additional properties to pass through to the +link{DSRequest}s made by this
    // DataSource.  This must be set before any +link{DSRequest}s are issued and before
    // any component is bound to the DataSource.
    // <p>
    // These properties are applied before +link{dataSource.transformRequest} is called.
    //
    // @see DSRequest
    // @see operationBinding.requestProperties
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.dataTransport      (RPCTransport : RPCManager.defaultTransport : [IR])
    // Transport to use for all operations on this DataSource. Defaults to
    // +link{RPCManager.defaultTransport}.  This would typically only be set to
    // enable "scriptInclude" transport for contacting +link{DataSource.dataFormat,JSON} web
    // services hosted on servers other than the origin server.
    // <p>
    // When using the "scriptInclude" transport, be sure to set +link{dataSource.callbackParam} or
    // +link{operationBinding.callbackParam} to match the name of the query parameter name expected
    // by your JSON service provider.
    //
    // @see RPCTransport
    // @see dataSource.callbackParam
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<
    
    //> @attr dataSource.preventHTTPCaching (Boolean : true : IR)
    // If set, the DataSource will ensure that it never uses a cached HTTP response, even if the
    // server marks the response as cacheable.
    // <P>
    // Note that this does not disable caching at higher levels in the framework, for example, the
    // caching performed by +link{ResultSet}.
    // @serverDS allowed
    // @visibility external
    //<
    preventHTTPCaching:true,

    //> @type DSDataFormat
    // Indicates the format to be used for HTTP requests and responses when
    // fulfilling DSRequests (eg, when +link{DataSource.fetchData()} is called).
    // <P>
    // Note that +link{RPCManager.startQueue(),request queuing} is only available for
    // "iscServer" requests.
    //
    // @value "iscServer"
    // Make an HTTP request in a format recognized by the ISC server and expect ISC server
    // response format.  +link{group:serverDataIntegration,Server-side integration} can then be
    // used to connect to any kind of data store or web service.
    //
    // @value "xml"
    // Expect XML responses.  Request format depends on the setting for
    // +link{operationBinding.dataProtocol,protocol}.  This is the correct setting when
    // consuming RSS feeds, XML web services (whether SOAP, REST, XML-RPC or custom format),
    // and XML flat files directly from the browser.
    // <P>
    // Values for "date", "time" or "datetime" fields in responses should be specified in the
    // applicable <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema
    // date format</a>.
    // If no timezone is explicitly specified, dates / datetimes received by the client are 
    // assumed to be GMT. Note that "date" type fields represent logical dates and may omit
    // time information entirely, and "time" type fields may omit date information.
    // See +link{group:dateFormatAndStorage,Date and Time Format and storage} for more information
    // on how date values are serialized in requests sent to the server.
    //  
    // <P>
    // A DSResponse will be derived from the returned XML via the process described under
    // +link{dataSource.transformResponse()}.
    //
    // @value "json"
    // Expect response in JSON +externalLink{http://json.org,(Java Script Object Notation)}
    // format, ready to be eval()'d. Response should either be a naked object literal:
    // <pre>
    //     { "property":"value1", "property2" : "value2", ... }
    // </pre>
    // or a string that evals to return a valid response object:
    // <pre>
    //     var response = { "property":"value1", "property2" : "value2", ... }
    //     response;
    // </pre>
    // <P>
    // A DSResponse will be derived from the returned JSON via the process described under
    // +link{dataSource.transformResponse()}.
    // <P>
    // As with <code>"xml"</code> responses, values for "date" or "datetime" fields should be
    // specified as a String in 
    // <a target=_blank href="http://www.w3.org/TR/xmlschema-2/#dateTime">XML Schema date format</a>
    // and may include a timezone.  In the absence of a timezone they will be assumed to be GMT.
    // <P>
    // Request format depends on the setting for +link{operationBinding.dataProtocol,protocol}.  
    // See also +link{XJSONDataSource}.
    //
    // @value "custom"
    // SmartClient will not attempt to parse the response, instead,
    // +link{dataSource.transformResponse()} must be implemented.
    // <code>transformResponse</code> will receive the "data" parameter as a String, and must
    // parse this String into an Array of Objects, which should be set as
    // +link{dsResponse.data}.  Request format depends on the setting for
    // +link{operationBinding.dataProtocol,protocol}.
    // <P>
    // Note that, unlike either the "json" or "xml" settings of <code>dataFormat</code>, you
    // are responsible for ensuring that parsed values are the correct type, for example, using
    // the JavaScript built-ins <code>parseInt</code> and <code>parseFloat</code> on integer
    // and decimal values respectively, and using <code>new Date()</code> to construct valid
    // Dates.
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @visibility external
    // @serverDS allowed
    // @example simpleJSON
    //<

    //> @attr dataSource.serverType (DSServerType : "generic" : [IR])
    // For a DataSource stored in .xml format on the SmartClient server, indicates what server-side
    // connector to use to execute requests, that is, what happens if you call
    // dsRequest.execute() in server code.
    // 
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    
    //> @type DSServerType
    // Indicates what SmartClient Server will do with a DataSource request if you call
    // dsRequest.execute() in server code.
    // <P>
    // If you use a Java-based persistence layer not provided by SmartClient, such as
    // EJB or your own custom object model, you don't need to set
    // <code>dataSource.serverType</code> and should follow the
    // +link{group:serverDataIntegration,integration instructions}.
    //
    // @value "sql"
    // Use SmartClient's +link{group:sqlDataSource,built-in SQL connectors} to talk directly
    // to relational databases.
    // 
    // @value "hibernate"
    // Use Hibernate, either using a real mapped bean or by automatically generating a 
    // Hibernate configuration based on a SmartClient DataSource file 
    // (<i>dataSourceID</i>.ds.xml).  See +link{group:hibernateIntegration} for details.
    //
    // @value "jpa"
    // Use SmartClient's built-in JPA 2.0 connector.
    //
    // @value "jpa1"
    // Use SmartClient's built-in JPA 1.0 connector.
    //
    // @value "generic"
    // Requests will be delivered to the server and you are expected to write Java code to
    // create a valid response.  Throws an error if the server side method dsRequest.execute()
    // is called. This is appropriate if you intend an entirely custom implementation, and you
    // want an error thrown if there is an attempt to call an operation you have not
    // implemented.
    //
    // @value "projectFile"
    // Requests will be delivered to the server and processed as 
    // +link{group:fileSource,FileSource operations}, using directories or other DataSources
    // which you configure via +link{dataSource.projectFileKey} or +link{dataSource.projectFileLocations}
    //
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.tableName (String : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, what database table name to use.  The default is to use the DataSource ID
    // as the table name.
    // 
    // @see dataSource.quoteTableName
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.schema (String : null : [IR])
    // <b>This property only applies to the built-in SQL DataSource provided in Pro and better 
    // editions of SmartClient</b>
    // <p>
    // Defines the name of the schema we use to qualify the +link{tableName,tableName} in generated
    // SQL.  If you do not provide this property, table names will not be qualified in generated 
    // SQL, and thus the default schema will be used.  Support for multiple schemas (or schemata)
    // varies quite significantly across the supported databases, as does the meaning of the 
    // phrase "default schema".  In addition, some databases allow you to override the default 
    // schema in the JDBC connection URL, which is a preferable approach if all your tables are 
    // in the same (non-default) schema.
    // <p>
    // The following table provides information by product:
    // <p>
    // <table border="1" class="normal" width="90%">
    // <tr><td> Product</td><td width="90%"> Notes</td></tr>
    // <tr><td> DB2</td><td>
    // Arbitrarily named schemas are supported.  The default schema is named after the connecting
    // user, though this can be overridden by specifying the "currentSchema" property on the JDBC
    // connection URL</td></tr>
    // <tr><td> DB2 for iSeries</td><td>
    // Arbitrarily named schemas are supported.  "Schema" is synonymous with "library".  The 
    // default schema depends on the setting of the "naming" connection property.  When this is 
    // set to "sql", behavior is similar to other DB2 editions: the default schema is named after
    // the connecting user, unless overridden by specifying a library name in the JDBC connection 
    // URL.  When "naming" is set to "system", the schema of an unqualified table is resolved 
    // using a traditional search of the library list; the library list can be provided in the 
    // "libraries" property</td></tr>
    // <tr><td> Firebird</td><td>
    // Firebird does not support the concept of schema at all - all "schema objects" like tables 
    // and indexes belong directly to the database.  In addition, Firebird actively rejects 
    // qualified table names in queries as syntax errors; therefore, you should <b>not</b> set
    // the <code>schema</code> property for a DataSource that will be backed by a Firebird database
    // </td></tr>
    // <tr><td> HSQLDB</td><td>
    // Arbitrarily named schemas are supported.  The default schema is auto-created when the
    // database is created; by default it is called "PUBLIC", but can be renamed.  It is not 
    // possible to set the default schema in the JDBC connection URL</td></tr>
    // <tr><td> Informix</td><td>
    // Informix databases can be flagged as "ANSI mode" at creation time.  ANSI-mode databases 
    // behave similarly to DB2 for schema support: arbitrarily named schemas are supported, and
    // the default schema is the one named after the connected user.  Non-ANSI databases have no
    // real schema support at all. It is not possible to set the default schema in the JDBC 
    // connection URL with either type of database</td></tr>
    // <tr><td> Microsoft SQL Server</td><td>
    // Prior to SQL Server 2005, schema support is similar to Oracle: "schema" is synonymous with 
    // "owner".  As of SQL Server 2005, schema is supported as a separate concept, and a user's 
    // default schema can be configured (though it still defaults to a schema with the same name
    // as the user).  It is not possible to set the default schema in the JDBC connection URL</td></tr>
    // <tr><td> MySQL</td><td>
    // MySQL does not have a separate concept of "schema"; it treats the terms "schema" and 
    // "database" interchangeably.  In fact MySQL databases actually behave more like schemas, in 
    // that a connection to database X can refer to a table in database Y simply by qualifying 
    // the name in the query.  Also, because schema and database are the same concept in MySQL, 
    // overriding the "default schema" is done implicitly when you specify which database to 
    // connect to in your JDBC connection URL</td></tr>
    // <tr><td> Oracle</td><td>
    // Arbitrarily named schemas are not supported; in Oracle, "schema" is synonymous with "user",
    // so each valid user in the database is associated implicitly with a schema of the same name,
    // and there are no other schemas possible.  It is possible to refer to tables in another
    // user's schema (assuming you have the privileges to do so) by simply qualifying the table name.
    // The default schema is always implied by the connecting user and cannot be overridden.</td></tr>
    // <tr><td> Postgres</td><td>
    // Arbitrarily named schemas are supported.
    // Rather than the concept of a "default schema", Postgres supports the idea of a search path 
    // of schemas, whereby unqualified table references cause a search of the list of schemas in 
    // order, and the first schema in the path is the "current" one for creation purposes.  
    // Unfortunately, there is no way to specify this search path on the JDBC connection URL, so
    // the default schema comes from the user definition, ultimately defaulting to the default 
    // "public" schema</td></tr>
    // </table>
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.quoteTableName (Boolean : null : [IRA])
    // For SQL DataSources, tells the framework whether to surround the associated 
    // +link{dataSource.tableName,table name} with quotation marks whenever it appears in
    // generated queries.  This is only required if you have to connect to a table with a name
    // that is in breach of your database product's naming conventions.  For example, some 
    // products (eg, Oracle) internally convert all unquoted references to upper case, so if
    // you create a table called <code><b>myTest</b></code>, the database actually calls it 
    // <code><b>MYTEST</b></code> unless you quoted the name in the create command, like this:
    // <p>
    // <code><b>&nbsp;&nbsp;CREATE TABLE "myTest"</b></code>
    // <p>
    // If you <em>do</em> quote the name like this, or if you have to connect to a legacy table
    // that has been named in this way, then you must set this property to tell the SQL engine 
    // that it must quote any references to this table name (this requirement depends on the 
    // database in use - as noted below, some are not affected by this problem).  If you do 
    // not, you will see exceptions along the lines of "Table or view 'myTest' does not exist".
    // <p>
    // Note, other database products (eg, Postgres) convert unquoted names to lower case, which
    // leads to the same issues.  Still others (eg, SQL Server) are not case sensitive and are 
    // not affected by this issue.
    // <p>
    // Generally, we recommend that you avoid using this property unless you have a specific 
    // reason to do so.  It is preferable to avoid the issue altogether by simply not quoting 
    // table names at creation time, if you are able to do so.
    // 
    // @see dataSource.tableName
    // @see dataSource.quoteColumnNames
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    

    //> @attr dataSource.dbName (String : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, which database configuration to use.  Database configurations can be
    // created using the +link{group:adminConsole, Admin Console}.  If unset, the default
    // database configuration is used (which is also settable using the "Databases" tab).
    // 
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.configBean (String : null : [IRA])
    // For DataSources of +link{serverType,serverType} "hibernate", the name of a Spring 
    // bean to query to obtain Hibernate Configuration for this particular DataSource.  Note
    // that this is intended for DataSource-specific configuration overrides for unusual 
    // circumstances, such as a DataSource whose physical data store is a completely 
    // different database to that used by other DataSources.  See the 
    // +link{group:hibernateIntegration,Integration with Hibernate} article for more 
    // information
    // 
    // @group serverDataIntegration
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.quoteColumnNames (boolean : null : [IR])
    // If set, tells the SQL engine to quote column names in all generated DML and DDL 
    // statements for this dataSource.  This will ensure that queries generated against
    // tables that do not follow the database product's natural column-naming conventions 
    // will still work.
    // <p>
    // In general we recommend that you allow the database to use its natural naming scheme
    // when creating tables (put more simply, just do not quote column names in the 
    // <code>CREATE TABLE</code> statement); if you do this, you will not need to worry about 
    // quoting column names when querying.  However, if you are dealing with pre-existing 
    // tables, or do not have control over the database naming conventions used, this property
    // may become necessary.  This property may also be necessary if you are using field/column
    // names that clash with reserved words in the underlying database (these vary by database,
    // but a field called "date" or "timestamp" would have problems with most database products)
    // <p>
    // <b>Note:</b> Only applicable to dataSources of +link{attr:serverType,serverType} "sql".
    //
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.jsonPrefix (String : null : [IRA])
    // Allows you to specify an arbitrary prefix string to apply to all json format responses 
    // sent from the server to this application.
    // <P>
    // The inclusion of such a prefix ensures your code is not directly executable outside of
    // your application, as a preventative measure against
    // +externalLink{http://www.google.com/search?q=javascript+hijacking, javascript hijacking}.
    // <P>
    // Only applies to responses formatted as json objects. Does not apply to responses returned
    // via scriptInclude type transport.<br>
    // Note: If the prefix / suffix served by your backend is not a constant, you can use 
    // +link{operationBinding.dataFormat, dataFormat:"custom"} instead and explicitly parse
    // the prefix out as part of +link{dataSource.transformResponse(), transformResponse()}.
    //
    // @see operationBinding.dataFormat
    // @see operationBinding.dataTransport
    // @serverDS allowed
    // @visibility external
    //<
    
    //> @attr dataSource.jsonSuffix (String : null : [IRA])
    // Allows you to specify an arbitrary suffix string to apply to all json format responses 
    // sent from the server to this application.
    // <P>
    // The inclusion of such a suffix ensures your code is not directly executable outside of
    // your application, as a preventative measure against
    // +externalLink{http://www.google.com/search?q=javascript+hijacking, javascript hijacking}.
    // <P>
    // Only applies to responses formatted as json objects. Does not apply to responses returned
    // via scriptInclude type transport.
    //
    // @see operationBinding.dataFormat
    // @see operationBinding.dataTransport
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.fields (Array of DataSourceField : null : [IR])
    // The list of fields that compose records from this DataSource.
    // <P>
    // Each DataSource field can have type, user-visible title, validators, and other metadata
    // attached.
    // <smartclient>
    // <p>
    // After a DataSource has been +link{class.create,created}, access the list of fields via
    // +link{dataSource.getFieldNames()} and access individual fields via
    // +link{dataSource.getField()}.
    // </smartclient>
    //
    // @group fields
    // @see class:DataSourceField
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.inheritsFrom (DataSource ID : null : IR)
    // ID of another DataSource this DataSource inherits its +link{fields} from.
    // <P>
    // Local fields (fields defined in this DataSource) are added to inherited fields 
    // to form the full set of fields.  Fields with the same name are merged in the same way
    // that +link{DataBoundComponent.fields,databound component fields} are merged with
    // DataSource fields.
    // <P>
    // The default order of the combined fields is new local fields first (including any fields
    // present in the parent DataSource which the local DataSource re-declares), then parent
    // fields.  You can set +link{useParentFieldOrder} to instead use the parent's field
    // order, with new local fields appearing last.  You can set +link{showLocalFieldsOnly} to
    // have all non-local fields hidden.
    // <P>
    // Note that <b>only fields are inherited</b> - other properties such as dataURL and
    // dataFormat are not.  You can use ordinary inheritance, that is, creating a subclass of
    // DataSource, in order to share properties such as dataURL across a series of DataSources
    // that also inherit fields from each other via <code>inheritsFrom</code>.
    // <P>
    // This feature can be used for:
    // <ul>
    // <li>creating a customized view (eg, only certain fields shown) which will be used by
    // multiple +link{DataBoundComponent,databound components}.
    // <li>adding presentation-specific attributes to metadata that has been automatically
    // derived from +link{XMLTools.loadXMLSchema,XML Schema} or other metadata formats
    // <li>modeling object subclassing and extension in server-side code and storage systems
    // <li>modeling relational database joins, and the equivalents in other systems
    // <li>creating hooks for others to customize your application in a maintainable way.  For
    // example, if you have a dataSource "employee", you can create a dataSource
    // "customizedEmployee" which inherits from "employee" but does not initially define any
    // fields, and bind all +link{DataBoundComponent,databound components} to
    // "customizedEmployee".  Customizations of fields (including appearance changes, field
    // order, new fields, hiding of fields, and custom validation rules) can be added to
    // "customizedEmployee", so that they are kept separately from the original field data and
    // have the best possible chance of working with future versions of the "employee"
    // dataSource.
    // </ul>
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    // @example schemaChaining
    //<

    //> @attr dataSource.auditedDataSourceID (String : varies : [IR])
    // For audit DataSources, this required property specifies the ID of the
    // +link{DataSource.audit,audited} DataSource.  Automatically populated for
    // +link{generateAuditDS,auto-generated} audit DataSources.
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.generateAuditDS (boolean : true : [IR])
    // For an +link{DataSource.audit,audited} DataSource, controls whether the Framework will
    // attempt to auto-generate the audit DataSource.  Note that this property is independent of
    // +link{auditDataSourceID} so that, by default, even when the audit DataSource is given
    // a non-default ID, the Framework will still attempt to auto-generate it.
    // @serverDS only
    // @visibility external
    //<

    //> @type DSInheritanceMode
    // For DataSources of type "sql" and "hibernate", specifies the kind of inheritance to use when a dataSource
    // specifies +link{dataSource.inheritsFrom,inheritsFrom}.
    //
    // @value "full"
    // Inherit fields by copying them onto the inheriting DataSource's underlying table.  When we 
    // import a DataSource with this inheritanceMode, we create actual columns for inherited fields
    //  on the table we create.  With this inheritanceMode, inherited fields are updatable.
    //
    // @value "none"
    // Do not physically inherit fields onto the inheriting DataSource's SQL table.  Columns will
    // not be created for inherited fields on import, and all generated SQL operations will exclude
    // inherited fields.  However, those fields are still part of the DataSource's schema so you
    // can, for example, write +link{group:customQuerying,custom SQL} that returns values for 
    // the inherited fields, and they will be delivered to the client.
    // 
    // @group fields
    // @serverDS only
    // @visibility external
    //<
    
    
    
    
    //> @attr dataSource.inheritanceMode (DSInheritanceMode : "full" : IR)
    // For dataSources of +link{serverType,serverType} "sql" and "hibernate", specifies the inheritance 
    // mode to use.  This property has no effect for any other type of DataSource.
    //
    // @see dataSource.inheritsFrom
    // @group fields
    // @serverDS only
    // @visibility external
    //<


    //> @attr dataSource.sequenceMode         (SequenceMode : "native" : [IR])
    // For fields of +link{dataSourceField.type,type} "sequence" in a dataSource of 
    // +link{DataSource.serverType,serverType} "sql", indicates the 
    // +link{type:SequenceMode} to use.  This property has no effect for fields or dataSources of 
    // other types.
    // <p>
    // You can set a default sequenceMode for all DataSources of a given database type by setting
    // property "sql.{database_type}.default.sequence.mode" in <code>server.properties</code>.  
    // You set a global default sequenceMode that applies to all database types by setting property
    // "sql.default.sequence.mode".  For example:<pre>
    //   sql.mysql.default.sequence.mode: jdbcDriver
    // </pre>
    // <P>
    // 
    // @serverDS only
    // @visibility external
    //<

    //> @type SequenceMode
    // The possible types of sequence handling SmartClient Server can apply.  This refers to the
    // technique used to obtain the primary keys of the most recent insert, which the product 
    // uses to enable automatic cache synchronization (updating client-side components bound to a 
    // dataSource to reflect updates to that dataSource).  Only applicable to
    // +link{class:DataSourceField,fields} of +link{type:FieldType,type} "sequence".
    // <P>
    // @value "jdbcDriver" Use the JDBC 3.0 API "getGeneratedKeys()" to get the most recent 
    //                     sequence value.  Obviously, this is only an option for JDBC 3.0+ drivers
    // @value "native"     Use a database-specific native technique to obtain the most recent
    //                     sequence value.  The actual technique used varies widely depending on
    //                     the vagaries of the underlying database (and sometimes the vagaries of
    //                     particular releases of a database product)
    // @value "none"       No automatic attempt is made to retrieve the most recent sequence value.
    //                     You are expected to handle this by providing a  
    //                     +link{operationBinding.cacheSyncOperation,cacheSyncOperation} that is 
    //                     able to return the entire row without needing generated PK values for
    //                     context. For example, a query that uses <code>MAX(pk)</code> would be
    //                     capable of this.  To give a more complex example, say you have a 
    //                     sequence value that is retrieved from a legacy system: you could store 
    //                     that sequence value in the HTTP session and then have your custom 
    //                     <code>cacheSyncOperation</code> reference that session attribute in 
    //                     its <code>WHERE</code> clause.  Also note that cacheSyncOperations, 
    //                     like any other +link{class:OperationBinding,DataSource operation}, 
    //                     can be +link{operationBinding.serverObject,written in Java} or any 
    //                     +link{operationBinding.script,JSR223-compliant scripting language} -
    //                     you do not have to use SQL 
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.useFlatFields (Boolean : null : IR)
    // Like +link{dataBoundComponent.useFlatFields}, but applies to all DataBound components
    // that bind to this DataSource.
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.showLocalFieldsOnly (boolean : null : IR)
    // For a DataSource that inherits +link{fields} from another DataSource 
    // (via +link{inheritsFrom}), indicates that only the fields listed in this DataSource
    // should be shown.  All other inherited parent fields will be marked "hidden:true".
    //
    // @group fields
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.useParentFieldOrder (boolean : null : IR)
    // For a DataSource that inherits +link{fields} from another DataSource 
    // (via +link{inheritsFrom}), indicates that the parent's field order should be used
    // instead of the order of the fields as declared in this DataSource.  New fields, if any,
    // are placed at the end.
    // 
    // @group fields
    // @serverDS allowed
    // @visibility external
    // @example schemaChaining
    //<

    //> @attr dataSource.dropExtraFields     (boolean : null : IR)
    // Indicates that for server responses, for any data being interpreted as DataSource records, 
    // only data that
    // corresponds to declared fields should be retained; any extra fields should be discarded.
    // <P>
    // For +link{DataSource.dataFormat,JSON} data, this means extra properties in selected
    // objects are dropped.
    // <P>
    // By default, for DMI DSResponses, DSResponse.data is filtered on the server to just
    // the set of fields defined on the DataSource.  This type of filtering can also be enabled
    // for non-DMI DSResponses (see the overview in +link{group:dmiOverview,DMI}).  Setting this property to
    // <code>false</code> disables this filtering for this DataSource only.  This setting
    // overrides the configuration in +link{group:server_properties,server.properties}.  This setting can
    // be overridden by +link{ServerObject.dropExtraFields}.
    // 
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.sendExtraFields     (Boolean : true : IR)
    // Analogous to +link{dataSource.dropExtraFields}, for data sent to the server.  Setting this
    // attribute to false ensures that for any records in the data object, only fields that
    // correspond to declared dataSource fields will be present on the dsRequest data object passed
    // to +link{dataSource.transformRequest()} and ultimately sent to the server.
    // 
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility external
    //<
    sendExtraFields:true,
    
    //> @attr dataSource.autoDeriveSchema (boolean : null : IR)
    // This property allows you to specify that your DataSource's schema (field definitions) should
    // be automatically derived from some kind of metadata.  This causes SmartClient to create 
    // a special super-DataSource, which is used purely as a source of default schema for this 
    // DataSource; this is arranged by causing the autoDerived DataSource to automatically 
    // +link{inheritsFrom,inherit from} the special super-DataSource.  This allows you to 
    // auto-derive schema from existing metadata, whilst still being able to override any or all
    // of it as required.<p>
    // This property has a different implementation depending upon the 
    // +link{dataSource.serverType,serverType} of the DataSource:<ul>
    // <li>For a DataSource with serverType: "sql", automatically derive the dataSource's schema 
    // from the Spring bean or Java class specified in +link{schemaBean,schemaBean}.  If 
    // <code>schemaBean</code> is not specified, derive the schema from the columns in the SQL 
    // table specified in +link{tableName,tableName}.  More information on SQL DataSources 
    // is +link{group:sqlDataSource,here}</li>  
    // <li>For a DataSource with serverType: "hibernate", automatically derive the dataSource's
    // schema from the Spring bean, Hibernate mapping or Java class named in the 
    // +link{schemaBean,schemaBean} property.  If no such thing exists, derive the schema from
    // the Hibernate mapping or Java class specified in the +link{beanClassName,beanClassName}
    // property (this allows you to specify schema and mapping separately, in the unusual 
    // circumstance that you have a need to do so).  Note that the "mappings" referred to here
    // can mean either <code>.hbm.xml</code> files or annotated classes; both are supported.
    // If neither of these is successful, derive the schema from the underlying SQL table 
    // specified in +link{tableName,tableName}.  More information on Hibernate DataSources is
    // +link{group:hibernateIntegration,here}</li>  
    // <li>For a DataSource with serverType: "jpa1" or "jpa", automatically derive the 
    // dataSource's schema from the annotated JPA class named in the +link{schemaBean,schemaBean} 
    // property.  If the schemaBean property is not defined, derive the schema from the 
    // annotated JPA class named in the +link{beanClassName,beanClassName} property (as with 
    // Hibernate, this allows you to specify schema and mapping separately if you need to do 
    // so).  JPA DataSource generation relies on annotations (the orm.xml mapping file is not 
    // supported).  More information on JPA DataSources is +link{group:jpaIntegration,here}</li>  
    // <li>For other DataSource types, attempt to find a Spring bean with the name specified in
    // the +link{schemaBean,schemaBean} property.  If no such bean is found (or Spring is not 
    // present), attempt to instantiate an object whose fully-qualified class name is the value
    // in the <code>schemaBean</code> property.  If one of these approaches succeeds, we derive
    // the schema from the discovered object (by treating it as a Java Bean and assuming that 
    // each one of its getters corresponds to a like-named field in the DataSource).  More 
    // information on custom DataSource implementations is +link{group:writeCustomDataSource,here}.</li>
    // </ul>
    // Note that when dataSource schema is derived by introspecting the Java class or Spring bean the
    // order of derived fields is non-deterministic, so you may find that it changes if you switch
    // JVMs, Java compilers or other parts of your Java toolchain. This means that you need to include
    // the order of all fields that are ultimately client-visible.  Otherwise, if you bind a ListGrid
    // or DynamicForm to this DataSource without specifying the order of fields in that grid or form,
    // you could get fields in a different order on each application restart.
    // <h4>Field types</h4>
    // The following table shows how SQL types are derived into 
    // +link{type:FieldType,DataSource types} when we use an SQL table as a source of metadata
    // for a SQL or Hibernate DataSource:
    // <table border="1" class="normal">
    // <tr><th>SQL type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>CHAR, VARCHAR, LONGVARCHAR, TEXT, CLOB</td><td>text</td></tr>
    // <tr><td>BIT, TINYINT, SMALLINT, INTEGER, BIGINT, DECIMAL<sup>*</sup>, NUMBER<sup>**</sup></td><td>integer</td></tr>
    // <tr><td>REAL, FLOAT, DOUBLE, DECIMAL<sup>*</sup>, NUMBER<sup>**</sup></td><td>float</td></tr>
    // <tr><td>DATE</td><td>date</td></tr>
    // <tr><td>TIME</td><td>time</td></tr>
    // <tr><td>TIMESTAMP</td><td>datetime</td></tr>
    // <tr><td>BLOB, BINARY, VARBINARY, LONGVARBINARY</td><td>binary</td></tr>
    // </table>
    // <sup>*</sup>For DECIMAL types, we inspect the "DECIMAL_DIGITS" attribute of the JDBC 
    // metadata and designate the field type "integer" if that attribute is 0, or "float" if
    // it is some other value.<br>
    // <sup>**</sup>NUMBER is an Oracle-only type that appears in the JDBC metadata as DECIMAL
    // and is handled exactly the same way as DECIMAL
    // <p>
    // The following table shows how Java types are derived into DataSource types when we use
    // an unannotated Java class (Spring bean, Hibernate mapping or POJO) as a source of 
    // metadata for a SQL, Hibernate or custom DataSource:
    // <table border="1" class="normal">
    // <tr><th>Java type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>boolean, Boolean</td><td>boolean</td></tr>
    // <tr><td>char, Character, String, Reader</td><td>text</td></tr>
    // <tr><td>byte, short, int, long, Byte, Short, Integer, Long, BigInteger</td><td>integer</td></tr>
    // <tr><td>float, double, Float, Double, BigDecimal</td><td>float</td></tr>
    // <tr><td>Enum</td><td>enum (see discussion below)</td></tr>
    // <tr><td>InputStream</td><td>binary</td></tr>
    // <tr><td>java.sql.Date, java.util.Date, java.util.Calendar</td><td>date</td></tr>
    // <tr><td>java.sql.Time</td><td>time</td></tr>
    // <tr><td>java.sql.Timestamp</td><td>datetime</td></tr>
    // </table>
    // <p>
    // Finally, this table shows how Java types are derived into DataSource types when we use an 
    // annotated class as a source of metadata.  Note annotated classes are necessary for JPA
    // DataSources, but you can choose to use them for other types of DataSource as well.  
    // For Hibernate DataSources, this is very worthwhile because Hibernate will also make use
    // of the annotations as config, meaning you don't need to specify <code>.hbm.xml</code> 
    // files.  For SQL and custom DataSources, there is no benefit at the persistence level, 
    // but it may still be worthwhile because the use of an annotated class gives us better 
    // metadata and allows us to generate a better, closer-fitting autoDerive DataSource than 
    // we can from examination of SQL schema or plain Java Beans:
    // <table border="1" class="normal">
    // <tr><th>Java type</th><th>+link{attr:DataSourceField.type,DataSource type}</th></tr>
    // <tr><td>boolean, Boolean</td><td>boolean</td></tr>
    // <tr><td>char, Character, String, Reader</td><td>text</td></tr>
    // <tr><td>byte, short, int, long, Byte, Short, Integer, Long, BigInteger</td><td>integer</td></tr>
    // <tr><td>float, double, Float, Double, BigDecimal</td><td>float</td></tr>
    // <tr><td>InputStream</td><td>binary</td></tr>
    // <tr><td>java.util.Date (with Temporal set to DATE), java.sql.Date</td><td>date</td></tr>
    // <tr><td>java.util.Date (with Temporal set to TIME), java.sql.Time</td><td>time</td></tr>
    // <tr><td>java.util.Date (with Temporal set to TIMESTAMP), java.util.Calendar, java.sql.Timestamp</td><td>datetime</td></tr>
    // <tr><td>Enum (with Enumerated set to STRING)</td><td>enum (see discussion below)</td></tr>
    // <tr><td>Enum (with Enumerated set to ORDINAL)</td><td>intEnum (see discussion below)</td></tr>
    // <tr><td>Field with Lob annotation</td><td>binary</td></tr>
    // <tr><td>Field with GeneratedValue annotation</td><td>sequence, if the field is an integer type (see discussion below)</td></tr>
    // </table>
    // <p>
    // <h4>Primary keys, sequences and identity columns</h4>
    // We attempt to derive information about primary keys from the metadata we have.
    // <p>
    // If the metadata source is an SQL table:
    // <ul>
    // <li>If the table does not have a native primary key constraint, no attempt is made to 
    //     identify primary key fields.  Otherwise:
    // <li>The column or columns that make up the table's native primary key constraint are 
    //     identified using the JDBC <code>DatabaseMetaData.getPrimaryKeys()</code> API</li>
    // <li>Each DataSource field that corresponds to one of these native primary key columns 
    //     is marked <code>primaryKey: true</code></li>
    // <li>For each of these columns, the metadata returned by 
    //     <code>DatabaseMetaData.getColumns()</code> is inspected.  If the metadata includes
    //     <code>IS_AUTOINCREMENT=YES</code>, we mark the corresponding field as 
    //     <code>type="sequence"</code>.  This information should be reliably provided by 
    //     databases that implement "auto-increment" or "identity" column types, such as MySQL
    //     or Microsoft SQL Server</li>
    // <li>If the previous step does not identify a column as a sequence, we inspect the 
    //     <code>ResultSetMetaData</code> obtained by running a dummy query on the table.  If 
    //     the <code>isAutoIncrement()</code> API returns true for that column, we mark the 
    //     corresponding field as <code>type="sequence"</code></li>
    // <li>If the previous steps have not identified the column as a sequence, we check the 
    //     <code>TYPE_NAME</code> in the column metadata.  If it is "serial", this means the 
    //     column is a PostgreSQL "serial" or "serial8" type column.  Postgres does not 
    //     transparently implement auto-increment columns, but it does provide this serial 
    //     type, which causes the column to be implicitly bound to an underlying sequence.  So
    //     this type causes us to mark the field <code>type="sequence"</code>, and we also set
    //     +link{dataSourceField.implicitSequence,implicitSequence} true</li>
    // <li>If the previous steps have not identified the column as a sequence, we check the 
    //     <code>COLUMN_DEF</code> in the column metadata.  If this contains the token "$$ISEQ"
    //     and ends with "NEXTVAL", this means the column is an Oracle "GENERATED AS IDENTITY" 
    //     column.  This type of column was introduced in Oracle 12c and is conceptually 
    //     exactly the same thing as the Postgres "serial" column described above.  We treat 
    //     it the same way: mark it <code>type="sequence"</code> and 
    //     <code>implicitSequence="true"</code></li>
    // <li>If the previous steps have not identified the column as a sequence, then you may
    //     be using a pure sequence database, such as an Oracle version earlier than 12c, or 
    //     you may be using a database where both sequences and identity columns are available
    //     (Oracle, Postgres, DB2), and a sequence is being used either by design or because 
    //     the table was created before the database product supported identity columns.  In 
    //     this case, we cannot determine if the column should be a sequence or not.  However,
    //     in many applications, the fact that the column is an integer and is a primary key
    //     would imply that it is also a sequence.  Therefore, if the column is an integer and
    //     the <code>server.properties</code> flag <code>auto.derive.integer.pk.always.sequence</code>
    //     is true, we mark the field as <code>type="sequence"</code></li>
    // <li>If, after all this, SmartClient ends up incorrectly marking a primary key field as 
    //     a sequence (or vice versa), you can always override it on a per-field basis by 
    //     simply redeclaring the field with the correct type in your <code>.ds.xml</code> 
    //     file:<pre>
    //  &lt;DataSource serverType="sql" tableName="myTable" autoDeriveSchema="true"&gt;
    //    &lt;fields&gt;
    //      &lt;!-- This field was incorrectly marked as a sequence --&gt;
    //      &lt;field name="notASeq" type="integer" /&gt;
    //      &lt;!-- This field was incorrectly marked as an integer when it should be a sequence --&gt;
    //      &lt;field name="isASeq" type="sequence" /&gt;
    //    &lt;/fields&gt;
    //  &lt;/DataSource&gt;</pre></li>
    // </ul>
    // <p>  
    // If the metadata source is Hibernate mappings described in a <code>.hbm.xml</code> file:
    // <ul>
    // <li>The first field we encounter that is described in the mapping with an &lt;id&gt; tag
    //     is marked as a primaryKey</li>
    // <li>If that field is marked as being generated, we set its type to "sequence"</li>
    // </ul>
    // <p>  
    // If the metadata source is an annotated object (whether JPA, Hibernate or just an 
    // annotated POJO):
    // <ul>
    // <li>Any field with an <code>@Id</code> annotation is is marked as a primaryKey (this 
    //     differs from the Hibernate <code>.hbm.xml</code> file case because that is specific 
    //     to Hibernate, which does support composite keys, but not by specifying multiple 
    //     &lt;id&gt; tags.  Annotations are supported, via annotated POJOs, for any kind of 
    //     persistence strategy, so multiple <code>@Id</code> fields are perfectly valid)</li>
    // <li>Any field with a <code>@GeneratedValue</code> annotation is either marked as 
    //     <code>type="sequence"</code> (if it is an integer type) or as 
    //     <code>+link{dataSourceField.autoGenerated,autoGenerated}="true"</code> (for other 
    //     field types)</li>
    // </ul>
    // Finally, if the metadata is a plain, unannotated Java object, no attempt is made to
    // derive primary key fields.
    // <h4>enums and valueMaps</h4>
    // When we come across Java <code>Enum</code> properties in plain or annotated classes, 
    // as well as setting the field type as noted in the above tables, we also generate a 
    // valueMap for the field, based on the <code>Enum</code> members.  
    // <p>
    // For cases where we generate a field of SmartClient type "enum" (see the above tables), 
    // the keys of the valueMap are the result of calling <code>name()</code> on each member
    // of the underlying Java Enum (in other words, its value exactly as declared in its 
    // enum declaration).  For cases where we generate a field of SmartClient type "intEnum",
    // the keys of the valueMap are strings representing the ordinal number of each member 
    // in the Java Enum - "0", "1", etc. Note that this behavior will be overriden by 
    // +link{attr:DataSource.enumTranslateStrategy,DataSource.enumTranslateStrategy} if both are set.
    // <p>
    // In both of these case, the display values generated for the valueMap are the result 
    // of calling <code>toString()</code> on each Enum member.  If that gives the same 
    // value as calling <code>name()</code>, the value is passed through 
    // <code>DataTools.deriveTitleFromName()</code>, which applies the same processing rules
    // as +link{classMethod:DataSource.getAutoTitle()} to derive a more user-friendly display value.
    // <h4>Further notes</h4>
    // <code>schemaBean</code> implies <code>autoDeriveSchema</code>, because it has no other 
    // purpose than to name the bean to use for auto-derived schema.  Thus, if you specify
    // <code>schemaBean</code> you do not need to specify <code>autoDeriveSchema</code> as well
    // (though it does no harm to do so).  However, <code>tableName</code> and 
    // <code>beanClassName</code> can be validly specified without implying 
    // <code>autoDeriveSchema</code>, so in those cases you must explicitly specify 
    // <code>autoDeriveSchema</code>.
    // <p>
    // The underlying super-DataSource is cached in server memory, so that it does 
    // not have to be derived and created each time you need it.  However, the cache manager 
    // will automatically refresh the cached copy if it detects that the deriving DataSource 
    // has changed.  Thus, if you change the metadata your DataSource is deriving (if, for 
    // example, you add a column to a table), all you need to do is touch the 
    // <code>.ds.xml</code> file (ie, update its last changed timestamp - you don't actually
    // have to change it) and the cached copy will be refreshed next time it is needed.
    // <p>
    // When autoDeriveSchema is set, SQLDataSource will automatically discover foreignKeys and
    // deliver table and column name information to the client in hashed form so that two
    // DataSources that are linked by native SQL foreign keys will automatically discover each
    // other if loaded into the same application, and set 
    // +link{dataSourceField.foreignKey,foreignKey} automatically.  Because the table and column 
    // names are delivered as cryptohashes, there is no information leakage, but regardless,
    // the feature can be disabled via setting <code>datasource.autoLinkFKs</code> to false in
    // +link{group:server_properties,server.properties}.  This hashed linkage information is
    // delivered to the client in properties +link{dataSource.tableCode} and
    // +link{dataSourceField.fkTableCode}/+link{dataSourceField.fkColumnCode,fkColumnCode}
    // 
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.schemaBean (String : null : IR)
    // For DataSources that specify +link{autoDeriveSchema}, this property indicates the name
    // of the Spring bean, Hibernate mapping or fully-qualified Java class to use as parent 
    // schema.
    //
    // @see autoDeriveSchema
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.idClassName (String : null : IR)
    // For JPA and Hibernate DataSources this property indicates, that data source has composite primary key and
    // specifies fully-qualified Java class:<ul>
    // <li>with <b><code>@EmbeddedId</code></b> you have to specify class name of declared id</li>
    // <li>with <b><code>@IdClass</code></b> you have to specify class specified in annotation declaration</li></ul>
    //
    // @group fields
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.patternSingleWildcard (String | Array of String : ["?","%"] : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator}, 
    // character that matches any single character.
    // <p>
    // Pass multiple strings to provide multiple alternative wildcards.
    // @visibility external
    //<
    patternSingleWildcard: ["?","%"],

    //> @attr dataSource.patternMultiWildcard (String | Array of String : "*" : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator}, 
    // character that matches a series of one or more characters.
    // <p>
    // Pass multiple strings to provide multiple alternative wildcards.
    // @visibility external
    //<
    patternMultiWildcard: "*",

    //> @attr dataSource.patternEscapeChar (String : "\" : IR)
    // When using the +link{group:patternOperators,pattern operators} +link{type:OperatorId,search operator}, 
    // character that escapes the +link{patternSingleWildcard} or +link{patternMultiWildcard} if placed before 
    // it, so that it is treated as a literal character.
    // @visibility external
    //<
    patternEscapeChar: "\\",

    //> @groupDef patternOperators
    // The +link{type:OperatorId,search operators}  
    // use patterns like "foo*txt" to match text values.  The patterns are similar to the patterns you use to
    // match names of files in a command-line interface, or to the pattern allowed for the SQL
    // "LIKE" operator.
    // The supported search operators are:
    //  <ul>
    //      <li>"matchesPattern" Basic GLOB matching using wildcards.</li>
    //      <li>"iMatchesPattern" Basic GLOB matching using wildcards (case insensitive).</li>
    //      <li>"containsPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it contains the pattern. </li>
    //      <li>"startsWithPattern" GLOB mathcing using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.</li>
    //      <li>"endsWithPattern" GLOB mathcing using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.</li>
    //      <li>"iContainsPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it contains the pattern. Matching is case insensitive. </li>
    //      <li>"iStartsWithPattern" GLOB matching using wildcards. Value is considered to meet the
    //        criterion if it starts with the pattern.  Matching is case insensitive.</li>
    //      <li>"iEndsWithPattern" GLOB matching using wildcards.Value is considered to meet the
    //        criterion if it ends with the pattern. Matching is case insensitive.</li>
    //  </ul>
    //
    // See +link{DataSource.translatePatternOperators} for more information on available patterns)
    //
    // @visibility external
    //< 

    //> @attr dataSource.translatePatternOperators (boolean : false : IR)
    // +link{type:OperatorId,Search operators} like "matchesPattern" use patterns like
    // "foo*txt" to match text values.  The patterns are similar to the patterns you use to
    // match names of files in a command-line interface, or to the pattern allowed for the SQL
    // "LIKE" operator.
    // <p>
    // <code>translatePatternOperators</code> controls whether these pattern operators should
    // be translated to a nested series of "startsWith"/"endsWidth"/"contains" operators before
    // being sent to the server.  This allows a server that only implements simple operators
    // like "startsWith" to support pattern operators such as "matchesPattern" and
    // "containsPattern", but with caveats:
    //    <ul>
    //        <li> single-character wildcards are not supported
    //        <li> multiple wildcards are not truly order-dependent, for example *1*2*3* will
    //             match 1,2,3 as interior characters in any order.  
    //        <li> may be less efficient than a direct server-side implementation that is able to
    //             translate the pattern directly to the underlying storage engine.
    //    </ul>
    // <p>
    // Note that since "containsPattern" is essentially equivalent to "matchesPattern" but with
    // "*" wildcards at the beginning and end of every pattern, the second limitation (pattern
    // not really order dependent) may be fairly obvious to users when using this feature.  For
    // example, "m*t" will match "we meet" and "we teem".
    // <p>
    // The following are examples of how patterns are translated to simpler operators.  Note
    // that the case sensitive version of the operator is referred to below, but of course
    // "iMatchesPattern" and "iContainsPattern" will be translated to case-insensitive versions
    // of these operators, such as "iStartsWith".
    // <p>
    // *foo (endsWith)<br>
    // foo* (startsWith)<br>
    // *foo* (contains)<br>
    // *foo*bar (contains and endsWith)<br>
    // foo*bar* (startsWith and contains)<br>
    // foo*bar (startsWith and endsWith)<br>
    // *foo*bar* (multiple contains)
    // <p>
    // Also supported: one startsWith, multiple contains, one endsWith.
    // @visibility external
    //<
    translatePatternOperators: false,

    // XML
    // ---------------------------------------------------------------------------------------
    
    //> @attr dataSource.xmlNamespaces (Object : See below : IR)
    // Sets the XML namespace prefixes available for XPaths on a DataSource-wide basied.  See
    // +link{operationBinding.xmlNamespaces} for details.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.serviceNamespace (URN : null : IR)
    // For an XML DataSource, URN of the WebService to use to invoke operations.  This URN
    // comes from the "targetNamespace" attribute of the &lt;wsdl:definitions&gt; element in a
    // WSDL (Web Service Description Language) document, and serves as the unique identifier of
    // the service.
    // <P>
    // Having loaded a WebService using +link{XMLTools.loadWSDL()}, setting
    // <code>serviceNamespace</code> combined with specifying 
    // +link{class:OperationBinding,operationBindings}
    // that set +link{attr:operationBinding.wsOperation} will cause a DataSource to invoke web
    // service operations to fulfill DataSource requests (+link{class:DSRequest,DSRequests}).
    // <P>
    // Setting <code>serviceNamespace</code> also defaults
    // +link{DataSource.dataURL,dataURL} to the service's location,
    // +link{DataSource.dataFormat,dataFormat} to "xml" and
    // +link{operationBinding.dataProtocol,dataProtocol} to "soap".
    //
    // @group wsdlBinding
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.schemaNamespace (URN : null : R)
    // For a DataSource derived from WSDL or XML schema, the XML namespace this schema belongs
    // to.  This is a read-only attribute automatically present on DataSources returned from
    // +link{schemaSet.getSchema()} and +link{webService.getSchema()}.
    //
    // @group wsdlBinding
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    //> @attr dataSource.recordXPath          (XPathExpression : null : [IR])
    // See +link{attr:operationBinding.recordXPath}.  <code>recordXPath</code> can be specified
    // directly on the DataSource for a simple read-only DataSource only capable of "fetch"
    // operations.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    // @example xmlDataSource
    // @example jsonXPath
    //<

    //> @attr dataSource.dataURL              (URL : null : [IR])
    // Default URL to contact to fulfill all DSRequests.  Can also be set on a
    // per-operationType basis via +link{attr:operationBinding.dataURL}.
    // <P>
    // NOTE: Best practice is to use the same <code>dataURL</code> for all DataSources which
    // fulfill DSRequests via the server-side RPCManager API.  Otherwise, cross-DataSource
    // +link{RPCManager.startQueue(),operation queuing} will not be possible.
    //
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    // @example jsonDataSource
    //<

    //> @attr dataSource.tagName             (String : null : IRA)
    // Tag name to use when serializing to XML.  If unspecified, the <code>dataSource.ID</code>
    // will be used.
    // @group clientDataIntegration
    // @serverDS allowed
    // @visibility xmlBinding
    //<

    
    //> @attr dataSource.useOfflineStorage (boolean : null : IRW)
    // Whether we store server responses for this DataSource into 
    // +link{class:Offline,browser-based offline storage}, and then use those stored responses
    // at a later time if we are offline (ie, the application cannot connect to the server).  
    // Note that by default we do NOT use offline storage for a dataSource.
    // @serverDS allowed
    // @group offlineGroup
    // @visibility external
    //<



// whether to transform XML responses to JS automatically, such that the client-side DSResponse
// is a JS object (whether the transform was performed on client or server is intended to be an
// implementation detail).
// At the moment 2005.7.5, some components can work directly with XML objects (eg read-only,
// selectable ListGrid), some can't.  Server XML->JS transform will always speed up the client.
// Aside from features that don't yet work with XML object, client XML->JS transform is a
// tradeoff between initial load vs later access time.
transformResponseToJS:true,

// whether this DataSource can queue requests to be submitted as a batch
supportsRequestQueuing: true,

// start value for sequence fields
firstGeneratedSequenceValue: 0,

    // Client Only DataSources
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.clientOnly     (Boolean : false : [IR])
    // A clientOnly DataSource simulates the behavior of a remote data store by manipulating a
    // static dataset in memory as +link{DSRequest,DSRequests} are executed on it.  Any changes
    // are lost when the user reloads the page or navigates away.
    // <P>
    // A clientOnly DataSource will return responses asynchronously, just as a DataSource
    // accessing remote data does.  This allows a clientOnly DataSource to be used as a
    // temporary placeholder while a real DataSource is being implemented - if a clientOnly
    // DataSource is replaced by a DataSource that accesses a remote data store, UI code for
    // components that used the clientOnly DataSource will not need be changed.
    // <P>
    // A clientOnly DataSource can also be used as a shared cache of modifiable data across
    // multiple UI components when immediate saving is not desirable.  In this case, several
    // components may interact with a clientOnly DataSource and get the benefit of
    // +link{ResultSet} behaviors such as automatic cache sync and in-browser data filtering
    // and sorting.  When it's finally time to save, +link{dataSource.cacheData} can be
    // inspected for changes and data can be saved to the original DataSource via
    // +link{addData()}, +link{updateData()} and +link{removeData()}, possibly in a
    // +link{rpcManager.startQueue,transactional queue}.  Note that
    // +link{DataSource.getClientOnlyDataSource()} lets you easily obtain a
    // <code>clientOnly</code> DataSource representing a subset of the data available from a
    // normal DataSource.  
    // <P>
    // See also +link{cacheAllData} - a <code>cacheAllData</code> behaves like a write-through
    // cache, performing fetch and filter operations locally while still performing remote save
    // operations immediately.
    // <P>
    // ClientOnly DataSources can be populated programmatically via +link{cacheData} - see
    // +link{group:clientOnlyDataSources,this discussion} for other ways to populate a
    // client-only DataSource with data.
    //
    // @group clientOnlyDataSources
    // @serverDS allowed
    // @visibility external
    // @example localDataSource
    //<
	//clientOnly: false,

    // in clientOnly mode, whether to shallow copy results to more fully simulate a server.
    // This allows separate changes to be made to the "server data set" (testData) and
    // ResultSet caches.
    copyLocalResults:true,
    // Also support a mode where we explicitly clone the local-data. This will recursively
    // clone sub-objects. Off by default - not usually necessary and a little risky as
    // data may have references to non-serializable objects.
    deepCopyLocalResults:false,

    // Mock mode
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.mockMode (Boolean : null : IRW)
    // If set, causes this DataSource to use a read-only "mock" or "test" dataset, if specified, or if no test
    // data is available, then to load data normally but then operate similarly to a +link{clientOnly}
    // DataSource, never writing changes back to the server.
    // <p>
    // <code>mockMode</code> has no effect on +link{MockDataSource} or a +link{clientOnly} DataSource.  
    // <p>
    // For other DataSources, a one-time fetch will be performed to retrieve sample data, similar to a
    // +link{cacheAllData} DataSource, except that changes will never be saved back to the server.  Only a
    // subset of data will be retrieved, based on +link{mockDataRows}.  +link{mockDataCriteria} can optionally
    // be set to retrieve specific data.
    // <p>
    // Alternatively, mock data can be provided with +link{cacheData}.
    // <p>
    // DataSources can be loaded in <code>mockMode</code> via passing settings to +link{DataSource.load()}, or
    // if loaded with a screen or project, by passing settings to +link{RPCManager.loadScreen()} or
    // the server-side Project.load() API.
    //
    // @visibility external
    //<

    //> @attr dataSource.mockDataRows (Integer : 75 : IR)
    // When +link{mockMode} is enabled, number of rows of data to retrieve via an initial "fetch" DSRequest, for
    // use as sample data.  Set to null to retrieve all available rows.
    // @serverDS allowed
    //
    // @visibility external
    //<
    mockDataRows:75,

    //> @attr dataSource.mockDataCriteria (Criteria : null : IR)
    // When +link{mockMode} is enabled, criteria to use in an initial "fetch" DSRequest to retrieve sample data.
    // @serverDS allowed
    //
    // @visibility external
    //<

    // Filtering
	// ----------------------------------------------------------------------------------------
    combineCriteria : function (criteria1, criteria2, outerOperator, textMatchStyle, subCriteria) {
        // instance-level method that passes itself to the class-level version
        return isc.DS.combineCriteria(criteria1, criteria2, outerOperator, textMatchStyle, subCriteria, this);
    },

    //> @attr dataSource.criteriaPolicy (CriteriaPolicy : "dropOnShortening" : IRWA)
    // Decides under what conditions the +link{ResultSet} cache should be dropped when the
    // +link{resultSet.criteria} changes.
    // @see compareCriteria()
    // @serverDS allowed
    // @visibility external
    //<
    criteriaPolicy:"dropOnShortening",

    //> @attr dataSource.defaultTextMatchStyle (TextMatchStyle : "exact" : [IR])
    // The default textMatchStyle to use for +link{DSRequest}s that do not explicitly state 
    // a +link{dsRequest.textMatchStyle,textMatchStyle}.    Note, however, that DSRequests 
    // issued by +link{ListGrid}s and other +link{DataBoundComponent,components} will 
    // generally have a setting for textMatchStyle on the component itself (see
    // +link{ListGrid.autoFetchTextMatchStyle}, for example).
    //
    // @group clientDataIntegration
    // @group serverDataIntegration
    // @serverDS allowed
    // @visibility external
    // @example jsonDataSource
    // @example simpleJSON
    //<
    defaultTextMatchStyle:"exact",

    //> @attr dataSource.ignoreTextMatchStyleCaseSensitive (Boolean : false : [IR])
    // For fields on this dataSource that specify 
    // +link{dataSourceField.ignoreTextMatchStyle,ignoreTextMatchStyle} true, the prevailing
    // textMatchStyle is ignored and SmartClient matches exact values.  This property dictates
    // whether that match is case-sensitive like the "exactCase" textMatchStyle, or 
    // case-insensitive like the "exact" textMatchStyle (the default).  Please see the 
    // +link{type:TextMatchStyle,TextMatchStyle documentation} for a discussion of the nuances
    // of case-sensitive matching.
    //
    // @serverDS allowed
    // @visibility external
    //<
    ignoreTextMatchStyleCaseSensitive:false,

    // ResultTrees
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.resultTreeClass (Class Object : null : [IRA])
    // Class for ResultTrees used by this datasource.  If null, defaults to using
    // +link{ResultTree}.
    // <P>
    // This can be set to a custom subclass of ResultTree that, for example, hangs on to extra
    // information necessary for integration with web services.
    //
    // @serverDS allowed
    //  @visibility external
    //<

    // ResultSets
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.resultSetClass (Class Object : null : [IRA])
    // Class for ResultSets used by this datasource.  If null, defaults to using
    // +link{ResultSet}.
    // <P>
    // This can be set to a custom subclass of ResultSet that, for example, hangs onto to extra
    // information necessary for integration with web services.
    //
    // @serverDS allowed
    // @visibility external
    //<
    
    // Validation
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.useLocalValidators (boolean : null : IRWA)
    // Whether to attempt validation on the client at all for this DataSource.  If unset (the
    // default), client-side validation is enabled.
    // <p>
    // Disabling client-side validation entirely is a good way to test server-side validation.
    //
    // @group validation
    // @serverDS allowed
    // @visibility external
    //<
    // NOTE: code that checks this property interprets null as true

    //> @attr dataSource.requiredMessage (HTMLString : null : [IRW])
    // The required message when a field that has been marked as
    // +link{DataSourceField.required,required} is not filled in by the user.
    // <p>
    // Note that +link{dataSourceField.requiredMessage} wins over this setting if both are set.
    // @group formTitles
    // @visibility external
    //<

    // ShowPrompt
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.showPrompt (Boolean : true : IRW)
    // Whether RPCRequests sent by this DataSource should enable
    // +link{attr:RPCRequest.showPrompt} in order to block user interactions until the
    // request completes.  
    // <p>
    // DataSource requests default to blocking UI interaction because, very often, if the user
    // continues to interact with an application that is waiting for a server response, some
    // kind of invalid or ambiguous situation can arise.
    // <p>
    // Examples include pressing a "Save" button a second time before the first save completes,
    // making further edits while edits are still being saved, or trying to initiate editing on
    // a grid that hasn't loaded data.
    // <p>
    // Defaulting to blocking the UI prevents these bad interactions, or alternatively, avoids
    // the developer having to write repetitive code to block invalid interactions on every
    // screen.
    // <p>
    // If an operation should ever be non-blocking, methods that initiate DataSource requests
    // (such as +link{DataSource.fetchData()}) will generally have a
    // <code>requestProperties</code> argument allowing <code>showPrompt</code> to be set to
    // false for a specific request.
    //
    // @serverDS allowed
    // @visibility external
    //<
    showPrompt:true,

    // Selection
	// ----------------------------------------------------------------------------------------
    //> @attr dataSource.selectionClass (ClassName : null : [A])
    // Class to use as the Selection object for ResultSets derived from this DataSource.
    // @visibility serverSelection
    //<
    

    // Java enum translation
	// ----------------------------------------------------------------------------------------
    //> @type EnumTranslateStrategy
    // Determines how Java enums are translated to and from Javascript by the SmartClient server.
    //
    // @value "name"
    //   Translates to/from a String matching the constant name. This is the default if not set.
    // @value "string"
    //   Translates to/from a String matching the <code>enum.toString()</code>.
    // @value "ordinal"
    //   Translates to/from an integer matching the ordinal number of the constant within 
    //   the enumeration
    // @value "bean"
    //   Translates to/from a Javascript object containing one property for each property defined 
    //   within the enum. The constant itself and the ordinal number are included in the JS object.
    //   By default they are called "_constant" and "_ordinal", but this can be overridden with 
    //   the +link{dataSource.enumOrdinalProperty} and +link{dataSource.enumConstantProperty}
    //   properties
    //
    // @see dataSource.enumTranslateStrategy
    // @serverDS allowed
    // @visibility external
    //<
    
    
    //> @attr dataSource.enumTranslateStrategy (EnumTranslateStrategy : null : IA)
    //
    // Sets the strategy this DataSource uses to translate Java enumerated types (objects of type
    // enum) to and from Javascript.
    // 
    // This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.enumConstantProperty (String : null : IA)
    //
    // The name of the property this DataSource uses for constant name when translating
    // Java enumerated types to and from Javascript, if the +link{enumTranslateStrategy} is set
    // to "bean".  Defaults to "_constant" if not set.
    // <p>
    //  This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.enumOrdinalProperty (String : null : IA)
    //
    // The name of the property this DataSource uses for ordinal number when translating
    // Java enumerated types to and from Javascript, if the +link{enumTranslateStrategy} is set
    // to "bean".  Defaults to "_ordinal" if not set.
    // <p>
    //  This property is only applicable if you are using the SmartClient server
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr dataSource.autoDeriveTitles (boolean : true : IR)
    // If set, titles are automatically derived from +link{dataSourceField.name,field.name} for any 
    // field that does not have a +link{dataSourceField.title,field.title} and is not marked
    // +link{dataSourceField.hidden,hidden}:true, by calling the method +link{getAutoTitle()}.
    // @serverDS allowed
    // @visibility external
    //<
    autoDeriveTitles: true,

    // Multi-level Sorting
    //> @attr dataSource.canMultiSort (boolean : true : IR)
    // When true, indicates that this DataSource supports multi-level sorting.
    // @serverDS allowed
    // @visibility external
    //<
    canMultiSort: true,
    
    //> @attr dataSource.sparseUpdates (boolean : false : IR)
    // When true, indicates that any updates for this DataSource include only those fields 
    // that have actually changed (and primaryKey fields); when false (the default), all 
    // field values are included in updates, whether they have changed or not
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.noNullUpdates (boolean : false : IR)
    // When true, indicates that fields in this DataSource will never be positively updated
    // to the null value; they may arrive at null values by being omitted, but we will 
    // not send actual null values in update requests.  When false (the default), null is 
    // not treated in any special way.
    // <p>
    // Setting this value causes null-assigned fields to be replaced with the field's
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}, if one is declared.
    // If no <code>nullReplacementValue</code> is declared for the field, the null assignment
    // is replaced with the DataSource's +link{nullStringValue,nullStringValue}, 
    // +link{nullIntegerValue,nullIntegerValue}, +link{nullFloatValue,nullFloatValue} 
    // or +link{nullDateValue,nullDateValue}, depending on the field type.
    // <p>
    // For "add" operations, setting +link{omitNullDefaultsOnAdd,omitNullDefaultsOnAdd} causes
    // null-valued fields to be removed from the request entirely, rather than replaced with
    // default values as described above.
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.omitNullDefaultsOnAdd (boolean : false : IR)
    // When true, and +link{noNullUpdates,noNullUpdates} is also true, indicates that "add" 
    // requests on this DataSource will have null-valued fields removed from the request 
    // entirely before it is sent to the server, as opposed to the default behavior of 
    // replacing such null values with defaults.
    // @see noNullUpdates
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.nullStringValue (String : "" : IR)
    // If +link{noNullUpdates} is set, the value to use for any text field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullStringValue: "",
    
    //> @attr dataSource.nullIntegerValue (int : 0 : IR)
    // If +link{noNullUpdates} is set, the value to use for any integer field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullIntegerValue: 0,
    
    //> @attr dataSource.nullFloatValue (float : 0.0 : IR)
    // If +link{noNullUpdates} is set, the value to use for any float field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullFloatValue: 0.0,
    
    //> @attr dataSource.nullBooleanValue (boolean : false : IR)
    // If +link{noNullUpdates} is set, the value to use for any boolean field that has a null
    // value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullBooleanValue: false,
    
    //> @attr dataSource.nullDateValue (Date : See below : IR)
    // If +link{noNullUpdates} is set, the value to use for any date or time field that has a
    // null value assigned on an update operation, and does not specify an explicit
    // +link{DataSourceField.nullReplacementValue,nullReplacementValue}.
    // <p>
    // Unlike strings and numbers, there is no "natural" choice for a null replacement value 
    // for dates.  The default value we have chosen is midnight on January 1st 1970, simply 
    // because this is "the epoch" - the value that is returned by calling "new Date(0)"
    // @see noNullUpdates
    // @see DataSourceField.nullReplacementValue
    // @serverDS only
    // @visibility external
    //<
    nullDateValue: new Date(0),
    

    // Role-based security
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.requiresAuthentication (boolean : null : IR)
    // Whether a user must be authenticated in order to access this DataSource.  This establishes a
    // default for the DataSource as a whole; individual +link{operationBindings} within the
    // DataSource may still override this setting by explicitly setting
    // +link{operationBinding.requiresAuthentication}.
    // <P>
    // Whether the user is authenticated is determined by calling
    // <code>httpServletRequest.getRemoteUser()</code>, hence works with both simple J2EE security
    // (realms and form-based authentication) and JAAS (Java Authentication & Authorization
    // Service).
    // <P>
    // If you wish to use an authentication scheme that does not make use of the servlet API's 
    // standards, SmartClient Server also implements the <code>setAuthenticated</code> method
    // on <code>RPCManager</code>.  You can use this API to tell SmartClient that all the 
    // requests in the queue currently being processed are associated with an authenticated
    // user; in this case, SmartClient will not attempt to authenticate the user via 
    // <code>httpServletRequest.getRemoteUser()</code>
    // <P>
    // You can set the default value for this property via setting "authentication.defaultRequired"
    // in +link{group:server_properties,server.properties}.  This allows you to, for example,
    // cause all DataSources to require
    // authentication for all operations by default.
    // <P>
    // Note that setting this property does not automatically cause an authentication mechanism to
    // appear - you still need to separately configure an authentication system.  Likewise, setting
    // requiresAuthentication="false" does not automatically allow users to bypass your authentication
    // mechanism - you need to set up a URL that will accept DSRequests and process them similar to
    // the default "IDACall" servlet, and which is not protected by the authentication system.  See
    // +link{group:servletDetails,Deploying SmartClient} for details on the IDACall servlet.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.requiresRole (String : null : IR)
    // Similar to +link{operationBinding.requiresRole}, but controls access to the DataSource as a
    // whole.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.requires (VelocityExpression : null : IR)
    // Indicates that the specified +link{type:VelocityExpression} must evaluate to true for a user 
    // to access this DataSource.
    // <P>
    // See also +link{operationBinding.requires}.
    //
    // @requiresModules SCServer
    // @group auth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.creatorOverrides (boolean : null : IR)
    // Indicates that declarative security rules are waived for rows that were created by the 
    // current user.  Practically, this means that when a security check fails, instead of a 
    // security exception being thrown, we alter the criteria to ensure that the request can 
    // only return or affect rows that were created by the current authenticated user.  This 
    // allows you to create security regimes whereby users can see and edit data they created, 
    // but have access to other users' data forbidden or limited.
    // <p>
    // In order for this to work, we require two things:<ul>
    // <li>The DataSource must specify a field of type "creator" - this field type is described 
    //     on +link{type:FieldType,this page}</li>
    // <li>The authentication regime in use must include the idea of a "current user".  The 
    //     authentication provided by the Servlet API is an example of such a regime.</li>
    // </ul>
    // This setting can be overridden at operationBinding and field level, allowing extremely
    // fine-grained control.
    //
    // @requiresModules SCServer
    // @see operationBinding.creatorOverrides
    // @see dataSourceField.creatorOverrides
    // @group fieldLevelAuth
    // @group declarativeSecurity
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.ownerIdField (String : null : IR)
    // Requires that the currently authenticated user match the contents of
    // this field, for client-initiated requests (i.e., where
    // <code>DSRequest.isClientRequest()</code> returns true on the server).
    //
    // <p>When a new row is added by a client-initiated +link{DSRequest}, the
    // ownerIdField will be automatically populated with the currently
    // authenticated user (clobbering any value supplied by the client).
    // Client-initiated attempts to update the ownerIdField will also be
    // prevented.
    //
    // <p>If you wish to set the ownerIdField to a different value via an "add"
    // or "update" operation, you can do so in server-side DMI code (possibly
    // consulting <code>DSRequest.getClientSuppliedValues()</code> to get the
    // value that was clobbered).
    //
    // <p>For client-initiated "fetch", "update" or "remove" operations, the
    // server will modify client-supplied criteria so that only rows whose
    // ownerIdField matches the currently authenticated user can be read,
    // updated or deleted. 
    //
    // <p>The ownerIdField setting can be overridden at the
    // +link{operationBinding.ownerIdField} level.
    //
    // <p>If ownerIdField is specified,
    // +link{dataSource.requiresAuthentication,requiresAuthentication} will
    // default to <code>true</code>. If <code>requiresAuthentication</code> is
    // explicitly set to <code>false</code>, then unauthenticated users will be
    // able to see all records. To avoid this, you can use
    // +link{dataSource.guestUserId,guestUserId} to specify a default user to
    // apply when no one has authenticated.
    //
    // @requiresModules SCServer
    // @see operationBinding.ownerIdField
    // @see dataSource.guestUserId
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.guestUserId (String : null : IR)
    // Value to use for the +link{dataSource.ownerIdField,ownerIdField} if no one 
    // has authenticated.
    //
    // <p>This setting can be overridden at the operationBinding level.
    //
    // @requiresModules SCServer
    // @see dataSource.ownerIdField
    // @see operationBinding.guestUserId
    // @serverDS only
    // @visibility external
    //<

    // General Security
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.serverOnly (String : null : IR)
    // Setting a DataSource to be <code>serverOnly="true"</code> ensures that it will not be visible
    // to the client. Any request through IDACall to this DataSource will return a failure response.
    // Only requests which have been initiated on the server-side will be executed against this DataSource.
    //
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    // Transactions
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.autoJoinTransactions (boolean : null : IR)
    // If true, causes all operations on this DataSource to automatically start or join a 
    // transaction associated with the current HttpServletRequest.  This means that multiple
    // operations sent to the server in a +link{RPCManager.startQueue(),request queue} will be
    // committed in a single transaction. 
    // <p>
    // Note that this includes fetch operations - setting this property to true has the same
    // effect as a transaction policy of ALL for just this DataSource's operations - see the 
    // server-side <code>RPCManager.setTransactionPolicy()</code> for details of the different 
    // TransactionPolicy settings.
    // <p>
    // If this property is explicitly false, this causes all operations on this DataSource 
    // to be committed individually - the same as a transaction policy of NONE, just for this
    // DataSource's operations.
    // <p>
    // In either case, you can override the setting for individual operations - see 
    // +link{OperationBinding.autoJoinTransactions}.
    // <P>
    // If this property if null or not defined, we fall back to the default setting for this
    // type of DataSource.  These are defined in +link{group:server_properties,server.properties}
    // as follows:
    // <ul>
    // <li><b>Hibernate:</b><code> hibernate.autoJoinTransactions</code></li>
    // <li><b>JPA/JPA2:</b><code> jpa.autoJoinTransactions</code></li>
    // <li><b>SQL:</b> There is one setting per configured database connection (+link{dbName,dbName}).
    // For example, the setting for the default MySQL connection is 
    // <code> sql.Mysql.autoJoinTransactions</code></li>
    // </ul>
    // If the setting is not defined at the DataSource-type level, we use the system global 
    // default, which is defined in <code>server.properties</code> as 
    // <code>autoJoinTransactions</code>.
    // <P>
    // At the dbName and global system levels, you can set the autoJoinTransactions attribute 
    // to a valid Transaction Policy, rather than a simple true or false (although these 
    // values work too - true is the same as ALL, false is the same as NONE).  For valid 
    // TransactionPolicy values and their meanings, see the server-side Javadoc for 
    // <code>RPCManager.setTransactionPolicy()</code>
    // <P>
    // Note that the configuration settings discussed here can be overridden for a particular 
    // queue of requests by setting the server-side RPCManager's transaction policy.  Look in
    // the server-side Javadoc for <code>RPCManager.getTransactionPolicy()</code>.
    // <P>
    // Transactions can also be initiated manually, separate from the
    // RPCManager/HttpServletRequest lifecycle, useful for both multi-threaded web
    // applications, and standalone applications that don't use a servlet container - see
    // +link{group:standaloneDataSourceUsage}.
    // <P>
    // NOTE: Setting this property to true does not cause a transactional persistence 
    // mechanism to automatically appear - you have to ensure that your DataSource supports 
    // transactions.  The SmartClient built-in SQL, Hibernate and JPA DataSources support transactions, 
    // but note that they do so <b>at the provider level</b>.  This means that you can combine 
    // updates to, say, an Oracle database and a MySQL database in the same queue, but they
    // will be committed in <em>two</em> transactions - one per database.  The SmartClient 
    // server will commit or rollback these two transactions as if they were one, so a 
    // failure in some Oracle update would cause all the updates to both databases to be 
    // rolled back.  However, this is not a true atomic transaction; it is possible for one
    // transaction to be committed whilst the other is not - in the case of hardware failure,
    // for example.
    // <p>
    // NOTE: Not all the supported SQL databases are supported for transactions.  Databases 
    // supported in this release are:
    // <ul>
    // <li>DB2</li>
    // <li>HSQLDB</li>
    // <li>Firebird</li>
    // <li>Informix</li>
    // <li>Microsoft SQL Server</li>
    // <li>MySQL (you must use InnoDB tables; the default MyISAM storage engine does not
    // support transactions)</li>
    // <li>MariaDB</li>
    // <li>Oracle</li>
    // <li>PostgreSQL</li>
    // </ul>
    //
    // @serverDS only
    // @see OperationBinding.autoJoinTransactions
    // @visibility transactions
    //<

    //> @attr dataSource.useSpringTransaction (boolean : null : IR)
    // This flag is part of the Automatic Transactions feature; it is only applicable in 
    // Power Edition and above.
    // <p>
    // If true, causes all transactional operations on this DataSource to use the current 
    // Spring-managed transaction, if one exists.  If there is no current Spring transaction 
    // to use at the time of execution, a server-side Exception is thrown.  Note, a 
    // "transactional operation" is one that would have joined the SmartClient shared 
    // transaction in the absence of Spring integration - see 
    // +link{dataSource.autoJoinTransactions,auotJoinTransactions}.
    // <p>
    // This feature is primarily intended for situations where you have 
    // +link{group:dmiOverview,DMI methods} that make use of both Spring DAO operations and 
    // SmartClient DSRequest operations, and you would like all of them to share the same 
    // transaction.  An example of the primary intended use case:<pre>
    //   &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    //   public class WorldService {
    //
    //     public DSResponse doSomeStuff(DSRequest dsReq, HttpServletRequest servletReq) 
    //     throws Exception 
    //     {
    //     	 ApplicationContext ac = (ApplicationContext)servletReq.getSession().getServletContext().getAttribute("applicationContext");
    //       WorldDao dao = (WorldDao)ac.getBean("worldDao");
    //       dao.insert(req.getValues());
    //       DSRequest other = new DSRequest("MyOtherDataSource", "add");
    //       // Set up the 'other' dsRequest with critiera, values, etc
    //       //  ...
    //
    //       // This dsRequest execution will use the same transaction that the DAO operation
    //       // above used; if it fails, the DAO operation will be rolled back
    //       other.execute();
    //
    //       return new DSResponse();
    //     }
    //   }</pre>
    // Note: if you want to rollback an integrated Spring-managed transaction, you can use 
    // any of the normal Spring methods for transaction rollback:<ul>
    // <li>Programmatically mark the transaction for rollback with the 
    // <code>setRollbackOnly()</code> API</li>
    // <li>Throw a <code>RuntimeException</code>, or</li>
    // <li>Throw an ordinary checked <code>Exception</code>. but configure Spring to rollback
    //     on that Exception.  This can be done in the @Transactional annotation:<pre>
    //     &#x0040;Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED, rollbackFor=MyRollbackException.class)</pre></li>
    // </ul>
    // Spring's exception-handling model is different from SmartClient's, so care must be
    // taken to get the correct error processing.  If a transactional DSRequest fails, 
    // SmartClient code will throw an ordinary checked <code>Exception</code>; but Spring will
    // ignore that <code>Exception</code>.  So you can either:<ul>
    // <li>Wrap every <code>DSRequest.execute()</code> in a try/catch block.  Catch 
    // <code>Exception</code> and throw a <code>RuntimeException</code> instead</li>
    // <li>Just use the "rollbackFor" annotation to make your transactional method rollback 
    // for all instances of <code>Exception</code></li>
    // </ul>
    // <br>
    // Note: Spring transaction integration is conceptually different from SmartClient's 
    // +link{dataSource.autoJoinTransactions,built-in transaction feature}, because SmartClient
    // transactions apply to a queue of DSRequests, whereas Spring transactions are scoped to 
    // a single method invocation.  If you want to make a whole SmartClient queue share a 
    // single Spring-managed transaction, you can wrap the processing of an entire queue in a 
    // call to a transactional Spring method.  See the <em>Using Spring Transactions with 
    // SmartClient DMI</em> section at the bottom of the 
    // +link{group:springIntegration,Spring integration page} for more details.
    // <p>
    // You can set <code>useSpringTransaction</code> as the default setting for all dataSources 
    // for a given database provider by adding the property 
    // <code>{dbName}.useSpringTransaction</code> to your <code>server.properties</code> file.
    // For example, <code>Mysql.useSpringTransaction: true</code> or 
    // <code>hibernate.useSpringTransaction: true</code>.  You can set it as the default for 
    // all providers with a <code>server.properties</code> setting like this: 
    // <code>useSpringTransaction: true</code>.  When <code>useSpringTransaction</code> is 
    // the default, you can switch it off for a specific dataSource by explicitly setting the
    // flag to false for that DataSource.
    // <p>
    // Finally, this setting can be overridden at the operationBinding level - see 
    // +link{operationBinding.useSpringTransaction}
    // <h3>Configuration</h3>
    // When using Spring transactions, SmartClient needs a way to lookup the JNDI connection 
    // being used by Spring, and this needs to be configured.  First, register a bean like 
    // this in your applicationContext.xml file:<pre>
    //   &lt;bean id="dataSource" class="org.springframework.jndi.JndiObjectFactoryBean"&gt;
    //       &lt;!-- Set this to the JNDI name Spring is using --&gt;
    //       &lt;property name="jndiName" value="isomorphic/jdbc/defaultDatabase"/&gt;
    //   &lt;/bean&gt;
    // </pre>
    // and then add a line like this to your server.properties:<pre>
    //   # Set this property to match the "id" of the JndiObjectFactoryBean registered in Spring
    //   sql.spring.jdbcDataSourceBean: dataSource
    // </pre>
    //    
    // @serverDS only
    // @see DataSource.autoJoinTransactions
    // @see OperationBinding.useSpringTransaction
    // @see group:springIntegration
    // @visibility transactions
    //<
	
	// SQL Paging Strategy
	// ----------------------------------------------------------------------------------------
    //> @type SQLPagingStrategy
    // The technique SmartClient Server's SQL DataSource should use to select a "page" of data 
	// from a table.  
    //
    // @value "sqlLimit"
    //   Specify the paging directly in the SQL query we generate.  The way this is done varies 
	// considerably from database to database: with some it is a straightforward built-in 
	// facility while others require arcane tricks or simply don't support the idea.  This is 
	// the most efficient method, where available.  Note that this strategy is not supported 
	// for operations that make use of a +link{operationBinding.customSQL,customSQL} clause, 
	// because it depends upon being able to determine the size of the whole dataset without
	// actually retrieving the whole dataset.  Ordinary operations do this by means of an 
	// automatically-generated "row count query", but we cannot generate such a query for a 
	// <code>customSQL</code> operation.
    //
    // @value "jdbcScroll"
    //   Implement the paging behavior by use of the <code>absolute()</code> method of the
	// JDBC <code>ResultSet</code>.  
    //
    // @value "dropAtServer"
    //   Implement the paging behavior by fetching the entire resultset from the database and
	// dropping any unnecessary rows on the server before returning the data to the client.
	// This approach is extremely inefficient, but also extremely straightforward; it is 
	// intended as a fallback option, for situations where the more sophisticated approaches
	// cause problems (a JDBC driver that throws vague exceptions when <code>absolute()</code>
	// is called, for example)
    //
    // @value "none"
    //   No paging behavior: we always return the entire resultset to the client.
    //
    // @see dataSource.sqlPaging
    // @see operationBinding.sqlPaging
    // @serverDS only
    // @visibility external
    //<
	
    //> @attr dataSource.sqlPaging (SQLPagingStrategy : null : IRW)
    // The paging strategy to use for this DataSource.  If this property is not set, the 
    // default paging strategy, specified with the +link{group:server_properties,server.properties}
    // setting <code>sql.defaultPaging</code>, is used.  
	// <p>
	// This setting can be overridden with the +link{OperationBinding.sqlPaging} property.
	// <P>
	// <b>NOTE:</b> Operations that involve a +link{operationBinding.customSQL,customSQL} 
	// clause ignore this property, because customSQL operations usually need to be treated
	// as special cases.  For these operations, the paging strategy comes from the 
	// +link{group:server_properties,server.properties} setting
	// <code>sql.defaultCustomSQLPaging</code> or 
    // <code>sql.defaultCustomSQLProgressivePaging</code>, depending on whether or not 
    // +link{dataSource.progressiveLoading,progressiveLoading} is in force.  Note that these
	// can always be overridden by a <code>sqlPaging</code> setting on the OperationBinding.
    //
    // @see operationBinding.sqlPaging
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.sqlUsePagingHint (boolean : null : IR)
    // If explicitly set true or left null, causes the server to use a "hint" in the SQL we 
    // generate for paged queries.  If explicitly set false, forces off the use of hints.  This
    // property can be overridden per operationBinding - see 
    // +link{operationBinding.sqlUsePagingHint}.
    // <p>
    // Note this property is only applicable to +link{dataSource.serverType,SQL} DataSources, 
    // only when a +link{dataSource.sqlPaging,paging strategy} of "sqlLimit" is in force,
    // and it only has an effect for those specific database products where we employ a native
    // hint in the generated SQL in an attempt to improve performance.
    //
    // @requiresModules SCServer
    // @see operationBinding.sqlUsePagingHint
    // @group sqlPaging
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.useSubselectForRowCount (boolean : null : IR)
    // This property is only applicable to +link{dataSource.serverType,SQL} DataSources, and 
    // only for +link{class:OperationBinding,operations} that express a 
    // +link{operationBinding.customSQL,customSQL} clause.  In these circumstances, we 
    // generally switch off paging because we are unable to generate a "row count" query that
    // tells the framework the size of the complete, unpaged resultset.
    // <p>
    // The <code>useSubselectForRowCount</code> flag causes the framework to derive a rowcount
    // query by simply wrapping the entire customSQL clause in a subselect, like so:<code><br>
    // &nbsp;&nbsp;&nbsp;&nbsp;SELECT COUNT(*) FROM ({customSQL clause here})</code>
    // <p>
    // However, this is not guaranteed to give good results.  Because the customSQL clause can
    // contain anything that you can write in SQL, running it inside a subselect in order to 
    // count the rows might not work, might have unintended side-effects (if, for example, it 
    // is a stored procedure call that performs updates as part of its function), or it might 
    // just be a bad idea - for example, if the customSQL query is slow-running, you'll make 
    // it twice as slow with this flag, simply because you'll be running it twice.  We 
    // recommend using this flag with care.
    // <p>
    // NOTE: This setting can be overridden per-operation - see 
    // +link{operationBinding.useSubselectForRowCount}.  You can also set a global default for
    // this setting, so you don't have to specify it in every dataSource - define 
    // <code>useSubselectForRowCount</code> as true in your 
    // +link{group:server_properties,server.properties} file.
    //
    // @requiresModules SCServer
    // @group sqlPaging
    // @serverDS only
    // @visibility external
    //<


    // SQL autoDeriveSchema auto-discovered FK relations
    // ----------------------------------------------------------------------------------------
    
    //> @attr dataSource.tableCode (String : null : R)
    // <b>Only applicable to the built-in SQL DataSource</b>
    // <p>
    // <code>tableCode</code> and the related properties +link{dataSourceField.columnCode},
    // +link{dataSourceField.fkTableCode} and +link{dataSourceField.fkColumnCode} are read-only
    // attributes that are secure and unique cryptographic hashes of table and column names
    // used by this DataSource.
    // <p>
    // These properties are used automatically by client-side framework code to 
    // link dataSources together by +link{dataSourceField.foreignKey,foreign key} when a
    // <code>foreignKey</code> is not explicitly declared, but is found in the SQL schema via
    // the +link{autoDeriveSchema} feature.
    // <p>
    // A secure hash is used rather than the actual SQL table or column name for security
    // reasons - sending the actual SQL table or column name to the client could aid in
    // attempted SQL injection attacks.
    // <p>
    // This feature can be disabled system-wide via setting <code>datasource.autoLinkFKs</code>
    // to <code>false</code> in +link{group:server_properties,server.properties}.
    //
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSourceField.fkTableCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSourceField.fkColumnCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSourceField.columnCode (String : null : R)
    // See +link{dataSource.tableCode}.
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    
    
    // progressiveLoading
    // ----------------------------------------------------------------------------------------
    
    //> @groupDef progressiveLoading
    // Settings related to the "progressive loading" pattern, which causes data to be loaded 
    // progressively, so that users can request more rows by scrolling off the bottom of the
    // currently visible rows, but cannot cause direct movement to some arbitrary position in 
    // the dataset (as is the case with ordinary, non-progressive loading).  This pattern may
    // give a better user experience with large datasets.
    // @visibility external
    //<
	
    //> @attr dataSource.progressiveLoading (boolean : null : IRW)
    // If true, causes SmartClient Server to use the "progressive loading" pattern for 
    // fetches on this dataSource, as described in the <b>Paging and total dataset length</b>
    // section of the +link{ResultSet,ResultSet documentation}.  Essentially, this means that
    // we avoid issuing a row count query and instead advertise total rows as being slightly 
    // more than the number of rows we have already read (see +link{endGap,endGap}).  This 
    // allows users to load more of
    // a dataset by scrolling past the end of the currently-loaded rows, but it prevents them
    // from scrolling directly to the end of the dataset.
    // <p>
    // Generally, progressive loading is appropriate when you have to deal with very large 
    // datasets. Note that by default, a dataSource will switch into progressive loading mode 
    // automatically when it detects that it is dealing with a dataset beyond a certain size - 
    // see +link{progressiveLoadingThreshold}.
	// <p>
	// This setting can be overridden for individual fetch operations with the 
    // +link{OperationBinding.progressiveLoading} property, and also at the level of the
    // individual +link{DSRequest.progressiveLoading,DSRequest}.  You can also specify 
    // <code>progressiveLoading</code> on 
    // +link{DataBoundComponent.progressiveLoading,DataBoundComponents} and certain types of 
    // <code>FormItem</code> - +link{SelectItem.progressiveLoading,SelectItem} and 
    // +link{ComboBoxItem.progressiveLoading,ComboBoxItem}.
    // <p>
    // Currently, this property only applies to users of the built-in SQLDataSource, but you 
    // could use it in custom DataSource implementations to trigger the server behavior 
    // described in the <code>ResultSet</code> documentation linked to above.
    //
    // @see operationBinding.progressiveLoading
    // @see dataSource.progressiveLoadingThreshold
    // @see dataSource.lookAhead
    // @see dataSource.endGap
    // @serverDS allowed
	// @group progressiveLoading
    // @visibility external
    //<

    //> @attr dataSource.progressiveLoadingThreshold (int : 200000 : IRW)
    // Indicates the dataset size that will cause SmartClient Server to automatically
    // switch into +link{progressiveLoading,progressive loading mode} for this DataSource.
    // To prevent automatic switching to progressive loading, set this property to -1. This
    // may also be prevented on a per-request basis by setting +link{dsRequest.progressiveLoading}
    // to <code>false</code>.
    //
    // @see dataSource.progressiveLoading
    // @see dsRequest.progressiveLoading
    // @serverDS only
    // @group progressiveLoading
    // @visibility external
    //<
	
    //> @attr dataSource.lookAhead (int : 1 : IRW)
    // If we are +link{progressiveLoading,loading progressively}, indicates the number of 
    // extra records SmartClient Server will read beyond the end record requested by the client,
    // in order to establish if there are more records to view.  This property has no effect 
    // if we are not progressive-loading.
    // <p>
    // This property can be tweaked in conjunction with +link{endGap,endGap} to change behavior
    // at the end of a dataset.  For example, with the default values of <code>lookAhead: 1</code>
    // and <code>endGap: 20</code>, we can end up with the viewport shrinking if we get a case
    // where there really was only one more record (because the client was initially told there
    // were 20 more).  This is not a problem per se, but it may be surprising to the user.
    // You could prevent this happening (at the cost of larger reads) by setting 
    // <code>lookAhead</code> to be <code>endGap+1</code>.
    //
    // @see dataSource.progressiveLoading
    // @see dataSource.endGap
    // @serverDS only
	// @group progressiveLoading
    // @visibility external
    //<

    //> @attr dataSource.defaultBooleanStorageStrategy (String : null : IR)
    // For +link{dataSource.serverType,serverType:"sql"} DataSources, sets the
    // default +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} to use for boolean fields
    // where no <code>sqlStorageStrategy</code> has been declared on the field.
    // <P>
    // Can also be set system-wide via the +link{group:server_properties} setting
    // <code>sql.defaultBooleanStorageStrategy</code>, or for a particular database configuration by
    // setting <code>sql.<i>dbName</i>.defaultBooleanStorageStrategy</code> (see
    // +link{group:adminConsole,Admin Console overview} for more information on SQL configuration).
    // <p>
    // Note that when this property is unset, the default +link{dataSourceField.sqlStorageStrategy}
    // strategy is effectively "string".
    //
    // @group serverDataIntegration
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.endGap (int : 20 : IRW)
    // If we are +link{progressiveLoading,loading progressively}, indicates the number of 
    // extra records SmartClient Server will advertise as being available, if it detects that 
    // there are more records to view (see +link{lookAhead,lookAhead}).  This property has no 
    // effect if we are not progressive-loading.
    //
    // @see dataSource.progressiveLoading
    // @see dataSOurce.lookAhead
    // @serverDS only
	// @group progressiveLoading
    // @visibility external
    //<
    

    // cacheAllData implementation
    // ----------------------------------------------------------------------------------------

    //> @attr dataSource.cacheAllData (Boolean : null : IRW)
    // Set this property to true to have a DataSource fetch all of its data client-side on the 
    // first fetch request.  However, unlike a +link{dataSource.clientOnly,clientOnly} DataSource, this DataSource 
    // will still save changes normally, sending remote requests.
    // <P>
    // You can manually set this attribute after initialization by calling 
    // +link{setCacheAllData}; setting +link{autoCacheAllData}:true causes a DataSource to 
    // automatically switch to <code>cacheAllData:true</code> when a fetch results in the
    // entire dataset being brought client-side.
    // <P>
    // To cause automatic cache updates, you can set +link{cacheMaxAge} to a number of seconds
    // and once data has been client-side for that length of time, the next fetch causes the
    // cache to be dropped and a new cache retrieved.
    // <P>
    // Note that multiple +link{operationBindings} of type "fetch" which return distinct
    // results will not work with <code>cacheAllData</code>: only one cache is created and is
    // used for all fetch operations, regardless of whether +link{dsRequest.operationId} has
    // been set.  However, "fetch" operationBindings used as a
    // +link{operationBinding.cacheSyncOperation} will work normally, so long as they return
    // all data fields that are returned by the default "fetch" operation, so that the cache
    // can be updated.
    // <P>
    // To specify which operationId to use for fetching all data, use
    // +link{dataSource.cacheAllOperationId, cacheAllOperationId}.
    // <p>
    // To use the cache only for requests that have the <code>cacheAllOperationId</code>,
    // allowing any other operationId (or absence of an operationId) to contact the server as
    // normal, set +link{dataSource.cacheAcrossOperationIds,cacheAcrossOperationIds}.
    //
    // @setter setCacheAllData
    // @group clientData
    // @visibility external
    //<

    //> @attr dataSource.cacheAllOperationId (String : null : IR)
    // +link{dsRequest.operationId} to use for fetching data in case +link{dataSource.cacheAllData, cacheAllData} is
    // true.  By default a standard fetch operation is used (with no <code>operationId</code>
    // specified).
    // @group clientData
    // @visibility external
    //<

    //> @attr dataSource.cacheAcrossOperationIds (Boolean : true : IR)
    // When +link{dataSource.cacheAllData,cacheAllData} mode is enabled and a
    // +link{dataSource.cacheAllOperationId} has been set, this flag affects whether cached
    // results are used for all "fetch" requests regardless of their
    // +link{dsRequest.operationId}, or are used only for "fetch" requests that use the
    // <code>cacheAllOperationId</code>, allowing other requests to go to server normally.
    // <p>
    // Default of <code>true</code> means that the <code>cacheAllOperationId</code> will be
    // used to fetch all rows, but the resulting cache will be used for all "fetch" operations
    // regardless of the <code>operationId</code> specified on the request.
    // <p>
    // Switching to "false" effectively creates caching just for one specific
    // <code>operationId</code> - the <code>cacheAllOperationId</code> - while allowing all
    // other requests to go to the server normally.
    //
    // @group clientData
    // @visibility external
    //<
    cacheAcrossOperationIds : true,

    //> @method dataSource.setCacheAllData() 
    // Call this method to switch cacheAllData on or off after initialization.  Passing a 
    // <code>shouldCache</code> value of false clears any existing client-side cache,
    // cancels any outstanding requests for a full cache and issues any other pending requests
    // normally.
    // 
    // @param shouldCache (Boolean) New value for +link{cacheAllData}
    // @group clientData
    // @visibility external
    //<
    setCacheAllData : function (shouldCache) {
        if (!shouldCache) {
            if (this.cacheAllData == true) {
                if (this.logIsInfoEnabled("cacheAllData")) {
                    this.logInfo("setCacheAllData(false): clearing the cache and any "+
                        "deferred requests", "cacheAllData");
                }
                // TODO: reset to normal operation
                delete this._autoCacheAllData_timestamp;
                // 1) clear the cache if there is one
                this.invalidateCache();
                this.cacheAllData = false;
                // 2) cancel and ignore any outstanding "fetch" requests for a full cache
                this.clearDeferredRequests();
                
                if (this._insulatedTransforms == true) {
                    // remove these custom methods - sendDSRequest() has logic that differs for clientCustom
                    // request if _isServerRequest is present
                    delete this._insulatedTransforms;
                    delete this._isServerRequest;
                    if (this.transformServerRequest) {
                        this.transformRequest = this.transformServerRequest;
                        delete this.transformServerRequest;
                    }
                    if (this.transformServerResponse) {
                        this.transformResponse = this.transformServerResponse;
                        delete this.transformServerResponse;
                    }
                }
            }
        } else {
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheAllData(true): invalidate the cache", "cacheAllData");
            }
            this.cacheAllData = true;
            this._autoCacheAllData_timestamp = isc.timestamp();
            this.invalidateCache();
        }
    },

    //> @attr dataSource.cacheMaxAge (Number : 60 : IRW)
    // The maximum time, in seconds, to maintain the client-side cache.  If a fetch occurs after
    // the cacheMaxAge has expired, the current cache will be dropped and another complete
    // cache fetched.
    // @group clientData
    // @visibility external
    //<
    cacheMaxAge: 60,
    // cacheLastFetchTime - the time at which the client-side cache became valid - this value +
    // the cacheMaxAge determines when the cache will be invalidated.
    cacheLastFetchTime: 0,

    cacheNeedsRefresh : function () {
        var currentTime = new Date().getTime(),
            elapsedSeconds = ((currentTime - this.cacheLastFetchTime) / 1000),
            result = (this.cacheLastFetchTime == 0 || elapsedSeconds > this.cacheMaxAge)
        ;

        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("cacheNeedsRefresh returns "+result, "cacheAllData");
        }

        return result;
    },

    //> @attr dataSource.cacheData (Array of Record : null : IRW)
    // For a +link{cacheAllData} or client-only DataSource, a set of records to use as a dataset, 
    // specified as an Array of JavaScript Objects representing records.
    // <P>
    // See +link{group:clientOnlyDataSources,this discussion} for ways to populate a
    // client-only DataSource with cache data.
    // <P>
    // Additionally, when a DataSource is loaded in +link{mockMode}, <code>cacheData</code>,
    // if provided, is used as the mock data.
    // <P>
    // For any other DataSource, <code>cacheData</code> is dropped when loaded.
    // @setter setCacheData
    // @group clientData
    // @visibility external
    //<

    //> @method dataSource.setCacheData() 
    // Call this method to set the data in the client-side cache after initialization.
    // @param data (Array of Record) Array of records to apply as the client-side cache
    // @group clientData
    // @visibility external
    //<
    setCacheData : function (data) {
        if (this.cacheAllData || this.clientOnly) {
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheData: invalidating the cache", "cacheAllData");
            }
            // invalidate the cache and clear any pending requests
            this.invalidateCache();
            this.clearDeferredRequests();

            // set the cacheData
            
            this.cacheData = this.testData = data;
            
			// At this point our cacheData is fresh - reset the timer so the 'needsRefresh' method
			// returns false and doesn't ignore it!
			this.cacheLastFetchTime = new Date().getTime();
            
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("setCacheData: cacheData has been set", "cacheAllData");
            }
            
        }
    },

    //> @attr dataSource.testData (Array of Record : null : IRW)
    // For a client-only DataSource, a set of records to use as a dataset, specified as an
    // Array of JavaScript Objects. 
    // <P>
    // See +link{group:clientOnlyDataSources,this discussion} for ways to populate a
    // client-only DataSource with test data.
    // @setter setTestData
    // @group clientData
    // @visibility external
    // @deprecated In favor of +link{dataSource.cacheData}.
    //<

    //> @method dataSource.setTestData()
    // Call this method to set the data in the client-side test-data after initialization. 
    // @param data (Array of Record) Array of records to apply as the client-side test-data
    // @group clientData
    // @visibility external
    // @deprecated In favor of +link{dataSource.setCacheData()}.
    //<
    setTestData : function (data, invalidateCache) {
        this.setCacheData(data,invalidateCache);
    },

    //> @attr dataSource.sendParentNode (Boolean : false : IRWA)
    // Set this attribute if you need to send the dsRequest.parentNode to the server-side.
    // @visibility external
    //<
    sendParentNode : false,

    // clear deferred requests - support passing in requestTypes to cancel or "any" to clear
    // all pending requests - if no requestTypes passed, assume "any"
    clearDeferredRequests : function (requestTypes) {
        if (!this._deferredRequests) return;
        requestTypes = requestTypes || "any";
        if (!isc.isAn.Array(requestTypes)) requestTypes = [requestTypes];

        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("clearDeferredRequests: "+this._deferredRequests.length+" requests, "+
                "clearing those of type "+isc.echoAll(requestTypes), "cacheAllData");
        }

        if (requestTypes.contains("any")) delete this._deferredRequests;
        else {
            if (this._deferredRequests) {
                var requests = this._deferredRequests;
                for (var i=requests.length; i>=0; i--) {
                    var type = requests[i].operationType || "fetch";
                    if (requestTypes.contains(type)) this._deferredRequests.removeAt(i);
                }
                if (this._deferredRequests.length == 0) delete this._deferredRequests;
            }
        }
    },

    // process any deferred requests that are still outstanding
    processDeferredRequests : function () {
        if (!this._deferredRequests) return;
        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("processDeferredRequests: processing "+this._deferredRequests.length+
                " deferred requests", "cacheAllData");
        }

        var deferredRequests = this._deferredRequests;
        this.clearDeferredRequests();
        // call all deferred requests
        for (var i = 0; i < deferredRequests.length; i++) {
            this.sendDSRequest(deferredRequests[i]);
        }
    },

    //> @method dataSource.invalidateCache() 
    // Invalidate the cache when +link{cacheAllData} or +link{dataSource.clientOnly,clientOnly} are true.
    // @group clientData
    // @visibility external
    //<
    invalidateCache : function () {
        if (!this.cacheAllData && !this.clientOnly) return;

        if (this.logIsInfoEnabled("cacheAllData")) {
            this.logInfo("invalidateCache: invalidating client-side cache", "cacheAllData");
        }

        delete this.cacheData;
        delete this.testData;
        this.cacheLastFetchTime = 0;
        if (this.cacheResultSet) {
            this.cacheResultSet.destroy();
            delete this.cacheResultSet;
        }
    },

    //> @method dataSource.setClientOnly() 
    // Switch into clientOnly mode, taking the cache from the cacheAllData ResultSet if it 
    // exists.
    // @group clientData
    // @visibility external
    //<
    setClientOnly : function (clientOnly) {
        if (clientOnly) {
            this.clientOnly = true
            if (this.enforceSecurityOnClient != false) this.enforceSecurityOnClient = true;
            if (this.cacheAllData) {
                if (this.cacheResultSet) {
                    if (this.logIsInfoEnabled("cacheAllData")) {
                        this.logInfo("setClientOnly: sourcing from client-cache", "cacheAllData");
                    }
                    this.cacheData = this.testData = this.cacheResultSet.getAllRows();
                }
            } else {
                this.clearDeferredRequests();
                this.invalidateCache();
                this.performDSOperation("fetch");
            }
        }
    },

    //> @method dataSource.hasAllData() 
    // When +link{dataSource.cacheAllData} is true, has all the data been retrieved to the client?
    // @return (Boolean) All data has been fetched from the server and is available client-side
    // @group clientData
    // @visibility external
    //<
    hasAllData : function () {
        if (this.cacheResultSet) return this.cacheResultSet.lengthIsKnown();
        else return false;
    },

    //> @attr dataSource.autoCacheAllData (Boolean : false : IR)
    // When a DataSource is not +link{dataSource.cacheAllData}:true and a fetch results in the
    // entire dataset being retrieved, this attribute being set to true causes the DataSource
    // to automatically switch to <code>cacheAllData:true</code> and prevent further server-trips for fetch 
    // requests.
    // <p>
    // +link{dataSource.cacheAllData, cacheAllData} is automatically enabled in either of these conditions:
    // <ul>
    //   <li>
    //     The request has no criteria and no startRow/endRow request properties. The latter can
    //     be accomplished by disabling paging with a +link{dataBoundComponent.dataFetchMode,dataFetchMode}
    //     setting of "basic" or "local" or by an explicit fetchData request with those request properties
    //     excluded.
    //  </li>
    //  <li>
    //     The request has no criteria but has startRow/endRow specified and the response received has
    //     all data available (<code>startRow:0</code> and <code>endRow:totalRows</code>).
    //  </li>
    // </ul>
    // @group clientData
    // @visibility external
    //<
    autoCacheAllData: false,

    //> @attr dataSource.useTestDataFetch (boolean : null : IRW)
    // When set, causes a +link{clientOnly, client-only} or +link{cacheAllData} DataSource to 
    // create a second DataSource to perform it's one-time fetch.  By default, this attribute
    // will be considered true when clientOnly is true, cacheAllData is false or unset and
    // a dataURL or testFileName is specified on the DataSource.
    // @group clientData
    // @visibility external
    //<

    
    criteriaContainsDates : function (criteria) {
        var fieldNames = this.getCriteriaFields(criteria);

        if (fieldNames && fieldNames.length > 0) {
            for (var i=0; i<fieldNames.length; i++) {
                var field = this.getField(fieldNames[i]);
                if (!field) continue;
                if (isc.SimpleType.inheritsFrom(field.type, "date") ||
                            isc.SimpleType.inheritsFrom(field.type, "datetime")) {
                    return true;
                }
            }
        }

        return false;
    },

    //> @method dataSource.convertRelativeDates ()
    // Takes all relative date values found anywhere within a Criteria / AdvancedCriteria object
    // and converts them to concrete date values, returning the new criteria object.
    // @param criteria (Criteria) criteria to convert
    // @param [timezoneOffset] (String) optional timezone offset.  Defaults to the current timezone
    // @param [firstDayOfWeek] (Integer) first day of the week (zero is Sunday).  Defaults to
    //                               +link{DateChooser.firstDayOfWeek}
    // @param [baseDate] (Date) base value for relative conversion - defaults to now
    // @return (Criteria) new copy of the criteria with all relative dates converted
    // @visibility external
    //<
    convertRelativeDates : function (criteria, timezoneOffset, firstDayOfWeek, baseDate) {
        // just bail if passed null criteria
        if (!criteria) return null;
        
        if (!this.criteriaContainsDates(criteria)) {
            // there are no date fields in the criteria - no point continuing, just return it
            return criteria;
        }
        
        if (!this.isAdvancedCriteria(criteria) && criteria.operator == null) {
            // this is neither an AdvancedCriteria nor a simple Criterion object so no point
            // parsing it, just return it as-is
            return criteria;
        }

        // get a copy of the criteria to alter and return - it's ok to use clone() here as 
        // we've already confirmed the param is criteria above
        var result = isc.clone(criteria);

        baseDate = baseDate || new Date();

        if (firstDayOfWeek == null) firstDayOfWeek = isc.DateChooser ? isc.DateChooser.firstDayOfWeek : 0;

        if (result.criteria && isc.isAn.Array(result.criteria)) {
            // complex sub-criteria, call this method again with that criteria
            var subCriteria = result.criteria;

            for (var i = subCriteria.length-1; i>=0; i--) {
                var subItem = subCriteria[i];

                if (!subItem) {
                    if (this.logIsInfoEnabled("relativeDates")) {
                        this.logInfo("Removing NULL subCriteria...", "relativeDates");
                    }
                    result.criteria.removeAt(i);
                } else {
                    if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Calling convertRelativeDates from convertRelativeDates "+
                                "- data is:\n\n"+isc.echoFull(subItem)+"\n\n"+
                                "criteria is: \n\n"+isc.echoFull(criteria)
                                ,"relativeDates"
                            );
                        }

                        result.criteria[i] = this.convertRelativeDates(subItem, timezoneOffset,
                            firstDayOfWeek, baseDate);

                        if (this.logIsInfoEnabled("relativeDates")) {
                            this.logInfo("Called convertRelativeDates from convertRelativeDates "+
                            "- data is\n\n" + isc.echoFull(result.criteria[i]), "relativeDates");
                        }
                    } else {
                        result.criteria[i] = this.mapRelativeDate(subItem, baseDate);
                    }
                }
            }
        } else {
            // simple criterion
            result = this.mapRelativeDate(result, baseDate);
        }

        if (this.logIsInfoEnabled("relativeDates")) {
            this.logInfo("Returning from convertRelativeDates - result is:\n\n"+
                isc.echoFull(result)+"\n\n"+
                "original criteria is: \n\n"+isc.echoFull(criteria)
                ,"relativeDates"
            );
        }

        return result;
    },

// helper method to map the relative date in a single criterion
    mapRelativeDate : function (criterion, baseDate) {
        var result = isc.addProperties({}, criterion),
            rangeStart,
            value
        ;

        baseDate = baseDate || new Date();
        
        var fieldName = result.fieldName,
        	field = fieldName ? this.getField(fieldName) : null,
        	type = field ? field.type : null
        ;
        
        
        	
        var logicalDate = isc.SimpleType.inheritsFrom(type, "date") && 
        					!isc.SimpleType.inheritsFrom(type, "datetime");
        

        if (result.value && isc.isAn.Object(result.value) && result.value._constructor == "RelativeDate") 
        {
            // we have a criterion with a "value" and it's a relativeDate - parse it now
            value = result.value.value;
            
            var tempValue = isc.DateUtil.getAbsoluteDate(value, baseDate, 
            								result.value.rangePosition, logicalDate || result.value.logicalDate);

            // if the field is a "datetime", we may want to manipulate the criteria a bit, 
            // without losing the relativeDate original, and depending on the operator
            // -----
            // we only want to to this for some of the pre-defined internal relativeDate 
            // strings, those that represent a specific day - $yesterday, $today and $tomorrow 
            if (!logicalDate && ["$yesterday", "$today", "$tomorrow"].contains(value)) {
                switch (result.operator) {
                    case "equals":
                        // equals for a relativeDate needs to do a between dayStart/dayEnd
                        result.operator = "betweenInclusive";
                        result.start = isc.DateUtil.getStartOf(tempValue, "D");
                        result.end = isc.DateUtil.getEndOf(tempValue, "D");
                        delete result.value;
                        break;
                    case "notEqual":
                        // notEqual for a relativeDate needs to do a NOT between dayStart/dayEnd
                        result._constructor = "AdvancedCriteria";
                        result.operator = "not";
                        result.criteria = [
                            { operator: "betweenInclusive", fieldName: result.fieldName,
                                start: isc.DateUtil.getStartOf(tempValue, "D"),
                                end: isc.DateUtil.getEndOf(tempValue, "D")
                            }
                        ];
                        delete result.value;
                        delete result.fieldName;
                        break;
                    case "lessThan":
                    case "greaterOrEqual":
                        // less/greaterOrEqual for a relativeDate needs to do a dayStart
                        result.value = isc.DateUtil.getStartOf(tempValue, "D");
                        break;
                    case "greaterThan":
                    case "lessOrEqual":
                        // startsWith for a relativeDate needs to do a dayEnd
                        result.value = isc.DateUtil.getEndOf(tempValue, "D");
                        break;
                    default:
                        result.value = tempValue;
                }
            } else {
                result.value = tempValue;
            }
        } else {
            if (result.start && isc.isAn.Object(result.start) &&
                result.start._constructor == "RelativeDate")
            {
                // we have a criterion with a "start" and it's a relativeDate - parse it now
                // Always default to start of range for ambiguous shortcuts like "$today"
                value = result.start.value;
                result.start = rangeStart = isc.DateUtil.getAbsoluteDate(value, baseDate,
                									"start", logicalDate || result.start.logicalDate);
            }
            if (result.end && isc.isAn.Object(result.end) && 
                result.end._constructor == "RelativeDate")
            {
                // we have a criterion with an "end" and it's a relativeDate - convert it now
                // Default to end of ambiguous shortcuts like "$today"
                value = result.end.value;
                result.end = isc.DateUtil.getAbsoluteDate(value, baseDate, "end", logicalDate || result.end.logicalDate);
            }
        }

        return result;
    },
    
    
    embedTimezoneInRelativeDates : function (criteria, baseDate) {
        // just bail if passed null criteria
        if (!criteria) return null;
        
        if (!this.criteriaContainsDates(criteria)) {
            // there are no date fields in the criteria - no point continuing, just return it
            return criteria;
        }
        
        if (!this.isAdvancedCriteria(criteria) && criteria.operator == null) {
            // this is neither an AdvancedCriteria nor a simple Criterion object so no point
            // parsing it, just return it as-is
            return criteria;
        }

        // get a copy of the criteria to alter and return - it's ok to use clone() here as 
        // we've already confirmed the param is criteria above
        var result = isc.clone(criteria);

        baseDate = baseDate || new Date();

        if (result.criteria && isc.isAn.Array(result.criteria)) {
            // complex sub-criteria, call this method again with that criteria
            var subCriteria = result.criteria;

            for (var i = subCriteria.length-1; i>=0; i--) {
                var subItem = subCriteria[i];

                if (!subItem) {
                    if (this.logIsInfoEnabled("relativeDates")) {
                        this.logInfo("Removing NULL subCriteria...", "relativeDates");
                    }
                    result.criteria.removeAt(i);
                } else {
                    if (subItem.criteria && isc.isAn.Array(subItem.criteria)) {
                        result.criteria[i] = this.embedTimezoneInRelativeDates(subItem, baseDate);
                    } else {
                        if (subItem.value && isc.isAn.Object(subItem.value) && 
                                        subItem.value._constructor == "RelativeDate")
                        {
                            result.criteria[i].value.browserTZ = isc.Time.getDefaultDisplayTimezone();
                        }
                    }
                }
            }
        } else {
            // simple criterion
            if (result.value && isc.isAn.Object(result.value) && 
                            result.value._constructor == "RelativeDate")
            {
                result.value.browserTZ = isc.Time.getDefaultDisplayTimezone();
            }
        }

        if (this.logIsInfoEnabled("relativeDates")) {
            this.logInfo("Returning from embedTimezoneInRelativeDates - result is:\n\n"+
                isc.echoFull(result)+"\n\n"+
                "original criteria is: \n\n"+isc.echoFull(criteria)
                ,"relativeDates"
            );
        }

        return result;
    },
    
    //> @attr dataSource.autoConvertRelativeDates (Boolean : true : IR)
    // Whether to convert relative date values to concrete date values before sending to the 
    // server.  Default value is true, which means that the server does not need to understand 
    // how to filter using relative dates - it receives all date values as absolute dates.
    // 
    // @serverDS allowed
    // @visibility external
    //<
    
    autoConvertRelativeDates: true,

    //> @attr dataSource.showFieldsAsTree (boolean : false : IR)
    // If set, certain components that show lists of fields from this DataSource (including the
    // +link{FieldPicker}) will show them as a tree.
    // <P>
    // The tree structure is created by using +link{tree.modelType,modelType:"parent"} with the
    // +link{dataSourceField.fieldTreeId} and +link{dataSourceField.fieldTreeParentId} properties.
    //<
    showFieldsAsTree: false,

    //> @attr dataSource.fieldTreeRootValue (boolean : null : IR)
    // Value of +link{tree.rootValue}} used if +link{dataSource.showFieldsAsTree} is true
    //<
    
    
    //> @attr DataSource.autoDiscoverTree (boolean : false : IR)
    //  Causes +link{Tree.discoverTree} to be called on dsResponse.data in order to automatically
    // discover tree structures in the response data.
    // <P>
    // If autoDiscoverTree is set, discoverTree() is called after the default dsResponse.data
    // has been derived (+link{operationBinding.recordXPath,recordXPath} and
    // +link{dataSourceField.valueXPath,valueXPath} have been applied) and after
    // +link{transformResponse()} has been called.
    // <P>
    // If a DataSourceField is declared with
    // +link{dataSourceField.childrenProperty,childrenProperty:true}, discoverTree() will be invoked with
    // +link{discoverTreeSettings.newChildrenProperty,settings.newChildrenProperty} set to the name of
    // the field marked as the childrenField.  Similarly, if the DataSource has a
    // +link{titleField} it will be used as the
    // +link{discoverTreeSettings.nameProperty,settings.nameProperty}.
    //
    // @visibility external
    //<
    autoDiscoverTree: false,

    //> @attr DataSource.discoverTreeSettings (DiscoverTreeSettings : null : IR)
    // Settings to use when discoverTree() is automatcially called because
    // +link{DataSource.autoDiscoverTree} is set to true for this DataSource
    //
    // @visibility external
    //<
    
    //> @attr dataSource.useAnsiJoins (boolean : null : [IR])
    // For DataSources using the +link{group:sqlDataSource,SmartClient SQL engine} for
    // persistence, whether to use ANSI-style joins (ie, joins implemented with JOIN directives
    // in the table clause, as opposed to additional join expressions in the where clause).
    // The default value of null has the same meaning as setting this flag to false.
    // <P>
    // Note, outer joins (see +link{dataSourceField.joinType,joinType}) only work with certain
    // database products if you choose not to use ANSI joins.  Other than that, the join 
    // strategies are equivalent.
    // <P>
    // If you wish to switch on ANSI-style joins for every DataSource, without the need to 
    // manually set this property on all of them, set
    // +link{group:server_properties,server.properties} flag 
    // <code>sql.useAnsiJoins</code> to true.
    // 
    // @group serverDataIntegration
    // @see OperationBinding.includeAnsiJoinsInTableClause
    // @requiresModules SCServer
    // @serverDS only
    // @visibility external
    //<
    

    //> @attr dataSource.trimMilliseconds (boolean : null : IR)
    // For this dataSource, should the millisecond portion of time and datetime values be 
    // trimmed off before before being sent from client to server or vice versa.  By default, 
    // millisecond information is preserved (ie, it is not trimmed).  You only need to consider
    // trimming millisecond values if their presence causes a problem - for example, a custom
    // server that is not expecting that extra information and so fails parsing.
    // <p>
    // Note that there is no inherent support for millisecond precision in SmartClient widgets;
    // if you need millisecond-precise visibility and editability of values in your client, 
    // you must write custom formatters and editors (or sponsor the addition of such things to
    // the framework).  Server-side, millisecond-precise values are delivered to and obtained
    // from DataSources, so DataSource implementations that are capable of persisting and 
    // reading millisecond values should work transparently.  Of the built-in DataSource types,
    // the JPA and Hibernate DataSources will transparently handle millisecond-precise values
    // as long as the underlying database supports millisecond precision, and the underlying 
    // column is of an appropriate type.  The SQLDataSource provides accuracy to the nearest
    // second by default; you can switch on millisecond precision per-field with the 
    // +link{DataSourceField.storeMilliseconds,storeMilliseconds} attribute.
    //
    // @serverDS allowed
    // @visibility external
    //<

    // Used by getFilenameField(), getFilesizeField() and getDateCreatedField()
    _filenameField: {}, 
    _filesizeField: {}, 
    _dateCreatedField: {}
    


});

//> @type ValueMap
// A ValueMap defines the set of legal values for a field, and optionally allows you to provide
// a mapping from stored values to values as seen by the end user.
// <P>
// A valueMap can be specified as either an Array of legal values, or as an +link{type:Object}
// where each property maps a stored value to a user-displayable value.  See
// +link{DataSourceField.valueMap} for how to express a ValueMap in
// +link{group:componentXML,Component XML}.
// <P>
// A ValueMap can be entirely static or entirely dynamic, with many options in between.  For
// example, a ValueMap may be:
// <ul>
// <li> statically defined in a JavaScript or XML file.  Such a valueMap changes only when
// application code is upgraded.
// <li> generated dynamically by server code when the application first loads, for example,
// by generating JavaScript or XML dynamically in a .jsp or .asp file.  Such a valueMap may be
// different for each session and for each user.
// <li> loaded on demand from a DataSource, via the
// +link{PickList.optionDataSource,optionDataSource} property, or via a call to
// +link{dataSource.fetchData()} where a valueMap is derived dynamically from the returned data
// (see +link{dataSource.fetchData()} for an example).  Such a valueMap may be updated at any
// time, for example, every time the user changes a related field while editing data.
// </ul>
// See also the +link{group:smartArchitecture,SmartClient Architecture Overview} to understand
// the best architecture from a performance and caching perspective.
// @serverDS allowed
// @visibility external
//<

//> @object DataSourceField
// Metadata about a DataSourceField, including its type and validators.
// @treeLocation Client Reference/Data Binding/DataSource
// @serverDS allowed
// @visibility external
//<

//> @groupDef basics
// Basic definition of a DataSource field
// @visibility external
//<

//> @type FieldName
// Name for a field.
// <P>
// Must be unique across all fields within its container as well as a valid JavaScript
// identifier, as specified by ECMA-262 Section 7.6.
// <P>
// <B>NOTE:</B> The <smartclient>+link{String.isValidID()}</smartclient>
// <smartgwt>StringUtil.isValidID()</smartgwt>
// function can be used to test whether a name is a valid JavaScript identifier.
// @baseType String
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.name (FieldName : null : [IR])
// Name for this field.  
// <P>
// Must be unique across all fields within the DataSource as well as a valid JavaScript
// identifier - see +link{FieldName} for details and how to check for validity.
// <P>
// The field name is also the property in each DataSource record which holds the value for this
// field.
//
// @group basics
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.type                 (FieldType : null : [IR])
// Type of this field.  Required for all DataSource fields.
// <P>
// Field type may imply automatic validators (for example, an integer field cannot accept the
// value "foo").  Field type also affects the default behaviors of DataBound components, for
// example, if a field is declared as type "date", components that edit that field will
// automatically choose a date-editing interface with pop-up date picker.
// @group basics
// @serverDS allowed
// @visibility external
//<


//> @attr dataSourceField.mimeType (String : null : IR)
// For a +link{group:binaryFields,binary field}, sets a fixed mime type for all files stored
// to this field.  Should be set to a standard mime type string, for example, "text/plain" for
// a .txt file.
// <P>
// This is useful if a binary field only stored one type of file and you chose not to store 
// filenames, since the extension of the file name is normally used to determine the mime type.
// @serverDS only
// @visibility external
//<

// Validation
// --------------------------------------------------------------------------------------------

//> @attr dataSourceField.required             (boolean : null : [IR])
// Indicates this field must be non-null in order for a record to pass validation. Or, in the
// case of a "binary" field, a non-empty file must be uploaded.  Setting this property has the
// same effect as giving the field a +link{type:ValidatorType,"required" validator}. 
// <P>
// Note that <code>required</code> should not be set for a server-generated field, such as a
// sequence, or validation will fail on the client.
// <h3>Conditionally required fields</h3>
// Adding an +link{Validator.applyWhen,applyWhen} condition to a <code>required</code> 
// validator introduces subtle complexities to the process of validating an existing record.  
// The client is not guaranteed to know the the full and complete state of the record it is 
// editing because it is common for a +link{class:DynamicForm} to be editing a subset of
// fields.  When a field is <i>unconditionally</i> required, things are simple: if the 
// DynamicForm has a +link{FormItem} for that field, then the <code>required</code> validation
// passes if that FormItem has a value, and fails if it does not.  If the form has no FormItem
// for the field, it can assume that the field has a value because otherwise it would have 
// failed validation when we attempted to add it (when we are adding a record, we of course do 
// know the full and complete state of the record - it is whatever we are about to add).
// <p>
// When a field is <i>conditionally</i> required, the client can no longer assume that all 
// required fields will have a value.  It may be the case that the condition of requirement 
// was not met when the record was added, but now it is.  For example, consider these field
// definitions:<pre>
//    &lt;field name="yearsAtCurrentAddress" type="integer" /&gt;
//    &lt;field name="previousAddress" type="text" &gt;
//      &lt;validator type="required" errorMessage="Previous address is required if you have been at your current address less than three years"&gt;
//        &lt;applyWhen operator="and"&gt;
//          &lt;criteria&gt;
//            &lt;criterion fieldName="yearsAtCurrentAddress" operator="lessThan" value="3" /&gt;
//          &lt;/criteria&gt;
//        &lt;/applyWhen&gt;
//      &lt;/validator&gt;
//    &lt;/field&gt;
// </pre>
// Imagine a record for this DataSource is added where the user has entered a value of "3" for 
// "yearsAtCurrentAddress", and no previous address.  Later, the value of that field is 
// changed to "2".  If this is done using a form that is also showing the "previousAddress" 
// field, we will know that "previousAddress" has not been provided, so we can fail the 
// validation and the user will get a helpful error message explaining what the problem is.
// <p>
// However, if the form does not also show the "previousAddress" field, we may choose to use an
// +link{class:operationBinding} that uses +link{operationBinding.outputs,outputs} to trim the
// record down to just the fields the form does contain, in the interests of avoiding 
// information leakage.  Or perhaps that value is automatically culled from the record before
// the client sees it by the application of a +link{dataSourceField.viewRequires,declarative security rule}.
// Whatever the reason, if the client does not have the complete record, it is not possible 
// for the client to sensibly apply this validation.  And because the client has no way of 
// knowing if a value is missing because it is genuinely null, or because it has been trimmed
// away by the server, we must treat any null value with suspicion (unless it has a matching 
// FormItem - the presence of the FormItem means that the user can edit the value, so it 
// would make no sense to pair it with a trimmed record that excludes that field value).
// <p>
// When this happens, we mark the validation as having passed on the client, but in need of 
// running on the server.  The server validation makes use of the "storedRecord" facility 
// (look for the description of <b>$storedRecord</b> in the 
// +link{group:velocitySupport,Velocity support overview}) to overlay the changed record on
// top of the existing record as it currently exists in the database.  This gives the validator
// the complete record including both changed and unchanged values, so it is able to carry 
// out the required check in a meaningful way.  However, you should be aware that the 
// combination of conditional "required" validators and DynamicForms that edit partial 
// records can result in a validation that cannot run on the client and must do both a server 
// roundtrip and a database fetch.
// @see Validator.applyWhen
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.requiredMessage (String : null : [IRW])
// The required message when a field that has been marked as
// +link{DataSourceField.required,required} is not filled in by the user.
// <p>
// Note that this setting wins over +link{dataSource.requiredMessage} if both are set.
// @group formTitles
// @visibility external
//<

//> @attr dataSourceField.autoGenerated        (boolean : null : [IR])
// Indicates that values for this field are automatically generated by the database or ORM 
// provider.  Setting this flag makes the field behave somewhat like a 
// +link{sequenceName,sequence field}, in that server-side logic does not expect client code
// to provide values for the field on "add" operations.  However, it is not entirely the same
// as a sequence:<ul>
// <li>Sequences must be integers, whereas autoGenerated fields can be of any type</li>
// <li>SmartClient Server's DataSource implementations are capable of discovering the value 
//     that was generated by the database for sequence fields, which may not be possible 
//     with an autoGenerated field.  See the docs for 
//     +link{dataSourceField.customInsertExpression,customInsertExpression} for a discussion
//     of this</li>
// </ul>
// Unrelated to the <code>autoGenerated</code> flag, you have a general ability for field 
// values to be generated by application code (as opposed to being generated by the database
// or ORM provider).  For example, you can use +link{group:dmiOverview,DMI methods}, 
// +link{group:serverScript,server scripts}, or +link{group:customQuerying,custom SQL}.  (Note, 
// if you want to have application code generate values for primaryKey fields, you may need to
// use an +link{OperationBinding,operationBinding} that specifies 
// +link{operationBinding.providesMissingKeys,providesMissingKeys}). 
// @group dataType
// @see sequenceName
// @see type:FieldType
// @see type:SequenceMode
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.nillable             (boolean : null : IR)
// Controls whether an explicit null-valued Record attribute for this field
// should result in <code>xsi:nil</code> being used to transmit the value when serializing
// to XML, like so:
// <pre>
// &lt;book&gt;
//     &lt;title&gt;Beowulf&lt;/title&gt;
//     &lt;author xsi:nil="true"/&gt;
// &lt;/book&gt;
// </pre>
// If <code>nillable</code> is not set, no XML element will be generated for
// the explicit null value.
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.valueMap             (ValueMap : null : [IR])
// A +link{type:ValueMap} is a set of legal values for a field.
// <p>
// The valueMap can be specified as either an Array of legal values, or as an
// +link{type:Object} where each property maps a stored value to a user-displayable value.
// <p>
// To enforce that a field should be constrained to only the values in the valueMap, either
// declare +link{dataSourceField.type,field.type} as "enum", or use a
// +link{ValidatorType} of "isOneOf" with explicitly listed values.  Otherwise,
// although a normal +link{SelectItem} control will only allow values from the valueMap to be
// entered, other controls such as a +link{ComboBoxItem,ComboBox} will allow other values 
// to be entered.
// <p>
// In XML, a valueMap that specifies only a list of legal values is specified as follows:
// <pre>
//   &lt;valueMap&gt;
//   	&lt;value&gt;Pens &amp; Pencils&lt;/value&gt;
//   	&lt;value&gt;Stationery&lt;/value&gt;
//   	&lt;value&gt;Computer Products&lt;/value&gt;
//   	&lt;value&gt;Furniture&lt;/value&gt;
//   	&lt;value&gt;Misc&lt;/value&gt;
//   &lt;/valueMap&gt;
// </pre>
// A ValueMap that specifies stored values mapped to user-visible values is specified as
// follows:
// <pre>
//   &lt;valueMap&gt;
//   	&lt;value ID="1"&gt;Pens &amp; Pencils&lt;/value&gt;
//   	&lt;value ID="2"&gt;Stationery&lt;/value&gt;
//   	&lt;value ID="3"&gt;Computer Products&lt;/value&gt;
//   	&lt;value ID="4"&gt;Furniture&lt;/value&gt;
//   	&lt;value ID="5"&gt;Misc&lt;/value&gt;
//   &lt;/valueMap&gt;
// </pre>
// 
// @group dataType
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.valueMapEnum (String : null : IR)
// Fully qualified Java className of an Enum that should be used to derive this field's
// +link{valueMap}.
// <P>
// This has the same behavior of auto-deriving a <code>valueMap</code> from a Java Enum as
// +link{DataSource.autoDeriveSchema} except it applies only to one field.
// <P>
// If you enable <code>autoDeriveSchema</code> there is no need to set
// <code>valueMapEnum</code> for Enum fields unless you want to actually <i>override</i> the
// behavior to use a different Enum for the field (eg, a superclass Enum that is more
// restrictive).
//
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.validators           (Array of Validator : null : [IR])
// Validators to be applied to this field.
// <p>
// Validators are applied whenever there is an attempt to save changes to a field.
// <p>
// For the available set of built-in validators, and how to define a custom validator, see the
// +link{class:Validator} class.
//
// @see class:Validator
// @group dataType
// @group validation
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.length               (number : null : [IR])
// Maximum number of characters allowed.  Applicable only to fields of text type.
// For fields of this type a +link{ValidatorType,length range validator} will be automatically
// generated on both the client and server side to enforce this maximum length
// (unless such a validator is explicitly present for the field already).
// <P>
// The +link{TextItem.enforceLength} attribute can also 
// explicitly limit user input for freeform text items editing fields with an explicit
// length specified.
// <P>
// <b>NOTE:</b> For DataSources of type "sql", this property has a bearing on the type of 
// column we use when the underlying table is created by a DataSource 
// +link{group:sqlDataSource,import} in the +link{group:adminConsole,Admin Console}.  Below 
// a certain length (which is database-specific, see below), we use standard <code>VARCHAR</code>
// columns; above that length, we use an alternate strategy (again, database-specific).  For 
// these long fields, we sometimes also generate different SQL for "update" and "add" 
// operations, using JDBC "?" replacement parameters rather than embedding values directly in 
// the generated SQL; whether or not this is done depends entirely on what the underlying 
// database product and/or JDBC driver will allow.
// <P><br>
// <b>Table of field length limits for supported databases:</b><p>
// <table style="font-size:10px;text-align:center;border:1px solid black;">
// <tr><td style="color:white;background-color:black;"><b>Database product</b></td>
//     <td style="color:white;background-color:black;"><b>VARCHAR limit *</b></td>
//     <td style="color:white;background-color:black;"><b>Type used above limit</b></td></tr>
// <tr><td>HSQLDB</td><td>None</td><td>-</td></tr>
// <tr><td>IBM DB2</td><td>4000</td><td>CLOB</td></tr>
// <tr><td>Firebird</td><td>32767</td><td>BLOB with subtype 1</td></tr>
// <tr><td>Informix</td><td>255 / 32739</td><td>LVARCHAR / TEXT ** </td></tr>
// <tr><td> Microsoft SQL Server </td><td>8000</td><td>TEXT</td></tr>
// <tr><td>MySQL</td><td> 255 / 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr>
// <tr><td>MariaDB</td><td> 255 / 65535 / 16M </td><td> TEXT / MEDIUMTEXT / LONGTEXT *** </td></tr>
// <tr><td>Oracle</td><td>4000</td><td>CLOB</td></tr>
// <tr><td>PostgreSQL</td><td>4000</td><td>TEXT</td></tr>
// </table><br>
// <b>*</b> The "VARCHAR limit" referred to here is a limit used by the SmartClient Server; it
// is not necessarily imposed by the database.  For example, DB2's VARCHAR limit is not 4000
// characters; it actually varies from about 4K to about 32K, depending on how the server has 
// been configured.<p>
// <b>**</b> Informix has a limit of just 255 characters for VARCHAR, but has a native LVARCHAR
// type which supports nearly 32K characters without needing to fall back on long datatypes. 
// Therefore, with that one product, we have two thresholds for a change in storage type.<p>
// <b>***</b> MySQL has a limit of 255 characters for VARCHAR, 65,535 characters for TEXT and 
// 16,777,215 for MEDIUMTEXT; therefore, with that one product, we have three thresholds for a 
// change in storage type.
// @group dataType
// @serverDS allowed
// @see listGridField.width
// @visibility external
// @example longText
//<

// XML
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.valueXPath      (XPathExpression : null : [IR])
// XPath expression used to retrieve the field's value.
// <P>
// This XPath expression will be evaluated in the scope of the record objects selected by 
// the +link{dataSource.recordXPath}.  For XML data 
// (+link{DataSource.dataFormat,dataFormat:"xml"}) this means a call to
// +link{XMLTools.selectString()} passing the selected XML element.  For JSON data
// (+link{DataSource.dataFormat,dataFormat:"json"}), this means a call to 
// +link{XMLTools.selectObjects()} passing the selected JSON object.
// <P>
// In the absence of a <code>valueXPath</code>, for JSON data the value for the field will
// be the value of the same-named property in the record object selected by
// +link{DataSource.recordXPath,recordXPath}.  
// <P>
// For XML data, the value will be the attribute or subelement named after the field name.
// For example, for a field "author" on a record element &lt;book&gt;, the following structures
// require no valueXPath:
// <pre>
//    &lt;book author="Mark Jones"/&gt;
//
//    &lt;book&gt;
//        &lt;author&gt;Mark Jones&lt;/author&gt;
//    &lt;/book&gt;
// </pre>
// <P>
// If <code>valueXPath</code> is not required for your field because of the default handling
// described above, don't specify it, as it's slightly slower.
// <p>
// To learn about XPath, try the following search:
// <a href="http://www.google.com/search?q=xpath+tutorial" target="_blank"
// >http://www.google.com/search?q=xpath+tutorial</a>
// <P>
// <B>Using valueXPath with the SmartClient server</B>
// <p>
// If you're using the SmartClient server to return data via the DSResponse object (or
// indirectly doing so using DataSource DMI), the valueXPath you specify on the DataSource
// fields will be applied to the data you return via the 
// +externalLink{http://commons.apache.org/jxpath/,JXPath} library.<br>
// See also the server side Java APIs <code>DataSource.setProperties()</code> and 
// <code>DSResponse.setData()</code>.
// <P>
// If you are returning Java Beans as your DSResponse data, normally each dataSource field
// receives the value of the same-named Java Bean property, that is, a field "zipCode" is
// populated by looking for "getZipCode()" on the objects passed as DSResponse data.  You can
// use <code>valueXPath</code> to retrieve properties from subobjects, so long as a chain of
// getter methods exists that corresponds to the valueXPath.  For example, a valueXPath of
// "address/zipCode" expects to call "getAddress()" on the bean(s) passed to
// DSResponse.setData(), followed by "getZipCode()" on whatever object "getAddress()" returns.
// <P>
// When you are saving data, the inbound DSRequest values, available as a Java Map, will use 
// just dataSource field names as Map keys, not the valueXPath used to derive them.  However,
// to achieve bidirectional valueXPath binding, you can use the server-side method
// dataSource.setProperties() to use the valueXPath when setting properties on your server
// object model.  When applied as a setter, an XPath like "address/zipCode" attempts
// "getAddress()" followed by "setZipCode()" on the returned object.  JXPath also has some
// ability to auto-create intervening objects if they are missing, such as auto-creating an
// "address" subobject when applying "address/zipCode" as a valueXPath.
// <P>
// See the
// +externalLink{http://jakarta.apache.org/commons/jxpath/,JXPath} library documentation for
// complete details, including other types of server object models supported, such as
// server-side XML.
//
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
// @example xpathBinding
//<

//> @attr dataSourceField.valueWriteXPath      (XPathExpression : null : [IR])
// Alternative XPath expression used to set the field's value.
// <P>
// If is not set, then +link{DataSourceField.valueXPath,dataSourceField.valueXPath} is
// used, see its description for details.
// <P>
// See also SmartClient server java APIs <code>DataSource.setProperties()</code> and
// <code>DSResponse.setData()</code>.
//
// @group clientDataIntegration
// @serverDS only
// @visibility xmlBinding
//<

//> @attr dataSourceField.getFieldValue (GetFieldValueCallback : null : IRA)
// A +link{Callback}, function, or JavaScript expression used to retrieve the field's value from
// the XML element or JSON record returned from a web service.
// <P>
// This is an advanced attribute for use when a +link{dataSourceField.valueXPath,valueXPath}
// setting is insufficient to derive a field's value, yet an implementation of
// +link{DataSource.transformResponse()} is overkill.
// <P>
// For the required parameters, see the documentation for
// +link{Callbacks.GetFieldValueCallback,GetFieldValueCallback}.
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
//<

//> @method Callbacks.GetFieldValueCallback
// +link{Callback} required for the property +link{dataSourceField.getFieldValue}.
//
// @param record (Object | XMLElement) record object selected from web service response data
//                                     by +link{operationBinding.recordXPath,recordXPath}
// @param value (Any) default value derived by the method described in
//                    +link{dataSourceField.valueXPath}
// @param field (DataSourceField) DataSourceField definition
// @param fieldName (FieldName) name of the DataSource field
//
// @group clientDataIntegration
// @serverDS allowed
// @visibility xmlBinding
//<

//> @attr dataSourceField.lenientXPath (boolean : null : IR)
// Indicates that getting +link{dataSourceField.valueXPath} for this field should
// not perform any validation at all and will return null for non existing XPaths.
// Otherwise warning message will be logged for non-existing XPath or with null objects
// in the middle of XPath.
// <P>
// NOTE: this applies to server-side processing of valueXPath only.
//
// @serverDS allowed
// @visibility external
// @deprecated No longer needs to be set since the framework now defaults to suppressing errors 
// for null values in the middle of Xpath, and only invalid XPath will cause warning be logged.
//<

// Component Binding
// --------------------------------------------------------------------------------------------

//> @groupDef componentBinding
// Properties that control how a DataBound Component binds to this DataSource
// @title Component Binding
// @visibility external
//< 

//> @attr dataSourceField.title                (String : null : [IR])
// Default user-visible title for this field.
// <p>
// This will be picked up by DataBound components and other views over this DataSource.
// <p>
// Note this property frequently does not need to be set since +link{DataSource.autoDeriveTitles} (on by
// default) usually picks an appropriate user-visible title if you have a reasonable naming convention
// for your field names.
// <P>
// Note that if this field is being displayed in a +link{ListGrid} bound to this dataSource,
// the +link{listGridField.headerTitle} attribute may be used to specify a
// different string for display in the listGrid column header.
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.escapeHTML	(Boolean : null : [IR])
// When data values are displayed in DataBound components, by default strings will be interpreted
// as HTML by the browser in most cases.
// <P>
// If set, this property will be picked up by components bound to this dataSource, notifying them
// that any HTML characters should be escaped when displaying values for this field. 
// @see ListGridField.escapeHTML
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canView              (boolean : null : [IR])
// If false, this property indicates that this field is considered "server only".  This means:
// <ul>
// <li>Components cannot bind to the field; even if you explicitly add a field with the same 
//     name to your +link{DataBoundComponent,dataBoundComponent}, it will be dropped</li>
// <li>If you are using SmartClient Server, the client will never be sent a value for the 
//     field</li>
// <li>If you are using SmartClient Server, then similar to +link{canEdit,canEdit}, no updates
//     to the field are allowed from the client.  If you explicitly add a value for the field 
//     to, eg, a record you are passing to +link{dataSource.updateData}, the server will strip
//     the value out of the record before processing the update request.
// </ul>
// <code>canView:false</code> is <b>not</b> the same thing as +link{hidden,hidden}.  Use 
// <code>canView:false</code> when you want to prevent the client from ever seeing a field's 
// definition or values; use <code>hidden:true</code> if it is fine from a security perspective
// that a field's definition and values are sent to the browser, but the field should not by
// default appear in user interface elements (but could do in some cases, like a special screen
// for advanced users or administrators, for example).
// <p>
// Note that this property must be set explicitly to false to have an effect; a null or 
// undefined setting is treated the same as true.
// <P>
// This property is used to implement field-level view security: failing a 
// +link{viewRequiresAuthentication,viewRequiresAuthentication}, 
// +link{viewRequiresRole,viewRequiresRole} or +link{viewRequires,viewRequires} test is 
// equivalent to setting <code>canView:false</code> on the field (and, indeed, from the 
// client's perspective, the field <em>has</em> had <code>canView:false</code> set).
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canEdit              (boolean : null : [IR])
// Controls whether, by default, DataBoundComponents consider this field editable. 
// Set to <code>false</code> to draw this field read-only.  
// <p>
// For a field that should never be changed from the UI, consider using +link{canSave} instead,
// which will both mark a field as non-editable and reject any attempt to programmatically
// change the value on the server (when using the SmartClient Server).
// <P>
// This attribute may not effect all dataBoundComponents - the 
// +link{databoundComponent.canEditFieldAttribute} may be set at the component level to look
// for a different attribute on the dataSourceField, and components allow developers to explicitly
// override this default (see +link{ListGridField.canEdit}. +link{FormItem.canEdit} for example).
//
// @group componentBinding
// @see dataSourceField.canFilter
// @see dataSourceField.canSave
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canSave (boolean : null : [IR])
// Whether values in this field can be updated and saved to the dataSource.
// <P>
// If set to <code>false</code>, this field will default to being non-editable in standard editing
// components (+link{DynamicForm}, editable +link{ListGrid}), but will be editable when displayed
// for filtering purposes only (in a +link{SearchForm} or +link{ListGrid.showFilterEditor,ListGrid
// filter editor}.  If +link{dataSourceField.canEdit,canEdit} is explicitly specified it will take 
// precedence over this client-side behavior, but the server will still enforce the no-save
// policy (described below).
// <p>
// NOTE: If you are using SmartClient Server and have specified <code>canSave: false</code> 
// for a field in a DataSource definition (<code>.ds.xml</code> file), this is enforced on 
// the server.  This means that we will strip out any attempt to set the value of such a 
// field before trying to process any update or add request, similar to what happens when 
// a +link{editRequiresAuthentication,field-level declarative security check} fails.
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canFilter (boolean : null : IR)
// Should the user be able to filter data by this field?
// Affects whether this field will show up in dataBoundComponents with UI for filtering data.
// <P>
// Note that setting <code>canFilter:false</code> only affects UI and is not a security
// feature.  Enforcing that filtering cannot be performed server side does not meaningfully
// increase security, since as long as a field can be viewed by an end user, they can
// effectively search the field themselves even if the UI doesn't offer a means to do so.
// If a field should be unable to be viewed entirely by some users, use 
// +link{dataSourceField.viewRequiresRole} and related settings.
// <P>
// Rather than a security setting, <code>canFilter:false</code> is intended for situations
// where it would be redundant or nonsensical to be able to search on a field, or where
// searching isn't implemented for that field.
//
// @see SearchForm.showFilterFieldsOnly
// @see SearchForm.canEditFieldAttribute
//
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.editorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used whenever this field is edited (whether in a grid, form,
// or other component).
// <P>
// If unset, a FormItem will be automatically chosen based on the type of the field, by the
// rules explained +link{type:FormItemType,here}.
// 
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.readOnlyEditorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used if this field is marked as 
// +link{dataSourceField.canEdit,canEdit false} and displayed in an editor component such
// as a DynamicForm.
// <P>
// This property may also be specified at the type level by specifying 
// +link{SimpleType.readOnlyEditorType}.
// 
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.filterEditorType (FormItemClassName : null : [IR])
// Sets the default FormItem to be used for this field if it appears in a filter row,
// and +link{canFilter} is not false.
// <P>
// Note: If this is not specified, the edit-formItem type may be derived from the
// +link{editorType} property, or from the field's +link{type}.
// 
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.displayFormat        (DateDisplayFormat : null : [IR])
// The default date formatter to use for displaying this field.  Only applicable to fields of 
// type "date" and "datetime".  Note that this property is honored when exporting directly to 
// Excel spreadsheets (ie, when using XLS or XLSX/OOXML form, <b>not</b> CSV); "date" and
// "datetime" fields with this property set will deliver real dates and formatting information
// to Excel, rather than formatted strings or unformatted dates.
// 
// @serverDS allowed
// @visibility external
// @deprecated Use +link{dataSourceField.dateFormatter} or +link{dataSourceField.timeFormatter}
//   instead.
//<

//>	@attr dataSourceField.dateFormatter (DateDisplayFormat : null : [IRWA])
// Preferred display format to use for date type values within this field.
// If this property is set on a field displayed in a databound component such as a
// +link{DynamicForm} or +link{ListGrid} it will be respected (See +link{formItem.dateFormatter} and
// +link{listGridField.dateFormatter}).
// <P>
// Note that this property is also honored when exporting directly to 
// Excel spreadsheets (ie, when using XLS or XLSX/OOXML form, <b>not</b> CSV); "date" and
// "datetime" fields with this property set will deliver real dates and formatting information
// to Excel, rather than formatted strings or unformatted dates.
// 
// @group appearance
// @visibility external
//<
//dateFormatter:null

//>	@attr dataSourceField.timeFormatter (TimeDisplayFormat : null : [IRWA])
// Preferred time-format to apply to date type values within this field.  If this property is
// specified on a field displayed within a dataBound component such as a +link{listGrid} or
// +link{dynamicForm}, any dates displayed in this field will be formatted as times using the
// appropriate format.
// <P>
// This is most commonly only applied to fields specified as type <code>"time"</code> though
// if no explicit +link{formItem.dateFormatter} is specified it will be respected for other 
// fields as well.
// <P>
// See +link{listGridField.timeFormatter} and +link{formItem.timeFormatter} for more information.
//
// @group appearance
// @visibility external
//<
//timeFormatter:null

//> @attr dataSourceField.decimalPrecision (number : null : [IRW])
// Applies only to fields of type "float" and affects how many significant digits are shown.
// <P>
// For example, with decimalPrecision 3, if the field value is 343.672677, 343.673 is shown.
// <P>
// If the value is 125.2, 125.2 is shown - decimalPrecision will not cause extra zeros to be
// added.  Use +link{dataSourceField.decimalPad} for this.
// <P>
// A number is always shown with its original precision when edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.decimalPad (number : null : [IRW])
// Applies only to fields of type "float" and enforces a minimum number of digits shown after
// the decimal point.
// <P>
// For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10
// if decimalPad is 2.
// <P>
// The original unpadded value is always shown when the value is edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.precision (number : null : [IRW])
// Applies only to fields of type "float" or "integer" and affects how many significant
// digits are shown.
// <P>
// For example, a field value of 343.1, 343.104 and 343.09872677 would all be shown as 343.10
// if precision is 5.
// <P>
// The original value is always shown when the value is edited.
//
// @group appearance
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.hidden (boolean : false : [IR])
// Whether this field should be hidden from users by default within a DataBound component.
// This is generally used for internal IDs and other fields not meaningful to users.
// <P>
// See +link{dataSourceField.detail} for fields that should be hidden in a summary view such as
// a +link{ListGrid}, but still available to the user.
// <p>
// <b>NOTE:</b> This property is <b>not</b> a security setting - data for hidden fields is 
// still delivered to the client, it just isn't shown to the user.  If you wish to make sure 
// that only appropriate data reaches the client, use +link{operationBinding.outputs},
// +link{canView}:false on the field, or a field-level declarative security setting like 
// +link{dataSourceField.viewRequiresRole}.
// 
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.ignore (boolean : false : [IR])
// Whether this field should be completely excluded from this dataSource, as if it had never been
// defined.
// <P>
// If set to true, the field will be entirely omitted when serving a DataSource derived 
// from a server-side definition (typically a .ds.xml file) to the client.
// 
// @group componentBinding
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.detail (boolean : false : [IR])
// Whether this field should be considered a "detail" field by a +link{DataBoundComponent}.
// <P>
// Detail fields won't be shown by default in a DataBoundComponent where 
// +link{DataBoundComponent.showDetailFields} is false.  This allows for some DataBound
// components, like a +link{ListGrid}, to show a summary view of records which displays only 
// the most commonly viewed fields by default, while other DataBoundComponents, like a
// +link{DetailViewer}, show all fields by default.
// <P>
// In addition, the +link{formItem.showIf,formItem.showIf} property is supported in multiple
// components for conditional visibility - see for example +link{listGridField.showIf} and
// +link{formItem.showIf}).
//
// @group componentBinding
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.excludeFromState (Boolean : null : IR)
// If true, then this field is excluded from the bound component's view state. In addition,
// the field will not be selected as the default title field
// by +link{DataBoundComponent.getTitleField()}
// if +link{DataBoundComponent.titleField} is not provided.
// @group viewState
// @visibility external
//<

 
//> @attr dataSourceField.excludeFromFieldPicker (Boolean : null : IR)
// If true, then this field is excluded from the +link{listGrid.useAdvancedFieldPicker,field picker}.
// Can also be set to false when +link{excludeFromState} is true to show the field in
// the field picker when it would normally be suppressed.
//<

//> @attr dataSourceField.emptyDisplayValue (HTMLString : null : [IR])
// Text to be used for display by client-side components when this field has a null or 
// undefined value.  This value will be overridden by a component's emptyCellValue, if set. 
//
// @group appearance
// @see formItem.emptyDisplayValue
// @see listGridField.emptyCellValue
// @see detailViewerField.emptyCellValue
// @serverDS allowed
// @visibility external
//<

// Relations
// --------------------------------------------------------------------------------------------

//> @groupDef dataSourceRelations
// Properties for declaring relations between DataSources and within DataSources, such as
// master-detail relationships (a SalesOrder contains 0 or more OrderItems) and tree
// relationships (records can be linked by a parentId field).
//
// @see DataSourceField.foreignKey
// @title Relations
// @visibility external
//<

//> @attr dataSourceField.primaryKey           (boolean : false : [IR])
// Indicates <b>either</b> that this field holds a value unique across all records in this
// DataSource, <b>or</b> that it is one of a number of fields marked as primary keys, and the
// combination of the values held in all of those fields is unique across all records in the
// DataSource.  Note that the latter usage - so-called "composite" or "multipart" keys - is 
// intended for support of legacy databases only: if you are able to choose an approach, 
// Isomorphic recommends the use of one <code>primaryKey</code> field per DataSource, and 
// ideally this field should be of +link{dataSourceField.type,type} "sequence".  If you have
// control of the underlying tables, there is nothing to stop you from adding a field like 
// this (a so-called "synthetic" or "surrogate" key), even for tables that already have a set
// of columns that could combine to make a composite key (a so-called "natural" key).  Also,  
// it is neither necessary nor correct to use a composite primaryKey because you want to 
// enforce uniqueness across that combination of fields.  You can achieve that by declaring
// a unique constraint in the table schema, or use an +link{type:ValidatorType,isUnique} 
// validator with <code>validator.criteriaFields</code>, or both; there is no need to use a 
// composite key to enforce uniqueness
// <p>
// Note that composite primaryKeys are not supported in tree-structured datasets 
// (+link{class:Tree} and +link{class:ResultTree}) or components (+link{class:TreeGrid}, 
// +link{class:ColumnTree}).  Tree-structured data requires that nodes have a unique 
// +link{Tree.idField,idField}, with the parent/child relationship expressed through the 
// +link{Tree.parentIdField,parentIdField}.  This implies that binding a Tree to a DataSource
// requires that the DataSource have a singular primaryKey, and that the primaryKey field is 
// also the idField, as described in the +link{group:treeDataBinding,tree databinding overview}
// <p>
// A DataSource that can <i>only</i> perform the "fetch" operation does not require a
// primaryKey unless it contains +link{group:binaryFields,binary fields}.  If a DataSource 
// allows modification of DataSource records through add, update and remove DataSource 
// operations, or it contains one or more binary fields, one or more fields must be marked as 
// the primary key.
// <P>
// SmartClient requires a primary key value to uniquely identify records when communicating
// updates or deletions to the server.  There is no requirement that the primaryKey field be
// mapped to an actual "primary key" in your object model, web service, or database (though 
// this is the most obvious and natural thing to do, of course).  The only requirement is 
// that the combined values of the primaryKey fields be unique for a given browser instance
// for the lifetime of the page.  
// <P>
// If using SmartClient's +link{group:sqlDataSource,SQL engine} and generating SQL tables using
// the +link{group:dbConfigTool,Database Configuration Tool}, the table column generated from a
// primaryKey field will have a unique constraint applied in the database table and, if the field
// is of type "sequence", the database column will also be created as an "identity column" in those
// databases that implement sequence-type handling with identity columns.
//
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.foreignKey           (String : false : [IR])
// Declares that this field holds values that can be matched to values from another DataSource
// field, to create a relationship between records from different DataSources or even records
// within the same DataSource.
// <p>
// The format of <code>foreignKey</code> is
// <code><i>dataSourceId</i>.<i>fieldName</i></code>.
// <p>
// For a foreignKey within the same dataSource, you can omit the <code>dataSourceId</code>
// and just specify <code><i>fieldName</i></code>.  For example, to create a tree relationship
// within a DataSource:
// <smartclient>
// <pre>
//   isc.DataSource.create({
//     ID:"supplyItem",
//     fields : [
//       {name:"itemId", type:"sequence", primaryKey:true},
//       {name:"parentId", type:"integer", foreignKey:"itemId"},
//       ...
//     ]
//   });
// </pre>
// </smartclient>
// <smartgwt>
// <pre>
//      DataSource supplyItem = new DataSource();
//      DataSourceField itemId = new DataSourceField();
//      itemId.setType(FieldType.SEQUENCE);
//      itemId.setPrimaryKey(true);
//      DataSourceField parentId = new DataSourceField();
//      parentId.setType(FieldType.INTEGER);
//      parentId.setForeignKey("itemId");
//      supplyItem.setFields(itemId, parentId);
// </pre>
// </smartgwt>
// <P>
// <code>foreignKey</code> declarations also allow other automatic behaviors by
// +link{DataBoundComponent,DataBoundComponents}, such as +link{listGrid.fetchRelatedData()}.
// <p>
// For SQLDataSources foreign keys can be automatically discovered from SQL tables if
// +link{dataSource.autoDeriveSchema,autoDeriveSchema} is set.
//
// @see dataSourceField.joinType
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.childrenProperty (Boolean : false : [IR])
// If true, this property indicates that this field will hold an explicit array of child nodes 
// for the current node.
// This has the same effect as specifying +link{dataSource.childrenField} to this field's 
// name.
// @see dataSource.childrenField
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
// @example treeLoadXML
//<


//> @attr dataSourceField.rootValue            (Any : null : [IR])
// For a field that is a foreignKey establishing a tree relationship, what value indicates a
// root-level node.  Defaults to null.
// <P>
// Note that the rootValue may be overridden on a specific ResultTree instance by setting
// +link{ResultTree.rootNode}, or if the ResultTree is auto-generated by a +link{TreeGrid},
// by setting +link{TreeGrid.treeRootValue}. This allows a component to navigate a subtree of
// the hierarchical data from this dataSource starting at a particular node.
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
// @example treeLoadXML
//<

//> @attr dataSourceField.sequenceName (String : null : IR)
// For a DataSource with +link{dataSource.serverType,serverType:"sql"} with a field of type
// "sequence", the name of the SQL sequence that should be used when inserting new records into
// this table.
// <P>
// Note that this is never required for SQL tables that are generated from SmartClient
// DataSources (a default sequence name of tableName + "_" + columnName is chosen, but see the
// notes below regarding this), and is never required for databases where inserting null into a 
// sequence column is sufficient (MySQL, SQL Server, DB2 and others). 
// <P>
// You would only need to set sequenceName if you are integrating with a pre-existing table
// stored in a database where the sequence must be named for insertion to work (Oracle,
// Postgres, Firebird) OR you are trying to use the same sequence across multiple DataSources.
// <P>
// <b>Note:</b> If you specify the <code>sql.{database type}.sequence.name.prefix</code> and/or 
// <code>sql.{database type}.sequence.name.suffix</code> properties in your 
// +link{group:server_properties,server.properties} file,the generated sequence name will include the prefix and/or
// suffix.  For example, with a prefix of "order_system_" and a suffix of "_seq", the sequence
// generated for column "orderNumber" on table "orders" would be:<pre>
//     order_system_orders_orderNumber_seq
// </pre>
//
// @group sqlDataSource
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.implicitSequence (Boolean : null : IR)
// For a field of +link{type:FieldType,type} "sequence" on a DataSource with 
// +link{dataSource.serverType,serverType:"sql"}, this flag indicates that the field is 
// implicitly bound to a sequence.  This setting means that SmartClient does not expect to 
// find a value for the field in "add" operations, even if it is marked as a 
// +link{primaryKey,primaryKey}, as such fields usually are.  It also means that SmartClient
// does not attempt to retrieve the field value from an actual database sequence, instead
// relying on the JDBC driver to return the generated value (see the note on
// <code>sequenceMode</code> below).
// <P>
// Implicitly bound columns are a syntactic convenience provided by some databases to simulate 
// the "auto-increment" or "identity" columns available natively in other products, without 
// the underlying sequence having to be explicitly referenced in SQL queries.  Currently, these
// database products support this idea:<ul>
// <li>PostgreSQL has had a "serial" column type for a long time - 
// <a href=http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL>
// http://www.postgresql.org/docs/9.3/static/datatype-numeric.html#DATATYPE-SERIAL</a></li>
// <li>DB2 has long supported a "GENERATED AS IDENTITY" notation for numeric fields.  This may
// or may not be implemented with a sequence - the documentation does not specify - but we 
// support it via the implicitSequence mechanism because it is so similar to the implicit
// sequence approach in Oracle.   
// <a href="http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm">
// http://publib.boulder.ibm.com/infocenter/dzichelp/v2r2/index.jsp?topic=%2Fcom.ibm.db2z10.doc.apsg%2Fsrc%2Ftpc%2Fdb2z_identitycols.htm</a></li>
// <li>Oracle introduced a "GENERATED AS IDENTITY" notation for numeric fields in version 12c - 
// <a href=http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php>
// http://www.oracle-base.com/articles/12c/identity-columns-in-oracle-12cr1.php</a></li>
// </ul>
// If you have columns like these in your database, declare them as type "sequence" and mark 
// them with the <code>implicitSequence</code> flag.
// <P>
// <b>NOTE:</b> If you use this property, you should also set the 
// +link{dataSource.sequenceMode,DataSource sequenceMode} to "jdbcDriver".  This is necessary
// because SmartClient cannot directly query the implicit sequence that is being used behind the 
// scenes, so we must rely on the JDBC driver to do that.
// <p>
// If you use +link{dataSource.autoDeriveSchema,autoDeriveSchema} to automatically derive a 
// dataSource from table metadata, SmartClient attempts to identify these special Oracle and
// Postgres columns by heuristic examination of the metadata.  When it identifies such a 
// column, it marks the corresponding dataSourceField <code>implicitSequence: true</code>, 
// and changes the sequenceMode on the DataSource to "jdbcDriver".  If your table contains
// one of these columns and SmartClient does not automatically identify it, bear in mind that
// you can always set this flag manually, even if you are using <code>autoDeriveSchema</code>.
// <P>
// This setting has no effect for non-SQL dataSources, or for databases other than those 
// mentioned above.
//
// @group sqlDataSource
// @see dataSource.sequenceMode
// @serverDS only
// @visibility external
//<



//> @attr dataSourceField.includeFrom (String : null : IR)
// Indicates that this field should be fetched from another, related DataSource.
// <P>
// The <code>incluedFrom</code> attribute should be of the form
// "<i>dataSourceId</i>.<i>fieldName</i>", for example:
// <pre>
//    &lt;field includeFrom="supplyItem.itemName"/&gt;
// </pre>
// <P>
// A +link{foreignKey} declaration must exist between the two DataSources, establishing either
// a 1-to-1 relationship or a many-to-1 relationship from this DataSource to the related
// DataSource. The inclusion can be indirect (traverse multiple DataSources) so long as there
// is a chain of <code>foreignKey</code> declarations from the target DataSource to the
// DataSource where the <code>includeFrom</code> field is declared.  You may use dot-notation
// to provide an explicit path between DataSources, or provide the name of only the last
// DataSource in the chain to have the complete path calculated for you at runtime.
// i.e., either of the following are acceptable forms, where foreign keys
// are defined to link records in the current DataSource to Employee records and in turn to
// Office records:
// <pre>
//   &lt;field includeFrom="Employee.Office.territory"/&gt;
//   &lt;!-- OR --&gt;
//   &lt;field includeFrom="Office.territory"/&gt;
// </pre>
// Note that when using the shorthand form, there is potential ambiguity: there could be 
// multiple ways in which two DataSources are related via different intervening DataSources, 
// so the auto-discovered relation may be different depending on which other DataSources are 
// loaded in the page. For this reason, explicitly spelling out the inclusion path is 
// preferred.
// <p>
// For including from a
// related DataSource where there are multiple related records, see
// +link{dataSourceField.includeSummaryFunction, includeSummaryFunction}.
// <p>
// In all cases, +link{DataSourceField.name} will default to the name of the included field,
// or you can specify a different name.
// <p>
// If both DataSources are SQLDataSources, HibernateDataSources or JPADataSources (with
// Hibernate as the provider) the related data will be retrieved via a SQL join and criteria
// and sort directions applied to the field work normally (they become part of the generated
// SQL query).
// <p>
// Related data will be retrieved via performing a DSRequest against
// the related DataSource once the data from the primary DataSource has been retrieved.  In
// this case, criteria or sorting directions applied to the included field are only allowed if
// data paging is not in use (for example +link{listGrid.dataFetchMode}:"basic"); otherwise,
// criteria and sort direction are ignored for the included field and a warning is logged on
// the server.
// <P>
// <b>Editing included fields</b>
// <p>
// An included field is +link{dataSourceField.canEdit,canEdit:false} by default.  Note that 
// included fields are not updatable, even if you set canEdit:true; the server will simply drop
// values for included fields if client code sends them. 
// <p>
// When thinking about editing an included field value, typically what is really intended is to
// edit the value of the <code>foreignKey</code> field.  For example, take the scenario of a
// system that tracks accounts and the employees assigned to manage them.  Given a DataSource
// "account" related one-to-one with DataSource "employee" by a "managerId" foreignKey field,
// we might declare an <code>includeFrom</code> so that the name of the account manager can
// be shown with each "account" record.  
// <p>
// Editing the manager's name while viewing the account would be intended to pick a new account
// manager, and <b>not</b> to change the legal name of the employee who happens to be the
// current account manager. 
// <p>
// To correctly set up this scenario, declare an <code>includeFrom</code> field that is hidden,
// but is used as the +link{dataSourceField.displayField,displayField} for the foreign key
// field:
// <pre>
// &lt;field name="managerId" foreignKey="employee.id" displayField="managerName" /&gt; 
// &lt;field name="managerName" includeFrom="employee.name" hidden="true"/&gt; 
// </pre>
// Now:
// <ul>
// <li> the "managerId" foreignKey field is shown in grids and forms, but takes its displayed
// value from the hidden <code>includeFrom</code> field. Note that when the
// <code>foreignKey</code> and <code>displayField</code> are specified, the 
// framework automatically defaults +link{dataSourceField.useLocalDisplayFieldValue} to 
// true to ensure the displayed value is picked up from the record being edited.
// <li> the automatically chosen editor will be a SelectItem with
// +link{SelectItem.optionDataSource,optionDataSource} set to "employees": it will allow
// picking a different "employee" record from the "employee" DataSource.
// <li> saving will save the ID of a new "employee" record to the "managerId" foreign key
// field, as intended
// </ul>

// You can alternatively set <code>editorType="ComboBoxItem"</code> on the
// "managerId" field to allow typeahead search of the "employee" DataSource.
// <P>
// Note that the +link{foreignDisplayField} attribute allows developers to have a different
// fieldName be used locally as a displayField from the field name for the display field
// in the foreign dataSource.
// <P>
// <b>Including fields that use summary functions</b>
// <p>
// The +link{dataSourceField.includeSummaryFunction, Include Summary Function} feature is used
// for including from a related DataSource where there are multiple related records. It applies
// a +link{type:SummaryFunction} to the related records aggregating them into single value.
// It is regularly used on directly included fields, but it supports indirect inclusions as well,
// when entire <code>includeFrom</code>+<code>includeSummaryFunction</code> setup is included from
// another DataSource. See +link{dataSourceField.includeSummaryFunction} docs for more details.
//
// @example sqlIncludeFrom 
// @serverDS only
// @group dataSourceRelations
// @visibility crossDS
//<


//> @attr dataSourceField.includeVia (String : null : IR)
// For a field that uses +link{dataSourceField.includeFrom}, specifies which
// +link{dataSourceField.foreignKey,foreignKey} field should be used to find records in the
// related DataSource.
// <p>
// <code>includeVia</code> only needs to be set when you have more than one
// <code>foreignKey</code> to the <i>same</i> related DataSource.  If you have multiple
// foreignKeys to multiple <i>different</i> DataSources, there is no need to set
// <code>includeVia</code>.
// <p>
// For example, perhaps you have a DataSource "moneyTransfer" where each record represents a
// money transfer, where the source and payment currencies are different, and the list of
// currencies is stored in a related DataSource "currency".  Each "moneyTransfer" record is
// linked to <b>2</b> "currency" records, through two different foreignKey fields,
// "sourceCurrencyId" and "paymentCurrencyId".
// <p>
// The following declarations would be required to use <code>includeFrom</code> to get a
// include the field "currencySymbol" from each of the two related "currency" records.
// <pre>
//   &lt;field name="sourceCurrencyId" foreignKey="currency.id"/&gt;
//   &lt;field name="paymentCurrencyId" foreignKey="currency.id"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
// </pre>
// <p>
// <h3>SQL Templating and <code>includeVia</code></h3>
// <p>
// The <code>includeVia</code> feature uses SQL table aliases in the generated SQL when generating multiple SQL joins
// to the same SQL table.  When using +link{group:customQuerying,SQL Templating}, it's sometimes necessary to know 
// the names of the aliases in the generated SQL.  The table alias used can be configured via
// setting +link{dataSourceField.relatedTableAlias} on the <code>foreignKey</code> field, for
// example, using the declarations below, aliases "source" and "payment" would be used for the
// two "currency" tables.
// <pre>
//   &lt;field name="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
//   &lt;field name="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurrencyId"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurrencyId"/&gt;
// </pre>
// <p>
// <h3>Multiple indirection and <code>relatedTableAlias</code></h3>
// <p>
// General rule is that if <code>relatedTableAlias</code> is present it is used as alias or its segment, otherwise
// <code>foreignKey</code> field name linked by <code>includeVia</code> is used instead. See some samples below.
// <p>
// Sometimes you may have two <code>includeFrom</code> fields that include a field which is itself included from 
// another DataSource, for example:
// <pre>
//   &lt;field name="sourceCurId" nativeName="sourceCurrencyId" foreignKey="currency.id" relatedTableAlias="source"/&gt;
//   &lt;field name="sourceCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="sourceCurId"/&gt;
//   &lt;field name="sourceCurrencyGroup" includeFrom="currency.groupName" includeVia="sourceCurId"/&gt;
//   &lt;field name="paymentCurId" nativeName="paymentCurrencyId" foreignKey="currency.id" relatedTableAlias="payment"/&gt;
//   &lt;field name="paymentCurrencySymbol" includeFrom="currency.currencySymbol" includeVia="paymentCurId"/&gt;
//   &lt;field name="paymentCurrencyGroup" includeFrom="currency.groupName" includeVia="paymentCurId"/&gt;
// </pre>
// .. where the "currency" DataSource used above is related to the "currencyGroup" DataSource via fields:
// <pre>
//   &lt;field name="groupId" type="integer" foreignKey="currencyGroup.id" relatedTableAlias="group"/&gt;
//   &lt;field name="groupName" type="text" includeFrom="currencyGroup.groupName"/&gt;
// </pre>
// Fields "sourceCurrencyGroup" and "paymentCurrencyGroup" include a field that is itself an included field.
// In this case "currencyGroup" table will be referenced two times, and its <code>relatedTableAlias</code> defined in 
// "currency" DataSource will be prefixed with the referenced by <code>includeVia</code> field's <code>relatedTableAlias</code>
// value to make aliases unique in generated SQL: "source_group" and "payment_group".
// <p>
// The same aliases would be used if "sourceCurrencyGroup" and "paymentCurrencyGroup" fields
// were to include "currencyGroup.groupName" <i>indirectly</i>:
// <pre>
//   &lt;field name="sourceCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="sourceCurId"/&gt;
//   &lt;field name="paymentCurrencyGroup" includeFrom="currency.currencyGroup.groupName" includeVia="paymentCurId"/&gt;
// </pre>
// <p>
// This works the same for more complex relationships.  If we add a "moneyTransferDetail"
// DataSource to the sample above which has multiple references to "moneyTransfer" 
// DataSource and would include fields from "currency" and "currencyGroup" DataSources:
// <pre>
//   &lt;field name="mtId" nativeName="moneyTransferId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="main" /&gt;
//   &lt;field name="mainTransferName" includeFrom="moneyTransfer.name" includeVia="mtId" /&gt;
//   &lt;field name="mainSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtId" /&gt;
//   &lt;field name="mainSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtId" /&gt;
//   &lt;field name="mainPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtId" /&gt;
//   &lt;field name="mainPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtId" /&gt;
//   &lt;field name="mtPrevId" nativeName="moneyTransferPreviousId" type="integer" foreignKey="moneyTransfer.id" relatedTableAlias="prev" /&gt;
//   &lt;field name="previousTransferName" includeFrom="moneyTransfer.name" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousSourceSymbol" includeFrom="moneyTransfer.sourceCurrencySymbol" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousSourceGroup" includeFrom="moneyTransfer.sourceCurrencyGroup" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousPaymentSymbol" includeFrom="moneyTransfer.paymentCurrencySymbol" includeVia="mtPrevId" /&gt;
//   &lt;field name="previousPaymentGroup" includeFrom="moneyTransfer.paymentCurrencyGroup" includeVia="mtPrevId" /&gt;
// </pre>
// In this scenario the "currencyGroup" table will be joined 4 times - for all main/prev transfer
// and payment/source currency combinations.  So, aliases will be prefixed with both
// intermediate <code>relatedTableAlias</code> values: "main_source_group",
// "main_payment_group", "prev_source_group", "prev_payment_group".
// <p>
// It is also allowed to specify a series of FK fields in <code>includeVia</code>, for example
// "moneyTransferDetail" could declare:
// <pre>
//   &lt;field name="mainSourceCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.sourceCurId"/&gt;
//   &lt;field name="mainPaymentCurrencyGroup" includeFrom="moneyTransfer.currency.currencyGroup.groupName" includeVia="mtId.paymentCurId"/&gt;
// </pre>
// In this case the prefix used for table aliases will be the same, cause relations referenced in <code>includeVia</code>
// are the same as in previous example: "main_source_group" and "main_payment_group".
// <p>
// <b>Note</b> that if +link{dataSourceField.relatedTableAlias,related table alias} are completely missing then, according to general rule,
// <code>foreignKey</code> field names will be used in aliases: "mtId_sourceCurId_groupId" and "mtId_paymentCurId_groupId".
// <p>
// <b>Note</b> that databases have their limitations for the length of identifier names. We limit table
// aliases according to the current database as described in +link{group:sqlSettings,SQL Settings overview}
// (search for <code>aliasLengthLimit</code> settings). If the generated table alias would exceed the length
// limit, we instead use a generated and unpredictable value like "a123".  To avoid hitting this limit
// for the advanced cases discussed above:
// <ul>
// <li> use relatively short strings for <code>relatedTableAlias</code>
// <li> for rare, multi-step inclusion scenarios where multiple field names are used as a
//      prefix, if field names are very long in order to match database column names, you can
//      use a shorter field name and use +link{dataSourceField.nativeName} to specify the
//      underlying column name (this is demonstrated in samples above - note field "mtPrevId")
// </ul>
// 
// @see dataSourceField.relatedTableAlias
// @example sqlIncludeVia
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.relatedTableAlias (String : null : IR)
// For a +link{group:sqlDataSource,SQL DataSource} field that specifies a
// +link{dataSourceField.foreignKey,foreignKey}, this property defines the table alias name to
// use in generated SQL.  
// <p>
// Aliasing is necessary when the same table appears more than once in a query.  This can 
// happen when using +link{dataSourceField.includeVia, Multiple <code>includeFrom</code> 
// fields referring to the same related DataSource}.  It can also happen when a
// +link{dataSourceField.foreignKey,foreignKey} definition references the same dataSource
// that the field is defined in; this happens with hierarchical structures, for example where
// every Employee reports to another Employee.  This is a so-called "self join", and it 
// <em>always</em> requires <code>relatedTableAlias</code> to be specified; failure to do so
// will result in invalid SQL.
// <p>
// In case of indirect relationship, when more than single join is needed to join the target table, and
// +link{dataSourceField.includeVia,includeVia} is missing, generated alias is a concatenation of
// <code>relatedTableAlias</code> and FK field names starting with the first <code>relatedTableAlias</code> 
// met in chain of relations leading to the target table.
// @see dataSourceField.includeVia
// @example sqlIncludeVia
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.displayField (String : null : IR)
// When records from this dataSource are displayed in a dataBoundComponent such as a
// +link{ListGrid}, the <code>displayField</code> attribute may be used to cause some 
// field to display a value from another field in the record.
// <P>
// This is typically used for editable +link{dataSourceField.foreignKey} fields. 
// In this scenario, a dataSource
// field has a foreignKey field which stores an ID value used to identify records in another,
// related dataSource. Rather than display this ID to users, developers may wish to display
// another, user-friendly field from the related record. This is easy to achieve by 
// having a second field on the dataSource which will be populated with the "display value"
// from this related dataSource, and using <code>dataSourceField.displayField</code> 
// to show this value.  The +link{DataSourceField.includeFrom} feature handles populating
// this field automatically for dataSources backed by the
// +link{group:serverDataIntegration,SmartClient Server}. See the "Editing included fields"
// section of the +link{dataSourceField.includeFrom} documentation
// for more on editing included foreignKey fields.
// <P>
// Editable dataSourceFields with a specified <code>displayField</code> and 
// <code>foreignKey</code> will typically be edited using a +link{SelectItem} 
// or +link{ComboBoxItem}. In this case, in addition to identifying the field to use as a
// static display value within the record being edited, <code>displayField</code>
// will also identify which field on the related dataSource
// to use as a display field when showing a set of options to the user. This behavior may
// be modified in a couple of ways:
// <ul>
//  <li>The +link{dataSourceField.foreignDisplayField} attribute may be used to handle the
//      case where the name of the field used as a displayField within the dataSource is
//      different from the name of the included/equivalent field in the related dataSource.</li>
//  <li>The +link{dataSourceField.useLocalDisplayFieldValue} attribute may be explicitly
//      set to false to avoid picking up a display value from the local record altogether.
//      Instead the displayField will be used only to derive the display value from
//      a related record from the optionDataSource</li>
// </ul>
// For more on how FormItems use the displayField property, see +link{FormItem.displayField}.
//
// @serverDS allowed
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.useLocalDisplayFieldValue (Boolean : null : IR)
// The +link{formItem.useLocalDisplayFieldValue} attribute may be specified
// within a dataSource configuration.
// <P>
// This property governs whether, when displaying a record in an editor component,
// the <code>displayField</code> value for this field should be picked up directly from
// the record value (as opposed to being retrieved via an explicit fetch operation against
// the +link{formItem.optionDataSource}). See +link{formItem.useLocalDisplayFieldValue}
// for further details.
// <P>
// If not explicitly set, dataSources backed by the 
// +link{group:serverDataIntegration,SmartClient server} will set this property to true
// automatically for fields where the specified +link{dataSourceField.displayField} values
// are retrieved from another dataSource using the +link{dataSourceField.includeFrom} 
// feature.
//
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.foreignDisplayField (String : null : IR)
// Name of another field in a separate dataSource that should be used as the display
// value for this field in the case where a <code>foreignKey</code> relationship
// exists.
// <P>
// For a general overview on picking up display values from a separate field,
// see +link{dataSourceField.displayField} property.
// <P>
// The <code>foreignDisplayField</code> property is useful for editable fields, where the 
// name of the display field within the record being edited differs from the display field 
// for related records in the option dataSource.<br>
// For example consider a "countryDS" dataSource with the following fields:
// <pre>
//  &lt;field name="id"     type="sequence"   hidden="true"     primaryKey="true" /&gt;
//  &lt;field name="name"   type="text"       title="Country"   required="true" /&gt;
// </pre>
// ...and a "city" dataSource which uses a foreignKey relationship identify associated
// country records:
// <pre>
//  &lt;field name="id"        type="sequence" hidden="true"   primaryKey="true" /&gt;
//  &lt;field name="name"      type="text"     title="City"    required="true" /&gt;
//  &lt;field name="countryId" type="integer"  editorType="SelectItem" 
//             foreignKey="countryDS.id" 
//             displayField="countryName" foreignDisplayField="name" title="Country" /&gt;
//  &lt;field name="countryName" includeFrom="countryDS.name"  hidden="true"   /&gt;
// </pre>
// A DynamicForm bound to this "city" dataSource would display a SelectItem editor by
// default for the country field. The initial display value would be the local value from
// the "countryName" field, populated from the related countryDS automatically via the
// +link{dataSourceField.includeFrom} feature.<br>
// If the user showed the drop-down list of options for this field, the display values
// within that list would be picked up from the "name" field values for the related
// "countryDS" records.
// <P>
// Note that when specified, <code>foreignDisplayField</code> is always expected to be set to 
// the related dataSource field containing equivalent values to the <code>displayField</code>
// in the local dataSource. This is important as, when editing the field, foreignDisplayField values from 
// the related dataSource will be displayed to the user, and when a value is selected
// the local record's <code>displayField</code> value will be updated to match the selected
// <code>foreignDisplayField</code> value from the related dataSource's record. This behavior
// is documented under +link{formItem.displayField}.
//
// @serverDS allowed
// @group dataSourceRelations
// @visibility external
//<

//> @attr dataSourceField.joinType (JoinType : null : IR)
// This property is only applicable to fields of SQL DataSources that also specify a 
// +link{foreignKey,foreignKey} property; it is ignored for all other fields.  Indicates the 
// type of join to make between the tables underlying this DataSource and the other DataSource
// referred to in the <code>foreignKey</code> property, when resolving +link{includeFrom,includeFrom} 
// fields.  The default value of null is the same as specifying "inner".
// <P>
// Note, outer joins are allowed for all supported database products only if you are using 
// +link{dataSource.useAnsiJoins,ANSI-style joins}, which is not the case by default.  If you
// are using the older strategy of additional join expressions in the WHERE clause, outer 
// joins are only supported for database products that provide a proprietary native syntax for 
// expressing outer joins.  Those products are:<ul>
// <li>Oracle</li>
// <li>Versions of Microsoft SQL Server earlier than 2012, and running in compatibility mode 80</li>
// </ul>
//
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<


//> @type JoinType
// The type of join to make between two SQL tables when resolving 
// +link{dataSourceField.includeFrom,includeFrom} fields.  
//
// @value "inner"    A regular inner join, whereby rows are only included in the resultset
//                   where the join can be satisified, so a missing row in the table being
//                   joined to results in the entire row being omitted.
// @value "outer"    An outer join.  All outer joins generated by SmartClient's SQL subsystem
//                   are left outer joins, meaning that every row in the join-from (or "left")
//                   table that matches the criteria is included, and missing rows in the 
//                   join-to (or "right") table cause columns to be set to null.
//
// @serverDS only
// @group dataSourceRelations
// @visibility external
//<


// Summary functions
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.summaryFunction (SummaryFunction : null : IR)
// @include listGridField.summaryFunction
// @visibility external
//<

//> @attr dataSourceField.summaryValueTitle (String : null : IR)
// Title to show in a +link{SummaryFunction,Summary of type "title"} for this field. If unspecified
// <code>title</code> summaries will show the +link{dataSourceField.title} for the field.
// @visibility external
//<



// XML binding / serialization
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.xmlAttribute (boolean : null : IR)
// Indicates that +link{dataSource.xmlSerialize()} should serialize this value as an XML
// attribute.
// <P>
// Note this does not need to be declared in order for DataSource records to be derived from
// XML data: a field will be populated with either an attribute or subelement with matching
// name.
//
// @group xmlSerialize
// @group componentSchema
// @serverDS allowed
// @visibility external
//<
//> @attr dataSourceField.childTagName (String : null : IR)
// For a field that is +link{multiple,multiple:"true"}, controls the name of the XML tag used for each
// subelement during +link{dataSource.xmlSerialize()}.
// <P>
// If unset, the default tag name is "value" for a field of simple type, and for a field of
// DataSource type, is the tagName or ID of the DataSource (as though
// <code>xmlSerialize()</code> were called on the child DataSource).
//
// @group xmlSerialize
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.propertiesOnly (boolean : null : IR)
// For use in +link{group:componentSchema} for fields that contain other components, this flag
// suppresses auto-construction for subcomponents that appear under this field.
// <P>
// For example, the +link{VLayout} schema sets this for its +link{Layout.members,members}
// property, so that when a VLayout is constructed via XML as follows:
// <pre>
// &lt;VLayout&gt;
//     &lt;members&gt;
//         &lt;ListGrid ID="myGrid" .../&gt;
//         &lt;Toolstrip ID="myToolStrip" ... /&gt;
//     &lt;/members&gt;
// &lt;/VLayout&gt;
// </pre>
// The ListGrid and ToolStrip do not construct themselves automatically.  Instead, the VLayout
// receives the properties of the ListGrid and ToolStrip as ordinary JavaScript Objects, with
// the special property <code>_constructor</code> set to the name of the class that should be
// constructed.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.inapplicable (boolean : null : IR)
// For use in +link{group:componentSchema}, a field +link{dataSource.inheritsFrom,inherited} from
// another schema can be redeclared with this property set in order to indicate that the
// property should not be used.
// <P>
// This is primarily used to influence +link{group:visualBuilder}.  For simple type properties,
// this avoids the property appearing in the Component Editor.  
// <P>
// For fields that hold subcomponents, this prevents inappropriate drag and drop.  For example,
// a custom class called <code>MyDialog</code> may automatically create a series of children,
// and not allow arbitrary other children to be added.  In this case, the inherited property
// +link{Canvas.children} should be marked inapplicable in order to prevent arbitrary
// components being dropped onto a <code>MyDialog</code> instance.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.group (String : null : IR)
// For use in +link{group:componentSchema}, indicates what group to place the property in when
// editing in Visual Builder.
//
// @group componentSchema
// @serverDS allowed
// @visibility external
//<

// Multi-valued fields
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.multiple (Boolean : null : IR)
// Indicates that this field should always be Array-valued.  If the value derived from
// +link{dataSource.dataFormat,XML or JSON data} is singular, it will be wrapped in an Array.
// <p>
// JPA and Hibernate DataSources use <code>multiple:true</code> as part of the declaration of
// One-To-Many and Many-to-Many relations - see +link{group:jpaHibernateRelations} for details.
// <p>
// <h4>Criteria on multiple:true fields: client-side filtering</h4>
// <p>
// For simple Criteria, the criteria value is compared to <i>each</i> field value in the
// <code>multiple:true</code> field, according to the
// +link{dsRequest.textMatchStyle,textMatchStyle}.  If <i>any</i> field value matches the
//j filter value, the field is considered to match the criteria.
// <p>
// For +link{AdvancedCriteria}, for normal +link{type:OperatorId,search operators} the field
// value is considered as matching the <code>Criterion</code> if <i>any</i> of the field values
// match the Criterion.  Specifically, this is true of all operators that have an 
// +link{type:OperatorValueType,operatorValueType} of "fieldType" or "valueRange".
// <p>
// For operators that compare against other fields in same record, such as "equalsField", 
// if the other field is <i>not</i> <code>multiple:true</code>, matching works the same as for
// normal operators, that is, as if <code>criterion.value</code> directly contained the value
// rather than the name of another field.
// <p>
// If the other field is <i>also</i> multiple:true, only "equalsField", "notEqualsField",
// "iEqualsField" and "iNotEqualsField" are allowed (any other <code>operator</code> will
// cause a warning and be ignored) and the set of values in the field must be identical (aside
// from case, for operators prefixed with "i") and in identical order to match.
// <p>
// For the <code>inSet</code> operator, the field matches if there is any intersection between
// the field values and the array of values provided in <code>criterion.value</code>.
// <code>notInSet</code> is the reverse.
// <p>
// Finally, for "isBlank", "notBlank", "isNull" and "notNull", an empty Array is considered non-null.  For example,
// if you use dataFormat:"json" and the field value is provided to the browser as
// <code>[]</code> (JSON for an empty Array), the field is considered non-null.
// <p>
// <h4>Server-side Representation and Storage</h4>
// <p>
// Values for multiple:true fields appear as Java Lists when received in server code such as a
// DMI.  The SmartClient Server supports simple storage of values that are multiple:true, controlled
// via the +link{multipleStorage} setting.
// <p>
// For server-side behavior of JPA and Hibernate relation fields that are multiple:true, see
// +link{group:jpaHibernateRelations}.
// <p>
// For non-relation fields, the SmartClient Server supports simple storage of values that are
// multiple:true, controlled via the +link{multipleStorage} setting, with some limited support
// for server-side filtering, as described in the +link{multipleStorage} docs.
// <p>
// For the built-in SQL, Hibernate and JPA connectors, if criteria are specified for a
// multiple:true field where <code>multipleStorage</code> is null or "none", the SmartClient
// server knows nothing about how the multiple values are stored, so as a fallback the criteria
// will operate as though the field were a normal, non-multiple "text" field.  This will
// generally <b>not</b> match the client-side filtering behavior described above, so filtering
// should either be performed entirely on the client (for example, via
// +link{listGrid.dataFetchMode,dataFetchMode:"local"} or entirely on the server (via
// +link{resultSet.useClientFiltering}:"false")
// <p>
// The server-side filtering is done through a criteria transform which happens with
// +link{DataSource.transformMultipleFields, transformMultipleFields}.
// <p>
// <h4>XML Serialization</h4>
// <P>
// Specifically for XML serialization and deserialization, <code>multiple:true</code> behaves
// similarly to the 
// +externalLink{http://www.google.com/search?hl=en&q=soap+array,SOAP array idiom}, that is,
// there will be a "wrapper element" named after the field name, whose contents will be several
// elements of the specified +link{dataSourceField.type,field.type}.  
// <P>
// For example, +link{layout.members} is declared with <code>type:"Canvas",
// multiple:true</code>.  The correct XML format is thus:
// <pre>
// &lt;VLayout&gt;
//     &lt;members&gt;
//         &lt;Canvas ID="myCanvas" ... /&gt;
//         &lt;ListGrid ID="myGrid" .../&gt;
//         &lt;Toolstrip ID="myToolStrip" ... /&gt;
//     &lt;/members&gt;
// &lt;/VLayout&gt;
// </pre>
// <P>
// See +link{dataSourceField.childTagName} for customizing the tagName used for subelements.
//
// @group xmlSerialize
// @group componentSchema
// @serverDS allowed
// @visibility external
//<
  
//> @attr dataSourceField.multipleValueSeparator (String : ", " : IR)
// For fields that are +link{multiple,multiple:true}, the separator used 
// between values when they are displayed.
// @serverDS allowed
// @group multipleField
// @visibility external
//<

//> @type MultipleFieldStorage
// Options for how values are stored for a field that is
// +link{listGridField.multiple,multiple:true}.  See +link{dataSourceField.multipleStorage}.
// @value "simpleString" values are saved as a simple delimeter-separated string.  Delimeter
//        can be configured via +link{dataSourceField.multipleStorageSeparator}.  An empty
//        array is stored as "", and null as the database <code>null</code> value.
// @value "json" values are serialized to JSON.  Empty array as a distinct value
//         from null (it appears as the text "[]").
// @value "none" no transformation is applied to values; server-side field value remains a Java
//        List when passed to the execute(Fetch|Add|Update|Remove) method of the server-side
//        DataSource class
// @group multipleField
// @visibility external
//<

//> @attr dataSourceField.multipleStorage (MultipleFieldStorage : null : IR)
// How values for a +link{multiple,multiple:true} field should be stored.
// <p>
// On the server, field values for <code>multiple:true</code> fields are represented as Java
// Lists in DSRequest and DSResponse objects, but when <code>multipleStorage</code> is used,
// are ultimately stored as Strings.  
// <p>
// This storage mechanism is "denormalized" in the sense of
// +externalLink{http://en.wikipedia.org/wiki/Database_normalization,database normalization}
// because the field contains a compound value rather than an atomic value.  Specifically, this
// makes the field harder to use with database features like SQL joins, since its value cannot
// be directly compared to other, singular fields.  For this reason, there's really only a
// narrow set of cases where it makes sense to use this storage mechanism, consider it if:
// <ul>
// <li> the values don't appear in any other tables or columns elsewhere in your database (so
//      joins and other comparisons wouldn't be possible anyway)
// <li> there is no authoritative list of all possible values, or even of popular values; it's
//      basically freeform, like arbitrary, uncurated "tags" applied to photos or links
// </ul>
// <p>
// A <code>multiple:true</code> field can be of any +link{SimpleType}, including "date",
// "time", "datetime", "float", "int" etc.  Type will be preserved across a store and reload
// cycle, so for example a List of values for a field of type "int" will arrive at the server
// in a DSRequest as a List of Integer, be stored as a String, but appear again as a List of
// Integer inside a DSResponse.  When storing "date", "time" or "datetime" values as Strings,
// XML schema formats are used - the same that are used for transmission in XML or JSON (see
// +link{group:dateFormatAndStorage,Date and Time Format and Storage overview} for details).
// <p>
// The <code>multipleStorage</code> feature works by transforming from List to String and back
// inside the server-side DataSource.execute() method.  Specifically, inbound DSRequests are
// transformed before methods that perform actual storage are called (executeUpdate() et al),
// and DSResponses received from these methods have <code>multiple:true</code> field values
// transformed back into Lists before DataSource.execute() returns the DSResponse.
// <p>
// This transformation approach means that the built-in SQL, JPA and Hibernate connectors all
// support <code>multipleStorage</code>, and <code>multipleStorage</code> is also automatically
// available for any custom DataSource that is capable of storing String values, and implements
// its storage methods via overrides of executeUpdate(), executeAdd() et al as described in the
// +link{group:writeCustomDataSource,custom DataSource overview}.
// <p>
// Note that when using the built-in SQL, JPA and Hibernate connectors, the underlying SQL
// column should be of 'text' type.  The +link{group:dbConfigTool,Database Configuration Tool} will
// automatically generate columns of the correct type for a SQLDataSource.  For JPA or
// Hibernate DataSources, just ensure the type of the Java bean property on your Java object is
// String.
// <p>
// The default <code>multipleStorage</code> setting of null means that the "simpleString"
// +link{MultipleFieldStorage} approach will be used if:
// <ul>
// <li> the field is of a known +link{SimpleType}
// <li> the field is not a +link{foreignKey}
// </ul>
// Otherwise, +link{MultipleFieldStorage} "none" will be used.
// <p>
// <h4>Criteria and AdvancedCriteria handling</h4>
// <p>
// For the built-in SQL, JPA and Hibernate connectors, when
// <code>multipleStorage</code>:"simpleString" or "json" is used, criteria are transformed to
// replicate the client-side filtering behavior for multiple:true fields, where possible.
// The following operators are supported with the same behavior as client-side filtering:
// <ul>
// <li> all String-oriented operators including +link{group:patternOperators,pattern operators}
// <li> regexp / iRegexp (built-in SQL only, JPA and Hibernate do not support these)
// <li> isBlank / notBlank
// <li> isNull / notNull
// <li> inSet / notInSet
// <li> equalsField / notEqualsField / iEqualsField / iNotEqualsField
// </ul>
// The following operators, which are supported for client-side filtering of multiple:true
// fields, are not supported for server filtering when using <code>multipleStorage</code>:
// <ul>
// <li> greaterThan/lessThan(OrEqual)
// <li> "between" and all other operators with +link{type:OperatorValueType} of "valueRange" 
// <li> regexp / iRegexp as noted above
// </ul>
// Note that for string-based filtering operators such as "equals", no characters which are
// part of the +link{multipleStorageSeparator} may be used in the filter string.  If any
// characters from the <code>multipleStorageSeparator</code> are present in the filter value,
// it will always fail to match.  For "json" mode, the <code>multipleStorageSeparator</code> is
// effectively the String '","'.  
//
// @group multipleField
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.multipleStorageSeparator (String : null : IR)
// For fields that are +link{multiple,multiple:true} and use +link{multipleStorage}, the
// separator used in the "simpleString" +link{type:MultipleFieldStorage} mode.
// <p>
// Default value of null means the +link{multipleValueSeparator} is used instead.
//
// @serverDS only
// @group multipleField
// @visibility external
//<

//> @attr operationBinding.transformMultipleFields (boolean : null : IR)
// If set to "false", transformation of values for
// +link{dataSourceField.multiple,multiple:true} fields, normally controlled by
// +link{dataSourceField.multipleStorage}, is instead disabled for this OperationBinding.
//
// @group multipleField
// @serverDS only
// @visibility external
//<

//> @attr dataSource.transformMultipleFields (boolean : null : IR)
// If set to "false", transformation of values for
// +link{dataSourceField.multiple,multiple:true} fields, normally controlled by
// +link{dataSourceField.multipleStorage}, is instead disabled for this entire DataSource.
//
// @group multipleField
// @serverDS only
// @visibility external
//<


// Javabean/POJO Binding
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.javaClass (String : null : IR)
// Explicitly declares the Java class that should be used when data from the client is
// validated by the SmartClient server and/or applied to Java Beans / POJOs via the server-side
// API <code>com.isomorphic.datasource.DataSource.setProperties()</code>.  This includes 
// auto-populating POJO arguments of a +link{group:dmiOverview,DMI} method, or populating
// JPA/Hibernate beans with data when using the built-in JPA and Hibernate DataSources.
// <p>
// For DataSources that do not use Java Beans, <code>javaClass</code> can be used to force a
// particular representation for validated DSRequest data (e.g. data passed to a DMI):
// <ul>
// <li>for fields declared to be of type "integer" or "float" valid settings include "BigInteger",
// "Long", "Integer", "Short", "Byte", "AtomicInteger", "AtomicLong", "BigDecimal", "Double", "Float".</li>
// <li>for fields declared to be of type "date" valid settings include basic "java.util.Date",
// "java.sql.Date" and "java.sql.Time" types as well as Joda-Time types "DateTime", "DateMidnight",
// "LocalDateTime", "LocalDate", "LocalTime" and Java 8 Date/Time API types "LocalDate", "LocalDateTime",
// "LocalTime".</li>
// </ul>
// When populating Java Beans/ POJOs, <code>javaClass</code> does not normally have to
// specified: SmartClient will use Java reflection to inspect the type of argument expected by
// a setter method and will attempt conversion of inbound data to that type.  As described in
// the documentation for <code>DataTools.setProperties()</code>, this works for almost all
// typical cases.  However <code>field.javaClass</code> is useful for:
// <ul>
// <li> subobject of abstract or interface type: in this case Java Reflection is not sufficient
// to discover the concrete type that should be instantiated, and <code>javaClass</code> should be
// set instead.</li>
// <li> subobject of Collection or Map type, when Java generics are not used or the Collection
// member type or Map value type is abstract.  When Java generics are used (for example the
// setter takes an argument is of type Collection&lt;SomePOJO&gt; or Map&lt;KeyType,SomePOJO&gt;,
// SmartClient will automatically attempt to convert inbound data to the type of the members of
// the Collection or values of the Map.  Without generics, <code>javaClass</code> needs to be
// specified.  Note that <code>javaClass</code> will take precedence over generics if both 
// are used. Also note that +link{dataSourceField.javaCollectionClass} can be specified if a
// particular Collection or Map type is needed, and +link{dataSourceField.javaKeyClass} can be
// specified for a field of type <code>java.util.Map</code>.</li>
// </ul>
// <b>NOTE:</b> It is also possible to make SmartClient Server determine the javaClass to use 
// dynamically at runtime. See the description of <code>DataSource.getPropertyJavaClass()</code> 
// in the server documentation for details.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.javaCollectionClass (String : null : IR)
// See +link{dataSourceField.javaClass} - when auto-populating of Java Beans / POJOs based on 
// inbound DSRequest data, for a field of type Collection or Map, 
// <code>javaCollectionClass</code> can 
// be used to specify a particular concrete class to use.  If not specified, and a concrete
// Collection or Map class cannot be discovered using Java Reflection, the following concrete
// classes are used:
// <ul>
// <li> <code>java.util.ArrayList</code> is used for fields of type <code>List</code>
// <li> <code>java.util.HashSet</code> is used for fields of type <code>Set</code>
// <li> <code>java.util.LinkedList</code> is used for fields of type <code>Queue</code>
// <li> <code>java.util.LinkedHashMap</code> is used for fields of type <code>Map</code>
// <li> <code>java.util.ArrayList</code> is used for fields that are otherwise of type <code>Collection</code>
// </ul>
// Note that this value is used even if the target Collection or Map is declared as a concrete
// class.  So, for example, if you set <code>javaCollectionClass</code> to 
// <code>java.util.LinkedList</code> but your setter method accepts a 
// <code>java.util.ArrayList</code>, you will get a ClassCastException.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.javaKeyClass (String : null : IR)
// See +link{dataSourceField.javaClass} - when auto-populating of Java Beans / POJOs based on 
// inbound DSRequest data, for a field of Map type, <code>javaKeyClass</code> can be used to
// specify a particular concrete class for the map keys.  If not specified, and a concrete
// type cannot be discovered using Java Reflection, <code>java.lang.Object</code> is used.
//
// Note that <code>javaKeyClass</code> take precedence over generics if both are used.
//
// @serverDS only
// @visibility external
//<


// Exporting
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.exportTitle (String : null : IR)
//	Optional different field-title used for exports.
//
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.canExport (Boolean : null : IR)
// Dictates whether the data in this field be exported.  Explicitly setting 
// <i>canExport</i> to false overrides the setting on any component-fields, such
// as +link{listGridField.canExport, ListGrid fields}.
//
// @serverDS allowed
// @visibility external
//<

// Upload
// --------------------------------------------------------------------------------------------

//> @attr dataSourceField.uploadFieldName (String : null : IR)
// Used by the +link{BatchUploader} to map a field in an upload file to this 
// dataSourceField.  This is only necessary if the dataSourceField's name and title differ 
// from the name of the field in the upload file (SmartClient will automatically map upload 
// fields using the dataSourceField's title, if possible, if it does not get a direct match 
// on field name).
//
// @serverDS allowed
// @visibility batchUploader
//<

//> @attr dataSourceField.batchUploadOperationId (String : null : IR)
// Used to look up key values for fields with +link{dataSourceField.importStrategy,importStrategy.display}
// while importing data using +link{BatchUploader} or <code>DataImport</code> server-side API.
// <p>
// Normally key values are looked up performing "fetch" operation on related data source, but
// setting <code>batchUploadOperationId</code> allows to control which operation will be performed.
// This can be useful to avoid unnecessary load when importing big data sets, if default "fetch"
// operation is too heavy.
// <p>
// By default the look up is not case sensitive but this can be controlled through the
// +link{attr:dataSourceField.batchUploadCaseSensitive,batchUploadCaseSensitive} attribute.
//
// @serverDS only
// @visibility batchUploader
//<

//> @attr dataSourceField.batchUploadCaseSensitive (Boolean : false : IR)
// Applies to the "fetch" operation that is used to look up key values for fields with
// +link{dataSourceField.importStrategy,importStrategy.display} while importing data using
// +link{BatchUploader} or <code>DataImport</code> server-side API. Controls whether look up
// for key values is case sensitive or not. Default value is "false".
//
// @serverDS only
// @visibility batchUploader
//<

//> @attr dataSourceField.showFileInline    (boolean : null : [IR])
// For a field of type:"imageFile", indicates whether to stream the image and display it
// inline or to display the View and Download icons.
// 
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.imageWidth (number | String: null : [IR])
// Width of the image-content of this field.  If set as a string, represents the name of 
// another field in the record that holds the imageWidth.  Applicable only to fields of image 
// type or fields that use a +link{class:ViewFileItem, ViewFileItem} as an editor.
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.imageHeight (number | String: null : [IR])
// Height of the image-content of this field.  If set as a string, represents the name of 
// another field in the record that holds the imageHeight.  Applicable only to fields of image 
// type or fields that use a +link{class:ViewFileItem, ViewFileItem} as an editor.
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.imageSize (number | String: null : [IR])
// Width and height of the image-content of this field.  If set as a string, represents the 
// name of another field in the record that holds the imageSize.  Applicable only to fields 
// of image type or fields that use a +link{class:ViewFileItem, ViewFileItem} as an editor.
// @serverDS allowed
// @visibility external
//<


// Role-based security
// ----------------------------------------------------------------------------------------

//> @groupDef fieldLevelAuth
// Properties that provide declarative security features at the level of individual fields
// @title Field-Level Security
// @visibility external
//< 

//> @attr dataSourceField.viewRequiresAuthentication (boolean : null : IR)
// Whether a user must be authenticated in order to fetch this field.  If this property is 
// set and the user is not authenticated, SmartClient Server will not return values for this
// field to the client.
// <p>
// The way this behavior works is to remove the field from the expressed or implied list of
// fields to return.  A list of fields can be expressed using +link{OperationBinding.outputs}
// or +link{dsRequest.outputs}; in the absence of those, the entire set of fields defined in 
// the DataSource is implied.  You can override this behavior on a per-request basis by 
// providing a DMI that just re-adds the names of the fields you want for that particular 
// request to the "consolidated outputs".  See the server-side Javadoc for 
// <code>DSRequest.getConsolidatedOutputs()</code>.
// <p>
// In addition to this behavior of trimming off values in fetched records, a field that fails
// a field-level security check (either this one or one of the two more specific checks, 
// +link{viewRequiresRole,viewRequiresRole} and +link{viewRequires,viewRequires}) will be 
// altered in the version of the dataSource returned to the client by the 
// +link{group:loadDSTag,&lt;loadDS&gt; JSP tag} or 
// +link{group:dataSourceDeclaration,DataSourceLoader servlet}.
// <ul>
// <li>If the field is also not editable (see the discussion of this below), it will be marked 
// +link{canView,canView}:false, and thus effectively be inert and unusable on the client</li>
// <li>If the field is editable, it will be marked +link{hidden,hidden}.  By default, this means
// that +link{dataBoundComponent}s will not show the field, though this can be overridden for 
// individual components.  If you do choose to unhide the field, bear in mind that it will 
// never actually show any data, because the underlying security test has still failed</li>
// </ul>
// By default, view constraints automatically imply edit constraints - almost all of the time,
// if a user is not allowed to view a field, he should not be allowed to update it either.  If
// you specify a view constraint, the system behaves as if you had also specified the 
// corresponding edit constraint - so <code>viewRequiresAuthentication</code> on a field 
// implies <code>+link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication}</code>.
// You override this behavior simply by specifying some kind of edit constraint for the field,
// either a different one (eg, "users" can view a field, but only "managers" can update it) or 
// a blank one (if you have some unusual requirement whereby users are not allowed to view a 
// field, but they can update it).
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.editRequiresAuthentication (boolean : null : IR)
// Whether a user must be authenticated in order to write to this field.  If this property is 
// set and the user is not authenticated, the SmartClient Server will not allow this field to
// be updated or initialized.
// <p>
// This property affects two things.  Firstly, the server determines when the DataSource is 
// first loaded if we have an authenticated user; if we don't, the field is marked 
// <code>canEdit: false</code>.  Secondly, when an insert or update request is received from 
// the client, the server removes the field from the <code>values</code> clause before the
// request is processed.
// <p>
// Note that you can override this behavior.  The <code>canEdit</code> setting can be overridden 
// on the the client-side DataSource like any other client-side property.  The value-removing 
// behavior can be overridden on a per-request basis by providing a DMI that re-adds values for
// the fields you want for that particular request to the values object (the values originally 
// sent up by the client are available on the DSRequest).  See the server-side Javadocs for 
// <code>DSRequest.getValues()</code> and <code>DSRequest.getClientSuppliedValues()</code>.
//
// @requiresModules SCServer
// @see dataSourceField.viewRequiresAuthentication
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.initRequiresAuthentication (boolean : null : IR)
// Whether a user must be authenticated in order to initialize to this field.  If this property is 
// set and the user is not authenticated, the SmartClient Server will not allow this field to
// be initialized.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.updateRequiresAuthentication (boolean : null : IR)
// Whether a user must be authenticated in order to update to this field.  If this property is 
// set and the user is not authenticated, the SmartClient Server will not allow this field to
// be updated.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.viewRequiresRole (String : null : IR)
// Comma-separated list of user roles that are allowed to fetch this field. If the current user
// has any of the roles listed, values for the field will be fetched.  Please see 
// +link{operationBinding.requiresRole} for further details of SmartClient's declarative 
// role-based security. Please see 
// +link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication} [or 
// +link{dataSourceField.viewRequiresAuthentication,viewRequiresAuthentication} for viewRequiresRole]
// for the UI consequences if the user does not have the required roles, as well as for information 
// on customizing field-level security.
//
// @requiresModules SCServer
// @see dataSourceField.viewRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.editRequiresRole (String : null : IR)
// Comma-separated list of user roles that are allowed to write to this field. If the current
// user does not have any of the roles listed, the system will not allow this field to be 
// initialized or updated.  Please see +link{operationBinding.requiresRole} for further 
// details of SmartClient's declarative role-based security. Please see 
// +link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication} [or 
// +link{dataSourceField.viewRequiresAuthentication,viewRequiresAuthentication} for viewRequiresRole]
// for the UI consequences if the user does not have the required roles, as well as for information 
// on customizing field-level security.
// <p>
// <b>NOTE:</b> This property prevents both initialization and updates for a field.  If you 
// have a need to prevent <em>just</em> initialization or <em>just</em> updates, you can use
// +link{dataSourceField.initRequiresRole} or +link{dataSourceField.updateRequiresRole}.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.viewRequiresRole
// @see dataSourceField.initRequiresRole
// @see dataSourceField.updateRequiresRole
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.initRequiresRole (String : null : IR)
// Comma-separated list of user roles that are allowed to initialize this field. If the current
// user does not have any of the roles listed, the system will not allow this field to be 
// initialized.
// <p>
// <b>NOTE:</b> This property only prevents initialization of a field; updates will still be 
// allowed.  You should only use this property if you have a special requirement; ordinarily,
// use +link{dataSourceField.editRequiresRole}, which applies security for both types of write.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @see dataSourceField.updateRequiresRole
// @see dataSourceField.initRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.updateRequiresRole (String : null : IR)
// Comma-separated list of user roles that are allowed to update this field. If the current
// user does not have any of the roles listed, the system will not allow this field to be 
// updated.
// <p>
// <b>NOTE:</b> This property only prevents a field from being updated; initialization will 
// still be allowed.  You should only use this property if you have a special requirement; 
// ordinarily, use +link{dataSourceField.editRequiresRole}, which applies security for both 
// types of write.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @see dataSourceField.initRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.viewRequires (VelocityExpression : null : IR)
// Indicates that the specified +link{type:VelocityExpression} must evaluate to true if
// values for the field are to be fetched.  If the specified expression does not evaluate
// to true, the field will be dropped as described for 
// +link{dataSourceField.viewRequiresAuthentication,viewRequiresAuthentication}.
// <p>
// In addition to the normal context variables available to Velocity expressions in SmartClient,
// expressions you write for field-level <code>requires</code> clauses - <code>viewRequires</code>, 
// +link{editRequires,editRequires}, +link{initRequires,initRequires} and 
// +link{updateRequires,updateRequires} - can reference two additional variables: 
// <code>$fieldName</code> and <code>$dsName</code>.  These are the names of the dataSource and 
// field currently undergoing <code>requires</code> checks.  They are helpful because they allow
// you to write a generic checker function that can be used to handle <code>requires</code>
// checks for multiple fields and dataSources.
//
// @requiresModules SCServer
// @see dataSourceField.viewRequiresAuthentication
// @see dataSourceField.viewRequiresRole
// @see dataSourceField.editRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.editRequires (VelocityExpression : null : IR)
// Indicates that the specified +link{type:VelocityExpression} must evaluate to true if
// writes to this field are to be allowed.  If the specified expression does not evaluate
// to true, the field will be removed from the request as described for 
// +link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication}.
// <p>
// In addition to the normal context variables available to Velocity expressions in SmartClient,
// expressions you write for field-level <code>requires</code> clauses - <code>editRequires</code>, 
// +link{viewRequires,viewRequires}, +link{initRequires,initRequires} and 
// +link{updateRequires,updateRequires} - can reference two additional variables: 
// <code>$fieldName</code> and <code>$dsName</code>.  These are the names of the dataSource and 
// field currently undergoing <code>requires</code> checks.  They are helpful because they allow
// you to write a generic checker function that can be used to handle <code>requires</code>
// checks for multiple fields and dataSources.
// <p>
// <b>NOTE:</b> This property prevents both initialization and updates for a field.  If you 
// have a need to prevent <em>just</em> initialization or <em>just</em> updates, you can use
// +link{dataSourceField.initRequires} or +link{dataSourceField.updateRequires}.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @see dataSourceField.viewRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.initRequires (VelocityExpression : null : IR)
// Indicates that the specified +link{type:VelocityExpression} must evaluate to true if
// initializations of this field are to be allowed.  If the specified expression does not 
// evaluate to true, the field will be removed from the request as described for 
// +link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication}.
// <p>
// In addition to the normal context variables available to Velocity expressions in SmartClient,
// expressions you write for field-level <code>requires</code> clauses - <code>initRequires</code>, 
// +link{viewRequires,viewRequires}, +link{editRequires,editRequires} and 
// +link{updateRequires,updateRequires} - can reference two additional variables: 
// <code>$fieldName</code> and <code>$dsName</code>.  These are the names of the dataSource and 
// field currently undergoing <code>requires</code> checks.  They are helpful because they allow
// you to write a generic checker function that can be used to handle <code>requires</code>
// checks for multiple fields and dataSources.
// <p>
// <b>NOTE:</b> This property only prevents initialization of a field; updates will still be 
// allowed.  You should only use this property if you have a special requirement; ordinarily,
// use +link{dataSourceField.editRequires}, which applies security for both types of write.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @see dataSourceField.viewRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.updateRequires (VelocityExpression : null : IR)
// Indicates that the specified +link{type:VelocityExpression} must evaluate to true if
// updates to this field are to be allowed.  If the specified expression does not 
// evaluate to true, the field will be removed from the request as described for 
// +link{dataSourceField.editRequiresAuthentication,editRequiresAuthentication}.
// <p>
// In addition to the normal context variables available to Velocity expressions in SmartClient,
// expressions you write for field-level <code>requires</code> clauses - <code>updateRequires</code>, 
// +link{viewRequires,viewRequires}, +link{editRequires,editRequires} and 
// +link{initRequires,initRequires} - can reference two additional variables: 
// <code>$fieldName</code> and <code>$dsName</code>.  These are the names of the dataSource and 
// field currently undergoing <code>requires</code> checks.  They are helpful because they allow
// you to write a generic checker function that can be used to handle <code>requires</code>
// checks for multiple fields and dataSources.
// <p>
// <b>NOTE:</b> This property only prevents update of a field; initialization will still be 
// allowed.  You should only use this property if you have a special requirement; ordinarily,
// use +link{dataSourceField.editRequires}, which applies security for both types of write.
//
// @requiresModules SCServer
// @see dataSourceField.editRequiresAuthentication
// @see dataSourceField.editRequiresRole
// @see dataSourceField.viewRequires
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.creatorOverrides (boolean : null : IR)
// Indicates that normal declarative security rules specified on this field are waived for 
// rows that were created by the current user, as described in the discussion of 
// +link{DataSource.creatorOverrides,dataSource.creatorOverrides}.  This setting overrides 
// <code>dataSource.creatorOverrides</code>, for this field only.
// <p>
// Note that field-level <code>creatorOverrides</code> is conceptually slightly different to
// the setting at DataSource and OperationBinding levels.  To give the example of a fetch 
// operation, at the other two levels, it results in a limited set of rows being returned, 
// rather than a security exception being thrown.  At the field-level, it results in values 
// for individual fields being present in those rows, rather than them being stripped out on
// the server.
//
// @requiresModules SCServer
// @see dataSourceField.editRequires
// @see dataSourceField.viewRequires
// @see dataSource.creatorOverrides
// @group fieldLevelAuth
// @group declarativeSecurity
// @serverDS only
// @visibility external
//<


// Auditing
// ---------------------------------------------------------------------------------------------

//> @attr dataSource.audit (boolean : false : [IR])
// Enables saving of a log of changes to this DataSource in a second DataSource with the same
// fields, called the "audit DataSource".  <b>NOTE</b>: this feature applies to Enterprise
// Edition only; for more information on edition-specific features, see
// +externalLink{http://smartclient.com/product}.
// <p>
// When auditing is enabled, every time a DSRequest modifies this DataSource, a Record is added
// to the audit DataSource that shows the record as it existed after the change was made (or
// for a "remove", the values of the record at the time of deletion).  In addition, the audit
// DataSource has the following additional metadata fields:
// <ul>
// <li> +link{auditTypeFieldName,"audit_operationType"}: type of the change ("update", "add" or "remove")
// <li> +link{auditUserFieldName,"audit_modifier"}: username of the user that made the change.  The username is
//      determined in the same way that the 
//      +link{operationBinding.requiresRole,Declarative Security} subsystem determines the 
//      current user.
// <li> +link{auditTimeStampFieldName,"audit_changeTime"}: a field of type "datetime" recording
//      the timestamp of the change
// <li> +link{auditRevisionFieldName,"audit_revision"}: a field of type "sequence" recording a
//      simple increasing integer value
// <li> +link{auditChangedFieldsFieldName,"audit_changedFields"}: a
//      +link{DataSourceField.multiple,"multiple"} field of type "string".  For "update"
//      operations, records which fields have changed; otherwise, null
// </ul>
// <p>
// If any of the field names above collide with field names of the DataSource being audited,
// an integer suffix will also be added, starting with 2 (for example, "audit_modifier2", then
// "audit_modifier3", etc).
// <p>
// To omit a data field from the automatically generated audit DataSource, just set
// +link{dataSourceField.audit} to false.  Audit can be disabled for a given DSRequest via
// the server-side API <code>DSRequest.setSkipAudit()</code>, or for a specific operation 
// via the +link{operationBinding.skipAudit,operationBinding.skipAudit} setting.
// <p>
// Note: The DataSource audit feature works only with single row operations; operations with 
// +link{operationBinding.allowMultiUpdate,allowMultiUpdate} enabled are not supported.
// <p>
// <h4>Auto-generated Audit DataSources</h4>
// <p>
// The audit DataSource is normally automatically generated, and unless otherwise specified
// with +link{dataSource.auditDataSourceID}, the ID of the audit DataSource will be
// <code>audit_[OriginalDSID]</code>.  
// <p>
// By default, the automatically generated audit DataSource will be of the same type as the
// DataSource being audited, however, if the DataSource being audited is not already a
// SQLDataSource, we recommend using +link{auditDSConstructor,auditDSConstructor:"sql"} to use
// a SQLDataSource as the audit DataSource.  This is because a SQLDataSource used an audit
// DataSource will automatically generate a SQL table for storing audit data the first time
// changes are made.  JPA would require manual creation of a Java Bean, and Hibernate requires 
// +externalLink{http://www.google.com/search?q=hbm2ddl.auto,hbm2ddl.auto=update} to be set,
// which is widely considered unsafe for production use.
// <p>
// Automatically created audit DataSources can be loaded and queried just like other
// DataSources, using the DataSourceLoader, and using the server-side API
// <code>DataSource.getAuditDataSource()</code>.  However, you <b>must</b> load the DataSource
// being audited before loading its automatically created audit DataSource.
// <p>
// Note, that automatic SQL tables creation can be disabled. See 
// +link{dataSource.autoCreateAuditTable,autoCreateAuditTable} for details.
// <p>
// <h4>Manually created Audit DataSources</h4>
// <p>
// The audit DataSource can also be manually created.  In this case, you can 
// can either follow the naming conventions described above for the ID of the audit DataSource
// and the names of metadata fields, or use the linked properties to assign custom names.  If
// you omit any data fields from the tracked DataSource in your audit DataSource, those fields
// will be ignored for auditing purposes, exactly as though +link{dataSourceField.audit} had
// been set to false for an automatically-generated audit DataSource.
// <p>
// Also, note that in case of manually defined audit DataSource, if this DataSource
// is defined so it inherits the audited DataSource, all the audited DataSource's fields
// will be inherited, this including the primary keys. Since for the audit
// DataSource the primary key should be the revision field, in order to prevent the
// audit DataSource having two primary keys, the inherited DataSource's primary key 
// will have to be declared in audit DataSource, but with the primaryKey attribute 
// omitted (as well not being of type "sequence") in the audit DataSource.
//
// @group serverDataIntegration
// @requiresModules SCServer
// @example auditing
// @serverDS only
// @visibility external
//<


//> @type FieldAuditMode
// @value "always" the field value will be saved for all audited adds and updates, regardless of
//                 whether it's changed or present in the update
// @value "change" the field value will be saved for all audited adds, and for updates in which
//                 the value changed
// @value "never"  the field value will never be saved for any DataSource audit operation
// @visibility external
//<

//> @attr dataSourceField.audit (FieldAuditMode : "always" : [IR])
// Determines when the field value should be saved to the audit DataSource when
// +link{dataSource.audit,auditing} is enabled.  Setting the property to "change" will conserve
// storage by only saving out the value when it's changed, and setting it to "never" will
// exclude the field values from ever being saved during auditing.
// <h4>Binary fields</h4>
// Because binary data can be very large compared to other data types, and in many use cases 
// does not typically change (for example, an application that stores scanned documents), 
// binary fields are treated specially for auditing purposes:<ul>
// <li>The default <code>audit</code> setting is "never"</li>
// <li>The implied <code>_filename</code>, <code>_filesize</code> and <code>_date_created</code>
// metadata fields inherit their <code>audit</code> setting from the associated binary field,
// if no explicit setting is provided for the metadata field, but this does not include inheriting the 
// the implicit "never" default.  See the +link{group:binaryFields,binary fields overview} 
// for more details about the binary metadata fields, including how to provide explicit 
// properties for them</li>
// <li>By default, we determine if the binary content has changed by comparing the 
// <code>_filename</code> and <code>_filesize</code> metadata values.  If both those values are
// unchanged, we assume the content is also unchanged.  If you want to compare the actual 
// binary content instead, set <code>DataSource</code> property 
// +link{DataSource.compareMetadataForAuditChangeStatus} to false, but bear in mind this may
// have performance implications, as described in the documentation for that property</li>
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditDataSourceID (String : null : [IR])
// For DataSources with +link{audit,auditing enabled}, optionally specifies the ID of the audit
// DataSource.  If this property is not specified, the ID of the audit DataSource will
// be <code>audit_[OriginalDSID] </code>
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditUserFieldName (String : "audit_modifier" : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the field name used to store
// the user who performed the operation.  If empty string is specified as the field name, the
// audit DataSource will not store this field.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditTimeStampFieldName (String : "audit_changeTime" : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the field name used to store
// the timestamp when the operation was performed (in a field of type "datetime").  If empty
// string is specified as the field name, the audit DataSource will not store this field.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditRevisionFieldName (String : "audit_revision" : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the field name used to store
// the revision number for the change (in a field of type "sequence").  If empty
// string is specified as the field name, the audit DataSource will not store this field.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditChangedFieldsFieldName (String : "audit_changedFields" : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the field name used to store
// the names of the fields which were updated.  If empty string is specified as the field name,
// the audit DataSource will not store this field.
// <P>
// Note that this field will only be set for +link{type:DSOperationType,update} operations.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditChangedFieldsFieldLength (Integer : 255 : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the length of the field used 
// to store the names of the fields which were updated.  See also 
// +link{dataSource.auditChangedFieldsFieldName}
// <p>
// To set the changedFields field length for all DataSources that do not override the default,
// set <code>audit.auditChangedFieldsFieldLength</code> in your <code>server.properties</code>
// file.  For example <pre>
//        audit.auditChangedFieldsFieldLength: 512
// </pre>
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditTypeFieldName (String : "audit_operationType" : [IR])
// For DataSources with +link{audit,auditing enabled}, specifies the field name used to store
// the +link{type:DSOperationType,operationType} (in a field of type "text").  If empty
// string is specified as the field name, the audit DataSource will not store this field.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.auditDSConstructor (String : null : [IR])
// For DataSources with +link{audit,auditing enabled}, optionally specifies the
// +link{dataSource.serverConstructor} for the automatically generated audit DataSource.  The
// default is to use the same <code>serverConstructor</code> as the DataSource where
// <code>audit="true"</code> was declared.
// <p>
// This property is primarily intended to allow the use of SQLDataSource
// (+link{DataSource.serverType,serverType:"sql"}) as an audit DataSource for a DataSource that
// might be of another type.  For example, you might have a DataSource that implements all CRUD
// operations via Java logic in +link{group:dmiOverview,DMI declaration} methods, and so doesn't provide generic
// storage; by using SQLDataSource as the type of your audit DataSource, you don't need to
// implement your own scheme for storing and querying audit data, and the necessary audit
// tables will be automatically generated in the database.
// <p>
// Similarly, even if you do use a reusable DataSource type such as the built-in JPADataSource,
// using SQLDataSource for audit DataSources means there's no need to write a JPA bean just to
// achieve storage of an audit trail.
// <p>
// To simplify this intended usage, the string "sql" is allowed for
// <code>auditDSConstructor</code> as a means of specifying that the built-in SQLDataSource class
// should be used.  For any other type, use the fully qualified Java classname, as is normal
// for <code>serverConstructor</code>.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.autoCreateAuditTable (boolean : true : [IR])
// Setting <code>autoCreateAuditTable</code> to <code>true</code> indicates that audit DataSource 
// will automatically create SQL table when +link{dataSource.audit,auditing} is enabled.
// <p>
// Note, that <code>autoCreateAuditTable</code> attribute takes effect only if framework setting 
// <code>audit.autoCreateTables</code> in <code>server.properties</code> is set to <code>false</code>,
// which by default is set to <code>true</code>.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.compareMetadataForAuditChangeStatus (boolean : true : [IR])
// Only applicable to +link{group:binaryFields,binary fields} on +link{DataSource.audit,audited}
// DataSources.
// <p>
// When determining if a binary field has changed for auditing purposes, should we compare the
// metadata values (ie, the associated <code>_filename</code> and <code>_filesize</code> 
// fields) or the actual binary content?  If you set this flag to false, this will cause 
// SmartClient to fetch the existing content of any binary field from the database before any
// update, and then compare it byte by byte to the new content.  You should consider if this 
// will have performance implications for your application, particularly if you store large 
// binary values.
// <p>
// Note that value comparison of any kind is only performed if the field's 
// +link{DataSourceField.audit} setting is "change"
// @serverDS only
// @visibility external
//<
//> @attr operationBinding.skipAudit (boolean : null : [IR])
// Setting <code>skipAudit</code> to <code>true</code> indicates that +link{dataSource.audit,auditing} 
// must be skipped for this operationBinding.
// <p>
// Note, that this setting can be overrided by server-side API <code>DSRequest.setSkipAudit()</code>.
//
// @serverDS only
// @visibility external
//<

// Miscellaneous
// --------------------------------------------------------------------------------------------

//> @attr dataSourceField.customSQL (boolean : null : IR)
// For a DataSource with +link{dataSource.serverType,serverType} "sql" or "hibernate",
// indicates that this field should be omitted by default from all SQL or Hibernate operations,
// and will only be used with +link{group:customQuerying,custom queries}.
// <P>
// Having marked a field as <code>customSQL</code> you can refer to it via
// $criteria.<i>fieldName</i> or $values.<i>fieldName</i> in customized queries.
// <P>
// The following are situations where you would <b>not</b> use <code>customSQL</code>:
// <ul>
// <li>simple joins where you want to enable users to see and search on a field from another
// table; consider +link{dataSourceField.includeFrom} instead
// <li>fields where you want to calculate or transform values in SQL on load or save, but
// always perform the same calculation for each operationType; consider instead
// +link{sqlStorageStrategy} for some common cases, or 
// +link{customSelectExpression}, +link{customUpdateExpression} and
// +link{customInsertExpression} for full customization
// <li>a special fetch is needed where the field needs to be excluded from the
// $defaultWhereClause so that it can be used in a custom &lt;whereClause&gt; - consider
// +link{operationBinding.excludeCriteriaFields} instead
// </ul>
// <P>
// Use customSQL in situations like:
// <ul>
// <li>there are multiple variations of the "fetch" operation with different
// +link{operationBinding.operationId,operationIds}, and the field is only used in some of them;
// in that case, consider using +link{operationBinding.customFields} to selectively re-introduce
// SQL generation for the field only in operations where it's used.
// <li>the field represents hidden criteria on a field in another table where the field is
// never shown to the user
// <li>the field is a write-only value only saved in some operations
// <li>more than one data access strategy is in use (eg direct SQL for fetch and bean-based
// persistence accessed via DMI for saves) and certain fields are not available in SQL
// </ul>
//
// @serverDS allowed
// @visibility customSQL
//<




//> @attr dataSourceField.customSelectExpression (VelocityExpression : null : IR)
// This property indicates that this field represents a custom expression that should be 
// embedded in the generated SQL instead of a reference to this field.  For example, if 
// you have a field <code>partialName</code> where this value is set to 
// <code>SUBSTR(surname, 2)</code>, the generated SQL would look similar to this:
// <pre>
//   SELECT ... SUBSTR(surname, 2) AS partialName ...
// </pre>
// Note that adding "AS partialName" as shown above is required - this is how the framework
// identifies the expression as producing a value for this particular DataSourceField when
// results are received from the database.
// <p>
// Fields with <code>customSelectExpression</code> set can be used for sorting and filtering in
// the normal way, but they are only applicable to update-type operations if you also provide a
// corresponding +link{customUpdateExpression,customUpdateExpression} and/or 
// +link{customInsertExpression,customInsertExpression}.  See the documentation 
// for those methods for the rules of how they are applied.
// <p>
// You can use Velocity expressions in your <code>customSelectExpression</code>s, and the 
// +link{group:velocitySupport,usual context variables} are available.  Note that the results
// of Velocity evaluations are automatically quoted and escaped by default; this behavior can
// be switched off - see +link{autoQuoteCustomExpressions,autoQuoteCustomExpressions}, and 
// particularly note the warnings about its use.
// <p>
// Note that this property only applies to users of the SmartClient server using dataSources of
// type "sql".
//
// @see customUpdateExpression
// @see customInsertExpression
// @see customCriteriaExpression
// @see autoQuoteCustomExpressions
// @serverDS only
// @visibility customSQL
//<

//> @attr dataSourceField.customUpdateExpression (VelocityExpression : null : IR)
// This property specifies the value to use to update this column on "update" operations.
// The value of this property will be passed through Velocity evaluation and then embedded
// directly in the SQL generated to perform the update.  It can be used in conjunction with
// +link{customSelectExpression,customSelectExpression} to provide bi-directional mapping 
// between application data formats and persisted data formats.  Or, it can be used 
// unilaterally as a means of silently enforcing data rules - for example, ensuring that all 
// values for a given field are in upper case.
// <P>
// You can use Velocity expressions in your <code>customUpdateExpression</code>s, and the 
// +link{group:velocitySupport,usual context variables} are available.  Note that the results
// of Velocity evaluations are automatically quoted and escaped by default; this behavior can
// be switched off - see +link{autoQuoteCustomExpressions,autoQuoteCustomExpressions}, and 
// particularly note the warnings about its use.
// <p>
// The value must be a string that will end up as a valid SQL snippet after Velocity
// evaluation.  The following examples are valid:
// <ul>
// <li><code>"SUBSTR(ANOTHER_COLUMN, 1, 10)"</code></li>
// <li><code>"SUBSTR($values.someTextField.toUpperCase(), 1, 10)"</code></li>
// <li><code>"SOME_NUMERIC_COLUMN * 1000"</code></li>
// <li><code>"$values.someTextField.toUpperCase()"</code> (this is a technically valid but 
// incorrect usage - see below)</li>
// </ul>
// <b>NOTE:</b> although all these examples are valid, <code>customUpdateExpression</code> is
// intended to be used when you have a need to customize the actual SQL.  If you simply want
// to use a server-derived value in the query (as is the case with the last of these 
// examples), you should use +link{group:transactionChaining,Transaction Chaining}, 
// +link{group:dmiOverview,DMI}, or a +link{group:serverScript,server script} instead.  
// <P>
// In the examples above, the first is an actual SQL snippet and must not be enclosed
// in quotes.  The second shows an SQL snippet containing a literal - because the literal is 
// the result of a Velocity evaluation, it will be automatically quoted so there is no need 
// to do so manually.  The third example yields a number, so it must not be quoted.
// The last example is also the result of a Velocity evaluation and thus does not need to
// be quoted.  Note, however, that this example involves no SQL customization - this kind of 
// usage should be avoided, as noted above.
// <p>
// When an "update" operation runs, any fields that specify 
// +link{customSelectExpression,customSelectExpression} but do <b>not</b> specify 
// customUpdateExpression will be ignored.  When an "add" operation runs, this property acts 
// as a default for any fields that do not specify a 
// +link{customInsertExpression,customInsertExpression}; similar to update, any fields that 
// specify a customSelectExpression but do not specify either a customUpdateExpression or 
// customInsertExpression, will be ignored when "add" operations run.
// <p>
// Note that this property only applies to users of the SmartClient server using dataSources of
// type "sql".
//
// @see customSelectExpression
// @see customInsertExpression
// @see customCriteriaExpression
// @see autoQuoteCustomExpressions
// @serverDS only
// @visibility customSQL
//<

//> @attr dataSourceField.customInsertExpression (VelocityExpression : null : IR)
// This property is similar to +link{customUpdateExpression,customUpdateExpression}; its value
// is used during "add" operations.  If you do not specify this property, but do specify a 
// <code>customUpdateExpression</code>, the <code>customUpdateExpression</code> is used instead.
// <P>
// Everything that applies to <code>customUpdateExpression</code> also applies to this property,
// including the observation that fields which specify a 
// +link{customSelectExpression,customSelectExpression} but no corresponding 
// <code>customUpdateExpression</code> or <code>customInsertExpression</code>, will be ignored
// when adding new records.
// <p>
// As with <code>customUpdateExpression</code>, this property is only intended to be used when
// you have a need to customize the actual SQL.  If you simply want to use a server-derived 
// value in the query, you should use +link{group:transactionChaining,Transaction Chaining}, 
// +link{group:dmiOverview,DMI}, or a +link{group:serverScript,server script} instead.
//
// <h3><code>customInsertExpression</code> with <code>primaryKey</code> fields</h3>
//
// if you use <code>customInsertExpression</code> to derive a value for a 
// +link{dataSourceField.primaryKey,primaryKey} field, the key value will not by default be 
// available to the framework, so the built-in cache synchronization system will not work.
// It may be possible to to work around this with the 
// +link{dataSourceField.autoGenerated,autoGenerated} flag, as described below, but otherwise 
// you must also create a +link{operationBinding.cacheSyncOperation,cacheSyncOperation} which 
// can retrieve the record just added to the database.  Please also see the documentation for
// +link{type:SequenceMode,SequenceMode "none"}, which talks further about cacheSyncOperation.
// <p>
// Typically, <code>primaryKey</code> fields that need to be auto-generated are implemented
// using a sequence field, which at the database level translates to either an actual sequence,
// or an auto-increment or "identity" column.  JDBC drivers have special support for such
// columns, so we are able to determine the generated value.  This is important for primaryKey 
// fields because, without it, we cannot re-fetch the record just inserted for cache 
// synchronization purposes, as described above.  Where a value is generated by something other
// than a sequence field, this special ability is lost - or at least, it is no longer 
// guaranteed to be present.
// <p>
// There are use cases where this may seem to be a restriction.  A common case would be where 
// you wish to use a generated UUID as primaryKey value, rather than an ordinary ascending 
// sequence.  If you had intended to do this using the database itself - for example, 
// specifying a <code>customInsertExpression</code> that calls something like MySQL's 
// <code>UUID()</code> built-in function - this is potentially a problem.  What we
// would recommend in this case and anything similar, is to use the general ability for field 
// values to be generated by application code, as described above.  (Note, if you want to have
// application code generate values for primaryKey fields, you may need to use an 
// +link{OperationBinding,operationBinding} that specifies 
// +link{operationBinding.providesMissingKeys,providesMissingKeys}). 
// <p>
// That said, different database vendors implement their JDBC drivers in different ways, and 
// with the SQLDataSource and certain database products it <i>is</i> possible to retrieve 
// values that were generated at the database level by a <code>customInsertExpression</code> 
// that expresses either a user-defined function call or an inline subselect, as long as the 
// field is marked with the <code>autoGenerated</code> flag.  Because this behavior
// is potentially useful, we do not inhibit it; however, we also do not recommend that you make 
// use of it, because the behavior is not portable across databases, and may also not be 
// portable across JDBC driver versions (because the behavior is unspecified and undocumented,
// and relies on implementation details that may change).  Databases where this behavior has 
// been observed to work include Oracle, Postgres and HSQLDB; databases where this behavior is 
// known not to work include MySQL, SQL Server, DB2 and Firebird (the latter because its JDBC 
// driver does not support the <code>getGeneratedKeys()</code> API). Note that in order to
// retrieve values that were generated at database level +link{SequenceMode} needs to be set to
// "jdbcDriver" via +link{DataSource.sequenceMode} or via "sql.MyDatabase.sequence.mode"
// +link{group:sqlSettings,SQL setting}.
// <p>
// Note that this property only applies to users of the SmartClient server using dataSources of
// type "sql".
//
// @see customUpdateExpression
// @see customSelectExpression
// @see customCriteriaExpression
// @see autoQuoteCustomExpressions
// @serverDS only
// @visibility customSQL
//<

//> @attr dataSourceField.customCriteriaExpression (VelocityExpression : null : IR)
// This property indicates that this field should be represented by a custom expression
// embedded in the WHERE clause of the generated SQL, instead of the generated expression
// containing this field name that would ordinarily be used.  You use this property when 
// you have to accomodate some special way of using a field's value in criteria, other than by
// directly comparing it to the criteria.  For example, if you have a column that contains 
// bit-packed information you will generally need to perform a bitwise AND to filter on that 
// column, rather than an equality check.  In this case, you would use a 
// <code>customCriteriaExpression</code> something like this (in Oracle):
// <p>
// <code>&nbsp;&nbsp;&nbsp;BITAND(myField, $criteria.myField)+0 = $criteria.myField</code>
// <p>
// Or this (in MySQL or SQL Server):
// <p>
// <code>&nbsp;&nbsp;&nbsp;myField & $criteria.myField = $criteria.myField</code>
// <p>
// As this example shows, a <code>customCriteriaExpression</code> is expected to be a complete
// logical expression that provides both sides of the comparison.  After Velocity processing,
// this example would result in SQL similar to this (for the MySQL case); the colored part 
// comes entirely from the <code>customCriteriaExpression</code>:
// <p>
// <code>SELECT myField, myOtherField FROM myTable WHERE <font color='blue'>myField & 32 = 32</font></code>
// <p>
// <code>customCriteriaExpression</code> can also be used with <code>AdvancedCriteria</code>.
// Note that the point mentioned above, about a <code>customCriteriaExpression</code> being a 
// complete logical expression that provides both sides of the comparison still applies.  This
// means that when you use <code>customCriteriaExpression</code> in conjunction with 
// <code>AdvancedCriteria</code>, you effectively switch off support for different 
// +link{type:OperatorId}s to be used on that field, unless you use Velocity expressions 
// containing the special <code>$criteriaOperator</code> variable (see below).
// <p>
// When you use <code>customCriteriaExpression</code> with <code>AdvancedCriteria</code>, the 
// way you access criteria values differs slightly.  One option is to use the 
// <code>$advancedCriteria</code> Velocity variable, as described in the "Using AdvancedCriteria"
// section of the +link{group:customQuerying,custom querying overview}.  However, this 
// variable only returns the value from the first +link{object:Criterion} that uses the field,
// as found by depth-first search.  If your <code>AdvancedCriteria</code> contains multiple 
// references to this field, this will not be satisfactory.  Therefore, specifically for 
// <code>customCriteriaExpression</code>, we provide another Velocity variable, 
// <code>$criteriaValue</code>.  This variable means "the value on a Criterion referencing 
// this field".  An example may serve to clarify this:
// <p>
// Assume you need to extend the above example to filter records where a certain bit is set 
// OR a certain other bit is set.  An <code>AdvancedCriteria</code> like this would be 
// required (note that the choice of "equals" as the operator in these clauses is completely
// arbitrary - as discussed above, the operator is ignored when we have a 
// <code>customCriteriaExpression</code>, so it would make no difference to the end product 
// if we had used different operators here):<pre>
//   { _constructor: "AdvancedCriteria", operator: "or", criteria: [
//       { fieldName: "myField", operator: "equals", value: 32 },
//       { fieldName: "myField", operator: "equals", value: 64 },
//     ]
//   }       
// </pre>
// If you used the <code>customCriteriaExpression</code> from above unchanged with this criteria,
// the following SQL would be generated (in the MySQL case):
// <p>
// <code>SELECT myField, myOtherField FROM myTable WHERE myField & null = null OR myField & null = null</code>
// <p>
// This is because <code>$criteria</code> is a variable that only works correctly with simple
// criteria.  If you changed the <code>$criteria</code> references in the expression to 
// <code>$advancedCriteria</code>, the generated SQL would be:
// <p>
// <code>SELECT myField, myOtherField FROM myTable WHERE myField & 32 = 32 OR myField & 32 = 32</code>
// <p>
// This is because <code>$advancedCriteria</code> always returns the first value it finds for
// a particular field, as described above.  However, if you change the expression so it reads:
// <p>
// <code>&nbsp;&nbsp;&nbsp;myField & $criteriaValue = $criteriaValue</code>
// <p>
// you will now get the correct SQL generated:
// <p>
// <code>SELECT myField, myOtherField FROM myTable WHERE myField & 32 = 32 OR myField & 64 = 64</code>
// <p>
// Similar to <code>$criteriaValue</code>, we provide a special variable, 
// <code>$criteriaOperator</code>.  This is intended for use in Velocity expressions, so that 
// your <code>customCriteriaExpression</code> can process different operators in different ways.
// How you choose to interpret an operator is entirely up to you; this variable is both 
// advanced and rarely used.  This example is contrived and does not show a usage that would be 
// remotely likely in a real application, but it does show how to use the variable in a Velocity
// expression:
// <p>
// <code>&nbsp;&nbsp;&nbsp;myField #if ($criteriaOperator == "greaterThan") & #else | #end $criteriaValue = $criteriaValue</code>
// <p>
// For simple criteria, note that <code>$criteriaOperator</code> will vary depending on field
// type and the +link{type:TextMatchStyle,textMatchStyle} in force, as follows:<ul>
// <li>Text fields with textMatchStyle "substring" - "iContains"</li>
// <li>Text fields with textMatchStyle "startsWith" - "iStartsWith"</li>
// <li>Text fields with textMatchStyle "exact" - "iEquals"</li>
// <li>All other cases (including text fields with textMatchStyle "exactCase") - "equals"</li>
// </ul>
// You can use Velocity expressions in your <code>customCriteriaExpression</code>s, and the 
// +link{group:velocitySupport,usual context variables} are available.  Note that the results
// of Velocity evaluations are automatically quoted and escaped by default; this behavior can
// be switched off - see +link{autoQuoteCustomExpressions,autoQuoteCustomExpressions}, and 
// particularly note the warnings about its use.
// <p>
// Note that this property only applies to users of the SmartClient server using dataSources of
// type "sql".
//
// @see customSelectExpression
// @see customUpdateExpression
// @see customInsertExpression
// @see autoQuoteCustomExpressions
// @serverDS only
// @visibility customSQL
//<

//> @attr dataSourceField.autoQuoteCustomExpressions (boolean : true : IR)
// If explicitly set to false, switches off automatic quoting and escaping of values in
// custom expressions that are derived from Velocity evaluations.
// <p>
// By default, any part of a +link{customSelectExpression,customSelectExpression},
// +link{customCriteriaExpression,customCriteriaExpression},
// +link{customUpdateExpression,customUpdateExpression} or 
// +link{customInsertExpression,customInsertExpression} that comes ultimately from evaluating
// a Velocity expression, will be automatically quoted and escaped according to the syntax 
// of the underlying database.  We do this because "raw" values are vulnerable to 
// <a href="http://en.wikipedia.org/wiki/SQL_injection">SQL injection attacks</a>.
// <p>
// However, it is possible that the exact SQL logic you desire for a custom expression cannot
// be expressed without access to the raw, unquoted value.  To work around this, you can either
// use the special +link{group:velocitySupport,$rawValue} context variable, or you can set this
// property to false to switch off auto-quoting completely for all custom expressions on this
// field.
// <P>
// <b>Warning</b>:  Bear in mind that it is <b>dangerous</b> to use raw values.  There are some
// cases where using the raw value is necessary, but even so, all such cases are likely to be
// vulnerable to injection attacks.  Generally, the presence of <code>$rawValue</code> in a 
// custom expression, or any fields with <code>autoQuoteCustomExpressions: false</code> 
// specified, should be viewed as a red flag.
//
// @see customSelectExpression
// @see customUpdateExpression
// @see customInsertExpression
// @see customCriteriaExpression
// @serverDS only
// @visibility customSQL
//<


//> @attr dataSourceField.nativeName (String : null : IR)
// Only applicable to "sql" dataSources. If set, this property indicates that the field is 
// bound to the column named in the property.  It is used to bind a DataSourceField to a 
// database column with a different name.
// <p>
// <code>nativeName</code> is useful for disambiguating in cases where you have customized 
// SQL.  For example, assume you are joining two tables - call them <code>product</code> and
// <code>supplier</code> - that both contain a column called "name".  Only one field in the 
// DataSource can be called "name"; to disambiguate, we need to specify both 
// +link{dataSourceField.tableName,tableName} and <code>nativeName</code>.  A field declaration 
// like this would be needed:<br>
// <pre>    &lt;field name="supplierName" type="text" tableName="supplier" nativeName="name" /></pre>
// <p>
// You may also wish to use this property to map legacy column names to more meaningful field
// names in the DataSource.  For example:<br>
// <pre>    &lt;field name="productName" type="text" nativeName="PRDNM" /></pre>
// <p>
// Note that it is not allowed to have multiple fields with the same <code>nativeName</code> 
// bound to the same database table.
//
// @see tableName
// @serverDS only
// @visibility customSQL
//<


//> @attr dataSourceField.tableName (String : null : IR)
// Only applicable to "sql" dataSources, setting <code>tableName</code> indicates that this
// field will be coming from another table by way of a 
// +link{group:customQuerying,customized SQL query}.
// <P>
// By default, the SQL generator will <b>not</b> include this field in generated SQL for "add"
// or "update" operations.  It will include the field in the SELECT clause and WHERE clause of
// customized "fetch" operations, where it is expected that you will make the table available
// via a custom &lt;tableClause&gt; as shown in +explorerExample{largeValueMapSQL,this sample}.
// <P>
// The table name will also be used to qualifying the column name unless
// +link{DataSource.qualifyColumnNames} or +link{OperationBinding.qualifyColumnNames} has been
// disabled.
// <p>
// <b>Note:</b> This property is only required when including fields from tables other than the
// default table specified by +link{DataSource.tableName}.
//
// @see nativeName
// @serverDS only
// @visibility customSQL
// @example largeValueMapSQL
//<

//> @attr dataSourceField.exportForceText (boolean : false : IR)
// When using +link{dataSource.recordsAsText}, determines what approach (if any) should be used
// to force values to be intepreted as text instead of heuristically parsed as dates, times or
// other structured types.
// @see TextExportSettings.forceText
// @visibility external
//<

//> @type FieldImportStrategy
// Options for how values in the import dataset (for example, the CSV file) are transformed
// during import if the field is a +link{dataSourceField.foreignKey,foreignKey} mapped to a 
// +link{dataSourceField.displayField,displayField}
// @value "key" The import process expects values in the import dataset to be the real 
//        underlying key values, and performs no transformation
// @value "display" The import process expects values in the import dataset to be display 
//        values, and it will transform them to the corresponding underlying keys if found
// @value "displayRequired" Same as "display", but results in
//        +link{dataSourceField.importStrategyFailedErrorMessage,validation error} if
//        corresponding underlying keys were not found
// @value "auto" The import process will attempt to discover the best setting to use, based
//        on the values in the first record, and use that setting for every remaining record
//        in the import dataset
// @see dataSourceField.importStrategy
// @visibility external
//<


//> @attr dataSourceField.importStrategy           (FieldImportStrategy : null : [IR])
// Declares the <code>FieldImportStrategy</code> for this field.  The default setting of null 
// has the same meaning as "auto".  Note, this attribute only has an effect if all of the 
// following are true:<ul>
// <li>The field declares a +link{dataSourceField.foreignKey,foreignKey}</li>
// <li>The field declares a +link{dataSourceField.displayField,displayField}</li>
// <li>The displayField so declared is +link{dataSourceField.includeFrom,included from} the 
// same DataSource that the <code>foreignKey</code> declaration refers to</li>
// </ul>
// In any other circumstances, this attribute is ignored.
// <p>
// <code>importStrategy</code> is applied by the server-side 
// <code>DataImport.importToRows()</code> method, which is in turn used by
// +link{class:BatchUploader} and several other DataImport APIs such as 
// <code>importToDataSource()</code>, <code>importDataSourceRecords()</code> and 
// <code>importAndValidateDSRows()</code>.  See the server-side documentation for
// details of these APIs.  The actual data transformation is carried out by the 
// server-side API <code>DataSource.transformImportValue()</code>; this method can 
// be overridden to carry out any other transformation you may require.
// @see dataSourceField.batchUploadOperationId
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.importStrategyFailedErrorMessage           (String : null : [IR])
// Customizable and +link{group:i18n,localizable} error message to use when "displayRequired"
// +link{dataSourceField.importStrategy,importStrategy} fails to find corresponding key value.
// Default message: <i>Key mapping for display value is required, but was not found</i>.
//
// @see dataSourceField.importStrategy
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.sqlStorageStrategy (String : null : IR)
// For certain field types, indicates the strategy to be used to store values to the underlying
// SQL column.
// <P>
// <b>Fields of type "boolean"</b><br>
// The default strategy for boolean fields is to assume the underlying type of the field is 
// text and store boolean true and false values as the character strings "true" and "false".  
// The following additional strategies are available:
// <ul>
// <li>"number" or "integer": store true as 1, false as 0
// <li>"singleChar10": store true as "1", false as "0"
// <li>"singleCharYN": store true as "Y", false as "N"
// <li>"singleCharTF": store true as "T", false as "F"
// <li>"singleChar": store as a single character, using the values defined by 
// +link{dataSourceField.sqlTrueValue,sqlTrueValue} and 
// +link{dataSourceField.sqlFalseValue,sqlFalseValue}
// <li>"string": store the entire values defined by 
// +link{dataSourceField.sqlTrueValue,sqlTrueValue} and 
// +link{dataSourceField.sqlFalseValue,sqlFalseValue}
// </ul>
// <P>
// <b>Fields of type "date", "time", and "datetime"</b><br>
// The default strategy for these types is to use a native type that supports date and 
// time values to the nearest second; the actual type used varies by database.  The following
// additional strategies are available:
// <ul>
// <li>"nativeDate": Use a native SQL DATE type</li>
// <li>"number" or "integer": Store the value as a plain numeric value</li>
// <li>"text": Store the value as a plain text value</li>
// </ul>
// The "number" and "text" strategies for date/time/datetime fields are provided to allow transparent
// two-way mapping of legacy date values; you would not ordinarily use them in the absence of a
// legacy database.  In both cases, the actual format of the number or text string is determined
// by specifying a +link{dataSourceField.sqlDateFormat,sqlDateFormat} on the field; if no 
// format is specified, the framework defaults to "yyyyMMdd".
// <P>
// <P>
// <b>Fields of type "text"</b><p>
// <em>NOTE: This section is only applicable for users of Microsoft SQL Server.  The "ntext"
// strategy is ignored for all other databases.</em><p>
// If you are integrating with Microsoft SQL Server, you may run into an issue with that database
// and double-byte character sets.  Although the documentation indicates that string values are 
// sent to the database as Unicode by default, they may undergo conversion at the database end, 
// depending on the collation settings of the database.  
// <a href=http://support.microsoft.com/kb/239530>This Microsoft support article</a> describes
// the situation, which is that Unicode is converted to the code page of the database before
// being used, in order to "provide backward compatibility with existing applications".
// <P>
// To work around this, we provide an <code>sqlStorageStrategy</code> of "ntext".  Fields that
// declare this strategy are inserted into queries using the "N syntax", like so:<br>
// <code>&nbsp;&nbsp;&nbsp;UPDATE MyTable SET MyTextColumn = N'some text' WHERE MyPK = N'some key'</code>
// <P>
// This syntax overrides defaults and forces the database to treat strings as Unicode.
// <P>
// Note that declaring a field to be of +link{type:FieldType,type} "ntext" is exactly 
// equivalent to specifying type "text" and an <code>sqlStorageStrategy</code> of "ntext".  
// If you declare a field of type "ntext" when the back-end database is something other than 
// SQL Server, it will be treated as a normal field of type "text".
// <p>
// This property only applies to users of the SmartClient server using dataSources of
// type "sql".
//
// @serverDS only
// @visibility customSQL
//< 

//> @attr dataSourceField.sqlDateFormat (String : null : IR)
// For fields of type "date", "time", and "datetime" that specify an
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "number" or "text", this
// property allows you to specify the format SmartClient should use to map to/from the 
// underlying value stored in the database.  The string provided must be a valid 
// <a href=http://download.oracle.com/javase/1.4.2/docs/api/java/text/SimpleDateFormat.html>
// SimpleDateFormat pattern string</a>.
// <P>
// For fields of type "datetime" and "time" that specify an
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "number", two special
// sqlDateFormat values are supported:
// <ul>
//   <li>"epoch" - The datetime or time value is stored as the number of full seconds that have
//       elapsed since January 1, 1970, 00:00:00 GMT.</li>
//   <li>"epochms" - The datetime or time value is stored as the number of milliseconds that
//       have elapsed since January 1, 1970, 00:00:00 GMT.  Millisecond precision is preserved
//       through database roundtrips with this setting</li>
// </ul>
// <P>
// This property and the "number" and "text" strategies for date/datetime fields are provided
// to allow transparent two-way mapping of legacy date values that are stored in numeric or
// text columns respectively rather than a true "date" column.  You would not ordinarily use them
// in the absence of a legacy database.
// <P>
// Note that this property only applies to users of SmartClient server and data sources of
// type "sql".
//
// @serverDS only
// @visibility customSQL
//< 

//> @attr dataSourceField.storeMilliseconds (Boolean : null : IR)
// For fields of type "datetime", indicates whether the framework should attempt to preserve
// the millisecond part when persisting to native SQL datetime-type columns.  Whether this 
// is possible depends on the type and version of the underlying database product; some 
// databases - for example SQL Server earlier than 2008 and MySQL versions earlier than 
// 5.6 - do not provide fractional seconds support.  If you set this flag when your underlying 
// database cannot support fractional seconds, it will be ignored.
// <p>
// Other than the two cases just mentioned which are known to fail, <code>storeMilliseconds</code> 
// has been tested and is officially supported with the following products and minimum 
// versions:<ul>
// <li>Oracle 10g</li>
// <li>Microsoft SQL Server 2008</li>
// <li>MySQL 5.6</li>
// <li>MariaDB 5.3</li>
// <li>PostgreSQL 9.1</li>
// <li>HSQLDB 2.2</li>
// <li>DB2 for Unix/Linux 9.7</li>
// <li>Firebird 11.2</li>
// <li>Informix IDS 11.5</li>
// </ul>
// Note that you can use +link{sqlStorageStrategy,sqlStorageStrategy} to store a datetime 
// value with sub-second precision in <em>any</em> database - see below.
// <p>
// When the system generates SQL to insert or update datetime values including a millisecond
// element, it does so using a database-specific format string specified in property 
// <code>defaultDateTimeFormatWithMilliseconds</code> in your <code>server.properties</code> 
// file.  These format strings should conform to the rules of the
// <a href=http://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html>
// Java SimpleDateFormat class</a>.  Suitable format strings are provided for all default 
// databases out of the box; if you need to override one or provide a new one, you do so as
// shown in this example:<pre>
//   sql.MyNewDatabase.defaultDateTimeFormatWithMilliseconds: yy-MM-dd'T'hh.mm.ss.SSS</pre>
// <p>
// Note that this property only controls the persistence of milliseconds into the database;
// there is no built-in support for sub-second elements of datetimes in any SmartClient visual
// components.  See also the documentation for +link{DataSOurce.trimMilliseconds} for more 
// details of how sub-second datetime elements are handled in the client-server flow.
// <p>
// This property is only applicable to DataSources of +link{type:DSServerType,serverType} 
// "sql" and fields of +link{type:FieldType,type} "datetime".  It is ignored in all other 
// cases.  However, note that the built-in JPA and Hibernate dataSources will always persist
// millisecond values automatically if the underlying Java type, database and column support
// it.
// <p>
// Finally, note that this property only has an effect on <em>native</em> datetime-type fields.
// When you use +link{sqlStorageStrategy,sqlStorageStrategy} to store a temporal value in a 
// text or number column, it is the +link{sqlDateFormat,sqlDateFormat} you use that dictates 
// the precision.  For example, a field with <code>sqlStorageStrategy:"text"</code> and 
// <code>sqlDateFormat:"yyyy-MM-dd hh:mm:ss.SSS"</code> would store and retrieve with millisecond
// precsion; the same field with <code>sqlDateFormat:"yyyy-MM-dd hh:mm"</code> would store
// and retrieve with precision to the nearest minute only.
//
// @see DataSource.trimMilliseconds
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.sqlTrueValue (String : null : IR)
// For fields of type "boolean" that specify a 
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "singleChar", this is the
// value to persist for true values.  Note that the common use cases of storing booleans as 
// T/F, Y/N and 1/0 are already catered for without the need for this property.<br>
// For fields of type "boolean" that specify a 
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "string", this is the value
// to persist for true values that require using the entire value.
//
// @see dataSourceField.sqlStorageStrategy
// @see dataSourceField.sqlFalseValue
// @serverDS only
// @visibility customSQL
//< 

//> @attr dataSourceField.sqlFalseValue (String : null : IR)
// For fields of type "boolean" that specify a 
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "singleChar", this is the
// value to persist for false values.  Note that the common use cases of storing booleans as 
// T/F, Y/N and 1/0 are already catered for without the need for this property.<br>
// For fields of type "boolean" that specify a 
// +link{dataSourceField.sqlStorageStrategy,sqlStorageStrategy} of "string", this is the value
// to persist for false values that require using the entire value.<br>
// <p>
// You can specify NULL as a valid value for sqlFalseValue, using this XML notation:
// <pre>
// &lt;sqlFalseValue xsi:nil="true"&gt;&lt;/sqlFalseValue&gt;
// </pre>
//
// @see dataSourceField.sqlStorageStrategy
// @see dataSourceField.sqlTrueValue
// @serverDS only
// @visibility customSQL
//< 
    
    
//> @attr dataSourceField.nullReplacementValue (Any : null : IR)
// If +link{DataSource.noNullUpdates} is set, the value to use for this field when a null
// value is assigned to it on an update operation.  This property overrides the DataSource-level
// properties +link{DataSource.nullStringValue,nullStringValue}, 
// +link{DataSource.nullIntegerValue,nullIntegerValue}, 
// +link{DataSource.nullFloatValue,nullFloatValue} and 
// +link{DataSource.nullDateValue,nullDateValue}, for this field only.
// <p>
// NOTE: If you use this property, you are responsible for ensuring that the replacement value
// is appropriate and valid.
// @see DataSource.noNullUpdates
// @see DataSource.nullStringValue
// @see DataSource.nullIntegerValue
// @see DataSource.nullFloatValue
// @see DataSource.nullDateValue
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.stringInBrowser (Boolean : null : IR)
// Server-side setting that causes values for fields of type "integer" or "float" to be represented 
// as Strings when delivered to a web browser, in order to avoid mangling values which cannot be
// represented faithfully in JavaScript.
// <p>
// JavaScript has a single "Number" type which internally stores numbers in a format equivalent to
// Java's "Double" - double-precision floating point.  This means it cannot represent the full
// range of Java's Long type: Java Longs can represent integral values between -2^63 to 2^63-1,
// whereas JavaScript Number can only represent exact integer values between -2^53 and 2^53.
// Similarly, JavaScript's Number type cannot represent Java's unlimited-size BigInteger or
// unlimited-precision BigDecimal objects at all.
// <p>
// The <code>stringInBrowser</code> setting can be used to deliver numeric values as Strings to the
// browser.  This is intended to allow read-only display and successful round-tripping of the
// numeric value, however, it will not cause number-oriented features such as +link{SpinnerItem},
// +link{Slider}, +link{listGrid.showGridSummary,ListGrid summaries} or range-checking
// +link{Validator,validators} or +link{AdvancedCriteria,criteria} to actually work.
// <p>
// If <code>stringInBrowser</code> is not set, the default behavior is configured by the 
// <code>server.properties</code> setting <code>datasource.defaultStringInBrowser</code>.  If 
// this flag is false, numeric values are delivered to the client as numbers, <i>even where 
// this will lead  to a loss of precision</i>.  If the flag is true (which is the the default),
// the behavior is to prevent range overflow for numeric values:
// <ul>
// <li> Java values of type Long, BigInteger and BigDecimal will be delivered as
//      String <i>only if</i> they exceed JavaScript's number range.  
// <li> Client-side validation will allow inputs that are outside of JavaScript's normal
//      integer range, and such numbers will remain as Strings after validation, instead of being
//      converted to Numbers
// <li> Values submitted to the server will be converted to BigInteger if they exceed the range
//      of Java's Long type.  This happens during DSRequest validation, before any defined
//      +link{group:dmiOverview,DMI methods} are called.
// </ul>
// <p>
// This default set of behaviors is intended to automatically deal with cases like numeric
// +link{primaryKey} or +link{foreignKey} values that are never used as numbers, but happen to use
// the full Java Long range.  To disable the above behaviors, set <code>stringInBrowser="false"</code>.
// <p>
// If <code>stringInBrowser</code> is explicitly set to true:
// <ul>
// <li> the value for the field will <i>always</i> be delivered to the browser as a String (no
//      attempt is made to detect the value as out of range / too high precision)
// <li> client-side validation will do a check for valid format only, and always leave the value
//      as a String.  Numeric range validators are ignored client-side (always pass), but are
//      still active server-side.
// <li> AdvancedCriteria +link{type:OperatorId,operators} that check if values are in a particular
//      range will always pass
// <li> the field is treated as though +link{canFilter,canFilter:false} were set, to avoid showing
//      non-functional search interfaces to the user.  Set <code>canFilter="true"</code> to avoid
//      this effect
// </ul>
// <p>
// This setting is recommended for presenting out-of-range issues or precision loss on fields that
// represent actual quantities (as opposed to primaryKey or foreignKey fields, which really
// represent IDs).  To ensure unlimited-precision BigDecimal values are preserved, you should also
// set +link{dataSourceField.javaClass}.
// <p>
// Note that responses delivered as JSON or XML, such as responses from the
// +link{group:servletDetails,RESTHandler servlet}, are not affected.  This setting applies only
// to responses delivered to a web browser.
// <p>
// The entirety of stringInBrowser processing can be completely disabled by setting 
// <code>server.properties</code> flag <code>datasource.disableStringInBrowser</code> to true.
// This will cause all numeric values to be delivered as numbers without even attempting to 
// detect if this will lead to a loss of precision.  This setting overrides both the 
// <code>stringInBrowser</code> field setting and the 
// <code>datasource.defaultStringInBrowser server.properties</code> flag.
// <p>
// <b><code>stringInBrowser</code> and client-side DataSources</b>
// <p>
// For DataSources that are not based on the SmartClient Server, the client-side behaviors described above (such as leaving
// user input in string form if precision would be lost) are active by default.
// <p>
// In addition, if +link{dataSource.dataFormat,dataSource.dataFormat:"xml"} is used, values that would lose precision remain as strings.  For JSON,
// if behavior similar to <code>stringInBrowser</code> is desired, your server response must send the values as JSON strings
// rather than JSON numeric literals.
// <p>
// You can use +link{DataSource.defaultStringInBrowser} to disable these behaviors.  <b>NOTE:</b> don't use this setting if
// you are using the SmartClient Server, use the server.properties approach described above instead.
//
// @serverDS allowed
// @visibility external
//<




  
//> @attr dataSourceField.sortByField (String : null : IR)
// Causes values for this field to be sorted according to values for another field, for
// both client- and server-side sorting.
// <p>
// This can be used to establish a sort order for a field that is not the normal sorting
// order indicated by the field value, typically by having the <code>sortByField</code> as
// a +link{dataSourceField.hidden,hidden field}.  
// <p>
// If using SQLDataSource, consider using a +link{customSelectExpression} as an efficient
// way to populate the <code>sortByField</code> with the results of a SQL expression.
//
// @serverDS allowed
// @visibility external
//<

//> @attr   dataSourceField.ignoreTextMatchStyle    (Boolean : null : IRW)
// <b>NOTE: </b>Only applicable to +link{dataSource.clientOnly,clientOnly} DataSources and the
// built-in +link{group:sqlDataSource,SQL}, +link{group:jpaIntegration,JPA} and 
// +link{group:hibernateIntegration,Hibernate} DataSources available in Pro, Power and 
// Enterprise versions of SmartClient.
// <p>
// Use this flag to inhibit the normal use of +link{type:TextMatchStyle} for this field.  A 
// field with this flag set will always be tested for exact equality in generated queries, 
// even for filter-style queries where normal behavior would be to use a substring match or 
// similar.
// <p>
// Whether or not the exact match is case-sensitive is determined by the DataSource's 
// +link{dataSource.ignoreTextMatchStyleCaseSensitive,ignoreTextMatchStyleCaseSensitive}
// setting.
//
// @serverDS allowed
// @visibility external
//<    

// ---------------------------------------------------------------------------------------
// client-side only sorting (canSortClientOnly)

//> @attr   dataSourceField.canSortClientOnly    (boolean : false : IRW)
// When true, this field can only be used for sorting if the data is entirely client-side.
// 
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.storeWithHash (HashAlgorithm : null : IR)
// If set, causes the field to be securely hashed before saving on an "add" or "update" 
// operation.
//
// @serverDS only
// @visibility external
//<

//> @type HashAlgorithm
// Algorithms to use when hashing field values (see +link{DataSourceField.storeWithHash})
//
// @value "MD5"      Message Digest algorithm 5 
// @value "SHA"      Secure Hashing Algorithm (SHA-1)
// @value "bcrypt"   bcrypt is a password hashing function designed by Niels Provos and David
//                   Mazieres, based on the Blowfish cipher
// @visibility external
//<

// ---------------------------------------------------------------------------------------
// File upload and other binary data properties

//> @attr dataSourceField.maxFileSize    (Integer : null : IR)
// For fields of a type that are represented by binary data initially uploaded from a file
// (currently "binary" and "imageFile", see +link{type:FieldType}), this sets the maximum 
// file size allowed, in bytes.
//
// @see DataSource.maxFileSizeExceededMessage
// @serverDS only
// @visibility external
//<

//> @attr dataSourceField.encodeInResponse (boolean : null : IRW)
// When set for a field with binary data, binary data will be delivered as a Base64 encoded
// string.  
// <P>
// When <code>encodeInResponse</code> is not set normal responses will not contain values for
// binary fields at all.  Instead, UI components, such as +link{class:TileGrid} issue a second
// binary fetch for binary data when appropriate, and APIs such as +link{dataSource.downloadFile(),downloadFile()} and
// +link{dataSource.viewFile(),viewFile()} can be used to programmatically trigger downloads.
// <p>
// Only applicable to fields of a type that are represented by binary data (currently "binary"
// and "imageFile", see +link{type:FieldType}).
//
// @serverDS only
// @visibility external
//<

// ---------------------------------------------------------------------------------------
// Presentation Mode

//> @attr dataSourceField.fieldTreeId (String : null : IR)
// Value for the +link{tree.idField} used when +link{dataSource.showFieldsAsTree} is set.
//<

//>@attr dataSourceField.fieldTreeParentId (String : null : IR)
// Value for the +link{tree.parentIdField} used when +link{dataSource.showFieldsAsTree} is set.
//<

// Field Types
// --------------------------------------------------------------------------------------------

//> @type FieldType
// The types listed below are built-in types that +link{DataBoundComponent,databound
// components} understand and treat specially (using type-specific form controls, validators,
// formatters, sorting logic, etc).  
// <P>
// You can declare custom types via +link{SimpleType,SimpleType.create()}, with settings that
// will influence DataBound components.  You can also create your own subclasses of databound
// components to add further custom, reusable behaviors based on field.type.
// <P>
// <code>field.type</code> can also be the ID of another +link{DataSource}, which allows you to
// model nested structures such as XML documents (in fact, +link{XMLTools.loadXMLSchema()}
// models XML schema in this way).  Nested DataSource declarations affect how XML and JSON data
// is deserialized into JavaScript objects in the 
// +link{group:clientDataIntegration,client-side integration} pipeline, so that you can load
// complex XML documents and have them deserialized into a correctly typed nested data
// structure.
// <P>
// Note: to declare related but <i>separate</i> objects, as in an "Account" object that can be
// related to both a "Contact" object and "Order" objects, use
// +link{dataSourceField.foreignKey}, <b>not</b> a nested structure declaration.
//
// @value "text"      Generic text, e.g. <code>"John Doe"</code>. This is the default field type.
//                    Use <code>field.length</code> to set length.
// @value "boolean"   A boolean value, e.g. <code>true</code>
// @value "integer"   A whole number, e.g. <code>123</code>
// @value "float"     A floating point (decimal) number, e.g. <code>1.23</code>
// @value "date"      A logical date, with no time value (such as a holiday or birthday).
//                    Represented on the client as a JavaScript <code>Date</code> object where
//                    time values are ignored.  See +link{group:dateFormatAndStorage} for more
//                    information on date display and serialization formats.
// @value "time"      A time of day, with no date.  Represented on the client as a JavaScript
//                    <code>Date</code> object in UTC/GMT by default (see also
//                    +link{group:dateFormatAndStorage} and the +link{Time} class).
// @value "datetime"  A date and time, accurate to the +link{dataSourceField.storeMilliseconds,
//                    second}. Represented on the client as a JavaScript <code>Date</code>
//                    object. See also +link{group:dateFormatAndStorage}.
// @value "enum"      A text value constrained to a set of legal values specified by the
//                    field's +link{DataSourceField.valueMap,valueMap}, as though a
//                    +link{ValidatorType} of "isOneOf" had been declared.
// @value "intEnum"   An enum whose values are numeric.
// @value "sequence"  If you are using the SmartClient SQL datasource connector, a
//                    <code>sequence</code> is a unique, increasing whole number, incremented
//                    whenever a new record is added. Otherwise, <code>sequence</code> behaves
//                    identically to <code>integer</code>. This type is typically used with
//                    <code>field.primaryKey</code> to auto-generate unique primary keys.
//                    See also +link{dataSourceField.sequenceName} and 
//                    +link{dataSource.sequenceMode}
// @value "link"      A string representing a well-formed URL.  Some components
//                    will render this as an HTML link (using an anchor tag for example).    
// @value "image"     A string representing a well-formed URL that points to an
//                    image.  Some components will render an IMG tag with the value of this field
//                    as the 'src' attribute to render the image.
// @value "binary"    Arbitrary binary data.  When this field type is present, three additional
// fields are automatically generated.  They are: &lt;fieldName&gt;_filename, &lt;fieldName&gt;_filesize, and
// &lt;fieldName&gt;_date_created where &lt;fieldName&gt; is the value of the <code>name</code>
// attribute of this field.  These fields are marked as
// +link{attr:dataSourceField.hidden}<code>:true</code> to suppress their rendering by default.  You
// can show one or more of these fields by specifying the field with a <code>hidden:false</code>
// override in the fields array of the databound component.
// <i>Stream / view file support for custom DataSources</i>: a custom DataSource or +link{DMI} 
// must implement the "viewFile" and "downloadFile" operationTypes and return a single Record
// with a byte[] as the field value for the binary field.  For more detail see
// the overview of +link{group:binaryFields,Binary Fields}.
//
// @value "imageFile" Binary data comprising an image.  Causes +link{ViewFileItem} to be used
//                    when the field is displayed in a form, allowing the image to optionally
//                    be displayed inline.
// @value "any"       Fields of this type can contain any data value and have no default 
//                    formatting or validation behavior. This is useful as the 
//                    +link{SimpleType.inheritsFrom,parent type} for SimpleTypes
//                    where you do not want any of the standard validation or formatting logic
//                    to be inherited from the standard built-in types.
// @value "custom"    Synonymous with "any".
// @value "modifier"  Fields of this type are automatically populated by the SmartClient Server 
//                    with the current authenticated userId as part of "add" and "update" 
//                    operations.  By default, fields of this type are hidden and not editable;
//                    the server ignores any value that the client sends in a field of this type.
//                    Note that the "authenticated user" can be set explicitly on the server-side 
//                    <code>RPCManager</code> using the setUserId() method, or it can come from
//                    the servlet API if you are using its built-in authentication scheme.  See
//                    the server-side Javadocs for <code>RPCManager</code>.
// @value "modifierTimestamp"  Fields of this type are automatically populated by the SmartClient
//                    Server with the current date and time as part of "add" and "update" 
//                    operations.  By default, fields of this type are hidden and not editable;
//                    the server ignores any value that the client sends in a field of this type.
// @value "creator"   Fields of this type are automatically populated by the SmartClient Server 
//                    with the current authenticated userId as part of "add" operations.
//                    By default, fields of this type are hidden and not editable;
//                    the server ignores any value that the client sends in a field of this type.
//                    The notes about type "modifier" also apply to fields of this type.
// @value "creatorTimestamp"  Fields of this type are automatically populated by the SmartClient
//                    Server with the current date and time as part of an "add" operation (when
//                    the record is first created).  By default, fields of this type are hidden
//                    and not editable; the server ignores any value that the client sends in a
//                    field of this type.
// @value "password"  Same as "text", but causes +link{PasswordItem} to be used by default for
//                    editing (hides typed-in value).
// @value "ntext"     A special field type specifically for use with Unicode data in conjunction
//                    with the Microsoft SQL Server database.  Field type "ntext" implies the 
//                    use of +link{DataSourceField.sqlStorageStrategy,sqlStorageStrategy} "ntext";
//                    other than that, this type is identical to "text"
// @value "localeInt" An integer number with locale-based formatting, e.g. <code>12,345,678</code>.
//                    See +link{group:localizedNumberFormatting,Localized Number Formatting}
//                    for more info.
// @value "localeFloat" A float number with locale-based formatting, e.g. <code>12,345.67</code>.
//                    See +link{group:localizedNumberFormatting,Localized Number Formatting}
//                    for more info.
// @value "localeCurrency" A float number with locale-based formatting and using currency
//                    symbol, e.g. <code>$12,345.67</code>.
//                    See +link{group:localizedNumberFormatting,Localized Number Formatting}
//                    for more info.
// @value "phoneNumber" A telephone number.  Uses +link{formItem.browserInputType} "tel" to
//                    hint to the device to restrict input.  On most mobile devices that have
//                    software keyboards, this cause a specialized keyboard to appear which
//                    only allows entry of normal phone numbers.  When displayed read-only,
//                    a "phoneNumber" renders as an HTML link with the "tel:" URL scheme,
//                    which will invoke the native phone dialing interface on most mobile
//                    devices.  In addition, the CSS style "sc_phoneNumber" is applied.
//                    <p>
//                    By default, "phoneNumber" fields do not include validators, however the
//                    following validator definition would limit to digits, dashes and the
//                    "+" character:
//                    xml:
//                    <p>
//                    &lt;validator type="regexp" expression="^(\(?\+?[0-9]*\)?)?[0-9_\- \(\)]*$"
//                        errorMessage="Phone number should be in the correct format e.g. +#(###)###-##-##" /&gt;
//                    <smartclient>
//                        <p>
//                        or directly in JavaScript:
//                        <p>
// <pre>
// {type:"regexp", expression:"^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$", 
//     errorMessage:"Phone number should be in the correct format e.g. +#(###)###-##-##"}
// </pre>
//                    </smartclient>
//                    <smartgwt>
//                        <p>
//                        or directly in Java:
//                        <p>
// <pre>
// RegExpValidator v = new RegExpValidator();
// v.setType(ValidatorType.REGEXP);
// v.setErrorMessage("Phone number should be in the correct format e.g. +#(###)###-##-##");
// v.setExpression("^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$");
// </pre>
//                    </smartgwt>
//                    and adding "#" and "*" to the regular expressions above would allow for
//                    users to enter special keys sometimes used for extension numbers or
//                    pauses
//
//
// @see type:ListGridFieldType
// @see type:FormItemType
// @serverDS allowed
// @visibility external
//<


// Field formatting with format strings
// ---------------------------------------------------------------------------------------

//> @attr dataSourceField.format (FormatString : null : IRW)
// Format string to use when rendering the value in any +link{DataBoundComponent} or when
// exporting via +link{dataSource.exportData()} or +link{listGrid.exportData()} or 
// +link{listGrid.exportClientData()}.
// <P>
// Supported for fields of type "date", "time", "datetime", "int", "float" or any derived
// +link{SimpleType}. 
// <p>
// To configure a different format for export, use +link{dataSourceField.exportFormat}.
// <p>
// This is a per-field setting; you can alternatively set a default format for all "date",
// "time" or "datetime" fields via 
// <smartclient>
// +link{DateUtil.setNormalDatetimeDisplayFormat()} and related methods on +link{Date}.
// </smartclient>
// <smartgwt>
// +link{DateUtil.setNormalDatetimeDisplayFormat()} and related methods on
// +link{Date}.
// </smartgwt>
// See also +link{group:localizedNumberFormatting} for built-in +link{FieldType,FieldTypes}
// that handle localized currency formatting.
// <p>
// Also note, this property takes precedence over any specified 
// +link{DataSourceField.dateFormatter,dateFormatter}, but can be overridden on a per-component
// basis by providing a formatter directly on the component, for example, via
// +link{ListGrid.formatCellValue()} or +link{FormItem.formatValue()}.
// 
// @see DataSourceField.exportFormat
// @serverDS allowed
// @visibility external
//<

//> @attr dataSourceField.exportFormat (FormatString : null : IRW)
// An optional +link{FormatString} for this field, for use when 
// +link{dataBoundComponent.exportData(),exporting} data to spreadsheet formats (XLS and 
// OOXML/XLSX), XML, JSON or CSV.   You can use this property to override the normal
// +link{dataSourceField.format,format} of this field, if any, specifically for exports,
// for both server-based and client-driven exports.
// 
// <p>
// Note, for server-driven exports you can specify default formats for date, time and 
// datetime fields by specifying properties <code>export.format.default.date</code>, 
// <code>export.format.default.time</code> and <code>export.format.default.datetime</code>
// in your <code>server.properties</code> file.  Similarly, default formats for float and
// integer fields can be specified with <code>export.format.default.float</code> and 
// <code>export.format.default.integer</code>, respectively.  These formats will be used for
// fields that do not have a "format" or "exportFormat" property specified in the 
// <code>.ds.xml</code> file.
// <p>
// Specifically when exporting to spreadsheet formats, the <code>FormatString</code> is
// translated to the type of format string used by spreadsheet programs like Excel.  A handful
// of features are not present in Excel format strings, and some features behave slightly
// differently.  These differences are explained below.
// <p>
// <h3>Excel cannot handle dates prior to January 1st 1900</h3>
// This is a well-known limitation of Excel dates; it is not a formatting issue as such.
// <p>
// <h3>Currency symbols become fixed to the current locale at export time</h3>
// The placeholder currency symbol "&#x00A4" (\u00A4) in a numeric
// format string is rendered as the 
// <smartclient>
// +link{NumberUtil.currencySymbol, localized currency symbol}.
// </smartclient>
// <smartgwt>
// localized currency symbol returned by GWT's built-in NumberFormat class.
// </smartgwt>
// When exporting, the format string provided to Excel contains the currency symbol for the
// current locale of the SmartClient application, and not a placeholder currency symbol that
// would make Excel pick up a currency symbol based on the operating system locale.  We do this
// to ensure that the spreadsheet reflects the <em>application's</em> localization, rather than
// the localization of the current user's computer, because they may be different.
// <p>
// <h3>Rounding differences</h3>
// The approach to rounding a positive number to a set number of decimal places is fairly 
// universally agreed upon for non-specialized requirements: add 0.5 (or 0.05, or 0.005, or 
// whatever) to the number and then truncate.  This leads to the well understood convention 
// that numbers exactly halfway between two possible rounding outcomes, go to the larger one. 
// So 7.5 becomes 8 and 7.15 becomes 7.2.
// <p>
// However, there is no such universal agreement when it come to rounding negative numbers.  
// Some take the view that you should round by taking the number to the larger absolute value,
// so -7.15 becomes -7.2.  Others feel that you should round by taking the number to the larger
// value in the sense of it being "less negative", so -7.15 becomes -7.1.
// <p>
// SmartClient formatting takes the first approach and rounds negative numbers away from zero.
// We do this simply because that is what Java DecimalFormat does.  Unfortunately, Excel does
// the opposite.  Therefore, you will see rounding differences on negative numbers on exact 
// 50% boundaries: SmartClient will format -7.15 as -7.2, while Excel will format the same 
// value as -7.1.
// <p>
// <h3>Different treatment of '#'</h3>
// Both SmartClient and Excel use '#' to mean "digit, do not show zeroes".  However, Excel
// does not implement this strictly in the integer part when the number it is formatting has
// a value of 0 in the integer part.  So, with a format of "#.##", the value 0.25 is formatted 
// as "0.25".  SmartClient (like Java DecimalFormat) is strict: with that format, 0.25 is 
// formatted as ".25"; if you want to match Excel's output, you must use the format "0.##".
// <p>
// <h3>Miscellaneous edge cases</h3>
// There is quite a lot of variation in behavior between Java DecimalFormat and Excel around 
// the edges.  For actual error cases - for example, a format string that just contains 
// nonsense - it is normal and expected that the SmartClient behavior and the Excel behavior
// do not match - this is just two systems producing different garbage out for the same 
// garbage in, which is to be expected.  For valid but weird usages - for example, a format 
// with multiple percent signs - SmartClient's formatting is in line with what DecimalFormat 
// does, unless DecimalFormat throws an Exception, in which case we just do the thing that 
// seems most sensible, or the thing that was easiest to implement.
// <p>
// Known differences in behavior in edge cases include:<ul>
// <li>SmartClient ignores formatting characters in the number part of the format string, 
// whereas Excel rejects the format (this behavior may vary with different releases of Excel
// and supposedly compatible libraries: POI, for example, will accept such format strings).  
// If you attempt to format 5.175 with the format string "#b0.#a#", SmartClient will return
// "5.72", and Excel will reject the format</li>
// <li>SmartClient ignores quoted characters in the number part of the format string, 
// whereas Excel preserves them.  If you attempt to format 5.175 with the format string 
// "#'b'0.#'a'#", SmartClient will return "5.72", and Excel will return "b5.7a2"</li>
// <li>If you specify the empty string as a format string, SmartClient returns the result of 
// calling toString() on the number; Excel uses the built-in "General" format.  These two 
// approaches will generally give the same or very similar results, but that is really a 
// coincidence: the correct way to obtain matching results in the browser and the spreadsheet
// is to specify a valid format string</li>
// <li>If you specify a format string that contains no number part (ie, no '#' or '0' 
// characters), SmartClient does what DecimalFormat does, which is to output the integer part
// of the number alongside the fixed part of the format.  Excel just outputs the fixed part.
// So, if you attempt to format -5.3 with the format string "'Hello world'", SmartClient will
// output "-Hello world5", whereas Excel will output just "Hello world"</li>
// <li>If you specify multiple percent signs in the format, SmartClient treats all but the 
// first one as static text, so 0.5 formatted with "#%%%" is "50%%%" (ie, all the signs are 
// preserved but there is only one multiplcation by 100).  Excel multiplies for  each percent
// sign, so 0.5 formatted with "#%%%" is "500000%%%"</li>
// </ul>
// <p>
// <h3>Date format functionality not supported by Excel</h3>
// The following date/time/datetime functionality is not supported by Excel; if you use 
// formatters that use any of this functionality, your values will be exported to Excel 
// incorrectly formatted.  In cases like this, we recommend that you use a separate 
// <code>exportFormat</code>, with the intent of exporting your values in a way that is 
// similar to your application formatting (which would be specified with the 
// +link{dataSourceField.format,format} property), but within the confines of what Excel 
// supports.
// <ul>
// <li>Fiscal year, week and day (LL, LLLL, C, CC, c, cc)</li>
// <li>Week in year (w, ww)</li>
// <li>Day in year (D, DD)</li>
// <li>Day number in week (u)</li>
// <li>Explicit control over whether to use 12- or 24-hour notation.  In Excel, this is 
// implied by the presence or absence of the AM/PM designator</li>
// <li>If the user's operating system locale is different to the locale in use in the 
// SmartClient application, day and month names may be different in the spreadsheet</li>
// </ul>
// <h3>Number format functionality not supported by Excel</h3>
// The only SmartClient number-formatting functionality not supported for 
// export to Excel is "multiply by 1000 and show as per mille".
// <p>
// <h3>Limit on number of custom Excel formats</h3>
// Excel limits the number of custom format strings in a single spreadsheet to somewhere
// between 200 and 250, depending on your locale and language.  Hitting this limit in an export
// would require hundreds of field definitions, each defining unique
// <code>FormatStrings</code>.  If you do hit the limit, the only workaround is to use fewer
// unique <code>FormatStrings</code>.
// <p>
// <h3>Controlling number format</h3>
// If we give Excel a formatted number like "500,000" it will not treat that value as a number,
// so sums and other basic spreadsheet features won't work. So we use the heuristic that if your
// formatted value parses as a number, you probably want it treated as a number in the
// spreadsheet, so we give Excel the unformatted numeric value and tell Excel it's a numeric
// data value.
// <p>
// You might expect that we would give Excel <i>both</i> the formatted value and the numeric
// value, but this is only possible by creating what's called a "custom format" for that cell,
// which as the section above mentions, is limited in that only a few hundred can be created.
// <p>
// With this Excel limitation in mind, it makes sense to just go with the default behavior. If
// you decide otherwise, one option is to use 
// +link{dsRequest.exportNumbersAsFormattedString,exportNumbersAsFormattedString}, but see the
// docs for that property for the drawbacks of doing this.
//
// @see DataSourceField.format
// @serverDS allowed
// @visibility external
//<

//> @type FormatString
// A String to be used as a format specifier for a date, datetime, time or numeric field, via
// the +link{dataSourceField.format,format} and +link{dataSourceField.exportFormat,exportFormat} 
// properties.  
// <p>
// For fields with a numeric type, the format string is similar to java.text.NumberFormat (see
// +externalLink{http://docs.oracle.com/javase/7/docs/api/java/text/DecimalFormat.html,DecimalFormat JavaDoc}),
// and for date, time, and datetime types, the format string is similar to
// java.text.SimpleDateFormat (see 
// +externalLink{http://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html,SimpleDateFormat JavaDoc}).
// <p>
// Note that all the client-side formatting described in this section is is done by the 
// +link{NumberUtil.format(),NumberUtil.format()} and 
// <smartclient>+link{DateUtil.format(),DateUtil.format()}</smartclient>
// <smartgwt>{@link com.smartgwt.client.util.DateUtil#format()}</smartgwt>
// methods.  These are static utility methods that your own code can call if you need to 
// programmatically format a date or number using a <code>FormatString</code>
// <p>
// There are 3 possible contexts where a <code>FormatString</code> may be interpreted, and each
// has slightly different limitations:
//
// <h4>in-browser rendering &amp; client-driven exports</h4>
// Almost complete support for Java's SimpleDateFormat/DecimalFormat, as described below, with
// some small extensions for formatting with awareness of a +link{FiscalCalendar}.
// <p>
// This category includes cases where code running in the browser does the rendering and
// the rendered result is passed to the server, such as 
// +link{ListGrid.exportClientData(),client-driven export} and
// +link{rpcManager.exportContent(),PDF export of the printed view}.
//
// <h4>Excel export</h4> 
// Almost the same as in-browser rendering, with minor limitations due to missing features in
// Excel.  Exact differences are described under +link{dataSourceField.exportFormat}.
//
// <h4>non-Excel server export</h4>
// For example, CSV, XML or JSON +link{type:ExportFormat,export formats} provided via
// +link{DataSource.exportData()}.  Full support for SimpleDateFormat/DecimalFormat
// as provided by whichever Java version you have installed on the server.  However note that
// depending on the context of the export, the default behavior may be to ignore format
// strings, since formatting intended for end users wouldn't be desirable if data exchange is
// the goal.  See the +link{group:exportFormatting,Export Formatting overview} for details.
//
// <P>
// <h3>Date Format</h3>
// <table width="700" style="font-size:11px;border:1px solid black;">
// <tr><td style="color:white;background-color:black;"><b>Format token</b></td>
//     <td style="color:white;background-color:black;"><b>Description</b></td>
//     <td style="color:white;background-color:black;width:150px;"><b>Sample value</b></td></tr>
// <tr><td>yy     </td><td>Year as a two-digit number                            </td><td>"99"   or "07"</td></tr>
// <tr><td>yyyy   </td><td>Year as a four-digit number                           </td><td>"1999" or "2007"</td></tr>
// <tr><td>YY     </td><td>Week year as a two-digit number (week year is the year associated with the entire week deemed to contain a given date, and it may differ from calendar year.  For example, the week year of December 31 2012 is 2013)</td><td>"99"   or "07"</td></tr>
// <tr><td>YYYY   </td><td>Week year as a four-digit number                      </td><td>"1999" or "2007"</td></tr>
// <tr><td>LL     </td><td>Fiscal year as a two-digit number (+link{FiscalCalendar})</td><td>"99"   or "07"</td></tr>
// <tr><td>LLLL   </td><td>Fiscal year as a four-digit number                    </td><td>"1999" or "2007"</td></tr>
// <tr><td>M      </td><td>Month in year                                         </td><td>"1"  to "12"</td></tr>
// <tr><td>MM     </td><td>Month in year with leading zero if required           </td><td>"01" to "12"</td></tr>
// <tr><td>MMM    </td><td>Short month name (<smartclient>+link{DateUtil.shortMonthNames}</smartclient><smartgwt>{@link com.smartgwt.client.util.DateUtil#setShortMonthNames()}</smartgwt>)        </td><td>"Jan" to "Dec"</td></tr>
// <tr><td>MMMM   </td><td>Full month name (<smartclient>+link{DateUtil.monthNames}</smartclient><smartgwt>{@link com.smartgwt.client.util.DateUtil#setMonthNames()}</smartgwt>)              </td><td>"January" to "December"</td></tr>
// <tr><td>w      </td><td>Week in year                                          </td><td>"1"  to "52"</td></tr>
// <tr><td>ww     </td><td>Week in year with leading zero if required            </td><td>"01" to "52"</td></tr>
// <tr><td>C      </td><td>Week in fiscal year (+link{FiscalCalendar})           </td><td>"7"  or "29"</td></tr>
// <tr><td>CC     </td><td>Week in fiscal year with leading zero if required     </td><td>"07" or "29"</td></tr>
// <tr><td>d      </td><td>Day of the month                                      </td><td>"1"  to "31"</td></tr>
// <tr><td>dd     </td><td>Day of the month with leading zero if required        </td><td>"01" to "31"</td></tr>
// <tr><td>ddd    </td><td>Short day name (+link{DateUtil.shortDayNames})        </td><td>"Mon" to "Sun"</td></tr>
// <tr><td>dddd   </td><td>Full day name. (+link{DateUtil.dayNames})             </td><td>"Monday" to "Sunday"</td></tr>
// <tr><td>E      </td><td>Short day name ("EE" and "EEE" are equivalent; all are exactly the same as "ddd" - "E" is supported purely to conform with SimpleDateFormat)</td><td>"Mon" to "Sun"</td></tr>
// <tr><td>EEEE   </td><td>Full day name (exactly the same as "dddd")            </td><td>"Monday" to "Sunday"</td></tr>
// <tr><td>D      </td><td>Day in year                                           </td><td>"1"  to "366"</td></tr>
// <tr><td>DD     </td><td>Day in year with leading zero if required             </td><td>"01" to "366"</td></tr>
// <tr><td>c      </td><td>Day in fiscal year (+link{FiscalCalendar})            </td><td>"5"  or "204"</td></tr>
// <tr><td>cc     </td><td>Day in fiscal year with leading zero if required      </td><td>"05" or "204"</td></tr>
// <tr><td>u      </td><td>Day number in week (1 is Monday)                      </td><td>"1" to "7"</td></tr>
// <tr><td>H      </td><td>Hour in day, 0-23 (24-hour clock)                     </td><td>"0"  to "23"</td></tr>
// <tr><td>HH     </td><td>Hour in day with leading zero if required (24-hour)   </td><td>"00" to "23"</td></tr>
// <tr><td>h      </td><td>Hour in day, 1-12 (12-hour clock)                     </td><td>"1"  to "12"</td></tr>
// <tr><td>hh     </td><td>Hour in day with leading zero if required (12-hour)   </td><td>"01" to "12"</td></tr>
// <tr><td>m      </td><td>Minute in hour                                        </td><td>"0"  to "59"</td></tr>
// <tr><td>mm     </td><td>Minute in hour with leading zero if required          </td><td>"00" to "59"</td></tr>
// <tr><td>s      </td><td>Second in minute                                      </td><td>"0"  to "59"</td></tr>
// <tr><td>ss     </td><td>Second in minute with leading zero if required        </td><td>"00" to "59"</td></tr>
// <tr><td>S      </td><td>Millisecond in second                                 </td><td>"0"  to "999"</td></tr>
// <tr><td>SSS    </td><td>Millisecond in second with leading zero(s) if required</td><td>"000" to "999"</td></tr>
// <tr><td>a      </td><td>The AM/PM designator (+link{Time.AMIndicator})        </td><td>" am" or " pm"</td></tr>
// </table>
// <p>
// Note that all text that doesn't represent tokens specified above will be passed through to
// the output, but such unmapped character sequences are reserved for future use.  To
// future-proof your code, you may single quote <code>"'"</code> any text to escape it to ensure
// no formatting is applied, guaranting that it's passed through unaltered.  Thus, a format of
// <code>"h'h'"</code> might end up as <code>"5h"</code>.  To create a single quote itself, use
// two in a row - for example <code>"h o''clock"</code>.
// <p>
// <h3>Examples - various formatted versions of the datetime "2006-08-03 11:26:18"</h3>
// <table>
// <tr><td width="150">"M/d/yy"</td><td width="300">8/3/06</td></tr>
// <tr><td>"MMMM yyyy"</td><td>August 2006</td></tr>
// <tr><td>"HH:mm"</td><td>11:26</td></tr>
// <tr><td>"d MMM yyyy, H:ma"</td><td>3 Aug 2006, 11:26 am</td></tr>
// <tr><td>"dd/MM/yyyy"</td><td>03/08/2006</td></tr>
// <tr><td>"CC/LLLL"</td><td>53/2006 (assuming the fiscal year ends in the first week of August)</td></tr>
// </table>
// <p>
// <h3><code>SimpleDateFormat</code> specifiers that we do <b>not</b> support:</h3>
// <ul>
// <li>Era designator, BC/AD (G)</li>
// <li>Day of week in month (F)</li>
// <li>Hour in day, 24-hour, with 1-based instead of normal 0-based numbering (hours are 1-24) (k)</li>
// <li>Hour in day, 12-hour, with 0-based instead of normal 1-based numbering (hours are 0-11) (K)</li>
// <li>Timezone (z, Z, X)</li>
// </ul>
// <p>&nbsp;<p>
// <h3>Number Format</h3>
// <table width="700" style="font-size:11px;border:1px solid black;">
// <tr><td style="color:white;background-color:black;"><b>Format char</b></td>
//     <td style="color:white;background-color:black;"><b>Description</b></td>
// <tr><td>0          </td><td>Digit, zero is displayed</td></tr>
// <tr><td>#          </td><td>Digit, zero is not displayed</td></tr>
// <tr><td>-          </td><td>Minus sign</td></tr>
// <tr><td>.          </td><td>Decimal separator</td></tr>
// <tr><td>%          </td><td>Multiply by 100 and show as percentage</td></tr>
// <tr><td>&#x2030; (\u2030) </td><td>Multiply by 1000 and show as per mille.  See below.</td></tr>
// <tr><td>,          </td><td>Indicates digit grouping should be used - eg 1,000,000.  See below.</td></tr>
// <tr><td>;          </td><td>Separates positive and negative subpatterns.  See below.</td></tr>
// <tr><td>&#x00a4; <smartclient>(\u00A4)</smartclient><smartgwt>(\\u00A4)</smartgwt> </td><td>As a prefix or suffix, indicates the local currency symbol should be used.  Note that you must use special notation to include this character in an XML file (such as a .ds.xml file).  See below.</td></tr>
// <tr><td>'          </td><td>Used to quote special characters in a prefix or suffix, for example, "'#'#" formats 123 to "#123". To create a single quote itself, use two in a row: "# o''clock".</td></tr>
// </table>
// <p>
// All other characters in the format string are taken literally and output unchanged.
// <p>
// <h3>Examples</h3>
// <table style="font-size:11px;border:1px solid black;">
// <tr><td width="150" style="color:white;background-color:black;"><b>Format string</b></td>
//     <td width="150" style="color:white;background-color:black;"><b>Zero value</b></td>
//     <td width="150" style="color:white;background-color:black;"><b>Positive value: 12345.678</b></td>
//     <td width="150" style="color:white;background-color:black;"><b>Negative value: -2345.123</b></td>
// <tr><td>"0.00"</td><td>0.00</td><td>12345.68</td><td>-2345.12</td></tr>
// <tr><td>",##0.00"</td><td>0.00</td><td>12,345.68</td><td>-2,345.12</td></tr>
// <tr><td>"0.###"</td><td>0</td><td>12345.678</td><td>-2345.123</td></tr>
// <tr><td>"&#x00a4;,0.00"</td><td>$0.00</td><td>$12,345.68</td><td>-$2345.12</td></tr>
// <tr><td>"0.0#%"</td><td>0.0%</td><td>1234567.8%</td><td>-234512.3%</td></tr>
// <tr><td>"0.0#&#x2030;"</td><td>0.0&#x2030;</td><td>12345678.0&#x2030;</td><td>-2345123.0&#x2030;</td></tr>
// <tr><td>"0.0#'%'"</td><td>0.0%</td><td>12345.68%</td><td>-2345.12%</td></tr>
// <tr><td>"0.00;(0.00)"</td><td>0.0%</td><td>12345.68</td><td>(2345.12)</td></tr>
// </table><br>
// Note, the above examples include cases where there are multiple '#' characters in the integer
// part of the number format (ie, to the left of the decimal separator, or the entire format 
// if there is no separator).  We support this pattern simply because <code>DecimalFormat</code>
// does: the extra '#' characters are not significant.  In other words, the format "##0.00" 
// produces exactly the same formatting as "0.00", and "##,###,###.##" produces exactly the 
// same formatting as ",#.##".  However, multiple '0' characters in the integer part of the 
// format <em>are</em> significant, as are both '#' and '0' characters in the decimal part 
// of the format (ie, to the right of any decimal separator).
// <p>
// The ";" character marks the boundary between two subpatterns - the first to be used for 
// formatting positive numbers (and 0), the second for negative numbers.  Specifying a separate
// pattern for negative numbers is optional: if no negative subpattern is specified, negative
// numbers are formatted like positive numbers, but with a leading "-" sign.
// <p>
// The "&#x00a4;" symbol (\u00A4) is documented in the Java DecimalFormat class as a placeholder for the currency
// symbol appropriate to the current locale.  For client-driven exports, we replace it with
// <smartclient>
// the +link{NumberUtil.currencySymbol, localized currency symbol}.
// Likewise, we use +link{NumberUtil.decimalSymbol,decimalSymbol} and
// +link{NumberUtil.groupingSymbol,groupingSymbol} to localize the formatting of numbers.
// </smartclient>
// <smartgwt>
// whatever GWT's built-in NumberFormat's class uses.  Likewise, the decimal symbol and
// grouping symbol will match what GWT's NumberFormat returns.
// </smartgwt>
// Note that "\u00A4" is the correct way to specify this character in Javascript code.  If you
// need to specify the character in an XML file - the common requirement is in a .ds.xml
// DataSource descriptor file - you must use the code "&amp;#x00A4;" instead.
// <p>
// The "&permil;" per mille symbol is specified as "\u2030" in Javascript code; in XML or HTML 
// you can use either the equivalent notation "&amp;#x2030;" or the special HTML code 
// "&amp;permil;".
//
// <p>
// <h3><code>DecimalFormat</code> features that we do <b>not</b> support:</h3>
// <ul>
// <li>Scientific notation</li>
// <li>Doubled currency symbol means "use international currency symbol"</li>
// <li>We do not support arbitrary digit grouping, by providing patterns of the '#' and ','
// characters, like <code>DecimalFormat</code> does.  Grouping in SmartClient FormatStrings
// is enabled with a single "," character somewhere before or within the number-formatting
// part of the string - extra "," characters within the number-formatting part of the string 
// are tolerated, but they have no effect.  Grouping in SmartClient always causes digits to 
// be gathered in groups of three</li>
// </ul>
// 
// @baseType String
// @see DataSourceField.format
// @see DataSourceField.exportFormat
// @see DateUtil.format()
// @see NumberUtil.format()
// @see Time.toTime()
// @see Time.toShortTime()
// @serverDS allowed
// @visibility external
//<


//> @groupDef exportFormatting
// This topic explains the default rules for whether date, numeric and other formatting
// settings are applied when performing various types of exports, and how to override the default
// behavior.
// <p>
// For server-based exports (e.g. +link{ListGrid.exportData()} or
// +link{DataSource.exportData()}):
// <ul>
// <li> if +link{dsRequest.exportAs,exportAs} is a spreadsheet format (XLS or OOXML),
//      +link{dataSourceField.format,dsField.format} or 
//      +link{dataSourceField.exportFormat,dsField.exportFormat} will be used if
//      specified, otherwise, +link{dataSourceField.dateFormatter} will be used if specified,
//      otherwise, no formatting will be applied and the date or number will be shown in the
//      spreadsheet program's default formatting.
// <li> if targetting CSV, XML or JSON, by default, formatting declarations are ignored and
//      standard formats are used, because the expectation is that this type of export is
//      intended for data interchange with other systems and not for direct viewing by end
//      users.  Specifically, date and datetime values use standard 
//      +externalLink{http://www.w3.org/TR/xmlschema-2/#dateTime,XML Schema date and time formats}
//      and CSV export uses the "yyyy-MM-dd HH:mm:ss" expected by Microsoft Excel and similar
//      tools that consume CSV, with only the date or time part of the format being used for
//      fields that are of type "date" or "time" rather than "datetime".  If you instead set
//      +link{dsRequest.exportRawValues} to false, format settings available to server will be used,
//      exactly as explained above for spreadsheet exports with <code>exportData()</code>.
// </ul>
// For a client-driven export (e.g. +link{listGrid.exportClientData()} or
// +link{DataSource.exportClientData()}:
// <ul>
// <li> if +link{dsRequest.exportAs,exportAs} is a spreadsheet format (XLS or OOXML),
//      rules are the same as for server-driven export, except that if no
//      +link{dataSourceField.format,dsField.format} or 
//      +link{dataSourceField.exportFormat,dsField.exportFormat} is specified, 
//      <code>dateFormatter</code> settings on client-side UI components will be used if a
//      built-in formatter is used (for example, if +link{listGridField.dateFormatter} is set to
//      the built-in formatter "toEuropeanShortDate").  If you need date or number values to
//      appear <b>exactly</b> as shown to the user, set
//      +link{dsRequest.exportDatesAsFormattedString} or
//      +link{dsRequest.exportNumbersAsFormattedString}, respectively, but see the docs for
//      these properties for the drawbacks of doing this.</li>
// <li> for CSV, XML or JSON exports, whatever is shown to the end user is used (since it's
//      assumed the reason for calling <code>exportClientData()</code> rather than
//      <code>exportData()</code> is precisely to create a fully formatted export).  If you
//      instead set +link{listGrid.exportRawValues} to true, only standard formats appropriate
//      to data interchange are used, the same as described for <code>exportData()</code> above.
// </li></ul>
// These different default behaviors for different export formats can be overriden by use of 
// +link{listGrid.exportRawValues}.  If you only want to override the default behaviors for 
// numeric values, you can use +link{listGrid.exportRawNumbers} (note, the 
// <code>exportRawNumbers</code> setting has no effect if <code>exportRawValues</code> is set
// to true)
// <p>
// Use +link{DSRequest.exportPropertyIdentifier} to override the default behavior for a server
// or client-driven export and force either component field names or titles to be exported.
// <P>
// <h3>Display-mapped fields</h3>
// SmartClient supports a number of ways to declaratively map underlying data values to 
// "display values" that have more meaning to a user.  This mapping can be achieved using a
// +link{dataSourceField.displayField,displayField} in the same record, a +link{type:ValueMap} 
// or an +link{listGridField.optionDataSource,optionDataSource}.  The table below shows what
// values get exported for each of these possibilities, in combination with the 
// +link{dsRequest.exportValueFields,exportValueFields} flag and whether you are using 
// client-driven or server-driven export:<p>
// <table width="700" style="font-size:11px;border:1px solid black;">
// <tr><td style="color:white;background-color:black;width:560px"><b>Use case</b></td>
//     <td align="center" style="color:white;background-color:black;width:70px;"><b>Exports value field</b></td>
//     <td align="center" style="color:white;background-color:black;width:70px;"><b>Exports display field</b></td></tr>
// <tr><td>exportClientData(), in-record displayField, exportValueFields=true</td><td align="center">&#x2713;</td><td align="center">&#x2713;</td></tr>
// <tr style="background-color:#ddd;"><td>exportClientData(), in-record displayField, exportValueFields=false</td><td align="center">&nbsp;</td><td align="center">&#x2713;</td></tr>
// <tr><td>exportClientData(), valueMap declared in DataSource, exportValueFields=true</td><td align="center">&nbsp;</td><td align="center">&#x2713;</td></tr>
// <tr style="background-color:#ddd;"><td>exportClientData(), valueMap declared in DataSource, exportValueFields=false</td><td align="center">&nbsp;</td><td align="center">&#x2713</td></tr>
// <tr><td>exportClientData(), valueMap defined in code, exportValueFields=true</td><td align="center">&nbsp;</td><td align="center">&#x2713;</td></tr>
// <tr style="background-color:#ddd;"><td>exportClientData(), valueMap defined in code, exportValueFields=false</td><td align="center">&nbsp;</td><td align="center">&#x2713</td></tr>
// <tr><td>exportClientData(), optionDataSource, exportValueFields=true</td><td align="center">&#x2713;</td><td align="center">&#x2713;</td></tr>
// <tr style="background-color:#ddd;"><td>exportClientData(), optionDataSource, exportValueFields=false</td><td align="center">&nbsp;</td><td align="center">&#x2713;</td></tr>
// <tr><td>exportData(), in-record displayField (must be declared in DataSource), exportValueFields not specified</td><td align="center">&#x2713</td><td align="center">&#x2713</td></tr>
// <tr style="background-color:#ddd;"><td>exportData(), in-record displayField (must be declared in DataSource), exportValueFields=true</td><td align="center">&#x2713</td><td align="center">&nbsp;</td></tr>
// <tr><td>exportData(), in-record displayField (must be declared in DataSource), exportValueFields=false</td><td align="center">&nbsp;</td><td align="center">&#x2713</td></tr>
// <tr style="background-color:#ddd;"><td>exportData(), valueMap declared in DataSource</td><td align="center">&#x2713;</td><td align="center">&nbsp;</td></tr>
// <tr><td>exportData(), valueMap defined in code</td><td align="center">&#x2713;</td><td align="center">&nbsp;</td></tr>
// <tr style="background-color:#ddd;"><td>exportData(), optionDataSource</td><td align="center">&#x2713;</td><td align="center">&nbsp;</td></tr>
// </table>
// @title Exports &amp; Formatting
// @visibility external
// 
//<

//> @attr dsRequest.exportRawValues (Boolean : null : IRW)
// Whether formatting settings should be applied to data being exported.  Default behavior and
// the effect of setting of <code>exportRawValues</code> is described in the
// +link{group:exportFormatting,Export Formatting overview}.
// @group exportFormatting
// @visibility external
//<


//> @attr dsRequest.exportPropertyIdentifier (PropertyIdentifier : null : IRW)
// Determines the +link{type:PropertyIdentifier} to be used in the exported data.  This
// essentially means, should we export internal field names like "countryCode" or
// "EMPLOYEE_NO", or localized descriptive field titles like "code du pays" or
// "Employee Number".  This setting has a lot in common with +link{dsRequest.exportRawValues};
// both are largely dependent on whether the exported data is intended for direct consumption by
// an end user (in which case it is appropriate to export formatted values and localized field
// titles), or for interface to some downstream computer system (in which case you probably
// want raw, unformatted values and internal field names).
// <p>
// If this property is not set, the following defaults apply:<ul>
// <li>If the export format is a native spreadsheet format (XLS or OOXML), localized field 
// titles are used</li>
// <li>If the export format is CSV, XML or JSON and this is a client-driven export (ie it was
// initiated by a call to +link{listGrid.exportClientData(),exportClientData()}), 
// localized field titles are used</li>
// <li>If the export format is CSV, XML or JSON and this is <b>not</b> a client-driven export,
// internal field names are used</li> 
// </ul>
// @group exportFormatting
// @visibility external
//<

//> @type PropertyIdentifier
// A means of identifying the properties in an exported dataset - either the property name
// or its title.
//
// @value "name"         Identify properties by internal name
// @value "title"        Identify properties by localized descriptive title
// @visibility external
//<





// Titles
// ---------------------------------------------------------------------------------------

//> @attr DataSource.title (String : dataSource.ID : IRW)
// User-visible name for this DataSource.
// <P>
// For example, for the supplyItem DataSource, "Supply Item".
// <P>
// If is unset, <code>getAutoTitle()</code> method will be used with <code>dataSource.ID</code>.
// value in order to derive a default value for the title.
// <P>
// For example "employee" ID will be derived to "Employee", "team_member" ID will be 
// derived to "Team Member".
//
// @group titles
// @serverDS allowed
// @visibility external
//<

//> @attr DataSource.pluralTitle (String : dataSource.ID : IR)
// User-visible plural name for this DataSource.
// <P>
// For example, for the supplyItem DataSource, "Supply Items".
// <P>
// Defaults to <code>dataSource.title</code> + "s".
// @group titles
// @serverDS allowed
// @visibility external
//<

//> @groupDef dsSpecialFields
// A DataSource allows you to declare that certain fields are the most important fields to 
// show to a user in situations where space is limited, and only one or a few fields can be
// reasonably shown.
// <P>
// In the table below these special fields are summarized, along with their meaning, and
// examples of which field would be most appropriate from several example DataSources.
// <P>
// <table cellPadding=2 class="normal" border=1>
// <tr style="font-weight:bold;">
//  <td rowSpan="2">Attribute</td>
//  <td colSpan="3">Example DataSource field</td>
//  <td rowSpan="2">Meaning</td>
// </tr><tr style="font-style:italic;">
//  <td>employee</td><td>emailMessage</td><td>stockItem</td>
// </tr><tr>
//  <td>titleField</td><td>name</td><td>subject</td><td>itemName</td>
//      <td>primary label for the record as a while</td>
// </tr><tr>
//  <td>infoField</td><td>job</td><td>sender</td><td>category</td>
//      <td>second most pertinent piece of textual information</td>
// </tr><tr>
//  <td>dataField</td><td>salary</td><td>date</td><td>price</td>
//      <td>most pertinent numeric, date or enum (eg status) field</td>
// </tr><tr>
//  <td>descriptionField</td><td>bio</td><td>messageBody</td><td>description</td>
//      <td>descriptive long text field</td>
// </tr><tr>
//  <td>iconField</td><td>photo</td><td>statusIcon</td><td>thumbnail</td>
//      <td> an image or icon to accompany the title field</td>
// </tr></table>
// <P>
// Examples of the use of these fields include the +link{TileGrid}'s default choice of fields,
// and the +link{EventHandler.setDragTracker(),drag tracker} that follows the mouse cursor when
// data is being dragged between grids.
//
// @visibility external
//<


//> @attr dataSource.titleField (String : see below : IR)
// Best field to use for a user-visible title for an individual record from this dataSource.
// <p>
// For example, for a DataSource of employees, a "full name" field would probably most clearly
// label an employee record.
// <p>
// If not explicitly set, titleField looks for fields named "title", "label", "name", and "id"
// in that order.  If a field exists with one of those names, it becomes the titleField.  If not,
// then the first field is designated as the titleField.
//
// @group titles, dsSpecialFields
// @serverDS allowed
// @visibility external
//<

//> @attr dataSource.iconField (String : see below : IR)
// Designates a field of +link{FieldType,type}:"image" as the field to use when rendering a
// record as an image, for example, in a +link{TileGrid}.
// <p>
// For example, for a DataSource of employees, a "photo" field of type "image" should be
// designated as the iconField.
// <p>
// If not explicitly set, iconField looks for fields named "picture", "thumbnail", "icon",
// "image" and "img", in that order, and will use any of these fields as the iconField if it
// exists and has type "image". 
// <P>
// To avoid any field being used as the iconField, set iconField to <code>null</code>.
// 
// @group dsSpecialFields
// @serverDS allowed
// @visibility external
//<

//> @attr dataSource.infoField (String : null : IR)
// Name of the field that has the second most pertinent piece of textual information in the
// record, for use when a +link{DataBoundComponent} needs to show a short summary of a record.
// <p>
// For example, for a DataSource of employees, a "job title" field would probably be the second
// most pertinent text field aside from the employee's "full name".
// <p>
// Unlike +link{titleField}, infoField is not automatically determined in the absence of an
// explicit setting.
// @group dsSpecialFields
// @serverDS allowed
// @visibility external
//<


//> @attr dataSource.dataField (String : null : IR)
// Name of the field that has the most pertinent numeric, date, or enum value, for use when a
// +link{DataBoundComponent} needs to show a short summary of a record.
// <P>
// For example, for a DataSource of employees, good choices might be the "salary" field, "hire
// date" or "status" (active, vacation, on leave, etc).
// <p>
// Unlike +link{titleField}, dataField is not automatically determined in the absence of an
// explicit setting.
// @group dsSpecialFields
// @serverDS allowed
// @visibility external
//<

//> @attr dataSource.descriptionField (String : null : IR)
// Name of the field that has a long description of the record, or has the primary text data
// value for a record that represents an email message, SMS, log or similar.
// <p>
// For example, for a DataSource representing employees, a field containing the employee's
// "bio" might be a good choice, or for an email message, the message body.
// <p>
// If descriptionField is unset, it defaults to any field named "description" or "desc" in the
// record, or the first long text field (greater than 255 characters) in the record, or null if
// no such field exists.
// @group dsSpecialFields
// @serverDS allowed
// @visibility external
//<

//> @attr dataSource.childrenField (String : null : [IR])
// fieldName for a field in the dataSource expected to contain an explicit array of child nodes.
// Enables loading a databound tree as a hierarchical data structure, rather than a flat list of
// nodes linked by foreignKey.<br>
// Note this is an alternative to setting +link{dataSourceField.childrenProperty} directly on
// the childrenField object.<P>
// By default the children field will be assumed to be +link{dataSourceField.multiple, multiple},
// for XML databinding. This implies that child data should be delivered in the format:
// <pre>
//      &lt;childrenFieldName&gt;
//          &lt;item name="firstChild" ...&gt;
//          &lt;item name="secondChild" ...&gt;
//      &lt;/childrenFieldName&gt;
// </pre>
// However data may also be delivered as a direct list of <code>childrenFieldName</code> 
// elements:
// <pre>
//      &lt;childrenFieldName name="firstChild" ...&gt;
//      &lt;childrenFieldName name="secondChild" ...&gt;
// </pre>
// If you want to return your data in this format, you will need to explicitly set 
// <code>multiple</code> to false in the appropriate dataSource field definition.
//
// @see dataSourceField.childrenProperty
// @group dataSourceRelations
// @serverDS allowed
// @visibility external
//<

//> @groupDef serverDataSourceImplementation
// NOTE: This section includes references to server-side classes and methods; you can find the
// documentation for these in the server-side Javadocs.
// <p>
// Bear in mind the following points when working with DataSources (whether custom or 
// built-in) on the SmartClient Server:<ul>
// <li>There is no requirement or expectation that DataSource subclasses be threadsafe.  As 
// long as you use documented techniques for creating DataSource instances, the server framework
// will ensure that no single instance is used concurrently by more than one thread.</li>
// <p>
// <li>If you are using +link{group:springIntegration,Spring-injected dataSources}, note that
// the default scope for a Spring bean is "singleton".  This means that a single instance of 
// the bean is cached by Spring and returned every time the framework code asks for that 
// DataSource.  This pattern prevents the SmartClient framework from making the above-mentioned
// guarantee that no single instance will be used by multiple threads, and can lead to
// unpleasant concurrency bugs.  The solution is to mark your Spring beans with a scope of 
// "prototype" (you could also use "request", but SmartClient caches DataSource instances 
// per-HttpServletRequest anyway, so nothing is gained by doing that).  See the 
// <a href=http://docs.spring.io/spring/docs/3.2.5.RELEASE/spring-framework-reference/html/beans.html#beans-factory-scopes>
// Spring documentation</a> for further information about bean scope. 
// <p>
// <li>DataSource instances can safely be retained for use multiple times in a given HTTP 
// request; this presents no thread-safety issues unless you specifically introduce them by,
// eg, creating a new DSRequest and executing it in its own thread.  However, note that mixing
// +link{DataSource.autoJoinTransactions,transactional} and non-transactional operations on the 
// same DataSource instance in a single HTTP request can lead to connection leaks if you are 
// using the built-in Hibernate or JPA DataSource.</li>
// <p>
// <li>If the +link{group:server_properties,server.properties} attribute 
// <code>datasource.cacheFailedLookups</code> is set, the server remembers the names of 
// DataSources it failed to look up, and does not attempt to look them up again (until the 
// server is restarted).  This provides a negligible performance improvement in normal 
// circumstances, but can provide a more significant benefit in cases of questionable usage 
// where DataSources or field types are declared server-side, for use purely client-side.
// Note, if you set this flag, a DataSource that you introduce in the middle of a running 
// application will not be picked up if the system has already cached a failed lookup of 
// that DataSource.</li>
// <p>
// <li>If the +link{group:server_properties,server.properties} attribute <code>datasources.pool.enabled</code>
// is set, DataSource instances are automatically cached in an in-memory pool.  This caching
// is smart: if the underlying <code>.ds.xml</code> file changes, cached instances are 
// discarded and rebuilt.</li>
// <p>
// <li>If pooling is not switched on, DataSource instances are constructed new as required.
// Whether or not pooling is enabled, new DataSource instances are always constructed using
// cached configuration for better performance.  The configuration file (<code>.ds.xml</code>
// file) is read the first time the DataSource is requested; thereafter, we will only re-read
// the configuration file if its last-changed timestamp changes.  This scheme combines the 
// performance benefits of caching with the with the convenience of being able to change a 
// <code>.ds.xml</code> file and pick up the changes without restarting the server.</li>
// <p>
// <li>The safe way to obtain a DataSource instance is to use 
// <code>RPCManager.getDataSource()</code>.  If pooling is enabled, this is the only way to 
// obtain a DataSource instance with the guarantee that it will be returned to the pool at 
// the end of request processing.</li>
// <p>
// <li>If you are using the <code>DynamicDSGenerator</code> to provide DataSources to the 
// framework dynamically:<ul>
// <p>
// <li>You are expected to use one of the <code>DataSource.fromXML()</code> APIs to construct
// your DataSources from an XML document or String of XML text</li>
// <p>
// <li>Do not use normal Java instantiation techniques like <code>new DataSource()</code>, as 
// this will introduce thread-safety issues</li>
// <p>
// <li>Return a new DataSource instance each time - returning the same DataSource twice will
// introduce thread-safety issues.  If you are concerned about performance, ensure pooling is
// enabled as described above - this will mean that the DataSource you return will be
// automatically cached and re-used, so your DynamicDSGenerator will only be called enough
// times to populate the pool.  If you are still concerned about performance, cache the XML
// String that you pass to <code>DataSource.fromXML()</code>.</li>
// <p>
// <li>For many applications of <code>DynamicDSGenerator</code>, pooling is inappropriate
// because the returned DataSource for a given name might be different each time the generator
// is called.  For this reason, pooling of dynamic DataSources is disabled by default.  To
// enable pooling for dynamically-generated DataSources, set the +link{group:server_properties,server.properties} 
// flag <code>datasources.poolDynamicDataSources</code> to true. Keep in mind, that if pooling 
// for dynamic DataSources is enabled, then DataSource definition must be the same for the same 
// DataSource ID. NOTE: Here, "dynamic DataSource" means 
// a DataSource whose name would cause the framework to invoke a DynamicDSGenerator, which 
// doesn't necessarily mean that the generator would actually create a dynamic DataSource.  As
// the server-side documentation for <code>DynamicDSGenerator.getDataSource()</code> states,
// a generator can simply return null to decline the opportunity to create a dynamic DataSource.
// Therefore, if the proper operation of pooling is important to you, avoid patterns of 
// <code>DynamicDSGenerator</code> usage that involve registering more generically than you 
// need to.  In particular, avoid the <code>addDynamicDSGenerator()</code> signature that 
// does not take a prefix or regex parameter - this will cause the pooling subsystem to regard
// <b>all</b> DataSources as dynamic, and will effectively disable all DataSource pooling.
// </li></ul>
// </li></ul>
//
// @treeLocation Client Reference/Data Binding/DataSource
// @title Notes on Server-side DataSource Implementations
// @visibility external
//<

//> @attr dataSource.serverConstructor (String : null : IR)
//
// This property allows you to write and use custom DataSource subclasses on the server, by 
// specifying either <ul>
// <li>the fully-qualified name of the DataSource subclass that should be instantiated
// server-side for this dataSource, or</li>
// <li>the token "spring:" followed by a valid Spring bean ID, if you wish to instantiate 
// your custom dataSource object using Spring dependency injection.  For example, 
// <code>"spring:MyDataSourceBean"</code>.  See also +link{group:serverInit} for special
// concerns with framework initialization when using Spring.  It is also particularly important
// that you read the discussion of caching and thread-safety linked to below, as there are 
// special considerations in this area when using Spring.</li>
// <li>the token "cdi:" followed by a valid CDI bean name, if you wish to instantiate 
// your custom dataSource object using CDI dependency injection.  For example, 
// <code>"cdi:MyDataSourceBean"</code>.</li>
// </ul>
// <p>
// One reason you might wish to do this would be to override the validate() method to provide 
// some arbitrary custom validation (such as complex database lookups, validation embedded in 
// legacy applications, etc).  It is also possible - though obviously a more substantial task -
// to override the execute() method in your custom DataSource.  This is one way of creating 
// a completely customized DataSource implementation.
// <p>
// <b>Note:</b> If you use this property, you are responsible for making sure that it refers to
// a valid server-side class that extends <code>com.isomorphic.datasource.BasicDataSource</code>,
// or to a Spring bean of the same description.
// If your implementation relies on methods or state only present in certain specialized 
// subclasses of DataSource (for example, you want the normal behavior and features of a 
// HibernateDataSource, but with a specialized validate() method), then you should extend the 
// subclass rather than the base class.
// <P>
// NOTE: Please take note of the points made in 
// +link{group:serverDataSourceImplementation,this discussion} of caching and thread-safety
// issues in server-side DataSources.
//
// @serverDS only
// @visibility external
//<

//> @attr dataSource.qualifyColumnNames (Boolean : true : IR)
//
// For dataSources of +link{serverType,serverType} "sql", determines whether we qualify column
// names with table names in any SQL we generate.  This property can be overridden on specific
// operationBindings.
//
// @see OperationBinding.qualifyColumnNames
// @serverDS allowed
// @visibility external
//<

//> @attr dataSource.validateRelatedRecords (boolean : null : IR)
//
// If true, indicates that the SmartClient Server should automatically apply a 
// +link{ValidatorType} of "hasRelatedRecord" to every field 
// on this dataSource that has a +link{DataSourceField.foreignKey,foreignKey} defined.
//
// @visibility external
//<

//> @attr dataSource.beanClassName (String : null : IR)
//
// This property has different meanings depending on the +link{dataSource.serverType,serverType}:
// <p>
// <b>For SQL DataSources (DataSources with serverType "sql")</b><br>
// If set, results from the database will be used to create one instance of the indicated Java
// bean per database row.  Otherwise a Map is used to represent each row retrieved from SQL.
// <P>
// With this feature active, a DSResponse from this DataSource will contain a Collection of
// instances of the indicated <code>beanClassName</code>, available via DSResponse.getData().
// This creates a couple of possibilities:
// <P>
// <dl>
// <dt>Add business logic for derived properties, such as computed formulas</dt>
// <dd>For example, declare a DataSourceField named "revenueProjection".  By default this
// field will call getRevenueProjection() on your bean to retrieve the value to send to the
// client.  Your implementation of getRevenueProjection() could apply some kind of formula to
// other values loaded from the database.</dd>
// <dt>Call business logic on retrieved beans via DMI</dt>
// <dd>By adding a +link{group:dmiOverview,DMI} method that calls DSRequest.execute() to retrieve a DSResponse,
// you have an opportunity to call business logic methods on the beans representing each
// row affected by the DSRequest.  For example, notify a related BPEL process of changes to
// certain fields.</dd>
// </dl>
// <P>
// By using <code>beanClassName</code> on a specific +link{operationBinding}, you can:
// <ul>
// <li>Use a bean to represent your data only when it matters; for example, avoid the overhead
//     of using a bean for "fetch" operations, but do use a bean for "update" operations so
//     that you can execute relevant business logic after the update completes.</li>
// <li>Skip the use of beans for complex reporting queries that produce results unrelated to
//     your persistent object model.  Set beanClassName to blank ("") on a specific
//     operationBinding to override DataSource.beanClassName for that specific operation.</li>
// <li>For SQL joins that produce additional data fields, use a special, operation-specific
//     bean that represents a join of multiple entities and contains business logic specific
//     to that joined dataset</li>
// </ul>
// <P>
// Note that <code>beanClassName</code> affects what numeric field types will be used for 
// inbound DSRequest data. For fields with numeric types, the +link{dsRequest.data,record data} 
// in DSRequests will automatically be converted to the type of the target field, before the 
// request is received in a +link{DMI}.  For details, see +link{group:dsRequestBeanTypes}.
// <p>
// Note that +link{group:dmiOverview,DMI} also has a built-in facility for populating a bean 
// with the inbound +link{DSRequest.data} - just declare the bean as a method argument.
// <p>
// <b>For generic DataSources (DataSources with serverType "generic")</b><br>
// +link{group:visualBuilder,Visual Builder} sets this property when it creates a generic 
// DataSource using the Javabean Wizard.  It has no built-in server-side effects.
// <p>
// <b>For Hibernate DataSources (DataSources with serverType "hibernate")</b><br>
// The name of the Java bean or POJO class that is mapped in Hibernate.  This will typically 
// be the fully-qualified class name - eg <code>com.foo.MyClass</code> - but it may be the 
// simple class name - just <code>MyClass</code> - or it may be some other value.  It all 
// depends on how your classes have been mapped in Hibernate.
// <p>
// The declared Java bean will affect how its properties will be mapped to built-in numeric 
// types, see +link{group:hibernateIntegration,Hibernate Integration overview} for details.
// <p>
// Note:  If you are intending to use Hibernate as a data-access layer only, 
// you do not need to create Hibernate mappings or Java objects: SmartClient will generate
// everything it needs on the fly.
// <p>
// <b>For JPA DataSources (DataSources with serverType "jpa" or "jpa1")</b><br>
// The fully qualified class name of the JPA annotated entity.
// <p>
// <b>NOTE for Hibernate and JPA users:</b> When you use JPA, or use Hibernate as a full ORM
// system (ie, not just allowing SmartClient Server to drive Hibernate as a data access layer),
// the beans returned on the server-side are <b>live</b>.  This means that if you make any 
// changes to them, the ORM system will persist those changes.  This is true even if the beans
// were created as part of a fetch operation.
// <p>
// This causes a problem in the common case where you want to use a DMI or custom DataSource 
// implementation to apply some post-processing to the beans fetched from the persistent 
// store.  If you change the values in the beans directly, those changes will be persisted.
// <p>
// If you want to alter the data returned from a JPA or Hibernate persistent store as part of
// a fetch request just so you can alter what gets sent to the client, you can use the 
// server-side <code>DSResponse</code>'s <code>getRecords()</code> method.  This will return
// your bean data in "record" format - ie, as a List of Maps.  You can alter these records 
// without affecting your persistent store, and then call <code>setData()</code> on the 
// <code>DSResponse</code>), passing the altered list of records.  See the server-side Javadocs
// for <code>DSResponse</code> for details of these two methods.
//
// @see OperationBinding.beanClassName
// @serverDS only
// @visibility external
//<

isc.DataSource.addMethods({
	init : function () {

        // serverType:"sql" implies iscServer format
        if (this.serverType == "sql") this.dataFormat = "iscServer";

        // make it unnecessary to set dataFormat="xml" when properties related to XML have
        // already been set
        if (this.dataFormat == "iscServer" &&
            (this.serviceNamespace != null || this.recordXPath != null)) this.dataFormat = "xml";
        
        // we don't currently support request queuing (multi-op) for anything other than the
        // iscServer format
        this.canQueueRequests = (this.dataFormat == "iscServer" || this.clientOnly);

        // if testData is set and cacheData isn't, set cacheData now, since testData is marked
        // as deprecated
        if (this.testData && !this.cacheData) this.cacheData = this.testData;
        // if cacheData is set and testData isn't, and we're in clientOnly or mock mode, set testData
        // now, since internal code requires it but it's marked externally as deprecated
        else if (this.clientOnly || this.mockMode) {
            this.cacheData = this.testData = this.cacheData || this.testData;
        }

        
        // Note: "id" is technically a reserved word, so have to use in quotes
        if (this.ID == null && this["id"] != null) this.ID = this["id"];

        // sandboxing name rewriting support - rename inbound IDs to encode sandbox context
        if (isc.DataSource._dsGlobalsRename) {
            var newID = isc.DataSource._dsGlobalsRename[this.ID];
            if (newID != null) this.ID = newID;
        }

		
        if (this.name == null) this.name = this.ID;

        // prevent the server definition of eg ValueMap from destroying certain built-in schema
        var existingDS = isc.DS.get(this.ID);
        if (existingDS && existingDS.builtinSchema) return existingDS;

        
        
        // If a new DataSource is overwriting a "mock" dataSource, log at the info
        // level rather than the warning level
        var suppressIDRegistration = false;
        if (isc.MockDataSource && isc.isA.MockDataSource(existingDS)) {
            this.logInfo("Replacing MockDataSource " + this.ID + " with new DataSource");
            existingDS.destroy();

        // If a mock datasource is created with the ID of an existing dataSource, we
        // want to hang onto the existing DS -- the ID (in global scope, or if
        // passed to DataSource.get()) should return the previously created DS.
        
        } else if (existingDS && (isc.MockDataSource && isc.isA.MockDataSource(this))) {
            suppressIDRegistration = true;
            this.logInfo("MockDataSource created with ID:" + this.ID + 
                " collides with ID of existing DataSource. " + 
                " The existing Datasource will be retained and the MockDataSource " +
                "will not be available by ID."
            );
        }

        // make the DataSource a global variable if set to do so, and it doesn't belong to a
        // particular namespace
        // NOTE: when becoming global, only clobber other DataSources, never a Class or any
        // other kind of global.  Otherwise widget DataSources like Canvas clobber the
        // corresponding widget class.  Note we have to specially check for isA.ClassObject()
        // because the DataSource classObject and subclasses will return true when
        // isA.DataSource() is applied to them.
        var existingValue = window[this.ID];

        if (!suppressIDRegistration && this.addGlobalId && this.addGlobalId != isc._false &&
            (!existingValue || 
                (!isc.isA.ClassObject(existingValue) && 
                 isc.isA.DataSource(existingValue))
            )
           )
        {
            isc.ClassFactory.addGlobalID(this);
        }

        
        // if field is provided as an Array, make them into an index by name (so client-only
        // DataSources can use the array of fields format common to all components).  NOTE:
        // this is essentially Array.makeIndex, except we log collisions.
        var fields = this.fields;
        if (isc.isAn.Array(fields)) {
            if (isc.Canvas.validateFieldNames) {
                // loop through each field and check that each field name is a valid JavaScript identifier.
                isc.Canvas._validateFieldNames(fields, this);
            }

            var fieldIndex = {};
            for (var i = 0; i < fields.length; i++) {
                var field = fields[i];
                // if includeFrom is set, but name isn't pick up name from includeFrom property
                if (field.includeFrom != null) {
                    var split = field.includeFrom.split(".");
                    if (split == null || split.length < 2) {
                        this.logWarn("Field has includeFrom specified as :"  + field.includeFrom
                            + " format not understood - clearing this property");
                        field.includeFrom = null;
                    } else {
                        if (field.name == null) field.name = split.last();
                    }
                }

                if (isc.isA.String(field.length)) {
                    field.length = field.length.asDataSizeBytes();
                }
                
                // last field wins on name collision.  
                if (fieldIndex[field.name] != null) {
                    this.logWarn("field.name collision: first field: " +
                                 this.echo(fieldIndex[field.name]) + 
                                 ", discarded field: " + this.echo(field));
                    continue;
                }
                field = this._prettyField(field);
                if (field.type) {
                    var type = this.getType(field.type);
                    if (type) {
                        if (type.fieldProperties) {
                            if (type.fieldProperties.editorProperties != null && 
                                !isc.isA.Object(type.fieldProperties.editorProperties))
                            {
                               type.fieldProperties.editorProperties = {};
                            }
                            field = fields[i] = isc.addProperties({}, type.fieldProperties, field);
                        }
                        if (!field.format && type.format) {
                            field.format = type.format;
                        }
                        // if the field has a non-string type but has a string defaultValue, 
                        // parse it via simpleType.parseInput(), if it exists
                        if (type.parseInput && isc.isA.String(field.defaultValue) && 
                                !isc.SimpleType.inheritsFrom(field.type, "text")) { 
                            field.defaultValue = type.parseInput(field.defaultValue, field, null, null);
                        }
                    }
                }

                fieldIndex[field.name] = field;
            }
            this.fields = fieldIndex;
        }
	
        if (this.dataSourceType == isc.DataSource.VIEW) this.initViewSources();
        
        // register globally
        if (!suppressIDRegistration) isc.DataSource.registerDataSource(this);

        if (this.realtimeUpdates) this.setRealtimeUpdates(this.realtimeUpdates);

        // CacheData loaded from a server .ds.xml file contains all values as strings.
        // Using the defined fields, convert the values to the correct types.
        
        if (this.cacheData && this.isServerDS && !this._convertedCacheData) {
            this.cacheData = this.recordsFromObjects(this.cacheData);
            this._convertedCacheData = true;
        }

        // Update for client-enforced security if applicable
        if (this.clientOnly &&
            this.addGlobalId != false &&
            this.enforceSecurityOnClient != false)
        {
            this.enforceSecurityOnClient = true;
        }

        // Update for client-enforced security, if applicable
        this.calculateDeclarativeSecuritySettings();
    },

    _prettyField : function (field) {
        if (isc.isA.String(field.validOperators)) {
            field.validOperators = [field.validOperators];
        }

        var undef;
        if ((field.foreignKey)
            && (field.nillable == undef)) {
            field.nillable = true;
        }

        return field;
    },
	
    // destroy global ID, if one was assigned.
    destroy : function () { 
        var ID = this.ID,
            DS = isc.DS;

        if (this.cacheResultSet) {
            // if there's a cacheResultSet, destroy it now, along with the parent DS
            this.cacheResultSet.destroy();
            this.cacheResultSet = null;
        }

        // remove from global scope
        if (ID && this == window[ID]) window[ID] = null;

        // remove from global registries
        if (DS._dataSources[ID] == this) DS._dataSources[ID] = null;
        if (DS._elements[ID] == this) DS._elements[ID] = null;
        if (DS._types[ID] == this) DS._types[ID] = null;
        this.Super("destroy", arguments);
    },
    
    //> @method dataSource.getAuditDataSourceID()
    // Getter for +link{auditDataSourceID}.
    // @return (String) specified or default audit DS ID
    //<
    getAuditDataSourceID : function () {
        return this.audit ? this.auditDataSourceID || "audit_" + this.getID() : null;
    },

    //> @method dataSource.getAuditUserFieldName()
    // Getter for +link{auditUserFieldName}.
    // @return (String) field name used to store the user who performed the operation
    //<
    getAuditUserFieldName : function () {
        if (!this.audit) return null;
        var fieldName = this.auditUserFieldName;
        return fieldName != null ? fieldName : "audit_modifier";
    },

    //> @method dataSource.getAuditTimeStampFieldName()
    // Getter for +link{auditTimeStampFieldName}.
    // @return (String) field name used to store the operation timestamp
    //<
    getAuditTimeStampFieldName : function () {
        if (!this.audit) return null;
        var fieldName = this.auditTimeStampFieldName;
        return fieldName != null ? fieldName : "audit_changeTime";
    },

    //> @method dataSource.getAuditRevisionFieldName()
    // Getter for +link{auditRevisionFieldName}.
    // @return (String) field name used to store the change revision number
    //<
    getAuditRevisionFieldName : function () {
        if (!this.audit) return null;
        var fieldName = this.auditRevisionFieldName;
        return fieldName != null ? fieldName : "audit_revision";
    },

    //> @method dataSource.getAuditChangedFieldsFieldName()
    // Getter for +link{auditChangedFieldsFieldName}.
    // @return (String) field name used to store the names of the updated fields
    //<
    getAuditChangedFieldsFieldName : function () {
        if (!this.audit) return null;
        var fieldName = this.auditChangedFieldsFieldName;
        return fieldName != null ? fieldName : "audit_changedFields";
    },

    //> @method dataSource.getAuditTypeFieldName()
    // Getter for +link{auditTypeFieldName}.
    // @return (String) field name used to store the +link{type:DSOperationType,operationType}
    //<
    getAuditTypeFieldName : function () {
        if (!this.audit) return null;
        var fieldName = this.auditTypeFieldName;
        return fieldName != null ? fieldName : "audit_operationType";
    },

    // Result Sets
	// --------------------------------------------------------------------------------------------
    getResultSet : function (params) {
        var resultSetClass = isc.ClassFactory.getClass(this.resultSetClass || isc.ResultSet);
        
        if (!isc.isA.Class(resultSetClass)) {
            this.logWarn("getResultSet(): Unrecognized 'resultSetClass' property:" 
                         + resultSetClass + ", returning a standard isc.ResultSet.");
            resultSetClass = isc.ResultSet;
        }
        
        // flag resultSet as autoCreated, so we know to destroy() it when the component no
        // longer needs it
        return resultSetClass.create(params, {_autoCreated: true});
    },
    
    getResultTree : function (params) {
        var resultTreeClass = isc.ClassFactory.getClass(this.resultTreeClass || isc.ResultTree);
        
        if (!isc.isA.Class(resultTreeClass)) {
            this.logWarn("getResultTree(): Unrecognized 'resultTreeClass' property:" 
                         + resultTreeClass + ", returning a standard isc.ResultTree.");
            resultTreeClass = isc.ResultTree;
        }
        
        // flag resultTree as autoCreated, so we know to destroy() it when the component no
        // longer needs it
        return resultTreeClass.create(params, {_autoCreated: true});
    },
    
    //> @method DataSource.dataChanged()
    // Notification method fired when a DataSource operation such as an 
    // +link{DataSource.addData(),add}, +link{DataSource.removeData(),remove} or 
    // +link{DataSource.updateData(),update} modifies the underlying data for a DataSource.
    // <P>
    // This method is used by +link{ResultSet}s to keep the user-visible data up to date as
    // changes are made.
    // <smartclient>
    // <P>
    // Note: rather than overriding this method, we recommend using 
    // +link{isc.Class.observe(),observation} to be notified when it is fired.
    // </smartclient>
    // 
    // @param dsResponse (DSResponse) response from the operation that modified the underlying
    //   data set
    // @param dsRequest (DSRequest) request that initiated the data change
    // @visibility external
    //<
    // Observable dataChanged methods.
    // ResultSets associated with this dataSource will observe these methods and use them
    // to handle cache-sync
    // Dont obfuscate: allow observers to pick up parameter names            
    dataChanged : function (dsResponse, dsRequest) {
//        alert("dataChanged: " + this);
        //!DONTOBFUSCATE
    },
    
    
    
    //> @method DataSource.updateCaches()
    // Causes any components using this DataSource to be notified of changes that have been made to
    // the remote dataset accessed via this DataSource, as though the provided DSResponse had just
    // successfully completed.  This will cause cache managers such as +link{ResultSet} or 
    // +link{ResultTree} to automatically update their caches, and components using such cache
    // managers to visually update to show modified data.
    // <P>
    // This API should be used when you have found out about changes made by other users or by
    // automatic processes.  For example, using the SmartClient +link{Messaging} system to receive
    // real-time updates via HTTP streaming, you may get updates that should affect a ListGrid
    // which is using a ResultSet to view a portion of a large dataset.  
    // <P>
    // The provided <code>DSResponse</code> should have
    // +link{dsResponse.operationType,operationType} "update", "add" or "remove" - there is no
    // way for a "fetch" response to meaningfully update arbitrary caches.  However, if you
    // have a list of updated records (possibly retrieved via +link{fetchData()}) you can still call
    // <code>updateCaches()</code>with DSResponses of type "update". Typically DataSource operations
    // that manipulate data operate on a single record at a time, but if you explicitly set the
    // <code>response.data</code> attribute to an array of records, framework code will handle this
    // as it would multiple updates.
    // <P>
    // Example usage: if you had a ListGrid bound to the <code>supplyItem</code> sample DataSource, 
    // and that ListGrid was showing a Record with <code>itemId</code> 23, and you wanted to update 
    // the <code>unitCost</code> field to a new value, you would use the following code:<br><br>
    // <smartclient>
    //    <code>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// updatedRecord is the record we want to update<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var record = supplyItemDS.copyRecord(updatedRecord);<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;record.unitCost = 500;<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;var dsResponse = {<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;data: [record],<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;operationType: "update"<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;};<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;supplyItemDS.updateCaches(dsResponse);<br>
    //   </code>
    // </smartclient>
    // <smartgwt>
    //    <code>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;// updatedRecord is the record we want to update<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Record record = supplyItemDS.copyRecord(updatedRecord);<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;record.setAttribute("unitCost", 500);<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;DSResponse dsResponse = new DSResponse();<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dsResponse.setData(record);<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;dsResponse.setOperationType(DSOperationType.UPDATE);<br>
    //    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;supplyItemDS.updateCaches(dsResponse);<br>
    //    </code>
    // </smartgwt>
    // <P>
    // To cause all components that have cache managers to drop their caches, provide a
    // DSResponse with +link{dsResponse.invalidateCache} set.
    // <P>
    // As an alternative to calling <code>updateCaches()</code> directly, if updates to other
    // DataSources occur as a result of server-side logic, you can use the server-side API
    // DSResponse.addRelatedUpdate(DSResponse) (Pro Edition and above), which ultimately calls
    // <code>updateCaches()</code> for you - see that method's documentation for details.
    // <P>
    // <b>NOTE:</b>: if <code>updateCaches</code> is called for a
    // +link{dataSource.clientOnly,clientOnly} DataSource, it will update
    // +link{DataSource.cacheData} synchronously in addition to notifying all cache managers as
    // normal.
    // <P>
    // If a DataSource has +link{cacheAllData} set and a full cache has been obtained, calling
    // <code>updateCaches</code> will automatically update the cache.
    // <P>
    // Note that the DSResponse provided to this method will <b>not</b> go through
    // +link{transformResponse()} or other processing that would normally occur for a
    // DSResponse resulting from a DSRequest sent by the application in this page.
    //
    // @param dsResponse (DSResponse) the provided DSResponse must minimally have 
    //                                dataSource, operationType, and data set
    // @param [dsRequest] (DSRequest) optional dsRequest.  If not specified, a DSRequest will be
    //                                automatically created based on the DataSource and operationType of
    //                                the DSResponse
    // @visibility external
    //<
	updateCaches : function (dsResponse, dsRequest) {
	    // If dsRequest is null, generate a dummy request with the appropriate operationType
	    // and dataSource
	    if (dsRequest == null) {
	        dsRequest = {
	            operationType:dsResponse.operationType,
	            dataSource:this
	        };
	        if (dsResponse.clientContext != null) {
	            dsRequest.clientContext = dsResponse.clientContext;
	        }
            if (dsResponse.internalClientContext != null) {
                dsRequest.internalClientContext = dsResponse.internalClientContext;
            }
	    } else {
            // ensure the dsRequest is marked with a DataSource.  Downstream code depends on this
            dsRequest.dataSource = dsRequest.dataSource || dsResponse.dataSource || this;
        }

		var updateData = dsResponse.data,
            forceCacheInvalidation = dsResponse.invalidateCache,
            responseCode = dsResponse.httpResponseCode;

        // check the response code for a valid empty file, in which case we just keep 
        // the client-side updates.
		if (!updateData && !forceCacheInvalidation 
            && !(responseCode >= 200 && responseCode < 300)) {
			//>DEBUG
			this.logWarn("Empty results returned on '" + dsRequest.operationType + 
                         "' on dataSource '" + dsRequest.dataSource + 
                         "', unable to update resultSet(s) on DataSource " + this.ID +
                         ".  Return affected records to ensure cache consistency.");
			//<DEBUG
			return;
		}
        
        // if we're caching all data and the cache is full, force refresh if data is invalid
        
        if (!this.clientOnly && this.cacheAllData && this.hasAllData() && 
            !isc.isAn.Array(updateData))
        {
            this.invalidateCache();
        }

        this.dataChanged(dsResponse, dsRequest);

        // if not invalidating the cache, apply update for a clientOnly DataSource
        if (dsResponse.invalidateCache != true && this.clientOnly && updateData) {
            // if the dsRequest has already modified the clientOnly data via a call to 
            // getClientOnlyResponse(), there's no need to call that method again now - check
            // for flag request.clientOnlyDataModified
            if (dsRequest.clientOnlyDataModified != true) {
	            if (isc.isAn.Array(updateData)) {
	                updateData.forEach(function (record) {
	                    dsRequest.data = record;
	                    // pass the third param, which causes data to be affected
	                    this.getClientOnlyResponse(dsRequest, null);
	                }, this);
	            } else {
	                dsRequest.data = updateData;
	                // pass the third param, which causes data to be affected
	                this.getClientOnlyResponse(dsRequest, null);
	            }
            }
        }
	},

    // ---------------------------------------------------------------------------------------
    // XML
    // ---------------------------------------------------------------------------------------

    //> @method dataSource.getLegalChildTags()
    // For a DataSource that describes a DOM structure, the list of legal child elements that can
    // be contained by the element described by this DataSource.
    // <p>
    // For a DataSource described by XML schema, this is the list of legal subelements <b>of
    // complexType</b> (elements of simpleType become DataSourceFields with atomic type).
    // <p>
    // Note that currently, if an XML schema file contains ordering constraints, DataSources
    // derived from XML Schema do not capture these constraints.
    //
    // @group xmlSchema
    // @visibility xmlBinding
    //<
    getLegalChildTags : function () {
        var fieldNames = this.getFieldNames(),
            complexFields = [];
        for (var i = 0; i < fieldNames.length; i++) {
            if (this.fieldIsComplexType(fieldNames[i])) complexFields.add(fieldNames[i]);
        }
        return complexFields;
    },

    // get the operationBinding for this operation.  The operationBinding is the bundle of 
    // properties specifying how to invoke a particular DataSource operation, eg "fetch".  
    // <BR>
    // In the absence of an operationBinding for a particular operation, the DataSource itself 
    // is used as the operationBinding, with the same set of properties supported - in this 
    // case you basically have a read-only DataSource, only capable of fetching.
    // <BR>
    // Takes either a dsRequest or an operationType and optional operationId.  
    getOperationBinding : function (operationType, operationId) { 
        if (operationType == null || this.operationBindings == null) return this;

        if (isc.isAn.Object(operationType)) {
            // passed a DSRequest 
            var dsRequest = operationType;
            operationType = dsRequest.operationType;
            operationId = dsRequest.operationId;
        }

        var schemaName;
        // look for a binding specific to the operationId (eg myFetchSchema) if passed
		
        if (operationId) {
            var operationBinding = this.operationBindings.find({
				operationId: operationId,
				operationType: operationType
			});
            if (operationBinding) return operationBinding;
        }
        // look for a binding for this operationType
		
        if (operationType) { 
            var operationBindings = this.operationBindings.findAll("operationType", operationType);
            if (operationBindings) {
                for (var i = 0; i < operationBindings.length; i++) {
                    if (!operationBindings[i].operationId || 
                            operationBindings[i].operationId.trim() == "")
                    {
                        return operationBindings[i];
                    }
                }
            }
        }
        return this;
    },

    getDataFormat : function (operationType, operationId) {
        return this.getOperationBinding(operationType, operationId).dataFormat || this.dataFormat;
    },
    
    // If preventHTTPCaching is set, use the RPCRequest.bypassCache attribute
    shouldBypassCache : function (operationType, operationId) {
        var preventCache = this.getOperationBinding(operationType, operationId).preventHTTPCaching;
        if (preventCache == null) preventCache = this.preventHTTPCaching;        
        return preventCache;
    },

    //> @method dataSource.copyRecord()
    // Copies all DataSource field values of a Record (including a TreeNode) to a new 
    // Record, omitting component-specific metadata such as selected state from grids, 
    // or parent folders for TreeNodes.
    // @param record (Record) The record to be copied. 
    // @return  (Record) A new copy of the record provided as an argument, with 
    // component-specific metata data removed.
    // @visibility external
    //<
    copyRecord : function (original) {
    	if (original == null) return null;

        var copy = {},
            fieldNamesArray = this.getFieldNames(false);

        for (var i = 0; i < fieldNamesArray.length; i++) {
        	
        	var fieldName = fieldNamesArray.get(i),
        	    value = original[fieldName],
        	    field = this.getField(fieldName);

            if (isc.isA.Date(value)) {
                var dateCopy = new Date();

                dateCopy.setTime(value.getTime());
                dateCopy.logicalDate = value.logicalDate;
                dateCopy.logicalTime = value.logicalTime;

                copy[fieldName] = dateCopy;

            // If the multiple flag is true and the field type is not
            // datasource then we want to duplicate the array if it is one.
            } else if (isc.isAn.Array(value) && 
            		   field.multiple == true && 
            		   field.type == null) 
            {
            	var arrayCopy = [];

            	for (var j =0; j < value.length; j++){

            		if (isc.isA.Date(value[j])) {
                        var dateCopy = new Date();

                        dateCopy.setTime(value[j].getTime());
                        dateCopy.logicalDate = value[j].logicalDate;
                        dateCopy.logicalTime = value[j].logicalTime;

                        arrayCopy[j] = dateCopy;
                    } else {
                    	arrayCopy[j] = value[j];
            		}
            	}

            	copy[fieldName] = arrayCopy;
            } else {
            	copy[fieldName] = value;
            }
        }
        return copy;
    },

    //> @method dataSource.copyRecords()
    // Copies all DataSource field values of an (Array) of Records (including a TreeNode) 
    // to a new array of Records, omitting component-specific metadata such as selected state 
    // from grids, or parent folders for TreeNodes. This method calls 
    // +link{DataSource.copyRecord()} for each item in the array.
    // @param records (Array of Record) The array of Record objects to be copied. 
    // @return (Array of Record) A new copy of each record provided in the array argument, 
    // with component-specific metata data removed.
    // @visibility external
    //<
    copyRecords : function (originals) {
    	if (originals == null) return null;

        var copies = [];

        for (var i = 0; i < originals.length; i++) {
        	var original = originals[i],
        	    copy = this.copyRecord(original);

        	copies[i] = copy;
        }
        return copies;
    },

    //> @method dataSource.cloneDSRequest() (A)
    // Creates a shallow copy of the given +link{DSRequest}. The request's +link{DSRequest.data,data},
    // if any, is shallow copied in the cloned request.
    // <p>
    // The +link{DSRequest.callback,callback} property of the given request is not copied into
    // the cloned request.
    // @param dsRequest (DSRequest) the DSRequest to clone.
    // @return (DSRequest) a clone of the given DSRequest object.
    // @see DataSource.cloneDSResponse()
    // @visibility external
    //<
    cloneDSRequest : isc.DataSource._cloneDSRequest,

    //> @method dataSource.cloneDSResponse() (A)
    // Creates a shallow copy of the given +link{DSResponse}. All properties that would affect
    // the processing of the response are copied into the resulting DSResponse so that the cloned
    // response could substitute for the original response. The response's +link{DSResponse.data,data},
    // if any, is shallow copied in the cloned response.
    // @param dsResponse (DSResponse) the DSResponse to clone.
    // @return (DSResponse) a clone of the given DSResponse object.
    // @see DataSource.cloneDSRequest()
    // @visibility external
    //<
    cloneDSResponse : isc.DataSource._cloneDSResponse,

    //> @method dataSource.transformRequest() [A]
    // For a dataSource using +link{group:clientDataIntegration,client-side data integration},
    // return the data that should be sent to the +link{dataURL}.
    // <P>
    // By default, HTTP requests sent to non-SmartClient servers do not include DSRequest
    // metadata such as +link{dsRequest.startRow}, +link{dsRequest.endRow,endRow},
    // and +link{dsRequest.oldValues,oldValues}.  Only the core
    // +link{group:dataSourceOperations,datasource protocol data} is sent, such as the criteria
    // passed to +link{listGrid.fetchData,fetchData()} or the updated values submitted by
    // +link{dynamicForm.saveData(),form.saveData()}.  
    // <P>
    // transformRequest() allows you to transform dsRequest metadata into a
    // format understood by your server and include it in the HTTP request, so that you can
    // integrate DataSource features such as data paging with servers that support such
    // features.
    // <P>
    // How the data is actually sent to the URL is controlled by 
    // +link{operationBinding.dataProtocol}.  If using the "getParams" or
    // "postParams" protocol, data is expected to be a JavaScript Object where each property
    // will become a GET or POST'd parameter.  If using dataProtocol:"soap" or "postXML", data
    // will be serialized as an XML message by +link{method:DataSource.xmlSerialize()}.
    // <P>
    // As an example, if you have a dataURL that can return paged data given URL parameters
    // "start" and "end", you could implement transformRequest like so:
    // <smartclient>
    // <pre>
    //   isc.DataSource.create({
    //      ... 
    //      transformRequest : function (dsRequest) {
    //         if (dsRequest.operationType == "fetch") {
    //             var params = {
    //                start : dsRequest.startRow,
    //                end : dsRequest.endRow
    //             };
    //             // combine paging parameters with criteria
    //             return isc.addProperties({}, dsRequest.data, params);
    //         }
    //      }
    //   });
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <pre>
    //      &#64;Override
    //      protected Object transformRequest (DSRequest dsRequest) {
    //          JavaScriptObject data = dsRequest.getData();
    //          if (dsRequest.getOperationType () == DSOperationType.FETCH) {
    //              JSOHelper.setAttribute (data, "start", dsRequest.getStartRow());
    //              JSOHelper.setAttribute (data, "end", dsRequest.getEndRow());
    //          }
    //          return data;
    //      }
    // </pre>
    // </smartgwt>
    // Other reasons to implement transformRequest():
    // <ul>
    // <li> transform a +link{type:Criteria} object into the custom query language of a web
    //      service
    // <li> add a session id to requests that require authentication
    // <li> detect colliding updates by sending both updated values and the values the user
    //      originally retrieved before editing began (available as +link{dsRequest.oldValues})
    // </ul>
    // <i>Special case:</i> If the <code>dataProtocol</code> is <code>"clientCustom"</code>
    // the SmartClient system will not attempt to send data to the server in any way. Instead 
    // transformRequest should be implemented such that it accesses or updates the underlying
    // data-set and calls +link{DataSource.processResponse()} when the operation is complete. This
    // setting allows straightforward integration with non SmartClient comm mechanisms that 
    // directly send requests to the server (such as GWT-RPC), or handle data manipulation without
    // sending HTTP at all (such as Google Gears).<br>
    // A <code>transformRequest</code> override may also be used to set the +link{dsRequest.dataProtocol}
    // to clientCustom at runtime, giving developers a way to intercept normal handling for
    // some particular request, and provide entirely custom handling written on the client.
    // <P>
    // Note: The +link{RestDataSource} class overrides transformRequest() to handle xml-serializing
    // the request (including meta data) into a standard format.
    //
    // @param dsRequest (DSRequest) the DSRequest being processed
    // @return (Any) data to be sent to the dataURL
    // @visibility xmlBinding
    //<
    transformRequest : function (dsRequest) {
        return dsRequest.data;
    },

    //> @method dataSource.getUpdatedData() [A]
    // Helper method to retrieve the updated data from a successful dataSource update or add 
    // operation.
    // @param dsRequest (DSRequest) Update request object passed to the server. Note that this
    //  request may have been modified by +link{DataSource.transformRequest()} 
    // @param dsResponse (DSResponse) Response returned by the server
    // @param useDataFromRequest (boolean) If +link{DSResponse.data} is empty, should data be
    //  derived from the submitted request.
    // @return data (DataSourceRecord | Array of DataSourceRecords) Updated data.
    // @visibility external
    //<
    
    getUpdatedData : function (dsRequest, dsResponse, useDataFromRequest, copyData) {
        var updateData = dsResponse.data;
        // If the server failed to return the updated records, and updateCacheFromRequest is true,
        // integrate the submitted values into the cache if the operation was succesful.
        if (useDataFromRequest && 
            dsResponse.status == 0 && 
            (updateData == null || 
             (isc.isA.Array(updateData) && updateData.length == 0) || 
             isc.isAn.emptyString(updateData))
           ) 
        {
            this.logInfo("dsResponse for successful operation of type " + dsRequest.operationType + 
                         " did not return updated record[s]. Using submitted request data to update"
                         + " ResultSet cache.", "ResultSet");
            var requestData = dsRequest.data;
            if (dsRequest.data && isc.isAn.Object(dsRequest.data)) {
                
                // if operationType is an update, request data will be sparse so need to combine 
                // with oldValues
                if (dsRequest.operationType == "update") {
                    updateData = isc.addProperties({}, dsRequest.oldValues);
            
                    // Assertion - we only update one record at a time, so if submitted data is an array
                    // it will contain one entry that matches the 'oldValues'
                    if (isc.isAn.Array(requestData)) {
                        updateData = isc.addProperties(updateData, requestData[0]);  
                    } else {
                        updateData = isc.addProperties(updateData, requestData);
                    }
                    updateData = [updateData];
                // for add or delete old values are irrelevant
                } else {      
                    if (!isc.isAn.Array(requestData)) requestData = [requestData];
                    updateData = [];
                    for (var i = 0; i < requestData.length; i++) {
                        updateData[i] = isc.addProperties({}, requestData[i]);
                    }
                }
                // updateData set to a new object, so we can skip it below
                copyData = false; 

                //>DEBUG
                if (this.logIsDebugEnabled("ResultSet")) {
                    this.logDebug("Submitted data to be integrated into the cache:"
                                  + this.echoAll(updateData), "ResultSet");
                }
                //<DEBUG
            }
        }
        // if copy requested and updateData isn't already a new object, copy it now
        return copyData ? isc.shallowClone(updateData) : updateData;
    },
    
    
    serializeFields : function (data, dsRequest) {
    

        if (!data && dsRequest != null) data = dsRequest.data;
        if (!data) return data;

        // don't try to serialize simpleType values
        if (isc.DS.isSimpleTypeValue(data)) return data;

        if (isc.isAn.Array(data)) {
            var newData = [];
            for (var i = 0; i < data.length; i++) {
                newData[i] = this.serializeFields(data[i], dsRequest);
            }
            return newData;
        } else if (this.isAdvancedCriteria(data)) {
            return this.serializeAdvancedCriteria(data);
        }
        data = isc.addProperties({}, data);

        
        if (data.__ref) {
            delete data.__ref;
            delete data.__module;
        }

        var fields = this.getFields();
        for (var fieldName in fields) {
        
            // Skip non-object values - we only care about dates
            // and nested objects which could contain dates.
            if (!isc.isAn.Object(data[fieldName])) continue;
        	
            var field = fields[fieldName],
                type = field.type,
                typeDS = type != null ? isc.DataSource.get(type) : null;
            	
            if (typeDS && typeDS.serializeFields) {
                data[fieldName] = typeDS.serializeFields(data[fieldName]);
            	
            } else if (isc.isA.Date(data[fieldName])) {
                if (isc.SimpleType.getBaseType(field.type) == "date" &&
                    !isc.SimpleType.inheritsFrom(field.type, "datetime"))
                {
                    // NOTE: we choose to flag the date instead of serializing it right here
                    // because we want isc.Comm.xmlSerialize() to use xsi:type="date" for clarity 
                    data[fieldName].logicalDate = true;
                } else if (isc.SimpleType.getBaseType(field.type) == "time") {
                    data[fieldName].logicalTime = true;
                }
            }
        }
        return data;
    },

    
    serializeAdvancedCriteria : function (data) {
        data = isc.clone(data);
        if (data.criteria) {
            for (var i = 0; i < data.criteria.length; i++) {
                data.criteria[i] = this.serializeAdvancedCriteria(data.criteria[i]);
            }
        } else {
            if (isc.isA.Date(data.value) || isc.isA.Date(data.start) || isc.isA.Date(data.end)) {
                var field = this.getField(data.fieldName);
                if (field != null) {
                    if (isc.SimpleType.getBaseType(field.type) == "date" &&
                        !isc.SimpleType.inheritsFrom(field.type, "datetime")) 
                    {
                        if (data.value) data.value.logicalDate = true;
                        if (data.start) data.start.logicalDate = true;
                        if (data.end) data.end.logicalDate = true;
                    } else if (isc.SimpleType.getBaseType(field.type) == "time") {
                        if (data.value) data.value.logicalTime = true;
                        if (data.start) data.start.logicalTime = true;
                        if (data.end) data.end.logicalTime = true;
                    }
                }
            }
        }
        return data;
    },
    
    
    //> @method DataSource.getDataProtocol() [A]
    // Returns the appropriate +link{OperationBinding.dataProtocol} for a +link{DSRequest}
    // @param dsRequest (DSRequest) DataSource Request object
    // @return (DSProtocol) DataProtocol to be used for this request operation.
    // @visibility external
    //<
    getDataProtocol : function (dsRequest) {
        
        // Support the protocol being specified directly on the request.
        // Rare case, mainly useful for a custom transformRequest implementation which
        // sets the protocol to 'clientCustom' for a particular request.
        if (dsRequest.dataProtocol != null) {
            return dsRequest.dataProtocol;
        }
        
        var operationBinding = this.getOperationBinding(dsRequest),
            service = this.getWebService(dsRequest);
        // WSDL-described web services use SOAP unless a dataProtocol has been explicitly set
        // for the operationBinding.
        // NOTE: protocol per operationBinding allows eg GET fetch, POST update
        // To avoid serializing the records when the request is clientOnly, we make this
        // method to return “clientOnly” when the dsRequest is clientOnly.
        // As this is not a valid value for DSProtocol, just an internal type, we do not
        // document "clientOnly" as a valid value for DSProtocol.
        return (operationBinding.dataProtocol != null ? operationBinding.dataProtocol :
                 isc.isA.WebService(service) ? "soap" : this.clientOnly ? "clientOnly" :
                 this.dataProtocol || "getParams");
    },

    _storeCustomRequest : function (dsRequest) {
        // clientCustom dataProtocol 
        // - transformRequest has been implemented to call non SmartClient code to generate the
        //   appropriate response, and call 'processResponse()' with it.
        // - store out the request so we can retrieve it by ID when processResponse fires.
        //   Doing this before calling transformRequest should handle synchronous as well as asynch
        //   response generation code.
        // - note we do this unconditionally since it is allowed to switch a request
        //   dynamically to clientCustom in transformRequest.  If it turns out it's not a
        //   clientCustom request, we just remove the entry later
        if (!this._clientCustomRequests) this._clientCustomRequests = {};
        this._clientCustomRequests[dsRequest.requestId] = dsRequest;
    },
    
    // get rpcRequest properties that should be set on this dsRequest based on dataProtocol and
    // other DataSource settings.
    // NOTE: 
    // - these settings will be applied to an rpcRequest which is a *copy* of the dsRequest,
    //   which is why we don't simply change the settings directly here.  See 
    //   "RPCRequest vs DSRequest" comment elsewhere in this file
    // - we need to be careful to respect overrides set on the dsRequest
    getServiceInputs : function (dsRequest) {
        
        var operationBinding = this.getOperationBinding(dsRequest),
            service = this.getWebService(dsRequest),
            operation = this.getWSOperation(dsRequest);

        this.addDefaultCriteria(dsRequest, operationBinding);

        // call transformRequest to allow the data to be changed before it is serialized to the
        // wire.  Hang onto the data in it's original format too
        dsRequest.originalData = dsRequest.data;

        this._storeCustomRequest(dsRequest);

        this.applySendExtraFields(dsRequest);

        // offline handling may mean we never send this request
        if (!this.clientOnly) {
            if (this.fulfilledFromOffline(dsRequest)) return { dataProtocol:"clientCustom" };

            // Save a copy of the unconverted DSRequest onto itself, for later use as a key in the
            // the isc.Offline cache.  See the comments near the call to convertRelativeDates() in 
            // DataSource.sendDSRequest() for details of why we do this.
            dsRequest.unconvertedDSRequest = isc.shallowClone(dsRequest);
        }

        if (this.autoConvertRelativeDates == true) {
            // convert any relative dates in criteria into absolute dates so the server
            // doesn't need to know how to handle relative dates
            if (this.logIsInfoEnabled("relativeDates")) {
                this.logInfo("Calling convertRelativeDates from getServiceInputs "+
                    "- data is\n\n"+isc.echoFull(transformedData));
            }

            var data = this.convertRelativeDates(dsRequest.data);

            if (this.logIsInfoEnabled("relativeDates")) {
                this.logInfo("Called convertRelativeDates from getServiceInputs "+
                    "- data is\n\n"+isc.echoFull(transformedData));
            }
            dsRequest.data = data;
        } else {
            dsRequest.data = this.embedTimezoneInRelativeDates(dsRequest.data);
        }
        
        // Copy the dataProtocol onto the request so custom code in
        // transformRequest can examine it directly
        dsRequest.dataProtocol = this.getDataProtocol(dsRequest);

        var transformedData = this.transformRequest(dsRequest);
        // correct the common error of returning the dsRequest itself incorrectly, which is
        // never right since the dsRequest contains various widgets and other data
        // inappropriate to send to the server.
        if (transformedData !== dsRequest) {
            dsRequest.data = transformedData;
        }

        // If it was a clientCustom request, just return and wait for a call to
        // processResponse.  Note dynamic checks allows switching dataProtocol in
        // transformRequest
        var protocol = this.getDataProtocol(dsRequest),
            clientCustom = protocol == "clientCustom";
        if (clientCustom) {
            return {dataProtocol:"clientCustom"};
        } else {
            delete this._clientCustomRequests[dsRequest.requestId];
        }

        if (isc.isA.WebService(service)) {
            if (dsRequest.wsOperation == null && isc.isAn.Object(operation)) {
                dsRequest.wsOperation = operation.name;
            }
            this.logInfo("web service: " + service + 
                          ", wsOperation: " + this.echoLeaf(operation), "xmlBinding");
        }

        dsRequest._sentTime = isc.timestamp();
        
        var dataURL = this.getDataURL(dsRequest);

        // allow dataURL to be specified as a DSRequest property.  Needed because the same
        // structure of data may come from many different URLs (such as RSS feeds or WSDL
        // files).  Also allow actionURL because we advertise that all RPCRequest props are
        // legal on DSRequests.
        dataURL = dsRequest.actionURL || dsRequest.dataURL || dataURL;
 
        // allow useHttpProxy to be set on operationBinding or DataSource
        if (dsRequest.useHttpProxy == null) {
            dsRequest.useHttpProxy = this._firstNonNull(operationBinding.useHttpProxy,
                                                        this.useHttpProxy);
        }
       
        // getParams / postParams send the request data to the server as params.
        // In addition to this, regardless of data protocol we support explicit
        // per request params, and defaultParams from the DS / binding.
        var params,
            defaultParams = operationBinding.defaultParams || this.defaultParams,
            explicitParams = dsRequest.params;
        
        if (defaultParams || explicitParams) {
            params = isc.addProperties({}, defaultParams, explicitParams);
        }

        var dataAsParams = protocol == "getParams" || protocol == "postParams"; 
        if (dataAsParams) {
            params = isc.addProperties(params || {}, dsRequest.data);
        }
        
        if (dataAsParams) {
    
            if (params) params = this.serializeFields(params, dsRequest);
            
            // GET or POST with form-style params
            return {
                actionURL: dataURL,
                httpMethod: dsRequest.httpMethod || (protocol == "getParams" ? "GET" : "POST"),
                params: params
            };
        }
        
        // remaining possibilities ("postMessage", "postXML", "soap") all POST a request body

        var serviceInputs = {
            actionURL: dataURL,
            // allow httpMethods like "PUT"
            httpMethod: dsRequest.httpMethod || "POST"
        };
        // if necessary pass params to the server as well as data in the body
        if (params) serviceInputs.params = params;
        
        if (protocol == "postMessage") {
            serviceInputs.data = (dsRequest.data || "").toString();
        }

        // for XML posts, serialize the data as XML
        if (protocol == "postXML" || protocol == "soap") {
            var flags = this.getSerializeFlags(dsRequest);
            var requestBody = serviceInputs.data = this.getXMLRequestBody(dsRequest);
            serviceInputs.contentType = dsRequest.contentType || "text/xml";
            this.logDebug("XML post requestBody is: " + requestBody, "xmlBinding");
        }

        // add SOAPAction HTTP header for SOAP
        if (protocol == "soap") {
            var soapAction = this._firstNonNull(operationBinding.soapAction, 
                                                operation.soapAction);
            // NOTE: some engines, like Axis, require a soapAction to be present, so people who
            // don't really need a soapAction put soapAction="" into their WSDL, hoping for a
            // meaningless 'SOAPAction: ""' header to get by Axis.
            if (soapAction == null) soapAction = '""';
            serviceInputs.httpHeaders = isc.addProperties({ SOAPAction : soapAction },
                                                            dsRequest.httpHeaders);

            var spoofResponses = isc.isA.WebService(service) &&
                                 this._firstNonNull(operationBinding.spoofResponses,
                                                    this.spoofResponses);
                                
            if (spoofResponses) {
                serviceInputs.spoofedResponse = service.getSampleResponse(operation.name);
                this.logInfo("Using spoofed response:\n" + serviceInputs.spoofedResponse, "xmlBinding");
            }
            
        }

        if (this.logIsDebugEnabled("xmlBinding")) {
            this.logDebug("serviceInputs are: " + this.echo(serviceInputs), "xmlBinding");
        }
        return serviceInputs;
    },

    //> @attr dataSource.implicitCriteria (Criteria : null : IRW)
    // Criteria that are implicitly applied to all fetches made through this DataSource.  These
    // criteria are never shown to or edited by the user and are cumulative with any other 
    // criteria provided on the DSRequest.
    // <P>
    // For example, a DataSource might *always* implicitly limit its fetch results to records 
    // owned by the current user's department.  Components and ResultSets requesting data 
    // from the DataSource can then apply further implicitCriteria of their own, separately 
    // from their regular, user-editable criteria.
    // <P>
    // For instance, a grid bound to this dataSource might be further limited to 
    // implicitly show only the subset of records created by the current user.  See 
    // +link{dataBoundComponent.implicitCriteria} and +link{resultSet.implicitCriteria} for 
    // more on these localized options.
    // <P>
    // Note that, while <code>implicitCriteria</code> can be declared in a server DataSource 
    // file using +link{group:componentXML, Component XML}, it is an entirely client-side 
    // feature, added by client-side components.  So it does not affect server-side requests, 
    // and will not be added to client-side requests that don't come from a SmartClient UI 
    // (eg RestHandler).
    // @serverDS allowed
    // @visibility external
    //<
    
    _getCombinedImplicitCriteria : function (request) {
        

        // no request, or the request has a resultSet (which already has combined implicitCrit)
        // just return this DS's implicitCrit
        if (!request || request.resultSet) return this.implicitCriteria;

        // if there's a request.resultTree (IDoc above), or request.dbcImplicitCriteria, is
        // set, want to continue and combine criteria - otherwise, just return this DS's 
        // implicitCriteria
        if (!request.resultTree && !request.dbcImplicitCriteria) return this.implicitCriteria;

        // combine any implicitCriteria specified on the DBC and the RT
        var rs = request.resultTree,
            dbcCriteria = isc.DataSource.copyCriteria(request.dbcImplicitCriteria),
            rsCriteria = (!dbcCriteria && rs && rs.getImplicitCriteria ? rs.getImplicitCriteria() : null),
            dsCriteria = this.implicitCriteria
        ;
        var implicitCriteria = this.combineCriteria(dbcCriteria, rsCriteria);
        if (dsCriteria) {
            // combine the implicitCriteria from DBC/RS with that from the DS
            implicitCriteria = this.combineCriteria(implicitCriteria, 
                isc.DataSource.copyCriteria(dsCriteria), null, request.textMatchStyle
            );
        }
        if (implicitCriteria) {
            implicitCriteria = isc.DS.compressNestedCriteria(implicitCriteria);
        }

        return implicitCriteria;
    },

    addImplicitCriteria : function (dsRequest) {
        // no request or not a "fetch" request - bail
        if (!dsRequest || dsRequest.operationType != "fetch") return;
        
        var implicitCriteria = this._getCombinedImplicitCriteria(dsRequest);

        var doLogs = false;
        if (implicitCriteria) {
            // store the original, explicit criteria for reference
            
            dsRequest.explicitCriteria = isc.shallowClone(dsRequest.data);
            // and add the implicitCriteria to dsRequest.data - pass the textMatchStyle
            dsRequest.data = this.combineCriteria(dsRequest.data, implicitCriteria, null, 
                dsRequest.textMatchStyle);
            this.logInfo("Explicit criteria: \n" + isc.echoFull(dsRequest.explicitCriteria) +
                        "\n\nimplicitCriteria: \n" + isc.echoFull(implicitCriteria) +
                        "\n\nAll criteria: \n" + isc.echoFull(dsRequest.data));
        }
    },
    
    addDefaultCriteria : function (dsRequest, operationBinding) {
        var defaultCriteria = operationBinding.defaultCriteria || this.defaultCriteria;
        
        // nothing to do if there's no defaultCriteria
        if (!defaultCriteria) return;
        
        defaultCriteria = isc.addProperties({}, defaultCriteria);
        if (defaultCriteria && dsRequest.operationType == "fetch") {
            if (this.isAdvancedCriteria(dsRequest.data)) {
                // combineCriteria will retain references to like fields from both criteria sets,
                // which is inappropriate for this use case - we want the real values to hide the
                // default values, otherwise we'll end up with something like 
                // "myField = 'defaultValue' AND myField = 'realValue'".  This isn't straightforward
                // because AdvancedCriteria can be arbitrarily complex.  So, we'll assume that the 
                // defaultCriteria is always simple (and document it that way) and remove from it
                // any property that is named anywhere in the existing criteria
                var fieldNames = this.mineCriteriaFieldNames(dsRequest.data);
                for (var key in defaultCriteria) {
                    if (fieldNames.contains(key)) delete defaultCriteria[key];
                }
            }
            // nothing to do if all defaultCriteria were removed (because they're already used!)
            if (isc.getValues(defaultCriteria).length > 0) {
                dsRequest.data = this.combineCriteria(dsRequest.data, 
                                    defaultCriteria, "and", null, dsRequest.textMatchStyle);
            }
        }
    },
    
    mineCriteriaFieldNames : function (criteria) {
    	var fieldNames = [];
        if (!criteria.criteria) return fieldNames;
        
        for (var i = 0; i < criteria.criteria.length; i++) {
            if (criteria.criteria[i].criteria) {
                fieldNames.addList(this.mineCriteriaFieldNames(criteria.criteria[i]));
            } else {
                fieldNames.add(criteria.criteria[i].fieldName);
            }
        }
        return fieldNames;
    },

    
    _removeExtraAdvancedCriteriaFields : function (criterion) {
        var criteria = criterion.criteria;
        if (criteria) {
            var operator = criterion.operator,
                isOR = operator == "or" || operator == "OR";
            for (var i = 0; i < criteria.length; i++) {
                if (this._removeExtraAdvancedCriteriaFields(criteria[i])) {
                    if (isOR) {
                        criteria.length = 0;
                    } else {
                        criteria.removeAt(i--);
                    }
                }
            }
            return criteria.length == 0;
        } else {
            var fieldName = criterion.fieldName;
            return !this.getField(fieldName);
        }
    },
    
    applySendExtraFields : function (dsRequest) {
        if (this.sendExtraFields) return;

        // If sendExtraFields is false, remove any non-ds fields from the record(s) in request.data
        // before calling transformRequest
                
        var data = dsRequest.data;
        if (!isc.isAn.Array(data)) data = [data];

        for (var i = 0; i < data.length; i++) {
            var record = data[i];
            if (!isc.isAn.Object(record)) continue;

            
            if (this.isAdvancedCriteria(record)) {
                this._removeExtraAdvancedCriteriaFields(record);
            } else {
                for (var field in record) {
                    if (!this.getField(field)) delete record[field];
                }
            }
        }
    },
    
    //> @method DataSource.processResponse() (A)
    // Process a dsResponse for a request initiated by a DataSource with
    // +link{OperationBinding.dataProtocol,dataProtocol:"clientCustom"}.
    // <code>requestId</code> parameter should be dsRequest.requestId as found on the dsRequest
    // passed to +link{dataSource.transformRequest()}.
    // <P>
    // You must provide a response for both error and non-error cases.  For an error case, a
    // sufficient response is:
    // <pre>
    // { status : -1 }
    // </pre>
    // @param requestId (String) requestId attribute from the associated dataSource request object
    // @param dsResponse (DSResponse Properties) Configuration for the dsResponse 
    // @visibility external
    //<
    processResponse : function (requestId, dsResponse) {
        var dsRequest = this._clientCustomRequests[requestId];
        if (dsRequest == null) {
            this.logWarn("DataSource.processResponse(): Unable to find request corresponding to ID "
                        + requestId + ", taking no action.");
            return;
        }
        delete this._clientCustomRequests[requestId];
        
        // assume success
        if (dsResponse.status == null) dsResponse.status = 0;
        if (dsResponse.status == 0) {
            // If start/endRow are unset check for data length
            var data = dsResponse.data;
            if (data == null) dsResponse.data = data = [];
            if (dsResponse.startRow == null) dsResponse.startRow = dsRequest.startRow || 0;
            if (dsResponse.endRow == null) dsResponse.endRow = dsResponse.startRow + data.length;
            if (dsResponse.totalRows == null) {
                dsResponse.totalRows = Math.max(dsResponse.endRow, data.length);
            }
        }

        this._completeResponseProcessing(data, dsResponse, dsRequest);
    },

    // An undocumented threshold over which the call to getClientOnlyResponse(), when
    // handling the data source reply of a client only data source, is to be executed
    // asynchronously.
    _asyncClientOnlyResponseThreshold: 200,

    _handleClientOnlyReply : function (rpcResponse, data, rpcRequest) {
        var serverData = this.cacheAllData && !this.clientOnly && this.cacheResultSet ? 
                this.cacheResultSet.getAllRows() : null,
            dsRequest = rpcRequest._dsRequest;

        // getClientOnlyResponse() is called asynchronously when the number of records is over
        // the configurable threshold _asyncClientOnlyResponseThreshold and copyLocalResults is
        // true.
        var callback = function (dsResponse) {
            // use by the Developer Console RPC tab to show clientOnly responses
            rpcResponse.clientOnlyData = dsResponse ? dsResponse.data : null;

            var op = dsRequest.operationType;
            if ( op == "fetch" || op == "add" || op == "update" || op == "remove") {
                this.resolveClientOnlyIncludeFrom(dsResponse.data);
            }
            this._completeResponseProcessing(data, dsResponse, dsRequest, rpcResponse, rpcRequest);
        };
        if (this.copyLocalResults &&
            this.getClientOnlyResponse === isc.DataSource.getInstanceProperty("getClientOnlyResponse"))
        {
            this._asyncGetClientOnlyResponse(dsRequest, serverData, callback);
        } else {
            // pass the third param, which causes data to be affected
            var dsResponse = this.getClientOnlyResponse(dsRequest, serverData);
            callback.call(this, dsResponse);
        }
    },

    
    _asyncGetClientOnlyResponse : function (request, serverData, callback) {
        //!OBFUSCATEOK

        var operationType = request.operationType,
            response = {
                status:0
            };

        if (!(operationType == "fetch" || operationType == "select" || operationType == "filter")) {
            // The synchronous version of getClientOnlyResponse() should be sufficient for handling
            // the other operation types (remove, delete, add, insert, replace, update, and validate).
            // pass the third param to ensure that getClientOnlyResponse() updates the underlying
            // serverData (usually this.cacheData)
            callback.apply(this, [this.getClientOnlyResponse(request, serverData)]);
            return;
        }

        if (!this.passesSecurityChecks(request)) {
            response.status = isc.RPCResponse.STATUS_AUTHORIZATION_FAILURE;
            response.data = request.securityFailureMessage;
            callback.call(this, response);
            return;
        }

        // initialize the spoofed dataset

        serverData = serverData || this.testData;

        var cacheData = this.cacheData,
            testData = this.testData,
            setCacheDataAndTestDataToServerData = false;

        // if we have serverData but no testData, it's a cacheAllData result - if we're also in
        // clientOnly mode, we need to set up the clientOnly cache - set both cacheData and the
        // now deprecated testData to the same array
        if (serverData && !this.testData && this.clientOnly) {
            cacheData = testData = serverData;
            setCacheDataAndTestDataToServerData = true;
        }

        if (!serverData || isc.isA.String(serverData)) {
            if (isc.isA.String(serverData)) {
                // ID or expression
                //>DEBUG
                this.logInfo(this.ID + " datasource: using testData property as data");
                //<DEBUG
                cacheData = testData = isc.eval(serverData);
                setCacheDataAndTestDataToServerData = true;
            } else if (window[this.ID + "TestData"]) {
                // dataset loaded in page under canonical name
                //>DEBUG
                this.logInfo(this.ID + " datasource: using " + this.ID + "TestData object as data");
                //<DEBUG
                cacheData = testData = window[this.ID + "TestData"];
                setCacheDataAndTestDataToServerData = true;
            } else {
                // initialize to empty list
                //>DEBUG
                this.logInfo(this.ID + " datasource: testData property and " + this.ID +
                             "TestData object not found, using empty list as data");
                //<DEBUG
                cacheData = testData = [];
                setCacheDataAndTestDataToServerData = true;
            }
            serverData = testData;
        }

        var result = this.getClientOnlyFetchResponse(request, serverData, true);
        response = result[0];
        var resultData = result[1];
        
        // shallow copy the results.  This allows test or example cases where the
        // "server data set" is changing independently of the client results
        var finish = function () {
            response.data = resultData;

            this._trackClientOnlyChanges(response, operationType);

            if (setCacheDataAndTestDataToServerData) {
                this.cacheData = this.testData = serverData;
            }

            callback.call(this, response);
        };
        if (this.copyLocalResults) {
            this._asyncCopyLocalResults(0, resultData.length, resultData, finish);
        } else {
            finish.call(this);
        }
    },

    _asyncCopyLocalResults : function (startIndex, endIndex, resultData, callback) {
        var finalIndex = endIndex,
            isSGWT = isc.Browser.isSGWT;
        endIndex = Math.min(endIndex, startIndex + this._asyncClientOnlyResponseThreshold);
        for (var i = startIndex; i < endIndex; ++i) {
        	if (this.deepCopyLocalResults) {
        		resultData[i] = isc.clone(resultData[i]);
			} else {
	            resultData[i] = isc.addProperties({}, resultData[i]);
			}
            // Clear out SGWT's __ref/__module pointers so that if the cacheData is created in
            // SGWT, Record.getOrCreateRef() won't return the same Java Record object for the
            // copied result record.
            if (isSGWT) {
                resultData[i][isc.gwtRef] = null;
                resultData[i][isc.gwtModule] = null;
            }
        }
        if (endIndex == finalIndex) {
            callback.call(this);
        } else {
            this.delayCall("_asyncCopyLocalResults", [endIndex, finalIndex, resultData, callback], 0);
        }
    },
    
    _handleCustomReply : function (rpcResponse, data, rpcRequest) {
        var dsResponse = {
            data : data,
            startRow : 0,
            endRow : 0,
            totalRows : 0,
            status : 0
        };
        var dsRequest = rpcRequest._dsRequest;
        this._completeResponseProcessing(data, dsResponse, dsRequest, rpcResponse, rpcRequest);
    },

    _handleJSONReply : function (rpcResponse, data, rpcRequest) {
        var dsRequest = rpcRequest._dsRequest,
            recordXPath = this.getOperationBinding(dsRequest).recordXPath || this.recordXPath;
        
        // log the raw object reply if we didn't just eval it from text (if we eval it from
        // text we've already logged the raw response)
        if ((rpcResponse._wasJSONTextReply || rpcResponse._wasCSVTextReply) && this.logIsDebugEnabled("xmlBinding")) {
            this.logDebug("Raw response data: " + this.echoFull(data), "xmlBinding");
        }

        // Hang onto the raw JSON object returned by the server. This allows transformResponse
        // to actually do something useful with the data returned (EG, pick up meta-data)
        var rawData = data;
        
        // Don't try to process null data - this can now happen if we get an invalid 
        // HTTP response (404, 500, etc) and willHandleError == true
		if ( data) {
	        if (recordXPath) {
	            // extract relevant records via XPath
	            data = isc.xml.selectObjects(data, recordXPath);
	            this.logInfo("JSON recordXPath: '" + recordXPath + 
	                         "', selected: " + this.echoLeaf(data), "xmlBinding");
	        }
	
            var responseDataSchema = this.getOperationBinding(dsRequest).responseDataSchema;
            data = this.recordsFromObjects(data, responseDataSchema);
	
	        if (this.logIsDebugEnabled("xmlBinding")) {
	            this.logDebug("Validated dsResponse.data: " + isc.echoFull(data), "xmlBinding");
	        }
	
	        // derive the default response
	        var dsResponse = {
	            data : data,
	            startRow : dsRequest.startRow || 0, 
	            status : 0 // assume success
	        };       

	        dsResponse.endRow = dsResponse.startRow + Math.max(0, data.length);
	        dsResponse.totalRows = Math.max(dsResponse.endRow, data.length);
	        
        } else {
	        // derive the default error response
            var status = rpcResponse.status;
            if (status == 0 || status == null) status = -1;
	        var dsResponse = {
	            status : status,
                data:rpcResponse.data
	        };
rawData=rpcResponse.results;
        }

        this._completeResponseProcessing(rawData, dsResponse, dsRequest, rpcResponse, rpcRequest);
    },
    
    _handleCSVTextReply : function (rpcResponse, csvText, rpcRequest) {
        if (rpcResponse.status != 0) return;

        var settings = isc.TextImportSettings.create({
            hasHeaderLine: true,
            trim: true
        });
        isc.TextImportSettings._importAsJsonObjects = true;
        var jsonObjects = this.recordsFromText(rpcResponse.data, settings);
        isc.TextImportSettings._importAsJsonObjects = false;        

        rpcResponse._wasCSVTextReply = true; 
        this._handleJSONReply(rpcResponse, jsonObjects, rpcRequest);
    },    

    _handleJSONTextReply : function (rpcResponse, jsonText, rpcRequest) {
        //!DONTOBFUSCATE
        
        // If the original request came from RestDataSource and formed part of a multi-op 
        // queue, queue-handling code in RPCManager will have eval'd the response already, 
        // so what is passed in here as "jsonText" is actually a real JS object
        if (rpcRequest.isRestRequest && !isc.isA.String(jsonText)) {
            var jsonObjects = jsonText;
        } else {
            // Don't try to process jsonText if we didn't get a valid response
            if (rpcResponse.status >= 0) {
                var evalText = jsonText;
                // Strip the json prefix / suffix if supplied, and transport was not scriptInclude
                // If response if empty, do not check prefix or suffix and consider it a valid response
                if (rpcRequest.transport != "scriptInclude" && evalText != null) {
                    // Strip whitespace before checking for specified prefix / suffix
                    var re;
                    if (this.jsonPrefix) {
                        re = new RegExp(/^\s*/);
                        evalText = evalText.replace(re, "");
                        if (evalText.startsWith(this.jsonPrefix)) {
                            evalText = evalText.substring(this.jsonPrefix.length);
                        } else {
                            if (!rpcResponse.data || rpcResponse.data.length == 0) {
                                this.logInfo("DataSource specifies jsonPrefix, but empty " + 
                                         "response returned from server. Processing response anyway.");
                            } else {
                                rpcResponse.status = isc.DSResponse.INVALID_RESPONSE_FORMAT;
                                rpcResponse.data = "The server failed to return a formatted response at all.";
                                this.logWarn("DataSource specifies jsonPrefix, but not present in " + 
                                         "response returned from server. Processing response anyway.");
                                this._handleJSONReply(rpcResponse, jsonObjects, rpcRequest);
                                return;
                            }
                        }
                    } 
                    if (this.jsonSuffix) {
                        re = new RegExp(/\s*$/)                
                        evalText = evalText.replace(re, "");            
                        if (evalText.endsWith(this.jsonSuffix)) {
                            evalText = evalText.substring(0, (evalText.length - this.jsonSuffix.length));
                        } else {
                            if (!rpcResponse.data || rpcResponse.data.length == 0) {
                                this.logInfo("DataSource specifies jsonSuffix, but empty " + 
                                             "response returned from server. Processing response anyway.");
                            } else {
                                rpcResponse.status = isc.DSResponse.INVALID_RESPONSE_FORMAT;
                                rpcResponse.data = "The server failed to return a formatted response at all.";
                                this.logWarn("DataSource specifies jsonSuffix, but not present in " + 
                                             "response returned from server. Processing response anyway.");
                                this._handleJSONReply(rpcResponse, jsonObjects, rpcRequest);
                                return;
                            }
                        }
                    }
                }

				var wasInvalid = false;
                try {
                	var jsonObjects;
                	if (rpcRequest.useStrictJSON) {
                		jsonObjects = isc.Class.parseStrictJSON(evalText, rpcRequest.jsonReviver);
					} else {
						// Note: FF1.0.7 bug: curly must be escaped in the following regex.  Not an issue in IE
						// or FF1.5
						if (evalText && evalText.match(/^\s*\{/)) {
							// eval barfs on "{ ...  }", thinking it's a closure
							evalText = "var evalText = " + evalText + ";evalText;"
						}
	                    jsonObjects = isc.eval(evalText);
					}
                } catch (e) {
                	
                    rpcResponse.status = isc.DSResponse.INVALID_RESPONSE_FORMAT;
                    rpcResponse.data = "Error: server returned invalid JSON response";
                    this.logWarn("Error evaluating JSON: " + e.toString() + ", JSON text:\n" +
                                 jsonText);
					wasInvalid = true;
                }

                // warn and bail if server response object evals to null.
                // This can happen if the response is "", or if it's something like "var foo = {};"
                // where the result of the eval is undef.
                // Avoids a JS error in handleJSONReply
                // In case of invalid JSON received, rpcResponse has been setup previously
				if (jsonObjects == null && !wasInvalid) {
                    rpcResponse.status = isc.DSResponse.INVALID_RESPONSE_FORMAT;
                    rpcResponse.data = "Error: server returned invalid JSON response";
                    this.logWarn("Evaluating JSON reply resulted in empty value. JSON text:\n" +
                                 this.echo(jsonText));
                    jsonObjects = jsonText;
                }
        
                // Hack to let _handleJSONReply know this JSON response came from text, for logging
                // purposes
                rpcResponse._wasJSONTextReply = true; 
            }
        }
        
        this._handleJSONReply(rpcResponse, jsonObjects, rpcRequest);
    },
    
    //> @type SkipJSONValidation
    // @visibility external
    // @value "full"       Skip validation for all fields.  In this mode, valueXPaths and 
    //                     getFieldValue implementations are skipped.
    // @value "partial"    Skip validation for fields with boolean, numeric, or string-drived
    //                     types.  Note that you must deliver all 
    //                     +link{dataSourceField.multiple}:true values as arrays.
    // @value "none"       Always do validation.
    //<
    
    //> @attr dataSource.skipJSONValidation (SkipJSONValidation : "none" : [IRW])
    // Sets what level of JSON validation will apply for this DataSource.
    // <P>
    // Note that the point of "partial" validation mode is that if the JSON ihat's delivered is
    // correct, we'll still need to validate to get "date" and such in the correct time, but
    // shouldn't need to for the rest.
    //
    // @visibility external
    //<

    _setCanSkipJSONValidation : function (field) {
        var canSkip = isc.SimpleType.inheritsFrom(field.type, "text")    ||
                      isc.SimpleType.inheritsFrom(field.type, "float")   ||
                      isc.SimpleType.inheritsFrom(field.type, "integer") ||
                      isc.SimpleType.inheritsFrom(field.type, "boolean");
        return (field._canSkipJSONValidation = canSkip);
    },
    
    //> @method dataSource.recordsFromObjects() [A]
    // Transform a list of Objects to DataSource records.
    // <P>
    // The value for each field is extracted from the XML according to the
    // rules described under +link{attr:DataSourceField.valueXPath}.  
    //<
    recordsFromObjects : function (data, schema) {

        // normalize to Array and apply schema
        if (!isc.isAn.Array(data)) data = [data];

        
        if (this.skipJSONValidation == true || this.skipJSONValidation == "full") return data;

        for (var i = 0; i < data.length; i++) {
            data[i] = this.validateJSONRecord(data[i], null, schema);
        }
        return data;
    },

    validateJSONRecord : function (record, disableXPath, schema) {
        // If no record was given, return null.
        if (!record) {
            return null;
        }
        if (schema == null) {
            schema = this;
        }
        var partial = this.skipJSONValidation == "partial",
            fieldNames = this.getFieldNames(),
            result = {};
        for (var i = 0; i < fieldNames.length; i++) {
            var fieldName = fieldNames[i],
                field = schema.getField(fieldName),
                fieldValue;

            if (field.valueXPath && !disableXPath && field.valueXPath != fieldName) {
                fieldValue = isc.xml.selectObjects(record, field.valueXPath, true);
            } else {
                fieldValue = record[fieldName];
            }
            
            if (field.getFieldValue) {
                if (!isc.isA.Function(field.getFieldValue)) {
            	    isc.Func.replaceWithMethod(field, "getFieldValue", 
                                                     "record,value,field,fieldName");
                }
                fieldValue = field.getFieldValue(record, fieldValue, field, fieldName);
            }

            var undef;
            if (fieldValue !== undef) {
                // skip "simple" types In "partial" validation mode
                if (partial) {
                    var canSkip = field._canSkipJSONValidation;
                    if (canSkip == null) {
                        canSkip = this._setCanSkipJSONValidation(field);
                    }
                    if (canSkip) {
                        result[fieldName] = fieldValue;
                        continue;
                    }
                }

                // validation fieldValue, if it is complex type
                var fieldDS = isc.DS.get(field.type);
                if (fieldDS && !(fieldDS.skipJSONValidation == true ||
                                 fieldDS.skipJSONValidation == "full"))
                {
                    if (isc.isAn.Array(fieldValue)) {
                        for (var j = 0; j < fieldValue.length; j++) {
                            fieldValue[j] = fieldDS.validateJSONRecord(fieldValue[j]);
                        }
                    } else {
                        fieldValue = fieldDS.validateJSONRecord(fieldValue);
                    }                    
                }

                //this.logWarn("validating value: " + fieldValue + 
                //             " of field: " + this.echo(field));
                // field is multiple:true
                
                if (field.multiple && isc.isAn.Array(fieldValue)) {
                    var childValue = [];
                    for (var j = 0; j < fieldValue.length; j++) {
                        childValue.push(this.validateFieldValue(field, fieldValue[j]));
                    }
                    result[fieldName] = childValue;
                } else {
                    result[fieldName] = this.validateFieldValue(field, fieldValue);
                }
            }
        }

        if (schema.dropExtraFields) return result;
            
        
        for (var i = 0; i < fieldNames.length; i++) {
            var fieldName = fieldNames[i];
            record[fieldName] = result[fieldName]
        }
        return record;
    },
		
    // XML Request Formation
    // ---------------------------------------------------------------------------------------

    // get the schema to be used to serialize JS data to XML.  
    // Also takes a dsRequest.
    getMessageSerializer : function (operationType, operationId) {
        // either: 
        // - an operationBinding has been specified with a wsOperation, so we use that, or
        // - no operationBinding was specified, so getOperationBinding() returns this, and then:
        //   - if this.wsOperation has been set, we use it
        //   - otherwise, we don't seem to be connected to a web service, so we use this
        //     DataSource as the message schema
        var operationBinding = this.getOperationBinding(operationType, operationId);
        if (operationBinding.wsOperation) {
            var service = this.getWebService(operationType, operationId);
            return service.getMessageSerializer(operationBinding.wsOperation);
        }
        return this;
    },

    //> @method dataSource.getXMLRequestBody() [A]
    // Get the XML to be posted to the dataURL based on the passed DSRequest.
    // <P>
    // This API is intended to be overridden in order to integrate with web services that
    // expect XML messages rather than simple HTTP parameters, but lack a
    // WSDL description.  For WSDL-described web services, having loaded the service
    // description, SmartClient knows the correct XML message structure, so customization is
    // best done by modifying the JavaScript data that is used to form the message.
    //
    // @see XMLTools.loadWSDL() for integration with WSDL-described web services
    // 
    // @param dsRequest (DSRequest) the request to encode as an XML message.
    // @return (String) the entire XML request as a String, including SOAP envelope if SOAP is used
    // @visibility xmlBinding
    //<
    getXMLRequestBody : function (dsRequest, flags) {
        if (isc._traceMarkers) arguments.__this = this;

        var requestBody = isc.SB.create(),
            protocol = this.getDataProtocol(dsRequest);

        // start envelope and headers
        if (protocol == "soap") {
            requestBody.append(this.getSoapStart(dsRequest), "\n");
            requestBody.append(this.getSoapBody(dsRequest, flags));
            requestBody.append("\n", this.getSoapEnd(dsRequest));
        } else { 
            if (this.messageStyle == "template") {
                requestBody.append(this._createTemplatedRequestBody(dsRequest));
            } else {
                var schema = this.getMessageSerializer(dsRequest);
                var flags = this.getSerializeFlags(dsRequest, flags);
                requestBody.append(schema.xmlSerialize(dsRequest.data, flags));
            }
        }

        if (this.logIsDebugEnabled("xmlComm")) {
            this.logDebug("outbound XML message: " + requestBody, "xmlComm");
        }

        return requestBody.release(false);
    },

    
    _createTemplatedRequestBody : function (dsRequest) {
        var template = this.soapBodyTemplate,
            message;

        
            message = template.evalDynamicString(this, dsRequest);
        

        return message;
    },

    // WebService-related helper methods
    getSchemaSet : function () {
        return isc.SchemaSet.get(this.schemaNamespace);
    },

    hasWSDLService : function (dsRequest) {
        return isc.isA.WebService(this.getWebService(dsRequest));
    },

    getWebService : function (dsRequest) {
        var operationBinding = this.getOperationBinding(dsRequest),
            serviceNamespace = (dsRequest ? dsRequest.serviceNamespace : null) 
                                    || operationBinding.serviceNamespace || this.serviceNamespace,
            serviceName = (dsRequest ? dsRequest.serviceName : null) 
                                    || operationBinding.serviceName || this.serviceName;

        // look up the WebService by serviceName / serviceNamespace
        var service;
        if (dsRequest && dsRequest._webService) {
            
            service = dsRequest._webService;
        } else if (serviceName) service = isc.WebService.getByName(serviceName, serviceNamespace);
        else service = isc.WebService.get(serviceNamespace);

        if ((serviceNamespace != null || serviceName != null) && service == null) {
            this.logWarn("Could not find WebService definition: " +
                         (serviceName ? "serviceName: " + serviceName : "") +
                         (serviceNamespace ? "   serviceNamespace: " + serviceNamespace : ""));
        }

        // if we don't, then the DataSource itself is expected to have all the relevant
        // properties
        return service || this;
    },
    
    getWSOperation : function (dsRequest) {
        
        var operationBinding = this.getOperationBinding(dsRequest),
            wsOperation = (isc.isAn.Object(dsRequest) ? dsRequest.wsOperation : null) || 
                            operationBinding.wsOperation || this.wsOperation,
            service = this.getWebService(dsRequest);

        if (wsOperation != null && isc.isA.WebService(service)) {
            var returnOp = service.getOperation(wsOperation);
            if (!returnOp) {
                isc.logWarn(this + ": getWSOperation(): could not retrieve the operation '" + 
                            wsOperation + "'");
            }
            return returnOp;
        }
        return this;
    },

    getDataURL : function (dsRequest) {
        var operationBinding = this.getOperationBinding(dsRequest);

        // if we have a real operationBinding definition (we're not using "this" as the
        // operationBinding definition) and it has a dataURL set, use that.  This allows eg
        // fetch via GET from one URL, save via POST to another
        if (operationBinding != this && operationBinding.dataURL) return operationBinding.dataURL;

        // NOTE: allow dataURL to be specified even on a DataSource that is using a web
        // service.  This is a simple way to spoof web service responses for a single
        // DataSource; using webService.setLocation() allows you to put the spoofing at the
        // WebService level
        if (this.dataURL != null) return this.dataURL;

        // otherwise if we have a WSDL-derived WebService definition, ask it for a dataURL
        // (WSDL services can't really have multiple URLs, but it's useful to set a different
        // URL per operation for spoofing during testing)
        if (this.hasWSDLService(dsRequest)) {
            var service = this.getWebService(dsRequest);
            return service.getDataURL(this.getWSOperation(dsRequest).name);
        }
        
        return this.dataURL;
    },

    //> @attr dataSource.globalNamespaces (Object : ... : IRW)
    // Namespaces definitions to add to the root element of outbound XML messages sent to a web
    // service, as a mapping from namespace prefix to namespace URI.
    // <P>
    // The default value is:
    // <pre>
    //   globalNamespaces : {
    //      xsi: "http://www.w3.org/2001/XMLSchema-instance",
    //      xsd: "http://www.w3.org/2001/XMLSchema"
    //   },
    // </pre>
    // This default value allows the use of the xsi:type and xsi:nil attributes without further
    // declarations.
    // <P>
    // Note that some web services will only accept specific revisions of the XML Schema URI.
    // If xsi-namespaced attributes seem to be ignored by an older webservice, try the URI
    // "http://www.w3.org/1999/XMLSchema-instance" instead.
    //
    // @serverDS allowed
    // @visibility xmlBinding
    //<
    getGlobalNamespaces : function (dsRequest) {
        var service = this.getWebService(dsRequest),
            namespaces = this.globalNamespaces;
        if (service && service.globalNamespaces) {
            namespaces = isc.addProperties({}, namespaces, service.globalNamespaces);
        }
        return namespaces;
    },

    getSoapStart : function (dsRequest) {
        // allow centralized overrides of getSoapStart/End via overrides on a WebService object
        var service = this.getWebService(dsRequest);
        if (service.getSoapStart) return service.getSoapStart(dsRequest);

        return isc.SB.concat(isc.DataSource._soapEnvelopeStart, 
                             isc.xml._generateNamespaces(this.getGlobalNamespaces(dsRequest), 
                                                         null, "         "),
                             ">", isc.DataSource._soapHeaderStart,
                             this.getSoapHeader(dsRequest),
                             isc.DataSource._soapHeaderEnd);
    },
    getSoapHeader : function (dsRequest) { 
        var service = this.getWebService(dsRequest);
        // allow an optional implementation of getSoapHeader on the WebService object (not actually used
        // by framework code)
        if (service.getSoapHeader) return service.getSoapHeader(dsRequest);

        // take data from either the request or from the service
        var headerData = dsRequest.headerData || service.getHeaderData(dsRequest);

        if (!headerData) return;

        this.logDebug("headerData is: " + this.echo(headerData), "xmlBinding");

        // get schema for the headers
        var allHeaderSchema = service.getInputHeaderSchema(this.getWSOperation(dsRequest)) || 
                                isc.emptyObject;
 
        // WSDL/SOAP blows: in SOAP the <wsdl:part>s of a <wsdl:message> do not have any name or
        // means of referring to them other than by the combination of the wsdl:message@name and
        // wsdl:part@name attributes.  When asking developers to specify data to be serialized
        // for each part, we rely on just the part name.  It would be perverse to declare a
        // soap header or body that uses two identically named parts of different messages, but
        // it appears to be legal. 
        // Relevant spec: http://www.w3.org/TR/wsdl#_soap:header
        var output = "", flatHeaders = dsRequest.useFlatHeaderFields;
        for (var partName in headerData) {
            var headerSchema = allHeaderSchema[partName];
            if (headerSchema != null) {
                //this.logWarn("serialized partName: " + partName + 
                //             " with schema " + headerSchema);
                if (isc.isA.DataSource(headerSchema)) {
                    output += headerSchema.xmlSerialize(headerData[partName], 
                                                        { useFlatFields: flatHeaders })
                } else {
                    // special handling for simpleType headers:
                    // The wsdl:message declaration, which becomes a DataSource, does not have
                    // a namespace (it doesn't belong to an xs:schema), however the wsdl:parts
                    // refer to types declared in an xs:schema block that must be namespaced.
                    // When a wsdl:part refers to a simpleType element, there won't be a
                    // DataSource for the element, only a field, hence the field has to carry
                    // the namespace via the special partNamespace property.
                    // headerSchema, in this case, is a field definition.
                    output += "\n     " + this._serializeSimpleTypeTag(partName, headerSchema,
                                    headerData[partName], headerSchema.partNamespace);
                }
            } else {
                this.logWarn("headerData passed for SOAP header partName: " + partName +
                             ", no schema available, not outputting");
            }
        }
        return output;
    },
    getSoapBody : function (dsRequest, flags) {
        if (isc._traceMarkers) arguments.__this = this;

        var soapBody = isc.SB.create(),
            service = this.getWebService(dsRequest),
            soapStyle = this.getSoapStyle(dsRequest),
            wsOperation = this.getWSOperation(dsRequest),

            // pass in a "flags" object that already has nsPrefixes, and reuse this flags
            // object to serialize each soap:body part.  This will capture all required
            // namespaces so we can output them as part of the soap:body element.   
            // For readability of the SOAP message, include the explicitly specified 
            // namespace prefixes.
            userPrefixes = this.xmlNamespaces ? isc.makeReverseMap(this.xmlNamespaces) : null,
            flags = isc.addProperties({
                nsPrefixes : isc.addProperties({}, userPrefixes)
            }, flags),

            // A soap:body has exactly one wsdl:message, represented by a DataSource, where each
            // DataSource field represents a wsdl:part of the message.  
            messageSchema = flags.generateResponse ? service.getResponseMessage(wsOperation.name)
                                                   : service.getRequestMessage(wsOperation.name),
            // 1. the soap:body can have multiple parts, either because:
            // - soap:body@parts is unspecified and the message has multiple parts
            // - soap:body@parts is specified and is a list
            // 2. each part can be just a simple type element or a complex element
            // 
            // Relevant spec: http://www.w3.org/TR/wsdl#_soap:body
            // - NOTE: not explicitly covered in the spec above, but based on WSDL4J APIs and
            //   other samples, soap:body@parts can be a space-separated *list* of part names
            //
            // Contrast this with soap:headers:
            // 1. each soap:header can have a different message
            // 2. each soap:header must specify a part
            bodyPartNames = flags.bodyPartNames || 
                                service.getBodyPartNames(wsOperation.name, flags.generateResponse);

        flags = this.getSerializeFlags(dsRequest, flags);

        
        isc.Comm.omitXSI = wsOperation.inputEncoding != "encoded";
        var oldXMLSchemaMode = isc.Comm.xmlSchemaMode;
        isc.Comm.xmlSchemaMode = true;

        var indent = "        ";

        if (soapStyle == "rpc") {
            // for RPC-style SOAP, SOAP body's outermost element should be named after the
            // operation and namespaced with the operation namespace 
            soapBody.append(
                "\n", indent, 
                isc.Comm._xmlOpenTag(wsOperation.name, null, 
                                     wsOperation.inputNamespace, "opNS", true), 
                ">"
            );
            indent += "    ";
            // otherwise the message definition as such does not produce outputs, only it's
            // parts do 
        }

        this.logInfo("soap:body parts in use: '" + bodyPartNames +
                     "', soapStyle: " + soapStyle, "xmlSerialize");
        if (this.logIsDebugEnabled("xmlSerialize")) {
            this.logDebug("SOAP data is: " + this.echoFull(dsRequest.data), "xmlSerialize");
        }

        for (var i = 0; i < bodyPartNames.length; i++) {
            var partName = bodyPartNames[i];

            // for document-style SOAP, if there is exactly one message part (the most common
            // style by far), use the entirety of the request data for that part.
            // This means that when a message is supposed to look like this:
            //    <login>
            //       <username>bob</username>
            //       <password>mebob</password>
            //    </login>
            // The JS data you need to pass is: 
            //    { username:"bob", password:"mebob" }
            // .. instead of the surprising and less obvious:
            //    { login : { username:"bob", password:"mebob" } }
            // Note that this works in conjunction with webService.getInputDS(), which for a
            // single part message will return the schema of that single part, such that a form
            // bound to that schema will produce the appropriate values to pass as
            // dsRequest.data.
            var data = bodyPartNames.length < 2 && soapStyle == "document" ? 
                            dsRequest.data : (dsRequest.data ? dsRequest.data[partName] : null);

            var partXML = messageSchema.getMessagePart(partName, data, flags, indent);
    
            soapBody.append("\n" + indent + partXML);
        }

        if (soapStyle == "rpc") {
            soapBody.append(
                "\n", "        ", isc.Comm._xmlCloseTag(wsOperation.name,
                                                        wsOperation.inputNamespace, "opNS")
            );
        }

        // restore global XML serialization settings
        isc.Comm.omitXSI = null;
        isc.Comm.xmlSchemaMode = oldXMLSchemaMode;

        return isc.SB.concat("    ", isc.DS._soapBodyStart,
                             this.outputNSPrefixes(flags.nsPrefixes, "        "),
                             ">",
                             soapBody.release(false),
                             "\n    ", isc.DS._soapBodyEnd);
    },

    // serialize a <wsdl:part> of a <wsdl:message>
    getMessagePart : function (partName, data, flags, indent) {
        if (isc._traceMarkers) arguments.__this = this;

        var partField = this.getPartField(partName),
            partSchema = this.getSchema(partField.type, partField.xsElementRef ? "element" : null),
            shouldLog = this.logIsInfoEnabled("xmlSerialize");

        // As with DataSource fields in general, each wsdl:part of a wsdl:message can be simple
        // or complex type
        if (isc.isA.DataSource(partSchema)) {
            if (shouldLog) {
                this.logInfo("soap:body part '" + partName + 
                             "' is complex type with schema: " + partSchema +
                             " has value: " +
                             (this.logIsDebugEnabled("xmlSerialize") ? 
                                    this.echo(data) : this.echoLeaf(data)), "xmlSerialize");
            }
            // a wsdl:part can specify complex type via @type or @element.  With @type, the
            // generated tag should match the part name.  With @element, it should match the
            // element name, which the partSchema will use if we just pass tagName as null.
            var tagName = partField.xsElementRef ? null : partName;
            return partSchema.xmlSerialize(data, flags, indent, tagName);
        } else {
            // if a simpleType part receives complex type data, assume they tried to specify
            // data as for example:
            //   { partName : value}
            // .. or ..
            //   { simpleTypeElementName : value }
            // .. and automatically find the simpleType value under those property names if
            // present
            if (data != null && !isc.DS.isSimpleTypeValue(data)) {
                 data = data[partField.name] || data[partName] || data;
            }

            if (shouldLog) {
                this.logInfo("soap:body part '" + partName + 
                             "' is of simple type '" + partField.type + "'" +
                             " has value: '" + this.echoLeaf(data) + "'", "xmlSerialize");
            }

            // if wsdl:part referred via element= to an element of simpleType in an imported
            // schema file.  This becomes a trivial isc.SimpleType but carries the correct
            // namespace.
            var simpleType = this.getType(partField.type),
                partNamespace = partField.partNamespace;
            if (!partNamespace && simpleType && simpleType.schemaNamespace) {
                partNamespace = simpleType.schemaNamespace;
            }

            //this.logWarn("partField: " + this.echo(partField) + 
            //             ", simpleType: " + this.echo(simpleType) + 
            //             ", partNamespace: " + partNamespace);

            return this._serializeSimpleTypeTag(partField.name || partName, partField, data,
                                                partNamespace, flags);
        }
    },


    // for a WSDLMessage, get the field that correspondes to a message <part>.
    // the field for a wsdl:part with @element will have field.name matching the
    // @element name (correct for serialization) but will also have a partName
    // attribute matching the "part" from the operation.inputHeaders/outputHeaders.
    // See schemaTranslator.xsl.
    getPartField : function (partName) {
        var partField = isc.getValues(this.getFields()).find("partName", partName);
        if (partField != null) return partField;
        return this.getField(partName);
    },
    getSoapEnd : function (dsRequest) {
        // allow centralized overrides of getSoapStart/End via overrides on a WebService object
        var service = this.getWebService(dsRequest);
        if (service.getSoapEnd) return service.getSoapEnd(dsRequest);

        return isc.DataSource._soapEnvelopeEnd;
    },
    
    getSoapStyle : function (dsRequest) {
        if (!this.hasWSDLService(dsRequest)) return "document";
        return this.getWebService(dsRequest).getSoapStyle(this.getWSOperation(dsRequest).name);
    },

    // get all the flags this DataSource should use for XML serialization, based on a
    // DSRequest and settings in the relevant operationBinding and the DataSource as a whole
    getSerializeFlags : function (dsRequest, flags) {
        flags = isc.addProperties({
            soapStyle : this.getSoapStyle(dsRequest)
        }, flags);

        // a few properties can be set on the operationBinding
        var operationBinding = this.getOperationBinding(dsRequest);
        
        // if useFlatFields is set, assume flat inbound data to be mapped automatically to
        // hierarchical XML message
        flags.flatData = this._firstNonNull(dsRequest.useFlatFields, 
                                            operationBinding.useFlatFields, 
                                            this.useFlatFields); 
        flags.recursiveFlatFields = this._firstNonNull(dsRequest.recursiveFlatFields,
                                                       operationBinding.recursiveFlatFields, 
                                                       this.recursiveFlatFields); 

        // ability to change the default textContentProperty for one serialization run
        flags.textContentProperty = this._firstNonNull(dsRequest.textContentProperty,
                                                       operationBinding.textContentProperty);

        // serialization of DS metadata: "startRowTag" et al can be set on the operationBinding schema,
        // and that tag will take on the value of dsRequest.startRow
        flags.dsRequest = dsRequest;
        flags.startRowTag = operationBinding.startRowTag || this.startRowTag;
        flags.endRowTag = operationBinding.endRowTag || this.endRowTag;
        return flags;
    },

    // Serializing Objects as XML
    // ---------------------------------------------------------------------------------------
    // Overall: we go through declared subelements, where the value of each subelement is the
    // value of the same named property in the object being serialized.  For complexType
    // subelements (described by another DataSource), we recurse.
    // - flatData mode: we assume the inbound structure is an object with properties that hold
    //   values for same-named subelements at various levels in the structure.  This is for
    //   flattening structures that have gratuitous nesting and are reasonably editable in a
    //   single form.
    // - ordering issues: if the XML output should be something like:
    //   <page>
    //      <section ../>
    //      <header ../>
    //      <section ../>
    //   .. where a subelement name appears *twice* or more, we have no object representation
    //   for this.  One possibility here is a marker on a field that indicates it serializes
    //   it's contents without outputting a tag for the fieldName itself (this would be the
    //   same or a related marker to what would cause immediate Canvas-typed subelements to be
    //   automatically binned in Canvas.children by default).

    // NOTE: there are a few reasons why schema is a necessity in XML serialization:
    // - SOAP
    //   - namespace requirements - eg must be able to tell whether an element definition was
    //     declared at top-level in the WSDL file, which means it requires namespacing
    //     (regardless of whether it appears in a given message)
    //   - "encoded" messages where xsi:type attributes are required pervasively - no way to
    //     detect the appropriate type from live JS data
    // - XML Schema (including it's use in SOAP)
    //   - order dependencies - XML schema basically forces you to declare an order even if you
    //     don't want one, and that order must be followed or the message is considered invalid
    // - ISC Widget XML
    //   - type:multiple fields and ValueMaps have custom encoding

    //> @object SerializationContext
    // Flags for XML serialization
    // @treeLocation Client Reference/Data Binding/DataSource
    // @visibility external
    //<
    
    //> @attr serializationContext.useFlatFields (boolean : null : IR)
    // Enables flat serialization mode, as described for +link{dsRequest.useFlatFields}.
    // @visibility external
    //<
    
    //> @attr serializationContext.xmlExplicitType (boolean : null : IR)
    // If specified, include explicit type information using <code>xsi:type</code>
    // attributes on the generated nodes for any attributes where no explicit field type is
    // specified in the dataSource, or +link{dataSourceField.serializeXMLType} is set to true.
    // The type written out will be determined based on the specified field type (if present)
    // otherwise on the type of the data being serialized.
    // <P>
    // Note that a field type of <code>"any"</code> is treated the same as a field with
    // no specified type - the <code>xsi:type</code> flag will be generated by default, and
    // will have a value derived from the type of the JavaScript value being serialized.
    //
    // @visibility internal
    //<

    //> @attr serializationContext.indent (Boolean : null : IR)
    // If explicitly set to false whitespace indention is not included in serialization.
    //
    // @visibility internal
    //<

    //> @attr dataSourceField.serializeXMLType (boolean : null : IR)
    // Should an explicit "xsi:type" attribute be included in in the entry for this field
    // to indicate the data type when
    // +link{dataSource.xmlSerialize(),serializing data as XML}? Has no effect
    // unless +link{serializationContext.xmlExplicitType} is set to true.
    //
    // @visibility internal
    //<

    //> @method dataSource.xmlSerialize() [A]
    // Serialize a JavaScript object as XML.
    // <P>
    // The JavaScript Object passed to +link{method:DataSource.xmlSerialize()} becomes an XML
    // element named after the +link{attr:DataSource.tagName} (or +link{attr:DataSource.ID} if
    // tagName is unset).  Each property of the object becomes a subElement.  For example,
    // using a DataSource to serialize like this:
    // <pre>
    //     var inputObject = {
    //        startRow : 5,
    //        endRow : 50,
    //        data : [
    //           { field1 : "value1", field2: new Date() },
    //           { field1 : "value3", field2: null }
    //        ]
    //     };
    //     var myDS = isc.DataSource.create({ tagName:"DSRequest" });
    //     myDS.xmlSerialize(inputObject);
    // </pre>
    // .. produces the following XML:
    // <pre>
    //     &lt;DSRequest&gt;
    //         &lt;startRow&gt;5&lt;/startRow&gt;
    //         &lt;endRow&gt;50&lt;/endRow&gt;
    //         &lt;data&gt;
    //             &lt;field1&gt;value1&lt;/field1&gt;
    //             &lt;field2&gt;2005-10-14T18:01:16&lt;/field2&gt;
    //         &lt;/data&gt;
    //         &lt;data&gt;
    //             &lt;field1&gt;value3&lt;/field1&gt;
    //             &lt;field2&gt;&lt;/field2&gt;
    //         &lt;/data&gt;
    //     &lt;/DSRequest&gt;
    // </pre>
    // <P>
    // Various properties on the DataSource and DataSourceField can affect how serialization is
    // performed, see for example +link{DataSource.tagName},
    // +link{DataSource.schemaNamespace}, 
    // +link{DataSourceField.xmlAttribute}, 
    // +link{DataSourceField.multiple} and +link{DataSourceField.childTagName}.
    // By setting the +link{dataSourceField.type,type of a field} to the ID of another
    // DataSource which has further XML serialization settings, you can control serialization of
    // nested structures.
    // <P>
    // If you are working with a WSDL-described web service, XML serialization is performed
    // automatically by APIs like +link{method:WebService.callOperation()} - you only need to
    // know about serialization in order to understand how to put together JavaScript data that
    // will fill in an XML message properly, and for simple messages, setting
    // +link{dsRequest.useFlatFields} makes that unnecessary as well.   
    // <P>
    // <b>Note:</b> when trying to send data to a web service, it is best to avoid putting
    // together any XML yourself, instead modify the JavaScript data being fed to SmartClient's
    // SOAP engine.  This is because the WSDL and SOAP rules for correctly namespacing and
    // encoding Web Service messages are very complex and are subject to change with new
    // versions of the web service you are contacting, whereas the data itself is easy to
    // manipulate and less likely to change.
    // <P>
    // To troubleshoot message formation, you can set the log category "xmlSerialize" to 
    // <code>INFO</code> or <code>DEBUG</code> level in order to see diagnostics about XML
    // message formation, and you can use the RPC tab in the Developer Console to see the
    // actual messages being passed to web services.
    //
    // @param data (Any) data to be serialized
    // @param flags (SerializationContext) options for the serialization engine
    // @return (String) data as serialized to XML
    //
    // @visibility xmlBinding
    //<
    xmlSerialize : function (data, flags, indent, tagName) {
        if (!flags) flags = {};

        if (flags.useFlatFields) flags.flatData = true;

        // qualifyAll, if set, should cascade to child elements which would not otherwise be
        // namespaced (because they were not declared as top level).  However when we are done
        // with this element, if we enabled qualifyAll we need to turn it back off
        var schemaSet = this.getSchemaSet(),
            enabledQualifyAll = (flags.qualifyAll == null);
        if (schemaSet && schemaSet.qualifyAll) {
            flags.qualifyAll = true;
        }

        
        var topLevel;
        if (flags.nsPrefixes == null) {
            var userPrefixes = this.xmlNamespaces ? isc.makeReverseMap(this.xmlNamespaces) : null;
            flags.nsPrefixes = isc.addProperties({}, userPrefixes);
            topLevel = true;
        }

        
        // enable xmlSchemaMode for any calls to xmlSerialize
        var oldXMLSchemaMode = isc.Comm.xmlSchemaMode;
        isc.Comm.xmlSchemaMode = true;
        // disable xsi:type unless it's been set explicitly
        
		
        
        var resetOmitXSI, omitXSIOldVal = null;
        if (flags.xmlExplicitType) {
        	resetOmitXSI = true;
        	omitXSIOldVal = isc.Comm.omitXSI;
			isc.Comm.omitXSI = false;
        } else {
        	if (isc.Comm.omitXSI == null) {
        		resetOmitXSI = isc.Comm.omitXSI = true;
        	}
		}

        var result = this._xmlSerialize(data, flags, indent, tagName, topLevel);

        // reset qualify all
        if (enabledQualifyAll) flags.qualifyAll = null;

        // restore global xml serialize settings
        isc.Comm.xmlSchemaMode = oldXMLSchemaMode;
		if (resetOmitXSI) {
		    isc.Comm.omitXSI = omitXSIOldVal
		}

        return result;
    },

    _xmlSerialize : function (data, flags, indent, tagName, topLevel) {
        if (isc._traceMarkers) arguments.__this = this;
    
        if (this.logIsDebugEnabled("xmlSerialize")) {
            this.logDebug("schema: " + this + 
                         " serializing: " + this.echo(data) +
                         " with flags: " + this.echo(flags), "xmlSerialize");
        }

        var qualify = this.mustQualify || flags.qualifyAll,
            tagName = tagName || this.tagName || this.ID;

        var dsExplicitType = this._getXmlExplicitTypes(this.xmlExplicitTypes),
            xmlExplicitType = (dsExplicitType ? dsExplicitType : flags.xmlExplicitType)
        ;

        
        if (!flags.ignoreConstructor) {
            var dataClassName;
            if (data != null && (data._constructor || isc.isAn.Instance(data))) {
                var dataClassName = isc.isAn.Instance(data) ? data.Class : 
                                    isc.DS.getNearestSchema(data._constructor);
                if (isc.isAn.Object(dataClassName)) {
                    dataClassName = dataClassName.type
                }
                if (!dataClassName && data._constructor) dataClassName = data._constructor;
            }
        }

        // if we're passed an atomic value like a String, we definitely don't want to iterate
        // down a String's properties and pick up functions like "startsWith", the best we can
        // do is return the String inside our tags
        if (isc.DS.isSimpleTypeValue(data)) {

            if (isc.isA.String(data) && isc.startsWith(data,"ref:")) {
                var prefix = ""
                if (indent && indent.length > 0) {
                    prefix = "\n" + indent;
                }
                return prefix + "<" + tagName + " ref=\"" + data.substring(4) + "\"/>";
            }

            this.logDebug("simple type value: " + this.echoLeaf(data) + 
                          " passed to xmlSerialize on " + this, "xmlSerialize");
            return isc.Comm._xmlSerialize(tagName ||  this.tagName || this.ID, data);
        }

        // if it's an instance, also trim it down to serializable fields
        
        if (isc.isAn.Instance(data)) data = data.getSerializeableFields();

        if (isc.isAn.Array(data) && !this.canBeArrayValued) return this.map("xmlSerialize", data, flags, indent).join("\n");

        var output = isc.SB.create(),
            indent = indent || "";

        output.append("\n", indent);

        var schemaNamespace;
        if (qualify) {
            //this.logWarn("schema: " + this + " parentNS: " + flags.parentSchemaNamespace);
            // XML Schema namespacing rules: if a subelement declares its structure via a "ref"
            // attribute pointing to another *Element* definition, the namespace of the
            // referenced element must be used.  If the subelement declares its structure via a
            // "type" attribute, the namespace of the parent element must be used.
            schemaNamespace = (this.isA("XSComplexType") ? flags.parentSchemaNamespace : null) 
                                    || this.schemaNamespace;
        }
		
		var xsiType;
		if (flags.xmlExplicitType) xsiType = null;
		else xsiType = this.ID;
		
        // leave the tag open..  
        output.append(
		    isc.Comm._xmlOpenTag(tagName, xsiType, schemaNamespace,
                                 flags.nsPrefixes, true)
        );

        // serialize attributes, if any.  Note only a field declared as an attribute
        // (field.xmlAttribute="true") ever becomes an attribute - undeclared data becomes
        // subelements
        data = this.serializeAttributes(data, output, flags);
        //this.logWarn("after serialize attributes, data is: " + this.echo(data));

        // if serializing an instance, save the actual class as "constructor" if it differs
        // from the schema we're using for serialization
        if (dataClassName && tagName != dataClassName) {
        	if (isc[dataClassName] != null) {
	            output.append(" constructor=\"", dataClassName, "\"");
	        
			} else {
				output.append(" _constructor=\"", dataClassName, "\"");
			}	            
        }

        var subElements;
        if (data != null) {
            subElements = this.xmlSerializeFields(data, flags, indent+(!flags || flags.indent != false ? "    " : ""));
        }

        // if this is the top-level element, write out all the namespace prefixes encountered
        // during serialization
        if (topLevel) {
            output.append(this.outputNSPrefixes(flags.nsPrefixes, indent+(!flags || flags.indent != false ? "     " : ""), flags));
        }

        // NOTE: one time flag to prevent trailing ident, for use eg if there is text content
        var suppressIndent = this._suppressIndent;
        this._suppressIndent = null;

        // use a short tag if possible
        if (subElements == null || isc.isAn.emptyString(subElements)) {
            output.append("/>");
            return output.release(false);
        }

        output.append(">", subElements, 
                      // NOTE: one time flag to prevent if there is text content, don't add whitespace/newline inside tag
                      (suppressIndent ? "" : "\n" + indent));
        
        output.append(isc.Comm._xmlCloseTag(tagName, schemaNamespace, flags.nsPrefixes));

        return output.release(false);
    },

    outputNSPrefixes : function (prefixes, indent, flags) {
        delete prefixes._nsCount;
        prefixes = isc.makeReverseMap(prefixes);
        var nsDefs = isc.xml._generateNamespaces(prefixes, null, indent+(!flags || flags.indent != false ? "        " : ""));
        return nsDefs;
    },

    serializeAttributes : function (data, output, flags) {
        var fieldNames = this.getFieldNames(),
            originalData = true;
        
        for (var i = 0; i < fieldNames.length; i++) {
            var fieldName = fieldNames[i],
                field = this.getField(fieldName),
                isAttribute = field.xmlAttribute || 
                                (field.xmlAttributeInRuleCriteria && flags.isRuleCriteria);
            if (isAttribute && ((data && data[fieldName] != null) || field.xmlRequired)) {
                // if we run into attributes, shallow copy the data so we can remove already
                // serialized fields without affecting the data the developer passed to
                // xmlSerialize()
                if (originalData) {
                    data = isc.addProperties({}, data);
                    originalData = false;
                }

                var value = data[fieldName];
                if (flags && flags.spoofData) value = this.getSpoofedData(field);

                
                if (isc.isAn.Instance(value)) {
                    if (value.ID) {
                        value = value.ID;
                    } else {
                        this.logWarn("Serializing attribute " + fieldName +
                                     " failed to replace object instance with ID");
                    }
                }  

                // emit multiple string attribute as CSV (e.g. "foo,bar,moby")
                if (field.multiple && isc.isAn.Array(value) &&
                    isc.SimpleType.inheritsFrom(field.type, "string"))
                {
                    value = value.join();
                }

                output.append(" ", fieldName, "=\"", 
                        this._serializeSimpleTypeValue(field, value), 
                        "\"");
                delete data[fieldName]
            }
        }
        return data; // return the (possibly copied) data
    },

    xmlSerializeFields : function (data, flags, indent) {
        var output = isc.SB.create(),
            flags = flags || isc.emptyObject,
            flatData = flags.flatData,
            spoofData = flags.spoofData,
            indent = indent || "",
            dsExplicitType = this._getXmlExplicitTypes(this.xmlExplicitTypes),
            xmlExplicitType = (dsExplicitType ? dsExplicitType : flags.xmlExplicitType);
        ;

        // output each known field *in order*
        var data = isc.addProperties({}, data); // copy data so we can delete known fields

        
        if (data.__ref) {
            delete data.__ref;
            delete data.__module;
        }

        var fields = this.getFields();
        for (var fieldName in fields) {
            var field = this.getField(fieldName),
                value = data[fieldName],
                fieldIsComplex = this.fieldIsComplexType(fieldName)
            ;

            // A field can be marked skipSerialization="true" to prevent it from
            // ever being serialized
            if (field.skipSerialization) {
                if (!flatData && data[fieldName] != null) delete data[fieldName];
                continue;
            }

            var childData = data[fieldName];
            if (flags.startRowTag == field.name && childData == null) {
                childData = flags.dsRequest ? flags.dsRequest.startRow : null;
            } else if (flags.endRowTag == field.name && childData == null) {
                childData = flags.dsRequest ? flags.dsRequest.endRow : null;

            // flatData mode: we assume the inbound data is an object with properties
            // that hold values for same-named subelements at various levels in the
            // structure.  This is for flattening structures that have gratuitous nesting
            // and are reasonably editable in a single form.
            // Note that even with flatData=true, "data" may have nested objects, intended
            // as data for a same-named complexType subelement, so flatData amounts to always
            // passing data to child elements of complexType
            } else if (fieldIsComplex && flatData && childData == null) {
                childData = data;
            }
    
            //if (this.logIsDebugEnabled("xmlSerialize")) {
            //    this.logDebug("for field: '" + fieldName + 
            //                 "' serializing data: " + this.echo(childData), "xmlSerialize");
            //}

            // NOTE: the xml notion of required is just that an element needs to be there - not
            // that it has to be non-empty
            var mustOutput = (field.xmlRequired && !field.xmlAttribute) || 
                                (data[fieldName] != null || (spoofData && !field.xmlAttribute));

            if (flatData && fieldIsComplex) {
                // HACK: for flatData, if a tag is not marked required, we can't easily
                // tell whether there will be output since subobjects may produce output if
                // the data happens to intersect with some simpleType field at any level of
                // nesting, so we just try serializing and throw the result away if there's
                // nothing
                var tagSchema = this.getSchema(field.type),
                    // HACK: this serialization run doesn't produce output, so disable caching
                    // of NS prefixes
                    origPrefixes = isc.clone(flags.nsPrefixes),
                    fieldsOutput = tagSchema.xmlSerializeFields(childData, flags);
                //this.logWarn("fieldName: '" + fieldName + 
                //             "', mustOutput before flatData check: " + mustOutput + 
                //             ", fieldsOutput: " + this.echoLeaf(fieldsOutput));
                if (fieldsOutput != null && !isc.isAn.emptyString(fieldsOutput)) {
                    mustOutput = true;
                }
                flags.nsPrefixes = origPrefixes;
            }

            if (mustOutput) {
                
                if (flatData && fieldIsComplex && 
                    // non-simpleType data is provided
                    data[fieldName] != null && !isc.DS.isSimpleTypeValue(data[fieldName]) &&
                    !flags.recursiveFlatFields) 
                {
                    // NOTE: we intentionally addProperties() rather than clone() here, because
                    // we do want flags.nsPrefixes to have any additional nsPrefixes added to
                    // it
                    flags = isc.addProperties({}, flags);
                    flags.flatData = false;
                }
                var fieldExplicitTypes = this._getXmlExplicitTypes(field.xmlExplicitTypes),
                    flagExplicitType = (fieldExplicitTypes ? fieldExplicitTypes : xmlExplicitType)
                ;
                flags = isc.addProperties({}, flags, { xmlExplicitType: flagExplicitType });

                output.append(this.xmlSerializeField(fieldName, childData, flags, indent));
            }
            // in flatData mode, we don't delete fields that we've output, because we don't
            // write out undeclared data at the end
            if (!flatData && data[fieldName] != null) delete data[fieldName];
        }

        // if there's any data left, tack them on the end, but *not* if this DataSource came
        // form XML Schema, in which case the extra data is sure to be invalid
        if (!flatData && !isc.isA.Schema(this)) {
            for (var fieldName in data) {
                output.append(this.xmlSerializeField(fieldName, data[fieldName], flags, indent));
            }
        }

        return output.release(false);
    },

    _$Action:"Action",
    xmlSerializeField : function (fieldName, value, flags, indent) {
        var output = isc.SB.create(),
            field = this.getField(fieldName);
        // skip undeclared, generated properties
        if (field == null && (fieldName.startsWith("_") || fieldName.startsWith("$"))) return;

        var fieldType = (field ? field.type : null),
            flatData = flags && flags.flatData,
            spoofData = flags && flags.spoofData,
            indent = indent || "";

        if (!flags.ignoreConstructor) {
            var dataClassName;
            if (value != null && (value._constructor || isc.isAn.Instance(value))) {
                var dataClassName = isc.isAn.Instance(value) ? value.Class : 
                                    isc.DS.getNearestSchema(value._constructor);
                if (isc.isAn.Object(dataClassName)) {
                    dataClassName = dataClassName.type
                }
                if (!dataClassName && value._constructor) dataClassName = value._constructor;
            }
        }

        if (spoofData) value = this.getSpoofedData(field);
    
        if (this.logIsDebugEnabled("xmlSerialize")) {
            this.logDebug("serializing fieldName: " + fieldName + 
                          " with type: " + fieldType + 
                          " with value: " + this.echo(value), "xmlSerialize");
        }

        // namespace the element if either everything must be qualifed or this particular field
        // is declared and must be qualified
        var namespace = ((field && field.mustQualify) || flags.qualifyAll ? 
                         this.getSchemaSet().schemaNamespace : null);

        // if this field matches the textContentProperty, and either a textContent field has
        // been declared or there are no elements, return the value of the textContentProperty
        // with no surrounding tag and no indent.
        // NOTE: this handling appears here so that it works with flatData and spoofData 
        var textContentProperty = flags.textContentProperty || this.textContentProperty,
            textContentField = this.getTextContentField();

        if (fieldName == textContentProperty && 
            (textContentField != null || !this.hasXMLElementFields(textContentProperty))) 
        {
            // one time flag prevents normal whitespace/indent from being added
            this._suppressIndent = true;
            return this._serializeSimpleTypeValue(textContentField, value);
        }

        // special case for "Action"s - get the iscAction we stored on the function object
        if (fieldType == this._$Action && value != null) {
            if (value.iscAction) {
                value = value.iscAction
            // sanity check for StringMethods (may not be necessary since addMethods() / 
            // addProperties() should have converted StringMethods to functions with iscAction 
            // stored on them
            } else if (isc.isA.StringMethod(value)) {
                value = value.value;                
            }
        }
		
		var xsiType = !flags.xmlExplicitType || this.shouldWriteSchemaType(field) ?
					this._getXMLSchemaType(field ? field.type : null, value) : null;

        var resetOmitXSI, omitXSIOldVal = null;
        if (flags.xmlExplicitType) {
            resetOmitXSI = true;
            omitXSIOldVal = isc.Comm.omitXSI;
            isc.Comm.omitXSI = false;
        }

        var fieldStart = isc.Comm._xmlOpenTag(fieldName, xsiType, 
                                              namespace, flags.nsPrefixes),
            fieldEnd = isc.Comm._xmlCloseTag(fieldName, namespace, flags.nsPrefixes);

        //this.logWarn("schemaSet is: " + this.echo(schemaSet) + ", fieldStart: " + fieldStart);

        var values = isc.isAn.Array(value) ? value : [value];
        
        // If this DataSource has no field of the given name, see if we were passed another
        // DataSource to use as schema by the calling code.  RestDataSource uses this pattern
        // to allow it to control the overall style of XML serialization (the tag names to use
        // for criteria, criterion, etc) and the detailed serialization of individual fields 
        // (most critically for fields of type "date", "time" and "datetime")
        if (!field && flags.schema && flags.schema.getField) {
            field = flags.schema.getField(fieldName);
        }

        // for a DataSource type, ask the DataSource to serialize the value
        if (this.fieldIsComplexType(fieldName)) {
            var oldPSN = flags.parentSchemaNamespace;
            flags.parentSchemaNamespace = this.schemaNamespace;
            //if (field && field.xsElementRef) this.logWarn("looking up *element* only: " + fieldType);
    
            var ds = (dataClassName ? this.getSchema(dataClassName) : this.getFieldDataSource(field, field && field.xsElementRef ? "element" : null));
            //this.logWarn("complexType field: " + fieldName + 
            //             " with schema: " + ds +
            //             " has value: " + this.echo(value));

            if (field.multiple) {
                // if this is a field declaration with multiple=true, we write out a
                // container tag containing one or more tags for the values, where the values
                // have the typeName, eg
                //      <children> // container tag: fieldName
                //          <Canvas> // value tag: field dataSource
                //          </Canvas>
                //          <Canvas> 
                //          </Canvas>
                //      </children>
                output.append("\n", indent, fieldStart);
                for (var i = 0; i < values.length; i++) {
                    
                    var elementDS = ds;
                    if (values[i] != null && values[i]._constructor) {
                        elementDS = isc.DS.get(values[i]._constructor) || ds;
                    }
                    output.append(elementDS.xmlSerialize(values[i], flags, indent+(!flags || flags.indent != false ? "    " : ""), 
                                                  // allow the field to specify a name for 
                                                  // child tags, eg, ds.fields -> "field"
                    							  values[i] == null
                    							   ? field.childTagName 
                    							   : values[i]._tagName || field.childTagName));
                }
                output.append("\n", indent, fieldEnd);

            } else if (ds.canBeArrayValued && isc.isAn.Array(value)) {
                // very special case for the valueMap and point types, which when it appears as a simple
                // JS Array, shouldn't be considered multiple valueMaps/points.

                output.append(ds.xmlSerialize(value, flags, indent, fieldName));
            } else if (values.length == 1 && isc.isA.String(values[0]) && isc.startsWith(values[0],"ref:")) {
                // special case of a field like DrawItem.fillGradient which can be a Gradient or
                // a reference but the output should not be <fillGradient><Gradient ref="xxx"></fillGradient>
                // but rather <fillGradient ref="xxx"/>.
                fieldStart = isc.Comm._xmlOpenTag(fieldName, xsiType, namespace, flags.nsPrefixes, true);
                output.append("\n", indent);
                output.append(fieldStart);
                output.append(" ref=\"", value.substring(4), "\"/>");
            } else {
                // if this is a field that isn't declared multiple but has multiple values,
                // we write out one or more tags named after the field name since that's the
                // inbound format that would produce an array in a field not declared
                // multiple
                for (var i = 0; i < values.length; i++) {
                    var value = values[i];
                    if (value == null) { // null = empty tag
                        output.append("\n", indent);
                        output.append(fieldStart, fieldEnd);
                    // handle being unexpectedly passed a simple type.  If we're serializing a
                    // SOAP message, the resulting XML isn't going to adhere to the schema, but
                    // there's nothing we can do.
                    } else if (isc.DS.isSimpleTypeValue(value)) {
                        if (isc.isA.String(value) && isc.startsWith(value,"ref:")) {
                            output.append("\n", indent);
                            output.append(fieldStart);
                            var refTagName = (field ? field.childTagName || field.type : "value");
                            output.append("<", refTagName, " ref=\"", value.substring(4), "\"/>");
                            output.append(fieldEnd);
                        } else {
                            this.logWarn("simple type value " + this.echoLeaf(value) + 
                                         " passed to complex field '" + field.name + "'",
                                         "xmlSerialize");
                            output.append("\n", indent);
                            output.append(isc.Comm.xmlSerialize(fieldName, value));
                        }
                    } else {
                        if (field.isRuleCriteria) flags.isRuleCriteria = true;
                        if (field.fieldsCanBeFormula) flags.fieldsCanBeFormula = true;

                        output.append(ds.xmlSerialize(value, flags, indent, fieldName));
                        delete flags.isRuleCriteria;
                    }
                }
            }
            flags.parentSchemaNamespace = oldPSN;

        // declared field of simple type
        } else if (field != null) {
            
            // if this field came from a simple type element, we have to use the namespace that
            // the element was defined in.  Note that both xs:simpleTypes and xs:elements of
            // simpleType become SimpleTypes in SmartClient - both essentially represent a
            // reusable atomic type.
            if (field.xsElementRef) {
                var simpleType = this.getType(field.type);
                //this.logWarn("in DataSource: " + this + 
                //             ", simpleType field: " + this.echo(field) + 
                //             ", got simpleType: " + this.echo(simpleType));
                if (simpleType && simpleType.schemaNamespace)
                {
                    namespace = simpleType.schemaNamespace;
                }
            }

            var useMultiFormat = field.multiple,
                commaSeparated = field.commaSeparated
            ;

            
            if (useMultiFormat && field.commaSeparated &&
                isc.SimpleType.inheritsFrom(fieldType, "string"))
            {
                
                useMultiFormat = false;
                values = [values.join()];
            }
    
            if (useMultiFormat) {
                output.append("\n", indent, fieldStart, "\n");
                for (var i = 0; i < values.length; i++) {
                    // field.childTagName dictates the childTagName.  If it's null a generic
                    // name will be used
                    output.append(indent,
                                  this._serializeSimpleTypeTag(field.childTagName, field,
                                                               values[i], namespace, flags),
                                  "\n");
                }
                output.append(indent, fieldEnd, "\n");
            } else {
                for (var i = 0; i < values.length; i++) {
                    output.append(
                        "\n", indent, 
                        this._serializeSimpleTypeTag(fieldName, field,
                                                       values[i], namespace, flags));
                }
            }

        // undeclared field, simple or complexType
        } else {
            //this.logWarn("serializing values for undeclared field: " + fieldName + 
            //             ", values: " + this.echoAll(values));
            for (var i = 0; i < values.length; i++) {
                if (values[i] == null || isc.isAn.emptyObject(values[i])) {
                    output.append("\n", indent, fieldStart, fieldEnd);
                } else {
                    var context = { isRoot:false };
                    if (flags.fieldsCanBeFormula) context.fieldCanBeFormula = true;
                    output.append("\n", indent, 
                                 isc.Comm._xmlSerialize(fieldName, values[i], indent, context));
                }
            }
        }

        if (resetOmitXSI) {
            isc.Comm.omitXSI = omitXSIOldVal;
        }

        return output.release(false);
    },
    
    // When performing XML Serialization, should we include an "xsi:type" tag indicating
    // the type of data for some field.
    // This method is only called in the case where xmlSerialize was passed a context with
    // the "xmlExplicitType" flag set, and returns true for fields where we do want
    // an "xsi:type" entry - which is basically fields of variable type like the
    // 'any' field in a criterion object.
    shouldWriteSchemaType : function (field) {
    	// No field - we don't have schema type info, so write out an explicit type based
    	// on the value, so the parser will know how to regen JS on a round-trip.
    	if (!field) return true;
    	// Respect explicit "serializeXMLType" if set
    	if (field.serializeXMLType != null) return field.serializeXMLType;
    	else {
    		// field has no specified type on the schema, so pick it up from the value.
    		return (field.type == null || field.type == "any");
    	}
    },

    
    _serializeSimpleTypeTag : function (fieldName, field, value, namespace, flags) {
        // NOTE: fieldName is passed as "null" for multiple:true fields, indicating use the
        // generic "value" for simple values, and let Comm.xmlSerialize pick a name if an
        // Object has been (erroneously) passed to a simple type field.  Comm.xmlSerialize will
        // use the Object's type as a tag name, defaulting to the generic "Object"

        var type = field.type,
            flags = flags || {};

        
        if (isc.isAn.Object(value) && !isc.isA.Function(value._xmlSerialize)) {
            return isc.Comm.xmlSerialize(fieldName || null, value);
        } else {
            
            
            var type = !flags.xmlExplicitType || this.shouldWriteSchemaType(field) ?
            			this._getXMLSchemaType(type, value) : null;

            // if the value is null and the field is nillable, send an empty element
            // (<element/>) with xsi:nil=true rather than an element with empty content
            // (<element></element>).  Note that this distinction is key for eg boolean or
            // other restricted types, where empty content is actually a bad value.
            if (value == null && field.nillable) {
                var tagName = fieldName || "value";
                return isc.Comm._xmlOpenTag(tagName, null, namespace, flags.nsPrefixes, true)
                        + " xsi:nil=\"true\"/>";
            }

            if (isc.isA.Date(value)) {
                // per XML Schema spec, 
                // - type == "date" omits the time 
                // - type == "time" omits the date and shows just the time
                // - type == "datetime" shows both.
                value = value.toSchemaDate(field.type, !!this.trimMilliseconds);
            } else if (value != null && value._xmlSerialize) {
                return value._xmlSerialize(fieldName, type, namespace); 
            } else {
                // makeXMLSafe covers String, null (as empty string), Number and Boolean
                value = isc.makeXMLSafe(value);
            }
            return isc.Comm._xmlValue(fieldName || "value", value, type, namespace,
                                      flags.nsPrefixes);
        }
    },

    // serialize a simple type value without surrounding tags, for use in attributes and for
    // textContent fields.
    // If value is not actually of simple type, toString() is called on it (best we can do in a
    // context where we are not allowed to generate elements).
    // Pseudo-bug: the internal _xmlSerialize override is factored incorrectly because it
    // always returns a tag, so it cannot be called for an attribute value.
    _serializeSimpleTypeValue : function (field, value) {
        if (isc.isA.Date(value)) {
            return value.toSchemaDate(field ? field.type : null);
        } else {
            return isc.makeXMLSafeAttribute(value);
        }
    },

    // translate dataSource field types to their XML Schema equivalents, where we have synonyms
    _getXMLSchemaType : function (type, value) {
    	// if a field has no type specified and we were passed a value, derive from
    	// the value.
    	
    	if (value != null && (type == null || type == "any")) {
    		if (value == null) return null;
    		if (isc.isA.Date(value)) {
    			return value.logicalDate ? "date" 
    			                         : (value.logicalTime ? "time" : "datetime");
    		} else if (isc.isA.Number(value)) {
    			if (parseInt(value) == value) {
    				return "float";
    			} else {
    				return "integer";
    			}
    		} else if (isc.isA.Boolean(value)) {
    			return "boolean";
    		} else if (isc.isA.String(value)) {
    			return "text";
    		}
    	}
        switch (type) {
            case "integer":
                return "int";
            case "number" :
                return "long";
            default:
                return type;
        }
    },

    // If xmlExplicitTypes is set on the DS return the value, otherwise return null
    _getXmlExplicitTypes : function (xmlExplicitTypes) {
        var explicitTypes = xmlExplicitTypes;
        if (isc.isA.String(explicitTypes)) explicitTypes = (explicitTypes == "true");
        return explicitTypes;
    },
    xmlSerializeSample : function () {
        return this.xmlSerialize({}, { spoofData:true });
    },

    getSpoofedData : function (field) {
        if (!field) return "textValue";

        // return an object for object-type fields (to avoid following pathway of simpleType
        // passed to complexType field)
        if (this.getSchema(field.type) != null) return {};

        // return arrays for multiple fields 
        if (field.multiple) {
            field = { type : field.type };
            return [this.getSpoofedData(field), this.getSpoofedData(field)];
        }

        // for valueMapped fields, return a value at random
        if (field.valueMap) {
            var values = !isc.isAn.Array(field.valueMap) ? 
                    isc.getKeys(field.valueMap) : field.valueMap;
            return values[Math.round(Math.random() * (values.length-1))];
        }

        // return various simpleType values
        var baseType = isc.SimpleType.getBaseType(field.type);
        switch (baseType) {
            case "boolean" :
                return (Math.random() > 0.5);
            case "integer" :
            case "int" :
            case "number" :
                var min = 0, max = 10;
                if (field.validators) {
                	// check for validator._constructor as well as validator.type. This handles
                	// validators converted from Validator sub-object schema
                    var rangeValidator = field.validators.find("type", "integerRange") ||
                    					 field.validators.find("_constructor", "integerRange");
                    if (rangeValidator) {
                        this.logWarn(field.name + " has " + 
                                     rangeValidator.type + " validator " + 
                                     " with min " + rangeValidator.min + 
                                     " and max " + rangeValidator.max);
                        min = rangeValidator.min || 0;
                        // NOTE: this means if max is < 0 we always pick it exactly
                        max = rangeValidator.max || Math.min(min, 10);
                        if (min > max) min = max;
                    }
                }
                return Math.round(min + (Math.random() * (max-min)));
            case "float" :
            case "decimal" :
            case "double" :
                var min = 0, max = 10, precision = 2;
                if (field.validators) {
                    var rangeValidator = field.validators.find("type", "floatRange") ||
                    					 field.validators.find("_constructor", "floatRange");
                    if (rangeValidator) {
                        this.logWarn(field.name + " has " + 
                                     rangeValidator.type + " validator " + 
                                     " with min " + rangeValidator.min + 
                                     " and max " + rangeValidator.max);
                        min = rangeValidator.min || 0;
                        // NOTE: this means if max is < 0 we always pick it exactly
                        max = rangeValidator.max || Math.min(min, 10);
                        if (min > max) min = max;
                    }
                    var precisionValidator = field.validators.find("type", "floatPrecision") ||
                    						 field.validators.find("_constructor", "floatPrecision");
                    if (precisionValidator) {
                        precision = precisionValidator.precision || 2;
                    }
                }
                return (min + (Math.random() * (max-min))).toFixed(precision);
            case "date" :
            case "time" :
            case "datetime" :
                var date = new Date();
                if (field.validators) {
                    var rangeValidator = field.validators.find("type", "dateRange") ||
                    					 field.validators.find("_constructor", "dateRange");
                    if (rangeValidator) {
                        this.logWarn(field.name + " has " + 
                                     rangeValidator.type + " validator " + 
                                     " with min " + rangeValidator.min + 
                                     " and max " + rangeValidator.max);
                        // NOTE: picking a random date between min and max would require at
                        // least zeroing out either time or date values for pure date or pure
                        // time value fields
                        if (rangeValidator.min) date = rangeValidator.min;
                        else if (rangeValidator.max) date = rangeValidator.max;
                    }
                }
                return date;
            default:
                
                return "textValue";
        }
    },


    //>EditMode
    // extract saveable data from a live DataSource
	getSerializeableFields : function (removeFields, keepFields) {
	    var props = this.Super("getSerializeableFields", arguments);

        var fields = props.fields;
        // switch back from Map to Array
        fields = isc.getValues(fields);
        // remove type-based validators automatically inserted into validators Array
        for (var i = 0; i < fields.length; i++) {
            var field = fields[i] = isc.addProperties({}, fields[i]);
            var validators = field.validators;
            if (validators) {
                field.validators = validators.findAll("_generated", null);
                if (field.validators == null) delete field.validators;
            }
        }
        props.fields = fields;
        
        return props;
    },
    //<EditMode
    
    // Returns a list of methods declared on this DS and its inheritance chain, with methods
    // declared closer to this DS appearing nearer the front of the list
    getMethods : function() {
        var methods = this.methods || [];
        // Note, not using hasSuperDS() because that returns true if a DataSource declares an
        // inheritsFrom. even if the client knows nothing about the inherited DataSource 
        // (probably because we haven't loaded the schema DataSources locally)
        if (this.superDS() != null) {
            methods.addAll(this.superDS().getMethods());
        }
        return methods;
    },
    
    getDeclaredMethod : function(fieldName) {
        var methods = this.getMethods();
        for (var i = 0; i < methods.length; i++) {
            if (methods[i].name == fieldName) {
                return methods[i];
            }
        }
    },
    
    getStringMethod : function(fieldName, methodString) {
        
        var fromSchema = this.getDeclaredMethod(fieldName);
        if (fromSchema) {
            var props = isc.addProperties({}, fromSchema);
            props.value = methodString;
            return isc.StringMethod.create(props);
        }
        
        var klass = isc.DataSource.getNearestSchemaClass(this),
            undef;
        if (klass && klass._stringMethodRegistry && 
                        klass._stringMethodRegistry[fieldName] !== undef) 
        {
            return isc.StringMethod.create({value:methodString});
        }
    },

    // XML Response handling
    // ---------------------------------------------------------------------------------------

    // take the XML response from a web service and ask the DataSource to provide an Array of
    // XMLElements from it
    _handleXMLReply : function (xmlDoc, xmlText, rpcResponse, rpcRequest) {
        var xmlData = xmlDoc,
            dsRequest = rpcRequest._dsRequest,
            operationBinding = this.getOperationBinding(dsRequest),
            opNamespaces;
            
        // Don't try to handle the response unless it's valid
        if (rpcResponse.status < 0) {
            rpcResponse.status = isc.DSResponse.INVALID_RESPONSE_FORMAT;
            var data = "The server failed to return a formatted response at all.";
            // Hang onto the raw XML object returned by the server. This allows transformResponse
            // to actually do something useful with the data returned (EG, pick up meta-data)
            var rawData = xmlText;
            this._completeResponseProcessing(rawData, {status: rpcResponse.status, data:data},
                                             dsRequest, 
                                             rpcResponse, rpcRequest);
            return;
        }
        
        // add namespaces to the xmlDoc to make subsequent selection easier
        if (xmlData) {
            if (operationBinding.wsOperation) {
                var service = this.getWebService(dsRequest),
                    opNamespaces = service.getOutputNamespaces(operationBinding.wsOperation);
                xmlData.addNamespaces(opNamespaces);
            }
            xmlData.addNamespaces(this.xmlNamespaces);
            xmlData.addNamespaces(operationBinding.xmlNamespaces);
        }

        // Ensure the full set of defined namespaces is available to all xPaths
        // executed during dsResponseFromXML.  Currently we associate all namespaces with the
        // XMLDoc, which means they'll be available for selectNodes() called directly with the
        // xmlDoc, but not for selectNodes() relative to an element (eg valueXPath).
        // To fix this pervasively such that any call to selectNodes() with an element works,
        // we should either tag or wrap all native XMLElements returned from selectNodes() so
        // that we always find the right set of namespaces.
        var xmlNamespaces = isc.addProperties({}, opNamespaces, 
                                               this.xmlNamespaces,
                                               operationBinding.xmlNamespaces);
                                          
        // NOTE: it's key to pass the dsRequest to dsResponseToXML since among other things
        // custom message formats may have the server just return a range of rows without
        // reminding the client what the range is
        // dsResponseFromXML can be asynchronous (depending on resultBatchSize)
        this.dsResponseFromXML(xmlData, dsRequest, xmlNamespaces, 
                                {target:this, methodName:"_completeHandleXMLReply",
                                    xmlData:xmlData, dsRequest:dsRequest,
                                    rpcRequest:rpcRequest, rpcResponse:rpcResponse
                                }
        ); 
        
    },
    
    _completeHandleXMLReply : function (dsResponse, callback) {
        this._completeResponseProcessing(callback.xmlData, dsResponse, callback.dsRequest, 
                                                  callback.rpcResponse, callback.rpcRequest);
    },

    //> @method DataSource.dsResponseFromXML() [A]
    // Generate a DSResponse from an XML Document already present on the client.
    // Makes use of <code>recordXPath</code> specified on the DataSource or the appropriate
    // operationBinding to select the appropriate set of nodes, and extracts record data 
    // as described in +link{DataSource.recordsFromXML()}. Extracted data is then assembled
    // into a <code>DSResponse</code> object, available on the callback.
    // @param xmlData (XML Document) XML Data from with the DSResponse will be generated
    // @param dsRequest (DSRequest) Request object
    // @param xmlNamespaces (Object) Namespace prefixes to apply when extracting data
    // @param callback (Callback) callback to fire when the response has been generated. Takes
    //  a single parameter <code>dsResponse</code> - the generated response object.
    // 
    // @visibility internal
    //<
    
    dsResponseFromXML : function (xmlData, dsRequest, xmlNamespaces, callback) {
        if (xmlData) {
            this.selectRecords(
                xmlData, dsRequest, 
                {target:this, methodName:"_completeDSResponseFromXML", dsRequest:dsRequest,
                 callback:callback, xmlData:xmlData, xmlNamespaces:xmlNamespaces}
            );
        } else {
            this._completeDSResponseFromXML([], dsRequest, xmlNamespaces, callback);
        }
    },
    
    _completeDSResponseFromXML : function (data, dsRequest, xmlNamespaces, callback) {
        // handle the case where this is fired asynchronously as a callback - 
        // pick up the dsRequest from the 2nd arguments (the callback object)
        if (!callback && dsRequest.callback) callback = dsRequest.callback;
        if (dsRequest.xmlNamespaces) xmlNamespaces = dsRequest.xmlNamespaces;
        if (dsRequest.dsRequest) dsRequest = dsRequest.dsRequest;
        if (xmlNamespaces == null) xmlNamespaces = this.xmlNamespaces;
        // default startRow as matching what was requested
        var dsResponse = { 
            data : data,
            startRow: dsRequest.startRow || 0,
            status : 0
        };
        dsResponse.endRow = dsResponse.startRow + Math.max(0, data.length);
        // assume dataset is complete by default
        dsResponse.totalRows = Math.max(dsResponse.endRow, data.length);
        var xmlData = callback.xmlData;
           
        // added null check on xmlData for the empty response case
        if (xmlData) {
            if (this.totalRowsXPath) {
                dsResponse.totalRows = 
                    isc.xml.selectNumber(xmlData, this.totalRowsXPath, xmlNamespaces, true);
            }
            if (this.startRowXPath) {
                dsResponse.startRow = 
                    isc.xml.selectNumber(xmlData, this.startRowXPath, xmlNamespaces, true);
                dsResponse.endRow = dsResponse.startRow + Math.max(0, data.length);
            }
            if (this.endRowXPath) {
                dsResponse.endRow = 
                    isc.xml.selectNumber(xmlData, this.endRowXPath, xmlNamespaces, true);
                // if there's no XPath specified for the startRow, derive it from endRow - number
                // of records returned
                if (!this.startRowXPath) {
                    dsResponse.startRow = dsResponse.endRow - Math.max(0, data.length);
                }
            }
    
            // an XPath is unlikely to be able to really translate 3rd party error codes to ISC
            // error codes, but might allow a first cut of error vs no error
            if (this.statusXPath) {
                dsResponse.status = parseInt(
                    isc.xml.selectScalar(xmlData, this.statusXPath, xmlNamespaces, true));
            }
            if (this.errorSchema) {
                dsResponse.errors = this.errorSchema.selectRecords(xmlData, dsRequest);
            }
        }
        if (callback) this.fireCallback(callback, "dsResponse", [dsResponse, callback])
        return dsResponse;
    },

    
    
    //>@attr dataSource.resultBatchSize (int : 150 : IRWA)
    // Very advanced: for servers that do not support paging, and must return large numbers of XML
    // records in one HTTP response, SmartClient breaks up the processing of the response
    // in order to avoid the "script running slowly" dialog appearing for an end user.
    // <P>
    // If you have a relatively small number of records with a great deal of properties or
    // subobjects on each record, and you have not set +link{dropExtraFields} to eliminate unused
    // data, and you see the "script running slowly" dialog, you may need to set this number
    // lower.
    // @serverDS allowed
    // @visibility external
    //<
    
    resultBatchSize:150,
    
    // extract records from an XML document using the recordXPath, and transform to JS using
    // the schema
    // @visibility xmlBinding
     
    selectRecords : function (xmlData, dsRequest, callback) {
        var elements = this.selectRecordElements(xmlData, dsRequest);
        var operationBinding = this.getOperationBinding(dsRequest),
            schema = this.getSchema(operationBinding.responseDataSchema) || this;
        return schema.recordsFromXML(elements, callback);
    },
    
    //> @method dataSource.recordsFromXML() [A]
    // Transform a list of XML elements to DataSource records.
    // <P>
    // <code>recordsFromXML()</code> will create a List of DataSource records in the form of
    // JavaScript objects.  The value for each field is extracted from the XML according to the
    // rules described under +link{attr:DataSourceField.valueXPath}. 
    // <P>
    // Derived JavaScript values for each field will be the appropriate JavaScript type, eg,
    // for a field of "date" type, the JS value will be a JavaScript Date object.
    // <P>
    // Note that if the set of nodes exceeds +link{DataSource.resultBatchSize}, this method
    // will break the XML processing logic into multiple threads and therefore complete
    // asynchronously. In this case the return value will be null, and the callback parameter
    // must be used to process the extracted records.
    // 
    // @param elements (List of XMLElement) XML elements to transform, eg, the result of a
    //                                       call to +link{XMLTools.selectNodes()}
    // @param callback (Callback) Callback to fire when the transform completes. Takes a single
    //    parameter <code>records</code> - the array of DataSource records derived from the
    //    XML elements.
    //
    // @return (List) List of DataSource records derived from the XML elements, or null
    //   if this method completed the XML processing asynchronously.
    // @visibility xmlBinding
    //<
    recordsFromXML : function (elements, callback) {
        // handle being passed a single element, or a native nodeList (as returned by natively
        // calling selectNodes)
        // check elements and skip if null (empty response case)
        if (elements && !isc.isAn.Array(elements)) {
            // XML elements have no length attribute, but NodeLists do
            if (elements.length != null) elements = isc.xml._nodeListToArray(elements);
            // assume a single XML element
            else elements = [elements];
        }

        if (elements && this.transformResponseToJS) {
            if (elements.length > this.resultBatchSize) {                
                var fromXMLContext = {startingRow:0, callback:callback, elements:elements};
                return this._asyncRecordsFromXML(fromXMLContext);
                
            } 
            
            var attrMask = this.dropExtraFields ? this.getFieldNames() : null;
            
            elements = isc.xml.toJS(elements, attrMask, this);
            if (this.logIsDebugEnabled("xmlBinding")) {
                this.logDebug("transformed response: " + this.echoFull(elements) +
                              "xmlBinding");
            }
        }         
        
        if (callback) {
            this.fireCallback(callback, "records", [elements, callback]);
        }
        return elements;
    },
    
    _asyncRecordsFromXML : function (context) {
        
        var elements = context.elements, 
            startingRow = context.startingRow,
            callback = context.callback,
            endRow = Math.min(elements.length, startingRow + this.resultBatchSize),
            attrMask = this.dropExtraFields ? this.getFieldNames() : null;

        if (!context._recordsFromXML) {
            context._recordsFromXML = isc.xml.toJS(
                                        elements.slice(startingRow, endRow+1), attrMask, this);
        } else {
            var records = isc.xml.toJS(elements.slice(startingRow, endRow+1), attrMask, this);
            context._recordsFromXML.addList(records);
        }
        if (endRow < elements.length) {
            context.startingRow = endRow + 1;
            this.delayCall("_asyncRecordsFromXML", [context]);
        } else if (callback) {
            this.fireCallback(callback, "records", [context._recordsFromXML, callback]);
        }
    },

    // given xmlData return by a web service, return an Array of XML elements to be used as a
    // recordSet
    selectRecordElements : function (xmlData, dsRequest) {
        if (isc.isA.String(xmlData)) xmlData = isc.xml.parseXML(xmlData);
        

        // get the XPath or tagName to use to select record elements from the operationBinding
        var operationBinding = this.getOperationBinding(dsRequest);

        // precedence order for selecting records: opBinding.recordXPath, opBinding.recordName, 
        //                                         dataSource.recordXPath, dataSource.recordName
        // Slightly tricky because operationBinding defaults to the DataSource itself when
        // there is no operationBinding for the operation.
        var opXPath = operationBinding == this ? null : operationBinding.recordXPath, 
            opRecordName = operationBinding == this ? null : operationBinding.recordName,
            dsXPath = this.recordXPath,
            dsRecordName = this.recordName;

        // if we have a recordName and a WSDL service definition, and there is no overriding
        // recordXPath definition, use the WebService to select the records by type.
        if (opXPath == null && 
            (opRecordName != null || (dsXPath == null && dsRecordName != null)) && 
            this.hasWSDLService(dsRequest)) 
        {
            // if we have a WebService, allow the recordName to be used as a way of
            // auto-generating the recordXPath
            var service = this.getWebService(dsRequest);

            return service.selectByType(xmlData, 
                                        operationBinding.wsOperation || this.wsOperation,
                                        opRecordName || dsRecordName);
        }

        // use a recordXPath if specified, otherwise use recordName to do just a simple
        // getElementsByTagName
        var recordXPath = opXPath || dsXPath,
            elements;
        if (recordXPath) {
            elements = isc.xml.selectNodes(xmlData, recordXPath, this.xmlNamespaces);
            this.logDebug("applying XPath: " + recordXPath + 
                          (this.xmlNamespaces ? 
                           " with namespaces: " + this.echo(this.xmlNamespaces) : "") +
                          " got " + (elements ? elements.length : null) + " elements", "xmlBinding");
        } else {
            elements = [];
            var recordName = opRecordName || dsRecordName || this.ID;
            // NOTE: a tagName of "record" matches <foo:record> in Moz, but NOT in IE
            var nodeList = xmlData.getElementsByTagName(recordName);
            for (var i = 0; i < nodeList.length; i++) elements.add(nodeList[i]);
            this.logDebug("getting elements of tag name: " + recordName +
                          " got " + elements.length + " elements", "xmlBinding");
        }

        return elements;
    },

    // Common XML / JSON Response handling
    // ---------------------------------------------------------------------------------------
    
    _completeResponseProcessing : function (data, dsResponse, dsRequest,
                                                  rpcResponse, rpcRequest) 
    {
        // empty response case, set up dsResponse manually
       if (!dsResponse) {
           
           // set the status and httpResponseCode, or the saving of local data will fail
            dsResponse = {
                status: rpcResponse.status, 
                httpResponseCode: rpcResponse.httpResponseCode
            };
        }
        // note for "clientCustom" operations this method is fired directly from
        // processResponse() and rpcResponse / rpcRequest will be null
        if (rpcResponse != null && rpcRequest != null) {
            // make the httpResponseCode available on dsResponse - needed for REST implementations
            dsResponse.httpResponseCode = rpcResponse.httpResponseCode;
            dsResponse.httpResponseText = rpcResponse.httpResponseText;
            // grab the transactionNum - needed for relogin via resubmitTransaction()
            dsResponse.transactionNum = rpcResponse.transactionNum;
            // place the clientContext on the response
            dsResponse.clientContext = rpcRequest.clientContext;
            dsResponse.internalClientContext = rpcRequest.internalClientContext;
            dsResponse.httpHeaders = rpcResponse.httpHeaders;
        } else {
            dsResponse.clientContext = dsRequest.clientContext;
            dsResponse.internalClientContext = dsRequest.internalClientContext;
        }
        

        if (this.logIsInfoEnabled("xmlBinding")) {
            this.logInfo("dsResponse is: " + this.echo(dsResponse), "xmlBinding");
        }

        
        dsResponse.context = rpcRequest;

        // operationType and operationId must be manually copied from request in clientOnly mode
        if (!dsResponse.operationType) {
            
            var operation = dsRequest.operation;
            dsResponse.operationId   = dsRequest.operationId   || operation && operation.ID;
            dsResponse.operationType = dsRequest.operationType || operation && operation.type;
        }

        // allow customization 
        var modifiedResponse = this.transformResponse(dsResponse, dsRequest, data);
        // handle failing to return the response - assume it's been modified in place
        dsResponse = modifiedResponse || dsResponse;
        // convert startRow, endRow and totalRows from string to integer if necessary, and
        // provide defaults if the values are senseless
        dsResponse.startRow = this._parseNumber(dsResponse.startRow, 0);
        var endRow = dsResponse.endRow;
        if (endRow == null) {
            if (dsResponse.status < 0) endRow = 0;
            else if (isc.isAn.Array(dsResponse.data)) endRow = dsResponse.data.length;
            else endRow = 1;
        }
        
        dsResponse.endRow = this._parseNumber(endRow);
        dsResponse.totalRows = this._parseNumber(dsResponse.totalRows, dsResponse.endRow);

        // if cacheAllData:false and autoCacheAllData:true and this fetch response includes
        // all posible records, switch cacheAllData on and proceed
        // Note 'downloadResult' requests bypass the cache-data so don't allow these to toggle
        // this.cacheAllData
        if (!this.cacheAllData && this.autoCacheAllData &&
            dsRequest.downloadResult != true && 
            dsResponse.operationType == "fetch" && 
            (dsRequest.data == null || isc.isAn.emptyObject(dsRequest.data)) &&
            dsResponse.startRow == 0 && dsResponse.endRow == dsResponse.totalRows)
        {
            if (this.logIsInfoEnabled("cacheAllData")) {
                this.logInfo("Response: switching on cacheAllData", "cacheAllData");
            }
            this.cacheAllData = true;
            this._autoCacheAllData_timestamp = isc.timestamp();
        }

        //>Offline cache responses for subsequent offline use.  Do this after the response is
        // known to be data-provider agnostic, that is, dsResponse.data is an Array of Object
        // and not any provider-specific format.  This allows custom data protocols to use the
        // offline system transparently, and skips the maximum amount of work when using
        // offline response (eg, no parsing WSDL responses again)
        if (this.useOfflineStorage && dsResponse.status == 0 && !this.clientOnly) {
            isc.DataSource.cacheResponse(dsRequest, dsResponse);
            // It's a waste of time to re-stash a response that came from Offline (and it also
            // leads to a misleading timestamp on the response - it effectively becomes a 
            // last-accessed timestamp rather than a stored timestamp)
            if (isc.Offline && !dsResponse.fromOfflineCache) {
                if (dsRequest.unconvertedDSRequest) {
                    isc.Offline.storeResponse(dsRequest.unconvertedDSRequest, dsResponse);
                } else {
                    isc.Offline.storeResponse(dsRequest, dsResponse);
                }
            }
        }
        
        // HACK: used by DBCs to tell if their data is in offline mode
        if (dsRequest && dsRequest.resultSet) {
            if (dsResponse.status == isc.RPCResponse.STATUS_OFFLINE) {
                dsRequest.resultSet._offline = true;
            } else {
                dsRequest.resultSet._offline = false;
            }
        } else if (dsRequest && dsRequest.resultTree) {
            if (dsResponse.status == isc.RPCResponse.STATUS_OFFLINE) {
                dsRequest.resultTree._offline = true;
            } else {
                dsRequest.resultTree._offline = false;
            }
        }
        //<Offline

        // if this.autoDiscoverTree is true, call discoverTree
        if (this.autoDiscoverTree) {
            // Check if we need to add nameProperty and/or childrenProperty to the discoverTreeSettings

            // We will use a copy of this.discoverTreeSettings to add settings from
            // DataSource only to the copy. This way we preserve the user setings
            var settings = this.discoverTreeSettings || {};

            // If DataSource contains a titleField, use it as the tree's nameProperty
            if (this.titleField != null) {
                settings.nameProperty = this.titleField;
            }

            // Check if we need to set settings.newChildrenProperty
            // Support dataSource.childrenField as well as the dataSourceField.childrenProperty 
            var childrenProperty;
            if (this.childrenField) childrenProperty = this.childrenField;
            var fields = this.getFields();
            for (var fieldName in fields) {
                var field = fields[fieldName];
                if (field.childrenProperty) childrenProperty = fieldName;
            }            
            if (childrenProperty != null) {
                settings.newChildrenProperty = childrenProperty;
            }

            isc.Tree.discoverTree(dsResponse.data, settings, null);
        }

        this.fireResponseCallbacks(dsResponse, dsRequest, rpcResponse, rpcRequest);
        
        if (dsResponse.relatedUpdates != null) {
            for (var i = 0; i < dsResponse.relatedUpdates.length; i++) {
                if (dsResponse.relatedUpdates[i].status < 0) {
                    this.logWarn("DSResponse contained relatedUpdate with failed status="
                        + dsResponse.relatedUpdates[i].status + ", ignoring related update.");
                    continue;
                }
                if (dsResponse.relatedUpdates[i].operationType == null) {
                    dsResponse.relatedUpdates[i].operationType = dsResponse.operationType;
                }
                if (dsResponse.relatedUpdates[i].operationType == "fetch") {
                    this.logWarn("DSResponse contained relatedUpdate has \"fetch\" operationType, so " +
                                 "will do nothing.");
                }
                var ds = isc.DS.get(dsResponse.relatedUpdates[i].dataSource);
                if (ds == null) {
                    this.logWarn("DSResponse contained relatedUpdate referencing dataSource ID:"
                                 + dsResponse.relatedUpdates[i].dataSource + 
                                 ". This dataSource appears not to be present - ignoring related update.");
                } else {
                    var relatedResponse = isc.addProperties({}, dsResponse.relatedUpdates[i]);
                    relatedResponse.clientContext = dsResponse.clientContext
                    ds.updateCaches(relatedResponse, null);
                }
            }
        }

    },

    fireResponseCallbacks : function (dsResponse, dsRequest, rpcResponse, rpcRequest) {
    
        if (!dsResponse.clientContext) dsResponse.clientContext = {};

        if (dsResponse.status >= 0) {
            // on success, notify ResultSets
            isc.DataSource.handleUpdate(dsResponse, dsRequest);
        } else if (!dsRequest.willHandleError) {
            isc.RPCManager._handleError(dsResponse, dsRequest);
            return; // don't fire any callbacks if willHandleError: false
        }

        // fire callbacks:
                        // passed directly to a DataSource method, eg ds.fetchData()
        var callbacks = [dsRequest._dsCallback, 
                        // secondary convenience callback, see ActionMethods::buildRequest()
                         dsRequest.afterFlowCallback]
        ;
            
        for (var i = 0; i < callbacks.length; i++) {

            var callback = callbacks[i],
                callbackResult = this.fireCallback(callback, "dsResponse,data,dsRequest", 
                                                    [dsResponse,dsResponse.data,dsRequest])
            ;
                                                        
			// the primary callback, which completes the basic dataSource flow, can stop
            // further processing by returning false.  This is intended to allow flow code to
            // signal fundamental errors that high-level user code isn't expected to handle.
			if (rpcRequest && rpcRequest.willHandleError && callbackResult === false) {
				//>DEBUG
				this.logDebug("performOperationReply: Further processing cancelled by callback");
				//<DEBUG
				break;
			}

            // If transaction has been suspended, stop processing callbacks
            // Can happen on EG login failure
            
            if (rpcResponse) {
                var transaction = isc.RPCManager.getTransaction(rpcResponse.transactionNum);            
                if (transaction && transaction.suspended) return;
            }
		}

    },

    // if argument is a string, try parsing it as a number and return parsed value as long as
    // it's not NaN
    _parseNumber : function (number, defaultValue) {
        if (number == null) return defaultValue;
        if (!isc.isA.String(number)) return number;
        var parsedNum = parseInt(number);
        if (isNaN(parsedNum)) return defaultValue != null ? defaultValue : number;
        else return parsedNum;
    },
    
    //> @method dataSource.transformResponse() [A]
    // Modify the DSResponse object derived from the response returned from the 
    // +link{dataSource.dataURL,dataURL}.
    // <P>
    // This is an override point that makes it possible to use DataSource features such as
    // paging with web services that support such features, by allowing you to fill in metadata
    // fields in the DSResponse object (such as +link{attr:DSResponse.startRow}) based on
    // service-specific metadata fields contained in the service's response.
    // <P>
    // The DSResponse passed to this method already has +link{attr:dsResponse.data}, which is
    // derived differently depending on the +link{dataSource.dataFormat,dataFormat} setting:
    // <ul>
    // <li> <code>dataFormat:"xml"</code> : either the
    // +link{attr:operationBinding.recordXPath,recordXPath} or 
    // +link{attr:operationBinding.recordName,recordName} is used to select the XML elements
    // that represent DataSource records.  The selected XML elements are passed to
    // +link{method:DataSource.recordsFromXML()}, which transforms the XML elements to typed
    // JavaScript data using the DataSource as a schema.
    // <li> <code>dataFormat:"json"</code> : the
    // +link{attr:operationBinding.recordXPath,recordXPath}, if specified, is used to select
    // records from the returned JSON data via +link{XMLTools.selectObjects()}.  
    // +link{DataSourceField.valueXPath} is used to derive correctly typed field values.
    // <li> <code>dataFormat:"custom"</code> : <code>dsResponse.data</code> is the raw response
    // in String form.  It must be parsed into an Array of Objects for subsequent processing to
    // work.
    // </ul> 
    // <P>
    // In addition to <code>dsResponse.data</code>, +link{attr:dsResponse.status} is defaulted
    // to 0 (indicating no error), and +link{attr:dsResponse.startRow} is assumed to be zero,
    // with +link{attr:dsResponse.endRow,endRow} and +link{attr:dsResponse.totalRows,totalRows}
    // both set to <code>dsResponse.data.length - 1</code>, that is, the returned data is
    // assumed to be all records that matched the filter criteria.
    // <P>
    // Examples of using this API include:
    // <ul>
    // <li> setting +link{attr:dsResponse.startRow,startRow}, 
    //      +link{attr:dsResponse.endRow,endRow} and +link{attr:dsResponse.totalRows,totalRows}
    //      to allow paging for a service that supports it.  For example, if an XML service
    //      returns a "resultRow" tag that contained the row number of the first row of the
    //      returned results:
    //    <smartclient><pre>
    //      dsResponse.startRow = isc.XMLTools.selectNumber(xmlData, "//resultRow");
    //    </pre></smartclient>
    //    <smartgwt><pre>
    //      dsResponse.setStartRow(XMLTools.selectNumber(xmlData, "//resultRow"));
    //    </pre></smartgwt>
    // <li> setting +link{attr:dsResponse.status} to recognized ISC error values based on
    //      service-specific errors, in order to trigger standard ISC error handling.  For
    //      example, setting <code>dsResponse.status</code> to
    //      +link{rpcResponse.STATUS_VALIDATION_ERROR} and filling in
    //      +link{attr:dsResponse.errors} in order to cause validation errors to be shown in
    //      forms and grids.
    // <li> for services that either do not return cache update data, or return partial data,
    //      using +link{attr:dsRequest.oldValues} to create cache update data (whether this is
    //      appropriate is application-specific), or setting
    //      +link{attr:dsResponse.invalidateCache}.
    // </ul>
    // <P>
    // <span STYLE="color:red">NOTE:</span> this method is NOT an appropriate time to call
    // methods on visual components such as grids, initiate new DSRequests or RPCRequests, or
    // in general do anything other than fill in fields on the DSResponse based on data that is
    // already available.  Any actions that need to be taken as a result of the web
    // service response should be implemented exactly as for a DataSource where
    // <code>transformResponse()</code> has not been overridden, that is, use the callback
    // passed to high-level methods such as 
    // +link{group:dataBoundComponentMethods,<code>grid.fetchData()</code>}, and do error
    // handling via either +link{DataSource.handleError()} or by setting
    // +link{RPCRequest.willHandleError,willHandleError}.
    //
    // @param dsResponse (DSResponse) default DSResponse derived from the response data
    // @param dsRequest (DSRequest) DSRequest object that initiated this request
    // @param data (XMLDocument | JSON) XML document or JSON objects returned by the web
    //                                   service
    // @return (DSResponse) response derived 
    // @visibility xmlBinding
    // @example xmlServerValidationErrors
    //<
    
    transformResponse : function (dsResponse, dsRequest, data) {
        return dsResponse;
    },

    // get the value of a field of a record from this DataSource.  Used for dynamically
    // fetching field values from XML elements
    getFieldValue : function (record, fieldName, field) {
        var value = isc.xml.getFieldValue(record, fieldName, field, this, this.xmlNamespaces);
        if (!field.getFieldValue) return value;

        if (!isc.isA.Function(field.getFieldValue)) {
    	    isc.Func.replaceWithMethod(field, "getFieldValue", "record,value,field,fieldName");
        }

        return field.getFieldValue(record, value, field, fieldName);
    },

    _singleArray : [],
    // validate a value for a field of simple type
    validateFieldValue : function (field, value) {
        if (!isc.Validator) return value; // forms module not loaded

        var validators = field.validators;
        if (!validators) return value;

        // normalize to an Array if necessary, avoiding an allocation   
        if (!isc.isAn.Array(validators)) {
            this._singleArray[0] = validators;
            validators = this._singleArray;
        }

        var origValue = value; // purely for log below

        for (var i = 0; i < validators.length; i++) {
            var validator = validators[i];
            var result = isc.Validator.processValidator(field, validator, value, null, null);
            if (!result) {
                this.logWarn(this.ID + "." + field.name + 
                             ": value: " + this.echoLeaf(value) +
                             " failed on validator: " + this.echo(validator));
                // NOTE: the value we return is the value as transformed by what validators did
                // not fail.  Hence, having originally been a String, it may now be an integer,
                // but not in the correct range.
                return value;
            }
            var undef;
            if (validator.resultingValue !== undef) {
                value = validator.resultingValue;
                validator.resultingValue = undef;
            }
			// if the validator wants us to stop if it wasn't passed, break out of the
            // validators loop
			if (!result && validator.stopIfFalse) break;
        }

        //this.logWarn("At field: " + this.ID + "." + field.name + 
        //             " validating value: " + this.echoLeaf(origValue) +
        //             " with validators: " + this.echo(validators) + 
        //             " produced result: " + this.echo(value));

        this._singleArray.length = 0;
        return value;
    },

    // Give a standard or advanced criteria object, return the complete set of
    // field names referenced.
    getCriteriaFields : function (criteria) {
        return isc.DS.getCriteriaFields(criteria, this);
    },

    // Drill into advancedCriteria object extracting fields
    _getAdvancedCriteriaFields : function (criterion, fieldNames) {
        return isc.DS._getAdvancedCriteriaFields(criterion, fieldNames);
    },

    // DataSource operation methods
    // --------------------------------------------------------------------------------------------

    // NOTE: concurrent editing: 
    //   - for updates and deletes we'll need the oldValues to detect changes in the target
    //     record
    //   - oldValues will be passed as requestProperties.oldValues 
    //   - oldValues will remain optional since many datasets are single-user
    //     - NOTE however: even single user web applications can be logged into simultaneously
    //       from two locations (eg email)
    
    //> @method dataSource.fetchRecord()
    // Fetch a single record from the DataSource by +link{dataSourceField.primaryKey,primary key}.
    // This simply calls +link{fetchData()} after creating +link{Criteria} that contain the primary
    // key field and value.
    // <p>
    // If you call this method on a DataSource with a composite primary key - ie, one with 
    // multiple primaryKey fields - this method returns the first record where the first 
    // defined primary field matches the supplied pkValue; this may or may not be meaningful, 
    // depending on your use case.  Generally, for DataSources with composite keys, it makes
    // more sense to use <code>fetchData()</code> directly, rather than this convenience 
    // method.
    //
    // @param pkValue (Any) value for the field marked
    //                      +link{dataSourceField.primaryKey,primaryKey}:true in this DataSource
    //                      (or the first field so marked if there is more than one)
    // @param [callback] (DSCallback)  callback to invoke on completion
    // @param [requestProperties] (DSRequest Properties) additional properties to set on the
    //                                                   DSRequest that will be issued
    // @visibility external
    //<
    fetchRecord : function (pkValue, callback, requestProperties) {
        var criteria = {},
            pkField = this.getPrimaryKeyField();
        if (pkField == null) {
            this.logWarn("This datasource has no primary key field. Ignoring fetchRecord call");
            return;
        }
        var pkFieldName = pkField.name;

        // handle being passed criteria rather than a single pkField value
        var undef;
        if (isc.isAn.Object(pkValue) && pkValue[pkFieldName] !== undef) {
            criteria = pkValue
        } else {
            criteria[pkFieldName] = pkValue
        }
        return this.fetchData(criteria, callback, requestProperties);
    },

     

    //> @class Callbacks
    // This object cannot be used; it exists for documentation purposes only as a place to put
    // documentation for callback methods, such as the callback for +link{Callbacks.DSCallback,DataSource.fetchData()}.
    //
	// @treeLocation Client Reference/Data Binding
    // @visibility external
    //<
    
    //> @method Callbacks.DSCallback
    // Callback fired when DataSource methods that send DSRequests complete (such as +link{DataSource.fetchData()}).
    //
    // @param dsResponse (DSResponse) a +link{class:DSResponse} instance with metadata about the returned data
    // @param data (Any) data returned to satisfy the DataSource request. See the 
    //        +link{group:dataSourceOperations,DataSource operations} topic for expected results
    //        for each type of DataSource operation
    // @param dsRequest (DSRequest) the +link{class:DSRequest} that was sent. You can use
    //        +link{attr:dsRequest.clientContext} to track state during the server turnaround.
    //
    // @visibility external
    //<
   
    //> @method Callbacks.HasFileCallback
    // A +link{type:Callback} fired when +link{DataSource.hasFile()} completes.
    //
    // @param dsResponse (DSResponse) A +link{class:DSResponse} instance with metadata about the
    //                                returned data.
    // @param data (boolean)          Whether the file exists.
    // @param dsRequest (DSRequest)   The +link{class:DSRequest} that was sent.
    // 
    // @group fileSource
    // @visibility external
    //<

    //> @method Callbacks.CanPlayCallback
    // A +link{type:Callback} fired when +link{Sound.load()} completes.
    // 
    // @visibility external
    //<

    //> @method Callbacks.PlaybackCompleteCallback
    // A +link{type:Callback} fired when +link{Sound.play()} completes.
    // 
    // @visibility external
    //<
    
    //> @method Callbacks.HasFileVersionCallback
    // A +link{type:Callback} fired when +link{DataSource.hasFileVersion()} completes.
    //
    // @param dsResponse (DSResponse) A +link{class:DSResponse} instance with metadata about the
    //                                returned data.
    // @param data (boolean)          Whether the file version exists.
    // @param dsRequest (DSRequest)   The +link{class:DSRequest} that was sent.
    // 
    // @group fileSource
    // @visibility external
    //<
    
    //> @method Callbacks.GetFileCallback
    // Callback fired when +link{DataSource.getFile()} completes.
    //
    // @param dsResponse (DSResponse) A +link{class:DSResponse} instance with metadata about the
    //                                returned data.
    // @param data (String)           The file contents, or null if there was an error (such as file
    //                                not found).
    // @param dsRequest (DSRequest)   The +link{class:DSRequest} that was sent.
    // 
    // @group fileSource
    // @visibility external
    //<

    //> @method Callbacks.GetFileVersionCallback
    // Callback fired when +link{DataSource.getFileVersion()} completes.
    //
    // @param dsResponse (DSResponse) A +link{class:DSResponse} instance with metadata about the
    //                                returned data.
    // @param data (String)           The file contents, or null if there was an error (such as file
    //                                not found).
    // @param dsRequest (DSRequest)   The +link{class:DSRequest} that was sent.
    // 
    // @group fileSource
    // @visibility external
    //<

    //> @method dataSource.fetchData()
    // Perform a "fetch" DataSource operation against this DataSource, sending search criteria
    // and retrieving matching records.
    // <P>
    // <b>NOTE:</b> do not attempt to override this method to create a custom DataSource.  For
    // a server-side custom DataSource, use the +link{DataSource.serverConstructor} attribute,
    // and the +explorerExample{customDataSource,Custom DataSource samples}.  For a
    // client-side custom DataSource, see +link{dataProtocol,dataProtocol:"custom"}.
    // <P>
    // In contrast to +link{listGrid.fetchData()}, which creates a +link{ResultSet} to manage
    // the returned data, calling <code>dataSource.fetchData()</code> provides the returned
    // data in the callback as a 
    // <smartclient>simple JavaScript Array of JavaScript Objects.</smartclient>
    // <smartgwt>RecordList or simple Array of Record objects.</smartgwt>  Calling
    // <code>dataSource.fetchData()</code> does not automatically update any visual components or
    // caches: code in the callback passed to <code>fetchData()</code> decides what to do with
    // the returned data. 
    // <P>
    // For example, given a ListGrid "myGrid" and a DataSource "employees", the following code
    // would populate "myGrid" with data fetched from the DataSource:
    // <pre>
    //    <smartclient>isc.DataSource.get("employees").fetchData(null, "myGrid.setData(data)");</smartclient>
    //    <smartgwt>DataSource.get("employees").fetchData(null, new DSCallback() {
    //        public void execute(DSResponse response, Object rawData, DSRequest request) {
    //            myGrid.setData(response.getData());
    //        }
    //    });</smartgwt>
    // </pre>
    // Unlike calling <code>myGrid.fetchData()</code>, which creates a +link{ResultSet}, the
    // data provided to the grid is "disconnected" data, unmanaged by SmartClient's databinding
    // facilities and safe to directly modify.  This is useful when, for example, a ListGrid is
    // being used as a more sophisticated version of HTML's multi-select component.
    // <P>
    // Disconnected datasets may be used to populate various visual components.  For example,
    // while an individual FormItem can be configured to fetch
    // +link{formItem.valueMap,valueMap} options from a DataSource via the
    // +link{formItem.optionDataSource,optionDataSource} property, the following code shows
    // storing a dataset to derive valueMaps from later:
    // <pre>
    //    <smartclient>
    //    isc.DataSource.get("countries").fetchData(null, "window.countries = data");
    //
    //    ... later, a form is created dynamically ...
    //
    //    function showForm() {
    //       isc.DynamicForm.create({
    //           items : [
    //              { name:"country", title:"Pick Country",
    //                valueMap: window.countries.getValueMap("countryId", "countryName")
    //              },
    //       ...
    //    </smartclient>
    //    <smartgwt>
    //      // Assume GlobalStore.allCountries is a public static variable of type RecordList 
    //      DataSource.get("countries").fetchData(null, new DSCallback(){
    //         public void execute(DSResponse response, Object rawData, DSRequest request) {
    //            GlobalStore.allCountries = response.getDataAsRecordList();
    //         }
    //      });
    //      ... later, while a DynamicForm is being created ...    
    //      SelectItem select = new SelectItem("country", "Pick Country");
    //      Map valueMap = GlobalStore.countries.getValueMap("countryId", "countryName");
    //      myItem.setValueMap(new LinkedHashMap(valueMap));
    //    </smartgwt>
    // </pre>
    // <P>
    // You can also create a ResultSet from the data retrieved from <code>fetchData()</code>,
    // like so:
    // <pre>
    //    <smartclient>
    //    isc.DataSource.get("countries").fetchData(null,
    //        function (dsResponse, data) {
    //            isc.ResultSet.create({
    //                dataSource:"countries",
    //                allRows:data
    //            })
    //        }
    //    )
    //    </smartclient>
    //    <smartgwt>
    //    DataSource.get("countries").fetchData(null, new DSCallback() {
    //        public void execute(DSResponse response, Object rawData, DSRequest request) {
    //            ResultSet rs = new ResultSet(DataSource.get("countries"));
    //            rs.setAllRows(response.getData());
    //        }
    //    });
    //    </smartgwt>
    // </pre>
    // <P>
    // This gives you a dataset that supports client-side filtering (via
    // +link{resultSet.setCriteria,setCriteria()}), can provide 
    // +link{resultSet.getValueMap,filtered valueMaps}, will 
    // +link{ResultSet.disableCacheSync,automatically reflect updates} to the DataSource made via
    // other components, and can be re-used with multiple visual components.
    // <P>
    // See also +link{DataSource.getClientOnlyDataSource()} and +link{DataSource.cacheAllData} for
    // similar capabilities for dealing with smaller datasets entirely within the browser, or working
    // with modifiable caches representing subsets of the data available from a DataSource.
    // <P>
    // See also the server-side com.isomorphic.js.JSTranslater class in the
    // <smartclient>+docTreeLink{JavaServerReference,Java Server Reference}</smartclient>
    // <smartgwt>
    // +externalLink{https://www.smartclient.com/smartgwtee-release/server/javadoc/,Java Server Reference}
    // </smartgwt> for other, similar approaches
    // involving dumping data into the page during initial page load.  <b>Note:</b> care should
    // be taken when using this approach.  Large datasets degrade the basic performance of some
    // browsers, so use +link{pickList.optionDataSource,optionDataSource} and similar
    // facilities to manage datasets that may become very large.
    // <P>
    // <b>Data-Driven Visual Component Creation</b>
    // <P>
    // <smartclient>
    // <code>DataSource.fetchData()</code> can also be used to create SmartClient components in
    // a data-driven way.  Many properties on SmartClient visual components are configured via
    // an Array of Objects - the same data format that <code>dataSource.fetchData()</code>
    // returns.  These include +link{listGrid.fields}, +link{tabSet.tabs},
    // +link{dynamicForm.items}, +link{facet.values} and even +link{dataSource.fields}.
    // <P>
    // For example, if you had a DataSource "myFormFields" whose fields included the
    // basic properties of +link{FormItem,FormItems} (name, title, type, etc), this example
    // code would create a form based on stored field definitions, loaded from the
    // "myFormFields" DataSource on the fly:
    // <pre>
    //    isc.DataSource.get("myFormFields").fetchData(null, 
    //        "isc.DynamicForm.create({ items:data })"
    //    )
    // </pre>
    // </smartclient>
    // <smartgwt>
    // <code>DataSource.fetchData()</code> can also be used to create Smart GWT components in a
    // data-driven way.  For example, if you had a DataSource "myGridFields" whose fields included the
    // basic properties of {@link com.smartgwt.client.widgets.grid.ListGridField} (name, title, type,
    // etc), this example code would create a form based on stored field definitions, loaded from the
    // "myFormFields" DataSource on the fly: 
    // <pre>    
    //   DataSource.get("myFormFields").fetchData(null, new DSCallback(){
    //       public void execute(DSResponse response, Object rawData, DSRequest request) {
    //          Record[] records = response.getData();
    //          ListGridField[] fields = new ListGridField[records.length];
    //          for (Record record in records) {
    //              ListGridField field = new ListGridField();
    //              field.setName(record.getAttribute("name"));
    //              field.setTitle(record.getAttribute("title"));
    //              field.setType(ListGridFieldType.valueOf(record.getAttribute("type")));
    //          }
    //          ListGrid grid = new ListGrid();
    //          grid.setFields(fields);
    //       }
    //   });
    // </pre>  
    // </smartgwt>
    // This capability to dynamically create visual components from dynamically fetched data
    // provides a foundation for creating interfaces that can be customized by end users.
    // See also the server-side API com.isomorphic.datasource.DataSource.addDynamicDSGenerator() for
    // dynamically creating DataSources supporting all server-side DataSource features, and
    // +link{dataSource.inheritsFrom} for sharing field definitions across multiple DataSources.
    //
    //	@param	[criteria]          (Criteria)	  search criteria
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    fetchData : function (criteria, callback, requestProperties) {
        this.performDSOperation("fetch", criteria, callback, requestProperties);
    },

    //> @method dataSource.filterData()
    // Perform a "fetch" DataSource operation against this DataSource, sending search criteria
    // and retrieving matching records.
    // <P>
    // This is identical to +link{fetchData()} except that
    // +link{dsRequest.textMatchStyle} is set to "substring" to cause case insensitive
    // substring matching (if the server respects this setting).
    //
    //	@param	[criteria]          (Criteria)	  search criteria
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    filterData : function (criteria, callback, requestProperties) {
        if (!requestProperties) requestProperties = {};
        
        requestProperties = isc.DataSource.dupRequest(requestProperties);
        
        if (requestProperties.textMatchStyle == null) requestProperties.textMatchStyle = "substring";
        this.performDSOperation("fetch", criteria, callback, requestProperties);
    },

    //> @attr dataSource.emptyExportMessage (String : "You are attempting to export an empty dataset" : [IRW])
    // The message to display to the user if an export of client-side data is attempted, but 
    // data provided for export is null or an empty List.
    // @see dataSource.exportClientData
    // @visibility internal - for now
    //<
    emptyExportMessage: "You are attempting to export an empty dataset",

    //> @method dataSource.exportClientData()
    // Exports arbitrary client-side data, with client-side formatters applied, so is suitable 
    // for direct display to users.  This method can be used to export data formatted outside
    // of any kind of visual component.
    // <P>
    // If you do not specify an +link{operationBinding.operationId,operationId} in the 
    // <code>requestProperties</code> you pass to this method, it behaves exactly the same as
    // the +link{classMethod:DataSource.exportClientData,static classMethod} of the same name.
    // If you do specify an <code>operationId</code>, the framework expects your DataSource to
    // configure an +link{class:operationBinding} of +link{operationBinding.operationType,operationType}
    // "clientExport" with the same <code>operationId</code>.  The framework will then send the
    // <code>exportClientData</code> request via the ordinary +link{class:DSRequest} mechanism,
    // which allows you to use normal framework features in the client data export.  
    // <p>
    // For example, you could add a +link{group:dmiOverview,DMI declaration} to your
    // <code>operationBinding</code>, which would allow you to write server-side code that
    // intervenes in the export process - for instance, by calling the
    // <code>getExportObject()</code> API to do something special with the export document,
    // like saving it to a database table or sending it to an email list.
    // <p>
    // When you use the specific <code>operationId</code> version of this API, both the 
    // SmartClient Server and server-side DataSources are required.
    // <P>
    // To export unformatted data, see +link{dataSource.exportData, exportData} which does
    // not include client-side formatters, but requires both the SmartClient server and the 
    // presence of server-side DataSources.
    // <P>
    // Note that field +link{DataSourceField.displayFormat,displayFormat} is honored for 
    // "date" and "datetime" fields when exporting direct to Excel; see the displayFormat
    // docs for details.
    //
    // @param data (Array of Record) Array of Records to export
    // @param [requestProperties] (DSRequest Properties) Request properties for the export
    // @param [callback] (DSCallback) Optional callback.  Note that this is only applicable 
    // if you also specify +link{DSRequest.exportToClient,exportToClient}: false in the 
    // request properties
    // @visibility external
    //<
    exportClientData : function (data, requestProperties, callback) {
        if (!requestProperties) requestProperties = {}
        if (requestProperties.operationId) {
            if (!this.operationBindings) {
                this.logWarn("exportClientData() was passed operationId '" +
                             requestProperties.operationId +
                             "', but this DataSource has no operationBindings.  Delegating to the " +
                             "static exportClientData() method");   
                delete requestProperties.operationId;
            }
            var binding, undef;
            for (var i = 0; i < this.operationBindings.length; i++) {
                if (this.operationBindings[i].operationId == requestProperties.operationId &&
                    this.operationBindings[i].operationType == "clientExport")
                {
                    binding = this.operationBindings[i];
                }
            }
            if (binding === undef) {
                this.logWarn("exportClientData() was passed operationId '" +
                             requestProperties.operationId +
                             "', but this DataSource has no operationBinding of type 'clientExport' " +
                             "with that name.  Delegating to the static exportClientData() method");   
                delete requestProperties.operationId;
            }
        }
        return isc.DataSource.exportClientData(data,requestProperties, callback, this);
	},

    //> @method dataSource.exportData()
    // Perform a "fetch" DataSource operation against this DataSource, sending search criteria,
    // retrieving matching records and exporting the results.  See 
    // +link{operationBinding.exportResults} or +link{dsRequest.exportResults} and for more
    // information.
    //
    //	@param	[criteria]          (Criteria)	  search criteria
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @param [callback] (DSCallback)   callback to invoke on completion.  Note that this parameter
    //                                  only applies where +link{dsRequest.exportToClient} is 
    //                                  explicitly set to false, because  file downloads do not 
    //                                  provide ordinary SmartClient callbacks 
    // @group operations
    // @visibility external
    //<
    exportData : function (criteria, requestProperties, callback, component) {
        var operationType = "fetch";

        // catch clientOnly DS case - needs special handling
        if (this.clientOnly) {
            
            if (this.fromServer) {
                
                this.logWarn("Translating exportData() call to exportClientData()");
                return this.exportClientData(this.getCacheData(), requestProperties, callback);
            }
            
            operationType = "export";
        }

        if (!requestProperties) requestProperties = {};

        requestProperties = isc.DataSource.dupRequest(requestProperties);
        
        if (this.canExport == false) {
        	// exporting is disabled at the DS level - warn and return
        	isc.logWarn("Exporting is disabled for this DataSource.  Set " + 
                "DataSource.canExport to true to enable it.");
        	return;
        }

        if (requestProperties.exportAs && requestProperties.exportAs.toLowerCase() == "json" &&
            requestProperties.exportToClient !== false)
        {
        	// json export not allowed via client-calls
        	isc.logWarn("Export in JSON format with download to client is not allowed from a " +
                        "client call - either specify exportToClient: false, or set " + 
                        "operationBinding.exportAs on your DataSource instead.  The server " +
                        "will reject this attempt.");
        }

        if (requestProperties.textMatchStyle == null) requestProperties.textMatchStyle = "substring";
        var exportAs = requestProperties.exportAs || "csv"; 

		var parameters = {};
        parameters.exportResults = true;
        parameters.exportAs = exportAs;
        parameters.exportDelimiter = requestProperties.exportDelimiter || ","; 
        parameters.exportTitleSeparatorChar = requestProperties.exportTitleSeparatorChar || ""; 
        if (requestProperties.operationId != null) {
            var operationBinding = this.getOperationBinding(operationType, requestProperties.operationId);
            if (operationBinding != null && operationBinding.exportAs) {
                exportAs = operationBinding.exportAs;
            }
        }
        parameters.exportFilename = isc.DataSource.addExportFilenameExtension(requestProperties.exportFilename || "Results",
                                                                    exportAs);

        requestProperties.exportFilename = parameters.exportFilename;
        parameters.exportPath = requestProperties.exportPath;
        parameters.exportDisplay = requestProperties.exportDisplay || "download";
        parameters.lineBreakStyle = requestProperties.lineBreakStyle || "default"; 
        parameters.exportFields = this.getExportableDSFields(
            requestProperties.exportFields  || this.getVisibleDSFields(), component
        );
        parameters.exportHeader = requestProperties.exportHeader;
        parameters.exportHeaderless = requestProperties.exportHeaderless;
        parameters.exportFooter = requestProperties.exportFooter;
        parameters.exportFieldTitles = requestProperties.exportFieldTitles;
        parameters.exportDatesAsFormattedString = 
            requestProperties.exportDatesAsFormattedString;
        parameters.exportNumbersAsFormattedString = 
            requestProperties.exportNumbersAsFormattedString;
        parameters.exportRawValues = requestProperties.exportRawValues;
        parameters.exportCurrencySymbol = isc.NumberUtil.currencySymbol;
        if (requestProperties.exportValueFields != null) {
            parameters.exportValueFields = requestProperties.exportValueFields;
        }

        if (!parameters.exportFieldTitles) {
            var wkFields = parameters.exportFields;
            var exportFieldTitles = {};
            for (var i = 0; i < wkFields.length; i++) {
                var field = wkFields[i];
                var fieldName;
                if (isc.isA.String(field)) {
                    fieldName = field;
                    field = this.getField(fieldName);
                }
                if (field) {
                    if (field.hidden) continue;
                   exportFieldTitles[field.name] = field.exportTitle || field.title;
                } else {
                   exportFieldTitles[fieldName] = fieldName;
                }
            }
            parameters.exportFieldTitles = exportFieldTitles;
        }

        parameters.exportHeaderSpans = requestProperties.exportHeaderSpans;
        parameters.exportOtherFields = requestProperties.exportOtherFields;
        
        if (requestProperties.exportHeaderHeight != null) {
            parameters.exportHeaderHeight = requestProperties.exportHeaderHeight;
        }
        
        if (requestProperties.exportFieldPixelWidths != null) {
            parameters.exportFieldPixelWidths = requestProperties.exportFieldPixelWidths;
			parameters.exportWidthScale = requestProperties.exportWidthScale;
        }
        
        parameters.exportWrapHeaderTitles = requestProperties.exportWrapHeaderTitles;

        if (requestProperties.exportStreaming != null) {
            parameters.exportStreaming = requestProperties.exportStreaming;
        }
        
        if (requestProperties.exportAlignments != null) {
            parameters.exportAlignments = requestProperties.exportAlignments;
        }
        
        if (requestProperties.exportPropertyIdentifier != null) {
            parameters.exportPropertyIdentifier = requestProperties.exportPropertyIdentifier;
        }

        if (requestProperties.exportTZ != null) {
            if (this.getDataFormat() == "iscServer" && 
                (requestProperties.exportAs == "ooxml" || requestProperties.exportAs == "xls")) {
                if (requestProperties.exportTZ == "client") {
                    requestProperties.exportTZ = isc.Time.getDefaultDisplayTimezone();
                }
                parameters.exportTZ = requestProperties.exportTZ;
            } else {
                requestProperties.exportTZ = null;
            }
        }

        requestProperties.downloadResult = (requestProperties.exportToClient !== false);
        
        
        requestProperties.downloadToNewWindow = requestProperties.exportDisplay == "window" 
        	? true : false;

        if (this.implicitCriteria) {
            // apply DS-level implicitCriteria to the export fetch
            criteria = this.combineCriteria(
                isc.DataSource.copyCriteria(this.implicitCriteria), 
                criteria
            );
        }

		if (requestProperties.downloadToNewWindow) {
			if (parameters.exportFilename.endsWith(".xml") && parameters.exportAs != "xml") {
				parameters.exportFilename = parameters.exportFilename + ".txt";
			}
            requestProperties.download_filename = requestProperties.exportFilename;
            criteria = criteria || {};
            criteria.download_filename = requestProperties.download_filename;
        }
        requestProperties.showPrompt = false;
		requestProperties.parameters = parameters;

        this.performDSOperation(operationType, criteria, callback, requestProperties);
    },

	getVisibleDSFields : function () {
        // pass up only visible fields
        var vFields = [];
        var fields = this.fields;
        // Internally, the fields collection is held as an index, not an array, so convert
        if (!isc.isAn.Array(fields)) {
            fields = [];
            for (var key in this.fields) {
                fields.add(this.fields[key]);
            }
        }
        for (var i = 0; i < fields.length; i++) {
            var field = fields.get(i);
            if (!field.hidden) vFields.add(field.name);
        }
        return vFields;
	},

    getExportableDSFields : function (fields, component) {
        // pass up only those fields that can be exported
        var vFields = [];
        if (this.canExport) {
            for (var i = 0; i < fields.length; i++) {
                var field = this.getField(fields[i]);
                if (!field && component && component.getField) {
                    field = component.getField(fields[i]);
                    if (field && field.includeFrom && field.canExport != false) {
                        vFields.add(fields[i]);
                    }
                    continue;
                }
                if (field && field.canExport != false) 
                    vFields.add(field.name);
            }
        }
        return vFields;
	},

    // undoc'd ability to disable exports at the DS level
    canExport: true,

    //> @method Callbacks.Function
    // Generic callback interface.
    //
    // @visibility external
    //<

    //> @method Callbacks.ClientOnlyDataSourceCallback
    // Generic callback interface.
    //
    // @param clientOnly (DataSource) Client only Data Source.
    // @visibility external
    //<
    
    //> @method dataSource.getClientOnlyDataSource()
    // Produces a clientOnly "copy" of a particular subset of data from a normal 
    // DataSource, via calling fetchData() to fetch matching rows, and constructing 
    // a clientOnly DataSource that +link{inheritsFrom} the original DataSource.
    // <P>
    // This clientOnly "copy" can be useful in situations where you want to allow 
    // a series of local changes without immediately committing to the server.  
    // See also +link{ListGrid.autoSaveEdits} for more fine-grained tracking of 
    // edits (eg, special styling for uncommitted changes).
    // <P>
    // The new DataSource is returned via the "callback" argument.  If +link{cacheAllData} is
    // enabled and +link{hasAllData()} returns true, the new DataSource is synchronously
    // returned as the result of the method.  In this case, if a callback was passed, it also
    // is executed synchronously.
    //
    // @param criteria (Criteria) The criteria for the clientOnly DS
    // @param callback (ClientOnlyDataSourceCallback) The callback to fire passing the clientOnly DS
    // @param [requestProperties] (DSRequest Properties) optional properties to pass through to the DSRequest
    // @param [dataSourceProperties] (DataSource Properties) optional properties to pass 
    //                                                       through to the clientOnly DS
    // 
    // @visibility external
    //<
    getClientOnlyDataSource : function (criteria, callback, requestProperties, dataSourceProperties) {
        var _criteria = criteria,
            _callback = callback,
            parentDS = this;

        if (this.cacheAllData && this.hasAllData()) {
            var ds = isc.DataSource.create({
                inheritsFrom: parentDS,
                clientOnly: true,
                useParentFieldOrder: true,
                testData: this.cacheResultSet.getAllRows()
                }, dataSourceProperties)
            ;
            parentDS.fireCallback(_callback, "dataSource", [ds]);
            return ds;
        } else {
            this.fetchData(_criteria, 
                function (dsResponse, data) {
                    var ds = isc.DataSource.create({
                        inheritsFrom: parentDS,
                        clientOnly: true,
                        useParentFieldOrder: true,
                        testData: data
                        }, dataSourceProperties)
                    ;
                    parentDS.fireCallback(_callback, "dataSource", [ds]);
                },
                isc.addProperties({}, requestProperties)
            );
        }
    },

    //> @method dataSource.addData()
    // Perform an "add" DataSource operation against this DataSource, to create a new DataSource
    // record.
    // <P>
    // <b>NOTE:</b> do not use repeated calls to <code>addData()</code> to provide the initial
    // dataset for a +link{dataSource.clientOnly,clientOnly} DataSource, instead, provide
    // initial data via +link{cacheData}.  Using <code>addData()</code> for subsequent,
    // incremental updates from sources like user editing is fine.
    //
    //	@param	newRecord           (Record)      new record
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    addData : function (newRecord, callback, requestProperties) {
        if (isc.Offline && isc.Offline.isOffline() && this.contactsServer()) {
            isc.logWarn("Data cannot be saved because you are not online");
            return;
        }
        this.performDSOperation("add", newRecord, callback, requestProperties);
    },

    //> @method dataSource.updateData()
    // Perform an "update" DataSource operation against this DataSource, to update values in an
    // existing DataSource record.
    //
    //	@param	updatedRecord       (Record Properties)      updated record
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    updateData : function (updatedRecord, callback, requestProperties) {
        if (isc.Offline && isc.Offline.isOffline() && this.contactsServer()) {
            isc.logWarn("Data cannot be saved because you are not online");
            return;
        }
        this.performDSOperation("update", updatedRecord, callback, requestProperties);
    },

    //> @method dataSource.removeData()
    // Perform a "remove" DataSource operation against this DataSource, to delete an existing
    // DataSource record.
    //
    //	@param	data                (Record | PrimaryKeys) primary key values of record to delete, (or complete record)
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    removeData : function (recordKeys, callback, requestProperties) {
        if (isc.Offline && isc.Offline.isOffline() && this.contactsServer()) {
            isc.logWarn("Data cannot be saved because you are not online");
            return;
        }
        // if passed a full record, trim it down to primaryKeys.
        // This will avoid problems where additional properties such as _selected etc 
        // are present on the record
        
        var keyFieldNames = this.getPrimaryKeyFieldNames(),
            recordKeys = isc.applyMask(recordKeys, keyFieldNames);
        this.performDSOperation("remove", recordKeys, callback, requestProperties);
    },

    contactsServer : function () {
        return !this.clientOnly && this.dataProtocol != "clientCustom"
    },

    //> @method dataSource.validateData()
    // Contacts the server to run server-side validation on a DSRequest and either returns
    // +link{dsResponse.errors} validation errors or a +link{dsResponse.status} code of 0.
    // <p>
    // A "validate" dsRequest is effectively always +link{RPCRequest.willHandleError}:true.
    // It is a normal condition for a "validate" DSResponse to have validation errors and
    // the response will never go to system-wide handling for unexpected errors
    // (+link{RPCManager.handleError}).
    //
    // @param values (Record) record values to validate
    // @param [callback] (DSCallback) callback to invoke on completion
    // @param [requestProperties] (DSRequest Properties) additional properties to set on
    //                                                   the DSRequest that will be issued
    //
    // @group operations
    // @visibility external
    //<
    validateData : function (values, callback, requestProperties) {
        if (!requestProperties) requestProperties = {};
        
        requestProperties = isc.DataSource.dupRequest(requestProperties);

        // Force willHandleError: true on request and default value for validationMode
        requestProperties = isc.addProperties(requestProperties, {willHandleError: true});
        if (requestProperties.validationMode == null) requestProperties.validationMode = "full";

        return !!this.performDSOperation("validate", values, callback, requestProperties);
    },

    //> @method dataSource.performCustomOperation()
    // Invoke an operation declared with +link{operationBinding.operationType} "custom".
    // <P>
    // <b>This is a rarely used API.</b>  If the operation you are performing can be thought of
    // as one of the standard "CRUD" +link{type:DSOperationType,operation types}, declare it
    // with a CRUD operationType.  For example, if your operation updates a record, declare it
    // with operationType "update" and invoke it via +link{updateData()} - this will cause
    // +link{ResultSet,cache sync} to work correctly.
    // <P>
    // In particular:
    // <ul>
    // <li> do not use this API just because you need to add additional server-side logic to a
    // CRUD operation (+link{DMI} allows this)
    // <li> do not use this API to implement variants of core CRUD operations
    // (+link{dsRequest.operationId} is the correct way to do this)
    // <li> do not use this API just because an operation affects more than one record.  Most
    // kinds of multi-record operations should use +link{RPCManager.startQueue(),queuing}.  
    // However, a custom operation <em>is</em> appropriate for genuine "batch" updates, as 
    // opposed to just a number of ordinary updates by primaryKey - see 
    // +link{operationBinding.allowMultiUpdate}
    // <li> do not use this API just because you are calling a stored procedure in SQL - if the
    // stored procedure performs some kind of CRUD operation on the records of this DataSource,
    // use a standard CRUD operationType
    // </ul>
    // <P>
    // Instead, the specific purpose of this API is to bypass all checks and side effects that
    // normally occur for CRUD operations, for example, that a "fetch" requires valid Criteria
    // or that an "update" or "remove" operation contains a valid primary key, or that an "add"
    // operation returns the newly added record.  <code>performCustomOperation</code> allows
    // you to pass an arbitrary Record to the server, act on it with custom code, and return
    // arbitray results or even no results.
    // <P>
    // The "data" parameter becomes +link{dsRequest.data,dsRequest.data}.  With the SmartClient
    // Server Framework, the data is accessible server-side via DSRequest.getValues() and in
    // +link{group:velocitySupport,Velocity templates} (such as &lt;customSQL&gt;) as $values.
    // <P>
    // Note that with SQLDataSource, <code>performCustomOperation</code> must be used if you
    // plan to have a &lt;customSQL&gt; tag in your operationBinding that will execute SQL
    // operations other than SELECT, UPDATE, INSERT, DELETE (such as creating a new table).
    // By declaring +link{operationBinding.operationType} "custom" in your .ds.xml file, all
    // checks related to normal CRUD operations will be skipped and your &lt;customSQL&gt;
    // can do arbitrary things.
    //
    //  @param  operationId         (String)                 the operation ID
    //	@param	[data]              (Record Properties)      data to pass to the server.
    //	@param	[callback]          (DSCallback)  callback to invoke on completion
    //  @param  [requestProperties] (DSRequest Properties)   additional properties to set on
    //                                                       the DSRequest that will be issued
    // @group operations
    // @visibility external
    //<
    performCustomOperation : function (operationId, data, callback, requestProperties) {
        if (!requestProperties) requestProperties = {};
        
        requestProperties = isc.DataSource.dupRequest(requestProperties);
        
        isc.addProperties(requestProperties, {operationId: operationId});
        this.performDSOperation("custom", data, callback, requestProperties);
    },

    performClientExportOperation : function (operationId, data, callback, requestProperties) {
        if (!requestProperties) requestProperties = {};

        requestProperties = isc.DataSource.dupRequest(requestProperties);
        
        isc.addProperties(requestProperties, {operationId: operationId});
        this.performDSOperation("clientExport", data, callback, requestProperties);
    },

    

    // ------------------------
    // FileSource Operations
    // ------------------------

    //> @groupDef fileSource
    //
    // These APIs allow a +link{DataSource} to be used as a way to store files in a
    // DataSource that might otherwise be stored in a filesystem on the server.
    // They are implemented by sending requests to the server with a special
    // +link{type:DSOperationType,operationType}.
    //
    // <p>FileSource operations use standardized field names: fileName, fileType, fileFormat,
    // fileContents, fileSize, fileLastModified and optionally fileVersion. These are 
    // translated on the server to native field names for the +link{DataSource}, determined 
    // according to the DataSource configuration for 
    // +link{DataSource.fileNameField,fileNameField},
    // +link{DataSource.fileTypeField,fileTypeField},
    // +link{DataSource.fileFormatField,fileFormatField},
    // +link{DataSource.fileContentsField,fileContentsField},
     
    // +link{DataSource.fileLastModifiedField,fileLastModifiedField}, and
    // +link{DataSource.fileVersionField,fileVersionField}.  
    //
    // @see class:DataSource
    // @treeLocation Client Reference/Data Binding/DataSource
    // @title FileSource Operations
    // @visibility external
    //<
    
    

    //> @object FileSpec
    // A record which specifies files for use with +link{group:fileSource,FileSource Operations}.
    //
    // @treeLocation Client Reference/Data Binding/DataSource
    // @see classMethod:dataSource.makeFileSpec() 
    // @group fileSource
    // @visibility external
    //<

    //> @attr fileSpec.fileName (String : null : IRW)
    // The name of the file, without any extension to indicate +link{attr:fileSpec.fileType,type} or
    // +link{attr:fileSpec.fileFormat,format}.
    // @visibility external
    //<
    
    //> @attr fileSpec.fileType (String : null : IRW)
    // The type of the file, e.g. "ds" for datasource, or "proj" for project.
    // @visibility external
    //<
    
    //> @attr fileSpec.fileFormat (String : null : IRW)
    // The format of the file, e.g. "xml" or "js"
    // @visibility external
    //<
    
    //> @attr dataSource.fileNameField (String : null : IR)
    // 
    // The native field name used by this DataSource on the server to represent the
    // <code>fileName</code> for +link{group:fileSource,FileSource Operations} operations. Any
    // extensions to the fileName to indicate type or format (e.g. ".ds.xml") are stored in the
    // +link{fileTypeField,fileTypeField} and +link{fileFormatField,fileFormatField}, if specified
    // for this DataSource.
    //
    // <p>If not specified for a DataSource, the fileNameField will be inferred
    // on the server as follows:
    //
    // <ul>
    // <!-- <li>f the +link{fileContentsField} is binary, then we use
    //     the filename field which corresponds to the binary field,
    //     if it exists. TODO: Not implemented yet.</li> -->
    // <li>If there is a field named "fileName", "name", or "title",
    //     then that field is used.</li>
    // <li>Otherwise, if there is a single primary key, and it has the type "text",
    //     then that field is used.</li>
    // <li>Otherwise, an error is logged</li>
    // </ul>
    //
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.fileTypeField (String : null : IR)
    // 
    // The native field name used by this DataSource on the server to represent the
    // <code>fileType</code> for +link{group:fileSource,FileSource Operations}. 
    //
    // <p>If the fileTypeField is not configured, then a field named "fileType"
    // will be used, if it exists. Otherwise, the DataSource will not track
    // fileTypes -- this may be acceptable if, for instance, you use a separate
    // DataSource for each fileType.
    //
    // <p>The fileType is specified according to the extension that would have been used in the
    // filesystem -- for instance, the fileType for employees.ds.xml would be "ds". 
    //
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.fileFormatField (String : null : IR)
    // 
    // The native field name used by this DataSource on the server to represent
    // the <code>fileFormat</code> for +link{group:fileSource,FileSource Operations}. 
    //
    // <p>If the fileFormatField is not configured, then a field named
    // "fileFormat" will be used, if it exists. Otherwise, the DataSource will not
    // track fileFormats -- this may be acceptable if, for instance, the
    // fileFormat is always the same.
    //
    // <p>The fileFormat is specified according to the extension that would have been used in the
    // filesystem -- for instance, the fileFormat for employees.ds.xml would be "xml". 
    //
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<
    
    //> @attr dataSource.fileContentsField (String : null : IR)
    //
    // The native field name used by this DataSource on the server to represent
    // the <code>fileContents</code> for +link{group:fileSource,FileSource Operations}.
    //
    // <p>If the fileContentsField is not configured, then a field named
    // "fileContents" or "contents" will be used, if it exists. <!-- If not found,
    // the first field with a "binary" type will be used. TODO: Binary field support
    // not working yet. --> If not found, the longest text field which is not the
    // +link{fileNameField,fileNameField}, +link{fileTypeField,fileTypeField} or
    // +link{fileFormatField,fileFormatField} will be used.
    //
    // <p>Note that the only method which will actually return the fileContents
    // is +link{dataSource.getFile(),getFile()} -- the other +link{group:fileSource,FileSource}
    // methods omit the fileContents for the sake of efficiency.
    //
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.fileSizeField (String : null : IR)
    //
    // The native field name used by this DataSource on the server to represent
    // the <code>fileSize</code> for +link{group:fileSource,FileSource Operations}.
    //
    // <p>If the fileSizeField is not configured, then a field named
    // "fileSize" will be used, if it exists. <!-- TODO: Binary fields? --> Otherwise,
    // the DataSource will not cache file sizes. 
    //
    // @group fileSource
    // @serverDS only
    // @visibility internal
    //<

    //> @attr dataSource.fileLastModifiedField (String : null : IR)
    //
    // The native field name used by this DataSource on the server to represent
    // <code>fileLastModified</code> for +link{group:fileSource,FileSource Operations}.
    //
    // <p>If the fileLastModifiedField is not configured, then a field named
    // "fileLastModified" will be used, if it exists. <!-- TODO: Binary fields? --> 
    // Otherwise, the server will look for a field with a "modifierTimestamp" type.
    // If that is not found, the DataSource will not keep track of the last
    // modified date.
    //
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.fileVersionField (String : null : IR)
    //
    // The native field name used by this DataSource on the server to represent
    // <code>fileVersion</code> for +link{group:fileSource,FileSource Operations}.
    // <p>
    // Automatic file versioning is configured by the presence of this property: if you want
    // automatic versioning for a FileSource DataSource, it is sufficient to simply define a 
    // <code>fileVersionField</code>.  When automatic versioning is on:<ul>
    // <li>Calls to +link{saveFile()} will save a new version of the file, retaining previous 
    // versions up to the maximum configured by +link{dataSource.maxFileVersions}; when that
    // maximum is reached, the oldest version is overwritten</li>
    // <li>The +link{getFile()} API always returns the most recent version</li>
    // <li>The +link{listFiles()} API only includes the most recent version of any file</li>
    // <li>You can view and retrieve earlier versions of a file with the 
    // +link{listFileVersions()} and +link{getFileVersion()} APIs.  Note that retrieving a
    // previous version of a file and then calling <code>saveFile()</code> goes through the
    // normal process of saving a new version</li>
    // </ul>
    // <p>
    // The <code>fileVersion</code> field is expected to be of type "datetime", and automatic 
    // versioning will not work otherwise.  Note, to minimize the possibility of version 
    // timestamp collisions, we recommend that <code>fileVersion</code> fields specify 
    // +link{dataSourceField.storeMilliseconds,storeMilliseconds}: true.
    // <p>
    // If the fileVersionField is not configured, no automatic file versioning will be done.
    //
    // @group fileSource
    // @see DataSource.maxFileVersions
    // @see DataSource.listFileVersions()
    // @see DataSource.getFileVersion()
    // @see DataSource.removeFileVersion()
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.maxFileVersions (Integer : 20 : IR)
    //
    // If +link{dataSource.fileVersionField,automatic file versioning} is enabled for a FileSource
    // DataSource, this property configures the maximum number of versions to retain.
    //
    // @group fileSource
    // @see DataSource.fileVersionField
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.streamLogging (boolean : false : IRW)
    // Whether +link{getFile(),load} and +link{saveFile(),save} operations for this
    // <code>DataSource</code> should be forwarded to the +link{ClickStream} module, where
    // they'll be captured by all streams configured for "file events."
    // @see ClickStream.captureDSFileEvents
    //<
    

    //> @method dataSource.getFile()
    //
    // Gets the contents of a file stored in this DataSource.
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType and fileFormat are not provided, will return
    //                 the first file with the specified fileName.
    // @param callback (GetFileCallback) +link{Callbacks.GetFileCallback(),Callback} executed with the results. The 
    //                 <code>data</code> parameter is either a String with the
    //                 contents of the file, or null to indicate error (such as
    //                 file not found). 
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    getFile : function (fileSpec, callback, requestProperties) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);

        this.performDSOperation(
            "getFile", fileSpec, function (response, data, request) {
                if (this.streamLogging) {
                    isc.ClickStream.addDSFileEvent(this, response, isc.ClickStream.FILE_LOAD);
                }
                // If file not found, or other error, return null
                if (response.status >= 0 && isc.isAn.Array(data) && data.length > 0) {
                    data = data[0].fileContents;
                } else {
                    data = null;
                }
                this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
            },
            isc.addProperties({
                willHandleError: true
            }, requestProperties)
        );
    },

    //> @method dataSource.hasFile()
    //
    // Indicates whether a file exists in this DataSource. 
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType or fileFormat are not provided, will indicate whether
    //                 any file with the provided fileName exists.
    // @param callback (HasFileCallback) +link{Callbacks.HasFileCallback(),Callback} executed with the results. 
    //                 The <code>data</code> parameter is a boolean indicating
    //                 whether the file is present.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    hasFile : function (fileSpec, callback, requestProperties) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);
        
        this.performDSOperation("hasFile", fileSpec, function (response, data, request) {
            if (response.status >= 0) {
                // Make sure data is *actually* a boolean for SGWT
                data = !!(isc.isAn.Array(data) && data.length > 0);
            } else {
                data = false;
            }
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        },
        isc.addProperties({
            willHandleError: true
        }, requestProperties));
    },

    
    uniqueName : function (fileSpec, callback) {
        if (isc.isA.String(fileSpec)) {
            this.logWarn("Invalid fileSpec for uniqueName operation");
            return;
        }
        
        this.performDSOperation("uniqueName", fileSpec, function (response, data, request) {
            if (response.status >= 0) {
                data = (isc.isAn.Array(data) && data.length > 0 ? data = data[0] : data);
            } else {
                data = null;
            }
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        }, {
            willHandleError: true
        });
    },

    //> @method dataSource.listFiles()
    //
    // Get a list of files from the DataSource.  Note, if 
    // +link{fileVersionField,automatic file versioning} is switched on for the dataSource,
    // the resulting list contains only the most recent version of each file.
    //
    // @param criteria (Criteria) Criteria to apply. References to <code>fileName</code>,
    //                 <code>fileType</code> and <code>fileFormat</code> fields will
    //                 be translated to the native field names configured for
    //                 this DataSource.
    // @param callback (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either an array of records,
    //                 or null to indicate an error. 
    //                 The records will have the <code>+link{fileNameField,fileName}</code>,
    //                 <code>+link{fileTypeField,fileType}</code>,
    //                 <code>+link{fileFormatField,fileFormat}</code>,
    
    //                 <code>+link{fileLastModifiedField,fileLastModified}</code>, and 
    //                 <code>+link{fileVersionField,fileVersion}</code> fields populated, but 
    //                 not the <code>+link{fileContentsField,fileContents}</code> field. (You 
    //                 can use +link{getFile(),getFile()} to get the <code>fileContents</code>).
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @see listFileVersions()
    // @requiresModules SCServer
    // @visibility external
    //<
    listFiles : function (criteria, callback, requestProperties) {
        if (!criteria) criteria = {};

        this.performDSOperation(
            "listFiles", criteria, function (response, data, request) {
                if (response.status < 0) data = null; 
                this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
            },
            isc.addProperties({
                willHandleError: true
            }, requestProperties)
        );
    },

    //> @method dataSource.saveFile()
    //
    // Save a file to the DataSource.
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 Depending on the configuration of the DataSource, the fileType
    //                 and fileFormat may be optional.
    // @param contents (String) The contents of the file
    // @param [callback] (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either a record represening
    //                 the new file, or null to indicate an error. The record will have its
    //                 <code>fileName</code>, <code>fileType</code> and <code>fileFormat</code>
    //                 field populated, but not the <code>fileContents</code>
    //                 field.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    saveFile : function (fileSpec, contents, callback, requestProperties) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);
        
        var values = isc.addProperties({
            fileContents: contents
        }, fileSpec);

        this.performDSOperation(
            "saveFile", values, function (response, data, request) {
                if (this.streamLogging) {
                    isc.ClickStream.addDSFileEvent(this, response, isc.ClickStream.FILE_SAVE);
                }
                if (response.status < 0) data = null; 
                if (isc.isAn.Array(data)) data = data[0];
                this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
            },
            isc.addProperties({
                willHandleError: true
            }, requestProperties)
        );
    },

    //> @method dataSource.renameFile()
    //
    // Rename a file stored in this DataSource.  Note, if 
    // +link{fileVersionField,automatic file versioning} is switched on for the dataSource,
    // all versions of the file are renamed.
    //
    // @param oldFileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat
    //                 of the file to rename.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 Depending on the configuration of the DataSource, the fileType and fileFormat
    //                 may be optional.
    // @param newFileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat
    //                 to rename the file to.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If the fileType or fileFormat are not provided, then they will not
    //                 be changed.
    // @param [callback] (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either an array of
    //                 records represening the renamed file(s), or null to
    //                 indicate an error.
    //                 The records will have their <code>fileName</code> fields and
    //                 <code>fileType</code> fields populated, but not the
    //                 <code>fileContents</code> field.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    renameFile : function (oldFileSpec, newFileSpec, callback, oldType, newType) {
        if (isc.isA.String(oldFileSpec)) oldFileSpec = isc.DataSource.makeFileSpec(oldFileSpec);
        if (isc.isA.String(newFileSpec)) newFileSpec = isc.DataSource.makeFileSpec(newFileSpec);

        // If no newType is provided, supply the oldType
        if (!newFileSpec.fileType) newFileSpec.fileType = oldFileSpec.fileType;
        if (!newFileSpec.fileFormat) newFileSpec.fileFormat = oldFileSpec.fileFormat;
        if (!newFileSpec.fileName) newFileSpec.fileName = oldFileSpec.fileName;

        this.performDSOperation("renameFile", newFileSpec, function (response, data, request) {
            if (response.status < 0) data = null; 
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        },{
            willHandleError: true,
            // This is what the server actually uses to find the record to rename,
            // since the fileName/fileType may be primary keys
            oldValues: oldFileSpec
        });
    },

    //> @method dataSource.removeFile()
    //
    // Remove a file stored in this DataSource.  Note, if 
    // +link{fileVersionField,automatic file versioning} is switched on for the dataSource,
    // all versions of the file are removed (to remove an individual file version, use the 
    // +link{removeFileVersion()} API).
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 Depending the configuration of the DataSource, the fileType
    //                 and fileFormat may be optional.
    // @param [callback] (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either an array of
    //                 records represening the removed file(s), or null to
    //                 indicate an error.
    //                 The records will have their <code>fileName</code> fields and
    //                 <code>fileType</code> fields populated, but not the
    //                 <code>fileContents</code> field.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    removeFile : function (fileSpec, callback, type) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);

        this.performDSOperation("removeFile", fileSpec, function (response, data, request) {
            if (response.status < 0) data = null; 
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        }, {
            willHandleError: true
        });
    },

    // FileSource versioning
    
    //> @method dataSource.listFileVersions()
    //
    // Get the list of a given file's versions from the dataSource, sorted in version order 
    // (most recent version first).  If the dataSource does not specify a 
    // +link{fileVersionField,fileVersionField}, this API will return an error
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType and fileFormat are not provided, will return
    //                 the first file with the specified fileName.
    // @param callback (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either an array of records,
    //                 or null to indicate an error. 
    //                 The records will have the <code>+link{fileNameField,fileName}</code>,
    //                 <code>+link{fileTypeField,fileType}</code>,
    //                 <code>+link{fileFormatField,fileFormat}</code>,
    
    //                 <code>+link{fileLastModifiedField,fileLastModified}</code> and 
    //                 <code>+link{fileVersionField,fileVersion}</code> fields populated, but 
    //                 not the <code>+link{fileContentsField,fileContents}</code> field. (You
    //                 can use +link{getFileVersion(),getFileVersion()} to get the 
    //                 <code>fileContents</code>).
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    listFileVersions : function (fileSpec, callback) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);

        this.performDSOperation("listFileVersions", fileSpec, function (response, data, request) {
            if (response.status < 0) data = null; 
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        }, {
            willHandleError: true
        });
    },

    
    //> @method dataSource.getFileVersion()
    //
    // Gets the contents of a particular file version stored in this DataSource.
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType and fileFormat are not provided, will return
    //                 the first file with the specified fileName.
    // @param version  (Date) A version timestamp.  This must exactly match the version 
    //                 timestamp recorded in the DataSource.  You can obtain the list of 
    //                 versions for a given file with the +link{listFileVersions()} API.
    // @param callback (GetFileVersionCallback) +link{Callbacks.GetFileVersionCallback(),Callback} executed with the results. The 
    //                 <code>data</code> parameter is either a String with the
    //                 contents of the file, or null to indicate error (such as
    //                 file not found). 
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    getFileVersion : function (fileSpec, version, callback, requestProperties) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);
        
        fileSpec[this.fileVersionField] = version;

        this.performDSOperation("getFileVersion", fileSpec, function (response, data, request) {
            // If file not found, or other error, return null
            if (response.status >= 0 && isc.isAn.Array(data) && data.length > 0) {
                data = data[0].fileContents;
            } else {
                data = null;
            }
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        },
        isc.addProperties({
            willHandleError: true
        }, requestProperties));
    },

    //> @method dataSource.hasFileVersion()
    //
    // Indicates whether a particular file version exists in this DataSource. 
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType or fileFormat are not provided, will indicate whether
    //                 any file with the provided fileName exists.
    // @param version  (Date) A version timestamp.  This must exactly match the version 
    //                 timestamp recorded in the DataSource for <code>hasFileVersion</code> to
    //                 return true.  Note, you can obtain the list of versions for a given 
    //                 file with the +link{listFileVersions()} API.
    // @param callback (HasFileCallback) +link{Callbacks.HasFileVersionCallback(),Callback} 
    //                 executed with the results.  The <code>data</code> parameter is a boolean
    //                 indicating whether the file version is present.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    hasFileVersion : function (fileSpec, version, callback) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);
        
        fileSpec.version = version;
        
        this.performDSOperation("hasFileVersion", fileSpec, function (response, data, request) {
            if (response.status >= 0) {
                // Make sure data is *actually* a boolean for SGWT
                data = !!(isc.isAn.Array(data) && data.length > 0);
            } else {
                data = false;
            }
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        }, {
            willHandleError: true
        });
    },

    //> @method dataSource.removeFileVersion()
    //
    // Remove a particular file version stored in this DataSource.  Any other versions of the
    // file are left untouched.
    //
    // @param fileSpec (FileSpec | String) Either a FileSpec, or a String which
    //                 will be parsed to determine the fileName, fileType and fileFormat.
    //                 For instance, "employees.ds.xml" would be parsed as
    //                 {fileName: "employees", fileType: "ds", fileFormat: "xml"}.
    //                 If fileType and fileFormat are not provided, will return
    //                 the first file with the specified fileName.
    // @param version  (Date) A version timestamp.  This must exactly match the version 
    //                 timestamp recorded in the DataSource.  You can obtain the list of 
    //                 versions for a given file with the +link{listFileVersions()} API.
    // @param [callback] (DSCallback) Callback executed with the results. 
    //                 The <code>data</code> parameter is either a record representing the
    //                 removed file version, or null to indicate an error.
    //                 The record will have its <code>+link{fileNameField,fileName}</code>,
    //                 <code>+link{fileTypeField,fileType}</code>,
    //                 <code>+link{fileFormatField,fileFormat}</code>,
    
    //                 <code>+link{fileLastModifiedField,fileLastModified}</code>, and 
    //                 <code>+link{fileVersionField,fileVersion}</code> fields populated, but 
    //                 not the <code>+link{fileContentsField,fileContents}</code> field.
    //                 You can examine <code>+link{dsResponse.status,dsResponse.status}</code>
    //                 and <code>+link{dsResponse.data,dsResponse.data}</code>
    //                 for additional information about any error.
    // 
    // @group fileSource
    // @requiresModules SCServer
    // @visibility external
    //<
    removeFileVersion : function (fileSpec, version, callback) {
        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);
        
        fileSpec.version = version;

        this.performDSOperation("removeFileVersion", fileSpec, function (response, data, request) {
            if (response.status < 0) data = null; 
            this.fireCallback(callback, "dsResponse,data,dsRequest", [response, data, request]);
        }, {
            willHandleError: true
        });
    },

    // helper to return the file version from a DataSource fileSpec
    _getFileSpecFileVersion : function (fileSpec) {
        if (!fileSpec) return;

        if (isc.isA.String(fileSpec)) fileSpec = isc.DataSource.makeFileSpec(fileSpec);

        return fileSpec[this.fileVersionField || this.fileLastModifiedField ||
                        "fileLastModified"];
    },

    // -----------
    // ProjectFile
    // -----------

    //> @attr dataSource.projectFileKey (String : null : IR)
    //
    // For DataSources with type +link{type:DSServerType,<code>projectFile</code>}, looks
    // up the locations to use as +link{dataSource.projectFileLocations,
    // projectFileLocations} from the project's configuration (i.e.
    // project.properties, +link{group:server_properties,server.properties}
    // etc.).
    //
    // <p>For instance, to look up the value of project.datasources and use it
    // for <code>projectFileLocations</code>, use "datasources" as the 
    // <code>projectFileKey</code>.
    //
    // <p>If you specify both <code>projectFileKey</code> and 
    // <code>projectFileLocations</code>, then both with be used, with the
    // <code>projectFileLocations</code> applied last.
    //
    // @see dataSource.projectFileLocations
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<

    //> @attr dataSource.projectFileLocations (Array of String : null : IR)
    //
    // For DataSources with type +link{type:DSServerType,<code>projectFile</code>},
    // specifies locations for the project files. In XML, each location is
    // expressed with a <code>&lt;location&gt;</code> tag, e.g.:
    //
    // <pre>
    //     &lt;projectFileLocations&gt;
    //         &lt;location&gt;[WEBROOT]/shared/ds&lt;/location&gt;
    //         &lt;location&gt;ds://datasources&lt;/location&gt;
    //     &lt;/projectFileLocations&gt;
    // </pre>
    //
    // Directories should be specified as absolute paths on the server.  If you
    // want to construct a webroot-relative path, then prefix the path with
    // <code>[WEBROOT]</code> (unlike in
    // +link{group:server_properties,server.properties}, where you would use
    // <code>$webRoot</code> as the prefix).
    //
    // <p>To specify another DataSource to be used via 
    // +link{group:fileSource,fileSource operations}, use <code>ds://dsName</code>
    // (where "dsName" is the name of the other DataSource).
    //
    // <p>A <code>projectFile</code> DataSource uses the standard
    // +link{group:fileSource,fileSource} field names: <code>fileName</code>,
    // <code>fileType</code>, <code>fileFormat</code>,
    // <code>fileContents</code>, <code>fileSize</code> and
    // <code>fileLastModified</code>. When defining a <code>projectFile</code>
    // DataSource, you can use +link{dataSource.inheritsFrom,inheritsFrom} with
    // a value of "ProjectFile" to inherit definitions for these fields -- e.g.:
    //
    // <pre>
    //     &lt;DataSource ID="MyDataSources" type="projectFile" inheritsFrom="ProjectFile"&gt;
    //         &lt;projectFileLocations&gt;
    //             &lt;location&gt;[WEBROOT]/shared/ds&lt;/location&gt;
    //             &lt;location&gt;ds://datasources&lt;/location&gt;
    //         &lt;/projectFileLocations&gt;
    //     &lt;/DataSource&gt; 
    // </pre>
    //
    // <p>For directory locations, the
    // <code>fileName</code> is relative to the directory specified. Note that
    // the <code>fileName</code> does not include any extension for type or
    // format.  For instance, for "employees.ds.xml", the <code>fileName</code>
    // would be "employees", the <code>fileType</code> would be "ds" and the
    // <code>fileFormat</code> would be "xml".
    //
    // <p>A projectFile DataSource executes the various 
    // +link{group:fileSource,fileSource operations} in the following manner.
    // The general rule is that <code>fileName</code>, <code>fileType</code>,
    // and <code>fileFormat</code> are treated as primary keys. If files with the
    // same combination of those attributes exist in more than one of the
    // configured locations, the locations are considered in <b>reverse</b>
    // order, with priority given to the location listed last. When modifying
    // an existing file, the last location which contains the file will be
    // used. When creating a new file, the file will be created in the last
    // configured location.
    //
    // <dl>
    // <dt>+link{dataSource.listFiles,listFiles} 
    // <dd>Returns a combined list of files from
    //     all configured locations. Note that <code>listFiles</code> does not 
    //     recurse into subdirectories. If the same combination of 
    //     <code>fileName / fileType / fileFormat</code> exists in more than
    //     one configured location, then the data for <code>fileSize</code> and
    //     <code>fileLastModified</code> will be taken from the last configured
    //     location which contains the file.
    //
    // <dt>+link{dataSource.hasFile,hasFile}
    // <dd>Indicates whether the file exists in any of the configured locations.
    //
    // <dt>+link{dataSource.getFile,getFile}
    // <dd>Returns file data by searching the locations in reverse order.
    //
    // <dt>+link{dataSource.saveFile,saveFile}
    // <dd>If the file exists, it will be saved in the last location in which
    //     it exists. If it is a new file, it will be saved in the last
    //     configured location.
    //
    // <dt>+link{dataSource.renameFile,renameFile}
    // <dd>The file will be renamed in the last location in which it exists.
    //     Note that if the file exists in more than one location, the rename
    //     will not affect other locations. Thus, a subsequent <code>listFiles</code>
    //     operation will return the file from the other location (as well
    //     as the renamed file).
    //
    // <dt>+link{dataSource.removeFile,removeFile}
    // <dd>The file will be removed from the last location in which it exists.
    //     Note that if the file exists in more than one location, the removal
    //     will not affect other locations. Thus, a subsequent <code>listFiles</code>
    //     operation will return the file from the other location.
    //
    // </dl>
    //
    // For convenience, a <code>projectFile</code> DataSource also responds to the standard
    // DataSource operations, in the following manner:
    //
    // <dl>
    // <dt>add
    // <dd>Executes a <code>saveFile</code> operation, either adding the file or updating
    //     an existing file.
    //
    // <dt>fetch
    // <dd>Executes a <code>listFiles</code> operation. Note that the results will not
    //     include the <code>fileContents</code>. In order to obtain the
    //     <code>fileContents</code>, you must use a
    //     +link{dataSource.getFile,getFile operation}.
    //
    // <dt>update
    // <dd>Executes a <code>renameFile</code> operation. Note that this will not update
    //     the <code>fileContents</code> -- for that, you need to use "add", or
    //     a +link{dataSource.saveFile,saveFile operation}. 
    //
    // <dt>remove
    // <dd>Executes a <code>removeFile</code> operation.
    //
    // </dl>
    //
    // <p>If you specify both +link{dataSource.projectFileKey,projectFileKey} and 
    // <code>projectFileLocations</code>, then both with be used, with the
    // <code>projectFileLocations</code> applied last.
    // 
    // @see dataSource.projectFileKey
    // @group fileSource
    // @serverDS only
    // @visibility external
    //<


    _getNextRequestId : function () {
        // ID can be completely arbitrary as long as it's unique, but lets use a format like
        // "SupplyItem_request12" to simplify debugging.
        if (!this._requestIdTemplate) this._requestIdTemplate = [this.getID(), "_request"];
        this._requestIdTemplate[2] = isc.DataSource._getNextRequestId();
        return this._requestIdTemplate.join(isc.emptyString);
    },

    // In order to avoid IE9 leaks we want to use strict JSON parsing (via JSON.parse)
    // by default for iscServer dataSources
    
    shouldUseStrictJSON : function (request) {
    	if (request && request.useStrictJSON != null) return request.useStrictJSON;
    	if (this.useStrictJSON != null) return this.useStrictJSON;

    	if (isc.Browser.isIE && isc.Browser.version>=9
    		 && isc.RPCManager.useJSONParse_IE9 &&
    		this.dataFormat == "iscServer") 
    	{
    		return true;
    	}
    	return null;		
    },

    shouldFallbackToEval : function (request) {
    	if (request == null) request = {};
    	if (request.fallbackToEval != null) return request.fallbackToEval;
    	if (request.useStrictJSON || this.useStrictJSON) return false;
    	return (isc.Browser.isIE && isc.Browser.version>=9 
    			&& isc.RPCManager.useJSONParse_IE9 && this.dataFormat == "iscServer");
    },

    //> @method dataSource.execute() (A)
    // Executes the given DSRequest on this DataSource.
    // <p>
    // This method is typically used by a DataSource whose +link{DataSource.dataProtocol,dataProtocol}
    // is set to <smartclient>"clientCustom"</smartclient><smartgwt>{@link com.smartgwt.client.types.DSProtocol#CLIENTCUSTOM}</smartgwt>.
    // Execution of a DSRequest can be delayed, either after a timeout or until some condition
    // is met, by saving the DSRequest object passed to the +link{DataSource.transformRequest()}
    // override and calling execute() on the DSRequest at a later time.
    // @param dsRequest (DSRequest) the DSRequest to execute.
    // @visibility external
    //<
    execute : function (dsRequest) {
        this.performDSOperation(dsRequest.operationType || "fetch",
                                dsRequest.data,
                                dsRequest.callback,
                                dsRequest);
    },

    performDSOperation : function (operationType, data, callback, requestProperties) {
        if (isc._traceMarkers) arguments.__this = this;

        //>DEBUG
        if (this.logIsDebugEnabled("dsOperationTrace")) {
            this.logDebug("Perform DS operation of type:" + operationType + " Stack:\n" + this.getStackTrace(),
                         "dsOperationTrace");
        }
        //<DEBUG

        requestProperties = isc.DataSource.dupRequest(requestProperties);

        // form a dsRequest
        var dsRequest = isc.addProperties({
            operationType : operationType,
            dataSource : this.ID,
            data : data,
            callback : callback,
            requestId : this._getNextRequestId(),
            // support useStrictJSON at the DS and at the
            // request level.
            
            _origUseStrictJSON: requestProperties && requestProperties.useStrictJSON,
            useStrictJSON: this.shouldUseStrictJSON(requestProperties),
            _origFallbackToEval: requestProperties && requestProperties.fallbackToEval,
            fallbackToEval: this.shouldFallbackToEval(requestProperties),
            textMatchStyle: this.defaultTextMatchStyle
        }, requestProperties);

        isc.DataSource.recordTimingData(dsRequest, "UI event to DSRequest creation", "start", isc.EH._setThreadTimeStamp);
        isc.DataSource.recordTimingData(dsRequest, "UI event to DSRequest creation", "end");
        isc.DataSource.recordTimingData(dsRequest, "performDSOperation", "start");
        dsRequest.lastClientEventThreadCode = isc.EH._thread;

        var ev = isc.EH.getLastEvent();
        if (dsRequest.sortBy != null) {
            if (!isc.isAn.Array(dsRequest.sortBy)) dsRequest.sortBy = [dsRequest.sortBy];

            if (isc.isAn.Object(dsRequest.sortBy[0])) {
                dsRequest.sortBy = isc.DS.getSortBy(dsRequest.sortBy);
            }

            for (var i = 0; i < dsRequest.sortBy.length; i++) {
                var sortByProp = dsRequest.sortBy[i];
                if (!isc.isA.String(sortByProp)) continue;
                // get the sortField, which might be prefixed with -
                var field = this.getField(sortByProp.charAt(0) == "-" ? 
                                sortByProp.substring(1) : sortByProp);
                // don't request the sort if the field is canSortClientOnly
                if (field && field.canSortClientOnly) dsRequest.sortBy[i] = null;
            }
            dsRequest.sortBy.removeEmpty();
            if (dsRequest.sortBy.length == 0) delete dsRequest.sortBy;
        }
        if (this.sendParentNode == false) {
            dsRequest._origParentNode = dsRequest.parentNode;
            dsRequest.parentNode = null;
        }

        return this.sendDSRequest(dsRequest);
    },

    translatePatternOperatorInAdvancedCriteria : function(advancedCriteria) {
        if(!this.isAdvancedCriteria(advancedCriteria)) {
            return advancedCriteria;
        }

        var index, criteria;
        if (advancedCriteria.criteria) {
            if(isc.isA.Array(advancedCriteria.criteria)) {
                for(index in advancedCriteria.criteria) {
                    criteria = advancedCriteria.criteria[index];
                    advancedCriteria.criteria[index] = this.translatePatternOperatorInAdvancedCriteria(criteria);
                }
            } else {
                advancedCriteria.criteria = this.translatePatternOperatorInAdvancedCriteria(advancedCriteria.criteria);
            }
        } else {
            criteria = advancedCriteria;
            if (criteria.operator === "matchesPattern" || criteria.operator === "iMatchesPattern" ||
                criteria.operator === "containsPattern" || criteria.operator === "iContainsPattern") 
            {
                var insensitive = (criteria.operator.indexOf('i') === 0);

                var splitCharacter = (isc.isA.Array(this.patternMultiWildcard) ? 
                      this.patternMultiWildcard[0] : this.patternMultiWildcard.substring(0, 1));
                var fieldName = criteria.fieldName;
                var fieldValue = criteria.value;

                if(isc.isA.Array(this.patternMultiWildcard)) {
                    for(var index = 1; index < this.patternMultiWildcard.length; index++) {
                        fieldValue = fieldValue.replaceAll(this.patternMultiWildcard[index], splitCharacter);
                    }
                }

                var parts = fieldValue.split(splitCharacter);
                var partCrit;
                var newCriteria;

                // If we only have one part, that means it's just a simple value and we can
                // create an equals criteria.
                if(parts.length === 1) {
                    if (criteria.operator === "matchesPattern" || criteria.operator === "iMatchesPattern") {
                        newCriteria = {
                            fieldName: fieldName,
                            value: parts[0],
                            operator: insensitive ? "iEquals" : "equals"
                        };
                    } else if (criteria.operator === 'startsWithPattern' || criteria.operator === 'iStartsWithPattern') {
                        newCriteria = {
                            fieldName: fieldName,
                            value: parts[0],
                            operator: insensitive ? "iStartsWith" : "startsWith"
                        };
                    }else if (criteria.operator === 'endsWithPattern' || criteria.operator === 'iEndsWithPattern') {
                        newCriteria = {
                            fieldName: fieldName,
                            value: parts[0],
                            operator: insensitive ? "iEndsWith" : "endsWith