/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.DBType;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import com.isomorphic.sql.SQLDriver;
import com.isomorphic.sql.SQLServerDriver;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SQLTableCreator
extends Base {
    private static Logger log = new Logger(SQLTableCreator.class.getName());
    static List<String> smallIntTypes = new ArrayList<String>(){
        {
            this.add("java.lang.Integer");
            this.add("java.lang.Short");
            this.add("java.lang.Byte");
            this.add("java.util.concurrent.atomic.AtomicInteger");
        }
    };

    public static void createTable(SQLDataSource ds, boolean dropTables) throws Exception {
        SQLTableCreator.createTable(ds, dropTables, false, true);
    }

    public static void createTable(SQLDataSource ds, boolean dropTables, boolean debug, boolean doWork) throws Exception {
        SQLTableCreator.createTable(ds, dropTables, debug, doWork, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(SQLDataSource ds, boolean dropTables, boolean debug, boolean doWork, boolean strictCreate) throws Exception {
        Map constraints;
        Connection conn = null;
        String dbURL = null;
        try {
            conn = SQLConnectionManager.getConnection(ds.getDriver().getDBName());
            dbURL = conn.getMetaData().getURL();
        }
        catch (Throwable throwable) {
            SQLConnectionManager.free(conn);
            throw throwable;
        }
        SQLConnectionManager.free(conn);
        DataTypeMap dsConfig = ds.getConfig();
        String databaseName = (String)dsConfig.get("dbName");
        if (databaseName == null) {
            databaseName = config.getString((Object)"sql.defaultDatabase");
        }
        if (databaseName == null) {
            throw new Exception("config file for datasource: " + ds.getName() + " does not define a database and no default has been specified in the master config file. Unable to continue");
        }
        if (config.getBoolean((Object)"wwwProduction", false) && !databaseName.equals("webdemos") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Refusing DataSource import for non-webdemos production table.");
        }
        if (dbURL != null && dbURL.contains("//www") && !dbURL.contains("-test") && !dbURL.contains("-staging") && !config.getBoolean((Object)"allowWWWProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production www data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWWWProductionDSImport: true in server.properties");
        }
        if (dbURL != null && dbURL.replace("_wrath", "_wr@th").contains("wrath") && !dbURL.contains(":oracle:") && !config.getBoolean((Object)"allowWrathProductionDSImport", false)) {
            throw new Exception("Processing DataSource '" + ds.getName() + "' would alter production wrath data (JDBC URL: " + dbURL + ") - cowardly refusing to process this DataSource - to  override, set allowWrathProductionDSImport: true in server.properties");
        }
        String tableName = ds.getTable().getNameQuotedIfNecessary(ds);
        tableName = SQLTableCreator.getSchemaPrefix((DataSource)ds) + tableName;
        String tableDrop = "DROP TABLE " + tableName;
        StringBuffer tableBuild = new StringBuffer();
        DBType dbType = ds.getDriver().getDBType();
        String dbName = ds.getDriver().getDBName();
        tableBuild.append("CREATE " + (dbType == DBType.HSQLDB ? "CACHED " : "") + "TABLE ");
        if (!strictCreate) {
            tableBuild.append("IF NOT EXISTS ");
        }
        tableBuild.append(tableName + " (");
        boolean gotColumn = false;
        LinkedHashSet noDups = new LinkedHashSet(ds.getFieldNames());
        for (String fieldName : noDups) {
            DSField field = ds.getField(fieldName);
            String fieldTable = (String)field.get((Object)"tableName");
            if (fieldTable != null && !fieldTable.equals(ds.getTable().getName())) continue;
            String columnName = ds.getColumnName(fieldName);
            String sqlColumn = SQLTableCreator.dsFieldToSQLColumn(ds, fieldName, dbName, dbType);
            if (sqlColumn == null) continue;
            if (gotColumn) {
                tableBuild.append(", ");
            }
            gotColumn = true;
            if ("%PUBLICROWID".equals(sqlColumn)) {
                tableBuild.append(sqlColumn);
                continue;
            }
            tableBuild.append(ds.escapeColumnName(columnName) + " " + sqlColumn);
        }
        if (!gotColumn) {
            throw new Exception("Empty table definition");
        }
        ArrayList primaryKeys = new ArrayList(ds.getPrimaryKeys());
        if (primaryKeys.size() > 0) {
            if (dbType == DBType.Cache || dbType == DBType.IRIS) {
                Iterator i = primaryKeys.iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    DSField dsField = ds.getField(key);
                    String nativeName = dsField.getNativeName();
                    if (nativeName == null) {
                        nativeName = key;
                    }
                    if (!nativeName.equals("ID") && !nativeName.equals("%ID")) continue;
                    i.remove();
                }
            }
            if (primaryKeys.size() > 0) {
                tableBuild.append(", " + SQLTableCreator.sqlForConstraint(ds, primaryKeys, "PRIMARY KEY", dbType));
            }
        }
        if ((constraints = (Map)dsConfig.get("unique")) != null) {
            for (String constraintID : constraints.keySet()) {
                Map constraint = (Map)constraints.get(constraintID);
                String constraintType = (String)constraint.get("type");
                if (constraintType == null) {
                    constraintType = "UNIQUE";
                }
                List constraintFields = (List)constraint.get("fields");
                String sqlConstraint = SQLTableCreator.sqlForConstraint(ds, constraintFields, constraintType, constraintID, dbType);
                tableBuild.append(", " + sqlConstraint);
            }
        }
        tableBuild.append(")");
        if (dbType != DBType.HSQLDB) {
            String tableCharacterSet;
            String tableCollation = ds.getConfig().getString((Object)"tableCollation");
            if (tableCollation != null) {
                tableBuild.append(" COLLATE " + tableCollation);
            }
            if ((tableCharacterSet = ds.getConfig().getString((Object)"tableCharacterSet")) != null) {
                tableBuild.append(" CHARACTER SET " + tableCharacterSet);
            }
        }
        if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
            boolean innoDB = config.getBoolean((Object)"sql.mysql.alwaysUseInnoDB");
            if (!innoDB && "true".equals(dsConfig.get("supportTransactions"))) {
                innoDB = true;
            }
            if (innoDB) {
                tableBuild.append(" ENGINE=InnoDB");
            }
        }
        if (debug && dropTables) {
            log.info((Object)("rebuilding table: " + tableName));
        }
        if (doWork && dropTables) {
            try {
                if (dbType == DBType.Oracle) {
                    tableDrop = tableDrop + " CASCADE CONSTRAINTS";
                }
                if (dbType == DBType.HSQLDB || dbType == DBType.PostgreSQL) {
                    tableDrop = tableDrop + " CASCADE";
                }
                if (debug) {
                    log.debug((Object)("issuing table drop command: " + tableDrop));
                }
                if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                    ds.executeNativeUpdate("SET foreign_key_checks = 0", null);
                } else if (dbType == DBType.SQLServer) {
                    ds.executeNativeUpdate("EXEC sp_msforeachtable \"ALTER TABLE ? NOCHECK CONSTRAINT all\"");
                }
                ds.executeNativeUpdate(tableDrop, null);
                log.warn((Object)"DROP TABLE COMPLETE");
            }
            catch (SQLException innoDB) {
                // empty catch block
            }
        }
        if (debug) {
            log.debug((Object)("issuing table create command: " + tableBuild));
        }
        if (doWork) {
            HashMap droppedFKs = new HashMap();
            if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                List fks = ds.executeNativeQuery("SELECT table_name, constraint_name FROM   information_schema.KEY_COLUMN_USAGE WHERE  referenced_table_name = '" + tableName + "'");
                for (int i = 0; i < fks.size(); ++i) {
                    Map record = (Map)fks.get(i);
                    if (droppedFKs.get(record.get("CONSTRAINT_NAME")) != null) continue;
                    droppedFKs.put(record.get("CONSTRAINT_NAME"), true);
                    try {
                        ds.executeNativeUpdate("ALTER TABLE " + record.get("TABLE_NAME") + " DROP FOREIGN KEY " + record.get("CONSTRAINT_NAME"));
                        continue;
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception while dropping remote foreign keys - ignoring", (Throwable)e);
                    }
                }
            }
            ds.executeNativeUpdate(tableBuild.toString(), null);
        }
        if (dbType == DBType.Oracle || dbType == DBType.PostgreSQL || dbType == DBType.Firebird || dbType == DBType.SQLServer && SQLServerDriver.useSequences((DataSource)ds)) {
            SQLTableCreator.buildSequences(ds, dropTables, doWork, debug, dbType);
        }
        if (doWork && "true".equals(dsConfig.get("createForeignKeys"))) {
            SQLTableCreator.createForeignKeys(ds, dbType);
        }
    }

    public static String dsFieldToSQLColumn(SQLDataSource ds, String fieldName, String dbName, DBType dbType) throws Exception {
        String sqlType;
        DSField field = ds.getField(fieldName);
        if (field.isDerived()) {
            return null;
        }
        if (ds.isPureInherited(field) && DataSource.DSInheritanceMode.NONE.equals((Object)ds.getInheritanceMode())) {
            return null;
        }
        if (field.getBoolean("customSQL")) {
            return null;
        }
        if (field.get((Object)"customSelectExpression") != null) {
            return null;
        }
        if (field.get((Object)"includeFrom") != null) {
            return null;
        }
        if (field.isInapplicable() || field.ignore()) {
            return null;
        }
        String type = field.getType();
        if (type == null || "".equals(type)) {
            type = "text";
        }
        String title = field.getTitle();
        long length = -1L;
        boolean boolInt = false;
        if (field.getLength() != null) {
            length = field.getLength();
        }
        if (type.equals("boolean") && (sqlType = field.getProperty("sqlStorageStrategy")) != null) {
            if (sqlType.equals("number") || sqlType.equals("integer")) {
                type = "integer";
                boolInt = true;
            } else if (sqlType.startsWith("singleChar")) {
                type = "text";
                length = 1L;
            }
        }
        String result = "";
        if (SQLDataSource.typeIsNumeric(type) && !SQLDataSource.typeIsDecimal(type)) {
            if (field.isMultiple() && (field.getProperty("sqlStorageStrategy") != null || field.getMultipleStorage() != null)) {
                String sqlType2 = field.getProperty("sqlStorageStrategy");
                if (sqlType2 == null) {
                    sqlType2 = "text";
                }
                if ("text".equals(sqlType2)) {
                    result = length > 0L ? result + "varchar(" + length + ")" : result + "varchar(255)";
                } else {
                    log.warn((Object)("sqlStorage specified for multiple field " + fieldName + " however is not 'text', but " + sqlType2 + " which is unhandled.Ignoring"));
                }
            } else {
                boolean isGeneratedOrKey;
                boolean bl = isGeneratedOrKey = "sequence".equals(type) || "integer".equals(type) && field.isAutoGenerated() || field.isPrimaryKey() || field.isForeignKey();
                if (!isGeneratedOrKey) {
                    if (boolInt) {
                        result = result + (dbType == DBType.Cache ? "number" : "integer");
                    } else if (dbType == DBType.Oracle) {
                        result = result + "integer";
                    } else if (dbType == DBType.Cache) {
                        result = result + "number";
                    } else if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                        result = result + "integer";
                    } else if (dbType == DBType.PostgreSQL) {
                        result = result + "bigint";
                    } else if (dbType == DBType.SQLServer) {
                        result = result + "bigint";
                    } else if (dbType == DBType.Firebird) {
                        result = result + "bigint";
                    } else if (dbType == DBType.Generic) {
                        result = result + "bigint";
                    } else if (dbType == DBType.DB2) {
                        result = result + "bigint";
                    } else if (dbType == DBType.HSQLDB) {
                        result = result + "integer";
                    } else if (dbType == DBType.IRIS) {
                        result = result + "bigint";
                    }
                    if (dbType == DBType.Informix && !boolInt) {
                        result = result + "int8";
                    }
                    if (!field.isPrimaryKey()) {
                        result = result + " default null";
                    }
                } else {
                    String sqlType3 = null;
                    String javaClass = field.getString((Object)"javaClass");
                    if (javaClass == null) {
                        String sequenceSize = config.getString((Object)("sql." + dbName + ".defaultKeySize"));
                        if (sequenceSize == null) {
                            sequenceSize = config.getString((Object)("sql." + (Object)((Object)dbType) + ".defaultKeySize"));
                        }
                        if (sequenceSize == null) {
                            sequenceSize = "large";
                        }
                        sequenceSize = sequenceSize.toUpperCase().substring(0, 1) + sequenceSize.substring(1);
                        javaClass = config.getString((Object)("sql." + dbName + ".javaTypeFor" + sequenceSize + "Key"));
                        if (javaClass == null) {
                            javaClass = config.getString((Object)("sql." + (Object)((Object)dbType) + ".javaTypeFor" + sequenceSize + "Key"));
                        }
                        if (javaClass == null) {
                            sequenceSize = "java.lang.Long";
                        }
                    }
                    sqlType3 = SQLTableCreator.sqlTypeForJavaClass(javaClass, dbType);
                    result = result + sqlType3;
                    if ("sequence".equals(type) || field.isAutoGenerated()) {
                        if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                            result = result + " auto_increment";
                        } else if (dbType == DBType.Oracle || dbType == DBType.PostgreSQL || dbType == DBType.Firebird) {
                            result = result + " default 0";
                        } else if (dbType == DBType.SQLServer) {
                            result = SQLServerDriver.useSequences((DataSource)ds) ? result + " default 0" : result + " identity (1, 1)";
                        } else if (dbType == DBType.DB2) {
                            result = result + " GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, CACHE 20)";
                        } else if (dbType == DBType.HSQLDB) {
                            result = result + " GENERATED BY DEFAULT AS IDENTITY(START WITH 1, INCREMENT BY 1)";
                        } else if (dbType == DBType.Informix) {
                            result = result + "serial8";
                        } else if (dbType == DBType.IRIS) {
                            result = "%PUBLICROWID";
                        }
                    }
                }
            }
        } else if (SQLDataSource.typeIsDecimal(type)) {
            if (field.isMultiple() && (field.getProperty("sqlStorageStrategy") != null || field.getMultipleStorage() != null)) {
                String sqlType4 = field.getProperty("sqlStorageStrategy");
                if (sqlType4 == null) {
                    sqlType4 = "text";
                }
                if ("text".equals(sqlType4)) {
                    result = length > 0L ? result + "varchar(" + length + ")" : result + "varchar(255)";
                } else {
                    log.warn((Object)("sqlStorage specified for multiple field " + fieldName + " however is not 'text', but " + sqlType4 + " which is unhandled.Ignoring"));
                }
            } else if (dbType == DBType.MySQL || dbType == DBType.MariaDB || dbType == DBType.DB2 || dbType == DBType.HSQLDB || dbType == DBType.Cache || dbType == DBType.IRIS) {
                result = result + "double default 0.0";
            } else if (dbType == DBType.PostgreSQL) {
                result = result + "real default 0.0";
            } else if (dbType == DBType.Oracle || dbType == DBType.SQLServer || dbType == DBType.Firebird || dbType == DBType.Generic || dbType == DBType.Informix) {
                result = result + "float default 0.0";
            }
        } else if (type.equals("date") || type.equals("datetime") || type.equals("time") || type.equals("modifierTimestamp") || type.equals("creatorTimestamp")) {
            String format;
            String sqlType5;
            boolean overridden = false;
            if (type.equals("date")) {
                sqlType5 = field.getProperty("sqlStorageStrategy");
                if (sqlType5 == null) {
                    log.debug((Object)("field " + field.getName() + " is date, sqlType is null, multipleStorage= " + field.getMultipleStorage() + "/" + field.getProperty("multipleStorage")));
                    if (field.getMultipleStorage() != null && field.isMultiple()) {
                        result = result + "varchar(";
                        result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                        result = result + ")";
                        overridden = true;
                    } else {
                        String defaultDateType = ds.getDriver().getSqlConfig().getString((Object)"defaultDateType");
                        if (defaultDateType != null) {
                            result = result + defaultDateType;
                            overridden = true;
                        }
                    }
                } else if (sqlType5.equals("nativeDate")) {
                    result = result + "date";
                    overridden = true;
                } else if (sqlType5.equals("number") || sqlType5.equals("integer")) {
                    if (dbType == DBType.Oracle || dbType == DBType.Cache) {
                        result = result + "number";
                    } else if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                        result = result + "integer";
                    } else if (dbType == DBType.PostgreSQL) {
                        result = result + "bigint";
                    } else if (dbType == DBType.SQLServer || dbType == DBType.Firebird || dbType == DBType.Generic) {
                        result = result + "bigint";
                    } else if (dbType == DBType.DB2) {
                        result = result + "bigint";
                    } else if (dbType == DBType.HSQLDB) {
                        result = result + "integer";
                    } else if (dbType == DBType.Informix) {
                        result = result + "int8";
                    } else if (dbType == DBType.IRIS) {
                        result = result + "bigint";
                    }
                    overridden = true;
                } else if (sqlType5.equals("text")) {
                    result = result + "varchar(";
                    format = field.getProperty("sqlDateFormat");
                    result = format == null ? (field.isMultiple() && field.getLength() != 0L ? result + field.getLength() : result + "10") : result + format.length();
                    result = result + ")";
                    overridden = true;
                } else {
                    result = result + sqlType5;
                    overridden = true;
                }
            }
            if (type.equals("datetime") || type.equals("modifierTimestamp") || type.equals("creatorTimestamp")) {
                type = "datetime";
                sqlType5 = field.getProperty("sqlStorageStrategy");
                if (sqlType5 != null) {
                    if (sqlType5.equals("number") || sqlType5.equals("integer")) {
                        if (dbType == DBType.Oracle || dbType == DBType.Cache) {
                            result = result + "number";
                        } else if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                            result = result + "bigint";
                        } else if (dbType == DBType.PostgreSQL) {
                            result = result + "bigint";
                        } else if (dbType == DBType.SQLServer) {
                            result = result + "bigint";
                        } else if (dbType == DBType.DB2) {
                            result = result + "bigint";
                        } else if (dbType == DBType.HSQLDB) {
                            result = result + "bigint";
                        } else if (dbType == DBType.Firebird) {
                            result = result + "bigint";
                        } else if (dbType == DBType.Generic) {
                            result = result + "bigint";
                        } else if (dbType == DBType.Informix) {
                            result = result + "int8";
                        }
                        overridden = true;
                    } else if (sqlType5.equals("text")) {
                        result = result + "varchar(";
                        format = field.getProperty("sqlDateFormat");
                        result = format == null ? (field.isMultiple() && field.getLength() != 0L ? result + field.getLength() : result + "23") : result + format.length();
                        result = result + ")";
                        overridden = true;
                    }
                } else if (field.getMultipleStorage() != null && field.isMultiple()) {
                    result = result + "varchar(";
                    result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                    result = result + ")";
                    overridden = true;
                }
            }
            if (type.equals("time") && field.isMultiple()) {
                sqlType5 = field.getProperty("sqlStorageStrategy");
                if (sqlType5 != null) {
                    result = result + sqlType5;
                    overridden = true;
                } else {
                    sqlType5 = "text";
                    result = result + "varchar(";
                    result = field.getLength() != null && field.getLength() > 0L ? result + field.getLength() : result + "256";
                    result = result + ")";
                    overridden = true;
                }
            }
            if (!overridden) {
                if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                    result = result + type;
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds() && ds.getDriver().supportsMilliseconds()) {
                        result = result + "(3)";
                    }
                } else if (dbType == DBType.HSQLDB && !"time".equals(type)) {
                    result = result + type;
                } else if (dbType == DBType.SQLServer) {
                    result = result + "datetime";
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds() && ds.getDriver().supportsMilliseconds()) {
                        result = result + "2(3)";
                    }
                } else if (dbType == DBType.Oracle && !"datetime".equals(type)) {
                    result = result + "date";
                } else if (dbType == DBType.HSQLDB || dbType == DBType.PostgreSQL || dbType == DBType.DB2 || dbType == DBType.Cache || dbType == DBType.Firebird || dbType == DBType.Generic || dbType == DBType.Oracle || dbType == DBType.IRIS) {
                    result = result + "timestamp";
                    if ("datetime".equals(type) && field.shouldStoreMilliseconds() && ds.getDriver().supportsMilliseconds() && (dbType == DBType.PostgreSQL || dbType == DBType.Oracle)) {
                        result = result + "(3)";
                    }
                } else if (dbType == DBType.Informix) {
                    result = result + "datetime YEAR to ";
                    result = "datetime".equals(type) && field.shouldStoreMilliseconds() && ds.getDriver().supportsMilliseconds() ? result + "FRACTION(3)" : result + "SECOND";
                }
            }
        } else if (type.equals("jsonb")) {
            result = result + "jsonb";
        } else if (type.equals("json")) {
            result = result + "json";
        } else if (type.equals("binary") || type.equals("blob") || type.equals("imageFile")) {
            if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                result = result + "longblob";
            } else if (dbType == DBType.PostgreSQL) {
                result = result + "bytea";
            } else if (dbType == DBType.Oracle || dbType == DBType.DB2) {
                result = result + "blob";
            } else if (dbType == DBType.Cache) {
                result = result + "binary";
            } else if (dbType == DBType.HSQLDB) {
                result = result + "blob(1G)";
            } else if (dbType == DBType.SQLServer) {
                result = result + "image";
            } else if (dbType == DBType.Firebird) {
                result = result + "BLOB";
            } else if (dbType == DBType.Generic) {
                result = result + config.getString((Object)"sql.generic.binary.type");
            } else if (dbType == DBType.Informix) {
                result = result + "blob";
            } else if (dbType == DBType.IRIS) {
                result = length <= 3641144L ? result + "varbinary('')" : result + "longvarbinary";
            }
        } else {
            if (type.equals("boolean")) {
                type = "text";
                if (length < 6L) {
                    length = 6L;
                }
            }
            if (type.equals("creator") || type.equals("modifier")) {
                type = "text";
            }
            if (!type.equals("text") && !type.equals("string")) {
                log.warn((Object)("Unrecognized type: '" + type + "' in datasource: " + ds.getName() + " mapping to type text."));
                type = "text";
            }
            if (length == -1L) {
                length = 255L;
            }
            if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                if (length <= 255L) {
                    result = result + "varchar(" + length + ")";
                } else if (length <= 65535L) {
                    result = result + "text";
                } else if (length <= 0xFFFFFFL) {
                    result = result + "mediumtext";
                } else if (length <= 0xFFFFFFFFL) {
                    result = result + "longtext";
                }
            } else {
                result = dbType == DBType.Oracle || dbType == DBType.DB2 ? (length <= 4000L && !type.equals("clob") ? result + "varchar(" + length + ")" : result + "clob") : (dbType == DBType.PostgreSQL ? (length <= 4000L ? result + "varchar(" + length + ")" : result + "text") : (dbType == DBType.SQLServer ? (length <= 8000L ? result + "varchar(" + length + ")" : result + "text") : (dbType == DBType.HSQLDB ? result + "varchar_ignorecase(" + length + ")" : (dbType == DBType.Firebird ? (length <= 32767L ? result + "varchar(" + length + ")" : result + "BLOB SUB_TYPE 1") : (dbType == DBType.Informix ? (length <= 255L ? result + "varchar(" + length + ")" : (length < 32739L ? result + "lvarchar(" + length + ")" : result + "text")) : (dbType == DBType.IRIS ? (length <= 3641144L ? result + "varchar('')" : result + "longvarchar") : result + "varchar(" + length + ")"))))));
            }
            if (field.isPrimaryKey() || field.isRequired()) {
                if (dbType == DBType.Cache) {
                    result = result + " default \"\"";
                } else if (dbType != DBType.MySQL && dbType != DBType.MariaDB || length <= 255L) {
                    result = result + " default ''";
                }
            }
        }
        if (field.isPrimaryKey() && (dbType == DBType.MySQL || dbType == DBType.MariaDB || dbType == DBType.DB2) || field.getBoolean("defineSQLColumnAsNotNull")) {
            result = result + " not null";
        }
        return result;
    }

    private static String sqlTypeForJavaClass(String javaClass, DBType dbType) {
        return smallIntTypes.contains(javaClass) || dbType == DBType.Oracle ? "INTEGER" : "BIGINT";
    }

    private static String sqlForConstraint(SQLDataSource ds, List fieldNames, String constraintType, DBType dbType) throws Exception {
        return SQLTableCreator.sqlForConstraint(ds, fieldNames, constraintType, null, dbType);
    }

    private static String sqlForConstraint(SQLDataSource ds, List fieldNames, String constraintType, String constraintName, DBType dbType) throws Exception {
        if (constraintName == null) {
            constraintName = SQLTableCreator.indexNameForTable(ds.getTable().getName(), dbType);
        }
        log.debug((Object)("Creating constraint of type " + constraintType + " on fields " + fieldNames));
        String constraint = dbType != DBType.Informix ? "CONSTRAINT " + ds.escapeColumnName(constraintName) + " " + constraintType + " (" : constraintType + " (";
        Iterator e = fieldNames.iterator();
        while (e.hasNext()) {
            String fieldName = (String)e.next();
            String columnName = ds.getColumnName(fieldName);
            if (columnName.contains(".")) {
                columnName = columnName.substring(columnName.lastIndexOf(".") + 1);
            }
            constraint = constraint + ds.escapeColumnName(columnName);
            if (!e.hasNext()) continue;
            constraint = constraint + ", ";
        }
        constraint = constraint + ")";
        if (dbType == DBType.Informix) {
            constraint = constraint + " CONSTRAINT " + ds.escapeColumnName(constraintName);
        }
        return constraint;
    }

    private static void buildSequences(SQLDataSource ds, boolean dropTables, boolean doWork, boolean debug, DBType dbType) throws Exception {
        Map sequences = ds.getTable().getSequences();
        for (String columnName : sequences.keySet()) {
            String sequenceCreate;
            String sequenceName;
            block13: {
                block12: {
                    sequenceName = SQLDriver.getSequenceName(columnName, sequences, ds.getTable().getName(), ds.getDriver());
                    sequenceName = SQLTableCreator.getSchemaPrefix((DataSource)ds) + sequenceName;
                    sequenceCreate = "CREATE SEQUENCE " + sequenceName;
                    if (dbType == DBType.Oracle) break block12;
                    if (dbType == DBType.DB2) break block12;
                    if (dbType != DBType.SQLServer) break block13;
                }
                sequenceCreate = sequenceCreate + " INCREMENT BY 1 START WITH 1";
            }
            if (dbType == DBType.PostgreSQL) {
                sequenceCreate = sequenceCreate + " INCREMENT 1 START 1";
            }
            if (debug) {
                log.debug((Object)("creating sequence named: " + sequenceName + " for column: " + columnName));
            }
            if (!doWork) {
                log.debug((Object)("create command: " + sequenceCreate));
                continue;
            }
            try {
                ds.executeNativeUpdate(sequenceCreate, null);
            }
            catch (SQLException se) {
                if (!dropTables) continue;
                try {
                    if (debug) {
                        log.debug((Object)"sequence exists, destroying and re-creating...");
                    }
                    ds.executeNativeUpdate("DROP SEQUENCE " + sequenceName, null);
                    ds.executeNativeUpdate(sequenceCreate, null);
                }
                catch (SQLException se2) {
                    log.debug((Object)("unable to create sequence: " + sequenceName));
                    throw se;
                }
            }
        }
    }

    private static void createForeignKeys(SQLDataSource ds, DBType dbType) throws Exception {
        String tableName;
        LinkedHashMap fks = new LinkedHashMap();
        Iterator i = ds.getFieldNames().iterator();
        while (i.hasNext()) {
            String[] fkElems;
            DSField field = ds.getField((String)i.next());
            String fkDec = field.getForeignKey();
            if (fkDec == null || (fkElems = fkDec.split("\\.")).length != 2) continue;
            if (!fks.containsKey(fkElems[0])) {
                fks.put(fkElems[0], new ArrayList());
            }
            List keyFields = (List)fks.get(fkElems[0]);
            HashMap<String, String> keyField = new HashMap<String, String>();
            keyField.put("from", field.getName());
            keyField.put("to", fkElems[1]);
            keyFields.add(keyField);
        }
        if (fks.keySet().size() == 0) {
            return;
        }
        if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
            ds.executeNativeUpdate("SET foreign_key_checks = 0");
        }
        if ((tableName = (String)ds.getConfig().get((Object)"tableName")) == null) {
            tableName = ds.getID();
        }
        for (String dsName : fks.keySet()) {
            String sql;
            DataSource work = DataSourceManager.get((String)dsName);
            if (!(work instanceof SQLDataSource)) continue;
            SQLDataSource related = (SQLDataSource)work;
            String relatedTableName = (String)related.getConfig().get((Object)"tableName");
            if (relatedTableName == null) {
                relatedTableName = related.getID();
            }
            List keyFields = (List)fks.get(dsName);
            String fromList = "";
            String toList = "";
            String firstField = null;
            for (Map keyField : keyFields) {
                String from = (String)keyField.get("from");
                String to = (String)keyField.get("to");
                from = (String)ds.ds2NativeFieldMap().get(from);
                if (from.contains(".")) {
                    from = from.substring(from.lastIndexOf(".") + 1);
                }
                if ((to = (String)related.ds2NativeFieldMap().get(to)).contains(".")) {
                    to = to.substring(to.lastIndexOf(".") + 1);
                }
                if (firstField == null) {
                    firstField = from;
                }
                from = ds.escapeColumnName(from);
                to = related.escapeColumnName(to);
                if (!"".equals(fromList)) {
                    fromList = fromList + ", ";
                    toList = toList + ", ";
                }
                fromList = fromList + from;
                toList = toList + to;
            }
            String hashCode = Integer.toHexString((tableName + relatedTableName).hashCode());
            if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
                sql = "ALTER TABLE " + tableName + " ADD INDEX ";
                sql = sql + "IX_" + hashCode;
                sql = sql + " (" + fromList + ")";
                ds.executeNativeUpdate(sql);
            }
            sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT ";
            if (dbType != DBType.Informix) {
                sql = sql + "FK_" + hashCode;
            }
            sql = sql + " FOREIGN KEY (" + fromList + ")";
            sql = sql + " REFERENCES " + relatedTableName + " (" + toList + ")";
            if (dbType == DBType.Informix) {
                sql = sql + " CONSTRAINT FK_" + hashCode;
            }
            ds.executeNativeUpdate(sql);
        }
        if (dbType == DBType.MySQL || dbType == DBType.MariaDB) {
            ds.executeNativeUpdate("SET foreign_key_checks = 1");
        }
    }

    private static String getSchemaPrefix(DataSource ds) {
        if (config.getBoolean((Object)"sql.applySchemaToTableCreate", true) && ds.getSchemaName() != null) {
            return ds.getSchemaName() + ".";
        }
        return "";
    }

    private static String indexNameForTable(String tableName, DBType dbType) {
        if (dbType == DBType.DB2 && tableName.length() > 15) {
            tableName = tableName.substring(0, 15);
        }
        return tableName + "_UI";
    }
}

