/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.AwsHelper;
import com.isomorphic.autotest.BatchRunDao;
import com.isomorphic.autotest.BuilderSpecifier;
import com.isomorphic.autotest.ConfiguredBase;
import com.isomorphic.autotest.LastPassBatchDao;
import com.isomorphic.autotest.ShowcaseSpecifier;
import com.isomorphic.autotest.TestResultDao;
import com.isomorphic.autotest.TestRunner;
import com.isomorphic.autotest.TestRunnerLauncher;
import com.isomorphic.autotest.model.TestResult;
import com.isomorphic.base.ISCInit;
import com.isomorphic.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

public class HistoryAnalyzer
extends ConfiguredBase {
    private static Logger log = new Logger(HistoryAnalyzer.class.getName());
    private static final int ANALYZE_SEARCH_DEPTH = 50;

    private static void analyzeBatch(final Date batchStartTime, String branch, boolean sourceCommit) throws Exception {
        List<String> suiteNames;
        List<Date> commits = BatchRunDao.getBatchTimes(branch, null);
        CollectionUtils.filter(commits, (Predicate)new Predicate(){

            public boolean evaluate(Object commit) {
                return batchStartTime.after((Date)commit);
            }
        });
        if (sourceCommit) {
            suiteNames = ShowcaseSpecifier.getValidShowcases(branch, null);
            suiteNames.addAll(BuilderSpecifier.getCommitBuilders(branch, null));
        } else {
            suiteNames = BuilderSpecifier.getScheduledBuilders(branch, null);
        }
        for (int i = 0; i < suiteNames.size(); ++i) {
            String suiteName = suiteNames.get(i);
            List<TestResult> results = TestResultDao.getTestsForBatch(batchStartTime, suiteName, branch);
            Map<String, TestResult> resultMap = TestRunner.processBatch(results);
            results = new ArrayList<TestResult>(resultMap.values());
            LastPassBatchDao.updateLastPass(results);
            LastPassBatchDao.updateCountState(results);
            LastPassBatchDao.fetchLastPass(results);
            TestRunner.addHistoryForChanges(BatchRunDao.getPredecessorBatchStartTime(batchStartTime, branch), suiteName, branch, config.getHistoryDepth(), results, true);
            TestResultDao.addHistory(results);
        }
        BatchRunDao.setBatchAsAnalyzed(batchStartTime);
    }

    private static void analyzeBatches(boolean sourceCommit) throws Exception {
        log.info((Object)"running history analysis on validated batches");
        List<Date> commits = BatchRunDao.getBatchTimes(null, null);
        int nCommitsToSearch = Math.min(commits.size(), 50);
        commits = commits.subList(0, nCommitsToSearch);
        Collections.reverse(commits);
        for (int i = 0; i < commits.size(); ++i) {
            Date batchStartTime = commits.get(i);
            if (!BatchRunDao.isBatchValidated(batchStartTime) || BatchRunDao.isBatchAnalyzed(batchStartTime)) continue;
            String branch = BatchRunDao.getBranch(batchStartTime);
            log.info((Object)("analyzing batch " + batchStartTime + " for branch " + branch));
            HistoryAnalyzer.analyzeBatch(batchStartTime, branch, sourceCommit);
        }
    }

    public static void main(String[] args) throws Exception {
        ISCInit.go((String)AwsHelper.class.getName());
        TestRunnerLauncher config = new TestRunnerLauncher();
        TestRunner.setConfiguration(config);
        config.setHistoryDepth(50);
        config.initFileRoot();
        try {
            HistoryAnalyzer.analyzeBatches(true);
        }
        catch (Exception e) {
            log.error((Object)"Commit batch analysis encountered an unexpected error", (Throwable)e);
        }
        TestRunnerLauncher.startReifyCloudBatch();
        try {
            HistoryAnalyzer.analyzeBatches(false);
        }
        catch (Exception e) {
            log.error((Object)"Scheduled batch analysis encountered an unexpected error", (Throwable)e);
        }
        finally {
            TestRunnerLauncher.endReifyCloudBatch();
        }
    }
}

