package com.smartgwt.sample.showcase.client.dataintegration.java.serversummaries;

import java.util.HashMap;
import java.util.Map;

import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.types.SummaryFunctionType;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.SelectItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.layout.VStack;
import com.smartgwt.sample.showcase.client.PanelFactory;
import com.smartgwt.sample.showcase.client.ShowcasePanel;
import com.smartgwt.sample.showcase.client.SourceEntity;

public class DynamicAggregationSample extends ShowcasePanel {

    private static final String DESCRIPTION =
        "Server summaries may be requested directly from the client by setting <code>dsRequest.groupBy</code> and <code>dsRequest.summaryFunctions</code>\r" +
        "when performing a fetch.\r" +
        "<p>\r" +
        "This sample demonstrates the same server-side data summarization as the \"<code>Basic Aggregation</code>\" sample, but in this\r" +
        "case the DataSource has no <code>operationBindings</code> defined. The aggregation behavior is requested \r" +
        "dynamically from the client.";    

    public static class Factory implements PanelFactory {
        private String id;

        public ShowcasePanel create() {
        	DynamicAggregationSample panel = new DynamicAggregationSample();
            id = panel.getID();
            return panel;
        }

        public String getID() {
            return id;
        }

        public String getDescription() {
            return DESCRIPTION;
        }
    }

    protected boolean isTopIntro() {
        return true;
    }

    public Canvas getViewPanel() {

    	final ListGrid orderItemList = new ListGrid();
    	orderItemList.setDataSource(DataSource.get("dynamicAggregation_orderItem"));
    	orderItemList.setWidth(500);
    	orderItemList.setHeight(300);
    	orderItemList.setShowFilterEditor(true);
    	orderItemList.setAlternateRecordStyles(true);
    	orderItemList.setAutoFetchData(false);
    	orderItemList.setCanEdit(false);
    	orderItemList.setCanRemoveRecords(false);
    	
    	ListGridField orderCustomerName = new ListGridField("orderCustomerName");
    	orderCustomerName.setHidden(true);
    	orderCustomerName.setTitle("Customer name");
    	ListGridField itemDescription = new ListGridField("itemDescription");
    	ListGridField unitPrice = new ListGridField("unitPrice");
    	unitPrice.setType(ListGridFieldType.FLOAT);
    	unitPrice.setHidden(true);
    	ListGridField amount = new ListGridField("amount");
    	amount.setType(ListGridFieldType.INTEGER);
    	ListGridField pk = new ListGridField("pk");
    	pk.setTitle("Count");
    	
    	orderItemList.setFields(orderCustomerName,itemDescription,unitPrice,amount,pk);    	
    	
    	DSRequest dsProperties = new DSRequest();
    	Map<String,SummaryFunctionType> summaryFunctions = new HashMap<String,SummaryFunctionType>();
		summaryFunctions.put("pk", SummaryFunctionType.COUNT);
		summaryFunctions.put("amount", SummaryFunctionType.SUM);
		dsProperties.setSummaryFunctions(summaryFunctions);
		dsProperties.setGroupBy("itemDescription");
		orderItemList.fetchData(null, null, dsProperties);
		
        DynamicForm operationForm = new DynamicForm();
        operationForm.setWidth(300);
        
        SelectItem operationId = new SelectItem();
        operationId.setDefaultToFirstOption(true);
        operationId.setTitle("Aggregation");
        
        Map<String,String> valueMap = new HashMap<String,String>();
        valueMap.put("amountByItem", "Amount by item");
        valueMap.put("amountByCustomer", "Amount by customer");
        valueMap.put("minPriceByItem", "Minimum price by item");
        valueMap.put("maxPriceByItem", "Maximum price by item");
        
        operationId.setValueMap(valueMap);
        operationId.addChangedHandler(new ChangedHandler() {
			@Override
			public void onChanged(ChangedEvent event) {
				String value = event.getValue().toString();
				DSRequest requestProperties = new DSRequest();
				orderItemList.setData(new ListGridRecord[0]);
				Map<String,SummaryFunctionType> summaryFunctions = new HashMap<String,SummaryFunctionType>();
				summaryFunctions.put("pk", SummaryFunctionType.COUNT);
				if (value.equals("amountByItem")) {
					summaryFunctions.put("amount", SummaryFunctionType.SUM);
					requestProperties.setGroupBy("itemDescription");
                } else if (value.equals("amountByCustomer")) {
					summaryFunctions.put("amount", SummaryFunctionType.SUM);
					requestProperties.setGroupBy("orderCustomerName");
                } else if (value.equals("minPriceByItem")) {
					summaryFunctions.put("unitPrice", SummaryFunctionType.MIN);
					requestProperties.setGroupBy("itemDescription");
                } else {
					summaryFunctions.put("unitPrice", SummaryFunctionType.MAX);
					requestProperties.setGroupBy("itemDescription");
                }
				requestProperties.setSummaryFunctions(summaryFunctions);
				orderItemList.fetchData(null, null, requestProperties);
				
                if (value.endsWith("ByItem")) {
                    orderItemList.hideField("orderCustomerName");
                    orderItemList.showField("itemDescription");
                } else {
                    orderItemList.showField("orderCustomerName");
                    orderItemList.hideField("itemDescription");
                }
                if (value.startsWith("amount")) {
                    orderItemList.hideField("unitPrice");
                    orderItemList.showField("amount");
                } else {
                    orderItemList.showField("unitPrice");
                    orderItemList.hideField("amount");
                }
			}
        });
        operationForm.setFields(operationId);
        		
        VStack vStack = new VStack();
        vStack.setWidth100();
        vStack.setMembersMargin(10);
        vStack.setMembers(operationForm,orderItemList);
        
        return vStack;
    }


    public String getIntro() {
        return DESCRIPTION;
    }

    public SourceEntity[] getSourceUrls() {
        return new SourceEntity[] {
            new SourceEntity("dynamicAggregation_order.ds.xml", XML, "source/dynamicAggregation_order.ds.xml.html", true)
        };
    }
}
