/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.log.Logger;
import com.isomorphic.util.AtomicFileWriter;
import com.isomorphic.util.AutoConfigurableExecutable;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ISCSystem;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;

public class ExecDataSource
extends BasicDataSource {
    private static Logger log = new Logger(ExecDataSource.class.getName());

    @Override
    public void init(Map theConfig, DSRequest dsRequest) throws Exception {
        super.init(theConfig, dsRequest);
    }

    @Override
    public DSResponse executeFetch(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeUpdate(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeAdd(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeRemove(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeCustom(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeReplace(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    @Override
    public DSResponse executeDownload(DSRequest dsRequest) throws Exception {
        return this.processRequest(dsRequest);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DSResponse processRequest(DSRequest dsRequest) throws Exception {
        String recordXPath;
        void var11_15;
        ISCSystem iscSystem;
        Object outboundData;
        DataTypeMap serverConfig = this.getServerConfig(dsRequest);
        if (serverConfig == null) {
            throw new Exception("You must define a serverConfig");
        }
        String dataFormat = serverConfig.getString("dataFormat", "json");
        String requestTemplate = serverConfig.getString("requestTemplate");
        if (requestTemplate != null) {
            requestTemplate = requestTemplate.trim();
            if (!dataFormat.equals("json")) throw new Exception("dataFormat: " + dataFormat + " is not supported");
            outboundData = JSTranslater.instance().fromJS(requestTemplate);
        } else {
            outboundData = new HashMap();
        }
        outboundData = this.setProperties(dsRequest.getValues(), outboundData, dsRequest);
        log.warn(DataTools.prettyPrint(outboundData));
        AutoConfigurableExecutable ace = new AutoConfigurableExecutable();
        DataTools.setProperties((Map)((Object)serverConfig), ace);
        String requestFile = serverConfig.getString("requestFile");
        if ("stdin".equals(requestFile) || requestFile == null) {
            iscSystem = ace.execute();
            if ("stdin".equals(requestFile)) {
                PrintStream stdin = iscSystem.getProcessStdin();
                if (!dataFormat.equals("json")) throw new Exception("dataFormat: " + dataFormat + " is not supported");
                JSTranslater.instance().strictJSONMode().toJS(outboundData, new PrintWriter(stdin));
            }
            iscSystem = ace.execute();
        } else {
            if (!dataFormat.equals("json")) {
                throw new Exception("dataFormat: " + dataFormat + " is not supported");
            }
            AtomicFileWriter writer = new AtomicFileWriter(requestFile);
            JSTranslater.instance().strictJSONMode().toJS(outboundData, (Writer)((Object)writer));
            writer.close();
            iscSystem = ace.execute();
        }
        int exitValue = iscSystem.waitFor().exitValue();
        DSResponse dsResponse = new DSResponse(this);
        if (exitValue != 0) {
            dsResponse.setFailure();
            dsResponse.setData(iscSystem.getFormattedErrorString());
            return dsResponse;
        }
        dsResponse.setSuccess();
        Object var11_12 = null;
        String responseFile = serverConfig.getString("responseFile");
        if ("stdout".equals(responseFile)) {
            StringReader stringReader = new StringReader(iscSystem.getStdout());
        } else if (responseFile != null) {
            Reader reader = ISCFile.newInstance(responseFile).getReader();
        }
        Object data = null;
        if (var11_15 != null) {
            if (!dataFormat.equals("json")) throw new Exception("dataFormat: " + dataFormat + " is not supported");
            data = JSTranslater.instance().fromJS((Reader)var11_15);
        }
        if ((recordXPath = serverConfig.getString("recordXPath")) != null) {
            JXPathContext context = JXPathContext.newContext((Object)data);
            data = context.getValue(recordXPath);
        }
        dsResponse.setData(DataTools.makeListIfSingle(data));
        return dsResponse;
    }
}

