/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.form.fields;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * (SSI for short) Provides a UI for creating, editing and applying saved searches for a {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent target} using the {@link
 * com.smartgwt.client.data.SavedSearches} system. <p> Normally, a <code>SavedSearchItem</code> is just provided a {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent}, and all other configuration
 * comes from the central {@link com.smartgwt.client.data.SavedSearches} class by default.  The
 * <code>targetComponent</code> must be a {@link com.smartgwt.client.widgets.DataBoundComponent} with a {@link
 * com.smartgwt.client.widgets.DataBoundComponent#getDataSource DataSource configured}. <p> Searches are applied to the
 * target by calling {@link com.smartgwt.client.widgets.DataBoundComponent#fetchData DataBoundComponent.fetchData()}, or,
 * for ListGrids, by calling {@link com.smartgwt.client.widgets.grid.ListGrid#setViewState ListGrid.setViewState()}.  If
 * {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getSaveLastSearch saveLastSearch} is set, the name of the
 * last search is automatically stored in browser <code>localStorage</code>, and will be applied to the
 * <code>targetComponent</code> as soon as saved searches are loaded. <p> By default, <code>SavedSearchItem</code> acquires
 * the {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource default DataSource for storing searches} and uses
 * it as {@link com.smartgwt.client.widgets.form.fields.SelectItem#getOptionDataSource SelectItem.optionDataSource}.  The
 * displayed value is the user's name for the search (from {@link com.smartgwt.client.data.SavedSearches#getSearchNameField
 * SavedSearches.searchNameField}) followed by a user-readable summary of the stored search, derived from {@link
 * com.smartgwt.client.data.DataSource#getAdvancedCriteriaDescription DataSource.getAdvancedCriteriaDescription()}, with a
 * hover to show long values that may be clipped. <p> If {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanAddSearch adding searches is allowed}, the
 * <code>SavedSearchItem</code> either shows a {@link com.smartgwt.client.widgets.form.fields.FormItemIcon} ({@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAddSearchIcon addSearchIcon}) or a pickList entry for adding
 * searches ({@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAddSearchValue addSearchValue}).  Either
 * interface opens an {@link com.smartgwt.client.widgets.EditSearchWindow}. <p> The PickList is automatically configured to
 * show the search name plus the search description (via {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getPickListFields pickListFields}), plus additional columns for
 * icons for  {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getEditSearchField editing}, {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getRemoveSearchField removal}, {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCopySearchField copying existing searches}, and {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getMarkAsDefaultField choosing a default search}. <p>
 * Admin-configured searches are displayed after user-created searches, after a {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAdminSeparatorRecord separator}. <p> {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#searchChanged searchChanged()} fires when the user selects a new
 * saved search, saves changes to an existing saved search, or saves a new search.  Note that {@link
 * com.smartgwt.client.widgets.form.fields.SelectItem#getValueField valueField} is set to {@link
 * com.smartgwt.client.data.SavedSearches#getComponentIdField SavedSearches.componentIdField} and {@link
 * com.smartgwt.client.widgets.form.fields.SelectItem#getDisplayField displayField} to {@link
 * com.smartgwt.client.data.SavedSearches#getSearchNameField SavedSearches.searchNameField}. <p> Saving new searches also
 * causes {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetDataSource targetDataSource} to be
 * required.  You can set {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getNewRecordValues
 * newRecordValues} to a set of fixed values that should be saved whenever the user saves a new search; this can be used to
 * save searches related to the current user's userId, for example. <p> The special interface that allows an admin to save
 * shared searches appears if the user has the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAdminRole
 * adminRole} as determined by {@link com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()}. <p>
 * <h3>Saving full "viewState" for grids</h3> <p> If the {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent} is a {@link
 * com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid},  the default behavior
 * is to store the complete {@link com.smartgwt.client.widgets.grid.ListGrid#getViewState ListGrid.viewState} rather that
 * just search criteria.  If you want to store just criteria, set {@link
 * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getStoredState storedState} to "criteria". <p> <b>Note:</b> this
 * feature requires <a href='https://www.smartclient.com/product/' target='_blank'>Smart GWT Pro</a> or better.
 */
@BeanFactory.FrameworkClass
public class SavedSearchItem extends SelectItem {

    public static SavedSearchItem getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof SavedSearchItem) {
            existingObj.setJsObj(jsObj);
            return (SavedSearchItem)existingObj;
        } else

        {
            return new SavedSearchItem(jsObj);
        }
    }
        


    /**
     * Changes the defaults for Canvas AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults Canvas defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, Canvas defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.BaseWidget::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SavedSearchItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "Canvas");
        }
        defaults.@com.smartgwt.client.widgets.BaseWidget::setConfigOnly(Z)(true);
        var cleanDefaultsJS = @com.smartgwt.client.util.JSOHelper::cleanProperties(Lcom/google/gwt/core/client/JavaScriptObject;Z)(defaults.@com.smartgwt.client.widgets.BaseWidget::getConfig()(), true);
        $wnd.isc.SavedSearchItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    /**
     * Changes the defaults for FormItem AutoChildren named <code>autoChildName</code>.
     *
     * @param autoChildName name of an AutoChild to customize the defaults for.
     * @param defaults FormItem defaults to apply. These defaults override any existing properties
     * without destroying or wiping out non-overridden properties.  For usage tips on this
     * param, see {@link com.smartgwt.client.docs.SGWTProperties}.
     * @see com.smartgwt.client.docs.AutoChildUsage
     */
    public static native void changeAutoChildDefaults(String autoChildName, FormItem defaults) /*-{
        if (defaults.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)(SavedSearchItem.@java.lang.Object::getClass()(), "changeAutoChildDefaults", "FormItem");
        }
        defaults.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var cleanDefaultsJS = defaults.@com.smartgwt.client.widgets.form.fields.FormItem::getEditorTypeConfig()();
        $wnd.isc.SavedSearchItem.changeDefaults(autoChildName + "Defaults", cleanDefaultsJS);
    }-*/;

    public static native void changePickerIconDefaults(FormItemIcon defaults) /*-{
        $wnd.isc.SavedSearchItem.changeDefaults("pickerIconDefaults", defaults.@com.smartgwt.client.core.DataClass::getJsObj()());
    }-*/;

    public SavedSearchItem(){
        setAttribute("editorType", "SavedSearchItem");
    }

    public SavedSearchItem(JavaScriptObject jsObj){
        super(jsObj);
    }


    public SavedSearchItem(String name) {
        setName(name);
                setAttribute("editorType", "SavedSearchItem");
    }


    public SavedSearchItem(String name, String title) {
        setName(name);
		setTitle(title);
                setAttribute("editorType", "SavedSearchItem");
    }


    // ********************* Properties / Attributes ***********************

    /**
     * Icon to be used to show the {@link com.smartgwt.client.widgets.EditSearchWindow}.
     *
     * @param addSearchIcon New addSearchIcon value. Default value is "[SKINIMG]actions/add.png"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public SavedSearchItem setAddSearchIcon(String addSearchIcon) {
        return (SavedSearchItem)setAttribute("addSearchIcon", addSearchIcon);
    }

    /**
     * Icon to be used to show the {@link com.smartgwt.client.widgets.EditSearchWindow}.
     *
     * @return Current addSearchIcon value. Default value is "[SKINIMG]actions/add.png"
     * @see com.smartgwt.client.docs.SCImgURL SCImgURL 
     */
    public String getAddSearchIcon()  {
        return getAttributeAsString("addSearchIcon");
    }
    

    /**
     * Setting this property moves the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanAddSearch
     * canAddSearch} functionality from an icon next to the form item ({@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAddSearchIcon addSearchIcon}) to the dropdown. When set, the
     * SavedSearchItem will look for this value in {@link com.smartgwt.client.widgets.form.fields.SelectItem#getSpecialValues
     * specialValues} and use it as the trigger action for {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanAddSearch canAddSearch}.
     *
     * @param addSearchValue New addSearchValue value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setAddSearchValue(String addSearchValue) {
        return (SavedSearchItem)setAttribute("addSearchValue", addSearchValue);
    }

    /**
     * Setting this property moves the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanAddSearch
     * canAddSearch} functionality from an icon next to the form item ({@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getAddSearchIcon addSearchIcon}) to the dropdown. When set, the
     * SavedSearchItem will look for this value in {@link com.smartgwt.client.widgets.form.fields.SelectItem#getSpecialValues
     * specialValues} and use it as the trigger action for {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanAddSearch canAddSearch}.
     *
     * @return Current addSearchValue value. Default value is null
     */
    public String getAddSearchValue()  {
        return getAttributeAsString("addSearchValue");
    }
    

    /**
     * Role to check for (via {@link com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()} to determine
     * whether admin interfaces are shown. If not explicitly set, at initialization time this will be defaulted to {@link
     * com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole}.
     *
     * @param adminRole New adminRole value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setAdminRole(String adminRole) {
        return (SavedSearchItem)setAttribute("adminRole", adminRole);
    }

    /**
     * Role to check for (via {@link com.smartgwt.client.util.Authentication#hasRole Authentication.hasRole()} to determine
     * whether admin interfaces are shown. If not explicitly set, at initialization time this will be defaulted to {@link
     * com.smartgwt.client.data.SavedSearches#getAdminRole SavedSearches.adminRole}.
     *
     * @return Current adminRole value. Default value is null
     */
    public String getAdminRole()  {
        return getAttributeAsString("adminRole");
    }
    

    /**
     * Properties for the separator record between locally saved and admin searches.
     * <p>
     * This component is an AutoChild named "adminSeparatorRecord".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current adminSeparatorRecord value. Default value is {isSeparator:true}
     */
    public ListGridRecord getAdminSeparatorRecord()  {
        return ListGridRecord.getOrCreateRef(getAttributeAsJavaScriptObject("adminSeparatorRecord"));
    }
    

    /**
     * This flag controls whether adding new searches is allowed.
     *
     * @param canAddSearch New canAddSearch value. Default value is false
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCanAddSearch(boolean canAddSearch) {
        return (SavedSearchItem)setAttribute("canAddSearch", canAddSearch);
    }

    /**
     * This flag controls whether adding new searches is allowed.
     *
     * @return Current canAddSearch value. Default value is false
     */
    public boolean getCanAddSearch()  {
        Boolean result = getAttributeAsBoolean("canAddSearch", true);
        return result == null ? false : result;
    }
    

    /**
     * Whether existing searches can be copied. <p> If no explicit value is set, it will be defaulted to <code>false</code> if
     * the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetEditsCriteria target is a grid}. Searches
     * can be copied by simply selecting them, using the grid's standard UI to edit the search, and then saving that as a new
     * search.
     *
     * @param canCopySearch New canCopySearch value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCanCopySearch(Boolean canCopySearch) {
        return (SavedSearchItem)setAttribute("canCopySearch", canCopySearch);
    }

    /**
     * Whether existing searches can be copied. <p> If no explicit value is set, it will be defaulted to <code>false</code> if
     * the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetEditsCriteria target is a grid}. Searches
     * can be copied by simply selecting them, using the grid's standard UI to edit the search, and then saving that as a new
     * search.
     *
     * @return Current canCopySearch value. Default value is null
     */
    public Boolean getCanCopySearch()  {
        return getAttributeAsBoolean("canCopySearch", true);
    }
    

    /**
     * Whether existing searches can be edited. <p> If no explicit value is set, it will be defaulted to <code>false</code> if
     * the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetEditsCriteria target is a grid}. Searches
     * can be edited by simply selecting them, using the grid's standard UI to edit the search, and then saving that as the
     * original search.
     *
     * @param canEditSearch New canEditSearch value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCanEditSearch(Boolean canEditSearch) {
        return (SavedSearchItem)setAttribute("canEditSearch", canEditSearch);
    }

    /**
     * Whether existing searches can be edited. <p> If no explicit value is set, it will be defaulted to <code>false</code> if
     * the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetEditsCriteria target is a grid}. Searches
     * can be edited by simply selecting them, using the grid's standard UI to edit the search, and then saving that as the
     * original search.
     *
     * @return Current canEditSearch value. Default value is null
     */
    public Boolean getCanEditSearch()  {
        return getAttributeAsBoolean("canEditSearch", true);
    }
    

    /**
     * Optional name of a boolean field in the records returned by the <code>optionDataSource</code>, where setting the field
     * to <code>false</code> means the Record cannot be edited or removed by the current user.
     *
     * @param canModifyProperty New canModifyProperty value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCanModifyProperty(String canModifyProperty) {
        return (SavedSearchItem)setAttribute("canModifyProperty", canModifyProperty);
    }

    /**
     * Optional name of a boolean field in the records returned by the <code>optionDataSource</code>, where setting the field
     * to <code>false</code> means the Record cannot be edited or removed by the current user.
     *
     * @return Current canModifyProperty value. Default value is null
     */
    public String getCanModifyProperty()  {
        return getAttributeAsString("canModifyProperty");
    }
    

    /**
     * Whether existing searches can be removed.
     *
     * @param canRemoveSearch New canRemoveSearch value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCanRemoveSearch(boolean canRemoveSearch) {
        return (SavedSearchItem)setAttribute("canRemoveSearch", canRemoveSearch);
    }

    /**
     * Whether existing searches can be removed.
     *
     * @return Current canRemoveSearch value. Default value is true
     */
    public boolean getCanRemoveSearch()  {
        Boolean result = getAttributeAsBoolean("canRemoveSearch", true);
        return result == null ? true : result;
    }
    

    /**
     * Whether a confirmation message should be shown when a user removes a saved search.  The message shown is the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getConfirmRemovalMessage confirmRemovalMessage}.
     *
     * @param confirmRemoval New confirmRemoval value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setConfirmRemoval(boolean confirmRemoval) {
        return (SavedSearchItem)setAttribute("confirmRemoval", confirmRemoval);
    }

    /**
     * Whether a confirmation message should be shown when a user removes a saved search.  The message shown is the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getConfirmRemovalMessage confirmRemovalMessage}.
     *
     * @return Current confirmRemoval value. Default value is true
     */
    public boolean getConfirmRemoval()  {
        Boolean result = getAttributeAsBoolean("confirmRemoval", true);
        return result == null ? true : result;
    }
    

    /**
     * Message shown when {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getConfirmRemoval removal
     * confirmation} is enabled and user attempts to remove a saved search.  The variable "${title}" is available providing the
     * display name of the saved search.
     *
     * @param confirmRemovalMessage New confirmRemovalMessage value. Default value is "Remove saved view '${title}'?"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public SavedSearchItem setConfirmRemovalMessage(String confirmRemovalMessage) {
        return (SavedSearchItem)setAttribute("confirmRemovalMessage", confirmRemovalMessage);
    }

    /**
     * Message shown when {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getConfirmRemoval removal
     * confirmation} is enabled and user attempts to remove a saved search.  The variable "${title}" is available providing the
     * display name of the saved search.
     *
     * @return Current confirmRemovalMessage value. Default value is "Remove saved view '${title}'?"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getConfirmRemovalMessage()  {
        return getAttributeAsString("confirmRemovalMessage");
    }
    

    /**
     * ListGridField shown in the pickList to allow users to copy existing searches.  The field is type "icon" and displays the
     * skin's standard "copy" icon.
     * <p>
     * This component is an AutoChild named "copySearchField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current copySearchField value. Default value is null
     */
    public ListGridField getCopySearchField()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("copySearchField"));
    }
    

    /**
     * Hover text that appeares over the +{copySearchField}
     *
     * @param copySearchHoverText New copySearchHoverText value. Default value is "Copy view"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setCopySearchHoverText(String copySearchHoverText) {
        return (SavedSearchItem)setAttribute("copySearchHoverText", copySearchHoverText);
    }

    /**
     * Hover text that appeares over the +{copySearchField}
     *
     * @return Current copySearchHoverText value. Default value is "Copy view"
     */
    public String getCopySearchHoverText()  {
        return getAttributeAsString("copySearchHoverText");
    }
    

    /**
     * HTML string to append to the search title in the search name field if this is the  default search.
     *
     * @param defaultSearchNameSuffix New defaultSearchNameSuffix value. Default value is " &lt;i&gt;[default]&lt;/i&gt;"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public SavedSearchItem setDefaultSearchNameSuffix(String defaultSearchNameSuffix) {
        return (SavedSearchItem)setAttribute("defaultSearchNameSuffix", defaultSearchNameSuffix);
    }

    /**
     * HTML string to append to the search title in the search name field if this is the  default search.
     *
     * @return Current defaultSearchNameSuffix value. Default value is " &lt;i&gt;[default]&lt;/i&gt;"
     * @see com.smartgwt.client.docs.HTMLString HTMLString 
     */
    public String getDefaultSearchNameSuffix()  {
        return getAttributeAsString("defaultSearchNameSuffix");
    }
    

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @param editProxyConstructor New editProxyConstructor value. Default value is "SavedSearchItemEditProxy"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public SavedSearchItem setEditProxyConstructor(String editProxyConstructor) {
        return (SavedSearchItem)setAttribute("editProxyConstructor", editProxyConstructor);
    }

    /**
     * Default class used to construct the {@link com.smartgwt.client.tools.EditProxy} for this component when the component is
     * {@link com.smartgwt.client.widgets.Canvas#setEditMode first placed into edit mode}.
     *
     * @return Current editProxyConstructor value. Default value is "SavedSearchItemEditProxy"
     * @see com.smartgwt.client.docs.SCClassName SCClassName 
     */
    public String getEditProxyConstructor()  {
        return getAttributeAsString("editProxyConstructor");
    }
    

    /**
     * ListGridField shown in the pickList to allow users to edit existing searches.  The field is type "icon" and displays the
     * skin's standard "edit" icon. <p> Does not appear if the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetEditsCriteria target is a grid}, since the simplest way
     * of editing a search is just to select it, use the grid's built-in criteria editing to change it, and save as new. <P>
     * Specific records can be marked as unable to be edited via {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanModifyProperty canModifyProperty}.
     * <p>
     * This component is an AutoChild named "editSearchField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current editSearchField value. Default value is null
     */
    public ListGridField getEditSearchField()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("editSearchField"));
    }
    

    /**
     * Hover text that appeares over the +{editSearchField}
     *
     * @param editSearchHoverText New editSearchHoverText value. Default value is "Save View Configuration"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setEditSearchHoverText(String editSearchHoverText) {
        return (SavedSearchItem)setAttribute("editSearchHoverText", editSearchHoverText);
    }

    /**
     * Hover text that appeares over the +{editSearchField}
     *
     * @return Current editSearchHoverText value. Default value is "Save View Configuration"
     */
    public String getEditSearchHoverText()  {
        return getAttributeAsString("editSearchHoverText");
    }
    

    /**
     * Modal pop-up window shown when the user adds or edits a search, instance of of {@link
     * com.smartgwt.client.widgets.EditSearchWindow}.
     * <p>
     * This component is an AutoChild named "editSearchWindow".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current editSearchWindow value. Default value is null
     */
    public EditSearchWindow getEditSearchWindow()  {
        return (EditSearchWindow)EditSearchWindow.getByJSObject(getAttributeAsJavaScriptObject("editSearchWindow"));
    }
    

    /**
     * Text shown inside the field that serves as an indicator of what this field is for.
     *
     * @param hint New hint value. Default value is "Saved views..."
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setHint(String hint) {
        return (SavedSearchItem)setAttribute("hint", hint);
    }

    /**
     * Text shown inside the field that serves as an indicator of what this field is for.
     *
     * @return Current hint value. Default value is "Saved views..."
     */
    public String getHint()  {
        return getAttributeAsString("hint");
    }
    

    /**
     * ListGridField shown in the pickList to allow admin users to designate which field is the admin-default search.   The
     * field is type "icon" and displays the skin's standard "checkbox" media.
     * <p>
     * This component is an AutoChild named "markAsAdminDefaultField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current markAsAdminDefaultField value. Default value is null
     */
    public ListGridField getMarkAsAdminDefaultField()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("markAsAdminDefaultField"));
    }
    

    /**
     * Hover text that appeares over the +{markAsAdminDefaultField}
     *
     * @param markAsAdminDefaultHoverText New markAsAdminDefaultHoverText value. Default value is "Set as default view for all users&lt;br&gt;&lt;br&gt;&lt;i&gt;[May be overridden by users' own preferences.]&lt;/i&gt;"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setMarkAsAdminDefaultHoverText(String markAsAdminDefaultHoverText) {
        return (SavedSearchItem)setAttribute("markAsAdminDefaultHoverText", markAsAdminDefaultHoverText);
    }

    /**
     * Hover text that appeares over the +{markAsAdminDefaultField}
     *
     * @return Current markAsAdminDefaultHoverText value. Default value is "Set as default view for all users&lt;br&gt;&lt;br&gt;&lt;i&gt;[May be overridden by users' own preferences.]&lt;/i&gt;"
     */
    public String getMarkAsAdminDefaultHoverText()  {
        return getAttributeAsString("markAsAdminDefaultHoverText");
    }
    

    /**
     * ListGridField shown in the pickList to allow users to designate which field is the default search.  The field is type
     * "icon" and displays the skin's standard "checkbox" media.
     * <p>
     * This component is an AutoChild named "markAsDefaultField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current markAsDefaultField value. Default value is null
     */
    public ListGridField getMarkAsDefaultField()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("markAsDefaultField"));
    }
    

    /**
     * Hover text that appeares over the +{markAsDefaultField}
     *
     * @param markAsDefaultHoverText New markAsDefaultHoverText value. Default value is "Set as default view"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setMarkAsDefaultHoverText(String markAsDefaultHoverText) {
        return (SavedSearchItem)setAttribute("markAsDefaultHoverText", markAsDefaultHoverText);
    }

    /**
     * Hover text that appeares over the +{markAsDefaultField}
     *
     * @return Current markAsDefaultHoverText value. Default value is "Set as default view"
     */
    public String getMarkAsDefaultHoverText()  {
        return getAttributeAsString("markAsDefaultHoverText");
    }
    

    /**
     * Additional, fixed Record values that should be used every time a new search is saved.   <P> This can be used to create
     * user-specific saved searches by adding the userId as part of the saved Record's value. <P> Since this property is
     * settable on the fly, you could also add an external interface that would allow a user to save system-wide searches that
     * are not associated with their userId.  For example, system-wide searches might have userId set to blank or to a special
     * marker value, and the {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionCriteria
     * SelectItem.optionCriteria} could be set so that the <code>SavedSearchItem</code> shows system-wide as well as
     * user-specific saved searches.
     *
     * @param newRecordValues New newRecordValues value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setNewRecordValues(Record newRecordValues) {
        return (SavedSearchItem)setAttribute("newRecordValues", newRecordValues == null ? null : newRecordValues.getJsObj());
    }

    /**
     * Additional, fixed Record values that should be used every time a new search is saved.   <P> This can be used to create
     * user-specific saved searches by adding the userId as part of the saved Record's value. <P> Since this property is
     * settable on the fly, you could also add an external interface that would allow a user to save system-wide searches that
     * are not associated with their userId.  For example, system-wide searches might have userId set to blank or to a special
     * marker value, and the {@link com.smartgwt.client.widgets.form.fields.FormItem#getOptionCriteria
     * SelectItem.optionCriteria} could be set so that the <code>SavedSearchItem</code> shows system-wide as well as
     * user-specific saved searches.
     *
     * @return Current newRecordValues value. Default value is null
     */
    public Record getNewRecordValues()  {
        return Record.getOrCreateRef(getAttributeAsJavaScriptObject("newRecordValues"));
    }
    

    /**
     * Optional key used for local storage of saved searches by this component. <P> If unset, the default {@link
     * com.smartgwt.client.data.SavedSearches#getOfflineStorageKey SavedSearches.offlineStorageKey} will be used for local
     * storage instead. <P> Has no effect if {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getSavedSearchDS
     * savedSearchDS} is set.
     *
     * @param offlineStorageKey New offlineStorageKey value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setOfflineStorageKey(String offlineStorageKey) {
        return (SavedSearchItem)setAttribute("offlineStorageKey", offlineStorageKey);
    }

    /**
     * Optional key used for local storage of saved searches by this component. <P> If unset, the default {@link
     * com.smartgwt.client.data.SavedSearches#getOfflineStorageKey SavedSearches.offlineStorageKey} will be used for local
     * storage instead. <P> Has no effect if {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getSavedSearchDS
     * savedSearchDS} is set.
     *
     * @return Current offlineStorageKey value. Default value is null
     */
    public String getOfflineStorageKey()  {
        return getAttributeAsString("offlineStorageKey");
    }
    

    /**
     * The SavedSearchItem pickListFields are automatically generated and contain fields for the search name plus the search
     * description, plus additional columns for icons for editing,  removal, copying existing searches, and choosing a default
     * search.
     *
     * @return Current pickListFields value. Default value is [...]
     */
    public ListGridField[] getPickListFields()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfListGridField(getAttributeAsJavaScriptObject("pickListFields"));
    }
    

    /**
     * ListGridField shown in the pickList to allow users to remove existing searches.  The field is type "icon" and displays
     * the skin's standard "remove" icon. <p> An optional confirmation dialog is shown if {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getConfirmRemoval confirmRemoval} is set. <p> By default, if a
     * record is an admin search (because it has no value for {@link com.smartgwt.client.data.SavedSearches#getUserIdField
     * SavedSearches.userIdField} or because {@link com.smartgwt.client.data.SavedSearches#getAdminField
     * SavedSearches.adminField} is true on the record), only an admin will be able to delete it. <P> Alternatively, if you are
     * not using the <code>SavedSearchItem</code>'s admin features, specific records can be marked as unable to be removed via
     * {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getCanModifyProperty canModifyProperty}.
     * <p>
     * This component is an AutoChild named "removeSearchField".  For an overview of how to use and
     * configure AutoChildren, see {@link com.smartgwt.client.docs.AutoChildUsage Using AutoChildren}.
     *
     * @return Current removeSearchField value. Default value is null
     */
    public ListGridField getRemoveSearchField()  {
        return ListGridField.getOrCreateRef(getAttributeAsJavaScriptObject("removeSearchField"));
    }
    

    /**
     * Hover text that appeares over the +{removeSearchField}
     *
     * @param removeSearchHoverText New removeSearchHoverText value. Default value is "Remove view"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setRemoveSearchHoverText(String removeSearchHoverText) {
        return (SavedSearchItem)setAttribute("removeSearchHoverText", removeSearchHoverText);
    }

    /**
     * Hover text that appeares over the +{removeSearchField}
     *
     * @return Current removeSearchHoverText value. Default value is "Remove view"
     */
    public String getRemoveSearchHoverText()  {
        return getAttributeAsString("removeSearchHoverText");
    }
    

    /**
     * Works identically to {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveDefaultSearch ListGrid.saveDefaultSearch}. 
     * The default is stored in browser <code>localStorage</code> using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId DataBoundComponent.savedSearchId} of the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent}, or the {@link
     * com.smartgwt.client.util.AutoTest#getMinimalLocator AutoTest.getMinimalLocator()} if no savedSearchId was specified.<br>
     * If no targetComponent is specified, the savedSearchId or minimal locator of the <code>SavedSearchItem</code> itself will
     * be used. <p> Note that if the targetComponent is {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData
     * ListGrid.autoFetchData}, and saveDefaultSearch is true, the SavedSearchItem automatically registers with the target
     * component to prevent an automatic fetch with default criteria, and then, after looking up the default search, will
     * perform either the default search or perform a standard autoFetch if no default search is found.
     *
     * @param saveDefaultSearch New saveDefaultSearch value. Default value is true
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setSaveDefaultSearch(boolean saveDefaultSearch) {
        return (SavedSearchItem)setAttribute("saveDefaultSearch", saveDefaultSearch);
    }

    /**
     * Works identically to {@link com.smartgwt.client.widgets.grid.ListGrid#getSaveDefaultSearch ListGrid.saveDefaultSearch}. 
     * The default is stored in browser <code>localStorage</code> using the {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId DataBoundComponent.savedSearchId} of the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent}, or the {@link
     * com.smartgwt.client.util.AutoTest#getMinimalLocator AutoTest.getMinimalLocator()} if no savedSearchId was specified.<br>
     * If no targetComponent is specified, the savedSearchId or minimal locator of the <code>SavedSearchItem</code> itself will
     * be used. <p> Note that if the targetComponent is {@link com.smartgwt.client.widgets.grid.ListGrid#getAutoFetchData
     * ListGrid.autoFetchData}, and saveDefaultSearch is true, the SavedSearchItem automatically registers with the target
     * component to prevent an automatic fetch with default criteria, and then, after looking up the default search, will
     * perform either the default search or perform a standard autoFetch if no default search is found.
     *
     * @return Current saveDefaultSearch value. Default value is true
     */
    public boolean getSaveDefaultSearch()  {
        Boolean result = getAttributeAsBoolean("saveDefaultSearch", true);
        return result == null ? true : result;
    }
    

    /**
     * Optional override of {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource SavedSearches.defaultDataSource}
     * for this SavedSearchItem.
     *
     * @param savedSearchDS New savedSearchDS value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setSavedSearchDS(String savedSearchDS) {
        return (SavedSearchItem)setAttribute("savedSearchDS", savedSearchDS);
    }

    /**
     * Optional override of {@link com.smartgwt.client.data.SavedSearches#getDefaultDataSource SavedSearches.defaultDataSource}
     * for this SavedSearchItem.
     *
     * @return Current savedSearchDS value. Default value is null
     */
    public String getSavedSearchDS()  {
        return getAttributeAsString("savedSearchDS");
    }
    

    /**
     * Optional explicit identifier for saved searches. See {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getSaveDefaultSearch saveDefaultSearch} for details.
     * <p><b>Note : </b> This is an advanced setting</p>
     *
     * @param savedSearchId New savedSearchId value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setSavedSearchId(String savedSearchId) {
        return (SavedSearchItem)setAttribute("savedSearchId", savedSearchId);
    }

    /**
     * Optional explicit identifier for saved searches. See {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getSaveDefaultSearch saveDefaultSearch} for details.
     *
     * @return Current savedSearchId value. Default value is null
     */
    public String getSavedSearchId()  {
        return getAttributeAsString("savedSearchId");
    }
    

    /**
     * If set, the name of the last search is automatically stored in browser <code>localStorage</code>,  and will be applied
     * to the <code>targetComponent</code> as soon as saved searches are loaded.
     *
     * @param saveLastSearch New saveLastSearch value. Default value is false
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setSaveLastSearch(boolean saveLastSearch) {
        return (SavedSearchItem)setAttribute("saveLastSearch", saveLastSearch);
    }

    /**
     * If set, the name of the last search is automatically stored in browser <code>localStorage</code>,  and will be applied
     * to the <code>targetComponent</code> as soon as saved searches are loaded.
     *
     * @return Current saveLastSearch value. Default value is false
     */
    public boolean getSaveLastSearch()  {
        Boolean result = getAttributeAsBoolean("saveLastSearch", true);
        return result == null ? false : result;
    }
    

    /**
     * Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of
     * the component.
     *
     * @param storedState New storedState value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     * @see com.smartgwt.client.widgets.form.fields.SavedSearchItem
     */
    public SavedSearchItem setStoredState(SavedSearchStoredState storedState) {
        return (SavedSearchItem)setAttribute("storedState", storedState == null ? null : storedState.getValue());
    }

    /**
     * Set to "criteria" if you want only criteria to be stored for ListGrids and TreeGrids instead of the full viewState of
     * the component.
     *
     * @return Current storedState value. Default value is null
     * @see com.smartgwt.client.widgets.form.fields.SavedSearchItem
     */
    public SavedSearchStoredState getStoredState()  {
        return EnumUtil.getEnum(SavedSearchStoredState.values(), getAttribute("storedState"));
    }
    

    /**
     * Component that saved searches should apply to.  When set, whenever {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#searchChanged searchChanged()} fires, the search is
     * automatically applied to the <code>targetComponent</code> unless the <code>searchChanged</code> event is cancelled. <p>
     * To avoid leaking local storage, saving searches will not be allowed for the target component unless it specifies {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId savedSearchId}, or an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getLocalId local or global ID} is present.
     *
     * <br><br>If this method is called after the component has been drawn/initialized:
     * Changes the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent} to the passed in newTargetComponent.
     *
     * @param targetComponent the newTargetComponent. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setTargetComponent(DataBoundComponent targetComponent) {
        return (SavedSearchItem)setAttribute("targetComponent", targetComponent == null ? null : ((Canvas)targetComponent).getOrCreateJsObj());

    }

    /**
     * Component that saved searches should apply to.  When set, whenever {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#searchChanged searchChanged()} fires, the search is
     * automatically applied to the <code>targetComponent</code> unless the <code>searchChanged</code> event is cancelled. <p>
     * To avoid leaking local storage, saving searches will not be allowed for the target component unless it specifies {@link
     * com.smartgwt.client.widgets.DataBoundComponent#getSavedSearchId savedSearchId}, or an explicit {@link
     * com.smartgwt.client.widgets.Canvas#getLocalId local or global ID} is present.
     *
     * @return Current targetComponent value. Default value is null
     */
    public DataBoundComponent getTargetComponent()  {
        return (DataBoundComponent)Canvas.getByJSObject(getAttributeAsJavaScriptObject("targetComponent"));
    }
    

    /**
     * DataSource that the saved searches are performed against. <p> Normally auto-derived from {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent.dataSource}, but can be
     * specified manually if no <code>targetComponent</code> is provided.  In this case, {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#searchChanged searchChanged()} would be implement to apply
     * criteria in a custom way.
     *
     * @param targetDataSource New targetDataSource value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setTargetDataSource(DataSource targetDataSource) {
        return (SavedSearchItem)setAttribute("targetDataSource", targetDataSource == null ? null : targetDataSource.getOrCreateJsObj());
    }

    /**
     * DataSource that the saved searches are performed against. <p> Normally auto-derived from {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent.dataSource}, but can be
     * specified manually if no <code>targetComponent</code> is provided.  In this case, {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#searchChanged searchChanged()} would be implement to apply
     * criteria in a custom way.
     *
     * @return Current targetDataSource value. Default value is null
     */
    public DataSource getTargetDataSource()  {
        return DataSource.getOrCreateRef(getAttributeAsJavaScriptObject("targetDataSource"));
    }
    

    /**
     * Whether the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent} has
     * built-in criteria editing or does not.  True by default if the target is a {@link
     * com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid} (but not {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}). <p> When the target has built-in criteria editing, the
     * <code>SavedSearchItem</code> does not try to provide a {@link com.smartgwt.client.widgets.form.FilterBuilder}-based
     * criteria editing interface, so the {@link com.smartgwt.client.widgets.SavedSearchEditor} is simplified to just allow
     * naming of searches.
     *
     * @param targetEditsCriteria New targetEditsCriteria value. Default value is null
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setTargetEditsCriteria(Boolean targetEditsCriteria) {
        return (SavedSearchItem)setAttribute("targetEditsCriteria", targetEditsCriteria);
    }

    /**
     * Whether the {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent} has
     * built-in criteria editing or does not.  True by default if the target is a {@link
     * com.smartgwt.client.widgets.grid.ListGrid} or {@link com.smartgwt.client.widgets.tree.TreeGrid} (but not {@link
     * com.smartgwt.client.widgets.cube.CubeGrid}). <p> When the target has built-in criteria editing, the
     * <code>SavedSearchItem</code> does not try to provide a {@link com.smartgwt.client.widgets.form.FilterBuilder}-based
     * criteria editing interface, so the {@link com.smartgwt.client.widgets.SavedSearchEditor} is simplified to just allow
     * naming of searches.
     *
     * @return Current targetEditsCriteria value. Default value is null
     */
    public Boolean getTargetEditsCriteria()  {
        return getAttributeAsBoolean("targetEditsCriteria", true);
    }
    

    /**
     * Title of this FormItem.  Mote that the title is hidden by default for SavedSearchItem.
     *
     * @param title New title value. Default value is "Views"
     * @return {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem SavedSearchItem} instance, for chaining setter calls
     */
    public SavedSearchItem setTitle(String title) {
        return (SavedSearchItem)setAttribute("title", title);
    }

    /**
     * Title of this FormItem.  Mote that the title is hidden by default for SavedSearchItem.
     *
     * @return Current title value. Default value is "Views"
     */
    public String getTitle()  {
        return getAttributeAsString("title");
    }
    

    // ********************* Methods ***********************
	/**
     * Event fired whenever a user changes the currently selected saved search, modifies a saved search or adds a new saved
     * search. <p> If a {@link com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent} has
     * been specified, <code>searchChanged</code> automatically applies the new search to the <code>targetComponent</code>
     * unless the event is cancelled .
     * @param newCriteria new criteria
     * @param searchData savedSearch record
     *
     * @return whether to automatically apply the search to the {@link
     * com.smartgwt.client.widgets.form.fields.SavedSearchItem#getTargetComponent targetComponent}
     */
    public native boolean searchChanged(Criteria newCriteria, Record searchData) /*-{
        var self = this.@com.smartgwt.client.core.DataClass::getJsObj()();
	    if(@com.smartgwt.client.data.Criterion::instanceOf(Ljava/lang/Object;)(newCriteria)){
	    	@com.smartgwt.client.util.JSOHelper::setAttribute(Lcom/google/gwt/core/client/JavaScriptObject;Ljava/lang/String;Ljava/lang/String;)(newCriteria.@com.smartgwt.client.data.Criterion::getJsObj()(),"_constructor","AdvancedCriteria");
	    }
        var ret = self.searchChanged(newCriteria == null ? null : newCriteria.@com.smartgwt.client.core.DataClass::getJsObj()(), searchData.@com.smartgwt.client.core.DataClass::getJsObj()());
        return ret == null ? false : ret;
    }-*/;


    // ********************* Static Methods ***********************

    /** 
     * Class level method to set the default properties of this class.  If set, then all
     * existing and subsequently created instances of this class will automatically have
     * default properties corresponding to
     * the properties of the class instance passed to this function.
     * This is a powerful feature that eliminates the need for users to create a separate
     * hierarchy of subclasses that only alter the default properties of this class. Can also
     * be used for skinning / styling purposes.  <P> <b>Note:</b> This method is intended for
     * setting default attributes only and will affect all instances of the underlying class
     * (including those automatically generated in JavaScript).  This method should not be used
     * to apply standard EventHandlers or override methods for a class - use a custom subclass
     * instead.  Calling this method after instances have been created can result in undefined
     * behavior, since it bypasses any setters and a class instance may have already examined 
     * a particular property and not be expecting any changes through this route.
     *
     * @param savedSearchItemProperties properties that should be used as new defaults when instances of this class are created
     * @see com.smartgwt.client.docs.SGWTProperties
     */
    public static native void setDefaultProperties(SavedSearchItem savedSearchItemProperties) /*-{
        if (savedSearchItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::isCreated()()) {
            @com.smartgwt.client.util.ConfigUtil::warnOfPreConfigInstantiation(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)(SavedSearchItem.@java.lang.Object::getClass()(), "setDefaultProperties", savedSearchItemProperties.@java.lang.Object::getClass()());
        }
        savedSearchItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::setConfigOnly(Z)(true);
    	var properties = savedSearchItemProperties.@com.smartgwt.client.widgets.form.fields.FormItem::getConfig()();
        $wnd.isc.SavedSearchItem.addProperties(properties);
    }-*/;

    // ***********************************************************

}
