/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.tools.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.envers.tools.graph.GraphDefiner;
import org.hibernate.envers.tools.graph.TopologicalSort;
import org.hibernate.envers.tools.graph.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphTopologicalSort {
    public static <V, R> List<V> sort(GraphDefiner<V, R> definer) {
        List<V> values = definer.getValues();
        HashMap<R, Vertex<R>> vertices = new HashMap<R, Vertex<R>>();
        for (V v : values) {
            R rep = definer.getRepresentation(v);
            vertices.put(rep, new Vertex<R>(rep));
        }
        for (V v : values) {
            for (V vn : definer.getNeighbours(v)) {
                ((Vertex)vertices.get(definer.getRepresentation(v))).addNeighbour((Vertex)vertices.get(definer.getRepresentation(vn)));
            }
        }
        List sortedReps = new TopologicalSort().sort(vertices.values());
        ArrayList<V> sortedValues = new ArrayList<V>(sortedReps.size());
        for (Object rep : sortedReps) {
            sortedValues.add(definer.getValue(rep));
        }
        return sortedValues;
    }
}

