/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.resources.gss.ExtendedConditionalNodeVisitor;
import com.google.gwt.resources.gss.PermutationsCollector;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;

public class BooleanConditionCollector
extends ExtendedConditionalNodeVisitor
implements CssCompilerPass {
    private final MutatingVisitController delegate;
    private final Set<String> booleanConditions;

    public BooleanConditionCollector(MutatingVisitController delegate) {
        this.delegate = delegate;
        this.booleanConditions = new HashSet<String>();
    }

    @Override
    public void enterBooleanExpression(CssBooleanExpressionNode booleanExpressionNode) {
        Matcher m;
        if (booleanExpressionNode.getType() == CssBooleanExpressionNode.Type.CONSTANT && !(m = PermutationsCollector.IS_FUNCTION.matcher(booleanExpressionNode.getValue())).matches()) {
            this.booleanConditions.add(booleanExpressionNode.getValue());
        }
    }

    public Set<String> getBooleanConditions() {
        return ImmutableSet.copyOf(this.booleanConditions);
    }

    public void runPass() {
        this.delegate.startVisit((CssTreeVisitor)this);
    }
}

