/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Locale;

public class AbsolutePanel
extends ComplexPanel
implements InsertPanel.ForIsWidget {
    private static void changeToStaticPositioning(com.google.gwt.dom.client.Element elem) {
        elem.getStyle().setProperty("left", "");
        elem.getStyle().setProperty("top", "");
        elem.getStyle().setProperty("position", "");
    }

    public AbsolutePanel() {
        this(DOM.createDiv());
        this.getElement().getStyle().setProperty("position", "relative");
        this.getElement().getStyle().setProperty("overflow", "hidden");
    }

    protected AbsolutePanel(com.google.gwt.dom.client.Element elem) {
        this.setElement(elem);
    }

    @Override
    public void add(Widget w) {
        super.add(w, this.getElement());
    }

    public void add(Widget w, int left, int top) {
        w.removeFromParent();
        int beforeIndex = this.getWidgetCount();
        this.setWidgetPositionImpl(w, left, top);
        this.insert(w, beforeIndex);
        this.verifyPositionNotStatic(w);
    }

    public void add(IsWidget w, int left, int top) {
        this.add(w.asWidget(), left, top);
    }

    public int getWidgetLeft(Widget w) {
        this.checkWidgetParent(w);
        return w.getElement().getAbsoluteLeft() - this.getElement().getAbsoluteLeft();
    }

    public int getWidgetTop(Widget w) {
        this.checkWidgetParent(w);
        return w.getElement().getAbsoluteTop() - this.getElement().getAbsoluteTop();
    }

    @Override
    public void insert(Widget w, int beforeIndex) {
        this.insert(w, this.getElement(), beforeIndex, true);
    }

    @Override
    public void insert(IsWidget w, int beforeIndex) {
        this.insert(AbsolutePanel.asWidgetOrNull(w), beforeIndex);
    }

    public void insert(Widget w, int left, int top, int beforeIndex) {
        w.removeFromParent();
        this.setWidgetPositionImpl(w, left, top);
        this.insert(w, beforeIndex);
        this.verifyPositionNotStatic(w);
    }

    @Override
    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            AbsolutePanel.changeToStaticPositioning(w.getElement());
        }
        return removed;
    }

    public void setWidgetPosition(Widget w, int left, int top) {
        this.checkWidgetParent(w);
        this.setWidgetPositionImpl(w, left, top);
        this.verifyPositionNotStatic(w);
    }

    protected void setWidgetPositionImpl(Widget w, int left, int top) {
        Element h = w.getElement();
        if (left == -1 && top == -1) {
            AbsolutePanel.changeToStaticPositioning(h);
        } else {
            h.getStyle().setProperty("position", "absolute");
            h.getStyle().setProperty("left", left + "px");
            h.getStyle().setProperty("top", top + "px");
        }
    }

    private void checkWidgetParent(Widget w) {
        if (w.getParent() != this) {
            throw new IllegalArgumentException("Widget must be a child of this panel.");
        }
    }

    private void verifyPositionNotStatic(Widget child) {
        if (GWT.isProdMode()) {
            return;
        }
        if (!this.isAttached()) {
            return;
        }
        if (child.getElement().getOffsetParent() == null) {
            return;
        }
        if (child.getElement().getOffsetParent() == this.getElement()) {
            return;
        }
        if ("body".equals(this.getElement().getNodeName().toLowerCase(Locale.ROOT))) {
            return;
        }
        String className = this.getClass().getName();
        GWT.log("Warning: " + className + " descendants will be incorrectly positioned, i.e. not relative to their parent element, when 'position:static', which is the CSS default, is in effect. One possible fix is to call 'panel.getElement().getStyle().setPosition(Position.RELATIVE)'.", new IllegalStateException(className + " is missing CSS 'position:{relative,absolute,fixed}'"));
    }
}

