/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.rpc;

import com.isomorphic.base.Config;
import com.isomorphic.base.ISCInit;
import com.isomorphic.base.Reflection;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSField;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DataSourceBeanFilter;
import com.isomorphic.datasource.DataSourceManager;
import com.isomorphic.datasource.ISCBinaryValue;
import com.isomorphic.datasource.MultiTenantDSGenerator;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.interfaces.ISQLDataSource;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.CurrentMillisMarker;
import com.isomorphic.js.IBeanFilter;
import com.isomorphic.js.JSONFilter;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.js.JSTranslaterDSConfig;
import com.isomorphic.js.KeepPropertiesBeanFilter;
import com.isomorphic.js.UnconvertableException;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.BaseResponse;
import com.isomorphic.rpc.ClientMustResubmitException;
import com.isomorphic.rpc.DataExport;
import com.isomorphic.rpc.HttpServletRequestParser;
import com.isomorphic.rpc.QueueAlreadyStartedException;
import com.isomorphic.rpc.RPCManagerCompletionCallback;
import com.isomorphic.rpc.RPCRequest;
import com.isomorphic.rpc.RPCResponse;
import com.isomorphic.rpc.RestRequestParser;
import com.isomorphic.servlet.ConfiguresRPC;
import com.isomorphic.servlet.IDACall;
import com.isomorphic.servlet.RESTHandler;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.RequestTimer;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.AtomicFileOutputStream;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.ErrorReport;
import com.isomorphic.util.ISCDate;
import com.isomorphic.util.ISCTime;
import com.isomorphic.velocity.ServletRequestAttributeMapFacade;
import com.isomorphic.velocity.SessionAttributeMapFacade;
import com.isomorphic.xml.XML;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.output.TeeOutputStream;

public class RPCManager {
    private static Config config = Config.getGlobal();
    private static int maxRequestDebugLength = config.getInt("RPCManager.maxRequestDebugLength", 1024);
    private static boolean globalOmitNullMapValuesInResponse = config.getBoolean((Object)"RPCManager.omitNullMapValuesInResponse", false);
    private static boolean globalPrettyPrintResponse = config.getBoolean((Object)"RPCManager.prettyPrintResponse", false);
    private static boolean globalUseStrictJSON = config.getBoolean((Object)"RPCManager.useStrictJSON", false);
    public static final String structuredRPCStart = "//isc_RPCResponseStart-->";
    public static final String structuredRPCEnd = "//isc_RPCResponseEnd";
    private static final String IFRAME_RECURSE_UP = "iframe";
    private static final String IFRAME_NEW_WINDOW = "iframeNewWindow";
    private static final String IFRAME_TARGET = "__iframeTarget__";
    private static final String IFRAME_CALLBACK_METHOD = "isc.Comm.hiddenFrameReply";
    private RequestContext context;
    private Map responseMap = new LinkedHashMap();
    private DSTransaction dsTransaction = new DSTransaction();
    protected final Set<RPCManagerCompletionCallback> callbacks = new HashSet<RPCManagerCompletionCallback>();
    private Long transactionNum;
    private String jsCallback;
    private Map transaction;
    private List<BaseRequest> requests = new ArrayList<BaseRequest>();
    private boolean responseIsCustom = false;
    private static boolean initNotRunMessageShown = false;
    private boolean isDownload = false;
    private String charset = config.getString("RPCManager.defaultCharset", "UTF-8");
    public boolean closeConnection = false;
    public boolean omitNullMapValuesInResponse = globalOmitNullMapValuesInResponse;
    public boolean prettyPrintResponse = globalPrettyPrintResponse;
    public boolean useStrictJSON = globalUseStrictJSON;
    public static Logger log = new Logger(RPCManager.class.getName());
    private boolean isExport = false;
    public boolean enableAllDS = false;
    private long constructed;
    private long started;
    String customHTML = config.getString("RPCManager.customHTML", null);
    String serverVersion = config.getString("iscVersionNumber");
    boolean devenv = config.getBoolean((Object)"devenv", false);
    private Map attributes = new HashMap();
    private List<BaseRequest> associatedRequests = new ArrayList<BaseRequest>();
    private Map<String, DataSource> cachedDataSources = new HashMap<String, DataSource>();
    private Boolean _shouldTrackTimings = null;

    public RequestContext getContext() {
        return this.context;
    }

    public RPCManager omitNullMapValuesInResponse(boolean value) {
        this.omitNullMapValuesInResponse = value;
        return this;
    }

    public RPCManager prettyPrintResponse(boolean value) {
        this.prettyPrintResponse = value;
        return this;
    }

    public RPCManager useStrictJSON(boolean value) {
        this.useStrictJSON = value;
        return this;
    }

    private boolean statusIsError() {
        for (Object response : this.responseMap.values()) {
            if (!((BaseResponse)response).statusIsError()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldReportDownloadErrorsAsDocuments() {
        List<BaseRequest> requests = this.getRequests();
        if (requests.isEmpty()) {
            return false;
        }
        BaseRequest request = requests.get(0);
        if (!(request instanceof DSRequest)) {
            return false;
        }
        return ((DSRequest)request).shouldReportDownloadErrorsAsDocuments();
    }

    @Deprecated
    public Map getTemplateContext() {
        return this.dsTransaction.getTemplateContext();
    }

    @Deprecated
    public Object getFromTemplateContext(Object key) {
        return this.dsTransaction.getFromTemplateContext(key);
    }

    @Deprecated
    public void addToTemplateContext(Object key, Object value) {
        this.dsTransaction.addToTemplateContext(key, value);
    }

    public void enableAllDataSources() {
        this.enableAllDS = true;
    }

    public long getConstructedTimestamp() {
        return this.constructed;
    }

    public long getStartedTimestamp() {
        return this.started;
    }

    public void setJsCallback(String jsCallback) {
        this.jsCallback = jsCallback;
    }

    public DSTransaction getDsTransaction() {
        return this.dsTransaction;
    }

    public void setDsTransaction(DSTransaction dsTransaction) {
        this.dsTransaction = dsTransaction;
    }

    public boolean isREST() {
        DSRequest dsReq = this.getDSRequest(true);
        if (dsReq != null) {
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public boolean isREST(Object req) {
        if (req instanceof DSRequest) {
            DSRequest dsReq = (DSRequest)req;
            return Boolean.TRUE.equals(dsReq.getREST());
        }
        return false;
    }

    public boolean isRawREST(Object req) {
        if (req instanceof DSRequest) {
            DSRequest dsReq = (DSRequest)req;
            return Boolean.TRUE.equals(dsReq.getRawREST());
        }
        return false;
    }

    public void setRawRestStatus(int status) {
        if (status > 0) {
            this.context.response.setStatus(status);
        }
    }

    public static boolean isRPC(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_rpc=1") != -1 || queryString.indexOf("is_isc_rpc=true") != -1;
    }

    public static boolean isXmlHttp(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_xhr=1") != -1 || queryString.indexOf("xmlHttp=true") != -1;
    }

    public static long getTransactionNum(HttpServletRequest request) {
        try {
            Map<String, String> queryParams = ServletTools.parseQueryString(request.getQueryString());
            String transactionNum = queryParams.get("isc_tnum");
            if (transactionNum == null) {
                transactionNum = queryParams.get("iscTNum");
            }
            if (RPCManager.isXmlHttp(request)) {
                transactionNum = request.getParameter("isc_tnum");
            }
            if (transactionNum == null) {
                return -1L;
            }
            return Long.valueOf(transactionNum);
        }
        catch (Exception e) {
            log.warn((Object)"Error parsing transaction from query params", e);
            return -1L;
        }
    }

    private static String getClientVersion(HttpServletRequest request) {
        try {
            Map<String, String> queryParams = ServletTools.parseQueryString(request.getQueryString());
            String version = queryParams.get("isc_v");
            if (version == null) {
                version = queryParams.get("isc_clientVersion");
            }
            return version;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine client version");
            return null;
        }
    }

    public static void writeDocumentDomain(Writer out, RequestContext context) throws IOException {
        if (config.getBoolean((Object)"domainSync.disabled", false)) {
            return;
        }
        String documentDomainRaw = RPCManager.getDocumentDomain((HttpServletRequest)context.request);
        if (documentDomainRaw != null) {
            List baseDomains = config.getList("domainSync.baseDomains");
            if (baseDomains == null || baseDomains.size() == 0) {
                log.warn("Potentially insecure settings: Domain synching is enabled and not restricted to any baseDomains.  See the \"XSS and CSRF Security\" overview in the client reference for details to disable this warning");
            } else if (!baseDomains.contains(documentDomainRaw)) {
                log.error("ERROR: The domain synching parameter \"isc_dd\" was passed up to the server, specifying a value (" + documentDomainRaw + ") that is not permitted by your \"domainSync.baseDomains\" setting. See the \"XSS and CSRF Security\" overview in the client reference for details of this error");
                return;
            }
            out.write("<SCRIPT>document.domain = '" + RPCManager.escapeValue(documentDomainRaw) + "';</SCRIPT>\n");
        }
    }

    private static String getDocumentDomain(HttpServletRequest request) {
        try {
            Map<String, String> queryParams = ServletTools.parseQueryString(request.getQueryString());
            String dd = queryParams.get("isc_dd");
            if (dd == null) {
                dd = queryParams.get("docDomain");
            }
            return dd;
        }
        catch (Exception e) {
            log.warn("Error decoding query string: " + request.getQueryString() + " - can't determine docDomain");
            return null;
        }
    }

    private static String escapeValue(String value) {
        if (value == null) {
            return null;
        }
        try {
            StringBuffer escaped = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c < '\u0100') {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        escaped.append(c);
                        continue;
                    }
                    escaped.append("\\x");
                    escaped.append(Integer.toHexString(c));
                    continue;
                }
                escaped.append(c);
            }
            return escaped.toString();
        }
        catch (Exception e) {
            log.warn((Object)("Error escaping raw value " + value), e);
            return null;
        }
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this(servlet, request, response, null);
    }

    public RPCManager(Servlet servlet, HttpServletRequest request, HttpServletResponse response, HttpServletRequestParser parser) throws Exception {
        this.constructed = System.currentTimeMillis();
        if (!ISCInit.isInitialized() && !initNotRunMessageShown) {
            log.warn("ISC Init has not been run.");
            initNotRunMessageShown = true;
        }
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(servlet, request, response);
        this.initLog(request);
        if (servlet instanceof ConfiguresRPC) {
            ((ConfiguresRPC)servlet).prepareRPCTransaction(this, this.context);
        }
        if (parser == null) {
            this.parseRequest();
        } else {
            parser.parseRequest(this, request);
        }
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession(false)));
        this.started = System.currentTimeMillis();
        for (int i = 0; i < this.requests.size(); ++i) {
            BaseRequest obj = this.requests.get(i);
            if (!(obj instanceof DSRequest)) continue;
            DSRequest dsRequest = (DSRequest)obj;
            dsRequest.recordTimingData("RPCManager construction", DSRequest.TimingLogType.END, this.getStartedTimestamp());
            dsRequest.recordTimingData("RPCManager processing", DSRequest.TimingLogType.START, this.getStartedTimestamp());
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request == null) {
            throw new Exception("RPCManager constructor was passed a null HttpServletRequest");
        }
        this.context = RequestContext.instance(ISCFile.servletContext, (ServletRequest)request, (ServletResponse)response);
        this.initLog(request);
        this.parseRequest();
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession(false)));
    }

    protected void initLog(HttpServletRequest request) {
        try {
            Map<String, String> queryParams = ServletTools.parseQueryString(request.getQueryString());
            String logging = queryParams.get("isc_rpc_logging");
            if ("off".equals(logging)) {
                log.setInstanceLevel(Logger.OFF);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error initializing log settings", e);
        }
    }

    public RPCManager(HttpServletRequest request, HttpServletResponse response, Writer out) throws Exception {
        this(request, response);
        this.context.setOut(out);
        this.addToTemplateContext("servletRequest", new ServletRequestAttributeMapFacade(request));
        this.addToTemplateContext("session", new SessionAttributeMapFacade(request.getSession(false)));
    }

    public void setCustomHTML(String customHTML) {
        this.customHTML = customHTML;
    }

    public void doCustomResponse() {
        this.responseIsCustom = true;
    }

    public void setResponseCharset(String charset) {
        this.charset = charset;
    }

    public Object getData() {
        return this.getRequest().getData();
    }

    public DSRequest getDSRequest() {
        return this.getDSRequest(false);
    }

    public DSRequest getDSRequest(boolean skipWarning) {
        BaseRequest req;
        int requestCount = this.requestCount();
        if (requestCount > 1 && !skipWarning) {
            log.warn((Object)("getDSRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        if ((req = this.requests.get(0)) instanceof DSRequest) {
            return (DSRequest)req;
        }
        return null;
    }

    public RPCRequest getRequest() {
        int requestCount = this.requestCount();
        if (requestCount > 1) {
            log.warn((Object)("getRequest() on multiop RPC (" + requestCount + " requests pending) "), new Exception());
        }
        return (RPCRequest)this.requests.get(0);
    }

    public List<BaseRequest> getRequests() {
        return this.requests;
    }

    public int requestCount() {
        return this.requests.size();
    }

    public void send(Object data) throws Exception {
        this.send(new RPCResponse(data));
    }

    public void send(RPCResponse rpcResponse) throws Exception {
        RPCRequest rpcRequest = this.getRequest();
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("Single-argument send() method called twice.  This method may only be called once in response to a single RPCRequest.");
        }
        this.send(rpcRequest, rpcResponse);
    }

    public void send(RPCRequest rpcRequest, RPCResponse rpcResponse) throws Exception {
        if (this.responseMap.get(rpcRequest) != null) {
            throw new Exception("send(rpcRequest, rpcResponse) called twice for the same rpcRequest.  Only one RPCResponse can be sent to an RPCRequest.");
        }
        this.responseMap.put(rpcRequest, rpcResponse);
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(RPCRequest rpcRequest, Object data) throws Exception {
        RPCResponse rpcResponse = new RPCResponse();
        rpcResponse.setData(data);
        rpcResponse.setStatus(0);
        this.send(rpcRequest, rpcResponse);
    }

    public void sendXMLString(RPCRequest rpcRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        validationContext.freeResources();
        this.send(rpcRequest, data);
    }

    public void send(DSRequest dsRequest, DSResponse dsResponse) throws Exception {
        if (!this.isDownload) {
            this.isDownload = dsRequest.isDownload();
        }
        if (!this.isExport) {
            this.isExport = dsRequest.isExport();
        }
        this.responseMap.put(dsRequest, dsResponse);
        if (dsRequest.getDsTransaction() != null) {
            dsRequest.getDsTransaction().registerResponse(dsRequest, dsResponse);
        }
        if (this.responseMap.size() == this.requestCount()) {
            this.completeResponse();
        }
    }

    public void send(DSRequest dsRequest, Object data) throws Exception {
        DSResponse dsResponse = new DSResponse(dsRequest == null ? (DataSource)null : dsRequest.getDataSource());
        dsResponse.setData(data);
        dsResponse.setStatus(0);
        this.send(dsRequest, dsResponse);
    }

    public void sendXMLString(DSRequest dsRequest, String xml) throws Exception {
        ValidationContext validationContext = new ValidationContext();
        Object data = XML.toDSRecords(new StringReader(xml), validationContext);
        validationContext.freeResources();
        this.send(dsRequest, data);
    }

    public void sendSuccess(RPCRequest rpcRequest) throws Exception {
        RPCResponse rpcResponse = new RPCResponse("success");
        this.send(rpcRequest, rpcResponse);
    }

    public void sendFailure(Object request, String error) throws Exception {
        if (request instanceof DSRequest) {
            DSResponse dsResponse = new DSResponse(((DSRequest)request).getDataSource(), -1);
            dsResponse.setData(error);
            this.send((DSRequest)request, dsResponse);
        } else {
            RPCResponse rpcResponse = new RPCResponse(error);
            rpcResponse.setStatus(-1);
            this.send((RPCRequest)request, rpcResponse);
        }
    }

    public void sendFailure(Object request, Throwable t) throws Exception {
        this.sendFailure(request, DataTools.getStackTrace(Reflection.getRealTargetException(t)));
    }

    public static Object filterDSResponseData(DSResponse dsResponse, DataSource ds) throws Exception {
        Object responseData;
        Map jsResponse = dsResponse.getJSResponse();
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return jsResponse.get("data");
        }
        Object data = responseData = jsResponse.get("data");
        if (responseData instanceof JSTranslaterDSConfig) {
            data = ((JSTranslaterDSConfig)responseData).getObject();
        }
        if (data instanceof JSONFilter) {
            IBeanFilter beanFilter = ((JSONFilter)data).getBeanFilter();
            if (beanFilter instanceof KeepPropertiesBeanFilter) {
                Collection propsToKeep = ((KeepPropertiesBeanFilter)beanFilter).getPropsToKeep();
                Object obj = ((JSONFilter)data).getObj();
                DataSourceBeanFilter newFilter = new DataSourceBeanFilter(ds, propsToKeep);
                data = new JSONFilter(obj, newFilter);
                if (responseData instanceof JSTranslaterDSConfig) {
                    data = new JSTranslaterDSConfig(data, (JSTranslaterDSConfig)responseData);
                }
                return data;
            }
        } else {
            boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
            if (dsResponse.getDropExtraFields() != null) {
                dropExtraFields = dsResponse.getDropExtraFields();
                log.debug("DMI response, dropExtraFields: " + dropExtraFields);
            } else {
                if (ds.dropExtraFieldsDefined()) {
                    dropExtraFields = ds.dropExtraFields();
                }
                log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
            }
            data = new JSONFilter(data, ds, dropExtraFields);
            if (responseData instanceof JSTranslaterDSConfig) {
                data = new JSTranslaterDSConfig(data, (JSTranslaterDSConfig)responseData);
            }
            return data;
        }
        return responseData;
    }

    public static Object filterDSResponseData(DSRequest dsRequest, DSResponse dsResponse, DataSource ds) throws Exception {
        Object responseData;
        Map jsResponse = dsResponse.getJSResponse();
        if (ds == null || dsResponse.getBypassDataFilter().booleanValue()) {
            return jsResponse.get("data");
        }
        Object data = responseData = jsResponse.get("data");
        if (responseData instanceof JSTranslaterDSConfig) {
            data = ((JSTranslaterDSConfig)responseData).getObject();
        }
        if (data instanceof JSONFilter) {
            return RPCManager.filterDSResponseData(dsResponse, ds);
        }
        boolean dropExtraFields = config.getBoolean((Object)"DSResponse.dropExtraFields", false);
        if (dsResponse.getDropExtraFields() != null) {
            dropExtraFields = dsResponse.getDropExtraFields();
            log.debug("DMI response, dropExtraFields: " + dropExtraFields);
        } else {
            if (ds.dropExtraFieldsDefined()) {
                dropExtraFields = ds.dropExtraFields();
            }
            log.debug("non-DMI response, dropExtraFields: " + dropExtraFields);
        }
        DataSourceBeanFilter filter = new DataSourceBeanFilter(ds, dsRequest.getConsolidatedOutputs(), dsRequest.getDroppedFields(), dropExtraFields, true);
        data = new JSONFilter(data, filter);
        if (responseData instanceof JSTranslaterDSConfig) {
            data = new JSTranslaterDSConfig(data, (JSTranslaterDSConfig)responseData);
        }
        return data;
    }

    private void setServerStatusHeaders(boolean reportStatusFailure) {
        try {
            StringBuffer queue = new StringBuffer();
            Integer serverStatus = reportStatusFailure ? Integer.valueOf(-1) : null;
            for (Object rpcResponse : this.responseMap.values()) {
                int status = 0;
                if (rpcResponse != null) {
                    if (rpcResponse instanceof RPCResponse) {
                        status = ((RPCResponse)rpcResponse).getStatus();
                    } else if (rpcResponse instanceof DSResponse) {
                        status = ((DSResponse)rpcResponse).getStatus();
                    }
                }
                if (queue.length() > 0) {
                    queue.append(",");
                }
                queue.append(status);
                if (status >= 0 || serverStatus != null) continue;
                serverStatus = status;
            }
            this.context.response.setHeader("x-isc-server-status", String.valueOf(serverStatus == null ? 0 : serverStatus));
            this.context.response.setHeader("x-isc-server-queue-status", queue.toString());
        }
        catch (Exception e) {
            log.warn("Attempt to set x-isc-server-status/x-isc-server-queue-status headers failed :" + e.toString());
        }
    }

    /*
     * Loose catch block
     */
    private void completeResponse() throws Exception {
        block146: {
            block147: {
                block145: {
                    if (!this.responseIsCustom) break block145;
                    if (this.dsTransaction != null) {
                        this.dsTransaction.freeQueueResources();
                    }
                    this.freeRPCResources();
                    return;
                }
                this.setServerStatusHeaders(false);
                if (this.statusIsError() && !this.shouldReportDownloadErrorsAsDocuments()) break block146;
                if (!this.isDownload) break block147;
                if (this.doDownload()) {
                    if (this.dsTransaction != null) {
                        this.dsTransaction.freeQueueResources();
                    }
                    this.freeRPCResources();
                    return;
                }
                break block146;
            }
            if (!this.isExport || !this.doExport()) break block146;
            if (this.dsTransaction != null) {
                this.dsTransaction.freeQueueResources();
            }
            this.freeRPCResources();
            return;
        }
        try {
            block148: {
                break block148;
                {
                    catch (Exception e) {
                        log.warn(e);
                        DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
                        DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
                        dsResponse.setData(e.getLocalizedMessage());
                        dsResponse.setStatus(-1);
                        this.setServerStatusHeaders(true);
                        if (!IDACall.shouldReturnStacktrace(this.getContext())) break block148;
                        dsResponse.setParameter("stacktrace", DataTools.getStackTrace(e));
                    }
                }
            }
            boolean isXMLHttp = this.context.response != null && RPCManager.isXmlHttp((HttpServletRequest)this.context.request);
            try {
                this.context.setNoCacheHeaders();
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            try {
                String contentType;
                String string = contentType = isXMLHttp ? "text/plain" : "text/html";
                if (this.isREST()) {
                    contentType = "json".equalsIgnoreCase(this.getDSRequest(true).getDataFormat()) ? "application/json" : "text/xml";
                }
                if (this.charset != null && !this.charset.trim().equals("") && !this.charset.toLowerCase().equals("none")) {
                    contentType = contentType + "; charset=" + this.charset;
                }
                this.context.setContentType(contentType);
                log.debug("Content type for RPC transaction: " + contentType);
            }
            catch (Exception e) {
                log.warn(e.toString());
            }
            this.context._compressIfPossibleLocal();
            Writer out = config.getBoolean((Object)"IDACall.showClientOutput", false) && (this.getDSRequest(true) == null || !this.getDSRequest(true).shouldStreamResults()) ? new StringWriter() : this.context.out();
            for (RPCManagerCompletionCallback callback : this.callbacks) {
                if (this.dsTransaction.queueHasFailures()) {
                    callback.onFailure(this.dsTransaction, this.dsTransaction.isTransactionalFailure(null));
                    continue;
                }
                callback.onSuccess(this.dsTransaction);
            }
            DSRequest dsReq = this.getDSRequest(true);
            if (!(this.dsTransaction == null || this.isREST(dsReq) && dsReq.isDataSourceNull())) {
                this.dsTransaction.complete(false);
                if (this.dsTransaction.queueHasFailures()) {
                    this.setServerStatusHeaders(true);
                }
            }
            long rpcCompletionTimestamp = System.currentTimeMillis();
            ArrayList<Map> orderedResponseList = new ArrayList<Map>();
            for (BaseRequest request : this.requests) {
                Map timing;
                Object response = this.responseMap.get(request);
                if (response == null) {
                    throw new Exception("No response for request: " + request.toString());
                }
                if (response instanceof RPCResponse) {
                    HashMap<String, Object> payload = new HashMap<String, Object>();
                    payload.put("data", ((RPCResponse)response).getData());
                    payload.put("status", ((RPCResponse)response).getStatus());
                    if (((RPCResponse)response).getStacktrace() != null) {
                        payload.put("stacktrace", ((RPCResponse)response).getStacktrace());
                    }
                    orderedResponseList.add(payload);
                    continue;
                }
                if (!(response instanceof DSResponse)) continue;
                DSResponse dsResponse = (DSResponse)response;
                if (dsResponse.wantsConnectionClosed()) {
                    this.closeConnection = true;
                }
                Map jsResponse = dsResponse.getJSResponse(true);
                DSRequest dsRequest = (DSRequest)request;
                DataSource ds = dsRequest.getDataSource();
                if (ds != null) {
                    Object data = RPCManager.filterDSResponseData(dsRequest, dsResponse, ds);
                    if (data instanceof JSTranslaterDSConfig) {
                        dsResponse.setData(((JSTranslaterDSConfig)data).getObject());
                    }
                    jsResponse.put("data", data);
                }
                if (dsRequest.trackTimings() && (timing = (Map)jsResponse.get("timing")) != null) {
                    List topLevelChildren = (List)timing.get("children");
                    if (topLevelChildren != null) {
                        for (int k = 0; k < topLevelChildren.size(); ++k) {
                            Map entry = (Map)topLevelChildren.get(k);
                            if (!"RPCManager processing".equals(entry.get("name"))) continue;
                            entry.put("end", rpcCompletionTimestamp);
                            break;
                        }
                    }
                    LinkedHashMap<String, Object> serialize = new LinkedHashMap<String, Object>();
                    serialize.put("name", "DSResponse serialization");
                    serialize.put("start", rpcCompletionTimestamp);
                    serialize.put("end", new CurrentMillisMarker());
                    topLevelChildren.add(serialize);
                    timing.put("end", new CurrentMillisMarker());
                }
                orderedResponseList.add(jsResponse);
            }
            if (isXMLHttp || this.isREST(dsReq)) {
                if (this.isREST(dsReq)) {
                    if (this.jsCallback != null) {
                        RPCManager.writeIframePrefix(out, this, null, null);
                    }
                    if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        out.write(dsReq.getJsonPrefix());
                    }
                } else {
                    out.write(structuredRPCStart);
                }
                JSTranslater jsTrans = JSTranslater.instance();
                jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                jsTrans.setObfuscation(false);
                jsTrans = this.setEnumProperties(jsTrans);
                ValidationContext vc = new ValidationContext();
                vc.setDSRequest(dsReq);
                vc.setEncodeBinaryFields(true);
                jsTrans.setTypeLookupVC(vc);
                Boolean trimMillis = null;
                if (dsReq != null && dsReq.getDataSource() != null && dsReq.getDataSource().getConfig().containsKey("trimMilliseconds")) {
                    trimMillis = DataTools.getBooleanObject(dsReq.getDataSource().getConfig(), "trimMilliseconds");
                    jsTrans.setTrimMilliseconds(trimMillis);
                }
                if (this.isREST(dsReq)) {
                    DSResponse response;
                    jsTrans.strictJSONMode();
                    jsTrans.setWriteXMLSchemaDate(true);
                    if (trimMillis == null) {
                        trimMillis = config.getBoolean((Object)"rest.trimMilliseconds", false);
                        jsTrans.setTrimMilliseconds(trimMillis);
                    }
                    boolean rawREST = this.isRawREST(dsReq);
                    String opType = dsReq.getOperationType();
                    Boolean singular = (Boolean)dsReq.getParameter("singularResponse");
                    if (rawREST) {
                        response = (DSResponse)this.responseMap.get(dsReq);
                        if (response.getStatus() != 0) {
                            if (!(response instanceof RestRequestParser.RawRestErrorResponse)) {
                                int httpStatus = 400;
                                if ("add".equals(opType)) {
                                    httpStatus = 409;
                                }
                                if (response.getStatus() == -9) {
                                    httpStatus = 405;
                                }
                                this.setRawRestStatus(httpStatus);
                            }
                        } else {
                            List records = response.getRecords(vc);
                            if (records.size() == 0) {
                                int httpStatus = 404;
                                if (("fetch".equals(opType) || "update".equals(opType) || "remove".equals(opType)) && !singular.booleanValue()) {
                                    httpStatus = 204;
                                }
                                if (DataSource.isCustom(opType)) {
                                    httpStatus = 204;
                                }
                                if (response.getInvalidateCache()) {
                                    httpStatus = 204;
                                }
                                this.setRawRestStatus(httpStatus);
                            } else if ("add".equals(opType)) {
                                this.setRawRestStatus(201);
                            }
                        }
                    }
                    if ("json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        if (orderedResponseList.size() > 1) {
                            ArrayList restList = new ArrayList();
                            for (int i = 0; i < orderedResponseList.size(); ++i) {
                                Map result = (Map)orderedResponseList.get(i);
                                LinkedHashMap<String, Map> restContainer = new LinkedHashMap<String, Map>();
                                Map restResponse = DataTools.subsetMap(result, DataTools.buildList("queueStatus", "status"));
                                Object statusObj = result.get("status");
                                int status = 0;
                                if (statusObj != null && statusObj instanceof Integer) {
                                    status = (Integer)statusObj;
                                }
                                if (status == 0) {
                                    if (DataSource.isModificationOperation(opType)) {
                                        restResponse.put("affectedRows", result.get("affectedRows"));
                                    } else {
                                        if (DataSource.isCustom(opType)) {
                                            restResponse.put("affectedRows", result.get("affectedRows"));
                                        }
                                        restResponse.put("startRow", result.get("startRow"));
                                        restResponse.put("endRow", result.get("endRow"));
                                        restResponse.put("totalRows", result.get("totalRows"));
                                    }
                                    restResponse.put("data", result.get("data"));
                                } else {
                                    restResponse.put("errors", result.get("errors"));
                                    restResponse.put("data", result.get("data"));
                                    if (status == -13) {
                                        restResponse.put("missingCriterion", result.get("missingCriterion"));
                                    }
                                }
                                restContainer.put("response", restResponse);
                                restList.add(restContainer);
                            }
                            jsTrans.toJS(restList, out);
                        } else if (rawREST) {
                            response = (DSResponse)this.responseMap.get(dsReq);
                            if (response.getStatus() != 0) {
                                Map errorReport = RESTHandler.getErrorReport(response, null);
                                if (config.getBoolean((Object)"simplifiedRawRestErrorResponse", false)) {
                                    HashMap errors = new HashMap();
                                    errors.put("errors", errorReport.get("errorMessages"));
                                    errors.put("status", "ERROR");
                                    if (response.getStatus() == -13) {
                                        errors.put("missingCriterion", response.getJSResponse().get("missingCriterion"));
                                    }
                                    jsTrans.toJS(errors, out);
                                } else {
                                    if (response.getStatus() == -13) {
                                        errorReport.put("missingCriterion", response.getJSResponse().get("missingCriterion"));
                                    }
                                    jsTrans.toJS(errorReport, out);
                                }
                            } else {
                                List records = response.getRecords(vc);
                                if (singular.booleanValue()) {
                                    if (records.size() > 0) {
                                        jsTrans.toJS(records.get(0), out);
                                    }
                                } else {
                                    jsTrans.toJS(records, out);
                                }
                            }
                        } else {
                            Map result = (Map)orderedResponseList.get(0);
                            LinkedHashMap<String, Map> restContainer = new LinkedHashMap<String, Map>();
                            Map restResponse = DataTools.subsetMap(result, DataTools.buildList("queueStatus", "status"));
                            Object statusObj = result.get("status");
                            int status = 0;
                            if (statusObj != null && statusObj instanceof Integer) {
                                status = (Integer)statusObj;
                            }
                            if (status == 0) {
                                if (DataSource.isModificationOperation(opType)) {
                                    restResponse.put("affectedRows", result.get("affectedRows"));
                                } else {
                                    if (DataSource.isCustom(opType)) {
                                        restResponse.put("affectedRows", result.get("affectedRows"));
                                    }
                                    restResponse.put("startRow", result.get("startRow"));
                                    restResponse.put("endRow", result.get("endRow"));
                                    restResponse.put("totalRows", result.get("totalRows"));
                                }
                                restResponse.put("data", result.get("data"));
                            } else {
                                restResponse.put("errors", result.get("errors"));
                                restResponse.put("data", result.get("data"));
                                if (status == -13) {
                                    restResponse.put("missingCriterion", result.get("missingCriterion"));
                                }
                            }
                            restContainer.put("response", restResponse);
                            jsTrans.toJS(restContainer, out);
                        }
                    } else {
                        StringWriter sw = new StringWriter();
                        sw.write("<?xml version=\"1.0\"?>\n");
                        if (orderedResponseList.size() > 1) {
                            sw.write("<responses>\n");
                        }
                        for (int i = 0; i < this.requests.size(); ++i) {
                            List records;
                            dsReq = (DSRequest)this.requests.get(i);
                            DSResponse response2 = (DSResponse)this.responseMap.get(dsReq);
                            response2.setDataSource(dsReq.getDataSource());
                            if (!rawREST) {
                                sw.write("<response>\n");
                                Object queueStatus = response2.getProperty("queueStatus");
                                if (queueStatus != null) {
                                    sw.write("<queueStatus>" + queueStatus + "</queueStatus>");
                                }
                                sw.write("<status>" + response2.getStatus() + "</status>\n");
                            }
                            if (response2.statusIsSuccess()) {
                                if (!rawREST) {
                                    String strValue;
                                    for (String propKey : response2.getSetPropsList()) {
                                        Object value = response2.getProperty(propKey);
                                        if ("queueStatus".equals(propKey)) continue;
                                        if (value instanceof Boolean || value instanceof Number) {
                                            strValue = value.toString();
                                        } else if (value instanceof String) {
                                            strValue = XML.quoteXMLString((String)value, false);
                                        } else if (value instanceof ISCDate) {
                                            strValue = new SimpleDateFormat("yyyy-MM-dd").format((ISCDate)value);
                                        } else if (value instanceof ISCTime) {
                                            strValue = new SimpleDateFormat("HH:mm:ss").format((ISCTime)value);
                                        } else if (value instanceof Date) {
                                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                                            strValue = sdf.format((Date)value);
                                        } else {
                                            strValue = "Invalid value type: " + value.getClass().getName();
                                        }
                                        sw.write("<" + propKey + ">" + strValue + "</" + propKey + ">");
                                    }
                                    if (DataSource.isModificationOperation(dsReq.getOperationType())) {
                                        sw.write("<affectedRows>" + response2.getAffectedRows() + "</affectedRows>\n");
                                    } else {
                                        if (DataSource.isCustom(opType)) {
                                            sw.write("<affectedRows>" + response2.getAffectedRows() + "</affectedRows>\n");
                                        }
                                        sw.write("<startRow>" + response2.getStartRow() + "</startRow>\n");
                                        sw.write("<endRow>" + response2.getEndRow() + "</endRow>\n");
                                        sw.write("<totalRows>" + response2.getTotalRows() + "</totalRows>\n");
                                    }
                                    List relatedUpdates = response2.getRelatedUpdates();
                                    if (relatedUpdates != null && !relatedUpdates.isEmpty()) {
                                        sw.write("<relatedUpdates>");
                                        for (DSResponse relatedUpdate : relatedUpdates) {
                                            sw.write("<response>");
                                            sw.write("<status>" + relatedUpdate.getStatus() + "</status>\n");
                                            sw.write("<operationType>" + relatedUpdate.getOperationType() + "</operationType>\n");
                                            if (DataSource.isModificationOperation(relatedUpdate.getOperationType())) {
                                                sw.write("<affectedRows>" + relatedUpdate.getAffectedRows() + "</affectedRows>\n");
                                            } else {
                                                sw.write("<startRow>" + relatedUpdate.getStartRow() + "</startRow>\n");
                                                sw.write("<endRow>" + relatedUpdate.getEndRow() + "</endRow>\n");
                                                sw.write("<totalRows>" + relatedUpdate.getTotalRows() + "</totalRows>\n");
                                            }
                                            for (String propKey : relatedUpdate.getSetPropsList()) {
                                                if ("queueStatus".equals(propKey)) continue;
                                                Object value = relatedUpdate.getProperty(propKey);
                                                if (value instanceof Boolean || value instanceof Number) {
                                                    strValue = value.toString();
                                                } else if (value instanceof String) {
                                                    strValue = XML.quoteXMLString((String)value, false);
                                                } else if (value instanceof ISCDate) {
                                                    strValue = new SimpleDateFormat("yyyy-MM-dd").format((ISCDate)value);
                                                } else if (value instanceof ISCTime) {
                                                    strValue = new SimpleDateFormat("HH:mm:ss").format((ISCTime)value);
                                                } else if (value instanceof Date) {
                                                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                                                    sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                                                    strValue = sdf.format((Date)value);
                                                } else {
                                                    strValue = "Invalid value type: " + value.getClass().getName();
                                                }
                                                sw.write("<" + propKey + ">" + strValue + "</" + propKey + ">");
                                            }
                                            sw.write("<data>\n");
                                            XML.recordsToXML("record", relatedUpdate.getRecords(vc), sw, false, dsReq);
                                            sw.write("</data>\n");
                                            sw.write("</response>");
                                        }
                                        sw.write("</relatedUpdates>");
                                    }
                                }
                            } else if (rawREST) {
                                RESTHandler.getErrorReport(response2, sw);
                            } else {
                                XML.recordToXML("errors", response2.getErrorReport(), sw, false, null);
                                Object outData = response2.getData();
                                if (outData instanceof JSONFilter) {
                                    outData = ((JSONFilter)outData).getObj();
                                }
                                if (outData instanceof String) {
                                    sw.write("<data>" + outData + "</data>\n");
                                }
                                if (response2.status == -13) {
                                    sw.write("<missingCriterion>");
                                    sw.write((String)response2.getProperty("missingCriterion"));
                                    sw.write("</missingCriterion>");
                                }
                            }
                            if ((records = response2.getRecords(vc)) != null && records.size() > 0) {
                                if (!rawREST || !singular.booleanValue()) {
                                    sw.write("<data>\n");
                                }
                                XML.recordsToXML("record", response2.getRecords(vc), sw, false, dsReq);
                                if (!rawREST || !singular.booleanValue()) {
                                    sw.write("</data>\n");
                                }
                            }
                            if (rawREST) continue;
                            sw.write("\n</response>\n");
                        }
                        if (orderedResponseList.size() > 1) {
                            sw.write("\n</responses>");
                        }
                        out.write(sw.toString());
                    }
                } else {
                    if (dsReq != null) {
                        if (dsReq.getUseStrictJSON()) {
                            jsTrans.strictJSONMode();
                        }
                    } else if (this.useStrictJSON) {
                        jsTrans.strictJSONMode();
                    }
                    long start = System.currentTimeMillis();
                    jsTrans.toJS(orderedResponseList, out);
                }
                vc.freeResources();
                if (this.isREST(dsReq)) {
                    if (!isXMLHttp && dsReq.getWrapJSONResponses().booleanValue() && "json".equalsIgnoreCase(dsReq.getDataFormat())) {
                        out.write(dsReq.getJsonSuffix());
                    }
                    if (this.jsCallback != null) {
                        this.context.setContentType("text/html", true);
                        RPCManager.writeIframePostfix(out);
                    }
                } else {
                    out.write(structuredRPCEnd);
                }
            } else {
                this.iframeWrite(out, true, orderedResponseList);
            }
            out.flush();
            if (out instanceof StringWriter) {
                String output = out.toString();
                int outputSize = output.length();
                log.debug("Uncompressed result size: " + outputSize + " bytes");
                this.context.out().write(output);
                this.context.out().flush();
                if (config.getBoolean((Object)"devenv", false)) {
                    log.debug((Object)"Output to client", output);
                }
            }
            this.context.completeResponse();
        }
        catch (Exception e) {
            try {
                if (this.dsTransaction != null) {
                    this.dsTransaction.onFailure();
                    this.setServerStatusHeaders(true);
                }
            }
            catch (Exception e2) {
                log.warn(DataTools.getStackTrace(Reflection.getRealTargetException(e2)));
            }
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (this.dsTransaction != null) {
                this.dsTransaction.freeQueueResources();
            }
            this.freeRPCResources();
        }
    }

    private boolean doDownload() throws Exception {
        Object binaryObj;
        String fileNameInURL;
        DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
        String fileName = fileNameInURL = dsRequest.getDownloadFileName();
        String fieldName = dsRequest.getDownloadFieldName();
        DataSource ds = dsRequest.getDataSource();
        DSField field = ds.getField(fieldName);
        DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
        Object dataObj = dsResponse.getData();
        Map<String, Object> data = dsResponse.getRecord();
        if (data == null) {
            String message = "dsResponse.getRecord() returned null when attempting to process a data member of type " + (dataObj == null ? "null" : dataObj.getClass().getName()) + ". Can't continue.";
            dsResponse.setErrorReport(new ErrorReport(message)).setStatus(-1);
            this.setServerStatusHeaders(true);
            this.reportErrorAsDownload(message);
            return false;
        }
        String storedFileName = (String)data.get(fieldName + "_filename");
        String fieldMimeType = field.getMimeType();
        if (fieldMimeType != null && storedFileName != null && !storedFileName.endsWith(".txt")) {
            this.context.setContentType(fieldMimeType);
        } else if ((this.context.requestPath.indexOf(".") == -1 || fileName == null) && storedFileName != null) {
            String mimeTypeForStoredFileName = DataTools.mimeTypeForFileName(storedFileName);
            if (mimeTypeForStoredFileName != null) {
                this.context.setContentType(mimeTypeForStoredFileName);
            }
        } else {
            String mimeType = ServletTools.mimeTypeForContext(this.context);
            this.context.setContentType(mimeType);
        }
        if (fileName == null) {
            fileName = storedFileName;
        }
        long contentLength = 0L;
        Object lengthObj = data.get(ds.getFilesizeField(fieldName));
        if (lengthObj != null) {
            contentLength = Long.valueOf(lengthObj.toString());
        }
        if (!ISCBinaryValue.isBinary(binaryObj = data.get(fieldName))) {
            String message = "dsResponse.getData().get(\"" + fieldName + "\") returned " + (binaryObj == null ? "null" : " an instance of " + binaryObj.getClass().getName()) + " when we were expecting an InputStream, Byte[] or byte[]. Can't continue.";
            dsResponse.setErrorReport(new ErrorReport(message)).setStatus(-1);
            this.reportErrorAsDownload(message);
            return false;
        }
        if (dsResponse.shouldExportToClient() == null || dsResponse.shouldExportToClient().booleanValue()) {
            if (dsRequest.getOperationType().equals("downloadFile")) {
                this.setContentDispositionHeader("attachment", fileNameInURL, fileName);
            } else {
                this.setContentDispositionHeader("inline", fileNameInURL, fileName);
            }
        }
        if (contentLength > 0L) {
            this.context.response.setContentLength((int)contentLength);
        }
        Object os = null;
        String qname = null;
        if (dsResponse.shouldExportToClient() != null && !dsResponse.shouldExportToClient().booleanValue() && dsResponse.shouldExportToFilesystem().booleanValue()) {
            qname = config.getPath("export.location");
            if (!config.getBoolean((Object)"export.allow.filesystem", false) && dsResponse.shouldExportToFilesystem().booleanValue()) {
                log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                dsResponse.setExportToFilesystem(false);
            } else if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                String path;
                if (qname == null) {
                    qname = "";
                }
                if (!qname.endsWith("/") && qname.length() > 0) {
                    qname = qname + "/";
                }
                if ((path = dsResponse.getExportPath()) != null) {
                    qname = qname + path;
                }
                if (!qname.endsWith("/") && qname.length() > 0) {
                    qname = qname + "/";
                }
                qname = qname + fileName;
                os = new BufferedOutputStream((OutputStream)((Object)new AtomicFileOutputStream(qname)));
            }
        } else {
            os = this.context.response.getOutputStream();
        }
        try {
            if (dsRequest.getAttribute("httpRangeStart") != null) {
                long start = (Long)dsRequest.getAttribute("httpRangeStart");
                long end = (Long)dsRequest.getAttribute("httpRangeEnd");
                if (start == -1L) {
                    start = contentLength - start;
                    end = -1L;
                }
                this.context.response.setStatus(206);
                this.context.response.addHeader("Accept-Ranges", "bytes");
                String contentRange = "" + (start != -1L ? Long.valueOf(start) : "") + "-";
                contentRange = contentRange + (end == -1L ? contentLength - 1L : end);
                contentRange = contentRange + "/" + contentLength;
                this.context.response.addHeader("Content-Range", "bytes " + contentRange);
                contentLength = end == -1L ? contentLength : end + 1L;
                this.context.response.setContentLength((int)(contentLength -= start == -1L ? 0L : start));
                ISCBinaryValue.copyToOutputStream(binaryObj, (OutputStream)os, start, end == -1L ? -1L : end + 1L);
            } else {
                ISCBinaryValue.copyToOutputStream(binaryObj, (OutputStream)os);
            }
            os.flush();
            os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private boolean doExport() throws Exception {
        DataTypeMap opBinding;
        DSRequest dsRequest = (DSRequest)this.getRequests().get(0);
        DSResponse dsResponse = (DSResponse)this.responseMap.get(dsRequest);
        if (!(dsResponse.getExportAs() != null && dsResponse.getExportAs() != "" || !"json".equals(dsRequest.getExportAs()) || (opBinding = dsRequest.getDataSource().getOperationBinding(dsRequest)) != null && "json".equals(opBinding.get("exportAs")))) {
            String err = "For security reasons, client is not allowed to specify exportAs: 'json'.  Either use a different format or create an operationBinding that specifies exportAs: 'json' instead.";
            dsResponse.setErrorReport(new ErrorReport(err)).setStatus(-1);
            this.setServerStatusHeaders(true);
            this.reportErrorAsDownload(err);
            return false;
        }
        dsRequest.copyExportSettingsToResponse(dsResponse);
        if (dsResponse.shouldExportToClient().booleanValue() || dsResponse.shouldExportToFilesystem().booleanValue() && dsResponse.getExportTo() == null) {
            Map dataMap;
            String separator;
            String lineBreakStyle;
            String exportAs;
            List data = new ArrayList();
            Iterator iterator = null;
            Object initData = dsResponse.getData();
            if (initData instanceof List) {
                data = (List)initData;
            } else if (initData instanceof Map[]) {
                Map[] arr = (Map[])initData;
                data.addAll(Arrays.asList(arr));
            } else if (initData instanceof Iterator) {
                iterator = (Iterator)initData;
            } else {
                data.add((Map)initData);
            }
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            DataSource ds = dsResponse.getDataSource() != null ? dsResponse.getDataSource() : dsRequest.getDataSource();
            List<String> fieldNames = ds != null ? ds.getFieldNames() : dsResponse.getExportFields();
            List<String> exportFields = dsResponse.getExportFields();
            if (exportFields == null) {
                exportFields = fieldNames;
            }
            Map exportFieldTitles = dsResponse.getExportFieldTitles();
            HashMap<String, String> exportOtherFields = (HashMap<String, String>)dsResponse.getParameter("exportOtherFields");
            if (exportOtherFields == null) {
                exportOtherFields = new HashMap<String, String>();
            }
            if ((exportAs = dsResponse.getExportAs()) != null) {
                exportAs = exportAs.toLowerCase();
            }
            if ((lineBreakStyle = dsResponse.getLineBreakStyle()) != null) {
                lineBreakStyle = lineBreakStyle.toLowerCase();
            }
            if ((separator = dsResponse.getExportTitleSeparatorChar()) == null) {
                separator = "";
            }
            boolean isExcelExport = "ooxml".equals(exportAs) || "xls".equals(exportAs);
            boolean isXMLExport = "xml".equals(exportAs);
            boolean isJSONExport = "json".equals(exportAs);
            for (int i = 0; i < exportFields.size(); ++i) {
                String fieldName = exportFields.get(i);
                String fieldTitle = null;
                fieldTitle = exportFieldTitles != null && exportFieldTitles.containsKey(fieldName) ? (String)exportFieldTitles.get(fieldName) : (String)exportOtherFields.get(fieldName);
                if (fieldTitle == null) {
                    DSField field;
                    fieldTitle = fieldName;
                    if (ds != null && (field = ds.getField(fieldName)) != null && !field.getBoolean("hidden")) {
                        String string = fieldTitle = field.getProperty("exportTitle") != null ? field.getProperty("exportTitle") : field.getTitle();
                    }
                }
                if (isXMLExport) {
                    if (fieldTitle == null) {
                        fieldTitle = fieldName;
                    }
                    fieldTitle = fieldTitle.replaceAll("[$&<>()\"'\\n ]", separator);
                }
                if (isExcelExport) {
                    fieldMap.put(fieldName, fieldName);
                    exportOtherFields.put(fieldName, fieldTitle);
                    continue;
                }
                fieldMap.put(fieldName, fieldTitle);
            }
            LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
            settings.put("exportAs", exportAs);
            settings.put("lineBreakStyle", lineBreakStyle);
            settings.put("exportDelimiter", dsResponse.getExportDelimiter());
            settings.put("dataSource", ds);
            settings.put("exportFields", exportFields);
            settings.put("exportHeader", dsResponse.getExportHeader());
            settings.put("exportHeaderless", dsResponse.getExportHeaderless());
            settings.put("exportFooter", dsResponse.getExportFooter());
            settings.put("exportOtherFields", exportOtherFields);
            settings.put("exportDatesAsFormattedString", dsResponse.getExportDatesAsFormattedString());
            settings.put("exportNumbersAsFormattedString", dsResponse.getExportNumbersAsFormattedString());
            settings.put("formulaFields", dsResponse.getParameter("formulaFields"));
            settings.put("formulaRemap", dsResponse.getParameter("formulaRemap"));
            settings.put("exportDefaultBGColor", dsResponse.getParameter("exportDefaultBGColor"));
            settings.put("exportAlternateRowBGColor", dsResponse.getParameter("exportAlternateRowBGColor"));
            settings.put("exportRowBGColors", dsResponse.getParameter("exportRowBGColors"));
            settings.put("exportColumnBGColors", dsResponse.getParameter("exportColumnBGColors"));
            settings.put("exportRawValues", dsResponse.getParameter("exportRawValues"));
            settings.put("exportCurrencySymbol", dsResponse.getParameter("exportCurrencySymbol"));
            settings.put("exportHeaderHeight", dsResponse.getParameter("exportHeaderHeight"));
            settings.put("exportHeaderSpans", dsResponse.getParameter("exportHeaderSpans"));
            settings.put("exportFieldPixelWidths", dsResponse.getParameter("exportFieldPixelWidths"));
            settings.put("exportWidthScale", dsResponse.getParameter("exportWidthScale"));
            settings.put("exportWrapHeaderTitles", dsResponse.getParameter("exportWrapHeaderTitles"));
            settings.put("exportAlignments", dsResponse.getParameter("exportAlignments"));
            settings.put("exportStreaming", dsResponse.getParameter("exportStreaming"));
            settings.put("exportPropertyIdentifier", dsResponse.getParameter("exportPropertyIdentifier"));
            settings.put("exportTZ", dsResponse.getParameter("exportTZ"));
            settings.put("exportValueFields", DataTools.asBooleanObject(dsResponse.getParameter("exportValueFields")));
            if (dsRequest.getValues(false) != null && dsRequest.getValues(false).size() != 0) {
                settings.put("useTitlesAsAttributeNames", true);
            } else {
                settings.put("useTitlesAsAttributeNames", false);
            }
            if (dsResponse.getStatus() != 0 && (dataMap = dsResponse.getDataMap()) != null) {
                HashMap errMap = new HashMap();
                Iterator iter = dataMap.keySet().iterator();
                if (iter.hasNext()) {
                    String key = (String)iter.next();
                    errMap.put("error", dataMap.get(key));
                }
                data.clear();
                data.add(errMap);
                exportFields = new ArrayList<String>();
                exportFields.add("error");
                settings.put("exportFields", exportFields);
                settings.put("exportHeaderless", true);
                settings.put("errors", true);
            }
            DataExport de = DataExport.getDataExport(settings, dsRequest);
            Object os = null;
            String fileName = dsResponse.getExportFilename();
            if (fileName == null) {
                fileName = "export";
            }
            if (fileName.indexOf(".") == -1) {
                fileName = fileName + "." + ("ooxml".equals(exportAs) ? "xlsx" : exportAs);
            }
            String qname = config.getPath("export.location");
            OutputStream fileOutputStream = null;
            if (!config.getBoolean((Object)"export.allow.filesystem", false) && dsResponse.shouldExportToFilesystem().booleanValue()) {
                log.warn("Cannot export to filesystem because the system is not configured to allow it. Add 'export.allow.filesystem: true' to your server.properties file to correct this");
                dsResponse.setExportToFilesystem(false);
            } else if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                String path;
                if (qname == null) {
                    qname = "";
                }
                if (!qname.endsWith("/") && qname.length() > 0) {
                    qname = qname + "/";
                }
                if ((path = dsResponse.getExportPath()) != null) {
                    qname = qname + path;
                }
                if (!qname.endsWith("/") && qname.length() > 0) {
                    qname = qname + "/";
                }
                if (fileName != null) {
                    qname = qname + fileName;
                }
                fileOutputStream = new BufferedOutputStream((OutputStream)((Object)new AtomicFileOutputStream(qname)));
                os = fileOutputStream;
            }
            if (dsRequest.shouldExportToClient()) {
                this.context.setContentType(DataExport.getMimeTypeForFormat(exportAs));
                if (dsResponse.getExportDisplay().equals("download")) {
                    this.setContentDispositionHeader("attachment", dsResponse.getExportFilename(), fileName);
                } else {
                    this.setContentDispositionHeader("inline", dsResponse.getExportFilename(), fileName);
                }
                os = fileOutputStream == null ? this.context.response.getOutputStream() : new TeeOutputStream(fileOutputStream, (OutputStream)this.context.response.getOutputStream());
            }
            if (iterator == null) {
                iterator = data.iterator();
            }
            int contentLength = de.exportResultSet(iterator, fieldMap, (OutputStream)os, dsResponse);
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (!dsRequest.shouldExportToClient() && !dsRequest.getExportObjectCalled()) {
                JSTranslater jsTrans = JSTranslater.instance();
                jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
                jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
                jsTrans.setObfuscation(false);
                jsTrans = this.setEnumProperties(jsTrans);
                ValidationContext vc = new ValidationContext();
                vc.setDSRequest(dsRequest);
                jsTrans.setTypeLookupVC(vc);
                DSResponse clientResponse = new DSResponse();
                clientResponse.setStatus(0);
                if (dsResponse.shouldExportToFilesystem().booleanValue()) {
                    clientResponse.setData("Successfully exported " + qname);
                }
                ArrayList<Map> responseList = new ArrayList<Map>();
                responseList.add(clientResponse.getJSResponse());
                this.context.out().write(structuredRPCStart);
                jsTrans.toJS(responseList, this.context.out());
                this.context.out().write(structuredRPCEnd);
                vc.freeResources();
            }
        } else if (dsResponse.shouldSendExportResponse().booleanValue()) {
            JSTranslater jsTrans = JSTranslater.instance();
            jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
            jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
            jsTrans.setObfuscation(false);
            jsTrans = this.setEnumProperties(jsTrans);
            ValidationContext vc = new ValidationContext();
            vc.setDSRequest(dsRequest);
            jsTrans.setTypeLookupVC(vc);
            DSResponse clientResponse = new DSResponse();
            clientResponse.setStatus(0);
            clientResponse.setData(dsResponse.getData());
            ArrayList<Map> responseList = new ArrayList<Map>();
            responseList.add(clientResponse.getJSResponse());
            this.context.out().write(structuredRPCStart);
            jsTrans.toJS(responseList, this.context.out());
            this.context.out().write(structuredRPCEnd);
            vc.freeResources();
        }
        return dsRequest.shouldExportToClient() || !dsRequest.sendRegularDSResponse();
    }

    private void reportErrorAsDownload(String message) throws Exception {
        if (this.shouldReportDownloadErrorsAsDocuments()) {
            this.context.out().write(message);
        }
        log.warn(message);
    }

    protected void freeRPCResources() {
        for (BaseRequest baseRequest : this.associatedRequests) {
            if (this.requests.contains(baseRequest)) continue;
            baseRequest.freeResources();
            baseRequest.freeQueueResources();
        }
    }

    public boolean queueHasFailures() {
        return this.dsTransaction.queueHasFailures();
    }

    public void skipRemainingQueue() {
        this.dsTransaction.skipRemainingQueue();
    }

    public DSResponse findLastResponse(String dsName, String opType) {
        return (DSResponse)this.dsTransaction.findLastResponse(dsName, opType);
    }

    public DSResponse findFirstResponse(String dsName, String opType) {
        return (DSResponse)this.dsTransaction.findFirstResponse(dsName, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSTranslater setEnumProperties(JSTranslater jsTrans) throws Exception {
        BaseRequest requestObj = null;
        for (int i = 0; i < this.requests.size() && !(requestObj instanceof DSRequest); ++i) {
            requestObj = this.requests.get(i);
        }
        if (requestObj instanceof DSRequest) {
            String dsName = ((DSRequest)requestObj).getDataSourceName();
            if (dsName == null) {
                return jsTrans;
            }
            DataSource ds = ((DSRequest)requestObj).getDataSource();
            boolean freeDS = false;
            if (ds == null) {
                ds = DataSourceManager.getDataSource(dsName, (DSRequest)requestObj);
                freeDS = true;
            }
            if (ds == null) {
                return jsTrans;
            }
            try {
                jsTrans.setEnumTranslateStrategy(ds.getEnumTranslateStrategy());
                jsTrans.setEnumOrdinalProperty(ds.getEnumOrdinalProperty());
                jsTrans.setEnumConstantProperty(ds.getEnumConstantProperty());
            }
            finally {
                if (freeDS) {
                    DataSourceManager.freeDataSource(ds);
                }
            }
        }
        return jsTrans;
    }

    public String encodeURIComponent(String s) {
        String result;
        try {
            if (s == null) {
                s = "";
            }
            result = URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            result = s;
        }
        return result;
    }

    public void setContentDispositionHeader(String contentDisposition, String fileNameInURL, String fallbackFileName) {
        String fileNameEncoding = "";
        if (!config.getBoolean((Object)"RPCManager.downloadsRelyOnFilenameInURL", true) || fileNameInURL == null) {
            fileNameEncoding = this.encodeFilename(fileNameInURL != null ? fileNameInURL : fallbackFileName);
        }
        this.context.response.addHeader("content-disposition", contentDisposition + "; " + fileNameEncoding);
    }

    public String encodeFilename(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        String fileNameEncoding = "filename=\"" + fileName + "\"";
        fileNameEncoding = fileNameEncoding + "; filename*=UTF-8''" + this.encodeURIComponent(fileName);
        return fileNameEncoding;
    }

    public String encodeParameter(String name, String value) {
        Pattern tspecials = Pattern.compile("[<()@,;:/?={} >\"\\[\\]\\t\\\\]");
        Matcher matcher = tspecials.matcher(value);
        if (value.length() <= 78) {
            if (!matcher.find()) {
                return name + "=" + value;
            }
            return name + "=\"" + value + "\"";
        }
        return name + "=\"" + value + "\"";
    }

    private void iframeWrite(Writer out, boolean structured, Object data) throws IOException, UnconvertableException {
        RPCManager.writeIframePrefix(out, this, null, null);
        if (structured) {
            out.write(structuredRPCStart);
        }
        JSTranslater jsTrans = new JSTranslater();
        jsTrans.quoteForTextArea();
        jsTrans.omitNullMapValues(this.omitNullMapValuesInResponse);
        jsTrans.enablePrettyPrinting(this.prettyPrintResponse);
        jsTrans.setObfuscation(false);
        ValidationContext vc = new ValidationContext();
        vc.setEncodeBinaryFields(true);
        jsTrans.setTypeLookupVC(vc);
        try {
            jsTrans = this.setEnumProperties(jsTrans);
        }
        catch (Exception e) {
            UnconvertableException uce = new UnconvertableException();
            uce.initCause(e);
            throw uce;
        }
        jsTrans.toJS(data, out);
        if (structured) {
            out.write(structuredRPCEnd);
        }
        RPCManager.writeIframePostfix(out);
    }

    private void writeCustomIFramePrefix(Writer out) throws IOException {
        if (this.customHTML != null) {
            out.write(this.customHTML);
        }
    }

    public static void writeIframePostfix(Writer out) throws IOException {
        out.write("</TEXTAREA>");
        out.write("</FORM>\n");
        out.write("</BODY></HTML>");
    }

    public static void writeIframePrefix(Writer out, RPCManager rpc, RequestContext context, String jsCallback) throws IOException {
        if (context == null && rpc != null) {
            context = rpc.getContext();
        }
        if (jsCallback == null && rpc != null) {
            jsCallback = rpc.jsCallback;
        }
        out.write("<HTML>\n");
        RPCManager.writeDocumentDomain(out, context);
        if (rpc != null) {
            rpc.writeCustomIFramePrefix(out);
        }
        out.write("<BODY ONLOAD='var results = document.formResults.results.value;" + jsCallback + "'>");
        out.write("<BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR><BR>");
        out.write("<FORM name='formResults'><TEXTAREA readonly name='results'>\n");
    }

    private void parseRequest() throws Exception {
        Object operationData;
        Boolean useStrictJSON;
        if (!RPCManager.isRPC((HttpServletRequest)this.context.request)) {
            throw new Exception("Non-RPC request ignored.");
        }
        String clientVersion = RPCManager.getClientVersion((HttpServletRequest)this.context.request);
        if (!(this.devenv || clientVersion != null && this.serverVersion.equals(clientVersion))) {
            if (clientVersion == null) {
                clientVersion = "pre-5.5b2";
            }
            log.warn("client/server version mismatch.  Client is version: " + clientVersion + ", server is version: " + this.serverVersion + " - mixing different client/server versions is generally not supported.  If you've installed a more recent client version, try clearing the browser cache and reloading the page.");
        }
        Map<Object, Object> queryParamsMap = new HashMap();
        try {
            queryParamsMap = ServletTools.parseQueryString(this.context.request.getQueryString());
        }
        catch (Exception e) {
            log.error((Object)"caught exception parsing queryParams", e);
        }
        String rawTransactionData = (String)queryParamsMap.get("_transaction");
        if (rawTransactionData == null) {
            rawTransactionData = this.context.request.getParameter("_transaction");
        }
        if (rawTransactionData == null || rawTransactionData.equals("")) {
            String logMessage = "Unexpected empty RPCManager transaction: POST'd data appears to have been removed from the request before the server framework received it. This may be due to application / server settings restricting maximum POST / file upload size, or due to security software on your server, browser or network that erroneously blocked the request, or due to bugs in servlet filters.  ";
            Writer out = this.context.out();
            ServletTools.sendHTMLStart(out);
            RPCManager.writeDocumentDomain(out, this.context);
            out.write("<SCRIPT>");
            if (RPCManager.isXmlHttp((HttpServletRequest)this.context.request) || "1".equals(queryParamsMap.get("isc_resubmit"))) {
                log.warn(logMessage + "Please see the documentation for isc.RPCResponse.STATUS_MAX_POST_SIZE_EXCEEDED");
                out.write("parent.isc.RPCManager.handleMaxPostSizeExceeded(window.name);");
            } else {
                String tnum = this.context.request.getQueryParameter("isc_tnum");
                if (this.context.request.isAborted()) {
                    log.warn((Object)("Transaction " + tnum + " aborted.  Caused by: "), this.context.request.getAbortReason());
                    out.write("parent.isc.RPCManager.handleRequestAborted(" + tnum + ");");
                } else {
                    logMessage.concat("Attempting to ask browser to retry transaction " + tnum + ".");
                    out.write("parent.isc.RPCManager.retryOperation(window.name);");
                }
                log.warn(logMessage);
            }
            out.write("</SCRIPT>");
            ServletTools.sendHTMLEnd(out);
            out.flush();
            this.context.response.flushBuffer();
            throw new ClientMustResubmitException("");
        }
        Object transactionData = null;
        log.debug("Starting request parsing");
        if (rawTransactionData.trim().startsWith("{")) {
            transactionData = JSTranslater.instance().fromJS(rawTransactionData);
        } else {
            ValidationContext validationContext = new ValidationContext();
            validationContext.setRestrictedXMLMode(true);
            validationContext.setForSCServerXML(true);
            transactionData = XML.toDSRecords(new StringReader(rawTransactionData), validationContext);
            validationContext.freeResources();
        }
        log.debug("Done request parsing");
        if (!(transactionData instanceof Map)) {
            throw new Exception("Invalid transaction format: " + (transactionData == null ? "null" : transactionData.getClass().getName()));
        }
        this.transaction = (Map)transactionData;
        this.jsCallback = (String)this.transaction.get("jscallback");
        Long transactionNum = (Long)this.transaction.get("transactionNum");
        Boolean nullValuesHandling = (Boolean)this.transaction.get("omitNullMapValuesInResponse");
        if (nullValuesHandling != null) {
            this.omitNullMapValuesInResponse(nullValuesHandling);
        }
        if ((useStrictJSON = (Boolean)this.transaction.get("useStrictJSON")) != null) {
            this.useStrictJSON(useStrictJSON);
        }
        if (this.jsCallback != null && !DataTools.isIdentifier(this.jsCallback)) {
            throw new Exception("Invalid jsCallback parameter: " + DataTools.escapeHTML(this.jsCallback));
        }
        if (IFRAME_NEW_WINDOW.equals(this.jsCallback) || IFRAME_RECURSE_UP.equals(this.jsCallback)) {
            this.jsCallback = this.generateIFrameCallback(this.jsCallback, transactionNum);
        }
        if (!((operationData = this.transaction.get("operations")) instanceof List)) {
            throw new Exception("Invalid 'operations' format" + operationData.getClass().getName());
        }
        List operations = (List)operationData;
        int requestNum = 0;
        log.debug("Processing " + operations.size() + " requests.");
        Iterator i = operations.iterator();
        while (i.hasNext()) {
            Map m;
            ++requestNum;
            Object payload = i.next();
            if (payload instanceof Map && (m = (Map)payload).get("appID") != null && m.get("operation") != null) {
                BasicDataSource ds;
                String rangeText;
                DSRequest dsRequest;
                if (!config.getBoolean((Object)"datasource.allowClientAdditionalOutputs", true)) {
                    m.remove("additionalOutputs");
                }
                if (MultiTenantDSGenerator.shouldAllowClientTenantIdParam()) {
                    m.put("tenantId", this.context.request.getParameter("isc_tenantId"));
                } else {
                    m.remove("tenantId");
                }
                Object criteria = m.remove("where");
                if (criteria != null) {
                    m.put("criteria", criteria);
                }
                if ((dsRequest = new DSRequest(m, this.context, this)).shouldStreamResults()) {
                    dsRequest.setFreeOnExecute(false);
                }
                if ((rangeText = this.context.request.getHeader("Range")) != null && rangeText.trim().length() != 0) {
                    int bytesStart = rangeText.indexOf("bytes=");
                    try {
                        if (bytesStart != -1) {
                            rangeText = rangeText.substring(bytesStart + "bytes=".length());
                            String[] rangeElements = rangeText.trim().split("-");
                            if (rangeText.startsWith("-")) {
                                dsRequest.setAttribute("httpRangeStart", new Long(-1L));
                                dsRequest.setAttribute("httpRangeEnd", Long.parseLong(rangeElements[0]));
                            } else if (rangeText.endsWith("-")) {
                                dsRequest.setAttribute("httpRangeStart", Long.parseLong(rangeElements[0]));
                                dsRequest.setAttribute("httpRangeEnd", new Long(-1L));
                            } else {
                                dsRequest.setAttribute("httpRangeStart", Long.parseLong(rangeElements[0]));
                                dsRequest.setAttribute("httpRangeEnd", Long.parseLong(rangeElements[1]));
                            }
                        }
                    }
                    catch (NumberFormatException nfe) {
                        log.warn((Object)("Failed to process HTTP Range header with value '" + this.context.request.getHeader("Range") + "'. Partial request support disabled for this request"), nfe);
                        dsRequest.removeAttribute("httpRangeStart");
                        dsRequest.removeAttribute("httpRangeEnd");
                    }
                }
                if ((ds = (BasicDataSource)dsRequest.getDataSource()) != null && DataTools.getBoolean(ds.getConfig(), "noNullUpdates")) {
                    for (Object key : m.keySet()) {
                        if (!key.equals("criteria") && !key.equals("values")) continue;
                        Map values = (Map)m.get(key);
                        for (String vKey : values.keySet()) {
                            DSField field;
                            Object value = values.get(vKey);
                            if (value != null || !ds.getSimpleBaseType((field = ds.getField(vKey)).getType()).equals("text")) continue;
                            values.put(vKey, "");
                        }
                    }
                }
                if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                    String payloadString = DataTools.prettyPrint(m);
                    if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                        payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength to desired max bytes (in server.properties) - zero disables/negative value allows arbitrary length messages].";
                    }
                    log.debug("Request #" + requestNum + " (DSRequest) payload: " + payloadString);
                }
                this.addRequest(dsRequest);
                continue;
            }
            if (payload instanceof String) {
                if ("__ISC_NULL__".equals((String)payload)) {
                    payload = null;
                } else if ("__ISC_EMPTY_STRING__".equals((String)payload)) {
                    payload = "";
                }
            }
            if (log.isDebugEnabled() && maxRequestDebugLength != 0) {
                String payloadString = DataTools.prettyPrint(payload);
                if (maxRequestDebugLength > 0 && payloadString.length() > maxRequestDebugLength) {
                    payloadString = payloadString.substring(0, maxRequestDebugLength) + "....[truncated " + (payloadString.length() - maxRequestDebugLength) + "bytes - to change, set config param RPCManager.maxRequestDebugLength to desired max bytes (in server.properties) - zero disables/negative value allows arbitrary length messages].";
                }
                log.debug("Request #" + requestNum + " (RPCRequest) data: " + payloadString);
            }
            this.addRequest(new RPCRequest(this, payload, this.context));
        }
        String localeName = this.context.request.getParameter("locale");
        if (localeName != null) {
            Locale locale = DataTools.deriveLocaleFromName(localeName);
            if (locale == null) {
                log.warn("Locale " + localeName + " was explicitly specified on the HttpServletRequest, but it is not a valid locale name.  Ignoring.");
            } else if (this.context != null) {
                this.context.setLocale(locale);
            }
        }
    }

    private String generateIFrameCallback(String jsCallback, Long transactionNum) {
        if (IFRAME_NEW_WINDOW.equals(jsCallback)) {
            return "window.opener.parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results,window)";
        }
        return "if (!(new RegExp(\"^(\\\\d{1,3}\\\\.){3}\\\\d{1,3}$\").test(document.domain))) {while (!window.isc && document.domain.indexOf(\".\") != -1 ) { try { parent.isc; break;} catch (e) {document.domain = document.domain.replace(/.*?\\./, \"\");}}}parent.isc.Comm.hiddenFrameReply(" + transactionNum + ",results)";
    }

    public void addRequest(BaseRequest request) {
        this.requests.add(request);
    }

    public Long getTransactionNum() {
        return this.transactionNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestTimer requestTimer = new RequestTimer(request);
        RPCManager rpc = null;
        try {
            RequestContext.instance((ServletRequest)request, (ServletResponse)response);
            try {
                rpc = new RPCManager(null, request, response);
            }
            catch (ClientMustResubmitException cmre) {
                requestTimer.stop();
                try {
                    response.flushBuffer();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            rpc.processRPCTransaction();
        }
        catch (Throwable e) {
            log.forceError((Object)"Error processing RPC Request: ", Reflection.getRealTargetException(e));
            ServletTools.handleServletError(response, " top-level exception", e);
        }
        finally {
            requestTimer.stop();
            try {
                response.flushBuffer();
            }
            catch (IOException iOException) {}
        }
    }

    public void processRPCTransaction() throws Exception {
        log.info("Performing " + this.requestCount() + " operation(s)");
        for (BaseRequest r : this.getRequests()) {
            if (r instanceof RPCRequest) {
                RPCRequest rpcRequest = (RPCRequest)r;
                this.send(rpcRequest, rpcRequest.execute());
                continue;
            }
            DSRequest dsRequest = (DSRequest)r;
            try {
                this.send(dsRequest, dsRequest.execute());
            }
            catch (Exception e) {
                log.forceError((Object)("Error executing operation: " + dsRequest.getOperation()), e);
                this.sendFailure((Object)dsRequest, e);
            }
        }
    }

    public DataSource getDataSource(String dsName) throws Exception {
        return this.getDataSource(dsName, null);
    }

    public DataSource getDataSource(String dsName, DSRequest dsRequest) throws Exception {
        String tenantId = MultiTenantDSGenerator.getRPCManagerTenantId(this);
        return this.dsTransaction.getDataSource(dsName, dsRequest, tenantId);
    }

    public void freeDataSources() throws Exception {
        this.dsTransaction.freeDataSources();
    }

    @Deprecated
    public void initiateRequestProcessing() throws Exception {
        this.dsTransaction.initiateRequestProcessing();
    }

    @Deprecated
    public DSResponse findResponse(String firstOrLast, String dsName, String opType) {
        return (DSResponse)this.dsTransaction.findResponse(firstOrLast, dsName, opType);
    }

    @Deprecated
    public Object findResponseData(String firstOrLast, String dsName, String opType) {
        return this.dsTransaction.findResponseData(firstOrLast, dsName, opType);
    }

    public void setUserId(String userId) {
        this.dsTransaction.setUserId(userId);
    }

    public String getUserId() {
        if (this.dsTransaction.getUserId() != null) {
            return this.dsTransaction.getUserId();
        }
        if (this.context.request != null) {
            return this.context.request.getRemoteUser();
        }
        return null;
    }

    public RPCManager setTenantId(String tenantId) {
        this.dsTransaction.setTenantId(tenantId);
        return this;
    }

    public String getTenantId() {
        return this.dsTransaction.getTenantId();
    }

    public boolean hasTenantId() {
        return this.dsTransaction.getTenantId() != null;
    }

    public Boolean getAuthenticated() {
        return this.dsTransaction.getAuthenticated();
    }

    public void setAuthenticated(boolean authenticated) {
        this.dsTransaction.setAuthenticated(authenticated);
    }

    public void setAuthenticated(Boolean newValue) {
        this.dsTransaction.setAuthenticated(newValue);
    }

    public List getUserRoles() {
        return this.dsTransaction.getUserRoles();
    }

    public void setUserRoles(String rolesString) {
        this.dsTransaction.setUserRoles(rolesString);
    }

    public void setUserRoles(String ... roles) {
        String[] stringArray;
        if (roles == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = roles;
        }
        String[] rolesString = stringArray;
        this.dsTransaction.setUserRoles(Arrays.asList(rolesString));
    }

    public void setUserRoles(List rolesList) {
        this.dsTransaction.setUserRoles(rolesList);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    public void registerCallback(RPCManagerCompletionCallback callback) {
        this.callbacks.add(callback);
    }

    public int getTransactionPolicy() {
        return this.dsTransaction.getTransactionPolicy();
    }

    public void setTransactionPolicy(int tp) throws QueueAlreadyStartedException {
        this.dsTransaction.setTransactionPolicy(tp);
    }

    public boolean requestQueueIncludesPriorUpdate(DSRequest req) {
        return this._requestQueueIncludesPriorUpdate(req);
    }

    public boolean requestQueueIncludesUpdates() {
        return this._requestQueueIncludesPriorUpdate(null);
    }

    private boolean _requestQueueIncludesPriorUpdate(DSRequest req) {
        try {
            if (req != null && req.getDataSource().isModificationRequest(req)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (BaseRequest requestObj : this.requests) {
            if (requestObj.equals(req)) {
                return false;
            }
            if (!(requestObj instanceof DSRequest)) continue;
            DSRequest request = (DSRequest)requestObj;
            try {
                if (!request.getDataSource().isModificationRequest(request)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public Connection startSQLTransaction(DSRequest dsReq) throws Exception {
        if (dsReq != null) {
            DataSource ds = dsReq.getDataSource();
            if (ds instanceof ISQLDataSource) {
                dsReq.registerFreeResourcesHandler(ds);
                return ((ISQLDataSource)((Object)ds)).getTransactionalConnection(dsReq);
            }
            log.warn("RPCManager.startSQLTransaction is only applicable to SQL DataSources but was called for a DSRequest on a non-SQL DataSource ('" + ds.getName() + "', which is of type " + ds.getClass().getCanonicalName() + ")");
        }
        return null;
    }

    public void dumpResponseMap() {
        log.debug(this.responseMap);
    }

    public void addAssociatedRequest(BaseRequest request) {
        this.associatedRequests.add(request);
    }

    public Map<String, DataSource> getCachedDataSourceInstances() {
        return this.cachedDataSources;
    }

    public Boolean shouldTrackTimings() {
        return this._shouldTrackTimings;
    }

    public void setShouldTrackTimings(Boolean newValue) {
        this._shouldTrackTimings = newValue;
    }
}

