/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource.cachesync;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.cachesync.CacheSyncStrategy;
import com.isomorphic.datasource.cachesync.RequestValuesStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenericRefetchStrategy
extends CacheSyncStrategy {
    @Override
    public boolean worksForBatchAdd(DSRequest request) throws Exception {
        DataSource ds = request.getDataSource();
        List<String> keys = ds.getPrimaryKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (!"sequence".equals(ds.getField(keys.get(i)).getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getCacheSyncData(DSRequest request, DSResponse resp) throws Exception {
        if (!this.isCacheSyncFetchAllowed(request, resp)) {
            return new RequestValuesStrategy().getCacheSyncData(request, resp);
        }
        DataSource ds = request.getDataSource();
        DSRequest refetch = new DSRequest(ds.getName(), "fetch", request.getRPCManager());
        List<String> keys = ds.getPrimaryKeys();
        HashMap criteria = new HashMap();
        Map values = request.getValues();
        for (int i = 0; i < keys.size(); ++i) {
            if (!values.containsKey(keys.get(i))) {
                this.log.info("In GenericRefetchStrategy, we are missing a value for key field '" + keys.get(i) + "'.  Allowing the fetch attempt to go ahead anyway, in case the impl is able to derive missing key values");
            }
            criteria.put(keys.get(i), values.get(keys.get(i)));
        }
        refetch.setCriteria(criteria);
        String syncOp = this.getCacheSyncOperation(request);
        if (syncOp != null) {
            refetch.setOperationId(syncOp);
        }
        return refetch.execute().getDataList();
    }

    @Override
    public boolean isCacheSyncFetchAllowed(DSRequest req, DSResponse resp) {
        return true;
    }
}

