/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.ValidationContext;
import com.isomorphic.io.ISCFile;
import com.isomorphic.js.JSTranslater;
import com.isomorphic.store.DataStructCache;
import com.isomorphic.taglib.BaseTag;
import com.isomorphic.util.DataTools;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;

public class LoadSystemSchemaTag
extends BaseTag {
    public int doStartTag() throws JspException {
        this.init();
        try {
            LoadSystemSchemaTag.outputSystemSchema((Writer)this.pageContext.getOut());
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadSystemSchema tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static List<String> getFrameworkDataSources() {
        LoadSystemSchemaTag.staticInit();
        ArrayList<String> dsList = new ArrayList<String>();
        List paths = config.getCommaSeparatedList("framework.datasources");
        if (paths == null) {
            staticLog.error("LoadSystemSchemaTag.getFrameworkDataSources(): could not get framework.datasources from configuration");
            return null;
        }
        Iterator j = paths.iterator();
        while (j.hasNext()) {
            String dsDirPath = ISCFile.canonicalizePath((String)j.next());
            File dsDir = new File(dsDirPath);
            String[] files = dsDir.list();
            if (files == null) {
                staticLog.error("LoadSystemSchemaTag.getFrameworkDataSources(): the following path configured for framework.datasources is not a directory: " + dsDirPath);
                continue;
            }
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i];
                if (filename.matches("[^A-Za-z_].*") || filename.equals("Object.ds.xml") || filename.equals("FileAssembly.ds.xml") || filename.equals("FileAssemblyEntry.ds.xml") || filename.equals("Filesystem.ds.xml") || filename.equals("StreamDataSource.ds.xml") || filename.equals("ISCLogEvent.ds.xml") || filename.equals("DataSourceDataChanged.ds.xml") || !filename.endsWith(".ds.xml")) continue;
                String dsName = filename.substring(0, filename.lastIndexOf(".ds.xml"));
                dsList.add(dsName);
            }
        }
        return dsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputSystemSchema(Writer out) throws Exception {
        LoadSystemSchemaTag.staticInit();
        JSTranslater jsTrans = JSTranslater.get();
        ValidationContext vc = new ValidationContext();
        DSRequest stubRequest = new DSRequest();
        vc.setDSRequest(stubRequest);
        HashMap loadedSoFar = new HashMap();
        DataStructCache.disableDsPaths();
        try {
            out.write("\risc.loadingSystemSchema=true;\r");
            for (String name : LoadSystemSchemaTag.getFrameworkDataSources()) {
                LoadSystemSchemaTag.outputDSForName(name, out, jsTrans, loadedSoFar, vc);
            }
        }
        finally {
            out.write("\risc.loadingSystemSchema=false;\r");
            DataStructCache.enableDsPaths();
            vc.freeResources();
            stubRequest.setRequestStarted(true);
            stubRequest.freeAllResources();
        }
    }

    public static void outputDSForName(String dataSourceId, Writer out, JSTranslater jsTrans, Map loadedSoFar, ValidationContext vc) throws Exception {
        BasicDataSource ds = null;
        if (loadedSoFar.get(dataSourceId) != null) {
            return;
        }
        ds = vc.getType(dataSourceId);
        if (ds == null) {
            throw new Exception("No datasource for name: " + dataSourceId);
        }
        String superDSName = ds.getSuperDSName();
        if (superDSName != null && !"Object".equals(superDSName)) {
            LoadSystemSchemaTag.outputDSForName(superDSName, out, jsTrans, loadedSoFar, vc);
        }
        ds.setComponentSchema(true);
        jsTrans.toJS(ds, out);
        loadedSoFar.put(dataSourceId, dataSourceId);
        out.write(";\r");
    }
}

