/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class Directory {
    private File directory;
    private ArrayList childDirectories;
    private ArrayList files;
    private Directory parent;

    public Directory(File directory) {
        this(directory, null);
    }

    public Directory(File directory, Directory parent) {
        this.parent = parent;
        this.childDirectories = new ArrayList();
        this.files = new ArrayList();
        this.directory = directory;
    }

    public void addDirectory(Directory directory) {
        if (!this.childDirectories.contains(directory)) {
            this.childDirectories.add(directory);
        }
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    public Iterator directoryIterator() {
        return this.childDirectories.iterator();
    }

    public Iterator filesIterator() {
        return this.files.iterator();
    }

    public Directory getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Directory getChild(File dir) {
        for (int i = 0; i < this.childDirectories.size(); ++i) {
            Directory current = (Directory)this.childDirectories.get(i);
            if (!current.getDirectory().equals(dir)) continue;
            return current;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Directory)) {
            return false;
        }
        Directory d = (Directory)obj;
        return this.directory.equals(d.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    public String[] getPath() {
        return Directory.getPath(this.directory.getAbsolutePath());
    }

    public static String[] getPath(String thePath) {
        StringTokenizer tokenizer = new StringTokenizer(thePath, File.separator);
        String[] path = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            path[i] = tokenizer.nextToken();
            ++i;
        }
        return path;
    }

    public int fileSize() {
        return this.files.size();
    }
}

