/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.IncludeFromDefinition;
import com.isomorphic.datasource.UnionDataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.sql.SQLExpression;
import com.isomorphic.sql.SQLExpressions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SQLSelectClause
extends Base {
    private static Logger log = new Logger(SQLSelectClause.class.getName());
    private String groupByString = null;
    private String groupByWithAliasString = null;
    private DSRequest request;
    List<String> sortFields;
    private SQLExpressions sqlExpressions;

    public SQLSelectClause(SQLExpressions sqlExpressions) throws Exception {
        this.sqlExpressions = sqlExpressions;
        this.request = sqlExpressions.getRequest();
        this.sortFields = sqlExpressions.getSortFields();
    }

    public void setSqlExpressions(SQLExpressions sqlExpressions) {
        this.sqlExpressions = sqlExpressions;
    }

    public String getSQLString() throws Exception {
        Iterator<Object> e;
        boolean unionMode = Boolean.TRUE.equals(this.request.getAttribute("unionMode"));
        UnionDataSource unionDS = (UnionDataSource)this.request.getAttribute("unionDataSource");
        List outputs = unionMode ? this.request.getOutputs() : this.request.getConsolidatedOutputs();
        LinkedHashMap<String, SQLExpression> orderedOutputs = null;
        if (outputs != null && Boolean.TRUE.equals(this.request.getAttribute("enforceOutputsFieldOrder"))) {
            SQLExpression expression;
            orderedOutputs = new LinkedHashMap<String, SQLExpression>();
            for (int i = 0; i < outputs.size(); ++i) {
                String unionFieldName;
                String fieldName = (String)outputs.get(i);
                expression = this.sqlExpressions.getExpression(fieldName);
                if (expression == null && unionMode && unionDS != null && (unionFieldName = unionDS.getOriginalFieldName(this.request.getDataSource(), fieldName)) != null) {
                    fieldName = unionFieldName;
                    expression = this.sqlExpressions.getExpression(fieldName);
                }
                if (expression != null && !expression.isExcluded()) {
                    orderedOutputs.put(fieldName, expression);
                }
                if (expression != null || !unionMode) continue;
                orderedOutputs.put(fieldName, expression);
            }
            if (this.sortFields != null) {
                for (String fieldName : this.sortFields) {
                    expression = this.sqlExpressions.getExpression(fieldName);
                    if (expression == null || expression.isExcluded()) continue;
                    orderedOutputs.put(fieldName, expression);
                }
            }
        }
        StringBuffer result = new StringBuffer();
        StringBuffer groupByResult = new StringBuffer();
        StringBuffer groupByWithAliasResult = new StringBuffer();
        if (this.request.isSummary()) {
            ArrayList<String> summaryFields = new ArrayList<String>();
            List requestSummaryFields = this.request.getSummaryFields();
            List requestGroupBy = this.request.getGroupBy();
            Map requestSummaryFunctions = this.request.getSummaryFunctions();
            if (requestGroupBy != null) {
                for (String s : requestGroupBy) {
                    if (!requestSummaryFields.contains(s)) continue;
                    summaryFields.add(s);
                }
            }
            if (requestSummaryFunctions != null) {
                for (String s : requestSummaryFunctions.keySet()) {
                    if (!requestSummaryFields.contains(s)) continue;
                    summaryFields.add(s);
                }
            }
            e = summaryFields.size() == this.request.getSummaryFields().size() && summaryFields.containsAll(this.request.getSummaryFields()) ? summaryFields.iterator() : this.request.getSummaryFields().iterator();
        } else {
            e = orderedOutputs != null && !orderedOutputs.isEmpty() ? orderedOutputs.keySet().iterator() : (outputs != null && !outputs.isEmpty() ? outputs.iterator() : (SQLExpressions.getRequestExpressions(this.request) != null ? SQLExpressions.getRequestExpressions(this.request).keySet().iterator() : null));
        }
        while (e != null && e.hasNext()) {
            SQLExpression expression;
            boolean sortField;
            String rsName = (String)e.next();
            if (this.request.getDroppedFields() != null && this.request.getDroppedFields().contains(rsName)) continue;
            boolean includeInSelect = true;
            List groupByList = this.request.getGroupBy();
            boolean includeInGroupBy = this.request.isSummary() && groupByList != null && groupByList.contains(rsName);
            boolean bl = sortField = this.sortFields != null && this.sortFields.contains(rsName);
            if (!sortField && this.request.getConsolidatedOutputs() != null && !this.request.getConsolidatedOutputs().contains(rsName)) {
                includeInSelect = false;
            }
            if (this.request.skipField(rsName) && !sortField || this.request.isStaticValueField(rsName)) continue;
            if (outputs != null) {
                if (!outputs.contains(rsName) && !includeInGroupBy) continue;
                rsName = IncludeFromDefinition.getFieldNameForInclusion((String)rsName);
            }
            if ((expression = SQLExpressions.getExpression(this.request, rsName, true)) == null && !unionMode) continue;
            if (expression != null) {
                if (expression.isQueryField() || expression.isExcluded()) continue;
                IncludeFromDefinition incFrom = expression.getIncludeFrom();
                if (incFrom != null && (incFrom.isCriteria() && !this.request.selectCriteriaFields() || incFrom.isSortBy() && !this.request.selectSortByFields())) {
                    includeInSelect = false;
                }
            }
            if (includeInSelect) {
                if (result.length() != 0) {
                    result.append(", ");
                }
                if (expression == null) {
                    result.append("null AS " + rsName);
                } else {
                    result.append(expression.getExprFullWithAlias());
                }
            }
            if (expression == null || !includeInGroupBy) continue;
            if (groupByResult.length() != 0) {
                groupByResult.append(", ");
            }
            groupByResult.append(expression.getExprFull());
            if (groupByWithAliasResult.length() != 0) {
                groupByWithAliasResult.append(", ");
            }
            groupByWithAliasResult.append(expression.getExprFullWithAlias());
        }
        if (groupByResult != null && groupByResult.length() > 0) {
            this.groupByString = groupByResult.toString();
            this.groupByWithAliasString = groupByWithAliasResult.toString();
        }
        if (result.length() == 0) {
            log.warning((Object)"SQLSelectClause is null or zero size, remap and conversions won't work!");
            if (this.request.getPrimaryDSRequest() != null && this.request.getPrimaryDSRequest() != this.request) {
                return "null";
            }
            return "*";
        }
        return result.toString();
    }

    public String getGroupByString() {
        return this.groupByString;
    }

    public String getGroupByWithAliasString() {
        return this.groupByWithAliasString;
    }

    public boolean isGroupBy() {
        return this.groupByString != null;
    }
}

