/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Opcodes;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.xml.SAXCodeAdapter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ASMContentHandler
extends DefaultHandler
implements Opcodes {
    private final List stack = new ArrayList();
    String match = "";
    protected boolean computeMax;
    protected OutputStream os;
    protected ClassWriter cw;
    protected Map labels;
    private static final String BASE = "class";
    private final RuleSet RULES = new RuleSet();
    static final Map OPCODES = new HashMap();
    static final Map TYPES;

    private static void addOpcode(String string, int n, int n2) {
        OPCODES.put(string, new Opcode(n, n2));
    }

    public ASMContentHandler(OutputStream outputStream, boolean bl) {
        this.RULES.add(BASE, new ClassRule());
        this.RULES.add("class/interfaces/interface", new InterfaceRule());
        this.RULES.add("class/interfaces", new InterfacesRule());
        this.RULES.add("class/outerclass", new OuterClassRule());
        this.RULES.add("class/innerclass", new InnerClassRule());
        this.RULES.add("class/source", new SourceRule());
        this.RULES.add("class/field", new FieldRule());
        this.RULES.add("class/method", new MethodRule());
        this.RULES.add("class/method/exceptions/exception", new ExceptionRule());
        this.RULES.add("class/method/exceptions", new ExceptionsRule());
        this.RULES.add("class/method/annotationDefault", new AnnotationDefaultRule());
        this.RULES.add("class/method/code/*", new OpcodesRule());
        this.RULES.add("class/method/code/frame", new FrameRule());
        this.RULES.add("class/method/code/frame/local", new FrameTypeRule());
        this.RULES.add("class/method/code/frame/stack", new FrameTypeRule());
        this.RULES.add("class/method/code/TABLESWITCH", new TableSwitchRule());
        this.RULES.add("class/method/code/TABLESWITCH/label", new TableSwitchLabelRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH", new LookupSwitchRule());
        this.RULES.add("class/method/code/LOOKUPSWITCH/label", new LookupSwitchLabelRule());
        this.RULES.add("class/method/code/Label", new LabelRule());
        this.RULES.add("class/method/code/TryCatch", new TryCatchRule());
        this.RULES.add("class/method/code/LineNumber", new LineNumberRule());
        this.RULES.add("class/method/code/LocalVar", new LocalVarRule());
        this.RULES.add("class/method/code/Max", new MaxRule());
        this.RULES.add("*/annotation", new AnnotationRule());
        this.RULES.add("*/parameterAnnotation", new AnnotationParameterRule());
        this.RULES.add("*/annotationValue", new AnnotationValueRule());
        this.RULES.add("*/annotationValueAnnotation", new AnnotationValueAnnotationRule());
        this.RULES.add("*/annotationValueEnum", new AnnotationValueEnumRule());
        this.RULES.add("*/annotationValueArray", new AnnotationValueArrayRule());
        this.os = outputStream;
        this.computeMax = bl;
    }

    public byte[] toByteArray() {
        return this.cw == null ? null : this.cw.toByteArray();
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2 == null || string2.length() == 0 ? string3 : string2;
        StringBuffer stringBuffer = new StringBuffer(this.match);
        if (this.match.length() > 0) {
            stringBuffer.append('/');
        }
        stringBuffer.append(string4);
        this.match = stringBuffer.toString();
        Rule rule = (Rule)this.RULES.match(this.match);
        if (rule != null) {
            rule.begin(string4, attributes);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        int n;
        String string4 = string2 == null || string2.length() == 0 ? string3 : string2;
        Rule rule = (Rule)this.RULES.match(this.match);
        if (rule != null) {
            rule.end(string4);
        }
        this.match = (n = this.match.lastIndexOf(47)) >= 0 ? this.match.substring(0, n) : "";
    }

    public final void endDocument() throws SAXException {
        try {
            this.os.write(this.toByteArray());
        }
        catch (IOException iOException) {
            throw new SAXException(iOException.toString(), iOException);
        }
    }

    final Object peek() {
        int n = this.stack.size();
        return n == 0 ? null : this.stack.get(n - 1);
    }

    final Object pop() {
        int n = this.stack.size();
        return n == 0 ? null : this.stack.remove(n - 1);
    }

    final void push(Object object) {
        this.stack.add(object);
    }

    static {
        ASMContentHandler.addOpcode("NOP", 0, 0);
        ASMContentHandler.addOpcode("ACONST_NULL", 1, 0);
        ASMContentHandler.addOpcode("ICONST_M1", 2, 0);
        ASMContentHandler.addOpcode("ICONST_0", 3, 0);
        ASMContentHandler.addOpcode("ICONST_1", 4, 0);
        ASMContentHandler.addOpcode("ICONST_2", 5, 0);
        ASMContentHandler.addOpcode("ICONST_3", 6, 0);
        ASMContentHandler.addOpcode("ICONST_4", 7, 0);
        ASMContentHandler.addOpcode("ICONST_5", 8, 0);
        ASMContentHandler.addOpcode("LCONST_0", 9, 0);
        ASMContentHandler.addOpcode("LCONST_1", 10, 0);
        ASMContentHandler.addOpcode("FCONST_0", 11, 0);
        ASMContentHandler.addOpcode("FCONST_1", 12, 0);
        ASMContentHandler.addOpcode("FCONST_2", 13, 0);
        ASMContentHandler.addOpcode("DCONST_0", 14, 0);
        ASMContentHandler.addOpcode("DCONST_1", 15, 0);
        ASMContentHandler.addOpcode("BIPUSH", 16, 1);
        ASMContentHandler.addOpcode("SIPUSH", 17, 1);
        ASMContentHandler.addOpcode("LDC", 18, 7);
        ASMContentHandler.addOpcode("ILOAD", 21, 2);
        ASMContentHandler.addOpcode("LLOAD", 22, 2);
        ASMContentHandler.addOpcode("FLOAD", 23, 2);
        ASMContentHandler.addOpcode("DLOAD", 24, 2);
        ASMContentHandler.addOpcode("ALOAD", 25, 2);
        ASMContentHandler.addOpcode("IALOAD", 46, 0);
        ASMContentHandler.addOpcode("LALOAD", 47, 0);
        ASMContentHandler.addOpcode("FALOAD", 48, 0);
        ASMContentHandler.addOpcode("DALOAD", 49, 0);
        ASMContentHandler.addOpcode("AALOAD", 50, 0);
        ASMContentHandler.addOpcode("BALOAD", 51, 0);
        ASMContentHandler.addOpcode("CALOAD", 52, 0);
        ASMContentHandler.addOpcode("SALOAD", 53, 0);
        ASMContentHandler.addOpcode("ISTORE", 54, 2);
        ASMContentHandler.addOpcode("LSTORE", 55, 2);
        ASMContentHandler.addOpcode("FSTORE", 56, 2);
        ASMContentHandler.addOpcode("DSTORE", 57, 2);
        ASMContentHandler.addOpcode("ASTORE", 58, 2);
        ASMContentHandler.addOpcode("IASTORE", 79, 0);
        ASMContentHandler.addOpcode("LASTORE", 80, 0);
        ASMContentHandler.addOpcode("FASTORE", 81, 0);
        ASMContentHandler.addOpcode("DASTORE", 82, 0);
        ASMContentHandler.addOpcode("AASTORE", 83, 0);
        ASMContentHandler.addOpcode("BASTORE", 84, 0);
        ASMContentHandler.addOpcode("CASTORE", 85, 0);
        ASMContentHandler.addOpcode("SASTORE", 86, 0);
        ASMContentHandler.addOpcode("POP", 87, 0);
        ASMContentHandler.addOpcode("POP2", 88, 0);
        ASMContentHandler.addOpcode("DUP", 89, 0);
        ASMContentHandler.addOpcode("DUP_X1", 90, 0);
        ASMContentHandler.addOpcode("DUP_X2", 91, 0);
        ASMContentHandler.addOpcode("DUP2", 92, 0);
        ASMContentHandler.addOpcode("DUP2_X1", 93, 0);
        ASMContentHandler.addOpcode("DUP2_X2", 94, 0);
        ASMContentHandler.addOpcode("SWAP", 95, 0);
        ASMContentHandler.addOpcode("IADD", 96, 0);
        ASMContentHandler.addOpcode("LADD", 97, 0);
        ASMContentHandler.addOpcode("FADD", 98, 0);
        ASMContentHandler.addOpcode("DADD", 99, 0);
        ASMContentHandler.addOpcode("ISUB", 100, 0);
        ASMContentHandler.addOpcode("LSUB", 101, 0);
        ASMContentHandler.addOpcode("FSUB", 102, 0);
        ASMContentHandler.addOpcode("DSUB", 103, 0);
        ASMContentHandler.addOpcode("IMUL", 104, 0);
        ASMContentHandler.addOpcode("LMUL", 105, 0);
        ASMContentHandler.addOpcode("FMUL", 106, 0);
        ASMContentHandler.addOpcode("DMUL", 107, 0);
        ASMContentHandler.addOpcode("IDIV", 108, 0);
        ASMContentHandler.addOpcode("LDIV", 109, 0);
        ASMContentHandler.addOpcode("FDIV", 110, 0);
        ASMContentHandler.addOpcode("DDIV", 111, 0);
        ASMContentHandler.addOpcode("IREM", 112, 0);
        ASMContentHandler.addOpcode("LREM", 113, 0);
        ASMContentHandler.addOpcode("FREM", 114, 0);
        ASMContentHandler.addOpcode("DREM", 115, 0);
        ASMContentHandler.addOpcode("INEG", 116, 0);
        ASMContentHandler.addOpcode("LNEG", 117, 0);
        ASMContentHandler.addOpcode("FNEG", 118, 0);
        ASMContentHandler.addOpcode("DNEG", 119, 0);
        ASMContentHandler.addOpcode("ISHL", 120, 0);
        ASMContentHandler.addOpcode("LSHL", 121, 0);
        ASMContentHandler.addOpcode("ISHR", 122, 0);
        ASMContentHandler.addOpcode("LSHR", 123, 0);
        ASMContentHandler.addOpcode("IUSHR", 124, 0);
        ASMContentHandler.addOpcode("LUSHR", 125, 0);
        ASMContentHandler.addOpcode("IAND", 126, 0);
        ASMContentHandler.addOpcode("LAND", 127, 0);
        ASMContentHandler.addOpcode("IOR", 128, 0);
        ASMContentHandler.addOpcode("LOR", 129, 0);
        ASMContentHandler.addOpcode("IXOR", 130, 0);
        ASMContentHandler.addOpcode("LXOR", 131, 0);
        ASMContentHandler.addOpcode("IINC", 132, 8);
        ASMContentHandler.addOpcode("I2L", 133, 0);
        ASMContentHandler.addOpcode("I2F", 134, 0);
        ASMContentHandler.addOpcode("I2D", 135, 0);
        ASMContentHandler.addOpcode("L2I", 136, 0);
        ASMContentHandler.addOpcode("L2F", 137, 0);
        ASMContentHandler.addOpcode("L2D", 138, 0);
        ASMContentHandler.addOpcode("F2I", 139, 0);
        ASMContentHandler.addOpcode("F2L", 140, 0);
        ASMContentHandler.addOpcode("F2D", 141, 0);
        ASMContentHandler.addOpcode("D2I", 142, 0);
        ASMContentHandler.addOpcode("D2L", 143, 0);
        ASMContentHandler.addOpcode("D2F", 144, 0);
        ASMContentHandler.addOpcode("I2B", 145, 0);
        ASMContentHandler.addOpcode("I2C", 146, 0);
        ASMContentHandler.addOpcode("I2S", 147, 0);
        ASMContentHandler.addOpcode("LCMP", 148, 0);
        ASMContentHandler.addOpcode("FCMPL", 149, 0);
        ASMContentHandler.addOpcode("FCMPG", 150, 0);
        ASMContentHandler.addOpcode("DCMPL", 151, 0);
        ASMContentHandler.addOpcode("DCMPG", 152, 0);
        ASMContentHandler.addOpcode("IFEQ", 153, 6);
        ASMContentHandler.addOpcode("IFNE", 154, 6);
        ASMContentHandler.addOpcode("IFLT", 155, 6);
        ASMContentHandler.addOpcode("IFGE", 156, 6);
        ASMContentHandler.addOpcode("IFGT", 157, 6);
        ASMContentHandler.addOpcode("IFLE", 158, 6);
        ASMContentHandler.addOpcode("IF_ICMPEQ", 159, 6);
        ASMContentHandler.addOpcode("IF_ICMPNE", 160, 6);
        ASMContentHandler.addOpcode("IF_ICMPLT", 161, 6);
        ASMContentHandler.addOpcode("IF_ICMPGE", 162, 6);
        ASMContentHandler.addOpcode("IF_ICMPGT", 163, 6);
        ASMContentHandler.addOpcode("IF_ICMPLE", 164, 6);
        ASMContentHandler.addOpcode("IF_ACMPEQ", 165, 6);
        ASMContentHandler.addOpcode("IF_ACMPNE", 166, 6);
        ASMContentHandler.addOpcode("GOTO", 167, 6);
        ASMContentHandler.addOpcode("JSR", 168, 6);
        ASMContentHandler.addOpcode("RET", 169, 2);
        ASMContentHandler.addOpcode("IRETURN", 172, 0);
        ASMContentHandler.addOpcode("LRETURN", 173, 0);
        ASMContentHandler.addOpcode("FRETURN", 174, 0);
        ASMContentHandler.addOpcode("DRETURN", 175, 0);
        ASMContentHandler.addOpcode("ARETURN", 176, 0);
        ASMContentHandler.addOpcode("RETURN", 177, 0);
        ASMContentHandler.addOpcode("GETSTATIC", 178, 4);
        ASMContentHandler.addOpcode("PUTSTATIC", 179, 4);
        ASMContentHandler.addOpcode("GETFIELD", 180, 4);
        ASMContentHandler.addOpcode("PUTFIELD", 181, 4);
        ASMContentHandler.addOpcode("INVOKEVIRTUAL", 182, 5);
        ASMContentHandler.addOpcode("INVOKESPECIAL", 183, 5);
        ASMContentHandler.addOpcode("INVOKESTATIC", 184, 5);
        ASMContentHandler.addOpcode("INVOKEINTERFACE", 185, 5);
        ASMContentHandler.addOpcode("INVOKEDYNAMIC", 186, 5);
        ASMContentHandler.addOpcode("NEW", 187, 3);
        ASMContentHandler.addOpcode("NEWARRAY", 188, 1);
        ASMContentHandler.addOpcode("ANEWARRAY", 189, 3);
        ASMContentHandler.addOpcode("ARRAYLENGTH", 190, 0);
        ASMContentHandler.addOpcode("ATHROW", 191, 0);
        ASMContentHandler.addOpcode("CHECKCAST", 192, 3);
        ASMContentHandler.addOpcode("INSTANCEOF", 193, 3);
        ASMContentHandler.addOpcode("MONITORENTER", 194, 0);
        ASMContentHandler.addOpcode("MONITOREXIT", 195, 0);
        ASMContentHandler.addOpcode("MULTIANEWARRAY", 197, 9);
        ASMContentHandler.addOpcode("IFNULL", 198, 6);
        ASMContentHandler.addOpcode("IFNONNULL", 199, 6);
        TYPES = new HashMap();
        String[] stringArray = SAXCodeAdapter.TYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            TYPES.put(stringArray[i], new Integer(i));
        }
    }

    static final class Opcode {
        public final int opcode;
        public final int type;

        Opcode(int n, int n2) {
            this.opcode = n;
            this.type = n2;
        }
    }

    final class AnnotationDefaultRule
    extends Rule {
        AnnotationDefaultRule() {
        }

        public void begin(String string, Attributes attributes) {
            MethodVisitor methodVisitor = (MethodVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(methodVisitor == null ? null : methodVisitor.visitAnnotationDefault());
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueArrayRule
    extends Rule {
        AnnotationValueArrayRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(annotationVisitor == null ? null : annotationVisitor.visitArray(attributes.getValue("name")));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueAnnotationRule
    extends Rule {
        AnnotationValueAnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            ASMContentHandler.this.push(annotationVisitor == null ? null : annotationVisitor.visitAnnotation(attributes.getValue("name"), attributes.getValue("desc")));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationValueEnumRule
    extends Rule {
        AnnotationValueEnumRule() {
        }

        public void begin(String string, Attributes attributes) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnum(attributes.getValue("name"), attributes.getValue("desc"), attributes.getValue("value"));
            }
        }
    }

    final class AnnotationValueRule
    extends Rule {
        AnnotationValueRule() {
        }

        public void begin(String string, Attributes attributes) throws SAXException {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.peek();
            if (annotationVisitor != null) {
                annotationVisitor.visit(attributes.getValue("name"), this.getValue(attributes.getValue("desc"), attributes.getValue("value")));
            }
        }
    }

    final class AnnotationParameterRule
    extends Rule {
        AnnotationParameterRule() {
        }

        public void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("parameter"));
            String string2 = attributes.getValue("desc");
            boolean bl = Boolean.valueOf(attributes.getValue("visible"));
            ASMContentHandler.this.push(((MethodVisitor)ASMContentHandler.this.peek()).visitParameterAnnotation(n, string2, bl));
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class AnnotationRule
    extends Rule {
        AnnotationRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("desc");
            boolean bl = Boolean.valueOf(attributes.getValue("visible"));
            Object object = ASMContentHandler.this.peek();
            if (object instanceof ClassVisitor) {
                ASMContentHandler.this.push(((ClassVisitor)object).visitAnnotation(string2, bl));
            } else if (object instanceof FieldVisitor) {
                ASMContentHandler.this.push(((FieldVisitor)object).visitAnnotation(string2, bl));
            } else if (object instanceof MethodVisitor) {
                ASMContentHandler.this.push(((MethodVisitor)object).visitAnnotation(string2, bl));
            }
        }

        public void end(String string) {
            AnnotationVisitor annotationVisitor = (AnnotationVisitor)ASMContentHandler.this.pop();
            if (annotationVisitor != null) {
                annotationVisitor.visitEnd();
            }
        }
    }

    final class MaxRule
    extends Rule {
        MaxRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("maxStack"));
            int n2 = Integer.parseInt(attributes.getValue("maxLocals"));
            this.getCodeVisitor().visitMaxs(n, n2);
        }
    }

    final class OpcodesRule
    extends Rule {
        OpcodesRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            Opcode opcode = (Opcode)OPCODES.get(string);
            if (opcode == null) {
                throw new SAXException("Invalid element: " + string + " at " + ASMContentHandler.this.match);
            }
            switch (opcode.type) {
                case 0: {
                    this.getCodeVisitor().visitInsn(opcode.opcode);
                    break;
                }
                case 4: {
                    this.getCodeVisitor().visitFieldInsn(opcode.opcode, attributes.getValue("owner"), attributes.getValue("name"), attributes.getValue("desc"));
                    break;
                }
                case 1: {
                    this.getCodeVisitor().visitIntInsn(opcode.opcode, Integer.parseInt(attributes.getValue("value")));
                    break;
                }
                case 6: {
                    this.getCodeVisitor().visitJumpInsn(opcode.opcode, this.getLabel(attributes.getValue("label")));
                    break;
                }
                case 5: {
                    this.getCodeVisitor().visitMethodInsn(opcode.opcode, opcode.opcode != 186 ? attributes.getValue("owner") : "java/lang/dyn/Dynamic", attributes.getValue("name"), attributes.getValue("desc"));
                    break;
                }
                case 3: {
                    this.getCodeVisitor().visitTypeInsn(opcode.opcode, attributes.getValue("desc"));
                    break;
                }
                case 2: {
                    this.getCodeVisitor().visitVarInsn(opcode.opcode, Integer.parseInt(attributes.getValue("var")));
                    break;
                }
                case 8: {
                    this.getCodeVisitor().visitIincInsn(Integer.parseInt(attributes.getValue("var")), Integer.parseInt(attributes.getValue("inc")));
                    break;
                }
                case 7: {
                    this.getCodeVisitor().visitLdcInsn(this.getValue(attributes.getValue("desc"), attributes.getValue("cst")));
                    break;
                }
                case 9: {
                    this.getCodeVisitor().visitMultiANewArrayInsn(attributes.getValue("desc"), Integer.parseInt(attributes.getValue("dims")));
                    break;
                }
                default: {
                    throw new Error("Internal error");
                }
            }
        }
    }

    final class LocalVarRule
    extends Rule {
        LocalVarRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("desc");
            String string4 = attributes.getValue("signature");
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            int n = Integer.parseInt(attributes.getValue("var"));
            this.getCodeVisitor().visitLocalVariable(string2, string3, string4, label, label2, n);
        }
    }

    final class LineNumberRule
    extends Rule {
        LineNumberRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("line"));
            Label label = this.getLabel(attributes.getValue("start"));
            this.getCodeVisitor().visitLineNumber(n, label);
        }
    }

    final class TryCatchRule
    extends Rule {
        TryCatchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Label label = this.getLabel(attributes.getValue("start"));
            Label label2 = this.getLabel(attributes.getValue("end"));
            Label label3 = this.getLabel(attributes.getValue("handler"));
            String string2 = attributes.getValue("type");
            this.getCodeVisitor().visitTryCatchBlock(label, label2, label3, string2);
        }
    }

    final class LabelRule
    extends Rule {
        LabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            this.getCodeVisitor().visitLabel(this.getLabel(attributes.getValue("name")));
        }
    }

    final class FrameTypeRule
    extends Rule {
        FrameTypeRule() {
        }

        public void begin(String string, Attributes attributes) {
            List list = (List)((HashMap)ASMContentHandler.this.peek()).get(string);
            String string2 = attributes.getValue("type");
            if ("uninitialized".equals(string2)) {
                list.add(this.getLabel(attributes.getValue("label")));
            } else {
                Integer n = (Integer)TYPES.get(string2);
                if (n == null) {
                    list.add(string2);
                } else {
                    list.add(n);
                }
            }
        }
    }

    final class FrameRule
    extends Rule {
        FrameRule() {
        }

        public void begin(String string, Attributes attributes) {
            HashMap hashMap = new HashMap();
            hashMap.put("local", new ArrayList());
            hashMap.put("stack", new ArrayList());
            ASMContentHandler.this.push(attributes.getValue("type"));
            ASMContentHandler.this.push(attributes.getValue("count") == null ? "0" : attributes.getValue("count"));
            ASMContentHandler.this.push(hashMap);
        }

        public void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            List list = (List)map.get("local");
            int n = list.size();
            Object[] objectArray = list.toArray();
            List list2 = (List)map.get("stack");
            int n2 = list2.size();
            Object[] objectArray2 = list2.toArray();
            String string2 = (String)ASMContentHandler.this.pop();
            String string3 = (String)ASMContentHandler.this.pop();
            if ("NEW".equals(string3)) {
                this.getCodeVisitor().visitFrame(-1, n, objectArray, n2, objectArray2);
            } else if ("FULL".equals(string3)) {
                this.getCodeVisitor().visitFrame(0, n, objectArray, n2, objectArray2);
            } else if ("APPEND".equals(string3)) {
                this.getCodeVisitor().visitFrame(1, n, objectArray, 0, null);
            } else if ("CHOP".equals(string3)) {
                this.getCodeVisitor().visitFrame(2, Integer.parseInt(string2), null, 0, null);
            } else if ("SAME".equals(string3)) {
                this.getCodeVisitor().visitFrame(3, 0, null, 0, null);
            } else if ("SAME1".equals(string3)) {
                this.getCodeVisitor().visitFrame(4, 0, null, n2, objectArray2);
            }
        }
    }

    final class LookupSwitchLabelRule
    extends Rule {
        LookupSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            Map map = (Map)ASMContentHandler.this.peek();
            ((List)map.get("labels")).add(this.getLabel(attributes.getValue("name")));
            ((List)map.get("keys")).add(attributes.getValue("key"));
        }
    }

    final class LookupSwitchRule
    extends Rule {
        LookupSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            hashMap.put("keys", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            Label label = this.getLabel(map.get("dflt"));
            List list = (List)map.get("keys");
            List list2 = (List)map.get("labels");
            Label[] labelArray = list2.toArray(new Label[list2.size()]);
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = Integer.parseInt((String)list.get(i));
            }
            this.getCodeVisitor().visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    final class TableSwitchLabelRule
    extends Rule {
        TableSwitchLabelRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((HashMap)ASMContentHandler.this.peek()).get("labels")).add(this.getLabel(attributes.getValue("name")));
        }
    }

    class TableSwitchRule
    extends Rule {
        TableSwitchRule() {
        }

        public final void begin(String string, Attributes attributes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("min", attributes.getValue("min"));
            hashMap.put("max", attributes.getValue("max"));
            hashMap.put("dflt", attributes.getValue("dflt"));
            hashMap.put("labels", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = Integer.parseInt((String)map.get("min"));
            int n2 = Integer.parseInt((String)map.get("max"));
            Label label = this.getLabel(map.get("dflt"));
            List list = (List)map.get("labels");
            Label[] labelArray = list.toArray(new Label[list.size()]);
            this.getCodeVisitor().visitTableSwitchInsn(n, n2, label, labelArray);
        }
    }

    final class ExceptionsRule
    extends Rule {
        ExceptionsRule() {
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = this.getAccess((String)map.get("access"));
            String string2 = (String)map.get("name");
            String string3 = (String)map.get("desc");
            String string4 = (String)map.get("signature");
            List list = (List)map.get("exceptions");
            String[] stringArray = list.toArray(new String[list.size()]);
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitMethod(n, string2, string3, string4, stringArray));
        }
    }

    final class ExceptionRule
    extends Rule {
        ExceptionRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((HashMap)ASMContentHandler.this.peek()).get("exceptions")).add(attributes.getValue("name"));
        }
    }

    final class MethodRule
    extends Rule {
        MethodRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ASMContentHandler.this.labels = new HashMap();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("desc", attributes.getValue("desc"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("exceptions", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }

        public final void end(String string) {
            ((MethodVisitor)ASMContentHandler.this.pop()).visitEnd();
            ASMContentHandler.this.labels = null;
        }
    }

    final class FieldRule
    extends Rule {
        FieldRule() {
        }

        public final void begin(String string, Attributes attributes) throws SAXException {
            int n = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("signature");
            String string4 = attributes.getValue("desc");
            Object object = this.getValue(string4, attributes.getValue("value"));
            ASMContentHandler.this.push(ASMContentHandler.this.cw.visitField(n, string2, string4, string3, object));
        }

        public void end(String string) {
            ((FieldVisitor)ASMContentHandler.this.pop()).visitEnd();
        }
    }

    final class InnerClassRule
    extends Rule {
        InnerClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = this.getAccess(attributes.getValue("access"));
            String string2 = attributes.getValue("name");
            String string3 = attributes.getValue("outerName");
            String string4 = attributes.getValue("innerName");
            ASMContentHandler.this.cw.visitInnerClass(string2, string3, string4, n);
        }
    }

    final class OuterClassRule
    extends Rule {
        OuterClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("owner");
            String string3 = attributes.getValue("name");
            String string4 = attributes.getValue("desc");
            ASMContentHandler.this.cw.visitOuterClass(string2, string3, string4);
        }
    }

    final class InterfacesRule
    extends Rule {
        InterfacesRule() {
        }

        public final void end(String string) {
            Map map = (Map)ASMContentHandler.this.pop();
            int n = (Integer)map.get("version");
            int n2 = this.getAccess((String)map.get("access"));
            String string2 = (String)map.get("name");
            String string3 = (String)map.get("signature");
            String string4 = (String)map.get("parent");
            List list = (List)map.get("interfaces");
            String[] stringArray = list.toArray(new String[list.size()]);
            ASMContentHandler.this.cw.visit(n, n2, string2, string3, string4, stringArray);
            ASMContentHandler.this.push(ASMContentHandler.this.cw);
        }
    }

    final class InterfaceRule
    extends Rule {
        InterfaceRule() {
        }

        public final void begin(String string, Attributes attributes) {
            ((List)((HashMap)ASMContentHandler.this.peek()).get("interfaces")).add(attributes.getValue("name"));
        }
    }

    final class SourceRule
    extends Rule {
        SourceRule() {
        }

        public void begin(String string, Attributes attributes) {
            String string2 = attributes.getValue("file");
            String string3 = attributes.getValue("debug");
            ASMContentHandler.this.cw.visitSource(string2, string3);
        }
    }

    final class ClassRule
    extends Rule {
        ClassRule() {
        }

        public final void begin(String string, Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue("major"));
            int n2 = Integer.parseInt(attributes.getValue("minor"));
            ASMContentHandler.this.cw = new ClassWriter(ASMContentHandler.this.computeMax ? 1 : 0);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("version", new Integer(n2 << 16 | n));
            hashMap.put("access", attributes.getValue("access"));
            hashMap.put("name", attributes.getValue("name"));
            hashMap.put("parent", attributes.getValue("parent"));
            hashMap.put("source", attributes.getValue("source"));
            hashMap.put("signature", attributes.getValue("signature"));
            hashMap.put("interfaces", new ArrayList());
            ASMContentHandler.this.push(hashMap);
        }
    }

    protected abstract class Rule {
        protected Rule() {
        }

        public void begin(String string, Attributes attributes) throws SAXException {
        }

        public void end(String string) {
        }

        protected final Object getValue(String string, String string2) throws SAXException {
            Object object = null;
            if (string2 != null) {
                if ("Ljava/lang/String;".equals(string)) {
                    object = this.decode(string2);
                } else if ("Ljava/lang/Integer;".equals(string) || "I".equals(string) || "S".equals(string) || "B".equals(string) || "C".equals(string) || "Z".equals(string)) {
                    object = new Integer(string2);
                } else if ("Ljava/lang/Short;".equals(string)) {
                    object = new Short(string2);
                } else if ("Ljava/lang/Byte;".equals(string)) {
                    object = new Byte(string2);
                } else if ("Ljava/lang/Character;".equals(string)) {
                    object = new Character(this.decode(string2).charAt(0));
                } else if ("Ljava/lang/Boolean;".equals(string)) {
                    object = Boolean.valueOf(string2);
                } else if ("Ljava/lang/Long;".equals(string) || "J".equals(string)) {
                    object = new Long(string2);
                } else if ("Ljava/lang/Float;".equals(string) || "F".equals(string)) {
                    object = new Float(string2);
                } else if ("Ljava/lang/Double;".equals(string) || "D".equals(string)) {
                    object = new Double(string2);
                } else if (Type.getDescriptor(Type.class).equals(string)) {
                    object = Type.getType(string2);
                } else {
                    throw new SAXException("Invalid value:" + string2 + " desc:" + string + " ctx:" + this);
                }
            }
            return object;
        }

        private final String decode(String string) throws SAXException {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            try {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\\') {
                        if ((c = string.charAt(++i)) == '\\') {
                            stringBuffer.append('\\');
                            continue;
                        }
                        stringBuffer.append((char)Integer.parseInt(string.substring(++i, i + 4), 16));
                        i += 3;
                        continue;
                    }
                    stringBuffer.append(c);
                }
            }
            catch (RuntimeException runtimeException) {
                throw new SAXException(runtimeException);
            }
            return stringBuffer.toString();
        }

        protected final Label getLabel(Object object) {
            Label label = (Label)ASMContentHandler.this.labels.get(object);
            if (label == null) {
                label = new Label();
                ASMContentHandler.this.labels.put(object, label);
            }
            return label;
        }

        protected final MethodVisitor getCodeVisitor() {
            return (MethodVisitor)ASMContentHandler.this.peek();
        }

        protected final int getAccess(String string) {
            int n = 0;
            if (string.indexOf("public") != -1) {
                n |= 1;
            }
            if (string.indexOf("private") != -1) {
                n |= 2;
            }
            if (string.indexOf("protected") != -1) {
                n |= 4;
            }
            if (string.indexOf("static") != -1) {
                n |= 8;
            }
            if (string.indexOf("final") != -1) {
                n |= 0x10;
            }
            if (string.indexOf("super") != -1) {
                n |= 0x20;
            }
            if (string.indexOf("synchronized") != -1) {
                n |= 0x20;
            }
            if (string.indexOf("volatile") != -1) {
                n |= 0x40;
            }
            if (string.indexOf("bridge") != -1) {
                n |= 0x40;
            }
            if (string.indexOf("varargs") != -1) {
                n |= 0x80;
            }
            if (string.indexOf("transient") != -1) {
                n |= 0x80;
            }
            if (string.indexOf("native") != -1) {
                n |= 0x100;
            }
            if (string.indexOf("interface") != -1) {
                n |= 0x200;
            }
            if (string.indexOf("abstract") != -1) {
                n |= 0x400;
            }
            if (string.indexOf("strict") != -1) {
                n |= 0x800;
            }
            if (string.indexOf("synthetic") != -1) {
                n |= 0x1000;
            }
            if (string.indexOf("annotation") != -1) {
                n |= 0x2000;
            }
            if (string.indexOf("enum") != -1) {
                n |= 0x4000;
            }
            if (string.indexOf("deprecated") != -1) {
                n |= 0x20000;
            }
            return n;
        }
    }

    static final class RuleSet {
        private final Map rules = new HashMap();
        private final List lpatterns = new ArrayList();
        private final List rpatterns = new ArrayList();

        RuleSet() {
        }

        public void add(String string, Object object) {
            String string2 = string;
            if (string.startsWith("*/")) {
                string2 = string.substring(1);
                this.lpatterns.add(string2);
            } else if (string.endsWith("/*")) {
                string2 = string.substring(0, string.length() - 1);
                this.rpatterns.add(string2);
            }
            this.rules.put(string2, object);
        }

        public Object match(String string) {
            if (this.rules.containsKey(string)) {
                return this.rules.get(string);
            }
            int n = string.lastIndexOf(47);
            for (String string2 : this.lpatterns) {
                if (!string.substring(n).endsWith(string2)) continue;
                return this.rules.get(string2);
            }
            for (String string2 : this.rpatterns) {
                if (!string.startsWith(string2)) continue;
                return this.rules.get(string2);
            }
            return null;
        }
    }

    private static interface OpcodeGroup {
        public static final int INSN = 0;
        public static final int INSN_INT = 1;
        public static final int INSN_VAR = 2;
        public static final int INSN_TYPE = 3;
        public static final int INSN_FIELD = 4;
        public static final int INSN_METHOD = 5;
        public static final int INSN_JUMP = 6;
        public static final int INSN_LDC = 7;
        public static final int INSN_IINC = 8;
        public static final int INSN_MULTIANEWARRAY = 9;
    }
}

