/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.widgets.grid.events;

import com.google.gwt.event.shared.EventHandler;

public interface CellHoverHandler extends EventHandler {
    /**
     * Called when the mouse hovers over a cell if <code>this.canHover</code> is <code>true</code>.
     *  
     *  
     *  To suppress the hover text from being shown if <code>showHover</code> is <code>true</code>
     *  for <code>this</code> or the field, cancel the
     *  <code>CellHoverEvent</code>. For example:
     *  <pre>grid.addCellHoverHandler(new CellHoverHandler() {
     *     &#64;Override
     *     public void onCellHover(CellHoverEvent event) {
     *         if (&#47;* some condition for when to suppress the hover *&#47;) {
     *             event.cancel();
     *         }
     *     }
     * });</pre>
     *  
     * 
     * 
     *
     * @param event the event
     */
    void onCellHover(com.smartgwt.client.widgets.grid.events.CellHoverEvent event);
}
