/*
 * Isomorphic SmartGWT web presentation layer
 * Copyright 2000 and beyond Isomorphic Software, Inc.
 *
 * OWNERSHIP NOTICE
 * Isomorphic Software owns and reserves all rights not expressly granted in this source code,
 * including all intellectual property rights to the structure, sequence, and format of this code
 * and to all designs, interfaces, algorithms, schema, protocols, and inventions expressed herein.
 *
 *  If you have any questions, please email <sourcecode@isomorphic.com>.
 *
 *  This entire comment must accompany any portion of Isomorphic Software source code that is
 *  copied or moved from this file.
 */
package com.smartgwt.sample.showcase.client.chart;

import com.smartgwt.client.widgets.tree.TreeNode;

public class DynamicDataChartData extends TreeNode {

    public DynamicDataChartData(String id, String parentId, String title) {
        setID(id);
        if (parentId != null) {
            setParentID(parentId);
        }
        setTitle(title);
    }

    public static DynamicDataChartData[] getData() {
        return new DynamicDataChartData[] {
            new DynamicDataChartData("sum", null, "All Years"),
            new DynamicDataChartData("2018", "sum", "2018"),
            new DynamicDataChartData("2019", "sum", "2019"),
            new DynamicDataChartData("2020", "sum", "2020"),
            new DynamicDataChartData("Q1-2018", "2018", "Q1-2018"),
            new DynamicDataChartData("Q2-2018", "2018", "Q2-2018"),
            new DynamicDataChartData("Q3-2018", "2018", "Q3-2018"),
            new DynamicDataChartData("Q4-2018", "2018", "Q4-2018"),
            new DynamicDataChartData("Q1-2019", "2019", "Q1-2019"),
            new DynamicDataChartData("Q2-2019", "2019", "Q2-2019"),
            new DynamicDataChartData("Q3-2019", "2019", "Q3-2019"),
            new DynamicDataChartData("Q4-2019", "2019", "Q4-2019"),
            new DynamicDataChartData("Q1-2020", "2020", "Q1-2020"),
            new DynamicDataChartData("Q2-2020", "2020", "Q2-2020"),
            new DynamicDataChartData("Q3-2020", "2020", "Q3-2020"),
            new DynamicDataChartData("Q4-2020", "2020", "Q4-2020"),
            new DynamicDataChartData("1/1/2018", "Q1-2018", "1/1/2018"),
            new DynamicDataChartData("2/1/2018", "Q1-2018", "2/1/2018"),
            new DynamicDataChartData("3/1/2018", "Q1-2018", "3/1/2018"),
            new DynamicDataChartData("4/1/2018", "Q2-2018", "4/1/2018"),
            new DynamicDataChartData("5/1/2018", "Q2-2018", "5/1/2018"),
            new DynamicDataChartData("6/1/2018", "Q2-2018", "6/1/2018"),
            new DynamicDataChartData("7/1/2018", "Q3-2018", "7/1/2018"),
            new DynamicDataChartData("8/1/2018", "Q3-2018", "8/1/2018"),
            new DynamicDataChartData("9/1/2018", "Q3-2018", "9/1/2018"),
            new DynamicDataChartData("10/1/2018", "Q4-2018", "10/1/2018"),
            new DynamicDataChartData("11/1/2018", "Q4-2018", "11/1/2018"),
            new DynamicDataChartData("12/1/2018", "Q4-2018", "12/1/2018"),
            new DynamicDataChartData("1/1/2019", "Q1-2019", "1/1/2019"),
            new DynamicDataChartData("2/1/2019", "Q1-2019", "2/1/2019"),
            new DynamicDataChartData("3/1/2019", "Q1-2019", "3/1/2019"),
            new DynamicDataChartData("4/1/2019", "Q2-2019", "4/1/2019"),
            new DynamicDataChartData("5/1/2019", "Q2-2019", "5/1/2019"),
            new DynamicDataChartData("6/1/2019", "Q2-2019", "6/1/2019"),
            new DynamicDataChartData("7/1/2019", "Q3-2019", "7/1/2019"),
            new DynamicDataChartData("8/1/2019", "Q3-2019", "8/1/2019"),
            new DynamicDataChartData("9/1/2019", "Q3-2019", "9/1/2019"),
            new DynamicDataChartData("10/1/2019", "Q4-2019", "10/1/2019"),
            new DynamicDataChartData("11/1/2019", "Q4-2019", "11/1/2019"),
            new DynamicDataChartData("12/1/2019", "Q4-2019", "12/1/2019"),
            new DynamicDataChartData("1/1/2020", "Q1-2020", "1/1/2020"),
            new DynamicDataChartData("2/1/2020", "Q1-2020", "2/1/2020"),
            new DynamicDataChartData("3/1/2020", "Q1-2020", "3/1/2020"),
            new DynamicDataChartData("4/1/2020", "Q2-2020", "4/1/2020"),
            new DynamicDataChartData("5/1/2020", "Q2-2020", "5/1/2020"),
            new DynamicDataChartData("6/1/2020", "Q2-2020", "6/1/2020"),
            new DynamicDataChartData("7/1/2020", "Q3-2020", "7/1/2020"),
            new DynamicDataChartData("8/1/2020", "Q3-2020", "8/1/2020"),
            new DynamicDataChartData("9/1/2020", "Q3-2020", "9/1/2020"),
            new DynamicDataChartData("10/1/2020", "Q4-2020", "10/1/2020"),
            new DynamicDataChartData("11/1/2020", "Q4-2020", "11/1/2020"),
            new DynamicDataChartData("12/1/2020", "Q4-2020", "12/1/2020"),
        };
    }

}
