/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
package com.smartgwt.client.ai;


import com.smartgwt.client.event.*;
import com.smartgwt.client.core.*;
import com.smartgwt.client.types.*;
import com.smartgwt.client.data.*;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.data.events.*;
import com.smartgwt.client.browser.window.*;
import com.smartgwt.client.rpc.*;
import com.smartgwt.client.ai.*;
import com.smartgwt.client.callbacks.*;
import com.smartgwt.client.tools.*;
import com.smartgwt.client.bean.*;
import com.smartgwt.client.widgets.*;
import com.smartgwt.client.widgets.ai.*;
import com.smartgwt.client.widgets.events.*;
import com.smartgwt.client.widgets.form.*;
import com.smartgwt.client.widgets.form.validator.*;
import com.smartgwt.client.widgets.form.fields.*;
import com.smartgwt.client.widgets.tile.*;
import com.smartgwt.client.widgets.tile.events.*;
import com.smartgwt.client.widgets.grid.*;
import com.smartgwt.client.widgets.grid.events.*;
import com.smartgwt.client.widgets.chart.*;
import com.smartgwt.client.widgets.layout.*;
import com.smartgwt.client.widgets.layout.events.*;
import com.smartgwt.client.widgets.menu.*;
import com.smartgwt.client.widgets.tour.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.rte.*;
import com.smartgwt.client.widgets.rte.events.*;
import com.smartgwt.client.widgets.ace.*;
import com.smartgwt.client.widgets.ace.events.*;
import com.smartgwt.client.widgets.tab.*;
import com.smartgwt.client.widgets.toolbar.*;
import com.smartgwt.client.widgets.tree.*;
import com.smartgwt.client.widgets.tree.events.*;
import com.smartgwt.client.widgets.tableview.*;
import com.smartgwt.client.widgets.viewer.*;
import com.smartgwt.client.widgets.calendar.*;
import com.smartgwt.client.widgets.calendar.events.*;
import com.smartgwt.client.widgets.cube.*;
import com.smartgwt.client.widgets.notify.*;
import com.smartgwt.client.widgets.drawing.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gwt.event.shared.*;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.core.client.JavaScriptObject;

import com.smartgwt.client.util.*;
import com.smartgwt.client.util.events.*;
import com.smartgwt.client.util.workflow.*;
import com.smartgwt.client.util.workflow.Process; // required to override java.lang.Process
import com.smartgwt.client.util.tour.*;


/**
 * Represents a user-specified and user-modifiable request to AI in some context. For example, the user's request may be in
 * the context of AI-assisted filtering of a {@link com.smartgwt.client.widgets.grid.ListGrid}; in such a context, the
 * user's request is their description of which records they would like to see. <p> The user's request is combined with
 * other messages, data, and instructions provided by the framework to create {@link com.smartgwt.client.ai.AIRequest}s
 * that are sent to the AI engine for the purpose of fulfilling the user's request.
 */
@BeanFactory.FrameworkClass
public class UserAIRequest extends SingleSourceAIRequest {

    public static UserAIRequest getOrCreateRef(JavaScriptObject jsObj) {
        if (jsObj == null) return null;

        final RefDataClass existingObj = RefDataClass.getRef(jsObj);

        if (existingObj instanceof UserAIRequest) {
            existingObj.setJsObj(jsObj);
            return (UserAIRequest)existingObj;
        } else

        {
            return new UserAIRequest(jsObj);
        }
    }
        


    public UserAIRequest(){
        
    }

    public UserAIRequest(JavaScriptObject jsObj){
        
        setJavaScriptObject(jsObj);
    }



    // ********************* Properties / Attributes ***********************

    /**
     * Additional messages from the user. For example, the {@link com.smartgwt.client.ai.UserAIRequest#getPrompt prompt} may be
     * an image, and additional text from the user about their request can be added to this array.
     *
     * @param additionalMessages New additionalMessages value. Default value is null
     * @return {@link com.smartgwt.client.ai.UserAIRequest UserAIRequest} instance, for chaining setter calls
     */
    public UserAIRequest setAdditionalMessages(AIMessage... additionalMessages) {
        return (UserAIRequest)setAttribute("additionalMessages", additionalMessages);
    }

    /**
     * Additional messages from the user. For example, the {@link com.smartgwt.client.ai.UserAIRequest#getPrompt prompt} may be
     * an image, and additional text from the user about their request can be added to this array.
     *
     * @return Current additionalMessages value. Default value is null
     */
    public AIMessage[] getAdditionalMessages()  {
        return com.smartgwt.client.util.ConvertTo.arrayOfAIMessage(getAttributeAsJavaScriptObject("additionalMessages"));
    }
    

    /**
     * The data of the user's request. The type of data is specified by the {@link
     * com.smartgwt.client.ai.UserAIRequest#getPromptType promptType}.
     *
     * @param prompt New prompt value. Default value is null
     * @return {@link com.smartgwt.client.ai.UserAIRequest UserAIRequest} instance, for chaining setter calls
     */
    public UserAIRequest setPrompt(Object prompt) {
        return (UserAIRequest)setAttribute("prompt", prompt);
    }

    /**
     * The data of the user's request. The type of data is specified by the {@link
     * com.smartgwt.client.ai.UserAIRequest#getPromptType promptType}.
     *
     * @return Current prompt value. Default value is null
     */
    public Object getPrompt()  {
        return getAttributeAsObject("prompt");
    }
    

    /**
     * The type of data of the user-specified {@link com.smartgwt.client.ai.UserAIRequest#getPrompt prompt}.
     *
     * @param promptType New promptType value. Default value is "text"
     * @return {@link com.smartgwt.client.ai.UserAIRequest UserAIRequest} instance, for chaining setter calls
     */
    public UserAIRequest setPromptType(AIContentType promptType) {
        return (UserAIRequest)setAttribute("promptType", promptType == null ? null : promptType.getValue());
    }

    /**
     * The type of data of the user-specified {@link com.smartgwt.client.ai.UserAIRequest#getPrompt prompt}.
     *
     * @return Current promptType value. Default value is "text"
     */
    public AIContentType getPromptType()  {
        return EnumUtil.getEnum(AIContentType.values(), getAttribute("promptType"));
    }
    

    // ********************* Methods ***********************

    // ********************* Static Methods ***********************

    // ***********************************************************

}
