/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.event.logical.shared;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;

public class ValueChangeEvent<T>
extends GwtEvent<ValueChangeHandler<T>> {
    private static GwtEvent.Type<ValueChangeHandler<?>> TYPE;
    private final T value;

    public static <T> void fire(HasValueChangeHandlers<T> source, T value) {
        if (TYPE != null) {
            ValueChangeEvent<T> event = new ValueChangeEvent<T>(value);
            source.fireEvent(event);
        }
    }

    public static <T> void fireIfNotEqual(HasValueChangeHandlers<T> source, T oldValue, T newValue) {
        if (ValueChangeEvent.shouldFire(source, oldValue, newValue)) {
            ValueChangeEvent<T> event = new ValueChangeEvent<T>(newValue);
            source.fireEvent(event);
        }
    }

    public static GwtEvent.Type<ValueChangeHandler<?>> getType() {
        if (TYPE == null) {
            TYPE = new GwtEvent.Type();
        }
        return TYPE;
    }

    protected static <T> boolean shouldFire(HasValueChangeHandlers<T> source, T oldValue, T newValue) {
        return TYPE != null && oldValue != newValue && (oldValue == null || !oldValue.equals(newValue));
    }

    protected ValueChangeEvent(T value) {
        this.value = value;
    }

    @Override
    public final GwtEvent.Type<ValueChangeHandler<T>> getAssociatedType() {
        return TYPE;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public String toDebugString() {
        return super.toDebugString() + this.getValue();
    }

    @Override
    protected void dispatch(ValueChangeHandler<T> handler) {
        handler.onValueChange(this);
    }
}

