/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesBuilder;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.client.SafeHtmlTemplates;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Image;

public class ClippedImageImpl {
    protected static final SafeUri clearImage = UriUtils.fromTrustedString(GWT.getModuleBaseURL() + "clear.cache.gif");
    private static Template template;
    private static DraggableTemplate draggableTemplate;

    public void adjust(Element img, SafeUri url, int left, int top, int width, int height) {
        String style = "url(\"" + url.asString() + "\") no-repeat " + -left + "px " + -top + "px";
        img.getStyle().setProperty("background", style);
        img.getStyle().setPropertyPx("width", width);
        img.getStyle().setPropertyPx("height", height);
    }

    public Element createStructure(SafeUri url, int left, int top, int width, int height) {
        SpanElement tmp = Document.get().createSpanElement();
        tmp.setInnerSafeHtml(this.getSafeHtml(url, left, top, width, height));
        Element elem = tmp.getFirstChildElement();
        elem.setPropertyJSO("onload", ClippedImageImpl.createOnLoadHandlerFunction());
        return elem;
    }

    public static native JavaScriptObject createOnLoadHandlerFunction();

    public Element getImgElement(Image image) {
        return image.getElement();
    }

    public SafeHtml getSafeHtml(SafeUri url, int left, int top, int width, int height) {
        return this.getSafeHtml(url, left, top, width, height, false);
    }

    public SafeHtml getSafeHtml(SafeUri url, int left, int top, int width, int height, boolean isDraggable) {
        SafeStylesBuilder builder = new SafeStylesBuilder();
        builder.width(width, Style.Unit.PX).height(height, Style.Unit.PX).trustedNameAndValue("background", "url(" + url.asString() + ") no-repeat " + -left + "px " + -top + "px");
        if (!isDraggable) {
            return this.getTemplate().image(clearImage, SafeStylesUtils.fromTrustedString(builder.toSafeStyles().asString()));
        }
        return this.getDraggableTemplate().image(clearImage, SafeStylesUtils.fromTrustedString(builder.toSafeStyles().asString()));
    }

    private DraggableTemplate getDraggableTemplate() {
        if (draggableTemplate == null) {
            draggableTemplate = (DraggableTemplate)GWT.create(DraggableTemplate.class);
        }
        return draggableTemplate;
    }

    private Template getTemplate() {
        if (template == null) {
            template = (Template)GWT.create(Template.class);
        }
        return template;
    }

    static interface Template
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<img src='{0}' style='{1}' border='0'>")
        public SafeHtml image(SafeUri var1, SafeStyles var2);
    }

    static interface DraggableTemplate
    extends SafeHtmlTemplates {
        @SafeHtmlTemplates.Template(value="<img src='{0}' style='{1}' border='0' draggable='true'>")
        public SafeHtml image(SafeUri var1, SafeStyles var2);
    }
}

