package com.smartgwt.sample.showcase.client;

import com.google.gwt.user.client.Window.Location;

public class ShowcaseConfiguration  {

    private final int maxDetailsLength;
    private final boolean openForTesting;
    private final boolean disableFullScreen;

    private ShowcaseConfiguration() {
        String value;
        value = Location.getParameter("autotest");
        openForTesting = null != value ? value.equals("showcase") : false;

        value = Location.getParameter("autotest_report_limit");
        maxDetailsLength = null != value ? Integer.parseInt(value) : 0;

        value = Location.getParameter("disableFullscreenMode");
        disableFullScreen = value != null && !"0".equals(value) && 
                            !"false".equals(value.toLowerCase());
    }

    public boolean isOpenForTesting() {
        return openForTesting;
    }
    public int getMaximumDetailsLength() {
        return maxDetailsLength;
    }
    public boolean isFullScreenModeDisabled() {
        return disableFullScreen;
    }

    // singleton paradigm for ShowcaseConfiguration

    private static ShowcaseConfiguration singleton;

    public static ShowcaseConfiguration getSingleton() {
        if (singleton == null) {
            singleton = new ShowcaseConfiguration();
        }
        return singleton;
    }
}