
package com.smartgwt.client.docs;

/**
 * <h3>Server logging</h3>
 * <h3>Default logging</h3>
 *  <p>
 *  Smart GWT's server-side classes have extensive built-in diagnostics which are output via
 * the <a href='https://logging.apache.org/log4j/2.x/' target='_blank'>Apache Log4j 2 library</a>
 * (see below for
 *  other alternatives).
 *  <p>
 *  At startup, Smart GWT will automatically load the file <code>log4j2.isc.config.xml</code>
 *  from the classpath and use it to configure Log4j 2.  <code>log4j2.isc.config.xml</code> is in
 *  Log4j2's standard 
 * <a href='https://logging.apache.org/log4j/2.x/manual/configuration.html#XML'
 * target='_blank'>XML configuration format</a>,
 *  and sets default log threshold levels for various subsystems to produce output that is
 *  generally appropriate for both development and production systems.  Various Smart GWT
 *  documentation may encourage you to enable certain diagnostic logs using this file when
 *  troubleshooting specific problems.
 *  <p>
 * There's a <code>iscLog4jConfiguration</code> JVM argument, which if explicitly set will be used
 * instead 
 * of the default <code>log4j2.isc.config.xml</code> configuration file. It should point to an
 * alternative 
 *  configuration file using the same Log4j2's standard 
 * <a href='https://logging.apache.org/log4j/2.x/manual/configuration.html#XML'
 * target='_blank'>XML configuration format</a>:
 *  <pre>
 *  -DiscLog4jConfiguration=log4j2.custom.config.xml
 *  </pre>
 * Note if the <code>iscLog4jConfiguration</code> is present, but the configuration file could not
 * be 
 *  loaded, Smartclient will fallback to default <code>log4j2.isc.config.xml</code> configuration.
 *  <p>
 *  <h3>Server Logs tab (Smart GWT Developer Console)</h3>
 *  <p>
 * The Server Logs tab of the {@link com.smartgwt.client.docs.Debugging Smart GWT Developer
 * Console} provides the
 * ability to view the most recent 10000 log entries, and change log threshold levels dynamically 
 *  at runtime.
 *  <p>
 * Note that the features of the "Server Logs" tab will <b>only</b> be available if using Log4j 2 
 *  API with the default Log4j 2 implementation.
 *  <p>
 *  <h3>Configure custom log4j loggers</h3>
 *  <p>
 *  If Log4j2 is used and custom loggers are configured in <code>log4j2.isc.config.xml</code> 
 *  file, use <code>DataTools.getLoggerContext()</code> method to access them on server side, 
 *  like this:
 *  <pre>
 *  DataTools.getLoggerContext().getLogger(CustomClass.class.getName());
 *  </pre>
 *  <h3>Redirecting logging to Slf4j framework</h3>
 *  <p>
 * <i><b>Deprecated.</b> Slf4j is intended to be a generic API that you can log to, which can be
 * configured 
 * to talk to various logging frameworks. However, Log4j 2 now offers the same capability of
 * plugging in 
 * alternate logging frameworks, and the generic logging API is better than Slf4j, making Slf4j
 * support 
 *  obsolete and deprecated.</i>
 *  <p>
 *  Smart GWT server logging can alternatively use the Simple Logging Facade for Java (slf4j),
 *  which allows logs to be sent to a variety of different logging frameworks that support
 *  Slf4j.
 *  <p>
 *  To send all logging to slf4j, the <code>iscUseSlf4j</code> VM argument must be set to true
 *  on the command line, like this:
 *  <pre>
 *  -DiscUseSlf4j=true
 *  </pre>
 *  <h3>Legacy: using Sfl4j to continue to use Log4j 1.x</h3>
 *  <p>
 *  It is still possible to use Log4j 1.x via the Slf4j. And even when the Slf4j will not be 
 *  directly supported by the Smartclient there will be an option to redirect Log4j 2 API to 
 *  the Slf4j + Log4j 1.x combo by using the 
 * <a href='https://logging.apache.org/log4j/2.x/log4j-to-slf4j/index.html' target='_blank'>Log4j
 * 2.x to Slf4j binding</a>.
 *  <p>
 * Note that the only reason to do this is that you've got heavy logging customizations that
 * depend on Log4j 1.x, 
 * so you can't migrate to another logging system yet. However, if you use this setup, you should
 * plan migration 
 *  as soon as possible.
 *  <p>
 * <i>See our {@link com.smartgwt.client.docs.LoggingMigration Logging migration} recommendations
 * on how to move to Log4j 2.x.</i>
 *  <p>
 *  <h3>Third-party libraries depending on Slf4j</h3>
 *  <p>
 * Smartclient uses Quartz Scheduler 2.3.1 and also continues to support Hibernate 3, both of
 * which depend on 
 * Slf4j for their internal logging. So, we are shipping with the set of dependencies redirecting
 * Hibernate and 
 *  Quartz logging to the Log4j 2 using the 
 * <a href='https://logging.apache.org/log4j/2.x/log4j-slf4j-impl/index.html'
 * target='_blank'>Log4j 2.x Slf4j binding</a> 
 * approach, so that the internal logging goes: <i>Hibernate -&gt; Slf4j -&gt; Slf4j to Log4j 2.x
 * binding -&gt; Log4j 2.x</i>.
 *  <p>
 *  <h3>Special logging category: com.isomorphic.SLOW_SQL</h3>
 *  <p>
 *  Used to log slow SQL queries. SQL query is considered "slow" if its execution time exceeds 
 *  configured threshold, see the global <i>sql.log.queriesSlowerThan</i> 
 * {@link com.smartgwt.client.docs.SqlSettings server.properties SQL setting} and more specific
 * {@link com.smartgwt.client.docs.serverds.DataSource#logSlowSQL DataSource.logSlowSQL} 
 *  setting for more details.
 *  <p>
 *  Set category logging level to "DEBUG" to log all slow queries:
 *  <pre>
 *  &lt;Logger name="com.isomorphic.SLOW_SQL" level="DEBUG" /&gt;
 *  </pre>
 * or enable logging for specific {@link com.smartgwt.client.types.DSOperationType operation
 * types}:
 *  <pre>
 *  &lt;Logger name="com.isomorphic.SLOW_SQL.fetch" level="DEBUG" /&gt;
 *  &lt;Logger name="com.isomorphic.SLOW_SQL.add" level="DEBUG" /&gt;
 *  &lt;Logger name="com.isomorphic.SLOW_SQL.update" level="DEBUG" /&gt;
 *  &lt;Logger name="com.isomorphic.SLOW_SQL.remove" level="DEBUG" /&gt;
 *  &lt;Logger name="com.isomorphic.SLOW_SQL.custom" level="DEBUG" /&gt;
 *  </pre>
 *  <h3>Special logging category: com.isomorphic.SQL</h3>
 *  <p>
 * Used to log all SQL queries even if other <code>com.isomorphic.sql.*</code> loggers are
 * disabled. Set category logging
 *  level to "INFO" to log all queries or to "DEBUG" to get additional details. For example:
 *  <pre>
 *  &lt;Logger name="com.isomorphic.SQL" level="INFO" /&gt;
 *  </pre>
 *  <h3>Special logging category: com.isomorphic.SQL_ERROR</h3>
 *  <p>
 * This category is used to log SQL errors, including the full SQL statement that caused the
 * error, regardless of other
 *  logging settings. It must be set to "DEBUG":
 *  <pre>
 *  &lt;Logger name="com.isomorphic.SQL_ERROR" level="DEBUG" /&gt;
 *  </pre>
 */
public interface ServerLogging {
}
