package com.smartgwt.client.types;


/*
 * Smart GWT (GWT for SmartClient)
 * Copyright 2008 and beyond, Isomorphic Software, Inc.
 *
 * Smart GWT is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.  Smart GWT is also
 * available under typical commercial license terms - see
 * http://smartclient.com/license
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */
/* sgwtgen */
 
/**
 * Indicates the strategy to be used for  {@link com.smartgwt.client.docs.CacheSynchronization automatic cache
 * synchronization}, for a given {@link com.smartgwt.client.data.DataSource#getCacheSyncStrategy DataSource},  {@link
 * com.smartgwt.client.data.OperationBinding#getCacheSyncStrategy OperationBinding} or  {@link
 * com.smartgwt.client.data.DSRequest#getCacheSyncStrategy DSRequest}. <P>
 */
public enum CacheSyncStrategy implements ValueEnum {
    /**
     * Obtain cache sync values by refetching the record we just updated or added. If the  DataSource contains {@link
     * com.smartgwt.client.data.DataSource#getPrimaryKeyFields primary key fields} of type <code>sequence</code>, the framework
     * will first attempt to obtain values for those  fields - see {@link com.smartgwt.client.types.SequenceMode sequenceMode}.
     * <p> This is the most complete and foolproof way to get cache sync data, because we pick up any  changes to the record
     * that were applied by the persistence layer - for example database  default values, values applied by database triggers
     * or transformations applied to the  record we sent by a remote REST service or legacy program call. However, it is also
     * the least performant, since it involves a full refetch of the data. This is the default strategy for {@link
     * com.smartgwt.client.docs.SqlDataSource SQL DataSources} and  {@link com.smartgwt.client.docs.WriteCustomDataSource
     * custom DataSources}. It is also the strategy used for  {@link com.smartgwt.client.docs.HibernateIntegration Hibernate}
     * and {@link com.smartgwt.client.docs.JpaIntegration JPA} DataSources,  though for these two, it is implemented inherently
     * by the ORM system and you should not  attempt to change it. See the {@link com.smartgwt.client.docs.CacheSynchronization
     * cache synchronization overview}  for details
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "refetch".
     */
    REFETCH("refetch"),
    /**
     * Obtain cache sync values by merging the request values on top of the request's  {@link
     * com.smartgwt.client.data.DSRequest#getOldValues oldValues}. If the DataSource contains  {@link
     * com.smartgwt.client.data.DataSource#getPrimaryKeyFields primary key fields} of type <code>sequence</code>, the framework
     * will then attempt to obtain values for those fields - see  {@link com.smartgwt.client.types.SequenceMode sequenceMode} -
     * and merge those values into the cache sync data as well. This strategy avoids a data refetch, which may be a significant
     * performance gain  (though please see the note in the <code>sequenceMode</code> documentation regarding Oracle as a
     * special case in this regard). Despite the name, this strategy is also suitable and effective for situations where your
     * keys are not sequences - for example, when they are GUIDs or when they are user-entered codes. In this case, we simply
     * do not attempt to resolve sequence values, and since the  key values are already included in the request values,
     * everything works <p> Note, if no <code>oldValues</code> are available and the updated record is  {@link
     * com.smartgwt.client.docs.serverds.DataSource#sparseUpdates incomplete}, or if the combination of <code>oldValues</code> 
     * and values is missing a value for a {@link com.smartgwt.client.data.DataSourceField#getRequired required field} for any 
     * other reason, this strategy will return incomplete cache sync data. For details of what we do in these circumstances,
     * see the "CacheSyncStrategy" section of the  {@link com.smartgwt.client.docs.CacheSynchronization cache synchronization
     * overview}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "requestValuesPlusSequences".
     */
    REQUESTVALUESPLUSSEQUENCES("requestValuesPlusSequences"),
    /**
     * This strategy simply returns the data returned by the add or update operation, as the cache  sync data. This only makes
     * sense for <code>DataSource</code> types that return a value for an update operation. This may include generic
     * DataSources  and <code>RestConnector</code>s, depending entirely on what the implementation returns. It specifically
     * does not include  {@link com.smartgwt.client.docs.SqlDataSource SQL DataSources}, because SQL/JDBC update operations do
     * not return a value (other than the number of affected records).  <p> This is the default strategy for {@link
     * com.smartgwt.client.docs.ServerRestConnector RestConnector}s, because it was the default way we did cache sync for that
     * DataSource type before  <code>CacheSyncStrategy</code> was introduced (and also because it is the ideal strategy  for
     * REST services that return the record-as-updated). See {@link com.smartgwt.client.data.DataSource#getCacheSyncStrategy
     * DataSource.cacheSyncStrategy} for details of how to change the default strategy for a given dataSource type.
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "responseValues".
     */
    RESPONSEVALUES("responseValues"),
    /**
     * This strategy does not attempt to derive cache sync data at all. No response data is sent  back to the caller, and the
     * response is marked for  {@link com.smartgwt.client.data.DSResponse#getInvalidateCache cache invalidation}
     * <P>
     * If this enumerated value is used in a {@link com.smartgwt.client.docs.ComponentXML Component XML}
     * file or server-side DataSource descriptor (.ds.xml file), use the value "none".
     */
    NONE("none");
    private String value;

    CacheSyncStrategy(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}
