/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.openapi;

import com.isomorphic.base.Config;
import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.util.LocaleMessage;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.text.WordUtils;

public class ContextUtils {
    protected static String createUniqueIdentifier(DataSource ds, Map binding) {
        String name = WordUtils.uncapitalize((String)ds.getID());
        Object id = (String)binding.get("operationId");
        String op = (String)binding.get("operationType");
        if (id == null) {
            id = "default" + WordUtils.capitalize((String)op);
        }
        return name + "_" + (String)id;
    }

    protected static String getExclusionAttribute() {
        return Config.getGlobal().getString("openapi.filter", "apidoc");
    }

    protected static boolean isAllowMultiUpdate(DataSource ds, Map<String, Object> bindingConfig) {
        String dsMultiUpdatePolicy = ds.getConfig().getString("defaultMultiUpdatePolicy");
        String defaultMultiUpdatePolicy = Config.getGlobal().getString(" datasources.defaultMultiUpdatePolicy");
        String multiUpdatePolicy = dsMultiUpdatePolicy != null ? dsMultiUpdatePolicy : defaultMultiUpdatePolicy;
        Boolean allowMultiUpdatesByDefault = "never".equalsIgnoreCase(multiUpdatePolicy);
        if (bindingConfig == null) {
            return allowMultiUpdatesByDefault;
        }
        String allowMultiUpdateString = String.valueOf(bindingConfig.get("allowMultiUpdate"));
        Boolean allowMultiUpdatesExplicitly = !"null".equals(allowMultiUpdateString) && Boolean.valueOf(allowMultiUpdateString) != false;
        return allowMultiUpdatesExplicitly != false || allowMultiUpdatesByDefault != false && allowMultiUpdatesExplicitly == false;
    }

    protected static boolean isViewRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("viewRequires") || config.containsKey("viewRequiresRole") || config.containsKey("viewRequiresAuthentication");
    }

    protected static boolean isAddRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("editRequires") || config.containsKey("editRequiresRole") || config.containsKey("editRequiresAuthentication") || config.containsKey("initRequires") || config.containsKey("initRequiresRole") || config.containsKey("initRequiresAuthentication");
    }

    protected static boolean isUpdateRestricted(DataTypeMap<String, Object> config) {
        return config.containsKey("editRequires") || config.containsKey("editRequiresRole") || config.containsKey("editRequiresAuthentication") || config.containsKey("updateRequires") || config.containsKey("updateRequiresRole") || config.containsKey("updateRequiresAuthentication");
    }

    protected static boolean includeDataSource(DataSource ds) {
        if (ds == null) {
            return false;
        }
        if (ds.getType().equals("component")) {
            return false;
        }
        if (ds.isServerOnly()) {
            return false;
        }
        String requiresExpression = ds.getConfig().getString("requires");
        if ("false".equalsIgnoreCase(requiresExpression)) {
            return false;
        }
        if (ds.getFields() == null || ds.getFields().isEmpty()) {
            return false;
        }
        String attr = ContextUtils.getExclusionAttribute();
        boolean include = ds.getConfig().getBoolean((Object)attr, true);
        return include;
    }

    protected static boolean includeOperationBinding(DataSource ds, Map<String, Object> bindingConfig) {
        String requiresExpression;
        String operationType = (String)bindingConfig.get("operationType");
        if (DataSource.isUpdate(operationType) || DataSource.isRemove(operationType)) {
            if (ds.getFields().size() <= ds.getPrimaryKeys().size()) {
                return false;
            }
            if ((ds.getPrimaryKeys() == null || ds.getPrimaryKeys().isEmpty()) && !ContextUtils.isAllowMultiUpdate(ds, bindingConfig)) {
                return false;
            }
        }
        if ("false".equalsIgnoreCase(requiresExpression = (String)bindingConfig.get("requires"))) {
            return false;
        }
        String attr = ContextUtils.getExclusionAttribute();
        return bindingConfig.get(attr) == null || Boolean.valueOf(attr) != false;
    }

    protected static String localizeConfigProperty(Object objectProperty, Locale locale) {
        String result = null;
        if (objectProperty instanceof LocaleMessage) {
            result = ((LocaleMessage)objectProperty).getMessage(locale);
        } else if (objectProperty != null) {
            result = String.valueOf(objectProperty);
        }
        return result;
    }

    protected static String[] localizeDescription(Object objectProperty, Locale locale) {
        String description = ContextUtils.localizeConfigProperty(objectProperty, locale);
        if (description != null) {
            return description.split("\\r?\\n");
        }
        return null;
    }
}

