/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinTable;
import java.util.Locale;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Property;

public class AnyBinder {
    static void bindAny(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, XProperty property, AnnotatedJoinColumns joinColumns, boolean forcePersist) {
        if (property.isAnnotationPresent(Columns.class)) {
            throw new AnnotationException(String.format(Locale.ROOT, "Property '%s' is annotated '@Any' and may not have a '@Columns' annotation (a single '@Column' or '@Formula' must be used to map the discriminator, and '@JoinColumn's must be used to map the foreign key) ", BinderHelper.getPath(propertyHolder, inferredData)));
        }
        Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
        OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        if (assocTable != null) {
            Join join = propertyHolder.addJoin(assocTable, false);
            for (AnnotatedJoinColumn joinColumn : joinColumns.getJoinColumns()) {
                joinColumn.setExplicitTableName(join.getTable().getName());
            }
        }
        AnyBinder.bindAny(BinderHelper.getCascadeStrategy(null, hibernateCascade, false, forcePersist), joinColumns, onDeleteAnn == null ? null : onDeleteAnn.action(), nullability, propertyHolder, inferredData, entityBinder, isIdentifierMapper, context);
    }

    private static void bindAny(String cascadeStrategy, AnnotatedJoinColumns columns, OnDeleteAction onDeleteAction, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context) {
        XProperty property = inferredData.getProperty();
        Any any = (Any)property.getAnnotation(Any.class);
        if (any == null) {
            throw new AssertionFailure("Missing @Any annotation: " + BinderHelper.getPath(propertyHolder, inferredData));
        }
        boolean lazy = any.fetch() == FetchType.LAZY;
        boolean optional = any.optional();
        org.hibernate.mapping.Any value = BinderHelper.buildAnyValue((Column)property.getAnnotation(Column.class), BinderHelper.getOverridableAnnotation((XAnnotatedElement)property, Formula.class, context), columns, inferredData, onDeleteAction, lazy, nullability, propertyHolder, entityBinder, optional, context);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(value);
        binder.setLazy(lazy);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        binder.setBuildingContext(context);
        binder.setHolder(propertyHolder);
        binder.setProperty(property);
        binder.setEntityBinder(entityBinder);
        Property prop = binder.makeProperty();
        prop.setOptional(optional && value.isNullable());
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }
}

