/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.log.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class BlobUserType
implements UserType {
    private static Logger log = new Logger(BlobUserType.class.getName());

    public Class<InputStream> returnedClass() {
        return InputStream.class;
    }

    public int getSqlType() {
        return 2004;
    }

    public Object nullSafeGet(ResultSet resultset, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        Blob blob = resultset.getBlob(position);
        if (blob != null) {
            try {
                return blob.getBinaryStream();
            }
            catch (SQLException e) {
                throw new HibernateException("Failed to get InputStream from Blob for field in custom UserType", (Throwable)e);
            }
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 2004);
        } else {
            byte[] bytes = (byte[])value;
            preparedStatement.setBytes(index, bytes);
        }
    }

    public boolean isMutable() {
        return false;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return ObjectUtils.equals((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }
}

