/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentList;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ListInitializer
extends AbstractImmediateCollectionInitializer {
    private static final String CONCRETE_NAME = ListInitializer.class.getSimpleName();
    private final DomainResultAssembler<Integer> listIndexAssembler;
    private final DomainResultAssembler<?> elementAssembler;
    private final int listIndexBase;

    public ListInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, Fetch listIndexFetch, Fetch elementFetch, boolean isResultInitializer, AssemblerCreationState creationState) {
        super(navigablePath, attributeMapping, parentAccess, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.listIndexAssembler = listIndexFetch.createAssembler(this, creationState);
        this.elementAssembler = elementFetch.createAssembler(this, creationState);
        this.listIndexBase = attributeMapping.getIndexMetadata().getListIndexBase();
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachAssembler(Consumer<DomainResultAssembler<?>> consumer) {
        consumer.accept(this.listIndexAssembler);
        consumer.accept(this.elementAssembler);
    }

    public @Nullable PersistentList<?> getCollectionInstance() {
        return (PersistentList)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(CollectionKey collectionKey, List<Object> loadingState, RowProcessingState rowProcessingState) {
        Integer indexValue = this.listIndexAssembler.assemble(rowProcessingState);
        if (indexValue == null) {
            throw new HibernateException("Illegal null value for list index encountered while reading: " + this.getCollectionAttributeMapping().getNavigableRole());
        }
        Object element = this.elementAssembler.assemble(rowProcessingState);
        if (element == null) {
            return;
        }
        int index = indexValue;
        if (this.listIndexBase != 0) {
            index -= this.listIndexBase;
        }
        for (int i = loadingState.size(); i <= index; ++i) {
            loadingState.add(i, null);
        }
        loadingState.set(index, element);
    }

    @Override
    protected void initializeSubInstancesFromParent(RowProcessingState rowProcessingState) {
        Initializer initializer = this.elementAssembler.getInitializer();
        if (initializer != null) {
            PersistentCollection list = this.getCollectionInstance();
            assert (list != null);
            Iterator iterator = ((PersistentList)list).iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                initializer.initializeInstanceFromParent(element, rowProcessingState);
            }
        }
    }

    public String toString() {
        return "ListInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

